/* chess-view-3d.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-view-3d.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "GL/glx.h"
#include "GL/gl.h"
#include <gdk/gdk.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo.h>
#include "GL/glu.h"
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;
typedef struct _ChessView3DPrivate ChessView3DPrivate;

#define TYPE_TDS_MODEL (tds_model_get_type ())
#define TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TDS_MODEL, TDSModel))
#define TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TDS_MODEL, TDSModelClass))
#define IS_TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TDS_MODEL))
#define IS_TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TDS_MODEL))
#define TDS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TDS_MODEL, TDSModelClass))

typedef struct _TDSModel TDSModel;
typedef struct _TDSModelClass TDSModelClass;
#define _tds_model_unref0(var) ((var == NULL) ? NULL : (var = (tds_model_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _XFree0(var) ((var == NULL) ? NULL : (var = (XFree (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView3D {
	ChessView parent_instance;
	ChessView3DPrivate * priv;
};

struct _ChessView3DClass {
	ChessViewClass parent_class;
};

struct _ChessView3DPrivate {
	GLXContext context;
	void* display;
	GLXDrawable drawable;
	gint border;
	gint square_size;
	TDSModel* pawn_model;
	TDSModel* knight_model;
	TDSModel* bishop_model;
	TDSModel* rook_model;
	TDSModel* queen_model;
	TDSModel* king_model;
	GLfloat* board_vertices;
	gint board_vertices_length1;
	gint _board_vertices_size_;
	GLfloat* board_normals;
	gint board_normals_length1;
	gint _board_normals_size_;
	GLushort* board_quads;
	gint board_quads_length1;
	gint _board_quads_size_;
	GLfloat SQUARE_WIDTH;
	GLfloat BOARD_DEPTH;
	GLfloat BOARD_BORDER;
	GLfloat BOARD_CHAMFER;
	GLfloat BOARD_INNER_WIDTH;
	GLfloat BOARD_OUTER_WIDTH;
	GLfloat OFFSET;
	GLfloat white_piece_color[4];
	GLfloat white_piece_specular[4];
	GLfloat black_piece_color[4];
	GLfloat black_piece_specular[4];
	GLuint _board_texture;
	GLuint _numbering_texture;
	GLuint _piece_texture;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_view3_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view3_d_get_type (void) G_GNUC_CONST;
gpointer tds_model_ref (gpointer instance);
void tds_model_unref (gpointer instance);
GParamSpec* param_spec_tds_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tds_model (GValue* value, gpointer v_object);
void value_take_tds_model (GValue* value, gpointer v_object);
gpointer value_get_tds_model (const GValue* value);
GType tds_model_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW3_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW3_D, ChessView3DPrivate))
enum  {
	CHESS_VIEW3_D_DUMMY_PROPERTY
};
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
ChessView* chess_view_construct (GType object_type);
static void chess_view3_d_realize_cb (ChessView3D* self);
static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void chess_view3_d_unrealize_cb (ChessView3D* self);
static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self);
TDSModel* tds_model_new (GFile* file, GError** error);
TDSModel* tds_model_construct (GType object_type, GFile* file, GError** error);
static void chess_view3_d_create_board (ChessView3D* self);
static gboolean chess_view3_d_start_gl (ChessView3D* self);
static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2);
static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
gboolean chess_game_get_is_superpaused (ChessGame* self);
void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
static void chess_view3_d_transform_camera (ChessView3D* self);
gdouble chess_scene_get_board_angle (ChessScene* self);
static void chess_view3_d_draw_board (ChessView3D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
static void chess_view3_d_draw_numbering (ChessView3D* self);
static void chess_view3_d_draw_pieces (ChessView3D* self);
static GLuint chess_view3_d_get_board_texture (ChessView3D* self);
static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell);
static GLuint chess_view3_d_get_piece_texture (ChessView3D* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
void tds_model_render (TDSModel* self);
static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename);
static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text);
static void chess_view3_d_finalize (GObject* obj);
static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_realize_cb (self);
#line 348 "chess-view-3d.c"
}


static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self) {
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_unrealize_cb (self);
#line 355 "chess-view-3d.c"
}


ChessView3D* chess_view3_d_construct (GType object_type) {
	ChessView3D * self = NULL;
	GLfloat _tmp0_ = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	GLfloat _tmp3_ = 0.0F;
	GLfloat _tmp4_[4] = {0};
	GLfloat _tmp5_[4] = {0};
	GLfloat _tmp6_[4] = {0};
	GLfloat _tmp7_[4] = {0};
	GError * _inner_error_ = NULL;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self = (ChessView3D*) chess_view_construct (object_type);
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->SQUARE_WIDTH = (GLfloat) 10.0f;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->BOARD_DEPTH = (GLfloat) 3.0f;
#line 68 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->BOARD_BORDER = (GLfloat) 5.0f;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->BOARD_CHAMFER = (GLfloat) 2.0f;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->SQUARE_WIDTH;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->BOARD_INNER_WIDTH = _tmp0_ * 8.0f;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = self->priv->BOARD_INNER_WIDTH;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->BOARD_BORDER;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->BOARD_OUTER_WIDTH = _tmp1_ + (_tmp2_ * 2.0f);
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = self->priv->BOARD_OUTER_WIDTH;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->OFFSET = _tmp3_ * 0.5f;
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _chess_view3_d_realize_cb_gtk_widget_realize, self, 0);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_signal_connect_object ((GtkWidget*) self, "unrealize", (GCallback) _chess_view3_d_unrealize_cb_gtk_widget_unrealize, self, 0);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_[0] = (GLfloat) (0.95f * 0.7f);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_[1] = (GLfloat) (0.81f * 0.7f);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_[2] = (GLfloat) (0.64f * 0.7f);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_[3] = (GLfloat) 1.0f;
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	memcpy (self->priv->white_piece_color, _tmp4_, 4 * sizeof (GLfloat));
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_[0] = (GLfloat) 0.95f;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_[1] = (GLfloat) 0.81f;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_[2] = (GLfloat) 0.64f;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_[3] = (GLfloat) 1.0f;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	memcpy (self->priv->white_piece_specular, _tmp5_, 4 * sizeof (GLfloat));
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_[0] = (GLfloat) (0.62f * 0.7f);
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_[1] = (GLfloat) (0.45f * 0.7f);
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_[2] = (GLfloat) (0.28f * 0.7f);
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_[3] = (GLfloat) 1.0f;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	memcpy (self->priv->black_piece_color, _tmp6_, 4 * sizeof (GLfloat));
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_[0] = (GLfloat) 0.62f;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_[1] = (GLfloat) 0.45f;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_[2] = (GLfloat) 0.28f;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_[3] = (GLfloat) 1.0f;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	memcpy (self->priv->black_piece_specular, _tmp7_, 4 * sizeof (GLfloat));
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gtk_widget_set_double_buffered ((GtkWidget*) self, FALSE);
#line 442 "chess-view-3d.c"
	{
		TDSModel* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		TDSModel* _tmp13_ = NULL;
		TDSModel* _tmp14_ = NULL;
		TDSModel* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		TDSModel* _tmp20_ = NULL;
		TDSModel* _tmp21_ = NULL;
		TDSModel* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GFile* _tmp25_ = NULL;
		GFile* _tmp26_ = NULL;
		TDSModel* _tmp27_ = NULL;
		TDSModel* _tmp28_ = NULL;
		TDSModel* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GFile* _tmp32_ = NULL;
		GFile* _tmp33_ = NULL;
		TDSModel* _tmp34_ = NULL;
		TDSModel* _tmp35_ = NULL;
		TDSModel* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GFile* _tmp39_ = NULL;
		GFile* _tmp40_ = NULL;
		TDSModel* _tmp41_ = NULL;
		TDSModel* _tmp42_ = NULL;
		TDSModel* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		GFile* _tmp46_ = NULL;
		GFile* _tmp47_ = NULL;
		TDSModel* _tmp48_ = NULL;
		TDSModel* _tmp49_ = NULL;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp9_ = g_build_filename (PKGDATADIR, "pieces", "3d", "pawn.3ds", NULL, NULL);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp10_ = _tmp9_;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp11_ = g_file_new_for_path (_tmp10_);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp12_ = _tmp11_;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp13_ = tds_model_new (_tmp12_, &_inner_error_);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp14_ = _tmp13_;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp12_);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp10_);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp8_ = _tmp14_;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 506 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->pawn_model);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->pawn_model = _tmp8_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp16_ = g_build_filename (PKGDATADIR, "pieces", "3d", "knight.3ds", NULL, NULL);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp17_ = _tmp16_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp18_ = g_file_new_for_path (_tmp17_);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp19_ = _tmp18_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp20_ = tds_model_new (_tmp19_, &_inner_error_);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp21_ = _tmp20_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp19_);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp17_);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp15_ = _tmp21_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 533 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->knight_model);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->knight_model = _tmp15_;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp23_ = g_build_filename (PKGDATADIR, "pieces", "3d", "bishop.3ds", NULL, NULL);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp24_ = _tmp23_;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp25_ = g_file_new_for_path (_tmp24_);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp26_ = _tmp25_;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp27_ = tds_model_new (_tmp26_, &_inner_error_);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp28_ = _tmp27_;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp26_);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp24_);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp22_ = _tmp28_;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 560 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->bishop_model);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->bishop_model = _tmp22_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp30_ = g_build_filename (PKGDATADIR, "pieces", "3d", "rook.3ds", NULL, NULL);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp31_ = _tmp30_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp32_ = g_file_new_for_path (_tmp31_);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp33_ = _tmp32_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp34_ = tds_model_new (_tmp33_, &_inner_error_);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp35_ = _tmp34_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp33_);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp31_);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp29_ = _tmp35_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 587 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->rook_model);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->rook_model = _tmp29_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp37_ = g_build_filename (PKGDATADIR, "pieces", "3d", "queen.3ds", NULL, NULL);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp38_ = _tmp37_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp39_ = g_file_new_for_path (_tmp38_);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp40_ = _tmp39_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp41_ = tds_model_new (_tmp40_, &_inner_error_);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp42_ = _tmp41_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp40_);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp38_);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp36_ = _tmp42_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 614 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->queen_model);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->queen_model = _tmp36_;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp44_ = g_build_filename (PKGDATADIR, "pieces", "3d", "king.3ds", NULL, NULL);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp45_ = _tmp44_;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp46_ = g_file_new_for_path (_tmp45_);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp47_ = _tmp46_;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp48_ = tds_model_new (_tmp47_, &_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp49_ = _tmp48_;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (_tmp47_);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp45_);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp43_ = _tmp49_;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 641 "chess-view-3d.c"
			goto __catch18_g_error;
		}
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tds_model_unref0 (self->priv->king_model);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->king_model = _tmp43_;
#line 648 "chess-view-3d.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		e = _inner_error_;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_inner_error_ = NULL;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp50_ = e;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp51_ = _tmp50_->message;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_warning ("chess-view-3d.vala:95: failed to load 3ds: %s", _tmp51_);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_error_free0 (e);
#line 668 "chess-view-3d.c"
	}
	__finally18:
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_inner_error_ != NULL) {
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_clear_error (&_inner_error_);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return NULL;
#line 679 "chess-view-3d.c"
	}
#line 97 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_create_board (self);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return self;
#line 685 "chess-view-3d.c"
}


ChessView3D* chess_view3_d_new (void) {
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return chess_view3_d_construct (TYPE_CHESS_VIEW3_D);
#line 692 "chess-view-3d.c"
}


static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2) {
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (s1 == s2) {
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return TRUE;
#line 701 "chess-view-3d.c"
	}
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (s1 == NULL) {
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return FALSE;
#line 707 "chess-view-3d.c"
	}
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (s2 == NULL) {
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return FALSE;
#line 713 "chess-view-3d.c"
	}
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return (*s1) == (*s2);
#line 717 "chess-view-3d.c"
}


static gboolean chess_view3_d_start_gl (ChessView3D* self) {
	gboolean result = FALSE;
	GLXContext null_context = {0};
	GLXContext _tmp0_ = {0};
	GLXContext _tmp1_ = {0};
	void* _tmp2_ = NULL;
	GLXDrawable _tmp3_ = {0};
	GLXContext _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	null_context = (GLXContext) NULL;
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->context;
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = null_context;
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_context_equal (&_tmp0_, &_tmp1_) == TRUE) {
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = FALSE;
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 744 "chess-view-3d.c"
	}
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->display;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = self->priv->drawable;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->context;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = glXMakeCurrent (_tmp2_, _tmp3_, _tmp4_);
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = _tmp5_;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 758 "chess-view-3d.c"
}


static void chess_view3_d_create_board (ChessView3D* self) {
	gfloat a = 0.0F;
	GLfloat b = 0.0F;
	GLfloat _tmp0_ = 0.0F;
	GLfloat c = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	GLfloat d = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	GLfloat e = 0.0F;
	GLfloat _tmp3_ = 0.0F;
	GLfloat _tmp4_ = 0.0F;
	GLfloat f = 0.0F;
	GLfloat _tmp5_ = 0.0F;
	gfloat l = 0.0F;
	GLfloat k = 0.0F;
	GLfloat _tmp6_ = 0.0F;
	GLfloat j = 0.0F;
	GLfloat _tmp7_ = 0.0F;
	GLfloat i = 0.0F;
	GLfloat _tmp8_ = 0.0F;
	GLfloat h = 0.0F;
	GLfloat _tmp9_ = 0.0F;
	GLfloat _tmp10_ = 0.0F;
	GLfloat g = 0.0F;
	GLfloat _tmp11_ = 0.0F;
	GLfloat _tmp12_ = 0.0F;
	GLfloat _tmp13_ = 0.0F;
	GLfloat _tmp14_ = 0.0F;
	GLfloat _tmp15_ = 0.0F;
	GLfloat _tmp16_ = 0.0F;
	GLfloat _tmp17_ = 0.0F;
	GLfloat _tmp18_ = 0.0F;
	GLfloat _tmp19_ = 0.0F;
	GLfloat* _tmp20_ = NULL;
	GLfloat* _tmp21_ = NULL;
	GLushort* _tmp22_ = NULL;
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	a = 0.0f;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->BOARD_CHAMFER;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	b = _tmp0_;
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = self->priv->BOARD_BORDER;
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	c = _tmp1_;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->SQUARE_WIDTH;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	d = c + (_tmp2_ * 8.0f);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = self->priv->BOARD_BORDER;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->BOARD_CHAMFER;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	e = (d + _tmp3_) - _tmp4_;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = self->priv->BOARD_BORDER;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	f = d + _tmp5_;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	l = 0.0f;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = self->priv->BOARD_CHAMFER;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	k = -_tmp6_;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = self->priv->BOARD_BORDER;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	j = -_tmp7_;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = self->priv->SQUARE_WIDTH;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	i = j - (_tmp8_ * 8.0f);
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = self->priv->BOARD_BORDER;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = self->priv->BOARD_CHAMFER;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	h = (i - _tmp9_) + _tmp10_;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = self->priv->BOARD_BORDER;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g = i - _tmp11_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = self->priv->BOARD_CHAMFER;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp13_ = self->priv->BOARD_CHAMFER;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp14_ = self->priv->BOARD_CHAMFER;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = self->priv->BOARD_CHAMFER;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = self->priv->BOARD_DEPTH;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = self->priv->BOARD_DEPTH;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = self->priv->BOARD_DEPTH;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = self->priv->BOARD_DEPTH;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_ = g_new0 (GLfloat, 48);
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[0] = c;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[1] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[2] = i;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[3] = d;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[4] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[5] = i;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[6] = d;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[7] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[8] = j;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[9] = c;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[10] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[11] = j;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[12] = b;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[13] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[14] = h;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[15] = e;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[16] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[17] = h;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[18] = e;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[19] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[20] = k;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[21] = b;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[22] = (GLfloat) 0.0f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[23] = k;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[24] = (GLfloat) a;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[25] = -_tmp12_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[26] = g;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[27] = f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[28] = -_tmp13_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[29] = g;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[30] = f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[31] = -_tmp14_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[32] = (GLfloat) l;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[33] = (GLfloat) a;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[34] = -_tmp15_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[35] = (GLfloat) l;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[36] = (GLfloat) a;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[37] = -_tmp16_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[38] = g;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[39] = f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[40] = -_tmp17_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[41] = g;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[42] = f;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[43] = -_tmp18_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[44] = (GLfloat) l;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[45] = (GLfloat) a;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[46] = -_tmp19_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_[47] = (GLfloat) l;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_vertices = _tmp20_;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_vertices_length1 = 48;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_board_vertices_size_ = self->priv->board_vertices_length1;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_ = g_new0 (GLfloat, 27);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[0] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[1] = (GLfloat) 1.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[2] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[3] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[4] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[5] = (GLfloat) (-1.0f);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[6] = (GLfloat) 1.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[7] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[8] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[9] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[10] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[11] = (GLfloat) 1.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[12] = (GLfloat) (-1.0f);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[13] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[14] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[15] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[16] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[17] = (GLfloat) (-0.707f);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[18] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[19] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[20] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[21] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[22] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[23] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[24] = (GLfloat) (-0.707f);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[25] = (GLfloat) 0.707f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_[26] = (GLfloat) 0.0f;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_normals = _tmp21_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_normals_length1 = 27;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_board_normals_size_ = self->priv->board_normals_length1;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_ = g_new0 (GLushort, 60);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[0] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[1] = (GLushort) 1;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[2] = (GLushort) 5;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[3] = (GLushort) 4;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[4] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[5] = (GLushort) 1;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[6] = (GLushort) 2;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[7] = (GLushort) 6;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[8] = (GLushort) 5;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[9] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[10] = (GLushort) 2;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[11] = (GLushort) 3;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[12] = (GLushort) 7;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[13] = (GLushort) 6;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[14] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[15] = (GLushort) 3;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[16] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[17] = (GLushort) 4;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[18] = (GLushort) 7;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[19] = (GLushort) 0;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[20] = (GLushort) 4;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[21] = (GLushort) 5;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[22] = (GLushort) 9;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[23] = (GLushort) 8;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[24] = (GLushort) 5;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[25] = (GLushort) 5;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[26] = (GLushort) 6;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[27] = (GLushort) 10;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[28] = (GLushort) 9;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[29] = (GLushort) 6;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[30] = (GLushort) 6;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[31] = (GLushort) 7;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[32] = (GLushort) 11;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[33] = (GLushort) 10;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[34] = (GLushort) 7;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[35] = (GLushort) 7;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[36] = (GLushort) 4;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[37] = (GLushort) 8;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[38] = (GLushort) 11;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[39] = (GLushort) 8;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[40] = (GLushort) 8;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[41] = (GLushort) 9;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[42] = (GLushort) 13;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[43] = (GLushort) 12;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[44] = (GLushort) 1;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[45] = (GLushort) 9;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[46] = (GLushort) 10;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[47] = (GLushort) 14;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[48] = (GLushort) 13;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[49] = (GLushort) 2;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[50] = (GLushort) 10;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[51] = (GLushort) 11;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[52] = (GLushort) 15;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[53] = (GLushort) 14;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[54] = (GLushort) 3;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[55] = (GLushort) 11;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[56] = (GLushort) 8;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[57] = (GLushort) 12;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[58] = (GLushort) 15;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_[59] = (GLushort) 4;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_quads = _tmp22_;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_quads_length1 = 60;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_board_quads_size_ = self->priv->board_quads_length1;
#line 1164 "chess-view-3d.c"
}


static void chess_view3_d_realize_cb (ChessView3D* self) {
	gint* attributes = NULL;
	gint* _tmp0_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	GdkWindow* _tmp1_ = NULL;
	Window _tmp2_ = 0;
	GdkWindow* _tmp3_ = NULL;
	GdkDisplay* _tmp4_ = NULL;
	Display* _tmp5_ = NULL;
	gint screen = 0;
	GdkScreen* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	XVisualInfo* visual = NULL;
	void* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	XVisualInfo* _tmp11_ = NULL;
	XVisualInfo* _tmp12_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = g_new0 (gint, 17);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[0] = GLX_RGBA;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[1] = GLX_RED_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[2] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[3] = GLX_GREEN_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[4] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[5] = GLX_BLUE_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[6] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[7] = GLX_DOUBLEBUFFER;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[8] = GLX_DEPTH_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[9] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[10] = GLX_ACCUM_RED_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[11] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[12] = GLX_ACCUM_GREEN_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[13] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[14] = GLX_ACCUM_BLUE_SIZE;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[15] = 1;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_[16] = 0;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	attributes = _tmp0_;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	attributes_length1 = 17;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_attributes_size_ = attributes_length1;
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = gdk_x11_window_get_xid (_tmp1_);
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->drawable = (GLXDrawable) _tmp2_;
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = gdk_window_get_display (_tmp3_);
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->display = _tmp5_;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = gtk_widget_get_screen ((GtkWidget*) self);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = gdk_x11_screen_get_screen_number (_tmp6_);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	screen = _tmp7_;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = self->priv->display;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = screen;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = attributes;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10__length1 = attributes_length1;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = glXChooseVisual (_tmp8_, _tmp9_, _tmp10_);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	visual = _tmp11_;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = visual;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp12_ == NULL) {
#line 1268 "chess-view-3d.c"
		void* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp13_ = self->priv->display;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp14_ = screen;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_warning ("chess-view-3d.vala:178: Failed to get GLX visual on display %p, screen" \
" %d", _tmp13_, _tmp14_);
#line 1277 "chess-view-3d.c"
	} else {
		void* _tmp15_ = NULL;
		XVisualInfo* _tmp16_ = NULL;
		GLXContext _tmp17_ = {0};
		GLXContext null_context = {0};
		GLXContext _tmp18_ = {0};
		GLXContext _tmp19_ = {0};
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp15_ = self->priv->display;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp16_ = visual;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp17_ = glXCreateContext (_tmp15_, _tmp16_, NULL, TRUE);
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->context = _tmp17_;
#line 182 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		null_context = (GLXContext) NULL;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp18_ = self->priv->context;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp19_ = null_context;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_context_equal (&_tmp18_, &_tmp19_) == TRUE) {
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			g_warning ("chess-view-3d.vala:184: Failed to create GLX context");
#line 1303 "chess-view-3d.c"
		}
	}
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_XFree0 (visual);
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	attributes = (g_free (attributes), NULL);
#line 1310 "chess-view-3d.c"
}


static void chess_view3_d_unrealize_cb (ChessView3D* self) {
	GLXContext null_context = {0};
	GLXContext _tmp0_ = {0};
	GLXContext _tmp1_ = {0};
	GLXDrawable _tmp2_ = {0};
	GLXDrawable _tmp3_ = {0};
	void* _tmp5_ = NULL;
	GLXContext _tmp6_ = {0};
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	null_context = (GLXContext) NULL;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->context;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = null_context;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_context_equal (&_tmp0_, &_tmp1_) == TRUE) {
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return;
#line 1334 "chess-view-3d.c"
	}
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->drawable;
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = glXGetCurrentDrawable ();
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp2_ == _tmp3_) {
#line 1342 "chess-view-3d.c"
		void* _tmp4_ = NULL;
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glXWaitGL ();
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp4_ = self->priv->display;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glXMakeCurrent (_tmp4_, (GLXDrawable) None, (GLXContext) NULL);
#line 1350 "chess-view-3d.c"
	}
#line 201 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = self->priv->display;
#line 201 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = self->priv->context;
#line 201 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glXDestroyContext (_tmp5_, _tmp6_);
#line 1358 "chess-view-3d.c"
}


static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gint short_edge = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
#line 204 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self = (ChessView3D*) base;
#line 204 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	short_edge = _tmp2_;
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = short_edge;
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->border;
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->square_size = (gint) _tmp5_;
#line 210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = chess_view3_d_start_gl (self);
#line 210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp6_) {
#line 1397 "chess-view-3d.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp7_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp8_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glViewport ((GLint) 0, (GLint) 0, (GLsizei) _tmp7_, (GLsizei) _tmp8_);
#line 1406 "chess-view-3d.c"
	}
#line 213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = TRUE;
#line 213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 1412 "chess-view-3d.c"
}


static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat xwsize = 0.0F;
	GLfloat _tmp0_ = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	GLfloat ywsize = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	GLfloat _tmp3_ = 0.0F;
	GLfloat dx = 0.0F;
	GLfloat _tmp4_ = 0.0F;
	gint _tmp5_ = 0;
	GLfloat _tmp6_ = 0.0F;
	GLfloat _tmp7_ = 0.0F;
	GLfloat _tmp8_ = 0.0F;
	GLfloat dy = 0.0F;
	GLfloat _tmp9_ = 0.0F;
	gint _tmp10_ = 0;
	GLfloat _tmp11_ = 0.0F;
	GLfloat _tmp12_ = 0.0F;
	GLfloat _tmp13_ = 0.0F;
	GLfloat _tmp14_ = 0.0F;
	GLfloat _tmp15_ = 0.0F;
	GLfloat _tmp16_ = 0.0F;
	GLfloat _tmp17_ = 0.0F;
	GLfloat _tmp18_ = 0.0F;
	GLfloat _tmp19_ = 0.0F;
	GLfloat _tmp20_ = 0.0F;
	GLfloat _tmp21_ = 0.0F;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = right;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = left;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	xwsize = _tmp0_ - _tmp1_;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = top;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = bottom;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	ywsize = _tmp2_ - _tmp3_;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = pixdx;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = eyedx;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = near;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = focus;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	dx = -(((_tmp4_ * xwsize) / _tmp5_) + ((_tmp6_ * _tmp7_) / _tmp8_));
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = pixdy;
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = eyedy;
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = near;
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp13_ = focus;
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	dy = -(((_tmp9_ * ywsize) / _tmp10_) + ((_tmp11_ * _tmp12_) / _tmp13_));
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp14_ = left;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = right;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = bottom;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = top;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = near;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = far;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glFrustum ((GLdouble) (_tmp14_ + dx), (GLdouble) (_tmp15_ + dx), (GLdouble) (_tmp16_ + dy), (GLdouble) (_tmp17_ + dy), (GLdouble) _tmp18_, (GLdouble) _tmp19_);
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_ = eyedx;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_ = eyedy;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTranslatef (-_tmp20_, -_tmp21_, (GLfloat) 0.0f);
#line 1501 "chess-view-3d.c"
}


static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat fov2 = 0.0F;
	GLfloat _tmp0_ = 0.0F;
	GLfloat top = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GLfloat bottom = 0.0F;
	GLfloat right = 0.0F;
	GLfloat _tmp4_ = 0.0F;
	GLfloat left = 0.0F;
	GLfloat _tmp5_ = 0.0F;
	GLfloat _tmp6_ = 0.0F;
	GLfloat _tmp7_ = 0.0F;
	GLfloat _tmp8_ = 0.0F;
	GLfloat _tmp9_ = 0.0F;
	GLfloat _tmp10_ = 0.0F;
	GLfloat _tmp11_ = 0.0F;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = fovy;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	fov2 = ((_tmp0_ * ((GLfloat) G_PI)) / 180.0f) / 2.0f;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = near;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = cos ((gdouble) fov2);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = sin ((gdouble) fov2);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	top = _tmp1_ / (((GLfloat) _tmp2_) / ((GLfloat) _tmp3_));
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	bottom = -top;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = aspect;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	right = top * _tmp4_;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	left = -right;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = near;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = far;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = pixdx;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = pixdy;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = eyedx;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = eyedy;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = focus;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_accFrustum (self, left, right, bottom, top, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 1561 "chess-view-3d.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return self ? g_object_ref (self) : NULL;
#line 1568 "chess-view-3d.c"
}


static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView3D * self;
	gboolean result = FALSE;
	ChessScene* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GLfloat* jitters = NULL;
	GLfloat* _tmp11_ = NULL;
	gint jitters_length1 = 0;
	gint _jitters_size_ = 0;
	gboolean _tmp12_ = FALSE;
	gint n_passes = 0;
	ChessScene* _tmp13_ = NULL;
	ChessScene* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ChessScene* _tmp66_ = NULL;
	ChessScene* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	void* _tmp70_ = NULL;
	GLXDrawable _tmp71_ = {0};
#line 241 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self = (ChessView3D*) base;
#line 241 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = chess_view_get_scene ((ChessView*) self);
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = _tmp0_;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = chess_scene_get_game (_tmp1_);
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = _tmp2_;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = chess_game_get_is_superpaused (_tmp3_);
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = _tmp4_;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp5_) {
#line 1615 "chess-view-3d.c"
		void* _tmp6_ = NULL;
		cairo_t* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp6_ = self->priv->display;
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glXMakeCurrent (_tmp6_, (GLXDrawable) None, (GLXContext) NULL);
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp7_ = c;
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp8_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp9_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		cairo_translate (_tmp7_, (gdouble) (_tmp8_ / 2), (gdouble) (_tmp9_ / 2));
#line 247 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp10_ = c;
#line 247 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		chess_view_draw_paused_overlay ((ChessView*) self, _tmp10_);
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = TRUE;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 1641 "chess-view-3d.c"
	}
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = g_new0 (GLfloat, 6);
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[0] = (GLfloat) 0.0033922635f;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[1] = (GLfloat) 0.3317967229f;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[2] = (GLfloat) 0.2806016275f;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[3] = (GLfloat) (-0.2495619123f);
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[4] = (GLfloat) (-0.273817106f);
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_[5] = (GLfloat) (-0.086844639f);
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	jitters = _tmp11_;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	jitters_length1 = 6;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_jitters_size_ = jitters_length1;
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = chess_view3_d_start_gl (self);
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (!_tmp12_) {
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = TRUE;
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		jitters = (g_free (jitters), NULL);
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 1673 "chess-view-3d.c"
	}
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	n_passes = 1;
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp13_ = chess_view_get_scene ((ChessView*) self);
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp14_ = _tmp13_;
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = chess_scene_get_show_3d_smooth (_tmp14_);
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = _tmp15_;
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp16_) {
#line 259 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glClear ((GLbitfield) GL_ACCUM_BUFFER_BIT);
#line 260 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		n_passes = 3;
#line 1691 "chess-view-3d.c"
	}
	{
		gint i = 0;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		i = 0;
#line 1697 "chess-view-3d.c"
		{
			gboolean _tmp17_ = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp17_ = TRUE;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 1704 "chess-view-3d.c"
				gboolean _tmp18_ = FALSE;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				GtkWindow* window = NULL;
				GtkWidget* _tmp22_ = NULL;
				GtkWindow* _tmp23_ = NULL;
				GdkRGBA bg = {0};
				GtkWindow* _tmp24_ = NULL;
				GtkStyleContext* _tmp25_ = NULL;
				GtkWindow* _tmp26_ = NULL;
				GtkStateFlags _tmp27_ = 0;
				GdkRGBA _tmp28_ = {0};
				GdkRGBA _tmp29_ = {0};
				gdouble _tmp30_ = 0.0;
				GdkRGBA _tmp31_ = {0};
				gdouble _tmp32_ = 0.0;
				GdkRGBA _tmp33_ = {0};
				gdouble _tmp34_ = 0.0;
				ChessScene* _tmp35_ = NULL;
				ChessScene* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				GLfloat* pos = NULL;
				GLfloat* _tmp49_ = NULL;
				gint pos_length1 = 0;
				gint _pos_size_ = 0;
				GLfloat* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				ChessScene* _tmp51_ = NULL;
				ChessScene* _tmp52_ = NULL;
				gdouble _tmp53_ = 0.0;
				gdouble _tmp54_ = 0.0;
				GLfloat _tmp55_ = 0.0F;
				GLfloat _tmp56_ = 0.0F;
				ChessScene* _tmp57_ = NULL;
				ChessScene* _tmp58_ = NULL;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				ChessScene* _tmp61_ = NULL;
				ChessScene* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
				gboolean _tmp64_ = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp18_ = _tmp17_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp18_) {
#line 1751 "chess-view-3d.c"
					gint _tmp19_ = 0;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp19_ = i;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					i = _tmp19_ + 1;
#line 1757 "chess-view-3d.c"
				}
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp17_ = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20_ = i;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp21_ = n_passes;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp20_ < _tmp21_)) {
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 1769 "chess-view-3d.c"
				}
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp22_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_WINDOW, GtkWindow));
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				window = _tmp23_;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp24_ = window;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26_ = window;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp27_ = gtk_widget_get_state_flags ((GtkWidget*) _tmp26_);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				gtk_style_context_get_background_color (_tmp25_, _tmp27_, &_tmp28_);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				bg = _tmp28_;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp29_ = bg;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp30_ = _tmp29_.red;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp31_ = bg;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp32_ = _tmp31_.green;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp33_ = bg;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp34_ = _tmp33_.blue;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glClearColor ((GLclampf) ((gfloat) _tmp30_), (GLclampf) ((gfloat) _tmp32_), (GLclampf) ((gfloat) _tmp34_), (GLclampf) 1.0f);
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glClear ((GLbitfield) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT));
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glEnable (GL_DEPTH_TEST);
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glMatrixMode (GL_PROJECTION);
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glLoadIdentity ();
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp35_ = chess_view_get_scene ((ChessView*) self);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp36_ = _tmp35_;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp37_ = chess_scene_get_show_3d_smooth (_tmp36_);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp38_ = _tmp37_;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (_tmp38_) {
#line 1821 "chess-view-3d.c"
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					GLfloat* _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					gint _tmp42_ = 0;
					GLfloat _tmp43_ = 0.0F;
					GLfloat* _tmp44_ = NULL;
					gint _tmp44__length1 = 0;
					gint _tmp45_ = 0;
					GLfloat _tmp46_ = 0.0F;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp39_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp40_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp41_ = jitters;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp41__length1 = jitters_length1;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp42_ = i;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp43_ = _tmp41_[_tmp42_ * 2];
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp44_ = jitters;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp44__length1 = jitters_length1;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp45_ = i;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp46_ = _tmp44_[(_tmp45_ * 2) + 1];
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					chess_view3_d_accPerspective (self, (GLfloat) 60.0f, (GLfloat) (((gfloat) _tmp39_) / _tmp40_), (GLfloat) 0.1f, (GLfloat) 1000, _tmp43_, _tmp46_, (GLfloat) 0, (GLfloat) 0, (GLfloat) 1);
#line 1854 "chess-view-3d.c"
				} else {
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp47_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp48_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					gluPerspective ((GLdouble) 60.0f, (GLdouble) (((gfloat) _tmp47_) / _tmp48_), (GLdouble) 0.1f, (GLdouble) 1000);
#line 1864 "chess-view-3d.c"
				}
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glMatrixMode (GL_MODELVIEW);
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_transform_camera (self);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_ = g_new0 (GLfloat, 4);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_[0] = (GLfloat) 100.0f;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_[1] = (GLfloat) 100.0f;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_[2] = (GLfloat) 100.0f;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_[3] = (GLfloat) 1.0f;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				pos = _tmp49_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				pos_length1 = 4;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_pos_size_ = pos_length1;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp50_ = pos;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp50__length1 = pos_length1;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glLightfv (GL_LIGHT0, GL_POSITION, _tmp50_);
#line 284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glEnable (GL_LIGHTING);
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glEnable (GL_LIGHT0);
#line 287 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPushMatrix ();
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp51_ = chess_view_get_scene ((ChessView*) self);
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp52_ = _tmp51_;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp53_ = chess_scene_get_board_angle (_tmp52_);
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp54_ = _tmp53_;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glRotatef ((GLfloat) _tmp54_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp55_ = self->priv->OFFSET;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp56_ = self->priv->OFFSET;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glTranslatef (-_tmp55_, (GLfloat) 0.0f, _tmp56_);
#line 291 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_board (self);
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp57_ = chess_view_get_scene ((ChessView*) self);
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp58_ = _tmp57_;
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp59_ = chess_scene_get_show_numbering (_tmp58_);
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp60_ = _tmp59_;
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (_tmp60_) {
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					chess_view3_d_draw_numbering (self);
#line 1928 "chess-view-3d.c"
				}
#line 294 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_pieces (self);
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPopMatrix ();
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp61_ = chess_view_get_scene ((ChessView*) self);
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp62_ = _tmp61_;
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp63_ = chess_scene_get_show_3d_smooth (_tmp62_);
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp64_ = _tmp63_;
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (_tmp64_) {
#line 1944 "chess-view-3d.c"
					gint _tmp65_ = 0;
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp65_ = n_passes;
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					glAccum (GL_ACCUM, (GLfloat) (1.0f / _tmp65_));
#line 1950 "chess-view-3d.c"
				}
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				pos = (g_free (pos), NULL);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_g_object_unref0 (window);
#line 1956 "chess-view-3d.c"
			}
		}
	}
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp66_ = chess_view_get_scene ((ChessView*) self);
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp67_ = _tmp66_;
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp68_ = chess_scene_get_show_3d_smooth (_tmp67_);
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp69_ = _tmp68_;
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp69_) {
#line 303 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glAccum (GL_RETURN, (GLfloat) 1);
#line 1972 "chess-view-3d.c"
	}
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp70_ = self->priv->display;
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp71_ = self->priv->drawable;
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glXSwapBuffers (_tmp70_, _tmp71_);
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = TRUE;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	jitters = (g_free (jitters), NULL);
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 1986 "chess-view-3d.c"
}


static void chess_view3_d_draw_board (ChessView3D* self) {
	GLuint _tmp65_ = 0U;
	GLuint _tmp66_ = 0U;
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_COLOR_MATERIAL);
#line 313 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glColor3f ((GLfloat) (0x2e / 255.f), (GLfloat) (0x34 / 255.f), (GLfloat) (0x36 / 255.f));
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBegin (GL_QUADS);
#line 2001 "chess-view-3d.c"
	{
		gint i = 0;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		i = 0;
#line 2006 "chess-view-3d.c"
		{
			gboolean _tmp0_ = FALSE;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp0_ = TRUE;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 2013 "chess-view-3d.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				GLushort* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint j = 0;
				GLushort* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				GLushort _tmp7_ = 0U;
				GLfloat* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				GLfloat _tmp10_ = 0.0F;
				GLfloat* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				GLfloat _tmp13_ = 0.0F;
				GLfloat* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				GLfloat _tmp16_ = 0.0F;
				GLushort* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				GLushort _tmp19_ = 0U;
				GLfloat* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint _tmp21_ = 0;
				GLfloat _tmp22_ = 0.0F;
				GLfloat* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				GLfloat _tmp25_ = 0.0F;
				GLfloat* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				GLfloat _tmp28_ = 0.0F;
				GLushort* _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				gint _tmp30_ = 0;
				GLushort _tmp31_ = 0U;
				GLfloat* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				GLfloat _tmp34_ = 0.0F;
				GLfloat* _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				GLfloat _tmp37_ = 0.0F;
				GLfloat* _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				GLfloat _tmp40_ = 0.0F;
				GLushort* _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				gint _tmp42_ = 0;
				GLushort _tmp43_ = 0U;
				GLfloat* _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gint _tmp45_ = 0;
				GLfloat _tmp46_ = 0.0F;
				GLfloat* _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gint _tmp48_ = 0;
				GLfloat _tmp49_ = 0.0F;
				GLfloat* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				gint _tmp51_ = 0;
				GLfloat _tmp52_ = 0.0F;
				GLushort* _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				gint _tmp54_ = 0;
				GLushort _tmp55_ = 0U;
				GLfloat* _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gint _tmp57_ = 0;
				GLfloat _tmp58_ = 0.0F;
				GLfloat* _tmp59_ = NULL;
				gint _tmp59__length1 = 0;
				gint _tmp60_ = 0;
				GLfloat _tmp61_ = 0.0F;
				GLfloat* _tmp62_ = NULL;
				gint _tmp62__length1 = 0;
				gint _tmp63_ = 0;
				GLfloat _tmp64_ = 0.0F;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp1_ = _tmp0_;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp1_) {
#line 2103 "chess-view-3d.c"
					gint _tmp2_ = 0;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp2_ = i;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					i = _tmp2_ + 5;
#line 2109 "chess-view-3d.c"
				}
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp0_ = FALSE;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp3_ = i;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp4_ = self->priv->board_quads;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp4__length1 = self->priv->board_quads_length1;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 2123 "chess-view-3d.c"
				}
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp5_ = self->priv->board_quads;
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp5__length1 = self->priv->board_quads_length1;
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp6_ = i;
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp7_ = _tmp5_[_tmp6_ + 4];
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				j = _tmp7_ * 3;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp8_ = self->priv->board_normals;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp8__length1 = self->priv->board_normals_length1;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp9_ = j;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp11_ = self->priv->board_normals;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp11__length1 = self->priv->board_normals_length1;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp12_ = j;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp13_ = _tmp11_[_tmp12_ + 1];
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp14_ = self->priv->board_normals;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp14__length1 = self->priv->board_normals_length1;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp15_ = j;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp16_ = _tmp14_[_tmp15_ + 2];
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glNormal3f (_tmp10_, _tmp13_, _tmp16_);
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp17_ = self->priv->board_quads;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp17__length1 = self->priv->board_quads_length1;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp18_ = i;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				j = _tmp19_ * 3;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20_ = self->priv->board_vertices;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20__length1 = self->priv->board_vertices_length1;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp21_ = j;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp22_ = _tmp20_[_tmp21_];
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23_ = self->priv->board_vertices;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23__length1 = self->priv->board_vertices_length1;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp24_ = j;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp25_ = _tmp23_[_tmp24_ + 1];
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26_ = self->priv->board_vertices;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26__length1 = self->priv->board_vertices_length1;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp27_ = j;
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp28_ = _tmp26_[_tmp27_ + 2];
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glVertex3f (_tmp22_, _tmp25_, _tmp28_);
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp29_ = self->priv->board_quads;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp29__length1 = self->priv->board_quads_length1;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp30_ = i;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				j = _tmp31_ * 3;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp32_ = self->priv->board_vertices;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp32__length1 = self->priv->board_vertices_length1;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp33_ = j;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp34_ = _tmp32_[_tmp33_];
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp35_ = self->priv->board_vertices;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp35__length1 = self->priv->board_vertices_length1;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp36_ = j;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp37_ = _tmp35_[_tmp36_ + 1];
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp38_ = self->priv->board_vertices;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp38__length1 = self->priv->board_vertices_length1;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp39_ = j;
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp40_ = _tmp38_[_tmp39_ + 2];
#line 322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glVertex3f (_tmp34_, _tmp37_, _tmp40_);
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp41_ = self->priv->board_quads;
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp41__length1 = self->priv->board_quads_length1;
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp42_ = i;
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp43_ = _tmp41_[_tmp42_ + 2];
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				j = _tmp43_ * 3;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp44_ = self->priv->board_vertices;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp44__length1 = self->priv->board_vertices_length1;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp45_ = j;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp46_ = _tmp44_[_tmp45_];
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp47_ = self->priv->board_vertices;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp47__length1 = self->priv->board_vertices_length1;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp48_ = j;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp49_ = _tmp47_[_tmp48_ + 1];
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp50_ = self->priv->board_vertices;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp50__length1 = self->priv->board_vertices_length1;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp51_ = j;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp52_ = _tmp50_[_tmp51_ + 2];
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glVertex3f (_tmp46_, _tmp49_, _tmp52_);
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp53_ = self->priv->board_quads;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp53__length1 = self->priv->board_quads_length1;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp54_ = i;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp55_ = _tmp53_[_tmp54_ + 3];
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				j = _tmp55_ * 3;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp56_ = self->priv->board_vertices;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp56__length1 = self->priv->board_vertices_length1;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp57_ = j;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp58_ = _tmp56_[_tmp57_];
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp59_ = self->priv->board_vertices;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp59__length1 = self->priv->board_vertices_length1;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp60_ = j;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp61_ = _tmp59_[_tmp60_ + 1];
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp62_ = self->priv->board_vertices;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp62__length1 = self->priv->board_vertices_length1;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp63_ = j;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp64_ = _tmp62_[_tmp63_ + 2];
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glVertex3f (_tmp58_, _tmp61_, _tmp64_);
#line 2305 "chess-view-3d.c"
			}
		}
	}
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnd ();
#line 330 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_TEXTURE_2D);
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp65_ = chess_view3_d_get_board_texture (self);
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp66_ = _tmp65_;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBindTexture (GL_TEXTURE_2D, _tmp66_);
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
#line 2321 "chess-view-3d.c"
	{
		gint rank = 0;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		rank = 0;
#line 2326 "chess-view-3d.c"
		{
			gboolean _tmp67_ = FALSE;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp67_ = TRUE;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 2333 "chess-view-3d.c"
				gboolean _tmp68_ = FALSE;
				gint _tmp70_ = 0;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp68_ = _tmp67_;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp68_) {
#line 2340 "chess-view-3d.c"
					gint _tmp69_ = 0;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp69_ = rank;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					rank = _tmp69_ + 1;
#line 2346 "chess-view-3d.c"
				}
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp67_ = FALSE;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp70_ = rank;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp70_ < 8)) {
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 2356 "chess-view-3d.c"
				}
				{
					gint file = 0;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					file = 0;
#line 2362 "chess-view-3d.c"
					{
						gboolean _tmp71_ = FALSE;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						_tmp71_ = TRUE;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						while (TRUE) {
#line 2369 "chess-view-3d.c"
							gboolean _tmp72_ = FALSE;
							gint _tmp74_ = 0;
							gint _tmp75_ = 0;
							gint _tmp76_ = 0;
							GLfloat x0 = 0.0F;
							GLfloat _tmp77_ = 0.0F;
							gint _tmp78_ = 0;
							GLfloat _tmp79_ = 0.0F;
							GLfloat x1 = 0.0F;
							GLfloat _tmp80_ = 0.0F;
							GLfloat _tmp81_ = 0.0F;
							GLfloat z0 = 0.0F;
							GLfloat _tmp82_ = 0.0F;
							gint _tmp83_ = 0;
							GLfloat _tmp84_ = 0.0F;
							GLfloat z1 = 0.0F;
							GLfloat _tmp85_ = 0.0F;
							GLfloat _tmp86_ = 0.0F;
							GLfloat _tmp87_ = 0.0F;
							GLfloat _tmp88_ = 0.0F;
							GLfloat _tmp89_ = 0.0F;
							GLfloat _tmp90_ = 0.0F;
							GLfloat _tmp91_ = 0.0F;
							GLfloat _tmp92_ = 0.0F;
							GLfloat _tmp93_ = 0.0F;
							GLfloat _tmp94_ = 0.0F;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp72_ = _tmp71_;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!_tmp72_) {
#line 2400 "chess-view-3d.c"
								gint _tmp73_ = 0;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp73_ = file;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								file = _tmp73_ + 1;
#line 2406 "chess-view-3d.c"
							}
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp71_ = FALSE;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp74_ = file;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!(_tmp74_ < 8)) {
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								break;
#line 2416 "chess-view-3d.c"
							}
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp75_ = file;
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp76_ = rank;
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (((_tmp75_ + _tmp76_) % 2) == 0) {
#line 337 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glColor3f ((GLfloat) (0xba / 255.f), (GLfloat) (0xbd / 255.f), (GLfloat) (0xb6 / 255.f));
#line 2426 "chess-view-3d.c"
							} else {
#line 339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glColor3f ((GLfloat) (0xee / 255.f), (GLfloat) (0xee / 255.f), (GLfloat) (0xec / 255.f));
#line 2430 "chess-view-3d.c"
							}
#line 341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glBegin (GL_QUADS);
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp77_ = self->priv->BOARD_BORDER;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp78_ = file;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp79_ = self->priv->SQUARE_WIDTH;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							x0 = _tmp77_ + (_tmp78_ * _tmp79_);
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp80_ = x0;
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp81_ = self->priv->SQUARE_WIDTH;
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							x1 = _tmp80_ + _tmp81_;
#line 344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp82_ = self->priv->BOARD_BORDER;
#line 344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp83_ = rank;
#line 344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp84_ = self->priv->SQUARE_WIDTH;
#line 344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							z0 = _tmp82_ + (_tmp83_ * _tmp84_);
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp85_ = z0;
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp86_ = self->priv->SQUARE_WIDTH;
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							z1 = _tmp85_ + _tmp86_;
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 0.0f);
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp87_ = x0;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp88_ = z0;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp87_, (GLfloat) 0.0f, -_tmp88_);
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 0.0f);
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp89_ = x1;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp90_ = z0;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp89_, (GLfloat) 0.0f, -_tmp90_);
#line 351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 1.0f);
#line 352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp91_ = x1;
#line 352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp92_ = z1;
#line 352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp91_, (GLfloat) 0.0f, -_tmp92_);
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 1.0f);
#line 354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp93_ = x0;
#line 354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp94_ = z1;
#line 354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp93_, (GLfloat) 0.0f, -_tmp94_);
#line 355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glEnd ();
#line 2496 "chess-view-3d.c"
						}
					}
				}
			}
		}
	}
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_TEXTURE_2D);
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_COLOR_MATERIAL);
#line 2507 "chess-view-3d.c"
}


static void chess_view3_d_draw_numbering (ChessView3D* self) {
	GLfloat text_width = 0.0F;
	GLfloat _tmp0_ = 0.0F;
	GLfloat text_offset = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	GLfloat offset = 0.0F;
	GLfloat _tmp3_ = 0.0F;
	GLfloat _tmp4_ = 0.0F;
	GLfloat white_z_offset = 0.0F;
	GLfloat _tmp5_ = 0.0F;
	GLfloat black_z_offset = 0.0F;
	GLfloat _tmp6_ = 0.0F;
	GLfloat _tmp7_ = 0.0F;
	GLfloat left_offset = 0.0F;
	GLfloat _tmp8_ = 0.0F;
	GLfloat right_offset = 0.0F;
	GLfloat _tmp9_ = 0.0F;
	GLfloat _tmp10_ = 0.0F;
	GLuint _tmp11_ = 0U;
	GLuint _tmp12_ = 0U;
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->BOARD_BORDER;
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	text_width = _tmp0_ * 0.7f;
#line 365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = self->priv->BOARD_BORDER;
#line 365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->BOARD_CHAMFER;
#line 365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	text_offset = (_tmp1_ + _tmp2_) * 0.5f;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = self->priv->BOARD_BORDER;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->SQUARE_WIDTH;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	offset = _tmp3_ + (_tmp4_ * 0.5f);
#line 367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = text_offset;
#line 367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	white_z_offset = -_tmp5_;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = self->priv->BOARD_OUTER_WIDTH;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = text_offset;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	black_z_offset = (-_tmp6_) + _tmp7_;
#line 369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = text_offset;
#line 369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	left_offset = _tmp8_;
#line 370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = self->priv->BOARD_OUTER_WIDTH;
#line 370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = text_offset;
#line 370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	right_offset = _tmp9_ - _tmp10_;
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_DEPTH_TEST);
#line 373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_TEXTURE_2D);
#line 374 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_COLOR_MATERIAL);
#line 375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_BLEND);
#line 376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
#line 377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = chess_view3_d_get_numbering_texture (self);
#line 377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = _tmp11_;
#line 377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBindTexture (GL_TEXTURE_2D, _tmp12_);
#line 378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glColor3f ((GLfloat) 1, (GLfloat) 1, (GLfloat) 1);
#line 379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
#line 2590 "chess-view-3d.c"
	{
		gint i = 0;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		i = 0;
#line 2595 "chess-view-3d.c"
		{
			gboolean _tmp13_ = FALSE;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp13_ = TRUE;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 2602 "chess-view-3d.c"
				gboolean _tmp14_ = FALSE;
				gint _tmp16_ = 0;
				GLfloat _tmp17_ = 0.0F;
				GLfloat _tmp18_ = 0.0F;
				GLfloat _tmp19_ = 0.0F;
				gint _tmp20_ = 0;
				GLfloat _tmp21_ = 0.0F;
				GLfloat _tmp22_ = 0.0F;
				GLfloat _tmp23_ = 0.0F;
				gint _tmp24_ = 0;
				GLfloat _tmp25_ = 0.0F;
				GLfloat _tmp26_ = 0.0F;
				GLfloat _tmp27_ = 0.0F;
				gint _tmp28_ = 0;
				GLfloat _tmp29_ = 0.0F;
				GLfloat _tmp30_ = 0.0F;
				GLfloat _tmp31_ = 0.0F;
				gint _tmp32_ = 0;
				GLfloat _tmp33_ = 0.0F;
				GLfloat _tmp34_ = 0.0F;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp14_ = _tmp13_;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp14_) {
#line 2627 "chess-view-3d.c"
					gint _tmp15_ = 0;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp15_ = i;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					i = _tmp15_ + 1;
#line 2633 "chess-view-3d.c"
				}
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp13_ = FALSE;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp16_ = i;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp16_ < 8)) {
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 2643 "chess-view-3d.c"
				}
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp17_ = left_offset;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp18_ = offset;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp19_ = text_width;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20_ = i;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_label (self, _tmp17_, -_tmp18_, _tmp19_, _tmp20_ + 8);
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp21_ = right_offset;
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp22_ = offset;
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23_ = text_width;
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp24_ = i;
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_label (self, _tmp21_, -_tmp22_, _tmp23_, _tmp24_ + 8);
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp25_ = offset;
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26_ = white_z_offset;
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp27_ = text_width;
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp28_ = i;
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_label (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_);
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp29_ = offset;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp30_ = black_z_offset;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp31_ = text_width;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp32_ = i;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_label (self, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp33_ = offset;
#line 388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp34_ = self->priv->SQUARE_WIDTH;
#line 388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				offset = _tmp33_ + _tmp34_;
#line 2691 "chess-view-3d.c"
			}
		}
	}
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_BLEND);
#line 392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_COLOR_MATERIAL);
#line 393 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_TEXTURE_2D);
#line 2701 "chess-view-3d.c"
}


static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell) {
	GLfloat w = 0.0F;
	GLfloat l = 0.0F;
	gint _tmp0_ = 0;
	GLfloat _tmp1_ = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	ChessScene* _tmp3_ = NULL;
	ChessScene* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
#line 396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	w = (GLfloat) (1.0f / 16);
#line 399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = cell;
#line 399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	l = (GLfloat) (_tmp0_ / 16.0f);
#line 401 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glPushMatrix ();
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = x;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = z;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTranslatef (_tmp1_, (GLfloat) 0.0f, _tmp2_);
#line 404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBegin (GL_QUADS);
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = chess_view_get_scene ((ChessView*) self);
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = _tmp3_;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = chess_scene_get_board_angle (_tmp4_);
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = _tmp5_;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp6_ == 180.0) {
#line 2743 "chess-view-3d.c"
		GLfloat _tmp7_ = 0.0F;
		GLfloat _tmp8_ = 0.0F;
		GLfloat _tmp9_ = 0.0F;
		GLfloat _tmp10_ = 0.0F;
		GLfloat _tmp11_ = 0.0F;
		GLfloat _tmp12_ = 0.0F;
		GLfloat _tmp13_ = 0.0F;
		GLfloat _tmp14_ = 0.0F;
		GLfloat _tmp15_ = 0.0F;
		GLfloat _tmp16_ = 0.0F;
		GLfloat _tmp17_ = 0.0F;
		GLfloat _tmp18_ = 0.0F;
		GLfloat _tmp19_ = 0.0F;
		GLfloat _tmp20_ = 0.0F;
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp7_ = l;
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp8_ = w;
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp7_ + _tmp8_, (GLfloat) 1.0f);
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp9_ = width;
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp10_ = width;
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f ((-_tmp9_) / 2, (GLfloat) 0.0f, (-_tmp10_) / 2);
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp11_ = l;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp12_ = w;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp11_ + _tmp12_, (GLfloat) 0.0f);
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp13_ = width;
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp14_ = width;
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f ((-_tmp13_) / 2, (GLfloat) 0.0f, _tmp14_ / 2);
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp15_ = l;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp15_, (GLfloat) 0.0f);
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp16_ = width;
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp17_ = width;
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f (_tmp16_ / 2, (GLfloat) 0.0f, _tmp17_ / 2);
#line 413 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp18_ = l;
#line 413 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp18_, (GLfloat) 1.0f);
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp19_ = width;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp20_ = width;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f (_tmp19_ / 2, (GLfloat) 0.0f, (-_tmp20_) / 2);
#line 2802 "chess-view-3d.c"
	} else {
		GLfloat _tmp21_ = 0.0F;
		GLfloat _tmp22_ = 0.0F;
		GLfloat _tmp23_ = 0.0F;
		GLfloat _tmp24_ = 0.0F;
		GLfloat _tmp25_ = 0.0F;
		GLfloat _tmp26_ = 0.0F;
		GLfloat _tmp27_ = 0.0F;
		GLfloat _tmp28_ = 0.0F;
		GLfloat _tmp29_ = 0.0F;
		GLfloat _tmp30_ = 0.0F;
		GLfloat _tmp31_ = 0.0F;
		GLfloat _tmp32_ = 0.0F;
		GLfloat _tmp33_ = 0.0F;
		GLfloat _tmp34_ = 0.0F;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp21_ = l;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp21_, (GLfloat) 0.0f);
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp22_ = width;
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp23_ = width;
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f ((-_tmp22_) / 2, (GLfloat) 0.0f, (-_tmp23_) / 2);
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp24_ = l;
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp24_, (GLfloat) 1.0f);
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp25_ = width;
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp26_ = width;
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f ((-_tmp25_) / 2, (GLfloat) 0.0f, _tmp26_ / 2);
#line 422 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp27_ = l;
#line 422 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp28_ = w;
#line 422 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp27_ + _tmp28_, (GLfloat) 1.0f);
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp29_ = width;
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp30_ = width;
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f (_tmp29_ / 2, (GLfloat) 0.0f, _tmp30_ / 2);
#line 424 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp31_ = l;
#line 424 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp32_ = w;
#line 424 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glTexCoord2f (_tmp31_ + _tmp32_, (GLfloat) 0.0f);
#line 425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp33_ = width;
#line 425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp34_ = width;
#line 425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glVertex3f (_tmp33_ / 2, (GLfloat) 0.0f, (-_tmp34_) / 2);
#line 2862 "chess-view-3d.c"
	}
#line 427 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnd ();
#line 429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glPopMatrix ();
#line 2868 "chess-view-3d.c"
}


static gpointer _chess_model_ref0 (gpointer self) {
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return self ? chess_model_ref (self) : NULL;
#line 2875 "chess-view-3d.c"
}


static void chess_view3_d_draw_pieces (ChessView3D* self) {
	ChessScene* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	GLuint _tmp4_ = 0U;
	GLuint _tmp5_ = 0U;
	ChessScene* _tmp6_ = NULL;
	ChessScene* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
#line 432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = chess_view_get_scene ((ChessView*) self);
#line 434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = _tmp0_;
#line 434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = chess_scene_get_game (_tmp1_);
#line 434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = _tmp2_;
#line 434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp3_ == NULL) {
#line 435 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return;
#line 2903 "chess-view-3d.c"
	}
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_DEPTH_TEST);
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glEnable (GL_TEXTURE_2D);
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = chess_view3_d_get_piece_texture (self);
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = _tmp4_;
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBindTexture (GL_TEXTURE_2D, _tmp5_);
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = chess_view_get_scene ((ChessView*) self);
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = _tmp6_;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = _tmp7_->pieces;
#line 2921 "chess-view-3d.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		model_collection = _tmp8_;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 2929 "chess-view-3d.c"
			ChessModel* _tmp9_ = NULL;
			ChessModel* model = NULL;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp9_ = _chess_model_ref0 ((ChessModel*) model_it->data);
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			model = _tmp9_;
#line 2936 "chess-view-3d.c"
			{
				GLfloat _tmp10_ = 0.0F;
				ChessModel* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				GLfloat _tmp13_ = 0.0F;
				GLfloat _tmp14_ = 0.0F;
				GLfloat _tmp15_ = 0.0F;
				ChessModel* _tmp16_ = NULL;
				gdouble _tmp17_ = 0.0;
				GLfloat _tmp18_ = 0.0F;
				GLfloat _tmp19_ = 0.0F;
				ChessModel* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				ChessModel* _tmp23_ = NULL;
				ChessPiece* _tmp24_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPushMatrix ();
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp10_ = self->priv->BOARD_BORDER;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp11_ = model;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp12_ = _tmp11_->x;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp13_ = self->priv->SQUARE_WIDTH;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp14_ = self->priv->SQUARE_WIDTH;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp15_ = self->priv->BOARD_BORDER;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp16_ = model;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp17_ = _tmp16_->y;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp18_ = self->priv->SQUARE_WIDTH;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp19_ = self->priv->SQUARE_WIDTH;
#line 445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glTranslatef ((_tmp10_ + (((GLfloat) _tmp12_) * _tmp13_)) + (_tmp14_ / 2), (GLfloat) 0.0f, -((_tmp15_ + (((GLfloat) _tmp17_) * _tmp18_)) + (_tmp19_ / 2)));
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20_ = model;
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp21_ = _tmp20_->is_selected;
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (_tmp21_) {
#line 2982 "chess-view-3d.c"
					GLfloat _tmp22_ = 0.0F;
#line 451 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp22_ = self->priv->SQUARE_WIDTH;
#line 451 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					glTranslatef ((GLfloat) 0.0f, _tmp22_ * 0.4f, (GLfloat) 0.0f);
#line 2988 "chess-view-3d.c"
				}
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23_ = model;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp24_ = _tmp23_->piece;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_render_piece (self, _tmp24_, (GLfloat) 1.0f);
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPopMatrix ();
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_chess_model_unref0 (model);
#line 3000 "chess-view-3d.c"
			}
		}
	}
	{
		gint rank = 0;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		rank = 0;
#line 3008 "chess-view-3d.c"
		{
			gboolean _tmp25_ = FALSE;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp25_ = TRUE;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 3015 "chess-view-3d.c"
				gboolean _tmp26_ = FALSE;
				gint _tmp28_ = 0;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26_ = _tmp25_;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp26_) {
#line 3022 "chess-view-3d.c"
					gint _tmp27_ = 0;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp27_ = rank;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					rank = _tmp27_ + 1;
#line 3028 "chess-view-3d.c"
				}
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp25_ = FALSE;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp28_ = rank;
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp28_ < 8)) {
#line 459 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 3038 "chess-view-3d.c"
				}
				{
					gint file = 0;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					file = 0;
#line 3044 "chess-view-3d.c"
					{
						gboolean _tmp29_ = FALSE;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						_tmp29_ = TRUE;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						while (TRUE) {
#line 3051 "chess-view-3d.c"
							gboolean _tmp30_ = FALSE;
							gint _tmp32_ = 0;
							gboolean _tmp33_ = FALSE;
							ChessScene* _tmp34_ = NULL;
							ChessScene* _tmp35_ = NULL;
							gboolean _tmp36_ = FALSE;
							gboolean _tmp37_ = FALSE;
							gboolean _tmp43_ = FALSE;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp30_ = _tmp29_;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!_tmp30_) {
#line 3064 "chess-view-3d.c"
								gint _tmp31_ = 0;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp31_ = file;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								file = _tmp31_ + 1;
#line 3070 "chess-view-3d.c"
							}
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp29_ = FALSE;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp32_ = file;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!(_tmp32_ < 8)) {
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								break;
#line 3080 "chess-view-3d.c"
							}
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp34_ = chess_view_get_scene ((ChessView*) self);
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp35_ = _tmp34_;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp36_ = chess_scene_get_show_move_hints (_tmp35_);
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp37_ = _tmp36_;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (_tmp37_) {
#line 3092 "chess-view-3d.c"
								ChessScene* _tmp38_ = NULL;
								ChessScene* _tmp39_ = NULL;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								gboolean _tmp42_ = FALSE;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp38_ = chess_view_get_scene ((ChessView*) self);
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp39_ = _tmp38_;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp40_ = rank;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp41_ = file;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp42_ = chess_scene_can_move (_tmp39_, _tmp40_, _tmp41_);
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp33_ = _tmp42_;
#line 3110 "chess-view-3d.c"
							} else {
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp33_ = FALSE;
#line 3114 "chess-view-3d.c"
							}
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp43_ = _tmp33_;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (_tmp43_) {
#line 3120 "chess-view-3d.c"
								GLfloat _tmp44_ = 0.0F;
								gint _tmp45_ = 0;
								GLfloat _tmp46_ = 0.0F;
								GLfloat _tmp47_ = 0.0F;
								GLfloat _tmp48_ = 0.0F;
								gint _tmp49_ = 0;
								GLfloat _tmp50_ = 0.0F;
								GLfloat _tmp51_ = 0.0F;
								ChessScene* _tmp52_ = NULL;
								ChessScene* _tmp53_ = NULL;
								ChessPiece* _tmp54_ = NULL;
								ChessPiece* _tmp55_ = NULL;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glPushMatrix ();
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp44_ = self->priv->BOARD_BORDER;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp45_ = file;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp46_ = self->priv->SQUARE_WIDTH;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp47_ = self->priv->SQUARE_WIDTH;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp48_ = self->priv->BOARD_BORDER;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp49_ = rank;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp50_ = self->priv->SQUARE_WIDTH;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp51_ = self->priv->SQUARE_WIDTH;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glTranslatef ((_tmp44_ + (_tmp45_ * _tmp46_)) + (_tmp47_ / 2), (GLfloat) 0.0f, -((_tmp48_ + (_tmp49_ * _tmp50_)) + (_tmp51_ / 2)));
#line 470 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glEnable (GL_BLEND);
#line 472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glDisable (GL_DEPTH_TEST);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp52_ = chess_view_get_scene ((ChessView*) self);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp53_ = _tmp52_;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp54_ = chess_scene_get_selected_piece (_tmp53_);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp55_ = _tmp54_;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								chess_view3_d_render_piece (self, _tmp55_, (GLfloat) 0.1f);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_chess_piece_unref0 (_tmp55_);
#line 474 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glEnable (GL_DEPTH_TEST);
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glDisable (GL_BLEND);
#line 477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								glPopMatrix ();
#line 3177 "chess-view-3d.c"
							}
						}
					}
				}
			}
		}
	}
#line 482 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glDisable (GL_TEXTURE_2D);
#line 3187 "chess-view-3d.c"
}


static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha) {
	GLfloat _tmp0_ = 0.0F;
	GLfloat _tmp1_ = 0.0F;
	GLfloat _tmp2_ = 0.0F;
	GLfloat _tmp3_ = 0.0F;
	ChessPiece* _tmp4_ = NULL;
	ChessPlayer* _tmp5_ = NULL;
	Color _tmp6_ = 0;
#line 500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	static const GLfloat black[] = {(GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f};
#line 3201 "chess-view-3d.c"
	ChessPiece* _tmp7_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	Color _tmp9_ = 0;
	ChessPiece* _tmp10_ = NULL;
	PieceType _tmp11_ = 0;
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (piece != NULL);
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = alpha;
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->white_piece_color[3] = _tmp0_;
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = self->priv->white_piece_color[3];
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = alpha;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->black_piece_color[3] = _tmp2_;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = self->priv->black_piece_color[3];
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = piece;
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = _tmp4_->player;
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = _tmp5_->color;
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp6_ == COLOR_WHITE) {
#line 492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->white_piece_color);
#line 493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->white_piece_specular);
#line 3235 "chess-view-3d.c"
	} else {
#line 497 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->black_piece_color);
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->black_piece_specular);
#line 3241 "chess-view-3d.c"
	}
#line 501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glMaterialfv (GL_FRONT_AND_BACK, GL_EMISSION, black);
#line 502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, (GLfloat) 64.0f);
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = piece;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = _tmp7_->player;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = _tmp8_->color;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp9_ == COLOR_BLACK) {
#line 505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		glRotatef ((GLfloat) 180.0f, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
#line 3257 "chess-view-3d.c"
	}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = piece;
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = _tmp10_->type;
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	switch (_tmp11_) {
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_PAWN:
#line 3267 "chess-view-3d.c"
		{
			TDSModel* _tmp12_ = NULL;
#line 510 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp12_ = self->priv->pawn_model;
#line 510 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp12_);
#line 511 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3276 "chess-view-3d.c"
		}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_ROOK:
#line 3280 "chess-view-3d.c"
		{
			TDSModel* _tmp13_ = NULL;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp13_ = self->priv->rook_model;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp13_);
#line 514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3289 "chess-view-3d.c"
		}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_KNIGHT:
#line 3293 "chess-view-3d.c"
		{
			TDSModel* _tmp14_ = NULL;
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp14_ = self->priv->knight_model;
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp14_);
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3302 "chess-view-3d.c"
		}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_BISHOP:
#line 3306 "chess-view-3d.c"
		{
			TDSModel* _tmp15_ = NULL;
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp15_ = self->priv->bishop_model;
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp15_);
#line 520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3315 "chess-view-3d.c"
		}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_QUEEN:
#line 3319 "chess-view-3d.c"
		{
			TDSModel* _tmp16_ = NULL;
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp16_ = self->priv->queen_model;
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp16_);
#line 523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3328 "chess-view-3d.c"
		}
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		case PIECE_TYPE_KING:
#line 3332 "chess-view-3d.c"
		{
			TDSModel* _tmp17_ = NULL;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp17_ = self->priv->king_model;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			tds_model_render (_tmp17_);
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			break;
#line 3341 "chess-view-3d.c"
		}
		default:
#line 507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		break;
#line 3346 "chess-view-3d.c"
	}
}


static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GLuint buffer[20] = {0};
	GLint* viewport = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	GLint* _tmp19_ = NULL;
	gint viewport_length1 = 0;
	gint _viewport_size_ = 0;
	GdkEventButton _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gint _tmp22_ = 0;
	GdkEventButton _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	GLint* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	ChessScene* _tmp28_ = NULL;
	ChessScene* _tmp29_ = NULL;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	GLfloat _tmp32_ = 0.0F;
	GLfloat _tmp33_ = 0.0F;
	GLint n_hits = 0;
	GLint _tmp62_ = 0;
	GLint _tmp63_ = 0;
#line 530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self = (ChessView3D*) base;
#line 530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = _tmp2_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = chess_scene_get_game (_tmp3_);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = _tmp4_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp5_ == NULL) {
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = TRUE;
#line 3404 "chess-view-3d.c"
	} else {
		GdkEventButton _tmp6_ = {0};
		guint _tmp7_ = 0U;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp6_ = *event;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp7_ = _tmp6_.button;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = _tmp7_ != ((guint) 1);
#line 3414 "chess-view-3d.c"
	}
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = _tmp1_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp8_) {
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp0_ = TRUE;
#line 3422 "chess-view-3d.c"
	} else {
		ChessScene* _tmp9_ = NULL;
		ChessScene* _tmp10_ = NULL;
		ChessGame* _tmp11_ = NULL;
		ChessGame* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp9_ = chess_view_get_scene ((ChessView*) self);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp10_ = _tmp9_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp11_ = chess_scene_get_game (_tmp10_);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp12_ = _tmp11_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp14_ = _tmp13_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp0_ = _tmp14_;
#line 3444 "chess-view-3d.c"
	}
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = _tmp0_;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp15_) {
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = FALSE;
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 3454 "chess-view-3d.c"
	}
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = chess_view3_d_start_gl (self);
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (!_tmp16_) {
#line 536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = TRUE;
#line 536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 3464 "chess-view-3d.c"
	}
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glSelectBuffer ((GLsizei) 20, buffer);
#line 541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glRenderMode (GL_SELECT);
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glInitNames ();
#line 546 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glMatrixMode (GL_PROJECTION);
#line 547 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glLoadIdentity ();
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = g_new0 (GLint, 4);
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_[0] = (GLint) 0;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_[1] = (GLint) 0;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_[2] = (GLint) _tmp17_;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_[3] = (GLint) _tmp18_;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	viewport = _tmp19_;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	viewport_length1 = 4;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_viewport_size_ = viewport_length1;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_ = *event;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_ = _tmp20_.x;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp23_ = *event;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp24_ = _tmp23_.y;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp25_ = viewport;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp25__length1 = viewport_length1;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gluPickMatrix ((GLdouble) _tmp21_, (GLdouble) (((gfloat) _tmp22_) - _tmp24_), (GLdouble) 1.0, (GLdouble) 1.0, _tmp25_);
#line 550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp26_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp27_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gluPerspective ((GLdouble) 60.0, (GLdouble) (((gfloat) _tmp26_) / ((gfloat) _tmp27_)), (GLdouble) 0, (GLdouble) 1);
#line 553 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glMatrixMode (GL_MODELVIEW);
#line 554 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glLoadIdentity ();
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_transform_camera (self);
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp28_ = chess_view_get_scene ((ChessView*) self);
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp29_ = _tmp28_;
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp30_ = chess_scene_get_board_angle (_tmp29_);
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp31_ = _tmp30_;
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glRotatef ((GLfloat) _tmp31_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
#line 557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp32_ = self->priv->OFFSET;
#line 557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp33_ = self->priv->OFFSET;
#line 557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTranslatef (-_tmp32_, (GLfloat) 0.0f, _tmp33_);
#line 3540 "chess-view-3d.c"
	{
		gint rank = 0;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		rank = 0;
#line 3545 "chess-view-3d.c"
		{
			gboolean _tmp34_ = FALSE;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp34_ = TRUE;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 3552 "chess-view-3d.c"
				gboolean _tmp35_ = FALSE;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp35_ = _tmp34_;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp35_) {
#line 3560 "chess-view-3d.c"
					gint _tmp36_ = 0;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp36_ = rank;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					rank = _tmp36_ + 1;
#line 3566 "chess-view-3d.c"
				}
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp34_ = FALSE;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp37_ = rank;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp37_ < 8)) {
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 3576 "chess-view-3d.c"
				}
#line 560 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp38_ = rank;
#line 560 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPushName ((GLuint) _tmp38_);
#line 3582 "chess-view-3d.c"
				{
					gint file = 0;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					file = 0;
#line 3587 "chess-view-3d.c"
					{
						gboolean _tmp39_ = FALSE;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						_tmp39_ = TRUE;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
						while (TRUE) {
#line 3594 "chess-view-3d.c"
							gboolean _tmp40_ = FALSE;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GLfloat x0 = 0.0F;
							GLfloat _tmp44_ = 0.0F;
							gint _tmp45_ = 0;
							GLfloat _tmp46_ = 0.0F;
							GLfloat x1 = 0.0F;
							GLfloat _tmp47_ = 0.0F;
							GLfloat _tmp48_ = 0.0F;
							GLfloat z0 = 0.0F;
							GLfloat _tmp49_ = 0.0F;
							gint _tmp50_ = 0;
							GLfloat _tmp51_ = 0.0F;
							GLfloat z1 = 0.0F;
							GLfloat _tmp52_ = 0.0F;
							GLfloat _tmp53_ = 0.0F;
							GLfloat _tmp54_ = 0.0F;
							GLfloat _tmp55_ = 0.0F;
							GLfloat _tmp56_ = 0.0F;
							GLfloat _tmp57_ = 0.0F;
							GLfloat _tmp58_ = 0.0F;
							GLfloat _tmp59_ = 0.0F;
							GLfloat _tmp60_ = 0.0F;
							GLfloat _tmp61_ = 0.0F;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp40_ = _tmp39_;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!_tmp40_) {
#line 3624 "chess-view-3d.c"
								gint _tmp41_ = 0;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								_tmp41_ = file;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								file = _tmp41_ + 1;
#line 3630 "chess-view-3d.c"
							}
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp39_ = FALSE;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp42_ = file;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							if (!(_tmp42_ < 8)) {
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
								break;
#line 3640 "chess-view-3d.c"
							}
#line 564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp43_ = file;
#line 564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glPushName ((GLuint) _tmp43_);
#line 566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glBegin (GL_QUADS);
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp44_ = self->priv->BOARD_BORDER;
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp45_ = file;
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp46_ = self->priv->SQUARE_WIDTH;
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							x0 = _tmp44_ + (_tmp45_ * _tmp46_);
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp47_ = x0;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp48_ = self->priv->SQUARE_WIDTH;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							x1 = _tmp47_ + _tmp48_;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp49_ = self->priv->BOARD_BORDER;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp50_ = rank;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp51_ = self->priv->SQUARE_WIDTH;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							z0 = _tmp49_ + (_tmp50_ * _tmp51_);
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp52_ = z0;
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp53_ = self->priv->SQUARE_WIDTH;
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							z1 = _tmp52_ + _tmp53_;
#line 572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp54_ = x0;
#line 572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp55_ = z0;
#line 572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp54_, (GLfloat) 0.0f, -_tmp55_);
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp56_ = x1;
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp57_ = z0;
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp56_, (GLfloat) 0.0f, -_tmp57_);
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp58_ = x1;
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp59_ = z1;
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp58_, (GLfloat) 0.0f, -_tmp59_);
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp60_ = x0;
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							_tmp61_ = z1;
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glVertex3f (_tmp60_, (GLfloat) 0.0f, -_tmp61_);
#line 576 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glEnd ();
#line 578 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
							glPopName ();
#line 3704 "chess-view-3d.c"
						}
					}
				}
#line 580 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				glPopName ();
#line 3710 "chess-view-3d.c"
			}
		}
	}
#line 584 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glFlush ();
#line 585 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp62_ = glRenderMode (GL_RENDER);
#line 585 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	n_hits = _tmp62_;
#line 587 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp63_ = n_hits;
#line 587 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp63_ > ((GLint) 0)) {
#line 3724 "chess-view-3d.c"
		gint rank = 0;
		GLuint _tmp64_ = 0U;
		gint file = 0;
		GLuint _tmp65_ = 0U;
		ChessScene* _tmp66_ = NULL;
		ChessScene* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
#line 589 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp64_ = buffer[3];
#line 589 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		rank = (gint) _tmp64_;
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp65_ = buffer[4];
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		file = (gint) _tmp65_;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp66_ = chess_view_get_scene ((ChessView*) self);
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp67_ = _tmp66_;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp68_ = file;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp69_ = rank;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		chess_scene_select_square (_tmp67_, _tmp68_, _tmp69_);
#line 3751 "chess-view-3d.c"
	}
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = TRUE;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	viewport = (g_free (viewport), NULL);
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 3759 "chess-view-3d.c"
}


static void chess_view3_d_transform_camera (ChessView3D* self) {
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glLoadIdentity ();
#line 600 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gluLookAt ((GLdouble) 0.0, (GLdouble) 80.0, (GLdouble) 40.0, (GLdouble) 0.0, (GLdouble) 0.0, (GLdouble) 5.0, (GLdouble) 0.0, (GLdouble) 1.0, (GLdouble) 0.0);
#line 3770 "chess-view-3d.c"
}


static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename) {
	GLuint result = 0U;
	GdkPixbuf* pixbuf = NULL;
	GLenum format = 0U;
	GdkPixbuf* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GLuint textures[1] = {0};
	GLuint t = 0U;
	GLuint _tmp15_ = 0U;
	GLuint _tmp16_ = 0U;
	GdkPixbuf* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GdkPixbuf* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GdkPixbuf* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GLenum _tmp26_ = 0U;
	GdkPixbuf* _tmp27_ = NULL;
	void* _tmp28_ = NULL;
	void* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (filename != NULL, 0U);
#line 3803 "chess-view-3d.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = filename;
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_, &_inner_error_);
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp0_ = _tmp2_;
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_inner_error_ != NULL) {
#line 3816 "chess-view-3d.c"
			goto __catch19_g_error;
		}
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (pixbuf);
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		pixbuf = _tmp0_;
#line 3823 "chess-view-3d.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		e = _inner_error_;
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_inner_error_ = NULL;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp3_ = filename;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp4_ = e;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp5_ = _tmp4_->message;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_warning ("chess-view-3d.vala:614: Error loading texture %s: %s", _tmp3_, _tmp5_);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		result = (GLuint) 0;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_error_free0 (e);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (pixbuf);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return result;
#line 3852 "chess-view-3d.c"
	}
	__finally19:
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_inner_error_ != NULL) {
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_object_unref0 (pixbuf);
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		g_clear_error (&_inner_error_);
#line 608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		return 0U;
#line 3865 "chess-view-3d.c"
	}
#line 619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = pixbuf;
#line 619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = gdk_pixbuf_get_n_channels (_tmp6_);
#line 619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = _tmp7_;
#line 619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp8_ == 1) {
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		format = GL_LUMINANCE;
#line 3877 "chess-view-3d.c"
	} else {
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp9_ = pixbuf;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp10_ = gdk_pixbuf_get_n_channels (_tmp9_);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp11_ = _tmp10_;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		if (_tmp11_ == 3) {
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			format = GL_RGB;
#line 3892 "chess-view-3d.c"
		} else {
			GdkPixbuf* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp12_ = pixbuf;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp13_ = gdk_pixbuf_get_n_channels (_tmp12_);
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp14_ = _tmp13_;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			if (_tmp14_ == 4) {
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				format = GL_RGBA;
#line 3907 "chess-view-3d.c"
			} else {
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				g_warning ("chess-view-3d.vala:627: Unknown format image");
#line 628 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				result = (GLuint) 0;
#line 628 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_g_object_unref0 (pixbuf);
#line 628 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				return result;
#line 3917 "chess-view-3d.c"
			}
		}
	}
#line 632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glGenTextures ((GLsizei) 1, textures);
#line 633 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = textures[0];
#line 633 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	t = _tmp15_;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = t;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBindTexture (GL_TEXTURE_2D, _tmp16_);
#line 635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
#line 636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
#line 637 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = pixbuf;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = gdk_pixbuf_get_n_channels (_tmp17_);
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = _tmp18_;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_ = pixbuf;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp22_ = _tmp21_;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp23_ = pixbuf;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp25_ = _tmp24_;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp26_ = format;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp27_ = pixbuf;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp28_ = gdk_pixbuf_get_pixels (_tmp27_);
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp29_ = _tmp28_;
#line 641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) _tmp19_, (GLsizei) _tmp22_, (GLsizei) _tmp25_, _tmp26_, GL_UNSIGNED_BYTE, _tmp29_);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = t;
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_g_object_unref0 (pixbuf);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 3975 "chess-view-3d.c"
}


static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self) {
	GLuint result = 0U;
	gint width = 0;
	gint height = 0;
	gint texture_width = 0;
	gint _tmp0_ = 0;
	gint texture_height = 0;
	gint _tmp1_ = 0;
	cairo_surface_t* surface = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_t* c = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	cairo_font_extents_t extents = {0};
	cairo_t* _tmp11_ = NULL;
	cairo_font_extents_t _tmp12_ = {0};
	gdouble scale = 0.0;
	gint _tmp13_ = 0;
	cairo_font_extents_t _tmp14_ = {0};
	gdouble _tmp15_ = 0.0;
	cairo_font_extents_t _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	gdouble yoffset = 0.0;
	gint _tmp18_ = 0;
	gdouble xoffset = 0.0;
	gint _tmp19_ = 0;
	GLuint textures[1] = {0};
	GLuint t = 0U;
	GLuint _tmp41_ = 0U;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	cairo_surface_t* _tmp44_ = NULL;
	guchar* _tmp45_ = NULL;
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 651 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	width = 64;
#line 651 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	height = 64;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = width;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	texture_width = _tmp0_ * 16;
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = height;
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	texture_height = _tmp1_;
#line 655 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = texture_width;
#line 655 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = texture_height;
#line 655 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_A8, _tmp2_, _tmp3_);
#line 655 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	surface = _tmp4_;
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = surface;
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = cairo_create (_tmp5_);
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	c = _tmp6_;
#line 657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = c;
#line 657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_set_source_rgba (_tmp7_, 1.0, 1.0, 1.0, 1.0);
#line 658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = c;
#line 658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_select_font_face (_tmp8_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = c;
#line 659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = width;
#line 659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_set_font_size (_tmp9_, (gdouble) _tmp10_);
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = c;
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_font_extents (_tmp11_, &_tmp12_);
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	extents = _tmp12_;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp13_ = width;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp14_ = extents;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = _tmp14_.height;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = extents;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = _tmp16_.descent;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	scale = _tmp13_ / (_tmp15_ + _tmp17_);
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = height;
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	yoffset = _tmp18_ * 0.5;
#line 665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = width;
#line 665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	xoffset = _tmp19_ * 0.5;
#line 4086 "chess-view-3d.c"
	{
		gint i = 0;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		i = 0;
#line 4091 "chess-view-3d.c"
		{
			gboolean _tmp20_ = FALSE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			_tmp20_ = TRUE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
			while (TRUE) {
#line 4098 "chess-view-3d.c"
				gboolean _tmp21_ = FALSE;
				gint _tmp23_ = 0;
				gchar* f = NULL;
				gint _tmp24_ = 0;
				gchar* _tmp25_ = NULL;
				gchar* r = NULL;
				gint _tmp26_ = 0;
				gchar* _tmp27_ = NULL;
				cairo_t* _tmp28_ = NULL;
				gdouble _tmp29_ = 0.0;
				gdouble _tmp30_ = 0.0;
				gdouble _tmp31_ = 0.0;
				const gchar* _tmp32_ = NULL;
				cairo_t* _tmp33_ = NULL;
				gdouble _tmp34_ = 0.0;
				gint _tmp35_ = 0;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp37_ = 0.0;
				const gchar* _tmp38_ = NULL;
				gdouble _tmp39_ = 0.0;
				gint _tmp40_ = 0;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp21_ = _tmp20_;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!_tmp21_) {
#line 4124 "chess-view-3d.c"
					gint _tmp22_ = 0;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					_tmp22_ = i;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					i = _tmp22_ + 1;
#line 4130 "chess-view-3d.c"
				}
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp20_ = FALSE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp23_ = i;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				if (!(_tmp23_ < 8)) {
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
					break;
#line 4140 "chess-view-3d.c"
				}
#line 668 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp24_ = i;
#line 668 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp25_ = g_strdup_printf ("%c", 'a' + _tmp24_);
#line 668 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				f = _tmp25_;
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp26_ = i;
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp27_ = g_strdup_printf ("%c", '1' + _tmp26_);
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				r = _tmp27_;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp28_ = c;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp29_ = xoffset;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp30_ = yoffset;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp31_ = scale;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp32_ = f;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_centered_text (self, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp33_ = c;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp34_ = xoffset;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp35_ = width;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp36_ = yoffset;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp37_ = scale;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp38_ = r;
#line 671 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				chess_view3_d_draw_centered_text (self, _tmp33_, _tmp34_ + (_tmp35_ * 8), _tmp36_, _tmp37_, _tmp38_);
#line 672 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp39_ = xoffset;
#line 672 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_tmp40_ = width;
#line 672 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				xoffset = _tmp39_ + _tmp40_;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_g_free0 (r);
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
				_g_free0 (f);
#line 4190 "chess-view-3d.c"
			}
		}
	}
#line 676 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glGenTextures ((GLsizei) 1, textures);
#line 677 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp41_ = textures[0];
#line 677 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	t = _tmp41_;
#line 678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glBindTexture (GL_TEXTURE_2D, t);
#line 679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
#line 681 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
#line 683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp42_ = texture_width;
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp43_ = texture_height;
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp44_ = surface;
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp45_ = cairo_image_surface_get_data (_tmp44_);
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) GL_ALPHA, (GLsizei) _tmp42_, (GLsizei) _tmp43_, GL_ALPHA, GL_UNSIGNED_BYTE, _tmp45_);
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = t;
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_cairo_destroy0 (c);
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_cairo_surface_destroy0 (surface);
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 4230 "chess-view-3d.c"
}


static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text) {
	cairo_text_extents_t char_extents = {0};
	cairo_t* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	cairo_text_extents_t _tmp2_ = {0};
	cairo_text_extents_t fake_extents = {0};
	cairo_t* _tmp3_ = NULL;
	cairo_text_extents_t _tmp4_ = {0};
	cairo_t* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	cairo_t* _tmp9_ = NULL;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_text_extents_t _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	cairo_t* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
#line 693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (self != NULL);
#line 693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (c != NULL);
#line 693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_if_fail (text != NULL);
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = c;
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp1_ = text;
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_text_extents (_tmp0_, _tmp1_, &_tmp2_);
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	char_extents = _tmp2_;
#line 699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp3_ = c;
#line 699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_text_extents (_tmp3_, "abcdefgh", &_tmp4_);
#line 699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	fake_extents = _tmp4_;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp5_ = c;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_save (_tmp5_);
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp6_ = c;
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp7_ = x;
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp8_ = y;
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_translate (_tmp6_, _tmp7_, _tmp8_);
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp9_ = c;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp10_ = char_extents;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp11_ = _tmp10_.width;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp12_ = scale;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp13_ = fake_extents;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp14_ = _tmp13_.height;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp15_ = scale;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_move_to (_tmp9_, ((-_tmp11_) * _tmp12_) / 2, (_tmp14_ * _tmp15_) / 2);
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp16_ = c;
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp17_ = scale;
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp18_ = scale;
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_scale (_tmp16_, _tmp17_, _tmp18_);
#line 704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp19_ = c;
#line 704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp20_ = text;
#line 704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_show_text (_tmp19_, _tmp20_);
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp21_ = c;
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	cairo_restore (_tmp21_);
#line 4325 "chess-view-3d.c"
}


static GLuint chess_view3_d_get_board_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_ = 0U;
	GLuint _tmp4_ = 0U;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->_board_texture;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp0_ == ((GLuint) 0)) {
#line 4339 "chess-view-3d.c"
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GLuint _tmp3_ = 0U;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = g_build_filename (PKGDATADIR, "textures", "board.png", NULL, NULL);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp2_ = _tmp1_;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp3_ = chess_view3_d_load_texture (self, _tmp2_);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->_board_texture = _tmp3_;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp2_);
#line 4353 "chess-view-3d.c"
	}
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->_board_texture;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = _tmp4_;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 4361 "chess-view-3d.c"
}


static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_ = 0U;
	GLuint _tmp2_ = 0U;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->_numbering_texture;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp0_ == ((GLuint) 0)) {
#line 4375 "chess-view-3d.c"
		GLuint _tmp1_ = 0U;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = chess_view3_d_make_numbering_texture (self);
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->_numbering_texture = _tmp1_;
#line 4381 "chess-view-3d.c"
	}
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp2_ = self->priv->_numbering_texture;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = _tmp2_;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 4389 "chess-view-3d.c"
}


static GLuint chess_view3_d_get_piece_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_ = 0U;
	GLuint _tmp4_ = 0U;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp0_ = self->priv->_piece_texture;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	if (_tmp0_ == ((GLuint) 0)) {
#line 4403 "chess-view-3d.c"
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GLuint _tmp3_ = 0U;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp1_ = g_build_filename (PKGDATADIR, "textures", "piece.png", NULL, NULL);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp2_ = _tmp1_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_tmp3_ = chess_view3_d_load_texture (self, _tmp2_);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		self->priv->_piece_texture = _tmp3_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		_g_free0 (_tmp2_);
#line 4417 "chess-view-3d.c"
	}
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tmp4_ = self->priv->_piece_texture;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	result = _tmp4_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	return result;
#line 4425 "chess-view-3d.c"
}


static void chess_view3_d_class_init (ChessView3DClass * klass) {
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	chess_view3_d_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	g_type_class_add_private (klass, sizeof (ChessView3DPrivate));
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view3_d_real_configure_event;
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	GTK_WIDGET_CLASS (klass)->draw = chess_view3_d_real_draw;
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view3_d_real_button_press_event;
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view3_d_get_property;
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_view3_d_finalize;
#line 4444 "chess-view-3d.c"
}


static void chess_view3_d_instance_init (ChessView3D * self) {
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv = CHESS_VIEW3_D_GET_PRIVATE (self);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->context = (GLXContext) NULL;
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->border = 6;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_board_texture = (GLuint) 0;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_numbering_texture = (GLuint) 0;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->_piece_texture = (GLuint) 0;
#line 4461 "chess-view-3d.c"
}


static void chess_view3_d_finalize (GObject* obj) {
	ChessView3D * self;
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW3_D, ChessView3D);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->pawn_model);
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->knight_model);
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->bishop_model);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->rook_model);
#line 27 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->queen_model);
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	_tds_model_unref0 (self->priv->king_model);
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
#line 31 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	G_OBJECT_CLASS (chess_view3_d_parent_class)->finalize (obj);
#line 4489 "chess-view-3d.c"
}


GType chess_view3_d_get_type (void) {
	static volatile gsize chess_view3_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view3_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView3DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view3_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView3D), 0, (GInstanceInitFunc) chess_view3_d_instance_init, NULL };
		GType chess_view3_d_type_id;
		chess_view3_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView3D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view3_d_type_id__volatile, chess_view3_d_type_id);
	}
	return chess_view3_d_type_id__volatile;
}


static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView3D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW3_D, ChessView3D);
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
	switch (property_id) {
#line 4510 "chess-view-3d.c"
		default:
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-3d.vala"
		break;
#line 4516 "chess-view-3d.c"
	}
}



