/* chess-engine-cecp.c generated by valac 0.22.1.2-49127, the Vala compiler
 * generated from chess-engine-cecp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;
typedef struct _ChessEngineCECPPrivate ChessEngineCECPPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEngineCECP {
	ChessEngine parent_instance;
	ChessEngineCECPPrivate * priv;
};

struct _ChessEngineCECPClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineCECPPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gboolean moving;
	gchar** options;
	gint options_length1;
	gint _options_size_;
};


static gpointer chess_engine_cecp_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_CECP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPPrivate))
enum  {
	CHESS_ENGINE_CECP_DUMMY_PROPERTY
};
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1);
static gchar** _vala_array_dup21 (gchar** self, int length);
static void chess_engine_cecp_start_cb (ChessEngineCECP* self);
static void _chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_cecp_real_process_input (ChessEngine* base, gchar* data, int data_length1);
void chess_engine_stop (ChessEngine* self);
static gchar* _vala_array_dup22 (gchar* self, int length);
static void chess_engine_cecp_real_start_game (ChessEngine* base);
static void chess_engine_cecp_real_request_move (ChessEngine* base);
static void chess_engine_cecp_real_report_move (ChessEngine* base, ChessMove* move);
gchar* chess_move_get_engine (ChessMove* self);
static void chess_engine_cecp_real_undo (ChessEngine* base);
static void chess_engine_cecp_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup21 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
	chess_engine_cecp_start_cb (self);
}


ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1) {
	ChessEngineCECP * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (binary != NULL, NULL);
	_tmp0_ = binary;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	self = (ChessEngineCECP*) chess_engine_construct (object_type, _tmp0_, _tmp1_, _tmp1__length1);
	_tmp2_ = options;
	_tmp2__length1 = options_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup21 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp3_;
	self->priv->options_length1 = _tmp3__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_cecp_start_cb_chess_engine_starting, self, 0);
	return self;
}


ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1) {
	return chess_engine_cecp_construct (TYPE_CHESS_ENGINE_CECP, binary, args, args_length1, options, options_length1);
}


static void chess_engine_cecp_start_cb (ChessEngineCECP* self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "xboard");
	chess_engine_write_line ((ChessEngine*) self, "random");
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < _tmp0__length1; o_it = o_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				_tmp2_ = o;
				chess_engine_write_line ((ChessEngine*) self, _tmp2_);
				_g_free0 (o);
			}
		}
	}
	chess_engine_set_ready ((ChessEngine*) self, TRUE);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* _vala_array_dup22 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static void chess_engine_cecp_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineCECP * self;
	gint current = 0;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	self = (ChessEngineCECP*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = (gint) (_tmp1__length1 + _tmp2__length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + _tmp2__length1));
	(_tmp3_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp3_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp3_;
	self->priv->_buffer_size_ = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gint _tmp7_ = 0;
				gchar* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gchar* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gchar* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gchar _tmp15_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = data;
				_tmp8__length1 = data_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->priv->buffer;
				_tmp9__length1 = self->priv->buffer_length1;
				_tmp10_ = current;
				_tmp11_ = i;
				_tmp12_ = data;
				_tmp12__length1 = data_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
				_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gint _tmp26_ = 0;
		gchar* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gchar* line = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar** move_prefixes = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar** _tmp38_ = NULL;
		gint move_prefixes_length1 = 0;
		gint _move_prefixes_size_ = 0;
		gchar** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gboolean _tmp56_ = FALSE;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		const gchar* _tmp59_ = NULL;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp75_ = FALSE;
		gchar* _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		gint _tmp97_ = 0;
		gchar* _tmp98_ = NULL;
		gint _tmp98__length1 = 0;
		gchar* _tmp99_ = NULL;
		gint _tmp99__length1 = 0;
		{
			gboolean _tmp16_ = FALSE;
			offset = 0;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gint _tmp20_ = 0;
				gchar* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gboolean _tmp25_ = FALSE;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = offset;
					offset = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp20_ = offset;
				_tmp21_ = self->priv->buffer;
				_tmp21__length1 = self->priv->buffer_length1;
				if (_tmp20_ < _tmp21__length1) {
					gchar* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
					_tmp22_ = self->priv->buffer;
					_tmp22__length1 = self->priv->buffer_length1;
					_tmp23_ = offset;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp19_ = _tmp24_ != '\n';
				} else {
					_tmp19_ = FALSE;
				}
				_tmp25_ = _tmp19_;
				if (!_tmp25_) {
					break;
				}
			}
		}
		_tmp26_ = offset;
		_tmp27_ = self->priv->buffer;
		_tmp27__length1 = self->priv->buffer_length1;
		if (_tmp26_ >= _tmp27__length1) {
			return;
		}
		_tmp28_ = self->priv->buffer;
		_tmp28__length1 = self->priv->buffer_length1;
		_tmp29_ = offset;
		_tmp28_[_tmp29_] = '\0';
		_tmp30_ = _tmp28_[_tmp29_];
		_tmp31_ = self->priv->buffer;
		_tmp31__length1 = self->priv->buffer_length1;
		_tmp32_ = g_strdup ((const gchar*) _tmp31_);
		line = _tmp32_;
		_tmp33_ = line;
		g_debug ("chess-engine-cecp.vala:54: Read from engine: '%s'", _tmp33_);
		_tmp34_ = g_strdup ("My move is: ");
		_tmp35_ = g_strdup ("My move is : ");
		_tmp36_ = g_strdup ("my move is ");
		_tmp37_ = g_strdup ("move ");
		_tmp38_ = g_new0 (gchar*, 4 + 1);
		_tmp38_[0] = _tmp34_;
		_tmp38_[1] = _tmp35_;
		_tmp38_[2] = _tmp36_;
		_tmp38_[3] = _tmp37_;
		move_prefixes = _tmp38_;
		move_prefixes_length1 = 4;
		_move_prefixes_size_ = move_prefixes_length1;
		_tmp39_ = move_prefixes;
		_tmp39__length1 = move_prefixes_length1;
		{
			gchar** prefix_collection = NULL;
			gint prefix_collection_length1 = 0;
			gint _prefix_collection_size_ = 0;
			gint prefix_it = 0;
			prefix_collection = _tmp39_;
			prefix_collection_length1 = _tmp39__length1;
			for (prefix_it = 0; prefix_it < _tmp39__length1; prefix_it = prefix_it + 1) {
				gchar* _tmp40_ = NULL;
				gchar* prefix = NULL;
				_tmp40_ = g_strdup (prefix_collection[prefix_it]);
				prefix = _tmp40_;
				{
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gboolean _tmp43_ = FALSE;
					_tmp41_ = line;
					_tmp42_ = prefix;
					_tmp43_ = g_str_has_prefix (_tmp41_, _tmp42_);
					if (_tmp43_) {
						gchar* move = NULL;
						const gchar* _tmp44_ = NULL;
						const gchar* _tmp45_ = NULL;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						const gchar* _tmp48_ = NULL;
						gint _tmp49_ = 0;
						gint _tmp50_ = 0;
						gchar* _tmp51_ = NULL;
						const gchar* _tmp52_ = NULL;
						const gchar* _tmp53_ = NULL;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						_tmp44_ = line;
						_tmp45_ = prefix;
						_tmp46_ = strlen (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = line;
						_tmp49_ = strlen (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp51_ = string_slice (_tmp44_, (glong) _tmp47_, (glong) _tmp50_);
						move = _tmp51_;
						_tmp52_ = move;
						g_debug ("chess-engine-cecp.vala:62: Engine moves %s", _tmp52_);
						self->priv->moving = TRUE;
						_tmp53_ = move;
						_tmp54_ = string_strip (_tmp53_);
						_tmp55_ = _tmp54_;
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp55_);
						_g_free0 (_tmp55_);
						_g_free0 (move);
					}
					_g_free0 (prefix);
				}
			}
		}
		_tmp59_ = line;
		if (g_strcmp0 (_tmp59_, "resign") == 0) {
			_tmp58_ = TRUE;
		} else {
			const gchar* _tmp60_ = NULL;
			_tmp60_ = line;
			_tmp58_ = g_strcmp0 (_tmp60_, "tellics resign") == 0;
		}
		_tmp61_ = _tmp58_;
		if (_tmp61_) {
			_tmp57_ = TRUE;
		} else {
			gboolean _tmp62_ = FALSE;
			const gchar* _tmp63_ = NULL;
			gboolean _tmp64_ = FALSE;
			gboolean _tmp67_ = FALSE;
			_tmp63_ = line;
			_tmp64_ = g_str_has_prefix (_tmp63_, "1-0 {");
			if (_tmp64_) {
				const gchar* _tmp65_ = NULL;
				gboolean _tmp66_ = FALSE;
				_tmp65_ = line;
				_tmp66_ = string_contains (_tmp65_, "resign");
				_tmp62_ = _tmp66_;
			} else {
				_tmp62_ = FALSE;
			}
			_tmp67_ = _tmp62_;
			_tmp57_ = _tmp67_;
		}
		_tmp68_ = _tmp57_;
		if (_tmp68_) {
			_tmp56_ = TRUE;
		} else {
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			gboolean _tmp74_ = FALSE;
			_tmp70_ = line;
			_tmp71_ = g_str_has_prefix (_tmp70_, "0-1 {");
			if (_tmp71_) {
				const gchar* _tmp72_ = NULL;
				gboolean _tmp73_ = FALSE;
				_tmp72_ = line;
				_tmp73_ = string_contains (_tmp72_, "resign");
				_tmp69_ = _tmp73_;
			} else {
				_tmp69_ = FALSE;
			}
			_tmp74_ = _tmp69_;
			_tmp56_ = _tmp74_;
		}
		_tmp75_ = _tmp56_;
		if (_tmp75_) {
			g_signal_emit_by_name ((ChessEngine*) self, "resigned");
		} else {
			const gchar* _tmp76_ = NULL;
			gboolean _tmp77_ = FALSE;
			_tmp76_ = line;
			_tmp77_ = g_str_has_prefix (_tmp76_, "Illegal move: ");
			if (_tmp77_) {
				chess_engine_stop ((ChessEngine*) self);
				g_signal_emit_by_name ((ChessEngine*) self, "error");
			} else {
				gboolean _tmp78_ = FALSE;
				const gchar* _tmp79_ = NULL;
				gboolean _tmp80_ = FALSE;
				gboolean _tmp83_ = FALSE;
				_tmp79_ = line;
				_tmp80_ = g_str_has_prefix (_tmp79_, "1-0");
				if (_tmp80_) {
					_tmp78_ = TRUE;
				} else {
					const gchar* _tmp81_ = NULL;
					gboolean _tmp82_ = FALSE;
					_tmp81_ = line;
					_tmp82_ = g_str_has_prefix (_tmp81_, "0-1");
					_tmp78_ = _tmp82_;
				}
				_tmp83_ = _tmp78_;
				if (_tmp83_) {
					chess_engine_stop ((ChessEngine*) self);
				} else {
					gboolean _tmp84_ = FALSE;
					gboolean _tmp85_ = FALSE;
					gboolean _tmp86_ = FALSE;
					const gchar* _tmp87_ = NULL;
					gboolean _tmp89_ = FALSE;
					gboolean _tmp91_ = FALSE;
					gboolean _tmp94_ = FALSE;
					_tmp87_ = line;
					if (g_strcmp0 (_tmp87_, "game is a draw") == 0) {
						_tmp86_ = TRUE;
					} else {
						const gchar* _tmp88_ = NULL;
						_tmp88_ = line;
						_tmp86_ = g_strcmp0 (_tmp88_, "draw") == 0;
					}
					_tmp89_ = _tmp86_;
					if (_tmp89_) {
						_tmp85_ = TRUE;
					} else {
						const gchar* _tmp90_ = NULL;
						_tmp90_ = line;
						_tmp85_ = g_strcmp0 (_tmp90_, "Draw") == 0;
					}
					_tmp91_ = _tmp85_;
					if (_tmp91_) {
						_tmp84_ = TRUE;
					} else {
						const gchar* _tmp92_ = NULL;
						gboolean _tmp93_ = FALSE;
						_tmp92_ = line;
						_tmp93_ = g_str_has_prefix (_tmp92_, "1/2-1/2");
						_tmp84_ = _tmp93_;
					}
					_tmp94_ = _tmp84_;
					if (_tmp94_) {
						g_signal_emit_by_name ((ChessEngine*) self, "claim-draw");
					} else {
						const gchar* _tmp95_ = NULL;
						_tmp95_ = line;
						if (g_strcmp0 (_tmp95_, "offer draw") == 0) {
							g_signal_emit_by_name ((ChessEngine*) self, "offer-draw");
						}
					}
				}
			}
		}
		_tmp96_ = self->priv->buffer;
		_tmp96__length1 = self->priv->buffer_length1;
		_tmp97_ = offset;
		_tmp98_ = self->priv->buffer;
		_tmp98__length1 = self->priv->buffer_length1;
		_tmp99_ = ((_tmp96_ + (_tmp97_ + 1)) != NULL) ? _vala_array_dup22 (_tmp96_ + (_tmp97_ + 1), _tmp98__length1 - (_tmp97_ + 1)) : ((gpointer) (_tmp96_ + (_tmp97_ + 1)));
		_tmp99__length1 = _tmp98__length1 - (_tmp97_ + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp99_;
		self->priv->buffer_length1 = _tmp99__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		move_prefixes = (_vala_array_free (move_prefixes, move_prefixes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}


static void chess_engine_cecp_real_start_game (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
}


static void chess_engine_cecp_real_request_move (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "go");
}


static void chess_engine_cecp_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineCECP * self;
	gboolean _tmp0_ = FALSE;
	self = (ChessEngineCECP*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->moving;
	if (!_tmp0_) {
		ChessMove* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		chess_engine_write_line ((ChessEngine*) self, "force");
		_tmp1_ = move;
		_tmp2_ = chess_move_get_engine (_tmp1_);
		_tmp3_ = _tmp2_;
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	self->priv->moving = FALSE;
}


static void chess_engine_cecp_real_undo (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "force");
	chess_engine_write_line ((ChessEngine*) self, "undo");
}


static void chess_engine_cecp_class_init (ChessEngineCECPClass * klass) {
	chess_engine_cecp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEngineCECPPrivate));
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_cecp_real_process_input;
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_cecp_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_cecp_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_cecp_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_cecp_real_undo;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_cecp_finalize;
}


static void chess_engine_cecp_instance_init (ChessEngineCECP * self) {
	self->priv = CHESS_ENGINE_CECP_GET_PRIVATE (self);
	self->priv->moving = FALSE;
}


static void chess_engine_cecp_finalize (GObject* obj) {
	ChessEngineCECP * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_CECP, ChessEngineCECP);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (chess_engine_cecp_parent_class)->finalize (obj);
}


GType chess_engine_cecp_get_type (void) {
	static volatile gsize chess_engine_cecp_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_cecp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineCECPClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_cecp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineCECP), 0, (GInstanceInitFunc) chess_engine_cecp_instance_init, NULL };
		GType chess_engine_cecp_type_id;
		chess_engine_cecp_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineCECP", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_cecp_type_id__volatile, chess_engine_cecp_type_id);
	}
	return chess_engine_cecp_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



