/* game-view.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_PLAYER (player_get_type ())

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
	gboolean _show_grid;
	gboolean _flip_final_result;
};

struct _Block1Data {
	int _ref_count_;
	GameView * self;
	gint x;
	gint y;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_SHOW_GRID,
	GAME_VIEW_FLIP_FINAL_RESULT
};
#define GAME_VIEW_GRID_WIDTH 1
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
Game* game_view_get_game (GameView* self);
static gint game_view_get_tile_size (GameView* self);
static void game_view_load_theme (GameView* self, cairo_t* c);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
gboolean game_view_get_show_grid (GameView* self);
static gint game_view_get_board_size (GameView* self);
const gchar* game_view_get_theme (GameView* self);
void game_view_redraw (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_is_complete (Game* self);
gint game_get_width (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
gboolean game_view_get_flip_final_result (GameView* self);
static gboolean ___lambda2_ (Block1Data* _data1_);
static gboolean ____lambda2__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
gint game_get_height (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	gint* _tmp0_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 62 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = g_new0 (gint, 8 * 8);
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->pixmaps = _tmp0_;
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->pixmaps_length1 = 8;
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->pixmaps_length2 = 8;
#line 60 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return self;
#line 171 "game-view.c"
}


GameView* game_view_new (void) {
#line 60 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 178 "game-view.c"
}


static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 117 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
#line 117 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_vala_minimum = _vala_natural;
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (minimum) {
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		*minimum = _vala_minimum;
#line 196 "game-view.c"
	}
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (natural) {
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		*natural = _vala_natural;
#line 202 "game-view.c"
	}
}


static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 122 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
#line 122 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_vala_minimum = _vala_natural;
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (minimum) {
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		*minimum = _vala_minimum;
#line 221 "game-view.c"
	}
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (natural) {
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		*natural = _vala_natural;
#line 227 "game-view.c"
	}
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
#line 125 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 125 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 127 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 127 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 127 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 128 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		result = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return result;
#line 256 "game-view.c"
	}
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp2_ = TRUE;
#line 264 "game-view.c"
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp4_ = self->priv->render_size;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = game_view_get_tile_size (self);
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp2_ = _tmp4_ != ((guint) _tmp6_);
#line 277 "game-view.c"
	}
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp7_ = _tmp2_;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp7_) {
#line 283 "game-view.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp10_ = NULL;
		cairo_surface_t* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		cairo_surface_t* _tmp16_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp17_ = NULL;
		cairo_t* _tmp18_ = NULL;
		cairo_t* _tmp19_ = NULL;
		cairo_surface_t* _tmp20_ = NULL;
		cairo_pattern_t* _tmp21_ = NULL;
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = game_view_get_tile_size (self);
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp9_ = _tmp8_;
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		self->priv->render_size = (guint) _tmp9_;
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp10_ = cr;
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp11_ = cairo_get_target (_tmp10_);
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_tile_size (self);
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp14_ = game_view_get_tile_size (self);
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp15_ = _tmp14_;
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp16_ = cairo_surface_create_similar (_tmp11_, CAIRO_CONTENT_COLOR_ALPHA, _tmp13_ * 8, _tmp15_ * 4);
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		surface = _tmp16_;
#line 134 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp17_ = surface;
#line 134 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18_ = cairo_create (_tmp17_);
#line 134 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		c = _tmp18_;
#line 135 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp19_ = c;
#line 135 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		game_view_load_theme (self, _tmp19_);
#line 136 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp20_ = surface;
#line 136 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp21_ = cairo_pattern_create_for_surface (_tmp20_);
#line 136 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 136 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		self->priv->tiles_pattern = _tmp21_;
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_cairo_destroy0 (c);
#line 130 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 344 "game-view.c"
	}
	{
		gint x = 0;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		x = 0;
#line 350 "game-view.c"
		{
			gboolean _tmp22_ = FALSE;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22_ = TRUE;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			while (TRUE) {
#line 357 "game-view.c"
				gboolean _tmp23_ = FALSE;
				gint _tmp25_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp23_ = _tmp22_;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!_tmp23_) {
#line 364 "game-view.c"
					gint _tmp24_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp24_ = x;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					x = _tmp24_ + 1;
#line 370 "game-view.c"
				}
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp22_ = FALSE;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp25_ = x;
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!(_tmp25_ < 8)) {
#line 139 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					break;
#line 380 "game-view.c"
				}
				{
					gint y = 0;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					y = 0;
#line 386 "game-view.c"
					{
						gboolean _tmp26_ = FALSE;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						_tmp26_ = TRUE;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						while (TRUE) {
#line 393 "game-view.c"
							gboolean _tmp27_ = FALSE;
							gint _tmp29_ = 0;
							gint tile_x = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint tile_y = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint texture_x = 0;
							gint* _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							gint _tmp40__length2 = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint texture_y = 0;
							gint* _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							cairo_pattern_t* _tmp56_ = NULL;
							cairo_matrix_t _tmp57_ = {0};
							cairo_t* _tmp58_ = NULL;
							cairo_pattern_t* _tmp59_ = NULL;
							cairo_t* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							gint _tmp62_ = 0;
							gint _tmp63_ = 0;
							gint _tmp64_ = 0;
							gint _tmp65_ = 0;
							gint _tmp66_ = 0;
							cairo_t* _tmp67_ = NULL;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp27_ = _tmp26_;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!_tmp27_) {
#line 447 "game-view.c"
								gint _tmp28_ = 0;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp28_ = y;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								y = _tmp28_ + 1;
#line 453 "game-view.c"
							}
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp26_ = FALSE;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp29_ = y;
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!(_tmp29_ < 8)) {
#line 141 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								break;
#line 463 "game-view.c"
							}
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp30_ = game_view_get_x_offset (self);
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp31_ = _tmp30_;
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp32_ = x;
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp33_ = game_view_get_tile_size (self);
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp34_ = _tmp33_;
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							tile_x = _tmp31_ + (_tmp32_ * (_tmp34_ + GAME_VIEW_GRID_WIDTH));
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp35_ = game_view_get_y_offset (self);
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp36_ = _tmp35_;
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp37_ = y;
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp38_ = game_view_get_tile_size (self);
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp39_ = _tmp38_;
#line 144 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							tile_y = _tmp36_ + (_tmp37_ * (_tmp39_ + GAME_VIEW_GRID_WIDTH));
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp40_ = self->priv->pixmaps;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp40__length1 = self->priv->pixmaps_length1;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp40__length2 = self->priv->pixmaps_length2;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp41_ = x;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp42_ = y;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp43_ = _tmp40_[(_tmp41_ * _tmp40__length2) + _tmp42_];
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp44_ = game_view_get_tile_size (self);
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp45_ = _tmp44_;
#line 145 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							texture_x = (_tmp43_ % 8) * _tmp45_;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp46_ = self->priv->pixmaps;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp46__length1 = self->priv->pixmaps_length1;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp46__length2 = self->priv->pixmaps_length2;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp47_ = x;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp48_ = y;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp50_ = game_view_get_tile_size (self);
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp51_ = _tmp50_;
#line 146 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							texture_y = (_tmp49_ / 8) * _tmp51_;
#line 148 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp52_ = texture_x;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp53_ = tile_x;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp54_ = texture_y;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp55_ = tile_y;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp52_ - _tmp53_), (gdouble) (_tmp54_ - _tmp55_));
#line 150 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp56_ = self->priv->tiles_pattern;
#line 150 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp57_ = matrix;
#line 150 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_pattern_set_matrix (_tmp56_, &_tmp57_);
#line 151 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp58_ = cr;
#line 151 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp59_ = self->priv->tiles_pattern;
#line 151 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_set_source (_tmp58_, _tmp59_);
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp60_ = cr;
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp61_ = tile_x;
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp62_ = tile_y;
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp63_ = game_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp64_ = _tmp63_;
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp65_ = game_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp66_ = _tmp65_;
#line 152 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_rectangle (_tmp60_, (gdouble) _tmp61_, (gdouble) _tmp62_, (gdouble) _tmp64_, (gdouble) _tmp66_);
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp67_ = cr;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							cairo_fill (_tmp67_);
#line 569 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 157 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp68_ = game_view_get_show_grid (self);
#line 157 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp69_ = _tmp68_;
#line 157 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp69_) {
#line 582 "game-view.c"
		gint dash_count = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		gdouble dash[1] = {0};
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		gdouble _tmp77_ = 0.0;
		cairo_t* _tmp78_ = NULL;
		cairo_t* _tmp79_ = NULL;
		cairo_t* _tmp80_ = NULL;
		cairo_t* _tmp81_ = NULL;
		cairo_t* _tmp108_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp70_ = game_view_get_tile_size (self);
#line 161 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp71_ = _tmp70_;
#line 161 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		dash_count = (_tmp71_ + GAME_VIEW_GRID_WIDTH) / 4;
#line 162 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp72_ = dash_count;
#line 162 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if ((_tmp72_ % 2) != 0) {
#line 607 "game-view.c"
			gint _tmp73_ = 0;
#line 163 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp73_ = dash_count;
#line 163 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			dash_count = _tmp73_ - 1;
#line 613 "game-view.c"
		}
#line 165 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp74_ = game_view_get_tile_size (self);
#line 165 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp75_ = _tmp74_;
#line 165 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp76_ = dash_count;
#line 165 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		dash[0] = ((gdouble) (_tmp75_ + GAME_VIEW_GRID_WIDTH)) / _tmp76_;
#line 165 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp77_ = dash[0];
#line 166 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp78_ = cr;
#line 166 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_set_dash (_tmp78_, dash, 1, 2.5);
#line 168 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp79_ = cr;
#line 168 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_set_source_rgb (_tmp79_, 1.0, 1.0, 1.0);
#line 169 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp80_ = cr;
#line 169 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_set_operator (_tmp80_, CAIRO_OPERATOR_DIFFERENCE);
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp81_ = cr;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_set_line_width (_tmp81_, (gdouble) GAME_VIEW_GRID_WIDTH);
#line 641 "game-view.c"
		{
			gint i = 0;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			i = 1;
#line 646 "game-view.c"
			{
				gboolean _tmp82_ = FALSE;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp82_ = TRUE;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				while (TRUE) {
#line 653 "game-view.c"
					gboolean _tmp83_ = FALSE;
					gint _tmp85_ = 0;
					cairo_t* _tmp86_ = NULL;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					cairo_t* _tmp94_ = NULL;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					cairo_t* _tmp97_ = NULL;
					gint _tmp98_ = 0;
					gint _tmp99_ = 0;
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					cairo_t* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					gint _tmp107_ = 0;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp83_ = _tmp82_;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					if (!_tmp83_) {
#line 682 "game-view.c"
						gint _tmp84_ = 0;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						_tmp84_ = i;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						i = _tmp84_ + 1;
#line 688 "game-view.c"
					}
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp82_ = FALSE;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp85_ = i;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					if (!(_tmp85_ < 8)) {
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						break;
#line 698 "game-view.c"
					}
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp86_ = cr;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp87_ = game_view_get_x_offset (self);
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp88_ = _tmp87_;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp89_ = i;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp90_ = game_view_get_board_size (self);
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp91_ = _tmp90_;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp92_ = game_view_get_y_offset (self);
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp93_ = _tmp92_;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					cairo_move_to (_tmp86_, (_tmp88_ + ((_tmp89_ * _tmp91_) / 8)) - 0.5, (gdouble) _tmp93_);
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp94_ = cr;
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp95_ = game_view_get_board_size (self);
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp96_ = _tmp95_;
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					cairo_rel_line_to (_tmp94_, (gdouble) 0, (gdouble) _tmp96_);
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp97_ = cr;
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp98_ = game_view_get_x_offset (self);
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp99_ = _tmp98_;
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp100_ = game_view_get_y_offset (self);
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp101_ = _tmp100_;
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp102_ = i;
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp103_ = game_view_get_board_size (self);
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp104_ = _tmp103_;
#line 176 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					cairo_move_to (_tmp97_, (gdouble) _tmp99_, (_tmp101_ + ((_tmp102_ * _tmp104_) / 8)) - 0.5);
#line 177 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp105_ = cr;
#line 177 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp106_ = game_view_get_board_size (self);
#line 177 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp107_ = _tmp106_;
#line 177 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					cairo_rel_line_to (_tmp105_, (gdouble) _tmp107_, (gdouble) 0);
#line 752 "game-view.c"
				}
			}
		}
#line 180 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp108_ = cr;
#line 180 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_stroke (_tmp108_);
#line 760 "game-view.c"
	}
#line 183 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 766 "game-view.c"
}


static void game_view_load_theme (GameView* self, cairo_t* c) {
	gint width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 188 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_tile_size (self);
#line 188 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 188 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	width = _tmp1_ * 8;
#line 189 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_tile_size (self);
#line 189 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 189 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	height = _tmp3_ * 4;
#line 794 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		RsvgHandle* _tmp6_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_t* _tmp11_ = NULL;
		cairo_matrix_t _tmp12_ = {0};
		cairo_t* _tmp13_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp4_ = game_view_get_theme (self);
#line 193 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 193 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp6_ = rsvg_handle_new_from_file (_tmp5_, &_inner_error_);
#line 193 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		h = _tmp6_;
#line 193 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_inner_error_ != NULL) {
#line 818 "game-view.c"
			goto __catch0_g_error;
		}
#line 195 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 196 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_object_get (h, "width", &_tmp7_, NULL);
#line 196 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 196 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_object_get (h, "height", &_tmp9_, NULL);
#line 196 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp10_ = _tmp9_;
#line 196 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) width) / _tmp8_, ((gdouble) height) / _tmp10_);
#line 197 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp11_ = c;
#line 197 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_ = m;
#line 197 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_set_matrix (_tmp11_, &_tmp12_);
#line 198 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp13_ = c;
#line 198 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp13_);
#line 200 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_g_object_unref0 (h);
#line 200 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return;
#line 847 "game-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		e = _inner_error_;
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 859 "game-view.c"
	}
	__finally0:
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_inner_error_ != NULL) {
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return;
#line 870 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		cairo_t* _tmp19_ = NULL;
#line 209 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp14_ = game_view_get_theme (self);
#line 209 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp15_ = _tmp14_;
#line 209 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp16_ = gdk_pixbuf_new_from_file_at_scale (_tmp15_, width, height, FALSE, &_inner_error_);
#line 209 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		p = _tmp16_;
#line 209 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_inner_error_ != NULL) {
#line 890 "game-view.c"
			goto __catch1_g_error;
		}
#line 210 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp17_ = c;
#line 210 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18_ = p;
#line 210 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
#line 211 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp19_ = c;
#line 211 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		cairo_paint (_tmp19_);
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_g_object_unref0 (p);
#line 905 "game-view.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		e = _inner_error_;
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_theme (self);
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp22_ = e;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_->message;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_warning ("game-view.vala:215: Failed to load theme %s: %s", _tmp21_, _tmp23_);
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 931 "game-view.c"
	}
	__finally1:
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_inner_error_ != NULL) {
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 207 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return;
#line 942 "game-view.c"
	}
}


void game_view_redraw (GameView* self) {
#line 219 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 952 "game-view.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return _data1_;
#line 961 "game-view.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 970 "game-view.c"
		GameView * self;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		self = _data1_->self;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_g_object_unref0 (self);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_slice_free (Block1Data, _data1_);
#line 978 "game-view.c"
	}
}


static gboolean ___lambda2_ (Block1Data* _data1_) {
	GameView * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = _data1_->self;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = TRUE;
#line 268 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = _data1_->x;
#line 268 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = _data1_->y;
#line 268 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_square_changed_cb (self, _tmp0_, _tmp1_);
#line 270 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = FALSE;
#line 270 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1002 "game-view.c"
}


static gboolean ____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda2_ (self);
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1011 "game-view.c"
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Block1Data* _data1_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	Game* _tmp55_ = NULL;
	Game* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp70_ = FALSE;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_->_ref_count_ = 1;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_->self = g_object_ref (self);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = x;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_->x = _tmp0_;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = y;
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_->y = _tmp1_;
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp4_ = _data1_->x;
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp5_ = _data1_->y;
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
#line 226 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	pixmap = _tmp7_;
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp9_ = self->priv->flip_final_result_now;
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp9_) {
#line 1075 "game-view.c"
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_game (self);
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_ = game_is_complete (_tmp11_);
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = _tmp12_;
#line 1087 "game-view.c"
	} else {
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = FALSE;
#line 1091 "game-view.c"
	}
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp13_ = _tmp8_;
#line 229 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp13_) {
#line 1097 "game-view.c"
		gint n = 0;
		gint _tmp14_ = 0;
		Game* _tmp15_ = NULL;
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp20_ = NULL;
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp14_ = _data1_->y;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp15_ = game_view_get_game (self);
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp16_ = _tmp15_;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp17_ = game_get_width (_tmp16_);
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18_ = _tmp17_;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp19_ = _data1_->x;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		n = (_tmp14_ * _tmp18_) + _tmp19_;
#line 232 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		winning_color = PLAYER_LIGHT;
#line 233 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		losing_color = PLAYER_DARK;
#line 234 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_game (self);
#line 234 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 234 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
#line 234 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 234 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		n_winning_tiles = _tmp23_;
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp24_ = game_view_get_game (self);
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp27_ = _tmp26_;
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		n_losing_tiles = _tmp27_;
#line 236 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp28_ = n_losing_tiles;
#line 236 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp29_ = n_winning_tiles;
#line 236 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp28_ > _tmp29_) {
#line 1165 "game-view.c"
			gint t = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			winning_color = PLAYER_DARK;
#line 239 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			losing_color = PLAYER_LIGHT;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp30_ = n_winning_tiles;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			t = _tmp30_;
#line 241 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp31_ = n_losing_tiles;
#line 241 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			n_winning_tiles = _tmp31_;
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp32_ = t;
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			n_losing_tiles = _tmp32_;
#line 1186 "game-view.c"
		}
#line 244 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp33_ = n;
#line 244 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp34_ = n_winning_tiles;
#line 244 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp33_ < _tmp34_) {
#line 1194 "game-view.c"
			Player _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp35_ = winning_color;
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			pixmap = _tmp36_;
#line 1203 "game-view.c"
		} else {
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp37_ = n;
#line 246 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp38_ = n_winning_tiles;
#line 246 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp39_ = n_losing_tiles;
#line 246 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
#line 1216 "game-view.c"
				Player _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp40_ = losing_color;
#line 247 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
#line 247 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				pixmap = _tmp41_;
#line 1225 "game-view.c"
			} else {
				gint _tmp42_ = 0;
#line 249 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
#line 249 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				pixmap = _tmp42_;
#line 1232 "game-view.c"
			}
		}
	} else {
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp48_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp44_ = self->priv->flip_final_result_now;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp44_) {
#line 1243 "game-view.c"
			Game* _tmp45_ = NULL;
			Game* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp45_ = game_view_get_game (self);
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp46_ = _tmp45_;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp47_ = game_is_complete (_tmp46_);
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp43_ = !_tmp47_;
#line 1255 "game-view.c"
		} else {
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp43_ = FALSE;
#line 1259 "game-view.c"
		}
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp48_ = _tmp43_;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp48_) {
#line 254 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			self->priv->flip_final_result_now = FALSE;
#line 1267 "game-view.c"
		}
	}
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp49_ = _data1_->x;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp50_ = _data1_->y;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp51_ = pixmap;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_set_square (self, _tmp49_, _tmp50_, _tmp51_);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp55_ = game_view_get_game (self);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp56_ = _tmp55_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp57_ = game_is_complete (_tmp56_);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp57_) {
#line 1286 "game-view.c"
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp58_ = game_view_get_flip_final_result (self);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp59_ = _tmp58_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp54_ = _tmp59_;
#line 1295 "game-view.c"
	} else {
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp54_ = FALSE;
#line 1299 "game-view.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp60_ = _tmp54_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp60_) {
#line 1305 "game-view.c"
		Game* _tmp61_ = NULL;
		Game* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp61_ = game_view_get_game (self);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp62_ = _tmp61_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp63_ = game_get_n_light_tiles (_tmp62_);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp64_ = _tmp63_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp53_ = _tmp64_ > 0;
#line 1320 "game-view.c"
	} else {
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp53_ = FALSE;
#line 1324 "game-view.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp65_ = _tmp53_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp65_) {
#line 1330 "game-view.c"
		Game* _tmp66_ = NULL;
		Game* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp66_ = game_view_get_game (self);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp67_ = _tmp66_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp68_ = game_get_n_dark_tiles (_tmp67_);
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp69_ = _tmp68_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp52_ = _tmp69_ > 0;
#line 1345 "game-view.c"
	} else {
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp52_ = FALSE;
#line 1349 "game-view.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp70_ = _tmp52_;
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp70_) {
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ____lambda2__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 1357 "game-view.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	block1_data_unref (_data1_);
#line 224 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_data1_ = NULL;
#line 1363 "game-view.c"
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb (self);
#line 289 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1372 "game-view.c"
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
#line 275 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->pixmaps;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0__length1 = self->priv->pixmaps_length1;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0__length2 = self->priv->pixmaps_length2;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = x;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = y;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp4_ = pixmap;
#line 277 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp3_ == _tmp4_) {
#line 278 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return;
#line 1421 "game-view.c"
	}
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp6_ = pixmap;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp6_ == 0) {
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = TRUE;
#line 1429 "game-view.c"
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pixmaps;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp7__length1 = self->priv->pixmaps_length1;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp7__length2 = self->priv->pixmaps_length2;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = x;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp9_ = y;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = _tmp10_ == 0;
#line 1451 "game-view.c"
	}
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp11_ = _tmp5_;
#line 280 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp11_) {
#line 1457 "game-view.c"
		gint* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_ = self->priv->pixmaps;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12__length1 = self->priv->pixmaps_length1;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12__length2 = self->priv->pixmaps_length2;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp13_ = x;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp14_ = y;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp15_ = pixmap;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = _tmp15_;
#line 281 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp16_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 1481 "game-view.c"
	} else {
		gint _tmp17_ = 0;
		gint* _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint _tmp18__length2 = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		guint _tmp30_ = 0U;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp17_ = pixmap;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18_ = self->priv->pixmaps;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18__length1 = self->priv->pixmaps_length1;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp18__length2 = self->priv->pixmaps_length2;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp19_ = x;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp20_ = y;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp17_ > _tmp21_) {
#line 1507 "game-view.c"
			gint* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gint _tmp22__length2 = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22_ = self->priv->pixmaps;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22__length1 = self->priv->pixmaps_length1;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22__length2 = self->priv->pixmaps_length2;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp23_ = x;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp24_ = y;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = _tmp25_ + 1;
#line 1528 "game-view.c"
		} else {
			gint* _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gint _tmp26__length2 = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp26_ = self->priv->pixmaps;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp26__length1 = self->priv->pixmaps_length1;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp26__length2 = self->priv->pixmaps_length2;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp27_ = x;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp28_ = y;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = _tmp29_ - 1;
#line 1550 "game-view.c"
		}
#line 288 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp30_ = self->priv->animate_timeout;
#line 288 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp30_ == ((guint) 0)) {
#line 1556 "game-view.c"
			guint _tmp31_ = 0U;
#line 289 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp31_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 289 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			self->priv->animate_timeout = _tmp31_;
#line 1562 "game-view.c"
		}
	}
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp32_ = game_view_get_x_offset (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp33_ = _tmp32_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp34_ = x;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp35_ = game_view_get_tile_size (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp37_ = game_view_get_y_offset (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp38_ = _tmp37_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp39_ = y;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp40_ = game_view_get_tile_size (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp41_ = _tmp40_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp42_ = game_view_get_tile_size (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp43_ = _tmp42_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp44_ = game_view_get_tile_size (self);
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp45_ = _tmp44_;
#line 291 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp33_ + (_tmp34_ * ((gint) (_tmp36_ + GAME_VIEW_GRID_WIDTH))), _tmp38_ + (_tmp39_ * ((gint) (_tmp41_ + GAME_VIEW_GRID_WIDTH))), _tmp43_, _tmp45_);
#line 1595 "game-view.c"
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp19_ = FALSE;
#line 294 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 296 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	animating = FALSE;
#line 1607 "game-view.c"
	{
		gint x = 0;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		x = 0;
#line 1612 "game-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp0_ = TRUE;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			while (TRUE) {
#line 1619 "game-view.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp1_ = _tmp0_;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!_tmp1_) {
#line 1626 "game-view.c"
					gint _tmp2_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp2_ = x;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					x = _tmp2_ + 1;
#line 1632 "game-view.c"
				}
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp0_ = FALSE;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp3_ = x;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!(_tmp3_ < 8)) {
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					break;
#line 1642 "game-view.c"
				}
				{
					gint y = 0;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					y = 0;
#line 1648 "game-view.c"
					{
						gboolean _tmp4_ = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						_tmp4_ = TRUE;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						while (TRUE) {
#line 1655 "game-view.c"
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint old = 0;
							gint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp5_ = _tmp4_;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!_tmp5_) {
#line 1678 "game-view.c"
								gint _tmp6_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp6_ = y;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								y = _tmp6_ + 1;
#line 1684 "game-view.c"
							}
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp4_ = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp7_ = y;
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!(_tmp7_ < 8)) {
#line 300 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								break;
#line 1694 "game-view.c"
							}
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp8_ = self->priv->pixmaps;
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp8__length1 = self->priv->pixmaps_length1;
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp8__length2 = self->priv->pixmaps_length2;
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp9_ = x;
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp10_ = y;
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 302 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							old = _tmp11_;
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp12_ = x;
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp13_ = y;
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							game_view_square_changed_cb (self, _tmp12_, _tmp13_);
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp14_ = self->priv->pixmaps;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp14__length1 = self->priv->pixmaps_length1;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp14__length2 = self->priv->pixmaps_length2;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp15_ = x;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp16_ = y;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp18_ = old;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (_tmp17_ != _tmp18_) {
#line 305 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								animating = TRUE;
#line 1734 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 309 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp19_ = animating;
#line 309 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (!_tmp19_) {
#line 311 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 312 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		result = FALSE;
#line 312 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return result;
#line 1752 "game-view.c"
	}
#line 315 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = TRUE;
#line 315 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1758 "game-view.c"
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
#line 318 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 320 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = color;
#line 320 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	switch (_tmp0_) {
#line 1771 "game-view.c"
		default:
#line 320 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case PLAYER_NONE:
#line 1775 "game-view.c"
		{
#line 324 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			result = 0;
#line 324 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			return result;
#line 1781 "game-view.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case PLAYER_DARK:
#line 1785 "game-view.c"
		{
#line 326 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			result = 1;
#line 326 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			return result;
#line 1791 "game-view.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case PLAYER_LIGHT:
#line 1795 "game-view.c"
		{
#line 328 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			result = 31;
#line 328 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			return result;
#line 1801 "game-view.c"
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
#line 332 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 332 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 334 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = *event;
#line 334 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_.button;
#line 334 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1822 "game-view.c"
		gint x = 0;
		GdkEventButton _tmp2_ = {0};
		gdouble _tmp3_ = 0.0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint y = 0;
		GdkEventButton _tmp8_ = {0};
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_ = 0;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp2_ = *event;
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp3_ = _tmp2_.x;
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp4_ = game_view_get_x_offset (self);
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp6_ = game_view_get_tile_size (self);
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 336 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		x = ((gint) (_tmp3_ - _tmp5_)) / (_tmp7_ + GAME_VIEW_GRID_WIDTH);
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp8_ = *event;
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp9_ = _tmp8_.y;
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_y_offset (self);
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_tile_size (self);
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 337 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		y = ((gint) (_tmp9_ - _tmp11_)) / (_tmp13_ + GAME_VIEW_GRID_WIDTH);
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp17_ = x;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp17_ >= 0) {
#line 1876 "game-view.c"
			gint _tmp18_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp18_ = x;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp16_ = _tmp18_ < 8;
#line 1882 "game-view.c"
		} else {
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp16_ = FALSE;
#line 1886 "game-view.c"
		}
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp19_ = _tmp16_;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp19_) {
#line 1892 "game-view.c"
			gint _tmp20_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp20_ = y;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp15_ = _tmp20_ >= 0;
#line 1898 "game-view.c"
		} else {
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp15_ = FALSE;
#line 1902 "game-view.c"
		}
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp21_ = _tmp15_;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp21_) {
#line 1908 "game-view.c"
			gint _tmp22_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp22_ = y;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp14_ = _tmp22_ < 8;
#line 1914 "game-view.c"
		} else {
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp14_ = FALSE;
#line 1918 "game-view.c"
		}
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp23_ = _tmp14_;
#line 338 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		if (_tmp23_) {
#line 1924 "game-view.c"
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp24_ = x;
#line 339 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp25_ = y;
#line 339 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			g_signal_emit_by_name (self, "move", _tmp24_, _tmp25_);
#line 1933 "game-view.c"
		}
	}
#line 342 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = TRUE;
#line 342 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1940 "game-view.c"
}


static gint game_view_get_tile_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 36 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = MIN (_tmp0_ / 8, _tmp1_ / ((gint) 8));
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = _tmp2_ - GAME_VIEW_GRID_WIDTH;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1961 "game-view.c"
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 44 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_tile_size (self);
#line 46 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 46 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
#line 46 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 1982 "game-view.c"
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 52 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 54 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_tile_size (self);
#line 54 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 54 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
#line 54 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2003 "game-view.c"
}


static gint game_view_get_board_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 58 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_tile_size (self);
#line 58 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 58 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = (_tmp1_ + GAME_VIEW_GRID_WIDTH) * 8;
#line 58 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2021 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 69 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 69 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = _tmp0_;
#line 69 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2036 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 74 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 2043 "game-view.c"
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
#line 77 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_square_changed_cb (self, x, y);
#line 2050 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
#line 70 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 2065 "game-view.c"
		Game* _tmp1_ = NULL;
#line 73 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 73 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 2071 "game-view.c"
	}
#line 74 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = value;
#line 74 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 74 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 74 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 75 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp4_ = self->priv->_game;
#line 75 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp4_ != NULL) {
#line 2085 "game-view.c"
		Game* _tmp5_ = NULL;
#line 77 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		_tmp5_ = self->priv->_game;
#line 77 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_signal_connect_object (_tmp5_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
#line 2091 "game-view.c"
		{
			gint x = 0;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			x = 0;
#line 2096 "game-view.c"
			{
				gboolean _tmp6_ = FALSE;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp6_ = TRUE;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				while (TRUE) {
#line 2103 "game-view.c"
					gboolean _tmp7_ = FALSE;
					gint _tmp9_ = 0;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp7_ = _tmp6_;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					if (!_tmp7_) {
#line 2110 "game-view.c"
						gint _tmp8_ = 0;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						_tmp8_ = x;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						x = _tmp8_ + 1;
#line 2116 "game-view.c"
					}
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp6_ = FALSE;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp9_ = x;
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					if (!(_tmp9_ < 8)) {
#line 78 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						break;
#line 2126 "game-view.c"
					}
					{
						gint y = 0;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						y = 0;
#line 2132 "game-view.c"
						{
							gboolean _tmp10_ = FALSE;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp10_ = TRUE;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							while (TRUE) {
#line 2139 "game-view.c"
								gboolean _tmp11_ = FALSE;
								gint _tmp13_ = 0;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								Game* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								Player _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp11_ = _tmp10_;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								if (!_tmp11_) {
#line 2157 "game-view.c"
									gint _tmp12_ = 0;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
									_tmp12_ = y;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
									y = _tmp12_ + 1;
#line 2163 "game-view.c"
								}
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp10_ = FALSE;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp13_ = y;
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								if (!(_tmp13_ < 8)) {
#line 79 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
									break;
#line 2173 "game-view.c"
								}
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp14_ = self->priv->pixmaps;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp14__length1 = self->priv->pixmaps_length1;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp14__length2 = self->priv->pixmaps_length2;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp15_ = x;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp16_ = y;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp17_ = self->priv->_game;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp18_ = x;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp19_ = y;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp20_ = game_get_owner (_tmp17_, _tmp18_, _tmp19_);
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp21_ = game_view_get_pixmap (self, _tmp20_);
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = _tmp21_;
#line 80 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp22_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 2199 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 82 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_redraw (self);
#line 70 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2211 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 89 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = _tmp0_;
#line 89 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2226 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_theme = _tmp1_;
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 2251 "game-view.c"
}


gboolean game_view_get_show_grid (GameView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_show_grid;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = _tmp0_;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2266 "game-view.c"
}


void game_view_set_show_grid (GameView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 97 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 97 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_show_grid = _tmp0_;
#line 97 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_redraw (self);
#line 97 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "show-grid");
#line 2282 "game-view.c"
}


gboolean game_view_get_flip_final_result (GameView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_flip_final_result;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	result = _tmp0_;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	return result;
#line 2297 "game-view.c"
}


void game_view_set_flip_final_result (GameView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 106 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_flip_final_result = _tmp0_;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (_tmp2_ == NULL) {
#line 108 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		return;
#line 2319 "game-view.c"
	}
	{
		gint x = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		x = 0;
#line 2325 "game-view.c"
		{
			gboolean _tmp3_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			_tmp3_ = TRUE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
			while (TRUE) {
#line 2332 "game-view.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				Game* _tmp7_ = NULL;
				Game* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp4_ = _tmp3_;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!_tmp4_) {
#line 2343 "game-view.c"
					gint _tmp5_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					_tmp5_ = x;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					x = _tmp5_ + 1;
#line 2349 "game-view.c"
				}
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp3_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp6_ = x;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp7_ = game_view_get_game (self);
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp8_ = _tmp7_;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp9_ = game_get_width (_tmp8_);
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				_tmp10_ = _tmp9_;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
				if (!(_tmp6_ < _tmp10_)) {
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					break;
#line 2367 "game-view.c"
				}
				{
					gint y = 0;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
					y = 0;
#line 2373 "game-view.c"
					{
						gboolean _tmp11_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						_tmp11_ = TRUE;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
						while (TRUE) {
#line 2380 "game-view.c"
							gboolean _tmp12_ = FALSE;
							gint _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Game* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp12_ = _tmp11_;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!_tmp12_) {
#line 2393 "game-view.c"
								gint _tmp13_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								_tmp13_ = y;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								y = _tmp13_ + 1;
#line 2399 "game-view.c"
							}
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp11_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp14_ = y;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp15_ = game_view_get_game (self);
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp16_ = _tmp15_;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp17_ = game_get_height (_tmp16_);
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp18_ = _tmp17_;
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							if (!(_tmp14_ < _tmp18_)) {
#line 110 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
								break;
#line 2417 "game-view.c"
							}
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp19_ = x;
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							_tmp20_ = y;
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
							game_view_square_changed_cb (self, _tmp19_, _tmp20_);
#line 2425 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 104 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "flip-final-result");
#line 2434 "game-view.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		data1 = closure->data;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 2453 "game-view.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		data2 = closure->data;
#line 2459 "game-view.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 2465 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_width = game_view_real_get_preferred_width;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	GTK_WIDGET_CLASS (klass)->get_preferred_height = game_view_real_get_preferred_height;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	GTK_WIDGET_CLASS (klass)->draw = game_view_real_draw;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	GTK_WIDGET_CLASS (klass)->button_press_event = game_view_real_button_press_event;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_GRID, g_param_spec_boolean ("show-grid", "show-grid", "show-grid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_FLIP_FINAL_RESULT, g_param_spec_boolean ("flip-final-result", "flip-final-result", "flip-final-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 2498 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 20 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->render_size = (guint) 0;
#line 21 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 27 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->animate_timeout = (guint) 0;
#line 32 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = FALSE;
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_game = NULL;
#line 86 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->_theme = NULL;
#line 2517 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 21 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 24 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 86 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2535 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_SHOW_GRID:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_value_set_boolean (value, game_view_get_show_grid (self));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_FLIP_FINAL_RESULT:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		g_value_set_boolean (value, game_view_get_flip_final_result (self));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 2580 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 2586 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_SHOW_GRID:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		game_view_set_show_grid (self, g_value_get_boolean (value));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		case GAME_VIEW_FLIP_FINAL_RESULT:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		game_view_set_flip_final_result (self, g_value_get_boolean (value));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 2620 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/game-view.vala"
		break;
#line 2626 "game-view.c"
	}
}



