/* gkr-item.c generated by valac 0.22.1, the Vala compiler
 * generated from gkr-item.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define SEAHORSE_GKR_TYPE_DISPLAY_INFO (seahorse_gkr_display_info_get_type ())
typedef struct _SeahorseGkrDisplayInfo SeahorseGkrDisplayInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SEAHORSE_GKR_TYPE_DISPLAY_ENTRY (seahorse_gkr_display_entry_get_type ())
typedef struct _SeahorseGkrDisplayEntry SeahorseGkrDisplayEntry;
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _seahorse_gkr_display_info_free0(var) ((var == NULL) ? NULL : (var = (seahorse_gkr_display_info_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_ITEM_DELETER (seahorse_gkr_item_deleter_get_type ())
#define SEAHORSE_GKR_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter))
#define SEAHORSE_GKR_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))
#define SEAHORSE_GKR_IS_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_IS_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_ITEM_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))

typedef struct _SeahorseGkrItemDeleter SeahorseGkrItemDeleter;
typedef struct _SeahorseGkrItemDeleterClass SeahorseGkrItemDeleterClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseGkrItemSetSecretData SeahorseGkrItemSetSecretData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_MAPPING_ENTRY (seahorse_gkr_mapping_entry_get_type ())
typedef struct _SeahorseGkrMappingEntry SeahorseGkrMappingEntry;
typedef struct _SeahorseGkrItemDeleterPrivate SeahorseGkrItemDeleterPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _SeahorseGkrItemDeleterDeleteData SeahorseGkrItemDeleterDeleteData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseGkrDisplayInfo {
	gchar* item_type;
	gchar* label;
	gchar* details;
	gchar* description;
};

typedef void (*SeahorseGkrDisplayCustom) (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
struct _SeahorseGkrDisplayEntry {
	gchar* item_type;
	gchar* description;
	SeahorseGkrDisplayCustom custom_func;
};

struct _SeahorseGkrItemPrivate {
	SecretValue* _item_secret;
	SeahorseGkrDisplayInfo* _info;
	GWeakRef _place;
	GCancellable* _req_secret;
};

struct _SeahorseGkrItemSetSecretData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItem* self;
	SecretValue* value;
	GCancellable* cancellable;
	gboolean result;
	SecretValue* _tmp0_;
	GCancellable* _tmp1_;
	SecretValue* _tmp2_;
	SecretValue* _tmp3_;
	GError * _inner_error_;
};

struct _SeahorseGkrMappingEntry {
	gchar* item_type;
	gchar* mapped_type;
	gchar* match_attribute;
	gchar* match_pattern;
};

struct _SeahorseGkrItemDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrItemDeleterPrivate * priv;
};

struct _SeahorseGkrItemDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrItemDeleterPrivate {
	GList* _items;
};

struct _SeahorseGkrItemDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItemDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	GList* items;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* item_collection;
	GList* item_it;
	SeahorseGkrItem* item;
	SeahorseGkrItem* _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_;
};


static gpointer seahorse_gkr_item_parent_class = NULL;
static SeahorseDeletableIface* seahorse_gkr_item_seahorse_deletable_parent_iface = NULL;
static SeahorseViewableIface* seahorse_gkr_item_seahorse_viewable_parent_iface = NULL;
static gpointer seahorse_gkr_item_deleter_parent_class = NULL;

GType seahorse_gkr_display_info_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest);
void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self);
GType seahorse_gkr_display_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest);
void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self);
#define SEAHORSE_GKR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItemPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DUMMY_PROPERTY,
	SEAHORSE_GKR_ITEM_DESCRIPTION,
	SEAHORSE_GKR_ITEM_USE,
	SEAHORSE_GKR_ITEM_HAS_SECRET,
	SEAHORSE_GKR_ITEM_PLACE,
	SEAHORSE_GKR_ITEM_OBJECT_FLAGS,
	SEAHORSE_GKR_ITEM_ICON,
	SEAHORSE_GKR_ITEM_LABEL,
	SEAHORSE_GKR_ITEM_MARKUP,
	SEAHORSE_GKR_ITEM_USAGE,
	SEAHORSE_GKR_ITEM_ACTIONS,
	SEAHORSE_GKR_ITEM_DELETABLE
};
static void seahorse_gkr_item_real_dispose (GObject* base);
static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item);
GType seahorse_gkr_item_deleter_get_type (void) G_GNUC_CONST;
static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent);
static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self);
gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name);
gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs);
#define SEAHORSE_GKR_GENERIC_SECRET "org.freedesktop.Secret.Generic"
#define SEAHORSE_GKR_NETWORK_PASSWORD "org.gnome.keyring.NetworkPassword"
void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_KEYRING_NOTE "org.gnome.keyring.Note"
#define SEAHORSE_GKR_CHAINED_KEYRING "org.gnome.keyring.ChainedKeyring"
#define SEAHORSE_GKR_ENCRYPTION_KEY "org.gnome.keyring.EncryptionKey"
#define SEAHORSE_GKR_PK_STORAGE "org.gnome.keyring.PkStorage"
#define SEAHORSE_GKR_CHROME_PASSWORD "x.internal.Chrome"
void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_GOA_PASSWORD "org.gnome.OnlineAccounts"
#define SEAHORSE_GKR_TELEPATHY_PASSWORD "org.freedesktop.Telepathy"
void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_EMPATHY_PASSWORD "org.freedesktop.Empathy"
void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_NETWORK_MANAGER_SECRET "org.freedesktop.NetworkManager"
static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self);
static void ___lambda18_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res);
static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_item_set_secret_data_free (gpointer _data);
static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_);
static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item___lambda28_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1);
static void __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void seahorse_gkr_item_finalize (GObject* obj);
static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name);
gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match);
gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display);
gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always);
gchar* seahorse_gkr_decode_telepathy_id (const gchar* account);
GType seahorse_gkr_mapping_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest);
void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self);
#define SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DELETER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent);
static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj);
static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_);
static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_gkr_item_deleter_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

const SeahorseGkrDisplayEntry SEAHORSE_GKR_DISPLAY_ENTRIES[11] = {{SEAHORSE_GKR_GENERIC_SECRET, "Password or secret", NULL}, {SEAHORSE_GKR_NETWORK_PASSWORD, "Network password", _seahorse_gkr_network_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_KEYRING_NOTE, "Stored note", NULL}, {SEAHORSE_GKR_CHAINED_KEYRING, "Keyring password", NULL}, {SEAHORSE_GKR_ENCRYPTION_KEY, "Encryption key password", NULL}, {SEAHORSE_GKR_PK_STORAGE, "Key storage password", NULL}, {SEAHORSE_GKR_CHROME_PASSWORD, "Google Chrome password", _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_GOA_PASSWORD, "Gnome Online Accounts password", NULL}, {SEAHORSE_GKR_TELEPATHY_PASSWORD, "Telepathy password", _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_EMPATHY_PASSWORD, "Instant messaging password", _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "Network Manager secret", NULL}};
const SeahorseGkrMappingEntry SEAHORSE_GKR_MAPPING_ENTRIES[5] = {{SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_CHROME_PASSWORD, "application", "chrome*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_GOA_PASSWORD, "goa-identity", NULL}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_TELEPATHY_PASSWORD, "account", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_EMPATHY_PASSWORD, "account-id", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "connection-uuid", NULL}};

GType seahorse_gkr_use_get_type (void) {
	static volatile gsize seahorse_gkr_use_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_use_type_id__volatile)) {
		static const GEnumValue values[] = {{SEAHORSE_GKR_USE_OTHER, "SEAHORSE_GKR_USE_OTHER", "other"}, {SEAHORSE_GKR_USE_NETWORK, "SEAHORSE_GKR_USE_NETWORK", "network"}, {SEAHORSE_GKR_USE_WEB, "SEAHORSE_GKR_USE_WEB", "web"}, {SEAHORSE_GKR_USE_PGP, "SEAHORSE_GKR_USE_PGP", "pgp"}, {SEAHORSE_GKR_USE_SSH, "SEAHORSE_GKR_USE_SSH", "ssh"}, {0, NULL, NULL}};
		GType seahorse_gkr_use_type_id;
		seahorse_gkr_use_type_id = g_enum_register_static ("SeahorseGkrUse", values);
		g_once_init_leave (&seahorse_gkr_use_type_id__volatile, seahorse_gkr_use_type_id);
	}
	return seahorse_gkr_use_type_id__volatile;
}


void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).label;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).label);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).label = _tmp3_;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).details;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).details);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).details = _tmp5_;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*self).description;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).description);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).description = _tmp7_;
#line 300 "gkr-item.c"
}


void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self) {
#line 32 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 33 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).label);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).details);
#line 35 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).description);
#line 313 "gkr-item.c"
}


SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self) {
	SeahorseGkrDisplayInfo* dup;
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrDisplayInfo, 1);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_copy (self, dup);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 325 "gkr-item.c"
}


void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self) {
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_destroy (self);
#line 31 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 334 "gkr-item.c"
}


GType seahorse_gkr_display_info_get_type (void) {
	static volatile gsize seahorse_gkr_display_info_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_info_type_id__volatile)) {
		GType seahorse_gkr_display_info_type_id;
		seahorse_gkr_display_info_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayInfo", (GBoxedCopyFunc) seahorse_gkr_display_info_dup, (GBoxedFreeFunc) seahorse_gkr_display_info_free);
		g_once_init_leave (&seahorse_gkr_display_info_type_id__volatile, seahorse_gkr_display_info_type_id);
	}
	return seahorse_gkr_display_info_type_id__volatile;
}


void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SeahorseGkrDisplayCustom _tmp4_ = NULL;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).description;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).description);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).description = _tmp3_;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).custom_func;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).custom_func = _tmp4_;
#line 375 "gkr-item.c"
}


void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self) {
#line 44 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 45 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).description);
#line 384 "gkr-item.c"
}


SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self) {
	SeahorseGkrDisplayEntry* dup;
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrDisplayEntry, 1);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_entry_copy (self, dup);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 396 "gkr-item.c"
}


void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self) {
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_entry_destroy (self);
#line 43 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 405 "gkr-item.c"
}


GType seahorse_gkr_display_entry_get_type (void) {
	static volatile gsize seahorse_gkr_display_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_entry_type_id__volatile)) {
		GType seahorse_gkr_display_entry_type_id;
		seahorse_gkr_display_entry_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayEntry", (GBoxedCopyFunc) seahorse_gkr_display_entry_dup, (GBoxedFreeFunc) seahorse_gkr_display_entry_free);
		g_once_init_leave (&seahorse_gkr_display_entry_type_id__volatile, seahorse_gkr_display_entry_type_id);
	}
	return seahorse_gkr_display_entry_type_id__volatile;
}


static void seahorse_gkr_item_real_dispose (GObject* base) {
	SeahorseGkrItem * self;
	GCancellable* _tmp0_ = NULL;
#line 134 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 135 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_req_secret;
#line 135 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 429 "gkr-item.c"
		GCancellable* _tmp1_ = NULL;
#line 136 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = self->priv->_req_secret;
#line 136 "/data/src/seahorse/gkr/gkr-item.vala"
		g_cancellable_cancel (_tmp1_);
#line 435 "gkr-item.c"
	}
#line 137 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (self->priv->_req_secret);
#line 137 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_req_secret = NULL;
#line 138 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 443 "gkr-item.c"
}


static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base) {
	SeahorseGkrItem * self;
	SeahorseDeleter* result = NULL;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
#line 141 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 142 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = seahorse_gkr_item_deleter_new (self);
#line 142 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (SeahorseDeleter*) _tmp0_;
#line 142 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 459 "gkr-item.c"
}


static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent) {
	SeahorseGkrItem * self;
	GtkWindow* result = NULL;
	GtkWindow* _tmp0_ = NULL;
	SeahorseGkrItemProperties* _tmp1_ = NULL;
#line 145 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 146 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = parent;
#line 146 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_item_properties_new (self, _tmp0_);
#line 146 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_ref_sink (_tmp1_);
#line 146 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (GtkWindow*) _tmp1_;
#line 146 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 480 "gkr-item.c"
}


static gpointer _seahorse_gkr_display_info_dup0 (gpointer self) {
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? seahorse_gkr_display_info_dup (self) : NULL;
#line 487 "gkr-item.c"
}


static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_network_custom (label, item_attrs, info);
#line 494 "gkr-item.c"
}


static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_chrome_custom (label, item_attrs, info);
#line 501 "gkr-item.c"
}


static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_telepathy_custom (label, item_attrs, info);
#line 508 "gkr-item.c"
}


static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_empathy_custom (label, item_attrs, info);
#line 515 "gkr-item.c"
}


static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self) {
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo _tmp1_ = {0};
	SeahorseGkrDisplayInfo _tmp2_ = {0};
	SeahorseGkrDisplayInfo* _tmp3_ = NULL;
	GHashTable* attrs = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	gchar* item_type = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SeahorseGkrDisplayInfo* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* label = NULL;
	gchar* _tmp15_ = NULL;
	SeahorseGkrDisplayInfo* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	SeahorseGkrDisplayInfo* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	SeahorseGkrDisplayInfo* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 150 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 150 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 151 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 553 "gkr-item.c"
	}
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	memset (&_tmp1_, 0, sizeof (SeahorseGkrDisplayInfo));
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = _seahorse_gkr_display_info_dup0 (&_tmp2_);
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = _tmp3_;
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_destroy (&_tmp2_);
#line 155 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
#line 155 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = _tmp4_;
#line 155 "/data/src/seahorse/gkr/gkr-item.vala"
	attrs = _tmp5_;
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = attrs;
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "xdg:schema");
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	item_type = _tmp7_;
#line 157 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = item_type;
#line 157 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = attrs;
#line 157 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = seahorse_gkr_map_item_type_to_specific (_tmp8_, _tmp9_);
#line 157 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (item_type);
#line 157 "/data/src/seahorse/gkr/gkr-item.vala"
	item_type = _tmp10_;
#line 158 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp11_ = item_type;
#line 158 "/data/src/seahorse/gkr/gkr-item.vala"
	_vala_assert (_tmp11_ != NULL, "item_type != null");
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp12_ = self->priv->_info;
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = item_type;
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*_tmp12_).item_type);
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	(*_tmp12_).item_type = _tmp14_;
#line 161 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = secret_item_get_label (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 161 "/data/src/seahorse/gkr/gkr-item.vala"
	label = _tmp15_;
#line 607 "gkr-item.c"
	{
		SeahorseGkrDisplayEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
		entry_collection = SEAHORSE_GKR_DISPLAY_ENTRIES;
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
		entry_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES);
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES); entry_it = entry_it + 1) {
#line 619 "gkr-item.c"
			SeahorseGkrDisplayEntry entry = {0};
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
			entry = entry_collection[entry_it];
#line 623 "gkr-item.c"
			{
				SeahorseGkrDisplayEntry _tmp16_ = {0};
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 163 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = entry;
#line 163 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp17_ = _tmp16_.item_type;
#line 163 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp18_ = item_type;
#line 163 "/data/src/seahorse/gkr/gkr-item.vala"
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 636 "gkr-item.c"
					SeahorseGkrDisplayEntry _tmp19_ = {0};
					SeahorseGkrDisplayCustom _tmp20_ = NULL;
					SeahorseGkrDisplayInfo* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
#line 164 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp19_ = entry;
#line 164 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp20_ = _tmp19_.custom_func;
#line 164 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp20_ != NULL) {
#line 647 "gkr-item.c"
						SeahorseGkrDisplayEntry _tmp21_ = {0};
						SeahorseGkrDisplayCustom _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
						GHashTable* _tmp24_ = NULL;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp21_ = entry;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp22_ = _tmp21_.custom_func;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp23_ = label;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp24_ = attrs;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp22_ (_tmp23_, _tmp24_, self->priv->_info);
#line 662 "gkr-item.c"
					}
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp25_ = self->priv->_info;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp26_ = (*_tmp25_).description;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp26_ == NULL) {
#line 670 "gkr-item.c"
						SeahorseGkrDisplayInfo* _tmp27_ = NULL;
						SeahorseGkrDisplayEntry _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp27_ = self->priv->_info;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp28_ = entry;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp29_ = _tmp28_.description;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp30_ = _ (_tmp29_);
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp31_ = g_strdup (_tmp30_);
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						_g_free0 ((*_tmp27_).description);
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
						(*_tmp27_).description = _tmp31_;
#line 690 "gkr-item.c"
					}
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
					break;
#line 694 "gkr-item.c"
				}
			}
		}
	}
#line 172 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp32_ = self->priv->_info;
#line 172 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp33_ = (*_tmp32_).label;
#line 172 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp33_ == NULL) {
#line 705 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 173 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp34_ = self->priv->_info;
#line 173 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp35_ = label;
#line 173 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = g_strdup (_tmp35_);
#line 173 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp34_).label);
#line 173 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp34_).label = _tmp36_;
#line 719 "gkr-item.c"
	}
#line 174 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp37_ = self->priv->_info;
#line 174 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp38_ = (*_tmp37_).label;
#line 174 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp38_ == NULL) {
#line 727 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp39_ = self->priv->_info;
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp40_ = g_strdup ("");
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp39_).label);
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp39_).label = _tmp40_;
#line 738 "gkr-item.c"
	}
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp41_ = self->priv->_info;
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp42_ = (*_tmp41_).details;
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp42_ == NULL) {
#line 746 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp43_ = self->priv->_info;
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp44_ = g_strdup ("");
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp43_).details);
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp43_).details = _tmp44_;
#line 757 "gkr-item.c"
	}
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (label);
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (item_type);
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (attrs);
#line 765 "gkr-item.c"
}


static void ___lambda18_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (res != NULL);
#line 773 "gkr-item.c"
	{
		GAsyncResult* _tmp0_ = NULL;
		SecretValue* _tmp1_ = NULL;
#line 185 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_object_unref0 (self->priv->_req_secret);
#line 185 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_req_secret = NULL;
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = res;
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
		secret_item_load_secret_finish ((SecretItem*) self, _tmp0_, &_inner_error_);
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 787 "gkr-item.c"
			goto __catch2_g_error;
		}
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = secret_item_get_secret (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		_secret_value_unref0 (self->priv->_item_secret);
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_item_secret = _tmp1_;
#line 188 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_notify ((GObject*) self, "has-secret");
#line 798 "gkr-item.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		err = _inner_error_;
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		_inner_error_ = NULL;
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = err;
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = _tmp2_->message;
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		g_warning ("gkr-item.vala:190: Couldn't retrieve secret: %s", _tmp3_);
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_error_free0 (err);
#line 818 "gkr-item.c"
	}
	__finally2:
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_inner_error_ != NULL) {
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		g_clear_error (&_inner_error_);
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 829 "gkr-item.c"
	}
}


static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
	___lambda18_ (self, source_object, res);
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (self);
#line 839 "gkr-item.c"
}


static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self) {
	GCancellable* _tmp0_ = NULL;
#line 180 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 181 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_req_secret;
#line 181 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 851 "gkr-item.c"
		GCancellable* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
#line 182 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_cancellable_new ();
#line 182 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_object_unref0 (self->priv->_req_secret);
#line 182 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_req_secret = _tmp1_;
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = self->priv->_req_secret;
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
		secret_item_load_secret ((SecretItem*) self, _tmp2_, ____lambda18__gasync_ready_callback, g_object_ref (self));
#line 864 "gkr-item.c"
	}
}


void seahorse_gkr_item_refresh (SeahorseGkrItem* self) {
	SecretValue* _tmp0_ = NULL;
#line 197 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 198 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_refresh (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 199 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 199 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 200 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_load_item_secret (self);
#line 881 "gkr-item.c"
	}
}


static gpointer _secret_value_ref0 (gpointer self) {
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? secret_value_ref (self) : NULL;
#line 889 "gkr-item.c"
}


SecretValue* seahorse_gkr_item_get_secret (SeahorseGkrItem* self) {
	SecretValue* result = NULL;
	SecretValue* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
#line 203 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 204 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 204 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 205 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_load_item_secret (self);
#line 906 "gkr-item.c"
	}
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = self->priv->_item_secret;
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _secret_value_ref0 (_tmp1_);
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 916 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_attribute (SeahorseGkrItem* self, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp0_, NULL);
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = _tmp0_;
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (_tmp2_);
#line 210 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_) {
#line 211 "/data/src/seahorse/gkr/gkr-item.vala"
		result = NULL;
#line 211 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 953 "gkr-item.c"
	}
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = _tmp4_;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp5_;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = name;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = _tmp9_;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (_tmp6_);
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp10_;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 975 "gkr-item.c"
}


static void seahorse_gkr_item_set_secret_data_free (gpointer _data) {
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _data;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->value);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->self);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_slice_free (SeahorseGkrItemSetSecretData, _data_);
#line 990 "gkr-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 997 "gkr-item.c"
}


void seahorse_gkr_item_set_secret (SeahorseGkrItem* self, SecretValue* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
	SeahorseGkrItem* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_slice_new0 (SeahorseGkrItemSetSecretData);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_set_secret);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_set_secret_data_free);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self = _tmp0_;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = value;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _secret_value_ref0 (_tmp1_);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->value);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->value = _tmp2_;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = cancellable;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->cancellable = _tmp4_;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_set_secret_co (_data_);
#line 1036 "gkr-item.c"
}


gboolean seahorse_gkr_item_set_secret_finish (SeahorseGkrItem* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemSetSecretData* _data_;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 1047 "gkr-item.c"
	}
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _data_->result;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1055 "gkr-item.c"
}


static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = _user_data_;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_source_object_ = source_object;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_res_ = _res_;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_set_secret_co (_data_);
#line 1069 "gkr-item.c"
}


static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_) {
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (_data_->_state_) {
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
		case 0:
#line 1078 "gkr-item.c"
		goto _state_0;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
		case 1:
#line 1082 "gkr-item.c"
		goto _state_1;
		default:
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 1087 "gkr-item.c"
	}
	_state_0:
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = NULL;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = _data_->value;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = NULL;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_state_ = 1;
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_set_secret (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_tmp0_, _data_->_tmp1_, seahorse_gkr_item_set_secret_ready, _data_);
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 1104 "gkr-item.c"
	_state_1:
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_set_secret_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_res_, &_data_->_inner_error_);
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_inner_error_ != NULL) {
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
		g_error_free (_data_->_inner_error_);
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_data_->_state_ == 0) {
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1118 "gkr-item.c"
		} else {
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1122 "gkr-item.c"
		}
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_unref (_data_->_async_result);
#line 217 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 1128 "gkr-item.c"
	}
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = NULL;
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = _data_->value;
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp3_ = NULL;
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp3_ = _secret_value_ref0 (_data_->_tmp2_);
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->self->priv->_item_secret);
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self->priv->_item_secret = _data_->_tmp3_;
#line 219 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) _data_->self, "has-secret");
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->result = TRUE;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1150 "gkr-item.c"
	} else {
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1154 "gkr-item.c"
	}
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1164 "gkr-item.c"
	} else {
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1168 "gkr-item.c"
	}
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 1174 "gkr-item.c"
}


SeahorseGkrItem* seahorse_gkr_item_construct (GType object_type) {
	SeahorseGkrItem * self = NULL;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) g_object_new (object_type, NULL);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	return self;
#line 1184 "gkr-item.c"
}


SeahorseGkrItem* seahorse_gkr_item_new (void) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	return seahorse_gkr_item_construct (SEAHORSE_GKR_TYPE_ITEM);
#line 1191 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_description (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 51 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 53 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 53 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = (*_tmp0_).description;
#line 53 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 53 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 53 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1214 "gkr-item.c"
}


SeahorseGkrUse seahorse_gkr_item_get_use (SeahorseGkrItem* self) {
	SeahorseGkrUse result;
	gchar* schema_name = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 58 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 59 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = seahorse_gkr_item_get_attribute (self, "xdg:schema");
#line 59 "/data/src/seahorse/gkr/gkr-item.vala"
	schema_name = _tmp0_;
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = schema_name;
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ != NULL) {
#line 1235 "gkr-item.c"
		const gchar* _tmp3_ = NULL;
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = schema_name;
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, SEAHORSE_GKR_NETWORK_PASSWORD) == 0;
#line 1241 "gkr-item.c"
	} else {
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = FALSE;
#line 1245 "gkr-item.c"
	}
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp1_;
#line 60 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_) {
#line 61 "/data/src/seahorse/gkr/gkr-item.vala"
		result = SEAHORSE_GKR_USE_NETWORK;
#line 61 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (schema_name);
#line 61 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1257 "gkr-item.c"
	}
#line 62 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_GKR_USE_OTHER;
#line 62 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (schema_name);
#line 62 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1265 "gkr-item.c"
}


gboolean seahorse_gkr_item_get_has_secret (SeahorseGkrItem* self) {
	gboolean result;
	SecretValue* _tmp0_ = NULL;
#line 67 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 67 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp0_ != NULL;
#line 67 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1280 "gkr-item.c"
}


SeahorseGkrKeyring* seahorse_gkr_item_get_place (SeahorseGkrItem* self) {
	SeahorseGkrKeyring* result;
	GObject* _tmp0_ = NULL;
#line 71 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = g_weak_ref_get (&self->priv->_place);
#line 71 "/data/src/seahorse/gkr/gkr-item.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
#line 71 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1295 "gkr-item.c"
}


void seahorse_gkr_item_set_place (SeahorseGkrItem* self, SeahorseGkrKeyring* value) {
	SeahorseGkrKeyring* _tmp0_ = NULL;
#line 72 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 72 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = value;
#line 72 "/data/src/seahorse/gkr/gkr-item.vala"
	g_weak_ref_set (&self->priv->_place, (GObject*) _tmp0_);
#line 72 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject *) self, "place");
#line 1309 "gkr-item.c"
}


SeahorseFlags seahorse_gkr_item_get_object_flags (SeahorseGkrItem* self) {
	SeahorseFlags result;
#line 76 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_FLAG_DELETABLE | SEAHORSE_FLAG_PERSONAL;
#line 76 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1321 "gkr-item.c"
}


GIcon* seahorse_gkr_item_get_icon (SeahorseGkrItem* self) {
	GIcon* result;
	GThemedIcon* _tmp0_ = NULL;
#line 80 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (SEAHORSE_ICON_PASSWORD);
#line 80 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (GIcon*) _tmp0_;
#line 80 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1336 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_label (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 84 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 86 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 86 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = (*_tmp0_).label;
#line 86 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 86 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 86 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1359 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_markup (SeahorseGkrItem* self) {
	gchar* result;
	GString* _result_ = NULL;
	GString* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SeahorseGkrDisplayInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 91 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 93 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = g_string_new ("");
#line 93 "/data/src/seahorse/gkr/gkr-item.vala"
	_result_ = _tmp0_;
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = self->priv->_info;
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*_tmp1_).label;
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) (-1));
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp3_;
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, _tmp4_);
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (_tmp4_);
#line 95 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, "<span size='small' rise='0' foreground='#555555'>\n");
#line 96 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = self->priv->_info;
#line 96 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*_tmp5_).details;
#line 96 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, _tmp6_);
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, "</span>");
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = _result_->str;
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp8_;
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_string_free0 (_result_);
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1415 "gkr-item.c"
}


SeahorseUsage seahorse_gkr_item_get_usage (SeahorseGkrItem* self) {
	SeahorseUsage result;
#line 103 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 103 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_USAGE_CREDENTIALS;
#line 103 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1427 "gkr-item.c"
}


GtkActionGroup* seahorse_gkr_item_get_actions (SeahorseGkrItem* self) {
	GtkActionGroup* result;
#line 107 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/data/src/seahorse/gkr/gkr-item.vala"
	result = NULL;
#line 107 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1439 "gkr-item.c"
}


static gboolean seahorse_gkr_item_real_get_deletable (SeahorseDeletable* base) {
	gboolean result;
	SeahorseGkrItem* self;
#line 111 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 111 "/data/src/seahorse/gkr/gkr-item.vala"
	result = TRUE;
#line 111 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1452 "gkr-item.c"
}


static void _seahorse_gkr_item___lambda28_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1) {
#line 120 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (changed_properties != NULL);
#line 121 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 121 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = NULL;
#line 122 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_freeze_notify ((GObject*) self);
#line 123 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "has-secret");
#line 124 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "use");
#line 125 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "label");
#line 126 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "icon");
#line 127 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "markup");
#line 128 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "description");
#line 129 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "object-flags");
#line 130 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_thaw_notify ((GObject*) self);
#line 1481 "gkr-item.c"
}


static void __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
#line 120 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_item___lambda28_ (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
#line 1488 "gkr-item.c"
}


static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItem * self;
#line 119 "/data/src/seahorse/gkr/gkr-item.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_parent_class);
#line 119 "/data/src/seahorse/gkr/gkr-item.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 119 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 120 "/data/src/seahorse/gkr/gkr-item.vala"
	g_signal_connect_object ((GDBusProxy*) self, "g-properties-changed", (GCallback) __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed, self, 0);
#line 119 "/data/src/seahorse/gkr/gkr-item.vala"
	return obj;
#line 1506 "gkr-item.c"
}


static void seahorse_gkr_item_class_init (SeahorseGkrItemClass * klass) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_parent_class = g_type_class_peek_parent (klass);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemPrivate));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_gkr_item_real_dispose;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_get_property;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_set_property;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_constructor;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_finalize;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USE, g_param_spec_enum ("use", "use", "use", SEAHORSE_GKR_TYPE_USE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_HAS_SECRET, g_param_spec_boolean ("has-secret", "has-secret", "has-secret", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PLACE, g_param_spec_object ("place", "place", "place", SEAHORSE_GKR_TYPE_KEYRING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_OBJECT_FLAGS, g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_MARKUP, g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USAGE, g_param_spec_enum ("usage", "usage", "usage", SEAHORSE_TYPE_USAGE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ACTIONS, g_param_spec_object ("actions", "actions", "actions", GTK_TYPE_ACTION_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DELETABLE, g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1547 "gkr-item.c"
}


static void seahorse_gkr_item_seahorse_deletable_interface_init (SeahorseDeletableIface * iface) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->create_deleter = (SeahorseDeleter* (*)(SeahorseDeletable*)) seahorse_gkr_item_real_create_deleter;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->get_deletable = seahorse_gkr_item_real_get_deletable;
#line 1558 "gkr-item.c"
}


static void seahorse_gkr_item_seahorse_viewable_interface_init (SeahorseViewableIface * iface) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->create_viewer = (GtkWindow* (*)(SeahorseViewable*, GtkWindow*)) seahorse_gkr_item_real_create_viewer;
#line 1567 "gkr-item.c"
}


static void seahorse_gkr_item_instance_init (SeahorseGkrItem * self) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv = SEAHORSE_GKR_ITEM_GET_PRIVATE (self);
#line 114 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_item_secret = NULL;
#line 115 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = NULL;
#line 117 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_req_secret = NULL;
#line 1580 "gkr-item.c"
}


static void seahorse_gkr_item_finalize (GObject* obj) {
	SeahorseGkrItem * self;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 114 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (self->priv->_item_secret);
#line 115 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 116 "/data/src/seahorse/gkr/gkr-item.vala"
	g_weak_ref_clear (&self->priv->_place);
#line 117 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (self->priv->_req_secret);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->finalize (obj);
#line 1598 "gkr-item.c"
}


GType seahorse_gkr_item_get_type (void) {
	static volatile gsize seahorse_gkr_item_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItem), 0, (GInstanceInitFunc) seahorse_gkr_item_instance_init, NULL };
		static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_item_type_id;
		seahorse_gkr_item_type_id = g_type_register_static (secret_item_get_type (), "SeahorseGkrItem", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
		g_once_init_leave (&seahorse_gkr_item_type_id__volatile, seahorse_gkr_item_type_id);
	}
	return seahorse_gkr_item_type_id__volatile;
}


static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (property_id) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_DESCRIPTION:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_description (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_USE:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_enum (value, seahorse_gkr_item_get_use (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_HAS_SECRET:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_boolean (value, seahorse_gkr_item_get_has_secret (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_PLACE:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_object (value, seahorse_gkr_item_get_place (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_OBJECT_FLAGS:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_flags (value, seahorse_gkr_item_get_object_flags (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_ICON:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_object (value, seahorse_gkr_item_get_icon (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_LABEL:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_label (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_MARKUP:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_markup (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_USAGE:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_enum (value, seahorse_gkr_item_get_usage (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_ACTIONS:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_object (value, seahorse_gkr_item_get_actions (self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_DELETABLE:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1689 "gkr-item.c"
		default:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1695 "gkr-item.c"
	}
}


static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (property_id) {
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_PLACE:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_set_place (self, g_value_get_object (value));
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1711 "gkr-item.c"
		default:
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 49 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1717 "gkr-item.c"
	}
}


gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 236 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 238 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 238 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 239 "/data/src/seahorse/gkr/gkr-item.vala"
		result = NULL;
#line 239 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1739 "gkr-item.c"
	}
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = name;
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp4_;
#line 240 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1753 "gkr-item.c"
}


gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name) {
	gint result = 0;
	GHashTable* _tmp0_ = NULL;
	gchar* value = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 246 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 246 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 247 "/data/src/seahorse/gkr/gkr-item.vala"
		result = 0;
#line 247 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1776 "gkr-item.c"
	}
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = name;
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	value = _tmp4_;
#line 250 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = value;
#line 250 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp5_ != NULL) {
#line 1792 "gkr-item.c"
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 251 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = value;
#line 251 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = atoi (_tmp6_);
#line 251 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp7_;
#line 251 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (value);
#line 251 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1805 "gkr-item.c"
	}
#line 253 "/data/src/seahorse/gkr/gkr-item.vala"
	result = 0;
#line 253 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (value);
#line 253 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1813 "gkr-item.c"
}


gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match) {
	gboolean result = FALSE;
	gchar* protocol = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 256 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 259 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 259 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "protocol");
#line 259 "/data/src/seahorse/gkr/gkr-item.vala"
	protocol = _tmp1_;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = protocol;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_ != NULL) {
#line 1837 "gkr-item.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = protocol;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = match;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = g_ascii_strcasecmp (_tmp4_, _tmp5_);
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _tmp6_ == 0;
#line 1849 "gkr-item.c"
	} else {
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 1853 "gkr-item.c"
	}
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = _tmp2_;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp7_;
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (protocol);
#line 260 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1863 "gkr-item.c"
}


gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GString* generated = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GString* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp10_ = NULL;
	GString* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 276 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = server;
#line 276 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 277 "/data/src/seahorse/gkr/gkr-item.vala"
		result = TRUE;
#line 277 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1888 "gkr-item.c"
	}
#line 279 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_string_new ("");
#line 279 "/data/src/seahorse/gkr/gkr-item.vala"
	generated = _tmp1_;
#line 280 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = user;
#line 280 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ != NULL) {
#line 1898 "gkr-item.c"
		GString* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 281 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = generated;
#line 281 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = user;
#line 281 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp3_, "%s@", _tmp4_);
#line 1907 "gkr-item.c"
	}
#line 282 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = generated;
#line 282 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = server;
#line 282 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_tmp5_, _tmp6_);
#line 283 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = port;
#line 283 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp7_ != 0) {
#line 1919 "gkr-item.c"
		GString* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = generated;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = port;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp8_, ":%d", _tmp9_);
#line 1928 "gkr-item.c"
	}
#line 285 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = object;
#line 285 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_ != NULL) {
#line 1934 "gkr-item.c"
		GString* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 286 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = generated;
#line 286 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = object;
#line 286 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp11_, "/%s", _tmp12_);
#line 1943 "gkr-item.c"
	}
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = generated;
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = _tmp13_->str;
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = display;
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	result = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_string_free0 (generated);
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1957 "gkr-item.c"
}


gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = seahorse_gkr_is_network_item (_tmp1_, "http");
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_) {
#line 1973 "gkr-item.c"
		GHashTable* _tmp3_ = NULL;
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = attrs;
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 1979 "gkr-item.c"
	} else {
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = FALSE;
#line 1983 "gkr-item.c"
	}
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp0_;
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_) {
#line 1989 "gkr-item.c"
		gchar* val = NULL;
		GHashTable* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 296 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = attrs;
#line 296 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = seahorse_gkr_get_attribute_string (_tmp5_, "object");
#line 296 "/data/src/seahorse/gkr/gkr-item.vala"
		val = _tmp6_;
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = val;
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp8_ != NULL) {
#line 2007 "gkr-item.c"
			const gchar* _tmp9_ = NULL;
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp9_ = val;
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 2013 "gkr-item.c"
		} else {
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = FALSE;
#line 2017 "gkr-item.c"
		}
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = _tmp7_;
#line 297 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp10_) {
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
			result = val;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
			return result;
#line 2027 "gkr-item.c"
		}
#line 301 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = always;
#line 301 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp11_) {
#line 2033 "gkr-item.c"
			GHashTable* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 302 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp12_ = attrs;
#line 302 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp13_ = seahorse_gkr_get_attribute_string (_tmp12_, "server");
#line 302 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (val);
#line 302 "/data/src/seahorse/gkr/gkr-item.vala"
			val = _tmp13_;
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp15_ = val;
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp15_ != NULL) {
#line 2051 "gkr-item.c"
				const gchar* _tmp16_ = NULL;
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = val;
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
#line 2057 "gkr-item.c"
			} else {
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp14_ = FALSE;
#line 2061 "gkr-item.c"
			}
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = _tmp14_;
#line 303 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp17_) {
#line 304 "/data/src/seahorse/gkr/gkr-item.vala"
				result = val;
#line 304 "/data/src/seahorse/gkr/gkr-item.vala"
				return result;
#line 2071 "gkr-item.c"
			}
		}
#line 295 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (val);
#line 2076 "gkr-item.c"
	}
#line 308 "/data/src/seahorse/gkr/gkr-item.vala"
	result = NULL;
#line 308 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 2082 "gkr-item.c"
}


void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* server = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* protocol = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* object = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* user = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint port = 0;
	GHashTable* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	SeahorseGkrDisplayInfo _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	gchar* symbol = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp32_ = FALSE;
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 315 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 315 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "server");
#line 315 "/data/src/seahorse/gkr/gkr-item.vala"
	server = _tmp1_;
#line 316 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = attrs;
#line 316 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = seahorse_gkr_get_attribute_string (_tmp2_, "protocol");
#line 316 "/data/src/seahorse/gkr/gkr-item.vala"
	protocol = _tmp3_;
#line 317 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = attrs;
#line 317 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = seahorse_gkr_get_attribute_string (_tmp4_, "object");
#line 317 "/data/src/seahorse/gkr/gkr-item.vala"
	object = _tmp5_;
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = attrs;
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "user");
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	user = _tmp7_;
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = attrs;
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = seahorse_gkr_get_attribute_int (_tmp8_, "port");
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	port = _tmp9_;
#line 321 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = protocol;
#line 321 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_ == NULL) {
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (user);
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (object);
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (protocol);
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (server);
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 2164 "gkr-item.c"
	}
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp11_ = server;
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp12_ = user;
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = object;
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = port;
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = display;
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp16_ = seahorse_gkr_is_custom_network_label (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
	if (!_tmp16_) {
#line 2180 "gkr-item.c"
		GHashTable* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 326 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp17_ = attrs;
#line 326 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp18_ = seahorse_gkr_calc_network_label (_tmp17_, TRUE);
#line 326 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 326 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp18_;
#line 2191 "gkr-item.c"
	}
#line 327 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp19_ = *info;
#line 327 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp20_ = _tmp19_.label;
#line 327 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp20_ == NULL) {
#line 2199 "gkr-item.c"
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp21_ = display;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp22_;
#line 2210 "gkr-item.c"
	}
#line 330 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp23_ = g_strdup ("@");
#line 330 "/data/src/seahorse/gkr/gkr-item.vala"
	symbol = _tmp23_;
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp24_ = user;
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp24_ == NULL) {
#line 2220 "gkr-item.c"
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 332 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp25_ = g_strdup ("");
#line 332 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (user);
#line 332 "/data/src/seahorse/gkr/gkr-item.vala"
		user = _tmp25_;
#line 333 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp26_ = g_strdup ("");
#line 333 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (symbol);
#line 333 "/data/src/seahorse/gkr/gkr-item.vala"
		symbol = _tmp26_;
#line 2235 "gkr-item.c"
	}
#line 336 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp27_ = object;
#line 336 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp27_ == NULL) {
#line 2241 "gkr-item.c"
		gchar* _tmp28_ = NULL;
#line 337 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp28_ = g_strdup ("");
#line 337 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (object);
#line 337 "/data/src/seahorse/gkr/gkr-item.vala"
		object = _tmp28_;
#line 2249 "gkr-item.c"
	}
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp30_ = server;
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp30_ != NULL) {
#line 2255 "gkr-item.c"
		const gchar* _tmp31_ = NULL;
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp31_ = protocol;
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = _tmp31_ != NULL;
#line 2261 "gkr-item.c"
	} else {
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = FALSE;
#line 2265 "gkr-item.c"
	}
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp32_ = _tmp29_;
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp32_) {
#line 2271 "gkr-item.c"
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp33_ = protocol;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp34_ = user;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp35_ = symbol;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = server;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp37_ = object;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp38_ = g_markup_printf_escaped ("%s://%s%s%s/%s", _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp38_;
#line 2294 "gkr-item.c"
	}
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (symbol);
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (user);
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (object);
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (protocol);
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (server);
#line 2306 "gkr-item.c"
}


void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* origin = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	SeahorseGkrDisplayInfo _tmp18_ = {0};
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 346 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 350 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 350 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "origin_url");
#line 350 "/data/src/seahorse/gkr/gkr-item.vala"
	origin = _tmp1_;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = display;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_ != NULL) {
#line 2333 "gkr-item.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = display;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = origin;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2342 "gkr-item.c"
	} else {
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 2346 "gkr-item.c"
	}
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp2_;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp6_) {
#line 2352 "gkr-item.c"
		{
			GRegex* regex = NULL;
			GRegex* _tmp7_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GMatchInfo* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = g_regex_new ("[a-z]+://([^/]+)/", G_REGEX_CASELESS, 0, &_inner_error_);
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp7_;
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2369 "gkr-item.c"
					goto __catch3_g_regex_error;
				}
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (origin);
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 355 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 2380 "gkr-item.c"
			}
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp8_ = regex;
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp9_ = display;
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp11_ = g_regex_match (_tmp8_, _tmp9_, G_REGEX_MATCH_ANCHORED, &_tmp10_);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp10_;
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp11_) {
#line 2394 "gkr-item.c"
				GMatchInfo* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp12_ = match;
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp13_ = g_match_info_matches (_tmp12_);
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp13_) {
#line 2403 "gkr-item.c"
					GMatchInfo* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 359 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp14_ = match;
#line 359 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp15_ = g_match_info_fetch (_tmp14_, 1);
#line 359 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).label);
#line 359 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).label = _tmp15_;
#line 2414 "gkr-item.c"
				}
			}
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 2421 "gkr-item.c"
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp16_ = err;
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = _tmp16_->message;
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:362: %s", _tmp17_);
#line 363 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 363 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (origin);
#line 363 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 2445 "gkr-item.c"
		}
		__finally3:
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (origin);
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 354 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 2458 "gkr-item.c"
		}
	}
#line 368 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp18_ = *info;
#line 368 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp19_ = _tmp18_.label;
#line 368 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp19_ == NULL) {
#line 2467 "gkr-item.c"
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 369 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp20_ = display;
#line 369 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp21_ = g_strdup (_tmp20_);
#line 369 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 369 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp21_;
#line 2478 "gkr-item.c"
	}
#line 370 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp22_ = origin;
#line 370 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp22_ != NULL) {
#line 2484 "gkr-item.c"
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp23_ = origin;
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) (-1));
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp24_;
#line 2495 "gkr-item.c"
	} else {
		gchar* _tmp25_ = NULL;
#line 373 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp25_ = g_strdup ("");
#line 373 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 373 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp25_;
#line 2504 "gkr-item.c"
	}
#line 346 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (origin);
#line 2508 "gkr-item.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2521 "gkr-item.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2551 "gkr-item.c"
				goto __catch4_g_regex_error;
			}
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 2560 "gkr-item.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2576 "gkr-item.c"
				goto __catch4_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 2587 "gkr-item.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2595 "gkr-item.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1246 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2609 "gkr-item.c"
	}
	__finally4:
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return NULL;
#line 2620 "gkr-item.c"
	}
}


gchar* seahorse_gkr_decode_telepathy_id (const gchar* account) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 376 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (account != NULL, NULL);
#line 377 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = account;
#line 377 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = string_replace (_tmp0_, "_", "%");
#line 377 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 377 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (_tmp2_);
#line 378 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = account;
#line 378 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_uri_unescape_string (_tmp3_, NULL);
#line 378 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp4_;
#line 378 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 2650 "gkr-item.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 918 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 921 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 921 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2675 "gkr-item.c"
		gchar* _tmp4_ = NULL;
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2683 "gkr-item.c"
	} else {
#line 924 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 924 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2689 "gkr-item.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2725 "gkr-item.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2734 "gkr-item.c"
	}
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2740 "gkr-item.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2749 "gkr-item.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2755 "gkr-item.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2764 "gkr-item.c"
	} else {
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2768 "gkr-item.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 2778 "gkr-item.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 2787 "gkr-item.c"
	} else {
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 2791 "gkr-item.c"
	}
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 2815 "gkr-item.c"
}


void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	SeahorseGkrDisplayInfo _tmp34_ = {0};
	const gchar* _tmp35_ = NULL;
	SeahorseGkrDisplayInfo _tmp38_ = {0};
	const gchar* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 385 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 385 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account-id");
#line 385 "/data/src/seahorse/gkr/gkr-item.vala"
	account = _tmp1_;
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _ ("IM account password for ");
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	prefix = _tmp3_;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = display;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp5_ != NULL) {
#line 2852 "gkr-item.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = display;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = prefix;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = _tmp8_;
#line 2864 "gkr-item.c"
	} else {
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = FALSE;
#line 2868 "gkr-item.c"
	}
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = _tmp4_;
#line 390 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp9_) {
#line 2874 "gkr-item.c"
		gint len = 0;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint pos = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = prefix;
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = strlen (_tmp10_);
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = _tmp11_;
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
		len = _tmp12_;
#line 392 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp13_ = display;
#line 392 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp14_ = len;
#line 392 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp15_ = string_index_of_char (_tmp13_, (gunichar) '(', (gint) _tmp14_);
#line 392 "/data/src/seahorse/gkr/gkr-item.vala"
		pos = _tmp15_;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp16_ = pos;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp16_ != (-1)) {
#line 2904 "gkr-item.c"
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = display;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp18_ = len;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp19_ = pos;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp20_ = string_slice (_tmp17_, (glong) _tmp18_, (glong) _tmp19_);
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 ((*info).label);
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
			(*info).label = _tmp20_;
#line 2921 "gkr-item.c"
		}
		{
			GRegex* regex = NULL;
			GRegex* _tmp21_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			GMatchInfo* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp21_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp21_;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2939 "gkr-item.c"
					goto __catch5_g_regex_error;
				}
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (prefix);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (account);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 2952 "gkr-item.c"
			}
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp22_ = regex;
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp23_ = account;
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp25_ = g_regex_match (_tmp22_, _tmp23_, G_REGEX_MATCH_ANCHORED, &_tmp24_);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp24_;
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp25_) {
#line 2966 "gkr-item.c"
				GMatchInfo* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp26_ = match;
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp27_ = g_match_info_matches (_tmp26_);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp27_) {
#line 2975 "gkr-item.c"
					GMatchInfo* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp28_ = match;
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp29_ = g_match_info_fetch (_tmp28_, 1);
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp30_ = _tmp29_;
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp31_ = seahorse_gkr_decode_telepathy_id (_tmp30_);
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).details);
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).details = _tmp31_;
#line 401 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (_tmp30_);
#line 2994 "gkr-item.c"
				}
			}
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 3001 "gkr-item.c"
		}
		goto __finally5;
		__catch5_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp32_ = err;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp33_ = _tmp32_->message;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:404: %s", _tmp33_);
#line 405 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 405 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (prefix);
#line 405 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 405 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3027 "gkr-item.c"
		}
		__finally5:
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (prefix);
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3042 "gkr-item.c"
		}
	}
#line 409 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp34_ = *info;
#line 409 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp35_ = _tmp34_.label;
#line 409 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp35_ == NULL) {
#line 3051 "gkr-item.c"
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
#line 410 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = display;
#line 410 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 410 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 410 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp37_;
#line 3062 "gkr-item.c"
	}
#line 411 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp38_ = *info;
#line 411 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp39_ = _tmp38_.details;
#line 411 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp39_ == NULL) {
#line 3070 "gkr-item.c"
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp40_ = account;
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp41_ = g_markup_escape_text (_tmp40_, (gssize) (-1));
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp41_;
#line 3081 "gkr-item.c"
	}
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (prefix);
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (account);
#line 3087 "gkr-item.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 3114 "gkr-item.c"
		gchar* _tmp4_ = NULL;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 3122 "gkr-item.c"
	} else {
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 3128 "gkr-item.c"
	}
}


void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_ = FALSE;
	SeahorseGkrDisplayInfo _tmp24_ = {0};
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 419 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 419 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account");
#line 419 "/data/src/seahorse/gkr/gkr-item.vala"
	account = _tmp1_;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = account;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_ != NULL) {
#line 3158 "gkr-item.c"
		const gchar* _tmp5_ = NULL;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = display;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = _tmp5_ != NULL;
#line 3164 "gkr-item.c"
	} else {
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = FALSE;
#line 3168 "gkr-item.c"
	}
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp3_;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp6_) {
#line 3174 "gkr-item.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = display;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = account;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = string_index_of (_tmp7_, _tmp8_, 0);
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _tmp9_ != (-1);
#line 3186 "gkr-item.c"
	} else {
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 3190 "gkr-item.c"
	}
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = _tmp2_;
#line 420 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_) {
#line 3196 "gkr-item.c"
		{
			GRegex* regex = NULL;
			GRegex* _tmp11_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GMatchInfo* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp11_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp11_;
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3213 "gkr-item.c"
					goto __catch6_g_regex_error;
				}
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (account);
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 3224 "gkr-item.c"
			}
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp12_ = regex;
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp13_ = account;
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp15_ = g_regex_match (_tmp12_, _tmp13_, G_REGEX_MATCH_ANCHORED, &_tmp14_);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp14_;
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp15_) {
#line 3238 "gkr-item.c"
				GMatchInfo* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = match;
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp17_ = g_match_info_matches (_tmp16_);
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp17_) {
#line 3247 "gkr-item.c"
					gchar* identifier = NULL;
					GMatchInfo* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
#line 426 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp18_ = match;
#line 426 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp19_ = g_match_info_fetch (_tmp18_, 1);
#line 426 "/data/src/seahorse/gkr/gkr-item.vala"
					identifier = _tmp19_;
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp20_ = identifier;
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp21_ = seahorse_gkr_decode_telepathy_id (_tmp20_);
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).label);
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).label = _tmp21_;
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (identifier);
#line 3269 "gkr-item.c"
				}
			}
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 3276 "gkr-item.c"
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 431 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp22_ = err;
#line 431 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp23_ = _tmp22_->message;
#line 431 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:431: %s", _tmp23_);
#line 432 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 432 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 432 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3300 "gkr-item.c"
		}
		__finally6:
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 421 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3313 "gkr-item.c"
		}
	}
#line 436 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp24_ = *info;
#line 436 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp25_ = _tmp24_.label;
#line 436 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp25_ == NULL) {
#line 3322 "gkr-item.c"
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
#line 437 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp26_ = display;
#line 437 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 437 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 437 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp27_;
#line 3333 "gkr-item.c"
	}
#line 438 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp28_ = account;
#line 438 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp28_ != NULL) {
#line 3339 "gkr-item.c"
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = account;
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp30_ = g_markup_escape_text (_tmp29_, (gssize) (-1));
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp30_;
#line 3350 "gkr-item.c"
	}
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (account);
#line 3354 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).mapped_type;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).mapped_type);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).mapped_type = _tmp3_;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).match_attribute;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).match_attribute);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).match_attribute = _tmp5_;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*self).match_pattern;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).match_pattern);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).match_pattern = _tmp7_;
#line 3399 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self) {
#line 458 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 459 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).mapped_type);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).match_attribute);
#line 461 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).match_pattern);
#line 3412 "gkr-item.c"
}


SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self) {
	SeahorseGkrMappingEntry* dup;
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrMappingEntry, 1);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_mapping_entry_copy (self, dup);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 3424 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self) {
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_mapping_entry_destroy (self);
#line 457 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 3433 "gkr-item.c"
}


GType seahorse_gkr_mapping_entry_get_type (void) {
	static volatile gsize seahorse_gkr_mapping_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_mapping_entry_type_id__volatile)) {
		GType seahorse_gkr_mapping_entry_type_id;
		seahorse_gkr_mapping_entry_type_id = g_boxed_type_register_static ("SeahorseGkrMappingEntry", (GBoxedCopyFunc) seahorse_gkr_mapping_entry_dup, (GBoxedFreeFunc) seahorse_gkr_mapping_entry_free);
		g_once_init_leave (&seahorse_gkr_mapping_entry_type_id__volatile, seahorse_gkr_mapping_entry_type_id);
	}
	return seahorse_gkr_mapping_entry_type_id__volatile;
}


gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
#line 477 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = item_type;
#line 477 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 3458 "gkr-item.c"
		gchar* _tmp1_ = NULL;
#line 478 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_strdup (SEAHORSE_GKR_GENERIC_SECRET);
#line 478 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp1_;
#line 478 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3466 "gkr-item.c"
	}
#line 479 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = attrs;
#line 479 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ == NULL) {
#line 3472 "gkr-item.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = item_type;
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp4_;
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3483 "gkr-item.c"
	}
	{
		SeahorseGkrMappingEntry* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
		mapping_collection = SEAHORSE_GKR_MAPPING_ENTRIES;
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
		mapping_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES);
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
		for (mapping_it = 0; mapping_it < G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES); mapping_it = mapping_it + 1) {
#line 3496 "gkr-item.c"
			SeahorseGkrMappingEntry mapping = {0};
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
			mapping = mapping_collection[mapping_it];
#line 3500 "gkr-item.c"
			{
				const gchar* _tmp5_ = NULL;
				SeahorseGkrMappingEntry _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp5_ = item_type;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp6_ = mapping;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp7_ = _tmp6_.item_type;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
				if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 3513 "gkr-item.c"
					gchar* value = NULL;
					GHashTable* _tmp8_ = NULL;
					SeahorseGkrMappingEntry _tmp9_ = {0};
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 484 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp8_ = attrs;
#line 484 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp9_ = mapping;
#line 484 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp10_ = _tmp9_.match_attribute;
#line 484 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp11_ = seahorse_gkr_get_attribute_string (_tmp8_, _tmp10_);
#line 484 "/data/src/seahorse/gkr/gkr-item.vala"
					value = _tmp11_;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp13_ = value;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp13_ != NULL) {
#line 3536 "gkr-item.c"
						SeahorseGkrMappingEntry _tmp14_ = {0};
						const gchar* _tmp15_ = NULL;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp14_ = mapping;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp15_ = _tmp14_.match_pattern;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp12_ = _tmp15_ != NULL;
#line 3545 "gkr-item.c"
					} else {
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp12_ = FALSE;
#line 3549 "gkr-item.c"
					}
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp16_ = _tmp12_;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp16_) {
#line 3555 "gkr-item.c"
						SeahorseGkrMappingEntry _tmp17_ = {0};
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						gboolean _tmp20_ = FALSE;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp17_ = mapping;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp18_ = _tmp17_.match_pattern;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp19_ = value;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp20_ = g_pattern_match_simple (_tmp18_, _tmp19_);
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
						if (_tmp20_) {
#line 3570 "gkr-item.c"
							SeahorseGkrMappingEntry _tmp21_ = {0};
							const gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp21_ = mapping;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp22_ = _tmp21_.mapped_type;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp23_ = g_strdup (_tmp22_);
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							result = _tmp23_;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							_g_free0 (value);
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
							return result;
#line 3586 "gkr-item.c"
						}
					} else {
						const gchar* _tmp24_ = NULL;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp24_ = value;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						if (_tmp24_ != NULL) {
#line 3594 "gkr-item.c"
							SeahorseGkrMappingEntry _tmp25_ = {0};
							const gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp25_ = mapping;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp26_ = _tmp25_.mapped_type;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp27_ = g_strdup (_tmp26_);
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							result = _tmp27_;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							_g_free0 (value);
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
							return result;
#line 3610 "gkr-item.c"
						}
					}
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (value);
#line 3615 "gkr-item.c"
				}
			}
		}
	}
#line 494 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp28_ = item_type;
#line 494 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 494 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp29_;
#line 494 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3628 "gkr-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 498 "/data/src/seahorse/gkr/gkr-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3635 "gkr-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 498 "/data/src/seahorse/gkr/gkr-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 498 "/data/src/seahorse/gkr/gkr-item.vala"
	g_list_free (self);
#line 3644 "gkr-item.c"
}


static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent) {
	SeahorseGkrItemDeleter * self;
	GtkDialog* result = NULL;
	guint num = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_items;
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	num = _tmp1_;
#line 502 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = num;
#line 502 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ == ((guint) 1)) {
#line 3667 "gkr-item.c"
		gchar* label = NULL;
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GtkWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		SeahorseDeleteDialog* _tmp10_ = NULL;
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = self->priv->_items;
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = _tmp3_->data;
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST ((SeahorseGkrItem*) _tmp4_, secret_item_get_type (), SecretItem), "label", &_tmp5_, NULL);
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = _tmp5_;
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
		label = _tmp6_;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = parent;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = _ ("Are you sure you want to delete the password '%s'?");
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = label;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp7_, _tmp8_, _tmp9_, NULL);
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_ref_sink (_tmp10_);
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		result = (GtkDialog*) _tmp10_;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (label);
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3703 "gkr-item.c"
	} else {
		GtkWindow* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		const gchar* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		SeahorseDeleteDialog* _tmp15_ = NULL;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = parent;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = num;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp13_ = ngettext ("Are you sure you want to delete %d password?", "Are you sure you want to delete %d passwords?", (gulong) _tmp12_);
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp14_ = num;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp15_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp11_, _tmp13_, _tmp14_, NULL);
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_ref_sink (_tmp15_);
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		result = (GtkDialog*) _tmp15_;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3726 "gkr-item.c"
	}
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item) {
	SeahorseGkrItemDeleter * self = NULL;
	SeahorseGkrItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 511 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 511 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) seahorse_deleter_construct (object_type);
#line 512 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = item;
#line 512 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) _tmp0_);
#line 512 "/data/src/seahorse/gkr/gkr-item.vala"
	if (!_tmp1_) {
#line 513 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 3747 "gkr-item.c"
	}
#line 511 "/data/src/seahorse/gkr/gkr-item.vala"
	return self;
#line 3751 "gkr-item.c"
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item) {
#line 511 "/data/src/seahorse/gkr/gkr-item.vala"
	return seahorse_gkr_item_deleter_construct (SEAHORSE_GKR_TYPE_ITEM_DELETER, item);
#line 3758 "gkr-item.c"
}


static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base) {
	SeahorseGkrItemDeleter * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
#line 516 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 517 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_items;
#line 517 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp0_;
#line 517 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3774 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj) {
	SeahorseGkrItemDeleter * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
#line 520 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 520 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (obj != NULL, FALSE);
#line 521 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = obj;
#line 521 "/data/src/seahorse/gkr/gkr-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_ITEM)) {
#line 3790 "gkr-item.c"
		GObject* _tmp1_ = NULL;
		SeahorseGkrItem* _tmp2_ = NULL;
#line 522 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = obj;
#line 522 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
#line 522 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_items = g_list_append (self->priv->_items, _tmp2_);
#line 523 "/data/src/seahorse/gkr/gkr-item.vala"
		result = TRUE;
#line 523 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3803 "gkr-item.c"
	}
#line 525 "/data/src/seahorse/gkr/gkr-item.vala"
	result = FALSE;
#line 525 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3809 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data) {
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _data;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->self);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	g_slice_free (SeahorseGkrItemDeleterDeleteData, _data_);
#line 3822 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemDeleter * self;
	SeahorseGkrItemDeleterDeleteData* _data_;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_slice_new0 (SeahorseGkrItemDeleterDeleteData);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_deleter_real_delete);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_deleter_real_delete_data_free);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self = _tmp0_;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = cancellable;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->cancellable = _tmp2_;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_real_delete_co (_data_);
#line 3854 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_delete_finish (SeahorseDeleter* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemDeleterDeleteData* _data_;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 3865 "gkr-item.c"
	}
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _data_->result;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3873 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemDeleterDeleteData* _data_;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = _user_data_;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_source_object_ = source_object;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_res_ = _res_;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_real_delete_co (_data_);
#line 3887 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_) {
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (_data_->_state_) {
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
		case 0:
#line 3896 "gkr-item.c"
		goto _state_0;
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
		case 1:
#line 3900 "gkr-item.c"
		goto _state_1;
		default:
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 3905 "gkr-item.c"
	}
	_state_0:
#line 529 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = NULL;
#line 529 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = _data_->self->priv->_items;
#line 529 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = NULL;
#line 529 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = g_list_copy (_data_->_tmp0_);
#line 529 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->items = _data_->_tmp1_;
#line 530 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = NULL;
#line 530 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = _data_->items;
#line 3922 "gkr-item.c"
	{
#line 530 "/data/src/seahorse/gkr/gkr-item.vala"
		_data_->item_collection = _data_->_tmp2_;
#line 530 "/data/src/seahorse/gkr/gkr-item.vala"
		for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
#line 530 "/data/src/seahorse/gkr/gkr-item.vala"
			_data_->item = (SeahorseGkrItem*) _data_->item_it->data;
#line 3930 "gkr-item.c"
			{
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp3_ = NULL;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp3_ = _data_->item;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp4_ = NULL;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp4_ = _data_->cancellable;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_state_ = 1;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				secret_item_delete ((SecretItem*) _data_->_tmp3_, _data_->_tmp4_, seahorse_gkr_item_deleter_delete_ready, _data_);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				return FALSE;
#line 3946 "gkr-item.c"
				_state_1:
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				secret_item_delete_finish ((SecretItem*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_data_->_inner_error_ != NULL) {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					g_error_free (_data_->_inner_error_);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_list_free0 (_data_->items);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_data_->_state_ == 0) {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3962 "gkr-item.c"
					} else {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3966 "gkr-item.c"
					}
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					g_object_unref (_data_->_async_result);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
					return FALSE;
#line 3972 "gkr-item.c"
				}
			}
		}
	}
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->result = TRUE;
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_list_free0 (_data_->items);
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3985 "gkr-item.c"
	} else {
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3989 "gkr-item.c"
	}
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_list_free0 (_data_->items);
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4001 "gkr-item.c"
	} else {
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4005 "gkr-item.c"
	}
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 4011 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_class_init (SeahorseGkrItemDeleterClass * klass) {
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_parent_class = g_type_class_peek_parent (klass);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemDeleterPrivate));
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->create_confirm = seahorse_gkr_item_deleter_real_create_confirm;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->get_objects = seahorse_gkr_item_deleter_real_get_objects;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->add_object = seahorse_gkr_item_deleter_real_add_object;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->delete = seahorse_gkr_item_deleter_real_delete;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->delete_finish = seahorse_gkr_item_deleter_real_delete_finish;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_deleter_finalize;
#line 4032 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_instance_init (SeahorseGkrItemDeleter * self) {
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv = SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE (self);
#line 4039 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_finalize (GObject* obj) {
	SeahorseGkrItemDeleter * self;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter);
#line 498 "/data/src/seahorse/gkr/gkr-item.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_items);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_deleter_parent_class)->finalize (obj);
#line 4051 "gkr-item.c"
}


GType seahorse_gkr_item_deleter_get_type (void) {
	static volatile gsize seahorse_gkr_item_deleter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_deleter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemDeleter), 0, (GInstanceInitFunc) seahorse_gkr_item_deleter_instance_init, NULL };
		GType seahorse_gkr_item_deleter_type_id;
		seahorse_gkr_item_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrItemDeleter", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_item_deleter_type_id__volatile, seahorse_gkr_item_deleter_type_id);
	}
	return seahorse_gkr_item_deleter_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



