/* gnome-mines.c generated by valac 0.22.1, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <stdio.h>


#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Mines {
	GtkApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	GtkApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkBox* buttons_box;
	GtkButton* play_pause_button;
	GtkImage* play_pause_image;
	GtkLabel* clock_label;
	GtkButton* hint_button;
	GMenu* app_main_menu;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean pause_requested;
	gboolean window_skip_configure;
	History* history;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkDialog* pref_dialog;
	GtkSpinButton* n_mines_spin;
	GtkSpinButton* p_mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GSimpleAction* hint_action;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
	gboolean is_new_game_screen;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};


static gpointer mines_parent_class = NULL;

GType mines_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define MINES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINES, MinesPrivate))
enum  {
	MINES_DUMMY_PROPERTY
};
#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_hint_cb (Mines* self);
static void _mines_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_preferences_cb (Mines* self);
static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mines* mines_new (void);
Mines* mines_construct (GType object_type);
static void mines_real_startup (GApplication* base);
static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event);
static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event);
static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mines_startup_new_game_screen (Mines* self);
static void mines_startup_custom_game_screen (Mines* self);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mines_display_new_game_button (Mines* self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_n_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_n_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_n_mines_limit (Mines* self);
static void mines_p_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_p_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_p_mines_limit (Mines* self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void minefield_set_paused (Minefield* self, gboolean value);
void mines_start (Mines* self);
static void mines_real_shutdown (GApplication* base);
static void mines_real_activate (GApplication* base);
gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
guint minefield_get_n_flags (Minefield* self);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static gboolean mines_can_start_new_game (Mines* self);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
static void mines_start_game (Mines* self);
static void mines_tick_cb (Mines* self);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void mines_marks_changed_cb (Mines* self, Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void mines_explode_cb (Mines* self, Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void mines_cleared_cb (Mines* self, Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
void minefield_hint (Minefield* self);
static void mines_display_unpause_button (Mines* self);
gdouble minefield_get_elapsed (Minefield* self);
static void mines_display_pause_button (Mines* self);
HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gfloat mines_get_p_mines (Mines* self);
static void mines_use_question_toggle_cb (Mines* self, GtkToggleButton* button);
static void mines_use_overmine_toggle_cb (Mines* self, GtkToggleButton* button);
static GtkDialog* mines_create_preferences (Mines* self);
static void mines_pref_response_cb (Mines* self, GtkDialog* dialog, gint response_id);
static void _mines_pref_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean mines_pref_delete_event_cb (Mines* self, GtkWidget* widget, GdkEventAny* event);
static gboolean _mines_pref_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _mines_use_question_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _mines_use_overmine_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void mines_set_mode (Mines* self, gint mode);
gint mines_main (gchar** args, int args_length1);
static void mines_finalize (GObject* obj);
static void _vala_mines_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry MINES_action_entries[9] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"hint", _mines_hint_cb_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"preferences", _mines_preferences_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}};

static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_new_game_cb (self);
}


static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_repeat_size_cb (self);
}


static void _mines_hint_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_hint_cb (self);
}


static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_toggle_pause_cb (self);
}


static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_scores_cb (self);
}


static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_preferences_cb (self);
}


static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_quit_cb (self);
}


static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_help_cb (self);
}


static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_about_cb (self);
}


Mines* mines_construct (GType object_type) {
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.mines", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Mines* mines_new (void) {
	return mines_construct (TYPE_MINES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = mines_window_configure_event_cb (self, event);
	return result;
}


static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mines_window_state_event_cb (self, event);
	return result;
}


static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_out_event_cb (self, event);
	return result;
}


static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_in_event_cb (self, event);
	return result;
}


static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mines_view_button_press_event (self, _sender, event);
	return result;
}


static void mines_real_startup (GApplication* base) {
	Mines * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp14_ = NULL;
	GMenu* _tmp15_ = NULL;
	GMenu* _tmp16_ = NULL;
	GMenu* _tmp17_ = NULL;
	GMenu* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GMenu* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GMenu* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GMenu* section = NULL;
	GMenu* _tmp24_ = NULL;
	GMenu* _tmp25_ = NULL;
	GMenu* _tmp26_ = NULL;
	GMenu* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GMenu* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GMenu* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GMenu* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GtkWindow* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GtkWindow* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	GtkWindow* _tmp39_ = NULL;
	GtkWindow* _tmp40_ = NULL;
	GtkWindow* _tmp41_ = NULL;
	GtkWindow* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GSettings* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	GtkWindow* _tmp52_ = NULL;
	GtkWindow* _tmp53_ = NULL;
	GtkBox* main_vbox = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkWindow* _tmp55_ = NULL;
	GtkBox* view_box = NULL;
	GtkBox* _tmp56_ = NULL;
	MinefieldView* _tmp57_ = NULL;
	MinefieldView* _tmp58_ = NULL;
	GSettings* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	MinefieldView* _tmp61_ = NULL;
	GSettings* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	MinefieldView* _tmp64_ = NULL;
	GSettings* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	MinefieldView* _tmp67_ = NULL;
	MinefieldView* _tmp68_ = NULL;
	GtkAspectFrame* _tmp69_ = NULL;
	GtkAspectFrame* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	History* _tmp74_ = NULL;
	History* _tmp75_ = NULL;
	GtkBox* _tmp76_ = NULL;
	GtkBox* _tmp77_ = NULL;
	GtkBox* _tmp78_ = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkSizeGroup* size = NULL;
	GtkSizeGroup* _tmp80_ = NULL;
	GtkButton* _tmp81_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp83_ = NULL;
	GtkBox* _tmp84_ = NULL;
	GtkLabel* _tmp85_ = NULL;
	GtkBox* _tmp86_ = NULL;
	GtkLabel* _tmp87_ = NULL;
	GtkButton* _tmp88_ = NULL;
	GtkBox* _tmp89_ = NULL;
	GtkButton* _tmp90_ = NULL;
	GtkButton* _tmp91_ = NULL;
	GtkButton* _tmp92_ = NULL;
	GtkButton* _tmp93_ = NULL;
	GtkButton* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	GtkBox* _tmp96_ = NULL;
	GtkButton* _tmp97_ = NULL;
	GtkButton* _tmp98_ = NULL;
	GtkButton* _tmp99_ = NULL;
	GtkBox* _tmp100_ = NULL;
	GtkImage* _tmp101_ = NULL;
	GtkBox* _tmp102_ = NULL;
	GtkImage* _tmp103_ = NULL;
	GtkLabel* _tmp104_ = NULL;
	GtkBox* _tmp105_ = NULL;
	GtkLabel* _tmp106_ = NULL;
	GtkButton* _tmp107_ = NULL;
	GtkBox* _tmp108_ = NULL;
	GtkButton* _tmp109_ = NULL;
	GtkButton* _tmp110_ = NULL;
	GtkButton* _tmp111_ = NULL;
	GtkBox* _tmp112_ = NULL;
	GtkButton* _tmp113_ = NULL;
	GtkButton* _tmp114_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Mines");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_window_set_default_icon_name ("gnome-mines");
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, G_N_ELEMENTS (MINES_action_entries), self);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp3_;
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp6_;
	_tmp7_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "hint");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = _tmp9_;
	_tmp10_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp11_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp12_;
	_tmp13_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	_tmp14_ = g_menu_new ();
	menu = _tmp14_;
	_tmp15_ = g_menu_new ();
	_g_object_unref0 (self->priv->app_main_menu);
	self->priv->app_main_menu = _tmp15_;
	_tmp16_ = menu;
	_tmp17_ = self->priv->app_main_menu;
	g_menu_append_section (_tmp16_, NULL, (GMenuModel*) _tmp17_);
	_tmp18_ = self->priv->app_main_menu;
	_tmp19_ = _ ("_New Game");
	g_menu_append (_tmp18_, _tmp19_, "app.new-game");
	_tmp20_ = self->priv->app_main_menu;
	_tmp21_ = _ ("_Scores");
	g_menu_append (_tmp20_, _tmp21_, "app.scores");
	_tmp22_ = self->priv->app_main_menu;
	_tmp23_ = _ ("_Preferences");
	g_menu_append (_tmp22_, _tmp23_, "app.preferences");
	_tmp24_ = g_menu_new ();
	section = _tmp24_;
	_tmp25_ = menu;
	_tmp26_ = section;
	g_menu_append_section (_tmp25_, NULL, (GMenuModel*) _tmp26_);
	_tmp27_ = section;
	_tmp28_ = _ ("_Help");
	g_menu_append (_tmp27_, _tmp28_, "app.help");
	_tmp29_ = section;
	_tmp30_ = _ ("_About");
	g_menu_append (_tmp29_, _tmp30_, "app.about");
	_tmp31_ = section;
	_tmp32_ = _ ("_Quit");
	g_menu_append (_tmp31_, _tmp32_, "app.quit");
	_tmp33_ = menu;
	gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp33_);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>n", "app.new-game", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>r", "app.repeat-size", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "Pause", "app.pause", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>w", "app.quit", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>q", "app.quit", NULL);
	_tmp34_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp34_;
	_tmp35_ = self->priv->window;
	_tmp36_ = _ ("Mines");
	gtk_window_set_title (_tmp35_, _tmp36_);
	_tmp37_ = self->priv->window;
	gtk_window_set_icon_name (_tmp37_, "gnome-mines");
	_tmp38_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "configure-event", (GCallback) _mines_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp39_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _mines_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp40_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "focus-out-event", (GCallback) _mines_window_focus_out_event_cb_gtk_widget_focus_out_event, self, 0);
	_tmp41_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp41_, "focus-in-event", (GCallback) _mines_window_focus_in_event_cb_gtk_widget_focus_in_event, self, 0);
	_tmp42_ = self->priv->window;
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_int (_tmp43_, "window-width");
	_tmp45_ = self->priv->settings;
	_tmp46_ = g_settings_get_int (_tmp45_, "window-height");
	gtk_window_set_default_size (_tmp42_, _tmp44_, _tmp46_);
	_tmp47_ = self->priv->settings;
	_tmp48_ = g_settings_get_boolean (_tmp47_, "window-is-maximized");
	if (_tmp48_) {
		GtkWindow* _tmp49_ = NULL;
		_tmp49_ = self->priv->window;
		gtk_window_maximize (_tmp49_);
	}
	_tmp50_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp50_);
	headerbar = _tmp50_;
	gtk_header_bar_set_show_close_button (headerbar, TRUE);
	_tmp51_ = _ ("Mines");
	gtk_header_bar_set_title (headerbar, _tmp51_);
	gtk_widget_show ((GtkWidget*) headerbar);
	_tmp52_ = self->priv->window;
	gtk_window_set_titlebar (_tmp52_, (GtkWidget*) headerbar);
	_tmp53_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp53_);
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 15);
	g_object_ref_sink (_tmp54_);
	main_vbox = _tmp54_;
	g_object_set ((GtkWidget*) main_vbox, "margin", 15, NULL);
	_tmp55_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) main_vbox);
	_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp56_);
	view_box = _tmp56_;
	gtk_container_set_border_width ((GtkContainer*) view_box, (guint) 3);
	gtk_widget_show ((GtkWidget*) view_box);
	gtk_box_pack_start (main_vbox, (GtkWidget*) view_box, TRUE, TRUE, (guint) 0);
	_tmp57_ = minefield_view_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp57_;
	_tmp58_ = self->priv->minefield_view;
	_tmp59_ = self->priv->settings;
	_tmp60_ = g_settings_get_boolean (_tmp59_, MINES_KEY_USE_QUESTION_MARKS);
	minefield_view_set_use_question_marks (_tmp58_, _tmp60_);
	_tmp61_ = self->priv->minefield_view;
	_tmp62_ = self->priv->settings;
	_tmp63_ = g_settings_get_boolean (_tmp62_, MINES_KEY_USE_OVERMINE_WARNING);
	minefield_view_set_use_overmine_warning (_tmp61_, _tmp63_);
	_tmp64_ = self->priv->minefield_view;
	_tmp65_ = self->priv->settings;
	_tmp66_ = g_settings_get_boolean (_tmp65_, MINES_KEY_USE_AUTOFLAG);
	minefield_view_set_use_autoflag (_tmp64_, _tmp66_);
	_tmp67_ = self->priv->minefield_view;
	g_signal_connect_object ((GtkWidget*) _tmp67_, "button-press-event", (GCallback) _mines_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp68_ = self->priv->minefield_view;
	gtk_box_pack_start (view_box, (GtkWidget*) _tmp68_, TRUE, TRUE, (guint) 0);
	mines_startup_new_game_screen (self);
	_tmp69_ = self->priv->new_game_screen;
	gtk_box_pack_start (view_box, (GtkWidget*) _tmp69_, TRUE, TRUE, (guint) 0);
	mines_startup_custom_game_screen (self);
	_tmp70_ = self->priv->custom_game_screen;
	gtk_box_pack_start (view_box, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
	_tmp71_ = g_get_user_data_dir ();
	_tmp72_ = g_build_filename (_tmp71_, "gnome-mines", "history", NULL);
	_tmp73_ = _tmp72_;
	_tmp74_ = history_new (_tmp73_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp74_;
	_g_free0 (_tmp73_);
	_tmp75_ = self->priv->history;
	history_load (_tmp75_);
	_tmp76_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->buttons_box);
	self->priv->buttons_box = _tmp76_;
	_tmp77_ = self->priv->buttons_box;
	gtk_widget_set_margin_right ((GtkWidget*) _tmp77_, 15);
	_tmp78_ = self->priv->buttons_box;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp78_, 15);
	_tmp79_ = self->priv->buttons_box;
	gtk_box_pack_start (main_vbox, (GtkWidget*) _tmp79_, FALSE, FALSE, (guint) 0);
	_tmp80_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	size = _tmp80_;
	_tmp81_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->hint_button);
	self->priv->hint_button = _tmp81_;
	_tmp82_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp82_);
	box = _tmp82_;
	_tmp83_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-question-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp83_);
	image = _tmp83_;
	_tmp84_ = box;
	gtk_box_pack_start (_tmp84_, (GtkWidget*) image, TRUE, TRUE, (guint) 0);
	_tmp85_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp85_;
	_tmp86_ = box;
	_tmp87_ = self->priv->flag_label;
	gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, TRUE, TRUE, (guint) 0);
	_tmp88_ = self->priv->hint_button;
	_tmp89_ = box;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = self->priv->hint_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp90_, GTK_ALIGN_CENTER);
	_tmp91_ = self->priv->hint_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp91_, GTK_ALIGN_CENTER);
	_tmp92_ = self->priv->hint_button;
	gtk_button_set_relief (_tmp92_, GTK_RELIEF_NONE);
	_tmp93_ = self->priv->hint_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp93_, "app.hint");
	_tmp94_ = self->priv->hint_button;
	_tmp95_ = _ ("Receive a hint for your next move");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp94_, _tmp95_);
	_tmp96_ = self->priv->buttons_box;
	_tmp97_ = self->priv->hint_button;
	gtk_box_pack_start (_tmp96_, (GtkWidget*) _tmp97_, FALSE, FALSE, (guint) 0);
	_tmp98_ = self->priv->hint_button;
	gtk_size_group_add_widget (size, (GtkWidget*) _tmp98_);
	_tmp99_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp99_;
	_tmp100_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp100_);
	_g_object_unref0 (box);
	box = _tmp100_;
	_tmp101_ = (GtkImage*) gtk_image_new_from_icon_name ("view-refresh-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp101_);
	_g_object_unref0 (self->priv->play_pause_image);
	self->priv->play_pause_image = _tmp101_;
	_tmp102_ = box;
	_tmp103_ = self->priv->play_pause_image;
	gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, TRUE, TRUE, (guint) 0);
	_tmp104_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp104_;
	_tmp105_ = box;
	_tmp106_ = self->priv->clock_label;
	gtk_box_pack_start (_tmp105_, (GtkWidget*) _tmp106_, TRUE, TRUE, (guint) 0);
	_tmp107_ = self->priv->play_pause_button;
	_tmp108_ = box;
	gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
	_tmp109_ = self->priv->play_pause_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp109_, GTK_ALIGN_CENTER);
	_tmp110_ = self->priv->play_pause_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp110_, GTK_ALIGN_CENTER);
	_tmp111_ = self->priv->play_pause_button;
	gtk_button_set_relief (_tmp111_, GTK_RELIEF_NONE);
	mines_display_new_game_button (self);
	_tmp112_ = self->priv->buttons_box;
	_tmp113_ = self->priv->play_pause_button;
	gtk_box_pack_end (_tmp112_, (GtkWidget*) _tmp113_, FALSE, FALSE, (guint) 0);
	_tmp114_ = self->priv->play_pause_button;
	gtk_size_group_add_widget (size, (GtkWidget*) _tmp114_);
	_g_object_unref0 (image);
	_g_object_unref0 (box);
	_g_object_unref0 (size);
	_g_object_unref0 (view_box);
	_g_object_unref0 (main_vbox);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (section);
	_g_object_unref0 (menu);
}


static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_small_size_clicked_cb (self);
}


static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_medium_size_clicked_cb (self);
}


static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_large_size_clicked_cb (self);
}


static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_custom_game_screen (self);
}


static void mines_startup_new_game_screen (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	GtkAspectFrame* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkGrid* new_game_grid = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkAspectFrame* _tmp4_ = NULL;
	GtkButton* button = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkButton* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	GtkButton* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkButton* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkAspectFrame* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkAspectFrame*) gtk_aspect_frame_new (NULL, 0.5f, 0.5f, 1.0f, FALSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp0_;
	_tmp1_ = self->priv->new_game_screen;
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp1_, GTK_SHADOW_NONE);
	_tmp2_ = self->priv->new_game_screen;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, 450, 450);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	new_game_grid = _tmp3_;
	gtk_grid_set_column_homogeneous (new_game_grid, TRUE);
	gtk_grid_set_column_spacing (new_game_grid, 0);
	gtk_grid_set_row_homogeneous (new_game_grid, TRUE);
	gtk_grid_set_row_spacing (new_game_grid, 0);
	_tmp4_ = self->priv->new_game_screen;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) new_game_grid);
	_tmp5_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp5_);
	button = _tmp5_;
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _mines_small_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp7_ = button;
	gtk_grid_attach (new_game_grid, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp8_);
	label = _tmp8_;
	_tmp9_ = label;
	_tmp10_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (_tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = label;
	gtk_label_set_justify (_tmp12_, GTK_JUSTIFY_CENTER);
	_tmp13_ = button;
	_tmp14_ = label;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (button);
	button = _tmp15_;
	_tmp16_ = button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) _mines_medium_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp17_ = button;
	gtk_grid_attach (new_game_grid, (GtkWidget*) _tmp17_, 1, 0, 1, 1);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	_tmp20_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	_tmp23_ = button;
	_tmp24_ = label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (button);
	button = _tmp25_;
	_tmp26_ = button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _mines_large_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp27_ = button;
	gtk_grid_attach (new_game_grid, (GtkWidget*) _tmp27_, 0, 1, 1, 1);
	_tmp28_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (label);
	label = _tmp28_;
	_tmp29_ = label;
	_tmp30_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp31_ = _tmp30_;
	gtk_label_set_markup (_tmp29_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = label;
	gtk_label_set_justify (_tmp32_, GTK_JUSTIFY_CENTER);
	_tmp33_ = button;
	_tmp34_ = label;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (button);
	button = _tmp35_;
	_tmp36_ = button;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) _mines_show_custom_game_screen_gtk_button_clicked, self, 0);
	_tmp37_ = button;
	gtk_grid_attach (new_game_grid, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
	_tmp38_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (label);
	label = _tmp38_;
	_tmp39_ = label;
	_tmp40_ = _ ("Custom");
	_tmp41_ = g_dpgettext2 (NULL, "board size", _tmp40_);
	_tmp42_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", _tmp41_, NULL);
	_tmp43_ = _tmp42_;
	gtk_label_set_markup_with_mnemonic (_tmp39_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = label;
	gtk_label_set_justify (_tmp44_, GTK_JUSTIFY_CENTER);
	_tmp45_ = button;
	_tmp46_ = label;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->new_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp47_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
	_g_object_unref0 (new_game_grid);
}


static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_xsize_spin_cb (self, _sender);
}


static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_ysize_spin_cb (self, _sender);
}


static void _mines_n_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_n_mines_spin_cb (self, _sender);
}


static void _mines_p_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_p_mines_spin_cb (self, _sender);
}


static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_new_game_screen (self);
}


static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_custom_size_clicked_cb (self);
}


static void mines_startup_custom_game_screen (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	GtkAspectFrame* _tmp1_ = NULL;
	GtkGrid* custom_game_grid = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkSpinButton* field_width_entry = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkLabel* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkSpinButton* field_height_entry = NULL;
	GtkSpinButton* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GtkLabel* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkSpinButton* _tmp24_ = NULL;
	GtkSpinButton* _tmp25_ = NULL;
	GtkSpinButton* _tmp26_ = NULL;
	GSettings* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GtkSpinButton* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkSpinButton* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkSpinButton* _tmp36_ = NULL;
	GtkSpinButton* _tmp37_ = NULL;
	GtkSpinButton* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkSpinButton* _tmp40_ = NULL;
	GtkGrid* button_grid = NULL;
	GtkGrid* _tmp41_ = NULL;
	GtkButton* button = NULL;
	const gchar* _tmp42_ = NULL;
	GtkButton* _tmp43_ = NULL;
	GtkButton* _tmp44_ = NULL;
	GtkButton* _tmp45_ = NULL;
	GtkButton* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkButton* _tmp49_ = NULL;
	GtkButton* _tmp50_ = NULL;
	GtkButton* _tmp51_ = NULL;
	GtkButton* _tmp52_ = NULL;
	GtkButton* _tmp53_ = NULL;
	GtkAspectFrame* _tmp54_ = NULL;
	GtkAspectFrame* _tmp55_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkAspectFrame*) gtk_aspect_frame_new ("", 0.5f, 0.5f, 0.0f, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp0_;
	_tmp1_ = self->priv->custom_game_screen;
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp1_, GTK_SHADOW_NONE);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	custom_game_grid = _tmp2_;
	gtk_grid_set_column_homogeneous (custom_game_grid, FALSE);
	gtk_grid_set_column_spacing (custom_game_grid, 12);
	gtk_grid_set_row_spacing (custom_game_grid, 6);
	_tmp3_ = self->priv->custom_game_screen;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) custom_game_grid);
	_tmp4_ = _ ("H_orizontal:");
	_tmp5_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp4_);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp6_, (gfloat) 0, 0.5f);
	_tmp7_ = label;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX, (gdouble) 1);
	g_object_ref_sink (_tmp8_);
	field_width_entry = _tmp8_;
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp10_);
	gtk_grid_attach (custom_game_grid, (GtkWidget*) field_width_entry, 1, 0, 1, 1);
	_tmp11_ = label;
	gtk_label_set_mnemonic_widget (_tmp11_, (GtkWidget*) field_width_entry);
	_tmp12_ = _ ("_Vertical:");
	_tmp13_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (label);
	label = _tmp13_;
	_tmp14_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp14_, (gfloat) 0, 0.5f);
	_tmp15_ = label;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp15_, 0, 1, 1, 1);
	_tmp16_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX, (gdouble) 1);
	g_object_ref_sink (_tmp16_);
	field_height_entry = _tmp16_;
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_int (_tmp17_, MINES_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp18_);
	gtk_grid_attach (custom_game_grid, (GtkWidget*) field_height_entry, 1, 1, 1, 1);
	_tmp19_ = label;
	gtk_label_set_mnemonic_widget (_tmp19_, (GtkWidget*) field_height_entry);
	_tmp20_ = _ ("_Number of mines:");
	_tmp21_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (label);
	label = _tmp21_;
	_tmp22_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, (gfloat) 0, 0.5f);
	_tmp23_ = label;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp23_, 0, 2, 1, 1);
	_tmp24_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) (MINES_XSIZE_MAX * MINES_YSIZE_MAX), (gdouble) 1);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->n_mines_spin);
	self->priv->n_mines_spin = _tmp24_;
	_tmp25_ = self->priv->n_mines_spin;
	g_signal_connect_object (_tmp25_, "value-changed", (GCallback) _mines_n_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp26_ = self->priv->n_mines_spin;
	_tmp27_ = self->priv->settings;
	_tmp28_ = g_settings_get_int (_tmp27_, MINES_KEY_NMINES);
	gtk_spin_button_set_value (_tmp26_, (gdouble) _tmp28_);
	_tmp29_ = self->priv->n_mines_spin;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp29_, 1, 2, 1, 1);
	mines_set_n_mines_limit (self);
	_tmp30_ = label;
	_tmp31_ = self->priv->n_mines_spin;
	gtk_label_set_mnemonic_widget (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = _ ("_Percentage of mines:");
	_tmp33_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp32_);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (label);
	label = _tmp33_;
	_tmp34_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp34_, (gfloat) 0, 0.5f);
	_tmp35_ = label;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp35_, 0, 3, 1, 1);
	_tmp36_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 100, (gdouble) 1);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->p_mines_spin);
	self->priv->p_mines_spin = _tmp36_;
	_tmp37_ = self->priv->p_mines_spin;
	g_signal_connect_object (_tmp37_, "value-changed", (GCallback) _mines_p_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp38_ = self->priv->p_mines_spin;
	gtk_grid_attach (custom_game_grid, (GtkWidget*) _tmp38_, 1, 3, 1, 1);
	mines_set_p_mines_limit (self);
	_tmp39_ = label;
	_tmp40_ = self->priv->p_mines_spin;
	gtk_label_set_mnemonic_widget (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp41_);
	button_grid = _tmp41_;
	gtk_grid_set_column_homogeneous (button_grid, FALSE);
	gtk_grid_set_column_spacing (button_grid, 5);
	gtk_grid_attach (custom_game_grid, (GtkWidget*) button_grid, 0, 4, 2, 1);
	_tmp42_ = _ ("_Cancel");
	_tmp43_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp42_);
	g_object_ref_sink (_tmp43_);
	button = _tmp43_;
	_tmp44_ = button;
	gtk_widget_set_valign ((GtkWidget*) _tmp44_, GTK_ALIGN_CENTER);
	_tmp45_ = button;
	g_object_set ((GtkWidget*) _tmp45_, "expand", TRUE, NULL);
	_tmp46_ = button;
	g_signal_connect_object (_tmp46_, "clicked", (GCallback) _mines_show_new_game_screen_gtk_button_clicked, self, 0);
	_tmp47_ = button;
	gtk_grid_attach (button_grid, (GtkWidget*) _tmp47_, 0, 0, 1, 1);
	_tmp48_ = _ ("_Play Game");
	_tmp49_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp48_);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (button);
	button = _tmp49_;
	_tmp50_ = button;
	gtk_widget_set_valign ((GtkWidget*) _tmp50_, GTK_ALIGN_CENTER);
	_tmp51_ = button;
	g_object_set ((GtkWidget*) _tmp51_, "expand", TRUE, NULL);
	_tmp52_ = button;
	g_signal_connect_object (_tmp52_, "clicked", (GCallback) _mines_custom_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp53_ = button;
	gtk_grid_attach (button_grid, (GtkWidget*) _tmp53_, 1, 0, 1, 1);
	_tmp54_ = self->priv->custom_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp55_);
	_g_object_unref0 (button);
	_g_object_unref0 (button_grid);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
	_g_object_unref0 (label);
	_g_object_unref0 (custom_game_grid);
}


static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->window_skip_configure;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	self->priv->window_skip_configure = FALSE;
	result = FALSE;
	return result;
}


static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		_tmp1_ = self->priv->minefield;
		minefield_set_paused (_tmp1_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->pause_requested;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		Minefield* _tmp4_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, FALSE);
	}
	result = FALSE;
	return result;
}


static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines) {
	gchar* result = NULL;
	gchar* size_label = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* mines_label = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_strdup_printf ("%d × %d", _tmp0_, _tmp1_);
	size_label = _tmp2_;
	_tmp3_ = n_mines;
	_tmp4_ = ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) _tmp3_);
	_tmp5_ = n_mines;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
	mines_label = _tmp6_;
	_tmp7_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp7_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}


void mines_start (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	mines_show_new_game_screen (self);
}


static void mines_real_shutdown (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
}


static void mines_real_activate (GApplication* base) {
	Mines * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
		self->priv->pause_requested = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mines_quit_cb (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mines_update_flag_label (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	Minefield* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = _ ("%u/%u");
	_tmp2_ = self->priv->minefield;
	_tmp3_ = minefield_get_n_flags (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->minefield;
	_tmp6_ = _tmp5_->n_mines;
	_tmp7_ = g_strdup_printf (_tmp1_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp0_, _tmp8_);
	_g_free0 (_tmp8_);
}


static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void mines_scores_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_scores (self, NULL, FALSE);
}


static void mines_show_custom_game_screen (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	MinefieldView* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->is_new_game_screen = FALSE;
	_tmp0_ = self->priv->custom_game_screen;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->minefield_view;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->new_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


static gboolean mines_can_start_new_game (Mines* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->minefield;
		_tmp9_ = _tmp8_->exploded;
		_tmp1_ = !_tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		Minefield* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->minefield;
		_tmp12_ = minefield_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = !_tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		gboolean was_paused = FALSE;
		Minefield* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Minefield* _tmp18_ = NULL;
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkMessageDialog* _tmp21_ = NULL;
		GtkMessageDialog* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GtkMessageDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gint _result_ = 0;
		GtkMessageDialog* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		GtkMessageDialog* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		_tmp15_ = self->priv->minefield;
		_tmp16_ = minefield_get_paused (_tmp15_);
		_tmp17_ = _tmp16_;
		was_paused = _tmp17_;
		_tmp18_ = self->priv->minefield;
		minefield_set_paused (_tmp18_, TRUE);
		_tmp19_ = self->priv->window;
		_tmp20_ = _ ("Do you want to start a new game?");
		_tmp21_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp19_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp20_);
		g_object_ref_sink (_tmp21_);
		dialog = _tmp21_;
		_tmp22_ = dialog;
		_tmp23_ = _ ("If you start a new game, your current progress will be lost.");
		g_object_set (_tmp22_, "secondary-text", _tmp23_, NULL);
		_tmp24_ = dialog;
		_tmp25_ = _ ("Keep Current Game");
		_tmp26_ = _ ("Start New Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp24_, _tmp25_, GTK_RESPONSE_DELETE_EVENT, _tmp26_, GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp27_ = dialog;
		_tmp28_ = gtk_dialog_run ((GtkDialog*) _tmp27_);
		_result_ = _tmp28_;
		_tmp29_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp29_);
		_tmp30_ = _result_;
		if (_tmp30_ != ((gint) GTK_RESPONSE_ACCEPT)) {
			Minefield* _tmp31_ = NULL;
			gboolean _tmp32_ = FALSE;
			_tmp31_ = self->priv->minefield;
			_tmp32_ = was_paused;
			minefield_set_paused (_tmp31_, _tmp32_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}


static void mines_show_new_game_screen (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	GtkAspectFrame* _tmp4_ = NULL;
	MinefieldView* _tmp5_ = NULL;
	GtkAspectFrame* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GSimpleAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_new_game_screen;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_ = NULL;
		Minefield* _tmp3_ = NULL;
		_tmp2_ = self->priv->minefield;
		minefield_set_paused (_tmp2_, FALSE);
		self->priv->pause_requested = FALSE;
		_tmp3_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_minefield_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	self->priv->is_new_game_screen = TRUE;
	_tmp4_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->minefield_view;
	gtk_widget_hide ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->new_game_screen;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->window;
	_tmp8_ = self->priv->window_width;
	_tmp9_ = self->priv->window_height;
	gtk_window_resize (_tmp7_, _tmp8_, _tmp9_);
	mines_display_new_game_button (self);
	_tmp10_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_tmp12_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	_tmp14_ = self->priv->buttons_box;
	gtk_widget_hide ((GtkWidget*) _tmp14_);
}


static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	mines_marks_changed_cb (self, _sender);
}


static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	mines_explode_cb (self, _sender);
}


static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	mines_cleared_cb (self, _sender);
}


static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self) {
	mines_tick_cb (self);
}


static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self) {
	mines_paused_changed_cb (self);
}


static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self) {
	mines_clock_started_cb (self);
}


static void mines_start_game (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	MinefieldView* _tmp1_ = NULL;
	MinefieldView* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	gint x = 0;
	gint y = 0;
	gint n = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Minefield* _tmp18_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	Minefield* _tmp23_ = NULL;
	Minefield* _tmp24_ = NULL;
	Minefield* _tmp25_ = NULL;
	Minefield* _tmp26_ = NULL;
	Minefield* _tmp27_ = NULL;
	Minefield* _tmp28_ = NULL;
	Minefield* _tmp29_ = NULL;
	MinefieldView* _tmp30_ = NULL;
	Minefield* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GSimpleAction* _tmp33_ = NULL;
	GSimpleAction* _tmp34_ = NULL;
	GSimpleAction* _tmp35_ = NULL;
	GSimpleAction* _tmp36_ = NULL;
	Minefield* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->is_new_game_screen = FALSE;
	_tmp0_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->window_skip_configure = TRUE;
	_tmp1_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->minefield_view;
	g_object_set ((GtkWidget*) _tmp2_, "has-focus", TRUE, NULL);
	_tmp3_ = self->priv->new_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->buttons_box;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	mines_tick_cb (self);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, MINES_KEY_MODE);
	switch (_tmp6_) {
		case 0:
		{
			x = 8;
			y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			x = 16;
			y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			x = 30;
			y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GSettings* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			GSettings* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
			_tmp9_ = CLAMP (_tmp8_, MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			x = _tmp9_;
			_tmp10_ = self->priv->settings;
			_tmp11_ = g_settings_get_int (_tmp10_, MINES_KEY_YSIZE);
			_tmp12_ = CLAMP (_tmp11_, MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			y = _tmp12_;
			_tmp13_ = self->priv->settings;
			_tmp14_ = g_settings_get_int (_tmp13_, MINES_KEY_NMINES);
			_tmp15_ = x;
			_tmp16_ = y;
			_tmp17_ = CLAMP (_tmp14_, 1, (_tmp15_ * _tmp16_) - 10);
			n = _tmp17_;
			break;
		}
	}
	_tmp18_ = self->priv->minefield;
	if (_tmp18_ != NULL) {
		Minefield* _tmp19_ = NULL;
		_tmp19_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp19_, NULL, self);
	}
	_tmp20_ = x;
	_tmp21_ = y;
	_tmp22_ = n;
	_tmp23_ = minefield_new ((guint) _tmp20_, (guint) _tmp21_, (guint) _tmp22_);
	_minefield_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp23_;
	_tmp24_ = self->priv->minefield;
	g_signal_connect_object (_tmp24_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp25_ = self->priv->minefield;
	g_signal_connect_object (_tmp25_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp26_ = self->priv->minefield;
	g_signal_connect_object (_tmp26_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp27_ = self->priv->minefield;
	g_signal_connect_object (_tmp27_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp28_ = self->priv->minefield;
	g_signal_connect_object (_tmp28_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp29_ = self->priv->minefield;
	g_signal_connect_object (_tmp29_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp30_ = self->priv->minefield_view;
	_tmp31_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp30_, _tmp31_);
	mines_update_flag_label (self);
	_tmp32_ = self->priv->clock_label;
	gtk_widget_hide ((GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp33_, TRUE);
	_tmp34_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp34_, TRUE);
	_tmp35_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp35_, TRUE);
	_tmp36_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp36_, TRUE);
	_tmp37_ = self->priv->minefield;
	minefield_set_paused (_tmp37_, FALSE);
	self->priv->pause_requested = FALSE;
}


static void mines_hint_cb (Mines* self) {
	Minefield* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	minefield_hint (_tmp0_);
}


static void mines_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_repeat_size_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_start_game (self);
	}
}


static void mines_toggle_pause_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->pause_requested;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp6_ = NULL;
		Minefield* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		Minefield* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp6_ = self->priv->minefield;
		_tmp7_ = self->priv->minefield;
		_tmp8_ = minefield_get_paused (_tmp7_);
		_tmp9_ = _tmp8_;
		minefield_set_paused (_tmp6_, !_tmp9_);
		_tmp10_ = self->priv->minefield;
		_tmp11_ = minefield_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		self->priv->pause_requested = _tmp12_;
	}
}


static void mines_paused_changed_cb (Mines* self) {
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_ = NULL;
		_tmp3_ = self->priv->hint_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		mines_display_unpause_button (self);
	} else {
		Minefield* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_elapsed (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > ((gdouble) 0)) {
			GSimpleAction* _tmp7_ = NULL;
			_tmp7_ = self->priv->hint_action;
			g_simple_action_set_enabled (_tmp7_, TRUE);
			mines_display_pause_button (self);
		}
	}
}


static void mines_marks_changed_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}


static void mines_explode_cb (Mines* self, Minefield* minefield) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_display_new_game_button (self);
	_tmp0_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->clock_label;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


static void mines_cleared_cb (Mines* self, Minefield* minefield) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Minefield* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	Minefield* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	Minefield* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp12_ = NULL;
	History* _tmp13_ = NULL;
	HistoryEntry* _tmp14_ = NULL;
	History* _tmp15_ = NULL;
	HistoryEntry* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = minefield;
	_tmp2_ = minefield_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = minefield;
	_tmp6_ = _tmp5_->width;
	_tmp7_ = minefield;
	_tmp8_ = _tmp7_->height;
	_tmp9_ = minefield;
	_tmp10_ = _tmp9_->n_mines;
	_tmp11_ = duration;
	_tmp12_ = history_entry_new (_tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp11_);
	entry = _tmp12_;
	_tmp13_ = self->priv->history;
	_tmp14_ = entry;
	history_add (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->history;
	history_save (_tmp15_);
	_tmp16_ = entry;
	_tmp17_ = mines_show_scores (self, _tmp16_, TRUE);
	if (_tmp17_ == ((gint) GTK_RESPONSE_OK)) {
		mines_show_new_game_screen (self);
	} else {
		GSimpleAction* _tmp18_ = NULL;
		GSimpleAction* _tmp19_ = NULL;
		GtkLabel* _tmp20_ = NULL;
		mines_display_new_game_button (self);
		_tmp18_ = self->priv->hint_action;
		g_simple_action_set_enabled (_tmp18_, FALSE);
		_tmp19_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp19_, FALSE);
		_tmp20_ = self->priv->clock_label;
		gtk_widget_hide ((GtkWidget*) _tmp20_);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
}


static void mines_clock_started_cb (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	mines_display_pause_button (self);
	_tmp0_ = self->priv->clock_label;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void mines_tick_cb (Mines* self) {
	gint elapsed = 0;
	Minefield* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint seconds = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d:%02d:%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d:%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void mines_about_cb (Mines* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Pista");
	_tmp3_ = g_strdup ("Szekeres Istvan");
	_tmp4_ = g_strdup ("Robert Ancell");
	_tmp5_ = g_strdup ("");
	_tmp6_ = _ ("Score:");
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_strdup ("Horacio J. Peña");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Resizing and SVG support:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Steve Chaplin");
	_tmp13_ = g_strdup ("Callum McKenzie");
	_tmp14_ = g_new0 (gchar*, 12 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp7_;
	_tmp14_[6] = _tmp8_;
	_tmp14_[7] = _tmp9_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	_tmp14_[11] = NULL;
	authors = _tmp14_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp15_ = _ ("Faces:");
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = g_strdup ("tigert");
	_tmp18_ = g_strdup ("Lapo Calamandrei and Ulisse Perusin");
	_tmp19_ = g_strdup ("");
	_tmp20_ = _ ("Graphics:");
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = g_strdup ("Richard Hoelscher");
	_tmp23_ = g_new0 (gchar*, 7 + 1);
	_tmp23_[0] = _tmp16_;
	_tmp23_[1] = _tmp17_;
	_tmp23_[2] = _tmp18_;
	_tmp23_[3] = _tmp19_;
	_tmp23_[4] = _tmp21_;
	_tmp23_[5] = _tmp22_;
	_tmp23_[6] = NULL;
	artists = _tmp23_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp24_ = g_strdup ("Ekaterina Gerasimova");
	_tmp25_ = g_new0 (gchar*, 2 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp25_[1] = NULL;
	documenters = _tmp25_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp26_ = self->priv->window;
	_tmp27_ = _ ("Mines");
	_tmp28_ = _ ("Clear explosive mines off the board\n" \
"\n" \
"Mines is a part of GNOME Games.");
	_tmp29_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp26_, "name", _tmp27_, "version", VERSION, "comments", _tmp28_, "copyright", "Copyright © 1997–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp29_, "logo-icon-name", "gnome-mines", "website", "https://wiki.gnome.org/Apps/Mines", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void mines_set_n_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint max_mines = 0;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint min_mines = 0;
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GtkSpinButton* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = size;
	max_mines = _tmp4_ - 10;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, MINES_KEY_NMINES);
	_tmp7_ = max_mines;
	if (_tmp6_ > _tmp7_) {
		GSettings* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GtkSpinButton* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = self->priv->settings;
		_tmp9_ = max_mines;
		g_settings_set_int (_tmp8_, MINES_KEY_NMINES, _tmp9_);
		_tmp10_ = self->priv->n_mines_spin;
		_tmp11_ = max_mines;
		gtk_spin_button_set_value (_tmp10_, (gdouble) _tmp11_);
	}
	_tmp12_ = size;
	_tmp13_ = round ((gdouble) (0.01f * _tmp12_));
	_tmp14_ = MAX ((gint) _tmp13_, 1);
	min_mines = _tmp14_;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, MINES_KEY_NMINES);
	_tmp17_ = min_mines;
	if (_tmp16_ < _tmp17_) {
		GSettings* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		GtkSpinButton* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		_tmp18_ = self->priv->settings;
		_tmp19_ = min_mines;
		g_settings_set_int (_tmp18_, MINES_KEY_NMINES, _tmp19_);
		_tmp20_ = self->priv->n_mines_spin;
		_tmp21_ = min_mines;
		gtk_spin_button_set_value (_tmp20_, (gdouble) _tmp21_);
	}
	_tmp22_ = self->priv->n_mines_spin;
	_tmp23_ = min_mines;
	_tmp24_ = max_mines;
	gtk_spin_button_set_range (_tmp22_, (gdouble) _tmp23_, (gdouble) _tmp24_);
}


static void mines_set_p_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint max_mines = 0;
	gdouble _tmp4_ = 0.0;
	gint min_mines = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	GtkSpinButton* _tmp7_ = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	gdouble _tmp11_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	max_mines = (gint) _tmp4_;
	_tmp5_ = round ((gdouble) (100.0f / size));
	_tmp6_ = MAX (1, (gint) _tmp5_);
	min_mines = _tmp6_;
	_tmp7_ = self->priv->p_mines_spin;
	gtk_spin_button_set_range (_tmp7_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp8_ = self->priv->p_mines_spin;
	_tmp9_ = mines_get_p_mines (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = round ((gdouble) _tmp10_);
	gtk_spin_button_set_value (_tmp8_, (gdouble) ((gint) _tmp11_));
}


static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint xsize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, MINES_KEY_XSIZE, _tmp6_);
	mines_set_n_mines_limit (self);
	mines_set_p_mines_limit (self);
}


static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint ysize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, MINES_KEY_YSIZE, _tmp6_);
	mines_set_n_mines_limit (self);
	mines_set_p_mines_limit (self);
}


static void mines_n_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint n_mines = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	GtkSpinButton* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkSpinButton* _tmp16_ = NULL;
	gfloat _tmp17_ = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gdouble _tmp19_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	n_mines = _tmp1_;
	_tmp2_ = n_mines;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_NMINES);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = n_mines;
	g_settings_set_int (_tmp5_, MINES_KEY_NMINES, _tmp6_);
	_tmp7_ = mines_get_p_mines (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->p_mines_spin;
	_tmp10_ = gtk_spin_button_get_value (_tmp9_);
	_tmp11_ = fabs (_tmp8_ - _tmp10_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_get_int (_tmp12_, MINES_KEY_XSIZE);
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_get_int (_tmp14_, MINES_KEY_YSIZE);
	if (_tmp11_ <= ((gdouble) ((100.0f * 0.5f) / (_tmp13_ * _tmp15_)))) {
		return;
	}
	_tmp16_ = self->priv->p_mines_spin;
	_tmp17_ = mines_get_p_mines (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = round ((gdouble) _tmp18_);
	gtk_spin_button_set_value (_tmp16_, (gdouble) ((gint) _tmp19_));
}


static void mines_p_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	GtkSpinButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	GtkSpinButton* _tmp5_ = NULL;
	GtkSpinButton* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = mines_get_p_mines (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = spin;
	_tmp3_ = gtk_spin_button_get_value (_tmp2_);
	_tmp4_ = fabs (_tmp1_ - _tmp3_);
	if (_tmp4_ <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp5_ = self->priv->n_mines_spin;
	_tmp6_ = spin;
	_tmp7_ = gtk_spin_button_get_value (_tmp6_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_int (_tmp8_, MINES_KEY_XSIZE);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, MINES_KEY_YSIZE);
	_tmp12_ = round ((_tmp7_ * (_tmp9_ * _tmp11_)) / 100.0f);
	gtk_spin_button_set_value (_tmp5_, (gdouble) ((gint) _tmp12_));
}


static void mines_use_question_toggle_cb (Mines* self, GtkToggleButton* button) {
	gboolean use_question_marks = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
	MinefieldView* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	use_question_marks = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, MINES_KEY_USE_QUESTION_MARKS, use_question_marks);
	_tmp3_ = self->priv->minefield_view;
	minefield_view_set_use_question_marks (_tmp3_, use_question_marks);
}


static void mines_use_overmine_toggle_cb (Mines* self, GtkToggleButton* button) {
	gboolean use_overmine_warning = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
	MinefieldView* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	use_overmine_warning = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, MINES_KEY_USE_OVERMINE_WARNING, use_overmine_warning);
	_tmp3_ = self->priv->minefield_view;
	minefield_view_set_use_overmine_warning (_tmp3_, use_overmine_warning);
}


static void _mines_pref_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	mines_pref_response_cb (self, _sender, response_id);
}


static gboolean _mines_pref_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = mines_pref_delete_event_cb (self, _sender, event);
	return result;
}


static void _mines_use_question_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	mines_use_question_toggle_cb (self, _sender);
}


static void _mines_use_overmine_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	mines_use_overmine_toggle_cb (self, _sender);
}


static GtkDialog* mines_create_preferences (Mines* self) {
	GtkDialog* result = NULL;
	GtkDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp6_ = NULL;
	GtkCheckButton* question_toggle = NULL;
	const gchar* _tmp7_ = NULL;
	GtkCheckButton* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkCheckButton* overmine_toggle = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCheckButton* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Mines Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("_Close");
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, _tmp2_, GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	g_signal_connect_object (dialog, "response", (GCallback) _mines_pref_response_cb_gtk_dialog_response, self, 0);
	g_signal_connect_object ((GtkWidget*) dialog, "delete-event", (GCallback) _mines_pref_delete_event_cb_gtk_widget_delete_event, self, 0);
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 5);
	gtk_window_set_resizable ((GtkWindow*) dialog, FALSE);
	_tmp4_ = (GtkBox*) gtk_dialog_get_content_area (dialog);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_BOX, GtkBox));
	box = _tmp5_;
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp6_);
	grid = _tmp6_;
	gtk_widget_show ((GtkWidget*) grid);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_grid_set_column_spacing (grid, (guint) 18);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) grid);
	_tmp7_ = _ ("_Use \"I'm not sure\" flags");
	_tmp8_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp7_);
	g_object_ref_sink (_tmp8_);
	question_toggle = _tmp8_;
	gtk_widget_show ((GtkWidget*) question_toggle);
	g_signal_connect_object ((GtkToggleButton*) question_toggle, "toggled", (GCallback) _mines_use_question_toggle_cb_gtk_toggle_button_toggled, self, 0);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_boolean (_tmp9_, MINES_KEY_USE_QUESTION_MARKS);
	gtk_toggle_button_set_active ((GtkToggleButton*) question_toggle, _tmp10_);
	gtk_grid_attach (grid, (GtkWidget*) question_toggle, 0, 0, 1, 1);
	_tmp11_ = _ ("_Warn if too many flags are placed next to a number");
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp11_);
	g_object_ref_sink (_tmp12_);
	overmine_toggle = _tmp12_;
	gtk_widget_show ((GtkWidget*) overmine_toggle);
	g_signal_connect_object ((GtkToggleButton*) overmine_toggle, "toggled", (GCallback) _mines_use_overmine_toggle_cb_gtk_toggle_button_toggled, self, 0);
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_boolean (_tmp13_, MINES_KEY_USE_OVERMINE_WARNING);
	gtk_toggle_button_set_active ((GtkToggleButton*) overmine_toggle, _tmp14_);
	gtk_grid_attach (grid, (GtkWidget*) overmine_toggle, 0, 1, 1, 1);
	result = dialog;
	_g_object_unref0 (overmine_toggle);
	_g_object_unref0 (question_toggle);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	return result;
}


static void mines_set_mode (Mines* self, gint mode) {
	gint _tmp0_ = 0;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, MINES_KEY_MODE);
	if (_tmp0_ != _tmp2_) {
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->settings;
		_tmp4_ = mode;
		g_settings_set_int (_tmp3_, MINES_KEY_MODE, _tmp4_);
	}
	mines_start_game (self);
}


static void mines_small_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}


static void mines_medium_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}


static void mines_large_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}


static void mines_custom_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}


static void mines_pref_response_cb (Mines* self, GtkDialog* dialog, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->pref_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static gboolean mines_pref_delete_event_cb (Mines* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->pref_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static void mines_preferences_cb (Mines* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pref_dialog;
	if (_tmp0_ == NULL) {
		GtkDialog* _tmp1_ = NULL;
		_tmp1_ = mines_create_preferences (self);
		_g_object_unref0 (self->priv->pref_dialog);
		self->priv->pref_dialog = _tmp1_;
	}
	_tmp2_ = self->priv->pref_dialog;
	gtk_window_present ((GtkWindow*) _tmp2_);
}


static void mines_help_cb (Mines* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mines", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mines.vala:897: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void mines_display_new_game_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkImage* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp0_, "app.new-game");
	_tmp1_ = self->priv->play_pause_button;
	_tmp2_ = _ ("Start a new game");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->play_pause_image;
	g_object_set (_tmp3_, "icon-name", "view-refresh-symbolic", NULL);
}


static void mines_display_pause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkImage* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp0_, "app.pause");
	_tmp1_ = self->priv->play_pause_button;
	_tmp2_ = _ ("Pause the game");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->play_pause_image;
	g_object_set (_tmp3_, "icon-name", "media-playback-pause-symbolic", NULL);
}


static void mines_display_unpause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkTextDirection _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp0_, "app.pause");
	_tmp1_ = self->priv->play_pause_button;
	_tmp2_ = _ ("Unpause the game");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->play_pause_button;
	_tmp4_ = gtk_widget_get_direction ((GtkWidget*) _tmp3_);
	if (_tmp4_ == GTK_TEXT_DIR_RTL) {
		GtkImage* _tmp5_ = NULL;
		_tmp5_ = self->priv->play_pause_image;
		g_object_set (_tmp5_, "icon-name", "media-playback-start-rtl-symbolic", NULL);
	} else {
		GtkImage* _tmp6_ = NULL;
		_tmp6_ = self->priv->play_pause_image;
		g_object_set (_tmp6_, "icon-name", "media-playback-start-symbolic", NULL);
	}
}


gint mines_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	Mines* app = NULL;
	Mines* _tmp8_ = NULL;
	Mines* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = mines_new ();
	app = _tmp8_;
	_tmp9_ = app;
	_tmp10_ = g_application_run ((GApplication*) _tmp9_, 0, NULL);
	result = _tmp10_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	return mines_main (argv, argc);
}


static gfloat mines_get_p_mines (Mines* self) {
	gfloat result;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_NMINES);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_XSIZE);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, MINES_KEY_YSIZE);
	result = (100.0f * ((gfloat) _tmp1_)) / (_tmp3_ * _tmp5_);
	return result;
}


static void mines_class_init (MinesClass * klass) {
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinesPrivate));
	G_APPLICATION_CLASS (klass)->startup = mines_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = mines_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = mines_real_activate;
	G_OBJECT_CLASS (klass)->get_property = _vala_mines_get_property;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
}


static void mines_instance_init (Mines * self) {
	self->priv = MINES_GET_PRIVATE (self);
	self->priv->pref_dialog = NULL;
}


static void mines_finalize (GObject* obj) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->buttons_box);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_image);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->hint_button);
	_g_object_unref0 (self->priv->app_main_menu);
	_g_object_unref0 (self->priv->window);
	_history_unref0 (self->priv->history);
	_minefield_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->pref_dialog);
	_g_object_unref0 (self->priv->n_mines_spin);
	_g_object_unref0 (self->priv->p_mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->hint_action);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}


GType mines_get_type (void) {
	static volatile gsize mines_type_id__volatile = 0;
	if (g_once_init_enter (&mines_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
		GType mines_type_id;
		mines_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Mines", &g_define_type_info, 0);
		g_once_init_leave (&mines_type_id__volatile, mines_type_id);
	}
	return mines_type_id__volatile;
}


static void _vala_mines_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINES, Mines);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



