/* chess-game.c generated by valac 0.24.0.24-2ca24a, the Vala compiler
 * generated from chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__chess_state_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_state_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
typedef struct _ParamSpecChessGame ParamSpecChessGame;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	ChessClock* _clock;
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ParamSpecChessGame {
	GParamSpec parent_instance;
};


static gpointer chess_game_parent_class = NULL;

GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY
};
void chess_clock_stop (ChessClock* self);
static void _chess_state_unref0_ (gpointer var);
static void _g_list_free__chess_state_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType chess_player_get_type (void) G_GNUC_CONST;
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static void chess_game_claim_draw_cb (ChessGame* self);
static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
ChessState* chess_state_copy (ChessState* self);
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
GType color_get_type (void) G_GNUC_CONST;
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gboolean chess_game_is_three_fold_repeat (ChessGame* self);
gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
gboolean chess_game_can_claim_draw (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
void chess_game_pause (ChessGame* self);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
ChessPlayer* chess_state_get_opponent (ChessState* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_game_finalize (ChessGame* obj);


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _chess_state_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (chess_state_unref (var), NULL));
}


static void _g_list_free__chess_state_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _chess_state_unref0_, NULL);
	g_list_free (self);
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb ((ChessGame*) self, _sender, move, apply);
	return result;
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
	chess_game_undo_cb ((ChessGame*) self, _sender);
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb ((ChessGame*) self, _sender);
	return result;
}


static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
	chess_game_claim_draw_cb ((ChessGame*) self);
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1) {
	ChessGame* self = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ChessPlayer* _tmp16_ = NULL;
	ChessPlayer* _tmp17_ = NULL;
	ChessPlayer* _tmp18_ = NULL;
	ChessPlayer* _tmp19_ = NULL;
	ChessPlayer* _tmp20_ = NULL;
	ChessPlayer* _tmp21_ = NULL;
	ChessPlayer* _tmp22_ = NULL;
	ChessPlayer* _tmp23_ = NULL;
	ChessPlayer* _tmp24_ = NULL;
	ChessPlayer* _tmp25_ = NULL;
	ChessPlayer* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	ChessPlayer* _tmp28_ = NULL;
	ChessPlayer* _tmp29_ = NULL;
	ChessPlayer* _tmp30_ = NULL;
	ChessPlayer* _tmp31_ = NULL;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessGame*) g_type_create_instance (object_type);
	self->is_started = FALSE;
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
	self->result = CHESS_RESULT_IN_PROGRESS;
	_tmp2_ = moves;
	_tmp2__length1 = moves_length1;
	if (_tmp2_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					ChessPlayer* _tmp7_ = NULL;
					ChessPlayer* _tmp8_ = NULL;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					_tmp6_ = moves;
					_tmp6__length1 = moves_length1;
					if (!(_tmp5_ < _tmp6__length1)) {
						break;
					}
					_tmp7_ = chess_game_get_current_player (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = moves;
					_tmp9__length1 = moves_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = chess_game_do_move (self, _tmp8_, _tmp11_, TRUE);
					if (!_tmp12_) {
						gchar** _tmp13_ = NULL;
						gint _tmp13__length1 = 0;
						gint _tmp14_ = 0;
						const gchar* _tmp15_ = NULL;
						_tmp13_ = moves;
						_tmp13__length1 = moves_length1;
						_tmp14_ = i;
						_tmp15_ = _tmp13_[_tmp14_];
						g_warning ("chess-game.vala:99: Invalid move %s", _tmp15_);
					}
				}
			}
		}
	}
	_tmp16_ = chess_game_get_white (self);
	_tmp17_ = _tmp16_;
	g_signal_connect (_tmp17_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
	_tmp18_ = chess_game_get_white (self);
	_tmp19_ = _tmp18_;
	g_signal_connect (_tmp19_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
	_tmp20_ = chess_game_get_white (self);
	_tmp21_ = _tmp20_;
	g_signal_connect (_tmp21_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
	_tmp22_ = chess_game_get_white (self);
	_tmp23_ = _tmp22_;
	g_signal_connect (_tmp23_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
	_tmp24_ = chess_game_get_black (self);
	_tmp25_ = _tmp24_;
	g_signal_connect (_tmp25_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
	_tmp26_ = chess_game_get_black (self);
	_tmp27_ = _tmp26_;
	g_signal_connect (_tmp27_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
	_tmp28_ = chess_game_get_black (self);
	_tmp29_ = _tmp28_;
	g_signal_connect (_tmp29_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
	_tmp30_ = chess_game_get_black (self);
	_tmp31_ = _tmp30_;
	g_signal_connect (_tmp31_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
	return self;
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1) {
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1);
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = move;
	_tmp3_ = apply;
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessState* state = NULL;
	ChessState* _tmp3_ = NULL;
	ChessState* _tmp4_ = NULL;
	ChessState* _tmp5_ = NULL;
	ChessState* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	ChessState* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ChessState* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	ChessState* _tmp15_ = NULL;
	ChessMove* _tmp16_ = NULL;
	ChessPiece* _tmp17_ = NULL;
	ChessState* _tmp21_ = NULL;
	ChessMove* _tmp22_ = NULL;
	ChessPiece* _tmp23_ = NULL;
	ChessState* _tmp24_ = NULL;
	ChessMove* _tmp25_ = NULL;
	ChessPiece* _tmp26_ = NULL;
	ChessState* _tmp30_ = NULL;
	ChessMove* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = chess_game_get_current_state (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = chess_state_copy (_tmp4_);
	state = _tmp5_;
	_tmp6_ = state;
	_tmp7_ = _tmp6_->number;
	_tmp6_->number = _tmp7_ + 1;
	_tmp8_ = state;
	_tmp9_ = move;
	_tmp10_ = apply;
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
	if (!_tmp11_) {
		result = FALSE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp12_ = apply;
	if (!_tmp12_) {
		result = TRUE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp13_ = state;
	_tmp14_ = _chess_state_ref0 (_tmp13_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
	_tmp15_ = state;
	_tmp16_ = _tmp15_->last_move;
	_tmp17_ = _tmp16_->victim;
	if (_tmp17_ != NULL) {
		ChessState* _tmp18_ = NULL;
		ChessMove* _tmp19_ = NULL;
		ChessPiece* _tmp20_ = NULL;
		_tmp18_ = state;
		_tmp19_ = _tmp18_->last_move;
		_tmp20_ = _tmp19_->victim;
		g_signal_emit_by_name (_tmp20_, "died");
	}
	_tmp21_ = state;
	_tmp22_ = _tmp21_->last_move;
	_tmp23_ = _tmp22_->piece;
	g_signal_emit_by_name (_tmp23_, "moved");
	_tmp24_ = state;
	_tmp25_ = _tmp24_->last_move;
	_tmp26_ = _tmp25_->moved_rook;
	if (_tmp26_ != NULL) {
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		ChessPiece* _tmp29_ = NULL;
		_tmp27_ = state;
		_tmp28_ = _tmp27_->last_move;
		_tmp29_ = _tmp28_->moved_rook;
		g_signal_emit_by_name (_tmp29_, "moved");
	}
	_tmp30_ = state;
	_tmp31_ = _tmp30_->last_move;
	g_signal_emit_by_name (self, "moved", _tmp31_);
	chess_game_complete_move (self);
	result = TRUE;
	_chess_state_unref0 (state);
	return result;
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	self->priv->hold_count = _tmp0_ + 1;
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	g_return_if_fail (_tmp0_ > 0);
	_tmp1_ = self->priv->hold_count;
	self->priv->hold_count = _tmp1_ - 1;
	_tmp2_ = self->priv->hold_count;
	if (_tmp2_ == 0) {
		chess_game_complete_move (self);
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_ = 0;
	ChessRule rule = 0;
	ChessResult _result_ = 0;
	ChessState* _tmp1_ = NULL;
	ChessState* _tmp2_ = NULL;
	ChessRule _tmp3_ = 0;
	ChessResult _tmp4_ = 0;
	ChessResult _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = chess_game_get_current_state (self);
	_tmp2_ = _tmp1_;
	_tmp4_ = chess_state_get_result (_tmp2_, &_tmp3_);
	rule = _tmp3_;
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	if (_tmp5_ != CHESS_RESULT_IN_PROGRESS) {
		ChessResult _tmp6_ = 0;
		ChessRule _tmp7_ = 0;
		_tmp6_ = _result_;
		_tmp7_ = rule;
		chess_game_stop (self, _tmp6_, _tmp7_);
	} else {
		ChessClock* _tmp8_ = NULL;
		ChessPlayer* _tmp13_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		ChessPlayer* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		_tmp8_ = self->priv->_clock;
		if (_tmp8_ != NULL) {
			ChessClock* _tmp9_ = NULL;
			ChessPlayer* _tmp10_ = NULL;
			ChessPlayer* _tmp11_ = NULL;
			Color _tmp12_ = 0;
			_tmp9_ = self->priv->_clock;
			_tmp10_ = chess_game_get_current_player (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->color;
			chess_clock_set_active_color (_tmp9_, _tmp12_);
		}
		_tmp13_ = chess_game_get_current_player (self);
		_tmp14_ = _tmp13_;
		g_signal_emit_by_name (_tmp14_, "start-turn");
		_tmp15_ = chess_game_get_current_player (self);
		_tmp16_ = _tmp15_;
		g_signal_emit_by_name (self, "turn-started", _tmp16_);
	}
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
		_tmp3_ = chess_game_get_opponent (self);
		_tmp4_ = _tmp3_;
		chess_game_undo_cb (self, _tmp4_);
	}
	_tmp5_ = self->move_stack;
	_tmp6_ = _tmp5_->next;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = self->move_stack;
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
	g_signal_emit_by_name (self, "undo");
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
	}
	result = TRUE;
	return result;
}


static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s1 != NULL, 0);
	count = 1;
	_tmp0_ = self->move_stack;
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
		s2_collection = _tmp0_;
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
			ChessState* _tmp1_ = NULL;
			ChessState* s2 = NULL;
			_tmp1_ = _chess_state_ref0 ((ChessState*) s2_it->data);
			s2 = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_ = NULL;
				ChessState* _tmp4_ = NULL;
				_tmp3_ = s1;
				_tmp4_ = s2;
				if (_tmp3_ != _tmp4_) {
					ChessState* _tmp5_ = NULL;
					ChessState* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = s1;
					_tmp6_ = s2;
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
					_tmp2_ = _tmp7_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gint _tmp8_ = 0;
					_tmp8_ = count;
					count = _tmp8_ + 1;
				}
				_chess_state_unref0 (s2);
			}
		}
	}
	result = count;
	return result;
}


gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp0_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp1_ = NULL;
			ChessState* state = NULL;
			_tmp1_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp1_;
			{
				ChessState* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				_tmp2_ = state;
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
				if (_tmp3_ >= 3) {
					result = TRUE;
					_chess_state_unref0 (state);
					return result;
				}
				_chess_state_unref0 (state);
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->halfmove_clock;
	result = _tmp2_ >= 100;
	return result;
}


gboolean chess_game_can_claim_draw (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = chess_game_is_fifty_move_rule_fulfilled (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = chess_game_is_three_fold_repeat (self);
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static void chess_game_claim_draw_cb (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_game_is_fifty_move_rule_fulfilled (self);
	if (_tmp0_) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
	} else {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = chess_game_is_three_fold_repeat (self);
		if (_tmp1_) {
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
		}
	}
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
	chess_game_clock_expired_cb ((ChessGame*) self, _sender);
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessPlayer* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->result;
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
		return;
	}
	_tmp1_ = self->is_started;
	if (_tmp1_) {
		return;
	}
	self->is_started = TRUE;
	_tmp2_ = self->priv->_clock;
	if (_tmp2_ != NULL) {
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
		_tmp3_ = self->priv->_clock;
		g_signal_connect (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self);
		_tmp4_ = self->priv->_clock;
		_tmp5_ = chess_game_get_current_player (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->color;
		chess_clock_set_active_color (_tmp4_, _tmp7_);
	}
	_tmp8_ = chess_game_get_current_player (self);
	_tmp9_ = _tmp8_;
	g_signal_emit_by_name (_tmp9_, "start-turn");
	_tmp10_ = chess_game_get_current_player (self);
	_tmp11_ = _tmp10_;
	g_signal_emit_by_name (self, "turn-started", _tmp11_);
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = chess_game_get_current_player (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
	}
}


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_ = 0;
	ChessState* state = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	ChessState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ChessPiece* _tmp13_ = NULL;
	ChessPiece* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = move_number;
	if (_tmp0_ < 0) {
		gint _tmp1_ = 0;
		GList* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp1_ = move_number;
		_tmp2_ = self->move_stack;
		_tmp3_ = g_list_length (_tmp2_);
		move_number = _tmp1_ + ((gint) _tmp3_);
	}
	_tmp4_ = self->move_stack;
	_tmp5_ = self->move_stack;
	_tmp6_ = g_list_length (_tmp5_);
	_tmp7_ = move_number;
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
	_tmp9_ = _chess_state_ref0 ((ChessState*) _tmp8_);
	state = _tmp9_;
	_tmp10_ = rank;
	_tmp11_ = file;
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
	_tmp13_ = state->board[_tmp12_];
	_tmp14_ = _chess_piece_ref0 (_tmp13_);
	result = _tmp14_;
	_chess_state_unref0 (state);
	return result;
}


void chess_game_pause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_ = 0;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_pause (_tmp7_);
		chess_game_set_is_paused (self, TRUE);
		g_signal_emit_by_name (self, "paused");
	}
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_ = 0;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_unpause (_tmp7_);
		chess_game_set_is_paused (self, FALSE);
		g_signal_emit_by_name (self, "unpaused");
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_ = FALSE;
	ChessResult _tmp1_ = 0;
	ChessRule _tmp2_ = 0;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = _result_;
	self->result = _tmp1_;
	_tmp2_ = rule;
	self->rule = _tmp2_;
	self->is_started = FALSE;
	_tmp3_ = self->priv->_clock;
	if (_tmp3_ != NULL) {
		ChessClock* _tmp4_ = NULL;
		_tmp4_ = self->priv->_clock;
		chess_clock_stop (_tmp4_);
	}
	g_signal_emit_by_name (self, "ended");
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_paused = _tmp0_;
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->move_stack;
	_tmp1_ = _tmp0_->data;
	result = (ChessState*) _tmp1_;
	return result;
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_player;
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_state_get_opponent (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_clock;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_ = FALSE;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_clock);
	self->priv->_clock = _tmp2_;
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->move_stack;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_ - 1;
	return result;
}


static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__CHESS_MOVE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__CHESS_MOVE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__CHESS_MOVE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_chess_move (param_values + 1), data2);
}


static void value_chess_game_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_game_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_game_unref (value->data[0].v_pointer);
	}
}


static void value_chess_game_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_game_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_game_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessGame* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_game_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessGame** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_game_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessGame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_GAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_game (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_game_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_game_unref (old);
	}
}


void value_take_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_game_unref (old);
	}
}


static void chess_game_class_init (ChessGameClass * klass) {
	chess_game_parent_class = g_type_class_peek_parent (klass);
	CHESS_GAME_CLASS (klass)->finalize = chess_game_finalize;
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
	g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
	g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__CHESS_MOVE, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
	g_signal_new ("paused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_game_instance_init (ChessGame * self) {
	self->priv = CHESS_GAME_GET_PRIVATE (self);
	self->priv->hold_count = 0;
	self->priv->_is_paused = FALSE;
	self->ref_count = 1;
}


static void chess_game_finalize (ChessGame* obj) {
	ChessGame * self;
	ChessClock* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
	_tmp0_ = self->priv->_clock;
	if (_tmp0_ != NULL) {
		ChessClock* _tmp1_ = NULL;
		_tmp1_ = self->priv->_clock;
		chess_clock_stop (_tmp1_);
	}
	__g_list_free__chess_state_unref0_0 (self->move_stack);
	_g_object_unref0 (self->priv->_clock);
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_game_init, value_chess_game_free_value, value_chess_game_copy_value, value_chess_game_peek_pointer, "p", value_chess_game_collect_value, "p", value_chess_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessGame", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


gpointer chess_game_ref (gpointer instance) {
	ChessGame* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_game_unref (gpointer instance) {
	ChessGame* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_GAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



