/* sudoku-generator.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _sudoku_board_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_board_unref (var), NULL)))

#define SUDOKU_GENERATOR_TYPE_RATED_SUDOKU (sudoku_generator_rated_sudoku_get_type ())

#define TYPE_DIFFICULTY_RATING (difficulty_rating_get_type ())
#define DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIFFICULTY_RATING, DifficultyRating))
#define DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))
#define IS_DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIFFICULTY_RATING))
#define IS_DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIFFICULTY_RATING))
#define DIFFICULTY_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))

typedef struct _DifficultyRating DifficultyRating;
typedef struct _DifficultyRatingClass DifficultyRatingClass;
typedef struct _SudokuGeneratorRatedSudoku SudokuGeneratorRatedSudoku;
#define _sudoku_generator_rated_sudoku_free0(var) ((var == NULL) ? NULL : (var = (sudoku_generator_rated_sudoku_free (var), NULL)))
typedef struct _DifficultyRatingPrivate DifficultyRatingPrivate;
#define _sudoku_generator_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_generator_unref (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_SUDOKU_SOLVER (sudoku_solver_get_type ())
#define SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SOLVER, SudokuSolver))
#define SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SOLVER, SudokuSolverClass))
#define IS_SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SOLVER))
#define IS_SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SOLVER))
#define SUDOKU_SOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SOLVER, SudokuSolverClass))

typedef struct _SudokuSolver SudokuSolver;
typedef struct _SudokuSolverClass SudokuSolverClass;

#define TYPE_SUDOKU_RATER (sudoku_rater_get_type ())
#define SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_RATER, SudokuRater))
#define SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_RATER, SudokuRaterClass))
#define IS_SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_RATER))
#define IS_SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_RATER))
#define SUDOKU_RATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_RATER, SudokuRaterClass))

typedef struct _SudokuRater SudokuRater;
typedef struct _SudokuRaterClass SudokuRaterClass;
#define _difficulty_rating_unref0(var) ((var == NULL) ? NULL : (var = (difficulty_rating_unref (var), NULL)))
#define _sudoku_solver_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_solver_unref (var), NULL)))
typedef struct _SudokuSolverPrivate SudokuSolverPrivate;

#define TYPE_GUESS_LIST (guess_list_get_type ())
#define GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS_LIST, GuessList))
#define GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS_LIST, GuessListClass))
#define IS_GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS_LIST))
#define IS_GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS_LIST))
#define GUESS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS_LIST, GuessListClass))

typedef struct _GuessList GuessList;
typedef struct _GuessListClass GuessListClass;

#define TYPE_BREADCRUMB_TRAIL (breadcrumb_trail_get_type ())
#define BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrail))
#define BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))
#define IS_BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BREADCRUMB_TRAIL))
#define IS_BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BREADCRUMB_TRAIL))
#define BREADCRUMB_TRAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))

typedef struct _BreadcrumbTrail BreadcrumbTrail;
typedef struct _BreadcrumbTrailClass BreadcrumbTrailClass;

#define TYPE_GUESS (guess_get_type ())
#define GUESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS, Guess))
#define GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS, GuessClass))
#define IS_GUESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS))
#define IS_GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS))
#define GUESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS, GuessClass))

typedef struct _Guess Guess;
typedef struct _GuessClass GuessClass;
#define _guess_unref0(var) ((var == NULL) ? NULL : (var = (guess_unref (var), NULL)))
typedef struct _ParamSpecSudokuGenerator ParamSpecSudokuGenerator;

struct _SudokuGenerator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuGeneratorPrivate * priv;
	gint clues;
	SudokuBoard* start_board;
};

struct _SudokuGeneratorClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuGenerator *self);
};

struct _SudokuGeneratorPrivate {
	SudokuBoard* temp_start_board;
};

struct _SudokuGeneratorRatedSudoku {
	SudokuBoard* board;
	DifficultyRating* diff;
};

struct _DifficultyRating {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DifficultyRatingPrivate * priv;
	gfloat rating;
};

struct _DifficultyRatingClass {
	GTypeClass parent_class;
	void (*finalize) (DifficultyRating *self);
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuBoard *self);
};

typedef enum  {
	SUDOKU_ERROR_UNSOLVABLE_PUZZLE,
	SUDOKU_ERROR_CONFLICT_ERROR,
	SUDOKU_ERROR_ALREADY_SET_ERROR
} SudokuError;
#define SUDOKU_ERROR sudoku_error_quark ()
struct _SudokuSolver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuSolverPrivate * priv;
	SudokuBoard* board;
	GuessList* guesses;
	BreadcrumbTrail* breadcrumbs;
	gint backtraces;
	gboolean solved;
};

struct _SudokuSolverClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuSolver *self);
	gboolean (*guess_least_open_square) (SudokuSolver* self, GError** error);
	void (*insert) (SudokuSolver* self, gint row, gint col, gint val);
};

struct _ParamSpecSudokuGenerator {
	GParamSpec parent_instance;
};


static gpointer sudoku_generator_parent_class = NULL;

gpointer sudoku_generator_ref (gpointer instance);
void sudoku_generator_unref (gpointer instance);
GParamSpec* param_spec_sudoku_generator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_generator (GValue* value, gpointer v_object);
void value_take_sudoku_generator (GValue* value, gpointer v_object);
gpointer value_get_sudoku_generator (const GValue* value);
GType sudoku_generator_get_type (void) G_GNUC_CONST;
gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
#define SUDOKU_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GENERATOR, SudokuGeneratorPrivate))
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
SudokuGenerator* sudoku_generator_new (void);
SudokuGenerator* sudoku_generator_construct (GType object_type);
static void sudoku_generator_generate_start_board (SudokuGenerator* self, gint row, gint col, gint no, gint filled, gint* solution);
void sudoku_generator_gen_stats (void);
GType sudoku_generator_rated_sudoku_get_type (void) G_GNUC_CONST;
gpointer difficulty_rating_ref (gpointer instance);
void difficulty_rating_unref (gpointer instance);
GParamSpec* param_spec_difficulty_rating (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_difficulty_rating (GValue* value, gpointer v_object);
void value_take_difficulty_rating (GValue* value, gpointer v_object);
gpointer value_get_difficulty_rating (const GValue* value);
GType difficulty_rating_get_type (void) G_GNUC_CONST;
SudokuGeneratorRatedSudoku* sudoku_generator_rated_sudoku_dup (const SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_free (SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_copy (const SudokuGeneratorRatedSudoku* self, SudokuGeneratorRatedSudoku* dest);
void sudoku_generator_rated_sudoku_destroy (SudokuGeneratorRatedSudoku* self);
SudokuGeneratorRatedSudoku* sudoku_generator_make_unique_puzzle (SudokuGenerator* self, gint line, gboolean strict_number_of_clues);
SudokuBoard* sudoku_generator_generate (SudokuGenerator* self, gfloat* difficulty_range, int difficulty_range_length1, gboolean symmetric);
static gint sudoku_generator_get_cells_for (SudokuGenerator* self, gfloat difficulty);
gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1);
SudokuBoard* sudoku_generator_make_puzzle_by_boxes (SudokuGenerator* self, gfloat skew_by);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
SudokuBoard* sudoku_generator_make_symmetric_puzzle (SudokuGenerator* self, gint line);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void sudoku_generator_reflect (SudokuGenerator* self, gint row, gint col, gint line, Coord* result);
void coord_init (Coord *self, gint row, gint col);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
gpointer sudoku_solver_ref (gpointer instance);
void sudoku_solver_unref (gpointer instance);
GParamSpec* param_spec_sudoku_solver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_solver (GValue* value, gpointer v_object);
void value_take_sudoku_solver (GValue* value, gpointer v_object);
gpointer value_get_sudoku_solver (const GValue* value);
GType sudoku_solver_get_type (void) G_GNUC_CONST;
GType sudoku_rater_get_type (void) G_GNUC_CONST;
SudokuRater* sudoku_rater_new (SudokuBoard** board);
SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board);
gboolean sudoku_solver_has_unique_solution (SudokuSolver* self);
DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self);
GQuark sudoku_error_quark (void);
GType guess_list_get_type (void) G_GNUC_CONST;
GType breadcrumb_trail_get_type (void) G_GNUC_CONST;
gpointer guess_ref (gpointer instance);
void guess_unref (gpointer instance);
GParamSpec* param_spec_guess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_guess (GValue* value, gpointer v_object);
void value_take_guess (GValue* value, gpointer v_object);
gpointer value_get_guess (const GValue* value);
GType guess_get_type (void) G_GNUC_CONST;
gint guess_get_row (Guess* self);
gint guess_get_col (Guess* self);
void sudoku_generator_rated_sudoku_init (SudokuGeneratorRatedSudoku *self, SudokuBoard* board, DifficultyRating* diff);
static void sudoku_generator_finalize (SudokuGenerator* obj);


SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator* self = NULL;
	gint solution = 0;
	self = (SudokuGenerator*) g_type_create_instance (object_type);
	solution = 0;
	sudoku_generator_generate_start_board (self, -1, -1, -1, -1, &solution);
	return self;
}


SudokuGenerator* sudoku_generator_new (void) {
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
}


void sudoku_generator_gen_stats (void) {
	{
		gint i = 0;
		i = 22;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				FILE* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				FILE* _tmp25_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < 77)) {
					break;
				}
				_tmp3_ = stdout;
				_tmp4_ = i;
				fprintf (_tmp3_, "%d, ", _tmp4_);
				{
					gint repeat = 0;
					repeat = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							SudokuGenerator* gen = NULL;
							SudokuGenerator* _tmp10_ = NULL;
							SudokuGenerator* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							SudokuGeneratorRatedSudoku* rated_sudoku = NULL;
							SudokuGenerator* _tmp13_ = NULL;
							gint32 _tmp14_ = 0;
							SudokuGeneratorRatedSudoku* _tmp15_ = NULL;
							FILE* _tmp21_ = NULL;
							SudokuGeneratorRatedSudoku* _tmp22_ = NULL;
							DifficultyRating* _tmp23_ = NULL;
							gfloat _tmp24_ = 0.0F;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = repeat;
								repeat = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = repeat;
							if (!(_tmp7_ < 50)) {
								break;
							}
							_tmp8_ = stdout;
							_tmp9_ = repeat;
							fprintf (_tmp8_, "repeat %d\n", _tmp9_);
							_tmp10_ = sudoku_generator_new ();
							gen = _tmp10_;
							_tmp11_ = gen;
							_tmp12_ = i;
							_tmp11_->clues = _tmp12_;
							_tmp13_ = gen;
							_tmp14_ = g_random_int_range ((gint32) 0, (gint32) 4);
							_tmp15_ = sudoku_generator_make_unique_puzzle (_tmp13_, (gint) _tmp14_, TRUE);
							rated_sudoku = _tmp15_;
							while (TRUE) {
								SudokuGeneratorRatedSudoku* _tmp16_ = NULL;
								_tmp16_ = rated_sudoku;
								if (_tmp16_ == NULL) {
									SudokuGenerator* _tmp17_ = NULL;
									gint32 _tmp18_ = 0;
									SudokuGeneratorRatedSudoku* _tmp19_ = NULL;
									SudokuGeneratorRatedSudoku* _tmp20_ = NULL;
									_tmp17_ = gen;
									_tmp18_ = g_random_int_range ((gint32) 0, (gint32) 4);
									_tmp19_ = sudoku_generator_make_unique_puzzle (_tmp17_, (gint) _tmp18_, TRUE);
									_tmp20_ = _tmp19_;
									_sudoku_generator_rated_sudoku_free0 (_tmp20_);
								} else {
									break;
								}
							}
							_tmp21_ = stdout;
							_tmp22_ = rated_sudoku;
							_tmp23_ = (*_tmp22_).diff;
							_tmp24_ = _tmp23_->rating;
							fprintf (_tmp21_, "%f, ", (gdouble) _tmp24_);
							_sudoku_generator_rated_sudoku_free0 (rated_sudoku);
							_sudoku_generator_unref0 (gen);
						}
					}
				}
				_tmp25_ = stdout;
				fprintf (_tmp25_, "\n");
			}
		}
	}
}


static gpointer _sudoku_board_ref0 (gpointer self) {
	return self ? sudoku_board_ref (self) : NULL;
}


SudokuBoard* sudoku_generator_generate (SudokuGenerator* self, gfloat* difficulty_range, int difficulty_range_length1, gboolean symmetric) {
	SudokuBoard* result = NULL;
	gint count = 0;
	FILE* _tmp32_ = NULL;
	SudokuBoard* _tmp33_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	count = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gfloat skew = 0.0F;
			gfloat* _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			gfloat _tmp3_ = 0.0F;
			gfloat* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gfloat _tmp5_ = 0.0F;
			gdouble _tmp6_ = 0.0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_ = 0;
			SudokuBoard* puzzle = NULL;
			gboolean _tmp13_ = FALSE;
			gint _tmp31_ = 0;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = count;
				if (!(_tmp1_ < 100)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			skew = 0.0f;
			_tmp2_ = difficulty_range;
			_tmp2__length1 = difficulty_range_length1;
			_tmp3_ = _tmp2_[0];
			_tmp4_ = difficulty_range;
			_tmp4__length1 = difficulty_range_length1;
			_tmp5_ = _tmp4_[1];
			_tmp6_ = g_random_double_range ((gdouble) _tmp3_, (gdouble) _tmp5_);
			_tmp7_ = sudoku_generator_get_cells_for (self, (gfloat) _tmp6_);
			self->clues = _tmp7_;
			_tmp8_ = self->clues;
			if (_tmp8_ < 17) {
				self->clues = 17;
			}
			_tmp9_ = self->clues;
			if (_tmp9_ > 60) {
				self->clues = 60;
			}
			_tmp11_ = count;
			if (_tmp11_ >= 10) {
				gint _tmp12_ = 0;
				_tmp12_ = count;
				_tmp10_ = (_tmp12_ % 10) == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gint solution = 0;
				solution = 0;
				sudoku_generator_generate_start_board (self, -1, -1, -1, -1, &solution);
			}
			_tmp13_ = symmetric;
			if (_tmp13_) {
				SudokuGeneratorRatedSudoku rated_sudoku = {0};
				gint32 _tmp14_ = 0;
				SudokuGeneratorRatedSudoku* _tmp15_ = NULL;
				SudokuGeneratorRatedSudoku* _tmp16_ = NULL;
				SudokuGeneratorRatedSudoku _tmp17_ = {0};
				SudokuGeneratorRatedSudoku _tmp18_ = {0};
				gboolean _tmp19_ = FALSE;
				SudokuGeneratorRatedSudoku _tmp20_ = {0};
				SudokuBoard* _tmp21_ = NULL;
				_tmp14_ = g_random_int_range ((gint32) 0, (gint32) 3);
				_tmp15_ = sudoku_generator_make_unique_puzzle (self, (gint) _tmp14_, FALSE);
				_tmp16_ = _tmp15_;
				sudoku_generator_rated_sudoku_copy (_tmp16_, &_tmp17_);
				_tmp18_ = _tmp17_;
				_sudoku_generator_rated_sudoku_free0 (_tmp16_);
				rated_sudoku = _tmp18_;
				_tmp20_ = rated_sudoku;
				_tmp21_ = _tmp20_.board;
				if (_tmp21_ != NULL) {
					SudokuGeneratorRatedSudoku _tmp22_ = {0};
					DifficultyRating* _tmp23_ = NULL;
					gfloat* _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gboolean _tmp25_ = FALSE;
					_tmp22_ = rated_sudoku;
					_tmp23_ = _tmp22_.diff;
					_tmp24_ = difficulty_range;
					_tmp24__length1 = difficulty_range_length1;
					_tmp25_ = difficulty_rating_in_range (_tmp23_, _tmp24_, _tmp24__length1);
					_tmp19_ = _tmp25_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					SudokuGeneratorRatedSudoku _tmp26_ = {0};
					SudokuBoard* _tmp27_ = NULL;
					SudokuBoard* _tmp28_ = NULL;
					_tmp26_ = rated_sudoku;
					_tmp27_ = _tmp26_.board;
					_tmp28_ = _sudoku_board_ref0 (_tmp27_);
					result = _tmp28_;
					sudoku_generator_rated_sudoku_destroy (&rated_sudoku);
					_sudoku_board_unref0 (puzzle);
					return result;
				}
				sudoku_generator_rated_sudoku_destroy (&rated_sudoku);
			} else {
				gfloat _tmp29_ = 0.0F;
				SudokuBoard* _tmp30_ = NULL;
				_tmp29_ = skew;
				_tmp30_ = sudoku_generator_make_puzzle_by_boxes (self, _tmp29_);
				_sudoku_board_unref0 (puzzle);
				puzzle = _tmp30_;
			}
			_tmp31_ = count;
			count = _tmp31_ + 1;
			_sudoku_board_unref0 (puzzle);
		}
	}
	_tmp32_ = stdout;
	fprintf (_tmp32_, "Puzzle not found..\n");
	_tmp33_ = sudoku_board_new (3, 3);
	result = _tmp33_;
	return result;
}


static gint sudoku_generator_get_cells_for (SudokuGenerator* self, gfloat difficulty) {
	gint result = 0;
	gfloat _tmp0_ = 0.0F;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = difficulty;
	result = (gint) (((-22.3275863216) * _tmp0_) + 44.9652207631);
	return result;
}


static void sudoku_generator_generate_start_board (SudokuGenerator* self, gint row, gint col, gint no, gint filled, gint* solution) {
	gint _tmp0_ = 0;
	gint _tmp4_ = 0;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint _tmp48_ = 0;
	SudokuBoard* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	SudokuBoard* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = filled;
	if (_tmp0_ == (-1)) {
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->temp_start_board;
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
		_tmp3_ = _tmp2_;
		filled = _tmp3_;
	}
	_tmp4_ = filled;
	_tmp5_ = self->priv->temp_start_board;
	_tmp6_ = sudoku_board_get_rows (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->temp_start_board;
	_tmp9_ = sudoku_board_get_cols (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp4_ == (_tmp7_ * _tmp10_)) {
		gint _tmp11_ = 0;
		_tmp11_ = *solution;
		*solution = _tmp11_ + 1;
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gint _tmp14_ = 0;
					if (!_tmp12_) {
						gint _tmp13_ = 0;
						_tmp13_ = y;
						y = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = y;
					if (!(_tmp14_ < 9)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp15_ = FALSE;
							_tmp15_ = TRUE;
							while (TRUE) {
								gint _tmp17_ = 0;
								SudokuBoard* _tmp18_ = NULL;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								SudokuBoard* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								if (!_tmp15_) {
									gint _tmp16_ = 0;
									_tmp16_ = x;
									x = _tmp16_ + 1;
								}
								_tmp15_ = FALSE;
								_tmp17_ = x;
								if (!(_tmp17_ < 9)) {
									break;
								}
								_tmp18_ = self->start_board;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = self->priv->temp_start_board;
								_tmp22_ = x;
								_tmp23_ = y;
								_tmp24_ = sudoku_board_get (_tmp21_, _tmp22_, _tmp23_);
								sudoku_board_insert (_tmp18_, _tmp19_, _tmp20_, _tmp24_, FALSE);
							}
						}
					}
				}
			}
		}
		return;
	}
	_tmp26_ = row;
	if (_tmp26_ == (-1)) {
		_tmp25_ = TRUE;
	} else {
		gint _tmp27_ = 0;
		_tmp27_ = col;
		_tmp25_ = _tmp27_ == (-1);
	}
	if (_tmp25_) {
		{
			gint l1 = 0;
			l1 = 0;
			{
				gboolean _tmp28_ = FALSE;
				_tmp28_ = TRUE;
				while (TRUE) {
					gint _tmp30_ = 0;
					SudokuBoard* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					if (!_tmp28_) {
						gint _tmp29_ = 0;
						_tmp29_ = l1;
						l1 = _tmp29_ + 1;
					}
					_tmp28_ = FALSE;
					_tmp30_ = l1;
					_tmp31_ = self->priv->temp_start_board;
					_tmp32_ = sudoku_board_get_rows (_tmp31_);
					_tmp33_ = _tmp32_;
					if (!(_tmp30_ < _tmp33_)) {
						break;
					}
					{
						gint l2 = 0;
						l2 = 0;
						{
							gboolean _tmp34_ = FALSE;
							_tmp34_ = TRUE;
							while (TRUE) {
								gint _tmp36_ = 0;
								SudokuBoard* _tmp37_ = NULL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								SudokuBoard* _tmp40_ = NULL;
								gint _tmp41_ = 0;
								gint _tmp42_ = 0;
								gint _tmp43_ = 0;
								if (!_tmp34_) {
									gint _tmp35_ = 0;
									_tmp35_ = l2;
									l2 = _tmp35_ + 1;
								}
								_tmp34_ = FALSE;
								_tmp36_ = l2;
								_tmp37_ = self->priv->temp_start_board;
								_tmp38_ = sudoku_board_get_cols (_tmp37_);
								_tmp39_ = _tmp38_;
								if (!(_tmp36_ < _tmp39_)) {
									break;
								}
								_tmp40_ = self->priv->temp_start_board;
								_tmp41_ = l1;
								_tmp42_ = l2;
								_tmp43_ = sudoku_board_get (_tmp40_, _tmp41_, _tmp42_);
								if (_tmp43_ == 0) {
									gint _tmp44_ = 0;
									gint _tmp45_ = 0;
									gint _tmp46_ = 0;
									gint _tmp47_ = 0;
									_tmp44_ = l1;
									_tmp45_ = l2;
									_tmp46_ = no;
									_tmp47_ = filled;
									sudoku_generator_generate_start_board (self, _tmp44_, _tmp45_, _tmp46_, _tmp47_, solution);
									return;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp48_ = no;
	if (_tmp48_ == (-1)) {
		gboolean* values_tried = NULL;
		SudokuBoard* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gboolean* _tmp52_ = NULL;
		gint values_tried_length1 = 0;
		gint _values_tried_size_ = 0;
		gint values_tried_count = 0;
		_tmp49_ = self->priv->temp_start_board;
		_tmp50_ = sudoku_board_get_max_val (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_new0 (gboolean, _tmp51_);
		values_tried = _tmp52_;
		values_tried_length1 = _tmp51_;
		_values_tried_size_ = values_tried_length1;
		values_tried_count = 0;
		while (TRUE) {
			gint _tmp53_ = 0;
			SudokuBoard* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint l1 = 0;
			gint _tmp65_ = 0;
			SudokuBoard* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			gboolean _tmp70_ = FALSE;
			_tmp53_ = values_tried_count;
			_tmp54_ = self->priv->temp_start_board;
			_tmp55_ = sudoku_board_get_max_val (_tmp54_);
			_tmp56_ = _tmp55_;
			if (!(_tmp53_ < _tmp56_)) {
				break;
			}
			l1 = -1;
			{
				gboolean _tmp57_ = FALSE;
				_tmp57_ = TRUE;
				while (TRUE) {
					SudokuBoard* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint32 _tmp64_ = 0;
					if (!_tmp57_) {
						gboolean* _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp59_ = 0;
						gboolean _tmp60_ = FALSE;
						_tmp58_ = values_tried;
						_tmp58__length1 = values_tried_length1;
						_tmp59_ = l1;
						_tmp60_ = _tmp58_[_tmp59_];
						if (!_tmp60_) {
							break;
						}
					}
					_tmp57_ = FALSE;
					_tmp61_ = self->priv->temp_start_board;
					_tmp62_ = sudoku_board_get_max_val (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = g_random_int_range ((gint32) 0, (gint32) _tmp63_);
					l1 = (gint) (_tmp64_ + 1);
				}
			}
			_tmp65_ = values_tried_count;
			values_tried_count = _tmp65_ + 1;
			_tmp66_ = self->priv->temp_start_board;
			_tmp67_ = row;
			_tmp68_ = col;
			_tmp69_ = l1;
			_tmp70_ = sudoku_board_is_possible (_tmp66_, _tmp67_, _tmp68_, _tmp69_);
			if (_tmp70_) {
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				_tmp71_ = row;
				_tmp72_ = col;
				_tmp73_ = l1;
				_tmp74_ = filled;
				sudoku_generator_generate_start_board (self, _tmp71_, _tmp72_, _tmp73_, _tmp74_, solution);
				_tmp75_ = *solution;
				if (_tmp75_ > 0) {
					values_tried = (g_free (values_tried), NULL);
					return;
				}
			}
		}
		values_tried = (g_free (values_tried), NULL);
		return;
	}
	_tmp76_ = self->priv->temp_start_board;
	_tmp77_ = row;
	_tmp78_ = col;
	_tmp79_ = no;
	sudoku_board_insert (_tmp76_, _tmp77_, _tmp78_, _tmp79_, FALSE);
	_tmp80_ = filled;
	sudoku_generator_generate_start_board (self, -1, -1, -1, _tmp80_ + 1, solution);
	_tmp81_ = self->priv->temp_start_board;
	_tmp82_ = row;
	_tmp83_ = col;
	sudoku_board_remove (_tmp81_, _tmp82_, _tmp83_, FALSE);
}


SudokuBoard* sudoku_generator_make_symmetric_puzzle (SudokuGenerator* self, gint line) {
	SudokuBoard* result = NULL;
	SudokuBoard* new_puzzle = NULL;
	SudokuBoard* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_new (3, 3);
	new_puzzle = _tmp0_;
	while (TRUE) {
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint row = 0;
		gint32 _tmp5_ = 0;
		gint col = 0;
		gint32 _tmp6_ = 0;
		SudokuBoard* _tmp7_ = NULL;
		gboolean* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gint _tmp8__length2 = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		_tmp1_ = new_puzzle;
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->clues;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = g_random_int_range ((gint32) 0, (gint32) 9);
		row = (gint) _tmp5_;
		_tmp6_ = g_random_int_range ((gint32) 0, (gint32) 9);
		col = (gint) _tmp6_;
		_tmp7_ = new_puzzle;
		_tmp8_ = _tmp7_->is_fixed;
		_tmp8__length1 = _tmp7_->is_fixed_length1;
		_tmp8__length2 = _tmp7_->is_fixed_length2;
		_tmp9_ = row;
		_tmp10_ = col;
		_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
		if (!_tmp11_) {
			Coord reflection = {0};
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Coord _tmp15_ = {0};
			SudokuBoard* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			SudokuBoard* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gboolean _tmp23_ = FALSE;
			Coord _tmp24_ = {0};
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			SudokuBoard* _tmp30_ = NULL;
			Coord _tmp31_ = {0};
			gint _tmp32_ = 0;
			Coord _tmp33_ = {0};
			gint _tmp34_ = 0;
			SudokuBoard* _tmp35_ = NULL;
			Coord _tmp36_ = {0};
			gint _tmp37_ = 0;
			Coord _tmp38_ = {0};
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			_tmp12_ = row;
			_tmp13_ = col;
			_tmp14_ = line;
			sudoku_generator_reflect (self, _tmp12_, _tmp13_, _tmp14_, &_tmp15_);
			reflection = _tmp15_;
			_tmp16_ = new_puzzle;
			_tmp17_ = row;
			_tmp18_ = col;
			_tmp19_ = self->start_board;
			_tmp20_ = row;
			_tmp21_ = col;
			_tmp22_ = sudoku_board_get (_tmp19_, _tmp20_, _tmp21_);
			sudoku_board_insert (_tmp16_, _tmp17_, _tmp18_, _tmp22_, TRUE);
			_tmp24_ = reflection;
			_tmp25_ = _tmp24_.row;
			_tmp26_ = row;
			if (_tmp25_ == _tmp26_) {
				Coord _tmp27_ = {0};
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				_tmp27_ = reflection;
				_tmp28_ = _tmp27_.col;
				_tmp29_ = col;
				_tmp23_ = _tmp28_ == _tmp29_;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				continue;
			}
			_tmp30_ = new_puzzle;
			_tmp31_ = reflection;
			_tmp32_ = _tmp31_.row;
			_tmp33_ = reflection;
			_tmp34_ = _tmp33_.col;
			_tmp35_ = self->start_board;
			_tmp36_ = reflection;
			_tmp37_ = _tmp36_.row;
			_tmp38_ = reflection;
			_tmp39_ = _tmp38_.col;
			_tmp40_ = sudoku_board_get (_tmp35_, _tmp37_, _tmp39_);
			sudoku_board_insert (_tmp30_, _tmp32_, _tmp34_, _tmp40_, TRUE);
		}
	}
	result = new_puzzle;
	return result;
}


static void sudoku_generator_reflect (SudokuGenerator* self, gint row, gint col, gint line, Coord* result) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = line;
	if (_tmp0_ == 0) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		Coord _tmp3_ = {0};
		_tmp1_ = row;
		_tmp2_ = col;
		coord_init (&_tmp3_, _tmp1_, 8 - _tmp2_);
		*result = _tmp3_;
		return;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = line;
		if (_tmp4_ == 1) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			Coord _tmp7_ = {0};
			_tmp5_ = col;
			_tmp6_ = row;
			coord_init (&_tmp7_, 8 - _tmp5_, 8 - _tmp6_);
			*result = _tmp7_;
			return;
		} else {
			gint _tmp8_ = 0;
			_tmp8_ = line;
			if (_tmp8_ == 2) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				Coord _tmp11_ = {0};
				_tmp9_ = row;
				_tmp10_ = col;
				coord_init (&_tmp11_, 8 - _tmp9_, _tmp10_);
				*result = _tmp11_;
				return;
			} else {
				gint _tmp12_ = 0;
				_tmp12_ = line;
				if (_tmp12_ == 3) {
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					Coord _tmp15_ = {0};
					_tmp13_ = row;
					_tmp14_ = col;
					coord_init (&_tmp15_, 8 - _tmp13_, 8 - _tmp14_);
					*result = _tmp15_;
					return;
				} else {
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					Coord _tmp18_ = {0};
					_tmp16_ = row;
					_tmp17_ = col;
					coord_init (&_tmp18_, _tmp16_, _tmp17_);
					*result = _tmp18_;
					return;
				}
			}
		}
	}
}


SudokuBoard* sudoku_generator_make_puzzle_by_boxes (SudokuGenerator* self, gfloat skew_by) {
	SudokuBoard* result = NULL;
	SudokuBoard* new_puzzle = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint nboxes = 0;
	gint max_squares = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat _tmp6_ = 0.0F;
	gint clued = 0;
	gint* nclues = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint nclues_length1 = 0;
	gint _nclues_size_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_new (3, 3);
	new_puzzle = _tmp0_;
	nboxes = 9;
	_tmp1_ = self->clues;
	_tmp2_ = nboxes;
	max_squares = _tmp1_ / _tmp2_;
	_tmp3_ = max_squares;
	_tmp4_ = nboxes;
	_tmp5_ = max_squares;
	_tmp6_ = skew_by;
	max_squares = _tmp3_ + ((gint) ((_tmp4_ - _tmp5_) * _tmp6_));
	clued = 0;
	_tmp7_ = nboxes;
	_tmp8_ = g_new0 (gint, _tmp7_);
	nclues = _tmp8_;
	nclues_length1 = _tmp7_;
	_nclues_size_ = nclues_length1;
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint clues = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gfloat _tmp25_ = 0.0F;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = n;
					n = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = n;
				_tmp12_ = nboxes;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = max_squares;
				clues = _tmp13_;
				_tmp14_ = clues;
				_tmp15_ = self->clues;
				_tmp16_ = clued;
				if (_tmp14_ > (_tmp15_ - _tmp16_)) {
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp17_ = self->clues;
					_tmp18_ = clued;
					clues = _tmp17_ - _tmp18_;
				}
				_tmp19_ = nclues;
				_tmp19__length1 = nclues_length1;
				_tmp20_ = n;
				_tmp21_ = clues;
				_tmp19_[_tmp20_] = _tmp21_;
				_tmp22_ = _tmp19_[_tmp20_];
				_tmp23_ = clued;
				_tmp24_ = clues;
				clued = _tmp23_ + _tmp24_;
				_tmp25_ = skew_by;
				if (_tmp25_ != ((gfloat) 0)) {
					gint _tmp26_ = 0;
					gfloat _tmp27_ = 0.0F;
					gdouble _tmp28_ = 0.0;
					_tmp26_ = max_squares;
					_tmp27_ = skew_by;
					_tmp28_ = round ((gdouble) (_tmp26_ * _tmp27_));
					max_squares = (gint) _tmp28_;
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint from = 0;
				gint _tmp33_ = 0;
				gint32 _tmp34_ = 0;
				gint to = 0;
				gint _tmp35_ = 0;
				gint32 _tmp36_ = 0;
				gint temp = 0;
				gint* _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint* _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gint _tmp41_ = 0;
				gint* _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gint* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				if (!_tmp29_) {
					gint _tmp30_ = 0;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = nboxes;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = nboxes;
				_tmp34_ = g_random_int_range ((gint32) 0, (gint32) _tmp33_);
				from = (gint) _tmp34_;
				_tmp35_ = nboxes;
				_tmp36_ = g_random_int_range ((gint32) 0, (gint32) _tmp35_);
				to = (gint) _tmp36_;
				_tmp37_ = nclues;
				_tmp37__length1 = nclues_length1;
				_tmp38_ = to;
				_tmp39_ = _tmp37_[_tmp38_];
				temp = _tmp39_;
				_tmp40_ = nclues;
				_tmp40__length1 = nclues_length1;
				_tmp41_ = to;
				_tmp42_ = nclues;
				_tmp42__length1 = nclues_length1;
				_tmp43_ = from;
				_tmp44_ = _tmp42_[_tmp43_];
				_tmp40_[_tmp41_] = _tmp44_;
				_tmp45_ = _tmp40_[_tmp41_];
				_tmp46_ = nclues;
				_tmp46__length1 = nclues_length1;
				_tmp47_ = from;
				_tmp48_ = temp;
				_tmp46_[_tmp47_] = _tmp48_;
				_tmp49_ = _tmp46_[_tmp47_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				if (!_tmp50_) {
					gint _tmp51_ = 0;
					_tmp51_ = i;
					i = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = i;
				_tmp53_ = nboxes;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				while (TRUE) {
					gint* _tmp54_ = NULL;
					gint _tmp54__length1 = 0;
					gint _tmp55_ = 0;
					gint _tmp56_ = 0;
					gint base_x = 0;
					gint _tmp57_ = 0;
					SudokuBoard* _tmp58_ = NULL;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					SudokuBoard* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint base_y = 0;
					gint _tmp64_ = 0;
					SudokuBoard* _tmp65_ = NULL;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					SudokuBoard* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					gint x = 0;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					SudokuBoard* _tmp73_ = NULL;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint32 _tmp76_ = 0;
					gint y = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					SudokuBoard* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint32 _tmp82_ = 0;
					SudokuBoard* _tmp83_ = NULL;
					gboolean* _tmp84_ = NULL;
					gint _tmp84__length1 = 0;
					gint _tmp84__length2 = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					gboolean _tmp87_ = FALSE;
					_tmp54_ = nclues;
					_tmp54__length1 = nclues_length1;
					_tmp55_ = i;
					_tmp56_ = _tmp54_[_tmp55_];
					if (!(_tmp56_ > 0)) {
						break;
					}
					_tmp57_ = i;
					_tmp58_ = new_puzzle;
					_tmp59_ = sudoku_board_get_block_cols (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = new_puzzle;
					_tmp62_ = sudoku_board_get_block_cols (_tmp61_);
					_tmp63_ = _tmp62_;
					base_x = (_tmp57_ % _tmp60_) * _tmp63_;
					_tmp64_ = i;
					_tmp65_ = new_puzzle;
					_tmp66_ = sudoku_board_get_block_rows (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = new_puzzle;
					_tmp69_ = sudoku_board_get_block_rows (_tmp68_);
					_tmp70_ = _tmp69_;
					base_y = (_tmp64_ / _tmp67_) * _tmp70_;
					_tmp71_ = base_x;
					_tmp72_ = base_x;
					_tmp73_ = new_puzzle;
					_tmp74_ = sudoku_board_get_block_rows (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_random_int_range ((gint32) _tmp71_, (gint32) (_tmp72_ + _tmp75_));
					x = (gint) _tmp76_;
					_tmp77_ = base_y;
					_tmp78_ = base_y;
					_tmp79_ = new_puzzle;
					_tmp80_ = sudoku_board_get_block_cols (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_random_int_range ((gint32) _tmp77_, (gint32) (_tmp78_ + _tmp81_));
					y = (gint) _tmp82_;
					_tmp83_ = new_puzzle;
					_tmp84_ = _tmp83_->is_fixed;
					_tmp84__length1 = _tmp83_->is_fixed_length1;
					_tmp84__length2 = _tmp83_->is_fixed_length2;
					_tmp85_ = x;
					_tmp86_ = y;
					_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
					if (!_tmp87_) {
						SudokuBoard* _tmp88_ = NULL;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						SudokuBoard* _tmp91_ = NULL;
						gint _tmp92_ = 0;
						gint _tmp93_ = 0;
						gint _tmp94_ = 0;
						gint* _tmp95_ = NULL;
						gint _tmp95__length1 = 0;
						gint _tmp96_ = 0;
						gint _tmp97_ = 0;
						_tmp88_ = new_puzzle;
						_tmp89_ = x;
						_tmp90_ = y;
						_tmp91_ = self->start_board;
						_tmp92_ = x;
						_tmp93_ = y;
						_tmp94_ = sudoku_board_get (_tmp91_, _tmp92_, _tmp93_);
						sudoku_board_insert (_tmp88_, _tmp89_, _tmp90_, _tmp94_, TRUE);
						_tmp95_ = nclues;
						_tmp95__length1 = nclues_length1;
						_tmp96_ = i;
						_tmp97_ = _tmp95_[_tmp96_];
						_tmp95_[_tmp96_] = _tmp97_ - 1;
					}
				}
			}
		}
	}
	result = new_puzzle;
	nclues = (g_free (nclues), NULL);
	return result;
}


static gpointer _sudoku_generator_rated_sudoku_dup0 (gpointer self) {
	return self ? sudoku_generator_rated_sudoku_dup (self) : NULL;
}


SudokuGeneratorRatedSudoku* sudoku_generator_make_unique_puzzle (SudokuGenerator* self, gint line, gboolean strict_number_of_clues) {
	SudokuGeneratorRatedSudoku* result = NULL;
	SudokuBoard* board = NULL;
	DifficultyRating* diff = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp67_ = FALSE;
	SudokuBoard* _tmp105_ = NULL;
	DifficultyRating* _tmp106_ = NULL;
	SudokuGeneratorRatedSudoku _tmp107_ = {0};
	SudokuGeneratorRatedSudoku _tmp108_ = {0};
	SudokuGeneratorRatedSudoku* _tmp109_ = NULL;
	SudokuGeneratorRatedSudoku* _tmp110_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = line;
	if (_tmp0_ != (-1)) {
		gint old_clues = 0;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = self->clues;
		old_clues = _tmp1_;
		self->clues = 4;
		_tmp2_ = line;
		_tmp3_ = sudoku_generator_make_symmetric_puzzle (self, _tmp2_);
		_sudoku_board_unref0 (board);
		board = _tmp3_;
		_tmp4_ = old_clues;
		self->clues = _tmp4_;
	} else {
		SudokuBoard* _tmp5_ = NULL;
		_tmp5_ = sudoku_generator_make_puzzle_by_boxes (self, 0.0f);
		_sudoku_board_unref0 (board);
		board = _tmp5_;
	}
	while (TRUE) {
		SudokuBoard* solved_board = NULL;
		SudokuBoard* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		SudokuRater* solver = NULL;
		SudokuRater* _tmp8_ = NULL;
		SudokuRater* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		Guess* crumb = NULL;
		SudokuRater* _tmp20_ = NULL;
		BreadcrumbTrail* _tmp21_ = NULL;
		SudokuRater* _tmp22_ = NULL;
		BreadcrumbTrail* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gpointer _tmp26_ = NULL;
		SudokuBoard* _tmp27_ = NULL;
		Guess* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		Guess* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		SudokuBoard* _tmp34_ = NULL;
		Guess* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		Guess* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		Coord reflection = {0};
		Guess* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Guess* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Coord _tmp49_ = {0};
		SudokuBoard* _tmp50_ = NULL;
		Coord _tmp51_ = {0};
		gint _tmp52_ = 0;
		Coord _tmp53_ = {0};
		gint _tmp54_ = 0;
		SudokuBoard* _tmp55_ = NULL;
		Coord _tmp56_ = {0};
		gint _tmp57_ = 0;
		Coord _tmp58_ = {0};
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		_tmp6_ = board;
		_tmp7_ = sudoku_board_clone (_tmp6_);
		solved_board = _tmp7_;
		_tmp8_ = sudoku_rater_new (&solved_board);
		solver = _tmp8_;
		_tmp9_ = solver;
		_tmp10_ = sudoku_solver_has_unique_solution ((SudokuSolver*) _tmp9_);
		if (_tmp10_) {
			SudokuRater* _tmp11_ = NULL;
			DifficultyRating* _tmp12_ = NULL;
			_tmp11_ = solver;
			_tmp12_ = sudoku_rater_get_difficulty (_tmp11_);
			_difficulty_rating_unref0 (diff);
			diff = _tmp12_;
			_sudoku_solver_unref0 (solver);
			_sudoku_board_unref0 (solved_board);
			break;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					gint _tmp15_ = 0;
					SudokuRater* _tmp16_ = NULL;
					BreadcrumbTrail* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					if (!_tmp13_) {
						gint _tmp14_ = 0;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = solver;
					_tmp17_ = ((SudokuSolver*) _tmp16_)->breadcrumbs;
					_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					if (!(_tmp15_ < _tmp19_)) {
						break;
					}
				}
			}
		}
		_tmp20_ = solver;
		_tmp21_ = ((SudokuSolver*) _tmp20_)->breadcrumbs;
		_tmp22_ = solver;
		_tmp23_ = ((SudokuSolver*) _tmp22_)->breadcrumbs;
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp25_ - 1);
		crumb = (Guess*) _tmp26_;
		_tmp27_ = board;
		_tmp28_ = crumb;
		_tmp29_ = guess_get_row (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = crumb;
		_tmp32_ = guess_get_col (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->start_board;
		_tmp35_ = crumb;
		_tmp36_ = guess_get_row (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = crumb;
		_tmp39_ = guess_get_col (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = sudoku_board_get (_tmp34_, _tmp37_, _tmp40_);
		sudoku_board_insert (_tmp27_, _tmp30_, _tmp33_, _tmp41_, TRUE);
		_tmp42_ = crumb;
		_tmp43_ = guess_get_row (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = crumb;
		_tmp46_ = guess_get_col (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = line;
		sudoku_generator_reflect (self, _tmp44_, _tmp47_, _tmp48_, &_tmp49_);
		reflection = _tmp49_;
		_tmp50_ = board;
		_tmp51_ = reflection;
		_tmp52_ = _tmp51_.row;
		_tmp53_ = reflection;
		_tmp54_ = _tmp53_.col;
		_tmp55_ = self->start_board;
		_tmp56_ = reflection;
		_tmp57_ = _tmp56_.row;
		_tmp58_ = reflection;
		_tmp59_ = _tmp58_.col;
		_tmp60_ = sudoku_board_get (_tmp55_, _tmp57_, _tmp59_);
		sudoku_board_insert (_tmp50_, _tmp52_, _tmp54_, _tmp60_, TRUE);
		_tmp62_ = strict_number_of_clues;
		if (_tmp62_) {
			SudokuBoard* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			_tmp63_ = board;
			_tmp64_ = sudoku_board_get_filled (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->clues;
			_tmp61_ = _tmp65_ > _tmp66_;
		} else {
			_tmp61_ = FALSE;
		}
		if (_tmp61_) {
			result = NULL;
			_guess_unref0 (crumb);
			_sudoku_solver_unref0 (solver);
			_sudoku_board_unref0 (solved_board);
			_difficulty_rating_unref0 (diff);
			_sudoku_board_unref0 (board);
			return result;
		}
		_guess_unref0 (crumb);
		_sudoku_solver_unref0 (solver);
		_sudoku_board_unref0 (solved_board);
	}
	_tmp67_ = strict_number_of_clues;
	if (_tmp67_) {
		gboolean changed = FALSE;
		gboolean _tmp101_ = FALSE;
		changed = FALSE;
		while (TRUE) {
			SudokuBoard* _tmp68_ = NULL;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint row = 0;
			gint col = 0;
			SudokuBoard* _tmp79_ = NULL;
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			SudokuBoard* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			Coord reflection = {0};
			gint _tmp86_ = 0;
			gint _tmp87_ = 0;
			gint _tmp88_ = 0;
			Coord _tmp89_ = {0};
			SudokuBoard* _tmp90_ = NULL;
			Coord _tmp91_ = {0};
			gint _tmp92_ = 0;
			Coord _tmp93_ = {0};
			gint _tmp94_ = 0;
			SudokuBoard* _tmp95_ = NULL;
			Coord _tmp96_ = {0};
			gint _tmp97_ = 0;
			Coord _tmp98_ = {0};
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			_tmp68_ = board;
			_tmp69_ = sudoku_board_get_filled (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = self->clues;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			row = -1;
			col = -1;
			{
				gboolean _tmp72_ = FALSE;
				_tmp72_ = TRUE;
				while (TRUE) {
					gint32 _tmp77_ = 0;
					gint32 _tmp78_ = 0;
					if (!_tmp72_) {
						SudokuBoard* _tmp73_ = NULL;
						gint _tmp74_ = 0;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
						_tmp73_ = board;
						_tmp74_ = row;
						_tmp75_ = col;
						_tmp76_ = sudoku_board_get (_tmp73_, _tmp74_, _tmp75_);
						if (!(_tmp76_ == 0)) {
							break;
						}
					}
					_tmp72_ = FALSE;
					_tmp77_ = g_random_int_range ((gint32) 0, (gint32) 9);
					row = (gint) _tmp77_;
					_tmp78_ = g_random_int_range ((gint32) 0, (gint32) 9);
					col = (gint) _tmp78_;
				}
			}
			_tmp79_ = board;
			_tmp80_ = row;
			_tmp81_ = col;
			_tmp82_ = self->start_board;
			_tmp83_ = row;
			_tmp84_ = col;
			_tmp85_ = sudoku_board_get (_tmp82_, _tmp83_, _tmp84_);
			sudoku_board_insert (_tmp79_, _tmp80_, _tmp81_, _tmp85_, TRUE);
			_tmp86_ = row;
			_tmp87_ = col;
			_tmp88_ = line;
			sudoku_generator_reflect (self, _tmp86_, _tmp87_, _tmp88_, &_tmp89_);
			reflection = _tmp89_;
			_tmp90_ = board;
			_tmp91_ = reflection;
			_tmp92_ = _tmp91_.row;
			_tmp93_ = reflection;
			_tmp94_ = _tmp93_.col;
			_tmp95_ = self->start_board;
			_tmp96_ = reflection;
			_tmp97_ = _tmp96_.row;
			_tmp98_ = reflection;
			_tmp99_ = _tmp98_.col;
			_tmp100_ = sudoku_board_get (_tmp95_, _tmp97_, _tmp99_);
			sudoku_board_insert (_tmp90_, _tmp92_, _tmp94_, _tmp100_, TRUE);
			changed = TRUE;
		}
		_tmp101_ = changed;
		if (_tmp101_) {
			SudokuRater* _tmp102_ = NULL;
			SudokuRater* _tmp103_ = NULL;
			DifficultyRating* _tmp104_ = NULL;
			_tmp102_ = sudoku_rater_new (&board);
			_tmp103_ = _tmp102_;
			_tmp104_ = sudoku_rater_get_difficulty (_tmp103_);
			_difficulty_rating_unref0 (diff);
			diff = _tmp104_;
			_sudoku_solver_unref0 (_tmp103_);
		}
	}
	_tmp105_ = board;
	_tmp106_ = diff;
	sudoku_generator_rated_sudoku_init (&_tmp107_, _tmp105_, _tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = _sudoku_generator_rated_sudoku_dup0 (&_tmp108_);
	_tmp110_ = _tmp109_;
	sudoku_generator_rated_sudoku_destroy (&_tmp108_);
	result = _tmp110_;
	_difficulty_rating_unref0 (diff);
	_sudoku_board_unref0 (board);
	return result;
}


static gpointer _difficulty_rating_ref0 (gpointer self) {
	return self ? difficulty_rating_ref (self) : NULL;
}


void sudoku_generator_rated_sudoku_init (SudokuGeneratorRatedSudoku *self, SudokuBoard* board, DifficultyRating* diff) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	DifficultyRating* _tmp2_ = NULL;
	DifficultyRating* _tmp3_ = NULL;
	g_return_if_fail (board != NULL);
	g_return_if_fail (diff != NULL);
	memset (self, 0, sizeof (SudokuGeneratorRatedSudoku));
	_tmp0_ = board;
	_tmp1_ = _sudoku_board_ref0 (_tmp0_);
	_sudoku_board_unref0 ((*self).board);
	(*self).board = _tmp1_;
	_tmp2_ = diff;
	_tmp3_ = _difficulty_rating_ref0 (_tmp2_);
	_difficulty_rating_unref0 ((*self).diff);
	(*self).diff = _tmp3_;
}


void sudoku_generator_rated_sudoku_copy (const SudokuGeneratorRatedSudoku* self, SudokuGeneratorRatedSudoku* dest) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	DifficultyRating* _tmp2_ = NULL;
	DifficultyRating* _tmp3_ = NULL;
	_tmp0_ = (*self).board;
	_tmp1_ = _sudoku_board_ref0 (_tmp0_);
	_sudoku_board_unref0 ((*dest).board);
	(*dest).board = _tmp1_;
	_tmp2_ = (*self).diff;
	_tmp3_ = _difficulty_rating_ref0 (_tmp2_);
	_difficulty_rating_unref0 ((*dest).diff);
	(*dest).diff = _tmp3_;
}


void sudoku_generator_rated_sudoku_destroy (SudokuGeneratorRatedSudoku* self) {
	_sudoku_board_unref0 ((*self).board);
	_difficulty_rating_unref0 ((*self).diff);
}


SudokuGeneratorRatedSudoku* sudoku_generator_rated_sudoku_dup (const SudokuGeneratorRatedSudoku* self) {
	SudokuGeneratorRatedSudoku* dup;
	dup = g_new0 (SudokuGeneratorRatedSudoku, 1);
	sudoku_generator_rated_sudoku_copy (self, dup);
	return dup;
}


void sudoku_generator_rated_sudoku_free (SudokuGeneratorRatedSudoku* self) {
	sudoku_generator_rated_sudoku_destroy (self);
	g_free (self);
}


GType sudoku_generator_rated_sudoku_get_type (void) {
	static volatile gsize sudoku_generator_rated_sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_rated_sudoku_type_id__volatile)) {
		GType sudoku_generator_rated_sudoku_type_id;
		sudoku_generator_rated_sudoku_type_id = g_boxed_type_register_static ("SudokuGeneratorRatedSudoku", (GBoxedCopyFunc) sudoku_generator_rated_sudoku_dup, (GBoxedFreeFunc) sudoku_generator_rated_sudoku_free);
		g_once_init_leave (&sudoku_generator_rated_sudoku_type_id__volatile, sudoku_generator_rated_sudoku_type_id);
	}
	return sudoku_generator_rated_sudoku_type_id__volatile;
}


static void value_sudoku_generator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_sudoku_generator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_generator_unref (value->data[0].v_pointer);
	}
}


static void value_sudoku_generator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_generator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_sudoku_generator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_sudoku_generator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuGenerator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_generator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_sudoku_generator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuGenerator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_generator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_sudoku_generator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSudokuGenerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SUDOKU_GENERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_sudoku_generator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_GENERATOR), NULL);
	return value->data[0].v_pointer;
}


void value_set_sudoku_generator (GValue* value, gpointer v_object) {
	SudokuGenerator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_generator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_generator_unref (old);
	}
}


void value_take_sudoku_generator (GValue* value, gpointer v_object) {
	SudokuGenerator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_generator_unref (old);
	}
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_GENERATOR_CLASS (klass)->finalize = sudoku_generator_finalize;
	g_type_class_add_private (klass, sizeof (SudokuGeneratorPrivate));
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	self->priv = SUDOKU_GENERATOR_GET_PRIVATE (self);
	self->clues = 40;
	_tmp0_ = sudoku_board_new (3, 3);
	self->start_board = _tmp0_;
	_tmp1_ = sudoku_board_new (3, 3);
	self->priv->temp_start_board = _tmp1_;
	self->ref_count = 1;
}


static void sudoku_generator_finalize (SudokuGenerator* obj) {
	SudokuGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GENERATOR, SudokuGenerator);
	_sudoku_board_unref0 (self->start_board);
	_sudoku_board_unref0 (self->priv->temp_start_board);
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_sudoku_generator_init, value_sudoku_generator_free_value, value_sudoku_generator_copy_value, value_sudoku_generator_peek_pointer, "p", value_sudoku_generator_collect_value, "p", value_sudoku_generator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuGenerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}


gpointer sudoku_generator_ref (gpointer instance) {
	SudokuGenerator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_generator_unref (gpointer instance) {
	SudokuGenerator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_GENERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



