/* chess-piece.c generated by valac 0.24.0.145-7a3bd, the Vala compiler
 * generated from chess-piece.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>


#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_piece_parent_class = NULL;

GType piece_type_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_PIECE_DUMMY_PROPERTY,
	CHESS_PIECE_COLOR,
	CHESS_PIECE_SYMBOL
};
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
static void chess_piece_finalize (GObject* obj);
static void _vala_chess_piece_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GType piece_type_get_type (void) {
	static volatile gsize piece_type_type_id__volatile = 0;
	if (g_once_init_enter (&piece_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIECE_TYPE_PAWN, "PIECE_TYPE_PAWN", "pawn"}, {PIECE_TYPE_ROOK, "PIECE_TYPE_ROOK", "rook"}, {PIECE_TYPE_KNIGHT, "PIECE_TYPE_KNIGHT", "knight"}, {PIECE_TYPE_BISHOP, "PIECE_TYPE_BISHOP", "bishop"}, {PIECE_TYPE_QUEEN, "PIECE_TYPE_QUEEN", "queen"}, {PIECE_TYPE_KING, "PIECE_TYPE_KING", "king"}, {0, NULL, NULL}};
		GType piece_type_type_id;
		piece_type_type_id = g_enum_register_static ("PieceType", values);
		g_once_init_leave (&piece_type_type_id__volatile, piece_type_type_id);
	}
	return piece_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type) {
	ChessPiece * self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	PieceType _tmp2_ = 0;
	g_return_val_if_fail (player != NULL, NULL);
	self = (ChessPiece*) g_object_new (object_type, NULL);
	_tmp0_ = player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->player);
	self->player = _tmp1_;
	_tmp2_ = type;
	self->type = _tmp2_;
	return self;
}


ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type) {
	return chess_piece_construct (TYPE_CHESS_PIECE, player, type);
}


Color chess_piece_get_color (ChessPiece* self) {
	Color result;
	ChessPlayer* _tmp0_ = NULL;
	Color _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->player;
	_tmp1_ = _tmp0_->color;
	result = _tmp1_;
	return result;
}


gunichar chess_piece_get_symbol (ChessPiece* self) {
	gunichar result;
	gunichar c = 0U;
	PieceType _tmp0_ = 0;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	gunichar _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	c = (gunichar) ' ';
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case PIECE_TYPE_PAWN:
		{
			c = (gunichar) 'p';
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			c = (gunichar) 'r';
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			c = (gunichar) 'n';
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			c = (gunichar) 'b';
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			c = (gunichar) 'q';
			break;
		}
		case PIECE_TYPE_KING:
		{
			c = (gunichar) 'k';
			break;
		}
		default:
		break;
	}
	_tmp1_ = self->player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		gunichar _tmp3_ = 0U;
		gunichar _tmp4_ = 0U;
		_tmp3_ = c;
		_tmp4_ = g_unichar_toupper (_tmp3_);
		c = _tmp4_;
	}
	_tmp5_ = c;
	result = _tmp5_;
	return result;
}


static void chess_piece_class_init (ChessPieceClass * klass) {
	chess_piece_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_piece_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_piece_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PIECE_COLOR, g_param_spec_enum ("color", "color", "color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PIECE_SYMBOL, g_param_spec_uint ("symbol", "symbol", "symbol", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("moved", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("promoted", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("died", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_piece_instance_init (ChessPiece * self) {
}


static void chess_piece_finalize (GObject* obj) {
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PIECE, ChessPiece);
	_g_object_unref0 (self->player);
	G_OBJECT_CLASS (chess_piece_parent_class)->finalize (obj);
}


GType chess_piece_get_type (void) {
	static volatile gsize chess_piece_type_id__volatile = 0;
	if (g_once_init_enter (&chess_piece_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessPieceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_piece_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPiece), 0, (GInstanceInitFunc) chess_piece_instance_init, NULL };
		GType chess_piece_type_id;
		chess_piece_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPiece", &g_define_type_info, 0);
		g_once_init_leave (&chess_piece_type_id__volatile, chess_piece_type_id);
	}
	return chess_piece_type_id__volatile;
}


static void _vala_chess_piece_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PIECE, ChessPiece);
	switch (property_id) {
		case CHESS_PIECE_COLOR:
		g_value_set_enum (value, chess_piece_get_color (self));
		break;
		case CHESS_PIECE_SYMBOL:
		g_value_set_uint (value, chess_piece_get_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



