/* sudoku-board.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gdouble difficulty_rating;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gdouble _previous_played_time;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
enum  {
	SUDOKU_BOARD_DUMMY_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME,
	SUDOKU_BOARD_BLOCK_ROWS,
	SUDOKU_BOARD_BLOCK_COLS,
	SUDOKU_BOARD_ROWS,
	SUDOKU_BOARD_COLS,
	SUDOKU_BOARD_MAX_VAL,
	SUDOKU_BOARD_BROKEN,
	SUDOKU_BOARD_FILLED,
	SUDOKU_BOARD_COMPLETE
};
static gboolean sudoku_board_in_range (SudokuBoard* self, gfloat* range, int range_length1);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
void coord_init (Coord *self, gint row, gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gboolean* _vala_array_dup2 (gboolean* self, int length);
static gboolean* _vala_array_dup3 (gboolean* self, int length);
static gboolean* _vala_array_dup4 (gboolean* self, int length);
static gboolean* _vala_array_dup5 (gboolean* self, int length);
static gboolean* _vala_array_dup6 (gboolean* self, int length);
void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gint* _vala_array_dup7 (gint* self, int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
static gint* _vala_array_dup8 (gint* self, int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
static void sudoku_board_finalize (GObject* obj);
static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gfloat DIFFICULTY_RATING_EASY_RANGE[2];
extern const gfloat DIFFICULTY_RATING_MEDIUM_RANGE[2];
extern const gfloat DIFFICULTY_RATING_HARD_RANGE[2];
extern const gfloat DIFFICULTY_RATING_VERY_HARD_RANGE[2];

static gboolean sudoku_board_in_range (SudokuBoard* self, gfloat* range, int range_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gfloat _tmp3_ = 0.0F;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->difficulty_rating;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = range;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length1 = range_length1;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_[0];
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ >= ((gdouble) _tmp3_)) {
#line 219 "sudoku-board.c"
		gdouble _tmp4_ = 0.0;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = self->difficulty_rating;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = range;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = range_length1;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = _tmp5_[1];
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp4_ < ((gdouble) _tmp6_);
#line 234 "sudoku-board.c"
	} else {
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 238 "sudoku-board.c"
	}
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 244 "sudoku-board.c"
}


DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self) {
	DifficultyCategory result = 0;
	gboolean _tmp0_ = FALSE;
#line 77 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_in_range (self, DIFFICULTY_RATING_EASY_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_EASY_RANGE));
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp0_) {
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		result = DIFFICULTY_CATEGORY_EASY;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		return result;
#line 261 "sudoku-board.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = sudoku_board_in_range (self, DIFFICULTY_RATING_MEDIUM_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_MEDIUM_RANGE));
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp1_) {
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			result = DIFFICULTY_CATEGORY_MEDIUM;
#line 82 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 272 "sudoku-board.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp2_ = sudoku_board_in_range (self, DIFFICULTY_RATING_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_HARD_RANGE));
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp2_) {
#line 84 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_HARD;
#line 84 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 283 "sudoku-board.c"
			} else {
				gboolean _tmp3_ = FALSE;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = sudoku_board_in_range (self, DIFFICULTY_RATING_VERY_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_VERY_HARD_RANGE));
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp3_) {
#line 86 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					result = DIFFICULTY_CATEGORY_VERY_HARD;
#line 86 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					return result;
#line 294 "sudoku-board.c"
				} else {
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					result = DIFFICULTY_CATEGORY_EASY;
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					return result;
#line 300 "sudoku-board.c"
				}
			}
		}
	}
}


SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols) {
	SudokuBoard * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gboolean* _tmp26_ = NULL;
	GeeHashSet* _tmp69_ = NULL;
	GeeArrayList* _tmp70_ = NULL;
	GeeList* _tmp98_ = NULL;
	GeeList* _tmp99_ = NULL;
	GeeList* _tmp100_ = NULL;
	GeeArrayList* _tmp101_ = NULL;
	GeeList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	GeeList* _tmp131_ = NULL;
	GeeHashMap* _tmp132_ = NULL;
	GeeMap* _tmp187_ = NULL;
	GeeMap* _tmp188_ = NULL;
	GeeMap* _tmp189_ = NULL;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self = (SudokuBoard*) g_object_new (object_type, NULL);
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = block_rows;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = block_cols;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_cols = _tmp0_ * _tmp1_;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_cols;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_rows = _tmp2_;
#line 108 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = block_rows;
#line 108 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_rows = _tmp3_;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = block_cols;
#line 109 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_cols = _tmp4_;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->priv->_rows;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = self->priv->_cols;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = g_new0 (gint, _tmp5_ * _tmp6_);
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = _tmp7_;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length1 = _tmp5_;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length2 = _tmp6_;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = self->priv->_rows;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->priv->_cols;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = g_new0 (gboolean, _tmp8_ * _tmp9_);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = _tmp10_;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length1 = _tmp8_;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length2 = _tmp9_;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->_rows;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = self->priv->_cols;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = g_new0 (gboolean, _tmp11_ * _tmp12_);
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = _tmp13_;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length1 = _tmp11_;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length2 = _tmp12_;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = self->priv->_cols;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = self->priv->_rows;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = g_new0 (gboolean, _tmp14_ * _tmp15_);
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = _tmp16_;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length1 = _tmp14_;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length2 = _tmp15_;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->priv->_block_rows;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = self->priv->_block_cols;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = self->priv->_block_rows;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = self->priv->_block_cols;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = g_new0 (gboolean, (_tmp17_ * _tmp18_) * (_tmp19_ * _tmp20_));
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = _tmp21_;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length1 = _tmp17_;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length2 = _tmp18_;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length3 = _tmp19_ * _tmp20_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = self->priv->_rows;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = self->priv->_cols;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = sudoku_board_get_max_val (self);
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = _tmp24_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp26_ = g_new0 (gboolean, (_tmp22_ * _tmp23_) * _tmp25_);
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks = (g_free (self->earmarks), NULL);
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks = _tmp26_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks_length1 = _tmp22_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks_length2 = _tmp23_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks_length3 = _tmp25_;
#line 466 "sudoku-board.c"
	{
		gint l1 = 0;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 471 "sudoku-board.c"
		{
			gboolean _tmp27_ = FALSE;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp27_ = TRUE;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 478 "sudoku-board.c"
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp27_) {
#line 483 "sudoku-board.c"
					gint _tmp28_ = 0;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp28_ = l1;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp28_ + 1;
#line 489 "sudoku-board.c"
				}
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp27_ = FALSE;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp29_ = l1;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp30_ = self->priv->_rows;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp29_ < _tmp30_)) {
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 501 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 507 "sudoku-board.c"
					{
						gboolean _tmp31_ = FALSE;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp31_ = TRUE;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 514 "sudoku-board.c"
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint* _tmp35_ = NULL;
							gint _tmp35__length1 = 0;
							gint _tmp35__length2 = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							gboolean* _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							gint _tmp39__length2 = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gboolean _tmp42_ = FALSE;
							gboolean* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							gint _tmp43__length2 = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gboolean _tmp46_ = FALSE;
							gboolean* _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							gint _tmp47__length2 = 0;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gboolean _tmp50_ = FALSE;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp31_) {
#line 543 "sudoku-board.c"
								gint _tmp32_ = 0;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp32_ = l2;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp32_ + 1;
#line 549 "sudoku-board.c"
							}
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp31_ = FALSE;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp33_ = l2;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34_ = self->priv->_cols;
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp33_ < _tmp34_)) {
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 561 "sudoku-board.c"
							}
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35_ = self->cells;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35__length1 = self->cells_length1;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35__length2 = self->cells_length2;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp36_ = l1;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp37_ = l2;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_] = 0;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39_ = self->is_fixed;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39__length1 = self->is_fixed_length1;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39__length2 = self->is_fixed_length2;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp40_ = l1;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp41_ = l2;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = FALSE;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43_ = self->priv->possible_in_row;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43__length1 = self->priv->possible_in_row_length1;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43__length2 = self->priv->possible_in_row_length2;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp44_ = l1;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp45_ = l2;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_] = TRUE;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47_ = self->priv->possible_in_col;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47__length1 = self->priv->possible_in_col_length1;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47__length2 = self->priv->possible_in_col_length2;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp48_ = l2;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp49_ = l1;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_] = TRUE;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp50_ = _tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_];
#line 619 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 630 "sudoku-board.c"
		{
			gboolean _tmp51_ = FALSE;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp51_ = TRUE;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 637 "sudoku-board.c"
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp51_) {
#line 642 "sudoku-board.c"
					gint _tmp52_ = 0;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp52_ = l1;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp52_ + 1;
#line 648 "sudoku-board.c"
				}
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp51_ = FALSE;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp53_ = l1;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp54_ = self->priv->_block_rows;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp53_ < _tmp54_)) {
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 660 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 666 "sudoku-board.c"
					{
						gboolean _tmp55_ = FALSE;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp55_ = TRUE;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 673 "sudoku-board.c"
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp55_) {
#line 678 "sudoku-board.c"
								gint _tmp56_ = 0;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp56_ = l2;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp56_ + 1;
#line 684 "sudoku-board.c"
							}
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp55_ = FALSE;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp57_ = l2;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp58_ = self->priv->_block_cols;
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp57_ < _tmp58_)) {
#line 129 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 696 "sudoku-board.c"
							}
							{
								gint l3 = 0;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l3 = 0;
#line 702 "sudoku-board.c"
								{
									gboolean _tmp59_ = FALSE;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp59_ = TRUE;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									while (TRUE) {
#line 709 "sudoku-board.c"
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										gint _tmp63_ = 0;
										gboolean* _tmp64_ = NULL;
										gint _tmp64__length1 = 0;
										gint _tmp64__length2 = 0;
										gint _tmp64__length3 = 0;
										gint _tmp65_ = 0;
										gint _tmp66_ = 0;
										gint _tmp67_ = 0;
										gboolean _tmp68_ = FALSE;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										if (!_tmp59_) {
#line 723 "sudoku-board.c"
											gint _tmp60_ = 0;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											_tmp60_ = l3;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											l3 = _tmp60_ + 1;
#line 729 "sudoku-board.c"
										}
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp59_ = FALSE;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp61_ = l3;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp62_ = sudoku_board_get_max_val (self);
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63_ = _tmp62_;
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										if (!(_tmp61_ < _tmp63_)) {
#line 131 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											break;
#line 743 "sudoku-board.c"
										}
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64_ = self->priv->possible_in_block;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64__length1 = self->priv->possible_in_block_length1;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64__length2 = self->priv->possible_in_block_length2;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64__length3 = self->priv->possible_in_block_length3;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp65_ = l1;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp66_ = l2;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp67_ = l3;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64_[(((_tmp65_ * _tmp64__length2) + _tmp66_) * _tmp64__length3) + _tmp67_] = TRUE;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										_tmp68_ = _tmp64_[(((_tmp65_ * _tmp64__length2) + _tmp66_) * _tmp64__length3) + _tmp67_];
#line 763 "sudoku-board.c"
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->broken_coords = (GeeSet*) _tmp69_;
#line 138 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 138 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 138 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = (GeeList*) _tmp70_;
#line 785 "sudoku-board.c"
	{
		gint col = 0;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 790 "sudoku-board.c"
		{
			gboolean _tmp71_ = FALSE;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp71_ = TRUE;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 797 "sudoku-board.c"
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				GeeList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				GeeArrayList* _tmp77_ = NULL;
				GeeList* _tmp89_ = NULL;
				gint _tmp90_ = 0;
				GeeList* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gpointer _tmp93_ = NULL;
				GeeList* _tmp94_ = NULL;
				GeeList* _tmp95_ = NULL;
				GeeList* _tmp96_ = NULL;
				GeeList* _tmp97_ = NULL;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp71_) {
#line 814 "sudoku-board.c"
					gint _tmp72_ = 0;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp72_ = col;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp72_ + 1;
#line 820 "sudoku-board.c"
				}
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp71_ = FALSE;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp73_ = col;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp74_ = self->priv->_cols;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp73_ < _tmp74_)) {
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 832 "sudoku-board.c"
				}
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp75_ = self->coords_for_col;
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp76_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp77_ = _tmp76_;
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp75_, (GeeList*) _tmp77_);
#line 141 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp77_);
#line 844 "sudoku-board.c"
				{
					gint row = 0;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 849 "sudoku-board.c"
					{
						gboolean _tmp78_ = FALSE;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp78_ = TRUE;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 856 "sudoku-board.c"
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
							GeeList* _tmp82_ = NULL;
							gint _tmp83_ = 0;
							gpointer _tmp84_ = NULL;
							GeeList* _tmp85_ = NULL;
							gint _tmp86_ = 0;
							gint _tmp87_ = 0;
							Coord _tmp88_ = {0};
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp78_) {
#line 868 "sudoku-board.c"
								gint _tmp79_ = 0;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp79_ = row;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp79_ + 1;
#line 874 "sudoku-board.c"
							}
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp78_ = FALSE;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp80_ = row;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp81_ = self->priv->_rows;
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp80_ < _tmp81_)) {
#line 142 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 886 "sudoku-board.c"
							}
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp82_ = self->coords_for_col;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp83_ = col;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp84_ = gee_list_get (_tmp82_, _tmp83_);
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp85_ = (GeeList*) _tmp84_;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp86_ = row;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp87_ = col;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp88_, _tmp86_, _tmp87_);
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp85_, &_tmp88_);
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp85_);
#line 906 "sudoku-board.c"
						}
					}
				}
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp89_ = self->coords_for_col;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp90_ = col;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp91_ = self->coords_for_col;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp92_ = col;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp93_ = gee_list_get (_tmp91_, _tmp92_);
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp94_ = (GeeList*) _tmp93_;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp95_ = gee_list_get_read_only_view (_tmp94_);
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp96_ = _tmp95_;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp97_ = _tmp96_;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp89_, _tmp90_, _tmp97_);
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp97_);
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp94_);
#line 934 "sudoku-board.c"
			}
		}
	}
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp98_ = self->coords_for_col;
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp99_ = gee_list_get_read_only_view (_tmp98_);
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp100_ = _tmp99_;
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 148 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = _tmp100_;
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp101_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = (GeeList*) _tmp101_;
#line 954 "sudoku-board.c"
	{
		gint row = 0;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		row = 0;
#line 959 "sudoku-board.c"
		{
			gboolean _tmp102_ = FALSE;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp102_ = TRUE;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 966 "sudoku-board.c"
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
				GeeList* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GeeArrayList* _tmp108_ = NULL;
				GeeList* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				GeeList* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gpointer _tmp124_ = NULL;
				GeeList* _tmp125_ = NULL;
				GeeList* _tmp126_ = NULL;
				GeeList* _tmp127_ = NULL;
				GeeList* _tmp128_ = NULL;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp102_) {
#line 983 "sudoku-board.c"
					gint _tmp103_ = 0;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp103_ = row;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					row = _tmp103_ + 1;
#line 989 "sudoku-board.c"
				}
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp102_ = FALSE;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp104_ = row;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp105_ = self->priv->_rows;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp104_ < _tmp105_)) {
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1001 "sudoku-board.c"
				}
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp106_ = self->coords_for_row;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp107_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp108_ = _tmp107_;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp106_, (GeeList*) _tmp108_);
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp108_);
#line 1013 "sudoku-board.c"
				{
					gint col = 0;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					col = 0;
#line 1018 "sudoku-board.c"
					{
						gboolean _tmp109_ = FALSE;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp109_ = TRUE;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1025 "sudoku-board.c"
							gint _tmp111_ = 0;
							gint _tmp112_ = 0;
							GeeList* _tmp113_ = NULL;
							gint _tmp114_ = 0;
							gpointer _tmp115_ = NULL;
							GeeList* _tmp116_ = NULL;
							gint _tmp117_ = 0;
							gint _tmp118_ = 0;
							Coord _tmp119_ = {0};
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp109_) {
#line 1037 "sudoku-board.c"
								gint _tmp110_ = 0;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp110_ = col;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								col = _tmp110_ + 1;
#line 1043 "sudoku-board.c"
							}
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp109_ = FALSE;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp111_ = col;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp112_ = self->priv->_cols;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp111_ < _tmp112_)) {
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1055 "sudoku-board.c"
							}
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp113_ = self->coords_for_row;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp114_ = row;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp115_ = gee_list_get (_tmp113_, _tmp114_);
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp116_ = (GeeList*) _tmp115_;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp117_ = row;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp118_ = col;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp119_, _tmp117_, _tmp118_);
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp116_, &_tmp119_);
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp116_);
#line 1075 "sudoku-board.c"
						}
					}
				}
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp120_ = self->coords_for_row;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp121_ = row;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp122_ = self->coords_for_row;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp123_ = row;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp124_ = gee_list_get (_tmp122_, _tmp123_);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp125_ = (GeeList*) _tmp124_;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp126_ = gee_list_get_read_only_view (_tmp125_);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp127_ = _tmp126_;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp128_ = _tmp127_;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp120_, _tmp121_, _tmp128_);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp128_);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp125_);
#line 1103 "sudoku-board.c"
			}
		}
	}
#line 160 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp129_ = self->coords_for_row;
#line 160 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp130_ = gee_list_get_read_only_view (_tmp129_);
#line 160 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp131_ = _tmp130_;
#line 160 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 160 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = _tmp131_;
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp132_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = (GeeMap*) _tmp132_;
#line 1123 "sudoku-board.c"
	{
		gint col = 0;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1128 "sudoku-board.c"
		{
			gboolean _tmp133_ = FALSE;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp133_ = TRUE;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1135 "sudoku-board.c"
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp133_) {
#line 1140 "sudoku-board.c"
					gint _tmp134_ = 0;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp134_ = col;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp134_ + 1;
#line 1146 "sudoku-board.c"
				}
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp133_ = FALSE;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp135_ = col;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp136_ = self->priv->_block_cols;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp135_ < _tmp136_)) {
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1158 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1164 "sudoku-board.c"
					{
						gboolean _tmp137_ = FALSE;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp137_ = TRUE;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1171 "sudoku-board.c"
							gint _tmp139_ = 0;
							gint _tmp140_ = 0;
							GeeMap* _tmp141_ = NULL;
							gint _tmp142_ = 0;
							gint _tmp143_ = 0;
							Coord _tmp144_ = {0};
							GeeArrayList* _tmp145_ = NULL;
							GeeArrayList* _tmp146_ = NULL;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp137_) {
#line 1182 "sudoku-board.c"
								gint _tmp138_ = 0;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp138_ = row;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp138_ + 1;
#line 1188 "sudoku-board.c"
							}
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp137_ = FALSE;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp139_ = row;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp140_ = self->priv->_block_rows;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp139_ < _tmp140_)) {
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1200 "sudoku-board.c"
							}
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp141_ = self->coords_for_block;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp142_ = row;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp143_ = col;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp144_, _tmp142_, _tmp143_);
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp145_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp146_ = _tmp145_;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp141_, &_tmp144_, (GeeList*) _tmp146_);
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp146_);
#line 1218 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1229 "sudoku-board.c"
		{
			gboolean _tmp147_ = FALSE;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp147_ = TRUE;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1236 "sudoku-board.c"
				gint _tmp149_ = 0;
				gint _tmp150_ = 0;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp147_) {
#line 1241 "sudoku-board.c"
					gint _tmp148_ = 0;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp148_ = col;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp148_ + 1;
#line 1247 "sudoku-board.c"
				}
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp147_ = FALSE;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp149_ = col;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp150_ = self->priv->_cols;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp149_ < _tmp150_)) {
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1259 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1265 "sudoku-board.c"
					{
						gboolean _tmp151_ = FALSE;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp151_ = TRUE;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1272 "sudoku-board.c"
							gint _tmp153_ = 0;
							gint _tmp154_ = 0;
							GeeMap* _tmp155_ = NULL;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
							gint _tmp158_ = 0;
							gint _tmp159_ = 0;
							Coord _tmp160_ = {0};
							gpointer _tmp161_ = NULL;
							GeeList* _tmp162_ = NULL;
							gint _tmp163_ = 0;
							gint _tmp164_ = 0;
							Coord _tmp165_ = {0};
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp151_) {
#line 1288 "sudoku-board.c"
								gint _tmp152_ = 0;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp152_ = row;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp152_ + 1;
#line 1294 "sudoku-board.c"
							}
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp151_ = FALSE;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp153_ = row;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp154_ = self->priv->_rows;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp153_ < _tmp154_)) {
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1306 "sudoku-board.c"
							}
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp155_ = self->coords_for_block;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp156_ = row;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp157_ = self->priv->_block_rows;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp158_ = col;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp159_ = self->priv->_block_cols;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp160_, _tmp156_ / _tmp157_, _tmp158_ / _tmp159_);
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp161_ = gee_map_get (_tmp155_, &_tmp160_);
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp162_ = (GeeList*) _tmp161_;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp163_ = row;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp164_ = col;
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp165_, _tmp163_, _tmp164_);
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp162_, &_tmp165_);
#line 174 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp162_);
#line 1334 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1345 "sudoku-board.c"
		{
			gboolean _tmp166_ = FALSE;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp166_ = TRUE;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1352 "sudoku-board.c"
				gint _tmp168_ = 0;
				gint _tmp169_ = 0;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp166_) {
#line 1357 "sudoku-board.c"
					gint _tmp167_ = 0;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp167_ = col;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp167_ + 1;
#line 1363 "sudoku-board.c"
				}
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp166_ = FALSE;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp168_ = col;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp169_ = self->priv->_block_cols;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp168_ < _tmp169_)) {
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1375 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1381 "sudoku-board.c"
					{
						gboolean _tmp170_ = FALSE;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp170_ = TRUE;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1388 "sudoku-board.c"
							gint _tmp172_ = 0;
							gint _tmp173_ = 0;
							GeeMap* _tmp174_ = NULL;
							gint _tmp175_ = 0;
							gint _tmp176_ = 0;
							Coord _tmp177_ = {0};
							GeeMap* _tmp178_ = NULL;
							gint _tmp179_ = 0;
							gint _tmp180_ = 0;
							Coord _tmp181_ = {0};
							gpointer _tmp182_ = NULL;
							GeeList* _tmp183_ = NULL;
							GeeList* _tmp184_ = NULL;
							GeeList* _tmp185_ = NULL;
							GeeList* _tmp186_ = NULL;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp170_) {
#line 1406 "sudoku-board.c"
								gint _tmp171_ = 0;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp171_ = row;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp171_ + 1;
#line 1412 "sudoku-board.c"
							}
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp170_ = FALSE;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp172_ = row;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp173_ = self->priv->_block_rows;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp172_ < _tmp173_)) {
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1424 "sudoku-board.c"
							}
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp174_ = self->coords_for_block;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp175_ = row;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp176_ = col;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp177_, _tmp175_, _tmp176_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp178_ = self->coords_for_block;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp179_ = row;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp180_ = col;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp181_, _tmp179_, _tmp180_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp182_ = gee_map_get (_tmp178_, &_tmp181_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp183_ = (GeeList*) _tmp182_;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp184_ = gee_list_get_read_only_view (_tmp183_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp185_ = _tmp184_;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp186_ = _tmp185_;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp174_, &_tmp177_, _tmp186_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp186_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp183_);
#line 1458 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp187_ = self->coords_for_block;
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp188_ = gee_map_get_read_only_view (_tmp187_);
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp189_ = _tmp188_;
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = _tmp189_;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return self;
#line 1477 "sudoku-board.c"
}


SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols) {
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
#line 1484 "sudoku-board.c"
}


static gint* _vala_array_dup1 (gint* self, int length) {
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 1491 "sudoku-board.c"
}


static gboolean* _vala_array_dup2 (gboolean* self, int length) {
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1498 "sudoku-board.c"
}


static gboolean* _vala_array_dup3 (gboolean* self, int length) {
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1505 "sudoku-board.c"
}


static gboolean* _vala_array_dup4 (gboolean* self, int length) {
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1512 "sudoku-board.c"
}


static gboolean* _vala_array_dup5 (gboolean* self, int length) {
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1519 "sudoku-board.c"
}


static gboolean* _vala_array_dup6 (gboolean* self, int length) {
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1526 "sudoku-board.c"
}


SudokuBoard* sudoku_board_clone (SudokuBoard* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuBoard* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gboolean* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gboolean* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp11__length3 = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	gint _tmp12__length3 = 0;
	gint _tmp13_ = 0;
	GeeSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	gboolean* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp16__length3 = 0;
	gboolean* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp17__length2 = 0;
	gint _tmp17__length3 = 0;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_cols;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board = _tmp2_;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->cells;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->cells_length1;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->cells_length2;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp3__length1;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length2 = _tmp3__length2;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = (g_free (board->cells), NULL);
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = _tmp4_;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length1 = _tmp4__length1;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length2 = _tmp4__length2;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->is_fixed;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length1 = self->is_fixed_length1;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length2 = self->is_fixed_length2;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length1 = _tmp5__length1;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length2 = _tmp5__length2;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = (g_free (board->is_fixed), NULL);
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = _tmp6_;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length1 = _tmp6__length1;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length2 = _tmp6__length2;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = self->priv->possible_in_row;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length1 = self->priv->possible_in_row_length1;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length2 = self->priv->possible_in_row_length2;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length1 = _tmp7__length1;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length2 = _tmp7__length2;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = _tmp8_;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length1 = _tmp8__length1;
#line 192 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length2 = _tmp8__length2;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->priv->possible_in_col;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->priv->possible_in_col_length1;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->priv->possible_in_col_length2;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length1 = _tmp9__length1;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length2 = _tmp9__length2;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = _tmp10_;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length1 = _tmp10__length1;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length2 = _tmp10__length2;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->possible_in_block;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length1 = self->priv->possible_in_block_length1;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length2 = self->priv->possible_in_block_length2;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length3 = self->priv->possible_in_block_length3;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length1 = _tmp11__length1;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length2 = _tmp11__length2;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length3 = _tmp11__length3;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = _tmp12_;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length1 = _tmp12__length1;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length2 = _tmp12__length2;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length3 = _tmp12__length3;
#line 195 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->_filled;
#line 195 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->_filled = _tmp13_;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = board->broken_coords;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = self->broken_coords;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	gee_collection_add_all ((GeeCollection*) _tmp14_, (GeeCollection*) _tmp15_);
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = self->earmarks;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length1 = self->earmarks_length1;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length2 = self->earmarks_length2;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length3 = self->earmarks_length3;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup6 (_tmp16_, (_tmp16__length1 * _tmp16__length2) * _tmp16__length3) : ((gpointer) _tmp16_);
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17__length1 = _tmp16__length1;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17__length2 = _tmp16__length2;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17__length3 = _tmp16__length3;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->earmarks = (g_free (board->earmarks), NULL);
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->earmarks = _tmp17_;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->earmarks_length1 = _tmp17__length1;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->earmarks_length2 = _tmp17__length2;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board->earmarks_length3 = _tmp17__length3;
#line 199 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = board;
#line 199 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 1735 "sudoku-board.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 789 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 790 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 790 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 790 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 790 "/opt/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1753 "sudoku-board.c"
}


void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter) {
	gint number_of_cells = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar** cells = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint cells_length1 = 0;
	gint _cells_size_ = 0;
	gchar** rating = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint rating_length1 = 0;
	gint _rating_size_ = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	const gchar* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (s != NULL);
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (delimiter != NULL);
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (empty_value != NULL);
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (rating_delimiter != NULL);
#line 206 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_cols;
#line 206 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_rows;
#line 206 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	number_of_cells = _tmp0_ * _tmp1_;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = s;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = delimiter;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = number_of_cells;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_ = g_strsplit (_tmp2_, _tmp3_, _tmp4_);
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	cells = _tmp6_;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	cells_length1 = _vala_array_length (_tmp5_);
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_cells_size_ = cells_length1;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = cells;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length1 = cells_length1;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = cells;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length1 = cells_length1;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp7_[_tmp8__length1 - 1];
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = rating_delimiter;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp11_ = g_strsplit (_tmp9_, _tmp10_, 2);
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	rating = _tmp12_;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	rating_length1 = _vala_array_length (_tmp11_);
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_rating_size_ = rating_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = cells;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length1 = cells_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = cells;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14__length1 = cells_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = rating;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15__length1 = rating_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = _tmp15_[0];
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (_tmp13_[_tmp14__length1 - 1]);
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_[_tmp14__length1 - 1] = _tmp17_;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = _tmp13_[_tmp14__length1 - 1];
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = rating;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length1 = rating_length1;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = _tmp19_[1];
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = double_parse (_tmp20_);
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->difficulty_rating = _tmp21_;
#line 1875 "sudoku-board.c"
	{
		gint i = 0;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		i = 0;
#line 1880 "sudoku-board.c"
		{
			gboolean _tmp22_ = FALSE;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp22_ = TRUE;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1887 "sudoku-board.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* cell = NULL;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp22_) {
#line 1900 "sudoku-board.c"
					gint _tmp23_ = 0;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp23_ = i;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp23_ + 1;
#line 1906 "sudoku-board.c"
				}
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = FALSE;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp24_ = i;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp25_ = number_of_cells;
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1918 "sudoku-board.c"
				}
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp26_ = cells;
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp26__length1 = cells_length1;
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp27_ = i;
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp28_ = _tmp26_[_tmp27_];
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp29_ = g_strdup (_tmp28_);
#line 216 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				cell = _tmp29_;
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp30_ = cell;
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp31_ = empty_value;
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (g_strcmp0 (_tmp30_, _tmp31_) != 0) {
#line 1938 "sudoku-board.c"
					gint val = 0;
					const gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gboolean _tmp34_ = FALSE;
					gint _tmp35_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
#line 221 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp32_ = cell;
#line 221 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp33_ = atoi (_tmp32_);
#line 221 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					val = _tmp33_;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp35_ = val;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					if (_tmp35_ >= 1) {
#line 1959 "sudoku-board.c"
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp36_ = val;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp37_ = sudoku_board_get_max_val (self);
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp38_ = _tmp37_;
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp34_ = _tmp36_ <= _tmp38_;
#line 1971 "sudoku-board.c"
					} else {
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp34_ = FALSE;
#line 1975 "sudoku-board.c"
					}
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_vala_assert (_tmp34_, "val >= 1 && val <= max_val");
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp39_ = i;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp40_ = self->priv->_cols;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp41_ = i;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp42_ = self->priv->_cols;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp43_ = val;
#line 226 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					sudoku_board_insert (self, _tmp39_ / _tmp40_, _tmp41_ % _tmp42_, _tmp43_, TRUE);
#line 1991 "sudoku-board.c"
				}
#line 214 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_g_free0 (cell);
#line 1995 "sudoku-board.c"
			}
		}
	}
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	rating = (_vala_array_free (rating, rating_length1, (GDestroyNotify) g_free), NULL);
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	cells = (_vala_array_free (cells, cells_length1, (GDestroyNotify) g_free), NULL);
#line 2003 "sudoku-board.c"
}


gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 231 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 233 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 233 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp0_ - 1;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->possible_in_row;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->priv->possible_in_row_length1;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->priv->possible_in_row_length2;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = row;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = val;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp6_) {
#line 2038 "sudoku-board.c"
		gboolean* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = self->priv->possible_in_col;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length1 = self->priv->possible_in_col_length1;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length2 = self->priv->possible_in_col_length2;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = col;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = val;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _tmp10_;
#line 2059 "sudoku-board.c"
	} else {
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = FALSE;
#line 2063 "sudoku-board.c"
	}
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_) {
#line 2067 "sudoku-board.c"
		gboolean* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp11__length3 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11_ = self->priv->possible_in_block;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length1 = self->priv->possible_in_block_length1;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length2 = self->priv->possible_in_block_length2;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length3 = self->priv->possible_in_block_length3;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp12_ = row;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = self->priv->_block_cols;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = self->priv->_block_rows;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp16_ = val;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp17_ = _tmp11_[((((_tmp12_ / _tmp13_) * _tmp11__length2) + (_tmp14_ / _tmp15_)) * _tmp11__length3) + _tmp16_];
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _tmp17_;
#line 2100 "sudoku-board.c"
	} else {
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = FALSE;
#line 2104 "sudoku-board.c"
	}
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp1_;
#line 234 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2110 "sudoku-board.c"
}


gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
#line 237 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = sudoku_board_get_possibilities (self, _tmp0_, _tmp1_, &_tmp2_);
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp2_;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp2_;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp5_;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2143 "sudoku-board.c"
}


static gint* _vala_array_dup7 (gint* self, int length) {
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 2150 "sudoku-board.c"
}


gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint* possibilities = NULL;
	gint* _tmp6_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gint count = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 242 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 244 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ != 0) {
#line 2190 "sudoku-board.c"
		gint* _tmp4_ = NULL;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = g_new0 (gint, 0);
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = 0;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		if (result_length1) {
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			*result_length1 = _tmp5__length1;
#line 2204 "sudoku-board.c"
		}
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		result = _tmp5_;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		return result;
#line 2210 "sudoku-board.c"
	}
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_new0 (gint, 9);
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp6_;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = 9;
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 248 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	count = 0;
#line 2222 "sudoku-board.c"
	{
		gint l = 0;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2227 "sudoku-board.c"
		{
			gboolean _tmp7_ = FALSE;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = TRUE;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2234 "sudoku-board.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp7_) {
#line 2244 "sudoku-board.c"
					gint _tmp8_ = 0;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp8_ = l;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp8_ + 1;
#line 2250 "sudoku-board.c"
				}
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = FALSE;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = sudoku_board_get_max_val (self);
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = _tmp10_;
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp9_ <= _tmp11_)) {
#line 250 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2264 "sudoku-board.c"
				}
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = row;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = col;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = l;
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = sudoku_board_is_possible (self, _tmp12_, _tmp13_, _tmp14_);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp15_) {
#line 2276 "sudoku-board.c"
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_ = possibilities;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16__length1 = possibilities_length1;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = count;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp18_ = l;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_[_tmp17_] = _tmp18_;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp19_ = _tmp16_[_tmp17_];
#line 254 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp20_ = count;
#line 254 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					count = _tmp20_ + 1;
#line 2299 "sudoku-board.c"
				}
			}
		}
	}
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = possibilities;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = possibilities_length1;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = count;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = ((_tmp21_ + 0) != NULL) ? _vala_array_dup7 (_tmp21_ + 0, _tmp22_ - 0) : ((gpointer) (_tmp21_ + 0));
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23__length1 = _tmp22_ - 0;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = _tmp23_;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24__length1 = _tmp23__length1;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp24__length1;
#line 2322 "sudoku-board.c"
	}
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp24_;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = (g_free (possibilities), NULL);
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2330 "sudoku-board.c"
}


gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_get_max_val (self);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_new0 (gboolean, _tmp1_);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp2_;
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = _tmp1_;
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 2358 "sudoku-board.c"
	{
		gint l = 0;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2363 "sudoku-board.c"
		{
			gboolean _tmp3_ = FALSE;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = TRUE;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2370 "sudoku-board.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp3_) {
#line 2384 "sudoku-board.c"
					gint _tmp4_ = 0;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp4_ = l;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp4_ + 1;
#line 2390 "sudoku-board.c"
				}
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = FALSE;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = l;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = sudoku_board_get_max_val (self);
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = _tmp6_;
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp5_ <= _tmp7_)) {
#line 264 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2404 "sudoku-board.c"
				}
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = possibilities;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8__length1 = possibilities_length1;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = row;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = col;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = l;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = sudoku_board_is_possible (self, _tmp10_, _tmp11_, _tmp12_);
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_[_tmp9_ - 1] = _tmp13_;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = _tmp8_[_tmp9_ - 1];
#line 2424 "sudoku-board.c"
			}
		}
	}
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = possibilities;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15__length1 = possibilities_length1;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp15__length1;
#line 2436 "sudoku-board.c"
	}
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp15_;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2442 "sudoku-board.c"
}


void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Coord _tmp4_ = {0};
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_rows;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_block_cols;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp4_, _tmp0_ / _tmp1_, _tmp2_ / _tmp3_);
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	*result = _tmp4_;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return;
#line 2468 "sudoku-board.c"
}


void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gint _tmp27__length2 = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint _tmp36__length2 = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean* _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp45__length2 = 0;
	gint _tmp45__length3 = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gboolean _tmp51_ = FALSE;
	gint _tmp61_ = 0;
	gboolean* _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	gint _tmp62__length2 = 0;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gboolean _tmp65_ = FALSE;
	gboolean* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gint _tmp66__length2 = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gboolean _tmp69_ = FALSE;
	gboolean* _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gint _tmp70__length2 = 0;
	gint _tmp70__length3 = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
#line 277 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 280 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 280 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp0_ > 0, "val > 0");
#line 281 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 281 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_max_val (self);
#line 281 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 281 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp1_ <= _tmp3_, "val <= max_val");
#line 284 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 284 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 2564 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 2585 "sudoku-board.c"
	}
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp12_ != 0) {
#line 2601 "sudoku-board.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = row;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = is_fixed;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp13_, _tmp14_, _tmp15_);
#line 2613 "sudoku-board.c"
	}
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = self->cells;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length1 = self->cells_length1;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length2 = self->cells_length2;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = row;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = col;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = val;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = _tmp19_;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = self->is_fixed;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = self->is_fixed_length1;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length2 = self->is_fixed_length2;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = row;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = col;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = is_fixed;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp26_ = self->priv->_filled;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_filled = _tmp26_ + 1;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp27_ = self->priv->possible_in_row;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp27__length1 = self->priv->possible_in_row_length1;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp27__length2 = self->priv->possible_in_row_length2;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp28_ = row;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29_ = val;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)];
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp30_) {
#line 2665 "sudoku-board.c"
		GeeList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gpointer _tmp33_ = NULL;
		GeeList* _tmp34_ = NULL;
		gint _tmp35_ = 0;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp31_ = self->coords_for_row;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp32_ = row;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = gee_list_get (_tmp31_, _tmp32_);
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = (GeeList*) _tmp33_;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = val;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp34_, _tmp35_);
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp34_);
#line 2685 "sudoku-board.c"
	}
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp36_ = self->priv->possible_in_col;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp36__length1 = self->priv->possible_in_col_length1;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp36__length2 = self->priv->possible_in_col_length2;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp37_ = col;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38_ = val;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp39_ = _tmp36_[(_tmp37_ * _tmp36__length2) + (_tmp38_ - 1)];
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp39_) {
#line 2701 "sudoku-board.c"
		GeeList* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gpointer _tmp42_ = NULL;
		GeeList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp40_ = self->coords_for_col;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp41_ = col;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = gee_list_get (_tmp40_, _tmp41_);
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = (GeeList*) _tmp42_;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp44_ = val;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp43_, _tmp44_);
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp43_);
#line 2721 "sudoku-board.c"
	}
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp45_ = self->priv->possible_in_block;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp45__length1 = self->priv->possible_in_block_length1;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp45__length2 = self->priv->possible_in_block_length2;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp45__length3 = self->priv->possible_in_block_length3;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp46_ = row;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47_ = self->priv->_block_cols;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp48_ = col;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp49_ = self->priv->_block_rows;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp50_ = val;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp51_ = _tmp45_[((((_tmp46_ / _tmp47_) * _tmp45__length2) + (_tmp48_ / _tmp49_)) * _tmp45__length3) + (_tmp50_ - 1)];
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp51_) {
#line 2745 "sudoku-board.c"
		GeeMap* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		Coord _tmp57_ = {0};
		gpointer _tmp58_ = NULL;
		GeeList* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp52_ = self->coords_for_block;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp53_ = row;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = self->priv->_block_cols;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = col;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = self->priv->_block_rows;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp57_, _tmp53_ / _tmp54_, _tmp55_ / _tmp56_);
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = gee_map_get (_tmp52_, &_tmp57_);
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp59_ = (GeeList*) _tmp58_;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp60_ = val;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp59_, _tmp60_);
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp59_);
#line 2777 "sudoku-board.c"
	}
#line 311 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp61_ = val;
#line 311 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp61_ - 1;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp62_ = self->priv->possible_in_row;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp62__length1 = self->priv->possible_in_row_length1;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp62__length2 = self->priv->possible_in_row_length2;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp63_ = row;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64_ = val;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_] = FALSE;
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66_ = self->priv->possible_in_col;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66__length1 = self->priv->possible_in_col_length1;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66__length2 = self->priv->possible_in_col_length2;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp67_ = col;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_ = val;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = FALSE;
#line 313 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70_ = self->priv->possible_in_block;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70__length1 = self->priv->possible_in_block_length1;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70__length2 = self->priv->possible_in_block_length2;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70__length3 = self->priv->possible_in_block_length3;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp71_ = row;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72_ = self->priv->_block_cols;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp73_ = col;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp74_ = self->priv->_block_rows;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp75_ = val;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70_[((((_tmp71_ / _tmp72_) * _tmp70__length2) + (_tmp73_ / _tmp74_)) * _tmp70__length3) + _tmp75_] = FALSE;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp76_ = _tmp70_[((((_tmp71_ / _tmp72_) * _tmp70__length2) + (_tmp73_ / _tmp74_)) * _tmp70__length3) + _tmp75_];
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp77_ = sudoku_board_get_complete (self);
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp78_ = _tmp77_;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp78_) {
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_signal_emit_by_name (self, "completed");
#line 2841 "sudoku-board.c"
	}
}


void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val) {
	gint _tmp0_ = 0;
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 322 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 322 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp0_ == 0) {
#line 2854 "sudoku-board.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = row;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = col;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp1_, _tmp2_, FALSE);
#line 2863 "sudoku-board.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = val;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp4_ > 0) {
#line 2871 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = val;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = sudoku_board_get_max_val (self);
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _tmp6_;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = _tmp5_ <= _tmp7_;
#line 2883 "sudoku-board.c"
		} else {
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = FALSE;
#line 2887 "sudoku-board.c"
		}
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp3_) {
#line 2891 "sudoku-board.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = row;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = col;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = val;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			sudoku_board_insert (self, _tmp8_, _tmp9_, _tmp10_, FALSE);
#line 2903 "sudoku-board.c"
		} else {
#line 332 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 2907 "sudoku-board.c"
		}
	}
}


gint sudoku_board_get (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 336 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp3_;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2939 "sudoku-board.c"
}


void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint previous_val = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Coord _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gint _tmp126_ = 0;
#line 341 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 344 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ == 0) {
#line 345 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		return;
#line 2988 "sudoku-board.c"
	}
#line 348 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 348 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 2994 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 349 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 3015 "sudoku-board.c"
	}
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 351 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	previous_val = _tmp12_;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->cells;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length1 = self->cells_length1;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length2 = self->cells_length2;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = row;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = col;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = 0;
#line 352 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->broken_coords;
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = row;
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = col;
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp20_, _tmp18_, _tmp19_);
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp20_);
#line 354 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp21_) {
#line 3057 "sudoku-board.c"
		GeeList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gpointer _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		GeeMap* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Coord _tmp37_ = {0};
		gpointer _tmp38_ = NULL;
		GeeList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GeeSet* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Coord _tmp44_ = {0};
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gpointer _tmp47_ = NULL;
		GeeList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GeeList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer _tmp52_ = NULL;
		GeeList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		GeeMap* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Coord _tmp60_ = {0};
		gpointer _tmp61_ = NULL;
		GeeList* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gboolean* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		gint _tmp64__length2 = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gpointer _tmp69_ = NULL;
		GeeList* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GeeSet* _tmp72_ = NULL;
		GeeSet* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gboolean _tmp76_ = FALSE;
		gboolean* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gint _tmp77__length2 = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		GeeList* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gpointer _tmp82_ = NULL;
		GeeList* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		GeeSet* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gboolean _tmp89_ = FALSE;
		gboolean* _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		gint _tmp90__length2 = 0;
		gint _tmp90__length3 = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		GeeMap* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		Coord _tmp101_ = {0};
		gpointer _tmp102_ = NULL;
		GeeList* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		GeeSet* _tmp105_ = NULL;
		GeeSet* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gboolean _tmp109_ = FALSE;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp22_ = self->coords_for_row;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp23_ = row;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp25_ = (GeeList*) _tmp24_;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp26_ = previous_val;
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp25_, _tmp26_);
#line 357 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp25_);
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp27_ = self->coords_for_col;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp28_ = col;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp30_ = (GeeList*) _tmp29_;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp31_ = previous_val;
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp30_, _tmp31_);
#line 358 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp30_);
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp32_ = self->coords_for_block;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = row;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = self->priv->_block_rows;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = col;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp36_ = self->priv->_block_cols;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp37_, _tmp33_ / _tmp34_, _tmp35_ / _tmp36_);
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp38_ = gee_map_get (_tmp32_, &_tmp37_);
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp39_ = (GeeList*) _tmp38_;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp40_ = previous_val;
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp39_, _tmp40_);
#line 359 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp39_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp41_ = self->broken_coords;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = row;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = col;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp44_, _tmp42_, _tmp43_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_remove ((GeeCollection*) _tmp41_, &_tmp44_);
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp45_ = self->coords_for_row;
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp46_ = row;
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp47_ = gee_list_get (_tmp45_, _tmp46_);
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp48_ = (GeeList*) _tmp47_;
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp49_ = previous_val;
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp48_, _tmp49_);
#line 363 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp48_);
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp50_ = self->coords_for_col;
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp51_ = col;
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp53_ = (GeeList*) _tmp52_;
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = previous_val;
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp53_, _tmp54_);
#line 364 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp53_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = self->coords_for_block;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = row;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp57_ = self->priv->_block_rows;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = col;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp59_ = self->priv->_block_cols;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp60_, _tmp56_ / _tmp57_, _tmp58_ / _tmp59_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp61_ = gee_map_get (_tmp55_, &_tmp60_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp62_ = (GeeList*) _tmp61_;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp63_ = previous_val;
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp62_, _tmp63_);
#line 365 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp62_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_ = self->priv->possible_in_row;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length1 = self->priv->possible_in_row_length1;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length2 = self->priv->possible_in_row_length2;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp65_ = row;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp66_ = previous_val;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp67_ = self->coords_for_row;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp68_ = row;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp70_ = (GeeList*) _tmp69_;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp71_ = previous_val;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp72_ = sudoku_board_get_occurances (self, _tmp70_, _tmp71_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp73_ = _tmp72_;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp75_ = _tmp74_;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)] = _tmp75_ == 0;
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp76_ = _tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)];
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp73_);
#line 368 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp70_);
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_ = self->priv->possible_in_col;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length1 = self->priv->possible_in_col_length1;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length2 = self->priv->possible_in_col_length2;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp78_ = col;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp79_ = previous_val;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp80_ = self->coords_for_col;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp81_ = col;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp83_ = (GeeList*) _tmp82_;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp84_ = previous_val;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp85_ = sudoku_board_get_occurances (self, _tmp83_, _tmp84_);
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp86_ = _tmp85_;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp87_ = gee_collection_get_size ((GeeCollection*) _tmp86_);
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp88_ = _tmp87_;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)] = _tmp88_ == 0;
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp89_ = _tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)];
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp86_);
#line 369 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp83_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_ = self->priv->possible_in_block;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length1 = self->priv->possible_in_block_length1;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length2 = self->priv->possible_in_block_length2;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length3 = self->priv->possible_in_block_length3;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp91_ = row;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp92_ = self->priv->_block_cols;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp93_ = col;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp94_ = self->priv->_block_rows;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp95_ = previous_val;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp96_ = self->coords_for_block;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp97_ = row;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp98_ = self->priv->_block_rows;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp99_ = col;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp100_ = self->priv->_block_cols;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp101_, _tmp97_ / _tmp98_, _tmp99_ / _tmp100_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp102_ = gee_map_get (_tmp96_, &_tmp101_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp103_ = (GeeList*) _tmp102_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp104_ = previous_val;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp105_ = sudoku_board_get_occurances (self, _tmp103_, _tmp104_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp106_ = _tmp105_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp108_ = _tmp107_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)] = _tmp108_ == 0;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp109_ = _tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)];
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp106_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp103_);
#line 3387 "sudoku-board.c"
	} else {
		gint _tmp110_ = 0;
		gboolean* _tmp111_ = NULL;
		gint _tmp111__length1 = 0;
		gint _tmp111__length2 = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		gint _tmp115__length2 = 0;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean* _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		gint _tmp119__length2 = 0;
		gint _tmp119__length3 = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gboolean _tmp125_ = FALSE;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp110_ = previous_val;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		previous_val = _tmp110_ - 1;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_ = self->priv->possible_in_row;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length1 = self->priv->possible_in_row_length1;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length2 = self->priv->possible_in_row_length2;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp112_ = row;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp113_ = previous_val;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_] = TRUE;
#line 376 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_ = self->priv->possible_in_col;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length1 = self->priv->possible_in_col_length1;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length2 = self->priv->possible_in_col_length2;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp116_ = col;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp117_ = previous_val;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = TRUE;
#line 377 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_ = self->priv->possible_in_block;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length1 = self->priv->possible_in_block_length1;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length2 = self->priv->possible_in_block_length2;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length3 = self->priv->possible_in_block_length3;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp120_ = row;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp121_ = self->priv->_block_cols;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp122_ = col;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp123_ = self->priv->_block_rows;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp124_ = previous_val;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_] = TRUE;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp125_ = _tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_];
#line 3466 "sudoku-board.c"
	}
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp126_ = self->priv->_filled;
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_filled = _tmp126_ - 1;
#line 3472 "sudoku-board.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return self ? g_object_ref (self) : NULL;
#line 3479 "sudoku-board.c"
}


GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_ = NULL;
#line 384 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 384 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coords != NULL, NULL);
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 386 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	occurances = (GeeSet*) _tmp0_;
#line 3495 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _coord_index = 0;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = coords;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp2_;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = _coord_list;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp5_;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3523 "sudoku-board.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Coord coord = {0};
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Coord* _tmp12_ = NULL;
			Coord _tmp13_ = {0};
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp6_ + 1;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_index;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_size;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3554 "sudoku-board.c"
			}
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_list;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = _coord_index;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = (Coord*) _tmp11_;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp13_ = *_tmp12_;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp12_);
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp13_;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 389 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3590 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
#line 390 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = occurances;
#line 390 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 390 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp21_, &_tmp22_);
#line 3599 "sudoku-board.c"
			}
		}
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3604 "sudoku-board.c"
	}
#line 393 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = occurances;
#line 393 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3610 "sudoku-board.c"
}


gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 396 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_row;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3656 "sudoku-board.c"
}


gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 401 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_col;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 403 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3702 "sudoku-board.c"
}


gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 406 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (block != NULL, FALSE);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_block;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *block;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 408 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3750 "sudoku-board.c"
}


static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
#line 411 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 411 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 3759 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = coords;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp1_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _coord_list;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = _tmp3_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp4_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3787 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			gboolean _tmp13_ = FALSE;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = _coord_index;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp5_ + 1;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_size;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3819 "sudoku-board.c"
			}
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_list;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_index;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = (Coord*) _tmp10_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = *_tmp11_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp11_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp12_;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3855 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = self->broken_coords;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = _tmp23_;
#line 3867 "sudoku-board.c"
			} else {
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = FALSE;
#line 3871 "sudoku-board.c"
			}
#line 415 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp13_) {
#line 3875 "sudoku-board.c"
				GeeSet* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
#line 416 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp24_ = self->broken_coords;
#line 416 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp25_ = coord;
#line 416 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_remove ((GeeCollection*) _tmp24_, &_tmp25_);
#line 3884 "sudoku-board.c"
			}
		}
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3889 "sudoku-board.c"
	}
}


static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* occurances = NULL;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 424 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = coords;
#line 424 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 424 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_occurances (self, _tmp0_, _tmp1_);
#line 424 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	occurances = _tmp2_;
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = occurances;
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 425 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_ != 1) {
#line 3922 "sudoku-board.c"
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = self->broken_coords;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = occurances;
#line 427 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp7_);
#line 3931 "sudoku-board.c"
	}
#line 422 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (occurances);
#line 3935 "sudoku-board.c"
}


void sudoku_board_to_initial_state (SudokuBoard* self) {
#line 431 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 3942 "sudoku-board.c"
	{
		gint l1 = 0;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 3947 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 3954 "sudoku-board.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 3959 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 3965 "sudoku-board.c"
				}
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = self->priv->_rows;
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 433 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 3977 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 3983 "sudoku-board.c"
					{
						gboolean _tmp4_ = FALSE;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp4_ = TRUE;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 3990 "sudoku-board.c"
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean _tmp11_ = FALSE;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp4_) {
#line 4001 "sudoku-board.c"
								gint _tmp5_ = 0;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp5_ = l2;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp5_ + 1;
#line 4007 "sudoku-board.c"
							}
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp4_ = FALSE;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = l2;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = self->priv->_cols;
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 435 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4019 "sudoku-board.c"
							}
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->is_fixed;
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length1 = self->is_fixed_length1;
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length2 = self->is_fixed_length2;
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = l1;
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 437 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp11_) {
#line 4035 "sudoku-board.c"
								gint _tmp12_ = 0;
								gint _tmp13_ = 0;
#line 438 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp12_ = l1;
#line 438 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = l2;
#line 438 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
#line 4044 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
}


void sudoku_board_print (SudokuBoard* self, gint indent) {
	FILE* _tmp22_ = NULL;
#line 443 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 4059 "sudoku-board.c"
	{
		gint l1 = 0;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4064 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4071 "sudoku-board.c"
				gint _tmp2_ = 0;
				FILE* _tmp21_ = NULL;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 4076 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 4082 "sudoku-board.c"
				}
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < 9)) {
#line 444 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4092 "sudoku-board.c"
				}
				{
					gint i = 0;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					i = 0;
#line 4098 "sudoku-board.c"
					{
						gboolean _tmp3_ = FALSE;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp3_ = TRUE;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4105 "sudoku-board.c"
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							FILE* _tmp7_ = NULL;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp3_) {
#line 4111 "sudoku-board.c"
								gint _tmp4_ = 0;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp4_ = i;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								i = _tmp4_ + 1;
#line 4117 "sudoku-board.c"
							}
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp3_ = FALSE;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = i;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = indent;
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp5_ < _tmp6_)) {
#line 446 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4129 "sudoku-board.c"
							}
#line 448 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = stdout;
#line 448 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp7_, " ");
#line 4135 "sudoku-board.c"
						}
					}
				}
				{
					gint l2 = 0;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4143 "sudoku-board.c"
					{
						gboolean _tmp8_ = FALSE;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp8_ = TRUE;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4150 "sudoku-board.c"
							gint _tmp10_ = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp8_) {
#line 4160 "sudoku-board.c"
								gint _tmp9_ = 0;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp9_ = l2;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp9_ + 1;
#line 4166 "sudoku-board.c"
							}
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = FALSE;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp10_ < 9)) {
#line 450 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4176 "sudoku-board.c"
							}
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = self->cells;
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length1 = self->cells_length1;
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length2 = self->cells_length2;
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = l1;
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 452 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp14_ != 0) {
#line 4192 "sudoku-board.c"
								FILE* _tmp15_ = NULL;
								gint* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp16__length2 = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = stdout;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = self->cells;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length1 = self->cells_length1;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length2 = self->cells_length2;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = l1;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = l2;
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 453 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp15_, "%d ", _tmp19_);
#line 4216 "sudoku-board.c"
							} else {
								FILE* _tmp20_ = NULL;
#line 455 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = stdout;
#line 455 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp20_, "  ");
#line 4223 "sudoku-board.c"
							}
						}
					}
				}
#line 457 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = stdout;
#line 457 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp21_, "\n");
#line 4232 "sudoku-board.c"
			}
		}
	}
#line 459 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = stdout;
#line 459 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	fflush (_tmp22_);
#line 4240 "sudoku-board.c"
}


void sudoku_board_get_string (SudokuBoard* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp18_ = NULL;
#line 462 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 463 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = stdout;
#line 463 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp0_, "[ ");
#line 4253 "sudoku-board.c"
	{
		gint l1 = 0;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4258 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4265 "sudoku-board.c"
				gint _tmp3_ = 0;
				FILE* _tmp4_ = NULL;
				FILE* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4272 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4278 "sudoku-board.c"
				}
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < 9)) {
#line 464 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4288 "sudoku-board.c"
				}
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = stdout;
#line 466 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp4_, "[ ");
#line 4294 "sudoku-board.c"
				{
					gint l2 = 0;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4299 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4306 "sudoku-board.c"
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4318 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4324 "sudoku-board.c"
							}
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < 9)) {
#line 467 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4334 "sudoku-board.c"
							}
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = stdout;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 469 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp8_, "%d", _tmp12_);
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 470 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp13_ != 8) {
#line 4356 "sudoku-board.c"
								FILE* _tmp14_ = NULL;
#line 471 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = stdout;
#line 471 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp14_, ",");
#line 4362 "sudoku-board.c"
							}
						}
					}
				}
#line 473 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = stdout;
#line 473 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp15_, " ]");
#line 474 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp16_ = l1;
#line 474 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp16_ != 8) {
#line 4375 "sudoku-board.c"
					FILE* _tmp17_ = NULL;
#line 475 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = stdout;
#line 475 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					fprintf (_tmp17_, ",");
#line 4381 "sudoku-board.c"
				}
			}
		}
	}
#line 477 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = stdout;
#line 477 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp18_, " ]");
#line 4390 "sudoku-board.c"
}


gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state) {
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
#line 480 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 482 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 482 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp0_;
#line 4404 "sudoku-board.c"
	{
		gint i = 0;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		i = 0;
#line 4409 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4416 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4421 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 4427 "sudoku-board.c"
				}
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 483 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4439 "sudoku-board.c"
				}
				{
					gint j = 0;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					j = 0;
#line 4445 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4452 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gboolean* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4463 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = j;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								j = _tmp6_ + 1;
#line 4469 "sudoku-board.c"
							}
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = j;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 485 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4481 "sudoku-board.c"
							}
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->is_fixed;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->is_fixed_length1;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->is_fixed_length2;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = i;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = j;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_) {
#line 4497 "sudoku-board.c"
								const gchar* _tmp13_ = NULL;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = board_string;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = self->cells;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length1 = self->cells_length1;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length2 = self->cells_length2;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = i;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = j;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp18_;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp20_;
#line 488 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp19_);
#line 4534 "sudoku-board.c"
							} else {
								gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = get_original_state;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								if (_tmp22_) {
#line 4544 "sudoku-board.c"
									gchar* _tmp23_ = NULL;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp23_ = g_strdup ("0");
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp23_;
#line 4552 "sudoku-board.c"
								} else {
									gint* _tmp24_ = NULL;
									gint _tmp24__length1 = 0;
									gint _tmp24__length2 = 0;
									gint _tmp25_ = 0;
									gint _tmp26_ = 0;
									gint _tmp27_ = 0;
									gchar* _tmp28_ = NULL;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24_ = self->cells;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length1 = self->cells_length1;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length2 = self->cells_length2;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp25_ = i;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp26_ = j;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp28_;
#line 4579 "sudoku-board.c"
								}
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp29_ = board_string;
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 490 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp30_;
#line 487 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp21_);
#line 4591 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 493 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = board_string;
#line 493 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4603 "sudoku-board.c"
}


static gint* _vala_array_dup8 (gint* self, int length) {
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 4610 "sudoku-board.c"
}


gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
#line 496 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length1 = _tmp0__length1;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length2 = _tmp0__length2;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length1 = _tmp1__length1;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length2 = _tmp1__length2;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp2__length1;
#line 4649 "sudoku-board.c"
	}
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length2) {
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		*result_length2 = _tmp2__length2;
#line 4655 "sudoku-board.c"
	}
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_;
#line 498 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4661 "sudoku-board.c"
}


GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_ = NULL;
#line 501 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 502 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 502 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp0_;
#line 4675 "sudoku-board.c"
	{
		gint l1 = 0;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4680 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4687 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4692 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4698 "sudoku-board.c"
				}
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 503 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4710 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4716 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4723 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4734 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4740 "sudoku-board.c"
							}
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 505 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4752 "sudoku-board.c"
							}
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_ == 0) {
#line 4768 "sudoku-board.c"
								GeeArrayList* possArrayList = NULL;
								GeeArrayList* _tmp13_ = NULL;
								gint* possArray = NULL;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint* _tmp17_ = NULL;
								gint possArray_length1 = 0;
								gint _possArray_size_ = 0;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								GeeHashMap* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Coord _tmp24_ = {0};
								GeeArrayList* _tmp25_ = NULL;
#line 509 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
#line 509 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								possArrayList = _tmp13_;
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = l1;
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = l2;
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								possArray = _tmp17_;
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								possArray_length1 = _tmp16_;
#line 510 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_possArray_size_ = possArray_length1;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = possArray;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18__length1 = possArray_length1;
#line 4805 "sudoku-board.c"
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									i_collection = _tmp18_;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									i_collection_length1 = _tmp18__length1;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
#line 4817 "sudoku-board.c"
										gint i = 0;
#line 511 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
										i = i_collection[i_it];
#line 4821 "sudoku-board.c"
										{
											GeeArrayList* _tmp19_ = NULL;
											gint _tmp20_ = 0;
#line 512 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											_tmp19_ = possArrayList;
#line 512 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											_tmp20_ = i;
#line 512 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
#line 4831 "sudoku-board.c"
										}
									}
								}
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp21_ = possibilities;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = l1;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp23_ = l2;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_tmp25_ = possArrayList;
#line 514 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								possArray = (g_free (possArray), NULL);
#line 507 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
								_g_object_unref0 (possArrayList);
#line 4851 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = possibilities;
#line 518 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4863 "sudoku-board.c"
}


gboolean sudoku_board_is_finished (SudokuBoard* self) {
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 521 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_to_string (self, TRUE);
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (_tmp1_);
#line 523 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp3_;
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
#line 524 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	finishgame_file = _tmp6_;
#line 525 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = g_file_new_for_path (finishgame_file);
#line 525 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	file = _tmp7_;
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = g_file_query_exists (file, NULL);
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp8_;
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (file);
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (finishgame_file);
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (board_string);
#line 527 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4919 "sudoku-board.c"
}


gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 530 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 532 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 532 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	s = _tmp0_;
#line 4933 "sudoku-board.c"
	{
		gint i = 0;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		i = 1;
#line 4938 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4945 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint _tmp6__length3 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4959 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 4965 "sudoku-board.c"
				}
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = sudoku_board_get_max_val (self);
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = _tmp4_;
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ <= _tmp5_)) {
#line 533 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4979 "sudoku-board.c"
				}
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = self->earmarks;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length1 = self->earmarks_length1;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length2 = self->earmarks_length2;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length3 = self->earmarks_length3;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = row;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = col;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = i;
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = _tmp6_[(((_tmp7_ * _tmp6__length2) + _tmp8_) * _tmp6__length3) + (_tmp9_ - 1)];
#line 534 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp10_) {
#line 4999 "sudoku-board.c"
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp11_ = s;
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp12_ = i;
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp13_ = g_strdup_printf ("%i", _tmp12_);
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp14_ = _tmp13_;
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (s);
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					s = _tmp15_;
#line 535 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (_tmp14_);
#line 5021 "sudoku-board.c"
				}
			}
		}
	}
#line 537 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = s;
#line 537 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5030 "sudoku-board.c"
}


gdouble sudoku_board_get_previous_played_time (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_previous_played_time;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5045 "sudoku-board.c"
}


void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = _tmp0_;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "previous-played-time");
#line 5059 "sudoku-board.c"
}


gint sudoku_board_get_block_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5074 "sudoku-board.c"
}


gint sudoku_board_get_block_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_cols;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 30 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5089 "sudoku-board.c"
}


gint sudoku_board_get_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_rows;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 37 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5104 "sudoku-board.c"
}


gint sudoku_board_get_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_cols;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5119 "sudoku-board.c"
}


gint sudoku_board_get_max_val (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_get_block_rows (self);
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_block_cols (self);
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp1_ * _tmp3_;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5143 "sudoku-board.c"
}


gboolean sudoku_board_get_broken (SudokuBoard* self) {
	gboolean result;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->broken_coords;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_ != 0;
#line 55 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5164 "sudoku-board.c"
}


gint sudoku_board_get_filled (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_filled;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 62 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5179 "sudoku-board.c"
}


gboolean sudoku_board_get_complete (SudokuBoard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_filled;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_cols;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_rows;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
#line 5199 "sudoku-board.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = sudoku_board_get_broken (self);
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = !_tmp5_;
#line 5208 "sudoku-board.c"
	} else {
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5212 "sudoku-board.c"
	}
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5218 "sudoku-board.c"
}


static void sudoku_board_class_init (SudokuBoardClass * klass) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME, g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS, g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS, g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL, g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN, g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED, g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE, g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5253 "sudoku-board.c"
}


static void sudoku_board_instance_init (SudokuBoard * self) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = (gdouble) 0;
#line 5262 "sudoku-board.c"
}


static void sudoku_board_finalize (GObject* obj) {
	SudokuBoard * self;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 9 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 11 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 12 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	self->earmarks = (g_free (self->earmarks), NULL);
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
#line 5292 "sudoku-board.c"
}


GType sudoku_board_get_type (void) {
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_ROWS:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_rows (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_COLS:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_cols (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_ROWS:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_rows (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COLS:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_cols (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_MAX_VAL:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_max_val (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BROKEN:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_broken (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FILLED:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_filled (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COMPLETE:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_complete (self));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5367 "sudoku-board.c"
		default:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5373 "sudoku-board.c"
	}
}


static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5389 "sudoku-board.c"
		default:
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5395 "sudoku-board.c"
	}
}


GType house_get_type (void) {
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void coord_init (Coord *self, gint row, gint col) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 552 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Coord));
#line 554 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 554 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	(*self).row = _tmp0_;
#line 555 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 555 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	(*self).col = _tmp1_;
#line 5425 "sudoku-board.c"
}


gint coord_hash (Coord* coord) {
	gint result = 0;
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	Coord _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 558 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coord != NULL, 0);
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.row;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = *coord;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_.col;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp1_ * 33) ^ _tmp3_;
#line 559 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5449 "sudoku-board.c"
}


gboolean coord_equal (Coord* a, Coord* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 562 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 562 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.row;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.row;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_ == _tmp4_) {
#line 5474 "sudoku-board.c"
		Coord _tmp5_ = {0};
		gint _tmp6_ = 0;
		Coord _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = *a;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = _tmp5_.col;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = *b;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp7_.col;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp6_ == _tmp8_;
#line 5489 "sudoku-board.c"
	} else {
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5493 "sudoku-board.c"
	}
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 563 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5499 "sudoku-board.c"
}


Coord* coord_dup (const Coord* self) {
	Coord* dup;
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Coord, 1);
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Coord));
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5511 "sudoku-board.c"
}


void coord_free (Coord* self) {
#line 547 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5518 "sudoku-board.c"
}


GType coord_get_type (void) {
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void cell_init (Cell *self, Coord* coord, gint val) {
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 572 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coord != NULL);
#line 572 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Cell));
#line 574 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 574 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	(*self).coord = _tmp0_;
#line 575 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 575 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	(*self).val = _tmp1_;
#line 5548 "sudoku-board.c"
}


gint cell_hash (Cell* cell) {
	gint result = 0;
	Cell _tmp0_ = {0};
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Cell _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 578 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (cell != NULL, 0);
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *cell;
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.coord;
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = coord_hash (&_tmp1_);
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *cell;
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.val;
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp2_ * 33) ^ _tmp4_;
#line 579 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5575 "sudoku-board.c"
}


gboolean cell_equal (Cell* a, Cell* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_ = {0};
	Coord _tmp2_ = {0};
	Cell _tmp3_ = {0};
	Coord _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 582 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.coord;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.coord;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = coord_equal (&_tmp2_, &_tmp4_);
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_) {
#line 5603 "sudoku-board.c"
		Cell _tmp6_ = {0};
		gint _tmp7_ = 0;
		Cell _tmp8_ = {0};
		gint _tmp9_ = 0;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = *a;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = _tmp6_.val;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = *b;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp8_.val;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp7_ == _tmp9_;
#line 5618 "sudoku-board.c"
	} else {
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5622 "sudoku-board.c"
	}
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 583 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5628 "sudoku-board.c"
}


Cell* cell_dup (const Cell* self) {
	Cell* dup;
#line 567 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Cell, 1);
#line 567 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Cell));
#line 567 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5640 "sudoku-board.c"
}


void cell_free (Cell* self) {
#line 567 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5647 "sudoku-board.c"
}


GType cell_get_type (void) {
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



