/* game-view.c generated by valac 0.22.1, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cogl/cogl.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_TILE_ACTOR (tile_actor_get_type ())
#define TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_ACTOR, TileActor))
#define TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_ACTOR, TileActorClass))
#define IS_TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_ACTOR))
#define IS_TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_ACTOR))
#define TILE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_ACTOR, TileActorClass))

typedef struct _TileActor TileActor;
typedef struct _TileActorClass TileActorClass;

#define TYPE_CURSOR_ACTOR (cursor_actor_get_type ())
#define CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURSOR_ACTOR, CursorActor))
#define CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURSOR_ACTOR, CursorActorClass))
#define IS_CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURSOR_ACTOR))
#define IS_CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURSOR_ACTOR))
#define CURSOR_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURSOR_ACTOR, CursorActorClass))

typedef struct _CursorActor CursorActor;
typedef struct _CursorActorClass CursorActorClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _theme_unref0(var) ((var == NULL) ? NULL : (var = (theme_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
typedef struct _ThemePrivate ThemePrivate;
typedef struct _TilePrivate TilePrivate;
typedef struct _TileActorPrivate TileActorPrivate;
#define __g_list_free__tile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__tile_unref0_ (var), NULL)))

#define TYPE_SCORE_ACTOR (score_actor_get_type ())
#define SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_ACTOR, ScoreActor))
#define SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_ACTOR, ScoreActorClass))
#define IS_SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_ACTOR))
#define IS_SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_ACTOR))
#define SCORE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_ACTOR, ScoreActorClass))

typedef struct _ScoreActor ScoreActor;
typedef struct _ScoreActorClass ScoreActorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTheme ParamSpecTheme;
#define __vala_ClutterPoint_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterPoint_free (var), NULL)))
typedef struct _CursorActorPrivate CursorActorPrivate;
typedef struct _ScoreActorPrivate ScoreActorPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
	gboolean is_zealous;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	TileActor* highlighted;
	CursorActor* cursor;
	gboolean cursor_active;
	gint _cursor_x;
	gint _cursor_y;
	TileActor** tiles;
	gint tiles_length1;
	gint tiles_length2;
	ClutterActor* game_actors;
	Game* _game;
	GHashTable* themes;
	gchar* _theme_name;
	gint tile_size;
};

struct _Theme {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThemePrivate * priv;
	ClutterImage** textures;
	gint textures_length1;
	ClutterImage* cursor;
};

struct _ThemeClass {
	GTypeClass parent_class;
	void (*finalize) (Theme *self);
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint grid_x;
	gint grid_y;
	gint color;
	gboolean visited;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _TileActor {
	ClutterActor parent_instance;
	TileActorPrivate * priv;
	Tile* tile;
};

struct _TileActorClass {
	ClutterActorClass parent_class;
};

struct _ParamSpecTheme {
	GParamSpec parent_instance;
};

struct _CursorActor {
	ClutterActor parent_instance;
	CursorActorPrivate * priv;
};

struct _CursorActorClass {
	ClutterActorClass parent_class;
};

struct _ScoreActor {
	ClutterGroup parent_instance;
	ScoreActorPrivate * priv;
};

struct _ScoreActorClass {
	ClutterGroupClass parent_class;
};

struct _ScoreActorPrivate {
	ClutterText* label;
	gfloat scene_width;
	gfloat scene_height;
	gint game_size;
};


static gpointer game_view_parent_class = NULL;
static gpointer theme_parent_class = NULL;
static gpointer tile_actor_parent_class = NULL;
static gpointer cursor_actor_parent_class = NULL;
static gpointer score_actor_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType tile_actor_get_type (void) G_GNUC_CONST;
GType cursor_actor_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
gpointer theme_ref (gpointer instance);
void theme_unref (gpointer instance);
GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_theme (GValue* value, gpointer v_object);
void value_take_theme (GValue* value, gpointer v_object);
gpointer value_get_theme (const GValue* value);
GType theme_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_CURSOR_X,
	GAME_VIEW_CURSOR_Y,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME_NAME
};
static void game_view_remove_tiles (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_columns (Game* self);
gint game_get_rows (Game* self);
static void game_view_place_tiles (GameView* self);
const gchar* game_view_get_theme_name (GameView* self);
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
Tile* game_get_tile (Game* self, gint x, gint y);
gboolean tile_get_closed (Tile* self);
TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size);
TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size);
void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y);
static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self);
void game_view_close_cb (GameView* self, gint grid_x, gint grid_y);
static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self);
static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor);
static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self);
static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
CursorActor* cursor_actor_new (ClutterContent* texture, gint size);
CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _theme_unref0_ (gpointer var);
Theme* theme_new (const gchar* name);
Theme* theme_construct (GType object_type, const gchar* name);
void tile_actor_animate_out (TileActor* self);
void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous);
static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity);
GList* game_connected_tiles (Game* self, Tile* li);
static void _tile_unref0_ (gpointer var);
static void _g_list_free__tile_unref0_ (GList* self);
void game_view_set_cursor_x (GameView* self, gint value);
void game_view_set_cursor_y (GameView* self, gint value);
gboolean game_remove_connected_tiles (Game* self, Tile* tile);
gboolean game_view_board_left_cb (GameView* self);
void game_reset_visit (Game* self);
void game_view_cursor_move (GameView* self, gint x, gint y);
gint game_view_get_cursor_x (GameView* self);
gint game_view_get_cursor_y (GameView* self);
void game_view_cursor_click (GameView* self);
void game_view_update_score_cb (GameView* self, gint points_awarded);
GType score_actor_get_type (void) G_GNUC_CONST;
ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height);
ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height);
void score_actor_animate_score (ScoreActor* self, gint points);
void game_view_game_complete_cb (GameView* self);
void score_actor_animate_final_score (ScoreActor* self, guint points);
gint game_get_score (Game* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self);
void game_view_set_theme_name (GameView* self, const gchar* value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	THEME_DUMMY_PROPERTY
};
static void theme_finalize (Theme* obj);
enum  {
	TILE_ACTOR_DUMMY_PROPERTY
};
static void _vala_ClutterPoint_free (ClutterPoint* self);
static void tile_actor_hide_tile_cb (TileActor* self);
static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void tile_actor_finalize (GObject* obj);
enum  {
	CURSOR_ACTOR_DUMMY_PROPERTY
};
#define SCORE_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCORE_ACTOR, ScoreActorPrivate))
enum  {
	SCORE_ACTOR_DUMMY_PROPERTY
};
static void __lambda2_ (ScoreActor* self);
static void ___lambda2__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void score_actor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_remove_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	CursorActor* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				Game* _tmp6_ = NULL;
				Game* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = x;
					x = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = x;
				_tmp6_ = game_view_get_game (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = game_get_columns (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp5_ < _tmp9_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gboolean _tmp11_ = FALSE;
							gint _tmp13_ = 0;
							Game* _tmp14_ = NULL;
							Game* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							TileActor* tile = NULL;
							TileActor** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp18__length2 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							TileActor* _tmp21_ = NULL;
							TileActor* _tmp22_ = NULL;
							TileActor* _tmp23_ = NULL;
							TileActor** _tmp24_ = NULL;
							gint _tmp24__length1 = 0;
							gint _tmp24__length2 = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							TileActor* _tmp27_ = NULL;
							TileActor* _tmp28_ = NULL;
							TileActor* _tmp29_ = NULL;
							_tmp11_ = _tmp10_;
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								_tmp12_ = y;
								y = _tmp12_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp13_ = y;
							_tmp14_ = game_view_get_game (self);
							_tmp15_ = _tmp14_;
							_tmp16_ = game_get_rows (_tmp15_);
							_tmp17_ = _tmp16_;
							if (!(_tmp13_ < _tmp17_)) {
								break;
							}
							_tmp18_ = self->priv->tiles;
							_tmp18__length1 = self->priv->tiles_length1;
							_tmp18__length2 = self->priv->tiles_length2;
							_tmp19_ = x;
							_tmp20_ = y;
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
							_tmp22_ = _g_object_ref0 (_tmp21_);
							tile = _tmp22_;
							_tmp23_ = tile;
							if (_tmp23_ == NULL) {
								_g_object_unref0 (tile);
								continue;
							}
							_tmp24_ = self->priv->tiles;
							_tmp24__length1 = self->priv->tiles_length1;
							_tmp24__length2 = self->priv->tiles_length2;
							_tmp25_ = x;
							_tmp26_ = y;
							_g_object_unref0 (_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_]);
							_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_] = NULL;
							_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
							_tmp28_ = tile;
							g_signal_handlers_disconnect_matched (_tmp28_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
							_tmp29_ = tile;
							clutter_actor_destroy ((ClutterActor*) _tmp29_);
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp30_ = self->priv->cursor;
	clutter_actor_destroy ((ClutterActor*) _tmp30_);
}


static gpointer _theme_ref0 (gpointer self) {
	return self ? theme_ref (self) : NULL;
}


static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self) {
	game_view_move_cb (self, old_x, old_y, new_x, new_y);
}


static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self) {
	game_view_close_cb (self, grid_x, grid_y);
}


static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self) {
	game_view_remove_region_cb (self, _sender, actor);
}


static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_entered_cb (self, _sender, event);
	return result;
}


static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_left_cb (self, _sender, event);
	return result;
}


static void game_view_place_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Theme* theme = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp74_ = NULL;
	ClutterImage* _tmp75_ = NULL;
	gint _tmp76_ = 0;
	CursorActor* _tmp77_ = NULL;
	ClutterActor* _tmp78_ = NULL;
	CursorActor* _tmp79_ = NULL;
	CursorActor* _tmp80_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->themes;
	_tmp3_ = game_view_get_theme_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp2_, _tmp4_);
	_tmp6_ = _theme_ref0 ((Theme*) _tmp5_);
	theme = _tmp6_;
	_tmp7_ = theme;
	if (_tmp7_ == NULL) {
		GHashTable* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		Theme* _tmp10_ = NULL;
		_tmp8_ = self->priv->themes;
		_tmp9_ = g_hash_table_lookup (_tmp8_, "shapesandcolors");
		_tmp10_ = _theme_ref0 ((Theme*) _tmp9_);
		_theme_unref0 (theme);
		theme = _tmp10_;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				gint _tmp14_ = 0;
				Game* _tmp15_ = NULL;
				Game* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = x;
					x = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = x;
				_tmp15_ = game_view_get_game (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = game_get_columns (_tmp16_);
				_tmp18_ = _tmp17_;
				if (!(_tmp14_ < _tmp18_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							gboolean _tmp20_ = FALSE;
							gint _tmp22_ = 0;
							Game* _tmp23_ = NULL;
							Game* _tmp24_ = NULL;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Tile* l = NULL;
							Game* _tmp27_ = NULL;
							Game* _tmp28_ = NULL;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							Tile* _tmp31_ = NULL;
							gboolean _tmp32_ = FALSE;
							Tile* _tmp33_ = NULL;
							gboolean _tmp37_ = FALSE;
							TileActor* tile = NULL;
							Tile* _tmp38_ = NULL;
							Theme* _tmp39_ = NULL;
							ClutterImage** _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							Tile* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							ClutterImage* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							TileActor* _tmp45_ = NULL;
							Tile* _tmp46_ = NULL;
							Tile* _tmp47_ = NULL;
							gfloat xx = 0.0F;
							gfloat yy = 0.0F;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							Game* _tmp50_ = NULL;
							Game* _tmp51_ = NULL;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							TileActor* _tmp56_ = NULL;
							gfloat _tmp57_ = 0.0F;
							gfloat _tmp58_ = 0.0F;
							TileActor* _tmp59_ = NULL;
							ClutterTapAction* tap = NULL;
							ClutterTapAction* _tmp60_ = NULL;
							TileActor* _tmp61_ = NULL;
							ClutterTapAction* _tmp62_ = NULL;
							ClutterTapAction* _tmp63_ = NULL;
							TileActor* _tmp64_ = NULL;
							TileActor* _tmp65_ = NULL;
							TileActor** _tmp66_ = NULL;
							gint _tmp66__length1 = 0;
							gint _tmp66__length2 = 0;
							gint _tmp67_ = 0;
							gint _tmp68_ = 0;
							TileActor* _tmp69_ = NULL;
							TileActor* _tmp70_ = NULL;
							TileActor* _tmp71_ = NULL;
							ClutterActor* _tmp72_ = NULL;
							TileActor* _tmp73_ = NULL;
							_tmp20_ = _tmp19_;
							if (!_tmp20_) {
								gint _tmp21_ = 0;
								_tmp21_ = y;
								y = _tmp21_ + 1;
							}
							_tmp19_ = FALSE;
							_tmp22_ = y;
							_tmp23_ = game_view_get_game (self);
							_tmp24_ = _tmp23_;
							_tmp25_ = game_get_rows (_tmp24_);
							_tmp26_ = _tmp25_;
							if (!(_tmp22_ < _tmp26_)) {
								break;
							}
							_tmp27_ = game_view_get_game (self);
							_tmp28_ = _tmp27_;
							_tmp29_ = x;
							_tmp30_ = y;
							_tmp31_ = game_get_tile (_tmp28_, _tmp29_, _tmp30_);
							l = _tmp31_;
							_tmp33_ = l;
							if (_tmp33_ == NULL) {
								_tmp32_ = TRUE;
							} else {
								Tile* _tmp34_ = NULL;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								_tmp34_ = l;
								_tmp35_ = tile_get_closed (_tmp34_);
								_tmp36_ = _tmp35_;
								_tmp32_ = _tmp36_;
							}
							_tmp37_ = _tmp32_;
							if (_tmp37_) {
								_tile_unref0 (l);
								continue;
							}
							_tmp38_ = l;
							_tmp39_ = theme;
							_tmp40_ = _tmp39_->textures;
							_tmp40__length1 = _tmp39_->textures_length1;
							_tmp41_ = l;
							_tmp42_ = _tmp41_->color;
							_tmp43_ = _tmp40_[_tmp42_];
							_tmp44_ = self->priv->tile_size;
							_tmp45_ = tile_actor_new (_tmp38_, _tmp43_, _tmp44_);
							g_object_ref_sink (_tmp45_);
							tile = _tmp45_;
							_tmp46_ = l;
							g_signal_connect_object (_tmp46_, "move", (GCallback) _game_view_move_cb_tile_move, self, 0);
							_tmp47_ = l;
							g_signal_connect_object (_tmp47_, "close", (GCallback) _game_view_close_cb_tile_close, self, 0);
							_tmp48_ = x;
							_tmp49_ = self->priv->tile_size;
							xx = (gfloat) (_tmp48_ * _tmp49_);
							_tmp50_ = game_view_get_game (self);
							_tmp51_ = _tmp50_;
							_tmp52_ = game_get_rows (_tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = y;
							_tmp55_ = self->priv->tile_size;
							yy = (gfloat) (((_tmp53_ - _tmp54_) - 1) * _tmp55_);
							_tmp56_ = tile;
							_tmp57_ = xx;
							_tmp58_ = yy;
							clutter_actor_set_position ((ClutterActor*) _tmp56_, _tmp57_, _tmp58_);
							_tmp59_ = tile;
							clutter_actor_set_reactive ((ClutterActor*) _tmp59_, TRUE);
							_tmp60_ = (ClutterTapAction*) clutter_tap_action_new ();
							g_object_ref_sink (_tmp60_);
							tap = _tmp60_;
							_tmp61_ = tile;
							_tmp62_ = tap;
							clutter_actor_add_action ((ClutterActor*) _tmp61_, (ClutterAction*) _tmp62_);
							_tmp63_ = tap;
							g_signal_connect_object (_tmp63_, "tap", (GCallback) _game_view_remove_region_cb_clutter_tap_action_tap, self, 0);
							_tmp64_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp64_, "enter-event", (GCallback) _game_view_tile_entered_cb_clutter_actor_enter_event, self, 0);
							_tmp65_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp65_, "leave-event", (GCallback) _game_view_tile_left_cb_clutter_actor_leave_event, self, 0);
							_tmp66_ = self->priv->tiles;
							_tmp66__length1 = self->priv->tiles_length1;
							_tmp66__length2 = self->priv->tiles_length2;
							_tmp67_ = x;
							_tmp68_ = y;
							_tmp69_ = tile;
							_tmp70_ = _g_object_ref0 (_tmp69_);
							_g_object_unref0 (_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_]);
							_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = _tmp70_;
							_tmp71_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
							_tmp72_ = self->priv->game_actors;
							_tmp73_ = tile;
							clutter_actor_add_child (_tmp72_, (ClutterActor*) _tmp73_);
							_g_object_unref0 (tap);
							_g_object_unref0 (tile);
							_tile_unref0 (l);
						}
					}
				}
			}
		}
	}
	_tmp74_ = theme;
	_tmp75_ = _tmp74_->cursor;
	_tmp76_ = self->priv->tile_size;
	_tmp77_ = cursor_actor_new ((ClutterContent*) _tmp75_, _tmp76_);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = _tmp77_;
	_tmp78_ = self->priv->game_actors;
	_tmp79_ = self->priv->cursor;
	clutter_actor_add_child (_tmp78_, (ClutterActor*) _tmp79_);
	_tmp80_ = self->priv->cursor;
	clutter_actor_hide ((ClutterActor*) _tmp80_);
	_theme_unref0 (theme);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _theme_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (theme_unref (var), NULL));
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Theme* theme = NULL;
	Theme* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	Theme* _tmp11_ = NULL;
	Theme* _tmp12_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _theme_unref0_);
	_g_hash_table_unref0 (self->priv->themes);
	self->priv->themes = _tmp2_;
	_tmp3_ = theme_new ("colors");
	theme = _tmp3_;
	_tmp4_ = self->priv->themes;
	_tmp5_ = g_strdup ("colors");
	_tmp6_ = theme;
	_tmp7_ = _theme_ref0 (_tmp6_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = theme_new ("shapesandcolors");
	_theme_unref0 (theme);
	theme = _tmp8_;
	_tmp9_ = self->priv->themes;
	_tmp10_ = g_strdup ("shapesandcolors");
	_tmp11_ = theme;
	_tmp12_ = _theme_ref0 (_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	_theme_unref0 (theme);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


void game_view_close_cb (GameView* self, gint grid_x, gint grid_y) {
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = grid_x;
	_tmp2_ = grid_y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	tile_actor_animate_out (_tmp3_);
}


void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y) {
	TileActor* tile = NULL;
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	TileActor* _tmp9_ = NULL;
	gint new_xx = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint new_yy = 0;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = old_x;
	_tmp2_ = old_y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tile = _tmp4_;
	_tmp5_ = self->priv->tiles;
	_tmp5__length1 = self->priv->tiles_length1;
	_tmp5__length2 = self->priv->tiles_length2;
	_tmp6_ = new_x;
	_tmp7_ = new_y;
	_tmp8_ = _g_object_ref0 (tile);
	_g_object_unref0 (_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_]);
	_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_] = _tmp8_;
	_tmp9_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp10_ = new_x;
	_tmp11_ = self->priv->tile_size;
	new_xx = _tmp10_ * _tmp11_;
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_rows (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = new_y;
	_tmp17_ = self->priv->tile_size;
	new_yy = ((_tmp15_ - _tmp16_) - 1) * _tmp17_;
	_tmp18_ = self->is_zealous;
	tile_actor_animate_to (tile, (gdouble) new_xx, (gdouble) new_yy, _tmp18_);
	_g_object_unref0 (tile);
}


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


static void _tile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tile_unref (var), NULL));
}


static void _g_list_free__tile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _tile_unref0_, NULL);
	g_list_free (self);
}


static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity) {
	TileActor* _tmp0_ = NULL;
	GList* connected_tiles = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = actor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = actor;
	_tmp4_ = _tmp3_->tile;
	_tmp5_ = game_connected_tiles (_tmp2_, _tmp4_);
	connected_tiles = _tmp5_;
	_tmp6_ = connected_tiles;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp6_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Tile* _tmp7_ = NULL;
			Tile* l = NULL;
			_tmp7_ = _tile_ref0 ((Tile*) l_it->data);
			l = _tmp7_;
			{
				TileActor** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp8__length2 = 0;
				Tile* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				Tile* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				TileActor* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				_tmp8_ = self->priv->tiles;
				_tmp8__length1 = self->priv->tiles_length1;
				_tmp8__length2 = self->priv->tiles_length2;
				_tmp9_ = l;
				_tmp10_ = _tmp9_->grid_x;
				_tmp11_ = l;
				_tmp12_ = _tmp11_->grid_y;
				_tmp13_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
				_tmp14_ = opacity;
				clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) _tmp14_);
				_tile_unref0 (l);
			}
		}
	}
	__g_list_free__tile_unref0_0 (connected_tiles);
}


static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->cursor_active;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = actor;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp2_;
	_tmp3_ = tile;
	game_view_opacity_for_connected_tiles (self, _tmp3_, 255);
	_tmp4_ = tile;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp5_;
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}


static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->cursor_active;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = actor;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp2_;
	_tmp3_ = tile;
	game_view_opacity_for_connected_tiles (self, _tmp3_, 180);
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}


static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor) {
	TileActor* tile = NULL;
	ClutterActor* _tmp0_ = NULL;
	TileActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	TileActor* _tmp5_ = NULL;
	Tile* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	TileActor* _tmp13_ = NULL;
	Tile* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp1_;
	_tmp2_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp2_, 180);
	_tmp3_ = self->priv->cursor_active;
	if (_tmp3_) {
		CursorActor* _tmp4_ = NULL;
		self->priv->cursor_active = FALSE;
		_tmp4_ = self->priv->cursor;
		clutter_actor_hide ((ClutterActor*) _tmp4_);
	}
	_tmp5_ = tile;
	_tmp6_ = _tmp5_->tile;
	_tmp7_ = _tmp6_->grid_x;
	game_view_set_cursor_x (self, _tmp7_);
	_tmp8_ = tile;
	_tmp9_ = _tmp8_->tile;
	_tmp10_ = _tmp9_->grid_y;
	game_view_set_cursor_y (self, _tmp10_);
	_tmp11_ = game_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = tile;
	_tmp14_ = _tmp13_->tile;
	game_remove_connected_tiles (_tmp12_, _tmp14_);
	_g_object_unref0 (tile);
}


gboolean game_view_board_left_cb (GameView* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	game_reset_visit (_tmp1_);
	_tmp2_ = self->priv->tiles;
	_tmp2__length1 = self->priv->tiles_length1;
	_tmp2__length2 = self->priv->tiles_length2;
	{
		TileActor** tile_collection = NULL;
		gint tile_collection_length1 = 0;
		gint tile_collection_length2 = 0;
		gint tile_it = 0;
		tile_collection = _tmp2_;
		tile_collection_length1 = _tmp2__length1 * _tmp2__length2;
		for (tile_it = 0; tile_it < (_tmp2__length1 * _tmp2__length2); tile_it = tile_it + 1) {
			TileActor* _tmp3_ = NULL;
			TileActor* tile = NULL;
			_tmp3_ = _g_object_ref0 (tile_collection[tile_it]);
			tile = _tmp3_;
			{
				TileActor* _tmp4_ = NULL;
				_tmp4_ = tile;
				clutter_actor_set_opacity ((ClutterActor*) _tmp4_, (guint) 180);
				_g_object_unref0 (tile);
			}
		}
	}
	result = FALSE;
	return result;
}


void game_view_cursor_move (GameView* self, gint x, gint y) {
	TileActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TileActor** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	TileActor* _tmp12_ = NULL;
	TileActor* _tmp13_ = NULL;
	TileActor* _tmp14_ = NULL;
	gfloat xx = 0.0F;
	gfloat yy = 0.0F;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Game* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	CursorActor* _tmp25_ = NULL;
	CursorActor* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->cursor_active = TRUE;
	_tmp0_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp0_, 180);
	_tmp1_ = game_view_get_cursor_x (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	game_view_set_cursor_x (self, _tmp2_ + _tmp3_);
	_tmp4_ = game_view_get_cursor_y (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = y;
	game_view_set_cursor_y (self, _tmp5_ + _tmp6_);
	_tmp7_ = self->priv->tiles;
	_tmp7__length1 = self->priv->tiles_length1;
	_tmp7__length2 = self->priv->tiles_length2;
	_tmp8_ = game_view_get_cursor_x (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = game_view_get_cursor_y (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp7_[(_tmp9_ * _tmp7__length2) + _tmp11_];
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp13_;
	_tmp14_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp14_, 255);
	_tmp15_ = game_view_get_cursor_x (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->tile_size;
	xx = (gfloat) (_tmp16_ * _tmp17_);
	_tmp18_ = game_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_get_rows (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = game_view_get_cursor_y (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->tile_size;
	yy = (gfloat) (((_tmp21_ - 1) - _tmp23_) * _tmp24_);
	_tmp25_ = self->priv->cursor;
	clutter_actor_set_position ((ClutterActor*) _tmp25_, xx, yy);
	_tmp26_ = self->priv->cursor;
	clutter_actor_show ((ClutterActor*) _tmp26_);
}


void game_view_cursor_click (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TileActor* _tmp7_ = NULL;
	Tile* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tiles;
	_tmp2__length1 = self->priv->tiles_length1;
	_tmp2__length2 = self->priv->tiles_length2;
	_tmp3_ = game_view_get_cursor_x (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_view_get_cursor_y (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
	_tmp8_ = _tmp7_->tile;
	game_remove_connected_tiles (_tmp1_, _tmp8_);
}


void game_view_update_score_cb (GameView* self, gint points_awarded) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_zealous;
	if (_tmp0_) {
		ScoreActor* text = NULL;
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gfloat _tmp5_ = 0.0F;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat _tmp8_ = 0.0F;
		ScoreActor* _tmp9_ = NULL;
		ClutterActor* _tmp10_ = NULL;
		ScoreActor* _tmp11_ = NULL;
		ScoreActor* _tmp12_ = NULL;
		ClutterAlignConstraint* _tmp13_ = NULL;
		ClutterAlignConstraint* _tmp14_ = NULL;
		ScoreActor* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp1_ = game_view_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = game_get_rows (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = score_actor_new (_tmp4_ / 5, (gdouble) _tmp6_, (gdouble) _tmp8_);
		g_object_ref_sink (_tmp9_);
		text = _tmp9_;
		_tmp10_ = self->priv->game_actors;
		_tmp11_ = text;
		clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
		_tmp12_ = text;
		_tmp13_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		clutter_actor_add_constraint ((ClutterActor*) _tmp12_, (ClutterConstraint*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = text;
		_tmp16_ = points_awarded;
		score_actor_animate_score (_tmp15_, _tmp16_);
		_g_object_unref0 (text);
	}
}


void game_view_game_complete_cb (GameView* self) {
	ScoreActor* text = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ScoreActor* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterAlignConstraint* _tmp10_ = NULL;
	ClutterAlignConstraint* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = score_actor_new (_tmp3_ / 5, (gdouble) _tmp5_, (gdouble) _tmp7_);
	g_object_ref_sink (_tmp8_);
	text = _tmp8_;
	_tmp9_ = self->priv->game_actors;
	clutter_actor_add_child (_tmp9_, (ClutterActor*) text);
	_tmp10_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	clutter_actor_add_constraint ((ClutterActor*) text, (ClutterConstraint*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_score (_tmp13_);
	_tmp15_ = _tmp14_;
	score_actor_animate_final_score (text, (guint) _tmp15_);
	_g_object_unref0 (text);
}


gint game_view_get_cursor_x (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cursor_x;
	result = _tmp0_;
	return result;
}


void game_view_set_cursor_x (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_columns (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
	self->priv->_cursor_x = _tmp5_;
	g_object_notify ((GObject *) self, "cursor-x");
}


gint game_view_get_cursor_y (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cursor_y;
	result = _tmp0_;
	return result;
}


void game_view_set_cursor_y (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_rows (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
	self->priv->_cursor_y = _tmp5_;
	g_object_notify ((GObject *) self, "cursor-y");
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	game_view_game_complete_cb (self);
}


static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self) {
	game_view_update_score_cb (self, points_awarded);
}


void game_view_set_game (GameView* self, Game* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Game* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	TileActor** _tmp22_ = NULL;
	gint _tmp23_ = 0;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	Game* _tmp29_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_actors;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_ = NULL;
		_tmp1_ = self->priv->game_actors;
		clutter_actor_destroy (_tmp1_);
	}
	_tmp2_ = clutter_actor_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->game_actors);
	self->priv->game_actors = _tmp2_;
	_tmp3_ = self->priv->game_actors;
	clutter_actor_add_child ((ClutterActor*) self, _tmp3_);
	game_view_remove_tiles (self);
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp8_ = value;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp9_;
	_tmp10_ = game_view_get_game (self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "update-score", (GCallback) _game_view_update_score_cb_game_update_score, self, 0);
	_tmp14_ = game_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = game_get_columns (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = game_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_get_rows (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_new0 (TileActor*, (_tmp17_ * _tmp21_) + 1);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->tiles = _tmp22_;
	self->priv->tiles_length1 = _tmp17_;
	self->priv->tiles_length2 = _tmp21_;
	game_view_place_tiles (self);
	_tmp23_ = self->priv->tile_size;
	_tmp24_ = game_view_get_game (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = game_get_columns (_tmp25_);
	_tmp27_ = _tmp26_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (_tmp23_ * _tmp27_));
	_tmp28_ = self->priv->tile_size;
	_tmp29_ = game_view_get_game (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = game_get_rows (_tmp30_);
	_tmp32_ = _tmp31_;
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (_tmp28_ * _tmp32_));
	g_object_notify ((GObject *) self, "game");
}


const gchar* game_view_get_theme_name (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_name;
	result = _tmp0_;
	return result;
}


void game_view_set_theme_name (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_theme_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		return;
	}
	_tmp3_ = value;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp4_;
	game_view_remove_tiles (self);
	game_view_place_tiles (self);
	g_object_notify ((GObject *) self, "theme-name");
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_X, g_param_spec_int ("cursor-x", "cursor-x", "cursor-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_Y, g_param_spec_int ("cursor-y", "cursor-y", "cursor-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void game_view_instance_init (GameView * self) {
	gchar* _tmp0_ = NULL;
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->highlighted = NULL;
	self->priv->cursor_active = FALSE;
	self->priv->game_actors = NULL;
	self->priv->_game = NULL;
	_tmp0_ = g_strdup ("shapesandcolors");
	self->priv->_theme_name = _tmp0_;
	self->priv->tile_size = 50;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->highlighted);
	_g_object_unref0 (self->priv->cursor);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->game_actors);
	_g_object_unref0 (self->priv->_game);
	_g_hash_table_unref0 (self->priv->themes);
	_g_free0 (self->priv->_theme_name);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a game. All clutter related stuff goes here. It follows the
 *  principle of MVC framework. This class deals with the presentation (view) layer. It communicates
 *  with the model class by composite relation and with the control layer by means of signals and
 *  events.
 */
GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_CURSOR_X:
		g_value_set_int (value, game_view_get_cursor_x (self));
		break;
		case GAME_VIEW_CURSOR_Y:
		g_value_set_int (value, game_view_get_cursor_y (self));
		break;
		case GAME_VIEW_GAME:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_NAME:
		g_value_set_string (value, game_view_get_theme_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_CURSOR_X:
		game_view_set_cursor_x (self, g_value_get_int (value));
		break;
		case GAME_VIEW_CURSOR_Y:
		game_view_set_cursor_y (self, g_value_get_int (value));
		break;
		case GAME_VIEW_GAME:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_NAME:
		game_view_set_theme_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Theme* theme_construct (GType object_type, const gchar* name) {
	Theme* self = NULL;
	ClutterImage** _tmp0_ = NULL;
	gchar** colors = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint colors_length1 = 0;
	gint _colors_size_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (Theme*) g_type_create_instance (object_type);
	_tmp0_ = g_new0 (ClutterImage*, 4 + 1);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->textures = _tmp0_;
	self->textures_length1 = 4;
	_tmp1_ = g_strdup ("blue");
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_strdup ("yellow");
	_tmp4_ = g_strdup ("red");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	colors = _tmp5_;
	colors_length1 = 4;
	_colors_size_ = colors_length1;
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		GdkPixbuf* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
		ClutterImage* _tmp40_ = NULL;
		ClutterImage* _tmp41_ = NULL;
		GdkPixbuf* _tmp42_ = NULL;
		guint8* _tmp43_ = NULL;
		GdkPixbuf* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		GdkPixbuf* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		GdkPixbuf* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_ = FALSE;
					gint _tmp9_ = 0;
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp10_ = NULL;
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_ = NULL;
					ClutterImage** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					ClutterImage* _tmp22_ = NULL;
					ClutterImage* _tmp23_ = NULL;
					ClutterImage** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gint _tmp25_ = 0;
					ClutterImage* _tmp26_ = NULL;
					GdkPixbuf* _tmp27_ = NULL;
					guint8* _tmp28_ = NULL;
					GdkPixbuf* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					GdkPixbuf* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					GdkPixbuf* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_ = 0;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = i;
					if (!(_tmp9_ < 4)) {
						break;
					}
					_tmp10_ = name;
					_tmp11_ = colors;
					_tmp11__length1 = colors_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_tmp14_ = g_strconcat (_tmp13_, ".svg", NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_build_filename (DATADIR, "themes", _tmp10_, _tmp15_, NULL);
					_tmp17_ = _tmp16_;
					_tmp18_ = gdk_pixbuf_new_from_file (_tmp17_, &_inner_error_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					_g_free0 (_tmp15_);
					pixbuf = _tmp19_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_tmp20_ = self->textures;
					_tmp20__length1 = self->textures_length1;
					_tmp21_ = i;
					_tmp22_ = clutter_image_new ();
					_g_object_unref0 (_tmp20_[_tmp21_]);
					_tmp20_[_tmp21_] = _tmp22_;
					_tmp23_ = _tmp20_[_tmp21_];
					_tmp24_ = self->textures;
					_tmp24__length1 = self->textures_length1;
					_tmp25_ = i;
					_tmp26_ = _tmp24_[_tmp25_];
					_tmp27_ = pixbuf;
					_tmp28_ = gdk_pixbuf_get_pixels (_tmp27_);
					_tmp29_ = pixbuf;
					_tmp30_ = gdk_pixbuf_get_width (_tmp29_);
					_tmp31_ = pixbuf;
					_tmp32_ = gdk_pixbuf_get_height (_tmp31_);
					_tmp33_ = pixbuf;
					_tmp34_ = gdk_pixbuf_get_rowstride (_tmp33_);
					clutter_image_set_data (_tmp26_, _tmp28_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp30_, (guint) _tmp32_, (guint) _tmp34_, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (pixbuf);
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_g_object_unref0 (pixbuf);
				}
			}
		}
		_tmp35_ = name;
		_tmp36_ = g_build_filename (DATADIR, "themes", _tmp35_, "highlight.svg", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = gdk_pixbuf_new_from_file (_tmp37_, &_inner_error_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		pixbuf = _tmp39_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_tmp40_ = clutter_image_new ();
		_g_object_unref0 (self->cursor);
		self->cursor = _tmp40_;
		_tmp41_ = self->cursor;
		_tmp42_ = pixbuf;
		_tmp43_ = gdk_pixbuf_get_pixels (_tmp42_);
		_tmp44_ = pixbuf;
		_tmp45_ = gdk_pixbuf_get_width (_tmp44_);
		_tmp46_ = pixbuf;
		_tmp47_ = gdk_pixbuf_get_height (_tmp46_);
		_tmp48_ = pixbuf;
		_tmp49_ = gdk_pixbuf_get_rowstride (_tmp48_);
		clutter_image_set_data (_tmp41_, _tmp43_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp45_, (guint) _tmp47_, (guint) _tmp49_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (pixbuf);
	}
	goto __finally0;
	__catch0_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = e;
		_tmp51_ = _tmp50_->message;
		g_warning ("game-view.vala:339: Failed to load textures: %s", _tmp51_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		g_warning ("game-view.vala:343: Failed to load textures: %s", _tmp53_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Theme* theme_new (const gchar* name) {
	return theme_construct (TYPE_THEME, name);
}


static void value_theme_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_theme_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		theme_unref (value->data[0].v_pointer);
	}
}


static void value_theme_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = theme_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_theme_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_theme_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Theme* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = theme_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_theme_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Theme** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = theme_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_theme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTheme* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THEME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_theme (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME), NULL);
	return value->data[0].v_pointer;
}


void value_set_theme (GValue* value, gpointer v_object) {
	Theme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		theme_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_unref (old);
	}
}


void value_take_theme (GValue* value, gpointer v_object) {
	Theme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_unref (old);
	}
}


static void theme_class_init (ThemeClass * klass) {
	theme_parent_class = g_type_class_peek_parent (klass);
	THEME_CLASS (klass)->finalize = theme_finalize;
}


static void theme_instance_init (Theme * self) {
	self->ref_count = 1;
}


static void theme_finalize (Theme* obj) {
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->cursor);
}


/**
 *  This class holds the textures for a specific theme. These textures are used for creating light
 *  actors and cursor actor.
 */
GType theme_get_type (void) {
	static volatile gsize theme_type_id__volatile = 0;
	if (g_once_init_enter (&theme_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_theme_init, value_theme_free_value, value_theme_copy_value, value_theme_peek_pointer, "p", value_theme_collect_value, "p", value_theme_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType theme_type_id;
		theme_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Theme", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&theme_type_id__volatile, theme_type_id);
	}
	return theme_type_id__volatile;
}


gpointer theme_ref (gpointer instance) {
	Theme* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void theme_unref (gpointer instance) {
	Theme* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THEME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_ClutterPoint_free (ClutterPoint* self) {
	g_boxed_free (clutter_point_get_type (), self);
}


TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size) {
	TileActor * self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ClutterImage* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	ClutterPoint* _tmp10_ = NULL;
	g_return_val_if_fail (tile != NULL, NULL);
	g_return_val_if_fail (texture != NULL, NULL);
	self = (TileActor*) g_object_new (object_type, NULL);
	_tmp0_ = tile;
	_tmp1_ = _tile_ref0 (_tmp0_);
	_tile_unref0 (self->tile);
	self->tile = _tmp1_;
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
	_tmp2_ = size;
	_tmp3_ = size;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp2_, (gfloat) _tmp3_);
	_tmp4_ = texture;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp4_);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp7_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp10_);
	return self;
}


TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size) {
	return tile_actor_construct (TYPE_TILE_ACTOR, tile, texture, size);
}


static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	tile_actor_hide_tile_cb (self);
}


void tile_actor_animate_out (TileActor* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_LINEAR);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	clutter_actor_set_scale ((ClutterActor*) self, 2.0, 2.0);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _tile_actor_hide_tile_cb_clutter_actor_transitions_completed, self, 0);
}


static void tile_actor_hide_tile_cb (TileActor* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_hide ((ClutterActor*) self);
}


void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous) {
	ClutterAnimationMode _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ClutterAnimationMode anim_mode = 0;
	ClutterAnimationMode _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp1_ = is_zealous;
	if (_tmp1_) {
		_tmp0_ = CLUTTER_EASE_OUT_BOUNCE;
	} else {
		_tmp0_ = CLUTTER_EASE_OUT_QUAD;
	}
	_tmp2_ = _tmp0_;
	anim_mode = _tmp2_;
	clutter_actor_set_easing_mode ((ClutterActor*) self, anim_mode);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	_tmp3_ = new_x;
	_tmp4_ = new_y;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp3_, (gfloat) _tmp4_);
}


static void tile_actor_class_init (TileActorClass * klass) {
	tile_actor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tile_actor_finalize;
}


static void tile_actor_instance_init (TileActor * self) {
}


static void tile_actor_finalize (GObject* obj) {
	TileActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_ACTOR, TileActor);
	_tile_unref0 (self->tile);
	G_OBJECT_CLASS (tile_actor_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a tile. All clutter related stuff goes here
 */
GType tile_actor_get_type (void) {
	static volatile gsize tile_actor_type_id__volatile = 0;
	if (g_once_init_enter (&tile_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileActor), 0, (GInstanceInitFunc) tile_actor_instance_init, NULL };
		GType tile_actor_type_id;
		tile_actor_type_id = g_type_register_static (clutter_actor_get_type (), "TileActor", &g_define_type_info, 0);
		g_once_init_leave (&tile_actor_type_id__volatile, tile_actor_type_id);
	}
	return tile_actor_type_id__volatile;
}


CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size) {
	CursorActor * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	ClutterContent* _tmp2_ = NULL;
	ClutterPoint* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	g_return_val_if_fail (texture != NULL, NULL);
	self = (CursorActor*) g_object_new (object_type, NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
	_tmp0_ = size;
	_tmp1_ = size;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp0_, (gfloat) _tmp1_);
	_tmp2_ = texture;
	clutter_actor_set_content ((ClutterActor*) self, _tmp2_);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp5_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp8_);
	return self;
}


CursorActor* cursor_actor_new (ClutterContent* texture, gint size) {
	return cursor_actor_construct (TYPE_CURSOR_ACTOR, texture, size);
}


static void cursor_actor_class_init (CursorActorClass * klass) {
	cursor_actor_parent_class = g_type_class_peek_parent (klass);
}


static void cursor_actor_instance_init (CursorActor * self) {
}


GType cursor_actor_get_type (void) {
	static volatile gsize cursor_actor_type_id__volatile = 0;
	if (g_once_init_enter (&cursor_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CursorActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cursor_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CursorActor), 0, (GInstanceInitFunc) cursor_actor_instance_init, NULL };
		GType cursor_actor_type_id;
		cursor_actor_type_id = g_type_register_static (clutter_actor_get_type (), "CursorActor", &g_define_type_info, 0);
		g_once_init_leave (&cursor_actor_type_id__volatile, cursor_actor_type_id);
	}
	return cursor_actor_type_id__volatile;
}


ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height) {
	ScoreActor * self = NULL;
	ClutterText* _tmp0_ = NULL;
	ClutterText* _tmp1_ = NULL;
	ClutterColor _tmp2_ = {0};
	ClutterText* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gint _tmp12_ = 0;
	self = (ScoreActor*) g_object_new (object_type, NULL);
	_tmp0_ = (ClutterText*) clutter_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp0_;
	_tmp1_ = self->priv->label;
	clutter_color_from_string (&_tmp2_, "rgba(255, 255, 255, 255)");
	clutter_text_set_color (_tmp1_, &_tmp2_);
	_tmp3_ = self->priv->label;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp3_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp6_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp9_);
	_tmp10_ = width;
	self->priv->scene_width = (gfloat) _tmp10_;
	_tmp11_ = height;
	self->priv->scene_height = (gfloat) _tmp11_;
	_tmp12_ = game_size;
	self->priv->game_size = _tmp12_;
	return self;
}


ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height) {
	return score_actor_construct (TYPE_SCORE_ACTOR, game_size, width, height);
}


static void __lambda2_ (ScoreActor* self) {
	clutter_actor_destroy ((ClutterActor*) self);
}


static void ___lambda2__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	__lambda2_ (self);
}


void score_actor_animate_score (ScoreActor* self, gint points) {
	gint _tmp0_ = 0;
	ClutterText* _tmp1_ = NULL;
	ClutterText* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = points;
	if (_tmp0_ <= 0) {
		return;
	}
	_tmp1_ = self->priv->label;
	clutter_text_set_font_name (_tmp1_, "Bitstrem Vera Sans Bold 30");
	_tmp2_ = self->priv->label;
	_tmp3_ = points;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("+", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	clutter_text_set_text (_tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_set_z_position ((ClutterActor*) self, 0.f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_SINE);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 600);
	clutter_actor_set_z_position ((ClutterActor*) self, 500.f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) ___lambda2__clutter_actor_transitions_completed, self, 0);
}


void score_actor_animate_final_score (ScoreActor* self, guint points) {
	ClutterText* _tmp0_ = NULL;
	gchar* points_label = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	ClutterText* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ClutterText* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label;
	clutter_text_set_font_name (_tmp0_, "Bitstrem Vera Sans 40");
	_tmp1_ = points;
	_tmp2_ = ngettext ("%u point", "%u points", (gulong) _tmp1_);
	_tmp3_ = points;
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
	points_label = _tmp4_;
	_tmp5_ = self->priv->label;
	_tmp6_ = _ ("Game Over!");
	_tmp7_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp6_, points_label);
	_tmp8_ = _tmp7_;
	clutter_text_set_markup (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->label;
	clutter_text_set_line_alignment (_tmp9_, PANGO_ALIGN_CENTER);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	_tmp10_ = self->priv->game_size;
	clutter_actor_set_z_position ((ClutterActor*) self, (-300.f) + (_tmp10_ * 100));
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_ELASTIC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 2000);
	_tmp11_ = self->priv->game_size;
	clutter_actor_set_z_position ((ClutterActor*) self, (gfloat) ((-200) + (_tmp11_ * 150)));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
	_g_free0 (points_label);
}


static void score_actor_class_init (ScoreActorClass * klass) {
	score_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreActorPrivate));
	G_OBJECT_CLASS (klass)->finalize = score_actor_finalize;
}


static void score_actor_instance_init (ScoreActor * self) {
	self->priv = SCORE_ACTOR_GET_PRIVATE (self);
}


static void score_actor_finalize (GObject* obj) {
	ScoreActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_ACTOR, ScoreActor);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (score_actor_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a score. All clutter related stuff goes here
 */
GType score_actor_get_type (void) {
	static volatile gsize score_actor_type_id__volatile = 0;
	if (g_once_init_enter (&score_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreActor), 0, (GInstanceInitFunc) score_actor_instance_init, NULL };
		GType score_actor_type_id;
		score_actor_type_id = g_type_register_static (clutter_group_get_type (), "ScoreActor", &g_define_type_info, 0);
		g_once_init_leave (&score_actor_type_id__volatile, score_actor_type_id);
	}
	return score_actor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



