/* minefield-view.c generated by valac 0.25.1.19-7bfa2, the Vala compiler
 * generated from minefield-view.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define TYPE_POSITION (position_get_type ())
#define POSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITION, Position))
#define POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSITION, PositionClass))
#define IS_POSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITION))
#define IS_POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSITION))
#define POSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSITION, PositionClass))

typedef struct _Position Position;
typedef struct _PositionClass PositionClass;
typedef struct _PositionPrivate PositionPrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Position {
	GObject parent_instance;
	PositionPrivate * priv;
};

struct _PositionClass {
	GObjectClass parent_class;
};

struct _PositionPrivate {
	gboolean _is_set;
	gint _x;
	gint _y;
};

struct _Tile {
	GtkButton parent_instance;
	TilePrivate * priv;
};

struct _TileClass {
	GtkButtonClass parent_class;
};

struct _TilePrivate {
	gint _row;
	gint _column;
	GtkImage* scaling_image;
};

struct _Block1Data {
	int _ref_count_;
	Tile* self;
	gint prow;
	gint pcol;
};

struct _MinefieldView {
	GtkGrid parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkGridClass parent_class;
};

struct _MinefieldViewPrivate {
	GSettings* settings;
	Position* keyboard_cursor;
	Position* selected;
	Tile** mines;
	gint mines_length1;
	gint mines_length2;
	Minefield* _minefield;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer position_parent_class = NULL;
static gpointer tile_parent_class = NULL;
static gchar** tile_IMAGE_CLASSES;
static gint tile_IMAGE_CLASSES_length1;
static gchar** tile_IMAGE_CLASSES = NULL;
static gint tile_IMAGE_CLASSES_length1 = 0;
static gint _tile_IMAGE_CLASSES_size_ = 0;
static gpointer minefield_view_parent_class = NULL;

GType position_get_type (void) G_GNUC_CONST;
#define POSITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POSITION, PositionPrivate))
enum  {
	POSITION_DUMMY_PROPERTY,
	POSITION_IS_SET,
	POSITION_IS_VALID,
	POSITION_X,
	POSITION_Y
};
Position* position_new (void);
Position* position_construct (GType object_type);
gboolean position_get_is_set (Position* self);
void position_set_is_set (Position* self, gboolean value);
gboolean position_get_is_valid (Position* self);
gint position_get_x (Position* self);
gint position_get_y (Position* self);
void position_set_x (Position* self, gint value);
void position_set_y (Position* self, gint value);
void position_set_position (Position* self, gint* value, int value_length1);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void position_finalize (GObject* obj);
static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tile_get_type (void) G_GNUC_CONST;
#define TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TILE, TilePrivate))
enum  {
	TILE_DUMMY_PROPERTY,
	TILE_ROW,
	TILE_COLUMN
};
Tile* tile_new (gint prow, gint pcol);
Tile* tile_construct (GType object_type, gint prow, gint pcol);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void tile_add_class (Tile* self, const gchar* style_class);
static gboolean __lambda4_ (Block1Data* _data1_, GdkEventCrossing* event);
static gboolean ___lambda4__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void __lambda5_ (Tile* self, GtkAllocation* allocation);
static void ___lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean __lambda6_ (Block1Data* _data1_, GdkEventButton* event);
static gboolean ___lambda6__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda7_ (Block1Data* _data1_, GdkEventButton* event);
static gboolean ___lambda7__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void tile_remove_class (Tile* self, const gchar* style_class);
gint tile_get_row (Tile* self);
gint tile_get_column (Tile* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tile_finalize (GObject* obj);
static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType minefield_view_get_type (void) G_GNUC_CONST;
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (GSettings* settings);
MinefieldView* minefield_view_construct (GType object_type, GSettings* settings);
static gint __lambda8_ (MinefieldView* self, gint x);
static gint ___lambda8__position_set_x (Position* _sender, gint x, gpointer self);
static gint __lambda9_ (MinefieldView* self, gint y);
static gint ___lambda9__position_set_y (Position* _sender, gint y, gpointer self);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self);
static gboolean __lambda18_ (MinefieldView* self, gint x, gint y);
static gboolean ___lambda18__position_validate (Position* _sender, gint x, gint y, gpointer self);
void minefield_view_tile_mouse_over_cb (MinefieldView* self, gint x, gint y);
Minefield* minefield_view_get_minefield (MinefieldView* self);
gboolean minefield_get_is_complete (Minefield* self);
gboolean minefield_get_paused (Minefield* self);
void minefield_view_tile_pressed_cb (MinefieldView* self, gint x, gint y, GdkEventButton* event);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
void minefield_view_tile_released_cb (MinefieldView* self, gint x, gint y, GdkEventButton* event);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
static void minefield_view_complete_cb (MinefieldView* self, Minefield* minefield);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
void minefield_view_add (MinefieldView* self, GtkWidget* child, gint i, gint j);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
static gboolean minefield_view_get_use_overmine_warning (MinefieldView* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
static gboolean minefield_view_get_use_question_marks (MinefieldView* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static gboolean minefield_view_get_use_autoflag (MinefieldView* self);
static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event);
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
static guint minefield_view_get_mine_size (MinefieldView* self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_minefield___lambda10_ (MinefieldView* self, GtkWidget* child);
static void __minefield_view_minefield___lambda10__gtk_callback (GtkWidget* widget, gpointer self);
static void _minefield_view_minefield_________lambda11_ (MinefieldView* self, gint x, gint y);
static void __minefield_view_minefield_________lambda11__tile_tile_mouse_over (Tile* _sender, gint x, gint y, gpointer self);
static void _minefield_view_minefield_________lambda12_ (MinefieldView* self, gint x, gint y, GdkEventButton* event);
static void __minefield_view_minefield_________lambda12__tile_tile_pressed (Tile* _sender, gint x, gint y, GdkEventButton* event, gpointer self);
static void _minefield_view_minefield_________lambda13_ (MinefieldView* self, gint x, gint y, GdkEventButton* event);
static void __minefield_view_minefield_________lambda13__tile_tile_released (Tile* _sender, gint x, gint y, GdkEventButton* event, gpointer self);
static void _minefield_view_minefield___lambda14_ (MinefieldView* self, guint x, guint y);
static void __minefield_view_minefield___lambda14__position_redraw (Position* _sender, guint x, guint y, gpointer self);
static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self);
static gint _minefield_view_minefield___lambda15_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda15__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda16_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda16__position_set_y (Position* _sender, gint y, gpointer self);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void _minefield_view_minefield___lambda17_ (MinefieldView* self);
static void __minefield_view_minefield___lambda17__minefield_paused_changed (Minefield* _sender, gpointer self);
static void _minefield_view_complete_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

Position* position_construct (GType object_type) {
	Position * self = NULL;
	self = (Position*) g_object_new (object_type, NULL);
	return self;
}


Position* position_new (void) {
	return position_construct (TYPE_POSITION);
}


gboolean position_get_is_set (Position* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_set;
	result = _tmp0_;
	return result;
}


void position_set_is_set (Position* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_set;
	_tmp2_ = value;
	if (_tmp1_ != _tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = position_get_is_valid (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp5_ = position_get_x (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = position_get_y (self);
		_tmp8_ = _tmp7_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp6_, (guint) _tmp8_);
	}
	_tmp9_ = value;
	self->priv->_is_set = _tmp9_;
	g_object_notify ((GObject *) self, "is-set");
}


gboolean position_get_is_valid (Position* self) {
	gboolean result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = position_get_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = position_get_y (self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "validate", _tmp1_, _tmp3_, &_tmp4_);
	result = _tmp4_;
	return result;
}


gint position_get_x (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_x;
	result = _tmp0_;
	return result;
}


void position_set_x (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_x;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = position_get_x (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = position_get_y (self);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp8_, (guint) _tmp10_);
	}
	_tmp11_ = value;
	g_signal_emit_by_name (self, "set-x", _tmp11_, &_tmp12_);
	self->priv->_x = _tmp12_;
	_tmp14_ = position_get_is_set (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = position_get_is_valid (self);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp18_ = position_get_x (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = position_get_y (self);
		_tmp21_ = _tmp20_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp19_, (guint) _tmp21_);
	}
	g_object_notify ((GObject *) self, "x");
}


gint position_get_y (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_y;
	result = _tmp0_;
	return result;
}


void position_set_y (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_y;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = position_get_x (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = position_get_y (self);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp8_, (guint) _tmp10_);
	}
	_tmp11_ = value;
	g_signal_emit_by_name (self, "set-y", _tmp11_, &_tmp12_);
	self->priv->_y = _tmp12_;
	_tmp14_ = position_get_is_set (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = position_get_is_valid (self);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp18_ = position_get_x (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = position_get_y (self);
		_tmp21_ = _tmp20_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp19_, (guint) _tmp21_);
	}
	g_object_notify ((GObject *) self, "y");
}


void position_set_position (Position* self, gint* value, int value_length1) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_x;
	_tmp2_ = value;
	_tmp2__length1 = value_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ == _tmp3_) {
		gint _tmp4_ = 0;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->_y;
		_tmp5_ = value;
		_tmp5__length1 = value_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp8_ = position_get_is_set (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = position_get_is_valid (self);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp12_ = position_get_x (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = position_get_y (self);
		_tmp15_ = _tmp14_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp13_, (guint) _tmp15_);
	}
	_tmp16_ = value;
	_tmp16__length1 = value_length1;
	_tmp17_ = _tmp16_[0];
	g_signal_emit_by_name (self, "set-x", _tmp17_, &_tmp18_);
	self->priv->_x = _tmp18_;
	_tmp19_ = value;
	_tmp19__length1 = value_length1;
	_tmp20_ = _tmp19_[1];
	g_signal_emit_by_name (self, "set-y", _tmp20_, &_tmp21_);
	self->priv->_y = _tmp21_;
	_tmp23_ = position_get_is_set (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		_tmp25_ = position_get_is_valid (self);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp27_ = position_get_x (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = position_get_y (self);
		_tmp30_ = _tmp29_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp28_, (guint) _tmp30_);
	}
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_INT__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_INT__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_int (return_value, v_return);
}


static void position_class_init (PositionClass * klass) {
	position_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PositionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_position_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_position_set_property;
	G_OBJECT_CLASS (klass)->finalize = position_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_SET, g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_X, g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_Y, g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("redraw", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("validate", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_INT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("set_x", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
	g_signal_new ("set_y", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
}


static void position_instance_init (Position * self) {
	self->priv = POSITION_GET_PRIVATE (self);
	self->priv->_is_set = FALSE;
	self->priv->_x = 0;
	self->priv->_y = 0;
}


static void position_finalize (GObject* obj) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSITION, Position);
	G_OBJECT_CLASS (position_parent_class)->finalize (obj);
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) position_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Position), 0, (GInstanceInitFunc) position_instance_init, NULL };
		GType position_type_id;
		position_type_id = g_type_register_static (G_TYPE_OBJECT, "Position", &g_define_type_info, 0);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		g_value_set_boolean (value, position_get_is_set (self));
		break;
		case POSITION_IS_VALID:
		g_value_set_boolean (value, position_get_is_valid (self));
		break;
		case POSITION_X:
		g_value_set_int (value, position_get_x (self));
		break;
		case POSITION_Y:
		g_value_set_int (value, position_get_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		position_set_is_set (self, g_value_get_boolean (value));
		break;
		case POSITION_X:
		position_set_x (self, g_value_get_int (value));
		break;
		case POSITION_Y:
		position_set_y (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Tile* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda4_ (Block1Data* _data1_, GdkEventCrossing* event) {
	Tile* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data1_->prow;
	_tmp1_ = _data1_->pcol;
	g_signal_emit_by_name (self, "tile-mouse-over", _tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, event);
	return result;
}


static void __lambda5_ (Tile* self, GtkAllocation* allocation) {
	GtkImage* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->scaling_image;
	_tmp1_ = *allocation;
	_tmp2_ = _tmp1_.height;
	gtk_image_set_pixel_size (_tmp0_, (_tmp2_ / 3) * 2);
}


static void ___lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda5_ ((Tile*) self, allocation);
}


static gboolean __lambda6_ (Block1Data* _data1_, GdkEventButton* event) {
	Tile* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkEventButton* _tmp2_ = NULL;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data1_->prow;
	_tmp1_ = _data1_->pcol;
	_tmp2_ = event;
	g_signal_emit_by_name (self, "tile-pressed", _tmp0_, _tmp1_, _tmp2_);
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda6_ (self, event);
	return result;
}


static gboolean __lambda7_ (Block1Data* _data1_, GdkEventButton* event) {
	Tile* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkEventButton* _tmp2_ = NULL;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data1_->prow;
	_tmp1_ = _data1_->pcol;
	_tmp2_ = event;
	g_signal_emit_by_name (self, "tile-released", _tmp0_, _tmp1_, _tmp2_);
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda7_ (self, event);
	return result;
}


Tile* tile_construct (GType object_type, gint prow, gint pcol) {
	Tile * self = NULL;
	Block1Data* _data1_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = prow;
	_data1_->prow = _tmp0_;
	_tmp1_ = pcol;
	_data1_->pcol = _tmp1_;
	self = (Tile*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp2_ = _data1_->prow;
	self->priv->_row = _tmp2_;
	_tmp3_ = _data1_->pcol;
	self->priv->_column = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->scaling_image);
	self->priv->scaling_image = _tmp4_;
	g_object_set ((GtkWidget*) self, "can-focus", FALSE, NULL);
	tile_add_class (self, "tile");
	_tmp5_ = self->priv->scaling_image;
	gtk_button_set_image ((GtkButton*) self, (GtkWidget*) _tmp5_);
	g_signal_connect_data ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda4__gtk_widget_enter_notify_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) ___lambda5__gtk_widget_size_allocate, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda6__gtk_widget_button_press_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda7__gtk_widget_button_release_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


Tile* tile_new (gint prow, gint pcol) {
	return tile_construct (TYPE_TILE, prow, pcol);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void tile_add_class (Tile* self, const gchar* style_class) {
	GtkStyleContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style_class != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = style_class;
	gtk_style_context_add_class (_tmp0_, _tmp1_);
	_tmp2_ = style_class;
	_tmp3_ = tile_IMAGE_CLASSES;
	_tmp3__length1 = tile_IMAGE_CLASSES_length1;
	if (_vala_string_array_contains (_tmp3_, _tmp3__length1, _tmp2_)) {
		GtkImage* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkImage* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp4_ = self->priv->scaling_image;
		_tmp5_ = style_class;
		gtk_image_set_from_icon_name (_tmp4_, _tmp5_, GTK_ICON_SIZE_DND);
		_tmp6_ = self->priv->scaling_image;
		_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		gtk_image_set_pixel_size (_tmp6_, (_tmp7_ / 3) * 2);
	}
}


void tile_remove_class (Tile* self, const gchar* style_class) {
	GtkStyleContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style_class != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = style_class;
	gtk_style_context_remove_class (_tmp0_, _tmp1_);
	_tmp2_ = style_class;
	_tmp3_ = tile_IMAGE_CLASSES;
	_tmp3__length1 = tile_IMAGE_CLASSES_length1;
	if (_vala_string_array_contains (_tmp3_, _tmp3__length1, _tmp2_)) {
		GtkImage* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		_tmp4_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->scaling_image);
		self->priv->scaling_image = _tmp4_;
		_tmp5_ = self->priv->scaling_image;
		gtk_button_set_image ((GtkButton*) self, (GtkWidget*) _tmp5_);
	}
}


gint tile_get_row (Tile* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_row;
	result = _tmp0_;
	return result;
}


gint tile_get_column (Tile* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_column;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__INT_INT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_BOXED) (gpointer data1, gint arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}


static void tile_class_init (TileClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tile_get_property;
	G_OBJECT_CLASS (klass)->finalize = tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_ROW, g_param_spec_int ("row", "row", "row", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_COLUMN, g_param_spec_int ("column", "column", "column", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("tile_mouse_over", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("tile_pressed", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_BOXED, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, gdk_event_get_type ());
	g_signal_new ("tile_released", TYPE_TILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_BOXED, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, gdk_event_get_type ());
	_tmp0_ = g_strdup ("mine");
	_tmp1_ = g_strdup ("flag");
	_tmp2_ = g_strdup ("maybe");
	_tmp3_ = g_strdup ("overmine");
	_tmp4_ = g_strdup ("exploded");
	_tmp5_ = g_strdup ("1mines");
	_tmp6_ = g_strdup ("2mines");
	_tmp7_ = g_strdup ("3mines");
	_tmp8_ = g_strdup ("4mines");
	_tmp9_ = g_strdup ("5mines");
	_tmp10_ = g_strdup ("6mines");
	_tmp11_ = g_strdup ("7mines");
	_tmp12_ = g_strdup ("8mines");
	_tmp13_ = g_new0 (gchar*, 13 + 1);
	_tmp13_[0] = _tmp0_;
	_tmp13_[1] = _tmp1_;
	_tmp13_[2] = _tmp2_;
	_tmp13_[3] = _tmp3_;
	_tmp13_[4] = _tmp4_;
	_tmp13_[5] = _tmp5_;
	_tmp13_[6] = _tmp6_;
	_tmp13_[7] = _tmp7_;
	_tmp13_[8] = _tmp8_;
	_tmp13_[9] = _tmp9_;
	_tmp13_[10] = _tmp10_;
	_tmp13_[11] = _tmp11_;
	_tmp13_[12] = _tmp12_;
	tile_IMAGE_CLASSES = _tmp13_;
	tile_IMAGE_CLASSES_length1 = 13;
}


static void tile_instance_init (Tile * self) {
	self->priv = TILE_GET_PRIVATE (self);
}


static void tile_finalize (GObject* obj) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
	_g_object_unref0 (self->priv->scaling_image);
	G_OBJECT_CLASS (tile_parent_class)->finalize (obj);
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, NULL };
		GType tile_type_id;
		tile_type_id = g_type_register_static (GTK_TYPE_BUTTON, "Tile", &g_define_type_info, 0);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE, Tile);
	switch (property_id) {
		case TILE_ROW:
		g_value_set_int (value, tile_get_row (self));
		break;
		case TILE_COLUMN:
		g_value_set_int (value, tile_get_column (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint __lambda8_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = x;
	result = _tmp0_;
	return result;
}


static gint ___lambda8__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = __lambda8_ ((MinefieldView*) self, x);
	return result;
}


static gint __lambda9_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = y;
	result = _tmp0_;
	return result;
}


static gint ___lambda9__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = __lambda9_ ((MinefieldView*) self, y);
	return result;
}


static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}


static gboolean __lambda18_ (MinefieldView* self, gint x, gint y) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean ___lambda18__position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = __lambda18_ ((MinefieldView*) self, x, y);
	return result;
}


MinefieldView* minefield_view_construct (GType object_type, GSettings* settings) {
	MinefieldView * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	Position* _tmp3_ = NULL;
	Position* _tmp4_ = NULL;
	Position* _tmp5_ = NULL;
	Position* _tmp6_ = NULL;
	Position* _tmp7_ = NULL;
	Position* _tmp8_ = NULL;
	Position* _tmp9_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (MinefieldView*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_grid_set_row_homogeneous ((GtkGrid*) self, TRUE);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 4);
	gtk_grid_set_column_homogeneous ((GtkGrid*) self, TRUE);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 4);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "minefield");
	_tmp3_ = position_new ();
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp3_;
	_tmp4_ = self->priv->selected;
	g_signal_connect_object (_tmp4_, "set-x", (GCallback) ___lambda8__position_set_x, self, 0);
	_tmp5_ = self->priv->selected;
	g_signal_connect_object (_tmp5_, "set-y", (GCallback) ___lambda9__position_set_y, self, 0);
	_tmp6_ = self->priv->selected;
	g_signal_connect_object (_tmp6_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp7_ = position_new ();
	_g_object_unref0 (self->priv->keyboard_cursor);
	self->priv->keyboard_cursor = _tmp7_;
	_tmp8_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp8_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp9_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp9_, "validate", (GCallback) ___lambda18__position_validate, self, 0);
	return self;
}


MinefieldView* minefield_view_new (GSettings* settings) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW, settings);
}


void minefield_view_tile_mouse_over_cb (MinefieldView* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Position* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	Position* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp9_ = NULL;
		Minefield* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = minefield_view_get_minefield (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = minefield_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp14_ = self->priv->selected;
	_tmp15_ = position_get_is_set (_tmp14_);
	_tmp16_ = _tmp15_;
	if (!_tmp16_) {
		_tmp13_ = TRUE;
	} else {
		Position* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->keyboard_cursor;
		_tmp18_ = position_get_is_set (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_;
	}
	if (_tmp13_) {
		return;
	}
	_tmp20_ = self->priv->selected;
	_tmp21_ = x;
	_tmp22_ = y;
	_tmp23_ = g_new0 (gint, 2);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	position_set_position (_tmp20_, _tmp24_, 2);
	_tmp24_ = (g_free (_tmp24_), NULL);
}


void minefield_view_tile_pressed_cb (MinefieldView* self, gint x, gint y, GdkEventButton* event) {
	GdkEventButton* _tmp0_ = NULL;
	GdkEventType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Position* _tmp22_ = NULL;
	Position* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint* _tmp26_ = NULL;
	gint* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	Position* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	GdkEventButton* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	Position* _tmp48_ = NULL;
	Tile** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gint _tmp49__length2 = 0;
	Position* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	Position* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	Tile* _tmp56_ = NULL;
	Position* _tmp57_ = NULL;
	Position* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	Position* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint* _tmp64_ = NULL;
	gint* _tmp65_ = NULL;
	gint _tmp65__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		return;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		return;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		return;
	}
	_tmp22_ = self->priv->selected;
	position_set_is_set (_tmp22_, FALSE);
	_tmp23_ = self->priv->selected;
	_tmp24_ = x;
	_tmp25_ = y;
	_tmp26_ = g_new0 (gint, 2);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	position_set_position (_tmp23_, _tmp27_, 2);
	_tmp27_ = (g_free (_tmp27_), NULL);
	_tmp28_ = self->priv->selected;
	_tmp29_ = position_get_is_valid (_tmp28_);
	_tmp30_ = _tmp29_;
	if (!_tmp30_) {
		return;
	}
	_tmp32_ = event;
	_tmp33_ = _tmp32_->button;
	if (_tmp33_ == ((guint) 3)) {
		_tmp31_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		GdkEventButton* _tmp35_ = NULL;
		guint _tmp36_ = 0U;
		_tmp35_ = event;
		_tmp36_ = _tmp35_->button;
		if (_tmp36_ == ((guint) 1)) {
			GdkEventButton* _tmp37_ = NULL;
			GdkModifierType _tmp38_ = 0;
			_tmp37_ = event;
			_tmp38_ = _tmp37_->state;
			_tmp34_ = (_tmp38_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp31_ = _tmp34_;
	}
	if (_tmp31_) {
		Position* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		Position* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		_tmp39_ = self->priv->selected;
		_tmp40_ = position_get_x (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = self->priv->selected;
		_tmp43_ = position_get_y (_tmp42_);
		_tmp44_ = _tmp43_;
		minefield_view_toggle_mark (self, (guint) _tmp41_, (guint) _tmp44_);
		g_signal_emit_by_name (self, "unlook");
	} else {
		GdkEventButton* _tmp45_ = NULL;
		guint _tmp46_ = 0U;
		_tmp45_ = event;
		_tmp46_ = _tmp45_->button;
		if (_tmp46_ == ((guint) 1)) {
			Position* _tmp47_ = NULL;
			_tmp47_ = self->priv->selected;
			position_set_is_set (_tmp47_, TRUE);
			g_signal_emit_by_name (self, "look");
		}
	}
	_tmp48_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp48_, FALSE);
	_tmp49_ = self->priv->mines;
	_tmp49__length1 = self->priv->mines_length1;
	_tmp49__length2 = self->priv->mines_length2;
	_tmp50_ = self->priv->keyboard_cursor;
	_tmp51_ = position_get_x (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = self->priv->keyboard_cursor;
	_tmp54_ = position_get_y (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp49_[(_tmp52_ * _tmp49__length2) + _tmp55_];
	tile_remove_class (_tmp56_, "cursor");
	_tmp57_ = self->priv->keyboard_cursor;
	_tmp58_ = self->priv->selected;
	_tmp59_ = position_get_x (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = self->priv->selected;
	_tmp62_ = position_get_y (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_new0 (gint, 2);
	_tmp64_[0] = _tmp60_;
	_tmp64_[1] = _tmp63_;
	_tmp65_ = _tmp64_;
	_tmp65__length1 = 2;
	position_set_position (_tmp57_, _tmp65_, 2);
	_tmp65_ = (g_free (_tmp65_), NULL);
}


void minefield_view_tile_released_cb (MinefieldView* self, gint x, gint y, GdkEventButton* event) {
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Minefield* _tmp22_ = NULL;
	Minefield* _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	Minefield* _tmp31_ = NULL;
	Minefield* _tmp32_ = NULL;
	Position* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	Position* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	Position* _tmp69_ = NULL;
	Position* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	Position* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint* _tmp76_ = NULL;
	gint* _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
	Position* _tmp78_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		return;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		return;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	}
	if (_tmp15_) {
		return;
	}
	_tmp22_ = minefield_view_get_minefield (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected;
	_tmp25_ = position_get_x (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_y (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = minefield_is_location (_tmp23_, _tmp26_, _tmp29_);
	if (!_tmp30_) {
		return;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp31_ = minefield_view_get_minefield (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->selected;
	_tmp34_ = position_get_x (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->selected;
	_tmp37_ = position_get_y (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = minefield_is_cleared (_tmp32_, (guint) _tmp35_, (guint) _tmp38_);
	if (_tmp39_) {
		Position* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		Position* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		Position* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Position* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_x (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_y (_tmp43_);
		_tmp45_ = _tmp44_;
		minefield_view_multi_release (self, (guint) _tmp42_, (guint) _tmp45_);
		_tmp46_ = self->priv->selected;
		_tmp47_ = position_get_x (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = self->priv->selected;
		_tmp50_ = position_get_y (_tmp49_);
		_tmp51_ = _tmp50_;
		minefield_view_redraw_adjacent (self, (guint) _tmp48_, (guint) _tmp51_);
	} else {
		Minefield* _tmp52_ = NULL;
		Minefield* _tmp53_ = NULL;
		Position* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		Position* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		FlagType _tmp60_ = 0;
		_tmp52_ = minefield_view_get_minefield (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = self->priv->selected;
		_tmp55_ = position_get_x (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = self->priv->selected;
		_tmp58_ = position_get_y (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = minefield_get_flag (_tmp53_, (guint) _tmp56_, (guint) _tmp59_);
		if (_tmp60_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp61_ = NULL;
			Minefield* _tmp62_ = NULL;
			Position* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			Position* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			_tmp61_ = minefield_view_get_minefield (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = self->priv->selected;
			_tmp64_ = position_get_x (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->priv->selected;
			_tmp67_ = position_get_y (_tmp66_);
			_tmp68_ = _tmp67_;
			minefield_clear_mine (_tmp62_, (guint) _tmp65_, (guint) _tmp68_);
		}
	}
	_tmp69_ = self->priv->keyboard_cursor;
	_tmp70_ = self->priv->selected;
	_tmp71_ = position_get_x (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = self->priv->selected;
	_tmp74_ = position_get_y (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_new0 (gint, 2);
	_tmp76_[0] = _tmp72_;
	_tmp76_[1] = _tmp75_;
	_tmp77_ = _tmp76_;
	_tmp77__length1 = 2;
	position_set_position (_tmp69_, _tmp77_, 2);
	_tmp77_ = (g_free (_tmp77_), NULL);
	_tmp78_ = self->priv->selected;
	position_set_is_set (_tmp78_, FALSE);
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	GtkStyleContext* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "explodedField");
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				Minefield* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = minefield;
				_tmp5_ = _tmp4_->width;
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_ = 0;
							Minefield* _tmp9_ = NULL;
							guint _tmp10_ = 0U;
							gboolean _tmp11_ = FALSE;
							Minefield* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gboolean _tmp15_ = FALSE;
							if (!_tmp6_) {
								gint _tmp7_ = 0;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = y;
							_tmp9_ = minefield;
							_tmp10_ = _tmp9_->height;
							if (!(((guint) _tmp8_) < _tmp10_)) {
								break;
							}
							_tmp12_ = minefield;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = minefield_has_mine (_tmp12_, (guint) _tmp13_, (guint) _tmp14_);
							if (_tmp15_) {
								_tmp11_ = TRUE;
							} else {
								gboolean _tmp16_ = FALSE;
								Minefield* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gboolean _tmp20_ = FALSE;
								_tmp17_ = minefield;
								_tmp18_ = x;
								_tmp19_ = y;
								_tmp20_ = minefield_has_mine (_tmp17_, (guint) _tmp18_, (guint) _tmp19_);
								if (!_tmp20_) {
									Minefield* _tmp21_ = NULL;
									gint _tmp22_ = 0;
									gint _tmp23_ = 0;
									FlagType _tmp24_ = 0;
									_tmp21_ = minefield;
									_tmp22_ = x;
									_tmp23_ = y;
									_tmp24_ = minefield_get_flag (_tmp21_, (guint) _tmp22_, (guint) _tmp23_);
									_tmp16_ = _tmp24_ == FLAG_TYPE_FLAG;
								} else {
									_tmp16_ = FALSE;
								}
								_tmp11_ = _tmp16_;
							}
							if (_tmp11_) {
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								_tmp25_ = x;
								_tmp26_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp25_, (guint) _tmp26_);
							}
						}
					}
				}
			}
		}
	}
}


static void minefield_view_complete_cb (MinefieldView* self, Minefield* minefield) {
	GtkStyleContext* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "completedField");
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	self = (MinefieldView*) base;
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		Minefield* _tmp3_ = NULL;
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		_tmp3_ = minefield_view_get_minefield (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->width;
		_tmp6_ = minefield_view_get_minimum_size (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = (gint) (_tmp5_ * _tmp7_);
	} else {
		_tmp0_ = 0;
	}
	_vala_natural = _tmp0_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	self = (MinefieldView*) base;
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		Minefield* _tmp3_ = NULL;
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		_tmp3_ = minefield_view_get_minefield (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->height;
		_tmp6_ = minefield_view_get_minimum_size (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = (gint) (_tmp5_ * _tmp7_);
	} else {
		_tmp0_ = 0;
	}
	_vala_natural = _tmp0_;
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


void minefield_view_add (MinefieldView* self, GtkWidget* child, gint i, gint j) {
	GtkWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkWidget* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	_tmp1_ = i;
	_tmp2_ = j;
	gtk_grid_attach ((GtkGrid*) self, _tmp0_, _tmp1_ - 1, _tmp2_ - 1, 1, 1);
	_tmp3_ = child;
	g_object_set (_tmp3_, "expand", TRUE, NULL);
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	gboolean is_down = FALSE;
	gboolean _tmp0_ = FALSE;
	Position* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp59_ = NULL;
	Minefield* _tmp60_ = NULL;
	guint _tmp61_ = 0U;
	guint _tmp62_ = 0U;
	gboolean _tmp63_ = FALSE;
	g_return_if_fail (self != NULL);
	is_down = FALSE;
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Position* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->selected;
		_tmp5_ = position_get_is_set (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		guint _tmp9_ = 0U;
		Position* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp9_ = x;
		_tmp10_ = self->priv->selected;
		_tmp11_ = position_get_x (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp9_ == ((guint) _tmp12_)) {
			guint _tmp13_ = 0U;
			Position* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_tmp13_ = y;
			_tmp14_ = self->priv->selected;
			_tmp15_ = position_get_y (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp8_ = _tmp13_ == ((guint) _tmp16_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Minefield* _tmp17_ = NULL;
			Minefield* _tmp18_ = NULL;
			guint _tmp19_ = 0U;
			guint _tmp20_ = 0U;
			FlagType _tmp21_ = 0;
			_tmp17_ = minefield_view_get_minefield (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = x;
			_tmp20_ = y;
			_tmp21_ = minefield_get_flag (_tmp18_, _tmp19_, _tmp20_);
			_tmp7_ = _tmp21_ != FLAG_TYPE_FLAG;
		} else {
			_tmp7_ = FALSE;
		}
		is_down = _tmp7_;
		_tmp23_ = is_down;
		if (!_tmp23_) {
			Minefield* _tmp24_ = NULL;
			Minefield* _tmp25_ = NULL;
			Position* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Position* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gboolean _tmp32_ = FALSE;
			_tmp24_ = minefield_view_get_minefield (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->selected;
			_tmp27_ = position_get_x (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = self->priv->selected;
			_tmp30_ = position_get_y (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = minefield_is_cleared (_tmp25_, (guint) _tmp28_, (guint) _tmp31_);
			_tmp22_ = _tmp32_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			{
				Neighbour* neighbour_collection = NULL;
				gint neighbour_collection_length1 = 0;
				gint _neighbour_collection_size_ = 0;
				gint neighbour_it = 0;
				neighbour_collection = neighbour_map;
				neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
				for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
					Neighbour neighbour = {0};
					neighbour = neighbour_collection[neighbour_it];
					{
						gint nx = 0;
						Position* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						Neighbour _tmp36_ = {0};
						gint _tmp37_ = 0;
						gint ny = 0;
						Position* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						Neighbour _tmp41_ = {0};
						gint _tmp42_ = 0;
						Minefield* _tmp43_ = NULL;
						Minefield* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_ = FALSE;
						gboolean _tmp49_ = FALSE;
						guint _tmp50_ = 0U;
						gint _tmp51_ = 0;
						_tmp33_ = self->priv->selected;
						_tmp34_ = position_get_x (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = neighbour;
						_tmp37_ = _tmp36_.x;
						nx = ((gint) _tmp35_) + _tmp37_;
						_tmp38_ = self->priv->selected;
						_tmp39_ = position_get_y (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = neighbour;
						_tmp42_ = _tmp41_.y;
						ny = ((gint) _tmp40_) + _tmp42_;
						_tmp43_ = minefield_view_get_minefield (self);
						_tmp44_ = _tmp43_;
						_tmp45_ = nx;
						_tmp46_ = ny;
						_tmp47_ = minefield_is_location (_tmp44_, _tmp45_, _tmp46_);
						if (!_tmp47_) {
							continue;
						}
						_tmp50_ = x;
						_tmp51_ = nx;
						if (_tmp50_ == ((guint) _tmp51_)) {
							guint _tmp52_ = 0U;
							gint _tmp53_ = 0;
							_tmp52_ = y;
							_tmp53_ = ny;
							_tmp49_ = _tmp52_ == ((guint) _tmp53_);
						} else {
							_tmp49_ = FALSE;
						}
						if (_tmp49_) {
							Minefield* _tmp54_ = NULL;
							Minefield* _tmp55_ = NULL;
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							FlagType _tmp58_ = 0;
							_tmp54_ = minefield_view_get_minefield (self);
							_tmp55_ = _tmp54_;
							_tmp56_ = nx;
							_tmp57_ = ny;
							_tmp58_ = minefield_get_flag (_tmp55_, (guint) _tmp56_, (guint) _tmp57_);
							_tmp48_ = _tmp58_ != FLAG_TYPE_FLAG;
						} else {
							_tmp48_ = FALSE;
						}
						if (_tmp48_) {
							is_down = TRUE;
						}
					}
				}
			}
		}
	}
	_tmp59_ = minefield_view_get_minefield (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = x;
	_tmp62_ = y;
	_tmp63_ = minefield_is_cleared (_tmp60_, _tmp61_, _tmp62_);
	if (_tmp63_) {
		Minefield* _tmp64_ = NULL;
		Minefield* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		Minefield* _tmp68_ = NULL;
		Minefield* _tmp69_ = NULL;
		guint _tmp70_ = 0U;
		guint _tmp71_ = 0U;
		gboolean _tmp72_ = FALSE;
		_tmp64_ = minefield_view_get_minefield (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = minefield_get_paused (_tmp65_);
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			return;
		}
		_tmp68_ = minefield_view_get_minefield (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = x;
		_tmp71_ = y;
		_tmp72_ = minefield_has_mine (_tmp69_, _tmp70_, _tmp71_);
		if (_tmp72_) {
			Tile** _tmp73_ = NULL;
			gint _tmp73__length1 = 0;
			gint _tmp73__length2 = 0;
			guint _tmp74_ = 0U;
			guint _tmp75_ = 0U;
			Tile* _tmp76_ = NULL;
			_tmp73_ = self->priv->mines;
			_tmp73__length1 = self->priv->mines_length1;
			_tmp73__length2 = self->priv->mines_length2;
			_tmp74_ = x;
			_tmp75_ = y;
			_tmp76_ = _tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_];
			tile_add_class (_tmp76_, "exploded");
		} else {
			gboolean _tmp77_ = FALSE;
			gboolean _tmp78_ = FALSE;
			gboolean _tmp79_ = FALSE;
			guint n = 0U;
			Minefield* _tmp89_ = NULL;
			Minefield* _tmp90_ = NULL;
			guint _tmp91_ = 0U;
			guint _tmp92_ = 0U;
			guint _tmp93_ = 0U;
			Tile** _tmp94_ = NULL;
			gint _tmp94__length1 = 0;
			gint _tmp94__length2 = 0;
			guint _tmp95_ = 0U;
			guint _tmp96_ = 0U;
			Tile* _tmp97_ = NULL;
			Tile** _tmp98_ = NULL;
			gint _tmp98__length1 = 0;
			gint _tmp98__length2 = 0;
			guint _tmp99_ = 0U;
			guint _tmp100_ = 0U;
			Tile* _tmp101_ = NULL;
			Tile** _tmp102_ = NULL;
			gint _tmp102__length1 = 0;
			gint _tmp102__length2 = 0;
			guint _tmp103_ = 0U;
			guint _tmp104_ = 0U;
			Tile* _tmp105_ = NULL;
			guint _tmp106_ = 0U;
			_tmp78_ = minefield_view_get_use_overmine_warning (self);
			_tmp79_ = _tmp78_;
			if (_tmp79_) {
				Minefield* _tmp80_ = NULL;
				Minefield* _tmp81_ = NULL;
				guint _tmp82_ = 0U;
				guint _tmp83_ = 0U;
				gboolean _tmp84_ = FALSE;
				_tmp80_ = minefield_view_get_minefield (self);
				_tmp81_ = _tmp80_;
				_tmp82_ = x;
				_tmp83_ = y;
				_tmp84_ = minefield_has_flag_warning (_tmp81_, _tmp82_, _tmp83_);
				_tmp77_ = _tmp84_;
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				Tile** _tmp85_ = NULL;
				gint _tmp85__length1 = 0;
				gint _tmp85__length2 = 0;
				guint _tmp86_ = 0U;
				guint _tmp87_ = 0U;
				Tile* _tmp88_ = NULL;
				_tmp85_ = self->priv->mines;
				_tmp85__length1 = self->priv->mines_length1;
				_tmp85__length2 = self->priv->mines_length2;
				_tmp86_ = x;
				_tmp87_ = y;
				_tmp88_ = _tmp85_[(_tmp86_ * _tmp85__length2) + _tmp87_];
				tile_add_class (_tmp88_, "overmine");
			}
			_tmp89_ = minefield_view_get_minefield (self);
			_tmp90_ = _tmp89_;
			_tmp91_ = x;
			_tmp92_ = y;
			_tmp93_ = minefield_get_n_adjacent_mines (_tmp90_, _tmp91_, _tmp92_);
			n = _tmp93_;
			_tmp94_ = self->priv->mines;
			_tmp94__length1 = self->priv->mines_length1;
			_tmp94__length2 = self->priv->mines_length2;
			_tmp95_ = x;
			_tmp96_ = y;
			_tmp97_ = _tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_];
			tile_remove_class (_tmp97_, "maybe");
			_tmp98_ = self->priv->mines;
			_tmp98__length1 = self->priv->mines_length1;
			_tmp98__length2 = self->priv->mines_length2;
			_tmp99_ = x;
			_tmp100_ = y;
			_tmp101_ = _tmp98_[(_tmp99_ * _tmp98__length2) + _tmp100_];
			tile_remove_class (_tmp101_, "flag");
			_tmp102_ = self->priv->mines;
			_tmp102__length1 = self->priv->mines_length1;
			_tmp102__length2 = self->priv->mines_length2;
			_tmp103_ = x;
			_tmp104_ = y;
			_tmp105_ = _tmp102_[(_tmp103_ * _tmp102__length2) + _tmp104_];
			tile_add_class (_tmp105_, "count");
			_tmp106_ = n;
			if (_tmp106_ > ((guint) 0)) {
				Tile** _tmp107_ = NULL;
				gint _tmp107__length1 = 0;
				gint _tmp107__length2 = 0;
				guint _tmp108_ = 0U;
				guint _tmp109_ = 0U;
				Tile* _tmp110_ = NULL;
				guint _tmp111_ = 0U;
				gchar* _tmp112_ = NULL;
				gchar* _tmp113_ = NULL;
				_tmp107_ = self->priv->mines;
				_tmp107__length1 = self->priv->mines_length1;
				_tmp107__length2 = self->priv->mines_length2;
				_tmp108_ = x;
				_tmp109_ = y;
				_tmp110_ = _tmp107_[(_tmp108_ * _tmp107__length2) + _tmp109_];
				_tmp111_ = n;
				_tmp112_ = g_strdup_printf ("%umines", _tmp111_);
				_tmp113_ = _tmp112_;
				tile_add_class (_tmp110_, _tmp113_);
				_g_free0 (_tmp113_);
			}
		}
	} else {
		Minefield* _tmp114_ = NULL;
		Minefield* _tmp115_ = NULL;
		gboolean _tmp116_ = FALSE;
		gboolean _tmp117_ = FALSE;
		Minefield* _tmp118_ = NULL;
		Minefield* _tmp119_ = NULL;
		guint _tmp120_ = 0U;
		guint _tmp121_ = 0U;
		FlagType _tmp122_ = 0;
		_tmp114_ = minefield_view_get_minefield (self);
		_tmp115_ = _tmp114_;
		_tmp116_ = minefield_get_paused (_tmp115_);
		_tmp117_ = _tmp116_;
		if (_tmp117_) {
			return;
		}
		_tmp118_ = minefield_view_get_minefield (self);
		_tmp119_ = _tmp118_;
		_tmp120_ = x;
		_tmp121_ = y;
		_tmp122_ = minefield_get_flag (_tmp119_, _tmp120_, _tmp121_);
		if (_tmp122_ == FLAG_TYPE_FLAG) {
			Tile** _tmp123_ = NULL;
			gint _tmp123__length1 = 0;
			gint _tmp123__length2 = 0;
			guint _tmp124_ = 0U;
			guint _tmp125_ = 0U;
			Tile* _tmp126_ = NULL;
			gboolean _tmp127_ = FALSE;
			Minefield* _tmp128_ = NULL;
			Minefield* _tmp129_ = NULL;
			gboolean _tmp130_ = FALSE;
			_tmp123_ = self->priv->mines;
			_tmp123__length1 = self->priv->mines_length1;
			_tmp123__length2 = self->priv->mines_length2;
			_tmp124_ = x;
			_tmp125_ = y;
			_tmp126_ = _tmp123_[(_tmp124_ * _tmp123__length2) + _tmp125_];
			tile_add_class (_tmp126_, "flag");
			_tmp128_ = minefield_view_get_minefield (self);
			_tmp129_ = _tmp128_;
			_tmp130_ = _tmp129_->exploded;
			if (_tmp130_) {
				Minefield* _tmp131_ = NULL;
				Minefield* _tmp132_ = NULL;
				guint _tmp133_ = 0U;
				guint _tmp134_ = 0U;
				gboolean _tmp135_ = FALSE;
				_tmp131_ = minefield_view_get_minefield (self);
				_tmp132_ = _tmp131_;
				_tmp133_ = x;
				_tmp134_ = y;
				_tmp135_ = minefield_has_mine (_tmp132_, _tmp133_, _tmp134_);
				_tmp127_ = !_tmp135_;
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				Tile** _tmp136_ = NULL;
				gint _tmp136__length1 = 0;
				gint _tmp136__length2 = 0;
				guint _tmp137_ = 0U;
				guint _tmp138_ = 0U;
				Tile* _tmp139_ = NULL;
				_tmp136_ = self->priv->mines;
				_tmp136__length1 = self->priv->mines_length1;
				_tmp136__length2 = self->priv->mines_length2;
				_tmp137_ = x;
				_tmp138_ = y;
				_tmp139_ = _tmp136_[(_tmp137_ * _tmp136__length2) + _tmp138_];
				tile_add_class (_tmp139_, "incorrect");
			}
		} else {
			gboolean _tmp140_ = FALSE;
			Minefield* _tmp141_ = NULL;
			Minefield* _tmp142_ = NULL;
			gboolean _tmp143_ = FALSE;
			_tmp141_ = minefield_view_get_minefield (self);
			_tmp142_ = _tmp141_;
			_tmp143_ = _tmp142_->exploded;
			if (_tmp143_) {
				Minefield* _tmp144_ = NULL;
				Minefield* _tmp145_ = NULL;
				guint _tmp146_ = 0U;
				guint _tmp147_ = 0U;
				gboolean _tmp148_ = FALSE;
				_tmp144_ = minefield_view_get_minefield (self);
				_tmp145_ = _tmp144_;
				_tmp146_ = x;
				_tmp147_ = y;
				_tmp148_ = minefield_has_mine (_tmp145_, _tmp146_, _tmp147_);
				_tmp140_ = _tmp148_;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				Tile** _tmp149_ = NULL;
				gint _tmp149__length1 = 0;
				gint _tmp149__length2 = 0;
				guint _tmp150_ = 0U;
				guint _tmp151_ = 0U;
				Tile* _tmp152_ = NULL;
				_tmp149_ = self->priv->mines;
				_tmp149__length1 = self->priv->mines_length1;
				_tmp149__length2 = self->priv->mines_length2;
				_tmp150_ = x;
				_tmp151_ = y;
				_tmp152_ = _tmp149_[(_tmp150_ * _tmp149__length2) + _tmp151_];
				tile_add_class (_tmp152_, "mine");
			}
		}
	}
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	FlagType _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_is_cleared (_tmp1_, _tmp2_, _tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = minefield_get_flag (_tmp6_, _tmp7_, _tmp8_);
	switch (_tmp9_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp10_ = FALSE;
			Minefield* _tmp11_ = NULL;
			Minefield* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			Minefield* _tmp15_ = NULL;
			Minefield* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			_tmp11_ = minefield_view_get_minefield (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = minefield_get_n_flags (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = minefield_view_get_minefield (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->n_mines;
			if (_tmp14_ >= _tmp17_) {
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				_tmp18_ = minefield_view_get_use_question_marks (self);
				_tmp19_ = _tmp18_;
				_tmp10_ = _tmp19_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				Minefield* _tmp20_ = NULL;
				Minefield* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				guint _tmp23_ = 0U;
				Tile** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp24__length2 = 0;
				guint _tmp25_ = 0U;
				guint _tmp26_ = 0U;
				Tile* _tmp27_ = NULL;
				_tmp20_ = minefield_view_get_minefield (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = x;
				_tmp23_ = y;
				minefield_set_flag (_tmp21_, _tmp22_, _tmp23_, FLAG_TYPE_MAYBE);
				_tmp24_ = self->priv->mines;
				_tmp24__length1 = self->priv->mines_length1;
				_tmp24__length2 = self->priv->mines_length2;
				_tmp25_ = x;
				_tmp26_ = y;
				_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
				tile_add_class (_tmp27_, "maybe");
			} else {
				Minefield* _tmp28_ = NULL;
				Minefield* _tmp29_ = NULL;
				guint _tmp30_ = 0U;
				guint _tmp31_ = 0U;
				Tile** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp32__length2 = 0;
				guint _tmp33_ = 0U;
				guint _tmp34_ = 0U;
				Tile* _tmp35_ = NULL;
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = x;
				_tmp31_ = y;
				minefield_set_flag (_tmp29_, _tmp30_, _tmp31_, FLAG_TYPE_FLAG);
				_tmp32_ = self->priv->mines;
				_tmp32__length1 = self->priv->mines_length1;
				_tmp32__length2 = self->priv->mines_length2;
				_tmp33_ = x;
				_tmp34_ = y;
				_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
				tile_add_class (_tmp35_, "flag");
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Tile** _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			gint _tmp36__length2 = 0;
			guint _tmp37_ = 0U;
			guint _tmp38_ = 0U;
			Tile* _tmp39_ = NULL;
			Minefield* _tmp40_ = NULL;
			Minefield* _tmp41_ = NULL;
			guint _tmp42_ = 0U;
			guint _tmp43_ = 0U;
			_tmp36_ = self->priv->mines;
			_tmp36__length1 = self->priv->mines_length1;
			_tmp36__length2 = self->priv->mines_length2;
			_tmp37_ = x;
			_tmp38_ = y;
			_tmp39_ = _tmp36_[(_tmp37_ * _tmp36__length2) + _tmp38_];
			tile_remove_class (_tmp39_, "maybe");
			_tmp40_ = minefield_view_get_minefield (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = x;
			_tmp43_ = y;
			minefield_set_flag (_tmp41_, _tmp42_, _tmp43_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			Tile** _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gint _tmp44__length2 = 0;
			guint _tmp45_ = 0U;
			guint _tmp46_ = 0U;
			Tile* _tmp47_ = NULL;
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			_tmp44_ = self->priv->mines;
			_tmp44__length1 = self->priv->mines_length1;
			_tmp44__length2 = self->priv->mines_length2;
			_tmp45_ = x;
			_tmp46_ = y;
			_tmp47_ = _tmp44_[(_tmp45_ * _tmp44__length2) + _tmp46_];
			tile_remove_class (_tmp47_, "flag");
			_tmp48_ = minefield_view_get_use_question_marks (self);
			_tmp49_ = _tmp48_;
			if (_tmp49_) {
				Minefield* _tmp50_ = NULL;
				Minefield* _tmp51_ = NULL;
				guint _tmp52_ = 0U;
				guint _tmp53_ = 0U;
				Tile** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp54__length2 = 0;
				guint _tmp55_ = 0U;
				guint _tmp56_ = 0U;
				Tile* _tmp57_ = NULL;
				_tmp50_ = minefield_view_get_minefield (self);
				_tmp51_ = _tmp50_;
				_tmp52_ = x;
				_tmp53_ = y;
				minefield_set_flag (_tmp51_, _tmp52_, _tmp53_, FLAG_TYPE_MAYBE);
				_tmp54_ = self->priv->mines;
				_tmp54__length1 = self->priv->mines_length1;
				_tmp54__length2 = self->priv->mines_length2;
				_tmp55_ = x;
				_tmp56_ = y;
				_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
				tile_add_class (_tmp57_, "maybe");
			} else {
				Minefield* _tmp58_ = NULL;
				Minefield* _tmp59_ = NULL;
				guint _tmp60_ = 0U;
				guint _tmp61_ = 0U;
				_tmp58_ = minefield_view_get_minefield (self);
				_tmp59_ = _tmp58_;
				_tmp60_ = x;
				_tmp61_ = y;
				minefield_set_flag (_tmp59_, _tmp60_, _tmp61_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp0_ = 0U;
				Neighbour _tmp1_ = {0};
				gint _tmp2_ = 0;
				gint ny = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				Minefield* _tmp6_ = NULL;
				Minefield* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = ((gint) _tmp0_) + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, (guint) _tmp11_, (guint) _tmp12_);
				}
			}
		}
	}
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint n_mines = 0U;
	Minefield* _tmp11_ = NULL;
	Minefield* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint n_flags = 0U;
	guint n_unknown = 0U;
	gboolean do_clear = FALSE;
	guint _tmp39_ = 0U;
	guint _tmp40_ = 0U;
	Minefield* m = NULL;
	Minefield* _tmp46_ = NULL;
	Minefield* _tmp47_ = NULL;
	Minefield* _tmp48_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_ = NULL;
		Minefield* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = minefield_view_get_minefield (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = minefield_get_n_adjacent_mines (_tmp12_, _tmp13_, _tmp14_);
	n_mines = _tmp15_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp16_ = 0U;
				Neighbour _tmp17_ = {0};
				gint _tmp18_ = 0;
				gint ny = 0;
				guint _tmp19_ = 0U;
				Neighbour _tmp20_ = {0};
				gint _tmp21_ = 0;
				Minefield* _tmp22_ = NULL;
				Minefield* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gboolean _tmp26_ = FALSE;
				Minefield* _tmp27_ = NULL;
				Minefield* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				FlagType _tmp31_ = 0;
				Minefield* _tmp33_ = NULL;
				Minefield* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gboolean _tmp37_ = FALSE;
				_tmp16_ = x;
				_tmp17_ = neighbour;
				_tmp18_ = _tmp17_.x;
				nx = ((gint) _tmp16_) + _tmp18_;
				_tmp19_ = y;
				_tmp20_ = neighbour;
				_tmp21_ = _tmp20_.y;
				ny = ((gint) _tmp19_) + _tmp21_;
				_tmp22_ = minefield_view_get_minefield (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = nx;
				_tmp25_ = ny;
				_tmp26_ = minefield_is_location (_tmp23_, _tmp24_, _tmp25_);
				if (!_tmp26_) {
					continue;
				}
				_tmp27_ = minefield_view_get_minefield (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = nx;
				_tmp30_ = ny;
				_tmp31_ = minefield_get_flag (_tmp28_, (guint) _tmp29_, (guint) _tmp30_);
				if (_tmp31_ == FLAG_TYPE_FLAG) {
					guint _tmp32_ = 0U;
					_tmp32_ = n_flags;
					n_flags = _tmp32_ + 1;
				}
				_tmp33_ = minefield_view_get_minefield (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = nx;
				_tmp36_ = ny;
				_tmp37_ = minefield_is_cleared (_tmp34_, (guint) _tmp35_, (guint) _tmp36_);
				if (!_tmp37_) {
					guint _tmp38_ = 0U;
					_tmp38_ = n_unknown;
					n_unknown = _tmp38_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp39_ = n_mines;
	_tmp40_ = n_flags;
	if (_tmp39_ == _tmp40_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		_tmp42_ = minefield_view_get_use_autoflag (self);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			guint _tmp44_ = 0U;
			guint _tmp45_ = 0U;
			_tmp44_ = n_unknown;
			_tmp45_ = n_mines;
			_tmp41_ = _tmp44_ == _tmp45_;
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp46_ = minefield_view_get_minefield (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	m = _tmp48_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp49_ = 0U;
				Neighbour _tmp50_ = {0};
				gint _tmp51_ = 0;
				gint ny = 0;
				guint _tmp52_ = 0U;
				Neighbour _tmp53_ = {0};
				gint _tmp54_ = 0;
				Minefield* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				gboolean _tmp58_ = FALSE;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				_tmp49_ = x;
				_tmp50_ = neighbour;
				_tmp51_ = _tmp50_.x;
				nx = ((gint) _tmp49_) + _tmp51_;
				_tmp52_ = y;
				_tmp53_ = neighbour;
				_tmp54_ = _tmp53_.y;
				ny = ((gint) _tmp52_) + _tmp54_;
				_tmp55_ = m;
				_tmp56_ = nx;
				_tmp57_ = ny;
				_tmp58_ = minefield_is_location (_tmp55_, _tmp56_, _tmp57_);
				if (!_tmp58_) {
					continue;
				}
				_tmp60_ = do_clear;
				if (_tmp60_) {
					Minefield* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					FlagType _tmp64_ = 0;
					_tmp61_ = m;
					_tmp62_ = nx;
					_tmp63_ = ny;
					_tmp64_ = minefield_get_flag (_tmp61_, (guint) _tmp62_, (guint) _tmp63_);
					_tmp59_ = _tmp64_ != FLAG_TYPE_FLAG;
				} else {
					_tmp59_ = FALSE;
				}
				if (_tmp59_) {
					Minefield* _tmp65_ = NULL;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					_tmp65_ = m;
					_tmp66_ = nx;
					_tmp67_ = ny;
					minefield_clear_mine (_tmp65_, (guint) _tmp66_, (guint) _tmp67_);
				} else {
					Minefield* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					_tmp68_ = m;
					_tmp69_ = nx;
					_tmp70_ = ny;
					minefield_set_flag (_tmp68_, (guint) _tmp69_, (guint) _tmp70_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_g_object_unref0 (m);
}


static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Position* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gint x = 0;
	Position* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint y = 0;
	Position* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	Tile** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint _tmp26__length2 = 0;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Position* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	Tile* _tmp33_ = NULL;
	GdkEventKey* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	gboolean _tmp58_ = FALSE;
	gint _tmp59_ = 0;
	Position* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	Position* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	Position* _tmp87_ = NULL;
	gint _tmp88_ = 0;
	Minefield* _tmp89_ = NULL;
	guint _tmp90_ = 0U;
	gint _tmp91_ = 0;
	Minefield* _tmp92_ = NULL;
	guint _tmp93_ = 0U;
	gint* _tmp94_ = NULL;
	gint* _tmp95_ = NULL;
	gint _tmp95__length1 = 0;
	Tile** _tmp96_ = NULL;
	gint _tmp96__length1 = 0;
	gint _tmp96__length2 = 0;
	Position* _tmp97_ = NULL;
	gint _tmp98_ = 0;
	gint _tmp99_ = 0;
	Position* _tmp100_ = NULL;
	gint _tmp101_ = 0;
	gint _tmp102_ = 0;
	Tile* _tmp103_ = NULL;
	Position* _tmp104_ = NULL;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp9_ = NULL;
		Minefield* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = minefield_view_get_minefield (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = minefield_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->priv->selected;
	_tmp15_ = position_get_is_set (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		Position* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->keyboard_cursor;
		_tmp18_ = position_get_is_set (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = !_tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->keyboard_cursor;
	_tmp21_ = position_get_x (_tmp20_);
	_tmp22_ = _tmp21_;
	x = _tmp22_;
	_tmp23_ = self->priv->keyboard_cursor;
	_tmp24_ = position_get_y (_tmp23_);
	_tmp25_ = _tmp24_;
	y = _tmp25_;
	_tmp26_ = self->priv->mines;
	_tmp26__length1 = self->priv->mines_length1;
	_tmp26__length2 = self->priv->mines_length2;
	_tmp27_ = self->priv->keyboard_cursor;
	_tmp28_ = position_get_x (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->keyboard_cursor;
	_tmp31_ = position_get_y (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp26_[(_tmp29_ * _tmp26__length2) + _tmp32_];
	tile_remove_class (_tmp33_, "cursor");
	_tmp34_ = event;
	_tmp35_ = _tmp34_->keyval;
	switch (_tmp35_) {
		case GDK_KEY_Left:
		case GDK_KEY_h:
		{
			gint _tmp36_ = 0;
			_tmp36_ = x;
			x = _tmp36_ - 1;
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_l:
		{
			gint _tmp37_ = 0;
			_tmp37_ = x;
			x = _tmp37_ + 1;
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_k:
		{
			gint _tmp38_ = 0;
			_tmp38_ = y;
			y = _tmp38_ - 1;
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_j:
		{
			gint _tmp39_ = 0;
			_tmp39_ = y;
			y = _tmp39_ + 1;
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			Position* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			_tmp40_ = self->priv->keyboard_cursor;
			_tmp41_ = position_get_is_set (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_) {
				Position* _tmp43_ = NULL;
				GdkEventKey* _tmp44_ = NULL;
				GdkModifierType _tmp45_ = 0;
				_tmp43_ = self->priv->selected;
				position_set_is_set (_tmp43_, FALSE);
				_tmp44_ = event;
				_tmp45_ = _tmp44_->state;
				if ((_tmp45_ & GDK_CONTROL_MASK) != 0) {
					Position* _tmp46_ = NULL;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					Position* _tmp49_ = NULL;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					_tmp46_ = self->priv->keyboard_cursor;
					_tmp47_ = position_get_x (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = self->priv->keyboard_cursor;
					_tmp50_ = position_get_y (_tmp49_);
					_tmp51_ = _tmp50_;
					minefield_view_toggle_mark (self, (guint) _tmp48_, (guint) _tmp51_);
				} else {
					Position* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					gint _tmp54_ = 0;
					gint* _tmp55_ = NULL;
					gint* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					Position* _tmp57_ = NULL;
					_tmp52_ = self->priv->selected;
					_tmp53_ = x;
					_tmp54_ = y;
					_tmp55_ = g_new0 (gint, 2);
					_tmp55_[0] = _tmp53_;
					_tmp55_[1] = _tmp54_;
					_tmp56_ = _tmp55_;
					_tmp56__length1 = 2;
					position_set_position (_tmp52_, _tmp56_, 2);
					_tmp56_ = (g_free (_tmp56_), NULL);
					_tmp57_ = self->priv->selected;
					position_set_is_set (_tmp57_, TRUE);
					g_signal_emit_by_name (self, "look");
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp59_ = x;
	_tmp60_ = self->priv->keyboard_cursor;
	_tmp61_ = position_get_x (_tmp60_);
	_tmp62_ = _tmp61_;
	if (_tmp59_ == _tmp62_) {
		gint _tmp63_ = 0;
		Position* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		_tmp63_ = y;
		_tmp64_ = self->priv->keyboard_cursor;
		_tmp65_ = position_get_y (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp58_ = _tmp63_ == _tmp66_;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		Tile** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gint _tmp67__length2 = 0;
		Position* _tmp68_ = NULL;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		Position* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		Tile* _tmp74_ = NULL;
		_tmp67_ = self->priv->mines;
		_tmp67__length1 = self->priv->mines_length1;
		_tmp67__length2 = self->priv->mines_length2;
		_tmp68_ = self->priv->keyboard_cursor;
		_tmp69_ = position_get_x (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = self->priv->keyboard_cursor;
		_tmp72_ = position_get_y (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = _tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_];
		tile_add_class (_tmp74_, "cursor");
		result = TRUE;
		return result;
	}
	_tmp75_ = self->priv->keyboard_cursor;
	_tmp76_ = position_get_is_set (_tmp75_);
	_tmp77_ = _tmp76_;
	if (!_tmp77_) {
		Position* _tmp78_ = NULL;
		Tile** _tmp79_ = NULL;
		gint _tmp79__length1 = 0;
		gint _tmp79__length2 = 0;
		Position* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		Position* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		gint _tmp85_ = 0;
		Tile* _tmp86_ = NULL;
		_tmp78_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp78_, TRUE);
		_tmp79_ = self->priv->mines;
		_tmp79__length1 = self->priv->mines_length1;
		_tmp79__length2 = self->priv->mines_length2;
		_tmp80_ = self->priv->keyboard_cursor;
		_tmp81_ = position_get_x (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = self->priv->keyboard_cursor;
		_tmp84_ = position_get_y (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = _tmp79_[(_tmp82_ * _tmp79__length2) + _tmp85_];
		tile_add_class (_tmp86_, "cursor");
		result = TRUE;
		return result;
	}
	_tmp87_ = self->priv->keyboard_cursor;
	_tmp88_ = x;
	_tmp89_ = self->priv->_minefield;
	_tmp90_ = _tmp89_->height;
	_tmp91_ = y;
	_tmp92_ = self->priv->_minefield;
	_tmp93_ = _tmp92_->width;
	_tmp94_ = g_new0 (gint, 2);
	_tmp94_[0] = (gint) (_tmp88_ % _tmp90_);
	_tmp94_[1] = (gint) (_tmp91_ % _tmp93_);
	_tmp95_ = _tmp94_;
	_tmp95__length1 = 2;
	position_set_position (_tmp87_, _tmp95_, 2);
	_tmp95_ = (g_free (_tmp95_), NULL);
	_tmp96_ = self->priv->mines;
	_tmp96__length1 = self->priv->mines_length1;
	_tmp96__length2 = self->priv->mines_length2;
	_tmp97_ = self->priv->keyboard_cursor;
	_tmp98_ = position_get_x (_tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = self->priv->keyboard_cursor;
	_tmp101_ = position_get_y (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = _tmp96_[(_tmp99_ * _tmp96__length2) + _tmp102_];
	tile_add_class (_tmp103_, "cursor");
	_tmp104_ = self->priv->selected;
	_tmp105_ = position_get_is_set (_tmp104_);
	_tmp106_ = _tmp105_;
	if (_tmp106_) {
		Position* _tmp107_ = NULL;
		Position* _tmp108_ = NULL;
		gint _tmp109_ = 0;
		gint _tmp110_ = 0;
		Position* _tmp111_ = NULL;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gint* _tmp114_ = NULL;
		gint* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		_tmp107_ = self->priv->selected;
		_tmp108_ = self->priv->keyboard_cursor;
		_tmp109_ = position_get_x (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = self->priv->keyboard_cursor;
		_tmp112_ = position_get_y (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_new0 (gint, 2);
		_tmp114_[0] = _tmp110_;
		_tmp114_[1] = _tmp113_;
		_tmp115_ = _tmp114_;
		_tmp115__length1 = 2;
		position_set_position (_tmp107_, _tmp115_, 2);
		_tmp115_ = (g_free (_tmp115_), NULL);
	}
	result = TRUE;
	return result;
}


static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Minefield* _tmp22_ = NULL;
	Minefield* _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	Position* _tmp60_ = NULL;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ != ((guint) GDK_KEY_space)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = !_tmp21_;
	}
	if (_tmp15_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp22_ = minefield_view_get_minefield (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected;
	_tmp25_ = position_get_x (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_y (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = minefield_is_cleared (_tmp23_, (guint) _tmp26_, (guint) _tmp29_);
	if (_tmp30_) {
		Position* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		Position* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Position* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		Position* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		_tmp31_ = self->priv->selected;
		_tmp32_ = position_get_x (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->selected;
		_tmp35_ = position_get_y (_tmp34_);
		_tmp36_ = _tmp35_;
		minefield_view_multi_release (self, (guint) _tmp33_, (guint) _tmp36_);
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_x (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_y (_tmp40_);
		_tmp42_ = _tmp41_;
		minefield_view_redraw_adjacent (self, (guint) _tmp39_, (guint) _tmp42_);
	} else {
		Minefield* _tmp43_ = NULL;
		Minefield* _tmp44_ = NULL;
		Position* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		Position* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		FlagType _tmp51_ = 0;
		_tmp43_ = minefield_view_get_minefield (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = self->priv->selected;
		_tmp46_ = position_get_x (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->selected;
		_tmp49_ = position_get_y (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = minefield_get_flag (_tmp44_, (guint) _tmp47_, (guint) _tmp50_);
		if (_tmp51_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp52_ = NULL;
			Minefield* _tmp53_ = NULL;
			Position* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			Position* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			_tmp52_ = minefield_view_get_minefield (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = self->priv->selected;
			_tmp55_ = position_get_x (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = self->priv->selected;
			_tmp58_ = position_get_y (_tmp57_);
			_tmp59_ = _tmp58_;
			minefield_clear_mine (_tmp53_, (guint) _tmp56_, (guint) _tmp59_);
		}
	}
	_tmp60_ = self->priv->selected;
	position_set_is_set (_tmp60_, FALSE);
	result = FALSE;
	return result;
}


static gboolean minefield_view_get_use_question_marks (MinefieldView* self) {
	gboolean result;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, MINES_KEY_USE_QUESTION_MARKS);
	result = _tmp1_;
	return result;
}


static gboolean minefield_view_get_use_overmine_warning (MinefieldView* self) {
	gboolean result;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, MINES_KEY_USE_OVERMINE_WARNING);
	result = _tmp1_;
	return result;
}


static gboolean minefield_view_get_use_autoflag (MinefieldView* self) {
	gboolean result;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, MINES_KEY_USE_AUTOFLAG);
	result = _tmp1_;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	guint w = 0U;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint h = 0U;
	Minefield* _tmp3_ = NULL;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint s = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_minefield___lambda10_ (MinefieldView* self, GtkWidget* child) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	gtk_container_remove ((GtkContainer*) self, _tmp0_);
}


static void __minefield_view_minefield___lambda10__gtk_callback (GtkWidget* widget, gpointer self) {
	_minefield_view_minefield___lambda10_ ((MinefieldView*) self, widget);
}


static void _minefield_view_minefield_________lambda11_ (MinefieldView* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = x;
	_tmp1_ = y;
	minefield_view_tile_mouse_over_cb (self, _tmp0_, _tmp1_);
}


static void __minefield_view_minefield_________lambda11__tile_tile_mouse_over (Tile* _sender, gint x, gint y, gpointer self) {
	_minefield_view_minefield_________lambda11_ ((MinefieldView*) self, x, y);
}


static void _minefield_view_minefield_________lambda12_ (MinefieldView* self, gint x, gint y, GdkEventButton* event) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkEventButton* _tmp2_ = NULL;
	g_return_if_fail (event != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = event;
	minefield_view_tile_pressed_cb (self, _tmp0_, _tmp1_, _tmp2_);
}


static void __minefield_view_minefield_________lambda12__tile_tile_pressed (Tile* _sender, gint x, gint y, GdkEventButton* event, gpointer self) {
	_minefield_view_minefield_________lambda12_ ((MinefieldView*) self, x, y, event);
}


static void _minefield_view_minefield_________lambda13_ (MinefieldView* self, gint x, gint y, GdkEventButton* event) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkEventButton* _tmp2_ = NULL;
	g_return_if_fail (event != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = event;
	minefield_view_tile_released_cb (self, _tmp0_, _tmp1_, _tmp2_);
}


static void __minefield_view_minefield_________lambda13__tile_tile_released (Tile* _sender, gint x, gint y, GdkEventButton* event, gpointer self) {
	_minefield_view_minefield_________lambda13_ ((MinefieldView*) self, x, y, event);
}


static void _minefield_view_minefield___lambda14_ (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_minefield;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = minefield_is_cleared (_tmp0_, _tmp1_, _tmp2_);
	if (_tmp3_) {
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp4_ = x;
		_tmp5_ = y;
		minefield_view_redraw_adjacent (self, _tmp4_, _tmp5_);
	}
}


static void __minefield_view_minefield___lambda14__position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	_minefield_view_minefield___lambda14_ ((MinefieldView*) self, x, y);
}


static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = minefield_is_location ((Minefield*) self, x, y);
	return result;
}


static gint _minefield_view_minefield___lambda15_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = x;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda15__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda15_ ((MinefieldView*) self, x);
	return result;
}


static gint _minefield_view_minefield___lambda16_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = y;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda16__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda16_ ((MinefieldView*) self, y);
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb ((MinefieldView*) self, _sender);
}


static void _minefield_view_minefield___lambda17_ (MinefieldView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __minefield_view_minefield___lambda17__minefield_paused_changed (Minefield* _sender, gpointer self) {
	_minefield_view_minefield___lambda17_ ((MinefieldView*) self);
}


static void _minefield_view_complete_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	minefield_view_complete_cb ((MinefieldView*) self, _sender);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	Minefield* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	Tile** _tmp10_ = NULL;
	Position* _tmp50_ = NULL;
	Position* _tmp51_ = NULL;
	Position* _tmp52_ = NULL;
	Minefield* _tmp53_ = NULL;
	Position* _tmp54_ = NULL;
	Position* _tmp55_ = NULL;
	gint* _tmp56_ = NULL;
	gint* _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
	Position* _tmp58_ = NULL;
	Position* _tmp59_ = NULL;
	Minefield* _tmp60_ = NULL;
	Minefield* _tmp61_ = NULL;
	Minefield* _tmp62_ = NULL;
	Minefield* _tmp63_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp4_, "explodedField");
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp5_, "completedField");
	_tmp6_ = self->priv->_minefield;
	_tmp7_ = _tmp6_->width;
	_tmp8_ = self->priv->_minefield;
	_tmp9_ = _tmp8_->height;
	_tmp10_ = g_new0 (Tile*, (_tmp7_ * _tmp9_) + 1);
	self->priv->mines = (_vala_array_free (self->priv->mines, self->priv->mines_length1 * self->priv->mines_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->mines = _tmp10_;
	self->priv->mines_length1 = _tmp7_;
	self->priv->mines_length2 = _tmp9_;
	gtk_container_forall ((GtkContainer*) self, __minefield_view_minefield___lambda10__gtk_callback, self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				Minefield* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = self->priv->_minefield;
				_tmp15_ = _tmp14_->width;
				if (!(((guint) _tmp13_) < _tmp15_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_ = 0;
							Minefield* _tmp19_ = NULL;
							guint _tmp20_ = 0U;
							Tile** _tmp21_ = NULL;
							gint _tmp21__length1 = 0;
							gint _tmp21__length2 = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Tile* _tmp26_ = NULL;
							Tile* _tmp27_ = NULL;
							Tile** _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							gint _tmp28__length2 = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							Tile* _tmp31_ = NULL;
							Tile** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							Tile* _tmp35_ = NULL;
							Tile** _tmp36_ = NULL;
							gint _tmp36__length1 = 0;
							gint _tmp36__length2 = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							Tile* _tmp39_ = NULL;
							Tile** _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							gint _tmp40__length2 = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							Tile* _tmp43_ = NULL;
							Tile** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							gint _tmp44__length2 = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							Tile* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							if (!_tmp16_) {
								gint _tmp17_ = 0;
								_tmp17_ = j;
								j = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = j;
							_tmp19_ = self->priv->_minefield;
							_tmp20_ = _tmp19_->height;
							if (!(((guint) _tmp18_) < _tmp20_)) {
								break;
							}
							_tmp21_ = self->priv->mines;
							_tmp21__length1 = self->priv->mines_length1;
							_tmp21__length2 = self->priv->mines_length2;
							_tmp22_ = i;
							_tmp23_ = j;
							_tmp24_ = i;
							_tmp25_ = j;
							_tmp26_ = tile_new (_tmp24_, _tmp25_);
							g_object_ref_sink (_tmp26_);
							_g_object_unref0 (_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_]);
							_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp26_;
							_tmp27_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
							_tmp28_ = self->priv->mines;
							_tmp28__length1 = self->priv->mines_length1;
							_tmp28__length2 = self->priv->mines_length2;
							_tmp29_ = i;
							_tmp30_ = j;
							_tmp31_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
							gtk_widget_show ((GtkWidget*) _tmp31_);
							_tmp32_ = self->priv->mines;
							_tmp32__length1 = self->priv->mines_length1;
							_tmp32__length2 = self->priv->mines_length2;
							_tmp33_ = i;
							_tmp34_ = j;
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
							g_signal_connect_object (_tmp35_, "tile-mouse-over", (GCallback) __minefield_view_minefield_________lambda11__tile_tile_mouse_over, self, 0);
							_tmp36_ = self->priv->mines;
							_tmp36__length1 = self->priv->mines_length1;
							_tmp36__length2 = self->priv->mines_length2;
							_tmp37_ = i;
							_tmp38_ = j;
							_tmp39_ = _tmp36_[(_tmp37_ * _tmp36__length2) + _tmp38_];
							g_signal_connect_object (_tmp39_, "tile-pressed", (GCallback) __minefield_view_minefield_________lambda12__tile_tile_pressed, self, 0);
							_tmp40_ = self->priv->mines;
							_tmp40__length1 = self->priv->mines_length1;
							_tmp40__length2 = self->priv->mines_length2;
							_tmp41_ = i;
							_tmp42_ = j;
							_tmp43_ = _tmp40_[(_tmp41_ * _tmp40__length2) + _tmp42_];
							g_signal_connect_object (_tmp43_, "tile-released", (GCallback) __minefield_view_minefield_________lambda13__tile_tile_released, self, 0);
							_tmp44_ = self->priv->mines;
							_tmp44__length1 = self->priv->mines_length1;
							_tmp44__length2 = self->priv->mines_length2;
							_tmp45_ = i;
							_tmp46_ = j;
							_tmp47_ = _tmp44_[(_tmp45_ * _tmp44__length2) + _tmp46_];
							_tmp48_ = i;
							_tmp49_ = j;
							minefield_view_add (self, (GtkWidget*) _tmp47_, _tmp48_, _tmp49_);
						}
					}
				}
			}
		}
	}
	_tmp50_ = self->priv->selected;
	position_set_is_set (_tmp50_, FALSE);
	_tmp51_ = self->priv->selected;
	g_signal_connect_object (_tmp51_, "redraw", (GCallback) __minefield_view_minefield___lambda14__position_redraw, self, 0);
	_tmp52_ = self->priv->selected;
	_tmp53_ = self->priv->_minefield;
	g_signal_connect_object (_tmp52_, "validate", (GCallback) _minefield_is_location_position_validate, _tmp53_, 0);
	_tmp54_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp54_, FALSE);
	_tmp55_ = self->priv->keyboard_cursor;
	_tmp56_ = g_new0 (gint, 2);
	_tmp56_[0] = 0;
	_tmp56_[1] = 0;
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 2;
	position_set_position (_tmp55_, _tmp57_, 2);
	_tmp57_ = (g_free (_tmp57_), NULL);
	_tmp58_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp58_, "set-x", (GCallback) __minefield_view_minefield___lambda15__position_set_x, self, 0);
	_tmp59_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp59_, "set-y", (GCallback) __minefield_view_minefield___lambda16__position_set_y, self, 0);
	_tmp60_ = self->priv->_minefield;
	g_signal_connect_object (_tmp60_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp61_ = self->priv->_minefield;
	g_signal_connect_object (_tmp61_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp62_ = self->priv->_minefield;
	g_signal_connect_object (_tmp62_, "paused-changed", (GCallback) __minefield_view_minefield___lambda17__minefield_paused_changed, self, 0);
	_tmp63_ = self->priv->_minefield;
	g_signal_connect_object (_tmp63_, "cleared", (GCallback) _minefield_view_complete_cb_minefield_cleared, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	((GtkWidgetClass *) klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	((GtkWidgetClass *) klass)->key_press_event = minefield_view_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = minefield_view_real_key_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, g_param_spec_object ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->keyboard_cursor);
	_g_object_unref0 (self->priv->selected);
	self->priv->mines = (_vala_array_free (self->priv->mines, self->priv->mines_length1 * self->priv->mines_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_GRID, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		g_value_set_object (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



