/* computer-player.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define COMPUTER_PLAYER_TYPE_STRATEGY (computer_player_strategy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint _level;
};

typedef enum  {
	COMPUTER_PLAYER_STRATEGY_PERFECT,
	COMPUTER_PLAYER_STRATEGY_VICTORY,
	COMPUTER_PLAYER_STRATEGY_BEST
} ComputerPlayerStrategy;

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY,
	COMPUTER_PLAYER_LEVEL
};
static GType computer_player_strategy_get_type (void) G_GNUC_UNUSED;
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void computer_player_set_level (ComputerPlayer* self, gint value);
void computer_player_move (ComputerPlayer* self);
GType player_get_type (void) G_GNUC_CONST;
gboolean game_can_move (Game* self, Player color);
Player game_get_current_color (Game* self);
gint game_get_n_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
gint game_place_tile (Game* self, gint x, gint y);
gint computer_player_get_level (ComputerPlayer* self);
static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gboolean game_is_complete (Game* self);
static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
gint game_count_tiles (Game* self, Player color);
Player player_flip_color (Player p);
void game_undo (Game* self, gint count);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
void game_pass (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static gint computer_player_around (Game* g);
static gint computer_player_eval_heuristic (Game* g);
Player game_get_owner (Game* self, gint x, gint y);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static GType computer_player_strategy_get_type (void) {
	static volatile gsize computer_player_strategy_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_strategy_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPUTER_PLAYER_STRATEGY_PERFECT, "COMPUTER_PLAYER_STRATEGY_PERFECT", "perfect"}, {COMPUTER_PLAYER_STRATEGY_VICTORY, "COMPUTER_PLAYER_STRATEGY_VICTORY", "victory"}, {COMPUTER_PLAYER_STRATEGY_BEST, "COMPUTER_PLAYER_STRATEGY_BEST", "best"}, {0, NULL, NULL}};
		GType computer_player_strategy_type_id;
		computer_player_strategy_type_id = g_enum_register_static ("ComputerPlayerStrategy", values);
		g_once_init_leave (&computer_player_strategy_type_id__volatile, computer_player_strategy_type_id);
	}
	return computer_player_strategy_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 152 "computer-player.c"
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 54 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 54 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
#line 56 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = game;
#line 56 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 56 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	self->priv->game = _tmp1_;
#line 57 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = level;
#line 57 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	computer_player_set_level (self, _tmp2_);
#line 54 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return self;
#line 179 "computer-player.c"
}


ComputerPlayer* computer_player_new (Game* game, gint level) {
#line 54 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, level);
#line 186 "computer-player.c"
}


void computer_player_move (ComputerPlayer* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint depth = 0;
	gint _tmp14_ = 0;
	gint tiles_remaining = 0;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ComputerPlayerStrategy _tmp18_ = 0;
	gint _tmp19_ = 0;
	ComputerPlayerStrategy strategy = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint x = 0;
	gint y = 0;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	ComputerPlayerStrategy _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	Game* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = self->priv->game;
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp3_ = _tmp2_;
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
#line 60 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_if_fail (_tmp4_);
#line 64 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp5_ = self->priv->game;
#line 64 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp6_ = game_get_n_tiles (_tmp5_);
#line 64 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp7_ = _tmp6_;
#line 64 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp7_ < 8) {
#line 245 "computer-player.c"
		gint x = 0;
		gint y = 0;
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 67 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp8_ = self->priv->game;
#line 67 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		computer_player_random_select (_tmp8_, &_tmp9_, &_tmp10_);
#line 67 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		x = _tmp9_;
#line 67 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		y = _tmp10_;
#line 68 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp11_ = self->priv->game;
#line 68 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp12_ = x;
#line 68 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp13_ = y;
#line 68 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		game_place_tile (_tmp11_, _tmp12_, _tmp13_);
#line 69 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		return;
#line 272 "computer-player.c"
	}
#line 72 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp14_ = self->priv->_level;
#line 72 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	depth = 7 - ((3 - _tmp14_) * 2);
#line 73 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp15_ = self->priv->game;
#line 73 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp16_ = game_get_n_tiles (_tmp15_);
#line 73 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp17_ = _tmp16_;
#line 73 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	tiles_remaining = 64 - _tmp17_;
#line 82 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp19_ = self->priv->_level;
#line 82 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp19_ == 1) {
#line 82 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_PERFECT;
#line 292 "computer-player.c"
	} else {
#line 82 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_BEST;
#line 296 "computer-player.c"
	}
#line 82 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	strategy = _tmp18_;
#line 83 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp20_ = tiles_remaining;
#line 83 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp21_ = depth;
#line 83 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp20_ <= (_tmp21_ + 10)) {
#line 84 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		strategy = COMPUTER_PLAYER_STRATEGY_PERFECT;
#line 308 "computer-player.c"
	} else {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 85 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp22_ = tiles_remaining;
#line 85 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp23_ = depth;
#line 85 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		if (_tmp22_ <= (_tmp23_ + 12)) {
#line 86 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			strategy = COMPUTER_PLAYER_STRATEGY_VICTORY;
#line 320 "computer-player.c"
		}
	}
#line 91 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	x = 0;
#line 91 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	y = 0;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp24_ = self->priv->game;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp25_ = game_new_copy (_tmp24_);
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp26_ = _tmp25_;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp27_ = strategy;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp28_ = depth;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp29_ = G_MININT;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp30_ = G_MAXINT;
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	computer_player_search (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, 1, &x, &y);
#line 92 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_g_object_unref0 (_tmp26_);
#line 93 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp31_ = self->priv->game;
#line 93 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp32_ = x;
#line 93 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp33_ = y;
#line 93 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp34_ = game_place_tile (_tmp31_, _tmp32_, _tmp33_);
#line 93 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp34_ == 0) {
#line 355 "computer-player.c"
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
#line 94 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp35_ = x;
#line 94 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp36_ = y;
#line 94 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		g_critical ("computer-player.vala:94: Computer chose an invalid move: %d,%d", _tmp35_, _tmp36_);
#line 364 "computer-player.c"
	}
}


static void _computer_player_possible_move_free0_ (gpointer var) {
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
#line 372 "computer-player.c"
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_list_free (self);
#line 381 "computer-player.c"
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
#line 133 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return self ? computer_player_possible_move_dup (self) : NULL;
#line 388 "computer-player.c"
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move ((ComputerPlayerPossibleMove*) a, (ComputerPlayerPossibleMove*) b);
#line 133 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 397 "computer-player.c"
}


static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y) {
	gint result = 0;
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GList* moves = NULL;
	GList* _tmp52_ = NULL;
	GList* _tmp55_ = NULL;
	gint _tmp105_ = 0;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = game_is_complete (_tmp0_);
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (!_tmp1_, 0);
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = p;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp3_ = p;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail ((_tmp2_ == 1) || (_tmp3_ == (-1)), 0);
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp4_ = a;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp5_ = b;
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (_tmp4_ < _tmp5_, 0);
#line 103 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp6_ = depth;
#line 103 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp6_ == 0) {
#line 438 "computer-player.c"
		Game* _tmp7_ = NULL;
		ComputerPlayerStrategy _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 104 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp7_ = g;
#line 104 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp8_ = strategy;
#line 104 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp9_ = computer_player_calculate_heuristic (_tmp7_, _tmp8_);
#line 104 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		result = _tmp9_;
#line 104 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		return result;
#line 452 "computer-player.c"
	}
#line 107 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	moves = NULL;
#line 456 "computer-player.c"
	{
		gint x = 0;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		x = 0;
#line 461 "computer-player.c"
		{
			gboolean _tmp10_ = FALSE;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp10_ = TRUE;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			while (TRUE) {
#line 468 "computer-player.c"
				gint _tmp12_ = 0;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!_tmp10_) {
#line 472 "computer-player.c"
					gint _tmp11_ = 0;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp11_ = x;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					x = _tmp11_ + 1;
#line 478 "computer-player.c"
				}
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp10_ = FALSE;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp12_ = x;
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!(_tmp12_ < 8)) {
#line 108 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					break;
#line 488 "computer-player.c"
				}
				{
					gint y = 0;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					y = 0;
#line 494 "computer-player.c"
					{
						gboolean _tmp13_ = FALSE;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp13_ = TRUE;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						while (TRUE) {
#line 501 "computer-player.c"
							gint _tmp15_ = 0;
							gint n_tiles = 0;
							Game* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							Game* _tmp20_ = NULL;
							gboolean _tmp21_ = FALSE;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!_tmp13_) {
#line 512 "computer-player.c"
								gint _tmp14_ = 0;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp14_ = y;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								y = _tmp14_ + 1;
#line 518 "computer-player.c"
							}
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp13_ = FALSE;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp15_ = y;
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!(_tmp15_ < 8)) {
#line 110 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								break;
#line 528 "computer-player.c"
							}
#line 112 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp16_ = g;
#line 112 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp17_ = x;
#line 112 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp18_ = y;
#line 112 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp19_ = game_place_tile (_tmp16_, _tmp17_, _tmp18_);
#line 112 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							n_tiles = _tmp19_;
#line 114 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp20_ = g;
#line 114 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp21_ = game_is_complete (_tmp20_);
#line 114 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (_tmp21_) {
#line 546 "computer-player.c"
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Game* _tmp24_ = NULL;
								Game* _tmp25_ = NULL;
								Player _tmp26_ = 0;
								Player _tmp27_ = 0;
								gint _tmp28_ = 0;
								Game* _tmp29_ = NULL;
								Game* _tmp30_ = NULL;
								Player _tmp31_ = 0;
								Player _tmp32_ = 0;
								Player _tmp33_ = 0;
								gint _tmp34_ = 0;
#line 116 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp22_ = x;
#line 116 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								*move_x = _tmp22_;
#line 117 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp23_ = y;
#line 117 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								*move_y = _tmp23_;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp24_ = g;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp25_ = g;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp26_ = game_get_current_color (_tmp25_);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp27_ = _tmp26_;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp28_ = game_count_tiles (_tmp24_, _tmp27_);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp29_ = g;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp30_ = g;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp31_ = game_get_current_color (_tmp30_);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp32_ = _tmp31_;
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp33_ = player_flip_color (_tmp32_);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp34_ = game_count_tiles (_tmp29_, _tmp33_);
#line 119 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								if (_tmp28_ > _tmp34_) {
#line 592 "computer-player.c"
									Game* _tmp35_ = NULL;
									gint _tmp36_ = 0;
									gint _tmp37_ = 0;
#line 121 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp35_ = g;
#line 121 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									game_undo (_tmp35_, 1);
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp37_ = p;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									if (_tmp37_ > 0) {
#line 604 "computer-player.c"
										gint _tmp38_ = 0;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp38_ = G_MAXINT;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp36_ = _tmp38_;
#line 610 "computer-player.c"
									} else {
										gint _tmp39_ = 0;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp39_ = G_MININT;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp36_ = _tmp39_;
#line 617 "computer-player.c"
									}
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									result = _tmp36_;
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 122 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									return result;
#line 625 "computer-player.c"
								} else {
									Game* _tmp40_ = NULL;
									gint _tmp41_ = 0;
									gint _tmp42_ = 0;
#line 126 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp40_ = g;
#line 126 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									game_undo (_tmp40_, 1);
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp42_ = p;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									if (_tmp42_ > 0) {
#line 638 "computer-player.c"
										gint _tmp43_ = 0;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp43_ = G_MININT;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp41_ = _tmp43_;
#line 644 "computer-player.c"
									} else {
										gint _tmp44_ = 0;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp44_ = G_MAXINT;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
										_tmp41_ = _tmp44_;
#line 651 "computer-player.c"
									}
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									result = _tmp41_;
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 127 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									return result;
#line 659 "computer-player.c"
								}
							} else {
								gint _tmp45_ = 0;
#line 130 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp45_ = n_tiles;
#line 130 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								if (_tmp45_ > 0) {
#line 667 "computer-player.c"
									ComputerPlayerPossibleMove move = {0};
									gint _tmp46_ = 0;
									gint _tmp47_ = 0;
									gint _tmp48_ = 0;
									ComputerPlayerPossibleMove _tmp49_ = {0};
									ComputerPlayerPossibleMove* _tmp50_ = NULL;
									Game* _tmp51_ = NULL;
#line 132 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp46_ = x;
#line 132 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp47_ = y;
#line 132 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp48_ = n_tiles;
#line 132 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									computer_player_possible_move_init (&move, _tmp46_, _tmp47_, _tmp48_);
#line 133 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp49_ = move;
#line 133 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp50_ = _computer_player_possible_move_dup0 (&_tmp49_);
#line 133 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									moves = g_list_insert_sorted (moves, _tmp50_, _computer_player_compare_move_gcompare_func);
#line 134 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									_tmp51_ = g;
#line 134 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
									game_undo (_tmp51_, 1);
#line 693 "computer-player.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 141 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp52_ = moves;
#line 141 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp52_ == NULL) {
#line 706 "computer-player.c"
		ComputerPlayerPossibleMove move = {0};
		ComputerPlayerPossibleMove _tmp53_ = {0};
		ComputerPlayerPossibleMove* _tmp54_ = NULL;
#line 143 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		computer_player_possible_move_init (&move, 0, 0, 0);
#line 144 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp53_ = move;
#line 144 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp54_ = _computer_player_possible_move_dup0 (&_tmp53_);
#line 144 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		moves = g_list_append (moves, _tmp54_);
#line 718 "computer-player.c"
	}
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp55_ = moves;
#line 722 "computer-player.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		move_collection = _tmp55_;
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 730 "computer-player.c"
			ComputerPlayerPossibleMove* _tmp56_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp56_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			move = _tmp56_;
#line 737 "computer-player.c"
			{
				ComputerPlayerPossibleMove* _tmp57_ = NULL;
				gint _tmp58_ = 0;
				gint _tmp73_ = 0;
				Game* _tmp102_ = NULL;
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
#line 150 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp57_ = move;
#line 150 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp58_ = (*_tmp57_).n_tiles;
#line 150 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (_tmp58_ == 0) {
#line 751 "computer-player.c"
					Game* _tmp59_ = NULL;
#line 152 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp59_ = g;
#line 152 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					game_pass (_tmp59_);
#line 757 "computer-player.c"
				} else {
					Game* _tmp60_ = NULL;
					ComputerPlayerPossibleMove* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					ComputerPlayerPossibleMove* _tmp63_ = NULL;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp60_ = g;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp61_ = move;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp62_ = (*_tmp61_).x;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp63_ = move;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp64_ = (*_tmp63_).y;
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp65_ = game_place_tile (_tmp60_, _tmp62_, _tmp64_);
#line 154 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					if (_tmp65_ == 0) {
#line 779 "computer-player.c"
						gint _tmp66_ = 0;
						ComputerPlayerPossibleMove* _tmp67_ = NULL;
						gint _tmp68_ = 0;
						ComputerPlayerPossibleMove* _tmp69_ = NULL;
						gint _tmp70_ = 0;
						ComputerPlayerPossibleMove* _tmp71_ = NULL;
						gint _tmp72_ = 0;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp66_ = depth;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp67_ = move;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp68_ = (*_tmp67_).x;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp69_ = move;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp70_ = (*_tmp69_).y;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp71_ = move;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp72_ = (*_tmp71_).n_tiles;
#line 156 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						g_warning ("computer-player.vala:156: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking", _tmp66_, _tmp68_, _tmp70_, _tmp72_);
#line 157 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_computer_player_possible_move_free0 (move);
#line 157 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						continue;
#line 807 "computer-player.c"
					}
				}
#line 168 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp73_ = p;
#line 168 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (_tmp73_ > 0) {
#line 814 "computer-player.c"
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint a_new = 0;
					Game* _tmp74_ = NULL;
					ComputerPlayerStrategy _tmp75_ = 0;
					gint _tmp76_ = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
#line 170 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					next_x_move = 0;
#line 170 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					next_y_move = 0;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp74_ = g;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp75_ = strategy;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp76_ = depth;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp77_ = a;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp78_ = b;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp79_ = p;
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp80_ = computer_player_search (_tmp74_, _tmp75_, _tmp76_ - 1, _tmp77_, _tmp78_, -_tmp79_, &next_x_move, &next_y_move);
#line 171 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					a_new = _tmp80_;
#line 172 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp81_ = a_new;
#line 172 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp82_ = a;
#line 172 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					if (_tmp81_ >= _tmp82_) {
#line 853 "computer-player.c"
						gint _tmp83_ = 0;
						ComputerPlayerPossibleMove* _tmp84_ = NULL;
						gint _tmp85_ = 0;
						ComputerPlayerPossibleMove* _tmp86_ = NULL;
						gint _tmp87_ = 0;
#line 174 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp83_ = a_new;
#line 174 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						a = _tmp83_;
#line 175 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp84_ = move;
#line 175 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp85_ = (*_tmp84_).x;
#line 175 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						*move_x = _tmp85_;
#line 176 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp86_ = move;
#line 176 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp87_ = (*_tmp86_).y;
#line 176 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						*move_y = _tmp87_;
#line 875 "computer-player.c"
					}
				} else {
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint b_new = 0;
					Game* _tmp88_ = NULL;
					ComputerPlayerStrategy _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
#line 182 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					next_x_move = 0;
#line 182 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					next_y_move = 0;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp88_ = g;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp89_ = strategy;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp90_ = depth;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp91_ = a;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp92_ = b;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp93_ = p;
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp94_ = computer_player_search (_tmp88_, _tmp89_, _tmp90_ - 1, _tmp91_, _tmp92_, -_tmp93_, &next_x_move, &next_y_move);
#line 183 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					b_new = _tmp94_;
#line 184 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp95_ = b_new;
#line 184 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp96_ = b;
#line 184 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					if (_tmp95_ <= _tmp96_) {
#line 916 "computer-player.c"
						gint _tmp97_ = 0;
						ComputerPlayerPossibleMove* _tmp98_ = NULL;
						gint _tmp99_ = 0;
						ComputerPlayerPossibleMove* _tmp100_ = NULL;
						gint _tmp101_ = 0;
#line 186 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp97_ = b_new;
#line 186 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						b = _tmp97_;
#line 187 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp98_ = move;
#line 187 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp99_ = (*_tmp98_).x;
#line 187 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						*move_x = _tmp99_;
#line 188 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp100_ = move;
#line 188 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp101_ = (*_tmp100_).y;
#line 188 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						*move_y = _tmp101_;
#line 938 "computer-player.c"
					}
				}
#line 192 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp102_ = g;
#line 192 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				game_undo (_tmp102_, 1);
#line 195 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp103_ = b;
#line 195 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp104_ = a;
#line 195 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (_tmp103_ <= _tmp104_) {
#line 196 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_computer_player_possible_move_free0 (move);
#line 196 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					break;
#line 955 "computer-player.c"
				}
#line 148 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_computer_player_possible_move_free0 (move);
#line 959 "computer-player.c"
			}
		}
	}
#line 199 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp105_ = p;
#line 199 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp105_ > 0) {
#line 967 "computer-player.c"
		gint _tmp106_ = 0;
#line 200 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp106_ = a;
#line 200 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		result = _tmp106_;
#line 200 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 200 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		return result;
#line 977 "computer-player.c"
	} else {
		gint _tmp107_ = 0;
#line 202 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp107_ = b;
#line 202 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		result = _tmp107_;
#line 202 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 202 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		return result;
#line 988 "computer-player.c"
	}
#line 97 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 992 "computer-player.c"
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = b;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = (*_tmp0_).n_tiles;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = a;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp3_ = (*_tmp2_).n_tiles;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	result = _tmp1_ - _tmp3_;
#line 207 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 1014 "computer-player.c"
}


static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy) {
	gint result = 0;
	gint tile_difference = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Player _tmp7_ = 0;
	Player _tmp8_ = 0;
	ComputerPlayerStrategy _tmp10_ = 0;
#line 214 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = game_get_n_dark_tiles (_tmp0_);
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp3_ = g;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp4_ = game_get_n_light_tiles (_tmp3_);
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp5_ = _tmp4_;
#line 216 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	tile_difference = _tmp2_ - _tmp5_;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp6_ = g;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp7_ = game_get_current_color (_tmp6_);
#line 217 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp8_ = _tmp7_;
#line 217 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp8_ == PLAYER_DARK) {
#line 1055 "computer-player.c"
		gint _tmp9_ = 0;
#line 218 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp9_ = tile_difference;
#line 218 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		tile_difference = -_tmp9_;
#line 1061 "computer-player.c"
	}
#line 220 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp10_ = strategy;
#line 220 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	switch (_tmp10_) {
#line 220 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_PERFECT:
#line 1069 "computer-player.c"
		{
#line 224 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			result = tile_difference;
#line 224 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			return result;
#line 1075 "computer-player.c"
		}
#line 220 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_VICTORY:
#line 1079 "computer-player.c"
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 228 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp11_ = tile_difference;
#line 228 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp12_ = CLAMP (_tmp11_, -1, 1);
#line 228 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			result = _tmp12_;
#line 228 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			return result;
#line 1091 "computer-player.c"
		}
		default:
		{
			gint _tmp13_ = 0;
			Game* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp13_ = tile_difference;
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp14_ = g;
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp15_ = computer_player_around (_tmp14_);
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp16_ = g;
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp17_ = computer_player_eval_heuristic (_tmp16_);
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			result = (_tmp13_ - _tmp15_) - _tmp17_;
#line 232 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			return result;
#line 1114 "computer-player.c"
		}
	}
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
#line 236 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 238 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	count = 0;
#line 1127 "computer-player.c"
	{
		gint x = 0;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		x = 0;
#line 1132 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1139 "computer-player.c"
				gint _tmp2_ = 0;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1143 "computer-player.c"
					gint _tmp1_ = 0;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1149 "computer-player.c"
				}
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 239 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					break;
#line 1159 "computer-player.c"
				}
				{
					gint y = 0;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					y = 0;
#line 1165 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1172 "computer-player.c"
							gint _tmp5_ = 0;
							gint h = 0;
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Player _tmp12_ = 0;
							Game* _tmp13_ = NULL;
							Player _tmp14_ = 0;
							Player _tmp15_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1189 "computer-player.c"
								gint _tmp4_ = 0;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1195 "computer-player.c"
							}
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 241 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								break;
#line 1205 "computer-player.c"
							}
#line 243 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp6_ = y;
#line 243 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp7_ = x;
#line 243 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp8_ = COMPUTER_PLAYER_heuristic[(_tmp6_ * 8) + _tmp7_];
#line 243 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							h = _tmp8_;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp10_ = x;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp11_ = y;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp12_ = game_get_owner (_tmp9_, _tmp10_, _tmp11_);
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp13_ = g;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp14_ = game_get_current_color (_tmp13_);
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp15_ = _tmp14_;
#line 244 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (_tmp12_ != _tmp15_) {
#line 1231 "computer-player.c"
								gint _tmp16_ = 0;
#line 245 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp16_ = h;
#line 245 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								h = -_tmp16_;
#line 1237 "computer-player.c"
							}
#line 246 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp17_ = count;
#line 246 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp18_ = h;
#line 246 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							count = _tmp17_ + _tmp18_;
#line 1245 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 250 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	result = count;
#line 250 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 1256 "computer-player.c"
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
#line 253 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 255 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	count = 0;
#line 1267 "computer-player.c"
	{
		gint x = 0;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		x = 0;
#line 1272 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1279 "computer-player.c"
				gint _tmp2_ = 0;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1283 "computer-player.c"
					gint _tmp1_ = 0;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1289 "computer-player.c"
				}
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 256 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					break;
#line 1299 "computer-player.c"
				}
				{
					gint y = 0;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					y = 0;
#line 1305 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1312 "computer-player.c"
							gint _tmp5_ = 0;
							gint a = 0;
							gint _tmp6_ = 0;
							Game* _tmp7_ = NULL;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Game* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Game* _tmp27_ = NULL;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Game* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							Game* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							Game* _tmp42_ = NULL;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							Game* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							Player _tmp50_ = 0;
							Game* _tmp51_ = NULL;
							Player _tmp52_ = 0;
							Player _tmp53_ = 0;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1367 "computer-player.c"
								gint _tmp4_ = 0;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1373 "computer-player.c"
							}
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 258 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								break;
#line 1383 "computer-player.c"
							}
#line 260 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = 0;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp6_ = a;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp7_ = g;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp8_ = x;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp9_ = y;
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp10_ = computer_player_is_empty (_tmp7_, _tmp8_ + 1, _tmp9_);
#line 261 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp6_ + _tmp10_;
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp11_ = a;
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp12_ = g;
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp13_ = x;
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp14_ = y;
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp15_ = computer_player_is_empty (_tmp12_, _tmp13_ + 1, _tmp14_ + 1);
#line 262 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp11_ + _tmp15_;
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp16_ = a;
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp17_ = g;
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp18_ = x;
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp19_ = y;
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp20_ = computer_player_is_empty (_tmp17_, _tmp18_, _tmp19_ + 1);
#line 263 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp16_ + _tmp20_;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp21_ = a;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp22_ = g;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp23_ = x;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp24_ = y;
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp25_ = computer_player_is_empty (_tmp22_, _tmp23_ - 1, _tmp24_ + 1);
#line 264 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp21_ + _tmp25_;
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp26_ = a;
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp27_ = g;
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp28_ = x;
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp29_ = y;
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp30_ = computer_player_is_empty (_tmp27_, _tmp28_ - 1, _tmp29_);
#line 265 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp26_ + _tmp30_;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp31_ = a;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp32_ = g;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp33_ = x;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp34_ = y;
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp35_ = computer_player_is_empty (_tmp32_, _tmp33_ - 1, _tmp34_ - 1);
#line 266 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp31_ + _tmp35_;
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp36_ = a;
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp37_ = g;
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp38_ = x;
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp39_ = y;
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp40_ = computer_player_is_empty (_tmp37_, _tmp38_, _tmp39_ - 1);
#line 267 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp36_ + _tmp40_;
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp41_ = a;
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp42_ = g;
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp43_ = x;
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp44_ = y;
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp45_ = computer_player_is_empty (_tmp42_, _tmp43_ + 1, _tmp44_ - 1);
#line 268 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							a = _tmp41_ + _tmp45_;
#line 271 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp46_ = a;
#line 271 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (_tmp46_ == 0) {
#line 272 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								a = 2;
#line 1489 "computer-player.c"
							}
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp47_ = g;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp48_ = x;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp49_ = y;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp50_ = game_get_owner (_tmp47_, _tmp48_, _tmp49_);
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp51_ = g;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp52_ = game_get_current_color (_tmp51_);
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp53_ = _tmp52_;
#line 274 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (_tmp50_ != _tmp53_) {
#line 1507 "computer-player.c"
								gint _tmp54_ = 0;
#line 275 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp54_ = a;
#line 275 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								a = -_tmp54_;
#line 1513 "computer-player.c"
							}
#line 276 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp55_ = count;
#line 276 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp56_ = a;
#line 276 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							count = _tmp55_ + _tmp56_;
#line 1521 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 280 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	result = count;
#line 280 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 1532 "computer-player.c"
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
#line 283 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp4_ = x;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp4_ < 0) {
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp3_ = TRUE;
#line 1551 "computer-player.c"
	} else {
		gint _tmp5_ = 0;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp5_ = x;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp3_ = _tmp5_ >= 8;
#line 1558 "computer-player.c"
	}
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp3_) {
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp2_ = TRUE;
#line 1564 "computer-player.c"
	} else {
		gint _tmp6_ = 0;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp6_ = y;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp2_ = _tmp6_ < 0;
#line 1571 "computer-player.c"
	}
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp2_) {
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp1_ = TRUE;
#line 1577 "computer-player.c"
	} else {
		gint _tmp7_ = 0;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp7_ = y;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp1_ = _tmp7_ >= 8;
#line 1584 "computer-player.c"
	}
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp1_) {
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp0_ = TRUE;
#line 1590 "computer-player.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Player _tmp11_ = 0;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp8_ = g;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp9_ = x;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp10_ = y;
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp11_ = game_get_owner (_tmp8_, _tmp9_, _tmp10_);
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp0_ = _tmp11_ != PLAYER_NONE;
#line 1606 "computer-player.c"
	}
#line 285 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp0_) {
#line 286 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		result = 0;
#line 286 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		return result;
#line 1614 "computer-player.c"
	}
#line 288 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	result = 1;
#line 288 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 1620 "computer-player.c"
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp15_ = NULL;
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 293 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	moves = NULL;
#line 1633 "computer-player.c"
	{
		gint x = 0;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		x = 0;
#line 1638 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1645 "computer-player.c"
				gint _tmp2_ = 0;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!_tmp0_) {
#line 1649 "computer-player.c"
					gint _tmp1_ = 0;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					_tmp1_ = x;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					x = _tmp1_ + 1;
#line 1655 "computer-player.c"
				}
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				_tmp2_ = x;
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
				if (!(_tmp2_ < 8)) {
#line 294 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					break;
#line 1665 "computer-player.c"
				}
				{
					gint y = 0;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
					y = 0;
#line 1671 "computer-player.c"
					{
						gboolean _tmp3_ = FALSE;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						_tmp3_ = TRUE;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1678 "computer-player.c"
							gint _tmp5_ = 0;
							Game* _tmp6_ = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							Player _tmp10_ = 0;
							Player _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!_tmp3_) {
#line 1689 "computer-player.c"
								gint _tmp4_ = 0;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp4_ = y;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								y = _tmp4_ + 1;
#line 1695 "computer-player.c"
							}
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp3_ = FALSE;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp5_ = y;
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (!(_tmp5_ < 8)) {
#line 296 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								break;
#line 1705 "computer-player.c"
							}
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp6_ = g;
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp7_ = x;
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp10_ = game_get_current_color (_tmp9_);
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp11_ = _tmp10_;
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							_tmp12_ = game_can_place (_tmp6_, _tmp7_, _tmp8_, _tmp11_);
#line 298 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
							if (_tmp12_) {
#line 1723 "computer-player.c"
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
#line 299 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp13_ = x;
#line 299 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								_tmp14_ = y;
#line 299 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp13_ * 8) + _tmp14_)));
#line 1732 "computer-player.c"
							}
						}
					}
				}
			}
		}
	}
#line 302 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp15_ = moves;
#line 302 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (_tmp15_ != NULL) {
#line 1744 "computer-player.c"
		gint32 i = 0;
		GList* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		gint32 _tmp18_ = 0;
		gint xy = 0;
		GList* _tmp19_ = NULL;
		gint32 _tmp20_ = 0;
		gconstpointer _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 304 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp16_ = moves;
#line 304 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 304 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp18_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp17_));
#line 304 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		i = _tmp18_;
#line 305 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp19_ = moves;
#line 305 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp20_ = i;
#line 305 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp21_ = g_list_nth_data (_tmp19_, (guint) _tmp20_);
#line 305 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		xy = (gint) ((gintptr) _tmp21_);
#line 306 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp22_ = xy;
#line 306 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_vala_move_x = _tmp22_ / 8;
#line 307 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp23_ = xy;
#line 307 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_vala_move_y = _tmp23_ % 8;
#line 1779 "computer-player.c"
	} else {
		gint _tmp24_ = 0;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_vala_move_y = 0;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_tmp24_ = _vala_move_y;
#line 310 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		_vala_move_x = _tmp24_;
#line 1788 "computer-player.c"
	}
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_g_list_free0 (moves);
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (move_x) {
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		*move_x = _vala_move_x;
#line 1796 "computer-player.c"
	}
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	if (move_y) {
#line 291 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		*move_y = _vala_move_y;
#line 1802 "computer-player.c"
	}
}


gint computer_player_get_level (ComputerPlayer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->_level;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	result = _tmp0_;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return result;
#line 1818 "computer-player.c"
}


static void computer_player_set_level (ComputerPlayer* self, gint value) {
	gint _tmp0_ = 0;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = value;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	self->priv->_level = _tmp0_;
#line 39 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_object_notify ((GObject *) self, "level");
#line 1832 "computer-player.c"
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 27 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
#line 29 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 29 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	(*self).x = _tmp0_;
#line 30 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 30 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	(*self).y = _tmp1_;
#line 31 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_tmp2_ = n_tiles;
#line 31 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	(*self).n_tiles = _tmp2_;
#line 1854 "computer-player.c"
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
#line 21 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
#line 21 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
#line 21 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	return dup;
#line 1866 "computer-player.c"
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
#line 21 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_free (self);
#line 1873 "computer-player.c"
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	computer_player_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1901 "computer-player.c"
}


static void computer_player_instance_init (ComputerPlayer * self) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
#line 1908 "computer-player.c"
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 36 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
#line 1920 "computer-player.c"
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	switch (property_id) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		g_value_set_int (value, computer_player_get_level (self));
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		break;
#line 1947 "computer-player.c"
		default:
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		break;
#line 1953 "computer-player.c"
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
	switch (property_id) {
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		computer_player_set_level (self, g_value_get_int (value));
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		break;
#line 1969 "computer-player.c"
		default:
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/manhattan/checkout/gnome/iagno/src/computer-player.vala"
		break;
#line 1975 "computer-player.c"
	}
}



