/* cheese-window.c generated by valac 0.25.4, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cheese-camera-device.h>
#include <cairo.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;

struct _CheeseMainWindow {
	GtkApplicationWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	ClutterScript* clutter_builder;
	GtkBuilder* header_bar_ui;
	GtkHeaderBar* header_bar;
	GSettings* settings;
	GtkClutterEmbed* viewport_widget;
	GtkWidget* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkBox* thumbnails_right;
	GtkBox* thumbnails_bottom;
	GtkWidget* leave_fullscreen_button_box;
	GtkButton* take_action_button;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkWidget* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterActor* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterActor* background_layer;
	ClutterText* error_layer;
	ClutterText* timeout_layer;
	ClutterActor* current_effects_grid;
	guint current_effects_page;
	GList* effects_grids;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean action_cancelled;
	gboolean was_maximized;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE ((guint) 9)
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void cheese_main_window_on_file_open (CheeseMainWindow* self);
static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self);
static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_trash (CheeseMainWindow* self);
static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_file_delete (CheeseMainWindow* self);
static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_effects_next (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self);
static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
static void cheese_main_window_set_window_title (CheeseMainWindow* self, const gchar* title);
static gboolean cheese_main_window_on_window_state_change_event (CheeseMainWindow* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self, GtkWidget* widget, guint button, guint time);
static gboolean cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self, GtkWidget* thumbview);
gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_set_fullscreen (CheeseMainWindow* self, gboolean fullscreen);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda4_ (CheeseMainWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_cancel_running_action (CheeseMainWindow* self);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self);
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_show_error (CheeseMainWindow* self, const gchar* _error_);
void cheese_main_window_set_effects (CheeseMainWindow* self, gboolean effects);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterTapAction* tap, ClutterActor* source);
static gboolean cheese_main_window_is_previous_effects_page (CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
static gboolean cheese_main_window_is_next_effects_page (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_update_header_bar_title (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
static void cheese_main_window_finalize (GObject* obj);

static const GActionEntry CHEESE_MAIN_WINDOW_actions[6] = {{"file-open", _cheese_main_window_on_file_open_gsimple_action_activate_callback}, {"file-saveas", _cheese_main_window_on_file_saveas_gsimple_action_activate_callback}, {"file-trash", _cheese_main_window_on_file_trash_gsimple_action_activate_callback}, {"file-delete", _cheese_main_window_on_file_delete_gsimple_action_activate_callback}, {"effects-next", _cheese_main_window_on_effects_next_gsimple_action_activate_callback}, {"effects-previous", _cheese_main_window_on_effects_previous_gsimple_action_activate_callback}};

/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType cheese_main_window_delete_response_get_type (void) {
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _cheese_main_window_on_file_open_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_open ((CheeseMainWindow*) self);
}


static void _cheese_main_window_on_file_saveas_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_saveas ((CheeseMainWindow*) self);
}


static void _cheese_main_window_on_file_trash_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_trash ((CheeseMainWindow*) self);
}


static void _cheese_main_window_on_file_delete_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_file_delete ((CheeseMainWindow*) self);
}


static void _cheese_main_window_on_effects_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_effects_next ((CheeseMainWindow*) self);
}


static void _cheese_main_window_on_effects_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_window_on_effects_previous ((CheeseMainWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application) {
	CheeseMainWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkHeaderBar* _tmp3_ = NULL;
	GtkSettings* settings = NULL;
	GtkSettings* _tmp4_ = NULL;
	GtkSettings* _tmp5_ = NULL;
	GtkSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CheeseMainWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = self->priv->header_bar_ui;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "header_bar");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp3_;
	_tmp4_ = gtk_settings_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	settings = _tmp5_;
	_tmp6_ = settings;
	g_object_get (_tmp6_, "gtk-dialogs-use-header", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GtkHeaderBar* _tmp9_ = NULL;
		GtkHeaderBar* _tmp10_ = NULL;
		_tmp9_ = self->priv->header_bar;
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
		_tmp10_ = self->priv->header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (settings);
	return self;
}


CheeseMainWindow* cheese_main_window_new (GtkApplication* application) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW, application);
}


static void cheese_main_window_set_window_title (CheeseMainWindow* self, const gchar* title) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->header_bar;
	_tmp1_ = title;
	gtk_header_bar_set_title (_tmp0_, _tmp1_);
	_tmp2_ = title;
	gtk_window_set_title ((GtkWindow*) self, _tmp2_);
}


static gboolean _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_window_state_change_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static gboolean cheese_main_window_on_window_state_change_event (CheeseMainWindow* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp2_ = NULL;
	GdkWindowState _tmp3_ = 0;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->new_window_state;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->changed_mask;
	self->priv->was_maximized = ((_tmp1_ - _tmp3_) & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	g_signal_parse_name ("window-state-event", gtk_widget_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self);
	result = FALSE;
	return result;
}


static void cheese_main_window_do_thumb_view_popup_menu (CheeseMainWindow* self, GtkWidget* widget, guint button, guint time) {
	GtkMenu* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->thumbnail_popup;
	_tmp1_ = widget;
	_tmp2_ = button;
	_tmp3_ = time;
	gtk_menu_popup (_tmp0_, NULL, _tmp1_, NULL, NULL, _tmp2_, (guint32) _tmp3_);
}


static gboolean cheese_main_window_on_thumb_view_popup_menu (CheeseMainWindow* self, GtkWidget* thumbview) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (thumbview != NULL, FALSE);
	_tmp0_ = thumbview;
	cheese_main_window_do_thumb_view_popup_menu (self, _tmp0_, (guint) 0, (guint) 0);
	result = TRUE;
	return result;
}


/**
    * Popup a context menu when right-clicking on a thumbnail.
    *
    * @param iconview the thumbnail view that emitted the signal
    * @param event the event
    * @return false to allow further processing of the event, true to indicate
    * that the event was handled completely
    */
gboolean cheese_main_window_on_thumbnail_button_press_event (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GdkEventButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	GdkEventButton* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	CheeseThumbView* _tmp7_ = NULL;
	GtkTreePath* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GdkEventButton* _tmp15_ = NULL;
	GdkEventType _tmp16_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->x;
	_tmp3_ = event;
	_tmp4_ = _tmp3_->y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_gtk_tree_path_free0 (path);
	path = _tmp5_;
	_tmp6_ = path;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp7_ = self->priv->thumb_view;
	_tmp8_ = path;
	_tmp9_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp7_, _tmp8_);
	if (!_tmp9_) {
		CheeseThumbView* _tmp10_ = NULL;
		CheeseThumbView* _tmp11_ = NULL;
		GtkTreePath* _tmp12_ = NULL;
		CheeseThumbView* _tmp13_ = NULL;
		GtkTreePath* _tmp14_ = NULL;
		_tmp10_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp10_, "unselect-all");
		_tmp11_ = self->priv->thumb_view;
		_tmp12_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->thumb_view;
		_tmp14_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp13_, _tmp14_, NULL, FALSE);
	}
	_tmp15_ = event;
	_tmp16_ = _tmp15_->type;
	if (_tmp16_ == GDK_BUTTON_PRESS) {
		GdkEvent* button_press = NULL;
		GdkEventButton* _tmp17_ = NULL;
		GdkEvent* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = event;
		button_press = (GdkEvent*) _tmp17_;
		_tmp18_ = button_press;
		_tmp19_ = gdk_event_triggers_context_menu (_tmp18_);
		if (_tmp19_) {
			CheeseThumbView* _tmp20_ = NULL;
			GdkEventButton* _tmp21_ = NULL;
			guint _tmp22_ = 0U;
			GdkEventButton* _tmp23_ = NULL;
			guint32 _tmp24_ = 0U;
			_tmp20_ = self->priv->thumb_view;
			_tmp21_ = event;
			_tmp22_ = _tmp21_->button;
			_tmp23_ = event;
			_tmp24_ = _tmp23_->time;
			cheese_main_window_do_thumb_view_popup_menu (self, (GtkWidget*) _tmp20_, _tmp22_, (guint) _tmp24_);
			result = TRUE;
			_gtk_tree_path_free0 (path);
			return result;
		}
	} else {
		GdkEventButton* _tmp25_ = NULL;
		GdkEventType _tmp26_ = 0;
		_tmp25_ = event;
		_tmp26_ = _tmp25_->type;
		if (_tmp26_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (self);
			result = TRUE;
			_gtk_tree_path_free0 (path);
			return result;
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   */
static void cheese_main_window_on_file_open (CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GdkScreen* _tmp7_ = NULL;
		GdkScreen* _tmp8_ = NULL;
		GdkScreen* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		guint32 _tmp11_ = 0U;
		_tmp4_ = filename;
		_tmp5_ = g_filename_to_uri (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (uri);
		uri = _tmp6_;
		_tmp7_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (screen);
		screen = _tmp8_;
		_tmp9_ = screen;
		_tmp10_ = uri;
		_tmp11_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp3_);
			goto __catch4_g_error;
		}
		_g_free0 (_tmp3_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GtkMessageDialog* error_dialog = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		GtkMessageDialog* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _ ("Could not open %s");
		_tmp13_ = filename;
		_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp12_, _tmp13_);
		g_object_ref_sink (_tmp14_);
		error_dialog = _tmp14_;
		_tmp15_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp15_);
		_tmp16_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp16_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   */
static void cheese_main_window_on_file_delete (CheeseMainWindow* self) {
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors = FALSE;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint files_length = 0U;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkMessageDialog* confirmation_dialog = NULL;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GtkMessageDialog* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkMessageDialog* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	const gchar* _tmp14_ = NULL;
	GtkMessageDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GtkMessageDialog* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	_tmp3_ = g_list_length (_tmp2_);
	files_length = _tmp3_;
	_tmp4_ = files_length;
	_tmp5_ = ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp4_);
	_tmp6_ = files_length;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp5_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	confirmation_dialog = _tmp7_;
	_tmp8_ = confirmation_dialog;
	_tmp9_ = _ ("_Cancel");
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_CANCEL);
	_tmp10_ = confirmation_dialog;
	_tmp11_ = _ ("_Delete");
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp12_ = confirmation_dialog;
	_tmp13_ = files_length;
	_tmp14_ = ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp13_);
	gtk_message_dialog_format_secondary_text (_tmp12_, "%s", _tmp14_);
	_tmp15_ = confirmation_dialog;
	_tmp16_ = gtk_dialog_run ((GtkDialog*) _tmp15_);
	response = _tmp16_;
	_tmp17_ = response;
	if (_tmp17_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp18_ = NULL;
		_tmp18_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp18_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp19_ = NULL;
				GFile* file = NULL;
				_tmp19_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp19_;
				{
					GFile* _tmp20_ = NULL;
					_tmp20_ = file;
					if (_tmp20_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp21_ = NULL;
						_tmp21_ = file;
						g_file_delete (_tmp21_, NULL, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch5_g_error;
						}
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* err = NULL;
						GError* _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp22_ = err;
						_tmp23_ = _tmp22_->message;
						g_warning ("cheese-window.vala:285: Unable to delete file: %s", _tmp23_);
						_tmp24_ = skip_all_errors;
						if (!_tmp24_) {
							GtkMessageDialog* error_dialog = NULL;
							GFile* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
							GtkMessageDialog* _tmp28_ = NULL;
							GtkMessageDialog* _tmp29_ = NULL;
							GtkMessageDialog* _tmp30_ = NULL;
							const gchar* _tmp31_ = NULL;
							GtkMessageDialog* _tmp32_ = NULL;
							GtkMessageDialog* _tmp33_ = NULL;
							GtkMessageDialog* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							GtkMessageDialog* _tmp38_ = NULL;
							_tmp25_ = file;
							_tmp26_ = g_file_get_path (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Could not delete %s", _tmp27_);
							g_object_ref_sink (_tmp28_);
							_tmp29_ = _tmp28_;
							_g_free0 (_tmp27_);
							error_dialog = _tmp29_;
							_tmp30_ = error_dialog;
							_tmp31_ = _ ("_Cancel");
							gtk_dialog_add_button ((GtkDialog*) _tmp30_, _tmp31_, (gint) GTK_RESPONSE_CANCEL);
							_tmp32_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp32_, "Skip", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp33_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp33_, "Skip all", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp34_ = error_dialog;
							_tmp35_ = gtk_dialog_run ((GtkDialog*) _tmp34_);
							error_response = _tmp35_;
							_tmp36_ = error_response;
							if (_tmp36_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp37_ = 0;
								_tmp37_ = error_response;
								if (_tmp37_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp38_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp38_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally5:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp39_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp39_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   */
static void cheese_main_window_on_file_trash (CheeseMainWindow* self) {
	GFile* file = NULL;
	GList* files = NULL;
	CheeseThumbView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				GList* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				GList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				GList* _tmp9_ = NULL;
				gconstpointer _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = files;
				_tmp6_ = g_list_length (_tmp5_);
				if (!(((guint) _tmp4_) < _tmp6_)) {
					break;
				}
				_tmp7_ = files;
				_tmp8_ = i;
				_tmp9_ = g_list_nth (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _tmp9_->data;
				_tmp11_ = _g_object_ref0 ((GFile*) _tmp10_);
				_g_object_unref0 (file);
				file = _tmp11_;
				_tmp12_ = file;
				if (_tmp12_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp13_ = NULL;
					_tmp13_ = file;
					g_file_trash (_tmp13_, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* err = NULL;
					GtkMessageDialog* error_dialog = NULL;
					const gchar* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					GtkMessageDialog* _tmp18_ = NULL;
					GtkMessageDialog* _tmp19_ = NULL;
					GtkMessageDialog* _tmp20_ = NULL;
					GtkMessageDialog* _tmp21_ = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = _ ("Could not move %s to trash");
					_tmp15_ = file;
					_tmp16_ = g_file_get_path (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp14_, _tmp17_);
					g_object_ref_sink (_tmp18_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					error_dialog = _tmp19_;
					_tmp20_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp20_);
					_tmp21_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp21_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   */
static void cheese_main_window_on_file_saveas (CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkFileChooserDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkFileChooserDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkFileChooserDialog* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = _ ("Save File");
	_tmp4_ = _ ("_Cancel");
	_tmp5_ = _ ("Save");
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp3_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp4_, GTK_RESPONSE_CANCEL, _tmp5_, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp6_;
	_tmp7_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp7_, TRUE);
	_tmp8_ = filename;
	_tmp9_ = g_filename_display_basename (_tmp8_);
	_g_free0 (basename);
	basename = _tmp9_;
	_tmp10_ = save_as_dialog;
	_tmp11_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp10_, _tmp11_);
	_tmp12_ = save_as_dialog;
	_tmp13_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp12_, _tmp13_);
	_tmp14_ = save_as_dialog;
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
	response = _tmp15_;
	_tmp16_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp16_);
	_tmp17_ = response;
	if (_tmp17_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GFile* src = NULL;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* dest = NULL;
		const gchar* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		_tmp18_ = save_as_dialog;
		_tmp19_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp18_);
		_g_free0 (target_filename);
		target_filename = _tmp19_;
		_tmp20_ = filename;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		src = _tmp21_;
		_tmp22_ = target_filename;
		_tmp23_ = g_file_new_for_path (_tmp22_);
		dest = _tmp23_;
		{
			GFile* _tmp24_ = NULL;
			GFile* _tmp25_ = NULL;
			_tmp24_ = src;
			_tmp25_ = dest;
			g_file_copy (_tmp24_, _tmp25_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* err = NULL;
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GtkMessageDialog* _tmp28_ = NULL;
			GtkMessageDialog* _tmp29_ = NULL;
			GtkMessageDialog* _tmp30_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = _ ("Could not save %s");
			_tmp27_ = target_filename;
			_tmp28_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp26_, _tmp27_);
			g_object_ref_sink (_tmp28_);
			error_dialog = _tmp28_;
			_tmp29_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp29_);
			_tmp30_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp30_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp31_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp31_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
     * Toggle fullscreen mode.
     *
     * @param fullscreen whether the window should be fullscreen
     */
void cheese_main_window_set_fullscreen (CheeseMainWindow* self, gboolean fullscreen) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen;
	cheese_main_window_set_fullscreen_mode (self, _tmp0_);
}


/**
     * Make the media capture mode actions sensitive.
     */
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkApplication* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_ = NULL;
	GtkApplication* _tmp9_ = NULL;
	GAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, TRUE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, TRUE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, TRUE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
     * Make the media capture mode actions insensitive.
     */
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	GSimpleAction* mode = NULL;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* effects = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkApplication* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* preferences = NULL;
	GtkApplication* _tmp8_ = NULL;
	GtkApplication* _tmp9_ = NULL;
	GAction* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (mode, FALSE);
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) _tmp5_, "effects");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	effects = _tmp7_;
	g_simple_action_set_enabled (effects, FALSE);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "preferences");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	preferences = _tmp11_;
	g_simple_action_set_enabled (preferences, FALSE);
	_g_object_unref0 (preferences);
	_g_object_unref0 (effects);
	_g_object_unref0 (mode);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_ = NULL;
	GList* formats = NULL;
	CheeseCamera* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	CheeseVideoFormat* format = NULL;
	gint width = 0;
	gint height = 0;
	CheeseMediaMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		_g_list_free0 (formats);
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			GSettings* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			GSettings* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint _tmp15_ = 0;
				GList* _tmp16_ = NULL;
				guint _tmp17_ = 0U;
				GList* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				GList* _tmp20_ = NULL;
				gconstpointer _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
				CheeseVideoFormat* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = formats;
				_tmp17_ = g_list_length (_tmp16_);
				if (!(((guint) _tmp15_) < _tmp17_)) {
					break;
				}
				_tmp18_ = formats;
				_tmp19_ = i;
				_tmp20_ = g_list_nth (_tmp18_, (guint) _tmp19_);
				_tmp21_ = _tmp20_->data;
				format = (CheeseVideoFormat*) _tmp21_;
				_tmp23_ = width;
				_tmp24_ = format;
				_tmp25_ = _tmp24_->width;
				if (_tmp23_ == _tmp25_) {
					gint _tmp26_ = 0;
					CheeseVideoFormat* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					_tmp26_ = height;
					_tmp27_ = format;
					_tmp28_ = _tmp27_->height;
					_tmp22_ = _tmp26_ == _tmp28_;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					CheeseCamera* _tmp29_ = NULL;
					CheeseVideoFormat* _tmp30_ = NULL;
					_tmp29_ = self->priv->camera;
					_tmp30_ = format;
					cheese_camera_set_video_format (_tmp29_, _tmp30_);
					break;
				}
			}
		}
	}
	_g_list_free0 (formats);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_ = NULL;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean __lambda4_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide (_tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_fullscreen ((GtkWindow*) self);
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((CheeseMainWindow*) self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	GSource* _tmp1_ = NULL;
	GSource* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


/**
     * Show the UI in fullscreen if there is any mouse activity.
     *
     * Start a new timeout at the end of every mouse pointer movement. All
     * timeouts will be cancelled, except one created during the last movement
     * event. Show() is called even if the button is not hidden.
     *
     * @param viewport the widget to check for mouse activity on
     * @param e the (unused) event
     */
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_window_unfullscreen ((GtkWindow*) self);
	gtk_window_maximize ((GtkWindow*) self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show (_tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		GtkWidget* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkClutterEmbed* _tmp7_ = NULL;
		g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _cheese_main_window_on_window_state_change_event_gtk_widget_window_state_event, self, 0);
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkBox* _tmp3_ = NULL;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkBox* _tmp4_ = NULL;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_set_no_show_all (_tmp5_, FALSE);
		_tmp6_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_show_all (_tmp6_);
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp7_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp7_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp8_ = FALSE;
		GtkWidget* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkClutterEmbed* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		gboolean _tmp15_ = FALSE;
		_tmp8_ = self->priv->is_wide_mode;
		if (_tmp8_) {
			GtkBox* _tmp9_ = NULL;
			_tmp9_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp9_);
		} else {
			GtkBox* _tmp10_ = NULL;
			_tmp10_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp10_);
		}
		_tmp11_ = self->priv->leave_fullscreen_button_box;
		gtk_widget_hide (_tmp11_);
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp12_ = self->priv->buttons_area;
		gtk_widget_show (_tmp12_);
		_tmp13_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", gtk_widget_get_type (), &_tmp14_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
		_tmp15_ = self->priv->was_maximized;
		if (_tmp15_) {
			gtk_window_maximize ((GtkWindow*) self);
		} else {
			gtk_window_unmaximize ((GtkWindow*) self);
		}
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_ = FALSE;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_ = NULL;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	GtkRequisition req = {0};
	GtkRequisition _tmp35_ = {0};
	GtkRequisition _tmp36_ = {0};
	GtkRequisition _tmp37_ = {0};
	gint _tmp38_ = 0;
	GtkRequisition _tmp39_ = {0};
	gint _tmp40_ = 0;
	GtkClutterEmbed* _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_ = NULL;
		EogThumbNav* _tmp10_ = NULL;
		GtkBox* _tmp11_ = NULL;
		GList* _tmp12_ = NULL;
		GList* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GtkBox* _tmp17_ = NULL;
		EogThumbNav* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp9_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp9_, TRUE);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_ != NULL;
		_g_list_free0 (_tmp13_);
		if (_tmp14_) {
			GtkBox* _tmp15_ = NULL;
			EogThumbNav* _tmp16_ = NULL;
			_tmp15_ = self->priv->thumbnails_bottom;
			_tmp16_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		}
		_tmp17_ = self->priv->thumbnails_right;
		_tmp18_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->is_fullscreen;
		if (!_tmp19_) {
			GtkBox* _tmp20_ = NULL;
			GtkBox* _tmp21_ = NULL;
			_tmp20_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp20_);
			_tmp21_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp21_);
		}
	} else {
		CheeseThumbView* _tmp22_ = NULL;
		EogThumbNav* _tmp23_ = NULL;
		GtkBox* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		GList* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		GtkBox* _tmp30_ = NULL;
		EogThumbNav* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		_tmp22_ = self->priv->thumb_view;
		cheese_thumb_view_set_vertical (_tmp22_, FALSE);
		_tmp23_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp23_, FALSE);
		_tmp24_ = self->priv->thumbnails_right;
		_tmp25_ = gtk_container_get_children ((GtkContainer*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_ != NULL;
		_g_list_free0 (_tmp26_);
		if (_tmp27_) {
			GtkBox* _tmp28_ = NULL;
			EogThumbNav* _tmp29_ = NULL;
			_tmp28_ = self->priv->thumbnails_right;
			_tmp29_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
		}
		_tmp30_ = self->priv->thumbnails_bottom;
		_tmp31_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
		_tmp32_ = self->priv->is_fullscreen;
		if (!_tmp32_) {
			GtkBox* _tmp33_ = NULL;
			GtkBox* _tmp34_ = NULL;
			_tmp33_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp33_);
			_tmp34_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp34_);
		}
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp35_, &_tmp36_);
	req = _tmp35_;
	req = _tmp36_;
	_tmp37_ = req;
	_tmp38_ = _tmp37_.width;
	_tmp39_ = req;
	_tmp40_ = _tmp39_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp38_, _tmp40_);
	_tmp41_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp41_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterActor* _tmp0_ = NULL;
	ClutterStage* _tmp1_ = NULL;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	ClutterStage* _tmp4_ = NULL;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	ClutterActor* _tmp7_ = NULL;
	ClutterStage* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gfloat _tmp10_ = 0.0F;
	ClutterStage* _tmp11_ = NULL;
	gfloat _tmp12_ = 0.0F;
	gfloat _tmp13_ = 0.0F;
	ClutterText* _tmp14_ = NULL;
	ClutterTexture* _tmp15_ = NULL;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	ClutterStage* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterStage* _tmp21_ = NULL;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size (_tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->timeout_layer;
	_tmp15_ = self->priv->video_preview;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->viewport;
	_tmp19_ = clutter_actor_get_width ((ClutterActor*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->viewport;
	_tmp22_ = clutter_actor_get_height ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, (_tmp17_ / 3) + (_tmp20_ / 2), _tmp23_ - 20);
}


/**
   * The method to call when the countdown is finished.
   */
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	CheeseMediaMode _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		gchar* file_name = NULL;
		CheeseFileUtil* _tmp1_ = NULL;
		CheeseMediaMode _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		GtkWidget* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		CheeseCamera* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		file_name = _tmp3_;
		_tmp4_ = self->priv->settings;
		_tmp5_ = g_settings_get_boolean (_tmp4_, "flash");
		if (_tmp5_) {
			CheeseFlash* _tmp6_ = NULL;
			_tmp6_ = self->priv->flash;
			cheese_flash_fire (_tmp6_);
		}
		_tmp7_ = self->priv->main_vbox;
		_tmp8_ = _ ("Shutter sound");
		ca_gtk_play_for_widget (_tmp7_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp8_, NULL, NULL);
		_tmp9_ = self->priv->camera;
		_tmp10_ = file_name;
		cheese_camera_take_photo (_tmp9_, _tmp10_);
		_g_free0 (file_name);
	}
	_tmp11_ = self->priv->current_mode;
	if (_tmp11_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback ((CheeseMainWindow*) self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_ = 0;
		ClutterText* _tmp3_ = NULL;
		CheeseCountdown* _tmp4_ = NULL;
		CheeseCountdown* _tmp5_ = NULL;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			cheese_main_window_disable_mode_change (self);
		}
		_tmp3_ = self->priv->countdown_layer;
		_tmp4_ = cheese_countdown_new (_tmp3_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp4_;
		_tmp5_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp5_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		cheese_main_window_take_photo (self);
		_tmp5_ = self->priv->burst_count;
		self->priv->burst_count = _tmp5_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
     * Cancel the current action (if any)
     */
static gboolean cheese_main_window_cancel_running_action (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CheeseCountdown* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current_countdown;
	if (_tmp3_ != NULL) {
		CheeseCountdown* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->current_countdown;
		_tmp5_ = _tmp4_->running;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->is_bursting;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->is_recording;
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		CheeseMediaMode _tmp8_ = 0;
		self->priv->action_cancelled = TRUE;
		_tmp8_ = self->priv->current_mode;
		switch (_tmp8_) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				CheeseCountdown* _tmp9_ = NULL;
				_tmp9_ = self->priv->current_countdown;
				cheese_countdown_stop (_tmp9_);
				cheese_main_window_finish_countdown_callback (self);
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				cheese_main_window_toggle_photo_bursting (self, FALSE);
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				cheese_main_window_toggle_video_recording (self, FALSE);
				break;
			}
			default:
			break;
		}
		self->priv->action_cancelled = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = cheese_main_window_cancel_running_action (self);
		if (_tmp7_) {
			result = FALSE;
			_g_free0 (key);
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = self->priv->is_effects_selector_active;
			if (_tmp8_) {
				GtkToggleButton* _tmp9_ = NULL;
				_tmp9_ = self->priv->effects_toggle_button;
				gtk_toggle_button_set_active (_tmp9_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
static gboolean _cheese_main_window_update_timeout_layer_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_update_timeout_layer ((CheeseMainWindow*) self);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_ = NULL;
		CheeseFileUtil* _tmp2_ = NULL;
		CheeseMediaMode _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GtkButton* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GtkImage* _tmp8_ = NULL;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		cheese_camera_start_video_recording (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _cheese_main_window_update_timeout_layer_gsource_func, g_object_ref (self), g_object_unref);
		_tmp6_ = self->priv->take_action_button;
		_tmp7_ = _ ("Stop recording");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp7_);
		_tmp8_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp8_, "media-playback-stop-symbolic", GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp9_ = NULL;
		ClutterText* _tmp10_ = NULL;
		GtkButton* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		_tmp9_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp9_);
		_tmp10_ = self->priv->timeout_layer;
		clutter_text_set_text (_tmp10_, "00:00:00");
		_tmp11_ = self->priv->take_action_button;
		_tmp12_ = _ ("Record a video");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->take_action_button_image;
		gtk_image_set_from_icon_name (_tmp13_, "camera-web-symbolic", GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Update the timeout layer displayed timer.
   *
   * @return false, if the source, Timeout.add_seconds (used
   * in the toogle_video_recording method), should be removed.
   */
static gboolean cheese_main_window_update_timeout_layer (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_recording;
	if (_tmp0_) {
		ClutterText* _tmp1_ = NULL;
		CheeseCamera* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = self->priv->timeout_layer;
		_tmp2_ = self->priv->camera;
		_tmp3_ = cheese_camera_get_recorded_time (_tmp2_);
		_tmp4_ = _tmp3_;
		clutter_text_set_text (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo ((CheeseMainWindow*) self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkButton* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gint burst_delay = 0;
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint countdown_duration = 0;
		GSettings* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->take_action_button;
		_tmp2_ = _ ("Stop taking pictures");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp2_);
		cheese_main_window_burst_take_photo (self);
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-delay");
		burst_delay = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_int (_tmp5_, "countdown-duration");
		countdown_duration = 500 + (_tmp6_ * 1000);
		_tmp8_ = burst_delay;
		_tmp9_ = countdown_duration;
		if ((_tmp8_ - _tmp9_) < 1000) {
			GSettings* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = self->priv->settings;
			_tmp11_ = g_settings_get_boolean (_tmp10_, "countdown");
			_tmp7_ = _tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gint _tmp12_ = 0;
			guint _tmp13_ = 0U;
			_tmp12_ = countdown_duration;
			_tmp13_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp12_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp13_;
		} else {
			gint _tmp14_ = 0;
			guint _tmp15_ = 0U;
			_tmp14_ = burst_delay;
			_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp14_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp15_;
		}
	} else {
		gboolean _tmp16_ = FALSE;
		CheeseCountdown* _tmp17_ = NULL;
		GtkButton* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		CheeseFileUtil* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		_tmp17_ = self->priv->current_countdown;
		if (_tmp17_ != NULL) {
			CheeseCountdown* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp18_ = self->priv->current_countdown;
			_tmp19_ = _tmp18_->running;
			_tmp16_ = _tmp19_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			CheeseCountdown* _tmp20_ = NULL;
			_tmp20_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp20_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp21_ = self->priv->take_action_button;
		_tmp22_ = _ ("Take multiple photos");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, _tmp22_);
		self->priv->burst_count = 0;
		_tmp23_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp23_);
		_tmp24_ = self->priv->burst_callback_id;
		g_source_remove (_tmp24_);
	}
}


/**
     * Take a photo or burst of photos, or record a video, based on the current
     * capture mode.
     */
void cheese_main_window_shoot (CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_mode;
	switch (_tmp0_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			cheese_main_window_take_photo (self);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp1_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->is_bursting;
			cheese_main_window_toggle_photo_bursting (self, !_tmp2_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


/**
     * Show an error.
     *
     * @param error the error to display, or null to hide the error layer
     */
void cheese_main_window_show_error (CheeseMainWindow* self, const gchar* _error_) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_ = NULL;
		ClutterTexture* _tmp2_ = NULL;
		ClutterText* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		ClutterText* _tmp5_ = NULL;
		_tmp1_ = self->priv->current_effects_grid;
		clutter_actor_hide (_tmp1_);
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->error_layer;
		_tmp4_ = _error_;
		clutter_text_set_text (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp5_);
	} else {
		ClutterText* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->error_layer;
		clutter_actor_hide ((ClutterActor*) _tmp6_);
		_tmp7_ = self->priv->is_effects_selector_active;
		if (_tmp7_) {
			ClutterActor* _tmp8_ = NULL;
			_tmp8_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp8_);
		} else {
			ClutterTexture* _tmp9_ = NULL;
			_tmp9_ = self->priv->video_preview;
			clutter_actor_show ((ClutterActor*) _tmp9_);
		}
	}
}


/**
     * Toggle the display of the effect selector.
     *
     * @param effects whether effects should be enabled
     */
void cheese_main_window_set_effects (CheeseMainWindow* self, gboolean effects) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = effects;
	cheese_main_window_toggle_effects_selector (self, _tmp0_);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param tap unused
   * @param source the actor (with associated effect) that was selected
   */
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterTapAction* tap, ClutterActor* source) {
	GtkToggleButton* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	CheeseEffect* _tmp3_ = NULL;
	CheeseCamera* _tmp4_ = NULL;
	CheeseEffect* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	CheeseEffect* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->effects_toggle_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_tmp1_ = source;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "effect");
	_tmp3_ = _g_object_ref0 ((CheeseEffect*) _tmp2_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp3_;
	_tmp4_ = self->priv->camera;
	_tmp5_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->selected_effect;
	_tmp8_ = cheese_effect_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_string (_tmp6_, "selected-effect", _tmp9_);
}


/**
     * Navigate back one page of effects.
     */
static void cheese_main_window_on_effects_previous (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_window_is_previous_effects_page (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp1_) - 1);
	}
}


/**
     * Navigate forward one page of effects.
     */
static void cheese_main_window_on_effects_next (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_window_is_next_effects_page (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, ((gint) _tmp1_) + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	ClutterActor* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GList* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gconstpointer _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterActor* _tmp20_ = NULL;
	ClutterActor* _tmp21_ = NULL;
	guint i = 0U;
	CheeseEffectsManager* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = (guint) _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_actor_get_children (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterActor* _tmp8_ = NULL;
		ClutterActor* _tmp9_ = NULL;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_actor_remove_child (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = g_list_nth_data (_tmp10_, (guint) _tmp11_);
	_tmp13_ = _g_object_ref0 ((ClutterActor*) _tmp12_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp13_;
	_tmp14_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp14_, (guint) 0);
	_tmp15_ = self->priv->viewport_layout;
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_add_child (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->current_effects_grid;
	clutter_actor_save_easing_state (_tmp17_);
	_tmp18_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_mode (_tmp18_, CLUTTER_LINEAR);
	_tmp19_ = self->priv->current_effects_grid;
	clutter_actor_set_easing_duration (_tmp19_, (guint) 500);
	_tmp20_ = self->priv->current_effects_grid;
	clutter_actor_set_opacity (_tmp20_, (guint) 255);
	_tmp21_ = self->priv->current_effects_grid;
	clutter_actor_restore_easing_state (_tmp21_);
	i = (guint) 0;
	_tmp22_ = self->priv->effects_manager;
	_tmp23_ = _tmp22_->effects;
	{
		GList* effect_collection = NULL;
		GList* effect_it = NULL;
		effect_collection = _tmp23_;
		for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
			CheeseEffect* _tmp24_ = NULL;
			CheeseEffect* effect = NULL;
			_tmp24_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
			effect = _tmp24_;
			{
				guint page_nr = 0U;
				guint _tmp25_ = 0U;
				guint _tmp26_ = 0U;
				gint _tmp27_ = 0;
				guint _tmp40_ = 0U;
				_tmp25_ = i;
				page_nr = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = page_nr;
				_tmp27_ = number;
				if (_tmp26_ == ((guint) _tmp27_)) {
					CheeseEffect* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
					CheeseEffect* _tmp36_ = NULL;
					_tmp28_ = effect;
					_tmp29_ = cheese_effect_is_preview_connected (_tmp28_);
					if (!_tmp29_) {
						ClutterTexture* texture = NULL;
						CheeseEffect* _tmp30_ = NULL;
						gconstpointer _tmp31_ = NULL;
						ClutterTexture* _tmp32_ = NULL;
						CheeseCamera* _tmp33_ = NULL;
						CheeseEffect* _tmp34_ = NULL;
						ClutterTexture* _tmp35_ = NULL;
						_tmp30_ = effect;
						_tmp31_ = g_object_get_data ((GObject*) _tmp30_, "texture");
						_tmp32_ = _g_object_ref0 ((ClutterTexture*) _tmp31_);
						texture = _tmp32_;
						_tmp33_ = self->priv->camera;
						_tmp34_ = effect;
						_tmp35_ = texture;
						cheese_camera_connect_effect_texture (_tmp33_, _tmp34_, _tmp35_);
						_g_object_unref0 (texture);
					}
					_tmp36_ = effect;
					cheese_effect_enable_preview (_tmp36_);
				} else {
					CheeseEffect* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
					_tmp37_ = effect;
					_tmp38_ = cheese_effect_is_preview_connected (_tmp37_);
					if (_tmp38_) {
						CheeseEffect* _tmp39_ = NULL;
						_tmp39_ = effect;
						cheese_effect_disable_preview (_tmp39_);
					}
				}
				_tmp40_ = i;
				i = _tmp40_ + 1;
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
     * Control the sensitivity of the effects page navigation buttons.
     */
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	GSimpleAction* effects_next = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* effects_previous = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GSimpleAction* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects-next");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects_next = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "effects-previous");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	effects_previous = _tmp3_;
	_tmp5_ = self->priv->is_effects_selector_active;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = cheese_main_window_is_next_effects_page (self);
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = effects_next;
	g_simple_action_set_enabled (_tmp7_, _tmp4_);
	_tmp9_ = self->priv->is_effects_selector_active;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = cheese_main_window_is_previous_effects_page (self);
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = effects_previous;
	g_simple_action_set_enabled (_tmp11_, _tmp8_);
	_g_object_unref0 (effects_previous);
	_g_object_unref0 (effects_next);
}


static gboolean cheese_main_window_is_next_effects_page (CheeseMainWindow* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	CheeseEffectsManager* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = g_list_length (_tmp2_);
	result = ((_tmp0_ + 1) * EFFECTS_PER_PAGE) < _tmp3_;
	return result;
}


static gboolean cheese_main_window_is_previous_effects_page (CheeseMainWindow* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_effects_page;
	result = _tmp0_ != ((guint) 0);
	return result;
}


/**
     * Toggle the visibility of the effects selector.
     *
     * @param active whether the selector should be active
     */
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	CheeseCamera* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = self->priv->effects_grids;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp4_ = active;
		if (_tmp4_) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = _ ("No effects found");
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = NULL;
		}
		cheese_main_window_show_error (self, _tmp3_);
	} else {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = active;
		if (_tmp6_) {
			ClutterTexture* _tmp7_ = NULL;
			ClutterActor* _tmp8_ = NULL;
			guint _tmp9_ = 0U;
			_tmp7_ = self->priv->video_preview;
			clutter_actor_hide ((ClutterActor*) _tmp7_);
			_tmp8_ = self->priv->current_effects_grid;
			clutter_actor_show (_tmp8_);
			_tmp9_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, (gint) _tmp9_);
		} else {
			ClutterActor* _tmp10_ = NULL;
			ClutterTexture* _tmp11_ = NULL;
			_tmp10_ = self->priv->current_effects_grid;
			clutter_actor_hide (_tmp10_);
			_tmp11_ = self->priv->video_preview;
			clutter_actor_show ((ClutterActor*) _tmp11_);
		}
	}
	_tmp12_ = self->priv->camera;
	_tmp13_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp12_, _tmp13_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
	cheese_main_window_update_header_bar_title (self);
}


/**
   * Create the effects selector.
   */
static void _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self) {
	cheese_main_window_on_selected_effect_change ((CheeseMainWindow*) self, _sender, actor);
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_ = NULL;
		CheeseEffectsManager* _tmp2_ = NULL;
		CheeseEffectsManager* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		CheeseEffectsManager* _tmp6_ = NULL;
		GList* _tmp7_ = NULL;
		guint i = 0U;
		CheeseEffectsManager* _tmp17_ = NULL;
		GList* _tmp18_ = NULL;
		GList* _tmp77_ = NULL;
		gconstpointer _tmp78_ = NULL;
		ClutterActor* _tmp79_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
		self->priv->effects_grids = NULL;
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		_tmp5_ = g_list_length (_tmp4_);
		if (_tmp5_ == ((guint) 0)) {
			g_warning ("cheese-window.vala:1121: gnome-video-effects is not installed.");
			return;
		}
		_tmp6_ = self->priv->effects_manager;
		_tmp7_ = _tmp6_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp7_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp8_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp8_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp8_;
				{
					ClutterGridLayout* grid_layout = NULL;
					ClutterGridLayout* _tmp9_ = NULL;
					ClutterActor* grid = NULL;
					ClutterActor* _tmp10_ = NULL;
					ClutterActor* _tmp11_ = NULL;
					ClutterGridLayout* _tmp12_ = NULL;
					ClutterActor* _tmp13_ = NULL;
					ClutterActor* _tmp14_ = NULL;
					ClutterGridLayout* _tmp15_ = NULL;
					ClutterGridLayout* _tmp16_ = NULL;
					_tmp9_ = (ClutterGridLayout*) clutter_grid_layout_new ();
					g_object_ref_sink (_tmp9_);
					grid_layout = _tmp9_;
					_tmp10_ = clutter_actor_new ();
					g_object_ref_sink (_tmp10_);
					grid = _tmp10_;
					_tmp11_ = grid;
					_tmp12_ = grid_layout;
					clutter_actor_set_layout_manager (_tmp11_, (ClutterLayoutManager*) _tmp12_);
					_tmp13_ = grid;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					self->priv->effects_grids = g_list_append (self->priv->effects_grids, _tmp14_);
					_tmp15_ = grid_layout;
					clutter_grid_layout_set_column_spacing (_tmp15_, (guint) 10);
					_tmp16_ = grid_layout;
					clutter_grid_layout_set_row_spacing (_tmp16_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (effect);
				}
			}
		}
		i = (guint) 0;
		_tmp17_ = self->priv->effects_manager;
		_tmp18_ = _tmp17_->effects;
		{
			GList* effect_collection = NULL;
			GList* effect_it = NULL;
			effect_collection = _tmp18_;
			for (effect_it = effect_collection; effect_it != NULL; effect_it = effect_it->next) {
				CheeseEffect* _tmp19_ = NULL;
				CheeseEffect* effect = NULL;
				_tmp19_ = _g_object_ref0 ((CheeseEffect*) effect_it->data);
				effect = _tmp19_;
				{
					ClutterTexture* texture = NULL;
					ClutterTexture* _tmp20_ = NULL;
					ClutterBinLayout* layout = NULL;
					ClutterBinLayout* _tmp21_ = NULL;
					ClutterActor* box = NULL;
					ClutterActor* _tmp22_ = NULL;
					ClutterActor* _tmp23_ = NULL;
					ClutterBinLayout* _tmp24_ = NULL;
					ClutterText* text = NULL;
					ClutterText* _tmp25_ = NULL;
					ClutterActor* rect = NULL;
					ClutterActor* _tmp26_ = NULL;
					ClutterActor* _tmp27_ = NULL;
					ClutterActor* _tmp28_ = NULL;
					ClutterColor _tmp29_ = {0};
					ClutterTexture* _tmp30_ = NULL;
					ClutterActor* _tmp31_ = NULL;
					ClutterTexture* _tmp32_ = NULL;
					ClutterActor* _tmp33_ = NULL;
					ClutterTapAction* tap = NULL;
					ClutterTapAction* _tmp34_ = NULL;
					ClutterActor* _tmp35_ = NULL;
					ClutterTapAction* _tmp36_ = NULL;
					ClutterTapAction* _tmp37_ = NULL;
					ClutterActor* _tmp38_ = NULL;
					CheeseEffect* _tmp39_ = NULL;
					CheeseEffect* _tmp40_ = NULL;
					CheeseEffect* _tmp41_ = NULL;
					ClutterTexture* _tmp42_ = NULL;
					ClutterTexture* _tmp43_ = NULL;
					ClutterText* _tmp44_ = NULL;
					CheeseEffect* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					ClutterText* _tmp48_ = NULL;
					ClutterColor _tmp49_ = {0};
					ClutterActor* _tmp50_ = NULL;
					ClutterText* _tmp51_ = NULL;
					gfloat _tmp52_ = 0.0F;
					gfloat _tmp53_ = 0.0F;
					ClutterActor* _tmp54_ = NULL;
					ClutterActor* _tmp55_ = NULL;
					ClutterActor* _tmp56_ = NULL;
					ClutterActor* _tmp57_ = NULL;
					ClutterActor* _tmp58_ = NULL;
					ClutterActor* _tmp59_ = NULL;
					ClutterText* _tmp60_ = NULL;
					ClutterText* _tmp61_ = NULL;
					ClutterText* _tmp62_ = NULL;
					ClutterText* _tmp63_ = NULL;
					ClutterActor* _tmp64_ = NULL;
					ClutterText* _tmp65_ = NULL;
					ClutterGridLayout* grid_layout = NULL;
					GList* _tmp66_ = NULL;
					guint _tmp67_ = 0U;
					gconstpointer _tmp68_ = NULL;
					ClutterLayoutManager* _tmp69_ = NULL;
					ClutterLayoutManager* _tmp70_ = NULL;
					ClutterGridLayout* _tmp71_ = NULL;
					ClutterGridLayout* _tmp72_ = NULL;
					ClutterActor* _tmp73_ = NULL;
					guint _tmp74_ = 0U;
					guint _tmp75_ = 0U;
					guint _tmp76_ = 0U;
					_tmp20_ = (ClutterTexture*) clutter_texture_new ();
					g_object_ref_sink (_tmp20_);
					texture = _tmp20_;
					_tmp21_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					g_object_ref_sink (_tmp21_);
					layout = _tmp21_;
					_tmp22_ = clutter_actor_new ();
					g_object_ref_sink (_tmp22_);
					box = _tmp22_;
					_tmp23_ = box;
					_tmp24_ = layout;
					clutter_actor_set_layout_manager (_tmp23_, (ClutterLayoutManager*) _tmp24_);
					_tmp25_ = (ClutterText*) clutter_text_new ();
					g_object_ref_sink (_tmp25_);
					text = _tmp25_;
					_tmp26_ = clutter_actor_new ();
					g_object_ref_sink (_tmp26_);
					rect = _tmp26_;
					_tmp27_ = rect;
					clutter_actor_set_opacity (_tmp27_, (guint) 128);
					_tmp28_ = rect;
					clutter_color_from_string (&_tmp29_, "black");
					clutter_actor_set_background_color (_tmp28_, &_tmp29_);
					_tmp30_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp30_, TRUE);
					_tmp31_ = box;
					_tmp32_ = texture;
					clutter_actor_add_child (_tmp31_, (ClutterActor*) _tmp32_);
					_tmp33_ = box;
					clutter_actor_set_reactive (_tmp33_, TRUE);
					_tmp34_ = (ClutterTapAction*) clutter_tap_action_new ();
					g_object_ref_sink (_tmp34_);
					tap = _tmp34_;
					_tmp35_ = box;
					_tmp36_ = tap;
					clutter_actor_add_action (_tmp35_, (ClutterAction*) _tmp36_);
					_tmp37_ = tap;
					g_signal_connect_object (_tmp37_, "tap", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_tap_action_tap, self, 0);
					_tmp38_ = box;
					_tmp39_ = effect;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					g_object_set_data_full ((GObject*) _tmp38_, "effect", _tmp40_, g_object_unref);
					_tmp41_ = effect;
					_tmp42_ = texture;
					_tmp43_ = _g_object_ref0 (_tmp42_);
					g_object_set_data_full ((GObject*) _tmp41_, "texture", _tmp43_, g_object_unref);
					_tmp44_ = text;
					_tmp45_ = effect;
					_tmp46_ = cheese_effect_get_name (_tmp45_);
					_tmp47_ = _tmp46_;
					clutter_text_set_text (_tmp44_, _tmp47_);
					_tmp48_ = text;
					clutter_color_from_string (&_tmp49_, "white");
					clutter_text_set_color (_tmp48_, &_tmp49_);
					_tmp50_ = rect;
					_tmp51_ = text;
					_tmp52_ = clutter_actor_get_height ((ClutterActor*) _tmp51_);
					_tmp53_ = _tmp52_;
					clutter_actor_set_height (_tmp50_, _tmp53_ + 5);
					_tmp54_ = rect;
					clutter_actor_set_x_align (_tmp54_, CLUTTER_ACTOR_ALIGN_FILL);
					_tmp55_ = rect;
					clutter_actor_set_y_align (_tmp55_, CLUTTER_ACTOR_ALIGN_END);
					_tmp56_ = rect;
					clutter_actor_set_x_expand (_tmp56_, TRUE);
					_tmp57_ = rect;
					clutter_actor_set_y_expand (_tmp57_, TRUE);
					_tmp58_ = box;
					_tmp59_ = rect;
					clutter_actor_add_child (_tmp58_, _tmp59_);
					_tmp60_ = text;
					clutter_actor_set_x_align ((ClutterActor*) _tmp60_, CLUTTER_ACTOR_ALIGN_CENTER);
					_tmp61_ = text;
					clutter_actor_set_y_align ((ClutterActor*) _tmp61_, CLUTTER_ACTOR_ALIGN_END);
					_tmp62_ = text;
					clutter_actor_set_x_expand ((ClutterActor*) _tmp62_, TRUE);
					_tmp63_ = text;
					clutter_actor_set_y_expand ((ClutterActor*) _tmp63_, TRUE);
					_tmp64_ = box;
					_tmp65_ = text;
					clutter_actor_add_child (_tmp64_, (ClutterActor*) _tmp65_);
					_tmp66_ = self->priv->effects_grids;
					_tmp67_ = i;
					_tmp68_ = g_list_nth_data (_tmp66_, _tmp67_ / EFFECTS_PER_PAGE);
					_tmp69_ = clutter_actor_get_layout_manager ((ClutterActor*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, clutter_grid_layout_get_type ()) ? ((ClutterGridLayout*) _tmp70_) : NULL);
					grid_layout = _tmp71_;
					_tmp72_ = grid_layout;
					_tmp73_ = box;
					_tmp74_ = i;
					_tmp75_ = i;
					clutter_grid_layout_attach (_tmp72_, _tmp73_, ((gint) (_tmp74_ % EFFECTS_PER_PAGE)) % 3, ((gint) (_tmp75_ % EFFECTS_PER_PAGE)) / 3, 1, 1);
					_tmp76_ = i;
					i = _tmp76_ + 1;
					_g_object_unref0 (grid_layout);
					_g_object_unref0 (tap);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp77_ = self->priv->effects_grids;
		_tmp78_ = g_list_nth_data (_tmp77_, (guint) 0);
		_tmp79_ = _g_object_ref0 ((ClutterActor*) _tmp78_);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp79_;
	}
}


/**
     * Update the UI when the camera starts playing.
     */
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self) {
	CheeseEffect* effect = NULL;
	CheeseEffectsManager* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	CheeseEffect* _tmp4_ = NULL;
	CheeseEffect* _tmp5_ = NULL;
	CheeseEffect* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	cheese_main_window_show_error (self, NULL);
	_tmp0_ = self->priv->effects_manager;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "selected-effect");
	_tmp3_ = _tmp2_;
	_tmp4_ = cheese_effects_manager_get_effect (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	effect = _tmp5_;
	_tmp6_ = effect;
	if (_tmp6_ != NULL) {
		CheeseCamera* _tmp7_ = NULL;
		CheeseEffect* _tmp8_ = NULL;
		_tmp7_ = self->priv->camera;
		_tmp8_ = effect;
		cheese_camera_set_effect (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (effect);
}


/**
     * Report an error as the camerabin switched to the NULL state.
     */
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self) {
	ClutterText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	cheese_main_window_cancel_running_action (self);
	_tmp0_ = self->priv->error_layer;
	g_object_get ((ClutterActor*) _tmp0_, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("There was an error playing video from the webcam");
		cheese_main_window_show_error (self, _tmp3_);
	}
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize ((CheeseMainWindow*) self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumb_view_popup_menu ((CheeseMainWindow*) self, _sender);
	return result;
}


static gboolean _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_button_press_event ((CheeseMainWindow*) self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release ((CheeseMainWindow*) self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	ClutterScript* _tmp0_ = NULL;
	CheeseFileUtil* _tmp1_ = NULL;
	CheeseFlash* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GMenu* menu = NULL;
	GtkApplication* _tmp4_ = NULL;
	GtkApplication* _tmp5_ = NULL;
	GMenu* _tmp6_ = NULL;
	GMenu* _tmp7_ = NULL;
	GtkMenu* _tmp8_ = NULL;
	GtkClutterEmbed* _tmp11_ = NULL;
	ClutterActor* _tmp12_ = NULL;
	ClutterStage* _tmp13_ = NULL;
	ClutterScript* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	ClutterTexture* _tmp16_ = NULL;
	ClutterScript* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterScript* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	ClutterBinLayout* _tmp22_ = NULL;
	ClutterScript* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	ClutterText* _tmp25_ = NULL;
	ClutterScript* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	ClutterActor* _tmp28_ = NULL;
	ClutterScript* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	ClutterText* _tmp31_ = NULL;
	ClutterScript* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	ClutterText* _tmp34_ = NULL;
	ClutterTexture* _tmp35_ = NULL;
	ClutterTexture* _tmp36_ = NULL;
	ClutterStage* _tmp37_ = NULL;
	ClutterActor* _tmp38_ = NULL;
	ClutterActor* _tmp39_ = NULL;
	ClutterBinLayout* _tmp40_ = NULL;
	ClutterStage* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterStage* _tmp43_ = NULL;
	ClutterText* _tmp44_ = NULL;
	ClutterStage* _tmp45_ = NULL;
	CheeseThumbView* _tmp46_ = NULL;
	CheeseThumbView* _tmp47_ = NULL;
	EogThumbNav* _tmp48_ = NULL;
	GtkMenu* _tmp49_ = NULL;
	CheeseThumbView* _tmp50_ = NULL;
	CheeseThumbView* _tmp51_ = NULL;
	GtkCssProvider* css = NULL;
	GdkScreen* _tmp55_ = NULL;
	GdkScreen* _tmp56_ = NULL;
	CheeseThumbView* _tmp57_ = NULL;
	GtkClutterEmbed* _tmp58_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp0_;
	_tmp1_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp1_;
	_tmp2_ = cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_application_get_menu_by_id (_tmp5_, "thumbview-menu");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	menu = _tmp7_;
	_tmp8_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) menu);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp8_;
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_MAIN_WINDOW_actions, G_N_ELEMENTS (CHEESE_MAIN_WINDOW_actions), self);
	{
		ClutterScript* _tmp9_ = NULL;
		_tmp9_ = self->priv->clutter_builder;
		clutter_script_load_from_resource (_tmp9_, "/org/gnome/Cheese/cheese-viewport.json", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp10_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = err->message;
		g_error ("cheese-window.vala:1234: Error: %s", _tmp10_);
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = self->priv->viewport_widget;
	_tmp12_ = gtk_clutter_embed_get_stage (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp13_;
	_tmp14_ = self->priv->clutter_builder;
	_tmp15_ = clutter_script_get_object (_tmp14_, "video_preview");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, clutter_texture_get_type ()) ? ((ClutterTexture*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp16_;
	_tmp17_ = self->priv->clutter_builder;
	_tmp18_ = clutter_script_get_object (_tmp17_, "viewport_layout");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp19_;
	_tmp20_ = self->priv->clutter_builder;
	_tmp21_ = clutter_script_get_object (_tmp20_, "viewport_layout_manager");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, clutter_bin_layout_get_type ()) ? ((ClutterBinLayout*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp22_;
	_tmp23_ = self->priv->clutter_builder;
	_tmp24_ = clutter_script_get_object (_tmp23_, "countdown_layer");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, clutter_text_get_type ()) ? ((ClutterText*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp25_;
	_tmp26_ = self->priv->clutter_builder;
	_tmp27_ = clutter_script_get_object (_tmp26_, "background");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp28_;
	_tmp29_ = self->priv->clutter_builder;
	_tmp30_ = clutter_script_get_object (_tmp29_, "error_layer");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, clutter_text_get_type ()) ? ((ClutterText*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp31_;
	_tmp32_ = self->priv->clutter_builder;
	_tmp33_ = clutter_script_get_object (_tmp32_, "timeout_layer");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, clutter_text_get_type ()) ? ((ClutterText*) _tmp33_) : NULL);
	_g_object_unref0 (self->priv->timeout_layer);
	self->priv->timeout_layer = _tmp34_;
	_tmp35_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp35_, TRUE);
	_tmp36_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp36_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp37_ = self->priv->viewport;
	_tmp38_ = self->priv->background_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp37_, _tmp38_);
	_tmp39_ = self->priv->viewport_layout;
	_tmp40_ = self->priv->viewport_layout_manager;
	clutter_actor_set_layout_manager (_tmp39_, (ClutterLayoutManager*) _tmp40_);
	_tmp41_ = self->priv->viewport;
	_tmp42_ = self->priv->viewport_layout;
	clutter_actor_add_child ((ClutterActor*) _tmp41_, _tmp42_);
	_tmp43_ = self->priv->viewport;
	_tmp44_ = self->priv->timeout_layer;
	clutter_actor_add_child ((ClutterActor*) _tmp43_, (ClutterActor*) _tmp44_);
	_tmp45_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp45_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp46_ = cheese_thumb_view_new ();
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp46_;
	_tmp47_ = self->priv->thumb_view;
	_tmp48_ = eog_thumb_nav_new ((GtkWidget*) _tmp47_, FALSE);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp48_;
	_tmp49_ = self->priv->thumbnail_popup;
	_tmp50_ = self->priv->thumb_view;
	gtk_menu_attach_to_widget (_tmp49_, (GtkWidget*) _tmp50_, NULL);
	_tmp51_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp51_, "popup-menu", (GCallback) _cheese_main_window_on_thumb_view_popup_menu_gtk_widget_popup_menu, self, 0);
	{
		GFile* file = NULL;
		GFile* _tmp52_ = NULL;
		GtkCssProvider* _tmp53_ = NULL;
		_tmp52_ = g_file_new_for_uri ("resource:///org/gnome/Cheese/cheese.css");
		file = _tmp52_;
		_tmp53_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp53_;
		gtk_css_provider_load_from_file (css, file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch9_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp54_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp54_ = e->message;
		g_error ("cheese-window.vala:1272: Error parsing CSS: %s\n", _tmp54_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css);
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp55_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp56_ = _tmp55_;
	gtk_style_context_add_provider_for_screen (_tmp56_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp57_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp57_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp58_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp58_);
	cheese_main_window_set_wide_mode (self, FALSE);
	cheese_main_window_setup_effects_selector (self);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (css);
	_g_object_unref0 (menu);
}


ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self) {
	ClutterTexture* result = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->video_preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_ = NULL;
	CheeseFileUtil* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_ = NULL;
	CheeseFileUtil* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * @param mode the media mode to set
     */
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_ = 0;
	CheeseMediaMode _tmp1_ = 0;
	ClutterText* _tmp2_ = NULL;
	CheeseMediaMode _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	cheese_main_window_update_header_bar_title (self);
	_tmp2_ = self->priv->timeout_layer;
	clutter_actor_hide ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->current_mode;
	switch (_tmp3_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkButton* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = self->priv->take_action_button;
			_tmp5_ = _ ("Take a photo using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _tmp5_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkButton* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			ClutterText* _tmp8_ = NULL;
			ClutterText* _tmp9_ = NULL;
			_tmp6_ = self->priv->take_action_button;
			_tmp7_ = _ ("Record a video using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp7_);
			_tmp8_ = self->priv->timeout_layer;
			clutter_text_set_text (_tmp8_, "00:00:00");
			_tmp9_ = self->priv->timeout_layer;
			clutter_actor_show ((ClutterActor*) _tmp9_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkButton* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = self->priv->take_action_button;
			_tmp11_ = _ ("Take multiple photos using a webcam");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp11_);
			break;
		}
		default:
		break;
	}
}


/**
     * Set the header bar title.
     */
static void cheese_main_window_update_header_bar_title (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Choose an Effect");
		cheese_main_window_set_window_title (self, _tmp1_);
	} else {
		CheeseMediaMode _tmp2_ = 0;
		_tmp2_ = self->priv->current_mode;
		switch (_tmp2_) {
			case CHEESE_MEDIA_MODE_PHOTO:
			{
				const gchar* _tmp3_ = NULL;
				_tmp3_ = _ ("Take a Photo");
				cheese_main_window_set_window_title (self, _tmp3_);
				break;
			}
			case CHEESE_MEDIA_MODE_VIDEO:
			{
				const gchar* _tmp4_ = NULL;
				_tmp4_ = _ ("Record a Video");
				cheese_main_window_set_window_title (self, _tmp4_);
				break;
			}
			case CHEESE_MEDIA_MODE_BURST:
			{
				const gchar* _tmp5_ = NULL;
				_tmp5_ = _ ("Take Multiple Photos");
				cheese_main_window_set_window_title (self, _tmp5_);
				break;
			}
			default:
			break;
		}
	}
}


/**
     * Set the camera.
     *
     * @param camera the camera to set
     */
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera) {
	CheeseCamera* _tmp0_ = NULL;
	CheeseCamera* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	gint CheeseMainWindow_private_offset;
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
	CheeseMainWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Cheese/cheese-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "viewport_widget", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, viewport_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, main_vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_right", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thumbnails_bottom", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, thumbnails_bottom));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "leave_fullscreen_button_box", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, leave_fullscreen_button_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "take_action_button_image", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, take_action_button_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "effects_toggle_button", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, effects_toggle_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "buttons_area", FALSE, CheeseMainWindow_private_offset + G_STRUCT_OFFSET (CheeseMainWindowPrivate, buttons_area));
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	GtkBuilder* _tmp0_ = NULL;
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Cheese/headerbar.ui");
	self->priv->header_bar_ui = _tmp0_;
	self->priv->current_effects_page = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->header_bar_ui);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->leave_fullscreen_button_box);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->timeout_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	__g_list_free__g_object_unref0_0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}



