/* game-view.c generated by valac 0.25.3.8-962c2, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	gint current_level;
	GList* actor_remove_queue;
	ClutterActor* board_group;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

void setup_animation (ClutterActor* actor, ClutterAnimationMode mode, guint duration);
GType game_view_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


void setup_animation (ClutterActor* actor, ClutterAnimationMode mode, guint duration) {
	ClutterActor* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	ClutterActor* _tmp2_ = NULL;
	ClutterAnimationMode _tmp3_ = 0;
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	_tmp1_ = duration;
	clutter_actor_set_easing_duration (_tmp0_, _tmp1_);
	_tmp2_ = actor;
	_tmp3_ = mode;
	clutter_actor_set_easing_mode (_tmp2_, _tmp3_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp20_ = NULL;
	ClutterTexture* _tmp21_ = NULL;
	ClutterTexture* _tmp22_ = NULL;
	ClutterTexture* _tmp23_ = NULL;
	ClutterTexture* _tmp24_ = NULL;
	ClutterTexture* _tmp25_ = NULL;
	ClutterActor* _tmp26_ = NULL;
	ClutterActor* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	BoardView* _tmp30_ = NULL;
	BoardView* _tmp31_ = NULL;
	ClutterActor* _tmp32_ = NULL;
	BoardView* _tmp33_ = NULL;
	gfloat real_board_width = 0.0F;
	ClutterTexture* _tmp34_ = NULL;
	gfloat _tmp35_ = 0.0F;
	gfloat _tmp36_ = 0.0F;
	gfloat real_board_height = 0.0F;
	ClutterTexture* _tmp37_ = NULL;
	gfloat _tmp38_ = 0.0F;
	gfloat _tmp39_ = 0.0F;
	ClutterTexture* _tmp40_ = NULL;
	ClutterClone* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
	ClutterActor* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	{
		ClutterTexture* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		ClutterTexture* _tmp3_ = NULL;
		ClutterTexture* _tmp4_ = NULL;
		ClutterTexture* _tmp5_ = NULL;
		ClutterTexture* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		ClutterTexture* _tmp9_ = NULL;
		ClutterTexture* _tmp10_ = NULL;
		ClutterTexture* _tmp11_ = NULL;
		ClutterTexture* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		ClutterTexture* _tmp15_ = NULL;
		ClutterTexture* _tmp16_ = NULL;
		ClutterTexture* _tmp17_ = NULL;
		_tmp1_ = g_build_filename (DATADIR, "highlight.svg", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp2_, &_inner_error_);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->highlight_texture);
		self->priv->highlight_texture = _tmp5_;
		_tmp7_ = g_build_filename (DATADIR, "off.svg", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp8_, &_inner_error_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (self->priv->off_texture);
		self->priv->off_texture = _tmp11_;
		_tmp13_ = g_build_filename (DATADIR, "on.svg", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp14_, &_inner_error_);
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->on_texture);
		self->priv->on_texture = _tmp17_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("game-view.vala:52: Failed to load textures: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = self->priv->highlight_texture;
	clutter_actor_hide ((ClutterActor*) _tmp20_);
	_tmp21_ = self->priv->highlight_texture;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp21_);
	_tmp22_ = self->priv->off_texture;
	clutter_actor_hide ((ClutterActor*) _tmp22_);
	_tmp23_ = self->priv->off_texture;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp23_);
	_tmp24_ = self->priv->on_texture;
	clutter_actor_hide ((ClutterActor*) _tmp24_);
	_tmp25_ = self->priv->on_texture;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp25_);
	_tmp26_ = clutter_actor_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->board_group);
	self->priv->board_group = _tmp26_;
	_tmp27_ = self->priv->board_group;
	clutter_actor_add_child ((ClutterActor*) self, _tmp27_);
	_tmp28_ = level;
	self->priv->current_level = _tmp28_;
	_tmp29_ = self->priv->current_level;
	_tmp30_ = game_view_create_board_view (self, _tmp29_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp30_;
	_tmp31_ = self->priv->board_view;
	_tmp31_->playable = TRUE;
	_tmp32_ = self->priv->board_group;
	_tmp33_ = self->priv->board_view;
	clutter_actor_add_child (_tmp32_, (ClutterActor*) _tmp33_);
	_tmp34_ = self->priv->off_texture;
	_tmp35_ = clutter_actor_get_width ((ClutterActor*) _tmp34_);
	_tmp36_ = _tmp35_;
	real_board_width = (5 * _tmp36_) + 4;
	_tmp37_ = self->priv->off_texture;
	_tmp38_ = clutter_actor_get_height ((ClutterActor*) _tmp37_);
	_tmp39_ = _tmp38_;
	real_board_height = (5 * _tmp39_) + 4;
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, real_board_height);
	_tmp40_ = self->priv->highlight_texture;
	_tmp41_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp40_);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->key_cursor_view);
	self->priv->key_cursor_view = (ClutterActor*) _tmp41_;
	_tmp42_ = self->priv->key_cursor_view;
	clutter_actor_set_position (_tmp42_, (gfloat) (-100), (gfloat) (-100));
	_tmp43_ = self->priv->key_cursor_view;
	g_object_set (_tmp43_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp44_ = self->priv->key_cursor_view;
	clutter_actor_add_child ((ClutterActor*) self, _tmp44_);
	return self;
}


GameView* game_view_new (gint level) {
	return game_view_construct (TYPE_GAME_VIEW, level);
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
	game_view_game_won_cb ((GameView*) self);
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	BoardView* view = NULL;
	ClutterTexture* _tmp0_ = NULL;
	ClutterTexture* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->off_texture;
	_tmp1_ = self->priv->on_texture;
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	view = _tmp2_;
	_tmp3_ = level;
	board_view_load_level (view, _tmp3_);
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
	view->playable = FALSE;
	result = view;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_ = NULL;
	BoardView* _tmp1_ = NULL;
	BoardView* _tmp2_ = NULL;
	BoardView* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_view;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->new_board_view;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp2_;
	_tmp3_ = self->priv->board_view;
	_tmp3_->playable = TRUE;
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = NULL;
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_tmp4_ = self->priv->actor_remove_queue;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp5_ = NULL;
			ClutterActor* actor = NULL;
			_tmp5_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp5_;
			{
				ClutterActor* _tmp6_ = NULL;
				_tmp6_ = actor;
				clutter_actor_destroy (_tmp6_);
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	self->priv->actor_remove_queue = NULL;
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_transition_complete_cb ((GameView*) self);
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	gint direction = 0;
	gint sign = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	BoardView* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	BoardView* _tmp19_ = NULL;
	ClutterTimeline* _tmp20_ = NULL;
	BoardView* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	ClutterTimeline* _tmp24_ = NULL;
	BoardView* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	ClutterTimeline* _tmp28_ = NULL;
	ClutterTimeline* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->current_level;
	self->priv->current_level = _tmp4_ + 1;
	direction = 0;
	sign = 0;
	{
		gboolean _tmp5_ = FALSE;
		_tmp5_ = TRUE;
		while (TRUE) {
			gint32 _tmp11_ = 0;
			gint _tmp12_ = 0;
			gboolean _tmp13_ = FALSE;
			if (!_tmp5_) {
				gboolean _tmp6_ = FALSE;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				_tmp7_ = self->priv->last_direction;
				_tmp8_ = direction;
				if (_tmp7_ == _tmp8_) {
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					_tmp9_ = self->priv->last_sign;
					_tmp10_ = sign;
					_tmp6_ = _tmp9_ == _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
			}
			_tmp5_ = FALSE;
			_tmp11_ = g_random_int_range ((gint32) 0, (gint32) 2);
			direction = (gint) _tmp11_;
			_tmp13_ = g_random_boolean ();
			if (_tmp13_) {
				_tmp12_ = 1;
			} else {
				_tmp12_ = -1;
			}
			sign = _tmp12_;
		}
	}
	_tmp14_ = direction;
	self->priv->last_direction = _tmp14_;
	_tmp15_ = sign;
	self->priv->last_sign = _tmp15_;
	_tmp16_ = self->priv->current_level;
	_tmp17_ = game_view_create_board_view (self, _tmp16_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp17_;
	_tmp18_ = self->priv->board_group;
	_tmp19_ = self->priv->new_board_view;
	clutter_actor_add_child (_tmp18_, (ClutterActor*) _tmp19_);
	_tmp20_ = clutter_timeline_new ((guint) 1500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp20_;
	_tmp21_ = self->priv->new_board_view;
	_tmp22_ = direction;
	_tmp23_ = sign;
	_tmp24_ = self->priv->timeline;
	board_view_slide_in (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->board_view;
	_tmp26_ = direction;
	_tmp27_ = sign;
	_tmp28_ = self->priv->timeline;
	board_view_slide_out (_tmp25_, _tmp26_, _tmp27_, _tmp28_);
	_tmp29_ = self->priv->timeline;
	g_signal_connect_object (_tmp29_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp30_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp30_);
}


void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ClutterTimeline* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	BoardView* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	BoardView* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	BoardView* _tmp14_ = NULL;
	BoardView* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ClutterTimeline* _tmp17_ = NULL;
	BoardView* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ClutterTimeline* _tmp20_ = NULL;
	ClutterTimeline* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->current_level;
	_tmp5_ = direction;
	self->priv->current_level = _tmp4_ + _tmp5_;
	_tmp6_ = self->priv->current_level;
	if (_tmp6_ <= 0) {
		self->priv->current_level = 1;
		return;
	}
	_tmp7_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp7_;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = game_view_create_board_view (self, _tmp8_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp9_;
	_tmp10_ = self->priv->board_group;
	_tmp11_ = self->priv->new_board_view;
	clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->new_board_view;
	_tmp13_ = direction;
	clutter_actor_set_z_position ((ClutterActor*) _tmp12_, (gfloat) ((-250) * _tmp13_));
	_tmp14_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp14_, (guint) 0);
	_tmp15_ = self->priv->new_board_view;
	_tmp16_ = direction;
	_tmp17_ = self->priv->timeline;
	board_view_swap_in (_tmp15_, (gfloat) _tmp16_, _tmp17_);
	_tmp18_ = self->priv->board_view;
	_tmp19_ = direction;
	_tmp20_ = self->priv->timeline;
	board_view_swap_out (_tmp18_, (gfloat) _tmp19_, _tmp20_);
	_tmp21_ = self->priv->timeline;
	g_signal_connect_object (_tmp21_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp22_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp22_);
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_view;
	setup_animation (_tmp0_, CLUTTER_EASE_OUT_SINE, (guint) 250);
	_tmp1_ = self->priv->key_cursor_view;
	clutter_actor_set_opacity (_tmp1_, (guint8) 0);
	self->priv->key_cursor_ready = FALSE;
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_ = FALSE;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp1_ = self->priv->key_cursor_x;
		_tmp2_ = x_step;
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
		_tmp3_ = self->priv->key_cursor_y;
		_tmp4_ = y_step;
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
		_tmp5_ = self->priv->key_cursor_x;
		_tmp6_ = MAX (_tmp5_, 0);
		self->priv->key_cursor_x = _tmp6_;
		_tmp7_ = self->priv->key_cursor_x;
		_tmp8_ = MIN (_tmp7_, 4);
		self->priv->key_cursor_x = _tmp8_;
		_tmp9_ = self->priv->key_cursor_y;
		_tmp10_ = MAX (_tmp9_, 0);
		self->priv->key_cursor_y = _tmp10_;
		_tmp11_ = self->priv->key_cursor_y;
		_tmp12_ = MIN (_tmp11_, 4);
		self->priv->key_cursor_y = _tmp12_;
	}
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->key_cursor_x;
	_tmp15_ = self->priv->key_cursor_y;
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = self->priv->key_cursor_ready;
	if (_tmp18_) {
		ClutterActor* _tmp19_ = NULL;
		ClutterActor* _tmp20_ = NULL;
		gfloat _tmp21_ = 0.0F;
		gfloat _tmp22_ = 0.0F;
		_tmp19_ = self->priv->key_cursor_view;
		setup_animation (_tmp19_, CLUTTER_EASE_OUT_SINE, (guint) 250);
		_tmp20_ = self->priv->key_cursor_view;
		_tmp21_ = x;
		_tmp22_ = y;
		clutter_actor_set_position (_tmp20_, _tmp21_, _tmp22_);
	} else {
		ClutterActor* _tmp23_ = NULL;
		ClutterActor* _tmp24_ = NULL;
		gfloat _tmp25_ = 0.0F;
		gfloat _tmp26_ = 0.0F;
		ClutterActor* _tmp27_ = NULL;
		ClutterActor* _tmp28_ = NULL;
		_tmp23_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp23_, (guint) 0);
		_tmp24_ = self->priv->key_cursor_view;
		_tmp25_ = x;
		_tmp26_ = y;
		clutter_actor_set_position (_tmp24_, _tmp25_, _tmp26_);
		_tmp27_ = self->priv->key_cursor_view;
		setup_animation (_tmp27_, CLUTTER_EASE_OUT_SINE, (guint) 250);
		_tmp28_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp28_, (guint8) 255);
	}
	self->priv->key_cursor_ready = TRUE;
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		BoardView* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->board_view;
		_tmp2_ = self->priv->key_cursor_x;
		_tmp3_ = self->priv->key_cursor_y;
		board_view_toggle_light (_tmp1_, _tmp2_, _tmp3_, TRUE);
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_ = NULL;
	ClutterTimeline* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	BoardView* _tmp6_ = NULL;
	ClutterActor* _tmp7_ = NULL;
	BoardView* _tmp8_ = NULL;
	BoardView* _tmp9_ = NULL;
	BoardView* _tmp10_ = NULL;
	BoardView* _tmp11_ = NULL;
	ClutterTimeline* _tmp12_ = NULL;
	BoardView* _tmp13_ = NULL;
	ClutterTimeline* _tmp14_ = NULL;
	ClutterTimeline* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->current_level = 1;
	_tmp4_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp4_;
	_tmp5_ = self->priv->current_level;
	_tmp6_ = game_view_create_board_view (self, _tmp5_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp6_;
	_tmp7_ = self->priv->board_group;
	_tmp8_ = self->priv->new_board_view;
	clutter_actor_add_child (_tmp7_, (ClutterActor*) _tmp8_);
	_tmp9_ = self->priv->new_board_view;
	clutter_actor_set_z_position ((ClutterActor*) _tmp9_, (gfloat) 250);
	_tmp10_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp10_, (guint) 0);
	_tmp11_ = self->priv->new_board_view;
	_tmp12_ = self->priv->timeline;
	board_view_swap_in (_tmp11_, (gfloat) (-1), _tmp12_);
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->timeline;
	board_view_swap_out (_tmp13_, (gfloat) (-1), _tmp14_);
	_tmp15_ = self->priv->timeline;
	g_signal_connect_object (_tmp15_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp16_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp16_);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->actor_remove_queue = NULL;
	self->priv->new_board_view = NULL;
	self->priv->key_cursor_x = 0;
	self->priv->key_cursor_y = 0;
	self->priv->key_cursor_ready = FALSE;
	self->priv->last_direction = 0;
	self->priv->last_sign = 0;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->highlight_texture);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	_g_object_unref0 (self->priv->board_group);
	_g_object_unref0 (self->priv->board_view);
	_g_object_unref0 (self->priv->new_board_view);
	_g_object_unref0 (self->priv->key_cursor_view);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



