/* ai.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>.*/
/*Here NEG_INF is supposed to be the lowest possible int value. int.MIN
MAX_HEURIST_VALUE is the maximum value that the heuristic functions can return.
It is returned when AI wins. -1*MAX_HEURIST_VALUE is returned when Human wins
MAX_HEURIST_VALUE < NEG_INF/plies */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "ai.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_DIFFICULTY (difficulty_get_type ())
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDecisionTree ParamSpecDecisionTree;

typedef enum  {
	PLAYER_NONE,
	PLAYER_HUMAN,
	PLAYER_AI
} Player;

typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

struct _DecisionTreePrivate {
	Player* board;
	gint board_length1;
	gint board_length2;
	gint plies;
	Player last_moving_player;
	gint next_move_in_column;
	Difficulty level;
};

struct _ParamSpecDecisionTree {
	GParamSpec parent_instance;
};


static gpointer decision_tree_parent_class = NULL;

#define NEG_INF (-100000)
#define MAX_HEURIST_VALUE 10000
#define BOARD_ROWS 6
#define BOARD_COLUMNS 7
GType player_get_type (void) G_GNUC_CONST;
GType difficulty_get_type (void) G_GNUC_CONST;
gint playgame (const gchar* moves_until_now);
#define DECISION_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DECISION_TREE, DecisionTreePrivate))
enum  {
	DECISION_TREE_DUMMY_PROPERTY
};
static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta);
static gboolean decision_tree_board_full (DecisionTree* self);
static gint decision_tree_heurist (DecisionTree* self);
static gboolean decision_tree_move (DecisionTree* self, gint i);
static gint decision_tree_victory (DecisionTree* self, gint i);
static void decision_tree_unmove (DecisionTree* self, gint i);
static gint decision_tree_vertical_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_horizontal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_immediate_win (DecisionTree* self, Player p);
static void decision_tree_set_level (DecisionTree* self, const gchar* vstr);
static gint decision_tree_heurist_easy (DecisionTree* self);
static gint decision_tree_heurist_medium (DecisionTree* self);
static gint decision_tree_heurist_hard (DecisionTree* self);
static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p);
static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j);
static void decision_tree_finalize (DecisionTree* obj);


GType player_get_type (void) {
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_HUMAN, "PLAYER_HUMAN", "human"}, {PLAYER_AI, "PLAYER_AI", "ai"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


GType difficulty_get_type (void) {
	static volatile gsize difficulty_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_MEDIUM, "DIFFICULTY_MEDIUM", "medium"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
		GType difficulty_type_id;
		difficulty_type_id = g_enum_register_static ("Difficulty", values);
		g_once_init_leave (&difficulty_type_id__volatile, difficulty_type_id);
	}
	return difficulty_type_id__volatile;
}


gint playgame (const gchar* moves_until_now) {
	gint result = 0;
	DecisionTree* t = NULL;
	DecisionTree* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 32 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (moves_until_now != NULL, 0);
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_new ();
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	t = _tmp0_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = moves_until_now;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_playgame (t, _tmp1_);
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp2_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_decision_tree_unref0 (t);
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 150 "ai.c"
}


DecisionTree* decision_tree_construct (GType object_type) {
	DecisionTree* self = NULL;
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self = (DecisionTree*) g_type_create_instance (object_type);
#line 158 "ai.c"
	{
		gint i = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 163 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 170 "ai.c"
				gint _tmp2_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 174 "ai.c"
					gint _tmp1_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 180 "ai.c"
				}
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 190 "ai.c"
				}
				{
					gint j = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = 0;
#line 196 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 203 "ai.c"
							gint _tmp5_ = 0;
							Player* _tmp6_ = NULL;
							gint _tmp6__length1 = 0;
							gint _tmp6__length2 = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Player _tmp9_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 213 "ai.c"
								gint _tmp4_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 219 "ai.c"
							}
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 229 "ai.c"
							}
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_ = self->priv->board;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6__length1 = self->priv->board_length1;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6__length2 = self->priv->board_length2;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = j;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_] = PLAYER_NONE;
#line 58 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 245 "ai.c"
						}
					}
				}
			}
		}
	}
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return self;
#line 254 "ai.c"
}


DecisionTree* decision_tree_new (void) {
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return decision_tree_construct (TYPE_DECISION_TREE);
#line 261 "ai.c"
}


void decision_tree_print_board (DecisionTree* self) {
	FILE* _tmp12_ = NULL;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 269 "ai.c"
	{
		gint i = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 274 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 281 "ai.c"
				gint _tmp2_ = 0;
				FILE* _tmp11_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 286 "ai.c"
					gint _tmp1_ = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 292 "ai.c"
				}
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 302 "ai.c"
				}
				{
					gint j = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = 0;
#line 308 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 315 "ai.c"
							gint _tmp5_ = 0;
							FILE* _tmp6_ = NULL;
							Player* _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							gint _tmp7__length2 = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							Player _tmp10_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 326 "ai.c"
								gint _tmp4_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 332 "ai.c"
							}
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 342 "ai.c"
							}
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_ = stdout;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = self->priv->board;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7__length1 = self->priv->board_length1;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7__length2 = self->priv->board_length2;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = i;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = j;
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 70 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							fprintf (_tmp6_, "%d\t", (gint) _tmp10_);
#line 360 "ai.c"
						}
					}
				}
#line 72 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = stdout;
#line 72 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				fprintf (_tmp11_, "\n");
#line 368 "ai.c"
			}
		}
	}
#line 74 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = stdout;
#line 74 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	fprintf (_tmp12_, "\n");
#line 376 "ai.c"
}


static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint max = 0;
	gint next = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = height;
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 0) {
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 396 "ai.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = decision_tree_board_full (self);
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = _tmp2_;
#line 403 "ai.c"
	}
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp0_) {
#line 407 "ai.c"
		Player _tmp3_ = 0;
#line 85 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = self->priv->last_moving_player;
#line 85 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp3_ == PLAYER_HUMAN) {
#line 413 "ai.c"
			gint _tmp4_ = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist (self);
#line 86 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 421 "ai.c"
		} else {
			Player _tmp5_ = 0;
#line 87 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp5_ = self->priv->last_moving_player;
#line 87 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp5_ == PLAYER_AI) {
#line 428 "ai.c"
				gint _tmp6_ = 0;
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = decision_tree_heurist (self);
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				result = (-1) * _tmp6_;
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				return result;
#line 436 "ai.c"
			} else {
#line 90 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				result = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				return result;
#line 442 "ai.c"
			}
		}
	}
#line 95 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	max = NEG_INF;
#line 99 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	next = -1;
#line 450 "ai.c"
	{
		gint i = 0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 455 "ai.c"
		{
			gboolean _tmp7_ = FALSE;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp7_ = TRUE;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 462 "ai.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp7_) {
#line 468 "ai.c"
					gint _tmp8_ = 0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = i;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp8_ + 1;
#line 474 "ai.c"
				}
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = FALSE;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp9_ = i;
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp9_ < BOARD_COLUMNS)) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 484 "ai.c"
				}
#line 104 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp10_ = i;
#line 104 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = decision_tree_move (self, _tmp10_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp11_) {
#line 492 "ai.c"
					gint temp = 0;
					Player _tmp12_ = 0;
					gint _tmp19_ = 0;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = self->priv->last_moving_player;
#line 110 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp12_ == PLAYER_HUMAN) {
#line 507 "ai.c"
						gint _tmp13_ = 0;
						gint _tmp14_ = 0;
						gint _tmp15_ = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp13_ = i;
#line 111 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp14_ = decision_tree_victory (self, _tmp13_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp15_ = height;
#line 111 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						temp = ((-1) * _tmp14_) * _tmp15_;
#line 519 "ai.c"
					} else {
						gint _tmp16_ = 0;
						gint _tmp17_ = 0;
						gint _tmp18_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp16_ = i;
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp17_ = decision_tree_victory (self, _tmp16_);
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp18_ = height;
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						temp = _tmp17_ * _tmp18_;
#line 532 "ai.c"
					}
#line 117 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = temp;
#line 117 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp19_ == 0) {
#line 538 "ai.c"
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp20_ = height;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp21_ = beta;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp22_ = alpha;
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp23_ = decision_tree_negamax (self, _tmp20_ - 1, (-1) * _tmp21_, (-1) * _tmp22_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						temp = (-1) * _tmp23_;
#line 553 "ai.c"
					}
#line 120 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = i;
#line 120 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					decision_tree_unmove (self, _tmp24_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25_ = temp;
#line 122 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp26_ = max;
#line 122 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp25_ > _tmp26_) {
#line 565 "ai.c"
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp27_ = i;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						next = _tmp27_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp28_ = temp;
#line 125 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						max = _tmp28_;
#line 576 "ai.c"
					}
#line 129 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp29_ = temp;
#line 129 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp30_ = alpha;
#line 129 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp29_ > _tmp30_) {
#line 584 "ai.c"
						gint _tmp31_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp31_ = temp;
#line 131 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						alpha = _tmp31_;
#line 590 "ai.c"
					}
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp32_ = alpha;
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp33_ = beta;
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp32_ >= _tmp33_) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						break;
#line 600 "ai.c"
					}
				}
			}
		}
	}
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp34_ = height;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp35_ = self->priv->plies;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp34_ == _tmp35_) {
#line 612 "ai.c"
		gint _tmp36_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp36_ = next;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->next_move_in_column = _tmp36_;
#line 618 "ai.c"
	}
#line 148 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = max;
#line 148 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 624 "ai.c"
}


static gint decision_tree_victory (DecisionTree* self, gint i) {
	gint result = 0;
	gint cell = 0;
	gint temp = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
#line 153 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 649 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		cell = 0;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 658 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 663 "ai.c"
				gint _tmp1_ = 0;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = cell;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				cell = _tmp1_ + 1;
#line 669 "ai.c"
			}
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = cell;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp3_ < BOARD_ROWS) {
#line 677 "ai.c"
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = cell;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = i;
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ == PLAYER_NONE;
#line 698 "ai.c"
			} else {
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 702 "ai.c"
			}
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 158 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 708 "ai.c"
			}
		}
	}
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = 0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = cell;
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_ = i;
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp10_ = decision_tree_vertical_win (self, _tmp8_, _tmp9_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp10_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = temp;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp11_ != 0) {
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = temp;
#line 163 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 730 "ai.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = cell;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp13_ = i;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp14_ = decision_tree_horizontal_win (self, _tmp12_, _tmp13_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp14_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp15_ = temp;
#line 166 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp15_ != 0) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = temp;
#line 166 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 748 "ai.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp16_ = cell;
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp17_ = i;
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp18_ = decision_tree_backward_diagonal_win (self, _tmp16_, _tmp17_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp18_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp19_ = temp;
#line 169 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp19_ != 0) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = temp;
#line 169 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 766 "ai.c"
	}
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp20_ = cell;
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp21_ = i;
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp22_ = decision_tree_forward_diagonal_win (self, _tmp20_, _tmp21_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp22_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = temp;
#line 172 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 780 "ai.c"
}


static gint decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp30_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 179 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 792 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 806 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 813 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 819 "ai.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp4_ + 1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 835 "ai.c"
				}
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 843 "ai.c"
					gint _tmp9_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ < BOARD_COLUMNS;
#line 849 "ai.c"
				} else {
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 853 "ai.c"
				}
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 857 "ai.c"
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 881 "ai.c"
				} else {
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 885 "ai.c"
				}
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 891 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp16_ - 1;
#line 909 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 916 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 922 "ai.c"
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp19_ - 1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 938 "ai.c"
				}
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 946 "ai.c"
					gint _tmp24_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ >= 0;
#line 952 "ai.c"
				} else {
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 956 "ai.c"
				}
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 960 "ai.c"
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 984 "ai.c"
				} else {
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 988 "ai.c"
				}
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 994 "ai.c"
				}
			}
		}
	}
#line 184 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 184 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp30_ >= 4) {
#line 1003 "ai.c"
		Player _tmp31_ = 0;
#line 186 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp31_ = self->priv->last_moving_player;
#line 186 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp31_ == PLAYER_HUMAN) {
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = (-1) * MAX_HEURIST_VALUE;
#line 187 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1013 "ai.c"
		} else {
#line 189 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = MAX_HEURIST_VALUE;
#line 189 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1019 "ai.c"
		}
	}
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = 0;
#line 192 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1026 "ai.c"
}


static gint decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp30_ = 0;
#line 195 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 197 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 1038 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 1052 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1059 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 1065 "ai.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp4_ - 1;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 1081 "ai.c"
				}
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 1089 "ai.c"
					gint _tmp9_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ >= 0;
#line 1095 "ai.c"
				} else {
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 1099 "ai.c"
				}
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 1103 "ai.c"
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 1127 "ai.c"
				} else {
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 1131 "ai.c"
				}
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1137 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp16_ + 1;
#line 1155 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1162 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 1168 "ai.c"
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp19_ + 1;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 1184 "ai.c"
				}
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 1192 "ai.c"
					gint _tmp24_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ < BOARD_COLUMNS;
#line 1198 "ai.c"
				} else {
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 1202 "ai.c"
				}
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 1206 "ai.c"
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 1230 "ai.c"
				} else {
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 1234 "ai.c"
				}
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1240 "ai.c"
				}
			}
		}
	}
#line 202 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 202 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp30_ >= 4) {
#line 1249 "ai.c"
		Player _tmp31_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp31_ = self->priv->last_moving_player;
#line 204 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp31_ == PLAYER_HUMAN) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = (-1) * MAX_HEURIST_VALUE;
#line 205 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1259 "ai.c"
		} else {
#line 207 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = MAX_HEURIST_VALUE;
#line 207 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1265 "ai.c"
		}
	}
#line 210 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1272 "ai.c"
}


static gint decision_tree_horizontal_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp22_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 215 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 1284 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = j;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1292 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1299 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1304 "ai.c"
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp2_ - 1;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1315 "ai.c"
				}
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ >= 0) {
#line 1323 "ai.c"
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = i;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = k;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1347 "ai.c"
				} else {
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1351 "ai.c"
				}
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1357 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp11_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp11_ = j;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp11_ + 1;
#line 1369 "ai.c"
		{
			gboolean _tmp12_ = FALSE;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp12_ = TRUE;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1376 "ai.c"
				gboolean _tmp15_ = FALSE;
				gint _tmp16_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp12_) {
#line 1381 "ai.c"
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = k;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp13_ + 1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = count;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp14_ + 1;
#line 1392 "ai.c"
				}
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp12_ = FALSE;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp16_ = k;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp16_ < BOARD_COLUMNS) {
#line 1400 "ai.c"
					Player* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp17__length2 = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Player _tmp20_ = 0;
					Player _tmp21_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17_ = self->priv->board;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17__length1 = self->priv->board_length1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17__length2 = self->priv->board_length2;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = i;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = k;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = self->priv->last_moving_player;
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp15_ = _tmp20_ == _tmp21_;
#line 1424 "ai.c"
				} else {
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp15_ = FALSE;
#line 1428 "ai.c"
				}
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp15_) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1434 "ai.c"
				}
			}
		}
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp22_ = count;
#line 220 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp22_ >= 4) {
#line 1443 "ai.c"
		Player _tmp23_ = 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp23_ = self->priv->last_moving_player;
#line 222 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp23_ == PLAYER_HUMAN) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = (-1) * MAX_HEURIST_VALUE;
#line 223 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1453 "ai.c"
		} else {
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = MAX_HEURIST_VALUE;
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1459 "ai.c"
		}
	}
#line 228 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = 0;
#line 228 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1466 "ai.c"
}


static gint decision_tree_vertical_win (DecisionTree* self, gint i, gint j) {
	gint result = 0;
	gint count = 0;
	gint _tmp11_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 233 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 1478 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1486 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1493 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1498 "ai.c"
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp2_ + 1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1509 "ai.c"
				}
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ < BOARD_ROWS) {
#line 1517 "ai.c"
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = k;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = j;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1541 "ai.c"
				} else {
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1545 "ai.c"
				}
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1551 "ai.c"
				}
			}
		}
	}
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = count;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp11_ >= 4) {
#line 1560 "ai.c"
		Player _tmp12_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp12_ = self->priv->last_moving_player;
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp12_ == PLAYER_HUMAN) {
#line 240 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = (-1) * MAX_HEURIST_VALUE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1570 "ai.c"
		} else {
#line 242 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = MAX_HEURIST_VALUE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 1576 "ai.c"
		}
	}
#line 245 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = 0;
#line 245 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1583 "ai.c"
}


static gboolean decision_tree_board_full (DecisionTree* self) {
	gboolean result = FALSE;
	gboolean empty = FALSE;
	gboolean _tmp6_ = FALSE;
#line 249 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	empty = FALSE;
#line 1595 "ai.c"
	{
		gint i = 0;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 1600 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1607 "ai.c"
				gint _tmp2_ = 0;
				Player* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
				Player _tmp5_ = 0;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 1616 "ai.c"
					gint _tmp1_ = 0;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 1622 "ai.c"
				}
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_COLUMNS)) {
#line 252 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1632 "ai.c"
				}
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3_ = self->priv->board;
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3__length1 = self->priv->board_length1;
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3__length2 = self->priv->board_length2;
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = _tmp3_[(0 * _tmp3__length2) + _tmp4_];
#line 254 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ == PLAYER_NONE) {
#line 256 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					empty = TRUE;
#line 257 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1650 "ai.c"
				}
			}
		}
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp6_ = empty;
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = !_tmp6_;
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1661 "ai.c"
}


static gboolean decision_tree_move (DecisionTree* self, gint i) {
	gboolean result = FALSE;
	gint cell = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	Player _tmp10_ = 0;
#line 264 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1673 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		cell = BOARD_ROWS - 1;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1682 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 1687 "ai.c"
				gint _tmp1_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = cell;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				cell = _tmp1_ - 1;
#line 1693 "ai.c"
			}
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = cell;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp3_ >= 0) {
#line 1701 "ai.c"
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = cell;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = i;
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ != PLAYER_NONE;
#line 1722 "ai.c"
			} else {
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 1726 "ai.c"
			}
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 268 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 1732 "ai.c"
			}
		}
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = cell;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp8_ < 0) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 1744 "ai.c"
	}
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp10_ = self->priv->last_moving_player;
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp10_ == PLAYER_NONE) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = TRUE;
#line 1752 "ai.c"
	} else {
		Player _tmp11_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp11_ = self->priv->last_moving_player;
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = _tmp11_ == PLAYER_HUMAN;
#line 1759 "ai.c"
	}
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp9_) {
#line 1763 "ai.c"
		Player* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gint _tmp12__length2 = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		Player _tmp15_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp12_ = self->priv->board;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp12__length1 = self->priv->board_length1;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp12__length2 = self->priv->board_length2;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = cell;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp14_ = i;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = PLAYER_AI;
#line 276 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 277 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->last_moving_player = PLAYER_AI;
#line 1786 "ai.c"
	} else {
		Player* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gint _tmp16__length2 = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		Player _tmp19_ = 0;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = self->priv->board;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16__length1 = self->priv->board_length1;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16__length2 = self->priv->board_length2;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp17_ = cell;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp18_ = i;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = PLAYER_HUMAN;
#line 281 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 282 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->last_moving_player = PLAYER_HUMAN;
#line 1810 "ai.c"
	}
#line 285 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1816 "ai.c"
}


static void decision_tree_unmove (DecisionTree* self, gint i) {
	gint cell = 0;
	Player* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	Player _tmp11_ = 0;
	Player _tmp12_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 1831 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		cell = BOARD_ROWS - 1;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1840 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 1845 "ai.c"
				gint _tmp1_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = cell;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				cell = _tmp1_ - 1;
#line 1851 "ai.c"
			}
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = cell;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp3_ >= 0) {
#line 1859 "ai.c"
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = cell;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = i;
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ != PLAYER_NONE;
#line 1880 "ai.c"
			} else {
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 1884 "ai.c"
			}
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 293 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 1890 "ai.c"
			}
		}
	}
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->board;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8__length1 = self->priv->board_length1;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8__length2 = self->priv->board_length2;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_ = cell;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp10_ = i;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_[((_tmp9_ + 1) * _tmp8__length2) + _tmp10_] = PLAYER_NONE;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = _tmp8_[((_tmp9_ + 1) * _tmp8__length2) + _tmp10_];
#line 297 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = self->priv->last_moving_player;
#line 297 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp12_ == PLAYER_AI) {
#line 298 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->last_moving_player = PLAYER_HUMAN;
#line 1914 "ai.c"
	} else {
		Player _tmp13_ = 0;
#line 299 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = self->priv->last_moving_player;
#line 299 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp13_ == PLAYER_HUMAN) {
#line 300 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->last_moving_player = PLAYER_AI;
#line 1923 "ai.c"
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1943 "ai.c"
}


void decision_tree_update_board (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Player move = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 307 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 310 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 310 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = strlen (_tmp0_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = _tmp1_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp2_ == 2) {
#line 310 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return;
#line 1971 "ai.c"
	}
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = vstr;
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp4_ = strlen (_tmp3_);
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = _tmp4_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if ((_tmp5_ % 2) == 0) {
#line 315 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		move = PLAYER_AI;
#line 1983 "ai.c"
	} else {
#line 317 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		move = PLAYER_HUMAN;
#line 1987 "ai.c"
	}
	{
		gint i = 0;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 1;
#line 1993 "ai.c"
		{
			gboolean _tmp6_ = FALSE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp6_ = TRUE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2000 "ai.c"
				gint _tmp8_ = 0;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint column = 0;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint cell = 0;
				Player* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp27__length2 = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				Player _tmp30_ = 0;
				Player _tmp31_ = 0;
				Player _tmp32_ = 0;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 2024 "ai.c"
					gint _tmp7_ = 0;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = i;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp7_ + 1;
#line 2030 "ai.c"
				}
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = FALSE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = i;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp9_ = vstr;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp10_ = strlen (_tmp9_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = _tmp10_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp8_ < (_tmp11_ - 1))) {
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2046 "ai.c"
				}
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp12_ = vstr;
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp13_ = i;
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp15_ = g_strdup_printf ("%c", _tmp14_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp16_ = _tmp15_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = atoi (_tmp16_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp18_ = _tmp17_ - 1;
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_g_free0 (_tmp16_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				column = _tmp18_;
#line 2066 "ai.c"
				{
					gboolean _tmp19_ = FALSE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					cell = BOARD_ROWS - 1;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = TRUE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					while (TRUE) {
#line 2075 "ai.c"
						gboolean _tmp21_ = FALSE;
						gint _tmp22_ = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (!_tmp19_) {
#line 2080 "ai.c"
							gint _tmp20_ = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp20_ = cell;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							cell = _tmp20_ - 1;
#line 2086 "ai.c"
						}
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp19_ = FALSE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp22_ = cell;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (_tmp22_ >= 0) {
#line 2094 "ai.c"
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23_ = self->priv->board;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length1 = self->priv->board_length1;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length2 = self->priv->board_length2;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24_ = cell;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp25_ = column;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp21_ = _tmp26_ != PLAYER_NONE;
#line 2115 "ai.c"
						} else {
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp21_ = FALSE;
#line 2119 "ai.c"
						}
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (!_tmp21_) {
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							break;
#line 2125 "ai.c"
						}
					}
				}
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp27_ = self->priv->board;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp27__length1 = self->priv->board_length1;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp27__length2 = self->priv->board_length2;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28_ = cell;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp29_ = column;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp30_ = move;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_] = _tmp30_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp31_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
#line 329 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp32_ = move;
#line 329 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp32_ == PLAYER_HUMAN) {
#line 330 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					move = PLAYER_AI;
#line 2151 "ai.c"
				} else {
#line 332 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					move = PLAYER_HUMAN;
#line 2155 "ai.c"
				}
			}
		}
	}
#line 335 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_HUMAN;
#line 2162 "ai.c"
}


static gint decision_tree_immediate_win (DecisionTree* self, Player p) {
	gint result = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp12_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = p;
#line 344 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp1_ == PLAYER_AI) {
#line 345 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->last_moving_player = PLAYER_HUMAN;
#line 2184 "ai.c"
	} else {
#line 347 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->last_moving_player = PLAYER_AI;
#line 2188 "ai.c"
	}
	{
		gint i = 0;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 2194 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2201 "ai.c"
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 2207 "ai.c"
					gint _tmp3_ = 0;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = i;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp3_ + 1;
#line 2213 "ai.c"
				}
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp4_ < BOARD_COLUMNS)) {
#line 349 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2223 "ai.c"
				}
#line 351 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = i;
#line 351 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = decision_tree_move (self, _tmp5_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp6_) {
#line 2231 "ai.c"
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp11_ = 0;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = i;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = decision_tree_victory (self, _tmp7_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					if (_tmp8_ != 0) {
#line 2241 "ai.c"
						gint _tmp9_ = 0;
						Player _tmp10_ = 0;
#line 355 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp9_ = i;
#line 355 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						decision_tree_unmove (self, _tmp9_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp10_ = old_last_moving_player;
#line 356 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						self->priv->last_moving_player = _tmp10_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						result = i;
#line 357 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						return result;
#line 2256 "ai.c"
					}
#line 360 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp11_ = i;
#line 360 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					decision_tree_unmove (self, _tmp11_);
#line 2262 "ai.c"
				}
			}
		}
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = old_last_moving_player;
#line 364 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp12_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = -1;
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2275 "ai.c"
}


gint decision_tree_playgame (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 371 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 371 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 374 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 374 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 377 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 380 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 380 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 383 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp3_ != (-1)) {
#line 2310 "ai.c"
		gint _tmp4_ = 0;
#line 384 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp4_ = temp;
#line 384 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp4_ + 1;
#line 384 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2318 "ai.c"
	}
#line 387 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 387 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp5_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp6_ = temp;
#line 390 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp6_ != (-1)) {
#line 2328 "ai.c"
		gint _tmp7_ = 0;
#line 391 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp7_ = temp;
#line 391 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp7_ + 1;
#line 391 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2336 "ai.c"
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->plies;
#line 394 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp8_, NEG_INF, (-1) * NEG_INF);
#line 397 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_ = self->priv->next_move_in_column;
#line 397 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp9_ + 1;
#line 397 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2348 "ai.c"
}


static gint decision_tree_heurist (DecisionTree* self) {
	gint result = 0;
	Difficulty _tmp0_ = 0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 404 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->level;
#line 404 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp0_ == DIFFICULTY_EASY) {
#line 2361 "ai.c"
		gint _tmp1_ = 0;
#line 405 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = decision_tree_heurist_easy (self);
#line 405 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp1_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2369 "ai.c"
	} else {
		Difficulty _tmp2_ = 0;
#line 407 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = self->priv->level;
#line 407 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp2_ == DIFFICULTY_MEDIUM) {
#line 2376 "ai.c"
			gint _tmp3_ = 0;
#line 408 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = decision_tree_heurist_medium (self);
#line 408 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp3_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 2384 "ai.c"
		} else {
			gint _tmp4_ = 0;
#line 411 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist_hard (self);
#line 411 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 2393 "ai.c"
		}
	}
}


static gint decision_tree_heurist_easy (DecisionTree* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 415 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 417 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_heurist_hard (self);
#line 417 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = (-1) * _tmp0_;
#line 417 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2410 "ai.c"
}


static gint decision_tree_heurist_medium (DecisionTree* self) {
	gint result = 0;
	gint32 _tmp0_ = 0;
#line 420 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 422 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 422 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = (gint) _tmp0_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2425 "ai.c"
}


static gint decision_tree_heurist_hard (DecisionTree* self) {
	gint result = 0;
	gint count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 425 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 427 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 429 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_count_3_in_a_row (self, PLAYER_AI);
#line 429 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = _tmp0_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = count;
#line 431 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_count_3_in_a_row (self, PLAYER_HUMAN);
#line 431 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = _tmp1_ - _tmp2_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = count;
#line 433 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = _tmp3_ * 100;
#line 435 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp4_ = count;
#line 435 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp4_ == 0) {
#line 2459 "ai.c"
		gint32 _tmp5_ = 0;
#line 436 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp5_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 436 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		count = (gint) _tmp5_;
#line 2465 "ai.c"
	}
#line 438 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = count;
#line 438 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2471 "ai.c"
}


static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p) {
	gint result = 0;
	gint count = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp27_ = 0;
#line 443 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 445 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 447 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 447 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = p;
#line 449 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp1_;
#line 2494 "ai.c"
	{
		gint j = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		j = 0;
#line 2499 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2506 "ai.c"
				gint _tmp4_ = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 2510 "ai.c"
					gint _tmp3_ = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = j;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = _tmp3_ + 1;
#line 2516 "ai.c"
				}
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = j;
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp4_ < BOARD_COLUMNS)) {
#line 451 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2526 "ai.c"
				}
				{
					gint i = 0;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = 0;
#line 2532 "ai.c"
					{
						gboolean _tmp5_ = FALSE;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp5_ = TRUE;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2539 "ai.c"
							gint _tmp7_ = 0;
							Player* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Player _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
							Player* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Player _tmp18_ = 0;
							Player _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp5_) {
#line 2567 "ai.c"
								gint _tmp6_ = 0;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = i;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								i = _tmp6_ + 1;
#line 2573 "ai.c"
							}
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = FALSE;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp7_ < BOARD_ROWS)) {
#line 453 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2583 "ai.c"
							}
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = self->priv->board;
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8__length1 = self->priv->board_length1;
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8__length2 = self->priv->board_length2;
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = i;
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp10_ = j;
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 455 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp11_ != PLAYER_NONE) {
#line 456 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2601 "ai.c"
							}
#line 458 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp12_ = i;
#line 458 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp13_ = j;
#line 458 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp14_ = decision_tree_all_adjacent_empty (self, _tmp12_, _tmp13_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp14_) {
#line 459 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								continue;
#line 2613 "ai.c"
							}
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15_ = self->priv->board;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15__length1 = self->priv->board_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15__length2 = self->priv->board_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp16_ = i;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp17_ = j;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp18_ = p;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
#line 461 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 463 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp20_ = j;
#line 463 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp21_ = decision_tree_victory (self, _tmp20_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp21_ != 0) {
#line 2637 "ai.c"
								gint _tmp22_ = 0;
#line 464 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp22_ = count;
#line 464 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								count = _tmp22_ + 1;
#line 2643 "ai.c"
							}
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23_ = self->priv->board;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length1 = self->priv->board_length1;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length2 = self->priv->board_length2;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24_ = i;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp25_ = j;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_] = PLAYER_NONE;
#line 466 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
#line 2659 "ai.c"
						}
					}
				}
			}
		}
	}
#line 470 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp27_ = old_last_moving_player;
#line 470 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp27_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = count;
#line 471 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2674 "ai.c"
}


static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
#line 475 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2682 "ai.c"
	{
		gint k = 0;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = -1;
#line 2687 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2694 "ai.c"
				gint _tmp2_ = 0;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 2698 "ai.c"
					gint _tmp1_ = 0;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = k;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp1_ + 1;
#line 2704 "ai.c"
				}
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = k;
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ <= 1)) {
#line 477 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2714 "ai.c"
				}
				{
					gint l = 0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = -1;
#line 2720 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2727 "ai.c"
							gint _tmp5_ = 0;
							gboolean _tmp6_ = FALSE;
							gint _tmp7_ = 0;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 2738 "ai.c"
								gint _tmp4_ = 0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = l;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								l = _tmp4_ + 1;
#line 2744 "ai.c"
							}
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = l;
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ <= 1)) {
#line 479 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2754 "ai.c"
							}
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = k;
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp7_ == 0) {
#line 2760 "ai.c"
								gint _tmp8_ = 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp8_ = l;
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = _tmp8_ == 0;
#line 2766 "ai.c"
							} else {
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = FALSE;
#line 2770 "ai.c"
							}
#line 481 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp6_) {
#line 482 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								continue;
#line 2776 "ai.c"
							}
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp12_ = i;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp13_ = k;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if ((_tmp12_ + _tmp13_) >= 0) {
#line 2784 "ai.c"
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp14_ = i;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp15_ = k;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp11_ = (_tmp14_ + _tmp15_) < BOARD_ROWS;
#line 2793 "ai.c"
							} else {
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp11_ = FALSE;
#line 2797 "ai.c"
							}
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp11_) {
#line 2801 "ai.c"
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp16_ = j;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp17_ = l;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp10_ = (_tmp16_ + _tmp17_) >= 0;
#line 2810 "ai.c"
							} else {
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp10_ = FALSE;
#line 2814 "ai.c"
							}
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp10_) {
#line 2818 "ai.c"
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp18_ = j;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp19_ = l;
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp9_ = (_tmp18_ + _tmp19_) < BOARD_COLUMNS;
#line 2827 "ai.c"
							} else {
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp9_ = FALSE;
#line 2831 "ai.c"
							}
#line 483 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp9_) {
#line 2835 "ai.c"
								Player* _tmp20_ = NULL;
								gint _tmp20__length1 = 0;
								gint _tmp20__length2 = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								Player _tmp25_ = 0;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp20_ = self->priv->board;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp20__length1 = self->priv->board_length1;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp20__length2 = self->priv->board_length2;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp21_ = i;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp22_ = k;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp23_ = j;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp24_ = l;
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp25_ = _tmp20_[((_tmp21_ + _tmp22_) * _tmp20__length2) + (_tmp23_ + _tmp24_)];
#line 485 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								if (_tmp25_ != PLAYER_NONE) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
									result = FALSE;
#line 486 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
									return result;
#line 2866 "ai.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 491 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 491 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2879 "ai.c"
}


static void decision_tree_set_level (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
#line 495 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 495 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 498 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 498 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 498 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 'a') {
#line 500 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->level = DIFFICULTY_EASY;
#line 501 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->plies = 4;
#line 2900 "ai.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
#line 503 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = vstr;
#line 503 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 503 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp3_ == 'b') {
#line 505 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_MEDIUM;
#line 506 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2914 "ai.c"
		} else {
#line 510 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_HARD;
#line 511 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2920 "ai.c"
		}
	}
}


gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 516 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 516 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 518 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 518 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 520 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 522 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 524 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp3_ != (-1)) {
#line 526 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = 1000;
#line 526 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2961 "ai.c"
	}
#line 529 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp4_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 529 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp4_;
#line 531 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = temp;
#line 531 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp5_ != (-1)) {
#line 2971 "ai.c"
		gint _tmp6_ = 0;
#line 532 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp6_ = temp;
#line 532 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp6_ + 1;
#line 532 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2979 "ai.c"
	}
#line 534 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp7_ = self->priv->plies;
#line 534 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp7_, NEG_INF, (-1) * NEG_INF);
#line 536 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->next_move_in_column;
#line 536 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp8_ + 1;
#line 536 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2991 "ai.c"
}


static void value_decision_tree_init (GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	value->data[0].v_pointer = NULL;
#line 2998 "ai.c"
}


static void value_decision_tree_free_value (GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (value->data[0].v_pointer);
#line 3007 "ai.c"
	}
}


static void value_decision_tree_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = decision_tree_ref (src_value->data[0].v_pointer);
#line 3017 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3021 "ai.c"
	}
}


static gpointer value_decision_tree_peek_pointer (const GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 3029 "ai.c"
}


static gchar* value_decision_tree_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (collect_values[0].v_pointer) {
#line 3036 "ai.c"
		DecisionTree* object;
		object = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3043 "ai.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3047 "ai.c"
		}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = decision_tree_ref (object);
#line 3051 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3055 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return NULL;
#line 3059 "ai.c"
}


static gchar* value_decision_tree_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DecisionTree** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (!object_p) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3070 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = NULL;
#line 3076 "ai.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = value->data[0].v_pointer;
#line 3080 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = decision_tree_ref (value->data[0].v_pointer);
#line 3084 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return NULL;
#line 3088 "ai.c"
}


GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDecisionTree* spec;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return G_PARAM_SPEC (spec);
#line 3102 "ai.c"
}


gpointer value_get_decision_tree (const GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 3111 "ai.c"
}


void value_set_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_ref (value->data[0].v_pointer);
#line 3131 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3135 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3141 "ai.c"
	}
}


void value_take_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 3160 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3164 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3170 "ai.c"
	}
}


static void decision_tree_class_init (DecisionTreeClass * klass) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	((DecisionTreeClass *) klass)->finalize = decision_tree_finalize;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_type_class_add_private (klass, sizeof (DecisionTreePrivate));
#line 3182 "ai.c"
}


static void decision_tree_instance_init (DecisionTree * self) {
	Player* _tmp0_ = NULL;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv = DECISION_TREE_GET_PRIVATE (self);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = g_new0 (Player, BOARD_ROWS * BOARD_COLUMNS);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board = _tmp0_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board_length1 = BOARD_ROWS;
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board_length2 = BOARD_COLUMNS;
#line 43 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->plies = 8;
#line 45 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_NONE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->ref_count = 1;
#line 3206 "ai.c"
}


static void decision_tree_finalize (DecisionTree* obj) {
	DecisionTree * self;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECISION_TREE, DecisionTree);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_signal_handlers_destroy (self);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board = (g_free (self->priv->board), NULL);
#line 3218 "ai.c"
}


GType decision_tree_get_type (void) {
	static volatile gsize decision_tree_type_id__volatile = 0;
	if (g_once_init_enter (&decision_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_decision_tree_init, value_decision_tree_free_value, value_decision_tree_copy_value, value_decision_tree_peek_pointer, "p", value_decision_tree_collect_value, "p", value_decision_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DecisionTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decision_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecisionTree), 0, (GInstanceInitFunc) decision_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType decision_tree_type_id;
		decision_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecisionTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&decision_tree_type_id__volatile, decision_tree_type_id);
	}
	return decision_tree_type_id__volatile;
}


gpointer decision_tree_ref (gpointer instance) {
	DecisionTree* self;
	self = instance;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return instance;
#line 3243 "ai.c"
}


void decision_tree_unref (gpointer instance) {
	DecisionTree* self;
	self = instance;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		DECISION_TREE_GET_CLASS (self)->finalize (self);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3256 "ai.c"
	}
}



