/* puzzle-generator.c generated by valac 0.28.0.2-022b, the Vala compiler
 * generated from puzzle-generator.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle generation logic:*/
/* We want to measure a puzzle's difficulty by the number of button presses*/
/* needed to solve it, and have that increase in a controlled manner.*/
/**/
/* Lights Off can be seen as a linear algebra problem over the field GF(2).*/
/* (See e.g. the first page of "Turning Lights Out with Linear Algebra".)*/
/* The linear map from button-press strategies to light configurations*/
/* will in general have a nullspace (of dimension n).*/
/* Thus, any solvable puzzle has 2^n solutions, given by a fixed solution*/
/* plus an element of the nullspace.*/
/* A solution is thus optimal if it presses at most half the buttons*/
/* which make up any element of the nullspace.*/
/**/
/* A basis for the nullspace splits the board into (up to) 2^n regions,*/
/* defined by which basic nullspace elements include a given button.*/
/* (This determines which nullspace elements include the same button.)*/
/* Thus, a solution is optimal if it includes at most half the buttons in any*/
/* region (except the region lying outside all null-sets).*/
/* The converse is not true, but (at least if the regions are even-sized)*/
/* does hold for a large number of puzzles up to the highest difficulty level.*/
/* (Certainly, on average, at most half the lights which belong to at least*/
/* one null set may be used.)*/

#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>


#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef struct _PuzzleGeneratorPrivate PuzzleGeneratorPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _PuzzleGenerator {
	GObject parent_instance;
	PuzzleGeneratorPrivate * priv;
};

struct _PuzzleGeneratorClass {
	GObjectClass parent_class;
};

struct _PuzzleGeneratorPrivate {
	gint size;
	gint max_solution_length;
	gint* region_of;
	gint region_of_length1;
	gint _region_of_size_;
	gint* region_size;
	gint region_size_length1;
	gint _region_size_size_;
};


static gpointer puzzle_generator_parent_class = NULL;

GType puzzle_generator_get_type (void) G_GNUC_CONST;
#define PUZZLE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorPrivate))
enum  {
	PUZZLE_GENERATOR_DUMMY_PROPERTY
};
PuzzleGenerator* puzzle_generator_new (gint size);
PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size);
gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2);
static void puzzle_generator_finalize (GObject* obj);


PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size) {
	PuzzleGenerator * self = NULL;
	gint _tmp0_ = 0;
	gint* adj_matrix = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint adj_matrix_length1 = 0;
	gint adj_matrix_length2 = 0;
	GList* non_pivot_cols = NULL;
	gint ipiv = 0;
	gint* basis_for_ns = NULL;
	GList* _tmp104_ = NULL;
	guint _tmp105_ = 0U;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint* _tmp108_ = NULL;
	gint basis_for_ns_length1 = 0;
	gint basis_for_ns_length2 = 0;
	gint n = 0;
	GList* _tmp109_ = NULL;
	GList* _tmp159_ = NULL;
	guint _tmp160_ = 0U;
	gint* _tmp161_ = NULL;
	gint _tmp169_ = 0;
	gint _tmp170_ = 0;
	gint* _tmp171_ = NULL;
	gint* _tmp198_ = NULL;
	gint _tmp198__length1 = 0;
	gint _tmp199_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self = (PuzzleGenerator*) g_object_new (object_type, NULL);
#line 43 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp0_ = size;
#line 43 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->size = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp1_ = size;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp2_ = size;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp3_ = size;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp4_ = size;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp5_ = g_new0 (gint, (_tmp1_ * _tmp2_) * (_tmp3_ * _tmp4_));
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	adj_matrix = _tmp5_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	adj_matrix_length1 = _tmp1_ * _tmp2_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	adj_matrix_length2 = _tmp3_ * _tmp4_;
#line 143 "puzzle-generator.c"
	{
		gint x0 = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		x0 = 0;
#line 148 "puzzle-generator.c"
		{
			gboolean _tmp6_ = FALSE;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp6_ = TRUE;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 155 "puzzle-generator.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp6_) {
#line 160 "puzzle-generator.c"
					gint _tmp7_ = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp7_ = x0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					x0 = _tmp7_ + 1;
#line 166 "puzzle-generator.c"
				}
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp6_ = FALSE;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp8_ = x0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp9_ = size;
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 45 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 178 "puzzle-generator.c"
				}
				{
					gint y0 = 0;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					y0 = 0;
#line 184 "puzzle-generator.c"
					{
						gboolean _tmp10_ = FALSE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp10_ = TRUE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 191 "puzzle-generator.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp10_) {
#line 196 "puzzle-generator.c"
								gint _tmp11_ = 0;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp11_ = y0;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								y0 = _tmp11_ + 1;
#line 202 "puzzle-generator.c"
							}
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp10_ = FALSE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp12_ = y0;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp13_ = size;
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 47 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 214 "puzzle-generator.c"
							}
							{
								gint x1 = 0;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								x1 = 0;
#line 220 "puzzle-generator.c"
								{
									gboolean _tmp14_ = FALSE;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp14_ = TRUE;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									while (TRUE) {
#line 227 "puzzle-generator.c"
										gint _tmp16_ = 0;
										gint _tmp17_ = 0;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										if (!_tmp14_) {
#line 232 "puzzle-generator.c"
											gint _tmp15_ = 0;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp15_ = x1;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											x1 = _tmp15_ + 1;
#line 238 "puzzle-generator.c"
										}
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp14_ = FALSE;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp16_ = x1;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp17_ = size;
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										if (!(_tmp16_ < _tmp17_)) {
#line 49 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											break;
#line 250 "puzzle-generator.c"
										}
										{
											gint y1 = 0;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											y1 = 0;
#line 256 "puzzle-generator.c"
											{
												gboolean _tmp18_ = FALSE;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp18_ = TRUE;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												while (TRUE) {
#line 263 "puzzle-generator.c"
													gint _tmp20_ = 0;
													gint _tmp21_ = 0;
													gint dx = 0;
													gint _tmp22_ = 0;
													gint _tmp23_ = 0;
													gint dy = 0;
													gint _tmp24_ = 0;
													gint _tmp25_ = 0;
													gint _tmp26_ = 0;
													gint _tmp27_ = 0;
													gint _tmp28_ = 0;
													gint _tmp29_ = 0;
													gint _tmp30_ = 0;
													gint* _tmp31_ = NULL;
													gint _tmp31__length1 = 0;
													gint _tmp31__length2 = 0;
													gint _tmp32_ = 0;
													gint _tmp33_ = 0;
													gint _tmp34_ = 0;
													gint _tmp35_ = 0;
													gint _tmp36_ = 0;
													gint _tmp37_ = 0;
													gint _tmp38_ = 0;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													if (!_tmp18_) {
#line 289 "puzzle-generator.c"
														gint _tmp19_ = 0;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														_tmp19_ = y1;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														y1 = _tmp19_ + 1;
#line 295 "puzzle-generator.c"
													}
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp18_ = FALSE;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp20_ = y1;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp21_ = size;
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													if (!(_tmp20_ < _tmp21_)) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														break;
#line 307 "puzzle-generator.c"
													}
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp22_ = x0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp23_ = x1;
#line 53 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													dx = _tmp22_ - _tmp23_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp24_ = y0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp25_ = y1;
#line 54 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													dy = _tmp24_ - _tmp25_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp27_ = dx;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp28_ = dx;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp29_ = dy;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp30_ = dy;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													if (((_tmp27_ * _tmp28_) + (_tmp29_ * _tmp30_)) <= 1) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														_tmp26_ = 1;
#line 333 "puzzle-generator.c"
													} else {
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														_tmp26_ = 0;
#line 337 "puzzle-generator.c"
													}
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp31_ = adj_matrix;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp31__length1 = adj_matrix_length1;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp31__length2 = adj_matrix_length2;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp32_ = x0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp33_ = size;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp34_ = y0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp35_ = x1;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp36_ = size;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp37_ = y1;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp31_[(((_tmp32_ * _tmp33_) + _tmp34_) * _tmp31__length2) + ((_tmp35_ * _tmp36_) + _tmp37_)] = _tmp26_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp38_ = _tmp31_[(((_tmp32_ * _tmp33_) + _tmp34_) * _tmp31__length2) + ((_tmp35_ * _tmp36_) + _tmp37_)];
#line 361 "puzzle-generator.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 62 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	non_pivot_cols = NULL;
#line 63 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	ipiv = 0;
#line 378 "puzzle-generator.c"
	{
		gint jpiv = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		jpiv = 0;
#line 383 "puzzle-generator.c"
		{
			gboolean _tmp39_ = FALSE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp39_ = TRUE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 390 "puzzle-generator.c"
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gboolean is_pivot_col = FALSE;
				gboolean _tmp102_ = FALSE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp39_) {
#line 398 "puzzle-generator.c"
					gint _tmp40_ = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp40_ = jpiv;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					jpiv = _tmp40_ + 1;
#line 404 "puzzle-generator.c"
				}
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp39_ = FALSE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp41_ = jpiv;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp42_ = size;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp43_ = size;
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp41_ < (_tmp42_ * _tmp43_))) {
#line 64 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 418 "puzzle-generator.c"
				}
#line 66 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				is_pivot_col = FALSE;
#line 422 "puzzle-generator.c"
				{
					gint i = 0;
					gint _tmp44_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp44_ = ipiv;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					i = _tmp44_;
#line 430 "puzzle-generator.c"
					{
						gboolean _tmp45_ = FALSE;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp45_ = TRUE;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 437 "puzzle-generator.c"
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gint* _tmp50_ = NULL;
							gint _tmp50__length1 = 0;
							gint _tmp50__length2 = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp45_) {
#line 449 "puzzle-generator.c"
								gint _tmp46_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp46_ = i;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								i = _tmp46_ + 1;
#line 455 "puzzle-generator.c"
							}
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp45_ = FALSE;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp47_ = i;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp48_ = size;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp49_ = size;
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(_tmp47_ < (_tmp48_ * _tmp49_))) {
#line 67 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 469 "puzzle-generator.c"
							}
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp50_ = adj_matrix;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp50__length1 = adj_matrix_length1;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp50__length2 = adj_matrix_length2;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp51_ = i;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp52_ = jpiv;
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
#line 69 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (_tmp53_ != 0) {
#line 485 "puzzle-generator.c"
								gint _tmp54_ = 0;
								gint _tmp55_ = 0;
								gint _tmp101_ = 0;
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp54_ = i;
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp55_ = ipiv;
#line 72 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								if (_tmp54_ != _tmp55_) {
#line 495 "puzzle-generator.c"
									{
										gint z = 0;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										z = 0;
#line 500 "puzzle-generator.c"
										{
											gboolean _tmp56_ = FALSE;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp56_ = TRUE;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											while (TRUE) {
#line 507 "puzzle-generator.c"
												gint _tmp58_ = 0;
												gint _tmp59_ = 0;
												gint _tmp60_ = 0;
												gint t = 0;
												gint* _tmp61_ = NULL;
												gint _tmp61__length1 = 0;
												gint _tmp61__length2 = 0;
												gint _tmp62_ = 0;
												gint _tmp63_ = 0;
												gint _tmp64_ = 0;
												gint* _tmp65_ = NULL;
												gint _tmp65__length1 = 0;
												gint _tmp65__length2 = 0;
												gint _tmp66_ = 0;
												gint _tmp67_ = 0;
												gint* _tmp68_ = NULL;
												gint _tmp68__length1 = 0;
												gint _tmp68__length2 = 0;
												gint _tmp69_ = 0;
												gint _tmp70_ = 0;
												gint _tmp71_ = 0;
												gint _tmp72_ = 0;
												gint* _tmp73_ = NULL;
												gint _tmp73__length1 = 0;
												gint _tmp73__length2 = 0;
												gint _tmp74_ = 0;
												gint _tmp75_ = 0;
												gint _tmp76_ = 0;
												gint _tmp77_ = 0;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												if (!_tmp56_) {
#line 539 "puzzle-generator.c"
													gint _tmp57_ = 0;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													_tmp57_ = z;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													z = _tmp57_ + 1;
#line 545 "puzzle-generator.c"
												}
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp56_ = FALSE;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp58_ = z;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp59_ = size;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp60_ = size;
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												if (!(_tmp58_ < (_tmp59_ * _tmp60_))) {
#line 74 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													break;
#line 559 "puzzle-generator.c"
												}
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp61_ = adj_matrix;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp61__length1 = adj_matrix_length1;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp61__length2 = adj_matrix_length2;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp62_ = i;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp63_ = z;
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + _tmp63_];
#line 76 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												t = _tmp64_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp65_ = adj_matrix;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp65__length1 = adj_matrix_length1;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp65__length2 = adj_matrix_length2;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp66_ = i;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp67_ = z;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp68_ = adj_matrix;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp68__length1 = adj_matrix_length1;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp68__length2 = adj_matrix_length2;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp69_ = ipiv;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp70_ = z;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_];
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp71_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp72_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp73_ = adj_matrix;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp73__length1 = adj_matrix_length1;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp73__length2 = adj_matrix_length2;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp74_ = ipiv;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp75_ = z;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp76_ = t;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_] = _tmp76_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp77_ = _tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_];
#line 617 "puzzle-generator.c"
											}
										}
									}
								}
								{
									gint j = 0;
									gint _tmp78_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp78_ = ipiv;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									j = _tmp78_ + 1;
#line 629 "puzzle-generator.c"
									{
										gboolean _tmp79_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp79_ = TRUE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										while (TRUE) {
#line 636 "puzzle-generator.c"
											gint _tmp81_ = 0;
											gint _tmp82_ = 0;
											gint _tmp83_ = 0;
											gint* _tmp84_ = NULL;
											gint _tmp84__length1 = 0;
											gint _tmp84__length2 = 0;
											gint _tmp85_ = 0;
											gint _tmp86_ = 0;
											gint _tmp87_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											if (!_tmp79_) {
#line 648 "puzzle-generator.c"
												gint _tmp80_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												_tmp80_ = j;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												j = _tmp80_ + 1;
#line 654 "puzzle-generator.c"
											}
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp79_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp81_ = j;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp82_ = size;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp83_ = size;
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											if (!(_tmp81_ < (_tmp82_ * _tmp83_))) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
												break;
#line 668 "puzzle-generator.c"
											}
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp84_ = adj_matrix;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp84__length1 = adj_matrix_length1;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp84__length2 = adj_matrix_length2;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp85_ = j;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp86_ = jpiv;
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
#line 84 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											if (_tmp87_ != 0) {
#line 684 "puzzle-generator.c"
												{
													gint k = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
													k = 0;
#line 689 "puzzle-generator.c"
													{
														gboolean _tmp88_ = FALSE;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														_tmp88_ = TRUE;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
														while (TRUE) {
#line 696 "puzzle-generator.c"
															gint _tmp90_ = 0;
															gint _tmp91_ = 0;
															gint _tmp92_ = 0;
															gint* _tmp93_ = NULL;
															gint _tmp93__length1 = 0;
															gint _tmp93__length2 = 0;
															gint _tmp94_ = 0;
															gint _tmp95_ = 0;
															gint* _tmp96_ = NULL;
															gint _tmp96__length1 = 0;
															gint _tmp96__length2 = 0;
															gint _tmp97_ = 0;
															gint _tmp98_ = 0;
															gint _tmp99_ = 0;
															gint _tmp100_ = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															if (!_tmp88_) {
#line 714 "puzzle-generator.c"
																gint _tmp89_ = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
																_tmp89_ = k;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
																k = _tmp89_ + 1;
#line 720 "puzzle-generator.c"
															}
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp88_ = FALSE;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp90_ = k;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp91_ = size;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp92_ = size;
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															if (!(_tmp90_ < (_tmp91_ * _tmp92_))) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
																break;
#line 734 "puzzle-generator.c"
															}
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp93_ = adj_matrix;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp93__length1 = adj_matrix_length1;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp93__length2 = adj_matrix_length2;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp94_ = j;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp95_ = k;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp96_ = adj_matrix;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp96__length1 = adj_matrix_length1;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp96__length2 = adj_matrix_length2;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp97_ = ipiv;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp98_ = k;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp99_ = _tmp96_[(_tmp97_ * _tmp96__length2) + _tmp98_];
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp93_[(_tmp94_ * _tmp93__length2) + _tmp95_] ^= _tmp99_;
#line 87 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
															_tmp100_ = _tmp93_[(_tmp94_ * _tmp93__length2) + _tmp95_];
#line 762 "puzzle-generator.c"
														}
													}
												}
											}
										}
									}
								}
#line 90 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								is_pivot_col = TRUE;
#line 91 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp101_ = ipiv;
#line 91 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								ipiv = _tmp101_ + 1;
#line 92 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 778 "puzzle-generator.c"
							}
						}
					}
				}
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp102_ = is_pivot_col;
#line 96 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp102_) {
#line 787 "puzzle-generator.c"
					gint _tmp103_ = 0;
#line 97 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp103_ = jpiv;
#line 97 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					non_pivot_cols = g_list_append (non_pivot_cols, (gpointer) ((gintptr) _tmp103_));
#line 793 "puzzle-generator.c"
				}
			}
		}
	}
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp104_ = non_pivot_cols;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp105_ = g_list_length (_tmp104_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp106_ = size;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp107_ = size;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp108_ = g_new0 (gint, _tmp105_ * (_tmp106_ * _tmp107_));
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	basis_for_ns = _tmp108_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	basis_for_ns_length1 = _tmp105_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	basis_for_ns_length2 = _tmp106_ * _tmp107_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	n = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp109_ = non_pivot_cols;
#line 818 "puzzle-generator.c"
	{
		GList* col_collection = NULL;
		GList* col_it = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		col_collection = _tmp109_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		for (col_it = col_collection; col_it != NULL; col_it = col_it->next) {
#line 826 "puzzle-generator.c"
			gint col = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			col = (gint) ((gintptr) col_it->data);
#line 830 "puzzle-generator.c"
			{
				gint* _tmp119_ = NULL;
				gint _tmp119__length1 = 0;
				gint _tmp119__length2 = 0;
				gint _tmp120_ = 0;
				gint _tmp121_ = 0;
				gint _tmp122_ = 0;
				gint _tmp158_ = 0;
				{
					gint j = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					j = 0;
#line 843 "puzzle-generator.c"
					{
						gboolean _tmp110_ = FALSE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp110_ = TRUE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 850 "puzzle-generator.c"
							gint _tmp112_ = 0;
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
							gint* _tmp115_ = NULL;
							gint _tmp115__length1 = 0;
							gint _tmp115__length2 = 0;
							gint _tmp116_ = 0;
							gint _tmp117_ = 0;
							gint _tmp118_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp110_) {
#line 862 "puzzle-generator.c"
								gint _tmp111_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp111_ = j;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								j = _tmp111_ + 1;
#line 868 "puzzle-generator.c"
							}
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp110_ = FALSE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp112_ = j;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp113_ = size;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp114_ = size;
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(_tmp112_ < (_tmp113_ * _tmp114_))) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 882 "puzzle-generator.c"
							}
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp115_ = basis_for_ns;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp115__length1 = basis_for_ns_length1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp115__length2 = basis_for_ns_length2;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp116_ = n;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp117_ = j;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
#line 898 "puzzle-generator.c"
						}
					}
				}
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp119_ = basis_for_ns;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp119__length1 = basis_for_ns_length1;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp119__length2 = basis_for_ns_length2;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp120_ = n;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp121_ = col;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp119_[(_tmp120_ * _tmp119__length2) + _tmp121_] = 1;
#line 108 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp122_ = _tmp119_[(_tmp120_ * _tmp119__length2) + _tmp121_];
#line 916 "puzzle-generator.c"
				{
					gint i = 0;
					gint _tmp123_ = 0;
					gint _tmp124_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp123_ = size;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp124_ = size;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					i = (_tmp123_ * _tmp124_) - 1;
#line 927 "puzzle-generator.c"
					{
						gboolean _tmp125_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp125_ = TRUE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 934 "puzzle-generator.c"
							gint _tmp127_ = 0;
							gint jpiv = 0;
							gint _tmp137_ = 0;
							gint _tmp138_ = 0;
							gint _tmp139_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp125_) {
#line 942 "puzzle-generator.c"
								gint _tmp126_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp126_ = i;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								i = _tmp126_ - 1;
#line 948 "puzzle-generator.c"
							}
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp125_ = FALSE;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp127_ = i;
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(_tmp127_ >= 0)) {
#line 110 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 958 "puzzle-generator.c"
							}
#line 112 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							jpiv = 0;
#line 962 "puzzle-generator.c"
							{
								gboolean _tmp128_ = FALSE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp128_ = TRUE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								while (TRUE) {
#line 969 "puzzle-generator.c"
									gint _tmp130_ = 0;
									gint _tmp131_ = 0;
									gint _tmp132_ = 0;
									gint* _tmp133_ = NULL;
									gint _tmp133__length1 = 0;
									gint _tmp133__length2 = 0;
									gint _tmp134_ = 0;
									gint _tmp135_ = 0;
									gint _tmp136_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									if (!_tmp128_) {
#line 981 "puzzle-generator.c"
										gint _tmp129_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp129_ = jpiv;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										jpiv = _tmp129_ + 1;
#line 987 "puzzle-generator.c"
									}
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp128_ = FALSE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp130_ = jpiv;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp131_ = size;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp132_ = size;
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									if (!(_tmp130_ < (_tmp131_ * _tmp132_))) {
#line 113 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										break;
#line 1001 "puzzle-generator.c"
									}
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp133_ = adj_matrix;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp133__length1 = adj_matrix_length1;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp133__length2 = adj_matrix_length2;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp134_ = i;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp135_ = jpiv;
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp136_ = _tmp133_[(_tmp134_ * _tmp133__length2) + _tmp135_];
#line 114 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									if (_tmp136_ != 0) {
#line 115 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										break;
#line 1019 "puzzle-generator.c"
									}
								}
							}
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp137_ = jpiv;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp138_ = size;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp139_ = size;
#line 116 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (_tmp137_ == (_tmp138_ * _tmp139_)) {
#line 117 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								continue;
#line 1033 "puzzle-generator.c"
							}
							{
								gint j = 0;
								gint _tmp140_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp140_ = jpiv;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								j = _tmp140_ + 1;
#line 1042 "puzzle-generator.c"
								{
									gboolean _tmp141_ = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									_tmp141_ = TRUE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
									while (TRUE) {
#line 1049 "puzzle-generator.c"
										gint _tmp143_ = 0;
										gint _tmp144_ = 0;
										gint _tmp145_ = 0;
										gint* _tmp146_ = NULL;
										gint _tmp146__length1 = 0;
										gint _tmp146__length2 = 0;
										gint _tmp147_ = 0;
										gint _tmp148_ = 0;
										gint* _tmp149_ = NULL;
										gint _tmp149__length1 = 0;
										gint _tmp149__length2 = 0;
										gint _tmp150_ = 0;
										gint _tmp151_ = 0;
										gint _tmp152_ = 0;
										gint* _tmp153_ = NULL;
										gint _tmp153__length1 = 0;
										gint _tmp153__length2 = 0;
										gint _tmp154_ = 0;
										gint _tmp155_ = 0;
										gint _tmp156_ = 0;
										gint _tmp157_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										if (!_tmp141_) {
#line 1073 "puzzle-generator.c"
											gint _tmp142_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											_tmp142_ = j;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											j = _tmp142_ + 1;
#line 1079 "puzzle-generator.c"
										}
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp141_ = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp143_ = j;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp144_ = size;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp145_ = size;
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										if (!(_tmp143_ < (_tmp144_ * _tmp145_))) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
											break;
#line 1093 "puzzle-generator.c"
										}
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp146_ = basis_for_ns;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp146__length1 = basis_for_ns_length1;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp146__length2 = basis_for_ns_length2;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp147_ = n;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp148_ = jpiv;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp149_ = adj_matrix;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp149__length1 = adj_matrix_length1;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp149__length2 = adj_matrix_length2;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp150_ = i;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp151_ = j;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp152_ = _tmp149_[(_tmp150_ * _tmp149__length2) + _tmp151_];
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp153_ = basis_for_ns;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp153__length1 = basis_for_ns_length1;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp153__length2 = basis_for_ns_length2;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp154_ = n;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp155_ = j;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp156_ = _tmp153_[(_tmp154_ * _tmp153__length2) + _tmp155_];
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp146_[(_tmp147_ * _tmp146__length2) + _tmp148_] ^= _tmp152_ * _tmp156_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
										_tmp157_ = _tmp146_[(_tmp147_ * _tmp146__length2) + _tmp148_];
#line 1133 "puzzle-generator.c"
									}
								}
							}
						}
					}
				}
#line 122 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp158_ = n;
#line 122 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				n = _tmp158_ + 1;
#line 1144 "puzzle-generator.c"
			}
		}
	}
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp159_ = non_pivot_cols;
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp160_ = g_list_length (_tmp159_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp161_ = g_new0 (gint, 1 << _tmp160_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_size = _tmp161_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_size_length1 = 1 << _tmp160_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->_region_size_size_ = self->priv->region_size_length1;
#line 1162 "puzzle-generator.c"
	{
		gint j = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		j = 0;
#line 1167 "puzzle-generator.c"
		{
			gboolean _tmp162_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp162_ = TRUE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 1174 "puzzle-generator.c"
				gint _tmp164_ = 0;
				gint* _tmp165_ = NULL;
				gint _tmp165__length1 = 0;
				gint* _tmp166_ = NULL;
				gint _tmp166__length1 = 0;
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp162_) {
#line 1184 "puzzle-generator.c"
					gint _tmp163_ = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp163_ = j;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					j = _tmp163_ + 1;
#line 1190 "puzzle-generator.c"
				}
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp162_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp164_ = j;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp165_ = self->priv->region_size;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp165__length1 = self->priv->region_size_length1;
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp164_ < _tmp165__length1)) {
#line 128 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 1204 "puzzle-generator.c"
				}
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp166_ = self->priv->region_size;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp166__length1 = self->priv->region_size_length1;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp167_ = j;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp166_[_tmp167_] = 0;
#line 129 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp168_ = _tmp166_[_tmp167_];
#line 1216 "puzzle-generator.c"
			}
		}
	}
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp169_ = size;
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp170_ = size;
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp171_ = g_new0 (gint, _tmp169_ * _tmp170_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_of = _tmp171_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_of_length1 = _tmp169_ * _tmp170_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->_region_of_size_ = self->priv->region_of_length1;
#line 1234 "puzzle-generator.c"
	{
		gint i = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		i = 0;
#line 1239 "puzzle-generator.c"
		{
			gboolean _tmp172_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp172_ = TRUE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 1246 "puzzle-generator.c"
				gint _tmp174_ = 0;
				gint _tmp175_ = 0;
				gint _tmp176_ = 0;
				gint* _tmp177_ = NULL;
				gint _tmp177__length1 = 0;
				gint _tmp178_ = 0;
				gint _tmp179_ = 0;
				gint* _tmp193_ = NULL;
				gint _tmp193__length1 = 0;
				gint* _tmp194_ = NULL;
				gint _tmp194__length1 = 0;
				gint _tmp195_ = 0;
				gint _tmp196_ = 0;
				gint _tmp197_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp172_) {
#line 1263 "puzzle-generator.c"
					gint _tmp173_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp173_ = i;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					i = _tmp173_ + 1;
#line 1269 "puzzle-generator.c"
				}
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp172_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp174_ = i;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp175_ = size;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp176_ = size;
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp174_ < (_tmp175_ * _tmp176_))) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 1283 "puzzle-generator.c"
				}
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp177_ = self->priv->region_of;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp177__length1 = self->priv->region_of_length1;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp178_ = i;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp177_[_tmp178_] = 0;
#line 133 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp179_ = _tmp177_[_tmp178_];
#line 1295 "puzzle-generator.c"
				{
					gint j = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					j = 0;
#line 1300 "puzzle-generator.c"
					{
						gboolean _tmp180_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp180_ = TRUE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 1307 "puzzle-generator.c"
							gint _tmp182_ = 0;
							GList* _tmp183_ = NULL;
							guint _tmp184_ = 0U;
							gint* _tmp185_ = NULL;
							gint _tmp185__length1 = 0;
							gint _tmp185__length2 = 0;
							gint _tmp186_ = 0;
							gint _tmp187_ = 0;
							gint _tmp188_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp180_) {
#line 1319 "puzzle-generator.c"
								gint _tmp181_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp181_ = j;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								j = _tmp181_ + 1;
#line 1325 "puzzle-generator.c"
							}
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp180_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp182_ = j;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp183_ = non_pivot_cols;
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp184_ = g_list_length (_tmp183_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(((guint) _tmp182_) < _tmp184_)) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 1339 "puzzle-generator.c"
							}
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp185_ = basis_for_ns;
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp185__length1 = basis_for_ns_length1;
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp185__length2 = basis_for_ns_length2;
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp186_ = j;
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp187_ = i;
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp188_ = _tmp185_[(_tmp186_ * _tmp185__length2) + _tmp187_];
#line 136 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (_tmp188_ != 0) {
#line 1355 "puzzle-generator.c"
								gint* _tmp189_ = NULL;
								gint _tmp189__length1 = 0;
								gint _tmp190_ = 0;
								gint _tmp191_ = 0;
								gint _tmp192_ = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp189_ = self->priv->region_of;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp189__length1 = self->priv->region_of_length1;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp190_ = i;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp191_ = j;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp189_[_tmp190_] += 1 << _tmp191_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp192_ = _tmp189_[_tmp190_];
#line 1373 "puzzle-generator.c"
							}
						}
					}
				}
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp193_ = self->priv->region_size;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp193__length1 = self->priv->region_size_length1;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp194_ = self->priv->region_of;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp194__length1 = self->priv->region_of_length1;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp195_ = i;
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp196_ = _tmp194_[_tmp195_];
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp197_ = _tmp193_[_tmp196_];
#line 139 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp193_[_tmp196_] = _tmp197_ + 1;
#line 1394 "puzzle-generator.c"
			}
		}
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp198_ = self->priv->region_size;
#line 142 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp198__length1 = self->priv->region_size_length1;
#line 142 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp199_ = _tmp198_[0];
#line 142 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->max_solution_length = _tmp199_;
#line 1406 "puzzle-generator.c"
	{
		gint j = 0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		j = 1;
#line 1411 "puzzle-generator.c"
		{
			gboolean _tmp200_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp200_ = TRUE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 1418 "puzzle-generator.c"
				gint _tmp202_ = 0;
				gint* _tmp203_ = NULL;
				gint _tmp203__length1 = 0;
				gint _tmp204_ = 0;
				gint* _tmp205_ = NULL;
				gint _tmp205__length1 = 0;
				gint _tmp206_ = 0;
				gint _tmp207_ = 0;
				gdouble _tmp208_ = 0.0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp200_) {
#line 1430 "puzzle-generator.c"
					gint _tmp201_ = 0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp201_ = j;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					j = _tmp201_ + 1;
#line 1436 "puzzle-generator.c"
				}
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp200_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp202_ = j;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp203_ = self->priv->region_size;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp203__length1 = self->priv->region_size_length1;
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp202_ < _tmp203__length1)) {
#line 143 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 1450 "puzzle-generator.c"
				}
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp204_ = self->priv->max_solution_length;
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp205_ = self->priv->region_size;
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp205__length1 = self->priv->region_size_length1;
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp206_ = j;
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp207_ = _tmp205_[_tmp206_];
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp208_ = floor ((gdouble) (_tmp207_ / 2));
#line 144 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				self->priv->max_solution_length = _tmp204_ + ((gint) _tmp208_);
#line 1466 "puzzle-generator.c"
			}
		}
	}
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	basis_for_ns = (g_free (basis_for_ns), NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_g_list_free0 (non_pivot_cols);
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	adj_matrix = (g_free (adj_matrix), NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	return self;
#line 1478 "puzzle-generator.c"
}


PuzzleGenerator* puzzle_generator_new (gint size) {
#line 41 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	return puzzle_generator_construct (TYPE_PUZZLE_GENERATOR, size);
#line 1485 "puzzle-generator.c"
}


gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2) {
	gboolean* result = NULL;
	gboolean* sol = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint sol_length1 = 0;
	gint sol_length2 = 0;
	gint* presses_in_region = NULL;
	gint* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint* _tmp16_ = NULL;
	gint presses_in_region_length1 = 0;
	gint _presses_in_region_size_ = 0;
	gint sym = 0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gint presses_left = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gboolean* _tmp91_ = NULL;
	gint _tmp91__length1 = 0;
	gint _tmp91__length2 = 0;
#line 147 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp0_ = self->priv->size;
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp1_ = self->priv->size;
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp2_ = g_new0 (gboolean, _tmp0_ * _tmp1_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	sol = _tmp2_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	sol_length1 = _tmp0_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	sol_length2 = _tmp1_;
#line 1527 "puzzle-generator.c"
	{
		gint x = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		x = 0;
#line 1532 "puzzle-generator.c"
		{
			gboolean _tmp3_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp3_ = TRUE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 1539 "puzzle-generator.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp3_) {
#line 1544 "puzzle-generator.c"
					gint _tmp4_ = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp4_ = x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					x = _tmp4_ + 1;
#line 1550 "puzzle-generator.c"
				}
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp3_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp5_ = x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp6_ = self->priv->size;
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 1562 "puzzle-generator.c"
				}
				{
					gint y = 0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					y = 0;
#line 1568 "puzzle-generator.c"
					{
						gboolean _tmp7_ = FALSE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp7_ = TRUE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						while (TRUE) {
#line 1575 "puzzle-generator.c"
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!_tmp7_) {
#line 1586 "puzzle-generator.c"
								gint _tmp8_ = 0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								_tmp8_ = y;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								y = _tmp8_ + 1;
#line 1592 "puzzle-generator.c"
							}
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp7_ = FALSE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp9_ = y;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp10_ = self->priv->size;
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							if (!(_tmp9_ < _tmp10_)) {
#line 151 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
								break;
#line 1604 "puzzle-generator.c"
							}
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp11_ = sol;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp11__length1 = sol_length1;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp11__length2 = sol_length2;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp12_ = x;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp13_ = y;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = FALSE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 1620 "puzzle-generator.c"
						}
					}
				}
			}
		}
	}
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp15_ = self->priv->region_size;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp15__length1 = self->priv->region_size_length1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp16_ = g_new0 (gint, _tmp15__length1);
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	presses_in_region = _tmp16_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	presses_in_region_length1 = _tmp15__length1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_presses_in_region_size_ = presses_in_region_length1;
#line 1639 "puzzle-generator.c"
	{
		gint i = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		i = 0;
#line 1644 "puzzle-generator.c"
		{
			gboolean _tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp17_ = TRUE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			while (TRUE) {
#line 1651 "puzzle-generator.c"
				gint _tmp19_ = 0;
				gint* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!_tmp17_) {
#line 1661 "puzzle-generator.c"
					gint _tmp18_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp18_ = i;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					i = _tmp18_ + 1;
#line 1667 "puzzle-generator.c"
				}
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp19_ = i;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp20_ = self->priv->region_size;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp20__length1 = self->priv->region_size_length1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				if (!(_tmp19_ < _tmp20__length1)) {
#line 155 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					break;
#line 1681 "puzzle-generator.c"
				}
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp21_ = presses_in_region;
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp21__length1 = presses_in_region_length1;
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp22_ = i;
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp21_[_tmp22_] = 0;
#line 156 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 1693 "puzzle-generator.c"
			}
		}
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp24_ = g_random_double ();
#line 159 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp25_ = floor (3 * _tmp24_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	sym = (gint) _tmp25_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp26_ = solution_length;
#line 161 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp27_ = self->priv->max_solution_length;
#line 161 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp28_ = MIN (_tmp26_, _tmp27_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	presses_left = _tmp28_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	while (TRUE) {
#line 1713 "puzzle-generator.c"
		gint _tmp29_ = 0;
		gint x[2] = {0};
		gint y[2] = {0};
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		gdouble _tmp32_ = 0.0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gdouble _tmp35_ = 0.0;
		gdouble _tmp36_ = 0.0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp29_ = presses_left;
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		if (!(_tmp29_ > 0)) {
#line 162 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			break;
#line 1732 "puzzle-generator.c"
		}
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp30_ = self->priv->size;
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp31_ = g_random_double ();
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp32_ = round ((_tmp30_ - 1) * _tmp31_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		x[0] = (gint) _tmp32_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp33_ = x[0];
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp34_ = self->priv->size;
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp35_ = g_random_double ();
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp36_ = round ((_tmp34_ - 1) * _tmp35_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		y[0] = (gint) _tmp36_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp37_ = y[0];
#line 172 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		_tmp38_ = sym;
#line 172 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		if (_tmp38_ == 0) {
#line 1758 "puzzle-generator.c"
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp39_ = self->priv->size;
#line 174 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp40_ = x[0];
#line 174 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			x[1] = (_tmp39_ - 1) - _tmp40_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp41_ = x[1];
#line 175 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp42_ = y[0];
#line 175 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			y[1] = _tmp42_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp43_ = y[1];
#line 1778 "puzzle-generator.c"
		} else {
			gint _tmp44_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			_tmp44_ = sym;
#line 177 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			if (_tmp44_ == 1) {
#line 1785 "puzzle-generator.c"
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp45_ = self->priv->size;
#line 179 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp46_ = x[0];
#line 179 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				x[1] = (_tmp45_ - 1) - _tmp46_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp47_ = x[1];
#line 180 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp48_ = self->priv->size;
#line 180 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp49_ = y[0];
#line 180 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				y[1] = (_tmp48_ - 1) - _tmp49_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp50_ = y[1];
#line 1808 "puzzle-generator.c"
			} else {
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
#line 184 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp51_ = x[0];
#line 184 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				x[1] = _tmp51_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp52_ = x[1];
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp53_ = self->priv->size;
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp54_ = y[0];
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				y[1] = (_tmp53_ - 1) - _tmp54_;
#line 185 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp55_ = y[1];
#line 1829 "puzzle-generator.c"
			}
		}
		{
			gint k = 0;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
			k = 0;
#line 1836 "puzzle-generator.c"
			{
				gboolean _tmp56_ = FALSE;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				_tmp56_ = TRUE;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
				while (TRUE) {
#line 1843 "puzzle-generator.c"
					gint _tmp58_ = 0;
					gint r = 0;
					gint* _tmp59_ = NULL;
					gint _tmp59__length1 = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gboolean _tmp66_ = FALSE;
					gint _tmp67_ = 0;
					gint _tmp90_ = 0;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					if (!_tmp56_) {
#line 1859 "puzzle-generator.c"
						gint _tmp57_ = 0;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp57_ = k;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						k = _tmp57_ + 1;
#line 1865 "puzzle-generator.c"
					}
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp56_ = FALSE;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp58_ = k;
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					if (!(_tmp58_ < 2)) {
#line 189 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						break;
#line 1875 "puzzle-generator.c"
					}
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp59_ = self->priv->region_of;
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp59__length1 = self->priv->region_of_length1;
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp60_ = k;
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp61_ = x[_tmp60_];
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp62_ = self->priv->size;
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp63_ = k;
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp64_ = y[_tmp63_];
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp65_ = _tmp59_[(_tmp61_ * _tmp62_) + _tmp64_];
#line 191 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					r = _tmp65_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp67_ = r;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					if (_tmp67_ == 0) {
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp66_ = TRUE;
#line 1901 "puzzle-generator.c"
					} else {
						gint* _tmp68_ = NULL;
						gint _tmp68__length1 = 0;
						gint _tmp69_ = 0;
						gint _tmp70_ = 0;
						gint* _tmp71_ = NULL;
						gint _tmp71__length1 = 0;
						gint _tmp72_ = 0;
						gint _tmp73_ = 0;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp68_ = presses_in_region;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp68__length1 = presses_in_region_length1;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp69_ = r;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp70_ = _tmp68_[_tmp69_];
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp71_ = self->priv->region_size;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp71__length1 = self->priv->region_size_length1;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp72_ = r;
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp73_ = _tmp71_[_tmp72_];
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp66_ = (2 * (_tmp70_ + 1)) <= _tmp73_;
#line 1929 "puzzle-generator.c"
					}
#line 192 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					if (_tmp66_) {
#line 1933 "puzzle-generator.c"
						gboolean* _tmp74_ = NULL;
						gint _tmp74__length1 = 0;
						gint _tmp74__length2 = 0;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
						gint _tmp77_ = 0;
						gint _tmp78_ = 0;
						gboolean _tmp79_ = FALSE;
						gboolean* _tmp80_ = NULL;
						gint _tmp80__length1 = 0;
						gint _tmp80__length2 = 0;
						gint _tmp81_ = 0;
						gint _tmp82_ = 0;
						gint _tmp83_ = 0;
						gint _tmp84_ = 0;
						gboolean _tmp85_ = FALSE;
						gint* _tmp86_ = NULL;
						gint _tmp86__length1 = 0;
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp74_ = sol;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp74__length1 = sol_length1;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp74__length2 = sol_length2;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp75_ = k;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp76_ = x[_tmp75_];
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp77_ = k;
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp78_ = y[_tmp77_];
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
#line 194 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						if (_tmp79_) {
#line 195 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
							continue;
#line 1975 "puzzle-generator.c"
						}
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp80_ = sol;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp80__length1 = sol_length1;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp80__length2 = sol_length2;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp81_ = k;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp82_ = x[_tmp81_];
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp83_ = k;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp84_ = y[_tmp83_];
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = TRUE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp85_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
#line 197 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp86_ = presses_in_region;
#line 197 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp86__length1 = presses_in_region_length1;
#line 197 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp87_ = r;
#line 197 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp88_ = _tmp86_[_tmp87_];
#line 197 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp86_[_tmp87_] = _tmp88_ + 1;
#line 198 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						_tmp89_ = presses_left;
#line 198 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						presses_left = _tmp89_ - 1;
#line 2009 "puzzle-generator.c"
					}
#line 200 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					_tmp90_ = presses_left;
#line 200 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
					if (_tmp90_ == 0) {
#line 201 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
						break;
#line 2017 "puzzle-generator.c"
					}
				}
			}
		}
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp91_ = sol;
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp91__length1 = sol_length1;
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	_tmp91__length2 = sol_length2;
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	if (result_length1) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		*result_length1 = _tmp91__length1;
#line 2033 "puzzle-generator.c"
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	if (result_length2) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
		*result_length2 = _tmp91__length2;
#line 2039 "puzzle-generator.c"
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	result = _tmp91_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	presses_in_region = (g_free (presses_in_region), NULL);
#line 205 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	return result;
#line 2047 "puzzle-generator.c"
}


static void puzzle_generator_class_init (PuzzleGeneratorClass * klass) {
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	puzzle_generator_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	g_type_class_add_private (klass, sizeof (PuzzleGeneratorPrivate));
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_generator_finalize;
#line 2058 "puzzle-generator.c"
}


static void puzzle_generator_instance_init (PuzzleGenerator * self) {
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv = PUZZLE_GENERATOR_GET_PRIVATE (self);
#line 2065 "puzzle-generator.c"
}


static void puzzle_generator_finalize (GObject* obj) {
	PuzzleGenerator * self;
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_GENERATOR, PuzzleGenerator);
#line 38 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
#line 34 "/home/mcatanzaro/jhbuild/checkout/lightsoff/src/puzzle-generator.vala"
	G_OBJECT_CLASS (puzzle_generator_parent_class)->finalize (obj);
#line 2079 "puzzle-generator.c"
}


GType puzzle_generator_get_type (void) {
	static volatile gsize puzzle_generator_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleGenerator), 0, (GInstanceInitFunc) puzzle_generator_instance_init, NULL };
		GType puzzle_generator_type_id;
		puzzle_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "PuzzleGenerator", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_generator_type_id__volatile, puzzle_generator_type_id);
	}
	return puzzle_generator_type_id__volatile;
}



