/* game-view.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SlotPrivate SlotPrivate;

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	cairo_pattern_t* tile_pattern;
	gint tile_pattern_width;
	gint tile_pattern_height;
	gint x_offset;
	gint y_offset;
	gint tile_width;
	gint tile_height;
	gint tile_layer_offset_x;
	gint tile_layer_offset_y;
	Game* _game;
	gchar* _theme;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _Slot {
	GObject parent_instance;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GObjectClass parent_class;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_background (GameView* self, const gchar* colour);
static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes);
const gchar* game_view_get_theme (GameView* self);
static void game_view_update_dimensions (GameView* self);
static void game_view_load_theme (GameView* self, cairo_t* c, gint width, gint height);
Game* game_view_get_game (GameView* self);
GType map_get_type (void) G_GNUC_CONST;
GType tile_get_type (void) G_GNUC_CONST;
GType slot_get_type (void) G_GNUC_CONST;
static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y);
static gint game_view_get_image_offset (GameView* self, gint number);
gboolean game_get_paused (Game* self);
Tile* game_get_selected_tile (Game* self);
static gboolean game_view_get_theme_dimensions (GameView* self, gint* width, gint* height);
guint map_get_width (Map* self);
guint map_get_height (Map* self);
static void game_view_redraw_tile_cb (GameView* self, Tile* tile);
static void game_view_paused_changed_cb (GameView* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static Tile* game_view_find_tile (GameView* self, guint x, guint y);
gboolean game_tile_can_move (Game* self, Tile* tile);
void game_set_selected_tile (Game* self, Tile* value);
gboolean tile_matches (Tile* self, Tile* tile);
gboolean game_remove_pair (Game* self, Tile* tile0, Tile* tile1);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self);
static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return self;
#line 209 "game-view.c"
}


GameView* game_view_new (void) {
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 216 "game-view.c"
}


void game_view_set_background (GameView* self, const gchar* colour) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	memset (&self->background_color, 0, sizeof (GdkRGBA));
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = colour;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = TRUE;
#line 233 "game-view.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp2_ = colour;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp3_ = gdk_rgba_parse (&self->background_color, _tmp2_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = !_tmp3_;
#line 243 "game-view.c"
	}
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp0_) {
#line 247 "game-view.c"
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->background_color.blue = (gdouble) 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp4_ = self->background_color.blue;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->background_color.green = _tmp4_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp5_ = self->background_color.green;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->background_color.red = _tmp5_;
#line 260 "game-view.c"
	}
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 264 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 271 "game-view.c"
}


static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint image_width = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint image_height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Game* _tmp31_ = NULL;
	Game* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	Game* _tmp92_ = NULL;
	Game* _tmp93_ = NULL;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = game_view_get_theme (self);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 305 "game-view.c"
	}
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_update_dimensions (self);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = self->priv->tile_width;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = self->priv->tile_layer_offset_x;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	image_width = _tmp2_ + _tmp3_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = self->priv->tile_height;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp5_ = self->priv->tile_layer_offset_y;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	image_height = _tmp4_ + _tmp5_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp7_ = render_indexes;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (!_tmp7_) {
#line 325 "game-view.c"
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		cairo_pattern_t* _tmp10_ = NULL;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp10_ = self->priv->tile_pattern;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (_tmp10_ == NULL) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp9_ = TRUE;
#line 335 "game-view.c"
		} else {
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp11_ = self->priv->tile_pattern_width;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp12_ = image_width;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp9_ = _tmp11_ != _tmp12_;
#line 345 "game-view.c"
		}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (_tmp9_) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp8_ = TRUE;
#line 351 "game-view.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp13_ = self->priv->tile_pattern_height;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp14_ = image_height;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp8_ = _tmp13_ != _tmp14_;
#line 361 "game-view.c"
		}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp6_ = _tmp8_;
#line 365 "game-view.c"
	} else {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp6_ = FALSE;
#line 369 "game-view.c"
	}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp6_) {
#line 373 "game-view.c"
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint width = 0;
		gint _tmp17_ = 0;
		gint height = 0;
		gint _tmp18_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp19_ = NULL;
		cairo_surface_t* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		cairo_surface_t* _tmp23_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp24_ = NULL;
		cairo_t* _tmp25_ = NULL;
		cairo_t* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		cairo_surface_t* _tmp29_ = NULL;
		cairo_pattern_t* _tmp30_ = NULL;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp15_ = image_width;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->priv->tile_pattern_width = _tmp15_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp16_ = image_height;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->priv->tile_pattern_height = _tmp16_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp17_ = image_width;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		width = _tmp17_ * 43;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp18_ = image_height;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		height = _tmp18_ * 2;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp19_ = cr;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp20_ = cairo_get_target (_tmp19_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp21_ = width;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp22_ = height;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp23_ = cairo_surface_create_similar (_tmp20_, CAIRO_CONTENT_COLOR_ALPHA, _tmp21_, _tmp22_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		surface = _tmp23_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp24_ = surface;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp25_ = cairo_create (_tmp24_);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		c = _tmp25_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp26_ = c;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp27_ = width;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp28_ = height;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		game_view_load_theme (self, _tmp26_, _tmp27_, _tmp28_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp29_ = surface;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp30_ = cairo_pattern_create_for_surface (_tmp29_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		self->priv->tile_pattern = _tmp30_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_cairo_destroy0 (c);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 448 "game-view.c"
	}
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp31_ = game_view_get_game (self);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp33_ = _tmp32_->tiles;
#line 456 "game-view.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		tile_collection = _tmp33_;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 464 "game-view.c"
			Tile* _tmp34_ = NULL;
			Tile* tile = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp34_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			tile = _tmp34_;
#line 471 "game-view.c"
			{
				Tile* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				gint x = 0;
				gint y = 0;
				Tile* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint texture_x = 0;
				Tile* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint texture_y = 0;
				Game* _tmp44_ = NULL;
				Game* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp70_ = FALSE;
				cairo_t* _tmp86_ = NULL;
				gint _tmp87_ = 0;
				gint _tmp88_ = 0;
				gint _tmp89_ = 0;
				gint _tmp90_ = 0;
				cairo_t* _tmp91_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp35_ = tile;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp36_ = _tmp35_->visible;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				if (!_tmp36_) {
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_g_object_unref0 (tile);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					continue;
#line 507 "game-view.c"
				}
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp37_ = tile;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				game_view_get_tile_position (self, _tmp37_, &_tmp38_, &_tmp39_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				x = _tmp38_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				y = _tmp39_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp40_ = tile;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp41_ = _tmp40_->number;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp42_ = game_view_get_image_offset (self, _tmp41_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp43_ = image_width;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				texture_x = _tmp42_ * _tmp43_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				texture_y = 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp44_ = game_view_get_game (self);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp45_ = _tmp44_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp46_ = game_get_paused (_tmp45_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp47_ = _tmp46_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				if (_tmp47_) {
#line 539 "game-view.c"
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp48_ = game_view_get_image_offset (self, -1);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp49_ = image_width;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					texture_x = _tmp48_ * _tmp49_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					texture_y = 0;
#line 550 "game-view.c"
				} else {
					Tile* _tmp50_ = NULL;
					Game* _tmp51_ = NULL;
					Game* _tmp52_ = NULL;
					Tile* _tmp53_ = NULL;
					Tile* _tmp54_ = NULL;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp50_ = tile;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp51_ = game_view_get_game (self);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp52_ = _tmp51_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp53_ = game_get_selected_tile (_tmp52_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp54_ = _tmp53_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					if (_tmp50_ == _tmp54_) {
#line 569 "game-view.c"
						gint _tmp55_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						_tmp55_ = image_height;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						texture_y = _tmp55_;
#line 575 "game-view.c"
					} else {
						gboolean _tmp56_ = FALSE;
						Game* _tmp57_ = NULL;
						Game* _tmp58_ = NULL;
						guint _tmp59_ = 0U;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						_tmp57_ = game_view_get_game (self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						_tmp58_ = _tmp57_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						_tmp59_ = _tmp58_->hint_blink_counter;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						if ((_tmp59_ % 2) == ((guint) 1)) {
#line 589 "game-view.c"
							gboolean _tmp60_ = FALSE;
							Tile* _tmp61_ = NULL;
							Game* _tmp62_ = NULL;
							Game* _tmp63_ = NULL;
							Tile* _tmp64_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp61_ = tile;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp62_ = game_view_get_game (self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp63_ = _tmp62_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp64_ = _tmp63_->hint_tiles[0];
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							if (_tmp61_ == _tmp64_) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp60_ = TRUE;
#line 607 "game-view.c"
							} else {
								Tile* _tmp65_ = NULL;
								Game* _tmp66_ = NULL;
								Game* _tmp67_ = NULL;
								Tile* _tmp68_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp65_ = tile;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp66_ = game_view_get_game (self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp67_ = _tmp66_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp68_ = _tmp67_->hint_tiles[1];
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
								_tmp60_ = _tmp65_ == _tmp68_;
#line 623 "game-view.c"
							}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp56_ = _tmp60_;
#line 627 "game-view.c"
						} else {
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp56_ = FALSE;
#line 631 "game-view.c"
						}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
						if (_tmp56_) {
#line 635 "game-view.c"
							gint _tmp69_ = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							_tmp69_ = image_height;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
							texture_y = _tmp69_;
#line 641 "game-view.c"
						}
					}
				}
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp70_ = render_indexes;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				if (_tmp70_) {
#line 649 "game-view.c"
					cairo_t* _tmp71_ = NULL;
					Tile* _tmp72_ = NULL;
					gint _tmp73_ = 0;
					Tile* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					Tile* _tmp76_ = NULL;
					gint _tmp77_ = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp71_ = cr;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp72_ = tile;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp73_ = _tmp72_->number;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp74_ = tile;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp75_ = _tmp74_->number;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp76_ = tile;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp77_ = _tmp76_->number;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					cairo_set_source_rgb (_tmp71_, _tmp73_ / 255.0, _tmp75_ / 255.0, _tmp77_ / 255.0);
#line 673 "game-view.c"
				} else {
					cairo_matrix_t matrix = {0};
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					cairo_pattern_t* _tmp82_ = NULL;
					cairo_matrix_t _tmp83_ = {0};
					cairo_t* _tmp84_ = NULL;
					cairo_pattern_t* _tmp85_ = NULL;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					cairo_matrix_init_identity (&matrix);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp78_ = texture_x;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp79_ = x;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp80_ = texture_y;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp81_ = y;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					cairo_matrix_translate (&matrix, (gdouble) (_tmp78_ - _tmp79_), (gdouble) (_tmp80_ - _tmp81_));
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp82_ = self->priv->tile_pattern;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp83_ = matrix;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					cairo_pattern_set_matrix (_tmp82_, &_tmp83_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp84_ = cr;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_tmp85_ = self->priv->tile_pattern;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					cairo_set_source (_tmp84_, _tmp85_);
#line 708 "game-view.c"
				}
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp86_ = cr;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp87_ = x;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp88_ = y;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp89_ = image_width;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp90_ = image_height;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				cairo_rectangle (_tmp86_, (gdouble) _tmp87_, (gdouble) _tmp88_, (gdouble) _tmp89_, (gdouble) _tmp90_);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp91_ = cr;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				cairo_fill (_tmp91_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_g_object_unref0 (tile);
#line 728 "game-view.c"
			}
		}
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp92_ = game_view_get_game (self);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp93_ = _tmp92_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp94_ = game_get_paused (_tmp93_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp95_ = _tmp94_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp95_) {
#line 742 "game-view.c"
		cairo_t* _tmp96_ = NULL;
		cairo_t* _tmp97_ = NULL;
		cairo_t* _tmp98_ = NULL;
		cairo_t* _tmp99_ = NULL;
		gint _tmp100_ = 0;
		gchar* text = NULL;
		const gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		cairo_text_extents_t _tmp105_ = {0};
		cairo_t* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		cairo_text_extents_t _tmp108_ = {0};
		gdouble _tmp109_ = 0.0;
		gint _tmp110_ = 0;
		cairo_text_extents_t _tmp111_ = {0};
		gdouble _tmp112_ = 0.0;
		cairo_t* _tmp113_ = NULL;
		cairo_t* _tmp114_ = NULL;
		const gchar* _tmp115_ = NULL;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp96_ = cr;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_set_source_rgba (_tmp96_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp97_ = cr;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_paint (_tmp97_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp98_ = cr;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_select_font_face (_tmp98_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp99_ = cr;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp100_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_set_font_size (_tmp99_, _tmp100_ * 0.125);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp101_ = _ ("Paused");
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp102_ = g_strdup (_tmp101_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		text = _tmp102_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp103_ = cr;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp104_ = text;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_text_extents (_tmp103_, _tmp104_, &_tmp105_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		extents = _tmp105_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp106_ = cr;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp107_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp108_ = extents;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp109_ = _tmp108_.width;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp110_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp111_ = extents;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp112_ = _tmp111_.height;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_move_to (_tmp106_, (_tmp107_ - _tmp109_) / 2.0, (_tmp110_ + _tmp112_) / 2.0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp113_ = cr;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_set_source_rgb (_tmp113_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp114_ = cr;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp115_ = text;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_show_text (_tmp114_, _tmp115_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_free0 (text);
#line 825 "game-view.c"
	}
}


static void game_view_load_theme (GameView* self, cairo_t* c, gint width, gint height) {
	GError * _inner_error_ = NULL;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 836 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		RsvgHandle* _tmp2_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t _tmp10_ = {0};
		cairo_t* _tmp11_ = NULL;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = game_view_get_theme (self);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp1_ = _tmp0_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp2_ = rsvg_handle_new_from_file (_tmp1_, &_inner_error_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		h = _tmp2_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 862 "game-view.c"
			goto __catch0_g_error;
		}
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp3_ = width;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_object_get (h, "width", &_tmp4_, NULL);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp6_ = height;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_object_get (h, "height", &_tmp7_, NULL);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp3_) / _tmp5_, ((gdouble) _tmp6_) / _tmp8_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp9_ = c;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp10_ = m;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_set_matrix (_tmp9_, &_tmp10_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp11_ = c;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp11_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_object_unref0 (h);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 895 "game-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		e = _inner_error_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_inner_error_ = NULL;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_error_free0 (e);
#line 907 "game-view.c"
	}
	__finally0:
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 918 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		cairo_t* _tmp19_ = NULL;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp12_ = game_view_get_theme (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp14_ = width;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp15_ = height;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp16_ = gdk_pixbuf_new_from_file_at_scale (_tmp13_, _tmp14_, _tmp15_, FALSE, &_inner_error_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		p = _tmp16_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 944 "game-view.c"
			goto __catch1_g_error;
		}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp17_ = c;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp18_ = p;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp19_ = c;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		cairo_paint (_tmp19_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_object_unref0 (p);
#line 959 "game-view.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		e = _inner_error_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_inner_error_ = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp20_ = game_view_get_theme (self);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp22_ = e;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp23_ = _tmp22_->message;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_warning ("game-view.vala:167: Failed to load theme %s: %s", _tmp21_, _tmp23_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_error_free0 (e);
#line 985 "game-view.c"
	}
	__finally1:
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 996 "game-view.c"
	}
}


static void game_view_update_dimensions (GameView* self) {
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint theme_width = 0;
	gint theme_height = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gdouble aspect = 0.0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gdouble map_width = 0.0;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Map* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gdouble map_height = 0.0;
	Game* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	Map* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gdouble _tmp19_ = 0.0;
	gdouble unit_width = 0.0;
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gint _tmp22_ = 0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble unit_height = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	Game* _tmp32_ = NULL;
	Game* _tmp33_ = NULL;
	Map* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	guint _tmp36_ = 0U;
	gdouble _tmp37_ = 0.0;
	gint _tmp38_ = 0;
	Game* _tmp39_ = NULL;
	Game* _tmp40_ = NULL;
	Map* _tmp41_ = NULL;
	guint _tmp42_ = 0U;
	guint _tmp43_ = 0U;
	gdouble _tmp44_ = 0.0;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	width = _tmp0_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	height = _tmp1_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = game_view_get_theme (self);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 1074 "game-view.c"
	}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp6_ = game_view_get_theme_dimensions (self, &_tmp4_, &_tmp5_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	theme_width = _tmp4_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	theme_height = _tmp5_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (!_tmp6_) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return;
#line 1086 "game-view.c"
	}
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp7_ = theme_height;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp8_ = theme_width;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	aspect = (((gdouble) _tmp7_) / 2) / (((gdouble) _tmp8_) / 43);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp9_ = game_view_get_game (self);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp10_ = _tmp9_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp11_ = _tmp10_->map;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp12_ = map_get_width (_tmp11_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	map_width = _tmp13_ + 2.0;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp14_ = game_view_get_game (self);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp16_ = _tmp15_->map;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp17_ = map_get_height (_tmp16_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp18_ = _tmp17_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp19_ = aspect;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	map_height = (_tmp18_ + 2.0) * _tmp19_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp20_ = width;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp21_ = map_width;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp22_ = height;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp23_ = map_height;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp24_ = MIN (_tmp20_ / _tmp21_, _tmp22_ / _tmp23_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	unit_width = _tmp24_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp25_ = unit_width;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp26_ = aspect;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	unit_height = _tmp25_ * _tmp26_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp27_ = unit_width;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_width = (gint) (_tmp27_ * 2);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp28_ = unit_height;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_height = (gint) (_tmp28_ * 2);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp29_ = self->priv->tile_width;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_layer_offset_x = _tmp29_ / 7;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp30_ = self->priv->tile_height;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_layer_offset_y = _tmp30_ / 10;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp31_ = width;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp32_ = game_view_get_game (self);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp33_ = _tmp32_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp34_ = _tmp33_->map;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp35_ = map_get_width (_tmp34_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp37_ = unit_width;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->x_offset = ((gint) (_tmp31_ - (_tmp36_ * _tmp37_))) / 2;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp38_ = height;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp39_ = game_view_get_game (self);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp40_ = _tmp39_;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp41_ = _tmp40_->map;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp42_ = map_get_height (_tmp41_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp43_ = _tmp42_;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp44_ = unit_height;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->y_offset = ((gint) (_tmp38_ - (_tmp43_ * _tmp44_))) / 2;
#line 1186 "game-view.c"
}


static gboolean game_view_get_theme_dimensions (GameView* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1197 "game-view.c"
	{
		RsvgHandle* svg = NULL;
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		RsvgHandle* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = game_view_get_theme (self);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp1_ = _tmp0_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp2_ = rsvg_handle_new_from_file (_tmp1_, &_inner_error_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		svg = _tmp2_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1217 "game-view.c"
			goto __catch2_g_error;
		}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_object_get (svg, "width", &_tmp3_, NULL);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_vala_width = _tmp4_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_object_get (svg, "height", &_tmp5_, NULL);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_vala_height = _tmp6_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = TRUE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_object_unref0 (svg);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (width) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			*width = _vala_width;
#line 1240 "game-view.c"
		}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (height) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			*height = _vala_height;
#line 1246 "game-view.c"
		}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1250 "game-view.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		e = _inner_error_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_inner_error_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp7_ = game_view_get_theme (self);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		gdk_pixbuf_get_file_info (_tmp8_, &_tmp9_, &_tmp10_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_vala_width = _tmp9_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_vala_height = _tmp10_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = TRUE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_error_free0 (e);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (width) {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			*width = _vala_width;
#line 1282 "game-view.c"
		}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (height) {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			*height = _vala_height;
#line 1288 "game-view.c"
		}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1292 "game-view.c"
	}
	__finally2:
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_clear_error (&_inner_error_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return FALSE;
#line 1301 "game-view.c"
}


static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _tmp0_ = 0;
	Tile* _tmp1_ = NULL;
	Slot* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Tile* _tmp5_ = NULL;
	Slot* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Tile* _tmp10_ = NULL;
	Slot* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	Tile* _tmp14_ = NULL;
	Slot* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (tile != NULL);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = self->priv->x_offset;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = tile;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = _tmp1_->slot;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = _tmp2_->x;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = self->priv->tile_width;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp5_ = tile;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp6_ = _tmp5_->slot;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp7_ = _tmp6_->layer;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp8_ = self->priv->tile_layer_offset_x;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_vala_x = (_tmp0_ + ((_tmp3_ * _tmp4_) / 2)) + (_tmp7_ * _tmp8_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp9_ = self->priv->y_offset;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp10_ = tile;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp11_ = _tmp10_->slot;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp12_ = _tmp11_->y;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp13_ = self->priv->tile_height;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp14_ = tile;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp15_ = _tmp14_->slot;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp16_ = _tmp15_->layer;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp17_ = self->priv->tile_layer_offset_y;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_vala_y = (_tmp9_ + ((_tmp12_ * _tmp13_) / 2)) - (_tmp16_ * _tmp17_);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (x) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		*x = _vala_x;
#line 1374 "game-view.c"
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (y) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		*y = _vala_y;
#line 1380 "game-view.c"
	}
}


static gint game_view_get_image_offset (GameView* self, gint number) {
	gint result = 0;
	gint set = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = number;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	set = _tmp0_ / 4;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = number;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp2_ < 0) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp1_ = TRUE;
#line 1406 "game-view.c"
	} else {
		gint _tmp3_ = 0;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp3_ = set;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp1_ = _tmp3_ >= 36;
#line 1413 "game-view.c"
	}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp1_) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = 42;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1421 "game-view.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = set;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp4_ == 33) {
#line 1427 "game-view.c"
		gint _tmp5_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp5_ = number;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = 33 + (_tmp5_ % 4);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1435 "game-view.c"
	}
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp6_ = set;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp6_ == 35) {
#line 1441 "game-view.c"
		gint _tmp7_ = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp7_ = number;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = 38 + (_tmp7_ % 4);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1449 "game-view.c"
	}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp8_ = set;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp8_ == 34) {
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = 37;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1459 "game-view.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = set;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 1465 "game-view.c"
}


static void game_view_redraw_tile_cb (GameView* self, Tile* tile) {
	gint x = 0;
	gint y = 0;
	Tile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (tile != NULL);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_update_dimensions (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = tile;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_get_tile_position (self, _tmp0_, &_tmp1_, &_tmp2_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	x = _tmp1_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	y = _tmp2_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = self->priv->tile_pattern_width;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = self->priv->tile_pattern_height;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, x, y, _tmp3_, _tmp4_);
#line 1497 "game-view.c"
}


static void game_view_paused_changed_cb (GameView* self) {
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1506 "game-view.c"
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self = (GameView*) base;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = FALSE;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1533 "game-view.c"
	}
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = cr;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = self->background_color;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gdk_cairo_set_source_rgba (_tmp2_, &_tmp3_);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = cr;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	cairo_paint (_tmp4_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp5_ = cr;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_draw_game (self, _tmp5_, FALSE);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = TRUE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 1553 "game-view.c"
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	GdkEventButton* _tmp7_ = NULL;
	GdkEventType _tmp8_ = 0;
	Tile* tile = NULL;
	GdkEventButton* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	GdkEventButton* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	Tile* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Tile* _tmp15_ = NULL;
	GdkEventButton* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self = (GameView*) base;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp2_ == NULL) {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = TRUE;
#line 1587 "game-view.c"
	} else {
		Game* _tmp3_ = NULL;
		Game* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp3_ = game_view_get_game (self);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp5_ = game_get_paused (_tmp4_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp0_ = _tmp6_;
#line 1603 "game-view.c"
	}
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp0_) {
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1611 "game-view.c"
	}
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp7_ = event;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp8_ = _tmp7_->type;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp8_ != GDK_BUTTON_PRESS) {
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1623 "game-view.c"
	}
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp9_ = event;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp10_ = _tmp9_->x;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp11_ = event;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp12_ = _tmp11_->y;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp13_ = game_view_find_tile (self, (guint) _tmp10_, (guint) _tmp12_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	tile = _tmp13_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp15_ = tile;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp15_ == NULL) {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp14_ = TRUE;
#line 1643 "game-view.c"
	} else {
		Game* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Tile* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp16_ = game_view_get_game (self);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp17_ = _tmp16_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp18_ = tile;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp19_ = game_tile_can_move (_tmp17_, _tmp18_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp14_ = !_tmp19_;
#line 1659 "game-view.c"
	}
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp14_) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		result = TRUE;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_g_object_unref0 (tile);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		return result;
#line 1669 "game-view.c"
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp20_ = event;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp21_ = _tmp20_->button;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	if (_tmp21_ == ((guint) 1)) {
#line 1677 "game-view.c"
		Game* _tmp22_ = NULL;
		Game* _tmp23_ = NULL;
		Tile* _tmp24_ = NULL;
		Tile* _tmp25_ = NULL;
		Tile* _tmp29_ = NULL;
		Game* _tmp30_ = NULL;
		Game* _tmp31_ = NULL;
		Tile* _tmp32_ = NULL;
		Tile* _tmp33_ = NULL;
		Game* _tmp36_ = NULL;
		Game* _tmp37_ = NULL;
		Tile* _tmp38_ = NULL;
		Tile* _tmp39_ = NULL;
		Tile* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp22_ = game_view_get_game (self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp24_ = game_get_selected_tile (_tmp23_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (_tmp25_ == NULL) {
#line 1703 "game-view.c"
			Game* _tmp26_ = NULL;
			Game* _tmp27_ = NULL;
			Tile* _tmp28_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp26_ = game_view_get_game (self);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp27_ = _tmp26_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp28_ = tile;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			game_set_selected_tile (_tmp27_, _tmp28_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			result = TRUE;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_g_object_unref0 (tile);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			return result;
#line 1721 "game-view.c"
		}
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp29_ = tile;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp30_ = game_view_get_game (self);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp31_ = _tmp30_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp32_ = game_get_selected_tile (_tmp31_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp33_ = _tmp32_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (_tmp29_ == _tmp33_) {
#line 1735 "game-view.c"
			Game* _tmp34_ = NULL;
			Game* _tmp35_ = NULL;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp34_ = game_view_get_game (self);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp35_ = _tmp34_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			game_set_selected_tile (_tmp35_, NULL);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			result = TRUE;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_g_object_unref0 (tile);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			return result;
#line 1750 "game-view.c"
		}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp36_ = game_view_get_game (self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp37_ = _tmp36_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp38_ = game_get_selected_tile (_tmp37_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp39_ = _tmp38_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp40_ = tile;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		_tmp41_ = tile_matches (_tmp39_, _tmp40_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		if (_tmp41_) {
#line 1766 "game-view.c"
			Game* _tmp42_ = NULL;
			Game* _tmp43_ = NULL;
			Game* _tmp44_ = NULL;
			Game* _tmp45_ = NULL;
			Tile* _tmp46_ = NULL;
			Tile* _tmp47_ = NULL;
			Tile* _tmp48_ = NULL;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp42_ = game_view_get_game (self);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp43_ = _tmp42_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp44_ = game_view_get_game (self);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp45_ = _tmp44_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp46_ = game_get_selected_tile (_tmp45_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp47_ = _tmp46_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp48_ = tile;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			game_remove_pair (_tmp43_, _tmp47_, _tmp48_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			result = TRUE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_g_object_unref0 (tile);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			return result;
#line 1796 "game-view.c"
		} else {
			Game* _tmp49_ = NULL;
			Game* _tmp50_ = NULL;
			Tile* _tmp51_ = NULL;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp49_ = game_view_get_game (self);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp50_ = _tmp49_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp51_ = tile;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			game_set_selected_tile (_tmp50_, _tmp51_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			result = TRUE;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_g_object_unref0 (tile);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			return result;
#line 1815 "game-view.c"
		}
	}
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = FALSE;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_g_object_unref0 (tile);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 1824 "game-view.c"
}


static Tile* game_view_find_tile (GameView* self, guint x, guint y) {
	Tile* result = NULL;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	cairo_t* _tmp8_ = NULL;
	guchar* data = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	guchar* _tmp10_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guchar number = '\0';
	guchar* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	guchar _tmp12_ = '\0';
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 1, 1);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	surface = _tmp0_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = surface;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = cairo_create (_tmp1_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	cr = _tmp2_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = cr;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	cairo_set_source_rgba (_tmp3_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp4_ = cr;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	cairo_paint (_tmp4_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp5_ = cr;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp6_ = x;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp7_ = y;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	cairo_translate (_tmp5_, (gdouble) (-_tmp6_), (gdouble) (-_tmp7_));
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp8_ = cr;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_draw_game (self, _tmp8_, TRUE);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp9_ = surface;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp10_ = cairo_image_surface_get_data (_tmp9_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	data = _tmp10_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	data_length1 = -1;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_data_size_ = data_length1;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp11_ = data;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp11__length1 = data_length1;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp12_ = _tmp11_[0];
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	number = _tmp12_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp13_ = game_view_get_game (self);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp14_ = _tmp13_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp15_ = _tmp14_->tiles;
#line 1909 "game-view.c"
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		tile_collection = _tmp15_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
#line 1917 "game-view.c"
			Tile* _tmp16_ = NULL;
			Tile* tile = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			_tmp16_ = _g_object_ref0 ((Tile*) tile_it->data);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
			tile = _tmp16_;
#line 1924 "game-view.c"
			{
				Tile* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				guchar _tmp19_ = '\0';
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp17_ = tile;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp18_ = _tmp17_->number;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_tmp19_ = number;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				if (_tmp18_ == ((gint) _tmp19_)) {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					result = tile;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_cairo_destroy0 (cr);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					_cairo_surface_destroy0 (surface);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
					return result;
#line 1945 "game-view.c"
				}
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
				_g_object_unref0 (tile);
#line 1949 "game-view.c"
			}
		}
	}
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = NULL;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_cairo_destroy0 (cr);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_cairo_surface_destroy0 (surface);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 1961 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = _tmp0_;
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 1976 "game-view.c"
}


static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self) {
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_redraw_tile_cb ((GameView*) self, tile);
#line 1983 "game-view.c"
}


static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender, gpointer self) {
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_paused_changed_cb ((GameView*) self);
#line 1990 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = value;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->_game = _tmp1_;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp2_ = self->priv->_game;
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_signal_connect_object (_tmp2_, "redraw-tile", (GCallback) _game_view_redraw_tile_cb_game_redraw_tile, self, 0);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp3_ = self->priv->_game;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_signal_connect_object (_tmp3_, "paused-changed", (GCallback) _game_view_paused_changed_cb_game_paused_changed, self, 0);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2021 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	result = _tmp0_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	return result;
#line 2036 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp0_ = value;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->_theme = _tmp1_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_pattern = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 2061 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	((GtkWidgetClass *) klass)->draw = game_view_real_draw;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = game_view_real_button_press_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2084 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_pattern = NULL;
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_pattern_width = 0;
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->tile_pattern_height = 0;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self->priv->_theme = NULL;
#line 2099 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2115 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 2148 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 2154 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 2176 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-mahjongg/src/game-view.vala"
		break;
#line 2182 "game-view.c"
	}
}



