/* gkr-backend.c generated by valac 0.28.0, the Vala compiler
 * generated from gkr-backend.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsecret/secret.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gcr/gcr-base.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include "config.h"


#define SEAHORSE_GKR_TYPE_MY_SERVICE (seahorse_gkr_my_service_get_type ())
#define SEAHORSE_GKR_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyService))
#define SEAHORSE_GKR_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))
#define SEAHORSE_GKR_IS_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_IS_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_MY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))

typedef struct _SeahorseGkrMyService SeahorseGkrMyService;
typedef struct _SeahorseGkrMyServiceClass SeahorseGkrMyServiceClass;
typedef struct _SeahorseGkrMyServicePrivate SeahorseGkrMyServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseGkrMyService {
	SecretService parent_instance;
	SeahorseGkrMyServicePrivate * priv;
};

struct _SeahorseGkrMyServiceClass {
	SecretServiceClass parent_class;
};

struct _SeahorseGkrBackendPrivate {
	SecretService* _service;
	GHashTable* _keyrings;
	GHashTable* _aliases;
	GtkActionGroup* _actions;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseGkrBackend* self;
	gchar* name;
};

struct _SeahorseGkrBackendActionsPrivate {
	SeahorseGkrBackend* _backend;
	gboolean _initialized;
};


static gpointer seahorse_gkr_my_service_parent_class = NULL;
static gpointer seahorse_gkr_backend_parent_class = NULL;
static SeahorseGkrBackend* seahorse_gkr_backend__instance;
static SeahorseGkrBackend* seahorse_gkr_backend__instance = NULL;
static GcrCollectionIface* seahorse_gkr_backend_gcr_collection_parent_iface = NULL;
static SeahorseBackendIface* seahorse_gkr_backend_seahorse_backend_parent_iface = NULL;
static gpointer seahorse_gkr_backend_actions_parent_class = NULL;
static GWeakRef seahorse_gkr_backend_actions__instance;
static GWeakRef seahorse_gkr_backend_actions__instance = {0};

GType seahorse_gkr_my_service_get_type (void) G_GNUC_CONST;
enum  {
	SEAHORSE_GKR_MY_SERVICE_DUMMY_PROPERTY
};
static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base);
static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base);
SeahorseGkrMyService* seahorse_gkr_my_service_new (void);
SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type);
#define SEAHORSE_GKR_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackendPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_NAME,
	SEAHORSE_GKR_BACKEND_LABEL,
	SEAHORSE_GKR_BACKEND_DESCRIPTION,
	SEAHORSE_GKR_BACKEND_ACTIONS,
	SEAHORSE_GKR_BACKEND_ALIASES,
	SEAHORSE_GKR_BACKEND_SERVICE
};
static void seahorse_gkr_backend_real_dispose (GObject* base);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static guint seahorse_gkr_backend_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object);
static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri);
static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self);
static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ___lambda16_ (SeahorseGkrBackend* self, GParamSpec* pspec);
static void ____lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda17_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ____lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __seahorse_gkr_backend___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActionsPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_ACTIONS_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND
};
static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self);
#define SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI "\"<ui>\n" \
"\t\t\t<popup name='SeahorseGkrBackend'>\n" \
"\t\t\t\t<menuitem action='keyring-new'/>\n" \
"\t\t\t</popup>\n" \
"\t\t</ui>"
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend);
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend);
static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend_actions___lambda14_ (SeahorseGkrBackendActions* self, GParamSpec* pspec);
static void __seahorse_gkr_backend_actions___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void seahorse_gkr_backend_actions_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS[2] = {{"keyring-new", NULL, "New password keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", NULL, "New password...", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};
static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW[2] = {{"keyring-new", "folder", "Password Keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", SEAHORSE_ICON_PASSWORD, "Stored Password", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};

static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
	self = (SeahorseGkrMyService*) base;
	result = SEAHORSE_GKR_TYPE_KEYRING;
	return result;
}


static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
	self = (SeahorseGkrMyService*) base;
	result = SEAHORSE_GKR_TYPE_ITEM;
	return result;
}


SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type) {
	SeahorseGkrMyService * self = NULL;
	self = (SeahorseGkrMyService*) g_object_new (object_type, NULL);
	return self;
}


SeahorseGkrMyService* seahorse_gkr_my_service_new (void) {
	return seahorse_gkr_my_service_construct (SEAHORSE_GKR_TYPE_MY_SERVICE);
}


static void seahorse_gkr_my_service_class_init (SeahorseGkrMyServiceClass * klass) {
	seahorse_gkr_my_service_parent_class = g_type_class_peek_parent (klass);
	((SecretServiceClass *) klass)->get_collection_gtype = seahorse_gkr_my_service_real_get_collection_gtype;
	((SecretServiceClass *) klass)->get_item_gtype = seahorse_gkr_my_service_real_get_item_gtype;
}


static void seahorse_gkr_my_service_instance_init (SeahorseGkrMyService * self) {
}


GType seahorse_gkr_my_service_get_type (void) {
	static volatile gsize seahorse_gkr_my_service_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_my_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrMyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_my_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrMyService), 0, (GInstanceInitFunc) seahorse_gkr_my_service_instance_init, NULL };
		GType seahorse_gkr_my_service_type_id;
		seahorse_gkr_my_service_type_id = g_type_register_static (secret_service_get_type (), "SeahorseGkrMyService", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_my_service_type_id__volatile, seahorse_gkr_my_service_type_id);
	}
	return seahorse_gkr_my_service_type_id__volatile;
}


static void seahorse_gkr_backend_real_dispose (GObject* base) {
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_aliases;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->_keyrings;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = self->priv->_actions;
	gtk_action_group_set_sensitive (_tmp2_, FALSE);
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void seahorse_gkr_backend_refresh_collections (SeahorseGkrBackend* self) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* keyrings = NULL;
	SecretService* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gchar* object_path = NULL;
	GList* _tmp5_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	seen = _tmp2_;
	_tmp3_ = self->priv->_service;
	_tmp4_ = secret_service_get_collections (_tmp3_);
	keyrings = _tmp4_;
	_tmp5_ = keyrings;
	{
		GList* keyring_collection = NULL;
		GList* keyring_it = NULL;
		keyring_collection = _tmp5_;
		for (keyring_it = keyring_collection; keyring_it != NULL; keyring_it = keyring_it->next) {
			SecretCollection* _tmp6_ = NULL;
			SecretCollection* keyring = NULL;
			_tmp6_ = _g_object_ref0 ((SecretCollection*) keyring_it->data);
			keyring = _tmp6_;
			{
				SecretCollection* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				GHashTable* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GHashTable* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				GHashTable* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gconstpointer _tmp18_ = NULL;
				_tmp7_ = keyring;
				_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (object_path);
				object_path = _tmp9_;
				_tmp10_ = self->priv->_aliases;
				_tmp11_ = g_hash_table_lookup (_tmp10_, "session");
				_tmp12_ = object_path;
				if (g_strcmp0 ((const gchar*) _tmp11_, _tmp12_) == 0) {
					_g_object_unref0 (keyring);
					continue;
				}
				_tmp13_ = seen;
				_tmp14_ = object_path;
				_tmp15_ = g_strdup (_tmp14_);
				g_hash_table_add (_tmp13_, _tmp15_);
				_tmp16_ = self->priv->_keyrings;
				_tmp17_ = object_path;
				_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
				if (((SeahorseGkrKeyring*) _tmp18_) == NULL) {
					GHashTable* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					SecretCollection* _tmp22_ = NULL;
					SeahorseGkrKeyring* _tmp23_ = NULL;
					SecretCollection* _tmp24_ = NULL;
					_tmp19_ = self->priv->_keyrings;
					_tmp20_ = object_path;
					_tmp21_ = g_strdup (_tmp20_);
					_tmp22_ = keyring;
					_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
					g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
					_tmp24_ = keyring;
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp24_);
				}
				_g_object_unref0 (keyring);
			}
		}
	}
	_tmp25_ = self->priv->_keyrings;
	g_hash_table_iter_init (&iter, _tmp25_);
	while (TRUE) {
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		gchar* _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		_tmp27_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp26_), (gpointer*) NULL);
		_g_free0 (object_path);
		_tmp28_ = g_strdup (_tmp26_);
		object_path = _tmp28_;
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = seen;
		_tmp30_ = object_path;
		_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
		if (((const gchar*) _tmp31_) == NULL) {
			SeahorseGkrKeyring* keyring = NULL;
			GHashTable* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gconstpointer _tmp34_ = NULL;
			SeahorseGkrKeyring* _tmp35_ = NULL;
			SeahorseGkrKeyring* _tmp36_ = NULL;
			_tmp32_ = self->priv->_keyrings;
			_tmp33_ = object_path;
			_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
			_tmp35_ = _g_object_ref0 ((SeahorseGkrKeyring*) _tmp34_);
			keyring = _tmp35_;
			g_hash_table_iter_remove (&iter);
			_tmp36_ = keyring;
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp36_);
			_g_object_unref0 (keyring);
		}
	}
	_g_free0 (object_path);
	__g_list_free__g_object_unref0_0 (keyrings);
	_g_hash_table_unref0 (seen);
}


static guint seahorse_gkr_backend_real_get_length (GcrCollection* base) {
	SeahorseGkrBackend * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_keyrings;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = _tmp1_;
	return result;
}


static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base) {
	SeahorseGkrBackend * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = seahorse_gkr_backend_get_keyrings (self);
	result = _tmp0_;
	return result;
}


static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object) {
	SeahorseGkrBackend * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
	self = (SeahorseGkrBackend*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING)) {
		SeahorseGkrKeyring* keyring = NULL;
		GObject* _tmp1_ = NULL;
		SeahorseGkrKeyring* _tmp2_ = NULL;
		GHashTable* _tmp3_ = NULL;
		SeahorseGkrKeyring* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		SeahorseGkrKeyring* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp1_ = object;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
		keyring = _tmp2_;
		_tmp3_ = self->priv->_keyrings;
		_tmp4_ = keyring;
		_tmp5_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_hash_table_lookup (_tmp3_, _tmp7_);
		_tmp9_ = keyring;
		_tmp10_ = ((SeahorseGkrKeyring*) _tmp8_) == _tmp9_;
		_g_free0 (_tmp7_);
		result = _tmp10_;
		_g_object_unref0 (keyring);
		return result;
	}
	result = FALSE;
	return result;
}


static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri) {
	SeahorseGkrBackend * self;
	SeahorsePlace* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	SeahorsePlace* _tmp3_ = NULL;
	self = (SeahorseGkrBackend*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->_keyrings;
	_tmp1_ = uri;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((SeahorsePlace*) ((SeahorseGkrKeyring*) _tmp2_));
	result = _tmp3_;
	return result;
}


void seahorse_gkr_backend_initialize (void) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackend* _tmp3_ = NULL;
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_if_fail (_tmp0_ == NULL);
	_tmp1_ = seahorse_gkr_backend_new ();
	_tmp2_ = _tmp1_;
	seahorse_backend_register ((SeahorseBackend*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = seahorse_gkr_backend__instance;
	g_return_if_fail (_tmp3_ != NULL);
}


SeahorseGkrBackend* seahorse_gkr_backend_instance (void) {
	SeahorseGkrBackend* result = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp1_ = seahorse_gkr_backend__instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


GList* seahorse_gkr_backend_get_keyrings (SeahorseGkrBackend* self) {
	GList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keyrings;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorseGkrBackend* self;
		self = _data1_->self;
		_g_free0 (_data1_->name);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrBackend* self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* object_path = NULL;
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp0_ = self->priv->_service;
		_tmp1_ = res;
		_tmp2_ = secret_service_read_alias_dbus_path_finish (_tmp0_, _tmp1_, &_inner_error_);
		object_path = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		if (object_path != NULL) {
			GHashTable* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp3_ = self->priv->_aliases;
			_tmp4_ = _data1_->name;
			_tmp5_ = g_strdup (_tmp4_);
			_tmp6_ = g_strdup (object_path);
			g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
			g_object_notify ((GObject*) self, "aliases");
		}
		_g_free0 (object_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _data1_->name;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("gkr-backend.vala:174: Couldn't read secret service alias %s: %s", _tmp7_, _tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ (self, source_object, res);
	block1_data_unref (self);
}


static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	SecretService* _tmp2_ = NULL;
	SecretService* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data1_->name);
	_data1_->name = _tmp1_;
	_tmp2_ = self->priv->_service;
	if (_tmp2_ == NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = self->priv->_service;
	_tmp4_ = _data1_->name;
	secret_service_read_alias_dbus_path (_tmp3_, _tmp4_, NULL, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self) {
	g_return_if_fail (self != NULL);
	seahorse_gkr_backend_read_alias (self, "default");
	seahorse_gkr_backend_read_alias (self, "session");
	seahorse_gkr_backend_read_alias (self, "login");
}


void seahorse_gkr_backend_refresh (SeahorseGkrBackend* self) {
	g_return_if_fail (self != NULL);
	seahorse_gkr_backend_refresh_aliases (self);
	seahorse_gkr_backend_refresh_collections (self);
}


gboolean seahorse_gkr_backend_has_alias (SeahorseGkrBackend* self, const gchar* alias, SeahorseGkrKeyring* keyring) {
	gboolean result = FALSE;
	gchar* object_path = NULL;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (alias != NULL, FALSE);
	g_return_val_if_fail (keyring != NULL, FALSE);
	_tmp0_ = keyring;
	_tmp1_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	object_path = _tmp2_;
	_tmp3_ = self->priv->_aliases;
	_tmp4_ = alias;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	result = g_strcmp0 ((const gchar*) _tmp5_, object_path) == 0;
	_g_free0 (object_path);
	return result;
}


SeahorseGkrBackend* seahorse_gkr_backend_construct (GType object_type) {
	SeahorseGkrBackend * self = NULL;
	self = (SeahorseGkrBackend*) g_object_new (object_type, NULL);
	return self;
}


SeahorseGkrBackend* seahorse_gkr_backend_new (void) {
	return seahorse_gkr_backend_construct (SEAHORSE_GKR_TYPE_BACKEND);
}


static const gchar* seahorse_gkr_backend_real_get_name (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	self = (SeahorseGkrBackend*) base;
	result = SEAHORSE_GKR_NAME;
	return result;
}


static const gchar* seahorse_gkr_backend_real_get_label (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = _ ("Passwords");
	result = _tmp0_;
	return result;
}


static const gchar* seahorse_gkr_backend_real_get_description (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = _ ("Stored personal passwords, credentials and secrets");
	result = _tmp0_;
	return result;
}


static GtkActionGroup* seahorse_gkr_backend_real_get_actions (SeahorseBackend* base) {
	GtkActionGroup* result;
	SeahorseGkrBackend* self;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	self = (SeahorseGkrBackend*) base;
	_tmp0_ = self->priv->_actions;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


GHashTable* seahorse_gkr_backend_get_aliases (SeahorseGkrBackend* self) {
	GHashTable* result;
	GHashTable* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aliases;
	result = _tmp0_;
	return result;
}


SecretService* seahorse_gkr_backend_get_service (SeahorseGkrBackend* self) {
	SecretService* result;
	SecretService* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}


static void ___lambda16_ (SeahorseGkrBackend* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->name;
	if (g_strcmp0 (_tmp1_, "collections") == 0) {
		seahorse_gkr_backend_refresh_collections (self);
	}
}


static void ____lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda16_ ((SeahorseGkrBackend*) self, pspec);
}


static void ___lambda17_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
	g_return_if_fail (res != NULL);
	seahorse_gkr_backend_refresh_collections (self);
}


static void ____lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda17_ ((SeahorseGkrBackend*) self, source_object, res);
	g_object_unref (self);
}


static void _seahorse_gkr_backend___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		SecretService* _tmp2_ = NULL;
		SecretService* _tmp3_ = NULL;
		SecretService* _tmp4_ = NULL;
		SecretService* _tmp5_ = NULL;
		_tmp1_ = res;
		_tmp2_ = secret_service_open_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->_service);
		self->priv->_service = _tmp3_;
		_tmp4_ = self->priv->_service;
		g_signal_connect_object ((GObject*) _tmp4_, "notify", (GCallback) ____lambda16__g_object_notify, self, 0);
		_tmp5_ = self->priv->_service;
		secret_service_load_collections (_tmp5_, NULL, ____lambda17__gasync_ready_callback, g_object_ref (self));
		seahorse_gkr_backend_refresh_aliases (self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("gkr-backend.vala:85: couldn't connect to secret service: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject*) self, "service");
}


static void __seahorse_gkr_backend___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_seahorse_gkr_backend___lambda15_ ((SeahorseGkrBackend*) self, source_object, res);
	g_object_unref (self);
}


static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackend * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	_tmp0_ = seahorse_gkr_backend__instance;
	g_return_val_if_fail (_tmp0_ == NULL, NULL);
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (seahorse_gkr_backend__instance);
	seahorse_gkr_backend__instance = _tmp1_;
	_tmp2_ = seahorse_gkr_backend_actions_instance (self);
	_g_object_unref0 (self->priv->_actions);
	self->priv->_actions = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_keyrings);
	self->priv->_keyrings = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->_aliases);
	self->priv->_aliases = _tmp8_;
	secret_service_open (SEAHORSE_GKR_TYPE_MY_SERVICE, NULL, SECRET_SERVICE_OPEN_SESSION, NULL, __seahorse_gkr_backend___lambda15__gasync_ready_callback, g_object_ref (self));
	return obj;
}


static void seahorse_gkr_backend_class_init (SeahorseGkrBackendClass * klass) {
	seahorse_gkr_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendPrivate));
	((GObjectClass *) klass)->dispose = seahorse_gkr_backend_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS, g_param_spec_object ("actions", "actions", "actions", gtk_action_group_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ALIASES, g_param_spec_boxed ("aliases", "aliases", "aliases", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_SERVICE, g_param_spec_object ("service", "service", "service", secret_service_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void seahorse_gkr_backend_gcr_collection_interface_init (GcrCollectionIface * iface) {
	seahorse_gkr_backend_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*)(GcrCollection*)) seahorse_gkr_backend_real_get_length;
	iface->get_objects = (GList* (*)(GcrCollection*)) seahorse_gkr_backend_real_get_objects;
	iface->contains = (gboolean (*)(GcrCollection*, GObject*)) seahorse_gkr_backend_real_contains;
}


static void seahorse_gkr_backend_seahorse_backend_interface_init (SeahorseBackendIface * iface) {
	seahorse_gkr_backend_seahorse_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_place = (SeahorsePlace* (*)(SeahorseBackend*, const gchar*)) seahorse_gkr_backend_real_lookup_place;
	iface->get_name = seahorse_gkr_backend_real_get_name;
	iface->get_label = seahorse_gkr_backend_real_get_label;
	iface->get_description = seahorse_gkr_backend_real_get_description;
	iface->get_actions = seahorse_gkr_backend_real_get_actions;
}


static void seahorse_gkr_backend_instance_init (SeahorseGkrBackend * self) {
	self->priv = SEAHORSE_GKR_BACKEND_GET_PRIVATE (self);
}


static void seahorse_gkr_backend_finalize (GObject* obj) {
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	_g_object_unref0 (self->priv->_service);
	_g_hash_table_unref0 (self->priv->_keyrings);
	_g_hash_table_unref0 (self->priv->_aliases);
	_g_object_unref0 (self->priv->_actions);
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->finalize (obj);
}


GType seahorse_gkr_backend_get_type (void) {
	static volatile gsize seahorse_gkr_backend_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackend), 0, (GInstanceInitFunc) seahorse_gkr_backend_instance_init, NULL };
		static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_backend_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_backend_info = { (GInterfaceInitFunc) seahorse_gkr_backend_seahorse_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_backend_type_id;
		seahorse_gkr_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseGkrBackend", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, gcr_collection_get_type (), &gcr_collection_info);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, SEAHORSE_TYPE_BACKEND, &seahorse_backend_info);
		g_once_init_leave (&seahorse_gkr_backend_type_id__volatile, seahorse_gkr_backend_type_id);
	}
	return seahorse_gkr_backend_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_NAME:
		g_value_set_string (value, seahorse_backend_get_name ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_LABEL:
		g_value_set_string (value, seahorse_backend_get_label ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_DESCRIPTION:
		g_value_set_string (value, seahorse_backend_get_description ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_ACTIONS:
		g_value_take_object (value, seahorse_backend_get_actions ((SeahorseBackend*) self));
		break;
		case SEAHORSE_GKR_BACKEND_ALIASES:
		g_value_set_boxed (value, seahorse_gkr_backend_get_aliases (self));
		break;
		case SEAHORSE_GKR_BACKEND_SERVICE:
		g_value_set_object (value, seahorse_gkr_backend_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_gkr_backend_actions_on_new_keyring (action);
}


static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_gkr_backend_actions_on_new_item (action);
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend) {
	SeahorseGkrBackendActions * self = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = backend;
	self = (SeahorseGkrBackendActions*) g_object_new (object_type, "name", "KeyringBackend", "backend", _tmp0_, NULL);
	return self;
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend) {
	return seahorse_gkr_backend_actions_construct (SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, backend);
}


static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrKeyringAdd* _tmp3_ = NULL;
	SeahorseGkrKeyringAdd* _tmp4_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = seahorse_action_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = seahorse_gkr_keyring_add_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrItemAdd* _tmp3_ = NULL;
	SeahorseGkrItemAdd* _tmp4_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = seahorse_action_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = seahorse_gkr_item_add_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


GtkActionGroup* seahorse_gkr_backend_actions_instance (SeahorseGkrBackend* backend) {
	GtkActionGroup* result = NULL;
	SeahorseGkrBackendActions* actions = NULL;
	GObject* _tmp0_ = NULL;
	SeahorseGkrBackendActions* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackendActions* _tmp3_ = NULL;
	SeahorseGkrBackendActions* _tmp4_ = NULL;
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&seahorse_gkr_backend_actions__instance);
	actions = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	_tmp1_ = actions;
	if (_tmp1_ != NULL) {
		result = (GtkActionGroup*) actions;
		return result;
	}
	_tmp2_ = backend;
	_tmp3_ = seahorse_gkr_backend_actions_new (_tmp2_);
	_g_object_unref0 (actions);
	actions = _tmp3_;
	_tmp4_ = actions;
	g_weak_ref_set (&seahorse_gkr_backend_actions__instance, (GObject*) _tmp4_);
	result = (GtkActionGroup*) actions;
	return result;
}


SeahorseGkrBackend* seahorse_gkr_backend_actions_get_backend (SeahorseGkrBackendActions* self) {
	SeahorseGkrBackend* result;
	SeahorseGkrBackend* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend;
	result = _tmp0_;
	return result;
}


static void seahorse_gkr_backend_actions_set_backend (SeahorseGkrBackendActions* self, SeahorseGkrBackend* value) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_backend);
	self->priv->_backend = _tmp1_;
	g_object_notify ((GObject *) self, "backend");
}


static void _seahorse_gkr_backend_actions___lambda14_ (SeahorseGkrBackendActions* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	SeahorseGkrBackend* _tmp3_ = NULL;
	SecretService* _tmp4_ = NULL;
	SecretService* _tmp5_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkActionGroup* _tmp8_ = NULL;
	GtkActionGroup* _tmp9_ = NULL;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->name;
	if (g_strcmp0 (_tmp1_, "service") == 0) {
		return;
	}
	_tmp2_ = self->priv->_initialized;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->_backend;
	_tmp4_ = seahorse_gkr_backend_get_service (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		return;
	}
	self->priv->_initialized = TRUE;
	gtk_action_group_add_actions ((GtkActionGroup*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS), NULL);
	seahorse_actions_register_definition ((SeahorseActions*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI);
	_tmp6_ = gtk_action_group_new ("gkr-generate");
	actions = _tmp6_;
	_tmp7_ = actions;
	gtk_action_group_set_translation_domain (_tmp7_, GETTEXT_PACKAGE);
	_tmp8_ = actions;
	gtk_action_group_add_actions (_tmp8_, SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW), NULL);
	_tmp9_ = actions;
	seahorse_registry_register_object ((GObject*) _tmp9_, "generator");
	_g_object_unref0 (actions);
}


static void __seahorse_gkr_backend_actions___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_seahorse_gkr_backend_actions___lambda14_ ((SeahorseGkrBackendActions*) self, pspec);
}


static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackendActions * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	self->priv->_initialized = FALSE;
	gtk_action_group_set_translation_domain ((GtkActionGroup*) self, GETTEXT_PACKAGE);
	_tmp0_ = self->priv->_backend;
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) __seahorse_gkr_backend_actions___lambda14__g_object_notify, self, G_CONNECT_AFTER);
	_tmp1_ = self->priv->_backend;
	g_object_notify ((GObject*) _tmp1_, "service");
	return obj;
}


static void seahorse_gkr_backend_actions_class_init (SeahorseGkrBackendActionsClass * klass) {
	seahorse_gkr_backend_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendActionsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_backend_actions_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_actions_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND, g_param_spec_object ("backend", "backend", "backend", SEAHORSE_GKR_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void seahorse_gkr_backend_actions_instance_init (SeahorseGkrBackendActions * self) {
	self->priv = SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE (self);
}


static void seahorse_gkr_backend_actions_finalize (GObject* obj) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	_g_object_unref0 (self->priv->_backend);
	G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class)->finalize (obj);
}


GType seahorse_gkr_backend_actions_get_type (void) {
	static volatile gsize seahorse_gkr_backend_actions_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackendActions), 0, (GInstanceInitFunc) seahorse_gkr_backend_actions_instance_init, NULL };
		GType seahorse_gkr_backend_actions_type_id;
		seahorse_gkr_backend_actions_type_id = g_type_register_static (SEAHORSE_TYPE_ACTIONS, "SeahorseGkrBackendActions", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_backend_actions_type_id__volatile, seahorse_gkr_backend_actions_type_id);
	}
	return seahorse_gkr_backend_actions_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
		g_value_set_object (value, seahorse_gkr_backend_actions_get_backend (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
	switch (property_id) {
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
		seahorse_gkr_backend_actions_set_backend (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



