/* rygel-media-export-item-factory.c generated by valac 0.29.2, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaFileItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaFileItem* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v);
void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v);
void rygel_media_export_item_factory_apply_file_info (RygelMediaFileItem* item, GVariant* v);
void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v);
void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v);
void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v);
void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v);
static void _vala_SoupDate_free (SoupDate* self);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;


RygelMediaFileItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaFileItem* result = NULL;
	gchar* title = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaFileItem* item = NULL;
	gchar* mime = NULL;
	GFileInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaFileItem* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	RygelMediaFileItem* _tmp40_ = NULL;
	GFileInfo* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	RygelMediaFileItem* _tmp43_ = NULL;
	GFileInfo* _tmp44_ = NULL;
	guint64 _tmp45_ = 0ULL;
	RygelMediaFileItem* _tmp46_ = NULL;
	GFile* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportVideoItem* _tmp13_ = NULL;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaFileItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportPhotoItem* _tmp21_ = NULL;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaFileItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = mime;
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
			if (_tmp24_) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp25_ = NULL;
				_tmp25_ = mime;
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
			}
			if (_tmp22_) {
				GFile* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				RygelMediaContainer* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				RygelMediaExportMusicItem* _tmp31_ = NULL;
				_tmp26_ = file;
				_tmp27_ = rygel_media_export_media_cache_get_id (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = parent;
				_tmp30_ = title;
				_tmp31_ = rygel_media_export_music_item_new (_tmp28_, _tmp29_, _tmp30_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp31_;
				_g_free0 (_tmp28_);
			} else {
				GFile* _tmp32_ = NULL;
				RygelMediaContainer* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				RygelMediaFileItem* _tmp35_ = NULL;
				RygelMediaFileItem* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				_tmp32_ = file;
				_tmp33_ = parent;
				_tmp34_ = title;
				_tmp35_ = rygel_media_export_item_factory_create_playlist_item (_tmp32_, _tmp33_, _tmp34_);
				_g_object_unref0 (item);
				item = _tmp35_;
				_tmp36_ = item;
				if (_tmp36_ == NULL) {
					result = NULL;
					_g_free0 (mime);
					_g_object_unref0 (item);
					_g_free0 (title);
					return result;
				}
				_tmp37_ = g_strdup ("text/xml");
				_g_free0 (mime);
				mime = _tmp37_;
			}
		}
	}
	_tmp38_ = item;
	_tmp39_ = mime;
	rygel_media_file_item_set_mime_type (_tmp38_, _tmp39_);
	_tmp40_ = item;
	_tmp41_ = info;
	_tmp42_ = g_file_info_get_size (_tmp41_);
	rygel_media_file_item_set_size (_tmp40_, (gint64) _tmp42_);
	_tmp43_ = item;
	_tmp44_ = info;
	_tmp45_ = g_file_info_get_attribute_uint64 (_tmp44_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp43_, _tmp45_);
	_tmp46_ = item;
	_tmp47_ = file;
	_tmp48_ = g_file_get_uri (_tmp47_);
	_tmp49_ = _tmp48_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp46_, _tmp49_);
	_g_free0 (_tmp49_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaFileItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gint _tmp14_ = 0;
		guint8 _tmp15_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		GUPnPMediaCollection* _tmp17_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp33_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		RygelMediaContainer* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		RygelMediaExportPlaylistItem* _tmp41_ = NULL;
		RygelMediaExportPlaylistItem* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp46_ = NULL;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp2_;
		contents_length1 = _tmp3_;
		_contents_size_ = contents_length1;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			contents = (g_free (contents), NULL);
			goto __catch71_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gint _tmp12_ = 0;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
		_tmp13_ = contents;
		_tmp13__length1 = contents_length1;
		_tmp14_ = i;
		_tmp15_ = _tmp13_[_tmp14_];
		if (_tmp15_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp16_ = contents;
		_tmp16__length1 = contents_length1;
		_tmp17_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp16_);
		didl_s = _tmp17_;
		_tmp18_ = didl_s;
		_tmp19_ = gupnp_media_collection_get_author (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		author = _tmp21_;
		_tmp22_ = didl_s;
		_tmp23_ = gupnp_media_collection_get_title (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		title = _tmp25_;
		_tmp28_ = author;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_ = NULL;
			_tmp29_ = title;
			_tmp27_ = _tmp29_ == NULL;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GUPnPMediaCollection* _tmp30_ = NULL;
			GList* _tmp31_ = NULL;
			GList* _tmp32_ = NULL;
			_tmp30_ = didl_s;
			_tmp31_ = gupnp_media_collection_get_items (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp26_ = _tmp32_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp32_);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp33_ = title;
		if (_tmp33_ == NULL) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = fallback_title;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (title);
			title = _tmp35_;
		}
		_tmp36_ = file;
		_tmp37_ = rygel_media_export_media_cache_get_id (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = parent;
		_tmp40_ = title;
		_tmp41_ = rygel_media_export_playlist_item_new (_tmp38_, _tmp39_, _tmp40_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp38_);
		item = _tmp42_;
		_tmp43_ = author;
		if (_tmp43_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp44_ = item;
			_tmp45_ = author;
			rygel_media_object_set_creator ((RygelMediaObject*) _tmp44_, _tmp45_);
		}
		_tmp46_ = item;
		rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp46_, "DIDL_S");
		result = (RygelMediaFileItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally71:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaFileItem* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v) {
	RygelMediaFileItem* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariant* upnp_class = NULL;
	GVariant* file_info = NULL;
	GVariant* dlna_profile = NULL;
	GVariant* info = NULL;
	GVariant* video_info = NULL;
	GVariant* audio_info = NULL;
	GVariant* meta_data = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	GVariantIter* _tmp9_ = NULL;
	gsize _tmp10_ = 0UL;
	gchar* id = NULL;
	GFile* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariantIter* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariantIter* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	GVariant* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_ = NULL;
	GVariantIter* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	GVariant* _tmp34_ = NULL;
	GVariant* _tmp35_ = NULL;
	GVariantIter* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	GVariant* _tmp41_ = NULL;
	GVariant* _tmp42_ = NULL;
	GVariantIter* _tmp45_ = NULL;
	GVariant* _tmp46_ = NULL;
	GVariant* _tmp47_ = NULL;
	GVariant* _tmp48_ = NULL;
	GVariant* _tmp49_ = NULL;
	GVariantIter* _tmp52_ = NULL;
	GVariant* _tmp53_ = NULL;
	GVariant* _tmp54_ = NULL;
	GVariant* _tmp55_ = NULL;
	GVariant* _tmp56_ = NULL;
	RygelMediaFileItem* item = NULL;
	GVariant* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	GQuark _tmp63_ = 0U;
	RygelMediaFileItem* _tmp73_ = NULL;
	GFile* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	GVariant* _tmp77_ = NULL;
	GVariant* _tmp80_ = NULL;
	GVariant* _tmp83_ = NULL;
	GVariant* _tmp86_ = NULL;
	GVariant* _tmp89_ = NULL;
	GVariant* _tmp92_ = NULL;
	RygelMediaFileItem* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	gboolean _tmp98_ = FALSE;
	RygelMediaFileItem* _tmp107_ = NULL;
	RygelMediaFileItem* _tmp108_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(smvmvmvmvmvmv)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:120: Invalid meta-data serialisat" \
"ion, cannot process %s", _tmp6_);
		result = NULL;
		return result;
	}
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = it;
	_tmp10_ = g_variant_iter_n_children (_tmp9_);
	if (_tmp10_ != ((gsize) 7)) {
		GVariantIter* _tmp11_ = NULL;
		gsize _tmp12_ = 0UL;
		_tmp11_ = it;
		_tmp12_ = g_variant_iter_n_children (_tmp11_);
		g_warning ("rygel-media-export-item-factory.vala:130: Invalid meta-data serialisat" \
"ion: exprected 7 children, got %d", (gint) _tmp12_);
		result = NULL;
		_g_variant_iter_free0 (it);
		_g_variant_unref0 (meta_data);
		_g_variant_unref0 (audio_info);
		_g_variant_unref0 (video_info);
		_g_variant_unref0 (info);
		_g_variant_unref0 (dlna_profile);
		_g_variant_unref0 (file_info);
		_g_variant_unref0 (upnp_class);
		return result;
	}
	_tmp13_ = file;
	_tmp14_ = rygel_media_export_media_cache_get_id (_tmp13_);
	id = _tmp14_;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_g_variant_unref0 (upnp_class);
	upnp_class = _tmp16_;
	_tmp17_ = it;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_maybe (_tmp19_);
	_g_variant_unref0 (file_info);
	file_info = _tmp20_;
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = file_info;
	if (_tmp21_ != NULL) {
		GVariant* _tmp22_ = NULL;
		GVariant* _tmp23_ = NULL;
		_tmp22_ = file_info;
		_tmp23_ = g_variant_get_variant (_tmp22_);
		_g_variant_unref0 (file_info);
		file_info = _tmp23_;
	}
	_tmp24_ = it;
	_tmp25_ = g_variant_iter_next_value (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_variant_get_maybe (_tmp26_);
	_g_variant_unref0 (dlna_profile);
	dlna_profile = _tmp27_;
	_g_variant_unref0 (_tmp26_);
	_tmp28_ = dlna_profile;
	if (_tmp28_ != NULL) {
		GVariant* _tmp29_ = NULL;
		GVariant* _tmp30_ = NULL;
		_tmp29_ = dlna_profile;
		_tmp30_ = g_variant_get_variant (_tmp29_);
		_g_variant_unref0 (dlna_profile);
		dlna_profile = _tmp30_;
	}
	_tmp31_ = it;
	_tmp32_ = g_variant_iter_next_value (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_maybe (_tmp33_);
	_g_variant_unref0 (info);
	info = _tmp34_;
	_g_variant_unref0 (_tmp33_);
	_tmp35_ = info;
	if (_tmp35_ != NULL) {
		GVariant* _tmp36_ = NULL;
		GVariant* _tmp37_ = NULL;
		_tmp36_ = info;
		_tmp37_ = g_variant_get_variant (_tmp36_);
		_g_variant_unref0 (info);
		info = _tmp37_;
	}
	_tmp38_ = it;
	_tmp39_ = g_variant_iter_next_value (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_variant_get_maybe (_tmp40_);
	_g_variant_unref0 (audio_info);
	audio_info = _tmp41_;
	_g_variant_unref0 (_tmp40_);
	_tmp42_ = audio_info;
	if (_tmp42_ != NULL) {
		GVariant* _tmp43_ = NULL;
		GVariant* _tmp44_ = NULL;
		_tmp43_ = audio_info;
		_tmp44_ = g_variant_get_variant (_tmp43_);
		_g_variant_unref0 (audio_info);
		audio_info = _tmp44_;
	}
	_tmp45_ = it;
	_tmp46_ = g_variant_iter_next_value (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_variant_get_maybe (_tmp47_);
	_g_variant_unref0 (video_info);
	video_info = _tmp48_;
	_g_variant_unref0 (_tmp47_);
	_tmp49_ = video_info;
	if (_tmp49_ != NULL) {
		GVariant* _tmp50_ = NULL;
		GVariant* _tmp51_ = NULL;
		_tmp50_ = video_info;
		_tmp51_ = g_variant_get_variant (_tmp50_);
		_g_variant_unref0 (video_info);
		video_info = _tmp51_;
	}
	_tmp52_ = it;
	_tmp53_ = g_variant_iter_next_value (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_variant_get_maybe (_tmp54_);
	_g_variant_unref0 (meta_data);
	meta_data = _tmp55_;
	_g_variant_unref0 (_tmp54_);
	_tmp56_ = meta_data;
	if (_tmp56_ != NULL) {
		GVariant* _tmp57_ = NULL;
		GVariant* _tmp58_ = NULL;
		_tmp57_ = meta_data;
		_tmp58_ = g_variant_get_variant (_tmp57_);
		_g_variant_unref0 (meta_data);
		meta_data = _tmp58_;
	}
	item = NULL;
	_tmp59_ = upnp_class;
	_tmp60_ = g_variant_get_string (_tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_tmp63_ = (NULL == _tmp61_) ? 0 : g_quark_from_string (_tmp61_);
	if (_tmp63_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp64_ = NULL;
				RygelMediaContainer* _tmp65_ = NULL;
				RygelMediaExportPhotoItem* _tmp66_ = NULL;
				_tmp64_ = id;
				_tmp65_ = parent;
				_tmp66_ = rygel_media_export_photo_item_new (_tmp64_, _tmp65_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp66_;
				break;
			}
		}
	} else if (_tmp63_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp67_ = NULL;
				RygelMediaContainer* _tmp68_ = NULL;
				RygelMediaExportVideoItem* _tmp69_ = NULL;
				_tmp67_ = id;
				_tmp68_ = parent;
				_tmp69_ = rygel_media_export_video_item_new (_tmp67_, _tmp68_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp69_;
				break;
			}
		}
	} else if (_tmp63_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp70_ = NULL;
				RygelMediaContainer* _tmp71_ = NULL;
				RygelMediaExportMusicItem* _tmp72_ = NULL;
				_tmp70_ = id;
				_tmp71_ = parent;
				_tmp72_ = rygel_media_export_music_item_new (_tmp70_, _tmp71_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp72_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return result;
			}
		}
	}
	_tmp73_ = item;
	_tmp74_ = file;
	_tmp75_ = g_file_get_uri (_tmp74_);
	_tmp76_ = _tmp75_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp73_, _tmp76_);
	_g_free0 (_tmp76_);
	_tmp77_ = dlna_profile;
	if (_tmp77_ != NULL) {
		RygelMediaFileItem* _tmp78_ = NULL;
		GVariant* _tmp79_ = NULL;
		_tmp78_ = item;
		_tmp79_ = dlna_profile;
		rygel_media_export_item_factory_apply_dlna_profile (_tmp78_, _tmp79_);
	}
	_tmp80_ = file_info;
	if (_tmp80_ != NULL) {
		RygelMediaFileItem* _tmp81_ = NULL;
		GVariant* _tmp82_ = NULL;
		_tmp81_ = item;
		_tmp82_ = file_info;
		rygel_media_export_item_factory_apply_file_info (_tmp81_, _tmp82_);
	}
	_tmp83_ = info;
	if (_tmp83_ != NULL) {
		RygelMediaFileItem* _tmp84_ = NULL;
		GVariant* _tmp85_ = NULL;
		_tmp84_ = item;
		_tmp85_ = info;
		rygel_media_export_item_factory_apply_info (_tmp84_, _tmp85_);
	}
	_tmp86_ = audio_info;
	if (_tmp86_ != NULL) {
		RygelMediaFileItem* _tmp87_ = NULL;
		GVariant* _tmp88_ = NULL;
		_tmp87_ = item;
		_tmp88_ = audio_info;
		rygel_media_export_item_factory_apply_audio_info (_tmp87_, _tmp88_);
	}
	_tmp89_ = video_info;
	if (_tmp89_ != NULL) {
		RygelMediaFileItem* _tmp90_ = NULL;
		GVariant* _tmp91_ = NULL;
		_tmp90_ = item;
		_tmp91_ = video_info;
		rygel_media_export_item_factory_apply_video_info (_tmp90_, _tmp91_);
	}
	_tmp92_ = meta_data;
	if (_tmp92_ != NULL) {
		RygelMediaFileItem* _tmp93_ = NULL;
		GVariant* _tmp94_ = NULL;
		_tmp93_ = item;
		_tmp94_ = meta_data;
		rygel_media_export_item_factory_apply_meta_data (_tmp93_, _tmp94_);
	}
	_tmp95_ = item;
	_tmp96_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = string_contains (_tmp97_, "T");
	if (_tmp98_) {
		SoupDate* date = NULL;
		RygelMediaFileItem* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		SoupDate* _tmp102_ = NULL;
		RygelMediaFileItem* _tmp103_ = NULL;
		SoupDate* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		gchar* _tmp106_ = NULL;
		_tmp99_ = item;
		_tmp100_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = soup_date_new_from_string (_tmp101_);
		date = _tmp102_;
		_tmp103_ = item;
		_tmp104_ = date;
		_tmp105_ = soup_date_to_string (_tmp104_, SOUP_DATE_ISO8601_FULL);
		_tmp106_ = _tmp105_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp103_, _tmp106_);
		_g_free0 (_tmp106_);
		__vala_SoupDate_free0 (date);
	}
	_tmp107_ = item;
	_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp107_) : NULL);
	result = _tmp108_;
	_g_object_unref0 (item);
	_g_free0 (id);
	_g_variant_iter_free0 (it);
	_g_variant_unref0 (meta_data);
	_g_variant_unref0 (audio_info);
	_g_variant_unref0 (video_info);
	_g_variant_unref0 (info);
	_g_variant_unref0 (dlna_profile);
	_g_variant_unref0 (file_info);
	_g_variant_unref0 (upnp_class);
	return result;
}


void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	RygelMediaFileItem* _tmp18_ = NULL;
	GVariantIter* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	gchar* album = NULL;
	gchar* _tmp27_ = NULL;
	GVariantIter* _tmp28_ = NULL;
	GVariant* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	RygelMediaFileItem* _tmp36_ = NULL;
	gint32 disc = 0;
	GVariantIter* _tmp37_ = NULL;
	GVariant* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	gint32 _tmp40_ = 0;
	gint32 _tmp41_ = 0;
	RygelMediaFileItem* _tmp42_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(msmsmsiii)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:222: Invalid meta-data serialisat" \
"ion of meta-data; %s", _tmp6_);
		return;
	}
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = it;
	_tmp10_ = g_variant_iter_next_value (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_get_maybe (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_variant_unref0 (_tmp11_);
	val = _tmp13_;
	_tmp15_ = val;
	if (_tmp15_ == NULL) {
		_g_free0 (_tmp14_);
		_tmp14_ = NULL;
	} else {
		GVariant* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp16_ = val;
		_tmp17_ = g_variant_dup_string (_tmp16_, NULL);
		_g_free0 (_tmp14_);
		_tmp14_ = _tmp17_;
	}
	_tmp18_ = item;
	rygel_media_object_set_artist ((RygelMediaObject*) _tmp18_, _tmp14_);
	_tmp19_ = it;
	_tmp20_ = g_variant_iter_next_value (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_variant_get_maybe (_tmp21_);
	_g_variant_unref0 (val);
	val = _tmp22_;
	_g_variant_unref0 (_tmp21_);
	_tmp24_ = val;
	if (_tmp24_ == NULL) {
		_g_free0 (_tmp23_);
		_tmp23_ = NULL;
	} else {
		GVariant* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp25_ = val;
		_tmp26_ = g_variant_dup_string (_tmp25_, NULL);
		_g_free0 (_tmp23_);
		_tmp23_ = _tmp26_;
	}
	_tmp27_ = g_strdup (_tmp23_);
	album = _tmp27_;
	_tmp28_ = it;
	_tmp29_ = g_variant_iter_next_value (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_variant_get_maybe (_tmp30_);
	_g_variant_unref0 (val);
	val = _tmp31_;
	_g_variant_unref0 (_tmp30_);
	_tmp33_ = val;
	if (_tmp33_ == NULL) {
		_g_free0 (_tmp32_);
		_tmp32_ = NULL;
	} else {
		GVariant* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		_tmp34_ = val;
		_tmp35_ = g_variant_dup_string (_tmp34_, NULL);
		_g_free0 (_tmp32_);
		_tmp32_ = _tmp35_;
	}
	_tmp36_ = item;
	rygel_media_object_set_genre ((RygelMediaObject*) _tmp36_, _tmp32_);
	_tmp37_ = it;
	_tmp38_ = g_variant_iter_next_value (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_variant_get_int32 (_tmp39_);
	_tmp41_ = _tmp40_;
	_g_variant_unref0 (_tmp39_);
	disc = _tmp41_;
	_tmp42_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp43_ = NULL;
		RygelAudioItem* _tmp44_ = NULL;
		gint32 track_number = 0;
		GVariantIter* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		gint32 _tmp48_ = 0;
		gint32 _tmp49_ = 0;
		RygelAudioItem* _tmp50_ = NULL;
		GVariantIter* _tmp51_ = NULL;
		GVariant* _tmp52_ = NULL;
		GVariant* _tmp53_ = NULL;
		gint32 _tmp54_ = 0;
		RygelAudioItem* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		RygelMediaFileItem* _tmp57_ = NULL;
		_tmp43_ = item;
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp43_) : NULL);
		audio_item = _tmp44_;
		_tmp45_ = it;
		_tmp46_ = g_variant_iter_next_value (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_variant_get_int32 (_tmp47_);
		_tmp49_ = _tmp48_;
		_g_variant_unref0 (_tmp47_);
		track_number = _tmp49_;
		_tmp50_ = audio_item;
		_tmp51_ = it;
		_tmp52_ = g_variant_iter_next_value (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_variant_get_int32 (_tmp53_);
		rygel_audio_item_set_bitrate (_tmp50_, (gint) _tmp54_);
		_g_variant_unref0 (_tmp53_);
		_tmp55_ = audio_item;
		_tmp56_ = album;
		rygel_audio_item_set_album (_tmp55_, _tmp56_);
		_tmp57_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp58_ = NULL;
			RygelMediaExportMusicItem* _tmp59_ = NULL;
			RygelMediaExportMusicItem* _tmp60_ = NULL;
			gint32 _tmp61_ = 0;
			RygelMediaExportMusicItem* _tmp62_ = NULL;
			gint32 _tmp63_ = 0;
			_tmp58_ = item;
			_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp58_) : NULL);
			music_item = _tmp59_;
			_tmp60_ = music_item;
			_tmp61_ = disc;
			_tmp60_->disc = (gint) _tmp61_;
			_tmp62_ = music_item;
			_tmp63_ = track_number;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp62_, (gint) _tmp63_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_g_free0 (_tmp32_);
	_g_free0 (album);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelMediaFileItem* _tmp7_ = NULL;
	RygelVisualItem* visual_item = NULL;
	RygelMediaFileItem* _tmp8_ = NULL;
	RygelVisualItem* _tmp9_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp10_ = NULL;
	GVariantIter* _tmp11_ = NULL;
	RygelVisualItem* _tmp12_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	gint32 _tmp16_ = 0;
	RygelVisualItem* _tmp17_ = NULL;
	GVariantIter* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	gint32 _tmp21_ = 0;
	RygelVisualItem* _tmp22_ = NULL;
	GVariantIter* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	gint32 _tmp26_ = 0;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(iii)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:258: Invalid meta-data serialisat" \
"ion of video info; %s", _tmp6_);
		return;
	}
	_tmp7_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_VISUAL_ITEM)) {
		return;
	}
	_tmp8_ = item;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp8_) : NULL);
	visual_item = _tmp9_;
	_tmp10_ = v;
	_tmp11_ = g_variant_iter_new (_tmp10_);
	it = _tmp11_;
	_tmp12_ = visual_item;
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_int32 (_tmp15_);
	rygel_visual_item_set_width (_tmp12_, (gint) _tmp16_);
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = visual_item;
	_tmp18_ = it;
	_tmp19_ = g_variant_iter_next_value (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_get_int32 (_tmp20_);
	rygel_visual_item_set_height (_tmp17_, (gint) _tmp21_);
	_g_variant_unref0 (_tmp20_);
	_tmp22_ = visual_item;
	_tmp23_ = it;
	_tmp24_ = g_variant_iter_next_value (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_variant_get_int32 (_tmp25_);
	rygel_visual_item_set_color_depth (_tmp22_, (gint) _tmp26_);
	_g_variant_unref0 (_tmp25_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (visual_item);
}


void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelMediaFileItem* _tmp7_ = NULL;
	RygelAudioItem* audio_item = NULL;
	RygelMediaFileItem* _tmp8_ = NULL;
	RygelAudioItem* _tmp9_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp10_ = NULL;
	GVariantIter* _tmp11_ = NULL;
	RygelAudioItem* _tmp12_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	gint32 _tmp16_ = 0;
	RygelAudioItem* _tmp17_ = NULL;
	GVariantIter* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	gint32 _tmp21_ = 0;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(ii)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:277: Invalid meta-data serialisat" \
"ion of audio info; %s", _tmp6_);
		return;
	}
	_tmp7_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_AUDIO_ITEM)) {
		return;
	}
	_tmp8_ = item;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp8_) : NULL);
	audio_item = _tmp9_;
	_tmp10_ = v;
	_tmp11_ = g_variant_iter_new (_tmp10_);
	it = _tmp11_;
	_tmp12_ = audio_item;
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_int32 (_tmp15_);
	rygel_audio_item_set_channels (_tmp12_, (gint) _tmp16_);
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = audio_item;
	_tmp18_ = it;
	_tmp19_ = g_variant_iter_next_value (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_get_int32 (_tmp20_);
	rygel_audio_item_set_sample_freq (_tmp17_, (gint) _tmp21_);
	_g_variant_unref0 (_tmp20_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (audio_item);
}


void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariantIter* it = NULL;
	GVariant* _tmp5_ = NULL;
	GVariantIter* _tmp6_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	GVariantIter* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	RygelMediaFileItem* _tmp26_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(msmsi)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		g_warning ("rygel-media-export-item-factory.vala:295: Invalid meta-data serialisat" \
"ion of general info");
	}
	_tmp5_ = v;
	_tmp6_ = g_variant_iter_new (_tmp5_);
	it = _tmp6_;
	_tmp7_ = it;
	_tmp8_ = g_variant_iter_next_value (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_get_maybe (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_variant_unref0 (_tmp9_);
	val = _tmp11_;
	_tmp12_ = val;
	if (_tmp12_ != NULL) {
		RygelMediaFileItem* _tmp13_ = NULL;
		GVariant* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp13_ = item;
		_tmp14_ = val;
		_tmp15_ = g_variant_dup_string (_tmp14_, NULL);
		_tmp16_ = _tmp15_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = it;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_maybe (_tmp19_);
	_g_variant_unref0 (val);
	val = _tmp20_;
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = val;
	if (_tmp21_ != NULL) {
		RygelMediaFileItem* _tmp22_ = NULL;
		GVariant* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp22_ = item;
		_tmp23_ = val;
		_tmp24_ = g_variant_dup_string (_tmp23_, NULL);
		_tmp25_ = _tmp24_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp22_, _tmp25_);
		_g_free0 (_tmp25_);
	}
	_tmp26_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaFileItem* _tmp27_ = NULL;
		GVariantIter* _tmp28_ = NULL;
		GVariant* _tmp29_ = NULL;
		GVariant* _tmp30_ = NULL;
		gint32 _tmp31_ = 0;
		_tmp27_ = item;
		_tmp28_ = it;
		_tmp29_ = g_variant_iter_next_value (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_variant_get_int32 (_tmp30_);
		rygel_audio_item_set_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp27_) : NULL, (glong) _tmp31_);
		_g_variant_unref0 (_tmp30_);
	}
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	RygelMediaFileItem* _tmp15_ = NULL;
	GVariantIter* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(ss)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:316: Invalid meta-data serialisat" \
"ion of DLNA profile %s", _tmp6_);
		return;
	}
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	rygel_media_file_item_set_dlna_profile (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (_tmp12_);
	_tmp15_ = item;
	_tmp16_ = it;
	_tmp17_ = g_variant_iter_next_value (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_variant_dup_string (_tmp18_, NULL);
	_tmp20_ = _tmp19_;
	rygel_media_file_item_set_mime_type (_tmp15_, _tmp20_);
	_g_free0 (_tmp20_);
	_g_variant_unref0 (_tmp18_);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_file_info (RygelMediaFileItem* item, GVariant* v) {
	GVariant* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	GVariantIter* _tmp9_ = NULL;
	gsize _tmp10_ = 0UL;
	GVariant* display_name = NULL;
	GVariantIter* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	RygelMediaFileItem* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GVariant* mime = NULL;
	GVariantIter* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	RygelMediaFileItem* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	RygelMediaFileItem* _tmp33_ = NULL;
	GVariantIter* _tmp34_ = NULL;
	GVariant* _tmp35_ = NULL;
	GVariant* _tmp36_ = NULL;
	guint64 _tmp37_ = 0ULL;
	RygelMediaFileItem* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	RygelMediaFileItem* _tmp48_ = NULL;
	GVariantIter* _tmp49_ = NULL;
	GVariant* _tmp50_ = NULL;
	GVariant* _tmp51_ = NULL;
	guint64 _tmp52_ = 0ULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_type_new ("(sstt)");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_is_of_type (_tmp0_, _tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_type_free0 (_tmp2_);
	if (_tmp4_) {
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = v;
		_tmp6_ = g_variant_get_type_string (_tmp5_);
		g_warning ("rygel-media-export-item-factory.vala:329: Invalid meta-data serialisat" \
"ion of file info %s", _tmp6_);
		return;
	}
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = it;
	_tmp10_ = g_variant_iter_n_children (_tmp9_);
	if (_tmp10_ != ((gsize) 4)) {
		g_warning ("rygel-media-export-item-factory.vala:337: Invalid meta-data serialisat" \
"ion of file info");
		_g_variant_iter_free0 (it);
		return;
	}
	_tmp11_ = it;
	_tmp12_ = g_variant_iter_next_value (_tmp11_);
	_g_variant_unref0 (display_name);
	display_name = _tmp12_;
	_tmp14_ = item;
	_tmp15_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		RygelMediaFileItem* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp17_ = item;
		_tmp18_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = g_strcmp0 (_tmp19_, "") == 0;
	}
	if (_tmp13_) {
		RygelMediaFileItem* _tmp20_ = NULL;
		GVariant* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp20_ = item;
		_tmp21_ = display_name;
		_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
		_tmp23_ = _tmp22_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
	}
	_tmp24_ = it;
	_tmp25_ = g_variant_iter_next_value (_tmp24_);
	mime = _tmp25_;
	_tmp26_ = item;
	_tmp27_ = rygel_media_file_item_get_mime_type (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		RygelMediaFileItem* _tmp29_ = NULL;
		GVariant* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp29_ = item;
		_tmp30_ = mime;
		_tmp31_ = g_variant_dup_string (_tmp30_, NULL);
		_tmp32_ = _tmp31_;
		rygel_media_file_item_set_mime_type (_tmp29_, _tmp32_);
		_g_free0 (_tmp32_);
	}
	_tmp33_ = item;
	_tmp34_ = it;
	_tmp35_ = g_variant_iter_next_value (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_variant_get_uint64 (_tmp36_);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp33_, (guint64) ((gint64) _tmp37_));
	_g_variant_unref0 (_tmp36_);
	_tmp38_ = item;
	_tmp39_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == NULL) {
		GTimeVal tv = {0};
		RygelMediaFileItem* _tmp41_ = NULL;
		guint64 _tmp42_ = 0ULL;
		guint64 _tmp43_ = 0ULL;
		GTimeVal _tmp44_ = {0};
		RygelMediaFileItem* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		_tmp41_ = item;
		_tmp42_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_.tv_sec = (glong) _tmp43_;
		_tmp44_.tv_usec = (glong) 0;
		tv = _tmp44_;
		_tmp45_ = item;
		_tmp46_ = g_time_val_to_iso8601 (&tv);
		_tmp47_ = _tmp46_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp45_, _tmp47_);
		_g_free0 (_tmp47_);
	}
	_tmp48_ = item;
	_tmp49_ = it;
	_tmp50_ = g_variant_iter_next_value (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_variant_get_uint64 (_tmp51_);
	rygel_media_file_item_set_size (_tmp48_, (gint64) _tmp52_);
	_g_variant_unref0 (_tmp51_);
	_g_variant_unref0 (mime);
	_g_variant_unref0 (display_name);
	_g_variant_iter_free0 (it);
}



