/* rygel-media-export-media-cache-upgrader.c generated by valac 0.29.2, the Vala compiler
 * generated from rygel-media-export-media-cache-upgrader.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-db.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
typedef struct _RygelMediaExportMediaCacheUpgraderPrivate RygelMediaExportMediaCacheUpgraderPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
typedef struct _RygelMediaExportParamSpecMediaCacheUpgrader RygelMediaExportParamSpecMediaCacheUpgrader;

struct _RygelMediaExportMediaCacheUpgrader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaExportMediaCacheUpgraderPrivate * priv;
};

struct _RygelMediaExportMediaCacheUpgraderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaExportMediaCacheUpgrader *self);
};

struct _RygelMediaExportMediaCacheUpgraderPrivate {
	RygelDatabaseDatabase* database;
	RygelMediaExportSQLFactory* sql;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE
} RygelMediaExportSQLString;

struct _RygelMediaExportParamSpecMediaCacheUpgrader {
	GParamSpec parent_instance;
};


static gpointer rygel_media_export_media_cache_upgrader_parent_class = NULL;

gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelDatabaseDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "16"
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v10_v11 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v11_v12 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v12_v13 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v13_v14 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v14_v15 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v15_v16 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj);


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelDatabaseDatabase* database, RygelMediaExportSQLFactory* sql) {
	RygelMediaExportMediaCacheUpgrader* self = NULL;
	RygelDatabaseDatabase* _tmp0_ = NULL;
	RygelMediaExportSQLFactory* _tmp1_ = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelMediaExportMediaCacheUpgrader*) g_type_create_instance (object_type);
	_tmp0_ = database;
	self->priv->database = _tmp0_;
	_tmp1_ = sql;
	self->priv->sql = _tmp1_;
	return self;
}


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelDatabaseDatabase* database, RygelMediaExportSQLFactory* sql) {
	return rygel_media_export_media_cache_upgrader_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, database, sql);
}


gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error) {
	gint _vala_current_version = 0;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	RygelDatabaseDatabase* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->database;
	_tmp2_ = rygel_database_database_query_value (_tmp1_, "SELECT version FROM schema_info", NULL, 0, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_vala_current_version = _tmp0_;
	_tmp3_ = _vala_current_version;
	_tmp4_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	result = _tmp3_ < _tmp4_;
	if (current_version) {
		*current_version = _vala_current_version;
	}
	return result;
}


void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	gint matching_schema_count = 0;
	RygelDatabaseDatabase* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = rygel_database_database_query_value (_tmp0_, "SELECT count(*) FROM " "sqlite_master WHERE sql " "LIKE 'CREATE TABLE Meta_Data" "%object_fk TEXT UNIQUE%'", NULL, 0, &_inner_error_);
	matching_schema_count = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = matching_schema_count;
	if (_tmp2_ == 0) {
		{
			RygelDatabaseDatabase* _tmp3_ = NULL;
			RygelDatabaseDatabase* _tmp4_ = NULL;
			RygelDatabaseDatabase* _tmp5_ = NULL;
			RygelDatabaseDatabase* _tmp6_ = NULL;
			RygelMediaExportSQLFactory* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			RygelDatabaseDatabase* _tmp9_ = NULL;
			g_message ("rygel-media-export-media-cache-upgrader.vala:58: Found faulty schema, " \
"forcing full reindex");
			_tmp3_ = self->priv->database;
			rygel_database_database_begin (_tmp3_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
			_tmp4_ = self->priv->database;
			rygel_database_database_exec (_tmp4_, "DELETE FROM Object WHERE upnp_id IN (" "SELECT DISTINCT object_fk FROM meta_data)", NULL, 0, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
			_tmp5_ = self->priv->database;
			rygel_database_database_exec (_tmp5_, "DROP TABLE Meta_Data", NULL, 0, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
			_tmp6_ = self->priv->database;
			_tmp7_ = self->priv->sql;
			_tmp8_ = rygel_media_export_sql_factory_make (_tmp7_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
			rygel_database_database_exec (_tmp6_, _tmp8_, NULL, 0, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
			_tmp9_ = self->priv->database;
			rygel_database_database_commit (_tmp9_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError* _error_ = NULL;
			RygelDatabaseDatabase* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = self->priv->database;
			rygel_database_database_rollback (_tmp10_);
			_tmp11_ = _error_;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = g_strconcat ("Failed to force reindex to fix database: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			g_warning ("rygel-media-export-media-cache-upgrader.vala:67: %s", _tmp14_);
			_g_free0 (_tmp14_);
			_g_error_free0 (_error_);
		}
		__finally20:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelMediaExportSQLFactory* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		_tmp0_ = self->priv->database;
		_tmp1_ = self->priv->sql;
		_tmp2_ = rygel_media_export_sql_factory_make (_tmp1_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp0_, _tmp2_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_analyze (_tmp3_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat ("Failed to create indices: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:78: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (_error_);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version) {
	gint current_version = 0;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_debug ("rygel-media-export-media-cache-upgrader.vala:84: Older schema detected" \
". Upgrading...");
	_tmp0_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	current_version = _tmp0_;
	while (TRUE) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp1_ = old_version;
		_tmp2_ = current_version;
		if (!(_tmp1_ < _tmp2_)) {
			break;
		}
		_tmp3_ = self->priv->database;
		if (_tmp3_ == NULL) {
			break;
		}
		_tmp4_ = old_version;
		switch (_tmp4_) {
			case 3:
			{
				rygel_media_export_media_cache_upgrader_update_v3_v4 (self);
				break;
			}
			case 4:
			{
				rygel_media_export_media_cache_upgrader_update_v4_v5 (self);
				break;
			}
			case 5:
			{
				rygel_media_export_media_cache_upgrader_update_v5_v6 (self);
				break;
			}
			case 6:
			{
				rygel_media_export_media_cache_upgrader_update_v6_v7 (self);
				break;
			}
			case 7:
			{
				rygel_media_export_media_cache_upgrader_update_v7_v8 (self);
				break;
			}
			case 8:
			{
				rygel_media_export_media_cache_upgrader_update_v8_v9 (self);
				break;
			}
			case 9:
			{
				rygel_media_export_media_cache_upgrader_update_v9_v10 (self);
				break;
			}
			case 10:
			{
				rygel_media_export_media_cache_upgrader_update_v10_v11 (self);
				break;
			}
			case 11:
			{
				rygel_media_export_media_cache_upgrader_update_v11_v12 (self);
				break;
			}
			case 12:
			{
				rygel_media_export_media_cache_upgrader_update_v12_v13 (self);
				break;
			}
			case 13:
			{
				rygel_media_export_media_cache_upgrader_update_v13_v14 (self);
				break;
			}
			case 14:
			{
				rygel_media_export_media_cache_upgrader_update_v14_v15 (self);
				break;
			}
			case 15:
			{
				rygel_media_export_media_cache_upgrader_update_v15_v16 (self);
				break;
			}
			default:
			{
				g_warning ("rygel-media-export-media-cache-upgrader.vala:132: Cannot upgrade");
				self->priv->database = NULL;
				break;
			}
		}
		_tmp5_ = old_version;
		old_version = _tmp5_ + 1;
	}
}


static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	RygelDatabaseDatabase* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	rygel_database_database_exec (_tmp0_, "UPDATE Object SET timestamp = 0", NULL, 0, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelMediaExportSQLFactory* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelMediaExportSQLFactory* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		RygelDatabaseDatabase* _tmp12_ = NULL;
		RygelDatabaseDatabase* _tmp13_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE Meta_Data RENAME TO _Meta_Data", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		_tmp3_ = self->priv->sql;
		_tmp4_ = rygel_media_export_sql_factory_make (_tmp3_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
		rygel_database_database_exec (_tmp2_, _tmp4_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "INSERT INTO meta_data (size, mime_type, " "duration, width, height, class, author, album, " "date, bitrate, sample_freq, bits_per_sample, " "channels, track, color_depth, object_fk) SELECT " "size, mime_type, duration, width, height, class, " "author, album, date, bitrate, sample_freq, " "bits_per_sample, channels, track, color_depth, " "o.upnp_id FROM _Meta_Data JOIN object o " "ON id = o.metadata_fk", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_exec (_tmp6_, "DROP TABLE _Meta_Data", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_exec (_tmp8_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_database_database_exec (_tmp9_, _tmp11_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_database_database_exec (_tmp12_, "UPDATE schema_info SET version = '4'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_database_database_commit (_tmp13_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch22_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally22;
	__catch22_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = self->priv->database;
		rygel_database_database_rollback (_tmp14_);
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:166: Database upgrade fai" \
"led: %s", _tmp16_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self) {
	GeeQueue* queue = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	queue = (GeeQueue*) _tmp0_;
	{
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelMediaExportSQLFactory* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelMediaExportSQLFactory* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		RygelDatabaseDatabase* _tmp12_ = NULL;
		RygelDatabaseDatabase* _tmp13_ = NULL;
		GeeQueue* _tmp14_ = NULL;
		RygelDatabaseDatabase* _tmp37_ = NULL;
		RygelDatabaseDatabase* _tmp38_ = NULL;
		RygelDatabaseDatabase* _tmp39_ = NULL;
		RygelMediaExportSQLFactory* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		RygelDatabaseDatabase* _tmp42_ = NULL;
		RygelMediaExportSQLFactory* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		RygelDatabaseDatabase* _tmp45_ = NULL;
		RygelDatabaseDatabase* _tmp46_ = NULL;
		RygelDatabaseDatabase* _tmp47_ = NULL;
		RygelDatabaseDatabase* _tmp48_ = NULL;
		_tmp1_ = self->priv->database;
		rygel_database_database_begin (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		_tmp4_ = self->priv->sql;
		_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_database_database_exec (_tmp3_, _tmp5_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_exec (_tmp6_, "ALTER TABLE Object RENAME TO _Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_exec (_tmp8_, "DELETE FROM Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp9_, _tmp11_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_database_database_exec (_tmp12_, "INSERT INTO _Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_database_database_exec (_tmp13_, "INSERT INTO Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = queue;
		gee_queue_offer (_tmp14_, "0");
		while (TRUE) {
			GeeQueue* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			GValue* args = NULL;
			GeeQueue* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GValue _tmp20_ = {0};
			GValue* _tmp21_ = NULL;
			gint args_length1 = 0;
			gint _args_size_ = 0;
			RygelDatabaseCursor* cursor = NULL;
			RygelDatabaseDatabase* _tmp22_ = NULL;
			GValue* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			RygelDatabaseCursor* _tmp24_ = NULL;
			RygelDatabaseDatabase* _tmp35_ = NULL;
			GValue* _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			_tmp15_ = queue;
			_tmp16_ = gee_collection_get_is_empty ((GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (!(!_tmp17_)) {
				break;
			}
			_tmp18_ = queue;
			_tmp19_ = gee_queue_poll (_tmp18_);
			g_value_init (&_tmp20_, G_TYPE_STRING);
			g_value_take_string (&_tmp20_, (gchar*) _tmp19_);
			_tmp21_ = g_new0 (GValue, 1);
			_tmp21_[0] = _tmp20_;
			args = _tmp21_;
			args_length1 = 1;
			_args_size_ = args_length1;
			_tmp22_ = self->priv->database;
			_tmp23_ = args;
			_tmp23__length1 = args_length1;
			_tmp24_ = rygel_database_database_exec_cursor (_tmp22_, "SELECT upnp_id FROM _Object WHERE " "parent = ?", _tmp23_, _tmp23__length1, &_inner_error_);
			cursor = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch23_rygel_database_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				RygelDatabaseCursorIterator* _statement_it = NULL;
				RygelDatabaseCursor* _tmp25_ = NULL;
				RygelDatabaseCursorIterator* _tmp26_ = NULL;
				_tmp25_ = cursor;
				_tmp26_ = rygel_database_cursor_iterator (_tmp25_);
				_statement_it = _tmp26_;
				while (TRUE) {
					gboolean _tmp27_ = FALSE;
					RygelDatabaseCursorIterator* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
					sqlite3_stmt* statement = NULL;
					RygelDatabaseCursorIterator* _tmp30_ = NULL;
					sqlite3_stmt* _tmp31_ = NULL;
					GeeQueue* _tmp32_ = NULL;
					sqlite3_stmt* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					_tmp28_ = _statement_it;
					_tmp29_ = rygel_database_cursor_iterator_next (_tmp28_, &_inner_error_);
					_tmp27_ = _tmp29_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
							goto __catch23_rygel_database_database_error;
						}
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (!_tmp27_) {
						break;
					}
					_tmp30_ = _statement_it;
					_tmp31_ = rygel_database_cursor_iterator_get (_tmp30_, &_inner_error_);
					statement = _tmp31_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
							goto __catch23_rygel_database_database_error;
						}
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp32_ = queue;
					_tmp33_ = statement;
					_tmp34_ = sqlite3_column_text (_tmp33_, 0);
					gee_queue_offer (_tmp32_, _tmp34_);
				}
				_rygel_database_cursor_iterator_unref0 (_statement_it);
			}
			_tmp35_ = self->priv->database;
			_tmp36_ = args;
			_tmp36__length1 = args_length1;
			rygel_database_database_exec (_tmp35_, "INSERT INTO Object SELECT * FROM _OBJECT " "WHERE parent = ?", _tmp36_, _tmp36__length1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch23_rygel_database_database_error;
				}
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (cursor);
			args = (_vala_GValue_array_free (args, args_length1), NULL);
		}
		_tmp37_ = self->priv->database;
		rygel_database_database_exec (_tmp37_, "DROP TABLE Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp38_ = self->priv->database;
		rygel_database_database_exec (_tmp38_, "ALTER TABLE _Object RENAME TO Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp39_ = self->priv->database;
		_tmp40_ = self->priv->sql;
		_tmp41_ = rygel_media_export_sql_factory_make (_tmp40_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp39_, _tmp41_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp42_ = self->priv->database;
		_tmp43_ = self->priv->sql;
		_tmp44_ = rygel_media_export_sql_factory_make (_tmp43_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp42_, _tmp44_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp45_ = self->priv->database;
		rygel_database_database_exec (_tmp45_, "UPDATE schema_info SET version = '5'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp46_ = self->priv->database;
		rygel_database_database_commit (_tmp46_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp47_ = self->priv->database;
		rygel_database_database_exec (_tmp47_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch23_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp48_ = self->priv->database;
		rygel_database_database_analyze (_tmp48_);
	}
	goto __finally23;
	__catch23_rygel_database_database_error:
	{
		GError* err = NULL;
		RygelDatabaseDatabase* _tmp49_ = NULL;
		GError* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp49_ = self->priv->database;
		rygel_database_database_rollback (_tmp49_);
		_tmp50_ = err;
		_tmp51_ = _tmp50_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:214: Database upgrade fai" \
"led: %s", _tmp51_);
		self->priv->database = NULL;
		_g_error_free0 (err);
	}
	__finally23:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (queue);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (queue);
}


static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelDatabaseDatabase* _tmp10_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "DROP TABLE object_type", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "DROP TRIGGER IF EXISTS trgr_delete_uris", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "ALTER TABLE Object ADD COLUMN uri TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "UPDATE Object SET uri = (SELECT uri " "FROM uri WHERE Uri.object_fk == Object.upnp_id LIMIT 1)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "DROP INDEX IF EXISTS idx_uri_fk", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_exec (_tmp6_, "DROP TABLE Uri", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "UPDATE schema_info SET version = '6'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_commit (_tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_database_database_exec (_tmp9_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch24_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		rygel_database_database_analyze (_tmp10_);
	}
	goto __finally24;
	__catch24_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = self->priv->database;
		rygel_database_database_rollback (_tmp11_);
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:235: Database upgrade fai" \
"led: %s", _tmp13_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE meta_data ADD COLUMN dlna_profile TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "UPDATE schema_info SET version = '7'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_commit (_tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch25_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_analyze (_tmp5_);
	}
	goto __finally25;
	__catch25_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = self->priv->database;
		rygel_database_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:251: Database upgrade fai" \
"led: %s", _tmp8_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE object ADD COLUMN flags TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "ALTER TABLE meta_data ADD COLUMN genre TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "UPDATE schema_info SET version = '8'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_commit (_tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch26_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_analyze (_tmp6_);
	}
	goto __finally26;
	__catch26_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = self->priv->database;
		rygel_database_database_rollback (_tmp7_);
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:268: Database upgrade fai" \
"led: %s", _tmp9_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelMediaExportSQLFactory* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		RygelDatabaseDatabase* _tmp11_ = NULL;
		RygelDatabaseDatabase* _tmp12_ = NULL;
		RygelDatabaseDatabase* _tmp13_ = NULL;
		RygelDatabaseDatabase* _tmp14_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "DROP TRIGGER trgr_update_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "DROP TRIGGER trgr_delete_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "ALTER TABLE Closure RENAME TO _Closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_database_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "INSERT INTO Closure (ancestor, " "descendant, depth) SELECT DISTINCT " "ancestor, descendant, depth FROM " "_Closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		_tmp9_ = self->priv->sql;
		_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp8_, _tmp10_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = self->priv->database;
		rygel_database_database_exec (_tmp11_, "DROP TABLE _Closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_database_database_exec (_tmp12_, "UPDATE schema_info SET version = '9'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_database_database_commit (_tmp13_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = self->priv->database;
		rygel_database_database_exec (_tmp14_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch27_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally27;
	__catch27_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = self->priv->database;
		rygel_database_database_rollback (_tmp15_);
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:291: Database upgrade fai" \
"led: %s", _tmp17_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* queue = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelDatabaseDatabase* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		RygelDatabaseDatabase* _tmp16_ = NULL;
		RygelDatabaseDatabase* _tmp17_ = NULL;
		RygelDatabaseDatabase* _tmp18_ = NULL;
		RygelDatabaseDatabase* _tmp19_ = NULL;
		RygelDatabaseDatabase* _tmp20_ = NULL;
		RygelMediaExportSQLFactory* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		RygelDatabaseDatabase* _tmp23_ = NULL;
		RygelMediaExportSQLFactory* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		RygelDatabaseDatabase* _tmp26_ = NULL;
		GeeLinkedList* _tmp27_ = NULL;
		RygelDatabaseDatabase* _tmp50_ = NULL;
		RygelDatabaseDatabase* _tmp51_ = NULL;
		RygelDatabaseDatabase* _tmp52_ = NULL;
		RygelMediaExportSQLFactory* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		RygelDatabaseDatabase* _tmp55_ = NULL;
		RygelMediaExportSQLFactory* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		RygelDatabaseDatabase* _tmp58_ = NULL;
		RygelMediaExportSQLFactory* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		RygelDatabaseDatabase* _tmp61_ = NULL;
		RygelDatabaseDatabase* _tmp62_ = NULL;
		RygelDatabaseDatabase* _tmp63_ = NULL;
		RygelDatabaseDatabase* _tmp64_ = NULL;
		_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		queue = _tmp0_;
		_tmp1_ = self->priv->database;
		rygel_database_database_begin (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "DELETE FROM Object WHERE upnp_id LIKE '" RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "%'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "DROP TRIGGER trgr_update_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "DROP TRIGGER trgr_delete_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "DROP INDEX idx_parent", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_exec (_tmp6_, "DROP INDEX idx_meta_data_fk", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "DROP INDEX IF EXISTS idx_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_exec (_tmp8_, "DROP TABLE Closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_database_database_exec (_tmp9_, "DROP TRIGGER trgr_delete_metadata", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		_tmp11_ = _ (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
		_tmp12_ = g_strconcat ("INSERT OR REPLACE INTO Object (parent, upnp_id, " "type_fk, title, timestamp) VALUES " "('0', '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "', 0, '", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "', 0)", NULL);
		_tmp15_ = _tmp14_;
		rygel_database_database_exec (_tmp10_, _tmp15_, NULL, 0, &_inner_error_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp16_ = self->priv->database;
		rygel_database_database_exec (_tmp16_, "UPDATE Object SET parent = '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "' WHERE parent = '0' AND upnp_id " "NOT LIKE 'virtual-%' AND upnp_id " "<> '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = self->priv->database;
		rygel_database_database_exec (_tmp17_, "ALTER TABLE Object RENAME TO _Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp18_ = self->priv->database;
		rygel_database_database_exec (_tmp18_, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = self->priv->database;
		rygel_database_database_exec (_tmp19_, "DELETE FROM Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = self->priv->database;
		_tmp21_ = self->priv->sql;
		_tmp22_ = rygel_media_export_sql_factory_make (_tmp21_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_database_database_exec (_tmp20_, _tmp22_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = self->priv->database;
		_tmp24_ = self->priv->sql;
		_tmp25_ = rygel_media_export_sql_factory_make (_tmp24_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp23_, _tmp25_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp26_ = self->priv->database;
		rygel_database_database_exec (_tmp26_, "INSERT INTO Closure (ancestor, descendant, " "depth) VALUES ('0','0',0)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = queue;
		gee_queue_offer ((GeeQueue*) _tmp27_, "0");
		while (TRUE) {
			GeeLinkedList* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			GValue* args = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gpointer _tmp32_ = NULL;
			GValue _tmp33_ = {0};
			GValue* _tmp34_ = NULL;
			gint args_length1 = 0;
			gint _args_size_ = 0;
			RygelDatabaseCursor* cursor = NULL;
			RygelDatabaseDatabase* _tmp35_ = NULL;
			GValue* _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			RygelDatabaseCursor* _tmp37_ = NULL;
			RygelDatabaseDatabase* _tmp48_ = NULL;
			GValue* _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			_tmp28_ = queue;
			_tmp29_ = gee_collection_get_is_empty ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			if (!(!_tmp30_)) {
				break;
			}
			_tmp31_ = queue;
			_tmp32_ = gee_queue_poll ((GeeQueue*) _tmp31_);
			g_value_init (&_tmp33_, G_TYPE_STRING);
			g_value_take_string (&_tmp33_, (gchar*) _tmp32_);
			_tmp34_ = g_new0 (GValue, 1);
			_tmp34_[0] = _tmp33_;
			args = _tmp34_;
			args_length1 = 1;
			_args_size_ = args_length1;
			_tmp35_ = self->priv->database;
			_tmp36_ = args;
			_tmp36__length1 = args_length1;
			_tmp37_ = rygel_database_database_exec_cursor (_tmp35_, "SELECT upnp_id FROM _Object WHERE " "parent = ?", _tmp36_, _tmp36__length1, &_inner_error_);
			cursor = _tmp37_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch28_rygel_database_database_error;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				RygelDatabaseCursorIterator* _statement_it = NULL;
				RygelDatabaseCursor* _tmp38_ = NULL;
				RygelDatabaseCursorIterator* _tmp39_ = NULL;
				_tmp38_ = cursor;
				_tmp39_ = rygel_database_cursor_iterator (_tmp38_);
				_statement_it = _tmp39_;
				while (TRUE) {
					gboolean _tmp40_ = FALSE;
					RygelDatabaseCursorIterator* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					sqlite3_stmt* statement = NULL;
					RygelDatabaseCursorIterator* _tmp43_ = NULL;
					sqlite3_stmt* _tmp44_ = NULL;
					GeeLinkedList* _tmp45_ = NULL;
					sqlite3_stmt* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					_tmp41_ = _statement_it;
					_tmp42_ = rygel_database_cursor_iterator_next (_tmp41_, &_inner_error_);
					_tmp40_ = _tmp42_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
							goto __catch28_rygel_database_database_error;
						}
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (!_tmp40_) {
						break;
					}
					_tmp43_ = _statement_it;
					_tmp44_ = rygel_database_cursor_iterator_get (_tmp43_, &_inner_error_);
					statement = _tmp44_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
							goto __catch28_rygel_database_database_error;
						}
						_rygel_database_cursor_iterator_unref0 (_statement_it);
						_g_object_unref0 (cursor);
						args = (_vala_GValue_array_free (args, args_length1), NULL);
						_g_object_unref0 (queue);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp45_ = queue;
					_tmp46_ = statement;
					_tmp47_ = sqlite3_column_text (_tmp46_, 0);
					gee_queue_offer ((GeeQueue*) _tmp45_, _tmp47_);
				}
				_rygel_database_cursor_iterator_unref0 (_statement_it);
			}
			_tmp48_ = self->priv->database;
			_tmp49_ = args;
			_tmp49__length1 = args_length1;
			rygel_database_database_exec (_tmp48_, "INSERT INTO Object SELECT * FROM _Object " "WHERE parent = ?", _tmp49_, _tmp49__length1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
					goto __catch28_rygel_database_database_error;
				}
				_g_object_unref0 (cursor);
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_object_unref0 (queue);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (cursor);
			args = (_vala_GValue_array_free (args, args_length1), NULL);
		}
		_tmp50_ = self->priv->database;
		rygel_database_database_exec (_tmp50_, "DROP TABLE Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp51_ = self->priv->database;
		rygel_database_database_exec (_tmp51_, "ALTER TABLE _Object RENAME TO Object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp52_ = self->priv->database;
		_tmp53_ = self->priv->sql;
		_tmp54_ = rygel_media_export_sql_factory_make (_tmp53_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp52_, _tmp54_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp55_ = self->priv->database;
		_tmp56_ = self->priv->sql;
		_tmp57_ = rygel_media_export_sql_factory_make (_tmp56_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_database_database_exec (_tmp55_, _tmp57_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp58_ = self->priv->database;
		_tmp59_ = self->priv->sql;
		_tmp60_ = rygel_media_export_sql_factory_make (_tmp59_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp58_, _tmp60_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp61_ = self->priv->database;
		rygel_database_database_exec (_tmp61_, "UPDATE schema_info SET version = '10'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp62_ = self->priv->database;
		rygel_database_database_commit (_tmp62_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp63_ = self->priv->database;
		rygel_database_database_exec (_tmp63_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (queue);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch28_rygel_database_database_error;
			}
			_g_object_unref0 (queue);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp64_ = self->priv->database;
		rygel_database_database_analyze (_tmp64_);
		_g_object_unref0 (queue);
	}
	goto __finally28;
	__catch28_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp65_ = NULL;
		GError* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp65_ = self->priv->database;
		rygel_database_database_rollback (_tmp65_);
		_tmp66_ = _error_;
		_tmp67_ = _tmp66_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:360: Database upgrade fai" \
"led: %s", _tmp67_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v10_v11 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE Meta_Data " "   ADD COLUMN disc INTEGER", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "UPDATE Object SET timestamp = 0 WHERE " "  upnp_id IN (" "SELECT object_fk FROM Meta_Data WHERE " "  class LIKE 'object.item.audioItem.%')", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "UPDATE schema_info SET version = '11'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_commit (_tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch29_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_analyze (_tmp6_);
	}
	goto __finally29;
	__catch29_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = self->priv->database;
		rygel_database_database_rollback (_tmp7_);
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:381: Database upgrade fai" \
"led: %s", _tmp9_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_media_cache_upgrader_update_v11_v12 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelDatabaseDatabase* _tmp10_ = NULL;
		RygelDatabaseDatabase* _tmp11_ = NULL;
		RygelDatabaseDatabase* _tmp12_ = NULL;
		GeeArrayList* ids = NULL;
		GeeArrayList* _tmp13_ = NULL;
		RygelDatabaseCursor* cursor = NULL;
		RygelDatabaseDatabase* _tmp14_ = NULL;
		RygelDatabaseCursor* _tmp15_ = NULL;
		guint32 count = 0U;
		RygelDatabaseDatabase* _tmp47_ = NULL;
		RygelDatabaseDatabase* _tmp48_ = NULL;
		RygelDatabaseDatabase* _tmp49_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE schema_info " "ADD COLUMN reset_token TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		_tmp3_ = gupnp_get_uuid ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("UPDATE schema_info SET reset_token = '", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "'", NULL);
		_tmp8_ = _tmp7_;
		rygel_database_database_exec (_tmp2_, _tmp8_, NULL, 0, &_inner_error_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_database_database_exec (_tmp9_, "UPDATE schema_info SET version = '12'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		rygel_database_database_exec (_tmp10_, "ALTER TABLE object " "ADD COLUMN object_update_id INTEGER", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = self->priv->database;
		rygel_database_database_exec (_tmp11_, "ALTER TABLE object " "ADD COLUMN deleted_child_count INTEGER", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_database_database_exec (_tmp12_, "ALTER TABLE object " "ADD COLUMN container_update_id INTEGER", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		ids = _tmp13_;
		_tmp14_ = self->priv->database;
		_tmp15_ = rygel_database_database_exec_cursor (_tmp14_, "SELECT upnp_id FROM object", NULL, 0, &_inner_error_);
		cursor = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (ids);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			RygelDatabaseCursorIterator* _statement_it = NULL;
			RygelDatabaseCursor* _tmp16_ = NULL;
			RygelDatabaseCursorIterator* _tmp17_ = NULL;
			_tmp16_ = cursor;
			_tmp17_ = rygel_database_cursor_iterator (_tmp16_);
			_statement_it = _tmp17_;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				RygelDatabaseCursorIterator* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				sqlite3_stmt* statement = NULL;
				RygelDatabaseCursorIterator* _tmp21_ = NULL;
				sqlite3_stmt* _tmp22_ = NULL;
				GeeArrayList* _tmp23_ = NULL;
				sqlite3_stmt* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				_tmp19_ = _statement_it;
				_tmp20_ = rygel_database_cursor_iterator_next (_tmp19_, &_inner_error_);
				_tmp18_ = _tmp20_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch30_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				if (!_tmp18_) {
					break;
				}
				_tmp21_ = _statement_it;
				_tmp22_ = rygel_database_cursor_iterator_get (_tmp21_, &_inner_error_);
				statement = _tmp22_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch30_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp23_ = ids;
				_tmp24_ = statement;
				_tmp25_ = sqlite3_column_text (_tmp24_, 0);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp25_);
			}
			_rygel_database_cursor_iterator_unref0 (_statement_it);
		}
		count = (guint32) 1;
		{
			GeeArrayList* _id_list = NULL;
			GeeArrayList* _tmp26_ = NULL;
			GeeArrayList* _tmp27_ = NULL;
			gint _id_size = 0;
			GeeArrayList* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _id_index = 0;
			_tmp26_ = ids;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_id_list = _tmp27_;
			_tmp28_ = _id_list;
			_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_id_size = _tmp30_;
			_id_index = -1;
			while (TRUE) {
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gchar* id = NULL;
				GeeArrayList* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gpointer _tmp36_ = NULL;
				GValue* args = NULL;
				guint32 _tmp37_ = 0U;
				GValue _tmp38_ = {0};
				guint32 _tmp39_ = 0U;
				GValue _tmp40_ = {0};
				const gchar* _tmp41_ = NULL;
				GValue _tmp42_ = {0};
				GValue* _tmp43_ = NULL;
				gint args_length1 = 0;
				gint _args_size_ = 0;
				guint32 _tmp44_ = 0U;
				RygelDatabaseDatabase* _tmp45_ = NULL;
				GValue* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				_tmp31_ = _id_index;
				_id_index = _tmp31_ + 1;
				_tmp32_ = _id_index;
				_tmp33_ = _id_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _id_list;
				_tmp35_ = _id_index;
				_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
				id = (gchar*) _tmp36_;
				_tmp37_ = count;
				g_value_init (&_tmp38_, G_TYPE_UINT);
				g_value_set_uint (&_tmp38_, _tmp37_);
				_tmp39_ = count;
				g_value_init (&_tmp40_, G_TYPE_UINT);
				g_value_set_uint (&_tmp40_, _tmp39_);
				_tmp41_ = id;
				g_value_init (&_tmp42_, G_TYPE_STRING);
				g_value_set_string (&_tmp42_, _tmp41_);
				_tmp43_ = g_new0 (GValue, 3);
				_tmp43_[0] = _tmp38_;
				_tmp43_[1] = _tmp40_;
				_tmp43_[2] = _tmp42_;
				args = _tmp43_;
				args_length1 = 3;
				_args_size_ = args_length1;
				_tmp44_ = count;
				count = _tmp44_ + 1;
				_tmp45_ = self->priv->database;
				_tmp46_ = args;
				_tmp46__length1 = args_length1;
				rygel_database_database_exec (_tmp45_, "UPDATE object SET " "container_update_id = ?, " "object_update_id = ?, " "deleted_child_count = 0 " "WHERE upnp_id = ?", _tmp46_, _tmp46__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					_g_free0 (id);
					_g_object_unref0 (_id_list);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch30_rygel_database_database_error;
					}
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					_g_free0 (id);
					_g_object_unref0 (_id_list);
					_g_object_unref0 (cursor);
					_g_object_unref0 (ids);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				args = (_vala_GValue_array_free (args, args_length1), NULL);
				_g_free0 (id);
			}
			_g_object_unref0 (_id_list);
		}
		_tmp47_ = self->priv->database;
		rygel_database_database_commit (_tmp47_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (cursor);
			_g_object_unref0 (ids);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			_g_object_unref0 (cursor);
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp48_ = self->priv->database;
		rygel_database_database_exec (_tmp48_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (cursor);
			_g_object_unref0 (ids);
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch30_rygel_database_database_error;
			}
			_g_object_unref0 (cursor);
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp49_ = self->priv->database;
		rygel_database_database_analyze (_tmp49_);
		_g_object_unref0 (cursor);
		_g_object_unref0 (ids);
	}
	goto __finally30;
	__catch30_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp50_ = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = self->priv->database;
		rygel_database_database_rollback (_tmp50_);
		_tmp51_ = _error_;
		_tmp52_ = _tmp51_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:424: Database upgrade fai" \
"led: %s", _tmp52_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v12_v13 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		RygelDatabaseDatabase* _tmp10_ = NULL;
		RygelDatabaseDatabase* _tmp11_ = NULL;
		RygelDatabaseDatabase* _tmp12_ = NULL;
		RygelDatabaseDatabase* _tmp13_ = NULL;
		RygelDatabaseDatabase* _tmp14_ = NULL;
		RygelDatabaseDatabase* _tmp15_ = NULL;
		RygelDatabaseDatabase* _tmp16_ = NULL;
		RygelMediaExportSQLFactory* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		RygelDatabaseDatabase* _tmp19_ = NULL;
		RygelMediaExportSQLFactory* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		RygelDatabaseDatabase* _tmp22_ = NULL;
		RygelMediaExportSQLFactory* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		RygelDatabaseDatabase* _tmp25_ = NULL;
		RygelDatabaseDatabase* _tmp26_ = NULL;
		RygelDatabaseDatabase* _tmp27_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "CREATE TEMPORARY TABLE object_backup(parent TEXT CONSTRAINT parent_fk_" \
"id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER, " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL, " "uri TEXT, " "object_update_id INTEGER, " "deleted_child_count INTEGER, " "container_update_id INTEGER)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "INSERT INTO object_backup SELECT " "parent, upnp_id, type_fk, title, " "timestamp, uri, object_update_id, " "deleted_child_count, container_update_id " "FROM object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_exec (_tmp3_, "DROP TRIGGER IF EXISTS trgr_update_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "DROP TRIGGER IF EXISTS trgr_delete_closure", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "DROP TRIGGER IF EXISTS trgr_delete_metadata", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_exec (_tmp6_, "DROP INDEX IF EXISTS idx_parent", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "DROP INDEX IF EXISTS idx_object_upnp_id", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_exec (_tmp8_, "DROP INDEX IF EXISTS idx_uri", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->database;
		rygel_database_database_exec (_tmp9_, "DROP TABLE object", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->database;
		rygel_database_database_exec (_tmp10_, "CREATE TABLE object " "(parent TEXT CONSTRAINT parent_fk_id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER, " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL, " "uri TEXT, " "object_update_id INTEGER, " "deleted_child_count INTEGER, " "container_update_id INTEGER)", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = self->priv->database;
		rygel_database_database_exec (_tmp11_, "INSERT INTO object SELECT parent, " "upnp_id, type_fk, title, timestamp, " "uri, object_update_id, " "deleted_child_count, container_update_id " "FROM object_backup", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = self->priv->database;
		rygel_database_database_exec (_tmp12_, "DROP TABLE object_backup", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = self->priv->database;
		rygel_database_database_exec (_tmp13_, "ALTER TABLE object " "ADD COLUMN is_guarded INTEGER", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = self->priv->database;
		rygel_database_database_exec (_tmp14_, "UPDATE object SET is_guarded = 0", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp15_ = self->priv->database;
		rygel_database_database_exec (_tmp15_, "UPDATE schema_info SET version = '13'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp16_ = self->priv->database;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_database_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = self->priv->database;
		_tmp20_ = self->priv->sql;
		_tmp21_ = rygel_media_export_sql_factory_make (_tmp20_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_database_database_exec (_tmp19_, _tmp21_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp22_ = self->priv->database;
		_tmp23_ = self->priv->sql;
		_tmp24_ = rygel_media_export_sql_factory_make (_tmp23_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_database_database_exec (_tmp22_, _tmp24_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp25_ = self->priv->database;
		rygel_database_database_commit (_tmp25_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp26_ = self->priv->database;
		rygel_database_database_exec (_tmp26_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch31_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = self->priv->database;
		rygel_database_database_analyze (_tmp27_);
	}
	goto __finally31;
	__catch31_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = self->priv->database;
		rygel_database_database_rollback (_tmp28_);
		_tmp29_ = _error_;
		_tmp30_ = _tmp29_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:487: Database upgrade fai" \
"led: %s", _tmp30_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally31:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v13_v14 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelMediaExportSQLFactory* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		RygelDatabaseDatabase* _tmp7_ = NULL;
		RygelDatabaseDatabase* _tmp8_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE Object ADD COLUMN reference_id " "DEFAULT NULL", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		_tmp3_ = self->priv->sql;
		_tmp4_ = rygel_media_export_sql_factory_make (_tmp3_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
		rygel_database_database_exec (_tmp2_, _tmp4_, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_exec (_tmp5_, "UPDATE schema_info SET version = '14'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->database;
		rygel_database_database_commit (_tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = self->priv->database;
		rygel_database_database_exec (_tmp7_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch32_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = self->priv->database;
		rygel_database_database_analyze (_tmp8_);
	}
	goto __finally32;
	__catch32_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = self->priv->database;
		rygel_database_database_rollback (_tmp9_);
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:506: Database upgrade fai" \
"led: %s", _tmp11_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally32:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v14_v15 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch33_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "ALTER TABLE Meta_Data " "   ADD COLUMN creator TEXT", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch33_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "UPDATE schema_info SET version = '15'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch33_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_commit (_tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch33_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch33_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_analyze (_tmp5_);
	}
	goto __finally33;
	__catch33_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = self->priv->database;
		rygel_database_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:522: Database upgrade fai" \
"led: %s", _tmp8_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally33:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v15_v16 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelDatabaseDatabase* _tmp0_ = NULL;
		RygelDatabaseDatabase* _tmp1_ = NULL;
		RygelDatabaseDatabase* _tmp2_ = NULL;
		RygelDatabaseDatabase* _tmp3_ = NULL;
		RygelDatabaseDatabase* _tmp4_ = NULL;
		RygelDatabaseDatabase* _tmp5_ = NULL;
		_tmp0_ = self->priv->database;
		rygel_database_database_begin (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch34_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = self->priv->database;
		rygel_database_database_exec (_tmp1_, "INSERT INTO meta_data (size, mime_type, " "class, object_fk) SELECT 0, " "'inode/directory', 'object.container', " "o.upnp_id FROM object AS o WHERE " "o.type_fk=0;", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch34_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->database;
		rygel_database_database_exec (_tmp2_, "UPDATE schema_info SET version = '16'", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch34_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = self->priv->database;
		rygel_database_database_commit (_tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch34_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = self->priv->database;
		rygel_database_database_exec (_tmp4_, "VACUUM", NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch34_rygel_database_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = self->priv->database;
		rygel_database_database_analyze (_tmp5_);
	}
	goto __finally34;
	__catch34_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelDatabaseDatabase* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = self->priv->database;
		rygel_database_database_rollback (_tmp6_);
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("rygel-media-export-media-cache-upgrader.vala:541: Database upgrade fai" \
"led: %s", _tmp8_);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_value_media_cache_upgrader_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_media_export_value_media_cache_upgrader_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_export_media_cache_upgrader_unref (value->data[0].v_pointer);
	}
}


static void rygel_media_export_value_media_cache_upgrader_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_media_export_value_media_cache_upgrader_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_media_export_value_media_cache_upgrader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaExportMediaCacheUpgrader* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_media_export_value_media_cache_upgrader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaExportMediaCacheUpgrader** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelMediaExportParamSpecMediaCacheUpgrader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	return value->data[0].v_pointer;
}


void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


static void rygel_media_export_media_cache_upgrader_class_init (RygelMediaExportMediaCacheUpgraderClass * klass) {
	rygel_media_export_media_cache_upgrader_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaExportMediaCacheUpgraderClass *) klass)->finalize = rygel_media_export_media_cache_upgrader_finalize;
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCacheUpgraderPrivate));
}


static void rygel_media_export_media_cache_upgrader_instance_init (RygelMediaExportMediaCacheUpgrader * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj) {
	RygelMediaExportMediaCacheUpgrader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader);
	g_signal_handlers_destroy (self);
}


GType rygel_media_export_media_cache_upgrader_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_upgrader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_upgrader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_media_export_value_media_cache_upgrader_init, rygel_media_export_value_media_cache_upgrader_free_value, rygel_media_export_value_media_cache_upgrader_copy_value, rygel_media_export_value_media_cache_upgrader_peek_pointer, "p", rygel_media_export_value_media_cache_upgrader_collect_value, "p", rygel_media_export_value_media_cache_upgrader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheUpgraderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_upgrader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCacheUpgrader), 0, (GInstanceInitFunc) rygel_media_export_media_cache_upgrader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_export_media_cache_upgrader_type_id;
		rygel_media_export_media_cache_upgrader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaExportMediaCacheUpgrader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_upgrader_type_id__volatile, rygel_media_export_media_cache_upgrader_type_id);
	}
	return rygel_media_export_media_cache_upgrader_type_id__volatile;
}


gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_export_media_cache_upgrader_unref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



