/* game-view.c generated by valac 0.28.0.14-080be, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_TEXT_OVERLAY (text_overlay_get_type ())
#define TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_OVERLAY, TextOverlay))
#define TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_OVERLAY, TextOverlayClass))
#define IS_TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_OVERLAY))
#define IS_TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_OVERLAY))
#define TEXT_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_OVERLAY, TextOverlayClass))

typedef struct _TextOverlay TextOverlay;
typedef struct _TextOverlayClass TextOverlayClass;

#define TYPE_BLOCK_TEXTURE (block_texture_get_type ())
#define BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_TEXTURE, BlockTexture))
#define BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_TEXTURE, BlockTextureClass))
#define IS_BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_TEXTURE))
#define IS_BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_TEXTURE))
#define BLOCK_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_TEXTURE, BlockTextureClass))

typedef struct _BlockTexture BlockTexture;
typedef struct _BlockTextureClass BlockTextureClass;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;

#define TYPE_BLOCK_ACTOR (block_actor_get_type ())
#define BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_ACTOR, BlockActor))
#define BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_ACTOR, BlockActorClass))
#define IS_BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_ACTOR))
#define IS_BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_ACTOR))
#define BLOCK_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_ACTOR, BlockActorClass))

typedef struct _BlockActor BlockActor;
typedef struct _BlockActorClass BlockActorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
typedef struct _BlockPrivate BlockPrivate;
typedef struct _BlockActorPrivate BlockActorPrivate;
typedef struct _TextOverlayPrivate TextOverlayPrivate;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _BlockTexturePrivate BlockTexturePrivate;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _GameView {
	GtkClutterEmbed parent_instance;
	GameViewPrivate * priv;
	gboolean mute;
};

struct _GameViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _GameViewPrivate {
	Game* _game;
	ClutterActor* playing_field;
	ClutterActor* shape;
	ClutterClone* shape_shadow;
	gboolean _show_shadow;
	TextOverlay* text_overlay;
	BlockTexture** block_textures;
	gint block_textures_length1;
	gint _block_textures_size_;
	GHashTable* blocks;
	GHashTable* shape_blocks;
	gint n_lines_destroyed;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _BlockActor {
	ClutterClone parent_instance;
	BlockActorPrivate * priv;
	Block* block;
};

struct _BlockActorClass {
	ClutterCloneClass parent_class;
};

struct _TextOverlay {
	ClutterCairoTexture parent_instance;
	TextOverlayPrivate * priv;
};

struct _TextOverlayClass {
	ClutterCairoTextureClass parent_class;
};

struct _TextOverlayPrivate {
	gchar* _text;
};

struct _BlockTexture {
	ClutterCairoTexture parent_instance;
	BlockTexturePrivate * priv;
};

struct _BlockTextureClass {
	ClutterCairoTextureClass parent_class;
};

struct _BlockTexturePrivate {
	gint color;
	gchar* _theme;
};


static gpointer game_view_parent_class = NULL;
static gpointer block_actor_parent_class = NULL;
static gpointer text_overlay_parent_class = NULL;
static gpointer block_texture_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
GType text_overlay_get_type (void) G_GNUC_CONST;
GType block_texture_get_type (void) G_GNUC_CONST;
GType block_get_type (void) G_GNUC_CONST;
GType block_actor_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_SHOW_SHADOW
};
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void game_view_size_allocate_cb (GameView* self, GtkWidget* widget, GtkAllocation* allocation);
static void _game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
TextOverlay* text_overlay_new (void);
TextOverlay* text_overlay_construct (GType object_type);
#define NCOLORS 7
BlockTexture* block_texture_new (gint color);
BlockTexture* block_texture_construct (GType object_type, gint color);
static void game_view_play_sound (GameView* self, const gchar* name);
static void game_view_shape_added_cb (GameView* self);
Game* game_view_get_game (GameView* self);
GType shape_get_type (void) G_GNUC_CONST;
static gint game_view_get_cell_size (GameView* self);
static void game_view_update_shadow (GameView* self);
BlockActor* block_actor_new (Block* block, ClutterActor* texture);
BlockActor* block_actor_construct (GType object_type, Block* block, ClutterActor* texture);
static void game_view_shape_moved_cb (GameView* self);
gint game_get_shadow_y (Game* self);
gboolean game_view_get_show_shadow (GameView* self);
static void game_view_shape_dropped_cb (GameView* self);
static void game_view_shape_rotated_cb (GameView* self);
static void game_view_shape_landed_cb (GameView* self, gint* lines, int lines_length1, GList* line_blocks);
void block_actor_explode (BlockActor* self);
gint game_get_width (Game* self);
gint game_get_height (Game* self);
static void game_view_pause_changed_cb (GameView* self);
static void game_view_update_message (GameView* self);
static void game_view_game_complete_cb (GameView* self);
gboolean game_get_paused (Game* self);
void text_overlay_set_text (TextOverlay* self, const gchar* value);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_shape_added_cb_game_shape_added (Game* _sender, gpointer self);
static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender, gpointer self);
static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender, gpointer self);
static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender, gpointer self);
static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender, gint* lines, int lines_length1, GList* line_blocks, gpointer self);
static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender, gpointer self);
static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
void block_texture_set_theme (BlockTexture* self, const gchar* value);
void game_view_set_show_shadow (GameView* self, gboolean value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	BLOCK_ACTOR_DUMMY_PROPERTY
};
static void block_actor_explode_complete_cb (BlockActor* self);
static void _block_actor_explode_complete_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void block_actor_finalize (GObject* obj);
#define TEXT_OVERLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEXT_OVERLAY, TextOverlayPrivate))
enum  {
	TEXT_OVERLAY_DUMMY_PROPERTY,
	TEXT_OVERLAY_TEXT
};
static gboolean text_overlay_real_draw (ClutterCairoTexture* base, cairo_t* cr);
const gchar* text_overlay_get_text (TextOverlay* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void text_overlay_finalize (GObject* obj);
static void _vala_text_overlay_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_text_overlay_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BLOCK_TEXTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLOCK_TEXTURE, BlockTexturePrivate))
enum  {
	BLOCK_TEXTURE_DUMMY_PROPERTY,
	BLOCK_TEXTURE_THEME
};
static gboolean block_texture_real_draw (ClutterCairoTexture* base, cairo_t* cr);
const gchar* block_texture_get_theme (BlockTexture* self);
static void block_texture_draw_clean (BlockTexture* self, cairo_t* cr);
static void block_texture_draw_tango (BlockTexture* self, cairo_t* cr, gboolean use_gradients);
static void block_texture_draw_plain (BlockTexture* self, cairo_t* cr);
static void block_texture_draw_rounded_rectangle (BlockTexture* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, gdouble r);
static void block_texture_finalize (GObject* obj);
static void _vala_block_texture_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_block_texture_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 322 "game-view.c"
}


static void _game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 117 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_size_allocate_cb ((GameView*) self, _sender, allocation);
#line 329 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 336 "game-view.c"
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	ClutterStage* stage = NULL;
	ClutterActor* _tmp6_ = NULL;
	ClutterStage* _tmp7_ = NULL;
	ClutterColor stage_color = {0};
	ClutterColor _tmp8_ = {0};
	ClutterColor field_color = {0};
	ClutterColor _tmp9_ = {0};
	ClutterStage* _tmp10_ = NULL;
	ClutterColor _tmp11_ = {0};
	ClutterActor* _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterColor _tmp14_ = {0};
	ClutterStage* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	TextOverlay* _tmp17_ = NULL;
	TextOverlay* _tmp18_ = NULL;
	ClutterStage* _tmp19_ = NULL;
	TextOverlay* _tmp20_ = NULL;
	BlockTexture** _tmp21_ = NULL;
#line 112 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = g_direct_hash;
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = g_direct_equal;
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_object_unref0_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->blocks);
#line 114 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->blocks = _tmp2_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = g_direct_hash;
#line 115 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = g_direct_equal;
#line 115 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_object_unref0_, _g_object_unref0_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->shape_blocks);
#line 115 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape_blocks = _tmp5_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_view_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 119 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
#line 119 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, clutter_stage_get_type (), ClutterStage));
#line 119 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	stage = _tmp7_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_.red = (guint8) 0x10;
#line 120 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_.green = (guint8) 0x10;
#line 120 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_.blue = (guint8) 0x10;
#line 120 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_.alpha = (guint8) 0xff;
#line 120 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	stage_color = _tmp8_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_.red = (guint8) 0x0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_.green = (guint8) 0x0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_.blue = (guint8) 0x0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_.alpha = (guint8) 0xff;
#line 121 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	field_color = _tmp9_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = stage;
#line 122 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = stage_color;
#line 122 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_background_color ((ClutterActor*) _tmp10_, &_tmp11_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = clutter_actor_new ();
#line 124 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_ref_sink (_tmp12_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->playing_field);
#line 124 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->playing_field = _tmp12_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = self->priv->playing_field;
#line 125 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = field_color;
#line 125 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_background_color (_tmp13_, &_tmp14_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = stage;
#line 126 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp16_ = self->priv->playing_field;
#line 126 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) _tmp15_, _tmp16_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp17_ = text_overlay_new ();
#line 128 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_ref_sink (_tmp17_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->text_overlay);
#line 128 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->text_overlay = _tmp17_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp18_ = self->priv->text_overlay;
#line 130 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp18_, (guint) 1, (guint) 1);
#line 131 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp19_ = stage;
#line 131 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp20_ = self->priv->text_overlay;
#line 131 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_container_add ((ClutterContainer*) _tmp19_, (ClutterActor*) _tmp20_, NULL);
#line 133 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp21_ = g_new0 (BlockTexture*, NCOLORS + 1);
#line 133 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
#line 133 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->block_textures = _tmp21_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->block_textures_length1 = NCOLORS;
#line 133 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_block_textures_size_ = self->priv->block_textures_length1;
#line 471 "game-view.c"
	{
		gint i = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		i = 0;
#line 476 "game-view.c"
		{
			gboolean _tmp22_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp22_ = TRUE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			while (TRUE) {
#line 483 "game-view.c"
				gint _tmp24_ = 0;
				BlockTexture** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				BlockTexture** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				BlockTexture* _tmp29_ = NULL;
				BlockTexture* _tmp30_ = NULL;
				BlockTexture** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				BlockTexture* _tmp33_ = NULL;
				BlockTexture** _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				gint _tmp35_ = 0;
				BlockTexture* _tmp36_ = NULL;
				ClutterStage* _tmp37_ = NULL;
				BlockTexture** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				BlockTexture* _tmp40_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				if (!_tmp22_) {
#line 508 "game-view.c"
					gint _tmp23_ = 0;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp23_ = i;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					i = _tmp23_ + 1;
#line 514 "game-view.c"
				}
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp22_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp24_ = i;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp25_ = self->priv->block_textures;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp25__length1 = self->priv->block_textures_length1;
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				if (!(_tmp24_ < _tmp25__length1)) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					break;
#line 528 "game-view.c"
				}
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp26_ = self->priv->block_textures;
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp26__length1 = self->priv->block_textures_length1;
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp27_ = i;
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp28_ = i;
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp29_ = block_texture_new (_tmp28_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_object_ref_sink (_tmp29_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (_tmp26_[_tmp27_]);
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp26_[_tmp27_] = _tmp29_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp30_ = _tmp26_[_tmp27_];
#line 138 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp31_ = self->priv->block_textures;
#line 138 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp31__length1 = self->priv->block_textures_length1;
#line 138 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp32_ = i;
#line 138 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 138 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp33_, (guint) 1, (guint) 1);
#line 139 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp34_ = self->priv->block_textures;
#line 139 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp34__length1 = self->priv->block_textures_length1;
#line 139 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp35_ = i;
#line 139 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp36_ = _tmp34_[_tmp35_];
#line 139 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_hide ((ClutterActor*) _tmp36_);
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp37_ = stage;
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp38_ = self->priv->block_textures;
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp38__length1 = self->priv->block_textures_length1;
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp39_ = i;
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp40_ = _tmp38_[_tmp39_];
#line 140 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_add_child ((ClutterActor*) _tmp37_, (ClutterActor*) _tmp40_);
#line 580 "game-view.c"
			}
		}
	}
#line 112 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (stage);
#line 112 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return self;
#line 588 "game-view.c"
}


GameView* game_view_new (void) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 595 "game-view.c"
}


static void game_view_play_sound (GameView* self, const gchar* name) {
	gboolean _tmp0_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (name != NULL);
#line 146 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->mute;
#line 146 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (!_tmp0_) {
#line 609 "game-view.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp1_ = name;
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp2_ = name;
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp3_ = g_strdup_printf ("%s.ogg", _tmp2_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp5_ = g_build_filename (SOUND_DIRECTORY, _tmp4_, NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp1_, CA_PROP_MEDIA_FILENAME, _tmp6_, NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_free0 (_tmp6_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_free0 (_tmp4_);
#line 634 "game-view.c"
	}
}


static void game_view_shape_added_cb (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Shape* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	Shape* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	Game* _tmp16_ = NULL;
	Game* _tmp17_ = NULL;
	Shape* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 154 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_ref_sink (_tmp0_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape);
#line 154 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape = _tmp0_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = self->priv->playing_field;
#line 155 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->shape;
#line 155 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_container_add ((ClutterContainer*) _tmp1_, _tmp2_, NULL);
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = self->priv->shape;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = _tmp5_->shape;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _tmp6_->x;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = game_view_get_cell_size (self);
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = game_view_get_game (self);
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = _tmp11_->shape;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = _tmp12_->y;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = game_view_get_cell_size (self);
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_position (_tmp3_, (gfloat) (_tmp7_ * _tmp9_), (gfloat) (_tmp13_ * _tmp15_));
#line 157 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_shadow (self);
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp16_ = game_view_get_game (self);
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp17_ = _tmp16_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp18_ = _tmp17_->shape;
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp19_ = _tmp18_->blocks;
#line 714 "game-view.c"
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block_collection = _tmp19_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
#line 722 "game-view.c"
			Block* _tmp20_ = NULL;
			Block* block = NULL;
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp20_ = _g_object_ref0 ((Block*) block_it->data);
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			block = _tmp20_;
#line 729 "game-view.c"
			{
				BlockActor* actor = NULL;
				Block* _tmp21_ = NULL;
				BlockTexture** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				Block* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				BlockTexture* _tmp25_ = NULL;
				BlockActor* _tmp26_ = NULL;
				GHashTable* _tmp27_ = NULL;
				Block* _tmp28_ = NULL;
				Block* _tmp29_ = NULL;
				BlockActor* _tmp30_ = NULL;
				BlockActor* _tmp31_ = NULL;
				ClutterActor* _tmp32_ = NULL;
				BlockActor* _tmp33_ = NULL;
				BlockActor* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				BlockActor* _tmp39_ = NULL;
				Block* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Block* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp21_ = block;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp22_ = self->priv->block_textures;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp22__length1 = self->priv->block_textures_length1;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp23_ = block;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp24_ = _tmp23_->color;
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp25_ = _tmp22_[_tmp24_];
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp26_ = block_actor_new (_tmp21_, (ClutterActor*) _tmp25_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_object_ref_sink (_tmp26_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				actor = _tmp26_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp27_ = self->priv->shape_blocks;
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp28_ = block;
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp29_ = _g_object_ref0 (_tmp28_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp30_ = actor;
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp31_ = _g_object_ref0 (_tmp30_);
#line 162 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_hash_table_insert (_tmp27_, _tmp29_, _tmp31_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp32_ = self->priv->shape;
#line 163 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp33_ = actor;
#line 163 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_container_add ((ClutterContainer*) _tmp32_, (ClutterActor*) _tmp33_, NULL);
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp34_ = actor;
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp35_ = game_view_get_cell_size (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp36_ = _tmp35_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp37_ = game_view_get_cell_size (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp38_ = _tmp37_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp34_, (gfloat) _tmp36_, (gfloat) _tmp38_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp39_ = actor;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp40_ = block;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp41_ = _tmp40_->x;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp42_ = game_view_get_cell_size (self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp43_ = _tmp42_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp44_ = block;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp45_ = _tmp44_->y;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp46_ = game_view_get_cell_size (self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp47_ = _tmp46_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp39_, (gfloat) (_tmp41_ * _tmp43_), (gfloat) (_tmp45_ * _tmp47_));
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (actor);
#line 159 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (block);
#line 832 "game-view.c"
			}
		}
	}
}


static void game_view_shape_moved_cb (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Shape* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ClutterClone* _tmp10_ = NULL;
	ClutterActor* _tmp24_ = NULL;
#line 169 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_play_sound (self, "slide");
#line 172 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->shape;
#line 172 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_save_easing_state (_tmp0_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = self->priv->shape;
#line 173 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_mode (_tmp1_, CLUTTER_EASE_IN_QUAD);
#line 174 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->shape;
#line 174 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_duration (_tmp2_, (guint) 30);
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = self->priv->shape;
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = _tmp5_->shape;
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _tmp6_->x;
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = game_view_get_cell_size (self);
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_x (_tmp3_, ((gfloat) _tmp7_) * _tmp9_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = self->priv->shape_shadow;
#line 176 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp10_ != NULL) {
#line 888 "game-view.c"
		ClutterClone* _tmp11_ = NULL;
		Game* _tmp12_ = NULL;
		Game* _tmp13_ = NULL;
		Shape* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		Game* _tmp18_ = NULL;
		Game* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp11_ = self->priv->shape_shadow;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp12_ = game_view_get_game (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp14_ = _tmp13_->shape;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp15_ = _tmp14_->x;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp16_ = game_view_get_cell_size (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp17_ = _tmp16_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp18_ = game_view_get_game (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp19_ = _tmp18_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp20_ = game_get_shadow_y (_tmp19_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp22_ = game_view_get_cell_size (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_position ((ClutterActor*) _tmp11_, (gfloat) (_tmp15_ * _tmp17_), (gfloat) (_tmp21_ * _tmp23_));
#line 930 "game-view.c"
	}
#line 178 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp24_ = self->priv->shape;
#line 178 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_restore_easing_state (_tmp24_);
#line 936 "game-view.c"
}


static void game_view_update_shadow (GameView* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
#line 181 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp3_ != NULL) {
#line 953 "game-view.c"
		Game* _tmp4_ = NULL;
		Game* _tmp5_ = NULL;
		Shape* _tmp6_ = NULL;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp4_ = game_view_get_game (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp6_ = _tmp5_->shape;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 965 "game-view.c"
	} else {
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp1_ = FALSE;
#line 969 "game-view.c"
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp1_) {
#line 973 "game-view.c"
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp7_ = game_view_get_show_shadow (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp0_ = _tmp8_;
#line 982 "game-view.c"
	} else {
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp0_ = FALSE;
#line 986 "game-view.c"
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp0_) {
#line 990 "game-view.c"
		ClutterClone* _tmp9_ = NULL;
		ClutterClone* _tmp15_ = NULL;
		Game* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Shape* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		Game* _tmp22_ = NULL;
		Game* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp9_ = self->priv->shape_shadow;
#line 185 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		if (_tmp9_ == NULL) {
#line 1009 "game-view.c"
			ClutterActor* _tmp10_ = NULL;
			ClutterClone* _tmp11_ = NULL;
			ClutterClone* _tmp12_ = NULL;
			ClutterActor* _tmp13_ = NULL;
			ClutterClone* _tmp14_ = NULL;
#line 187 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp10_ = self->priv->shape;
#line 187 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp11_ = (ClutterClone*) clutter_clone_new (_tmp10_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			g_object_ref_sink (_tmp11_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_g_object_unref0 (self->priv->shape_shadow);
#line 187 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			self->priv->shape_shadow = _tmp11_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp12_ = self->priv->shape_shadow;
#line 188 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			clutter_actor_set_opacity ((ClutterActor*) _tmp12_, (guint8) 32);
#line 189 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp13_ = self->priv->playing_field;
#line 189 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp14_ = self->priv->shape_shadow;
#line 189 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			clutter_container_add ((ClutterContainer*) _tmp13_, (ClutterActor*) _tmp14_, NULL);
#line 1035 "game-view.c"
		}
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp15_ = self->priv->shape_shadow;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp16_ = game_view_get_game (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp17_ = _tmp16_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp18_ = _tmp17_->shape;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp19_ = _tmp18_->x;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp20_ = game_view_get_cell_size (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp22_ = game_view_get_game (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp24_ = game_get_shadow_y (_tmp23_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp26_ = game_view_get_cell_size (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp27_ = _tmp26_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_position ((ClutterActor*) _tmp15_, (gfloat) (_tmp19_ * _tmp21_), (gfloat) (_tmp25_ * _tmp27_));
#line 1065 "game-view.c"
	} else {
		ClutterClone* _tmp28_ = NULL;
#line 195 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp28_ = self->priv->shape_shadow;
#line 195 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		if (_tmp28_ != NULL) {
#line 1072 "game-view.c"
			ClutterClone* _tmp29_ = NULL;
#line 196 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp29_ = self->priv->shape_shadow;
#line 196 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp29_);
#line 1078 "game-view.c"
		}
#line 197 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (self->priv->shape_shadow);
#line 197 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		self->priv->shape_shadow = NULL;
#line 1084 "game-view.c"
	}
}


static void game_view_shape_dropped_cb (GameView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Shape* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ClutterActor* _tmp10_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->shape;
#line 203 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_save_easing_state (_tmp0_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = self->priv->shape;
#line 204 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_mode (_tmp1_, CLUTTER_EASE_IN_QUAD);
#line 205 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->shape;
#line 205 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_duration (_tmp2_, (guint) 60);
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = self->priv->shape;
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = _tmp5_->shape;
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _tmp6_->y;
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = game_view_get_cell_size (self);
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 206 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_y (_tmp3_, ((gfloat) _tmp7_) * _tmp9_);
#line 207 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_shadow (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = self->priv->shape;
#line 208 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_restore_easing_state (_tmp10_);
#line 1137 "game-view.c"
}


static void game_view_shape_rotated_cb (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Shape* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_play_sound (self, "turn");
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = _tmp1_->shape;
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = _tmp2_->blocks;
#line 1158 "game-view.c"
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block_collection = _tmp3_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
#line 1166 "game-view.c"
			Block* _tmp4_ = NULL;
			Block* block = NULL;
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp4_ = _g_object_ref0 ((Block*) block_it->data);
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			block = _tmp4_;
#line 1173 "game-view.c"
			{
				BlockActor* actor = NULL;
				GHashTable* _tmp5_ = NULL;
				Block* _tmp6_ = NULL;
				gconstpointer _tmp7_ = NULL;
				BlockActor* _tmp8_ = NULL;
				BlockActor* _tmp9_ = NULL;
				Block* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				Block* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp5_ = self->priv->shape_blocks;
#line 216 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp6_ = block;
#line 216 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp8_ = _g_object_ref0 ((BlockActor*) _tmp7_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				actor = _tmp8_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp9_ = actor;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp10_ = block;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp11_ = _tmp10_->x;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp12_ = game_view_get_cell_size (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp13_ = _tmp12_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp14_ = block;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp15_ = _tmp14_->y;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp16_ = game_view_get_cell_size (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp17_ = _tmp16_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp9_, (gfloat) (_tmp11_ * _tmp13_), (gfloat) (_tmp15_ * _tmp17_));
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (actor);
#line 214 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (block);
#line 1223 "game-view.c"
			}
		}
	}
#line 219 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_shadow (self);
#line 1229 "game-view.c"
}


static void game_view_shape_landed_cb (GameView* self, gint* lines, int lines_length1, GList* line_blocks) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ClutterActor* _tmp1_ = NULL;
	ClutterClone* _tmp2_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	Shape* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GList* _tmp39_ = NULL;
	gint* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
#line 222 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = lines;
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0__length1 = lines_length1;
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (_tmp0__length1) {
#line 1256 "game-view.c"
		default:
		{
#line 227 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			game_view_play_sound (self, "land");
#line 228 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1263 "game-view.c"
		}
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case 1:
#line 1267 "game-view.c"
		{
#line 230 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			game_view_play_sound (self, "lines1");
#line 231 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1273 "game-view.c"
		}
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case 2:
#line 1277 "game-view.c"
		{
#line 233 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			game_view_play_sound (self, "lines2");
#line 234 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1283 "game-view.c"
		}
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case 3:
#line 224 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case 4:
#line 1289 "game-view.c"
		{
#line 237 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			game_view_play_sound (self, "lines3");
#line 238 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1295 "game-view.c"
		}
	}
#line 242 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = self->priv->shape;
#line 242 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_destroy (_tmp1_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape);
#line 243 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape = NULL;
#line 244 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->shape_shadow;
#line 244 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp2_ != NULL) {
#line 1310 "game-view.c"
		ClutterClone* _tmp3_ = NULL;
#line 245 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp3_ = self->priv->shape_shadow;
#line 245 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_destroy ((ClutterActor*) _tmp3_);
#line 1316 "game-view.c"
	}
#line 246 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape_shadow);
#line 246 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape_shadow = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = self->priv->shape_blocks;
#line 247 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_hash_table_remove_all (_tmp4_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = lines;
#line 249 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5__length1 = lines_length1;
#line 249 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->n_lines_destroyed = _tmp5__length1;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = game_view_get_game (self);
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = _tmp7_->shape;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = _tmp8_->blocks;
#line 1340 "game-view.c"
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block_collection = _tmp9_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
#line 1348 "game-view.c"
			Block* _tmp10_ = NULL;
			Block* block = NULL;
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp10_ = _g_object_ref0 ((Block*) block_it->data);
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			block = _tmp10_;
#line 1355 "game-view.c"
			{
				BlockActor* actor = NULL;
				Block* _tmp11_ = NULL;
				BlockTexture** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				Block* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				BlockTexture* _tmp15_ = NULL;
				BlockActor* _tmp16_ = NULL;
				ClutterActor* _tmp17_ = NULL;
				BlockActor* _tmp18_ = NULL;
				GHashTable* _tmp19_ = NULL;
				Block* _tmp20_ = NULL;
				Block* _tmp21_ = NULL;
				BlockActor* _tmp22_ = NULL;
				BlockActor* _tmp23_ = NULL;
				BlockActor* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				BlockActor* _tmp29_ = NULL;
				Block* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				Block* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp11_ = block;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp12_ = self->priv->block_textures;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp12__length1 = self->priv->block_textures_length1;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp13_ = block;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp14_ = _tmp13_->color;
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp15_ = _tmp12_[_tmp14_];
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp16_ = block_actor_new (_tmp11_, (ClutterActor*) _tmp15_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_object_ref_sink (_tmp16_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				actor = _tmp16_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp17_ = self->priv->playing_field;
#line 255 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp18_ = actor;
#line 255 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_container_add ((ClutterContainer*) _tmp17_, (ClutterActor*) _tmp18_, NULL);
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp19_ = self->priv->blocks;
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp20_ = block;
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp21_ = _g_object_ref0 (_tmp20_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp22_ = actor;
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp24_ = actor;
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp25_ = game_view_get_cell_size (self);
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp26_ = _tmp25_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp27_ = game_view_get_cell_size (self);
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp28_ = _tmp27_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp24_, (gfloat) _tmp26_, (gfloat) _tmp28_);
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp29_ = actor;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp30_ = block;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp31_ = _tmp30_->x;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp32_ = game_view_get_cell_size (self);
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp33_ = _tmp32_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp34_ = block;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp35_ = _tmp34_->y;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp36_ = self->priv->n_lines_destroyed;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp37_ = game_view_get_cell_size (self);
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp38_ = _tmp37_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp29_, (gfloat) (_tmp31_ * _tmp33_), (gfloat) ((_tmp35_ - _tmp36_) * _tmp38_));
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (actor);
#line 252 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (block);
#line 1461 "game-view.c"
			}
		}
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp39_ = line_blocks;
#line 1467 "game-view.c"
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block_collection = _tmp39_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
#line 1475 "game-view.c"
			Block* _tmp40_ = NULL;
			Block* block = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp40_ = _g_object_ref0 ((Block*) block_it->data);
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			block = _tmp40_;
#line 1482 "game-view.c"
			{
				BlockActor* actor = NULL;
				GHashTable* _tmp41_ = NULL;
				Block* _tmp42_ = NULL;
				gconstpointer _tmp43_ = NULL;
				BlockActor* _tmp44_ = NULL;
				BlockActor* _tmp45_ = NULL;
				GHashTable* _tmp46_ = NULL;
				Block* _tmp47_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp41_ = self->priv->blocks;
#line 264 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp42_ = block;
#line 264 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp44_ = _g_object_ref0 ((BlockActor*) _tmp43_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				actor = _tmp44_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp45_ = actor;
#line 265 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_actor_explode (_tmp45_);
#line 266 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp46_ = self->priv->blocks;
#line 266 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp47_ = block;
#line 266 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				g_hash_table_remove (_tmp46_, _tmp47_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (actor);
#line 262 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (block);
#line 1516 "game-view.c"
			}
		}
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp48_ = lines;
#line 270 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp48__length1 = lines_length1;
#line 270 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp48__length1 > 0) {
#line 1526 "game-view.c"
		{
			gint x = 0;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			x = 0;
#line 1531 "game-view.c"
			{
				gboolean _tmp49_ = FALSE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp49_ = TRUE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				while (TRUE) {
#line 1538 "game-view.c"
					gint _tmp51_ = 0;
					Game* _tmp52_ = NULL;
					Game* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					if (!_tmp49_) {
#line 1546 "game-view.c"
						gint _tmp50_ = 0;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						_tmp50_ = x;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						x = _tmp50_ + 1;
#line 1552 "game-view.c"
					}
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp49_ = FALSE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp51_ = x;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp52_ = game_view_get_game (self);
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp53_ = _tmp52_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp54_ = game_get_width (_tmp53_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp55_ = _tmp54_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					if (!(_tmp51_ < _tmp55_)) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						break;
#line 1570 "game-view.c"
					}
					{
						gint y = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						y = 0;
#line 1576 "game-view.c"
						{
							gboolean _tmp56_ = FALSE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp56_ = TRUE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							while (TRUE) {
#line 1583 "game-view.c"
								gint _tmp58_ = 0;
								Game* _tmp59_ = NULL;
								Game* _tmp60_ = NULL;
								gint _tmp61_ = 0;
								gint _tmp62_ = 0;
								Block* block = NULL;
								Game* _tmp63_ = NULL;
								Game* _tmp64_ = NULL;
								Block** _tmp65_ = NULL;
								gint _tmp65__length1 = 0;
								gint _tmp65__length2 = 0;
								gint _tmp66_ = 0;
								gint _tmp67_ = 0;
								Block* _tmp68_ = NULL;
								Block* _tmp69_ = NULL;
								Block* _tmp70_ = NULL;
								BlockActor* actor = NULL;
								GHashTable* _tmp71_ = NULL;
								Block* _tmp72_ = NULL;
								gconstpointer _tmp73_ = NULL;
								BlockActor* _tmp74_ = NULL;
								BlockActor* _tmp75_ = NULL;
								BlockActor* _tmp76_ = NULL;
								BlockActor* _tmp77_ = NULL;
								gint _tmp78_ = 0;
								gdouble _tmp79_ = 0.0;
								BlockActor* _tmp80_ = NULL;
								Block* _tmp81_ = NULL;
								gint _tmp82_ = 0;
								gint _tmp83_ = 0;
								gint _tmp84_ = 0;
								Block* _tmp85_ = NULL;
								gint _tmp86_ = 0;
								gint _tmp87_ = 0;
								gint _tmp88_ = 0;
								BlockActor* _tmp89_ = NULL;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								if (!_tmp56_) {
#line 1622 "game-view.c"
									gint _tmp57_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
									_tmp57_ = y;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
									y = _tmp57_ + 1;
#line 1628 "game-view.c"
								}
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp56_ = FALSE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp58_ = y;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp59_ = game_view_get_game (self);
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp60_ = _tmp59_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp61_ = game_get_height (_tmp60_);
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp62_ = _tmp61_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								if (!(_tmp58_ < _tmp62_)) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
									break;
#line 1646 "game-view.c"
								}
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp63_ = game_view_get_game (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp64_ = _tmp63_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp65_ = _tmp64_->blocks;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp65__length1 = _tmp64_->blocks_length1;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp65__length2 = _tmp64_->blocks_length2;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp66_ = x;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp67_ = y;
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp68_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp69_ = _g_object_ref0 (_tmp68_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								block = _tmp69_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp70_ = block;
#line 277 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								if (_tmp70_ == NULL) {
#line 278 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
									_g_object_unref0 (block);
#line 278 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
									continue;
#line 1676 "game-view.c"
								}
#line 280 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp71_ = self->priv->blocks;
#line 280 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp72_ = block;
#line 280 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp73_ = g_hash_table_lookup (_tmp71_, _tmp72_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp74_ = _g_object_ref0 ((BlockActor*) _tmp73_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								actor = _tmp74_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp75_ = actor;
#line 282 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_save_easing_state ((ClutterActor*) _tmp75_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp76_ = actor;
#line 283 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_set_easing_mode ((ClutterActor*) _tmp76_, CLUTTER_EASE_OUT_BOUNCE);
#line 284 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp77_ = actor;
#line 284 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp78_ = self->priv->n_lines_destroyed;
#line 284 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp79_ = sqrt ((gdouble) _tmp78_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_set_easing_duration ((ClutterActor*) _tmp77_, (guint) ((gint) (300 * _tmp79_)));
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp80_ = actor;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp81_ = block;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp82_ = _tmp81_->x;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp83_ = game_view_get_cell_size (self);
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp84_ = _tmp83_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp85_ = block;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp86_ = _tmp85_->y;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp87_ = game_view_get_cell_size (self);
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp88_ = _tmp87_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_set_position ((ClutterActor*) _tmp80_, ((gfloat) _tmp82_) * _tmp84_, ((gfloat) _tmp86_) * _tmp88_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp89_ = actor;
#line 286 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_restore_easing_state ((ClutterActor*) _tmp89_);
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_g_object_unref0 (actor);
#line 274 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_g_object_unref0 (block);
#line 1732 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
}


static void game_view_size_allocate_cb (GameView* self, GtkWidget* widget, GtkAllocation* allocation) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	BlockTexture** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp9_ = NULL;
	GHashTableIter shape_iter = {0};
	GHashTable* _tmp29_ = NULL;
	ClutterActor* _tmp49_ = NULL;
	TextOverlay* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	TextOverlay* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	TextOverlay* _tmp68_ = NULL;
	ClutterActor* _tmp69_ = NULL;
	Game* _tmp70_ = NULL;
	Game* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	Game* _tmp76_ = NULL;
	Game* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	ClutterActor* _tmp82_ = NULL;
	gint _tmp83_ = 0;
	ClutterActor* _tmp84_ = NULL;
	gfloat _tmp85_ = 0.0F;
	gint _tmp86_ = 0;
	ClutterActor* _tmp87_ = NULL;
	gfloat _tmp88_ = 0.0F;
#line 292 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (widget != NULL);
#line 292 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (allocation != NULL);
#line 294 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 294 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 295 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		return;
#line 1793 "game-view.c"
	}
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->block_textures;
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2__length1 = self->priv->block_textures_length1;
#line 1799 "game-view.c"
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		texture_collection = _tmp2_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		texture_collection_length1 = _tmp2__length1;
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (texture_it = 0; texture_it < _tmp2__length1; texture_it = texture_it + 1) {
#line 1811 "game-view.c"
			BlockTexture* _tmp3_ = NULL;
			BlockTexture* texture = NULL;
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp3_ = _g_object_ref0 (texture_collection[texture_it]);
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			texture = _tmp3_;
#line 1818 "game-view.c"
			{
				BlockTexture* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp4_ = texture;
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp5_ = game_view_get_cell_size (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp6_ = _tmp5_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp7_ = game_view_get_cell_size (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp8_ = _tmp7_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp4_, (gfloat) _tmp6_, (gfloat) _tmp8_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (texture);
#line 1839 "game-view.c"
			}
		}
	}
#line 300 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = self->priv->blocks;
#line 300 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_hash_table_iter_init (&iter, _tmp9_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	while (TRUE) {
#line 1849 "game-view.c"
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Block* _tmp13_ = NULL;
		BlockActor* _tmp14_ = NULL;
		BlockActor* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		BlockActor* _tmp20_ = NULL;
		Block* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		Block* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp12_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp10_), (gpointer*) (&_tmp11_));
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (block);
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp13_ = _g_object_ref0 (_tmp10_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block = _tmp13_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (actor);
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp14_ = _g_object_ref0 (_tmp11_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		actor = _tmp14_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		if (!_tmp12_) {
#line 306 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_g_object_unref0 (actor);
#line 306 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_g_object_unref0 (block);
#line 306 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1893 "game-view.c"
		}
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp15_ = actor;
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp16_ = game_view_get_cell_size (self);
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp17_ = _tmp16_;
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp18_ = game_view_get_cell_size (self);
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp19_ = _tmp18_;
#line 307 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_size ((ClutterActor*) _tmp15_, (gfloat) _tmp17_, (gfloat) _tmp19_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp20_ = actor;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp21_ = block;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp22_ = _tmp21_->x;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp23_ = game_view_get_cell_size (self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp24_ = _tmp23_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp25_ = block;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp26_ = _tmp25_->y;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp27_ = game_view_get_cell_size (self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp28_ = _tmp27_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_position ((ClutterActor*) _tmp20_, (gfloat) (_tmp22_ * _tmp24_), (gfloat) (_tmp26_ * _tmp28_));
#line 301 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (actor);
#line 301 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (block);
#line 1931 "game-view.c"
	}
#line 310 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp29_ = self->priv->shape_blocks;
#line 310 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_hash_table_iter_init (&shape_iter, _tmp29_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	while (TRUE) {
#line 1939 "game-view.c"
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		Block* _tmp33_ = NULL;
		BlockActor* _tmp34_ = NULL;
		BlockActor* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		BlockActor* _tmp40_ = NULL;
		Block* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Block* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp32_ = g_hash_table_iter_next (&shape_iter, (gpointer*) (&_tmp30_), (gpointer*) (&_tmp31_));
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (block);
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp33_ = _g_object_ref0 (_tmp30_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block = _tmp33_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (actor);
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp34_ = _g_object_ref0 (_tmp31_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		actor = _tmp34_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		if (!_tmp32_) {
#line 316 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_g_object_unref0 (actor);
#line 316 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_g_object_unref0 (block);
#line 316 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			break;
#line 1983 "game-view.c"
		}
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp35_ = actor;
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp36_ = game_view_get_cell_size (self);
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp37_ = _tmp36_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp38_ = game_view_get_cell_size (self);
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp39_ = _tmp38_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_size ((ClutterActor*) _tmp35_, (gfloat) _tmp37_, (gfloat) _tmp39_);
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp40_ = actor;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp41_ = block;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp42_ = _tmp41_->x;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp43_ = game_view_get_cell_size (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp44_ = _tmp43_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp45_ = block;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp46_ = _tmp45_->y;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp47_ = game_view_get_cell_size (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp48_ = _tmp47_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_position ((ClutterActor*) _tmp40_, (gfloat) (_tmp42_ * _tmp44_), (gfloat) (_tmp46_ * _tmp48_));
#line 311 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (actor);
#line 311 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_g_object_unref0 (block);
#line 2021 "game-view.c"
	}
#line 320 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp49_ = self->priv->shape;
#line 320 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp49_ != NULL) {
#line 2027 "game-view.c"
		ClutterActor* _tmp50_ = NULL;
		Game* _tmp51_ = NULL;
		Game* _tmp52_ = NULL;
		Shape* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		Game* _tmp57_ = NULL;
		Game* _tmp58_ = NULL;
		Shape* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp50_ = self->priv->shape;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp51_ = game_view_get_game (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp52_ = _tmp51_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp53_ = _tmp52_->shape;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp54_ = _tmp53_->x;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp55_ = game_view_get_cell_size (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp56_ = _tmp55_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp57_ = game_view_get_game (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp58_ = _tmp57_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp59_ = _tmp58_->shape;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp60_ = _tmp59_->y;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp61_ = game_view_get_cell_size (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp62_ = _tmp61_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		clutter_actor_set_position (_tmp50_, (gfloat) (_tmp54_ * _tmp56_), (gfloat) (_tmp60_ * _tmp62_));
#line 2069 "game-view.c"
	}
#line 322 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_shadow (self);
#line 324 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp63_ = self->priv->text_overlay;
#line 324 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp64_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 324 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp65_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 324 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_size ((ClutterActor*) _tmp63_, (gfloat) _tmp64_, (gfloat) _tmp65_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp66_ = self->priv->text_overlay;
#line 325 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp67_ = clutter_actor_get_parent ((ClutterActor*) _tmp66_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp68_ = self->priv->text_overlay;
#line 325 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_child_above_sibling (_tmp67_, (ClutterActor*) _tmp68_, NULL);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp69_ = self->priv->playing_field;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp70_ = game_view_get_game (self);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp71_ = _tmp70_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp72_ = game_get_width (_tmp71_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp73_ = _tmp72_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp74_ = game_view_get_cell_size (self);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp75_ = _tmp74_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp76_ = game_view_get_game (self);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp77_ = _tmp76_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp78_ = game_get_height (_tmp77_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp79_ = _tmp78_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp80_ = game_view_get_cell_size (self);
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp81_ = _tmp80_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_size (_tmp69_, (gfloat) (_tmp73_ * _tmp75_), (gfloat) (_tmp79_ * _tmp81_));
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp82_ = self->priv->playing_field;
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp83_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp84_ = self->priv->playing_field;
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp85_ = clutter_actor_get_width (_tmp84_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp86_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp87_ = self->priv->playing_field;
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp88_ = clutter_actor_get_height (_tmp87_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_position (_tmp82_, (_tmp83_ - _tmp85_) * 0.5f, _tmp86_ - _tmp88_);
#line 2133 "game-view.c"
}


static void game_view_pause_changed_cb (GameView* self) {
#line 332 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 334 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_message (self);
#line 2142 "game-view.c"
}


static void game_view_game_complete_cb (GameView* self) {
#line 337 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_play_sound (self, "gameover");
#line 340 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_message (self);
#line 2153 "game-view.c"
}


static void game_view_update_message (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 345 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 345 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = game_get_paused (_tmp1_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp3_) {
#line 2174 "game-view.c"
		TextOverlay* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 346 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp4_ = self->priv->text_overlay;
#line 346 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp5_ = _ ("Paused");
#line 346 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		text_overlay_set_text (_tmp4_, _tmp5_);
#line 2183 "game-view.c"
	} else {
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 347 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp6_ = game_view_get_game (self);
#line 347 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp8_ = _tmp7_->game_over;
#line 347 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		if (_tmp8_) {
#line 2196 "game-view.c"
			TextOverlay* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp9_ = self->priv->text_overlay;
#line 348 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp10_ = _ ("Game Over");
#line 348 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			text_overlay_set_text (_tmp9_, _tmp10_);
#line 2205 "game-view.c"
		} else {
			TextOverlay* _tmp11_ = NULL;
#line 350 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp11_ = self->priv->text_overlay;
#line 350 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			text_overlay_set_text (_tmp11_, NULL);
#line 2212 "game-view.c"
		}
	}
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 17 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 17 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 17 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = _tmp0_;
#line 17 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 2229 "game-view.c"
}


static void _game_view_shape_added_cb_game_shape_added (Game* _sender, gpointer self) {
#line 23 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_shape_added_cb ((GameView*) self);
#line 2236 "game-view.c"
}


static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender, gpointer self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_shape_moved_cb ((GameView*) self);
#line 2243 "game-view.c"
}


static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender, gpointer self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_shape_dropped_cb ((GameView*) self);
#line 2250 "game-view.c"
}


static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender, gpointer self) {
#line 26 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_shape_rotated_cb ((GameView*) self);
#line 2257 "game-view.c"
}


static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender, gint* lines, int lines_length1, GList* line_blocks, gpointer self) {
#line 27 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_shape_landed_cb ((GameView*) self, lines, lines_length1, line_blocks);
#line 2264 "game-view.c"
}


static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender, gpointer self) {
#line 28 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_pause_changed_cb ((GameView*) self);
#line 2271 "game-view.c"
}


static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 29 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_game_complete_cb ((GameView*) self);
#line 2278 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	ClutterActor* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	Shape* _tmp15_ = NULL;
	Game* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	Game* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
#line 18 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 20 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 20 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 2310 "game-view.c"
		Game* _tmp1_ = NULL;
#line 21 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 21 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 2316 "game-view.c"
	}
#line 22 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = value;
#line 22 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 22 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 22 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = self->priv->_game;
#line 23 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp4_, "shape-added", (GCallback) _game_view_shape_added_cb_game_shape_added, self, 0);
#line 24 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = self->priv->_game;
#line 24 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp5_, "shape-moved", (GCallback) _game_view_shape_moved_cb_game_shape_moved, self, 0);
#line 25 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = self->priv->_game;
#line 25 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp6_, "shape-dropped", (GCallback) _game_view_shape_dropped_cb_game_shape_dropped, self, 0);
#line 26 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = self->priv->_game;
#line 26 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp7_, "shape-rotated", (GCallback) _game_view_shape_rotated_cb_game_shape_rotated, self, 0);
#line 27 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = self->priv->_game;
#line 27 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp8_, "shape-landed", (GCallback) _game_view_shape_landed_cb_game_shape_landed, self, 0);
#line 28 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = self->priv->_game;
#line 28 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp9_, "pause-changed", (GCallback) _game_view_pause_changed_cb_game_pause_changed, self, 0);
#line 29 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = self->priv->_game;
#line 29 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object (_tmp10_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
#line 32 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = self->priv->blocks;
#line 32 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_hash_table_remove_all (_tmp11_);
#line 33 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = self->priv->playing_field;
#line 33 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_remove_all_children (_tmp12_);
#line 34 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape_shadow);
#line 34 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape_shadow = NULL;
#line 37 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = game_view_get_game (self);
#line 37 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = _tmp13_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = _tmp14_->shape;
#line 37 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp15_ != NULL) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		game_view_shape_added_cb (self);
#line 2376 "game-view.c"
	}
	{
		gint x = 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		x = 0;
#line 2382 "game-view.c"
		{
			gboolean _tmp16_ = FALSE;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp16_ = TRUE;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			while (TRUE) {
#line 2389 "game-view.c"
				gint _tmp18_ = 0;
				Game* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				if (!_tmp16_) {
#line 2396 "game-view.c"
					gint _tmp17_ = 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					_tmp17_ = x;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					x = _tmp17_ + 1;
#line 2402 "game-view.c"
				}
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp16_ = FALSE;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp18_ = x;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp19_ = self->priv->_game;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp20_ = game_get_width (_tmp19_);
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp21_ = _tmp20_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				if (!(_tmp18_ < _tmp21_)) {
#line 39 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					break;
#line 2418 "game-view.c"
				}
				{
					gint y = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
					y = 0;
#line 2424 "game-view.c"
					{
						gboolean _tmp22_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						_tmp22_ = TRUE;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
						while (TRUE) {
#line 2431 "game-view.c"
							gint _tmp24_ = 0;
							Game* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							Block* block = NULL;
							Game* _tmp28_ = NULL;
							Block** _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Block* _tmp32_ = NULL;
							Block* _tmp33_ = NULL;
							Block* _tmp34_ = NULL;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							if (!_tmp22_) {
#line 2448 "game-view.c"
								gint _tmp23_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp23_ = y;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								y = _tmp23_ + 1;
#line 2454 "game-view.c"
							}
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp22_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp24_ = y;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp25_ = self->priv->_game;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp26_ = game_get_height (_tmp25_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp27_ = _tmp26_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							if (!(_tmp24_ < _tmp27_)) {
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								break;
#line 2470 "game-view.c"
							}
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp28_ = self->priv->_game;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp29_ = _tmp28_->blocks;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp29__length1 = _tmp28_->blocks_length1;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp29__length2 = _tmp28_->blocks_length2;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp30_ = x;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp31_ = y;
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp33_ = _g_object_ref0 (_tmp32_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							block = _tmp33_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_tmp34_ = block;
#line 44 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							if (_tmp34_ != NULL) {
#line 2494 "game-view.c"
								BlockActor* actor = NULL;
								Block* _tmp35_ = NULL;
								BlockTexture** _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
								Block* _tmp37_ = NULL;
								gint _tmp38_ = 0;
								BlockTexture* _tmp39_ = NULL;
								BlockActor* _tmp40_ = NULL;
								GHashTable* _tmp41_ = NULL;
								Block* _tmp42_ = NULL;
								Block* _tmp43_ = NULL;
								BlockActor* _tmp44_ = NULL;
								BlockActor* _tmp45_ = NULL;
								BlockActor* _tmp46_ = NULL;
								gint _tmp47_ = 0;
								gint _tmp48_ = 0;
								gint _tmp49_ = 0;
								gint _tmp50_ = 0;
								BlockActor* _tmp51_ = NULL;
								Block* _tmp52_ = NULL;
								gint _tmp53_ = 0;
								gint _tmp54_ = 0;
								gint _tmp55_ = 0;
								Block* _tmp56_ = NULL;
								gint _tmp57_ = 0;
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
								ClutterActor* _tmp60_ = NULL;
								BlockActor* _tmp61_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp35_ = block;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp36_ = self->priv->block_textures;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp36__length1 = self->priv->block_textures_length1;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp37_ = block;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp38_ = _tmp37_->color;
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp39_ = _tmp36_[_tmp38_];
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp40_ = block_actor_new (_tmp35_, (ClutterActor*) _tmp39_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								g_object_ref_sink (_tmp40_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								actor = _tmp40_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp41_ = self->priv->blocks;
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp42_ = block;
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp43_ = _g_object_ref0 (_tmp42_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp44_ = actor;
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp45_ = _g_object_ref0 (_tmp44_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								g_hash_table_insert (_tmp41_, _tmp43_, _tmp45_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp46_ = actor;
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp47_ = game_view_get_cell_size (self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp48_ = _tmp47_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp49_ = game_view_get_cell_size (self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp50_ = _tmp49_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_set_size ((ClutterActor*) _tmp46_, (gfloat) _tmp48_, (gfloat) _tmp50_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp51_ = actor;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp52_ = block;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp53_ = _tmp52_->x;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp54_ = game_view_get_cell_size (self);
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp55_ = _tmp54_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp56_ = block;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp57_ = _tmp56_->y;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp58_ = game_view_get_cell_size (self);
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp59_ = _tmp58_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_actor_set_position ((ClutterActor*) _tmp51_, (gfloat) (_tmp53_ * _tmp55_), (gfloat) (_tmp57_ * _tmp59_));
#line 50 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp60_ = self->priv->playing_field;
#line 50 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_tmp61_ = actor;
#line 50 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								clutter_container_add ((ClutterContainer*) _tmp60_, (ClutterActor*) _tmp61_, NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
								_g_object_unref0 (actor);
#line 2594 "game-view.c"
							}
#line 41 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
							_g_object_unref0 (block);
#line 2598 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp62_ = self->priv->_game;
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp63_ = game_get_width (_tmp62_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp64_ = _tmp63_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp65_ = self->priv->_game;
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp66_ = game_get_height (_tmp65_);
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp67_ = _tmp66_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, (_tmp64_ * 190) / _tmp67_, 190);
#line 56 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_message (self);
#line 18 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2623 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	BlockTexture** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->block_textures;
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0__length1 = self->priv->block_textures_length1;
#line 2636 "game-view.c"
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		texture_collection = _tmp0_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		texture_collection_length1 = _tmp0__length1;
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		for (texture_it = 0; texture_it < _tmp0__length1; texture_it = texture_it + 1) {
#line 2648 "game-view.c"
			BlockTexture* _tmp1_ = NULL;
			BlockTexture* texture = NULL;
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			_tmp1_ = _g_object_ref0 (texture_collection[texture_it]);
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			texture = _tmp1_;
#line 2655 "game-view.c"
			{
				BlockTexture* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
#line 69 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp2_ = texture;
#line 69 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp3_ = value;
#line 69 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_texture_set_theme (_tmp2_, _tmp3_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_g_object_unref0 (texture);
#line 2667 "game-view.c"
			}
		}
	}
#line 66 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 2673 "game-view.c"
}


gboolean game_view_get_show_shadow (GameView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 84 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 84 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_show_shadow;
#line 84 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = _tmp0_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 2688 "game-view.c"
}


void game_view_set_show_shadow (GameView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 85 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = value;
#line 85 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_show_shadow = _tmp0_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_update_shadow (self);
#line 85 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_notify ((GObject *) self, "show-shadow");
#line 2704 "game-view.c"
}


static gint game_view_get_cell_size (GameView* self) {
	gint result;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 105 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp1_ != NULL) {
#line 2720 "game-view.c"
		gint _tmp2_ = 0;
		Game* _tmp3_ = NULL;
		Game* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Game* _tmp8_ = NULL;
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp3_ = game_view_get_game (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp5_ = game_get_width (_tmp4_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp8_ = game_view_get_game (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp9_ = _tmp8_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp10_ = game_get_height (_tmp9_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp12_ = MIN (_tmp2_ / _tmp6_, _tmp7_ / _tmp11_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		result = _tmp12_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		return result;
#line 2758 "game-view.c"
	} else {
#line 108 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		result = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		return result;
#line 2764 "game-view.c"
	}
}


static void game_view_class_init (GameViewClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_SHADOW, g_param_spec_boolean ("show-shadow", "show-shadow", "show-shadow", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2786 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 14 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_game = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape = NULL;
#line 79 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->shape_shadow = NULL;
#line 81 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_show_shadow = FALSE;
#line 2801 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 14 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 73 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->playing_field);
#line 76 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape);
#line 79 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->shape_shadow);
#line 89 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->priv->text_overlay);
#line 92 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
#line 95 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->blocks);
#line 96 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->shape_blocks);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2827 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case GAME_VIEW_SHOW_SHADOW:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		g_value_set_boolean (value, game_view_get_show_shadow (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 2860 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 2866 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case GAME_VIEW_SHOW_SHADOW:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		game_view_set_show_shadow (self, g_value_get_boolean (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 2894 "game-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 2900 "game-view.c"
	}
}


BlockActor* block_actor_construct (GType object_type, Block* block, ClutterActor* texture) {
	BlockActor * self = NULL;
	ClutterActor* _tmp0_ = NULL;
	Block* _tmp1_ = NULL;
	Block* _tmp2_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (block != NULL, NULL);
#line 358 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (texture != NULL, NULL);
#line 360 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = texture;
#line 360 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (BlockActor*) g_object_new (object_type, "source", _tmp0_, NULL);
#line 361 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = block;
#line 361 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->block);
#line 361 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->block = _tmp2_;
#line 358 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return self;
#line 2928 "game-view.c"
}


BlockActor* block_actor_new (Block* block, ClutterActor* texture) {
#line 358 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return block_actor_construct (TYPE_BLOCK_ACTOR, block, texture);
#line 2935 "game-view.c"
}


static void _block_actor_explode_complete_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
#line 373 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_actor_explode_complete_cb ((BlockActor*) self);
#line 2942 "game-view.c"
}


void block_actor_explode (BlockActor* self) {
	ClutterActor* _tmp0_ = NULL;
#line 364 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 366 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
#line 366 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_child_above_sibling (_tmp0_, (ClutterActor*) self, NULL);
#line 368 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 369 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUINT);
#line 370 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 720);
#line 371 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 372 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 2.f, (gdouble) 2.f);
#line 373 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _block_actor_explode_complete_cb_clutter_actor_transitions_completed, self, 0);
#line 374 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 2968 "game-view.c"
}


static void block_actor_explode_complete_cb (BlockActor* self) {
#line 377 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 379 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_actor_destroy ((ClutterActor*) self);
#line 2977 "game-view.c"
}


static void block_actor_class_init (BlockActorClass * klass) {
#line 354 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_actor_parent_class = g_type_class_peek_parent (klass);
#line 354 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = block_actor_finalize;
#line 2986 "game-view.c"
}


static void block_actor_instance_init (BlockActor * self) {
}


static void block_actor_finalize (GObject* obj) {
	BlockActor * self;
#line 354 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK_ACTOR, BlockActor);
#line 356 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (self->block);
#line 354 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (block_actor_parent_class)->finalize (obj);
#line 3002 "game-view.c"
}


GType block_actor_get_type (void) {
	static volatile gsize block_actor_type_id__volatile = 0;
	if (g_once_init_enter (&block_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockActor), 0, (GInstanceInitFunc) block_actor_instance_init, NULL };
		GType block_actor_type_id;
		block_actor_type_id = g_type_register_static (clutter_clone_get_type (), "BlockActor", &g_define_type_info, 0);
		g_once_init_leave (&block_actor_type_id__volatile, block_actor_type_id);
	}
	return block_actor_type_id__volatile;
}


TextOverlay* text_overlay_construct (GType object_type) {
	TextOverlay * self = NULL;
#line 392 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (TextOverlay*) g_object_new (object_type, NULL);
#line 394 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
#line 392 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return self;
#line 3026 "game-view.c"
}


TextOverlay* text_overlay_new (void) {
#line 392 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return text_overlay_construct (TYPE_TEXT_OVERLAY);
#line 3033 "game-view.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 3040 "game-view.c"
}


static gboolean text_overlay_real_draw (ClutterCairoTexture* base, cairo_t* cr) {
	TextOverlay * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint w = 0U;
	guint h = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	cairo_t* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp7_ = NULL;
	PangoLayout* layout = NULL;
	cairo_t* _tmp8_ = NULL;
	PangoLayout* _tmp9_ = NULL;
	PangoLayout* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	PangoLayout* dummy_layout = NULL;
	PangoLayout* _tmp13_ = NULL;
	PangoLayout* _tmp14_ = NULL;
	PangoLayout* _tmp15_ = NULL;
	PangoFontDescription* _tmp16_ = NULL;
	gint lw = 0;
	gint lh = 0;
	PangoLayout* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	PangoFontDescription* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	guint _tmp23_ = 0U;
	PangoLayout* _tmp24_ = NULL;
	PangoFontDescription* _tmp25_ = NULL;
	PangoLayout* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	cairo_t* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	cairo_t* _tmp32_ = NULL;
	PangoLayout* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	gfloat _tmp36_ = 0.0F;
	gfloat _tmp37_ = 0.0F;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
#line 397 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (TextOverlay*) base;
#line 397 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 399 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
#line 401 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = text_overlay_get_text (self);
#line 401 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 402 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		result = FALSE;
#line 402 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		return result;
#line 3111 "game-view.c"
	}
#line 406 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp2_, &_tmp3_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	w = _tmp2_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	h = _tmp3_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = cr;
#line 407 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = w;
#line 407 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = h;
#line 407 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_translate (_tmp4_, (gdouble) (_tmp5_ / 2), (gdouble) (_tmp6_ / 2));
#line 409 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = pango_font_description_from_string ("Sans");
#line 409 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	desc = _tmp7_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = cr;
#line 411 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = pango_cairo_create_layout (_tmp8_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	layout = _tmp9_;
#line 412 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = layout;
#line 412 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = text_overlay_get_text (self);
#line 412 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = _tmp11_;
#line 412 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_layout_set_text (_tmp10_, _tmp12_, -1);
#line 414 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = layout;
#line 414 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = pango_layout_copy (_tmp13_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	dummy_layout = _tmp14_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = dummy_layout;
#line 415 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp16_ = desc;
#line 415 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_layout_set_font_description (_tmp15_, _tmp16_);
#line 417 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp17_ = dummy_layout;
#line 417 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_layout_get_size (_tmp17_, &_tmp18_, &_tmp19_);
#line 417 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	lw = _tmp18_;
#line 417 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	lh = _tmp19_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp20_ = desc;
#line 419 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp21_ = lh;
#line 419 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp22_ = lw;
#line 419 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp23_ = w;
#line 419 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_font_description_set_absolute_size (_tmp20_, (((((gfloat) _tmp21_) / _tmp22_) * PANGO_SCALE) * _tmp23_) * 0.7);
#line 420 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp24_ = layout;
#line 420 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp25_ = desc;
#line 420 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_layout_set_font_description (_tmp24_, _tmp25_);
#line 422 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp26_ = layout;
#line 422 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_layout_get_size (_tmp26_, &_tmp27_, &_tmp28_);
#line 422 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	lw = _tmp27_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	lh = _tmp28_;
#line 423 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp29_ = cr;
#line 423 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp30_ = lw;
#line 423 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp31_ = lh;
#line 423 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_move_to (_tmp29_, (-(((gdouble) _tmp30_) / PANGO_SCALE)) / 2, (-(((gdouble) _tmp31_) / PANGO_SCALE)) / 2);
#line 424 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp32_ = cr;
#line 424 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp33_ = layout;
#line 424 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pango_cairo_layout_path (_tmp32_, _tmp33_);
#line 425 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp34_ = cr;
#line 425 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source_rgb (_tmp34_, 0.333333333333, 0.341176470588, 0.32549019607);
#line 428 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp35_ = cr;
#line 428 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp36_ = clutter_actor_get_width ((ClutterActor*) self);
#line 428 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp37_ = _tmp36_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_line_width (_tmp35_, _tmp37_ / 100.0);
#line 429 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp38_ = cr;
#line 429 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_stroke_preserve (_tmp38_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp39_ = cr;
#line 431 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source_rgb (_tmp39_, 1.0, 1.0, 1.0);
#line 432 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp40_ = cr;
#line 432 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_fill (_tmp40_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = FALSE;
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (dummy_layout);
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_object_unref0 (layout);
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	__vala_PangoFontDescription_free0 (desc);
#line 434 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 3237 "game-view.c"
}


const gchar* text_overlay_get_text (TextOverlay* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 388 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 388 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_text;
#line 388 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = _tmp0_;
#line 388 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 3252 "game-view.c"
}


void text_overlay_set_text (TextOverlay* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = value;
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_free0 (self->priv->_text);
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_text = _tmp1_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
#line 389 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_notify ((GObject *) self, "text");
#line 3273 "game-view.c"
}


static void text_overlay_class_init (TextOverlayClass * klass) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	text_overlay_parent_class = g_type_class_peek_parent (klass);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (TextOverlayPrivate));
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	((ClutterCairoTextureClass *) klass)->draw = text_overlay_real_draw;
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_text_overlay_get_property;
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_text_overlay_set_property;
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = text_overlay_finalize;
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_OVERLAY_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3292 "game-view.c"
}


static void text_overlay_instance_init (TextOverlay * self) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv = TEXT_OVERLAY_GET_PRIVATE (self);
#line 385 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_text = NULL;
#line 3301 "game-view.c"
}


static void text_overlay_finalize (GObject* obj) {
	TextOverlay * self;
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_OVERLAY, TextOverlay);
#line 385 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_free0 (self->priv->_text);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (text_overlay_parent_class)->finalize (obj);
#line 3313 "game-view.c"
}


GType text_overlay_get_type (void) {
	static volatile gsize text_overlay_type_id__volatile = 0;
	if (g_once_init_enter (&text_overlay_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TextOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextOverlay), 0, (GInstanceInitFunc) text_overlay_instance_init, NULL };
		GType text_overlay_type_id;
		text_overlay_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "TextOverlay", &g_define_type_info, 0);
		g_once_init_leave (&text_overlay_type_id__volatile, text_overlay_type_id);
	}
	return text_overlay_type_id__volatile;
}


static void _vala_text_overlay_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case TEXT_OVERLAY_TEXT:
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		g_value_set_string (value, text_overlay_get_text (self));
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 3340 "game-view.c"
		default:
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 3346 "game-view.c"
	}
}


static void _vala_text_overlay_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case TEXT_OVERLAY_TEXT:
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		text_overlay_set_text (self, g_value_get_string (value));
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 3362 "game-view.c"
		default:
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 383 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 3368 "game-view.c"
	}
}


BlockTexture* block_texture_construct (GType object_type, gint color) {
	BlockTexture * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (BlockTexture*) g_object_new (object_type, NULL);
#line 456 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
#line 457 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = color;
#line 457 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, 6);
#line 457 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->color = _tmp1_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return self;
#line 3389 "game-view.c"
}


BlockTexture* block_texture_new (gint color) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return block_texture_construct (TYPE_BLOCK_TEXTURE, color);
#line 3396 "game-view.c"
}


static gboolean block_texture_real_draw (ClutterCairoTexture* base, cairo_t* cr) {
	BlockTexture * self;
	gboolean result = FALSE;
	guint w = 0U;
	guint h = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	cairo_t* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GQuark _tmp9_ = 0U;
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static GQuark _tmp8_label0 = 0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static GQuark _tmp8_label1 = 0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static GQuark _tmp8_label2 = 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = (BlockTexture*) base;
#line 460 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 462 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
#line 465 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp0_, &_tmp1_);
#line 465 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	w = _tmp0_;
#line 465 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	h = _tmp1_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = cr;
#line 466 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = w;
#line 466 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = h;
#line 466 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_scale (_tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = block_texture_get_theme (self);
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("clean")))) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		switch (0) {
#line 3452 "game-view.c"
			default:
			{
				cairo_t* _tmp10_ = NULL;
#line 475 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp10_ = cr;
#line 475 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_texture_draw_clean (self, _tmp10_);
#line 476 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 3462 "game-view.c"
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("tangoflat")))) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		switch (0) {
#line 3468 "game-view.c"
			default:
			{
				cairo_t* _tmp11_ = NULL;
#line 478 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp11_ = cr;
#line 478 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_texture_draw_tango (self, _tmp11_, FALSE);
#line 479 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 3478 "game-view.c"
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("tangoshaded")))) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		switch (0) {
#line 3484 "game-view.c"
			default:
			{
				cairo_t* _tmp12_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp12_ = cr;
#line 481 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_texture_draw_tango (self, _tmp12_, TRUE);
#line 482 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 3494 "game-view.c"
			}
		}
	} else {
#line 468 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		switch (0) {
#line 3500 "game-view.c"
			default:
			{
				cairo_t* _tmp13_ = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp13_ = cr;
#line 472 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				block_texture_draw_plain (self, _tmp13_);
#line 473 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 3510 "game-view.c"
			}
		}
	}
#line 485 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = FALSE;
#line 485 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 3518 "game-view.c"
}


static void block_texture_draw_plain (BlockTexture* self, cairo_t* cr) {
#line 490 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static const gdouble colors[] = {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
#line 3525 "game-view.c"
	cairo_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	cairo_t* _tmp7_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 488 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = cr;
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = self->priv->color;
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = colors[_tmp1_ * 3];
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = self->priv->color;
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = colors[(_tmp3_ * 3) + 1];
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = self->priv->color;
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = colors[(_tmp5_ * 3) + 2];
#line 501 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source_rgb (_tmp0_, _tmp2_, _tmp4_, _tmp6_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = cr;
#line 502 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_paint (_tmp7_);
#line 3558 "game-view.c"
}


static void block_texture_draw_rounded_rectangle (BlockTexture* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, gdouble r) {
	cairo_t* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_t* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	cairo_t* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_t* _tmp22_ = NULL;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	cairo_t* _tmp28_ = NULL;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	cairo_t* _tmp44_ = NULL;
	gdouble _tmp45_ = 0.0;
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_t* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	gdouble _tmp58_ = 0.0;
	gdouble _tmp59_ = 0.0;
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	cairo_t* _tmp62_ = NULL;
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	gdouble _tmp65_ = 0.0;
	cairo_t* _tmp66_ = NULL;
	gdouble _tmp67_ = 0.0;
	gdouble _tmp68_ = 0.0;
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_ = 0.0;
	gdouble _tmp72_ = 0.0;
	gdouble _tmp73_ = 0.0;
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
#line 505 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 505 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 507 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = cr;
#line 507 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = x;
#line 507 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = r;
#line 507 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = y;
#line 507 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_move_to (_tmp0_, _tmp1_ + _tmp2_, _tmp3_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = cr;
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = x;
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = w;
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = r;
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = y;
#line 508 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_line_to (_tmp4_, (_tmp5_ + _tmp6_) - _tmp7_, _tmp8_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = cr;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = x;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = w;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = r;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = y;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = x;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = w;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp16_ = y;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp17_ = r;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp18_ = x;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp19_ = w;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp20_ = y;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp21_ = r;
#line 509 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_curve_to (_tmp9_, (_tmp10_ + _tmp11_) - (_tmp12_ / 2), _tmp13_, _tmp14_ + _tmp15_, _tmp16_ + (_tmp17_ / 2), _tmp18_ + _tmp19_, _tmp20_ + _tmp21_);
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp22_ = cr;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp23_ = x;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp24_ = w;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp25_ = y;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp26_ = h;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp27_ = r;
#line 510 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_line_to (_tmp22_, _tmp23_ + _tmp24_, (_tmp25_ + _tmp26_) - _tmp27_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp28_ = cr;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp29_ = x;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp30_ = w;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp31_ = y;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp32_ = h;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp33_ = r;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp34_ = x;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp35_ = w;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp36_ = r;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp37_ = y;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp38_ = h;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp39_ = x;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp40_ = w;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp41_ = r;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp42_ = y;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp43_ = h;
#line 511 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_curve_to (_tmp28_, _tmp29_ + _tmp30_, (_tmp31_ + _tmp32_) - (_tmp33_ / 2), (_tmp34_ + _tmp35_) - (_tmp36_ / 2), _tmp37_ + _tmp38_, (_tmp39_ + _tmp40_) - _tmp41_, _tmp42_ + _tmp43_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp44_ = cr;
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp45_ = x;
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp46_ = r;
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp47_ = y;
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp48_ = h;
#line 512 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_line_to (_tmp44_, _tmp45_ + _tmp46_, _tmp47_ + _tmp48_);
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp49_ = cr;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp50_ = x;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp51_ = r;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp52_ = y;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp53_ = h;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp54_ = x;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp55_ = y;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp56_ = h;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp57_ = r;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp58_ = x;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp59_ = y;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp60_ = h;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp61_ = r;
#line 513 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_curve_to (_tmp49_, _tmp50_ + (_tmp51_ / 2), _tmp52_ + _tmp53_, _tmp54_, (_tmp55_ + _tmp56_) - (_tmp57_ / 2), _tmp58_, (_tmp59_ + _tmp60_) - _tmp61_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp62_ = cr;
#line 514 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp63_ = x;
#line 514 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp64_ = y;
#line 514 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp65_ = r;
#line 514 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_line_to (_tmp62_, _tmp63_, _tmp64_ + _tmp65_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp66_ = cr;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp67_ = x;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp68_ = y;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp69_ = r;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp70_ = x;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp71_ = r;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp72_ = y;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp73_ = x;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp74_ = r;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp75_ = y;
#line 515 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_curve_to (_tmp66_, _tmp67_, _tmp68_ + (_tmp69_ / 2), _tmp70_ + (_tmp71_ / 2), _tmp72_, _tmp73_ + _tmp74_, _tmp75_);
#line 3813 "game-view.c"
}


static void block_texture_draw_clean (BlockTexture* self, cairo_t* cr) {
#line 522 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static const gdouble colors[] = {0.780392156863, 0.247058823529, 0.247058823529, 0.713725490196, 0.192156862745, 0.192156862745, 0.61568627451, 0.164705882353, 0.164705882353, 0.552941176471, 0.788235294118, 0.32549019607, 0.474509803922, 0.713725490196, 0.243137254902, 0.388235294118, 0.596078431373, 0.18431372549, 0.313725490196, 0.450980392157, 0.623529411765, 0.239215686275, 0.345098039216, 0.474509803922, 0.21568627451, 0.313725490196, 0.435294117647, 1.0, 1.0, 1.0, 0.909803921569, 0.909803921569, 0.898039215686, 0.701960784314, 0.701960784314, 0.670588235294, 0.945098039216, 0.878431372549, 0.321568627451, 0.929411764706, 0.839215686275, 0.113725490196, 0.760784313725, 0.682352941176, 0.0274509803922, 0.576470588235, 0.364705882353, 0.607843137255, 0.443137254902, 0.282352941176, 0.46666666666, 0.439215686275, 0.266666666667, 0.46666666666, 0.890196078431, 0.572549019608, 0.258823529412, 0.803921568627, 0.450980392157, 0.101960784314, 0.690196078431, 0.388235294118, 0.0901960784314, 0.392156862745, 0.392156862745, 0.392156862745, 0.262745098039, 0.262745098039, 0.262745098039, 0.21568627451, 0.235294117647, 0.23921568627};
#line 3820 "game-view.c"
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	cairo_pattern_t* pat = NULL;
	cairo_pattern_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gint _tmp13_ = 0;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gdouble _tmp20_ = 0.0;
	gint _tmp21_ = 0;
	gdouble _tmp22_ = 0.0;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
#line 518 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 518 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 558 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = cr;
#line 558 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_texture_draw_rounded_rectangle (self, _tmp0_, 0.05, 0.05, 0.9, 0.9, 0.05);
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = cr;
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = self->priv->color;
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = colors[(_tmp2_ * 9) + 6];
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp4_ = self->priv->color;
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp5_ = colors[(_tmp4_ * 9) + 7];
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp6_ = self->priv->color;
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp7_ = colors[(_tmp6_ * 9) + 8];
#line 561 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source_rgb (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 562 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp8_ = cr;
#line 562 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_line_width (_tmp8_, 0.1);
#line 563 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp9_ = cr;
#line 563 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_stroke_preserve (_tmp9_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp10_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
#line 566 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	pat = _tmp10_;
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp11_ = self->priv->color;
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp12_ = colors[_tmp11_ * 9];
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp13_ = self->priv->color;
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp14_ = colors[(_tmp13_ * 9) + 1];
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp15_ = self->priv->color;
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp16_ = colors[(_tmp15_ * 9) + 2];
#line 567 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_pattern_add_color_stop_rgb (pat, 0.0, _tmp12_, _tmp14_, _tmp16_);
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp17_ = self->priv->color;
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp18_ = colors[(_tmp17_ * 9) + 3];
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp19_ = self->priv->color;
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp20_ = colors[(_tmp19_ * 9) + 4];
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp21_ = self->priv->color;
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp22_ = colors[(_tmp21_ * 9) + 5];
#line 568 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_pattern_add_color_stop_rgb (pat, 1.0, _tmp18_, _tmp20_, _tmp22_);
#line 569 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp23_ = cr;
#line 569 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source (_tmp23_, pat);
#line 570 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp24_ = cr;
#line 570 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_fill (_tmp24_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_cairo_pattern_destroy0 (pat);
#line 3921 "game-view.c"
}


static void block_texture_draw_tango (BlockTexture* self, cairo_t* cr, gboolean use_gradients) {
#line 576 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	static const gdouble colors[] = {0.93725490196078431, 0.16078431372549021, 0.16078431372549021, 0.8, 0.0, 0.0, 0.64313725490196083, 0.0, 0.0, 0.54117647058823526, 0.88627450980392153, 0.20392156862745098, 0.45098039215686275, 0.82352941176470584, 0.086274509803921567, 0.30588235294117649, 0.60392156862745094, 0.023529411764705882, 0.44705882352941179, 0.62352941176470589, 0.81176470588235294, 0.20392156862745098, 0.396078431372549, 0.64313725490196083, 0.12549019607843137, 0.29019607843137257, 0.52941176470588236, 0.93333333333333335, 0.93333333333333335, 0.92549019607843142, 0.82745098039215681, 0.84313725490196079, 0.81176470588235294, 0.72941176470588232, 0.74117647058823533, 0.71372549019607845, 0.9882352941176471, 0.9137254901960784, 0.30980392156862746, 0.92941176470588238, 0.83137254901960789, 0.0, 0.7686274509803922, 0.62745098039215685, 0.0, 0.67843137254901964, 0.49803921568627452, 0.6588235294117647, 0.45882352941176469, 0.31372549019607843, 0.4823529411764706, 0.36078431372549019, 0.20784313725490197, 0.4, 0.9882352941176471, 0.68627450980392157, 0.24313725490196078, 0.96078431372549022, 0.47450980392156861, 0.0, 0.80784313725490198, 0.36078431372549019, 0.0, 0.33, 0.34, 0.32, 0.18, 0.2, 0.21, 0.10, 0.12, 0.13};
#line 3928 "game-view.c"
	gboolean _tmp0_ = FALSE;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gdouble _tmp29_ = 0.0;
	gint _tmp30_ = 0;
	gdouble _tmp31_ = 0.0;
	gint _tmp32_ = 0;
	gdouble _tmp33_ = 0.0;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	cairo_t* _tmp47_ = NULL;
#line 573 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 611 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = use_gradients;
#line 611 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp0_) {
#line 3952 "game-view.c"
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp1_ = NULL;
		cairo_pattern_t* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gdouble _tmp4_ = 0.0;
		gint _tmp5_ = 0;
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		gdouble _tmp8_ = 0.0;
		cairo_pattern_t* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
		gint _tmp14_ = 0;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_ = NULL;
		cairo_pattern_t* _tmp17_ = NULL;
#line 613 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp1_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
#line 613 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		pat = _tmp1_;
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp2_ = pat;
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp3_ = self->priv->color;
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp4_ = colors[_tmp3_ * 9];
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp5_ = self->priv->color;
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp6_ = colors[(_tmp5_ * 9) + 1];
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp7_ = self->priv->color;
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp8_ = colors[(_tmp7_ * 9) + 2];
#line 614 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_pattern_add_color_stop_rgb (_tmp2_, 0.0, _tmp4_, _tmp6_, _tmp8_);
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp9_ = pat;
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp10_ = self->priv->color;
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp11_ = colors[(_tmp10_ * 9) + 3];
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp12_ = self->priv->color;
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp13_ = colors[(_tmp12_ * 9) + 4];
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp14_ = self->priv->color;
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp15_ = colors[(_tmp14_ * 9) + 5];
#line 615 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_pattern_add_color_stop_rgb (_tmp9_, 1.0, _tmp11_, _tmp13_, _tmp15_);
#line 616 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp16_ = cr;
#line 616 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp17_ = pat;
#line 616 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_set_source (_tmp16_, _tmp17_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_cairo_pattern_destroy0 (pat);
#line 4015 "game-view.c"
	} else {
		cairo_t* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gdouble _tmp20_ = 0.0;
		gint _tmp21_ = 0;
		gdouble _tmp22_ = 0.0;
		gint _tmp23_ = 0;
		gdouble _tmp24_ = 0.0;
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp18_ = cr;
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp19_ = self->priv->color;
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp20_ = colors[_tmp19_ * 9];
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp21_ = self->priv->color;
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp22_ = colors[(_tmp21_ * 9) + 1];
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp23_ = self->priv->color;
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp24_ = colors[(_tmp23_ * 9) + 2];
#line 619 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_set_source_rgb (_tmp18_, _tmp20_, _tmp22_, _tmp24_);
#line 4040 "game-view.c"
	}
#line 621 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp25_ = cr;
#line 621 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_texture_draw_rounded_rectangle (self, _tmp25_, 0.05, 0.05, 0.9, 0.9, 0.2);
#line 622 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp26_ = cr;
#line 622 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_fill_preserve (_tmp26_);
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp27_ = cr;
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp28_ = self->priv->color;
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp29_ = colors[(_tmp28_ * 9) + 6];
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp30_ = self->priv->color;
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp31_ = colors[(_tmp30_ * 9) + 7];
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp32_ = self->priv->color;
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp33_ = colors[(_tmp32_ * 9) + 8];
#line 624 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_source_rgb (_tmp27_, _tmp29_, _tmp31_, _tmp33_);
#line 627 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp34_ = cr;
#line 627 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_set_line_width (_tmp34_, 0.1);
#line 628 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp35_ = cr;
#line 628 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_stroke (_tmp35_);
#line 630 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp36_ = cr;
#line 630 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_texture_draw_rounded_rectangle (self, _tmp36_, 0.15, 0.15, 0.7, 0.7, 0.08);
#line 631 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp37_ = use_gradients;
#line 631 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (_tmp37_) {
#line 4082 "game-view.c"
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		cairo_t* _tmp44_ = NULL;
		cairo_pattern_t* _tmp45_ = NULL;
#line 633 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp38_ = cairo_pattern_create_linear (-0.3, -0.3, 0.8, 0.8);
#line 633 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		pat = _tmp38_;
#line 635 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp39_ = self->priv->color;
#line 635 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		switch (_tmp39_) {
#line 635 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			case 3:
#line 635 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
			case 4:
#line 4100 "game-view.c"
			{
				cairo_pattern_t* _tmp40_ = NULL;
				cairo_pattern_t* _tmp41_ = NULL;
#line 639 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp40_ = pat;
#line 639 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				cairo_pattern_add_color_stop_rgba (_tmp40_, 0.0, 1.0, 1.0, 1.0, 1.0);
#line 640 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp41_ = pat;
#line 640 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				cairo_pattern_add_color_stop_rgba (_tmp41_, 1.0, 1.0, 1.0, 1.0, 0.0);
#line 641 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 4114 "game-view.c"
			}
			default:
			{
				cairo_pattern_t* _tmp42_ = NULL;
				cairo_pattern_t* _tmp43_ = NULL;
#line 643 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp42_ = pat;
#line 643 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				cairo_pattern_add_color_stop_rgba (_tmp42_, 0.0, 0.9295, 0.9295, 0.9295, 1.0);
#line 644 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				_tmp43_ = pat;
#line 644 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				cairo_pattern_add_color_stop_rgba (_tmp43_, 1.0, 0.9295, 0.9295, 0.9295, 0.0);
#line 645 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
				break;
#line 4130 "game-view.c"
			}
		}
#line 647 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp44_ = cr;
#line 647 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp45_ = pat;
#line 647 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_set_source (_tmp44_, _tmp45_);
#line 631 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_cairo_pattern_destroy0 (pat);
#line 4141 "game-view.c"
	} else {
		cairo_t* _tmp46_ = NULL;
#line 650 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		_tmp46_ = cr;
#line 650 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		cairo_set_source_rgba (_tmp46_, 1.0, 1.0, 1.0, 0.35);
#line 4148 "game-view.c"
	}
#line 653 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp47_ = cr;
#line 653 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	cairo_stroke (_tmp47_);
#line 4154 "game-view.c"
}


const gchar* block_texture_get_theme (BlockTexture* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 444 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 444 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	result = _tmp0_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	return result;
#line 4169 "game-view.c"
}


void block_texture_set_theme (BlockTexture* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 445 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 447 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 447 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp1_ = value;
#line 447 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 448 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		return;
#line 4188 "game-view.c"
	}
#line 449 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp2_ = value;
#line 449 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 449 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_theme = _tmp3_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
#line 445 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 4202 "game-view.c"
}


static void block_texture_class_init (BlockTextureClass * klass) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	block_texture_parent_class = g_type_class_peek_parent (klass);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (BlockTexturePrivate));
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	((ClutterCairoTextureClass *) klass)->draw = block_texture_real_draw;
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_block_texture_get_property;
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_block_texture_set_property;
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = block_texture_finalize;
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLOCK_TEXTURE_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4221 "game-view.c"
}


static void block_texture_instance_init (BlockTexture * self) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv = BLOCK_TEXTURE_GET_PRIVATE (self);
#line 441 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self->priv->_theme = NULL;
#line 4230 "game-view.c"
}


static void block_texture_finalize (GObject* obj) {
	BlockTexture * self;
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK_TEXTURE, BlockTexture);
#line 441 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	G_OBJECT_CLASS (block_texture_parent_class)->finalize (obj);
#line 4242 "game-view.c"
}


GType block_texture_get_type (void) {
	static volatile gsize block_texture_type_id__volatile = 0;
	if (g_once_init_enter (&block_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockTexture), 0, (GInstanceInitFunc) block_texture_instance_init, NULL };
		GType block_texture_type_id;
		block_texture_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "BlockTexture", &g_define_type_info, 0);
		g_once_init_leave (&block_texture_type_id__volatile, block_texture_type_id);
	}
	return block_texture_type_id__volatile;
}


static void _vala_block_texture_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BlockTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_TEXTURE, BlockTexture);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case BLOCK_TEXTURE_THEME:
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		g_value_set_string (value, block_texture_get_theme (self));
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 4269 "game-view.c"
		default:
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 4275 "game-view.c"
	}
}


static void _vala_block_texture_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BlockTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_TEXTURE, BlockTexture);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
	switch (property_id) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		case BLOCK_TEXTURE_THEME:
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		block_texture_set_theme (self, g_value_get_string (value));
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 4291 "game-view.c"
		default:
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 438 "/home/mcatanzaro/jhbuild/checkout/quadrapassel/src/game-view.vala"
		break;
#line 4297 "game-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



