/* chess-player.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from chess-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPlayerPrivate {
	gboolean _local_human;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;


static gpointer chess_player_parent_class = NULL;

GType color_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
#define CHESS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_PLAYER, ChessPlayerPrivate))
enum  {
	CHESS_PLAYER_DUMMY_PROPERTY,
	CHESS_PLAYER_LOCAL_HUMAN
};
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
GType piece_type_get_type (void) G_GNUC_CONST;
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
void chess_player_undo (ChessPlayer* self);
gboolean chess_player_resign (ChessPlayer* self);
void chess_player_claim_draw (ChessPlayer* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_player_finalize (GObject* obj);
static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType color_get_type (void) {
	static volatile gsize color_type_id__volatile = 0;
	if (g_once_init_enter (&color_type_id__volatile)) {
		static const GEnumValue values[] = {{COLOR_WHITE, "COLOR_WHITE", "white"}, {COLOR_BLACK, "COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType color_type_id;
		color_type_id = g_enum_register_static ("Color", values);
		g_once_init_leave (&color_type_id__volatile, color_type_id);
	}
	return color_type_id__volatile;
}


ChessPlayer* chess_player_construct (GType object_type, Color color) {
	ChessPlayer * self = NULL;
	Color _tmp0_ = 0;
	self = (ChessPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = color;
	self->color = _tmp0_;
	return self;
}


ChessPlayer* chess_player_new (Color color) {
	return chess_player_construct (TYPE_CHESS_PLAYER, color);
}


gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = move;
	_tmp1_ = apply;
	g_signal_emit_by_name (self, "do-move", _tmp0_, _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type) {
	gboolean result = FALSE;
	gchar* move = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	PieceType _tmp5_ = 0;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = f0;
	_tmp1_ = r0;
	_tmp2_ = f1;
	_tmp3_ = r1;
	_tmp4_ = g_strdup_printf ("%c%d%c%d", 'a' + _tmp0_, _tmp1_ + 1, 'a' + _tmp2_, _tmp3_ + 1);
	move = _tmp4_;
	_tmp5_ = promotion_type;
	switch (_tmp5_) {
		case PIECE_TYPE_QUEEN:
		{
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = move;
			_tmp7_ = g_strconcat (_tmp6_, "=N", NULL);
			_g_free0 (move);
			move = _tmp7_;
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = move;
			_tmp9_ = g_strconcat (_tmp8_, "=R", NULL);
			_g_free0 (move);
			move = _tmp9_;
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp10_ = move;
			_tmp11_ = g_strconcat (_tmp10_, "=B", NULL);
			_g_free0 (move);
			move = _tmp11_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp12_ = move;
	_tmp13_ = apply;
	g_signal_emit_by_name (self, "do-move", _tmp12_, _tmp13_, &_tmp14_);
	result = _tmp14_;
	_g_free0 (move);
	return result;
}


void chess_player_undo (ChessPlayer* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "do-undo");
}


gboolean chess_player_resign (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "do-resign", &_tmp0_);
	result = _tmp0_;
	return result;
}


void chess_player_claim_draw (ChessPlayer* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "do-claim-draw");
}


gboolean chess_player_get_local_human (ChessPlayer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_local_human;
	result = _tmp0_;
	return result;
}


void chess_player_set_local_human (ChessPlayer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_local_human = _tmp0_;
	g_object_notify ((GObject *) self, "local-human");
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void chess_player_class_init (ChessPlayerClass * klass) {
	chess_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PLAYER_LOCAL_HUMAN, g_param_spec_boolean ("local-human", "local-human", "local-human", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("do_move", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("do_undo", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("do_resign", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("do_claim_draw", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_player_instance_init (ChessPlayer * self) {
	self->priv = CHESS_PLAYER_GET_PRIVATE (self);
	self->priv->_local_human = FALSE;
}


static void chess_player_finalize (GObject* obj) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PLAYER, ChessPlayer);
	G_OBJECT_CLASS (chess_player_parent_class)->finalize (obj);
}


GType chess_player_get_type (void) {
	static volatile gsize chess_player_type_id__volatile = 0;
	if (g_once_init_enter (&chess_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPlayer), 0, (GInstanceInitFunc) chess_player_instance_init, NULL };
		GType chess_player_type_id;
		chess_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPlayer", &g_define_type_info, 0);
		g_once_init_leave (&chess_player_type_id__volatile, chess_player_type_id);
	}
	return chess_player_type_id__volatile;
}


static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN:
		g_value_set_boolean (value, chess_player_get_local_human (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN:
		chess_player_set_local_human (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



