/* gnome-nibbles.c generated by valac 0.30.0.7-cbd7, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgames-support.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
typedef struct _ControlsGridPrivate ControlsGridPrivate;

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GtkRevealer* next_button_revealer;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	gint seconds;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	gint score;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};


static gpointer nibbles_parent_class = NULL;
static gpointer scoreboard_parent_class = NULL;
static gpointer player_score_box_parent_class = NULL;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES, NibblesPrivate))
enum  {
	NIBBLES_DUMMY_PROPERTY
};
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self, gint score);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self);
static void __lambda11_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self, GSettings* settings);
void nibbles_view_board_rescale (NibblesView* self, gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self, gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self, gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self, gint value);
void nibbles_view_new_level (NibblesView* self, gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
static gboolean __lambda5_ (Block1Data* _data1_);
void nibbles_game_add_bonus (NibblesGame* self, gboolean regular);
void nibbles_game_start (NibblesGame* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda6_ (Block2Data* _data2_, gint response_id);
static void ___lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self, gint value);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_start_level (NibblesGame* self);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void __lambda7_ (Block3Data* _data3_, GObject* object, GAsyncResult* _result_);
static void nibbles_game_over (Nibbles* self, gint score, glong last_score);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda9_ (Block4Data* _data4_);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda10_ (Block4Data* _data4_);
static gboolean ___lambda10__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
gint nibbles_main (gchar** args, int args_length1);
static void nibbles_finalize (GObject* obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
#define SCOREBOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCOREBOARD, ScoreboardPrivate))
enum  {
	SCOREBOARD_DUMMY_PROPERTY
};
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left);
static void scoreboard_finalize (GObject* obj);
#define PLAYER_SCORE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxPrivate))
enum  {
	PLAYER_SCORE_BOX_DUMMY_PROPERTY
};
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self, gint score);
void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left);
static void player_score_box_finalize (GObject* obj);
#define CONTROLS_GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTROLS_GRID, ControlsGridPrivate))
enum  {
	CONTROLS_GRID_DUMMY_PROPERTY
};
static void controls_grid_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[6] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};

static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_start_game_cb ((Nibbles*) self);
}


static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_new_game_cb ((Nibbles*) self);
}


static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_pause_cb ((Nibbles*) self);
}


static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_scores_cb ((Nibbles*) self);
}


static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_about_cb ((Nibbles*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
}


static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_show_controls_screen_cb ((Nibbles*) self);
}


static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_back_cb ((Nibbles*) self);
}


Nibbles* nibbles_construct (GType object_type) {
	Nibbles * self = NULL;
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
	return self;
}


Nibbles* nibbles_new (void) {
	return nibbles_construct (TYPE_NIBBLES);
}


static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Nibbles * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (Nibbles*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-nibbles %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
}


static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
	return result;
}


static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
}


static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gpointer self) {
	nibbles_log_score_cb ((Nibbles*) self, score);
}


static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self) {
	nibbles_level_completed_cb ((Nibbles*) self);
}


static void __lambda11_ (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_ = NULL;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
	} else {
		GtkStack* _tmp4_ = NULL;
		_tmp4_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
	}
}


static void ___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda11_ ((Nibbles*) self);
}


static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
	return result;
}


static void nibbles_real_startup (GApplication* base) {
	Nibbles * self;
	GtkSettings* _tmp0_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GtkCssProvider* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	GtkCssProvider* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GAction* _tmp22_ = NULL;
	GSimpleAction* _tmp23_ = NULL;
	GAction* _tmp24_ = NULL;
	GSimpleAction* _tmp25_ = NULL;
	GAction* _tmp26_ = NULL;
	GSimpleAction* _tmp27_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GtkBuilder* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	GtkApplicationWindow* _tmp31_ = NULL;
	GtkApplicationWindow* _tmp32_ = NULL;
	GtkApplicationWindow* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GSettings* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	GSettings* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	GSettings* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkHeaderBar* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkOverlay* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkButton* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkButton* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkStack* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkStack* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GeeLinkedList* _tmp66_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkRevealer* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkApplicationWindow* _tmp86_ = NULL;
	GtkHeaderBar* _tmp87_ = NULL;
	GtkApplicationWindow* _tmp88_ = NULL;
	GSettings* _tmp89_ = NULL;
	NibblesGame* _tmp90_ = NULL;
	NibblesGame* _tmp91_ = NULL;
	NibblesGame* _tmp92_ = NULL;
	NibblesGame* _tmp93_ = NULL;
	NibblesGame* _tmp94_ = NULL;
	NibblesView* _tmp95_ = NULL;
	NibblesView* _tmp96_ = NULL;
	NibblesView* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	gboolean _tmp99_ = FALSE;
	NibblesView* _tmp100_ = NULL;
	GamesGridFrame* _tmp101_ = NULL;
	GtkBox* _tmp102_ = NULL;
	GamesGridFrame* _tmp103_ = NULL;
	Scoreboard* _tmp104_ = NULL;
	NibblesView* _tmp105_ = NULL;
	NibblesGame* _tmp106_ = NULL;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	NibblesGame* _tmp109_ = NULL;
	gint _tmp110_ = 0;
	gint _tmp111_ = 0;
	GdkPixbuf* _tmp112_ = NULL;
	Scoreboard* _tmp113_ = NULL;
	GtkStack* _tmp114_ = NULL;
	Scoreboard* _tmp115_ = NULL;
	GamesGridFrame* _tmp116_ = NULL;
	NibblesView* _tmp117_ = NULL;
	GamesGridFrame* _tmp118_ = NULL;
	NibblesView* _tmp119_ = NULL;
	NibblesGame* _tmp120_ = NULL;
	gint _tmp121_ = 0;
	gint _tmp122_ = 0;
	NibblesGame* _tmp123_ = NULL;
	gint _tmp124_ = 0;
	gint _tmp125_ = 0;
	GdkPixbuf* _tmp126_ = NULL;
	NibblesView* _tmp127_ = NULL;
	NibblesGame* _tmp128_ = NULL;
	gint _tmp129_ = 0;
	gint _tmp130_ = 0;
	NibblesGame* _tmp131_ = NULL;
	gint _tmp132_ = 0;
	gint _tmp133_ = 0;
	GdkPixbuf* _tmp134_ = NULL;
	gboolean first_run = FALSE;
	GSettings* _tmp135_ = NULL;
	gboolean _tmp136_ = FALSE;
	gboolean _tmp137_ = FALSE;
	GtkApplicationWindow* _tmp138_ = NULL;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_settings_get_default ();
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp1_ = gtk_css_provider_new ();
	css_provider = _tmp1_;
	_tmp2_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp2_, "/org/gnome/nibbles/ui/nibbles.css");
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, G_N_ELEMENTS (NIBBLES_action_entries), self);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, G_N_ELEMENTS (NIBBLES_menu_entries), self);
	_tmp5_ = g_settings_new ("org.gnome.nibbles");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	_tmp6_ = gee_array_list_new (G_TYPE_SETTINGS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar* name = NULL;
				gint _tmp10_ = 0;
				gchar* _tmp11_ = NULL;
				GeeArrayList* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GSettings* _tmp14_ = NULL;
				GSettings* _tmp15_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				if (!(_tmp9_ < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp10_ = i;
				_tmp11_ = g_strdup_printf ("org.gnome.nibbles.worm%d", _tmp10_);
				name = _tmp11_;
				_tmp12_ = self->priv->worm_settings;
				_tmp13_ = name;
				_tmp14_ = g_settings_new (_tmp13_);
				_tmp15_ = _tmp14_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp15_);
				_g_object_unref0 (_tmp15_);
				_g_free0 (name);
			}
		}
	}
	_tmp16_ = g_strdup ("<Primary>q");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = g_strdup ("Escape");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp23_;
	_tmp24_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp25_;
	_tmp26_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp27_;
	_tmp28_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
	builder = _tmp28_;
	_tmp29_ = builder;
	_tmp30_ = gtk_builder_get_object (_tmp29_, "nibbles-window");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp31_;
	_tmp32_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp33_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp33_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp34_ = self->priv->window;
	_tmp35_ = self->priv->settings;
	_tmp36_ = g_settings_get_int (_tmp35_, "window-width");
	_tmp37_ = self->priv->settings;
	_tmp38_ = g_settings_get_int (_tmp37_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp34_, _tmp36_, _tmp38_);
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_boolean (_tmp39_, "window-is-maximized");
	if (_tmp40_) {
		GtkApplicationWindow* _tmp41_ = NULL;
		_tmp41_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp41_);
	}
	_tmp42_ = builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "headerbar");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp44_;
	_tmp45_ = builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "main_overlay");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp47_;
	_tmp48_ = builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "new_game_button");
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp50_;
	_tmp51_ = builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "pause_button");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp53_;
	_tmp54_ = builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "main_stack");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp56_;
	_tmp57_ = builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "game_box");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp59_;
	_tmp60_ = builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "statusbar_stack");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->statusbar_stack);
	self->priv->statusbar_stack = _tmp62_;
	_tmp63_ = builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "countdown");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->countdown);
	self->priv->countdown = _tmp65_;
	_tmp66_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	self->priv->number_of_players_buttons = _tmp66_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				gint _tmp69_ = 0;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				GObject* _tmp74_ = NULL;
				GtkToggleButton* _tmp75_ = NULL;
				GtkToggleButton* _tmp76_ = NULL;
				GtkToggleButton* _tmp77_ = NULL;
				GeeLinkedList* _tmp78_ = NULL;
				GtkToggleButton* _tmp79_ = NULL;
				if (!_tmp67_) {
					gint _tmp68_ = 0;
					_tmp68_ = i;
					i = _tmp68_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp69_ = i;
				if (!(_tmp69_ < NIBBLES_GAME_MAX_HUMANS)) {
					break;
				}
				_tmp70_ = builder;
				_tmp71_ = i;
				_tmp72_ = g_strdup_printf ("players%d", _tmp71_ + 1);
				_tmp73_ = _tmp72_;
				_tmp74_ = gtk_builder_get_object (_tmp70_, _tmp73_);
				_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_toggle_button_get_type (), GtkToggleButton));
				_tmp76_ = _tmp75_;
				_g_free0 (_tmp73_);
				button = _tmp76_;
				_tmp77_ = button;
				g_signal_connect_object (_tmp77_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
				_tmp78_ = self->priv->number_of_players_buttons;
				_tmp79_ = button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp79_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp80_ = builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "next_button_revealer");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_revealer_get_type (), GtkRevealer));
	_g_object_unref0 (self->priv->next_button_revealer);
	self->priv->next_button_revealer = _tmp82_;
	_tmp83_ = builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "grids_box");
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->grids_box);
	self->priv->grids_box = _tmp85_;
	_tmp86_ = self->priv->window;
	_tmp87_ = self->priv->headerbar;
	gtk_window_set_titlebar ((GtkWindow*) _tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp88_);
	_tmp89_ = self->priv->settings;
	_tmp90_ = nibbles_game_new (_tmp89_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp90_;
	_tmp91_ = self->priv->game;
	g_signal_connect_object (_tmp91_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
	_tmp92_ = self->priv->game;
	g_signal_connect_object (_tmp92_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
	_tmp93_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp93_, "notify::is_paused", (GCallback) ___lambda11__g_object_notify, self, 0);
	_tmp94_ = self->priv->game;
	_tmp95_ = nibbles_view_new (_tmp94_);
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp95_;
	_tmp96_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp96_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp97_ = self->priv->view;
	_tmp98_ = self->priv->settings;
	_tmp99_ = g_settings_get_boolean (_tmp98_, "sound");
	_tmp97_->is_muted = !_tmp99_;
	_tmp100_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp100_);
	_tmp101_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
	g_object_ref_sink (_tmp101_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp101_;
	_tmp102_ = self->priv->game_box;
	_tmp103_ = self->priv->frame;
	gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, TRUE, TRUE, (guint) 0);
	_tmp104_ = scoreboard_new ();
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->scoreboard);
	self->priv->scoreboard = _tmp104_;
	_tmp105_ = self->priv->view;
	_tmp106_ = self->priv->game;
	_tmp107_ = nibbles_game_get_tile_size (_tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = self->priv->game;
	_tmp110_ = nibbles_game_get_tile_size (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = nibbles_view_load_pixmap_file (_tmp105_, "scoreboard-life.svg", 2 * _tmp108_, 2 * _tmp111_);
	_g_object_unref0 (self->priv->scoreboard_life);
	self->priv->scoreboard_life = _tmp112_;
	_tmp113_ = self->priv->scoreboard;
	gtk_widget_show ((GtkWidget*) _tmp113_);
	_tmp114_ = self->priv->statusbar_stack;
	_tmp115_ = self->priv->scoreboard;
	gtk_stack_add_named (_tmp114_, (GtkWidget*) _tmp115_, "scoreboard");
	_tmp116_ = self->priv->frame;
	_tmp117_ = self->priv->view;
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = self->priv->frame;
	gtk_widget_show ((GtkWidget*) _tmp118_);
	_tmp119_ = self->priv->view;
	_tmp120_ = self->priv->game;
	_tmp121_ = nibbles_game_get_tile_size (_tmp120_);
	_tmp122_ = _tmp121_;
	_tmp123_ = self->priv->game;
	_tmp124_ = nibbles_game_get_tile_size (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = nibbles_view_load_pixmap_file (_tmp119_, "arrow.svg", 5 * _tmp122_, 5 * _tmp125_);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	self->priv->arrow_pixbuf = _tmp126_;
	_tmp127_ = self->priv->view;
	_tmp128_ = self->priv->game;
	_tmp129_ = nibbles_game_get_tile_size (_tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = self->priv->game;
	_tmp132_ = nibbles_game_get_tile_size (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = nibbles_view_load_pixmap_file (_tmp127_, "arrow-key.svg", 5 * _tmp130_, 5 * _tmp133_);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	self->priv->arrow_key_pixbuf = _tmp134_;
	_tmp135_ = self->priv->settings;
	_tmp136_ = g_settings_get_boolean (_tmp135_, "first-run");
	first_run = _tmp136_;
	_tmp137_ = first_run;
	if (_tmp137_) {
		nibbles_show_first_run_screen (self);
	} else {
		nibbles_show_new_game_screen_cb (self);
	}
	nibbles_create_scores (self);
	_tmp138_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp138_);
	_g_object_unref0 (builder);
	_g_object_unref0 (css_provider);
}


static void nibbles_real_activate (GApplication* base) {
	Nibbles * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void nibbles_real_shutdown (GApplication* base) {
	Nibbles * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	NibblesGame* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	self = (Nibbles*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->game;
	_tmp7_ = self->priv->settings;
	nibbles_game_save_properties (_tmp6_, _tmp7_);
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.width;
	self->priv->window_width = _tmp4_;
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.height;
	self->priv->window_height = _tmp6_;
}


static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	GdkEventConfigure* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkEventConfigure* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkEventConfigure* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	GdkEventConfigure* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	NibblesGame* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->width;
	ts_x = _tmp1_ / NIBBLES_GAME_WIDTH;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->height;
	ts_y = _tmp3_ / NIBBLES_GAME_HEIGHT;
	_tmp4_ = ts_x;
	_tmp5_ = event;
	_tmp6_ = _tmp5_->width;
	if ((_tmp4_ * NIBBLES_GAME_WIDTH) > _tmp6_) {
		gint _tmp7_ = 0;
		_tmp7_ = ts_x;
		ts_x = _tmp7_ - 1;
	}
	_tmp8_ = ts_y;
	_tmp9_ = event;
	_tmp10_ = _tmp9_->height;
	if ((_tmp8_ * NIBBLES_GAME_HEIGHT) > _tmp10_) {
		gint _tmp11_ = 0;
		_tmp11_ = ts_y;
		ts_y = _tmp11_ - 1;
	}
	_tmp12_ = ts_x;
	_tmp13_ = ts_y;
	_tmp14_ = MIN (_tmp12_, _tmp13_);
	tile_size = _tmp14_;
	_tmp16_ = tile_size;
	if (_tmp16_ == 0) {
		_tmp15_ = TRUE;
	} else {
		NibblesGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp17_ = self->priv->game;
		_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp15_ = _tmp19_ == 0;
	}
	if (_tmp15_) {
		result = TRUE;
		return result;
	}
	_tmp20_ = self->priv->game;
	_tmp21_ = nibbles_game_get_tile_size (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = tile_size;
	if (_tmp22_ != _tmp23_) {
		NibblesView* _tmp24_ = NULL;
		ClutterActor* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		NibblesView* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		NibblesView* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		NibblesView* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		NibblesGame* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp24_ = self->priv->view;
		_tmp25_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp24_);
		_tmp26_ = tile_size;
		_tmp27_ = tile_size;
		clutter_actor_set_size (_tmp25_, (gfloat) (_tmp26_ * NIBBLES_GAME_WIDTH), (gfloat) (_tmp27_ * NIBBLES_GAME_HEIGHT));
		_tmp28_ = self->priv->view;
		_tmp29_ = tile_size;
		nibbles_view_board_rescale (_tmp28_, _tmp29_);
		_tmp30_ = self->priv->view;
		_tmp31_ = tile_size;
		nibbles_view_boni_rescale (_tmp30_, _tmp31_);
		_tmp32_ = self->priv->view;
		_tmp33_ = tile_size;
		nibbles_view_warps_rescale (_tmp32_, _tmp33_);
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp34_ = NULL;
			GeeLinkedList* _tmp35_ = NULL;
			GeeLinkedList* _tmp36_ = NULL;
			GeeLinkedList* _tmp37_ = NULL;
			gint _worm_size = 0;
			GeeLinkedList* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _worm_index = 0;
			_tmp34_ = self->priv->game;
			_tmp35_ = nibbles_game_get_worms (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_worm_list = _tmp37_;
			_tmp38_ = _worm_list;
			_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			_worm_size = _tmp40_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Worm* worm = NULL;
				GeeLinkedList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gpointer _tmp46_ = NULL;
				Worm* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				_tmp41_ = _worm_index;
				_worm_index = _tmp41_ + 1;
				_tmp42_ = _worm_index;
				_tmp43_ = _worm_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _worm_list;
				_tmp45_ = _worm_index;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
				worm = (Worm*) _tmp46_;
				_tmp47_ = worm;
				_tmp48_ = tile_size;
				g_signal_emit_by_name (_tmp47_, "rescaled", _tmp48_);
				_g_object_unref0 (worm);
			}
			_g_object_unref0 (_worm_list);
		}
		_tmp49_ = self->priv->game;
		_tmp50_ = tile_size;
		nibbles_game_set_tile_size (_tmp49_, _tmp50_);
	}
	result = FALSE;
	return result;
}


static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	scoreboard_update ((Scoreboard*) self);
}


static void nibbles_start_game_cb (Nibbles* self) {
	GSettings* _tmp0_ = NULL;
	NibblesView* _tmp1_ = NULL;
	NibblesGame* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	NibblesView* _tmp5_ = NULL;
	Scoreboard* _tmp6_ = NULL;
	NibblesGame* _tmp38_ = NULL;
	NibblesView* _tmp39_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
	_tmp1_ = self->priv->view;
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_current_level (_tmp2_);
	_tmp4_ = _tmp3_;
	nibbles_view_new_level (_tmp1_, _tmp4_);
	_tmp5_ = self->priv->view;
	nibbles_view_connect_worm_signals (_tmp5_);
	_tmp6_ = self->priv->scoreboard;
	scoreboard_clear (_tmp6_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp7_ = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _worm_index = 0;
		_tmp7_ = self->priv->game;
		_tmp8_ = nibbles_game_get_worms (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_worm_list = _tmp10_;
		_tmp11_ = _worm_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_worm_size = _tmp13_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			gint color = 0;
			NibblesGame* _tmp20_ = NULL;
			GeeHashMap* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
			Worm* _tmp23_ = NULL;
			gpointer _tmp24_ = NULL;
			WormProperties* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			Scoreboard* _tmp28_ = NULL;
			Worm* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			GdkPixbuf* _tmp33_ = NULL;
			Worm* _tmp34_ = NULL;
			Scoreboard* _tmp35_ = NULL;
			Worm* _tmp36_ = NULL;
			Scoreboard* _tmp37_ = NULL;
			_tmp14_ = _worm_index;
			_worm_index = _tmp14_ + 1;
			_tmp15_ = _worm_index;
			_tmp16_ = _worm_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _worm_list;
			_tmp18_ = _worm_index;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
			worm = (Worm*) _tmp19_;
			_tmp20_ = self->priv->game;
			_tmp21_ = nibbles_game_get_worm_props (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = worm;
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
			_tmp25_ = (WormProperties*) _tmp24_;
			_tmp26_ = (*_tmp25_).color;
			_tmp27_ = _tmp26_;
			_worm_properties_free0 (_tmp25_);
			color = _tmp27_;
			_tmp28_ = self->priv->scoreboard;
			_tmp29_ = worm;
			_tmp30_ = color;
			_tmp31_ = nibbles_view_colorval_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->scoreboard_life;
			scoreboard_register (_tmp28_, _tmp29_, _tmp32_, _tmp33_);
			_g_free0 (_tmp32_);
			_tmp34_ = worm;
			_tmp35_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp34_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp35_, 0);
			_tmp36_ = worm;
			_tmp37_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp36_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp37_, 0);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp38_ = self->priv->game;
	nibbles_game_add_worms (_tmp38_);
	_tmp39_ = self->priv->view;
	nibbles_view_create_name_labels (_tmp39_);
	nibbles_show_game_view (self);
	nibbles_start_game_with_countdown (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Nibbles* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	Nibbles* self;
	gboolean result = FALSE;
	GtkLabel* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp15_ = 0;
	self = _data1_->self;
	_tmp0_ = self->priv->countdown;
	_tmp1_ = g_strdup_printf ("%i", _data1_->seconds);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_data1_->seconds == 0) {
		GtkStack* _tmp3_ = NULL;
		NibblesView* _tmp4_ = NULL;
		ClutterActor* _tmp5_ = NULL;
		ClutterActor* _tmp6_ = NULL;
		GtkLabel* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		NibblesGame* _tmp10_ = NULL;
		NibblesGame* _tmp11_ = NULL;
		GSimpleAction* _tmp12_ = NULL;
		GSimpleAction* _tmp13_ = NULL;
		GSimpleAction* _tmp14_ = NULL;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "scoreboard");
		_tmp4_ = self->priv->view;
		_tmp5_ = nibbles_view_get_name_labels (_tmp4_);
		_tmp6_ = _tmp5_;
		clutter_actor_hide (_tmp6_);
		_tmp7_ = self->priv->countdown;
		_tmp8_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->game;
		nibbles_game_add_bonus (_tmp10_, TRUE);
		_tmp11_ = self->priv->game;
		nibbles_game_start (_tmp11_);
		_tmp12_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp12_, TRUE);
		_tmp13_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp13_, TRUE);
		_tmp14_ = self->priv->back_action;
		g_simple_action_set_enabled (_tmp14_, TRUE);
		self->priv->countdown_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp15_ = _data1_->seconds;
	_data1_->seconds = _tmp15_ - 1;
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
	return result;
}


static void nibbles_start_game_with_countdown (Nibbles* self) {
	Block1Data* _data1_;
	GtkStack* _tmp0_ = NULL;
	NibblesView* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->statusbar_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
	_data1_->seconds = NIBBLES_COUNTDOWN_TIME;
	_tmp1_ = self->priv->view;
	_tmp2_ = nibbles_view_get_name_labels (_tmp1_);
	_tmp3_ = _tmp2_;
	clutter_actor_show (_tmp3_);
	_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	self->priv->countdown_id = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void nibbles_restart_game (Nibbles* self) {
	NibblesView* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	NibblesGame* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
	_tmp3_ = _tmp2_;
	nibbles_view_new_level (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->game;
	nibbles_game_add_worms (_tmp4_);
	nibbles_start_game_with_countdown (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Nibbles* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda6_ (Block2Data* _data2_, gint response_id) {
	Nibbles* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	self = _data2_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		nibbles_show_new_game_screen_cb (self);
	}
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = response_id;
		_tmp2_ = _tmp4_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp2_) {
		NibblesGame* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->game;
		_tmp6_ = nibbles_game_get_is_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		NibblesGame* _tmp8_ = NULL;
		NibblesView* _tmp9_ = NULL;
		_tmp8_ = self->priv->game;
		nibbles_game_start (_tmp8_);
		_tmp9_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
}


static void ___lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda6_ (self, response_id);
}


static void nibbles_new_game_cb (Nibbles* self) {
	Block2Data* _data2_;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkApplicationWindow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkButton* button = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	_tmp4_ = self->priv->window;
	_tmp5_ = _ ("Are you sure you want to start a new game?");
	_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, _tmp5_);
	g_object_ref_sink (_tmp6_);
	_data2_->dialog = _tmp6_;
	_tmp7_ = _ ("If you start a new game, the current one will be lost.");
	g_object_set (_data2_->dialog, "secondary-text", _tmp7_, NULL);
	_tmp8_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data2_->dialog, (gint) GTK_RESPONSE_OK);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
	button = _tmp9_;
	_tmp10_ = _ ("_New Game");
	gtk_button_set_label (button, _tmp10_);
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda6__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
	_g_object_unref0 (button);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void nibbles_pause_cb (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->game;
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			NibblesGame* _tmp4_ = NULL;
			GtkButton* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp4_ = self->priv->game;
			nibbles_game_pause (_tmp4_);
			_tmp5_ = self->priv->pause_button;
			_tmp6_ = _ ("_Resume");
			gtk_button_set_label (_tmp5_, _tmp6_);
		} else {
			NibblesGame* _tmp7_ = NULL;
			GtkButton* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			NibblesView* _tmp10_ = NULL;
			_tmp7_ = self->priv->game;
			nibbles_game_unpause (_tmp7_);
			_tmp8_ = self->priv->pause_button;
			_tmp9_ = _ ("_Pause");
			gtk_button_set_label (_tmp8_, _tmp9_);
			_tmp10_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
		}
	}
}


static void nibbles_show_first_run_screen (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
}


static void nibbles_show_new_game_screen_cb (Nibbles* self) {
	guint _tmp0_ = 0U;
	NibblesGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkHeaderBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkStackTransitionType type = 0;
	GtkStack* _tmp13_ = NULL;
	GtkStackTransitionType _tmp14_ = 0;
	GtkStack* _tmp15_ = NULL;
	GtkStack* _tmp16_ = NULL;
	GtkStack* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->countdown_id;
		g_source_remove (_tmp1_);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		NibblesGame* _tmp5_ = NULL;
		_tmp5_ = self->priv->game;
		nibbles_game_stop (_tmp5_);
	}
	_tmp6_ = self->priv->headerbar;
	_tmp7_ = _ ("Nibbles");
	gtk_header_bar_set_title (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_tmp10_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp10_, TRUE);
	_tmp11_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->main_stack;
	_tmp14_ = gtk_stack_get_transition_type (_tmp13_);
	type = _tmp14_;
	_tmp15_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp15_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp16_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp16_, "number_of_players");
	_tmp17_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp17_, type);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void nibbles_show_controls_screen_cb (Nibbles* self) {
	NibblesGame* _tmp21_ = NULL;
	NibblesGame* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	GtkStack* _tmp58_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _button_index = 0;
		_tmp0_ = self->priv->number_of_players_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_button_list = _tmp1_;
		_tmp2_ = _button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_button_size = _tmp4_;
		_button_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = _button_index;
			_button_index = _tmp5_ + 1;
			_tmp6_ = _button_index;
			_tmp7_ = _button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _button_list;
			_tmp9_ = _button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = button;
			_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
			if (_tmp12_) {
				gchar* label = NULL;
				GtkToggleButton* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				NibblesGame* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				_tmp13_ = button;
				_tmp14_ = gtk_button_get_label ((GtkButton*) _tmp13_);
				_tmp15_ = g_strdup (_tmp14_);
				label = _tmp15_;
				_tmp16_ = self->priv->game;
				_tmp17_ = label;
				_tmp18_ = string_replace (_tmp17_, "_", "");
				_tmp19_ = _tmp18_;
				_tmp20_ = atoi (_tmp19_);
				nibbles_game_set_numhumans (_tmp16_, _tmp20_);
				_g_free0 (_tmp19_);
				_g_free0 (label);
			}
			_g_object_unref0 (button);
		}
		_g_object_unref0 (_button_list);
	}
	_tmp21_ = self->priv->game;
	nibbles_game_create_worms (_tmp21_);
	_tmp22_ = self->priv->game;
	_tmp23_ = self->priv->worm_settings;
	nibbles_game_load_worm_properties (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->grids_box;
	_tmp25_ = gtk_container_get_children ((GtkContainer*) _tmp24_);
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
		grid_collection = _tmp25_;
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
			GtkWidget* grid = NULL;
			grid = (GtkWidget*) grid_it->data;
			{
				GtkWidget* _tmp26_ = NULL;
				_tmp26_ = grid;
				gtk_widget_destroy (_tmp26_);
			}
		}
		_g_list_free0 (grid_collection);
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp27_ = NULL;
		GeeLinkedList* _tmp28_ = NULL;
		GeeLinkedList* _tmp29_ = NULL;
		GeeLinkedList* _tmp30_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _worm_index = 0;
		_tmp27_ = self->priv->game;
		_tmp28_ = nibbles_game_get_worms (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_worm_list = _tmp30_;
		_tmp31_ = _worm_list;
		_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_worm_size = _tmp33_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gpointer _tmp39_ = NULL;
			Worm* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			_tmp34_ = _worm_index;
			_worm_index = _tmp34_ + 1;
			_tmp35_ = _worm_index;
			_tmp36_ = _worm_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _worm_list;
			_tmp38_ = _worm_index;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
			worm = (Worm*) _tmp39_;
			_tmp40_ = worm;
			_tmp41_ = _tmp40_->is_human;
			if (_tmp41_) {
				ControlsGrid* grid = NULL;
				Worm* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				NibblesGame* _tmp45_ = NULL;
				GeeHashMap* _tmp46_ = NULL;
				GeeHashMap* _tmp47_ = NULL;
				Worm* _tmp48_ = NULL;
				gpointer _tmp49_ = NULL;
				WormProperties* _tmp50_ = NULL;
				GdkPixbuf* _tmp51_ = NULL;
				GdkPixbuf* _tmp52_ = NULL;
				WormProperties _tmp53_ = {0};
				ControlsGrid* _tmp54_ = NULL;
				ControlsGrid* _tmp55_ = NULL;
				GtkBox* _tmp56_ = NULL;
				ControlsGrid* _tmp57_ = NULL;
				_tmp42_ = worm;
				_tmp43_ = worm_get_id (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = self->priv->game;
				_tmp46_ = nibbles_game_get_worm_props (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = worm;
				_tmp49_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp47_, _tmp48_);
				_tmp50_ = (WormProperties*) _tmp49_;
				_tmp51_ = self->priv->arrow_pixbuf;
				_tmp52_ = self->priv->arrow_key_pixbuf;
				_tmp53_ = *_tmp50_;
				_tmp54_ = controls_grid_new (_tmp44_, &_tmp53_, _tmp51_, _tmp52_);
				g_object_ref_sink (_tmp54_);
				_tmp55_ = _tmp54_;
				_worm_properties_free0 (_tmp50_);
				grid = _tmp55_;
				_tmp56_ = self->priv->grids_box;
				_tmp57_ = grid;
				gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
				_g_object_unref0 (grid);
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp58_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp58_, "controls");
}


static void nibbles_show_game_view (Nibbles* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GtkHeaderBar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkStack* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->pause_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->headerbar;
	_tmp4_ = _ ("Level %d");
	_tmp5_ = self->priv->game;
	_tmp6_ = nibbles_game_get_current_level (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_header_bar_set_title (_tmp3_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp10_, "game_box");
}


static void nibbles_back_cb (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	gchar* child_name = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	GtkStack* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	child_name = _tmp3_;
	_tmp4_ = child_name;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp8_ = NULL;
				_tmp8_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_new_game_cb (self);
				break;
			}
		}
	}
	_tmp9_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_g_free0 (child_name);
}


static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp1_ = button;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	if (!_tmp2_) {
		GtkToggleButton* _tmp3_ = NULL;
		GtkStyleContext* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = button;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		_tmp5_ = gtk_style_context_has_class (_tmp4_, "suggested-action");
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkToggleButton* _tmp6_ = NULL;
		_tmp6_ = button;
		gtk_toggle_button_set_active (_tmp6_, TRUE);
	} else {
		gboolean _tmp7_ = FALSE;
		GtkToggleButton* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = button;
		_tmp9_ = gtk_toggle_button_get_active (_tmp8_);
		if (_tmp9_) {
			GtkToggleButton* _tmp10_ = NULL;
			GtkStyleContext* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp10_ = button;
			_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
			_tmp12_ = gtk_style_context_has_class (_tmp11_, "suggested-action");
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkRevealer* _tmp13_ = NULL;
			GtkToggleButton* _tmp14_ = NULL;
			GtkStyleContext* _tmp15_ = NULL;
			_tmp13_ = self->priv->next_button_revealer;
			gtk_revealer_set_reveal_child (_tmp13_, TRUE);
			_tmp14_ = button;
			_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
			gtk_style_context_add_class (_tmp15_, "suggested-action");
			{
				GeeLinkedList* _other_button_list = NULL;
				GeeLinkedList* _tmp16_ = NULL;
				GeeLinkedList* _tmp17_ = NULL;
				gint _other_button_size = 0;
				GeeLinkedList* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _other_button_index = 0;
				_tmp16_ = self->priv->number_of_players_buttons;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_other_button_list = _tmp17_;
				_tmp18_ = _other_button_list;
				_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_other_button_size = _tmp20_;
				_other_button_index = -1;
				while (TRUE) {
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					GtkToggleButton* other_button = NULL;
					GeeLinkedList* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gpointer _tmp26_ = NULL;
					GtkToggleButton* _tmp27_ = NULL;
					GtkToggleButton* _tmp28_ = NULL;
					_tmp21_ = _other_button_index;
					_other_button_index = _tmp21_ + 1;
					_tmp22_ = _other_button_index;
					_tmp23_ = _other_button_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _other_button_list;
					_tmp25_ = _other_button_index;
					_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp25_);
					other_button = (GtkToggleButton*) _tmp26_;
					_tmp27_ = button;
					_tmp28_ = other_button;
					if (_tmp27_ != _tmp28_) {
						GtkToggleButton* _tmp29_ = NULL;
						gboolean _tmp30_ = FALSE;
						_tmp29_ = other_button;
						_tmp30_ = gtk_toggle_button_get_active (_tmp29_);
						if (_tmp30_) {
							GtkToggleButton* _tmp31_ = NULL;
							GtkStyleContext* _tmp32_ = NULL;
							GtkToggleButton* _tmp33_ = NULL;
							_tmp31_ = other_button;
							_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
							gtk_style_context_remove_class (_tmp32_, "suggested-action");
							_tmp33_ = other_button;
							gtk_toggle_button_set_active (_tmp33_, FALSE);
							_g_object_unref0 (other_button);
							break;
						}
					}
					_g_object_unref0 (other_button);
				}
				_g_object_unref0 (_other_button_list);
			}
		}
	}
}


static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _cat_index = 0;
		_tmp0_ = self->priv->scorecats;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_cat_list = _tmp1_;
		_tmp2_ = _cat_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_cat_size = _tmp4_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GamesScoresCategory* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp5_ = _cat_index;
			_cat_index = _tmp5_ + 1;
			_tmp6_ = _cat_index;
			_tmp7_ = _cat_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cat_list;
			_tmp9_ = _cat_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			cat = (GamesScoresCategory*) _tmp10_;
			_tmp11_ = key;
			_tmp12_ = cat;
			_tmp13_ = games_scores_category_get_key (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp11_, _tmp14_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	g_assert_not_reached ();
}


static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
	return result;
}


static void nibbles_create_scores (Nibbles* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GamesScoresCategory* _tmp2_ = NULL;
	GamesScoresCategory* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	GamesScoresCategory* _tmp5_ = NULL;
	GamesScoresCategory* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GamesScoresCategory* _tmp8_ = NULL;
	GamesScoresCategory* _tmp9_ = NULL;
	GeeLinkedList* _tmp10_ = NULL;
	GamesScoresCategory* _tmp11_ = NULL;
	GamesScoresCategory* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GamesScoresCategory* _tmp14_ = NULL;
	GamesScoresCategory* _tmp15_ = NULL;
	GeeLinkedList* _tmp16_ = NULL;
	GamesScoresCategory* _tmp17_ = NULL;
	GamesScoresCategory* _tmp18_ = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	GamesScoresCategory* _tmp20_ = NULL;
	GamesScoresCategory* _tmp21_ = NULL;
	GeeLinkedList* _tmp22_ = NULL;
	GamesScoresCategory* _tmp23_ = NULL;
	GamesScoresCategory* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkApplicationWindow* _tmp26_ = NULL;
	GamesScoresContext* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scorecats);
	self->priv->scorecats = _tmp0_;
	_tmp1_ = self->priv->scorecats;
	_tmp2_ = games_scores_category_new ("beginner", "Beginner");
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->scorecats;
	_tmp5_ = games_scores_category_new ("slow", "Slow");
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->scorecats;
	_tmp8_ = games_scores_category_new ("medium", "Medium");
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->scorecats;
	_tmp11_ = games_scores_category_new ("fast", "Fast");
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->scorecats;
	_tmp14_ = games_scores_category_new ("beginner-fakes", "Beginner with Fakes");
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->scorecats;
	_tmp17_ = games_scores_category_new ("slow-fakes", "Slow with Fakes");
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->scorecats;
	_tmp20_ = games_scores_category_new ("medium-fakes", "Medium with Fakes");
	_tmp21_ = _tmp20_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->scorecats;
	_tmp23_ = games_scores_category_new ("fast-fakes", "Fast with Fakes");
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = _ ("Difficulty Level:");
	_tmp26_ = self->priv->window;
	_tmp27_ = games_scores_context_new ("gnome-nibbles", _tmp25_, (GtkWindow*) _tmp26_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_PLAIN_DESCENDING);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp27_;
}


static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes) {
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp5_ = FALSE;
	GeeLinkedList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	key = NULL;
	_tmp0_ = speed;
	switch (_tmp0_) {
		case 1:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("fast");
			_g_free0 (key);
			key = _tmp1_;
			break;
		}
		case 2:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("medium");
			_g_free0 (key);
			key = _tmp2_;
			break;
		}
		case 3:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("slow");
			_g_free0 (key);
			key = _tmp3_;
			break;
		}
		case 4:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("beginner");
			_g_free0 (key);
			key = _tmp4_;
			break;
		}
		default:
		break;
	}
	_tmp5_ = fakes;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = key;
		_tmp7_ = g_strconcat (_tmp6_, "-fakes", NULL);
		_g_free0 (key);
		key = _tmp7_;
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _cat_index = 0;
		_tmp8_ = self->priv->scorecats;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_cat_list = _tmp9_;
		_tmp10_ = _cat_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_cat_size = _tmp12_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GamesScoresCategory* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			_tmp13_ = _cat_index;
			_cat_index = _tmp13_ + 1;
			_tmp14_ = _cat_index;
			_tmp15_ = _cat_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _cat_list;
			_tmp17_ = _cat_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			cat = (GamesScoresCategory*) _tmp18_;
			_tmp19_ = key;
			_tmp20_ = cat;
			_tmp21_ = games_scores_category_get_key (_tmp20_);
			_tmp22_ = _tmp21_;
			if (g_strcmp0 (_tmp19_, _tmp22_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				_g_free0 (key);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	_tmp23_ = self->priv->scorecats;
	_tmp24_ = gee_linked_list_first (_tmp23_);
	result = (GamesScoresCategory*) _tmp24_;
	_g_free0 (key);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Nibbles* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda7_ (Block3Data* _data3_, GObject* object, GAsyncResult* _result_) {
	Nibbles* self;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp6_ = NULL;
	NibblesGame* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	NibblesGame* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GamesScoresCategory* _tmp13_ = NULL;
	GamesScoresCategory* _tmp14_ = NULL;
	GeeList* _tmp15_ = NULL;
	GeeList* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GeeList* _tmp18_ = NULL;
	gpointer _tmp19_ = NULL;
	GamesScoresScore* _tmp20_ = NULL;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (_result_ != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GamesScoresContext* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->scores_context;
		_tmp2_ = _result_;
		_tmp3_ = games_scores_context_add_score_finish (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		if (_tmp0_) {
			return;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("gnome-nibbles.vala:623: Failed to add score: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->scores_context;
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_speed (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->game;
	_tmp11_ = nibbles_game_get_fakes (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = nibbles_get_scores_category (self, _tmp9_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = games_scores_context_get_high_scores (_tmp6_, _tmp14_, 10);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	scores = _tmp16_;
	_tmp17_ = _data3_->score;
	_tmp18_ = scores;
	_tmp19_ = gee_list_last (_tmp18_);
	_tmp20_ = (GamesScoresScore*) _tmp19_;
	_tmp21_ = games_scores_score_get_score (_tmp20_);
	_tmp22_ = _tmp21_;
	nibbles_game_over (self, _tmp17_, _tmp22_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (scores);
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ (self, source_object, res);
	block3_data_unref (self);
}


static void nibbles_log_score_cb (Nibbles* self, gint score) {
	Block3Data* _data3_;
	gint _tmp0_ = 0;
	NibblesGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	NibblesGame* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GamesScoresContext* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	NibblesGame* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	NibblesGame* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GamesScoresCategory* _tmp16_ = NULL;
	GamesScoresCategory* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = score;
	_data3_->score = _tmp0_;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_numhumans (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 1) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_game_get_start_level (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != 1) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp7_ = _data3_->score;
	if (_tmp7_ <= 0) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp8_ = self->priv->scores_context;
	_tmp9_ = _data3_->score;
	_tmp10_ = self->priv->game;
	_tmp11_ = nibbles_game_get_speed (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->game;
	_tmp14_ = nibbles_game_get_fakes (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = nibbles_get_scores_category (self, _tmp12_, _tmp15_);
	_tmp17_ = _tmp16_;
	games_scores_context_add_score (_tmp8_, (glong) _tmp9_, _tmp17_, NULL, ___lambda7__gasync_ready_callback, block3_data_ref (_data3_));
	_g_object_unref0 (_tmp17_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void nibbles_scores_cb (Nibbles* self) {
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GamesScoresContext* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_ = NULL;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		should_unpause = TRUE;
	}
	_tmp4_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp4_);
	_tmp5_ = should_unpause;
	if (_tmp5_) {
		GSimpleAction* _tmp6_ = NULL;
		_tmp6_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp6_, "activate", NULL);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Nibbles* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->button);
		_g_object_unref0 (_data4_->label);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda9_ (Block4Data* _data4_) {
	Nibbles* self;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	self = _data4_->self;
	gtk_widget_destroy ((GtkWidget*) _data4_->label);
	gtk_widget_destroy ((GtkWidget*) _data4_->button);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->headerbar;
	_tmp3_ = _ ("Level %d");
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_game_get_current_level (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (_tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_header_bar_set_title (_tmp2_, _tmp8_);
	_g_free0 (_tmp8_);
	nibbles_restart_game (self);
}


static void ___lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda9_ (self);
}


static gboolean __lambda10_ (Block4Data* _data4_) {
	Nibbles* self;
	gboolean result = FALSE;
	self = _data4_->self;
	gtk_widget_show ((GtkWidget*) _data4_->button);
	gtk_widget_grab_focus ((GtkWidget*) _data4_->button);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ (self);
	return result;
}


static void nibbles_level_completed_cb (Nibbles* self) {
	Block4Data* _data4_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	NibblesGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GtkOverlay* _tmp14_ = NULL;
	GtkOverlay* _tmp15_ = NULL;
	GtkOverlay* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = _ ("Level %d Completed!");
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_data4_->label = _tmp9_;
	gtk_widget_set_halign ((GtkWidget*) _data4_->label, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data4_->label, GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _data4_->label, 150);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _data4_->label);
	gtk_style_context_add_class (_tmp10_, "menu-title");
	gtk_widget_show ((GtkWidget*) _data4_->label);
	_tmp11_ = _ ("_Next Level");
	_tmp12_ = (GtkButton*) gtk_button_new_with_label (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_data4_->button = _tmp12_;
	gtk_button_set_use_underline (_data4_->button, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _data4_->button, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data4_->button, GTK_ALIGN_END);
	gtk_widget_set_margin_bottom ((GtkWidget*) _data4_->button, 100);
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _data4_->button);
	gtk_style_context_add_class (_tmp13_, "suggested-action");
	g_signal_connect_data (_data4_->button, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp14_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp14_, (GtkWidget*) _data4_->label);
	_tmp15_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp15_, (GtkWidget*) _data4_->button);
	_tmp16_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp16_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda10__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Nibbles* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->button);
		_g_object_unref0 (_data5_->points_left_label);
		_g_object_unref0 (_data5_->score_label);
		_g_object_unref0 (_data5_->game_over_label);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda8_ (Block5Data* _data5_) {
	Nibbles* self;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	self = _data5_->self;
	gtk_widget_destroy ((GtkWidget*) _data5_->game_over_label);
	gtk_widget_destroy ((GtkWidget*) _data5_->score_label);
	gtk_widget_destroy ((GtkWidget*) _data5_->points_left_label);
	gtk_widget_destroy ((GtkWidget*) _data5_->button);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	nibbles_show_new_game_screen_cb (self);
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ (self);
}


static void nibbles_game_over (Nibbles* self, gint score, glong last_score) {
	Block5Data* _data5_;
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkStyleContext* _tmp5_ = NULL;
	gchar* score_string = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	glong points_left = 0L;
	glong _tmp22_ = 0L;
	gint _tmp23_ = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkStyleContext* _tmp32_ = NULL;
	GtkOverlay* _tmp33_ = NULL;
	GtkOverlay* _tmp34_ = NULL;
	GtkOverlay* _tmp35_ = NULL;
	GtkOverlay* _tmp36_ = NULL;
	GtkOverlay* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = _ ("Game Over!");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_data5_->game_over_label = _tmp3_;
	gtk_widget_set_halign ((GtkWidget*) _data5_->game_over_label, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data5_->game_over_label, GTK_ALIGN_START);
	_tmp4_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _data5_->game_over_label, _tmp4_ / 3);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _data5_->game_over_label);
	gtk_style_context_add_class (_tmp5_, "menu-title");
	gtk_widget_show ((GtkWidget*) _data5_->game_over_label);
	_tmp6_ = score;
	_tmp7_ = g_strdup_printf ("%d Point", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = score;
	_tmp10_ = g_strdup_printf ("%d Points", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = score;
	_tmp13_ = ngettext (_tmp8_, _tmp11_, (gulong) _tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	score_string = _tmp15_;
	_tmp16_ = string_to_string (score_string);
	_tmp17_ = g_strconcat ("<b>", _tmp16_, "</b>", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_data5_->score_label = _tmp20_;
	gtk_label_set_use_markup (_data5_->score_label, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _data5_->score_label, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data5_->score_label, GTK_ALIGN_START);
	_tmp21_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _data5_->score_label, (_tmp21_ / 3) + 80);
	gtk_widget_show ((GtkWidget*) _data5_->score_label);
	_tmp22_ = last_score;
	_tmp23_ = score;
	points_left = _tmp22_ - _tmp23_;
	_tmp24_ = _ ("(%d more points to reach the leaderboard)");
	_tmp25_ = g_strdup_printf (_tmp24_, points_left);
	_tmp26_ = _tmp25_;
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_data5_->points_left_label = _tmp28_;
	gtk_widget_set_halign ((GtkWidget*) _data5_->points_left_label, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data5_->points_left_label, GTK_ALIGN_START);
	_tmp29_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _data5_->points_left_label, (_tmp29_ / 3) + 100);
	gtk_widget_show ((GtkWidget*) _data5_->points_left_label);
	_tmp30_ = _ ("_Play Again");
	_tmp31_ = (GtkButton*) gtk_button_new_with_label (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_data5_->button = _tmp31_;
	gtk_button_set_use_underline (_data5_->button, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _data5_->button, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data5_->button, GTK_ALIGN_END);
	gtk_widget_set_margin_bottom ((GtkWidget*) _data5_->button, 100);
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _data5_->button);
	gtk_style_context_add_class (_tmp32_, "suggested-action");
	g_signal_connect_data (_data5_->button, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data5_->button);
	_tmp33_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp33_, (GtkWidget*) _data5_->game_over_label);
	_tmp34_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp34_, (GtkWidget*) _data5_->score_label);
	_tmp35_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp35_, (GtkWidget*) _data5_->points_left_label);
	_tmp36_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp36_, (GtkWidget*) _data5_->button);
	gtk_widget_grab_focus ((GtkWidget*) _data5_->button);
	_tmp37_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp37_);
	_g_free0 (score_string);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void nibbles_about_cb (Nibbles* self) {
	static const gchar* authors[] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
	static const gchar* documenters[] = {"Kevin Breit", NULL};
	static const gchar* artists[] = {"Allan Day", NULL};
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Nibbles");
	_tmp2_ = _ ("A worm game for GNOME");
	_tmp3_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _tmp2_, "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _tmp3_, "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
}


gint nibbles_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	const gchar* _tmp9_ = NULL;
	Nibbles* _tmp19_ = NULL;
	Nibbles* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (_tmp1_, _tmp2_);
	_tmp3_ = context;
	_tmp4_ = clutter_get_option_group_without_init ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = _ ("Nibbles");
	g_set_application_name (_tmp9_);
	gtk_window_set_default_icon_name ("gnome-nibbles");
	{
		GOptionEntry* _tmp10_ = NULL;
		GOptionEntry* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp10_ = g_new0 (GOptionEntry, 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp11_, NULL, &_inner_error_);
		_tmp11_ = (g_free (_tmp11_), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		GtkMessageDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_ = NULL;
		GtkMessageDialog* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp13_);
		g_object_ref_sink (_tmp14_);
		dialog = _tmp14_;
		_tmp15_ = dialog;
		_tmp16_ = g_get_application_name ();
		gtk_window_set_title ((GtkWindow*) _tmp15_, _tmp16_);
		_tmp17_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp17_);
		_tmp18_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp18_);
		result = EXIT_FAILURE;
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp19_ = nibbles_new ();
	_tmp20_ = _tmp19_;
	_tmp21_ = args;
	_tmp21__length1 = args_length1;
	_tmp22_ = g_application_run ((GApplication*) _tmp20_, _tmp21__length1, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp20_);
	result = _tmp23_;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return nibbles_main (argv, argc);
}


static void nibbles_class_init (NibblesClass * klass) {
	nibbles_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesPrivate));
	((GApplicationClass *) klass)->handle_local_options = nibbles_real_handle_local_options;
	((GApplicationClass *) klass)->startup = nibbles_real_startup;
	((GApplicationClass *) klass)->activate = nibbles_real_activate;
	((GApplicationClass *) klass)->shutdown = nibbles_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
}


static void nibbles_instance_init (Nibbles * self) {
	self->priv = NIBBLES_GET_PRIVATE (self);
	self->priv->game = NULL;
	self->priv->countdown_id = (guint) 0;
}


static void nibbles_finalize (GObject* obj) {
	Nibbles * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	_g_object_unref0 (self->priv->next_button_revealer);
	_g_object_unref0 (self->priv->grids_box);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	_g_object_unref0 (self->priv->statusbar_stack);
	_g_object_unref0 (self->priv->countdown);
	_g_object_unref0 (self->priv->scoreboard);
	_g_object_unref0 (self->priv->scoreboard_life);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->scorecats);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->back_action);
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
}


GType nibbles_get_type (void) {
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}


Scoreboard* scoreboard_construct (GType object_type) {
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (Scoreboard*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->boxes);
	self->priv->boxes = _tmp0_;
	return self;
}


Scoreboard* scoreboard_new (void) {
	return scoreboard_construct (TYPE_SCOREBOARD);
}


void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf) {
	PangoColor color = {0};
	const gchar* _tmp0_ = NULL;
	PlayerScoreBox* box = NULL;
	Worm* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	PangoColor _tmp8_ = {0};
	Worm* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Worm* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkPixbuf* _tmp15_ = NULL;
	PlayerScoreBox* _tmp16_ = NULL;
	PlayerScoreBox* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	Worm* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	g_return_if_fail (color_name != NULL);
	g_return_if_fail (life_pixbuf != NULL);
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = color_name;
	pango_color_parse (&color, _tmp0_);
	_tmp1_ = worm;
	_tmp2_ = worm_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_ + 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Worm ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = color;
	_tmp9_ = worm;
	_tmp10_ = worm_get_score (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = worm;
	_tmp13_ = worm_get_lives (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = life_pixbuf;
	_tmp16_ = player_score_box_new (_tmp7_, &_tmp8_, _tmp11_, _tmp14_, _tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	box = _tmp17_;
	_tmp18_ = self->priv->boxes;
	_tmp19_ = worm;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, box, _tmp19_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
}


void scoreboard_update (Scoreboard* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			Worm* worm = NULL;
			GeeMapEntry* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			PlayerScoreBox* _tmp18_ = NULL;
			Worm* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Worm* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
			box = _tmp13_;
			_tmp14_ = entry;
			_tmp15_ = gee_map_entry_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 ((Worm*) _tmp16_);
			worm = _tmp17_;
			_tmp18_ = box;
			_tmp19_ = worm;
			_tmp20_ = worm_get_score (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = worm;
			_tmp23_ = worm_get_lives (_tmp22_);
			_tmp24_ = _tmp23_;
			player_score_box_update (_tmp18_, _tmp21_, _tmp24_);
			_g_object_unref0 (worm);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


void scoreboard_clear (Scoreboard* self) {
	GeeHashMap* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			PlayerScoreBox* _tmp14_ = NULL;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
			box = _tmp13_;
			_tmp14_ = box;
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp15_ = self->priv->boxes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp15_);
}


static void scoreboard_class_init (ScoreboardClass * klass) {
	gint Scoreboard_private_offset;
	scoreboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreboardPrivate));
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
	Scoreboard_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
}


static void scoreboard_instance_init (Scoreboard * self) {
	self->priv = SCOREBOARD_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void scoreboard_finalize (GObject* obj) {
	Scoreboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
	_g_object_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
}


GType scoreboard_get_type (void) {
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}


PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GeeLinkedList* _tmp16_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = pango_color_to_string (color);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "</span>", NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (_tmp0_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp12_ = self->priv->score_label;
	_tmp13_ = score;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->life_images);
	self->priv->life_images = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_ = 0;
				GtkImage* life = NULL;
				GdkPixbuf* _tmp20_ = NULL;
				GtkImage* _tmp21_ = NULL;
				GtkImage* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				GeeLinkedList* _tmp25_ = NULL;
				GtkImage* _tmp26_ = NULL;
				GtkGrid* _tmp27_ = NULL;
				GtkImage* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				if (!(_tmp19_ < WORM_MAX_LIVES)) {
					break;
				}
				_tmp20_ = life_pixbuf;
				_tmp21_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp20_);
				g_object_ref_sink (_tmp21_);
				life = _tmp21_;
				_tmp22_ = life;
				gtk_widget_show ((GtkWidget*) _tmp22_);
				_tmp23_ = i;
				if (_tmp23_ >= WORM_STARTING_LIVES) {
					GtkImage* _tmp24_ = NULL;
					_tmp24_ = life;
					gtk_widget_set_opacity ((GtkWidget*) _tmp24_, (gdouble) 0);
				}
				_tmp25_ = self->priv->life_images;
				_tmp26_ = life;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				_tmp27_ = self->priv->lives_grid;
				_tmp28_ = life;
				_tmp29_ = i;
				_tmp30_ = i;
				gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, _tmp29_ % 6, _tmp30_ / 6, 1, 1);
				_g_object_unref0 (life);
			}
		}
	}
	return self;
}


PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
}


void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = score;
	player_score_box_update_score (self, _tmp0_);
	_tmp1_ = lives_left;
	player_score_box_update_lives (self, _tmp1_);
}


void player_score_box_update_score (PlayerScoreBox* self, gint score) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_label;
	_tmp1_ = score;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GeeLinkedList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp0_ = self->priv->life_images;
		_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeLinkedList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				GtkImage* _tmp10_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = lives_left;
				if (!(_tmp5_ >= _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->life_images;
				_tmp8_ = i;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
				_tmp10_ = (GtkImage*) _tmp9_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp10_, (gdouble) 0);
				_g_object_unref0 (_tmp10_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GeeLinkedList* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gpointer _tmp17_ = NULL;
				GtkImage* _tmp18_ = NULL;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = lives_left;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = self->priv->life_images;
				_tmp16_ = i;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
				_tmp18_ = (GtkImage*) _tmp17_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 1);
				_g_object_unref0 (_tmp18_);
			}
		}
	}
}


static void player_score_box_class_init (PlayerScoreBoxClass * klass) {
	gint PlayerScoreBox_private_offset;
	player_score_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlayerScoreBoxPrivate));
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
	PlayerScoreBox_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
}


static void player_score_box_instance_init (PlayerScoreBox * self) {
	self->priv = PLAYER_SCORE_BOX_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void player_score_box_finalize (GObject* obj) {
	PlayerScoreBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->score_label);
	_g_object_unref0 (self->priv->lives_grid);
	_g_object_unref0 (self->priv->life_images);
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
}


GType player_score_box_get_type (void) {
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}


ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_ = {0};
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* player_id = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	GtkImage* _tmp23_ = NULL;
	GdkPixbuf* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_ = NULL;
	GtkImage* _tmp27_ = NULL;
	GdkPixbuf* _tmp28_ = NULL;
	GdkPixbuf* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	gchar* upper_key = NULL;
	WormProperties _tmp31_ = {0};
	guint _tmp32_ = 0U;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	WormProperties _tmp48_ = {0};
	guint _tmp49_ = 0U;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	WormProperties _tmp65_ = {0};
	guint _tmp66_ = 0U;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	WormProperties _tmp82_ = {0};
	guint _tmp83_ = 0U;
	const gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	g_return_val_if_fail (worm_props != NULL, NULL);
	g_return_val_if_fail (arrow != NULL, NULL);
	g_return_val_if_fail (arrow_key != NULL, NULL);
	self = (ControlsGrid*) g_object_new (object_type, NULL);
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = *worm_props;
	_tmp1_ = _tmp0_.color;
	_tmp2_ = nibbles_view_colorval_name (_tmp1_);
	_tmp3_ = _tmp2_;
	pango_color_parse (&color, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = _ ("Player %d");
	_tmp5_ = worm_id;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_ + 1);
	player_id = _tmp6_;
	_tmp7_ = self->priv->name_label;
	_tmp8_ = pango_color_to_string (&color);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = player_id;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp10_, "\">", _tmp12_, "</span></b>", NULL);
	_tmp14_ = _tmp13_;
	gtk_label_set_markup (_tmp7_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp9_);
	_tmp15_ = self->priv->arrow_up;
	_tmp16_ = arrow;
	_tmp17_ = gdk_pixbuf_rotate_simple (_tmp16_, GDK_PIXBUF_ROTATE_NONE);
	_tmp18_ = _tmp17_;
	gtk_image_set_from_pixbuf (_tmp15_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->arrow_down;
	_tmp20_ = arrow;
	_tmp21_ = gdk_pixbuf_rotate_simple (_tmp20_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
	_tmp22_ = _tmp21_;
	gtk_image_set_from_pixbuf (_tmp19_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->arrow_left;
	_tmp24_ = arrow;
	_tmp25_ = gdk_pixbuf_rotate_simple (_tmp24_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
	_tmp26_ = _tmp25_;
	gtk_image_set_from_pixbuf (_tmp23_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->arrow_right;
	_tmp28_ = arrow;
	_tmp29_ = gdk_pixbuf_rotate_simple (_tmp28_, GDK_PIXBUF_ROTATE_CLOCKWISE);
	_tmp30_ = _tmp29_;
	gtk_image_set_from_pixbuf (_tmp27_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = *worm_props;
	_tmp32_ = _tmp31_.up;
	_tmp33_ = gdk_keyval_name (_tmp32_);
	_tmp34_ = g_utf8_strup (_tmp33_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp34_;
	_tmp35_ = upper_key;
	if (g_strcmp0 (_tmp35_, "UP") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		GtkOverlay* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
		GtkImage* _tmp40_ = NULL;
		GtkImage* _tmp41_ = NULL;
		GtkOverlay* _tmp42_ = NULL;
		_tmp36_ = arrow_key;
		_tmp37_ = gdk_pixbuf_rotate_simple (_tmp36_, GDK_PIXBUF_ROTATE_NONE);
		rotated_pixbuf = _tmp37_;
		_tmp38_ = self->priv->move_up;
		_tmp39_ = rotated_pixbuf;
		_tmp40_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp39_);
		g_object_ref_sink (_tmp40_);
		_tmp41_ = _tmp40_;
		gtk_overlay_add_overlay (_tmp38_, (GtkWidget*) _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = self->priv->move_up;
		gtk_widget_show_all ((GtkWidget*) _tmp42_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		_tmp43_ = self->priv->move_up_label;
		_tmp44_ = upper_key;
		_tmp45_ = string_to_string (_tmp44_);
		_tmp46_ = g_strconcat ("<b>", _tmp45_, "</b>", NULL);
		_tmp47_ = _tmp46_;
		gtk_label_set_markup (_tmp43_, _tmp47_);
		_g_free0 (_tmp47_);
	}
	_tmp48_ = *worm_props;
	_tmp49_ = _tmp48_.down;
	_tmp50_ = gdk_keyval_name (_tmp49_);
	_tmp51_ = g_utf8_strup (_tmp50_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp51_;
	_tmp52_ = upper_key;
	if (g_strcmp0 (_tmp52_, "DOWN") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp53_ = NULL;
		GdkPixbuf* _tmp54_ = NULL;
		GtkOverlay* _tmp55_ = NULL;
		GdkPixbuf* _tmp56_ = NULL;
		GtkImage* _tmp57_ = NULL;
		GtkImage* _tmp58_ = NULL;
		GtkOverlay* _tmp59_ = NULL;
		_tmp53_ = arrow_key;
		_tmp54_ = gdk_pixbuf_rotate_simple (_tmp53_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
		rotated_pixbuf = _tmp54_;
		_tmp55_ = self->priv->move_down;
		_tmp56_ = rotated_pixbuf;
		_tmp57_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp56_);
		g_object_ref_sink (_tmp57_);
		_tmp58_ = _tmp57_;
		gtk_overlay_add_overlay (_tmp55_, (GtkWidget*) _tmp58_);
		_g_object_unref0 (_tmp58_);
		_tmp59_ = self->priv->move_down;
		gtk_widget_show_all ((GtkWidget*) _tmp59_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		_tmp60_ = self->priv->move_down_label;
		_tmp61_ = upper_key;
		_tmp62_ = string_to_string (_tmp61_);
		_tmp63_ = g_strconcat ("<b>", _tmp62_, "</b>", NULL);
		_tmp64_ = _tmp63_;
		gtk_label_set_markup (_tmp60_, _tmp64_);
		_g_free0 (_tmp64_);
	}
	_tmp65_ = *worm_props;
	_tmp66_ = _tmp65_.left;
	_tmp67_ = gdk_keyval_name (_tmp66_);
	_tmp68_ = g_utf8_strup (_tmp67_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp68_;
	_tmp69_ = upper_key;
	if (g_strcmp0 (_tmp69_, "LEFT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp70_ = NULL;
		GdkPixbuf* _tmp71_ = NULL;
		GtkOverlay* _tmp72_ = NULL;
		GdkPixbuf* _tmp73_ = NULL;
		GtkImage* _tmp74_ = NULL;
		GtkImage* _tmp75_ = NULL;
		GtkOverlay* _tmp76_ = NULL;
		_tmp70_ = arrow_key;
		_tmp71_ = gdk_pixbuf_rotate_simple (_tmp70_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
		rotated_pixbuf = _tmp71_;
		_tmp72_ = self->priv->move_left;
		_tmp73_ = rotated_pixbuf;
		_tmp74_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp73_);
		g_object_ref_sink (_tmp74_);
		_tmp75_ = _tmp74_;
		gtk_overlay_add_overlay (_tmp72_, (GtkWidget*) _tmp75_);
		_g_object_unref0 (_tmp75_);
		_tmp76_ = self->priv->move_left;
		gtk_widget_show_all ((GtkWidget*) _tmp76_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		const gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		_tmp77_ = self->priv->move_left_label;
		_tmp78_ = upper_key;
		_tmp79_ = string_to_string (_tmp78_);
		_tmp80_ = g_strconcat ("<b>", _tmp79_, "</b>", NULL);
		_tmp81_ = _tmp80_;
		gtk_label_set_markup (_tmp77_, _tmp81_);
		_g_free0 (_tmp81_);
	}
	_tmp82_ = *worm_props;
	_tmp83_ = _tmp82_.right;
	_tmp84_ = gdk_keyval_name (_tmp83_);
	_tmp85_ = g_utf8_strup (_tmp84_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp85_;
	_tmp86_ = upper_key;
	if (g_strcmp0 (_tmp86_, "RIGHT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp87_ = NULL;
		GdkPixbuf* _tmp88_ = NULL;
		GtkOverlay* _tmp89_ = NULL;
		GdkPixbuf* _tmp90_ = NULL;
		GtkImage* _tmp91_ = NULL;
		GtkImage* _tmp92_ = NULL;
		GtkOverlay* _tmp93_ = NULL;
		_tmp87_ = arrow_key;
		_tmp88_ = gdk_pixbuf_rotate_simple (_tmp87_, GDK_PIXBUF_ROTATE_CLOCKWISE);
		rotated_pixbuf = _tmp88_;
		_tmp89_ = self->priv->move_right;
		_tmp90_ = rotated_pixbuf;
		_tmp91_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp90_);
		g_object_ref_sink (_tmp91_);
		_tmp92_ = _tmp91_;
		gtk_overlay_add_overlay (_tmp89_, (GtkWidget*) _tmp92_);
		_g_object_unref0 (_tmp92_);
		_tmp93_ = self->priv->move_right;
		gtk_widget_show_all ((GtkWidget*) _tmp93_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		_tmp94_ = self->priv->move_right_label;
		_tmp95_ = upper_key;
		_tmp96_ = string_to_string (_tmp95_);
		_tmp97_ = g_strconcat ("<b>", _tmp96_, "</b>", NULL);
		_tmp98_ = _tmp97_;
		gtk_label_set_markup (_tmp94_, _tmp98_);
		_g_free0 (_tmp98_);
	}
	_g_free0 (upper_key);
	_g_free0 (player_id);
	return self;
}


ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
}


static void controls_grid_class_init (ControlsGridClass * klass) {
	gint ControlsGrid_private_offset;
	controls_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ControlsGridPrivate));
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
	ControlsGrid_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
}


static void controls_grid_instance_init (ControlsGrid * self) {
	self->priv = CONTROLS_GRID_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void controls_grid_finalize (GObject* obj) {
	ControlsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->arrow_up);
	_g_object_unref0 (self->priv->arrow_down);
	_g_object_unref0 (self->priv->arrow_left);
	_g_object_unref0 (self->priv->arrow_right);
	_g_object_unref0 (self->priv->move_up);
	_g_object_unref0 (self->priv->move_up_label);
	_g_object_unref0 (self->priv->move_down);
	_g_object_unref0 (self->priv->move_down_label);
	_g_object_unref0 (self->priv->move_left);
	_g_object_unref0 (self->priv->move_left_label);
	_g_object_unref0 (self->priv->move_right);
	_g_object_unref0 (self->priv->move_right_label);
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
}


GType controls_grid_get_type (void) {
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



