/* rygel-subtitle-manager.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()
struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_subtitle_manager_parent_class = NULL;
static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;

GQuark subtitle_manager_error_quark (void);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_MANAGER_DUMMY_PROPERTY
};
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitleManager* rygel_subtitle_manager_new (void);
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self, const gchar* uri, GError** error);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type, const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type, const gchar* mime_type, const gchar* caption_type);
static void rygel_subtitle_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark subtitle_manager_error_quark (void) {
	return g_quark_from_static_string ("subtitle_manager_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelSubtitleManager* rygel_subtitle_manager_get_default (void) {
	RygelSubtitleManager* result = NULL;
	RygelSubtitleManager* _tmp0_ = NULL;
	RygelSubtitleManager* _tmp2_ = NULL;
	RygelSubtitleManager* _tmp3_ = NULL;
	_tmp0_ = rygel_subtitle_manager_manager;
	if (_tmp0_ == NULL) {
		RygelSubtitleManager* _tmp1_ = NULL;
		_tmp1_ = rygel_subtitle_manager_new ();
		_g_object_unref0 (rygel_subtitle_manager_manager);
		rygel_subtitle_manager_manager = _tmp1_;
	}
	_tmp2_ = rygel_subtitle_manager_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


GeeArrayList* rygel_subtitle_manager_get_subtitles (RygelSubtitleManager* self, const gchar* uri, GError** error) {
	GeeArrayList* result = NULL;
	GFile* video_file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* directory = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* basename = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint ext_index = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar** exts = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint exts_length1 = 0;
	gint _exts_size_ = 0;
	GeeArrayList* subtitles = NULL;
	GeeArrayList* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GeeArrayList* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	video_file = _tmp1_;
	_tmp2_ = video_file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	directory = _tmp3_;
	_tmp4_ = video_file;
	_tmp5_ = g_file_get_basename (_tmp4_);
	basename = _tmp5_;
	_tmp6_ = basename;
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
	ext_index = _tmp7_;
	_tmp8_ = ext_index;
	if (_tmp8_ >= 0) {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		_tmp9_ = basename;
		_tmp10_ = ext_index;
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
		_g_free0 (basename);
		basename = _tmp11_;
	}
	_tmp12_ = g_strdup ("srt");
	_tmp13_ = g_strdup ("smi");
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	exts = _tmp14_;
	exts_length1 = 2;
	_exts_size_ = exts_length1;
	_tmp15_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL, NULL, NULL);
	subtitles = _tmp15_;
	_tmp16_ = exts;
	_tmp16__length1 = exts_length1;
	{
		gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = _tmp16_;
		ext_collection_length1 = _tmp16__length1;
		for (ext_it = 0; ext_it < _tmp16__length1; ext_it = ext_it + 1) {
			gchar* _tmp17_ = NULL;
			gchar* ext = NULL;
			_tmp17_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp17_;
			{
				gchar* filename = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				GFile* subtitle_file = NULL;
				GFile* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				GFile* _tmp26_ = NULL;
				_tmp18_ = basename;
				_tmp19_ = g_strconcat (_tmp18_, ".", NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = ext;
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp20_);
				filename = _tmp23_;
				_tmp24_ = directory;
				_tmp25_ = filename;
				_tmp26_ = g_file_get_child (_tmp24_, _tmp25_);
				subtitle_file = _tmp26_;
				{
					gchar* attribs = NULL;
					gchar* _tmp27_ = NULL;
					GFileInfo* info = NULL;
					GFile* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					GFileInfo* _tmp30_ = NULL;
					GFileInfo* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					_tmp27_ = g_strdup (G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
					attribs = _tmp27_;
					_tmp28_ = subtitle_file;
					_tmp29_ = attribs;
					_tmp30_ = g_file_query_info (_tmp28_, _tmp29_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
					info = _tmp30_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (attribs);
						goto __catch75_g_error;
					}
					_tmp31_ = info;
					_tmp32_ = g_file_info_get_attribute_boolean (_tmp31_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
					if (_tmp32_) {
						gchar* content_type = NULL;
						GFileInfo* _tmp33_ = NULL;
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						RygelSubtitle* subtitle = NULL;
						const gchar* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
						RygelSubtitle* _tmp38_ = NULL;
						RygelSubtitle* _tmp39_ = NULL;
						GFile* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						RygelSubtitle* _tmp42_ = NULL;
						GFileInfo* _tmp43_ = NULL;
						guint64 _tmp44_ = 0ULL;
						GeeArrayList* _tmp45_ = NULL;
						RygelSubtitle* _tmp46_ = NULL;
						_tmp33_ = info;
						_tmp34_ = g_file_info_get_attribute_string (_tmp33_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
						_tmp35_ = g_strdup (_tmp34_);
						content_type = _tmp35_;
						_tmp36_ = content_type;
						_tmp37_ = ext;
						_tmp38_ = rygel_subtitle_new (_tmp36_, _tmp37_);
						subtitle = _tmp38_;
						_tmp39_ = subtitle;
						_tmp40_ = subtitle_file;
						_tmp41_ = g_file_get_uri (_tmp40_);
						_g_free0 (_tmp39_->uri);
						_tmp39_->uri = _tmp41_;
						_tmp42_ = subtitle;
						_tmp43_ = info;
						_tmp44_ = g_file_info_get_attribute_uint64 (_tmp43_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
						_tmp42_->size = (gint64) _tmp44_;
						_tmp45_ = subtitles;
						_tmp46_ = subtitle;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
						_rygel_subtitle_unref0 (subtitle);
						_g_free0 (content_type);
					}
					_g_object_unref0 (info);
					_g_free0 (attribs);
				}
				goto __finally75;
				__catch75_g_error:
				{
					GError* err = NULL;
					GFile* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					GError* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp47_ = subtitle_file;
					_tmp48_ = g_file_get_path (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = err;
					_tmp51_ = _tmp50_->message;
					g_debug ("rygel-subtitle-manager.vala:84: Failed to query file information for %" \
"s: %s", _tmp49_, _tmp51_);
					_g_free0 (_tmp49_);
					_g_error_free0 (err);
				}
				__finally75:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (subtitle_file);
					_g_free0 (filename);
					_g_free0 (ext);
					_g_object_unref0 (subtitles);
					exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (basename);
					_g_object_unref0 (directory);
					_g_object_unref0 (video_file);
					return NULL;
				}
				_g_object_unref0 (subtitle_file);
				_g_free0 (filename);
				_g_free0 (ext);
			}
		}
	}
	_tmp52_ = subtitles;
	_tmp53_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp52_);
	_tmp54_ = _tmp53_;
	if (_tmp54_ == 0) {
		const gchar* _tmp55_ = NULL;
		GError* _tmp56_ = NULL;
		_tmp55_ = _ ("No subtitle available");
		_tmp56_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _tmp55_);
		_inner_error_ = _tmp56_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (subtitles);
		exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (basename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	result = subtitles;
	exts = (_vala_array_free (exts, exts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
	return result;
}


RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type) {
	RygelSubtitleManager * self = NULL;
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitleManager* rygel_subtitle_manager_new (void) {
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
}


static void rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass) {
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}


static void rygel_subtitle_manager_instance_init (RygelSubtitleManager * self) {
}


static void rygel_subtitle_manager_finalize (GObject* obj) {
	RygelSubtitleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}


/**
 * Provides subtitles for videos.
 */
GType rygel_subtitle_manager_get_type (void) {
	static volatile gsize rygel_subtitle_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_manager_type_id__volatile, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



