/* rygel-media-player.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-media-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
	gchar* (*get_user_agent) (RygelMediaPlayer* self);
	void (*set_user_agent) (RygelMediaPlayer* self, const gchar* value);
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaPlayer* self;
	GUPnPDIDLLiteObject* item;
};



GType rygel_media_player_get_type (void) G_GNUC_CONST;
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
gdouble rygel_media_player_play_speed_to_double (RygelMediaPlayer* self, const gchar* speed);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gint64 rygel_media_player_get_duration (RygelMediaPlayer* self);
gint64 rygel_media_player_get_size (RygelMediaPlayer* self);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_time_utils_time_to_string (gint64 time);
gint64 rygel_media_player_get_position (RygelMediaPlayer* self);
gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
gchar* rygel_media_player_get_user_agent (RygelMediaPlayer* self);
void rygel_media_player_set_user_agent (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_protocol_info (RygelMediaPlayer* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _rygel_media_player_protocol_info___lambda4_ (Block1Data* _data1_, GUPnPDIDLLiteItem* object);
static void __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Seek to a point in the current media that is
     * this many microseconds after the start.
     */
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->seek (self, time);
}


/**
     * Seek to a byte position in the current media.
     */
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->seek_bytes (self, bytes);
}


/**
     * Return the protocols supported by this renderer,
     * such as "http-get" and "rtsp".
     */
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_protocols (self, result_length1);
}


gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_types (self, result_length1);
}


/**
     * Transform a fractional playspeed (e.g. "-1/4") to double.
     * Input values are expected to be valid rational numbers.
     */
static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gdouble rygel_media_player_play_speed_to_double (RygelMediaPlayer* self, const gchar* speed) {
	gdouble result = 0.0;
	gchar** rational = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint rational_length1 = 0;
	gint _rational_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	g_return_val_if_fail (speed != NULL, 0.0);
	_tmp0_ = speed;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 2);
	rational = _tmp2_;
	rational_length1 = _vala_array_length (_tmp1_);
	_rational_size_ = rational_length1;
	_tmp3_ = rational;
	_tmp3__length1 = rational_length1;
	_tmp4_ = _tmp3_[0];
	_vala_assert (g_strcmp0 (_tmp4_, "0") != 0, "rational[0] != \"0\"");
	_tmp5_ = rational;
	_tmp5__length1 = rational_length1;
	_tmp6_ = _tmp5_[1];
	if (_tmp6_ == NULL) {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		_tmp7_ = rational;
		_tmp7__length1 = rational_length1;
		_tmp8_ = _tmp7_[0];
		_tmp9_ = double_parse (_tmp8_);
		result = _tmp9_;
		rational = (_vala_array_free (rational, rational_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp10_ = rational;
	_tmp10__length1 = rational_length1;
	_tmp11_ = _tmp10_[1];
	_vala_assert (g_strcmp0 (_tmp11_, "0") != 0, "rational[1] != \"0\"");
	_tmp12_ = rational;
	_tmp12__length1 = rational_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = double_parse (_tmp13_);
	_tmp15_ = rational;
	_tmp15__length1 = rational_length1;
	_tmp16_ = _tmp15_[1];
	_tmp17_ = double_parse (_tmp16_);
	result = _tmp14_ / _tmp17_;
	rational = (_vala_array_free (rational, rational_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_state (self);
}


void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_state (self, value);
}


gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_allowed_playback_speeds (self, result_length1);
}


gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_playback_speed (self);
}


void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_playback_speed (self, value);
}


gchar* rygel_media_player_get_uri (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_uri (self);
}


void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_uri (self, value);
}


gdouble rygel_media_player_get_volume (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_volume (self);
}


void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_volume (self, value);
}


gint64 rygel_media_player_get_duration (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_duration (self);
}


gint64 rygel_media_player_get_size (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_size (self);
}


gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_metadata (self);
}


void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_metadata (self, value);
}


gchar* rygel_media_player_get_mime_type (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_mime_type (self);
}


void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_mime_type (self, value);
}


gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_can_seek (self);
}


gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_can_seek_bytes (self);
}


gchar* rygel_media_player_get_content_features (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_content_features (self);
}


void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_content_features (self, value);
}


gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_player_get_duration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
	result = _tmp2_;
	return result;
}


gint64 rygel_media_player_get_position (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_position (self);
}


gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_byte_position (self);
}


gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self) {
	gchar* result;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_player_get_position (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_time_utils_time_to_string (_tmp1_);
	result = _tmp2_;
	return result;
}


gchar* rygel_media_player_get_user_agent (RygelMediaPlayer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->get_user_agent (self);
}


void rygel_media_player_set_user_agent (RygelMediaPlayer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_PLAYER_GET_INTERFACE (self)->set_user_agent (self, value);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelMediaPlayer* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->item);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_player_protocol_info___lambda4_ (Block1Data* _data1_, GUPnPDIDLLiteItem* object) {
	RygelMediaPlayer* self;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	self = _data1_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 ((GUPnPDIDLLiteObject*) _tmp0_);
	_g_object_unref0 (_data1_->item);
	_data1_->item = _tmp1_;
}


static void __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
	_rygel_media_player_protocol_info___lambda4_ (self, item);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gchar* rygel_media_player_get_protocol_info (RygelMediaPlayer* self) {
	gchar* result;
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GUPnPDIDLLiteParser* p = NULL;
	GUPnPDIDLLiteParser* _tmp9_ = NULL;
	GUPnPDIDLLiteParser* _tmp10_ = NULL;
	GList* resources = NULL;
	GUPnPDIDLLiteObject* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp1_ = rygel_media_player_get_metadata (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp5_ = rygel_media_player_get_uri (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == NULL;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		gchar* _tmp8_ = NULL;
		_tmp8_ = g_strdup ("");
		result = _tmp8_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp9_ = gupnp_didl_lite_parser_new ();
	p = _tmp9_;
	_data1_->item = NULL;
	_tmp10_ = p;
	g_signal_connect_data (_tmp10_, "item-available", (GCallback) __rygel_media_player_protocol_info___lambda4__gupnp_didl_lite_parser_item_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	{
		GUPnPDIDLLiteParser* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp11_ = p;
		_tmp12_ = rygel_media_player_get_metadata (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		gupnp_didl_lite_parser_parse_didl (_tmp11_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp15_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = g_strdup ("");
		result = _tmp15_;
		_g_error_free0 (_error_);
		_g_object_unref0 (p);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (p);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp16_ = _data1_->item;
	_tmp17_ = gupnp_didl_lite_object_get_resources (_tmp16_);
	resources = _tmp17_;
	_tmp18_ = resources;
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
		resource_collection = _tmp18_;
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
			GUPnPDIDLLiteResource* _tmp19_ = NULL;
			GUPnPDIDLLiteResource* resource = NULL;
			_tmp19_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
			resource = _tmp19_;
			{
				GUPnPDIDLLiteResource* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				_tmp20_ = resource;
				_tmp21_ = gupnp_didl_lite_resource_get_uri (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = rygel_media_player_get_uri (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strcmp0 (_tmp22_, _tmp25_) == 0;
				_g_free0 (_tmp25_);
				if (_tmp26_) {
					GUPnPDIDLLiteResource* _tmp27_ = NULL;
					GUPnPProtocolInfo* _tmp28_ = NULL;
					GUPnPProtocolInfo* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					_tmp27_ = resource;
					_tmp28_ = gupnp_didl_lite_resource_get_protocol_info (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = gupnp_protocol_info_to_string (_tmp29_);
					result = _tmp30_;
					_g_object_unref0 (resource);
					__g_list_free__g_object_unref0_0 (resources);
					_g_object_unref0 (p);
					block1_data_unref (_data1_);
					_data1_ = NULL;
					return result;
				}
				_g_object_unref0 (resource);
			}
		}
	}
	_tmp31_ = g_strdup ("");
	result = _tmp31_;
	__g_list_free__g_object_unref0_0 (resources);
	_g_object_unref0 (p);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static void rygel_media_player_base_init (RygelMediaPlayerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * A DIDLLite document describing the current media URI or null.
		     * The document is either the one received from a UPnP control point or
		     * one generated by the implementing class.
		     */
		g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * The contents of the contentFeatures.dlna.org HTTP header,
		     * containing the 4th field of the protocol info for the current
		     * media URI. Or null if the header does not exist or the media
		     * does not have DLNA information attached.
		     */
		g_object_interface_install_property (iface, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * This interface maps UPnP AVTransport:2 methods to the plugin's specific implementation.
 *
 * This interface is useful only when implementing Rygel renderer plugins.
 * Instances of this interface are retrieved from
 * rygel_media_renderer_plugin_get_player().
 */
GType rygel_media_player_get_type (void) {
	static volatile gsize rygel_media_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaPlayerIface), (GBaseInitFunc) rygel_media_player_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_media_player_type_id;
		rygel_media_player_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelMediaPlayer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_media_player_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&rygel_media_player_type_id__volatile, rygel_media_player_type_id);
	}
	return rygel_media_player_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



