/* rygel-lms-database.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-lms-database.vala, do not modify */

/*
 * Copyright (C) 2009,2011 Jens Georg <mail@jensge.org>,
 *           (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-db.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;
typedef struct _RygelLMSDatabasePrivate RygelLMSDatabasePrivate;

#define RYGEL_LMS_TYPE_DBUS (rygel_lms_dbus_get_type ())
#define RYGEL_LMS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DBUS, RygelLMSDBus))
#define RYGEL_LMS_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DBUS))
#define RYGEL_LMS_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_LMS_TYPE_DBUS, RygelLMSDBusIface))

typedef struct _RygelLMSDBus RygelLMSDBus;
typedef struct _RygelLMSDBusIface RygelLMSDBusIface;

#define RYGEL_LMS_TYPE_DBUS_PROXY (rygel_lms_dbus_proxy_get_type ())
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_lms_database_unref0(var) ((var == NULL) ? NULL : (var = (rygel_lms_database_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _RygelLMSParamSpecDatabase RygelLMSParamSpecDatabase;

typedef enum  {
	RYGEL_LMS_DATABASE_ERROR_OPEN,
	RYGEL_LMS_DATABASE_ERROR_PREPARE,
	RYGEL_LMS_DATABASE_ERROR_BIND,
	RYGEL_LMS_DATABASE_ERROR_STEP,
	RYGEL_LMS_DATABASE_ERROR_NOT_FOUND
} RygelLMSDatabaseError;
#define RYGEL_LMS_DATABASE_ERROR rygel_lms_database_error_quark ()
struct _RygelLMSDatabase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelLMSDatabasePrivate * priv;
};

struct _RygelLMSDatabaseClass {
	GTypeClass parent_class;
	void (*finalize) (RygelLMSDatabase *self);
};

struct _RygelLMSDBusIface {
	GTypeInterface parent_iface;
	gchar* (*get_data_base_path) (RygelLMSDBus* self);
	guint64 (*get_update_id) (RygelLMSDBus* self);
};

struct _RygelLMSDatabasePrivate {
	sqlite3* db;
	RygelLMSDBus* lms_proxy;
	guint64 update_id;
};

struct _RygelLMSParamSpecDatabase {
	GParamSpec parent_instance;
};


static gpointer rygel_lms_database_parent_class = NULL;

GQuark rygel_lms_database_error_quark (void);
gpointer rygel_lms_database_ref (gpointer instance);
void rygel_lms_database_unref (gpointer instance);
GParamSpec* rygel_lms_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_lms_value_set_database (GValue* value, gpointer v_object);
void rygel_lms_value_take_database (GValue* value, gpointer v_object);
gpointer rygel_lms_value_get_database (const GValue* value);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
GType rygel_lms_dbus_get_type (void) G_GNUC_CONST;
GType rygel_lms_dbus_proxy_get_type (void) G_GNUC_CONST;
guint rygel_lms_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define RYGEL_LMS_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabasePrivate))
enum  {
	RYGEL_LMS_DATABASE_DUMMY_PROPERTY
};
RygelLMSDatabase* rygel_lms_database_new (GError** error);
RygelLMSDatabase* rygel_lms_database_construct (GType object_type, GError** error);
gchar* rygel_lms_dbus_get_data_base_path (RygelLMSDBus* self);
guint64 rygel_lms_dbus_get_update_id (RygelLMSDBus* self);
static void rygel_lms_database_on_lms_properties_changed (RygelLMSDatabase* self, GDBusProxy* lms_proxy, GVariant* changed, gchar** invalidated, int invalidated_length1);
static void _rygel_lms_database_on_lms_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void _rygel_database_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static gint _rygel_database_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b);
static gchar* _variant_get1 (GVariant* value);
static guint64 _variant_get2 (GVariant* value);
static guint64 _variant_get3 (GVariant* value);
sqlite3_stmt* rygel_lms_database_prepare (RygelLMSDatabase* self, const gchar* query_string, GError** error);
sqlite3_stmt* rygel_lms_database_prepare_and_init (RygelLMSDatabase* self, const gchar* query, GValue* arguments, int arguments_length1, GError** error);
void rygel_lms_database_find_object (const gchar* id, sqlite3_stmt* stmt, GError** error);
void rygel_lms_database_get_children_init (sqlite3_stmt* stmt, guint offset, guint max_count, const gchar* sort_criteria, GError** error);
void rygel_lms_database_get_children_with_update_id_init (sqlite3_stmt* stmt, guint64 old_id, guint64 new_id, GError** error);
gboolean rygel_lms_database_get_children_step (sqlite3_stmt* stmt, GError** error);
static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_lms_database_finalize (RygelLMSDatabase* obj);
static gint _vala_array_length (gpointer array);


GQuark rygel_lms_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_lms_database_error-quark");
}


static void _rygel_lms_database_on_lms_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	rygel_lms_database_on_lms_properties_changed ((RygelLMSDatabase*) self, _sender, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


static void _rygel_database_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
	rygel_database_database_utf8_contains (context, values, values_length1);
}


static gint _rygel_database_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b) {
	gint result;
	result = rygel_database_database_utf8_collate (alen, a, blen, b);
	return result;
}


RygelLMSDatabase* rygel_lms_database_construct (GType object_type, GError** error) {
	RygelLMSDatabase* self = NULL;
	gchar* db_path = NULL;
	const gchar* _tmp17_ = NULL;
	sqlite3* _tmp18_ = NULL;
	sqlite3* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	sqlite3* _tmp25_ = NULL;
	sqlite3* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelLMSDatabase*) g_type_create_instance (object_type);
	{
		RygelLMSDBus* _tmp0_ = NULL;
		RygelLMSDBus* _tmp1_ = NULL;
		RygelLMSDBus* _tmp2_ = NULL;
		RygelLMSDBus* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelLMSDBus* _tmp7_ = NULL;
		guint64 _tmp8_ = 0ULL;
		guint64 _tmp9_ = 0ULL;
		guint64 _tmp10_ = 0ULL;
		RygelLMSDBus* _tmp11_ = NULL;
		_tmp1_ = g_initable_new (RYGEL_LMS_TYPE_DBUS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.lightmediascanner", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/lightmediascanner/Scanner1", "g-interface-name", "org.lightmediascanner.Scanner1", "g-interface-info", g_type_get_qdata (RYGEL_LMS_TYPE_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp0_ = (RygelLMSDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch11_g_io_error;
			}
			_g_free0 (db_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->lms_proxy);
		self->priv->lms_proxy = _tmp2_;
		_tmp3_ = self->priv->lms_proxy;
		_tmp4_ = rygel_lms_dbus_get_data_base_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (db_path);
		db_path = _tmp5_;
		_tmp6_ = db_path;
		g_debug ("rygel-lms-database.vala:51: Got db path %s from LMS over dbus", _tmp6_);
		_tmp7_ = self->priv->lms_proxy;
		_tmp8_ = rygel_lms_dbus_get_update_id (_tmp7_);
		_tmp9_ = _tmp8_;
		self->priv->update_id = _tmp9_;
		_tmp10_ = self->priv->update_id;
		g_debug ("rygel-lms-database.vala:53: Got updated id %lld from LMS over dbus", _tmp10_);
		_tmp11_ = self->priv->lms_proxy;
		g_signal_connect ((GDBusProxy*) _tmp11_, "g-properties-changed", (GCallback) _rygel_lms_database_on_lms_properties_changed_g_dbus_proxy_g_properties_changed, self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("rygel-lms-database.vala:57: Couldn't get LMS Dbus proxy: %s", _tmp13_);
		_tmp14_ = g_get_user_config_dir ();
		_tmp15_ = g_strconcat (_tmp14_, "/lightmediascannerd/db.sqlite3", NULL);
		_g_free0 (db_path);
		db_path = _tmp15_;
		_tmp16_ = db_path;
		g_debug ("rygel-lms-database.vala:60: Using default sqlite database location %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (db_path);
			_rygel_lms_database_unref0 (self);
			return NULL;
		} else {
			_g_free0 (db_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = db_path;
	sqlite3_open (_tmp17_, &_tmp18_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp18_;
	_tmp19_ = self->priv->db;
	_tmp20_ = sqlite3_errcode (_tmp19_);
	if (_tmp20_ != SQLITE_OK) {
		const gchar* _tmp21_ = NULL;
		sqlite3* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		GError* _tmp24_ = NULL;
		_tmp21_ = db_path;
		_tmp22_ = self->priv->db;
		_tmp23_ = sqlite3_errcode (_tmp22_);
		_tmp24_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_OPEN, "Failed to open '%s': %d", _tmp21_, _tmp23_);
		_inner_error_ = _tmp24_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (db_path);
			_rygel_lms_database_unref0 (self);
			return NULL;
		} else {
			_g_free0 (db_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = self->priv->db;
	sqlite3_create_function (_tmp25_, "contains", 2, SQLITE_UTF8, NULL, _rygel_database_database_utf8_contains_sqlite_user_func_callback, NULL, NULL);
	_tmp26_ = self->priv->db;
	sqlite3_create_collation (_tmp26_, "CASEFOLD", SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _rygel_database_database_utf8_collate_sqlite_compare_callback);
	_g_free0 (db_path);
	return self;
}


RygelLMSDatabase* rygel_lms_database_new (GError** error) {
	return rygel_lms_database_construct (RYGEL_LMS_TYPE_DATABASE, error);
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint64 _variant_get2 (GVariant* value) {
	return g_variant_get_uint64 (value);
}


static guint64 _variant_get3 (GVariant* value) {
	return g_variant_get_uint64 (value);
}


static void rygel_lms_database_on_lms_properties_changed (RygelLMSDatabase* self, GDBusProxy* lms_proxy, GVariant* changed, gchar** invalidated, int invalidated_length1) {
	GVariant* _tmp0_ = NULL;
	const GVariantType* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lms_proxy != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = changed;
	_tmp1_ = g_variant_get_type (_tmp0_);
	_tmp2_ = G_VARIANT_TYPE_VARDICT;
	_tmp3_ = g_variant_type_equal (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	{
		GVariantIter* _changed_prop_it = NULL;
		GVariant* _tmp4_ = NULL;
		GVariantIter* _tmp5_ = NULL;
		GVariant* changed_prop = NULL;
		_tmp4_ = changed;
		_tmp5_ = g_variant_iter_new (_tmp4_);
		_changed_prop_it = _tmp5_;
		while (TRUE) {
			GVariantIter* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			gchar* key = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			GVariant* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GVariant* value = NULL;
			GVariant* _tmp14_ = NULL;
			GVariant* _tmp15_ = NULL;
			GVariant* _tmp16_ = NULL;
			GVariant* _tmp17_ = NULL;
			GVariant* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GVariant* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GQuark _tmp26_ = 0U;
			static GQuark _tmp25_label0 = 0;
			_tmp6_ = _changed_prop_it;
			_tmp7_ = g_variant_iter_next_value (_tmp6_);
			_g_variant_unref0 (changed_prop);
			changed_prop = _tmp7_;
			_tmp8_ = changed_prop;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = changed_prop;
			_tmp10_ = g_variant_get_child_value (_tmp9_, (gsize) 0);
			_tmp11_ = _tmp10_;
			_tmp12_ = _variant_get1 (_tmp11_);
			_tmp13_ = _tmp12_;
			_g_variant_unref0 (_tmp11_);
			key = _tmp13_;
			_tmp14_ = changed_prop;
			_tmp15_ = g_variant_get_child_value (_tmp14_, (gsize) 1);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_variant_get_child_value (_tmp16_, (gsize) 0);
			_tmp18_ = _tmp17_;
			_g_variant_unref0 (_tmp16_);
			value = _tmp18_;
			_tmp19_ = key;
			_tmp20_ = value;
			_tmp21_ = g_variant_print (_tmp20_, TRUE);
			_tmp22_ = _tmp21_;
			g_debug ("rygel-lms-database.vala:95: LMS property %s changed value to %s", _tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			_tmp23_ = key;
			_tmp24_ = _tmp23_;
			_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
			if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("UpdateID")))) {
				switch (0) {
					default:
					{
						guint64 _tmp27_ = 0ULL;
						GVariant* _tmp28_ = NULL;
						guint64 _tmp29_ = 0ULL;
						GVariant* _tmp30_ = NULL;
						guint64 _tmp31_ = 0ULL;
						_tmp27_ = self->priv->update_id;
						_tmp28_ = value;
						_tmp29_ = _variant_get2 (_tmp28_);
						g_signal_emit_by_name (self, "db-updated", _tmp27_, _tmp29_);
						_tmp30_ = value;
						_tmp31_ = _variant_get3 (_tmp30_);
						self->priv->update_id = _tmp31_;
						break;
					}
				}
			}
			_g_variant_unref0 (value);
			_g_free0 (key);
		}
		_g_variant_unref0 (changed_prop);
		_g_variant_iter_free0 (_changed_prop_it);
	}
}


sqlite3_stmt* rygel_lms_database_prepare (RygelLMSDatabase* self, const gchar* query_string, GError** error) {
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* statement = NULL;
	gint err = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query_string != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = query_string;
	_tmp3_ = sqlite3_prepare_v2 (_tmp0_, _tmp1_, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != SQLITE_OK) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GError* _tmp7_ = NULL;
		_tmp5_ = query_string;
		_tmp6_ = err;
		_tmp7_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_PREPARE, "Unable to create statement '%s': %d", _tmp5_, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (statement);
			return NULL;
		} else {
			_sqlite3_finalize0 (statement);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = statement;
	return result;
}


sqlite3_stmt* rygel_lms_database_prepare_and_init (RygelLMSDatabase* self, const gchar* query, GValue* arguments, int arguments_length1, GError** error) {
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* statement = NULL;
	gint err = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = query;
	_tmp3_ = sqlite3_prepare_v2 (_tmp0_, _tmp1_, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp2_;
	err = _tmp3_;
	_tmp4_ = err;
	if (_tmp4_ != SQLITE_OK) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GError* _tmp7_ = NULL;
		_tmp5_ = query;
		_tmp6_ = err;
		_tmp7_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_PREPARE, "Unable to create statement '%s': %d", _tmp5_, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (statement);
			return NULL;
		} else {
			_sqlite3_finalize0 (statement);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				GValue* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint sqlite_err = 0;
				GValue current_value = {0};
				GValue* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				GValue _tmp14_ = {0};
				gboolean _tmp15_ = FALSE;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = arguments;
				_tmp11__length1 = arguments_length1;
				if (!(_tmp10_ <= _tmp11__length1)) {
					break;
				}
				_tmp12_ = arguments;
				_tmp12__length1 = arguments_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_ - 1];
				current_value = _tmp14_;
				_tmp15_ = G_VALUE_HOLDS (&current_value, G_TYPE_INT);
				if (_tmp15_) {
					sqlite3_stmt* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp16_ = statement;
					_tmp17_ = i;
					_tmp18_ = g_value_get_int (&current_value);
					_tmp19_ = sqlite3_bind_int (_tmp16_, _tmp17_, _tmp18_);
					sqlite_err = _tmp19_;
					_tmp20_ = sqlite_err;
					if (_tmp20_ != SQLITE_OK) {
						gint _tmp21_ = 0;
						GError* _tmp22_ = NULL;
						_tmp21_ = sqlite_err;
						_tmp22_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp21_);
						_inner_error_ = _tmp22_;
						if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_sqlite3_finalize0 (statement);
							return NULL;
						} else {
							_sqlite3_finalize0 (statement);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				} else {
					gboolean _tmp23_ = FALSE;
					_tmp23_ = G_VALUE_HOLDS (&current_value, G_TYPE_INT64);
					if (_tmp23_) {
						sqlite3_stmt* _tmp24_ = NULL;
						gint _tmp25_ = 0;
						gint64 _tmp26_ = 0LL;
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						_tmp24_ = statement;
						_tmp25_ = i;
						_tmp26_ = g_value_get_int64 (&current_value);
						_tmp27_ = sqlite3_bind_int64 (_tmp24_, _tmp25_, _tmp26_);
						sqlite_err = _tmp27_;
						_tmp28_ = sqlite_err;
						if (_tmp28_ != SQLITE_OK) {
							gint _tmp29_ = 0;
							GError* _tmp30_ = NULL;
							_tmp29_ = sqlite_err;
							_tmp30_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp29_);
							_inner_error_ = _tmp30_;
							if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_sqlite3_finalize0 (statement);
								return NULL;
							} else {
								_sqlite3_finalize0 (statement);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						gboolean _tmp31_ = FALSE;
						_tmp31_ = G_VALUE_HOLDS (&current_value, G_TYPE_UINT64);
						if (_tmp31_) {
							sqlite3_stmt* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							guint64 _tmp34_ = 0ULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							_tmp32_ = statement;
							_tmp33_ = i;
							_tmp34_ = g_value_get_uint64 (&current_value);
							_tmp35_ = sqlite3_bind_int64 (_tmp32_, _tmp33_, (gint64) _tmp34_);
							sqlite_err = _tmp35_;
							_tmp36_ = sqlite_err;
							if (_tmp36_ != SQLITE_OK) {
								gint _tmp37_ = 0;
								GError* _tmp38_ = NULL;
								_tmp37_ = sqlite_err;
								_tmp38_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp37_);
								_inner_error_ = _tmp38_;
								if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
									g_propagate_error (error, _inner_error_);
									_sqlite3_finalize0 (statement);
									return NULL;
								} else {
									_sqlite3_finalize0 (statement);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
						} else {
							gboolean _tmp39_ = FALSE;
							_tmp39_ = G_VALUE_HOLDS (&current_value, G_TYPE_LONG);
							if (_tmp39_) {
								sqlite3_stmt* _tmp40_ = NULL;
								gint _tmp41_ = 0;
								glong _tmp42_ = 0L;
								gint _tmp43_ = 0;
								gint _tmp44_ = 0;
								_tmp40_ = statement;
								_tmp41_ = i;
								_tmp42_ = g_value_get_long (&current_value);
								_tmp43_ = sqlite3_bind_int64 (_tmp40_, _tmp41_, (gint64) _tmp42_);
								sqlite_err = _tmp43_;
								_tmp44_ = sqlite_err;
								if (_tmp44_ != SQLITE_OK) {
									gint _tmp45_ = 0;
									GError* _tmp46_ = NULL;
									_tmp45_ = sqlite_err;
									_tmp46_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp45_);
									_inner_error_ = _tmp46_;
									if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
										g_propagate_error (error, _inner_error_);
										_sqlite3_finalize0 (statement);
										return NULL;
									} else {
										_sqlite3_finalize0 (statement);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							} else {
								gboolean _tmp47_ = FALSE;
								_tmp47_ = G_VALUE_HOLDS (&current_value, G_TYPE_UINT);
								if (_tmp47_) {
									sqlite3_stmt* _tmp48_ = NULL;
									gint _tmp49_ = 0;
									guint _tmp50_ = 0U;
									gint _tmp51_ = 0;
									gint _tmp52_ = 0;
									_tmp48_ = statement;
									_tmp49_ = i;
									_tmp50_ = g_value_get_uint (&current_value);
									_tmp51_ = sqlite3_bind_int64 (_tmp48_, _tmp49_, (gint64) _tmp50_);
									sqlite_err = _tmp51_;
									_tmp52_ = sqlite_err;
									if (_tmp52_ != SQLITE_OK) {
										gint _tmp53_ = 0;
										GError* _tmp54_ = NULL;
										_tmp53_ = sqlite_err;
										_tmp54_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp53_);
										_inner_error_ = _tmp54_;
										if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
											g_propagate_error (error, _inner_error_);
											_sqlite3_finalize0 (statement);
											return NULL;
										} else {
											_sqlite3_finalize0 (statement);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
								} else {
									gboolean _tmp55_ = FALSE;
									_tmp55_ = G_VALUE_HOLDS (&current_value, G_TYPE_STRING);
									if (_tmp55_) {
										sqlite3_stmt* _tmp56_ = NULL;
										gint _tmp57_ = 0;
										const gchar* _tmp58_ = NULL;
										gchar* _tmp59_ = NULL;
										GDestroyNotify _tmp60_ = NULL;
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										_tmp56_ = statement;
										_tmp57_ = i;
										_tmp58_ = g_value_get_string (&current_value);
										_tmp59_ = g_strdup (_tmp58_);
										_tmp60_ = g_free;
										_tmp61_ = sqlite3_bind_text (_tmp56_, _tmp57_, _tmp59_, -1, _tmp60_);
										sqlite_err = _tmp61_;
										_tmp62_ = sqlite_err;
										if (_tmp62_ != SQLITE_OK) {
											gint _tmp63_ = 0;
											GError* _tmp64_ = NULL;
											_tmp63_ = sqlite_err;
											_tmp64_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp63_);
											_inner_error_ = _tmp64_;
											if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
												g_propagate_error (error, _inner_error_);
												_sqlite3_finalize0 (statement);
												return NULL;
											} else {
												_sqlite3_finalize0 (statement);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
									} else {
										gboolean _tmp65_ = FALSE;
										_tmp65_ = G_VALUE_HOLDS (&current_value, G_TYPE_POINTER);
										if (_tmp65_) {
											void* _tmp66_ = NULL;
											_tmp66_ = g_value_peek_pointer (&current_value);
											if (_tmp66_ == NULL) {
												sqlite3_stmt* _tmp67_ = NULL;
												gint _tmp68_ = 0;
												gint _tmp69_ = 0;
												gint _tmp70_ = 0;
												_tmp67_ = statement;
												_tmp68_ = i;
												_tmp69_ = sqlite3_bind_null (_tmp67_, _tmp68_);
												sqlite_err = _tmp69_;
												_tmp70_ = sqlite_err;
												if (_tmp70_ != SQLITE_OK) {
													gint _tmp71_ = 0;
													GError* _tmp72_ = NULL;
													_tmp71_ = sqlite_err;
													_tmp72_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind value %d", _tmp71_);
													_inner_error_ = _tmp72_;
													if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
														g_propagate_error (error, _inner_error_);
														_sqlite3_finalize0 (statement);
														return NULL;
													} else {
														_sqlite3_finalize0 (statement);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
											} else {
												g_assert_not_reached ();
											}
										} else {
											GType type = 0UL;
											GType _tmp73_ = 0UL;
											const gchar* _tmp74_ = NULL;
											const gchar* _tmp75_ = NULL;
											_tmp73_ = G_VALUE_TYPE (&current_value);
											type = _tmp73_;
											_tmp74_ = _ ("Unsupported type %s");
											_tmp75_ = g_type_name (type);
											g_warning (_tmp74_, _tmp75_);
											g_assert_not_reached ();
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = statement;
	return result;
}


void rygel_lms_database_find_object (const gchar* id, sqlite3_stmt* stmt, GError** error) {
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint integer_id = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint sqlite_err = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (id != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = sqlite3_reset (_tmp0_);
	_tmp2_ = id;
	_tmp3_ = atoi (_tmp2_);
	integer_id = _tmp3_;
	_tmp4_ = stmt;
	_tmp5_ = integer_id;
	_tmp6_ = sqlite3_bind_int (_tmp4_, 1, _tmp5_);
	sqlite_err = _tmp6_;
	_tmp7_ = sqlite_err;
	if (_tmp7_ != SQLITE_OK) {
		gint _tmp8_ = 0;
		GError* _tmp9_ = NULL;
		_tmp8_ = sqlite_err;
		_tmp9_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind id %d", _tmp8_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = stmt;
	_tmp11_ = sqlite3_step (_tmp10_);
	sqlite_err = _tmp11_;
	_tmp12_ = sqlite_err;
	if (_tmp12_ != SQLITE_ROW) {
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp13_ = id;
		_tmp14_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_STEP, "Unable to find id %s", _tmp13_);
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void rygel_lms_database_get_children_init (sqlite3_stmt* stmt, guint offset, guint max_count, const gchar* sort_criteria, GError** error) {
	gint sqlite_err = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3_stmt* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (sort_criteria != NULL);
	_tmp0_ = stmt;
	_tmp1_ = sqlite3_reset (_tmp0_);
	_tmp2_ = stmt;
	_tmp3_ = max_count;
	_tmp4_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp3_);
	sqlite_err = _tmp4_;
	_tmp5_ = sqlite_err;
	if (_tmp5_ != SQLITE_OK) {
		gint _tmp6_ = 0;
		GError* _tmp7_ = NULL;
		_tmp6_ = sqlite_err;
		_tmp7_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind max_count %d", _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = stmt;
	_tmp9_ = offset;
	_tmp10_ = sqlite3_bind_int (_tmp8_, 2, (gint) _tmp9_);
	sqlite_err = _tmp10_;
	_tmp11_ = sqlite_err;
	if (_tmp11_ != SQLITE_OK) {
		gint _tmp12_ = 0;
		GError* _tmp13_ = NULL;
		_tmp12_ = sqlite_err;
		_tmp13_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind offset %d", _tmp12_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void rygel_lms_database_get_children_with_update_id_init (sqlite3_stmt* stmt, guint64 old_id, guint64 new_id, GError** error) {
	gint sqlite_err = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint64 _tmp2_ = 0ULL;
	guint64 _tmp3_ = 0ULL;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	guint64 _tmp13_ = 0ULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	_tmp1_ = sqlite3_reset (_tmp0_);
	_tmp2_ = new_id;
	_tmp3_ = old_id;
	if (_tmp2_ < _tmp3_) {
		sqlite3_stmt* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = stmt;
		_tmp5_ = sqlite3_bind_int64 (_tmp4_, 1, (gint64) 0);
		sqlite_err = _tmp5_;
	} else {
		sqlite3_stmt* _tmp6_ = NULL;
		guint64 _tmp7_ = 0ULL;
		gint _tmp8_ = 0;
		_tmp6_ = stmt;
		_tmp7_ = old_id;
		_tmp8_ = sqlite3_bind_int64 (_tmp6_, 1, (gint64) _tmp7_);
		sqlite_err = _tmp8_;
	}
	_tmp9_ = sqlite_err;
	if (_tmp9_ != SQLITE_OK) {
		gint _tmp10_ = 0;
		GError* _tmp11_ = NULL;
		_tmp10_ = sqlite_err;
		_tmp11_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind old_id %d", _tmp10_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = stmt;
	_tmp13_ = new_id;
	_tmp14_ = sqlite3_bind_int64 (_tmp12_, 2, (gint64) _tmp13_);
	sqlite_err = _tmp14_;
	_tmp15_ = sqlite_err;
	if (_tmp15_ != SQLITE_OK) {
		gint _tmp16_ = 0;
		GError* _tmp17_ = NULL;
		_tmp16_ = sqlite_err;
		_tmp17_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_BIND, "Unable to bind new_id %d", _tmp16_);
		_inner_error_ = _tmp17_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean rygel_lms_database_get_children_step (sqlite3_stmt* stmt, GError** error) {
	gboolean result = FALSE;
	gboolean retval = FALSE;
	gint sqlite_err = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (stmt != NULL, FALSE);
	_tmp0_ = stmt;
	_tmp1_ = sqlite3_step (_tmp0_);
	sqlite_err = _tmp1_;
	_tmp2_ = sqlite_err;
	retval = _tmp2_ == SQLITE_ROW;
	_tmp4_ = retval;
	if (!_tmp4_) {
		gint _tmp5_ = 0;
		_tmp5_ = sqlite_err;
		_tmp3_ = _tmp5_ != SQLITE_DONE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp6_ = 0;
		GError* _tmp7_ = NULL;
		_tmp6_ = sqlite_err;
		_tmp7_ = g_error_new (RYGEL_LMS_DATABASE_ERROR, RYGEL_LMS_DATABASE_ERROR_STEP, "Error iterating through rows %d", _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = retval;
	return result;
}


static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT64_UINT64) (gpointer data1, guint64 arg_1, guint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT64_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT64_UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint64 (param_values + 1), g_value_get_uint64 (param_values + 2), data2);
}


static void rygel_lms_value_database_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_lms_value_database_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_lms_database_unref (value->data[0].v_pointer);
	}
}


static void rygel_lms_value_database_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_lms_database_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_lms_value_database_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_lms_value_database_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelLMSDatabase* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_lms_database_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_lms_value_database_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelLMSDatabase** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_lms_database_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_lms_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelLMSParamSpecDatabase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_LMS_TYPE_DATABASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_lms_value_get_database (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LMS_TYPE_DATABASE), NULL);
	return value->data[0].v_pointer;
}


void rygel_lms_value_set_database (GValue* value, gpointer v_object) {
	RygelLMSDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LMS_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_LMS_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_lms_database_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_lms_database_unref (old);
	}
}


void rygel_lms_value_take_database (GValue* value, gpointer v_object) {
	RygelLMSDatabase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LMS_TYPE_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_LMS_TYPE_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_lms_database_unref (old);
	}
}


static void rygel_lms_database_class_init (RygelLMSDatabaseClass * klass) {
	rygel_lms_database_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSDatabaseClass *) klass)->finalize = rygel_lms_database_finalize;
	g_type_class_add_private (klass, sizeof (RygelLMSDatabasePrivate));
	g_signal_new ("db_updated", RYGEL_LMS_TYPE_DATABASE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64_UINT64, G_TYPE_NONE, 2, G_TYPE_UINT64, G_TYPE_UINT64);
}


static void rygel_lms_database_instance_init (RygelLMSDatabase * self) {
	self->priv = RYGEL_LMS_DATABASE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_lms_database_finalize (RygelLMSDatabase* obj) {
	RygelLMSDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase);
	g_signal_handlers_destroy (self);
	_sqlite3_close0 (self->priv->db);
	_g_object_unref0 (self->priv->lms_proxy);
}


GType rygel_lms_database_get_type (void) {
	static volatile gsize rygel_lms_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_database_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_lms_value_database_init, rygel_lms_value_database_free_value, rygel_lms_value_database_copy_value, rygel_lms_value_database_peek_pointer, "p", rygel_lms_value_database_collect_value, "p", rygel_lms_value_database_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSDatabase), 0, (GInstanceInitFunc) rygel_lms_database_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_lms_database_type_id;
		rygel_lms_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelLMSDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_lms_database_type_id__volatile, rygel_lms_database_type_id);
	}
	return rygel_lms_database_type_id__volatile;
}


gpointer rygel_lms_database_ref (gpointer instance) {
	RygelLMSDatabase* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_lms_database_unref (gpointer instance) {
	RygelLMSDatabase* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_LMS_DATABASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



