/* rygel-media-export-item-factory.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>
#include <libsoup/soup.h>

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER (rygel_media_export_dvd_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))

typedef struct _RygelMediaExportDVDContainer RygelMediaExportDVDContainer;
typedef struct _RygelMediaExportDVDContainerClass RygelMediaExportDVDContainerClass;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

typedef enum  {
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION,
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH
} RygelMediaExportItemFactoryItemFactoryError;
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR rygel_media_export_item_factory_item_factory_error_quark ()
struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



GQuark rygel_media_export_item_factory_item_factory_error_quark (void);
gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error);
RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error);
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS RYGEL_MEDIA_CONTAINER_PLAYLIST ".DVD"
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
GType rygel_media_export_dvd_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_file_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error);
static void _vala_SoupDate_free (SoupDate* self);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;


GQuark rygel_media_export_item_factory_item_factory_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_item_factory_item_factory_error-quark");
}


gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error) {
	gboolean result = FALSE;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantType* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (typestring != NULL, FALSE);
	_tmp0_ = v;
	_tmp1_ = typestring;
	_tmp2_ = g_variant_type_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_is_of_type (_tmp0_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_variant_type_free0 (_tmp3_);
	if (_tmp5_) {
		gchar* msg = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp6_ = g_strdup ("Variant type mismatch, expected %s, got %s");
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = v;
		_tmp9_ = g_variant_get_type_string (_tmp8_);
		_tmp10_ = typestring;
		_tmp11_ = g_error_new (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION, _tmp7_, _tmp9_, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaFileItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaFileItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gint _tmp14_ = 0;
		guint8 _tmp15_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		GUPnPMediaCollection* _tmp17_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp33_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		RygelMediaContainer* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		RygelMediaExportPlaylistItem* _tmp41_ = NULL;
		RygelMediaExportPlaylistItem* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp46_ = NULL;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp2_;
		contents_length1 = _tmp3_;
		_contents_size_ = contents_length1;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			contents = (g_free (contents), NULL);
			goto __catch63_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gint _tmp12_ = 0;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
		_tmp13_ = contents;
		_tmp13__length1 = contents_length1;
		_tmp14_ = i;
		_tmp15_ = _tmp13_[_tmp14_];
		if (_tmp15_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp16_ = contents;
		_tmp16__length1 = contents_length1;
		_tmp17_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp16_);
		didl_s = _tmp17_;
		_tmp18_ = didl_s;
		_tmp19_ = gupnp_media_collection_get_author (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		author = _tmp21_;
		_tmp22_ = didl_s;
		_tmp23_ = gupnp_media_collection_get_title (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		title = _tmp25_;
		_tmp28_ = author;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_ = NULL;
			_tmp29_ = title;
			_tmp27_ = _tmp29_ == NULL;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GUPnPMediaCollection* _tmp30_ = NULL;
			GList* _tmp31_ = NULL;
			GList* _tmp32_ = NULL;
			_tmp30_ = didl_s;
			_tmp31_ = gupnp_media_collection_get_items (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp26_ = _tmp32_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp32_);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp33_ = title;
		if (_tmp33_ == NULL) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = fallback_title;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (title);
			title = _tmp35_;
		}
		_tmp36_ = file;
		_tmp37_ = rygel_media_export_media_cache_get_id (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = parent;
		_tmp40_ = title;
		_tmp41_ = rygel_media_export_playlist_item_new (_tmp38_, _tmp39_, _tmp40_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp38_);
		item = _tmp42_;
		_tmp43_ = author;
		if (_tmp43_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp44_ = item;
			_tmp45_ = author;
			rygel_media_object_set_creator ((RygelMediaObject*) _tmp44_, _tmp45_);
		}
		_tmp46_ = item;
		rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp46_, "DIDL_S");
		result = (RygelMediaFileItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally63:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error) {
	RygelMediaObject* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* upnp_class = NULL;
	GVariant* file_info = NULL;
	GVariant* dlna_profile = NULL;
	GVariant* info = NULL;
	GVariant* video_info = NULL;
	GVariant* audio_info = NULL;
	GVariant* meta_data = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	gchar* id = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GVariantIter* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariantIter* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariantIter* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariantIter* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	GVariantIter* _tmp28_ = NULL;
	GVariant* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariantIter* _tmp35_ = NULL;
	GVariant* _tmp36_ = NULL;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	GVariantIter* _tmp42_ = NULL;
	GVariant* _tmp43_ = NULL;
	GVariant* _tmp44_ = NULL;
	GVariant* _tmp45_ = NULL;
	GVariant* _tmp46_ = NULL;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* object = NULL;
	GVariant* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	GQuark _tmp53_ = 0U;
	RygelMediaFileItem* _tmp78_ = NULL;
	GFile* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_ = NULL;
	GVariant* _tmp82_ = NULL;
	GVariant* _tmp85_ = NULL;
	GVariant* _tmp88_ = NULL;
	GVariant* _tmp91_ = NULL;
	GVariant* _tmp94_ = NULL;
	GVariant* _tmp97_ = NULL;
	RygelMediaFileItem* _tmp100_ = NULL;
	const gchar* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	gboolean _tmp103_ = FALSE;
	RygelMediaFileItem* _tmp112_ = NULL;
	RygelMediaObject* _tmp113_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(smvmvmvmvmvmv)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = rygel_media_export_media_cache_get_id (_tmp3_);
	id = _tmp4_;
	_tmp5_ = it;
	_tmp6_ = g_variant_iter_next_value (_tmp5_);
	_g_variant_unref0 (upnp_class);
	upnp_class = _tmp6_;
	_tmp7_ = it;
	_tmp8_ = g_variant_iter_next_value (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_get_maybe (_tmp9_);
	_g_variant_unref0 (file_info);
	file_info = _tmp10_;
	_g_variant_unref0 (_tmp9_);
	_tmp11_ = file_info;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_ = NULL;
		GVariant* _tmp13_ = NULL;
		_tmp12_ = file_info;
		_tmp13_ = g_variant_get_variant (_tmp12_);
		_g_variant_unref0 (file_info);
		file_info = _tmp13_;
	}
	_tmp14_ = it;
	_tmp15_ = g_variant_iter_next_value (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_maybe (_tmp16_);
	_g_variant_unref0 (dlna_profile);
	dlna_profile = _tmp17_;
	_g_variant_unref0 (_tmp16_);
	_tmp18_ = dlna_profile;
	if (_tmp18_ != NULL) {
		GVariant* _tmp19_ = NULL;
		GVariant* _tmp20_ = NULL;
		_tmp19_ = dlna_profile;
		_tmp20_ = g_variant_get_variant (_tmp19_);
		_g_variant_unref0 (dlna_profile);
		dlna_profile = _tmp20_;
	}
	_tmp21_ = it;
	_tmp22_ = g_variant_iter_next_value (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_get_maybe (_tmp23_);
	_g_variant_unref0 (info);
	info = _tmp24_;
	_g_variant_unref0 (_tmp23_);
	_tmp25_ = info;
	if (_tmp25_ != NULL) {
		GVariant* _tmp26_ = NULL;
		GVariant* _tmp27_ = NULL;
		_tmp26_ = info;
		_tmp27_ = g_variant_get_variant (_tmp26_);
		_g_variant_unref0 (info);
		info = _tmp27_;
	}
	_tmp28_ = it;
	_tmp29_ = g_variant_iter_next_value (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_variant_get_maybe (_tmp30_);
	_g_variant_unref0 (audio_info);
	audio_info = _tmp31_;
	_g_variant_unref0 (_tmp30_);
	_tmp32_ = audio_info;
	if (_tmp32_ != NULL) {
		GVariant* _tmp33_ = NULL;
		GVariant* _tmp34_ = NULL;
		_tmp33_ = audio_info;
		_tmp34_ = g_variant_get_variant (_tmp33_);
		_g_variant_unref0 (audio_info);
		audio_info = _tmp34_;
	}
	_tmp35_ = it;
	_tmp36_ = g_variant_iter_next_value (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_variant_get_maybe (_tmp37_);
	_g_variant_unref0 (video_info);
	video_info = _tmp38_;
	_g_variant_unref0 (_tmp37_);
	_tmp39_ = video_info;
	if (_tmp39_ != NULL) {
		GVariant* _tmp40_ = NULL;
		GVariant* _tmp41_ = NULL;
		_tmp40_ = video_info;
		_tmp41_ = g_variant_get_variant (_tmp40_);
		_g_variant_unref0 (video_info);
		video_info = _tmp41_;
	}
	_tmp42_ = it;
	_tmp43_ = g_variant_iter_next_value (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_variant_get_maybe (_tmp44_);
	_g_variant_unref0 (meta_data);
	meta_data = _tmp45_;
	_g_variant_unref0 (_tmp44_);
	_tmp46_ = meta_data;
	if (_tmp46_ != NULL) {
		GVariant* _tmp47_ = NULL;
		GVariant* _tmp48_ = NULL;
		_tmp47_ = meta_data;
		_tmp48_ = g_variant_get_variant (_tmp47_);
		_g_variant_unref0 (meta_data);
		meta_data = _tmp48_;
	}
	item = NULL;
	object = NULL;
	_tmp49_ = upnp_class;
	_tmp50_ = g_variant_get_string (_tmp49_, NULL);
	_tmp51_ = _tmp50_;
	_tmp53_ = (NULL == _tmp51_) ? 0 : g_quark_from_string (_tmp51_);
	if (_tmp53_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp54_ = NULL;
				RygelMediaContainer* _tmp55_ = NULL;
				RygelMediaExportPhotoItem* _tmp56_ = NULL;
				_tmp54_ = id;
				_tmp55_ = parent;
				_tmp56_ = rygel_media_export_photo_item_new (_tmp54_, _tmp55_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp56_;
				break;
			}
		}
	} else if (_tmp53_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp57_ = NULL;
				RygelMediaContainer* _tmp58_ = NULL;
				RygelMediaExportVideoItem* _tmp59_ = NULL;
				_tmp57_ = id;
				_tmp58_ = parent;
				_tmp59_ = rygel_media_export_video_item_new (_tmp57_, _tmp58_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp59_;
				break;
			}
		}
	} else if (_tmp53_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp60_ = NULL;
				RygelMediaContainer* _tmp61_ = NULL;
				RygelMediaExportMusicItem* _tmp62_ = NULL;
				_tmp60_ = id;
				_tmp61_ = parent;
				_tmp62_ = rygel_media_export_music_item_new (_tmp60_, _tmp61_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaFileItem*) _tmp62_;
				break;
			}
		}
	} else if (_tmp53_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				GFile* _tmp63_ = NULL;
				RygelMediaContainer* _tmp64_ = NULL;
				RygelMediaFileItem* _tmp65_ = NULL;
				_tmp63_ = file;
				_tmp64_ = parent;
				_tmp65_ = rygel_media_export_item_factory_create_playlist_item (_tmp63_, _tmp64_, "");
				_g_object_unref0 (item);
				item = _tmp65_;
				break;
			}
		}
	} else if (_tmp53_ == g_quark_from_string (RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp66_ = NULL;
				gchar* _tmp67_ = NULL;
				gchar* _tmp68_ = NULL;
				RygelMediaContainer* _tmp69_ = NULL;
				GFile* _tmp70_ = NULL;
				gchar* _tmp71_ = NULL;
				gchar* _tmp72_ = NULL;
				RygelMediaExportDVDContainer* _tmp73_ = NULL;
				RygelMediaObject* _tmp74_ = NULL;
				GFile* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				_tmp66_ = id;
				_tmp67_ = g_strconcat ("dvd:", _tmp66_, NULL);
				_tmp68_ = _tmp67_;
				_tmp69_ = parent;
				_tmp70_ = file;
				_tmp71_ = g_file_get_path (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = rygel_media_export_dvd_container_new (_tmp68_, _tmp69_, "", _tmp72_);
				_g_object_unref0 (object);
				object = (RygelMediaObject*) _tmp73_;
				_g_free0 (_tmp72_);
				_g_free0 (_tmp68_);
				_tmp74_ = object;
				_tmp75_ = file;
				_tmp76_ = g_file_get_uri (_tmp75_);
				_tmp77_ = _tmp76_;
				rygel_media_object_add_uri (_tmp74_, _tmp77_);
				_g_free0 (_tmp77_);
				result = object;
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				_g_object_unref0 (object);
				_g_object_unref0 (item);
				_g_free0 (id);
				_g_variant_iter_free0 (it);
				_g_variant_unref0 (meta_data);
				_g_variant_unref0 (audio_info);
				_g_variant_unref0 (video_info);
				_g_variant_unref0 (info);
				_g_variant_unref0 (dlna_profile);
				_g_variant_unref0 (file_info);
				_g_variant_unref0 (upnp_class);
				return result;
			}
		}
	}
	_tmp78_ = item;
	_tmp79_ = file;
	_tmp80_ = g_file_get_uri (_tmp79_);
	_tmp81_ = _tmp80_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp78_, _tmp81_);
	_g_free0 (_tmp81_);
	_tmp82_ = dlna_profile;
	if (_tmp82_ != NULL) {
		RygelMediaFileItem* _tmp83_ = NULL;
		GVariant* _tmp84_ = NULL;
		_tmp83_ = item;
		_tmp84_ = dlna_profile;
		rygel_media_export_item_factory_apply_dlna_profile (_tmp83_, _tmp84_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp85_ = file_info;
	if (_tmp85_ != NULL) {
		RygelMediaFileItem* _tmp86_ = NULL;
		GVariant* _tmp87_ = NULL;
		_tmp86_ = item;
		_tmp87_ = file_info;
		rygel_media_export_item_factory_apply_file_info (_tmp86_, _tmp87_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp88_ = info;
	if (_tmp88_ != NULL) {
		RygelMediaFileItem* _tmp89_ = NULL;
		GVariant* _tmp90_ = NULL;
		_tmp89_ = item;
		_tmp90_ = info;
		rygel_media_export_item_factory_apply_info (_tmp89_, _tmp90_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp91_ = audio_info;
	if (_tmp91_ != NULL) {
		RygelMediaFileItem* _tmp92_ = NULL;
		GVariant* _tmp93_ = NULL;
		_tmp92_ = item;
		_tmp93_ = audio_info;
		rygel_media_export_item_factory_apply_audio_info (_tmp92_, _tmp93_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp94_ = video_info;
	if (_tmp94_ != NULL) {
		RygelMediaFileItem* _tmp95_ = NULL;
		GVariant* _tmp96_ = NULL;
		_tmp95_ = item;
		_tmp96_ = video_info;
		rygel_media_export_item_factory_apply_video_info (_tmp95_, _tmp96_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp97_ = meta_data;
	if (_tmp97_ != NULL) {
		RygelMediaFileItem* _tmp98_ = NULL;
		GVariant* _tmp99_ = NULL;
		_tmp98_ = item;
		_tmp99_ = meta_data;
		rygel_media_export_item_factory_apply_meta_data (_tmp98_, _tmp99_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			_g_object_unref0 (item);
			_g_free0 (id);
			_g_variant_iter_free0 (it);
			_g_variant_unref0 (meta_data);
			_g_variant_unref0 (audio_info);
			_g_variant_unref0 (video_info);
			_g_variant_unref0 (info);
			_g_variant_unref0 (dlna_profile);
			_g_variant_unref0 (file_info);
			_g_variant_unref0 (upnp_class);
			return NULL;
		}
	}
	_tmp100_ = item;
	_tmp101_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = string_contains (_tmp102_, "T");
	if (_tmp103_) {
		SoupDate* date = NULL;
		RygelMediaFileItem* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		const gchar* _tmp106_ = NULL;
		SoupDate* _tmp107_ = NULL;
		RygelMediaFileItem* _tmp108_ = NULL;
		SoupDate* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		_tmp104_ = item;
		_tmp105_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = soup_date_new_from_string (_tmp106_);
		date = _tmp107_;
		_tmp108_ = item;
		_tmp109_ = date;
		_tmp110_ = soup_date_to_string (_tmp109_, SOUP_DATE_ISO8601_FULL);
		_tmp111_ = _tmp110_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp108_, _tmp111_);
		_g_free0 (_tmp111_);
		__vala_SoupDate_free0 (date);
	}
	_tmp112_ = item;
	_tmp113_ = _g_object_ref0 ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp112_) : NULL));
	result = _tmp113_;
	_g_object_unref0 (object);
	_g_object_unref0 (item);
	_g_free0 (id);
	_g_variant_iter_free0 (it);
	_g_variant_unref0 (meta_data);
	_g_variant_unref0 (audio_info);
	_g_variant_unref0 (video_info);
	_g_variant_unref0 (info);
	_g_variant_unref0 (dlna_profile);
	_g_variant_unref0 (file_info);
	_g_variant_unref0 (upnp_class);
	return result;
}


void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	RygelMediaFileItem* _tmp12_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gchar* album = NULL;
	gchar* _tmp21_ = NULL;
	GVariantIter* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	RygelMediaFileItem* _tmp30_ = NULL;
	gint32 disc = 0;
	GVariantIter* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	gint32 _tmp34_ = 0;
	gint32 _tmp35_ = 0;
	RygelMediaFileItem* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsmsiii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp9_ = val;
	if (_tmp9_ == NULL) {
		_g_free0 (_tmp8_);
		_tmp8_ = NULL;
	} else {
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = item;
	rygel_media_object_set_artist ((RygelMediaObject*) _tmp12_, _tmp8_);
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp18_ = val;
	if (_tmp18_ == NULL) {
		_g_free0 (_tmp17_);
		_tmp17_ = NULL;
	} else {
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_g_free0 (_tmp17_);
		_tmp17_ = _tmp20_;
	}
	_tmp21_ = g_strdup (_tmp17_);
	album = _tmp21_;
	_tmp22_ = it;
	_tmp23_ = g_variant_iter_next_value (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_maybe (_tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_g_variant_unref0 (_tmp24_);
	_tmp27_ = val;
	if (_tmp27_ == NULL) {
		_g_free0 (_tmp26_);
		_tmp26_ = NULL;
	} else {
		GVariant* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		_tmp28_ = val;
		_tmp29_ = g_variant_dup_string (_tmp28_, NULL);
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp29_;
	}
	_tmp30_ = item;
	rygel_media_object_set_genre ((RygelMediaObject*) _tmp30_, _tmp26_);
	_tmp31_ = it;
	_tmp32_ = g_variant_iter_next_value (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_int32 (_tmp33_);
	_tmp35_ = _tmp34_;
	_g_variant_unref0 (_tmp33_);
	disc = _tmp35_;
	_tmp36_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp37_ = NULL;
		RygelAudioItem* _tmp38_ = NULL;
		gint32 track_number = 0;
		GVariantIter* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
		GVariant* _tmp41_ = NULL;
		gint32 _tmp42_ = 0;
		gint32 _tmp43_ = 0;
		RygelAudioItem* _tmp44_ = NULL;
		GVariantIter* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		gint32 _tmp48_ = 0;
		RygelAudioItem* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		RygelMediaFileItem* _tmp51_ = NULL;
		_tmp37_ = item;
		_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp37_) : NULL);
		audio_item = _tmp38_;
		_tmp39_ = it;
		_tmp40_ = g_variant_iter_next_value (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_variant_get_int32 (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_variant_unref0 (_tmp41_);
		track_number = _tmp43_;
		_tmp44_ = audio_item;
		_tmp45_ = it;
		_tmp46_ = g_variant_iter_next_value (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_variant_get_int32 (_tmp47_);
		rygel_audio_item_set_bitrate (_tmp44_, (gint) _tmp48_);
		_g_variant_unref0 (_tmp47_);
		_tmp49_ = audio_item;
		_tmp50_ = album;
		rygel_audio_item_set_album (_tmp49_, _tmp50_);
		_tmp51_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp52_ = NULL;
			RygelMediaExportMusicItem* _tmp53_ = NULL;
			RygelMediaExportMusicItem* _tmp54_ = NULL;
			gint32 _tmp55_ = 0;
			RygelMediaExportMusicItem* _tmp56_ = NULL;
			gint32 _tmp57_ = 0;
			_tmp52_ = item;
			_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp52_) : NULL);
			music_item = _tmp53_;
			_tmp54_ = music_item;
			_tmp55_ = disc;
			_tmp54_->disc = (gint) _tmp55_;
			_tmp56_ = music_item;
			_tmp57_ = track_number;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp56_, (gint) _tmp57_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_g_free0 (_tmp26_);
	_g_free0 (album);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelVisualItem* visual_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelVisualItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelVisualItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelVisualItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	RygelVisualItem* _tmp19_ = NULL;
	GVariantIter* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	gint32 _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(iii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VISUAL_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp5_) : NULL);
	visual_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = visual_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_visual_item_set_width (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = visual_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_visual_item_set_height (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_tmp19_ = visual_item;
	_tmp20_ = it;
	_tmp21_ = g_variant_iter_next_value (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_variant_get_int32 (_tmp22_);
	rygel_visual_item_set_color_depth (_tmp19_, (gint) _tmp23_);
	_g_variant_unref0 (_tmp22_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (visual_item);
}


void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelAudioItem* audio_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelAudioItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelAudioItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelAudioItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp5_) : NULL);
	audio_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = audio_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_audio_item_set_channels (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = audio_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_audio_item_set_sample_freq (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (audio_item);
}


void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	RygelMediaFileItem* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsi)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp8_ = val;
	if (_tmp8_ != NULL) {
		RygelMediaFileItem* _tmp9_ = NULL;
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = item;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = val;
	if (_tmp17_ != NULL) {
		RygelMediaFileItem* _tmp18_ = NULL;
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp18_ = item;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_tmp21_ = _tmp20_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaFileItem* _tmp23_ = NULL;
		GVariantIter* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		GVariant* _tmp26_ = NULL;
		gint32 _tmp27_ = 0;
		_tmp23_ = item;
		_tmp24_ = it;
		_tmp25_ = g_variant_iter_next_value (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_variant_get_int32 (_tmp26_);
		rygel_audio_item_set_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp23_) : NULL, (glong) _tmp27_);
		_g_variant_unref0 (_tmp26_);
	}
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	GVariantIter* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ss)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = it;
	_tmp5_ = g_variant_iter_next_value (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_dup_string (_tmp6_, NULL);
	_tmp8_ = _tmp7_;
	rygel_media_file_item_set_dlna_profile (_tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (_tmp6_);
	_tmp9_ = item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	rygel_media_file_item_set_mime_type (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (_tmp12_);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_file_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* display_name = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaFileItem* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GVariant* mime = NULL;
	GVariantIter* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	RygelMediaFileItem* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	RygelMediaFileItem* _tmp25_ = NULL;
	GVariantIter* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_ = NULL;
	guint64 _tmp29_ = 0ULL;
	RygelMediaFileItem* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	RygelMediaFileItem* _tmp40_ = NULL;
	GVariantIter* _tmp41_ = NULL;
	GVariant* _tmp42_ = NULL;
	GVariant* _tmp43_ = NULL;
	guint64 _tmp44_ = 0ULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(sstt)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_g_variant_unref0 (display_name);
	display_name = _tmp4_;
	_tmp6_ = item;
	_tmp7_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		RygelMediaFileItem* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = item;
		_tmp10_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp5_) {
		RygelMediaFileItem* _tmp12_ = NULL;
		GVariant* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp12_ = item;
		_tmp13_ = display_name;
		_tmp14_ = g_variant_dup_string (_tmp13_, NULL);
		_tmp15_ = _tmp14_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = it;
	_tmp17_ = g_variant_iter_next_value (_tmp16_);
	mime = _tmp17_;
	_tmp18_ = item;
	_tmp19_ = rygel_media_file_item_get_mime_type (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		RygelMediaFileItem* _tmp21_ = NULL;
		GVariant* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp21_ = item;
		_tmp22_ = mime;
		_tmp23_ = g_variant_dup_string (_tmp22_, NULL);
		_tmp24_ = _tmp23_;
		rygel_media_file_item_set_mime_type (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = item;
	_tmp26_ = it;
	_tmp27_ = g_variant_iter_next_value (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_variant_get_uint64 (_tmp28_);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp25_, (guint64) ((gint64) _tmp29_));
	_g_variant_unref0 (_tmp28_);
	_tmp30_ = item;
	_tmp31_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == NULL) {
		GTimeVal tv = {0};
		RygelMediaFileItem* _tmp33_ = NULL;
		guint64 _tmp34_ = 0ULL;
		guint64 _tmp35_ = 0ULL;
		GTimeVal _tmp36_ = {0};
		RygelMediaFileItem* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		_tmp33_ = item;
		_tmp34_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_.tv_sec = (glong) _tmp35_;
		_tmp36_.tv_usec = (glong) 0;
		tv = _tmp36_;
		_tmp37_ = item;
		_tmp38_ = g_time_val_to_iso8601 (&tv);
		_tmp39_ = _tmp38_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp37_, _tmp39_);
		_g_free0 (_tmp39_);
	}
	_tmp40_ = item;
	_tmp41_ = it;
	_tmp42_ = g_variant_iter_next_value (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_variant_get_uint64 (_tmp43_);
	rygel_media_file_item_set_size (_tmp40_, (gint64) _tmp44_);
	_g_variant_unref0 (_tmp43_);
	_g_variant_unref0 (mime);
	_g_variant_unref0 (display_name);
	_g_variant_iter_free0 (it);
}



