/* cheese-window.c generated by valac 0.13.3, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <gee.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cheese-config.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _CheeseMainWindow {
	GtkWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkVBox* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkMenuBar* menubar;
	GtkHBox* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkHBox* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterBox* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterRectangle* background_layer;
	ClutterText* error_layer;
	ClutterBox* current_effects_grid;
	gint current_effects_page;
	GeeArrayList* effects_grids;
	GtkAction* take_photo_action;
	GtkAction* take_video_action;
	GtkAction* take_burst_action;
	GtkAction* photo_mode_action;
	GtkAction* video_mode_action;
	GtkAction* burst_mode_action;
	GtkToggleAction* effects_toggle_action;
	GtkToggleAction* wide_mode_action;
	GtkToggleAction* fullscreen_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean is_camera_actions_sensitive;
	gboolean action_cancelled;
	gboolean is_command_line_startup;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheesePreferencesDialog* preferences_dialog;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
	GeeHashMap* action_sensitivities;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE 9
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda0_ (CheeseMainWindow* self);
static gboolean ___lambda0__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active);
static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri);
static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
CheeseMainWindow* cheese_main_window_new (void);
CheeseMainWindow* cheese_main_window_construct (GType object_type);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self) {
	CheesePreferencesDialog* _tmp0_;
	CheesePreferencesDialog* _tmp4_;
	CheeseMediaMode _tmp5_;
	CheesePreferencesDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		CheeseCamera* _tmp1_;
		GSettings* _tmp2_;
		CheesePreferencesDialog* _tmp3_;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->settings;
		_tmp3_ = cheese_preferences_dialog_new (_tmp1_, _tmp2_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp3_;
	}
	_tmp4_ = self->priv->preferences_dialog;
	_tmp5_ = self->priv->current_mode;
	cheese_preferences_dialog_set_current_mode (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->preferences_dialog;
	cheese_preferences_dialog_show (_tmp6_);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_;
	GdkEventButton _tmp1_;
	gdouble _tmp2_;
	GdkEventButton _tmp3_;
	gdouble _tmp4_;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	CheeseThumbView* _tmp8_;
	GtkTreePath* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GdkEventButton _tmp16_;
	GdkEventType _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_tmp6_ = _gtk_tree_path_copy0 (_tmp5_);
	_gtk_tree_path_free0 (path);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp8_ = self->priv->thumb_view;
	_tmp9_ = path;
	_tmp10_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		CheeseThumbView* _tmp11_;
		CheeseThumbView* _tmp12_;
		GtkTreePath* _tmp13_;
		CheeseThumbView* _tmp14_;
		GtkTreePath* _tmp15_;
		_tmp11_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp11_, "unselect-all");
		_tmp12_ = self->priv->thumb_view;
		_tmp13_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->thumb_view;
		_tmp15_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp14_, _tmp15_, NULL, FALSE);
	}
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.type;
	if (_tmp17_ == GDK_BUTTON_PRESS) {
		GdkEventButton _tmp18_;
		guint _tmp19_;
		_tmp18_ = *event;
		_tmp19_ = _tmp18_.button;
		if (_tmp19_ == ((guint) 3)) {
			GtkMenu* _tmp20_;
			CheeseThumbView* _tmp21_;
			GdkEventButton _tmp22_;
			guint _tmp23_;
			GdkEventButton _tmp24_;
			guint32 _tmp25_;
			_tmp20_ = self->priv->thumbnail_popup;
			_tmp21_ = self->priv->thumb_view;
			_tmp22_ = *event;
			_tmp23_ = _tmp22_.button;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.time;
			gtk_menu_popup (_tmp20_, NULL, (GtkWidget*) _tmp21_, NULL, NULL, _tmp23_, _tmp25_);
		}
	} else {
		GdkEventButton _tmp26_;
		GdkEventType _tmp27_;
		_tmp26_ = *event;
		_tmp27_ = _tmp26_.type;
		if (_tmp27_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GdkScreen* _tmp6_ = NULL;
		GdkScreen* _tmp7_;
		GdkScreen* _tmp8_;
		const gchar* _tmp9_;
		guint32 _tmp10_ = 0U;
		_tmp3_ = filename;
		_tmp4_ = g_filename_to_uri (_tmp3_, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (uri);
		uri = _tmp5_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (screen);
		screen = _tmp7_;
		_tmp8_ = screen;
		_tmp9_ = uri;
		_tmp10_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* _tmp15_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = filename;
		_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not open %s", _tmp11_);
		_tmp13_ = g_object_ref_sink (_tmp12_);
		error_dialog = _tmp13_;
		_tmp14_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	gint response = 0;
	GtkMessageDialog* confirmation_dialog = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GList* _tmp6_;
				guint _tmp7_ = 0U;
				GList* _tmp8_;
				gint _tmp9_;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				GtkMessageDialog* _tmp17_;
				GtkMessageDialog* _tmp18_;
				GtkMessageDialog* _tmp19_;
				GtkMessageDialog* _tmp20_;
				GtkMessageDialog* _tmp21_;
				GtkMessageDialog* _tmp22_;
				gint _tmp23_ = 0;
				GtkMessageDialog* _tmp24_;
				gint _tmp25_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (confirmation_dialog);
					_g_object_unref0 (file);
					return;
				}
				_tmp14_ = file;
				_tmp15_ = g_file_get_basename (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "Are you sure you want to permanently delete the file \"%s\"?", _tmp16_);
				_tmp18_ = g_object_ref_sink (_tmp17_);
				_g_object_unref0 (confirmation_dialog);
				confirmation_dialog = _tmp18_;
				_g_free0 (_tmp16_);
				_tmp19_ = confirmation_dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp19_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
				_tmp20_ = confirmation_dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp20_, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
				_tmp21_ = confirmation_dialog;
				gtk_message_dialog_format_secondary_text (_tmp21_, "%s", "If you delete an item, it will be permanently lost");
				_tmp22_ = confirmation_dialog;
				_tmp23_ = gtk_dialog_run ((GtkDialog*) _tmp22_);
				response = _tmp23_;
				_tmp24_ = confirmation_dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp24_);
				_tmp25_ = response;
				if (_tmp25_ == ((gint) GTK_RESPONSE_ACCEPT)) {
					{
						GFile* _tmp26_;
						_tmp26_ = file;
						g_file_delete (_tmp26_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch3_g_error;
						}
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* err = NULL;
						GFile* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						GtkMessageDialog* _tmp30_;
						GtkMessageDialog* _tmp31_;
						GtkMessageDialog* _tmp32_;
						GtkMessageDialog* error_dialog;
						GtkMessageDialog* _tmp33_;
						GtkMessageDialog* _tmp34_;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp27_ = file;
						_tmp28_ = g_file_get_path (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not delete %s", _tmp29_);
						_tmp31_ = g_object_ref_sink (_tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp29_);
						error_dialog = _tmp32_;
						_tmp33_ = error_dialog;
						gtk_dialog_run ((GtkDialog*) _tmp33_);
						_tmp34_ = error_dialog;
						gtk_widget_destroy ((GtkWidget*) _tmp34_);
						_g_object_unref0 (error_dialog);
						_g_error_free0 (err);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						__g_list_free__g_object_unref0_0 (files);
						_g_object_unref0 (confirmation_dialog);
						_g_object_unref0 (file);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (confirmation_dialog);
	_g_object_unref0 (file);
}


void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GList* _tmp6_;
				guint _tmp7_ = 0U;
				GList* _tmp8_;
				gint _tmp9_;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp14_;
					_tmp14_ = file;
					g_file_trash (_tmp14_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* err = NULL;
					GFile* _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					GtkMessageDialog* _tmp18_;
					GtkMessageDialog* _tmp19_;
					GtkMessageDialog* _tmp20_;
					GtkMessageDialog* error_dialog;
					GtkMessageDialog* _tmp21_;
					GtkMessageDialog* _tmp22_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp15_ = file;
					_tmp16_ = g_file_get_path (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not move %s to trash", _tmp17_);
					_tmp19_ = g_object_ref_sink (_tmp18_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp17_);
					error_dialog = _tmp20_;
					_tmp21_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp21_);
					_tmp22_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp22_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GFile* file_to_trash = NULL;
		GFileInfo* file_info = NULL;
		CheeseFileUtil* _tmp0_;
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* directory;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_ = NULL;
		GFileEnumerator* enumerator;
		CheeseFileUtil* _tmp19_;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_;
		GFileEnumerator* _tmp23_ = NULL;
		GFileEnumerator* _tmp24_;
		_tmp0_ = self->priv->fileutil;
		_tmp1_ = cheese_fileutil_get_photo_path (_tmp0_);
		_tmp2_ = g_file_new_for_path (_tmp1_);
		directory = _tmp2_;
		_tmp3_ = directory;
		_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		enumerator = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		while (TRUE) {
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_ = NULL;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			CheeseFileUtil* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* _tmp17_ = NULL;
			GFile* _tmp18_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp7_;
			_tmp8_ = file_info;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = self->priv->fileutil;
			_tmp10_ = cheese_fileutil_get_photo_path (_tmp9_);
			_tmp11_ = g_strconcat (_tmp10_, G_DIR_SEPARATOR_S, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = file_info;
			_tmp14_ = g_file_info_get_name (_tmp13_);
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_file_new_for_path (_tmp16_);
			_g_object_unref0 (file_to_trash);
			file_to_trash = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_tmp18_ = file_to_trash;
			g_file_trash (_tmp18_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
		}
		_tmp19_ = self->priv->fileutil;
		_tmp20_ = cheese_fileutil_get_video_path (_tmp19_);
		_tmp21_ = g_file_new_for_path (_tmp20_);
		_g_object_unref0 (directory);
		directory = _tmp21_;
		_tmp22_ = directory;
		_tmp23_ = g_file_enumerate_children (_tmp22_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp24_;
		while (TRUE) {
			GFileEnumerator* _tmp25_;
			GFileInfo* _tmp26_ = NULL;
			GFileInfo* _tmp27_;
			GFileInfo* _tmp28_;
			CheeseFileUtil* _tmp29_;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GFileInfo* _tmp33_;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GFile* _tmp37_ = NULL;
			GFile* _tmp38_;
			_tmp25_ = enumerator;
			_tmp26_ = g_file_enumerator_next_file (_tmp25_, NULL, &_inner_error_);
			_tmp27_ = _tmp26_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp27_;
			_tmp28_ = file_info;
			if (!(_tmp28_ != NULL)) {
				break;
			}
			_tmp29_ = self->priv->fileutil;
			_tmp30_ = cheese_fileutil_get_photo_path (_tmp29_);
			_tmp31_ = g_strconcat (_tmp30_, G_DIR_SEPARATOR_S, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = file_info;
			_tmp34_ = g_file_info_get_name (_tmp33_);
			_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_file_new_for_path (_tmp36_);
			_g_object_unref0 (file_to_trash);
			file_to_trash = _tmp37_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp32_);
			_tmp38_ = file_to_trash;
			g_file_trash (_tmp38_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
		}
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file_to_trash);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("cheese-window.vala:295: Error: %s\n", _tmp40_);
		_g_error_free0 (e);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_;
	gint _tmp13_ = 0;
	GtkFileChooserDialog* _tmp14_;
	gint _tmp15_;
	GtkFileChooserDialog* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save File", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp4_;
	_tmp5_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp5_, TRUE);
	_tmp6_ = filename;
	_tmp7_ = g_filename_display_basename (_tmp6_);
	_g_free0 (basename);
	basename = _tmp7_;
	_tmp8_ = save_as_dialog;
	_tmp9_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp8_, _tmp9_);
	_tmp10_ = save_as_dialog;
	_tmp11_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp10_, _tmp11_);
	_tmp12_ = save_as_dialog;
	_tmp13_ = gtk_dialog_run ((GtkDialog*) _tmp12_);
	response = _tmp13_;
	_tmp14_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp14_);
	_tmp15_ = response;
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp16_;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		GFile* _tmp19_ = NULL;
		GFile* src;
		const gchar* _tmp20_;
		GFile* _tmp21_ = NULL;
		GFile* dest;
		_tmp16_ = save_as_dialog;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_g_free0 (target_filename);
		target_filename = _tmp17_;
		_tmp18_ = filename;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		src = _tmp19_;
		_tmp20_ = target_filename;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		dest = _tmp21_;
		{
			GFile* _tmp22_;
			GFile* _tmp23_;
			_tmp22_ = src;
			_tmp23_ = dest;
			g_file_copy (_tmp22_, _tmp23_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp24_;
			GtkMessageDialog* _tmp25_;
			GtkMessageDialog* _tmp26_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp27_;
			GtkMessageDialog* _tmp28_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = target_filename;
			_tmp25_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not save %s", _tmp24_);
			_tmp26_ = g_object_ref_sink (_tmp25_);
			error_dialog = _tmp26_;
			_tmp27_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp27_);
			_tmp28_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp28_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp29_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self) {
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (screen);
	screen = _tmp1_;
	{
		guint32 _tmp2_ = 0U;
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (screen, "ghelp:cheese", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("cheese-window.vala:364: Error: %s\n", _tmp4_);
		_g_error_free0 (err);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self) {
	GtkAboutDialog* about_dialog = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkAboutDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->gtk_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "aboutdialog");
	_tmp2_ = _g_object_ref0 (GTK_ABOUT_DIALOG (_tmp1_));
	_g_object_unref0 (about_dialog);
	about_dialog = _tmp2_;
	gtk_window_set_transient_for ((GtkWindow*) about_dialog, (GtkWindow*) self);
	gtk_window_set_modal ((GtkWindow*) about_dialog, TRUE);
	gtk_about_dialog_set_version (about_dialog, VERSION);
	gtk_dialog_run ((GtkDialog*) about_dialog);
	gtk_widget_hide ((GtkWidget*) about_dialog);
	_g_object_unref0 (about_dialog);
}


void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkToggleAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "wide-mode", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_wide_mode (self, _tmp7_);
}


void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkToggleAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "fullscreen", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_fullscreen_mode (self, _tmp7_);
}


void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self) {
	GtkRadioAction* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	g_object_get (_tmp0_, "value", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	cheese_main_window_set_mode (self, (CheeseMediaMode) _tmp2_);
}


static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->photo_mode_action;
	gtk_action_set_sensitive (_tmp0_, TRUE);
	_tmp1_ = self->priv->video_mode_action;
	gtk_action_set_sensitive (_tmp1_, TRUE);
	_tmp2_ = self->priv->burst_mode_action;
	gtk_action_set_sensitive (_tmp2_, TRUE);
	_tmp3_ = self->priv->effects_toggle_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp3_, TRUE);
}


static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->photo_mode_action;
	gtk_action_set_sensitive (_tmp0_, FALSE);
	_tmp1_ = self->priv->video_mode_action;
	gtk_action_set_sensitive (_tmp1_, FALSE);
	_tmp2_ = self->priv->burst_mode_action;
	gtk_action_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = self->priv->effects_toggle_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp3_, FALSE);
}


static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* formats;
	GList* _tmp3_;
	CheeseVideoFormat* format = NULL;
	gint width;
	gint height;
	CheeseMediaMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_;
			gint _tmp6_ = 0;
			GSettings* _tmp7_;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_;
			gint _tmp10_ = 0;
			GSettings* _tmp11_;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				GList* _tmp17_;
				guint _tmp18_ = 0U;
				GList* _tmp19_;
				gint _tmp20_;
				GList* _tmp21_ = NULL;
				gconstpointer _tmp22_;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_;
				CheeseVideoFormat* _tmp25_;
				gint _tmp26_;
				gboolean _tmp30_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = formats;
				_tmp18_ = g_list_length (_tmp17_);
				if (!(((guint) _tmp16_) < _tmp18_)) {
					break;
				}
				_tmp19_ = formats;
				_tmp20_ = i;
				_tmp21_ = g_list_nth (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _tmp21_->data;
				format = (CheeseVideoFormat*) _tmp22_;
				_tmp24_ = width;
				_tmp25_ = format;
				_tmp26_ = _tmp25_->width;
				if (_tmp24_ == _tmp26_) {
					gint _tmp27_;
					CheeseVideoFormat* _tmp28_;
					gint _tmp29_;
					_tmp27_ = height;
					_tmp28_ = format;
					_tmp29_ = _tmp28_->height;
					_tmp23_ = _tmp27_ == _tmp29_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					CheeseCamera* _tmp31_;
					CheeseVideoFormat* _tmp32_;
					_tmp31_ = self->priv->camera;
					_tmp32_ = format;
					cheese_camera_set_video_format (_tmp31_, _tmp32_);
					break;
				}
			}
		}
	}
}


static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_;
	CheeseMediaMode _tmp1_;
	CheesePreferencesDialog* _tmp2_;
	CheeseMediaMode _tmp5_;
	GtkLabel* _tmp21_;
	GtkButton* _tmp22_;
	GtkAction* _tmp23_;
	GtkAction* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkAction* _tmp33_;
	GtkAction* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	_tmp2_ = self->priv->preferences_dialog;
	if (_tmp2_ != NULL) {
		CheesePreferencesDialog* _tmp3_;
		CheeseMediaMode _tmp4_;
		_tmp3_ = self->priv->preferences_dialog;
		_tmp4_ = self->priv->current_mode;
		cheese_preferences_dialog_set_current_mode (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->current_mode;
	switch (_tmp5_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkAction* _tmp6_;
			GtkAction* _tmp7_;
			GtkAction* _tmp8_;
			GtkButton* _tmp9_;
			GtkAction* _tmp10_;
			_tmp6_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp6_, TRUE);
			_tmp7_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp7_, FALSE);
			_tmp8_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp8_, FALSE);
			_tmp9_ = self->priv->take_action_button;
			_tmp10_ = self->priv->take_photo_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp9_, _tmp10_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkAction* _tmp11_;
			GtkAction* _tmp12_;
			GtkAction* _tmp13_;
			GtkButton* _tmp14_;
			GtkAction* _tmp15_;
			_tmp11_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp11_, FALSE);
			_tmp12_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp12_, TRUE);
			_tmp13_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp13_, FALSE);
			_tmp14_ = self->priv->take_action_button;
			_tmp15_ = self->priv->take_video_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp14_, _tmp15_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkAction* _tmp16_;
			GtkAction* _tmp17_;
			GtkAction* _tmp18_;
			GtkButton* _tmp19_;
			GtkAction* _tmp20_;
			_tmp16_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp16_, FALSE);
			_tmp17_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp17_, FALSE);
			_tmp18_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp18_, TRUE);
			_tmp19_ = self->priv->take_action_button;
			_tmp20_ = self->priv->take_burst_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp19_, _tmp20_);
			break;
		}
		default:
		break;
	}
	_tmp21_ = self->priv->take_action_button_label;
	_tmp22_ = self->priv->take_action_button;
	_tmp23_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = gtk_action_get_label (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("<b>", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "</b>", NULL);
	_tmp30_ = _tmp29_;
	gtk_label_set_label (_tmp21_, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp31_ = self->priv->take_action_button;
	_tmp32_ = self->priv->take_action_button;
	_tmp33_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = gtk_action_get_tooltip (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _tmp36_);
}


static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


static gboolean __lambda0_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkHBox* _tmp0_;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda0__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkHBox* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen_mode;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen_mode;
	if (_tmp1_) {
		gboolean _tmp2_;
		GtkMenuBar* _tmp5_;
		GtkHBox* _tmp6_;
		GtkHBox* _tmp7_;
		GtkButton** _tmp8_;
		gint _tmp8__length1;
		GtkClutterEmbed* _tmp13_;
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkAlignment* _tmp3_;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkAlignment* _tmp4_;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->menubar;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_show_all ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->buttons;
		_tmp8__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp8_;
			b_collection_length1 = _tmp8__length1;
			for (b_it = 0; b_it < _tmp8__length1; b_it = b_it + 1) {
				GtkButton* _tmp9_;
				GtkButton* b = NULL;
				_tmp9_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp9_;
				{
					GtkButton* _tmp10_;
					const gchar* _tmp11_ = NULL;
					_tmp10_ = b;
					_tmp11_ = gtk_buildable_get_name ((GtkBuildable*) _tmp10_);
					if (g_strcmp0 (_tmp11_, "take_action_button") != 0) {
						GtkButton* _tmp12_;
						_tmp12_ = b;
						gtk_button_set_relief (_tmp12_, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp13_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp13_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp14_;
		GtkMenuBar* _tmp17_;
		GtkHBox* _tmp18_;
		GtkButton** _tmp19_;
		gint _tmp19__length1;
		GtkHBox* _tmp24_;
		GtkClutterEmbed* _tmp25_;
		guint _tmp26_ = 0U;
		_tmp14_ = self->priv->is_wide_mode;
		if (_tmp14_) {
			GtkAlignment* _tmp15_;
			_tmp15_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
		} else {
			GtkAlignment* _tmp16_;
			_tmp16_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp16_);
		}
		_tmp17_ = self->priv->menubar;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_hide ((GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->buttons;
		_tmp19__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp19_;
			b_collection_length1 = _tmp19__length1;
			for (b_it = 0; b_it < _tmp19__length1; b_it = b_it + 1) {
				GtkButton* _tmp20_;
				GtkButton* b = NULL;
				_tmp20_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp20_;
				{
					GtkButton* _tmp21_;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = b;
					_tmp22_ = gtk_buildable_get_name ((GtkBuildable*) _tmp21_);
					if (g_strcmp0 (_tmp22_, "take_action_button") != 0) {
						GtkButton* _tmp23_;
						_tmp23_ = b;
						gtk_button_set_relief (_tmp23_, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp24_ = self->priv->buttons_area;
		gtk_widget_show ((GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp26_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp25_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp26_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	GtkRequisition req = {0};
	GtkRequisition _tmp31_ = {0};
	GtkRequisition _tmp32_ = {0};
	GtkRequisition _tmp33_;
	gint _tmp34_;
	GtkRequisition _tmp35_;
	gint _tmp36_;
	GtkClutterEmbed* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_;
		EogThumbNav* _tmp10_;
		GtkAlignment* _tmp11_;
		GtkWidget* _tmp12_ = NULL;
		GtkAlignment* _tmp15_;
		EogThumbNav* _tmp16_;
		GtkAlignment* _tmp17_;
		GtkAlignment* _tmp18_;
		GtkAlignment* _tmp19_;
		_tmp9_ = self->priv->thumb_view;
		gtk_icon_view_set_columns ((GtkIconView*) _tmp9_, 1);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		if (_tmp12_ != NULL) {
			GtkAlignment* _tmp13_;
			EogThumbNav* _tmp14_;
			_tmp13_ = self->priv->thumbnails_bottom;
			_tmp14_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		}
		_tmp15_ = self->priv->thumbnails_right;
		_tmp16_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->thumbnails_right;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->thumbnails_right;
		gtk_container_resize_children ((GtkContainer*) _tmp18_);
		_tmp19_ = self->priv->thumbnails_bottom;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	} else {
		CheeseThumbView* _tmp20_;
		EogThumbNav* _tmp21_;
		GtkAlignment* _tmp22_;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp26_;
		EogThumbNav* _tmp27_;
		GtkAlignment* _tmp28_;
		GtkAlignment* _tmp29_;
		GtkAlignment* _tmp30_;
		_tmp20_ = self->priv->thumb_view;
		gtk_icon_view_set_columns ((GtkIconView*) _tmp20_, 5000);
		_tmp21_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumbnails_right;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		if (_tmp23_ != NULL) {
			GtkAlignment* _tmp24_;
			EogThumbNav* _tmp25_;
			_tmp24_ = self->priv->thumbnails_right;
			_tmp25_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		}
		_tmp26_ = self->priv->thumbnails_bottom;
		_tmp27_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->thumbnails_bottom;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->thumbnails_bottom;
		gtk_container_resize_children ((GtkContainer*) _tmp29_);
		_tmp30_ = self->priv->thumbnails_right;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp31_, &_tmp32_);
	req = _tmp31_;
	req = _tmp32_;
	_tmp33_ = req;
	_tmp34_ = _tmp33_.width;
	_tmp35_ = req;
	_tmp36_ = _tmp35_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp34_, _tmp36_);
	_tmp37_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp37_, -1, -1);
}


void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterBox* _tmp0_;
	ClutterStage* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterStage* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterRectangle* _tmp7_;
	ClutterStage* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterStage* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size ((ClutterActor*) _tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size ((ClutterActor*) _tmp7_, _tmp10_, _tmp13_);
}


void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GSettings* _tmp0_;
	GtkToggleAction* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = action;
	_tmp2_ = gtk_toggle_action_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_;
	CheeseMediaMode _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		CheeseFileUtil* _tmp1_;
		CheeseMediaMode _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* file_name;
		GSettings* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GtkVBox* _tmp8_;
		const gchar* _tmp9_ = NULL;
		CheeseCamera* _tmp10_;
		const gchar* _tmp11_;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "flash");
		if (_tmp6_) {
			CheeseFlash* _tmp7_;
			_tmp7_ = self->priv->flash;
			cheese_flash_fire (_tmp7_);
		}
		_tmp8_ = self->priv->main_vbox;
		_tmp9_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) _tmp8_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp9_, NULL, NULL);
		_tmp10_ = self->priv->camera;
		_tmp11_ = file_name;
		cheese_camera_take_photo (_tmp10_, _tmp11_);
		_g_free0 (file_name);
	}
	_tmp12_ = self->priv->current_mode;
	if (_tmp12_ == CHEESE_MEDIA_MODE_PHOTO) {
		GtkAction* _tmp13_;
		_tmp13_ = self->priv->take_photo_action;
		gtk_action_set_sensitive (_tmp13_, TRUE);
		cheese_main_window_enable_mode_change (self);
	}
}


static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_;
		ClutterText* _tmp4_;
		CheeseCountdown* _tmp5_;
		CheeseCountdown* _tmp6_;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			GtkAction* _tmp3_;
			_tmp3_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp3_, FALSE);
			cheese_main_window_disable_mode_change (self);
		}
		_tmp4_ = self->priv->countdown_layer;
		_tmp5_ = cheese_countdown_new (_tmp4_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp5_;
		_tmp6_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp6_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_;
		GSettings* _tmp3_;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_;
		cheese_main_window_take_photo (self);
		_tmp6_ = self->priv->burst_count;
		self->priv->burst_count = _tmp6_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->is_bursting;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->is_recording;
			_tmp7_ = _tmp16_;
		}
		_tmp17_ = _tmp7_;
		if (_tmp17_) {
			CheeseMediaMode _tmp18_;
			self->priv->action_cancelled = TRUE;
			_tmp18_ = self->priv->current_mode;
			if (_tmp18_ == CHEESE_MEDIA_MODE_PHOTO) {
				CheeseCountdown* _tmp19_;
				_tmp19_ = self->priv->current_countdown;
				cheese_countdown_stop (_tmp19_);
				cheese_main_window_finish_countdown_callback (self);
			} else {
				CheeseMediaMode _tmp20_;
				_tmp20_ = self->priv->current_mode;
				if (_tmp20_ == CHEESE_MEDIA_MODE_BURST) {
					cheese_main_window_toggle_photo_bursting (self, FALSE);
				} else {
					CheeseMediaMode _tmp21_;
					_tmp21_ = self->priv->current_mode;
					if (_tmp21_ == CHEESE_MEDIA_MODE_VIDEO) {
						cheese_main_window_toggle_video_recording (self, FALSE);
					}
				}
			}
			self->priv->action_cancelled = FALSE;
		} else {
			gboolean _tmp22_;
			_tmp22_ = self->priv->is_effects_selector_active;
			if (_tmp22_) {
				GtkToggleAction* _tmp23_;
				_tmp23_ = self->priv->effects_toggle_action;
				gtk_toggle_action_set_active (_tmp23_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_;
		CheeseFileUtil* _tmp2_;
		CheeseMediaMode _tmp3_;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkButton* _tmp11_;
		GtkImage* _tmp12_;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		cheese_camera_start_video_recording (_tmp1_, _tmp4_);
		_tmp5_ = self->priv->take_action_button_label;
		_tmp6_ = _ ("Stop _Recording");
		_tmp7_ = g_strconcat ("<b>", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp11_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, "Stop recording");
		_tmp12_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp12_, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp13_;
		GtkLabel* _tmp14_;
		GtkButton* _tmp15_;
		GtkAction* _tmp16_;
		GtkAction* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkButton* _tmp24_;
		GtkButton* _tmp25_;
		GtkAction* _tmp26_;
		GtkAction* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		GtkImage* _tmp30_;
		_tmp13_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp13_);
		_tmp14_ = self->priv->take_action_button_label;
		_tmp15_ = self->priv->take_action_button;
		_tmp16_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gtk_action_get_label (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("<b>", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "</b>", NULL);
		_tmp23_ = _tmp22_;
		gtk_label_set_label (_tmp14_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp24_ = self->priv->take_action_button;
		_tmp25_ = self->priv->take_action_button;
		_tmp26_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = gtk_action_get_tooltip (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _tmp29_);
		_tmp30_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp30_, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkToggleAction* _tmp1_;
		GtkLabel* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkButton* _tmp8_;
		gboolean _tmp9_ = FALSE;
		GSettings* _tmp10_;
		gint _tmp11_ = 0;
		gboolean _tmp14_;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->effects_toggle_action;
		gtk_action_set_sensitive ((GtkAction*) _tmp1_, FALSE);
		_tmp2_ = self->priv->take_action_button_label;
		_tmp3_ = _ ("Stop _Taking Pictures");
		_tmp4_ = g_strconcat ("<b>", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "</b>", NULL);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp2_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp8_ = self->priv->take_action_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, "Stop taking pictures");
		cheese_main_window_burst_take_photo (self);
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_int (_tmp10_, "burst-delay");
		if ((_tmp11_ - 3500) < 1000) {
			GSettings* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp12_ = self->priv->settings;
			_tmp13_ = g_settings_get_boolean (_tmp12_, "countdown");
			_tmp9_ = _tmp13_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			guint _tmp15_ = 0U;
			_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3500, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp15_;
		} else {
			GSettings* _tmp16_;
			gint _tmp17_ = 0;
			guint _tmp18_ = 0U;
			_tmp16_ = self->priv->settings;
			_tmp17_ = g_settings_get_int (_tmp16_, "burst-delay");
			_tmp18_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp17_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp18_;
		}
	} else {
		gboolean _tmp19_ = FALSE;
		CheeseCountdown* _tmp20_;
		gboolean _tmp23_;
		GtkLabel* _tmp25_;
		GtkButton* _tmp26_;
		GtkAction* _tmp27_;
		GtkAction* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GtkButton* _tmp35_;
		GtkButton* _tmp36_;
		GtkAction* _tmp37_;
		GtkAction* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		CheeseFileUtil* _tmp41_;
		guint _tmp42_;
		_tmp20_ = self->priv->current_countdown;
		if (_tmp20_ != NULL) {
			CheeseCountdown* _tmp21_;
			gboolean _tmp22_;
			_tmp21_ = self->priv->current_countdown;
			_tmp22_ = _tmp21_->running;
			_tmp19_ = _tmp22_;
		} else {
			_tmp19_ = FALSE;
		}
		_tmp23_ = _tmp19_;
		if (_tmp23_) {
			CheeseCountdown* _tmp24_;
			_tmp24_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp24_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp25_ = self->priv->take_action_button_label;
		_tmp26_ = self->priv->take_action_button;
		_tmp27_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = gtk_action_get_label (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat ("<b>", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "</b>", NULL);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp25_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp35_ = self->priv->take_action_button;
		_tmp36_ = self->priv->take_action_button;
		_tmp37_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = gtk_action_get_tooltip (_tmp38_);
		_tmp40_ = _tmp39_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp40_);
		self->priv->burst_count = 0;
		_tmp41_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp41_);
		_tmp42_ = self->priv->burst_callback_id;
		g_source_remove (_tmp42_);
	}
}


void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_mode;
	if (_tmp0_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_take_photo (self);
	} else {
		CheeseMediaMode _tmp1_;
		_tmp1_ = self->priv->current_mode;
		if (_tmp1_ == CHEESE_MEDIA_MODE_VIDEO) {
			gboolean _tmp2_;
			_tmp2_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp2_);
		} else {
			CheeseMediaMode _tmp3_;
			_tmp3_ = self->priv->current_mode;
			if (_tmp3_ == CHEESE_MEDIA_MODE_BURST) {
				gboolean _tmp4_;
				_tmp4_ = self->priv->is_bursting;
				cheese_main_window_toggle_photo_bursting (self, !_tmp4_);
			}
		}
	}
}


void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GtkToggleAction* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GtkAction* _tmp19_;
	GtkToggleAction* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkAction* _tmp23_;
	GtkToggleAction* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	cheese_main_window_toggle_effects_selector (self, _tmp2_);
	_tmp3_ = self->priv->take_photo_action;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_action_set_sensitive (_tmp3_, !_tmp6_);
	_tmp7_ = self->priv->take_video_action;
	_tmp8_ = action;
	_tmp9_ = gtk_toggle_action_get_active (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_action_set_sensitive (_tmp7_, !_tmp10_);
	_tmp11_ = self->priv->take_burst_action;
	_tmp12_ = action;
	_tmp13_ = gtk_toggle_action_get_active (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_action_set_sensitive (_tmp11_, !_tmp14_);
	_tmp15_ = self->priv->photo_mode_action;
	_tmp16_ = action;
	_tmp17_ = gtk_toggle_action_get_active (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_action_set_sensitive (_tmp15_, !_tmp18_);
	_tmp19_ = self->priv->video_mode_action;
	_tmp20_ = action;
	_tmp21_ = gtk_toggle_action_get_active (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_action_set_sensitive (_tmp19_, !_tmp22_);
	_tmp23_ = self->priv->burst_mode_action;
	_tmp24_ = action;
	_tmp25_ = gtk_toggle_action_get_active (_tmp24_);
	_tmp26_ = _tmp25_;
	gtk_action_set_sensitive (_tmp23_, !_tmp26_);
}


gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	CheeseEffect* _tmp2_;
	CheeseCamera* _tmp3_;
	CheeseEffect* _tmp4_;
	GSettings* _tmp5_;
	CheeseEffect* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkToggleAction* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = source;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	g_object_get (_tmp6_, "name", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->effects_toggle_action;
	gtk_toggle_action_set_active (_tmp10_, FALSE);
	result = FALSE;
	return result;
}


void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	if (_tmp0_ != 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp1_ - 1);
	}
}


void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	CheeseEffectsManager* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp0_ != (_tmp4_ / EFFECTS_PER_PAGE)) {
		gint _tmp5_;
		_tmp5_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp5_ + 1);
	}
}


static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_;
	gint _tmp1_;
	ClutterBox* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	ClutterBox* _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_ = NULL;
	ClutterBox* _tmp13_;
	ClutterBox* _tmp14_;
	ClutterBox* _tmp15_;
	ClutterBox* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_container_get_children ((ClutterContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, (ClutterActor*) _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterBox* _tmp8_;
		ClutterBox* _tmp9_;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_container_remove ((ClutterContainer*) _tmp8_, CLUTTER_ACTOR (_tmp9_), NULL);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = (ClutterBox*) _tmp12_;
	_tmp13_ = self->priv->current_effects_grid;
	g_object_set ((GObject*) _tmp13_, "opacity", 0, NULL);
	_tmp14_ = self->priv->viewport_layout;
	_tmp15_ = self->priv->current_effects_grid;
	clutter_container_add ((ClutterContainer*) _tmp14_, CLUTTER_ACTOR (_tmp15_), NULL);
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_animate ((ClutterActor*) _tmp16_, (gulong) CLUTTER_LINEAR, (guint) 1000, "opacity", 255, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				CheeseEffectsManager* _tmp21_;
				GeeArrayList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint page_of_effect;
				CheeseEffectsManager* _tmp26_;
				GeeArrayList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_ = NULL;
				CheeseEffect* effect;
				gint _tmp30_;
				gint _tmp31_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = self->priv->effects_manager;
				_tmp22_ = _tmp21_->effects;
				_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
				_tmp24_ = _tmp23_;
				if (!(_tmp20_ < _tmp24_)) {
					break;
				}
				_tmp25_ = i;
				page_of_effect = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = self->priv->effects_manager;
				_tmp27_ = _tmp26_->effects;
				_tmp28_ = i;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
				effect = (CheeseEffect*) _tmp29_;
				_tmp30_ = page_of_effect;
				_tmp31_ = number;
				if (_tmp30_ == _tmp31_) {
					CheeseEffect* _tmp32_;
					gboolean _tmp33_ = FALSE;
					CheeseEffect* _tmp40_;
					_tmp32_ = effect;
					_tmp33_ = cheese_effect_is_preview_connected (_tmp32_);
					if (!_tmp33_) {
						CheeseEffect* _tmp34_;
						gconstpointer _tmp35_ = NULL;
						ClutterTexture* _tmp36_;
						ClutterTexture* texture;
						CheeseCamera* _tmp37_;
						CheeseEffect* _tmp38_;
						ClutterTexture* _tmp39_;
						_tmp34_ = effect;
						_tmp35_ = g_object_get_data ((GObject*) _tmp34_, "texture");
						_tmp36_ = _g_object_ref0 ((ClutterTexture*) _tmp35_);
						texture = _tmp36_;
						_tmp37_ = self->priv->camera;
						_tmp38_ = effect;
						_tmp39_ = texture;
						cheese_camera_connect_effect_texture (_tmp37_, _tmp38_, _tmp39_);
						_g_object_unref0 (texture);
					}
					_tmp40_ = effect;
					cheese_effect_enable_preview (_tmp40_);
				} else {
					CheeseEffect* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = effect;
					_tmp42_ = cheese_effect_is_preview_connected (_tmp41_);
					if (_tmp42_) {
						CheeseEffect* _tmp43_;
						_tmp43_ = effect;
						cheese_effect_disable_preview (_tmp43_);
					}
				}
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkAction* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GtkAction* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_effects_selector_active;
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->priv->current_effects_page;
		_tmp0_ = _tmp2_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = self->priv->effects_page_prev_action;
	_tmp4_ = _tmp0_;
	gtk_action_set_sensitive (_tmp3_, _tmp4_);
	_tmp6_ = self->priv->is_effects_selector_active;
	if (_tmp6_) {
		gint _tmp7_;
		CheeseEffectsManager* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp7_ = self->priv->current_effects_page;
		_tmp8_ = self->priv->effects_manager;
		_tmp9_ = _tmp8_->effects;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp7_ != (_tmp11_ / EFFECTS_PER_PAGE);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp12_ = self->priv->effects_page_next_action;
	_tmp13_ = _tmp5_;
	gtk_action_set_sensitive (_tmp12_, _tmp13_);
}


static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	CheeseCamera* _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		ClutterTexture* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->effects_grids;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == 0) {
			ClutterText* _tmp6_;
			const gchar* _tmp7_ = NULL;
			ClutterText* _tmp8_;
			_tmp6_ = self->priv->error_layer;
			_tmp7_ = _ ("No effects found");
			clutter_text_set_text (_tmp6_, _tmp7_);
			_tmp8_ = self->priv->error_layer;
			clutter_actor_show ((ClutterActor*) _tmp8_);
		} else {
			ClutterBox* _tmp9_;
			gint _tmp10_;
			_tmp9_ = self->priv->current_effects_grid;
			clutter_actor_show ((ClutterActor*) _tmp9_);
			_tmp10_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, _tmp10_);
		}
	} else {
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		ClutterTexture* _tmp16_;
		_tmp11_ = self->priv->effects_grids;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == 0) {
			ClutterText* _tmp14_;
			_tmp14_ = self->priv->error_layer;
			clutter_actor_hide ((ClutterActor*) _tmp14_);
		} else {
			ClutterBox* _tmp15_;
			_tmp15_ = self->priv->current_effects_grid;
			clutter_actor_hide ((ClutterActor*) _tmp15_);
		}
		_tmp16_ = self->priv->video_preview;
		clutter_actor_show ((ClutterActor*) _tmp16_);
	}
	_tmp17_ = self->priv->camera;
	_tmp18_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp17_, _tmp18_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_selected_effect_change (self, _sender, event);
	return result;
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_;
		CheeseEffectsManager* _tmp2_;
		CheeseEffectsManager* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp93_;
		gpointer _tmp94_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		_tmp3_ = self->priv->effects_manager;
		_tmp4_ = _tmp3_->effects;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == 0) {
			return;
		}
		_tmp7_ = gee_array_list_new (clutter_box_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_g_object_unref0 (self->priv->effects_grids);
		self->priv->effects_grids = _tmp7_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					CheeseEffectsManager* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					ClutterTableLayout* _tmp16_;
					ClutterTableLayout* _tmp17_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp18_;
					ClutterBox* _tmp19_;
					ClutterBox* _tmp20_;
					ClutterBox* grid;
					GeeArrayList* _tmp21_;
					ClutterBox* _tmp22_;
					ClutterTableLayout* _tmp23_;
					ClutterTableLayout* _tmp24_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = self->priv->effects_manager;
					_tmp13_ = _tmp12_->effects;
					_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					if (!(_tmp11_ <= (_tmp15_ / EFFECTS_PER_PAGE))) {
						break;
					}
					_tmp16_ = (ClutterTableLayout*) clutter_table_layout_new ();
					_tmp17_ = g_object_ref_sink (_tmp16_);
					table_layout = _tmp17_;
					_tmp18_ = table_layout;
					_tmp19_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp18_);
					_tmp20_ = g_object_ref_sink (_tmp19_);
					grid = _tmp20_;
					_tmp21_ = self->priv->effects_grids;
					_tmp22_ = grid;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					_tmp23_ = table_layout;
					clutter_table_layout_set_column_spacing (_tmp23_, (guint) 10);
					_tmp24_ = table_layout;
					clutter_table_layout_set_row_spacing (_tmp24_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp26_;
					gint _tmp28_;
					CheeseEffectsManager* _tmp29_;
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					CheeseEffectsManager* _tmp33_;
					GeeArrayList* _tmp34_;
					gint _tmp35_;
					gpointer _tmp36_ = NULL;
					CheeseEffect* effect;
					ClutterTexture* _tmp37_;
					ClutterTexture* _tmp38_;
					ClutterTexture* texture;
					ClutterBinLayout* _tmp39_;
					ClutterBinLayout* _tmp40_;
					ClutterBinLayout* layout;
					ClutterBinLayout* _tmp41_;
					ClutterBox* _tmp42_;
					ClutterBox* _tmp43_;
					ClutterBox* box;
					ClutterText* _tmp44_;
					ClutterText* _tmp45_;
					ClutterText* text;
					ClutterRectangle* _tmp46_;
					ClutterRectangle* _tmp47_;
					ClutterRectangle* rect;
					ClutterRectangle* _tmp48_;
					ClutterRectangle* _tmp49_;
					ClutterColor _tmp50_ = {0};
					ClutterColor _tmp51_;
					ClutterTexture* _tmp52_;
					ClutterBox* _tmp53_;
					ClutterTexture* _tmp54_;
					ClutterBox* _tmp55_;
					ClutterBox* _tmp56_;
					CheeseEffect* _tmp57_;
					CheeseEffect* _tmp58_;
					CheeseEffect* _tmp59_;
					ClutterTexture* _tmp60_;
					ClutterTexture* _tmp61_;
					ClutterBox* _tmp62_;
					ClutterText* _tmp63_;
					CheeseEffect* _tmp64_;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_;
					ClutterText* _tmp68_;
					ClutterColor _tmp69_ = {0};
					ClutterColor _tmp70_;
					ClutterRectangle* _tmp71_;
					ClutterText* _tmp72_;
					gfloat _tmp73_;
					gfloat _tmp74_;
					ClutterBox* _tmp75_;
					ClutterRectangle* _tmp76_;
					ClutterBox* _tmp77_;
					ClutterText* _tmp78_;
					GeeArrayList* _tmp79_;
					gint _tmp80_;
					gpointer _tmp81_ = NULL;
					ClutterBox* _tmp82_;
					ClutterLayoutManager* _tmp83_;
					ClutterLayoutManager* _tmp84_;
					ClutterTableLayout* _tmp85_;
					ClutterTableLayout* _tmp86_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp87_;
					ClutterBox* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					ClutterTableLayout* _tmp91_;
					ClutterBox* _tmp92_;
					_tmp26_ = _tmp25_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp28_ = i;
					_tmp29_ = self->priv->effects_manager;
					_tmp30_ = _tmp29_->effects;
					_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
					_tmp32_ = _tmp31_;
					if (!(_tmp28_ < _tmp32_)) {
						break;
					}
					_tmp33_ = self->priv->effects_manager;
					_tmp34_ = _tmp33_->effects;
					_tmp35_ = i;
					_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
					effect = (CheeseEffect*) _tmp36_;
					_tmp37_ = (ClutterTexture*) clutter_texture_new ();
					_tmp38_ = g_object_ref_sink (_tmp37_);
					texture = _tmp38_;
					_tmp39_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					_tmp40_ = g_object_ref_sink (_tmp39_);
					layout = _tmp40_;
					_tmp41_ = layout;
					_tmp42_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp41_);
					_tmp43_ = g_object_ref_sink (_tmp42_);
					box = _tmp43_;
					_tmp44_ = (ClutterText*) clutter_text_new ();
					_tmp45_ = g_object_ref_sink (_tmp44_);
					text = _tmp45_;
					_tmp46_ = (ClutterRectangle*) clutter_rectangle_new ();
					_tmp47_ = g_object_ref_sink (_tmp46_);
					rect = _tmp47_;
					_tmp48_ = rect;
					clutter_actor_set_opacity ((ClutterActor*) _tmp48_, (guint) 128);
					_tmp49_ = rect;
					clutter_color_from_string (&_tmp50_, "black");
					_tmp51_ = _tmp50_;
					clutter_rectangle_set_color (_tmp49_, &_tmp51_);
					_tmp52_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp52_, TRUE);
					_tmp53_ = box;
					_tmp54_ = texture;
					clutter_box_pack (_tmp53_, CLUTTER_ACTOR (_tmp54_), NULL, NULL, NULL);
					_tmp55_ = box;
					clutter_actor_set_reactive ((ClutterActor*) _tmp55_, TRUE);
					_tmp56_ = box;
					_tmp57_ = effect;
					_tmp58_ = _g_object_ref0 (_tmp57_);
					g_object_set_data_full ((GObject*) _tmp56_, "effect", _tmp58_, g_object_unref);
					_tmp59_ = effect;
					_tmp60_ = texture;
					_tmp61_ = _g_object_ref0 (_tmp60_);
					g_object_set_data_full ((GObject*) _tmp59_, "texture", _tmp61_, g_object_unref);
					_tmp62_ = box;
					g_signal_connect_object ((ClutterActor*) _tmp62_, "button-release-event", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event, self, 0);
					_tmp63_ = text;
					_tmp64_ = effect;
					g_object_get (_tmp64_, "name", &_tmp65_, NULL);
					_tmp66_ = _tmp65_;
					_tmp67_ = _tmp66_;
					clutter_text_set_text (_tmp63_, _tmp67_);
					_g_free0 (_tmp67_);
					_tmp68_ = text;
					clutter_color_from_string (&_tmp69_, "white");
					_tmp70_ = _tmp69_;
					clutter_text_set_color (_tmp68_, &_tmp70_);
					_tmp71_ = rect;
					_tmp72_ = text;
					_tmp73_ = clutter_actor_get_height ((ClutterActor*) _tmp72_);
					_tmp74_ = _tmp73_;
					clutter_actor_set_height ((ClutterActor*) _tmp71_, _tmp74_ + 5);
					_tmp75_ = box;
					_tmp76_ = rect;
					clutter_box_pack (_tmp75_, CLUTTER_ACTOR (_tmp76_), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp77_ = box;
					_tmp78_ = text;
					clutter_box_pack (_tmp77_, CLUTTER_ACTOR (_tmp78_), "x-align", CLUTTER_BIN_ALIGNMENT_CENTER, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp79_ = self->priv->effects_grids;
					_tmp80_ = i;
					_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, _tmp80_ / EFFECTS_PER_PAGE);
					_tmp82_ = (ClutterBox*) _tmp81_;
					_tmp83_ = clutter_box_get_layout_manager (_tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = _g_object_ref0 (CLUTTER_TABLE_LAYOUT (_tmp84_));
					_tmp86_ = _tmp85_;
					_g_object_unref0 (_tmp82_);
					table_layout = _tmp86_;
					_tmp87_ = table_layout;
					_tmp88_ = box;
					_tmp89_ = i;
					_tmp90_ = i;
					clutter_table_layout_pack (_tmp87_, CLUTTER_ACTOR (_tmp88_), (_tmp89_ % EFFECTS_PER_PAGE) % 3, (_tmp90_ % EFFECTS_PER_PAGE) / 3);
					_tmp91_ = table_layout;
					_tmp92_ = box;
					clutter_table_layout_set_expand (_tmp91_, (ClutterActor*) _tmp92_, FALSE, FALSE);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp93_ = self->priv->effects_grids;
		_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, 0);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = (ClutterBox*) _tmp94_;
	}
}


void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_camera_actions_sensitive = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		{
			GeeHashMap* _tmp2_;
			GeeSet* _tmp3_;
			GeeSet* _tmp4_;
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _tmp7_;
			GeeIterator* _key_it;
			_tmp2_ = self->priv->action_sensitivities;
			_tmp3_ = gee_map_get_keys ((GeeMap*) _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_key_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				gboolean _tmp9_ = FALSE;
				GeeIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				gchar* key;
				GtkBuilder* _tmp12_;
				const gchar* _tmp13_;
				GObject* _tmp14_ = NULL;
				GtkAction* _tmp15_;
				GtkAction* action;
				GtkAction* _tmp16_;
				GeeHashMap* _tmp17_;
				const gchar* _tmp18_;
				gpointer _tmp19_ = NULL;
				_tmp8_ = _key_it;
				_tmp9_ = gee_iterator_next (_tmp8_);
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = _key_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				key = (gchar*) _tmp11_;
				_tmp12_ = self->priv->gtk_builder;
				_tmp13_ = key;
				_tmp14_ = gtk_builder_get_object (_tmp12_, _tmp13_);
				_tmp15_ = _g_object_ref0 (GTK_ACTION (_tmp14_));
				action = _tmp15_;
				_tmp16_ = action;
				_tmp17_ = self->priv->action_sensitivities;
				_tmp18_ = key;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
				gtk_action_set_sensitive (_tmp16_, GPOINTER_TO_INT (_tmp19_));
				_g_object_unref0 (action);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
	} else {
		GHashFunc _tmp20_;
		GeeHashMap* _tmp21_;
		GtkBuilder* _tmp22_;
		GSList* _tmp23_ = NULL;
		GSList* objects;
		GSList* _tmp24_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar** _tmp47_ = NULL;
		gchar** active_actions;
		gint active_actions_length1;
		gint _active_actions_size_;
		gboolean flag = FALSE;
		GSList* _tmp48_;
		_tmp20_ = g_str_hash;
		_tmp21_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, _tmp20_, NULL, NULL);
		_g_object_unref0 (self->priv->action_sensitivities);
		self->priv->action_sensitivities = _tmp21_;
		_tmp22_ = self->priv->gtk_builder;
		_tmp23_ = gtk_builder_get_objects (_tmp22_);
		objects = _tmp23_;
		_tmp24_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp24_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp25_;
				GObject* obj = NULL;
				_tmp25_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp25_;
				{
					GObject* _tmp26_;
					_tmp26_ = obj;
					if (GTK_IS_ACTION (_tmp26_)) {
						GObject* _tmp27_;
						GtkAction* _tmp28_;
						GtkAction* action;
						GeeHashMap* _tmp29_;
						GtkAction* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						GtkAction* _tmp33_;
						gboolean _tmp34_;
						gboolean _tmp35_;
						_tmp27_ = obj;
						_tmp28_ = _g_object_ref0 (GTK_ACTION (_tmp27_));
						action = _tmp28_;
						_tmp29_ = self->priv->action_sensitivities;
						_tmp30_ = action;
						_tmp31_ = gtk_action_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = action;
						_tmp34_ = gtk_action_get_sensitive (_tmp33_);
						_tmp35_ = _tmp34_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, GINT_TO_POINTER (_tmp35_));
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp36_ = g_strdup ("cheese_action");
		_tmp37_ = g_strdup ("edit_action");
		_tmp38_ = g_strdup ("help_action");
		_tmp39_ = g_strdup ("quit");
		_tmp40_ = g_strdup ("help_contents");
		_tmp41_ = g_strdup ("about");
		_tmp42_ = g_strdup ("open");
		_tmp43_ = g_strdup ("save_as");
		_tmp44_ = g_strdup ("move_to_trash");
		_tmp45_ = g_strdup ("delete");
		_tmp46_ = g_strdup ("move_all_to_trash");
		_tmp47_ = g_new0 (gchar*, 11 + 1);
		_tmp47_[0] = _tmp36_;
		_tmp47_[1] = _tmp37_;
		_tmp47_[2] = _tmp38_;
		_tmp47_[3] = _tmp39_;
		_tmp47_[4] = _tmp40_;
		_tmp47_[5] = _tmp41_;
		_tmp47_[6] = _tmp42_;
		_tmp47_[7] = _tmp43_;
		_tmp47_[8] = _tmp44_;
		_tmp47_[9] = _tmp45_;
		_tmp47_[10] = _tmp46_;
		active_actions = _tmp47_;
		active_actions_length1 = 11;
		_active_actions_size_ = active_actions_length1;
		_tmp48_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp48_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp49_;
				GObject* obj = NULL;
				_tmp49_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp49_;
				{
					GObject* _tmp50_;
					flag = FALSE;
					_tmp50_ = obj;
					if (GTK_IS_ACTION (_tmp50_)) {
						GObject* _tmp51_;
						GtkAction* _tmp52_;
						GtkAction* action;
						gchar** _tmp53_;
						gint _tmp53__length1;
						gboolean _tmp59_;
						_tmp51_ = obj;
						_tmp52_ = _g_object_ref0 (GTK_ACTION (_tmp51_));
						action = _tmp52_;
						_tmp53_ = active_actions;
						_tmp53__length1 = active_actions_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp53_;
							s_collection_length1 = _tmp53__length1;
							for (s_it = 0; s_it < _tmp53__length1; s_it = s_it + 1) {
								gchar* _tmp54_;
								gchar* s = NULL;
								_tmp54_ = g_strdup (s_collection[s_it]);
								s = _tmp54_;
								{
									GtkAction* _tmp55_;
									const gchar* _tmp56_;
									const gchar* _tmp57_;
									const gchar* _tmp58_;
									_tmp55_ = action;
									_tmp56_ = gtk_action_get_name (_tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = s;
									if (g_strcmp0 (_tmp57_, _tmp58_) == 0) {
										flag = TRUE;
									}
									_g_free0 (s);
								}
							}
						}
						_tmp59_ = flag;
						if (!_tmp59_) {
							GObject* _tmp60_;
							_tmp60_ = obj;
							gtk_action_set_sensitive (GTK_ACTION (_tmp60_), FALSE);
						}
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		active_actions = (_vala_array_free (active_actions, active_actions_length1, (GDestroyNotify) g_free), NULL);
		_g_slist_free0 (objects);
	}
}


static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state) {
	GstState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_state;
	if (_tmp0_ == GST_STATE_PLAYING) {
		gboolean _tmp1_;
		CheeseEffectsManager* _tmp2_;
		GSettings* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		CheeseEffect* _tmp6_ = NULL;
		CheeseEffect* _tmp7_;
		CheeseEffect* effect;
		CheeseEffect* _tmp8_;
		_tmp1_ = self->priv->is_camera_actions_sensitive;
		if (!_tmp1_) {
			cheese_main_window_toggle_camera_actions_sensitivities (self, TRUE);
		}
		_tmp2_ = self->priv->effects_manager;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_string (_tmp3_, "selected-effect");
		_tmp5_ = _tmp4_;
		_tmp6_ = cheese_effects_manager_get_effect (_tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		effect = _tmp7_;
		_tmp8_ = effect;
		if (_tmp8_ != NULL) {
			CheeseCamera* _tmp9_;
			CheeseEffect* _tmp10_;
			_tmp9_ = self->priv->camera;
			_tmp10_ = effect;
			cheese_camera_set_effect (_tmp9_, _tmp10_);
		}
		_g_object_unref0 (effect);
	}
}


void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_wide_mode;
	if (_tmp0_) {
		return;
	}
	self->priv->is_command_line_startup = TRUE;
	_tmp1_ = self->priv->wide_mode_action;
	gtk_toggle_action_set_active (_tmp1_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self) {
	GtkToggleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->is_command_line_startup = TRUE;
	_tmp0_ = self->priv->fullscreen_action;
	gtk_toggle_action_set_active (_tmp0_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_;
	ClutterScript* _tmp1_;
	CheeseFileUtil* _tmp2_;
	CheeseFlash* _tmp3_;
	GSettings* _tmp4_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkVBox* _tmp21_;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkWidget* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkClutterEmbed* _tmp27_;
	GtkClutterEmbed* _tmp28_;
	ClutterActor* _tmp29_ = NULL;
	ClutterStage* _tmp30_;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkAlignment* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkAlignment* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkMenuBar* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_ = NULL;
	GtkHBox* _tmp42_;
	GtkBuilder* _tmp43_;
	GObject* _tmp44_ = NULL;
	GtkToggleButton* _tmp45_;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_ = NULL;
	GtkToggleButton* _tmp48_;
	GtkBuilder* _tmp49_;
	GObject* _tmp50_ = NULL;
	GtkToggleButton* _tmp51_;
	GtkBuilder* _tmp52_;
	GObject* _tmp53_ = NULL;
	GtkButton* _tmp54_;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_ = NULL;
	GtkLabel* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_ = NULL;
	GtkImage* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_ = NULL;
	GtkToggleButton* _tmp63_;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_ = NULL;
	GtkButton* _tmp66_;
	GtkBuilder* _tmp67_;
	GObject* _tmp68_ = NULL;
	GtkHBox* _tmp69_;
	GtkBuilder* _tmp70_;
	GObject* _tmp71_ = NULL;
	GtkMenu* _tmp72_;
	GtkBuilder* _tmp73_;
	GObject* _tmp74_ = NULL;
	GtkAction* _tmp75_;
	GtkBuilder* _tmp76_;
	GObject* _tmp77_ = NULL;
	GtkAction* _tmp78_;
	GtkBuilder* _tmp79_;
	GObject* _tmp80_ = NULL;
	GtkAction* _tmp81_;
	GtkBuilder* _tmp82_;
	GObject* _tmp83_ = NULL;
	GtkAction* _tmp84_;
	GtkBuilder* _tmp85_;
	GObject* _tmp86_ = NULL;
	GtkAction* _tmp87_;
	GtkBuilder* _tmp88_;
	GObject* _tmp89_ = NULL;
	GtkAction* _tmp90_;
	GtkBuilder* _tmp91_;
	GObject* _tmp92_ = NULL;
	GtkToggleAction* _tmp93_;
	GtkBuilder* _tmp94_;
	GObject* _tmp95_ = NULL;
	GtkAction* _tmp96_;
	GtkBuilder* _tmp97_;
	GObject* _tmp98_ = NULL;
	GtkToggleAction* _tmp99_;
	GtkBuilder* _tmp100_;
	GObject* _tmp101_ = NULL;
	GtkToggleAction* _tmp102_;
	GtkBuilder* _tmp103_;
	GObject* _tmp104_ = NULL;
	GtkAction* _tmp105_;
	GtkBuilder* _tmp106_;
	GObject* _tmp107_ = NULL;
	GtkAction* _tmp108_;
	GtkToggleButton* _tmp109_;
	GtkButton* _tmp110_;
	GtkToggleButton* _tmp111_;
	GtkButton* _tmp112_;
	GtkToggleButton* _tmp113_;
	GtkButton* _tmp114_;
	GtkButton* _tmp115_;
	GtkButton* _tmp116_;
	GtkToggleButton* _tmp117_;
	GtkButton* _tmp118_;
	GtkButton* _tmp119_;
	GtkButton* _tmp120_;
	GtkButton** _tmp121_ = NULL;
	ClutterScript* _tmp122_;
	GObject* _tmp123_ = NULL;
	ClutterTexture* _tmp124_;
	ClutterScript* _tmp125_;
	GObject* _tmp126_ = NULL;
	ClutterBox* _tmp127_;
	ClutterScript* _tmp128_;
	GObject* _tmp129_ = NULL;
	ClutterBinLayout* _tmp130_;
	ClutterScript* _tmp131_;
	GObject* _tmp132_ = NULL;
	ClutterText* _tmp133_;
	ClutterScript* _tmp134_;
	GObject* _tmp135_ = NULL;
	ClutterRectangle* _tmp136_;
	ClutterScript* _tmp137_;
	GObject* _tmp138_ = NULL;
	ClutterText* _tmp139_;
	ClutterTexture* _tmp140_;
	ClutterTexture* _tmp141_;
	ClutterStage* _tmp142_;
	ClutterRectangle* _tmp143_;
	ClutterBox* _tmp144_;
	ClutterBinLayout* _tmp145_;
	ClutterStage* _tmp146_;
	ClutterBox* _tmp147_;
	ClutterStage* _tmp148_;
	CheeseThumbView* _tmp149_;
	CheeseThumbView* _tmp150_;
	CheeseThumbView* _tmp151_;
	EogThumbNav* _tmp152_;
	EogThumbNav* _tmp153_;
	GtkCssProvider* css = NULL;
	GtkStyleContext* context = NULL;
	CheeseThumbView* _tmp160_;
	GtkStyleContext* _tmp161_ = NULL;
	GtkStyleContext* _tmp162_;
	GdkScreen* _tmp163_ = NULL;
	GtkStyleContext* _tmp164_;
	GdkScreen* _tmp165_;
	GdkScreen* _tmp166_;
	CheeseThumbView* _tmp167_;
	GtkVBox* _tmp168_;
	GtkVBox* _tmp169_;
	GtkClutterEmbed* _tmp170_;
	GtkToggleAction* _tmp171_;
	GSettings* _tmp172_;
	gboolean _tmp173_ = FALSE;
	GSettings* _tmp174_;
	gboolean _tmp175_ = FALSE;
	GSettings* _tmp177_;
	gboolean _tmp178_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp0_;
	_tmp1_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp1_;
	_tmp2_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp2_;
	_tmp3_ = cheese_flash_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	{
		GtkBuilder* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GtkBuilder* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GtkBuilder* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GtkBuilder* _tmp14_;
		ClutterScript* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp5_ = self->priv->gtk_builder;
		_tmp6_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL);
		_tmp7_ = _tmp6_;
		gtk_builder_add_from_file (_tmp5_, _tmp7_, &_inner_error_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp8_ = self->priv->gtk_builder;
		_tmp9_ = g_build_filename (PACKAGE_DATADIR, "cheese-about.ui", NULL);
		_tmp10_ = _tmp9_;
		gtk_builder_add_from_file (_tmp8_, _tmp10_, &_inner_error_);
		_g_free0 (_tmp10_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp11_ = self->priv->gtk_builder;
		_tmp12_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
		_tmp13_ = _tmp12_;
		gtk_builder_add_from_file (_tmp11_, _tmp13_, &_inner_error_);
		_g_free0 (_tmp13_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp14_ = self->priv->gtk_builder;
		gtk_builder_connect_signals (_tmp14_, self);
		_tmp15_ = self->priv->clutter_builder;
		_tmp16_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
		_tmp17_ = _tmp16_;
		clutter_script_load_from_file (_tmp15_, _tmp17_, &_inner_error_);
		_g_free0 (_tmp17_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp18_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = err->message;
		g_error ("cheese-window.vala:1128: Error: %s", _tmp18_);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = self->priv->gtk_builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "mainbox_normal");
	_tmp21_ = _g_object_ref0 (GTK_VBOX (_tmp20_));
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp21_;
	_tmp22_ = self->priv->gtk_builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "thumbnails");
	_tmp24_ = _g_object_ref0 (GTK_WIDGET (_tmp23_));
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp24_;
	_tmp25_ = self->priv->gtk_builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "viewport");
	_tmp27_ = _g_object_ref0 (GTK_CLUTTER_EMBED (_tmp26_));
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp27_;
	_tmp28_ = self->priv->viewport_widget;
	_tmp29_ = gtk_clutter_embed_get_stage (_tmp28_);
	_tmp30_ = _g_object_ref0 (CLUTTER_STAGE (_tmp29_));
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp30_;
	_tmp31_ = self->priv->gtk_builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "thumbnails_right");
	_tmp33_ = _g_object_ref0 (GTK_ALIGNMENT (_tmp32_));
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp33_;
	_tmp34_ = self->priv->gtk_builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "thumbnails_bottom");
	_tmp36_ = _g_object_ref0 (GTK_ALIGNMENT (_tmp35_));
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp36_;
	_tmp37_ = self->priv->gtk_builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "main_menubar");
	_tmp39_ = _g_object_ref0 (GTK_MENU_BAR (_tmp38_));
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp39_;
	_tmp40_ = self->priv->gtk_builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "leave_fullscreen_button_bin");
	_tmp42_ = _g_object_ref0 (GTK_HBOX (_tmp41_));
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp42_;
	_tmp43_ = self->priv->gtk_builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "photo_toggle_button");
	_tmp45_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp44_));
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp45_;
	_tmp46_ = self->priv->gtk_builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "video_toggle_button");
	_tmp48_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp47_));
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp48_;
	_tmp49_ = self->priv->gtk_builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "burst_toggle_button");
	_tmp51_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp50_));
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp51_;
	_tmp52_ = self->priv->gtk_builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "take_action_button");
	_tmp54_ = _g_object_ref0 (GTK_BUTTON (_tmp53_));
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp54_;
	_tmp55_ = self->priv->gtk_builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "take_action_button_internal_label");
	_tmp57_ = _g_object_ref0 (GTK_LABEL (_tmp56_));
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp57_;
	_tmp58_ = self->priv->gtk_builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "take_action_button_internal_image");
	_tmp60_ = _g_object_ref0 (GTK_IMAGE (_tmp59_));
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp60_;
	_tmp61_ = self->priv->gtk_builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "effects_toggle_button");
	_tmp63_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp62_));
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp63_;
	_tmp64_ = self->priv->gtk_builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "leave_fullscreen_button");
	_tmp66_ = _g_object_ref0 (GTK_BUTTON (_tmp65_));
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp66_;
	_tmp67_ = self->priv->gtk_builder;
	_tmp68_ = gtk_builder_get_object (_tmp67_, "buttons_area");
	_tmp69_ = _g_object_ref0 (GTK_HBOX (_tmp68_));
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp69_;
	_tmp70_ = self->priv->gtk_builder;
	_tmp71_ = gtk_builder_get_object (_tmp70_, "thumbnail_popup");
	_tmp72_ = _g_object_ref0 (GTK_MENU (_tmp71_));
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp72_;
	_tmp73_ = self->priv->gtk_builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "take_photo");
	_tmp75_ = _g_object_ref0 (GTK_ACTION (_tmp74_));
	_g_object_unref0 (self->priv->take_photo_action);
	self->priv->take_photo_action = _tmp75_;
	_tmp76_ = self->priv->gtk_builder;
	_tmp77_ = gtk_builder_get_object (_tmp76_, "take_video");
	_tmp78_ = _g_object_ref0 (GTK_ACTION (_tmp77_));
	_g_object_unref0 (self->priv->take_video_action);
	self->priv->take_video_action = _tmp78_;
	_tmp79_ = self->priv->gtk_builder;
	_tmp80_ = gtk_builder_get_object (_tmp79_, "take_burst");
	_tmp81_ = _g_object_ref0 (GTK_ACTION (_tmp80_));
	_g_object_unref0 (self->priv->take_burst_action);
	self->priv->take_burst_action = _tmp81_;
	_tmp82_ = self->priv->gtk_builder;
	_tmp83_ = gtk_builder_get_object (_tmp82_, "photo_mode");
	_tmp84_ = _g_object_ref0 (GTK_ACTION (_tmp83_));
	_g_object_unref0 (self->priv->photo_mode_action);
	self->priv->photo_mode_action = _tmp84_;
	_tmp85_ = self->priv->gtk_builder;
	_tmp86_ = gtk_builder_get_object (_tmp85_, "video_mode");
	_tmp87_ = _g_object_ref0 (GTK_ACTION (_tmp86_));
	_g_object_unref0 (self->priv->video_mode_action);
	self->priv->video_mode_action = _tmp87_;
	_tmp88_ = self->priv->gtk_builder;
	_tmp89_ = gtk_builder_get_object (_tmp88_, "burst_mode");
	_tmp90_ = _g_object_ref0 (GTK_ACTION (_tmp89_));
	_g_object_unref0 (self->priv->burst_mode_action);
	self->priv->burst_mode_action = _tmp90_;
	_tmp91_ = self->priv->gtk_builder;
	_tmp92_ = gtk_builder_get_object (_tmp91_, "effects_toggle");
	_tmp93_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp92_));
	_g_object_unref0 (self->priv->effects_toggle_action);
	self->priv->effects_toggle_action = _tmp93_;
	_tmp94_ = self->priv->gtk_builder;
	_tmp95_ = gtk_builder_get_object (_tmp94_, "countdown");
	_tmp96_ = _g_object_ref0 (GTK_ACTION (_tmp95_));
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp96_;
	_tmp97_ = self->priv->gtk_builder;
	_tmp98_ = gtk_builder_get_object (_tmp97_, "wide_mode");
	_tmp99_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp98_));
	_g_object_unref0 (self->priv->wide_mode_action);
	self->priv->wide_mode_action = _tmp99_;
	_tmp100_ = self->priv->gtk_builder;
	_tmp101_ = gtk_builder_get_object (_tmp100_, "fullscreen");
	_tmp102_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp101_));
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp102_;
	_tmp103_ = self->priv->gtk_builder;
	_tmp104_ = gtk_builder_get_object (_tmp103_, "effects_page_next");
	_tmp105_ = _g_object_ref0 (GTK_ACTION (_tmp104_));
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->effects_page_next_action = _tmp105_;
	_tmp106_ = self->priv->gtk_builder;
	_tmp107_ = gtk_builder_get_object (_tmp106_, "effects_page_prev");
	_tmp108_ = _g_object_ref0 (GTK_ACTION (_tmp107_));
	_g_object_unref0 (self->priv->effects_page_prev_action);
	self->priv->effects_page_prev_action = _tmp108_;
	_tmp109_ = self->priv->photo_toggle_button;
	_tmp110_ = _g_object_ref0 ((GtkButton*) _tmp109_);
	_tmp111_ = self->priv->video_toggle_button;
	_tmp112_ = _g_object_ref0 ((GtkButton*) _tmp111_);
	_tmp113_ = self->priv->burst_toggle_button;
	_tmp114_ = _g_object_ref0 ((GtkButton*) _tmp113_);
	_tmp115_ = self->priv->take_action_button;
	_tmp116_ = _g_object_ref0 (_tmp115_);
	_tmp117_ = self->priv->effects_toggle_button;
	_tmp118_ = _g_object_ref0 ((GtkButton*) _tmp117_);
	_tmp119_ = self->priv->leave_fullscreen_button;
	_tmp120_ = _g_object_ref0 (_tmp119_);
	_tmp121_ = g_new0 (GtkButton*, 6 + 1);
	_tmp121_[0] = _tmp110_;
	_tmp121_[1] = _tmp112_;
	_tmp121_[2] = _tmp114_;
	_tmp121_[3] = _tmp116_;
	_tmp121_[4] = _tmp118_;
	_tmp121_[5] = _tmp120_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons = _tmp121_;
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp122_ = self->priv->clutter_builder;
	_tmp123_ = clutter_script_get_object (_tmp122_, "video_preview");
	_tmp124_ = _g_object_ref0 (CLUTTER_TEXTURE (_tmp123_));
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp124_;
	_tmp125_ = self->priv->clutter_builder;
	_tmp126_ = clutter_script_get_object (_tmp125_, "viewport_layout");
	_tmp127_ = _g_object_ref0 (CLUTTER_BOX (_tmp126_));
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp127_;
	_tmp128_ = self->priv->clutter_builder;
	_tmp129_ = clutter_script_get_object (_tmp128_, "viewport_layout_manager");
	_tmp130_ = _g_object_ref0 (CLUTTER_BIN_LAYOUT (_tmp129_));
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp130_;
	_tmp131_ = self->priv->clutter_builder;
	_tmp132_ = clutter_script_get_object (_tmp131_, "countdown_layer");
	_tmp133_ = _g_object_ref0 (CLUTTER_TEXT (_tmp132_));
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp133_;
	_tmp134_ = self->priv->clutter_builder;
	_tmp135_ = clutter_script_get_object (_tmp134_, "background");
	_tmp136_ = _g_object_ref0 (CLUTTER_RECTANGLE (_tmp135_));
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp136_;
	_tmp137_ = self->priv->clutter_builder;
	_tmp138_ = clutter_script_get_object (_tmp137_, "error_layer");
	_tmp139_ = _g_object_ref0 (CLUTTER_TEXT (_tmp138_));
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp139_;
	_tmp140_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp140_, TRUE);
	_tmp141_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp141_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp142_ = self->priv->viewport;
	_tmp143_ = self->priv->background_layer;
	clutter_container_add_actor ((ClutterContainer*) _tmp142_, (ClutterActor*) _tmp143_);
	_tmp144_ = self->priv->viewport_layout;
	_tmp145_ = self->priv->viewport_layout_manager;
	clutter_box_set_layout_manager (_tmp144_, (ClutterLayoutManager*) _tmp145_);
	_tmp146_ = self->priv->viewport;
	_tmp147_ = self->priv->viewport_layout;
	clutter_container_add_actor ((ClutterContainer*) _tmp146_, (ClutterActor*) _tmp147_);
	_tmp148_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp148_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp149_ = cheese_thumb_view_new ();
	_tmp150_ = g_object_ref_sink (_tmp149_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp150_;
	_tmp151_ = self->priv->thumb_view;
	_tmp152_ = eog_thumb_nav_new ((GtkWidget*) _tmp151_, FALSE);
	_tmp153_ = g_object_ref_sink (_tmp152_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp153_;
	{
		GtkCssProvider* _tmp154_;
		gchar* _tmp155_ = NULL;
		gchar* _tmp156_;
		_tmp154_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp154_;
		_tmp155_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
		_tmp156_ = _tmp155_;
		gtk_css_provider_load_from_path (css, _tmp156_, &_inner_error_);
		_g_free0 (_tmp156_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp157_;
		GError* _tmp158_;
		const gchar* _tmp159_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp157_ = stdout;
		_tmp158_ = e;
		_tmp159_ = _tmp158_->message;
		fprintf (_tmp157_, "Error: %s\n", _tmp159_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp160_ = self->priv->thumb_view;
	_tmp161_ = gtk_widget_get_style_context ((GtkWidget*) _tmp160_);
	_tmp162_ = _g_object_ref0 (_tmp161_);
	_g_object_unref0 (context);
	context = _tmp162_;
	_tmp163_ = gdk_screen_get_default ();
	gtk_window_set_screen ((GtkWindow*) self, _tmp163_);
	_tmp164_ = context;
	_tmp165_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp166_ = _tmp165_;
	gtk_style_context_add_provider_for_screen (_tmp166_, (GtkStyleProvider*) css, (guint) 600);
	_tmp167_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp167_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	_tmp168_ = self->priv->main_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp168_);
	_tmp169_ = self->priv->main_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp169_);
	_tmp170_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp170_);
	_tmp171_ = self->priv->wide_mode_action;
	_tmp172_ = self->priv->settings;
	_tmp173_ = g_settings_get_boolean (_tmp172_, "wide-mode");
	gtk_toggle_action_set_active (_tmp171_, _tmp173_);
	_tmp174_ = self->priv->settings;
	_tmp175_ = g_settings_get_boolean (_tmp174_, "wide-mode");
	if (!_tmp175_) {
		GtkToggleAction* _tmp176_;
		_tmp176_ = self->priv->wide_mode_action;
		gtk_toggle_action_toggled (_tmp176_);
	}
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_tmp177_ = self->priv->settings;
	_tmp178_ = g_settings_get_boolean (_tmp177_, "fullscreen");
	if (_tmp178_) {
		GtkToggleAction* _tmp179_;
		_tmp179_ = self->priv->fullscreen_action;
		gtk_toggle_action_set_active (_tmp179_, TRUE);
	}
	_g_object_unref0 (context);
	_g_object_unref0 (css);
}


static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self) {
	cheese_main_window_camera_state_changed (self, new_state);
}


void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri) {
	gchar* device = NULL;
	gdouble value = 0.0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	ClutterTexture* _tmp10_;
	const gchar* _tmp11_;
	GSettings* _tmp12_;
	gint _tmp13_ = 0;
	GSettings* _tmp14_;
	gint _tmp15_ = 0;
	CheeseCamera* _tmp16_;
	GSettings* _tmp26_;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_;
	GSettings* _tmp31_;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_;
	GSettings* _tmp36_;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_;
	GSettings* _tmp41_;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_;
	CheeseCamera* _tmp46_;
	CheeseCamera* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = uri;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = uri;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (device);
		device = _tmp7_;
	} else {
		GSettings* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->settings;
		_tmp9_ = g_settings_get_string (_tmp8_, "camera");
		_g_free0 (device);
		device = _tmp9_;
	}
	_tmp10_ = self->priv->video_preview;
	_tmp11_ = device;
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_get_int (_tmp12_, "photo-x-resolution");
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_get_int (_tmp14_, "photo-y-resolution");
	_tmp16_ = cheese_camera_new (_tmp10_, _tmp11_, _tmp13_, _tmp15_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp16_;
	{
		CheeseCamera* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->camera;
		_tmp18_ = device;
		cheese_camera_setup (_tmp17_, _tmp18_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		ClutterTexture* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		ClutterText* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		ClutterText* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp19_);
		_tmp20_ = err;
		_tmp21_ = _tmp20_->message;
		g_warning ("cheese-window.vala:1256: Error: %s\n", _tmp21_);
		_tmp22_ = self->priv->error_layer;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		clutter_text_set_text (_tmp22_, _tmp24_);
		_tmp25_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp25_);
		cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
		_g_error_free0 (err);
		_g_free0 (device);
		return;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (device);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_double (_tmp26_, "brightness");
	value = _tmp27_;
	_tmp28_ = value;
	if (_tmp28_ != 0.0) {
		CheeseCamera* _tmp29_;
		gdouble _tmp30_;
		_tmp29_ = self->priv->camera;
		_tmp30_ = value;
		cheese_camera_set_balance_property (_tmp29_, "brightness", _tmp30_);
	}
	_tmp31_ = self->priv->settings;
	_tmp32_ = g_settings_get_double (_tmp31_, "contrast");
	value = _tmp32_;
	_tmp33_ = value;
	if (_tmp33_ != 1.0) {
		CheeseCamera* _tmp34_;
		gdouble _tmp35_;
		_tmp34_ = self->priv->camera;
		_tmp35_ = value;
		cheese_camera_set_balance_property (_tmp34_, "contrast", _tmp35_);
	}
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_double (_tmp36_, "hue");
	value = _tmp37_;
	_tmp38_ = value;
	if (_tmp38_ != 0.0) {
		CheeseCamera* _tmp39_;
		gdouble _tmp40_;
		_tmp39_ = self->priv->camera;
		_tmp40_ = value;
		cheese_camera_set_balance_property (_tmp39_, "hue", _tmp40_);
	}
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_double (_tmp41_, "saturation");
	value = _tmp42_;
	_tmp43_ = value;
	if (_tmp43_ != 1.0) {
		CheeseCamera* _tmp44_;
		gdouble _tmp45_;
		_tmp44_ = self->priv->camera;
		_tmp45_ = value;
		cheese_camera_set_balance_property (_tmp44_, "saturation", _tmp45_);
	}
	_tmp46_ = self->priv->camera;
	g_signal_connect_object (_tmp46_, "state-flags-changed", (GCallback) _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed, self, 0);
	_tmp47_ = self->priv->camera;
	cheese_camera_play (_tmp47_);
	_g_free0 (device);
}


void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_;
	CheeseFileUtil* _tmp1_;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_;
	CheeseFileUtil* _tmp4_;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type) {
	CheeseMainWindow * self = NULL;
	self = (CheeseMainWindow*) g_object_new (object_type, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (void) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW);
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = CHEESE_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	_g_object_unref0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->take_photo_action);
	_g_object_unref0 (self->priv->take_video_action);
	_g_object_unref0 (self->priv->take_burst_action);
	_g_object_unref0 (self->priv->photo_mode_action);
	_g_object_unref0 (self->priv->video_mode_action);
	_g_object_unref0 (self->priv->burst_mode_action);
	_g_object_unref0 (self->priv->effects_toggle_action);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	_g_object_unref0 (self->priv->action_sensitivities);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



