/* chess-clock.c generated by valac 0.14.0, the Vala compiler
 * generated from chess-clock.vala, do not modify */


#include <glib.h>
#include <glib-object.h>


#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
	Color _active_color;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

struct _ChessClockPrivate {
	guint _white_duration;
	guint _black_duration;
	guint _white_used;
	guint _black_used;
	GTimer* timer;
	guint expire_timeout;
	guint tick_timeout;
};


static gpointer chess_clock_parent_class = NULL;

GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_DURATION,
	CHESS_CLOCK_BLACK_DURATION,
	CHESS_CLOCK_WHITE_USED,
	CHESS_CLOCK_WHITE_USED_IN_SECONDS,
	CHESS_CLOCK_BLACK_USED,
	CHESS_CLOCK_BLACK_USED_IN_SECONDS,
	CHESS_CLOCK_ACTIVE_COLOR
};
ChessClock* chess_clock_new (guint white_duration, guint black_duration, guint white_used, guint black_used);
ChessClock* chess_clock_construct (GType object_type, guint white_duration, guint black_duration, guint white_used, guint black_used);
void chess_clock_start (ChessClock* self);
static gboolean chess_clock_get_is_started (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
guint chess_clock_get_white_duration (ChessClock* self);
static gboolean chess_clock_timer_expired_cb (ChessClock* self);
static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self);
guint chess_clock_get_black_duration (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
guint chess_clock_get_white_used (ChessClock* self);
guint chess_clock_get_white_used_in_seconds (ChessClock* self);
guint chess_clock_get_black_used (ChessClock* self);
guint chess_clock_get_black_used_in_seconds (ChessClock* self);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject* obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ChessClock* chess_clock_construct (GType object_type, guint white_duration, guint black_duration, guint white_used, guint black_used) {
	ChessClock * self = NULL;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GTimer* _tmp4_;
	self = (ChessClock*) g_object_new (object_type, NULL);
	_tmp0_ = white_duration;
	self->priv->_white_duration = _tmp0_ * 1000;
	_tmp1_ = black_duration;
	self->priv->_black_duration = _tmp1_ * 1000;
	_tmp2_ = white_used;
	self->priv->_white_used = _tmp2_;
	_tmp3_ = black_used;
	self->priv->_black_used = _tmp3_;
	_tmp4_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp4_;
	return self;
}


ChessClock* chess_clock_new (guint white_duration, guint black_duration, guint white_used, guint black_used) {
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_duration, black_duration, white_used, black_used);
}


static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_timer_expired_cb (self);
	return result;
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GTimer* _tmp2_;
	Color _tmp3_;
	Color _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_is_started (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->timer;
	g_timer_start (_tmp2_);
	_tmp3_ = chess_clock_get_active_color (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == COLOR_WHITE) {
		guint _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		guint _tmp8_ = 0U;
		_tmp5_ = chess_clock_get_white_duration (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_white_used;
		_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp6_ - _tmp7_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->expire_timeout = _tmp8_;
	} else {
		guint _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		guint _tmp12_ = 0U;
		_tmp9_ = chess_clock_get_black_duration (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_black_used;
		_tmp12_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp10_ - _tmp11_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->expire_timeout = _tmp12_;
	}
	chess_clock_tick_cb (self);
}


static gboolean chess_clock_timer_expired_cb (ChessClock* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	chess_clock_stop (self);
	g_signal_emit_by_name (self, "expired");
	result = FALSE;
	return result;
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb (self);
	return result;
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	GTimer* _tmp1_;
	gdouble _tmp2_ = 0.0;
	guint elapsed;
	guint used = 0U;
	Color _tmp3_;
	Color _tmp4_;
	guint _tmp9_;
	guint next_tick_time;
	guint _tmp10_;
	guint _tmp11_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tick_timeout;
	if (_tmp0_ != ((guint) 0)) {
		g_signal_emit_by_name (self, "tick");
	}
	_tmp1_ = self->priv->timer;
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
	elapsed = (guint) (_tmp2_ * 1000);
	_tmp3_ = chess_clock_get_active_color (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == COLOR_WHITE) {
		guint _tmp5_;
		guint _tmp6_;
		_tmp5_ = self->priv->_white_used;
		_tmp6_ = elapsed;
		used = _tmp5_ + _tmp6_;
	} else {
		guint _tmp7_;
		guint _tmp8_;
		_tmp7_ = self->priv->_black_used;
		_tmp8_ = elapsed;
		used = _tmp7_ + _tmp8_;
	}
	_tmp9_ = used;
	next_tick_time = ((_tmp9_ / 1000) + 1) * 1000;
	_tmp10_ = used;
	_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, next_tick_time - _tmp10_, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->tick_timeout = _tmp11_;
	result = FALSE;
	return result;
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GTimer* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GTimer* _tmp5_;
	gdouble _tmp6_ = 0.0;
	guint elapsed;
	Color _tmp7_;
	Color _tmp8_;
	GTimer* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_is_started (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->timer;
	g_timer_stop (_tmp2_);
	_tmp3_ = self->priv->expire_timeout;
	g_source_remove (_tmp3_);
	self->priv->expire_timeout = (guint) 0;
	_tmp4_ = self->priv->tick_timeout;
	g_source_remove (_tmp4_);
	self->priv->tick_timeout = (guint) 0;
	_tmp5_ = self->priv->timer;
	_tmp6_ = g_timer_elapsed (_tmp5_, NULL);
	elapsed = (guint) (_tmp6_ * 1000);
	_tmp7_ = chess_clock_get_active_color (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == COLOR_WHITE) {
		guint _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp9_ = self->priv->_white_used;
		_tmp10_ = elapsed;
		self->priv->_white_used = _tmp9_ + _tmp10_;
		_tmp11_ = self->priv->_white_used;
		_tmp12_ = chess_clock_get_white_duration (self);
		_tmp13_ = _tmp12_;
		if (_tmp11_ > _tmp13_) {
			guint _tmp14_;
			guint _tmp15_;
			_tmp14_ = chess_clock_get_white_duration (self);
			_tmp15_ = _tmp14_;
			self->priv->_white_used = _tmp15_;
		}
	} else {
		guint _tmp16_;
		guint _tmp17_;
		guint _tmp18_;
		guint _tmp19_;
		guint _tmp20_;
		_tmp16_ = self->priv->_black_used;
		_tmp17_ = elapsed;
		self->priv->_black_used = _tmp16_ + _tmp17_;
		_tmp18_ = self->priv->_black_used;
		_tmp19_ = chess_clock_get_black_duration (self);
		_tmp20_ = _tmp19_;
		if (_tmp18_ > _tmp20_) {
			guint _tmp21_;
			guint _tmp22_;
			_tmp21_ = chess_clock_get_black_duration (self);
			_tmp22_ = _tmp21_;
			self->priv->_black_used = _tmp22_;
		}
	}
	_tmp23_ = self->priv->timer;
	g_timer_reset (_tmp23_);
}


guint chess_clock_get_white_duration (ChessClock* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_white_duration;
	result = _tmp0_;
	return result;
}


guint chess_clock_get_black_duration (ChessClock* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_black_duration;
	result = _tmp0_;
	return result;
}


guint chess_clock_get_white_used (ChessClock* self) {
	guint result;
	Color _tmp0_;
	Color _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = chess_clock_get_active_color (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_WHITE) {
		guint _tmp2_;
		GTimer* _tmp3_;
		gdouble _tmp4_ = 0.0;
		_tmp2_ = self->priv->_white_used;
		_tmp3_ = self->priv->timer;
		_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
		result = _tmp2_ + ((guint) (_tmp4_ * 1000));
		return result;
	} else {
		guint _tmp5_;
		_tmp5_ = self->priv->_white_used;
		result = _tmp5_;
		return result;
	}
}


guint chess_clock_get_white_used_in_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = chess_clock_get_white_used (self);
	_tmp1_ = _tmp0_;
	result = (_tmp1_ + 500) / 1000;
	return result;
}


guint chess_clock_get_black_used (ChessClock* self) {
	guint result;
	Color _tmp0_;
	Color _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = chess_clock_get_active_color (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_WHITE) {
		guint _tmp2_;
		_tmp2_ = self->priv->_black_used;
		result = _tmp2_;
		return result;
	} else {
		guint _tmp3_;
		GTimer* _tmp4_;
		gdouble _tmp5_ = 0.0;
		_tmp3_ = self->priv->_black_used;
		_tmp4_ = self->priv->timer;
		_tmp5_ = g_timer_elapsed (_tmp4_, NULL);
		result = _tmp3_ + ((guint) (_tmp5_ * 1000));
		return result;
	}
}


guint chess_clock_get_black_used_in_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = chess_clock_get_black_used (self);
	_tmp1_ = _tmp0_;
	result = (_tmp1_ + 500) / 1000;
	return result;
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->_active_color;
	result = _tmp0_;
	return result;
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
	Color _tmp0_;
	Color _tmp1_;
	Color _tmp2_;
	Color _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = chess_clock_get_active_color (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		return;
	}
	chess_clock_stop (self);
	_tmp3_ = value;
	self->_active_color = _tmp3_;
	chess_clock_start (self);
	g_object_notify ((GObject *) self, "active-color");
}


static gboolean chess_clock_get_is_started (ChessClock* self) {
	gboolean result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->expire_timeout;
	result = _tmp0_ != ((guint) 0);
	return result;
}


static void chess_clock_class_init (ChessClockClass * klass) {
	chess_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_DURATION, g_param_spec_uint ("white-duration", "white-duration", "white-duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_DURATION, g_param_spec_uint ("black-duration", "black-duration", "black-duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_USED, g_param_spec_uint ("white-used", "white-used", "white-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_USED_IN_SECONDS, g_param_spec_uint ("white-used-in-seconds", "white-used-in-seconds", "white-used-in-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_USED, g_param_spec_uint ("black-used", "black-used", "black-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_USED_IN_SECONDS, g_param_spec_uint ("black-used-in-seconds", "black-used-in-seconds", "black-used-in-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_clock_instance_init (ChessClock * self) {
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
	self->_active_color = COLOR_WHITE;
	self->priv->expire_timeout = (guint) 0;
	self->priv->tick_timeout = (guint) 0;
}


static void chess_clock_finalize (GObject* obj) {
	ChessClock * self;
	self = CHESS_CLOCK (obj);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = CHESS_CLOCK (object);
	switch (property_id) {
		case CHESS_CLOCK_WHITE_DURATION:
		g_value_set_uint (value, chess_clock_get_white_duration (self));
		break;
		case CHESS_CLOCK_BLACK_DURATION:
		g_value_set_uint (value, chess_clock_get_black_duration (self));
		break;
		case CHESS_CLOCK_WHITE_USED:
		g_value_set_uint (value, chess_clock_get_white_used (self));
		break;
		case CHESS_CLOCK_WHITE_USED_IN_SECONDS:
		g_value_set_uint (value, chess_clock_get_white_used_in_seconds (self));
		break;
		case CHESS_CLOCK_BLACK_USED:
		g_value_set_uint (value, chess_clock_get_black_used (self));
		break;
		case CHESS_CLOCK_BLACK_USED_IN_SECONDS:
		g_value_set_uint (value, chess_clock_get_black_used_in_seconds (self));
		break;
		case CHESS_CLOCK_ACTIVE_COLOR:
		g_value_set_enum (value, chess_clock_get_active_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = CHESS_CLOCK (object);
	switch (property_id) {
		case CHESS_CLOCK_ACTIVE_COLOR:
		chess_clock_set_active_color (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



