; AisleRiot - thirteen.scm
; Copyright (C) 1999, 2003 Rosanna Yuen <rwsy@mit.edu>
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(define magic-total 13)

(define waste-slot 1)

(define (new-game)
  (initialize-playing-area)  
  (set-ace-low)
  (make-standard-deck)
  (shuffle-deck)

  (add-normal-slot DECK)
  (add-extended-slot '() right)

  (add-carriage-return-slot)

  (add-blank-slot)
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-blank-slot)
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-blank-slot)
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (set! HORIZPOS (+ HORIZPOS 0.5))
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (add-carriage-return-slot)
  (set! VERTPOS (- VERTPOS (/ 2 3)))
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())
  (add-normal-slot '())

  (deal-cards 0 '(2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22))
  (deal-cards-face-up 0 '(23 24 25 26 27 28 29))

  (give-status-message)

  (list 7 4)
)

(define (give-status-message)
  (set-statusbar-message (get-stock-no-string)))

(define (get-stock-no-string)
  (string-append (_"Stock left:") " " 
		 (number->string (length (get-cards 0)))))

(define (button-pressed slot-id card-list)
  (and (not (empty-slot? slot-id))
       (is-visible? (car card-list))
       (= (length card-list) 1)
       (not (= (get-value (car card-list)) king))))

(define (check-for-flips slot-id)
  (cond ((= slot-id 29)
	 (if (empty-slot? 28)
	     (flip-top-card 22)
	     ))
	((= slot-id 28)
	 (begin
	   (if (empty-slot? 29)
	       (flip-top-card 22)
	       )
	   (if (empty-slot? 27)
	       (flip-top-card 21)
	       )))
	((= slot-id 27)
	 (begin
	   (if (empty-slot? 28)
	       (flip-top-card 21)
	       )
	   (if (empty-slot? 26)
	       (flip-top-card 20)
	       )))
	((= slot-id 26)
	 (begin
	   (if (empty-slot? 27)
	       (flip-top-card 20)
	       )
	   (if (empty-slot? 25)
	       (flip-top-card 19)
	       )))
	((= slot-id 25)
	 (begin
	   (if (empty-slot? 26)
	       (flip-top-card 19)
	       )
	   (if (empty-slot? 24)
	       (flip-top-card 18)
	       )))
	((= slot-id 24)
	 (begin
	   (if (empty-slot? 25)
	       (flip-top-card 18)
	       )
	   (if (empty-slot? 23)
	       (flip-top-card 17)
	       )))
	((= slot-id 23)
	 (if (empty-slot? 24)
	     (flip-top-card 17)
	     ))
	((= slot-id 22)
	 (if (empty-slot? 21)
	     (flip-top-card 16)
	     ))
	((= slot-id 21)
	 (begin
	   (if (empty-slot? 22)
	       (flip-top-card 16)
	       )
	   (if (empty-slot? 20)
	       (flip-top-card 15)
	       )))
	((= slot-id 20)
	 (begin
	   (if (empty-slot? 21)
	       (flip-top-card 15)
	       )
	   (if (empty-slot? 19)
	       (flip-top-card 14)
	       )))
	((= slot-id 19)
	 (begin
	   (if (empty-slot? 20)
	       (flip-top-card 14)
	       )
	   (if (empty-slot? 18)
	       (flip-top-card 13)
	       )))
	((= slot-id 18)
	 (begin
	   (if (empty-slot? 19)
	       (flip-top-card 13)
	       )
	   (if (empty-slot? 17)
	       (flip-top-card 12)
	       )))
	((= slot-id 17)
	 (if (empty-slot? 18)
	     (flip-top-card 12)
	     ))
	((= slot-id 16)
	 (if (empty-slot? 15)
	     (flip-top-card 11)
	     ))
	((= slot-id 15)
	 (begin
	   (if (empty-slot? 16)
	       (flip-top-card 11)
	       )
	   (if (empty-slot? 14)
	       (flip-top-card 10)
	       )))
	((= slot-id 14)
	 (begin
	   (if (empty-slot? 15)
	       (flip-top-card 10)
	       )
	   (if (empty-slot? 13)
	       (flip-top-card 9)
	       )))
	((= slot-id 13)
	 (begin
	   (if (empty-slot? 14)
	       (flip-top-card 9)
	       )
	   (if (empty-slot? 12)
	       (flip-top-card 8)
	       )))
	((= slot-id 12)
	 (if (empty-slot? 13)
	     (flip-top-card 8)
	     ))
	((= slot-id 11)
	 (if (empty-slot? 10)
	     (flip-top-card 7)
	     ))
	((= slot-id 10)
	 (begin
	   (if (empty-slot? 11)
	       (flip-top-card 7)
	       )
	   (if (empty-slot? 9)
	       (flip-top-card 6)
	       )))
	((= slot-id 9)
	 (begin
	   (if (empty-slot? 10)
	       (flip-top-card 6)
	       )
	   (if (empty-slot? 8)
	       (flip-top-card 5)
	       )))
	((= slot-id 8)
	 (if (empty-slot? 9)
	     (flip-top-card 5)
	     ))
	((= slot-id 7)
	 (if (empty-slot? 6)
	     (flip-top-card 4)
	     ))
	((= slot-id 6)
	 (begin
	   (if (empty-slot? 7)
	       (flip-top-card 4)
	       )
	   (if (empty-slot? 5)
	       (flip-top-card 3)
	       )))
	((= slot-id 5)
	 (if (empty-slot? 6)
	     (flip-top-card 3)
	     ))
	((= slot-id 4)
	 (if (empty-slot? 3)
	     (flip-top-card 2)
	     ))
	((= slot-id 3)
	 (if (empty-slot? 4)
	     (flip-top-card 2)
	     ))
	))

(define (check-double-flips start-slot end-slot)
  (if (= 1 (- (max start-slot end-slot) (min start-slot end-slot)))
      (let ((smaller (min start-slot end-slot)))
	(cond ((= smaller 28)
	       (flip-top-card 22))
	      ((= smaller 27)
	       (flip-top-card 21))
	      ((= smaller 26)
	       (flip-top-card 20))
	      ((= smaller 25)
	       (flip-top-card 19))
	      ((= smaller 24)
	       (flip-top-card 18))
	      ((= smaller 23)
	       (flip-top-card 17))
	      ((= smaller 21)
	       (flip-top-card 16))
	      ((= smaller 20)
	       (flip-top-card 15))
	      ((= smaller 19)
	       (flip-top-card 14))
	      ((= smaller 18)
	       (flip-top-card 13))
	      ((= smaller 17)
	       (flip-top-card 12))
	      ((= smaller 15)
	       (flip-top-card 11))
	      ((= smaller 14)
	       (flip-top-card 10))
	      ((= smaller 13)
	       (flip-top-card 9))
	      ((= smaller 12)
	       (flip-top-card 8))
	      ((= smaller 10)
	       (flip-top-card 7))
	      ((= smaller 9)
	       (flip-top-card 6))
	      ((= smaller 8)
	       (flip-top-card 5))
	      ((= smaller 6)
	       (flip-top-card 4))
	      ((= smaller 5)
	       (flip-top-card 3))
	      ((= smaller 3)
	       (flip-top-card 2))
	      (#t #t)))))

(define (droppable? start-slot card-list end-slot)
  (and (not (empty-slot? end-slot))
       (is-visible? (get-top-card end-slot))
       (= magic-total (+ (get-value (car card-list))
			 (get-value (get-top-card end-slot))))))

(define (button-released start-slot card-list end-slot)
  (and (droppable? start-slot card-list end-slot)
       (begin
         (remove-card end-slot)
         (check-for-flips start-slot)
         (check-for-flips end-slot)
         (check-double-flips start-slot end-slot)
         (add-to-score! 2))))

(define (button-clicked slot-id)
  (if (= slot-id 0)
      (if (not (empty-slot? 0))
	  (deal-cards-face-up 0 (list waste-slot))
	  #f)
      (and (not (empty-slot? slot-id))
	   (is-visible? (get-top-card slot-id))
	   (= (get-value (get-top-card slot-id))
	      king)
	   (remove-card slot-id)
	   (check-for-flips slot-id)
	   (add-to-score! 1))))

(define (button-double-clicked slot-id)
  #f)

(define (game-continuable)
  (give-status-message)
  (and (not (game-won))
       (get-hint)))

(define (game-won)
  (and (empty-slot? 3)
       (empty-slot? waste-slot)
       (empty-slot? 0)))

; This doesn't check for a King on top, that is a generic move and
; check-move handles it. This only checks for the one special case
; of the top two cards matching.
(define (check-waste-for-move)
  (if (and (>= (length (get-cards waste-slot)) 2)
	   (= (+ (get-value (get-nth-card waste-slot 1))
		 (get-value (get-nth-card waste-slot 2))) 
	      magic-total))
      (list 0 (_"Match the top two cards of the waste."))
      #f))

(define (check-move slot1 slot2)
  (if (or (empty-slot? slot1)
	  (not (is-visible? (get-top-card slot1))))
      (if (< slot1 28)
	  (check-move (+ 1 slot1) (+ 2 slot1))
	  #f)
      (if (= king (get-value (get-top-card slot1)))
	  (list 2 (get-name (get-top-card slot1)) (_"itself"))
	  (if (or (empty-slot? slot2)
		  (not (is-visible? (get-top-card slot2)))
		  (not (= magic-total (+ (get-value (get-top-card slot1))
					 (get-value (get-top-card slot2))))))
	      (if (< slot2 29)
		  (check-move slot1 (+ 1 slot2))
		  (if (< slot1 28)
		      (check-move (+ 1 slot1) (+ 2 slot1))
		      #f))
	      (list 1 
		    (get-name (get-top-card slot1)) 
		    (get-name (get-top-card slot2)))))))

(define (dealable?)
  (not (empty-slot? 0)))

(define (do-deal-next-cards)
  (deal-cards-face-up 0 (list waste-slot)))

(define (get-hint)
  (or (check-waste-for-move) 
      (check-move waste-slot 2)
      (if (not (empty-slot? 0))
          (list 0 (_"Deal a card"))
          #f)))

(define (get-options) 
  #f)

(define (apply-options options) 
  #f)

(define (timeout) 
  #f)

(set-features droppable-feature dealable-feature)

(set-lambda new-game button-pressed button-released button-clicked
button-double-clicked game-continuable game-won get-hint get-options
apply-options timeout droppable? dealable?)
