/* rygel-thumbnail.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from rygel-thumbnail.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	RygelMediaResource* (*get_resource) (RygelThumbnail* self, const gchar* protocol, gint index);
};


static gpointer rygel_thumbnail_parent_class = NULL;

GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self, const gchar* protocol, gint index);
static RygelMediaResource* rygel_thumbnail_real_get_resource (RygelThumbnail* self, const gchar* protocol, gint index);
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name);
void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value);
void rygel_media_resource_set_width (RygelMediaResource* self, gint value);
void rygel_media_resource_set_height (RygelMediaResource* self, gint value);
void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value);
void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value);
void rygel_media_resource_set_dlna_operation (RygelMediaResource* self, GUPnPDLNAOperation value);
void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self, GUPnPDLNAConversion value);
void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
static void rygel_thumbnail_finalize (RygelIconInfo* obj);


RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension) {
	RygelThumbnail* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	_tmp0_ = mime_type;
	_tmp1_ = file_extension;
	self = (RygelThumbnail*) rygel_icon_info_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = dlna_profile;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->dlna_profile);
	self->dlna_profile = _tmp3_;
	return self;
}


RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL, mime_type, dlna_profile, file_extension);
}


static RygelMediaResource* rygel_thumbnail_real_get_resource (RygelThumbnail* self, const gchar* protocol, gint index) {
	RygelMediaResource* result = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GUPnPDLNAFlags _tmp11_ = 0;
	GUPnPDLNAFlags _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = protocol;
	_tmp1_ = index;
	_tmp2_ = g_strdup_printf ("%s_thumbnail_%02d", _tmp0_, _tmp1_);
	name = _tmp2_;
	_tmp3_ = rygel_media_resource_new (name);
	res = _tmp3_;
	_tmp4_ = ((RygelIconInfo*) self)->size;
	rygel_media_resource_set_size (res, _tmp4_);
	_tmp5_ = ((RygelIconInfo*) self)->width;
	rygel_media_resource_set_width (res, _tmp5_);
	_tmp6_ = ((RygelIconInfo*) self)->height;
	rygel_media_resource_set_height (res, _tmp6_);
	_tmp7_ = ((RygelIconInfo*) self)->depth;
	rygel_media_resource_set_color_depth (res, _tmp7_);
	_tmp8_ = ((RygelIconInfo*) self)->mime_type;
	rygel_media_resource_set_mime_type (res, _tmp8_);
	_tmp9_ = self->dlna_profile;
	rygel_media_resource_set_dlna_profile (res, _tmp9_);
	_tmp10_ = protocol;
	rygel_media_resource_set_protocol (res, _tmp10_);
	_tmp11_ = rygel_media_resource_get_dlna_flags (res);
	_tmp12_ = _tmp11_;
	rygel_media_resource_set_dlna_flags (res, _tmp12_ | (((GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15));
	rygel_media_resource_set_dlna_operation (res, GUPNP_DLNA_OPERATION_RANGE);
	rygel_media_resource_set_dlna_conversion (res, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp13_ = ((RygelIconInfo*) self)->file_extension;
	rygel_media_resource_set_extension (res, _tmp13_);
	_tmp14_ = ((RygelIconInfo*) self)->uri;
	rygel_media_resource_set_uri (res, _tmp14_);
	result = res;
	_g_free0 (name);
	return result;
}


RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self, const gchar* protocol, gint index) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_THUMBNAIL_GET_CLASS (self)->get_resource (self, protocol, index);
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	((RygelIconInfoClass *) klass)->finalize = rygel_thumbnail_finalize;
	((RygelThumbnailClass *) klass)->get_resource = rygel_thumbnail_real_get_resource;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


static void rygel_thumbnail_finalize (RygelIconInfo* obj) {
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	_g_free0 (self->dlna_profile);
	RYGEL_ICON_INFO_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
}


/**
 * Represents a picture or video thumbnail.
 */
GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (RYGEL_TYPE_ICON_INFO, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}



