/* rygel-http-byte-seek-request.c generated by valac 0.32.0, the Vala compiler
 * generated from rygel-http-byte-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;
typedef struct _RygelHTTPByteSeekRequestPrivate RygelHTTPByteSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPByteSeekRequestPrivate * priv;
};

struct _RygelHTTPByteSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPByteSeekRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_byte_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE
};
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (SoupMessage* msg, RygelHTTPGetHandler* handler, GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, SoupMessage* msg, RygelHTTPGetHandler* handler, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string);
static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value);
gboolean rygel_http_byte_seek_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_byte_seek_request_requested (SoupMessage* msg);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self);
static void rygel_http_byte_seek_request_finalize (GObject* obj);
static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, SoupMessage* msg, RygelHTTPGetHandler* handler, GError** error) {
	RygelHTTPByteSeekRequest * self = NULL;
	const gchar* range = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint64 start_byte = 0LL;
	gint64 end_byte = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGetHandler* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gchar** range_tokens = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gint64 _tmp31_ = 0LL;
	gboolean _tmp40_ = FALSE;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	const gchar* _tmp42_ = NULL;
	gint64 _tmp75_ = 0LL;
	gint64 _tmp76_ = 0LL;
	gint64 _tmp77_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelHTTPByteSeekRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = msg;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, "Range");
	range = _tmp2_;
	_tmp3_ = range;
	if (_tmp3_ == NULL) {
		GError* _tmp4_ = NULL;
		_tmp4_ = g_error_new_literal (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Range header not present");
		_inner_error_ = _tmp4_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = handler;
	_tmp6_ = rygel_http_get_handler_get_resource_size (_tmp5_);
	total_size = _tmp6_;
	_tmp7_ = total_size;
	if (_tmp7_ < ((gint64) 0)) {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp8_ = range;
	_tmp9_ = g_str_has_prefix (_tmp8_, "bytes=");
	if (!_tmp9_) {
		gchar* message = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		_tmp10_ = g_strdup ("Invalid Range value (missing 'bytes=' field): '%s'");
		message = _tmp10_;
		_tmp11_ = message;
		_tmp12_ = range;
		_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp11_, _tmp12_);
		_inner_error_ = _tmp13_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (message);
	}
	_tmp14_ = range;
	_tmp15_ = string_substring (_tmp14_, (glong) 6, (glong) -1);
	parsed_range = _tmp15_;
	_tmp16_ = string_contains (parsed_range, "-");
	if (!_tmp16_) {
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		_tmp17_ = range;
		_tmp18_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range request with no '-': '%s'", _tmp17_);
		_inner_error_ = _tmp18_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = _tmp19_ = g_strsplit (parsed_range, "-", 2);
	range_tokens = _tmp20_;
	range_tokens_length1 = _vala_array_length (_tmp19_);
	_range_tokens_size_ = range_tokens_length1;
	_tmp21_ = range_tokens;
	_tmp21__length1 = range_tokens_length1;
	_tmp22_ = _tmp21_[0];
	_tmp23_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp26_ = int64_try_parse (_tmp24_, &_tmp25_);
	start_byte = _tmp25_;
	_tmp27_ = !_tmp26_;
	_g_free0 (_tmp24_);
	if (_tmp27_) {
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
		_tmp28_ = range;
		_tmp29_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range start value: '%s'", _tmp28_);
		_inner_error_ = _tmp29_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp31_ = total_size;
	if (_tmp31_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp32_ = 0LL;
		gint64 _tmp33_ = 0LL;
		_tmp32_ = start_byte;
		_tmp33_ = total_size;
		_tmp30_ = _tmp32_ >= _tmp33_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		gchar* message = NULL;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gint64 _tmp36_ = 0LL;
		gint64 _tmp37_ = 0LL;
		const gchar* _tmp38_ = NULL;
		GError* _tmp39_ = NULL;
		_tmp34_ = g_strdup ("Range start value %lld is larger than content size %lld: '%s'");
		message = _tmp34_;
		_tmp35_ = message;
		_tmp36_ = start_byte;
		_tmp37_ = total_size;
		_tmp38_ = range;
		_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
		_inner_error_ = _tmp39_;
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (message);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (message);
	}
	_tmp41_ = range_tokens;
	_tmp41__length1 = range_tokens_length1;
	_tmp42_ = _tmp41_[1];
	if (_tmp42_ == NULL) {
		_tmp40_ = TRUE;
	} else {
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		_tmp43_ = range_tokens;
		_tmp43__length1 = range_tokens_length1;
		_tmp44_ = _tmp43_[1];
		_tmp45_ = strlen (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp40_ = _tmp46_ == 0;
	}
	if (_tmp40_) {
		gint64 _tmp47_ = 0LL;
		_tmp47_ = total_size;
		if (_tmp47_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			gint64 _tmp48_ = 0LL;
			gint64 _tmp49_ = 0LL;
			gint64 _tmp50_ = 0LL;
			_tmp48_ = total_size;
			end_byte = _tmp48_ - 1;
			_tmp49_ = end_byte;
			_tmp50_ = start_byte;
			rygel_http_byte_seek_request_set_range_length (self, (_tmp49_ - _tmp50_) + 1);
		} else {
			end_byte = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
			rygel_http_byte_seek_request_set_range_length (self, RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED);
		}
	} else {
		gchar** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gint64 _tmp55_ = 0LL;
		gboolean _tmp56_ = FALSE;
		gboolean _tmp57_ = FALSE;
		gint64 _tmp60_ = 0LL;
		gint64 _tmp61_ = 0LL;
		gboolean _tmp68_ = FALSE;
		gint64 _tmp69_ = 0LL;
		gint64 _tmp73_ = 0LL;
		gint64 _tmp74_ = 0LL;
		_tmp51_ = range_tokens;
		_tmp51__length1 = range_tokens_length1;
		_tmp52_ = _tmp51_[1];
		_tmp53_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp56_ = int64_try_parse (_tmp54_, &_tmp55_);
		end_byte = _tmp55_;
		_tmp57_ = !_tmp56_;
		_g_free0 (_tmp54_);
		if (_tmp57_) {
			const gchar* _tmp58_ = NULL;
			GError* _tmp59_ = NULL;
			_tmp58_ = range;
			_tmp59_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range end value: '%s'", _tmp58_);
			_inner_error_ = _tmp59_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp60_ = end_byte;
		_tmp61_ = start_byte;
		if (_tmp60_ < _tmp61_) {
			gchar* message = NULL;
			gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			gint64 _tmp64_ = 0LL;
			gint64 _tmp65_ = 0LL;
			const gchar* _tmp66_ = NULL;
			GError* _tmp67_ = NULL;
			_tmp62_ = g_strdup ("Range end value %lld is smaller than range start value %lld: '%s'");
			message = _tmp62_;
			_tmp63_ = message;
			_tmp64_ = end_byte;
			_tmp65_ = start_byte;
			_tmp66_ = range;
			_tmp67_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp63_, _tmp64_, _tmp65_, _tmp66_);
			_inner_error_ = _tmp67_;
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (message);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (message);
		}
		_tmp69_ = total_size;
		if (_tmp69_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			gint64 _tmp70_ = 0LL;
			gint64 _tmp71_ = 0LL;
			_tmp70_ = end_byte;
			_tmp71_ = total_size;
			_tmp68_ = _tmp70_ >= _tmp71_;
		} else {
			_tmp68_ = FALSE;
		}
		if (_tmp68_) {
			gint64 _tmp72_ = 0LL;
			_tmp72_ = total_size;
			end_byte = _tmp72_ - 1;
		}
		_tmp73_ = end_byte;
		_tmp74_ = start_byte;
		rygel_http_byte_seek_request_set_range_length (self, (_tmp73_ - _tmp74_) + 1);
	}
	_tmp75_ = start_byte;
	rygel_http_byte_seek_request_set_start_byte (self, _tmp75_);
	_tmp76_ = end_byte;
	rygel_http_byte_seek_request_set_end_byte (self, _tmp76_);
	_tmp77_ = total_size;
	rygel_http_byte_seek_request_set_total_size (self, _tmp77_);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	return self;
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (SoupMessage* msg, RygelHTTPGetHandler* handler, GError** error) {
	return rygel_http_byte_seek_request_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, msg, handler, error);
}


gboolean rygel_http_byte_seek_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		SoupMessage* _tmp0_ = NULL;
		RygelClientHacks* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = message;
		_tmp1_ = rygel_client_hacks_create (_tmp0_, &_inner_error_);
		hack = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
		_tmp2_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp2_;
		_g_object_unref0 (hack);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = force_seek;
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		RygelHTTPGetHandler* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = handler;
		_tmp6_ = rygel_http_get_handler_supports_byte_seek (_tmp5_);
		_tmp3_ = _tmp6_;
	}
	result = _tmp3_;
	return result;
}


gboolean rygel_http_byte_seek_request_requested (SoupMessage* msg) {
	gboolean result = FALSE;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (msg != NULL, FALSE);
	_tmp0_ = msg;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, "Range");
	result = _tmp2_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string) {
	gchar* result = NULL;
	gint i = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (number_string != NULL, NULL);
	i = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar _tmp3_ = '\0';
		gint _tmp8_ = 0;
		_tmp1_ = number_string;
		_tmp2_ = i;
		_tmp3_ = string_get (_tmp1_, (glong) _tmp2_);
		if (_tmp3_ == '0') {
			gint _tmp4_ = 0;
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp4_ = i;
			_tmp5_ = number_string;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp0_ = _tmp4_ < _tmp7_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	_tmp9_ = i;
	if (_tmp9_ == 0) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = number_string;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	} else {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		_tmp12_ = number_string;
		_tmp13_ = i;
		_tmp14_ = number_string;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
		result = _tmp17_;
		return result;
	}
}


gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_length;
	result = _tmp0_;
	return result;
}


static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_length = _tmp0_;
	g_object_notify ((GObject *) self, "range-length");
}


gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_http_byte_seek_request_class_init (RygelHTTPByteSeekRequestClass * klass) {
	rygel_http_byte_seek_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_request_finalize;
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_byte_seek_request_instance_init (RygelHTTPByteSeekRequest * self) {
	self->priv = RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE (self);
}


static void rygel_http_byte_seek_request_finalize (GObject* obj) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	G_OBJECT_CLASS (rygel_http_byte_seek_request_parent_class)->finalize (obj);
}


GType rygel_http_byte_seek_request_get_type (void) {
	static volatile gsize rygel_http_byte_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekRequest), 0, (GInstanceInitFunc) rygel_http_byte_seek_request_instance_init, NULL };
		GType rygel_http_byte_seek_request_type_id;
		rygel_http_byte_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPByteSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_request_type_id__volatile, rygel_http_byte_seek_request_type_id);
	}
	return rygel_http_byte_seek_request_type_id__volatile;
}


static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_start_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_end_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_range_length (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
		rygel_http_byte_seek_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
		rygel_http_byte_seek_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
		rygel_http_byte_seek_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
		rygel_http_byte_seek_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



