/* rygel-http-time-seek-request.c generated by valac 0.32.0, the Vala compiler
 * generated from rygel-http-time-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_time_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_REQUEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, RygelPlaySpeed* speed, GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, RygelPlaySpeed* speed, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
gboolean rygel_http_time_seek_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_time_seek_request_requested (SoupMessage* message);
static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value);
static void rygel_http_time_seek_request_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Create a HTTPTimeSeekRequest corresponding with a HTTPGet that contains a
     * TimeSeekRange.dlna.org header value.
     *
     * Note: This constructor will check the syntax of the request (per DLNA
     * 7.5.4.3.2.24.3) as well as perform some range validation. If the
     * provided request is associated with a handler that can provide content
     * duration, the start and end time will be checked for out-of-bounds
     * conditions. Additionally, the start and end will be checked according
     * to playspeed direction (with rate +1.0 assumed when speed is not
     * provided). When speed is provided, the range end parameter check is
     * relaxed when the rate is not +1.0 (per DLNA 7.5.4.3.2.24.4).
     *
     * @param request The HTTP GET/HEAD request
     * @param speed An associated speed request
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, SoupMessage* message, RygelHTTPGetHandler* handler, RygelPlaySpeed* speed, GError** error) {
	RygelHTTPTimeSeekRequest * self = NULL;
	gboolean _tmp0_ = FALSE;
	RygelPlaySpeed* _tmp1_ = NULL;
	gboolean positive_rate = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelPlaySpeed* _tmp5_ = NULL;
	gboolean trick_mode = FALSE;
	RygelHTTPGetHandler* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	gchar* range = NULL;
	SoupMessage* _tmp11_ = NULL;
	SoupMessageHeaders* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gchar** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	const gchar* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gint64 _tmp36_ = 0LL;
	gint64 end = 0LL;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	const gchar* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelHTTPTimeSeekRequest*) rygel_http_seek_request_construct (object_type);
	_tmp1_ = speed;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		RygelPlaySpeed* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = speed;
		_tmp3_ = rygel_play_speed_is_positive (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	positive_rate = _tmp0_;
	_tmp5_ = speed;
	if (_tmp5_ != NULL) {
		RygelPlaySpeed* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = speed;
		_tmp7_ = rygel_play_speed_is_normal_rate (_tmp6_);
		_tmp4_ = !_tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	trick_mode = _tmp4_;
	_tmp8_ = handler;
	_tmp9_ = rygel_http_get_handler_get_resource_duration (_tmp8_);
	self->total_duration = _tmp9_;
	_tmp10_ = self->total_duration;
	if (_tmp10_ <= ((gint64) 0)) {
		self->total_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp11_ = message;
	_tmp12_ = _tmp11_->request_headers;
	_tmp13_ = soup_message_headers_get_one (_tmp12_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp14_ = g_strdup (_tmp13_);
	range = _tmp14_;
	_tmp15_ = range;
	if (_tmp15_ == NULL) {
		GError* _tmp16_ = NULL;
		_tmp16_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s not present", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = range;
	_tmp18_ = g_str_has_prefix (_tmp17_, "npt=");
	if (!_tmp18_) {
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		_tmp19_ = range;
		_tmp20_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing npt field): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp19_);
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = range;
	_tmp22_ = string_substring (_tmp21_, (glong) 4, (glong) -1);
	parsed_range = _tmp22_;
	_tmp23_ = parsed_range;
	_tmp24_ = string_contains (_tmp23_, "-");
	if (!_tmp24_) {
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		_tmp25_ = range;
		_tmp26_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s request with no '-': '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp25_);
		_inner_error_ = _tmp26_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = parsed_range;
	_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "-", 2);
	range_tokens = _tmp29_;
	range_tokens_length1 = _vala_array_length (_tmp28_);
	_range_tokens_size_ = range_tokens_length1;
	start = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp30_ = range_tokens;
	_tmp30__length1 = range_tokens_length1;
	_tmp31_ = _tmp30_[0];
	_tmp32_ = rygel_http_time_seek_request_parse_npt_time (_tmp31_, &start);
	if (!_tmp32_) {
		const gchar* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
		_tmp33_ = range;
		_tmp34_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (no start): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp33_);
		_inner_error_ = _tmp34_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = self->total_duration;
	if (_tmp36_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp37_ = 0LL;
		gint64 _tmp38_ = 0LL;
		_tmp37_ = start;
		_tmp38_ = self->total_duration;
		_tmp35_ = _tmp37_ > _tmp38_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		_tmp40_ = trick_mode;
		if (_tmp40_) {
			gboolean _tmp41_ = FALSE;
			_tmp41_ = positive_rate;
			_tmp39_ = !_tmp41_;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			gint64 _tmp42_ = 0LL;
			_tmp42_ = self->total_duration;
			self->start_time = _tmp42_;
		} else {
			gchar* msg = NULL;
			gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gint64 _tmp45_ = 0LL;
			gint64 _tmp46_ = 0LL;
			GError* _tmp47_ = NULL;
			_tmp43_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
			msg = _tmp43_;
			_tmp44_ = msg;
			_tmp45_ = start;
			_tmp46_ = self->total_duration;
			_tmp47_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp44_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp45_, _tmp46_);
			_inner_error_ = _tmp47_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
	} else {
		gint64 _tmp48_ = 0LL;
		_tmp48_ = start;
		self->start_time = _tmp48_;
	}
	end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp49_ = range_tokens;
	_tmp49__length1 = range_tokens_length1;
	_tmp50_ = _tmp49_[1];
	_tmp51_ = rygel_http_time_seek_request_parse_npt_time (_tmp50_, &end);
	if (_tmp51_) {
		gboolean _tmp52_ = FALSE;
		_tmp52_ = positive_rate;
		if (_tmp52_) {
			gboolean _tmp53_ = FALSE;
			gint64 _tmp54_ = 0LL;
			gint64 _tmp65_ = 0LL;
			gint64 _tmp66_ = 0LL;
			gint64 _tmp67_ = 0LL;
			_tmp54_ = self->total_duration;
			if (_tmp54_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
				gint64 _tmp55_ = 0LL;
				gint64 _tmp56_ = 0LL;
				_tmp55_ = end;
				_tmp56_ = self->total_duration;
				_tmp53_ = _tmp55_ > _tmp56_;
			} else {
				_tmp53_ = FALSE;
			}
			if (_tmp53_) {
				gboolean _tmp57_ = FALSE;
				_tmp57_ = trick_mode;
				if (_tmp57_) {
					gint64 _tmp58_ = 0LL;
					_tmp58_ = self->total_duration;
					self->end_time = _tmp58_;
				} else {
					gchar* msg = NULL;
					gchar* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					gint64 _tmp61_ = 0LL;
					gint64 _tmp62_ = 0LL;
					GError* _tmp63_ = NULL;
					_tmp59_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
					msg = _tmp59_;
					_tmp60_ = msg;
					_tmp61_ = end;
					_tmp62_ = self->total_duration;
					_tmp63_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp60_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp61_, _tmp62_);
					_inner_error_ = _tmp63_;
					if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (msg);
				}
			} else {
				gint64 _tmp64_ = 0LL;
				_tmp64_ = end;
				self->end_time = _tmp64_;
			}
			_tmp65_ = self->end_time;
			_tmp66_ = self->start_time;
			self->range_duration = _tmp65_ - _tmp66_;
			_tmp67_ = self->range_duration;
			if (_tmp67_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				GError* _tmp71_ = NULL;
				_tmp68_ = g_strdup ("Invalid %s value (start time after end time - forward scan): '%s'");
				msg = _tmp68_;
				_tmp69_ = msg;
				_tmp70_ = range;
				_tmp71_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp69_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp70_);
				_inner_error_ = _tmp71_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		} else {
			gint64 _tmp72_ = 0LL;
			gint64 _tmp73_ = 0LL;
			gint64 _tmp74_ = 0LL;
			gint64 _tmp75_ = 0LL;
			_tmp72_ = end;
			self->end_time = _tmp72_;
			_tmp73_ = self->start_time;
			_tmp74_ = self->end_time;
			self->range_duration = _tmp73_ - _tmp74_;
			_tmp75_ = self->range_duration;
			if (_tmp75_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				const gchar* _tmp78_ = NULL;
				GError* _tmp79_ = NULL;
				_tmp76_ = g_strdup ("Invalid %s value (start time before end time - reverse scan): '%s'");
				msg = _tmp76_;
				_tmp77_ = msg;
				_tmp78_ = range;
				_tmp79_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp77_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp78_);
				_inner_error_ = _tmp79_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		}
	} else {
		gint64 _tmp80_ = 0LL;
		self->end_time = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		_tmp80_ = self->total_duration;
		if (_tmp80_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			self->range_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		} else {
			gboolean _tmp81_ = FALSE;
			_tmp81_ = positive_rate;
			if (_tmp81_) {
				gint64 _tmp82_ = 0LL;
				gint64 _tmp83_ = 0LL;
				gint64 _tmp84_ = 0LL;
				_tmp82_ = self->total_duration;
				self->end_time = _tmp82_ - G_TIME_SPAN_MILLISECOND;
				_tmp83_ = self->total_duration;
				_tmp84_ = self->start_time;
				self->range_duration = _tmp83_ - _tmp84_;
			} else {
				gint64 _tmp85_ = 0LL;
				self->end_time = (gint64) 0;
				_tmp85_ = self->start_time;
				self->range_duration = _tmp85_;
			}
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	_g_free0 (range);
	return self;
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (SoupMessage* message, RygelHTTPGetHandler* handler, RygelPlaySpeed* speed, GError** error) {
	return rygel_http_time_seek_request_construct (RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, message, handler, speed, error);
}


gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->end_time;
	if (_tmp1_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp2_ = 0LL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->end_time;
		_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("*");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = self->start_time;
	_tmp6_ = g_strdup_printf ("HTTPTimeSeekRequest (npt=%lld-%s)", _tmp5_, _tmp0_);
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}


/**
     * Return true if time-seek is supported.
     *
     * This method utilizes elements associated with the request to determine if
     * a TimeSeekRange request is supported for the given request/resource.
     */
gboolean rygel_http_time_seek_request_supported (SoupMessage* message, RygelHTTPGetHandler* handler) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		SoupMessage* _tmp0_ = NULL;
		RygelClientHacks* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = message;
		_tmp1_ = rygel_client_hacks_create (_tmp0_, &_inner_error_);
		hack = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch53_g_error;
		}
		_tmp2_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp2_;
		_g_object_unref0 (hack);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = force_seek;
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		RygelHTTPGetHandler* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = handler;
		_tmp6_ = rygel_http_get_handler_supports_time_seek (_tmp5_);
		_tmp3_ = _tmp6_;
	}
	result = _tmp3_;
	return result;
}


/**
     * Return true of the HTTPGet contains a TimeSeekRange request.
     */
gboolean rygel_http_time_seek_request_requested (SoupMessage* message) {
	gboolean result = FALSE;
	gchar* header = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp3_ = g_strdup (_tmp2_);
	header = _tmp3_;
	result = header != NULL;
	_g_free0 (header);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (range_token != NULL, FALSE);
	_tmp0_ = range_token;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	_tmp2_ = g_ascii_isdigit (_tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = range_token;
		_tmp4_ = double_parse (_tmp3_);
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint64 _tmp26_ = 0LL;
	_tmp0_ = range_token;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = range_token;
	_tmp2_ = string_index_of (_tmp1_, ":", 0);
	if (_tmp2_ == -1) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = range_token;
		_tmp4_ = rygel_http_time_seek_request_parse_npt_seconds (_tmp3_, value);
		result = _tmp4_;
		return result;
	}
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp5_ = range_token;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp7_;
	time_tokens_length1 = _vala_array_length (_tmp6_);
	_time_tokens_size_ = time_tokens_length1;
	_tmp10_ = time_tokens;
	_tmp10__length1 = time_tokens_length1;
	_tmp11_ = _tmp10_[0];
	if (_tmp11_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		_tmp12_ = time_tokens;
		_tmp12__length1 = time_tokens_length1;
		_tmp13_ = _tmp12_[1];
		_tmp9_ = _tmp13_ == NULL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = time_tokens;
		_tmp14__length1 = time_tokens_length1;
		_tmp15_ = _tmp14_[2];
		_tmp8_ = _tmp15_ == NULL;
	}
	if (_tmp8_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp16_ = time_tokens;
	_tmp16__length1 = time_tokens_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp16_;
		time_collection_length1 = _tmp16__length1;
		for (time_it = 0; time_it < _tmp16__length1; time_it = time_it + 1) {
			gchar* _tmp17_ = NULL;
			gchar* time = NULL;
			_tmp17_ = g_strdup (time_collection[time_it]);
			time = _tmp17_;
			{
				const gchar* _tmp18_ = NULL;
				gchar _tmp19_ = '\0';
				gboolean _tmp20_ = FALSE;
				gint _tmp25_ = 0;
				_tmp18_ = time;
				_tmp19_ = string_get (_tmp18_, (glong) 0);
				_tmp20_ = g_ascii_isdigit (_tmp19_);
				if (_tmp20_) {
					gint64 _tmp21_ = 0LL;
					const gchar* _tmp22_ = NULL;
					gdouble _tmp23_ = 0.0;
					gint _tmp24_ = 0;
					_tmp21_ = seconds_sum;
					_tmp22_ = time;
					_tmp23_ = double_parse (_tmp22_);
					_tmp24_ = time_factor;
					seconds_sum = _tmp21_ + ((gint64) ((_tmp23_ * G_TIME_SPAN_SECOND) * _tmp24_));
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp25_ = time_factor;
				time_factor = _tmp25_ / 60;
				_g_free0 (time);
			}
		}
	}
	_tmp26_ = seconds_sum;
	*value = _tmp26_;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void rygel_http_time_seek_request_class_init (RygelHTTPTimeSeekRequestClass * klass) {
	rygel_http_time_seek_request_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_request_finalize;
}


static void rygel_http_time_seek_request_instance_init (RygelHTTPTimeSeekRequest * self) {
}


static void rygel_http_time_seek_request_finalize (GObject* obj) {
	RygelHTTPTimeSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest);
	G_OBJECT_CLASS (rygel_http_time_seek_request_parent_class)->finalize (obj);
}


/**
 * This class represents a DLNA TimeSeekRange request.
 *
 * A TimeSeekRange request can only have a time range ("npt=start-end").
 */
GType rygel_http_time_seek_request_get_type (void) {
	static volatile gsize rygel_http_time_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekRequest), 0, (GInstanceInitFunc) rygel_http_time_seek_request_instance_init, NULL };
		GType rygel_http_time_seek_request_type_id;
		rygel_http_time_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPTimeSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_request_type_id__volatile, rygel_http_time_seek_request_type_id);
	}
	return rygel_http_time_seek_request_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



