/* print-dialog.c generated by valac 0.32.0.32-d07e8, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _PrintDialogPrivate PrintDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintDialog {
	GtkDialog parent_instance;
	PrintDialogPrivate * priv;
};

struct _PrintDialogClass {
	GtkDialogClass parent_class;
};

struct _PrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkButton* print_button;
	GtkBox* print_box;
	GtkSpinButton* n_sudokus_button;
	GtkRadioButton* easy_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* hard_radio_button;
	GtkRadioButton* very_hard_radio_button;
	GtkRevealer* revealer;
	GtkSpinner* spinner;
	GCancellable* cancellable;
};

struct _Block4Data {
	int _ref_count_;
	PrintDialog* self;
	gchar* key_name;
	GtkAdjustment* action;
};


static gpointer print_dialog_parent_class = NULL;

GType print_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_DIALOG, PrintDialogPrivate))
enum  {
	PRINT_DIALOG_DUMMY_PROPERTY
};
#define PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda23_ (PrintDialog* self, gint response_id);
static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda24_ (Block4Data* _data4_);
static void ___lambda24__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
gboolean print_dialog_start_spinner_cb (PrintDialog* self);
static void print_dialog_real_response (GtkDialog* base, gint response);
static void __lambda22_ (PrintDialog* self, GObject* obj, GAsyncResult* res);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void print_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda23_ (PrintDialog* self, gint response_id) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	_tmp1_ = response_id;
	if (_tmp1_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = response_id;
		_tmp0_ = _tmp2_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp0_) {
		GCancellable* _tmp3_ = NULL;
		_tmp3_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp3_);
	}
}


static void ___lambda23__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda23_ ((PrintDialog*) self, response_id);
}


PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window) {
	PrintDialog * self = NULL;
	SudokuSaver* _tmp0_ = NULL;
	SudokuSaver* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkSpinner* _tmp4_ = NULL;
	GtkRevealer* _tmp5_ = NULL;
	GtkRevealer* _tmp6_ = NULL;
	GtkSpinner* _tmp7_ = NULL;
	GtkRevealer* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkRevealer* _tmp10_ = NULL;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	GtkSpinButton* _tmp21_ = NULL;
	GtkAdjustment* _tmp22_ = NULL;
	g_return_val_if_fail (saver != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (PrintDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	_tmp0_ = saver;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda23__gtk_dialog_response, self, 0);
	_tmp3_ = window;
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp3_);
	_tmp4_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp4_;
	_tmp5_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp5_;
	_tmp6_ = self->priv->revealer;
	_tmp7_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->revealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp10_ = self->priv->revealer;
	gtk_header_bar_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_enum (_tmp11_, PRINT_DIALOG_DIFFICULTY_KEY_NAME);
	saved_difficulty = (DifficultyCategory) _tmp12_;
	_tmp13_ = saved_difficulty;
	if (_tmp13_ == DIFFICULTY_CATEGORY_EASY) {
		GtkRadioButton* _tmp14_ = NULL;
		_tmp14_ = self->priv->easy_radio_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
	} else {
		DifficultyCategory _tmp15_ = 0;
		_tmp15_ = saved_difficulty;
		if (_tmp15_ == DIFFICULTY_CATEGORY_MEDIUM) {
			GtkRadioButton* _tmp16_ = NULL;
			_tmp16_ = self->priv->medium_radio_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp16_, TRUE);
		} else {
			DifficultyCategory _tmp17_ = 0;
			_tmp17_ = saved_difficulty;
			if (_tmp17_ == DIFFICULTY_CATEGORY_HARD) {
				GtkRadioButton* _tmp18_ = NULL;
				_tmp18_ = self->priv->hard_radio_button;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp18_, TRUE);
			} else {
				DifficultyCategory _tmp19_ = 0;
				_tmp19_ = saved_difficulty;
				if (_tmp19_ == DIFFICULTY_CATEGORY_VERY_HARD) {
					GtkRadioButton* _tmp20_ = NULL;
					_tmp20_ = self->priv->very_hard_radio_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, TRUE);
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp21_ = self->priv->n_sudokus_button;
	_tmp22_ = gtk_spin_button_get_adjustment (_tmp21_);
	print_dialog_wrap_adjustment (self, "print-multiple-sudokus-to-print", _tmp22_);
	return self;
}


PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window) {
	return print_dialog_construct (TYPE_PRINT_DIALOG, saver, window);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PrintDialog* self;
		self = _data4_->self;
		_g_free0 (_data4_->key_name);
		_g_object_unref0 (_data4_->action);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda24_ (Block4Data* _data4_) {
	PrintDialog* self;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	self = _data4_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = _data4_->key_name;
	_tmp2_ = _data4_->action;
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
	g_settings_set_int (_tmp0_, _tmp1_, (gint) _tmp3_);
}


static void ___lambda24__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	__lambda24_ (self);
}


static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action) {
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkAdjustment* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_name != NULL);
	g_return_if_fail (action != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = key_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data4_->key_name);
	_data4_->key_name = _tmp1_;
	_tmp2_ = action;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data4_->action);
	_data4_->action = _tmp3_;
	_tmp4_ = _data4_->action;
	_tmp5_ = self->priv->settings;
	_tmp6_ = _data4_->key_name;
	_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
	gtk_adjustment_set_value (_tmp4_, (gdouble) _tmp7_);
	_tmp8_ = _data4_->action;
	g_signal_connect_data (_tmp8_, "value-changed", (GCallback) ___lambda24__gtk_adjustment_value_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


gboolean print_dialog_start_spinner_cb (PrintDialog* self) {
	gboolean result = FALSE;
	GtkRevealer* _tmp0_ = NULL;
	GtkRevealer* _tmp1_ = NULL;
	GtkSpinner* _tmp2_ = NULL;
	GtkRevealer* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_transition_type (_tmp0_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	_tmp1_ = self->priv->revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->spinner;
	gtk_spinner_start (_tmp2_);
	_tmp3_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp3_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}


static void __lambda22_ (PrintDialog* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkSpinner* _tmp2_ = NULL;
		GtkRevealer* _tmp3_ = NULL;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp4_ = NULL;
		SudokuPrinter* _tmp5_ = NULL;
		GtkPrintOperationResult _tmp6_ = 0;
		_tmp0_ = res;
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
		boards = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch4_g_thread_error;
			}
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = self->priv->spinner;
		gtk_spinner_stop (_tmp2_);
		_tmp3_ = self->priv->revealer;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = sudoku_printer_new (boards, (GtkWindow*) self);
		printer = _tmp4_;
		_tmp5_ = printer;
		_tmp6_ = sudoku_printer_print_sudoku (_tmp5_);
		if (_tmp6_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
			{
				GeeList* _board_list = NULL;
				GeeList* _tmp7_ = NULL;
				gint _board_size = 0;
				GeeList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _board_index = 0;
				_tmp7_ = _g_object_ref0 (boards);
				_board_list = _tmp7_;
				_tmp8_ = _board_list;
				_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				_board_size = _tmp10_;
				_board_index = -1;
				while (TRUE) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					SudokuBoard* board = NULL;
					GeeList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gpointer _tmp16_ = NULL;
					SudokuSaver* _tmp17_ = NULL;
					SudokuBoard* _tmp18_ = NULL;
					SudokuGame* _tmp19_ = NULL;
					SudokuGame* _tmp20_ = NULL;
					_tmp11_ = _board_index;
					_board_index = _tmp11_ + 1;
					_tmp12_ = _board_index;
					_tmp13_ = _board_size;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = _board_list;
					_tmp15_ = _board_index;
					_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
					board = (SudokuBoard*) _tmp16_;
					_tmp17_ = self->priv->saver;
					_tmp18_ = board;
					_tmp19_ = sudoku_game_new (_tmp18_);
					_tmp20_ = _tmp19_;
					sudoku_saver_add_game_to_finished (_tmp17_, _tmp20_, FALSE);
					_g_object_unref0 (_tmp20_);
					_g_object_unref0 (board);
				}
				_g_object_unref0 (_board_list);
			}
		}
		_g_object_unref0 (printer);
		_g_object_unref0 (boards);
	}
	goto __finally4;
	__catch4_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e->message;
		g_error ("print-dialog.vala:147: Thread error: %s\n", _tmp21_);
		_g_error_free0 (e);
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		if (!g_error_matches (_tmp22_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning ("print-dialog.vala:152: Error: %s\n", _tmp24_);
		}
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda22_ ((PrintDialog*) self, source_object, res);
	g_object_unref (self);
}


static void print_dialog_real_response (GtkDialog* base, gint response) {
	PrintDialog * self;
	gint _tmp0_ = 0;
	gint nsudokus = 0;
	GtkSpinButton* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp12_ = NULL;
	DifficultyCategory _tmp13_ = 0;
	GtkButton* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GCancellable* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	DifficultyCategory _tmp18_ = 0;
	GCancellable* _tmp19_ = NULL;
	self = (PrintDialog*) base;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_destroy ((GtkWidget*) self);
		return;
	}
	_tmp1_ = self->priv->n_sudokus_button;
	_tmp2_ = gtk_spin_button_get_adjustment (_tmp1_);
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
	nsudokus = (gint) _tmp3_;
	_tmp4_ = self->priv->easy_radio_button;
	_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
	if (_tmp5_) {
		level = DIFFICULTY_CATEGORY_EASY;
	} else {
		GtkRadioButton* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->medium_radio_button;
		_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
		if (_tmp7_) {
			level = DIFFICULTY_CATEGORY_MEDIUM;
		} else {
			GtkRadioButton* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = self->priv->hard_radio_button;
			_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
			if (_tmp9_) {
				level = DIFFICULTY_CATEGORY_HARD;
			} else {
				GtkRadioButton* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp10_ = self->priv->very_hard_radio_button;
				_tmp11_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp10_);
				if (_tmp11_) {
					level = DIFFICULTY_CATEGORY_VERY_HARD;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp12_ = self->priv->settings;
	_tmp13_ = level;
	g_settings_set_enum (_tmp12_, PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) _tmp13_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, (GSourceFunc) print_dialog_start_spinner_cb, g_object_ref (self), NULL);
	_tmp14_ = self->priv->print_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
	_tmp15_ = self->priv->print_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
	_tmp16_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp16_;
	_tmp17_ = nsudokus;
	_tmp18_ = level;
	_tmp19_ = self->priv->cancellable;
	sudoku_generator_generate_boards_async (_tmp17_, _tmp18_, _tmp19_, ___lambda22__gasync_ready_callback, g_object_ref (self));
}


static void print_dialog_class_init (PrintDialogClass * klass) {
	gint PrintDialog_private_offset;
	print_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PrintDialogPrivate));
	((GtkDialogClass *) klass)->response = print_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = print_dialog_finalize;
	PrintDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/sudoku/ui/print-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_box", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_sudokus_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_sudokus_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "easy_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, easy_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, medium_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, hard_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "very_hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, very_hard_radio_button));
}


static void print_dialog_instance_init (PrintDialog * self) {
	self->priv = PRINT_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void print_dialog_finalize (GObject* obj) {
	PrintDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_DIALOG, PrintDialog);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->print_button);
	_g_object_unref0 (self->priv->print_box);
	_g_object_unref0 (self->priv->n_sudokus_button);
	_g_object_unref0 (self->priv->easy_radio_button);
	_g_object_unref0 (self->priv->medium_radio_button);
	_g_object_unref0 (self->priv->hard_radio_button);
	_g_object_unref0 (self->priv->very_hard_radio_button);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (print_dialog_parent_class)->finalize (obj);
}


GType print_dialog_get_type (void) {
	static volatile gsize print_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&print_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintDialog), 0, (GInstanceInitFunc) print_dialog_instance_init, NULL };
		GType print_dialog_type_id;
		print_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PrintDialog", &g_define_type_info, 0);
		g_once_init_leave (&print_dialog_type_id__volatile, print_dialog_type_id);
	}
	return print_dialog_type_id__volatile;
}



