/* rygel-mpris-player.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from rygel-mpris-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Sivakumar Mani <siva@orexel.com>
 *         Jens Georg <mail@jensge.org>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define RYGEL_MPRIS_TYPE_PLAYER (rygel_mpris_player_get_type ())
#define RYGEL_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer))
#define RYGEL_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))
#define RYGEL_MPRIS_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))

typedef struct _RygelMPRISPlayer RygelMPRISPlayer;
typedef struct _RygelMPRISPlayerClass RygelMPRISPlayerClass;
typedef struct _RygelMPRISPlayerPrivate RygelMPRISPlayerPrivate;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY (rygel_mpris_media_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxy))
#define RYGEL_MPRIS_IS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerProxy RygelMPRISMediaPlayerProxy;
typedef struct _RygelMPRISMediaPlayerProxyIface RygelMPRISMediaPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY_PROXY (rygel_mpris_media_player_proxy_proxy_get_type ())

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY (rygel_mpris_media_player_player_proxy_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMPRISPluginPrivate RygelMPRISPluginPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMPRISPlayer {
	GObject parent_instance;
	RygelMPRISPlayerPrivate * priv;
};

struct _RygelMPRISPlayerClass {
	GObjectClass parent_class;
};

struct _RygelMPRISMediaPlayerProxyIface {
	GTypeInterface parent_iface;
	gchar* (*get_identity) (RygelMPRISMediaPlayerProxy* self);
	gchar** (*get_supported_uri_schemes) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
	gchar** (*get_supported_mime_types) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
	gchar* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_rate) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gdouble (*get_minimum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_maximum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_seek) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_control) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISPlayerPrivate {
	gchar** protocols;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	gchar* _user_agent;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _playback_speed;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
};

struct _RygelMPRISPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelMPRISPluginPrivate * priv;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	gchar** mime_types;
	gint mime_types_length1;
	gchar** protocols;
	gint protocols_length1;
};

struct _RygelMPRISPluginClass {
	RygelMediaRendererPluginClass parent_class;
};


static gpointer rygel_mpris_player_parent_class = NULL;
static RygelMediaPlayerIface* rygel_mpris_player_rygel_media_player_parent_iface = NULL;

GType rygel_mpris_player_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_mpris_media_player_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_player_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerPrivate))
enum  {
	RYGEL_MPRIS_PLAYER_DUMMY_PROPERTY,
	RYGEL_MPRIS_PLAYER_USER_AGENT,
	RYGEL_MPRIS_PLAYER_PLAYBACK_STATE,
	RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED,
	RYGEL_MPRIS_PLAYER_MINIMUM_RATE,
	RYGEL_MPRIS_PLAYER_MAXIMUM_RATE,
	RYGEL_MPRIS_PLAYER_URI,
	RYGEL_MPRIS_PLAYER_MIME_TYPE,
	RYGEL_MPRIS_PLAYER_METADATA,
	RYGEL_MPRIS_PLAYER_CONTENT_FEATURES,
	RYGEL_MPRIS_PLAYER_CAN_SEEK,
	RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES,
	RYGEL_MPRIS_PLAYER_VOLUME,
	RYGEL_MPRIS_PLAYER_DURATION,
	RYGEL_MPRIS_PLAYER_SIZE,
	RYGEL_MPRIS_PLAYER_POSITION,
	RYGEL_MPRIS_PLAYER_BYTE_POSITION
};
GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISPlugin* plugin);
RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISPlugin* plugin);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self, GDBusProxy* actual_player, GVariant* changed, gchar** invalidated, int invalidated_length1);
static void _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void rygel_mpris_player_real_constructed (GObject* base);
static gboolean __lambda4_ (RygelMPRISPlayer* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean rygel_mpris_player_real_seek (RygelMediaPlayer* base, gint64 time);
void rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
static gboolean rygel_mpris_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes);
static gchar** rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar* rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self, const gchar* state);
static gchar* _variant_get1 (GVariant* value);
gchar* rygel_mpris_media_player_player_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
static gchar** _vala_array_dup5 (gchar** self, int length);
void rygel_mpris_media_player_player_proxy_set_rate (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
gdouble rygel_mpris_player_get_minimum_rate (RygelMPRISPlayer* self);
gdouble rygel_mpris_player_get_maximum_rate (RygelMPRISPlayer* self);
GHashTable* rygel_mpris_media_player_player_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self);
static gchar* _variant_get2 (GVariant* value);
void rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
gboolean rygel_mpris_media_player_player_proxy_get_can_seek (RygelMPRISMediaPlayerPlayerProxy* self);
gdouble rygel_mpris_media_player_player_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
static gint64 _variant_get3 (GVariant* value);
gint64 rygel_mpris_media_player_player_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self);
static void rygel_mpris_player_finalize (GObject* obj);
static void _vala_rygel_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_mpris_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	rygel_mpris_player_on_properties_changed ((RygelMPRISPlayer*) self, _sender, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISPlugin* plugin) {
	RygelMPRISPlayer * self = NULL;
	RygelMPRISPlugin* _tmp0_ = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp1_ = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp2_ = NULL;
	RygelMPRISPlugin* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RygelMPRISPlugin* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	RygelMPRISMediaPlayerPlayerProxy* _tmp9_ = NULL;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (RygelMPRISPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = plugin;
	_tmp1_ = _tmp0_->actual_player;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->actual_player);
	self->priv->actual_player = _tmp2_;
	_tmp3_ = plugin;
	_tmp4_ = _tmp3_->mime_types;
	_tmp4__length1 = _tmp3_->mime_types_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = _tmp5_;
	self->priv->mime_types_length1 = _tmp5__length1;
	self->priv->_mime_types_size_ = self->priv->mime_types_length1;
	_tmp6_ = plugin;
	_tmp7_ = _tmp6_->protocols;
	_tmp7__length1 = _tmp6_->protocols_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup2 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols = _tmp8_;
	self->priv->protocols_length1 = _tmp8__length1;
	self->priv->_protocols_size_ = self->priv->protocols_length1;
	_tmp9_ = self->priv->actual_player;
	g_signal_connect_object ((GDBusProxy*) _tmp9_, "g-properties-changed", (GCallback) _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
	return self;
}


RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISPlugin* plugin) {
	return rygel_mpris_player_construct (RYGEL_MPRIS_TYPE_PLAYER, plugin);
}


static gboolean __lambda4_ (RygelMPRISPlayer* self) {
	gboolean result = FALSE;
	g_object_notify ((GObject*) self, "playback-state");
	g_object_notify ((GObject*) self, "volume");
	g_object_notify ((GObject*) self, "uri");
	g_object_notify ((GObject*) self, "duration");
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((RygelMPRISPlayer*) self);
	return result;
}


static void rygel_mpris_player_real_constructed (GObject* base) {
	RygelMPRISPlayer * self;
	self = (RygelMPRISPlayer*) base;
	G_OBJECT_CLASS (rygel_mpris_player_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean rygel_mpris_player_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelMPRISPlayer * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	ret = FALSE;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		_tmp0_ = self->priv->actual_player;
		_tmp1_ = time;
		_tmp2_ = rygel_media_player_get_position ((RygelMediaPlayer*) self);
		_tmp3_ = _tmp2_;
		rygel_mpris_media_player_player_proxy_seek (_tmp0_, _tmp1_ - _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		ret = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = ret;
	return result;
}


static gboolean rygel_mpris_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes) {
	RygelMPRISPlayer * self;
	gboolean result = FALSE;
	self = (RygelMPRISPlayer*) base;
	result = FALSE;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelMPRISPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->protocols;
	_tmp0__length1 = self->priv->protocols_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelMPRISPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->mime_types;
	_tmp0__length1 = self->priv->mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self, const gchar* state) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = state;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Stopped")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup ("STOPPED");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("PAUSED_PLAYBACK");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup ("PLAYING");
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static void rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self, GDBusProxy* actual_player, GVariant* changed, gchar** invalidated, int invalidated_length1) {
	GVariant* _tmp0_ = NULL;
	const GVariantType* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actual_player != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = changed;
	_tmp1_ = g_variant_get_type (_tmp0_);
	_tmp2_ = G_VARIANT_TYPE_VARDICT;
	_tmp3_ = g_variant_type_equal (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	{
		GVariantIter* _changed_prop_it = NULL;
		GVariant* _tmp4_ = NULL;
		GVariantIter* _tmp5_ = NULL;
		GVariant* changed_prop = NULL;
		_tmp4_ = changed;
		_tmp5_ = g_variant_iter_new (_tmp4_);
		_changed_prop_it = _tmp5_;
		while (TRUE) {
			GVariantIter* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			gchar* key = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			GVariant* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GVariant* value = NULL;
			GVariant* _tmp14_ = NULL;
			GVariant* _tmp15_ = NULL;
			GVariant* _tmp16_ = NULL;
			GVariant* _tmp17_ = NULL;
			GVariant* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GQuark _tmp22_ = 0U;
			static GQuark _tmp21_label0 = 0;
			static GQuark _tmp21_label1 = 0;
			static GQuark _tmp21_label2 = 0;
			static GQuark _tmp21_label3 = 0;
			static GQuark _tmp21_label4 = 0;
			_tmp6_ = _changed_prop_it;
			_tmp7_ = g_variant_iter_next_value (_tmp6_);
			_g_variant_unref0 (changed_prop);
			changed_prop = _tmp7_;
			_tmp8_ = changed_prop;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = changed_prop;
			_tmp10_ = g_variant_get_child_value (_tmp9_, (gsize) 0);
			_tmp11_ = _tmp10_;
			_tmp12_ = _variant_get1 (_tmp11_);
			_tmp13_ = _tmp12_;
			_g_variant_unref0 (_tmp11_);
			key = _tmp13_;
			_tmp14_ = changed_prop;
			_tmp15_ = g_variant_get_child_value (_tmp14_, (gsize) 1);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_variant_get_child_value (_tmp16_, (gsize) 0);
			_tmp18_ = _tmp17_;
			_g_variant_unref0 (_tmp16_);
			value = _tmp18_;
			_tmp19_ = key;
			_tmp20_ = _tmp19_;
			_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
			if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("PlaybackStatus")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "playback-state");
						break;
					}
				}
			} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("Volume")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "volume");
						break;
					}
				}
			} else if (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string ("Metadata")))) {
				switch (0) {
					default:
					{
						GDBusProxy* _tmp23_ = NULL;
						GVariant* _tmp24_ = NULL;
						gchar** _tmp25_ = NULL;
						gchar** _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						_tmp23_ = actual_player;
						_tmp24_ = value;
						_tmp25_ = g_new0 (gchar*, 0 + 1);
						_tmp26_ = _tmp25_;
						_tmp26__length1 = 0;
						rygel_mpris_player_on_properties_changed (self, _tmp23_, _tmp24_, _tmp26_, 0);
						_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
						break;
					}
				}
			} else if (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string ("xesam:url")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "uri");
						break;
					}
				}
			} else if (_tmp22_ == ((0 != _tmp21_label4) ? _tmp21_label4 : (_tmp21_label4 = g_quark_from_static_string ("mpris:length")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "duration");
						break;
					}
				}
			}
			_g_variant_unref0 (value);
			_g_free0 (key);
		}
		_g_variant_unref0 (changed_prop);
		_g_variant_iter_free0 (_changed_prop_it);
	}
}


static gchar* rygel_mpris_player_real_get_user_agent (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_user_agent;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_mpris_player_real_set_user_agent (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_user_agent);
	self->priv->_user_agent = _tmp1_;
	g_object_notify ((GObject *) self, "user-agent");
}


static gchar* rygel_mpris_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_playback_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_mpris_player_mpris_to_upnp_state (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void rygel_mpris_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	g_debug ("rygel-mpris-player.vala:46: Changing playback state to %s..", _tmp0_);
	_tmp1_ = value;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp5_ = NULL;
					_tmp5_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_stop (_tmp5_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp6_ = NULL;
					_tmp6_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_pause (_tmp6_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp7_ = NULL;
					_tmp7_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_play (_tmp7_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally3:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_mpris_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelMPRISPlayer* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_mpris_player_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_mpris_player_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = value;
	_tmp2_ = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp1_);
	rygel_mpris_media_player_player_proxy_set_rate (_tmp0_, _tmp2_);
	_tmp3_ = value;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_playback_speed);
	self->priv->_playback_speed = _tmp4_;
	g_object_notify ((GObject *) self, "playback-speed");
}


gdouble rygel_mpris_player_get_minimum_rate (RygelMPRISPlayer* self) {
	gdouble result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp1_);
	result = _tmp2_;
	return result;
}


gdouble rygel_mpris_player_get_maximum_rate (RygelMPRISPlayer* self) {
	gdouble result;
	gint i = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	i = _tmp0__length1;
	_vala_assert (i > 0, "i > 0");
	_tmp1_ = self->priv->_allowed_playback_speeds;
	_tmp1__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp2_ = _tmp1_[i - 1];
	_tmp3_ = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp2_);
	result = _tmp3_;
	return result;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gchar* _variant_get2 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar* rygel_mpris_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	GVariant* val = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "xesam:url");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = val;
		_tmp9_ = _variant_get2 (_tmp8_);
		result = _tmp9_;
		_g_variant_unref0 (val);
		return result;
	} else {
		result = NULL;
		_g_variant_unref0 (val);
		return result;
	}
	_g_variant_unref0 (val);
}


static void rygel_mpris_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->actual_player;
		_tmp1_ = value;
		rygel_mpris_media_player_player_proxy_open_uri (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "uri");
}


static gchar* rygel_mpris_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_mpris_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static gchar* rygel_mpris_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_mpris_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


static gchar* rygel_mpris_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_mpris_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_content_features);
	self->priv->_content_features = _tmp1_;
	g_object_notify ((GObject *) self, "content-features");
}


static gboolean rygel_mpris_player_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_can_seek (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gboolean rygel_mpris_player_real_get_can_seek_bytes (RygelMediaPlayer* base) {
	gboolean result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = FALSE;
	return result;
}


static gdouble rygel_mpris_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_volume (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void rygel_mpris_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = value;
	rygel_mpris_media_player_player_proxy_set_volume (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 _variant_get3 (GVariant* value) {
	return g_variant_get_int64 (value);
}


static gint64 rygel_mpris_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	GVariant* val = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	gint64 dur = 0LL;
	GVariant* _tmp7_ = NULL;
	gint64 _tmp10_ = 0LL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "mpris:length");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	dur = (gint64) 0;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		_tmp8_ = val;
		_tmp9_ = _variant_get3 (_tmp8_);
		dur = _tmp9_;
	}
	_tmp10_ = dur;
	result = _tmp10_;
	_g_variant_unref0 (val);
	return result;
}


static gint64 rygel_mpris_player_real_get_size (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = (gint64) 0;
	return result;
}


static gint64 rygel_mpris_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_ = NULL;
	RygelMPRISMediaPlayerPlayerProxy* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	g_dbus_proxy_set_cached_property ((GDBusProxy*) _tmp0_, "Position", NULL);
	_tmp1_ = self->priv->actual_player;
	_tmp2_ = rygel_mpris_media_player_player_proxy_get_position (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


static gint64 rygel_mpris_player_real_get_byte_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	self = (RygelMPRISPlayer*) base;
	result = (gint64) 0;
	return result;
}


static void rygel_mpris_player_class_init (RygelMPRISPlayerClass * klass) {
	rygel_mpris_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMPRISPlayerPrivate));
	((GObjectClass *) klass)->constructed = rygel_mpris_player_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_mpris_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_mpris_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_USER_AGENT, g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MINIMUM_RATE, g_param_spec_double ("minimum-rate", "minimum-rate", "minimum-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MAXIMUM_RATE, g_param_spec_double ("maximum-rate", "maximum-rate", "maximum-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_BYTE_POSITION, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_mpris_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_mpris_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_mpris_player_real_seek;
	iface->seek_bytes = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_mpris_player_real_seek_bytes;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_mpris_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_mpris_player_real_get_mime_types;
	iface->get_user_agent = rygel_mpris_player_real_get_user_agent;
	iface->set_user_agent = rygel_mpris_player_real_set_user_agent;
	iface->get_playback_state = rygel_mpris_player_real_get_playback_state;
	iface->set_playback_state = rygel_mpris_player_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_mpris_player_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_mpris_player_real_get_playback_speed;
	iface->set_playback_speed = rygel_mpris_player_real_set_playback_speed;
	iface->get_uri = rygel_mpris_player_real_get_uri;
	iface->set_uri = rygel_mpris_player_real_set_uri;
	iface->get_mime_type = rygel_mpris_player_real_get_mime_type;
	iface->set_mime_type = rygel_mpris_player_real_set_mime_type;
	iface->get_metadata = rygel_mpris_player_real_get_metadata;
	iface->set_metadata = rygel_mpris_player_real_set_metadata;
	iface->get_content_features = rygel_mpris_player_real_get_content_features;
	iface->set_content_features = rygel_mpris_player_real_set_content_features;
	iface->get_can_seek = rygel_mpris_player_real_get_can_seek;
	iface->get_can_seek_bytes = rygel_mpris_player_real_get_can_seek_bytes;
	iface->get_volume = rygel_mpris_player_real_get_volume;
	iface->set_volume = rygel_mpris_player_real_set_volume;
	iface->get_duration = rygel_mpris_player_real_get_duration;
	iface->get_size = rygel_mpris_player_real_get_size;
	iface->get_position = rygel_mpris_player_real_get_position;
	iface->get_byte_position = rygel_mpris_player_real_get_byte_position;
}


static void rygel_mpris_player_instance_init (RygelMPRISPlayer * self) {
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self->priv = RYGEL_MPRIS_PLAYER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("1");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->_allowed_playback_speeds = _tmp1_;
	self->priv->_allowed_playback_speeds_length1 = 1;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp2_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp2_;
}


static void rygel_mpris_player_finalize (GObject* obj) {
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->actual_player);
	_g_free0 (self->priv->_user_agent);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_content_features);
	G_OBJECT_CLASS (rygel_mpris_player_parent_class)->finalize (obj);
}


GType rygel_mpris_player_get_type (void) {
	static volatile gsize rygel_mpris_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlayer), 0, (GInstanceInitFunc) rygel_mpris_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_mpris_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_mpris_player_type_id;
		rygel_mpris_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMPRISPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_mpris_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_mpris_player_type_id__volatile, rygel_mpris_player_type_id);
	}
	return rygel_mpris_player_type_id__volatile;
}


static void _vala_rygel_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_USER_AGENT:
		g_value_take_string (value, rygel_media_player_get_user_agent ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_ALLOWED_PLAYBACK_SPEEDS:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_MINIMUM_RATE:
		g_value_set_double (value, rygel_mpris_player_get_minimum_rate (self));
		break;
		case RYGEL_MPRIS_PLAYER_MAXIMUM_RATE:
		g_value_set_double (value, rygel_mpris_player_get_maximum_rate (self));
		break;
		case RYGEL_MPRIS_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_MIME_TYPE:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_METADATA:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CONTENT_FEATURES:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CAN_SEEK:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_CAN_SEEK_BYTES:
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_SIZE:
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_BYTE_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_mpris_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMPRISPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_USER_AGENT:
		rygel_media_player_set_user_agent ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_PLAYBACK_SPEED:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_MIME_TYPE:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_METADATA:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_CONTENT_FEATURES:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



