/* worm.c generated by valac 0.34.0.139-050d, the Vala compiler
 * generated from worm.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>


#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
enum  {
	WORM_ADDED_SIGNAL,
	WORM_FINISH_ADDED_SIGNAL,
	WORM_MOVED_SIGNAL,
	WORM_RESCALED_SIGNAL,
	WORM_DIED_SIGNAL,
	WORM_TAIL_REDUCED_SIGNAL,
	WORM_REVERSED_SIGNAL,
	WORM_BONUS_FOUND_SIGNAL,
	WORM_WARP_FOUND_SIGNAL,
	WORM_LAST_SIGNAL
};
static guint worm_signals[WORM_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _WormPrivate {
	Position _starting_position;
	gint _id;
	gboolean _is_materialized;
	gint rounds_dematerialized;
	gint _lives;
	gint _score;
	GeeArrayQueue* key_queue;
	GeeLinkedList* _list;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;


static gpointer worm_parent_class = NULL;
static guint* worm_deadend_board;
static gint worm_deadend_board_length1;
static gint worm_deadend_board_length2;
static guint* worm_deadend_board = NULL;
static gint worm_deadend_board_length1 = 0;
static gint worm_deadend_board_length2 = 0;
static guint worm_deadend_runnumber;
static guint worm_deadend_runnumber = (guint) 0;

GType worm_direction_get_type (void) G_GNUC_CONST;
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GType worm_get_type (void) G_GNUC_CONST;
#define WORM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WORM, WormPrivate))
enum  {
	WORM_DUMMY_PROPERTY,
	WORM_STARTING_POSITION,
	WORM_ID,
	WORM_IS_MATERIALIZED,
	WORM_LIVES,
	WORM_SCORE,
	WORM_LENGTH,
	WORM_HEAD,
	WORM_LIST
};
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define WORM_STARTING_LENGTH 5
#define WORM_STARTING_LIVES 6
#define WORM_MAX_LIVES 12
#define WORM_GROW_FACTOR 4
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type, gint id);
static void worm_set_id (Worm* self, gint value);
void worm_set_lives (Worm* self, gint value);
void worm_set_score (Worm* self, gint value);
static void worm_set_list (Worm* self, GeeLinkedList* value);
void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction);
GeeLinkedList* worm_get_list (Worm* self);
static void worm_set_starting_position (Worm* self, Position * value);
void worm_get_starting_position (Worm* self, Position * result);
void worm_move (Worm* self, gint* board, int board_length1, int board_length2);
void worm_get_head (Worm* self, Position * result);
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_EMPTYCHAR 'a'
gboolean worm_get_is_materialized (Worm* self);
#define NIBBLES_GAME_WORMCHAR 'w'
gint worm_get_id (Worm* self);
void worm_dequeue_keypress (Worm* self);
static void worm_materialize (Worm* self, gint* board, int board_length1, int board_length2);
void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size);
void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2);
GType warp_get_type (void) G_GNUC_CONST;
void worm_warp (Worm* self, Warp* warp);
static void worm_set_head (Worm* self, Position * value);
gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms);
static void worm_position_move (Worm* self, Position* result);
gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm);
static gboolean _position_equal (const Position * s1, const Position * s2);
void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2);
static void worm_set_is_materialized (Worm* self, gboolean value);
void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds);
void worm_add_life (Worm* self);
gint worm_get_lives (Worm* self);
static void worm_lose_life (Worm* self);
void worm_reset (Worm* self, gint* board, int board_length1, int board_length2);
static void worm_direction_set (Worm* self, WormDirection dir);
void worm_queue_keypress (Worm* self, WormDirection dir);
static guint worm_upper_key (Worm* self, guint keyval);
void worm_handle_direction (Worm* self, WormDirection dir);
gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props);
static gint worm_ai_deadend (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint length_left);
static gint worm_ai_deadend_after (gint* board, int board_length1, int board_length2, GeeLinkedList* worms, gint numworms, gint x, gint y, gint dir, gint length);
static gboolean worm_ai_too_close (Worm* self, GeeLinkedList* worms, gint numworms);
static gboolean worm_ai_wander (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint dir, gint ox, gint oy);
GType bonus_type_get_type (void) G_GNUC_CONST;
void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms);
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
gint worm_get_length (Worm* self);
gint worm_get_score (Worm* self);
void worm_set_length (Worm* self, gint value);
static void worm_finalize (GObject * obj);
static void _vala_worm_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_worm_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType worm_direction_get_type (void) {
	static volatile gsize worm_direction_type_id__volatile = 0;
	if (g_once_init_enter (&worm_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{WORM_DIRECTION_NONE, "WORM_DIRECTION_NONE", "none"}, {WORM_DIRECTION_RIGHT, "WORM_DIRECTION_RIGHT", "right"}, {WORM_DIRECTION_DOWN, "WORM_DIRECTION_DOWN", "down"}, {WORM_DIRECTION_LEFT, "WORM_DIRECTION_LEFT", "left"}, {WORM_DIRECTION_UP, "WORM_DIRECTION_UP", "up"}, {0, NULL, NULL}};
		GType worm_direction_type_id;
		worm_direction_type_id = g_enum_register_static ("WormDirection", values);
		g_once_init_leave (&worm_direction_type_id__volatile, worm_direction_type_id);
	}
	return worm_direction_type_id__volatile;
}


Position* position_dup (const Position* self) {
	Position* dup;
	dup = g_new0 (Position, 1);
	memcpy (dup, self, sizeof (Position));
	return dup;
}


void position_free (Position* self) {
	g_free (self);
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		GType position_type_id;
		position_type_id = g_boxed_type_register_static ("Position", (GBoxedCopyFunc) position_dup, (GBoxedFreeFunc) position_free);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


WormProperties* worm_properties_dup (const WormProperties* self) {
	WormProperties* dup;
	dup = g_new0 (WormProperties, 1);
	memcpy (dup, self, sizeof (WormProperties));
	return dup;
}


void worm_properties_free (WormProperties* self) {
	g_free (self);
}


GType worm_properties_get_type (void) {
	static volatile gsize worm_properties_type_id__volatile = 0;
	if (g_once_init_enter (&worm_properties_type_id__volatile)) {
		GType worm_properties_type_id;
		worm_properties_type_id = g_boxed_type_register_static ("WormProperties", (GBoxedCopyFunc) worm_properties_dup, (GBoxedFreeFunc) worm_properties_free);
		g_once_init_leave (&worm_properties_type_id__volatile, worm_properties_type_id);
	}
	return worm_properties_type_id__volatile;
}


Worm* worm_construct (GType object_type, gint id) {
	Worm * self = NULL;
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeArrayQueue* _tmp3_;
	self = (Worm*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	worm_set_id (self, _tmp0_);
	worm_set_lives (self, WORM_STARTING_LIVES);
	worm_set_score (self, 0);
	self->change = 0;
	_tmp1_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, position_free, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	worm_set_list (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gee_array_queue_new (TYPE_WORM_DIRECTION, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->key_queue);
	self->priv->key_queue = _tmp3_;
	return self;
}


Worm* worm_new (gint id) {
	return worm_construct (TYPE_WORM, id);
}


void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction) {
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Position _tmp3_ = {0};
	GeeLinkedList* _tmp4_;
	Position _tmp5_;
	WormDirection _tmp6_;
	WormDirection _tmp7_;
	GeeArrayQueue* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = xhead;
	_tmp2_ = yhead;
	memset (&_tmp3_, 0, sizeof (Position));
	_tmp3_.x = _tmp1_;
	_tmp3_.y = _tmp2_;
	worm_set_starting_position (self, &_tmp3_);
	_tmp4_ = self->priv->_list;
	_tmp5_ = self->priv->_starting_position;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
	_tmp6_ = direction;
	self->starting_direction = _tmp6_;
	_tmp7_ = self->starting_direction;
	self->direction = _tmp7_;
	self->change = 0;
	_tmp8_ = self->priv->key_queue;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
}


void worm_move (Worm* self, gint* board, int board_length1, int board_length2) {
	gboolean _tmp0_;
	Position position;
	Position _tmp1_ = {0};
	Position _tmp2_;
	WormDirection _tmp3_;
	GeeLinkedList* _tmp36_;
	Position _tmp37_;
	gint* _tmp38_;
	gint _tmp38__length1;
	gint _tmp38__length2;
	Position _tmp39_ = {0};
	Position _tmp40_;
	gint _tmp41_;
	Position _tmp42_ = {0};
	Position _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint* _tmp61_;
	gint _tmp61__length1;
	gint _tmp61__length2;
	Position _tmp62_ = {0};
	Position _tmp63_;
	gint _tmp64_;
	Position _tmp65_ = {0};
	Position _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gboolean _tmp69_;
	GeeArrayQueue* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	gint _tmp83_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_human;
	if (_tmp0_) {
		self->keypress = FALSE;
	}
	worm_get_head (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	_tmp3_ = self->direction;
	switch (_tmp3_) {
		case WORM_DIRECTION_UP:
		{
			Position _tmp4_ = {0};
			Position _tmp5_;
			Position _tmp6_ = {0};
			Position _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			Position _tmp10_;
			gint _tmp11_;
			worm_get_head (self, &_tmp4_);
			_tmp5_ = _tmp4_;
			worm_get_head (self, &_tmp6_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_.y;
			_tmp7_.y = _tmp8_ - 1;
			_tmp9_ = _tmp7_.y;
			position.y = _tmp9_;
			_tmp10_ = position;
			_tmp11_ = _tmp10_.y;
			if (_tmp11_ < 0) {
				position.y = NIBBLES_GAME_HEIGHT - 1;
			}
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			Position _tmp12_ = {0};
			Position _tmp13_;
			Position _tmp14_ = {0};
			Position _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Position _tmp18_;
			gint _tmp19_;
			worm_get_head (self, &_tmp12_);
			_tmp13_ = _tmp12_;
			worm_get_head (self, &_tmp14_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_.y;
			_tmp15_.y = _tmp16_ + 1;
			_tmp17_ = _tmp15_.y;
			position.y = _tmp17_;
			_tmp18_ = position;
			_tmp19_ = _tmp18_.y;
			if (_tmp19_ >= NIBBLES_GAME_HEIGHT) {
				position.y = 0;
			}
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			Position _tmp20_ = {0};
			Position _tmp21_;
			Position _tmp22_ = {0};
			Position _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			Position _tmp26_;
			gint _tmp27_;
			worm_get_head (self, &_tmp20_);
			_tmp21_ = _tmp20_;
			worm_get_head (self, &_tmp22_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_.x;
			_tmp23_.x = _tmp24_ - 1;
			_tmp25_ = _tmp23_.x;
			position.x = _tmp25_;
			_tmp26_ = position;
			_tmp27_ = _tmp26_.x;
			if (_tmp27_ < 0) {
				position.x = NIBBLES_GAME_WIDTH - 1;
			}
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			Position _tmp28_ = {0};
			Position _tmp29_;
			Position _tmp30_ = {0};
			Position _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			Position _tmp34_;
			gint _tmp35_;
			worm_get_head (self, &_tmp28_);
			_tmp29_ = _tmp28_;
			worm_get_head (self, &_tmp30_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_.x;
			_tmp31_.x = _tmp32_ + 1;
			_tmp33_ = _tmp31_.x;
			position.x = _tmp33_;
			_tmp34_ = position;
			_tmp35_ = _tmp34_.x;
			if (_tmp35_ >= NIBBLES_GAME_WIDTH) {
				position.x = 0;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp36_ = self->priv->_list;
	_tmp37_ = position;
	gee_deque_offer_head ((GeeDeque*) _tmp36_, &_tmp37_);
	_tmp38_ = board;
	_tmp38__length1 = board_length1;
	_tmp38__length2 = board_length2;
	worm_get_head (self, &_tmp39_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_.x;
	worm_get_head (self, &_tmp42_);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_.y;
	_tmp45_ = _tmp38_[(_tmp41_ * _tmp38__length2) + _tmp44_];
	if (_tmp45_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
		g_signal_emit (self, worm_signals[WORM_WARP_FOUND_SIGNAL], 0);
	}
	_tmp46_ = self->change;
	if (_tmp46_ > 0) {
		gint _tmp47_;
		_tmp47_ = self->change;
		self->change = _tmp47_ - 1;
		g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
	} else {
		gint* _tmp48_;
		gint _tmp48__length1;
		gint _tmp48__length2;
		GeeLinkedList* _tmp49_;
		gpointer _tmp50_;
		Position* _tmp51_;
		gint _tmp52_;
		GeeLinkedList* _tmp53_;
		gpointer _tmp54_;
		Position* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		GeeLinkedList* _tmp58_;
		gpointer _tmp59_;
		Position* _tmp60_;
		_tmp48_ = board;
		_tmp48__length1 = board_length1;
		_tmp48__length2 = board_length2;
		_tmp49_ = self->priv->_list;
		_tmp50_ = gee_linked_list_last (_tmp49_);
		_tmp51_ = (Position*) _tmp50_;
		_tmp52_ = (*_tmp51_).x;
		_tmp53_ = self->priv->_list;
		_tmp54_ = gee_linked_list_last (_tmp53_);
		_tmp55_ = (Position*) _tmp54_;
		_tmp56_ = (*_tmp55_).y;
		_tmp48_[(_tmp52_ * _tmp48__length2) + _tmp56_] = (gint) NIBBLES_GAME_EMPTYCHAR;
		_tmp57_ = _tmp48_[(_tmp52_ * _tmp48__length2) + _tmp56_];
		_position_free0 (_tmp55_);
		_position_free0 (_tmp51_);
		_tmp58_ = self->priv->_list;
		_tmp59_ = gee_deque_poll_tail ((GeeDeque*) _tmp58_);
		_tmp60_ = (Position*) _tmp59_;
		_position_free0 (_tmp60_);
		g_signal_emit (self, worm_signals[WORM_MOVED_SIGNAL], 0);
	}
	_tmp61_ = board;
	_tmp61__length1 = board_length1;
	_tmp61__length2 = board_length2;
	worm_get_head (self, &_tmp62_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_.x;
	worm_get_head (self, &_tmp65_);
	_tmp66_ = _tmp65_;
	_tmp67_ = _tmp66_.y;
	_tmp68_ = _tmp61_[(_tmp64_ * _tmp61__length2) + _tmp67_];
	if (_tmp68_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
		g_signal_emit (self, worm_signals[WORM_BONUS_FOUND_SIGNAL], 0);
	}
	_tmp69_ = self->priv->_is_materialized;
	if (_tmp69_) {
		gint* _tmp70_;
		gint _tmp70__length1;
		gint _tmp70__length2;
		Position _tmp71_ = {0};
		Position _tmp72_;
		gint _tmp73_;
		Position _tmp74_ = {0};
		Position _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		_tmp70_ = board;
		_tmp70__length1 = board_length1;
		_tmp70__length2 = board_length2;
		worm_get_head (self, &_tmp71_);
		_tmp72_ = _tmp71_;
		_tmp73_ = _tmp72_.x;
		worm_get_head (self, &_tmp74_);
		_tmp75_ = _tmp74_;
		_tmp76_ = _tmp75_.y;
		_tmp77_ = self->priv->_id;
		_tmp70_[(_tmp73_ * _tmp70__length2) + _tmp76_] = NIBBLES_GAME_WORMCHAR + _tmp77_;
		_tmp78_ = _tmp70_[(_tmp73_ * _tmp70__length2) + _tmp76_];
	} else {
		gint _tmp79_;
		_tmp79_ = self->priv->rounds_dematerialized;
		self->priv->rounds_dematerialized = _tmp79_ - 1;
	}
	_tmp80_ = self->priv->key_queue;
	_tmp81_ = gee_array_queue_get_is_empty (_tmp80_);
	_tmp82_ = _tmp81_;
	if (!_tmp82_) {
		worm_dequeue_keypress (self);
	}
	_tmp83_ = self->priv->rounds_dematerialized;
	if (_tmp83_ == 1) {
		gint* _tmp84_;
		gint _tmp84__length1;
		gint _tmp84__length2;
		_tmp84_ = board;
		_tmp84__length1 = board_length1;
		_tmp84__length2 = board_length2;
		worm_materialize (self, _tmp84_, _tmp84__length1, _tmp84__length2);
	}
}


void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = erase_size;
	if (_tmp0_ > 0) {
		gint _tmp18_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					gint _tmp4_;
					gint* _tmp5_;
					gint _tmp5__length1;
					gint _tmp5__length2;
					GeeLinkedList* _tmp6_;
					gpointer _tmp7_;
					Position* _tmp8_;
					gint _tmp9_;
					GeeLinkedList* _tmp10_;
					gpointer _tmp11_;
					Position* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					GeeLinkedList* _tmp15_;
					gpointer _tmp16_;
					Position* _tmp17_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = erase_size;
					if (!(_tmp3_ < _tmp4_)) {
						break;
					}
					_tmp5_ = board;
					_tmp5__length1 = board_length1;
					_tmp5__length2 = board_length2;
					_tmp6_ = self->priv->_list;
					_tmp7_ = gee_linked_list_last (_tmp6_);
					_tmp8_ = (Position*) _tmp7_;
					_tmp9_ = (*_tmp8_).x;
					_tmp10_ = self->priv->_list;
					_tmp11_ = gee_linked_list_last (_tmp10_);
					_tmp12_ = (Position*) _tmp11_;
					_tmp13_ = (*_tmp12_).y;
					_tmp5_[(_tmp9_ * _tmp5__length2) + _tmp13_] = (gint) NIBBLES_GAME_EMPTYCHAR;
					_tmp14_ = _tmp5_[(_tmp9_ * _tmp5__length2) + _tmp13_];
					_position_free0 (_tmp12_);
					_position_free0 (_tmp8_);
					_tmp15_ = self->priv->_list;
					_tmp16_ = gee_deque_poll_tail ((GeeDeque*) _tmp15_);
					_tmp17_ = (Position*) _tmp16_;
					_position_free0 (_tmp17_);
				}
			}
		}
		_tmp18_ = erase_size;
		g_signal_emit (self, worm_signals[WORM_TAIL_REDUCED_SIGNAL], 0, _tmp18_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2) {
	GeeLinkedList* reversed_list;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp14_;
	GeeLinkedList* _tmp15_;
	gpointer _tmp16_;
	Position* _tmp17_;
	gint _tmp18_;
	GeeLinkedList* _tmp19_;
	gpointer _tmp20_;
	Position* _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, position_free, NULL, NULL, NULL);
	reversed_list = _tmp0_;
	{
		GeeLinkedList* _pos_list;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index;
		_tmp1_ = self->priv->_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pos_list = _tmp2_;
		_tmp3_ = _pos_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pos_size = _tmp5_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GeeLinkedList* _tmp12_;
			Position* _tmp13_;
			_tmp6_ = _pos_index;
			_pos_index = _tmp6_ + 1;
			_tmp7_ = _pos_index;
			_tmp8_ = _pos_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pos_list;
			_tmp10_ = _pos_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			pos = (Position*) _tmp11_;
			_tmp12_ = reversed_list;
			_tmp13_ = pos;
			gee_deque_offer_head ((GeeDeque*) _tmp12_, _tmp13_);
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	g_signal_emit (self, worm_signals[WORM_REVERSED_SIGNAL], 0);
	_tmp14_ = reversed_list;
	worm_set_list (self, _tmp14_);
	_tmp15_ = self->priv->_list;
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
	_tmp17_ = (Position*) _tmp16_;
	_tmp18_ = (*_tmp17_).y;
	_tmp19_ = self->priv->_list;
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 1);
	_tmp21_ = (Position*) _tmp20_;
	_tmp22_ = (*_tmp21_).y;
	_tmp23_ = _tmp18_ == _tmp22_;
	_position_free0 (_tmp21_);
	_position_free0 (_tmp17_);
	if (_tmp23_) {
		WormDirection _tmp24_ = 0;
		GeeLinkedList* _tmp25_;
		gpointer _tmp26_;
		Position* _tmp27_;
		gint _tmp28_;
		GeeLinkedList* _tmp29_;
		gpointer _tmp30_;
		Position* _tmp31_;
		gint _tmp32_;
		gboolean _tmp33_;
		_tmp25_ = self->priv->_list;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
		_tmp27_ = (Position*) _tmp26_;
		_tmp28_ = (*_tmp27_).x;
		_tmp29_ = self->priv->_list;
		_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 1);
		_tmp31_ = (Position*) _tmp30_;
		_tmp32_ = (*_tmp31_).x;
		_tmp33_ = _tmp28_ > _tmp32_;
		_position_free0 (_tmp31_);
		_position_free0 (_tmp27_);
		if (_tmp33_) {
			_tmp24_ = WORM_DIRECTION_RIGHT;
		} else {
			_tmp24_ = WORM_DIRECTION_LEFT;
		}
		self->direction = _tmp24_;
	} else {
		WormDirection _tmp34_ = 0;
		GeeLinkedList* _tmp35_;
		gpointer _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		GeeLinkedList* _tmp39_;
		gpointer _tmp40_;
		Position* _tmp41_;
		gint _tmp42_;
		gboolean _tmp43_;
		_tmp35_ = self->priv->_list;
		_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
		_tmp37_ = (Position*) _tmp36_;
		_tmp38_ = (*_tmp37_).y;
		_tmp39_ = self->priv->_list;
		_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 1);
		_tmp41_ = (Position*) _tmp40_;
		_tmp42_ = (*_tmp41_).y;
		_tmp43_ = _tmp38_ > _tmp42_;
		_position_free0 (_tmp41_);
		_position_free0 (_tmp37_);
		if (_tmp43_) {
			_tmp34_ = WORM_DIRECTION_DOWN;
		} else {
			_tmp34_ = WORM_DIRECTION_UP;
		}
		self->direction = _tmp34_;
	}
	_g_object_unref0 (reversed_list);
}


void worm_warp (Worm* self, Warp* warp) {
	Warp* _tmp0_;
	gint _tmp1_;
	Warp* _tmp2_;
	gint _tmp3_;
	Position _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (warp != NULL);
	_tmp0_ = warp;
	_tmp1_ = _tmp0_->wx;
	_tmp2_ = warp;
	_tmp3_ = _tmp2_->wy;
	memset (&_tmp4_, 0, sizeof (Position));
	_tmp4_.x = _tmp1_;
	_tmp4_.y = _tmp3_;
	worm_set_head (self, &_tmp4_);
}


gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms) {
	gboolean result = FALSE;
	Position position;
	Position _tmp0_ = {0};
	gint next_position;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	Position _tmp2_;
	gint _tmp3_;
	Position _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	worm_position_move (self, &_tmp0_);
	position = _tmp0_;
	_tmp1_ = board;
	_tmp1__length1 = board_length1;
	_tmp1__length2 = board_length2;
	_tmp2_ = position;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = position;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = _tmp1_[(_tmp3_ * _tmp1__length2) + _tmp5_];
	next_position = _tmp6_;
	_tmp8_ = next_position;
	if (_tmp8_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
		gint _tmp9_;
		_tmp9_ = next_position;
		_tmp7_ = _tmp9_ < ((gint) NIBBLES_GAME_WORMCHAR);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = next_position;
	if (_tmp11_ >= ((gint) NIBBLES_GAME_WORMCHAR)) {
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = next_position;
		_tmp13_ = numworms;
		_tmp10_ = _tmp12_ < (NIBBLES_GAME_WORMCHAR + _tmp13_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_is_materialized;
		result = !_tmp14_;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean _position_equal (const Position * s1, const Position * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	return TRUE;
}


gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Position worm_pos;
	Position _tmp4_ = {0};
	Position other_worm_pos;
	Worm* _tmp5_;
	Position _tmp6_ = {0};
	Position _tmp7_;
	Position _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other_worm != NULL, FALSE);
	_tmp1_ = self->priv->_is_materialized;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Worm* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = other_worm;
		_tmp3_ = _tmp2_->priv->_is_materialized;
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	worm_position_move (self, &_tmp4_);
	worm_pos = _tmp4_;
	_tmp5_ = other_worm;
	worm_position_move (_tmp5_, &_tmp6_);
	other_worm_pos = _tmp6_;
	_tmp7_ = worm_pos;
	_tmp8_ = other_worm_pos;
	if (_position_equal (&_tmp7_, &_tmp8_) == TRUE) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2) {
	g_return_if_fail (self != NULL);
	self->change = WORM_STARTING_LENGTH - 1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < WORM_STARTING_LENGTH)) {
					break;
				}
				_tmp3_ = board;
				_tmp3__length1 = board_length1;
				_tmp3__length2 = board_length2;
				worm_move (self, _tmp3_, _tmp3__length1, _tmp3__length2);
			}
		}
	}
}


static void worm_materialize (Worm* self, gint* board, int board_length1, int board_length2) {
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _pos_list;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index;
		_tmp0_ = self->priv->_list;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_pos_list = _tmp1_;
		_tmp2_ = _pos_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pos_size = _tmp4_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Position* pos;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp11__length2;
			Position* _tmp12_;
			gint _tmp13_;
			Position* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp5_ = _pos_index;
			_pos_index = _tmp5_ + 1;
			_tmp6_ = _pos_index;
			_tmp7_ = _pos_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pos_list;
			_tmp9_ = _pos_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			pos = (Position*) _tmp10_;
			_tmp11_ = board;
			_tmp11__length1 = board_length1;
			_tmp11__length2 = board_length2;
			_tmp12_ = pos;
			_tmp13_ = (*_tmp12_).x;
			_tmp14_ = pos;
			_tmp15_ = (*_tmp14_).y;
			_tmp16_ = _tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_];
			if (_tmp16_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				gint _tmp17_;
				_tmp17_ = self->priv->rounds_dematerialized;
				self->priv->rounds_dematerialized = _tmp17_ + 1;
				_position_free0 (pos);
				_g_object_unref0 (_pos_list);
				return;
			}
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	{
		GeeLinkedList* _pos_list;
		GeeLinkedList* _tmp18_;
		GeeLinkedList* _tmp19_;
		gint _pos_size;
		GeeLinkedList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _pos_index;
		_tmp18_ = self->priv->_list;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_pos_list = _tmp19_;
		_tmp20_ = _pos_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_pos_size = _tmp22_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			Position* pos;
			GeeLinkedList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			gint* _tmp29_;
			gint _tmp29__length1;
			gint _tmp29__length2;
			Position* _tmp30_;
			gint _tmp31_;
			Position* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			_tmp23_ = _pos_index;
			_pos_index = _tmp23_ + 1;
			_tmp24_ = _pos_index;
			_tmp25_ = _pos_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _pos_list;
			_tmp27_ = _pos_index;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
			pos = (Position*) _tmp28_;
			_tmp29_ = board;
			_tmp29__length1 = board_length1;
			_tmp29__length2 = board_length2;
			_tmp30_ = pos;
			_tmp31_ = (*_tmp30_).x;
			_tmp32_ = pos;
			_tmp33_ = (*_tmp32_).y;
			_tmp34_ = self->priv->_id;
			_tmp29_[(_tmp31_ * _tmp29__length2) + _tmp33_] = NIBBLES_GAME_WORMCHAR + _tmp34_;
			_tmp35_ = _tmp29_[(_tmp31_ * _tmp29__length2) + _tmp33_];
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	worm_set_is_materialized (self, TRUE);
	self->priv->rounds_dematerialized = 0;
}


void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rounds;
	self->priv->rounds_dematerialized = _tmp0_;
	worm_set_is_materialized (self, FALSE);
	{
		GeeLinkedList* _pos_list;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index;
		_tmp1_ = self->priv->_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pos_list = _tmp2_;
		_tmp3_ = _pos_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pos_size = _tmp5_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp12__length2;
			Position* _tmp13_;
			gint _tmp14_;
			Position* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp6_ = _pos_index;
			_pos_index = _tmp6_ + 1;
			_tmp7_ = _pos_index;
			_tmp8_ = _pos_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pos_list;
			_tmp10_ = _pos_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			pos = (Position*) _tmp11_;
			_tmp12_ = board;
			_tmp12__length1 = board_length1;
			_tmp12__length2 = board_length2;
			_tmp13_ = pos;
			_tmp14_ = (*_tmp13_).x;
			_tmp15_ = pos;
			_tmp16_ = (*_tmp15_).y;
			_tmp17_ = _tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_];
			_tmp18_ = self->priv->_id;
			if (_tmp17_ == (NIBBLES_GAME_WORMCHAR + _tmp18_)) {
				gint* _tmp19_;
				gint _tmp19__length1;
				gint _tmp19__length2;
				Position* _tmp20_;
				gint _tmp21_;
				Position* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp19_ = board;
				_tmp19__length1 = board_length1;
				_tmp19__length2 = board_length2;
				_tmp20_ = pos;
				_tmp21_ = (*_tmp20_).x;
				_tmp22_ = pos;
				_tmp23_ = (*_tmp22_).y;
				_tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_] = (gint) NIBBLES_GAME_EMPTYCHAR;
				_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
			}
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
}


void worm_add_life (Worm* self) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lives;
	if (_tmp0_ > WORM_MAX_LIVES) {
		return;
	}
	_tmp1_ = self->priv->_lives;
	worm_set_lives (self, _tmp1_ + 1);
}


static void worm_lose_life (Worm* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lives;
	worm_set_lives (self, _tmp0_ - 1);
}


void worm_reset (Worm* self, gint* board, int board_length1, int board_length2) {
	GeeArrayQueue* _tmp0_;
	GeeLinkedList* _tmp18_;
	GeeLinkedList* _tmp19_;
	Position _tmp20_;
	WormDirection _tmp21_;
	gint* _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	g_return_if_fail (self != NULL);
	self->is_stopped = TRUE;
	worm_set_is_materialized (self, FALSE);
	self->priv->rounds_dematerialized = 0;
	_tmp0_ = self->priv->key_queue;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	worm_lose_life (self);
	g_signal_emit (self, worm_signals[WORM_DIED_SIGNAL], 0);
	{
		GeeLinkedList* _pos_list;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index;
		_tmp1_ = self->priv->_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pos_list = _tmp2_;
		_tmp3_ = _pos_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pos_size = _tmp5_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position* pos;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp12__length2;
			Position* _tmp13_;
			gint _tmp14_;
			Position* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp6_ = _pos_index;
			_pos_index = _tmp6_ + 1;
			_tmp7_ = _pos_index;
			_tmp8_ = _pos_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pos_list;
			_tmp10_ = _pos_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			pos = (Position*) _tmp11_;
			_tmp12_ = board;
			_tmp12__length1 = board_length1;
			_tmp12__length2 = board_length2;
			_tmp13_ = pos;
			_tmp14_ = (*_tmp13_).x;
			_tmp15_ = pos;
			_tmp16_ = (*_tmp15_).y;
			_tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_] = (gint) NIBBLES_GAME_EMPTYCHAR;
			_tmp17_ = _tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_];
			_position_free0 (pos);
		}
		_g_object_unref0 (_pos_list);
	}
	_tmp18_ = self->priv->_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp18_);
	_tmp19_ = self->priv->_list;
	_tmp20_ = self->priv->_starting_position;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
	g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
	_tmp21_ = self->starting_direction;
	self->direction = _tmp21_;
	self->change = 0;
	_tmp22_ = board;
	_tmp22__length1 = board_length1;
	_tmp22__length2 = board_length2;
	worm_spawn (self, _tmp22_, _tmp22__length1, _tmp22__length2);
	g_signal_emit (self, worm_signals[WORM_FINISH_ADDED_SIGNAL], 0);
}


static void worm_position_move (Worm* self, Position* result) {
	Position position;
	Position _tmp0_ = {0};
	Position _tmp1_;
	WormDirection _tmp2_;
	g_return_if_fail (self != NULL);
	worm_get_head (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	position = _tmp1_;
	_tmp2_ = self->direction;
	switch (_tmp2_) {
		case WORM_DIRECTION_UP:
		{
			Position _tmp3_ = {0};
			Position _tmp4_;
			Position _tmp5_ = {0};
			Position _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			Position _tmp9_;
			gint _tmp10_;
			worm_get_head (self, &_tmp3_);
			_tmp4_ = _tmp3_;
			worm_get_head (self, &_tmp5_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_.y;
			_tmp6_.y = _tmp7_ - 1;
			_tmp8_ = _tmp6_.y;
			position.y = _tmp8_;
			_tmp9_ = position;
			_tmp10_ = _tmp9_.y;
			if (_tmp10_ < 0) {
				position.y = NIBBLES_GAME_HEIGHT - 1;
			}
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			Position _tmp11_ = {0};
			Position _tmp12_;
			Position _tmp13_ = {0};
			Position _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			Position _tmp17_;
			gint _tmp18_;
			worm_get_head (self, &_tmp11_);
			_tmp12_ = _tmp11_;
			worm_get_head (self, &_tmp13_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_.y;
			_tmp14_.y = _tmp15_ + 1;
			_tmp16_ = _tmp14_.y;
			position.y = _tmp16_;
			_tmp17_ = position;
			_tmp18_ = _tmp17_.y;
			if (_tmp18_ >= NIBBLES_GAME_HEIGHT) {
				position.y = 0;
			}
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			Position _tmp19_ = {0};
			Position _tmp20_;
			Position _tmp21_ = {0};
			Position _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			Position _tmp25_;
			gint _tmp26_;
			worm_get_head (self, &_tmp19_);
			_tmp20_ = _tmp19_;
			worm_get_head (self, &_tmp21_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_.x;
			_tmp22_.x = _tmp23_ - 1;
			_tmp24_ = _tmp22_.x;
			position.x = _tmp24_;
			_tmp25_ = position;
			_tmp26_ = _tmp25_.x;
			if (_tmp26_ < 0) {
				position.x = NIBBLES_GAME_WIDTH - 1;
			}
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			Position _tmp27_ = {0};
			Position _tmp28_;
			Position _tmp29_ = {0};
			Position _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			Position _tmp33_;
			gint _tmp34_;
			worm_get_head (self, &_tmp27_);
			_tmp28_ = _tmp27_;
			worm_get_head (self, &_tmp29_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_.x;
			_tmp30_.x = _tmp31_ + 1;
			_tmp32_ = _tmp30_.x;
			position.x = _tmp32_;
			_tmp33_ = position;
			_tmp34_ = _tmp33_.x;
			if (_tmp34_ >= NIBBLES_GAME_WIDTH) {
				position.x = 0;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	*result = position;
	return;
}


static void worm_direction_set (Worm* self, WormDirection dir) {
	gboolean _tmp0_;
	WormDirection _tmp1_;
	WormDirection _tmp2_;
	gboolean _tmp3_;
	WormDirection _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_human;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = dir;
	if (_tmp1_ > 4) {
		dir = (WormDirection) 1;
	}
	_tmp2_ = dir;
	if (_tmp2_ < 1) {
		dir = (WormDirection) 4;
	}
	_tmp3_ = self->keypress;
	if (_tmp3_) {
		WormDirection _tmp4_;
		_tmp4_ = dir;
		worm_queue_keypress (self, _tmp4_);
		return;
	}
	_tmp5_ = dir;
	self->direction = (WormDirection) _tmp5_;
	self->keypress = TRUE;
}


static guint worm_upper_key (Worm* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = keyval;
	if (_tmp0_ > ((guint) 255)) {
		guint _tmp1_;
		_tmp1_ = keyval;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = keyval;
	_tmp3_ = g_ascii_toupper ((gchar) _tmp2_);
	result = (guint) _tmp3_;
	return result;
}


void worm_handle_direction (Worm* self, WormDirection dir) {
	WormDirection _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dir;
	worm_direction_set (self, _tmp0_);
}


gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	WormProperties properties = {0};
	guint propsUp = 0U;
	guint propsDown = 0U;
	guint propsLeft = 0U;
	guint propsRight = 0U;
	guint keyvalUpper = 0U;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	WormProperties* _tmp5_;
	WormProperties _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	WormProperties _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	WormProperties _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	WormProperties _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	gboolean _tmp20_ = FALSE;
	guint _tmp21_;
	guint _tmp22_;
	gboolean _tmp24_ = FALSE;
	guint _tmp25_;
	guint _tmp26_;
	gboolean _tmp28_ = FALSE;
	guint _tmp29_;
	guint _tmp30_;
	gboolean _tmp32_ = FALSE;
	guint _tmp33_;
	guint _tmp34_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worm_props != NULL, FALSE);
	_tmp1_ = self->priv->_lives;
	if (_tmp1_ <= 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->is_stopped;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = worm_props;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, self);
	_tmp5_ = (WormProperties*) _tmp4_;
	properties = *_tmp5_;
	_worm_properties_free0 (_tmp5_);
	_tmp6_ = properties;
	_tmp7_ = _tmp6_.up;
	_tmp8_ = worm_upper_key (self, _tmp7_);
	propsUp = _tmp8_;
	_tmp9_ = properties;
	_tmp10_ = _tmp9_.left;
	_tmp11_ = worm_upper_key (self, _tmp10_);
	propsLeft = _tmp11_;
	_tmp12_ = properties;
	_tmp13_ = _tmp12_.down;
	_tmp14_ = worm_upper_key (self, _tmp13_);
	propsDown = _tmp14_;
	_tmp15_ = properties;
	_tmp16_ = _tmp15_.right;
	_tmp17_ = worm_upper_key (self, _tmp16_);
	propsRight = _tmp17_;
	_tmp18_ = keyval;
	_tmp19_ = worm_upper_key (self, _tmp18_);
	keyvalUpper = _tmp19_;
	_tmp21_ = keyvalUpper;
	_tmp22_ = propsUp;
	if (_tmp21_ == _tmp22_) {
		WormDirection _tmp23_;
		_tmp23_ = self->direction;
		_tmp20_ = _tmp23_ != WORM_DIRECTION_DOWN;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		worm_handle_direction (self, WORM_DIRECTION_UP);
		result = TRUE;
		return result;
	}
	_tmp25_ = keyvalUpper;
	_tmp26_ = propsDown;
	if (_tmp25_ == _tmp26_) {
		WormDirection _tmp27_;
		_tmp27_ = self->direction;
		_tmp24_ = _tmp27_ != WORM_DIRECTION_UP;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		worm_handle_direction (self, WORM_DIRECTION_DOWN);
		result = TRUE;
		return result;
	}
	_tmp29_ = keyvalUpper;
	_tmp30_ = propsRight;
	if (_tmp29_ == _tmp30_) {
		WormDirection _tmp31_;
		_tmp31_ = self->direction;
		_tmp28_ = _tmp31_ != WORM_DIRECTION_LEFT;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		worm_handle_direction (self, WORM_DIRECTION_RIGHT);
		result = TRUE;
		return result;
	}
	_tmp33_ = keyvalUpper;
	_tmp34_ = propsLeft;
	if (_tmp33_ == _tmp34_) {
		WormDirection _tmp35_;
		_tmp35_ = self->direction;
		_tmp32_ = _tmp35_ != WORM_DIRECTION_RIGHT;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		worm_handle_direction (self, WORM_DIRECTION_LEFT);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void worm_queue_keypress (Worm* self, WormDirection dir) {
	gboolean _tmp0_ = FALSE;
	GeeArrayQueue* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayQueue* _tmp7_;
	WormDirection _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->key_queue;
	_tmp2_ = gee_array_queue_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		WormDirection _tmp4_;
		GeeArrayQueue* _tmp5_;
		gpointer _tmp6_;
		_tmp4_ = dir;
		_tmp5_ = self->priv->key_queue;
		_tmp6_ = gee_abstract_queue_peek ((GeeAbstractQueue*) _tmp5_);
		_tmp0_ = _tmp4_ == ((WormDirection) ((gintptr) _tmp6_));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->priv->key_queue;
	_tmp8_ = dir;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((gintptr) _tmp8_));
}


void worm_dequeue_keypress (Worm* self) {
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayQueue* _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_queue;
	_tmp1_ = gee_array_queue_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (!_tmp2_, "!key_queue.is_empty");
	_tmp3_ = self->priv->key_queue;
	_tmp4_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp3_);
	worm_direction_set (self, (WormDirection) ((gintptr) _tmp4_));
}


static gint worm_ai_deadend (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint length_left) {
	gint result = 0;
	gint cdir = 0;
	gint cx = 0;
	gint cy = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp46_;
	_tmp0_ = x;
	if (_tmp0_ >= NIBBLES_GAME_WIDTH) {
		x = 0;
	}
	_tmp1_ = x;
	if (_tmp1_ < 0) {
		x = NIBBLES_GAME_WIDTH - 1;
	}
	_tmp2_ = y;
	if (_tmp2_ >= NIBBLES_GAME_HEIGHT) {
		y = 0;
	}
	_tmp3_ = y;
	if (_tmp3_ < 0) {
		y = NIBBLES_GAME_HEIGHT - 1;
	}
	_tmp4_ = length_left;
	if (_tmp4_ <= 0) {
		result = 0;
		return result;
	}
	cdir = 5;
	while (TRUE) {
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint _tmp20__length2;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp5_ = cdir;
		cdir = _tmp5_ - 1;
		_tmp6_ = cdir;
		if (!(_tmp6_ > 0)) {
			break;
		}
		_tmp7_ = x;
		cx = _tmp7_;
		_tmp8_ = y;
		cy = _tmp8_;
		_tmp9_ = cdir;
		switch (_tmp9_) {
			case WORM_DIRECTION_UP:
			{
				gint _tmp10_;
				_tmp10_ = cy;
				cy = _tmp10_ - 1;
				break;
			}
			case WORM_DIRECTION_DOWN:
			{
				gint _tmp11_;
				_tmp11_ = cy;
				cy = _tmp11_ + 1;
				break;
			}
			case WORM_DIRECTION_LEFT:
			{
				gint _tmp12_;
				_tmp12_ = cx;
				cx = _tmp12_ - 1;
				break;
			}
			case WORM_DIRECTION_RIGHT:
			{
				gint _tmp13_;
				_tmp13_ = cx;
				cx = _tmp13_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp14_ = cx;
		if (_tmp14_ >= NIBBLES_GAME_WIDTH) {
			cx = 0;
		}
		_tmp15_ = cx;
		if (_tmp15_ < 0) {
			cx = NIBBLES_GAME_WIDTH - 1;
		}
		_tmp16_ = cy;
		if (_tmp16_ >= NIBBLES_GAME_HEIGHT) {
			cy = 0;
		}
		_tmp17_ = cy;
		if (_tmp17_ < 0) {
			cy = NIBBLES_GAME_HEIGHT - 1;
		}
		_tmp20_ = board;
		_tmp20__length1 = board_length1;
		_tmp20__length2 = board_length2;
		_tmp21_ = cx;
		_tmp22_ = cy;
		_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
		if (_tmp23_ <= ((gint) NIBBLES_GAME_EMPTYCHAR)) {
			_tmp19_ = TRUE;
		} else {
			gint* _tmp24_;
			gint _tmp24__length1;
			gint _tmp24__length2;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp24_ = board;
			_tmp24__length1 = board_length1;
			_tmp24__length2 = board_length2;
			_tmp25_ = x;
			_tmp26_ = y;
			_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
			_tmp28_ = numworms;
			_tmp19_ = _tmp27_ >= ('z' + _tmp28_);
		}
		if (_tmp19_) {
			guint* _tmp29_;
			gint _tmp29__length1;
			gint _tmp29__length2;
			gint _tmp30_;
			gint _tmp31_;
			guint _tmp32_;
			guint _tmp33_;
			_tmp29_ = worm_deadend_board;
			_tmp29__length1 = worm_deadend_board_length1;
			_tmp29__length2 = worm_deadend_board_length2;
			_tmp30_ = cx;
			_tmp31_ = cy;
			_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
			_tmp33_ = worm_deadend_runnumber;
			_tmp18_ = _tmp32_ != _tmp33_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			guint* _tmp34_;
			gint _tmp34__length1;
			gint _tmp34__length2;
			gint _tmp35_;
			gint _tmp36_;
			guint _tmp37_;
			guint _tmp38_;
			gint* _tmp39_;
			gint _tmp39__length1;
			gint _tmp39__length2;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			_tmp34_ = worm_deadend_board;
			_tmp34__length1 = worm_deadend_board_length1;
			_tmp34__length2 = worm_deadend_board_length2;
			_tmp35_ = cx;
			_tmp36_ = cy;
			_tmp37_ = worm_deadend_runnumber;
			_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = _tmp37_;
			_tmp38_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
			_tmp39_ = board;
			_tmp39__length1 = board_length1;
			_tmp39__length2 = board_length2;
			_tmp40_ = numworms;
			_tmp41_ = cx;
			_tmp42_ = cy;
			_tmp43_ = length_left;
			_tmp44_ = worm_ai_deadend (_tmp39_, _tmp39__length1, _tmp39__length2, _tmp40_, _tmp41_, _tmp42_, _tmp43_ - 1);
			length_left = _tmp44_;
			_tmp45_ = length_left;
			if (_tmp45_ <= 0) {
				result = 0;
				return result;
			}
		}
	}
	_tmp46_ = length_left;
	result = _tmp46_;
	return result;
}


static gint worm_ai_deadend_after (gint* board, int board_length1, int board_length2, GeeLinkedList* worms, gint numworms, gint x, gint y, gint dir, gint length) {
	gint result = 0;
	gint cx = 0;
	gint cy = 0;
	gint cl = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	guint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	guint* _tmp66_;
	gint _tmp66__length1;
	gint _tmp66__length2;
	gint _tmp67_;
	gint _tmp68_;
	guint _tmp69_;
	guint _tmp70_;
	guint* _tmp71_;
	gint _tmp71__length1;
	gint _tmp71__length2;
	gint _tmp72_;
	gint _tmp73_;
	guint _tmp74_;
	guint _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gint* _tmp79_;
	gint _tmp79__length1;
	gint _tmp79__length2;
	gint _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	g_return_val_if_fail (worms != NULL, 0);
	_tmp3_ = x;
	if (_tmp3_ < 0) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = x;
		_tmp2_ = _tmp4_ >= NIBBLES_GAME_WIDTH;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp5_;
		_tmp5_ = y;
		_tmp1_ = _tmp5_ < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp6_;
		_tmp6_ = y;
		_tmp0_ = _tmp6_ >= NIBBLES_GAME_HEIGHT;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp7_ = worm_deadend_runnumber;
	worm_deadend_runnumber = _tmp7_ + 1;
	_tmp8_ = dir;
	if (_tmp8_ > 4) {
		dir = 1;
	}
	_tmp9_ = dir;
	if (_tmp9_ < 1) {
		dir = 4;
	}
	_tmp10_ = numworms;
	i = _tmp10_;
	while (TRUE) {
		gint _tmp11_;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gpointer _tmp14_;
		Worm* _tmp15_;
		Position _tmp16_ = {0};
		Position _tmp17_;
		gint _tmp18_;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gpointer _tmp21_;
		Worm* _tmp22_;
		Position _tmp23_ = {0};
		Position _tmp24_;
		gint _tmp25_;
		gboolean _tmp26_ = FALSE;
		gint _tmp27_;
		gint _tmp28_;
		_tmp11_ = i;
		i = _tmp11_ - 1;
		if (!(_tmp11_ > 0)) {
			break;
		}
		_tmp12_ = worms;
		_tmp13_ = i;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
		_tmp15_ = (Worm*) _tmp14_;
		worm_get_head (_tmp15_, &_tmp16_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_.x;
		cx = _tmp18_;
		_g_object_unref0 (_tmp15_);
		_tmp19_ = worms;
		_tmp20_ = i;
		_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
		_tmp22_ = (Worm*) _tmp21_;
		worm_get_head (_tmp22_, &_tmp23_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_.y;
		cy = _tmp25_;
		_g_object_unref0 (_tmp22_);
		_tmp27_ = cx;
		_tmp28_ = x;
		if (_tmp27_ != _tmp28_) {
			_tmp26_ = TRUE;
		} else {
			gint _tmp29_;
			gint _tmp30_;
			_tmp29_ = cy;
			_tmp30_ = y;
			_tmp26_ = _tmp29_ != _tmp30_;
		}
		if (_tmp26_) {
			gint _tmp31_;
			gint _tmp37_;
			gint _tmp43_;
			gint _tmp49_;
			_tmp31_ = cx;
			if (_tmp31_ > 0) {
				guint* _tmp32_;
				gint _tmp32__length1;
				gint _tmp32__length2;
				gint _tmp33_;
				gint _tmp34_;
				guint _tmp35_;
				guint _tmp36_;
				_tmp32_ = worm_deadend_board;
				_tmp32__length1 = worm_deadend_board_length1;
				_tmp32__length2 = worm_deadend_board_length2;
				_tmp33_ = cx;
				_tmp34_ = cy;
				_tmp35_ = worm_deadend_runnumber;
				_tmp32_[((_tmp33_ - 1) * _tmp32__length2) + _tmp34_] = _tmp35_;
				_tmp36_ = _tmp32_[((_tmp33_ - 1) * _tmp32__length2) + _tmp34_];
			}
			_tmp37_ = cy;
			if (_tmp37_ > 0) {
				guint* _tmp38_;
				gint _tmp38__length1;
				gint _tmp38__length2;
				gint _tmp39_;
				gint _tmp40_;
				guint _tmp41_;
				guint _tmp42_;
				_tmp38_ = worm_deadend_board;
				_tmp38__length1 = worm_deadend_board_length1;
				_tmp38__length2 = worm_deadend_board_length2;
				_tmp39_ = cx;
				_tmp40_ = cy;
				_tmp41_ = worm_deadend_runnumber;
				_tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)] = _tmp41_;
				_tmp42_ = _tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)];
			}
			_tmp43_ = cx;
			if (_tmp43_ < (NIBBLES_GAME_WIDTH - 1)) {
				guint* _tmp44_;
				gint _tmp44__length1;
				gint _tmp44__length2;
				gint _tmp45_;
				gint _tmp46_;
				guint _tmp47_;
				guint _tmp48_;
				_tmp44_ = worm_deadend_board;
				_tmp44__length1 = worm_deadend_board_length1;
				_tmp44__length2 = worm_deadend_board_length2;
				_tmp45_ = cx;
				_tmp46_ = cy;
				_tmp47_ = worm_deadend_runnumber;
				_tmp44_[((_tmp45_ + 1) * _tmp44__length2) + _tmp46_] = _tmp47_;
				_tmp48_ = _tmp44_[((_tmp45_ + 1) * _tmp44__length2) + _tmp46_];
			}
			_tmp49_ = cy;
			if (_tmp49_ < (NIBBLES_GAME_HEIGHT - 1)) {
				guint* _tmp50_;
				gint _tmp50__length1;
				gint _tmp50__length2;
				gint _tmp51_;
				gint _tmp52_;
				guint _tmp53_;
				guint _tmp54_;
				_tmp50_ = worm_deadend_board;
				_tmp50__length1 = worm_deadend_board_length1;
				_tmp50__length2 = worm_deadend_board_length2;
				_tmp51_ = cx;
				_tmp52_ = cy;
				_tmp53_ = worm_deadend_runnumber;
				_tmp50_[(_tmp51_ * _tmp50__length2) + (_tmp52_ + 1)] = _tmp53_;
				_tmp54_ = _tmp50_[(_tmp51_ * _tmp50__length2) + (_tmp52_ + 1)];
			}
		}
	}
	_tmp55_ = x;
	cx = _tmp55_;
	_tmp56_ = y;
	cy = _tmp56_;
	_tmp57_ = dir;
	switch (_tmp57_) {
		case WORM_DIRECTION_UP:
		{
			gint _tmp58_;
			_tmp58_ = cy;
			cy = _tmp58_ - 1;
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			gint _tmp59_;
			_tmp59_ = cy;
			cy = _tmp59_ + 1;
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			gint _tmp60_;
			_tmp60_ = cx;
			cx = _tmp60_ - 1;
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			gint _tmp61_;
			_tmp61_ = cx;
			cx = _tmp61_ + 1;
			break;
		}
		default:
		break;
	}
	_tmp62_ = cx;
	if (_tmp62_ >= NIBBLES_GAME_WIDTH) {
		cx = 0;
	}
	_tmp63_ = cx;
	if (_tmp63_ < 0) {
		cx = NIBBLES_GAME_WIDTH - 1;
	}
	_tmp64_ = cy;
	if (_tmp64_ >= NIBBLES_GAME_HEIGHT) {
		cy = 0;
	}
	_tmp65_ = cy;
	if (_tmp65_ < 0) {
		cy = NIBBLES_GAME_HEIGHT - 1;
	}
	_tmp66_ = worm_deadend_board;
	_tmp66__length1 = worm_deadend_board_length1;
	_tmp66__length2 = worm_deadend_board_length2;
	_tmp67_ = x;
	_tmp68_ = y;
	_tmp69_ = worm_deadend_runnumber;
	_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = _tmp69_;
	_tmp70_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
	_tmp71_ = worm_deadend_board;
	_tmp71__length1 = worm_deadend_board_length1;
	_tmp71__length2 = worm_deadend_board_length2;
	_tmp72_ = cx;
	_tmp73_ = cy;
	_tmp74_ = worm_deadend_runnumber;
	_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = _tmp74_;
	_tmp75_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
	_tmp76_ = length;
	_tmp77_ = length;
	cl = (_tmp76_ * _tmp77_) / 16;
	_tmp78_ = cl;
	if (_tmp78_ < NIBBLES_GAME_WIDTH) {
		cl = NIBBLES_GAME_WIDTH;
	}
	_tmp79_ = board;
	_tmp79__length1 = board_length1;
	_tmp79__length2 = board_length2;
	_tmp80_ = numworms;
	_tmp81_ = cx;
	_tmp82_ = cy;
	_tmp83_ = cl;
	_tmp84_ = worm_ai_deadend (_tmp79_, _tmp79__length1, _tmp79__length2, _tmp80_, _tmp81_, _tmp82_, _tmp83_);
	result = _tmp84_;
	return result;
}


static gboolean worm_ai_too_close (Worm* self, GeeLinkedList* worms, gint numworms) {
	gboolean result = FALSE;
	gint i;
	gint _tmp0_;
	gint dx = 0;
	gint dy = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worms != NULL, FALSE);
	_tmp0_ = numworms;
	i = _tmp0_;
	while (TRUE) {
		gint _tmp1_;
		Position _tmp2_ = {0};
		Position _tmp3_;
		gint _tmp4_;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gpointer _tmp7_;
		Worm* _tmp8_;
		Position _tmp9_ = {0};
		Position _tmp10_;
		gint _tmp11_;
		Position _tmp12_ = {0};
		Position _tmp13_;
		gint _tmp14_;
		GeeLinkedList* _tmp15_;
		gint _tmp16_;
		gpointer _tmp17_;
		Worm* _tmp18_;
		Position _tmp19_ = {0};
		Position _tmp20_;
		gint _tmp21_;
		WormDirection _tmp22_;
		_tmp1_ = i;
		i = _tmp1_ - 1;
		if (!(_tmp1_ > 0)) {
			break;
		}
		worm_get_head (self, &_tmp2_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_.x;
		_tmp5_ = worms;
		_tmp6_ = i;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp6_);
		_tmp8_ = (Worm*) _tmp7_;
		worm_get_head (_tmp8_, &_tmp9_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_.x;
		dx = _tmp4_ - _tmp11_;
		_g_object_unref0 (_tmp8_);
		worm_get_head (self, &_tmp12_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_.y;
		_tmp15_ = worms;
		_tmp16_ = i;
		_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
		_tmp18_ = (Worm*) _tmp17_;
		worm_get_head (_tmp18_, &_tmp19_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_.y;
		dy = _tmp14_ - _tmp21_;
		_g_object_unref0 (_tmp18_);
		_tmp22_ = self->direction;
		switch (_tmp22_) {
			case WORM_DIRECTION_UP:
			{
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gint _tmp26_;
				_tmp26_ = dy;
				if (_tmp26_ > 0) {
					gint _tmp27_;
					_tmp27_ = dy;
					_tmp25_ = _tmp27_ <= 3;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					gint _tmp28_;
					_tmp28_ = dx;
					_tmp24_ = _tmp28_ >= -1;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					gint _tmp29_;
					_tmp29_ = dx;
					_tmp23_ = _tmp29_ <= 1;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_DOWN:
			{
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				gint _tmp33_;
				_tmp33_ = dy;
				if (_tmp33_ < 0) {
					gint _tmp34_;
					_tmp34_ = dy;
					_tmp32_ = _tmp34_ >= -3;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					gint _tmp35_;
					_tmp35_ = dx;
					_tmp31_ = _tmp35_ >= -1;
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					gint _tmp36_;
					_tmp36_ = dx;
					_tmp30_ = _tmp36_ <= 1;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_LEFT:
			{
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_;
				_tmp40_ = dx;
				if (_tmp40_ > 0) {
					gint _tmp41_;
					_tmp41_ = dx;
					_tmp39_ = _tmp41_ <= 3;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					gint _tmp42_;
					_tmp42_ = dy;
					_tmp38_ = _tmp42_ >= -1;
				} else {
					_tmp38_ = FALSE;
				}
				if (_tmp38_) {
					gint _tmp43_;
					_tmp43_ = dy;
					_tmp37_ = _tmp43_ <= 1;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					result = TRUE;
					return result;
				}
				break;
			}
			case WORM_DIRECTION_RIGHT:
			{
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gint _tmp47_;
				_tmp47_ = dx;
				if (_tmp47_ < 0) {
					gint _tmp48_;
					_tmp48_ = dx;
					_tmp46_ = _tmp48_ >= -3;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					gint _tmp49_;
					_tmp49_ = dy;
					_tmp45_ = _tmp49_ >= -1;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					gint _tmp50_;
					_tmp50_ = dy;
					_tmp44_ = _tmp50_ <= 1;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					result = TRUE;
					return result;
				}
				break;
			}
			default:
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean worm_ai_wander (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint dir, gint ox, gint oy) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	_tmp0_ = dir;
	if (_tmp0_ > 4) {
		dir = 1;
	}
	_tmp1_ = dir;
	if (_tmp1_ < 1) {
		dir = 4;
	}
	_tmp2_ = dir;
	switch (_tmp2_) {
		case WORM_DIRECTION_UP:
		{
			gint _tmp3_;
			_tmp3_ = y;
			y = _tmp3_ - 1;
			break;
		}
		case WORM_DIRECTION_DOWN:
		{
			gint _tmp4_;
			_tmp4_ = y;
			y = _tmp4_ + 1;
			break;
		}
		case WORM_DIRECTION_LEFT:
		{
			gint _tmp5_;
			_tmp5_ = x;
			x = _tmp5_ - 1;
			break;
		}
		case WORM_DIRECTION_RIGHT:
		{
			gint _tmp6_;
			_tmp6_ = x;
			x = _tmp6_ + 1;
			break;
		}
		default:
		break;
	}
	_tmp7_ = x;
	if (_tmp7_ >= NIBBLES_GAME_WIDTH) {
		x = 0;
	}
	_tmp8_ = x;
	if (_tmp8_ < 0) {
		x = NIBBLES_GAME_WIDTH - 1;
	}
	_tmp9_ = y;
	if (_tmp9_ >= NIBBLES_GAME_HEIGHT) {
		y = 0;
	}
	_tmp10_ = y;
	if (_tmp10_ < 0) {
		y = NIBBLES_GAME_HEIGHT - 1;
	}
	_tmp11_ = board;
	_tmp11__length1 = board_length1;
	_tmp11__length2 = board_length2;
	_tmp12_ = x;
	_tmp13_ = y;
	_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
	switch (_tmp14_ - 'A') {
		case BONUS_TYPE_REGULAR:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_DOUBLE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_LIFE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_REVERSE:
		{
			result = TRUE;
			return result;
		}
		case BONUS_TYPE_HALF:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			gboolean _tmp15_ = FALSE;
			gint* _tmp16_;
			gint _tmp16__length1;
			gint _tmp16__length2;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp16_ = board;
			_tmp16__length1 = board_length1;
			_tmp16__length2 = board_length2;
			_tmp17_ = x;
			_tmp18_ = y;
			_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
			if (_tmp19_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
				gint* _tmp20_;
				gint _tmp20__length1;
				gint _tmp20__length2;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp20_ = board;
				_tmp20__length1 = board_length1;
				_tmp20__length2 = board_length2;
				_tmp21_ = x;
				_tmp22_ = y;
				_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
				_tmp24_ = numworms;
				_tmp15_ = _tmp23_ < ('z' + _tmp24_);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = FALSE;
				return result;
			} else {
				gboolean _tmp25_ = FALSE;
				gint _tmp26_;
				gint _tmp27_;
				gint* _tmp30_;
				gint _tmp30__length1;
				gint _tmp30__length2;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gboolean _tmp37_;
				_tmp26_ = ox;
				_tmp27_ = x;
				if (_tmp26_ == _tmp27_) {
					gint _tmp28_;
					gint _tmp29_;
					_tmp28_ = oy;
					_tmp29_ = y;
					_tmp25_ = _tmp28_ == _tmp29_;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					result = FALSE;
					return result;
				}
				_tmp30_ = board;
				_tmp30__length1 = board_length1;
				_tmp30__length2 = board_length2;
				_tmp31_ = numworms;
				_tmp32_ = x;
				_tmp33_ = y;
				_tmp34_ = dir;
				_tmp35_ = ox;
				_tmp36_ = oy;
				_tmp37_ = worm_ai_wander (_tmp30_, _tmp30__length1, _tmp30__length2, _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_);
				result = _tmp37_;
				return result;
			}
		}
	}
}


void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms) {
	WormDirection opposite;
	WormDirection _tmp0_;
	gboolean front;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint _tmp2_;
	Position _tmp3_ = {0};
	Position _tmp4_;
	gint _tmp5_;
	Position _tmp6_ = {0};
	Position _tmp7_;
	gint _tmp8_;
	WormDirection _tmp9_;
	Position _tmp10_ = {0};
	Position _tmp11_;
	gint _tmp12_;
	Position _tmp13_ = {0};
	Position _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gboolean left;
	gint* _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	gint _tmp18_;
	Position _tmp19_ = {0};
	Position _tmp20_;
	gint _tmp21_;
	Position _tmp22_ = {0};
	Position _tmp23_;
	gint _tmp24_;
	WormDirection _tmp25_;
	Position _tmp26_ = {0};
	Position _tmp27_;
	gint _tmp28_;
	Position _tmp29_ = {0};
	Position _tmp30_;
	gint _tmp31_;
	gboolean _tmp32_;
	gboolean right;
	gint* _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	gint _tmp34_;
	Position _tmp35_ = {0};
	Position _tmp36_;
	gint _tmp37_;
	Position _tmp38_ = {0};
	Position _tmp39_;
	gint _tmp40_;
	WormDirection _tmp41_;
	Position _tmp42_ = {0};
	Position _tmp43_;
	gint _tmp44_;
	Position _tmp45_ = {0};
	Position _tmp46_;
	gint _tmp47_;
	gboolean _tmp48_;
	gint dir = 0;
	gboolean _tmp49_;
	WormDirection old_dir;
	WormDirection _tmp67_;
	gint best_yet;
	gint best_dir;
	gint this_len = 0;
	gint _tmp109_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worms != NULL);
	_tmp0_ = self->direction;
	opposite = ((_tmp0_ + 1) % 4) + 1;
	_tmp1_ = board;
	_tmp1__length1 = board_length1;
	_tmp1__length2 = board_length2;
	_tmp2_ = numworms;
	worm_get_head (self, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.x;
	worm_get_head (self, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_.y;
	_tmp9_ = self->direction;
	worm_get_head (self, &_tmp10_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_.x;
	worm_get_head (self, &_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_.y;
	_tmp16_ = worm_ai_wander (_tmp1_, _tmp1__length1, _tmp1__length2, _tmp2_, _tmp5_, _tmp8_, (gint) _tmp9_, _tmp12_, _tmp15_);
	front = _tmp16_;
	_tmp17_ = board;
	_tmp17__length1 = board_length1;
	_tmp17__length2 = board_length2;
	_tmp18_ = numworms;
	worm_get_head (self, &_tmp19_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_.x;
	worm_get_head (self, &_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_.y;
	_tmp25_ = self->direction;
	worm_get_head (self, &_tmp26_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_.x;
	worm_get_head (self, &_tmp29_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_.y;
	_tmp32_ = worm_ai_wander (_tmp17_, _tmp17__length1, _tmp17__length2, _tmp18_, _tmp21_, _tmp24_, (gint) (_tmp25_ - 1), _tmp28_, _tmp31_);
	left = _tmp32_;
	_tmp33_ = board;
	_tmp33__length1 = board_length1;
	_tmp33__length2 = board_length2;
	_tmp34_ = numworms;
	worm_get_head (self, &_tmp35_);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_.x;
	worm_get_head (self, &_tmp38_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_.y;
	_tmp41_ = self->direction;
	worm_get_head (self, &_tmp42_);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_.x;
	worm_get_head (self, &_tmp45_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_.y;
	_tmp48_ = worm_ai_wander (_tmp33_, _tmp33__length1, _tmp33__length2, _tmp34_, _tmp37_, _tmp40_, (gint) (_tmp41_ + 1), _tmp44_, _tmp47_);
	right = _tmp48_;
	_tmp49_ = front;
	if (!_tmp49_) {
		gboolean _tmp50_;
		_tmp50_ = left;
		if (_tmp50_) {
			WormDirection _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			_tmp51_ = self->direction;
			dir = (gint) (_tmp51_ - 1);
			_tmp52_ = dir;
			if (_tmp52_ < 1) {
				dir = 4;
			}
			_tmp53_ = dir;
			self->direction = (WormDirection) _tmp53_;
		} else {
			gboolean _tmp54_;
			_tmp54_ = right;
			if (_tmp54_) {
				WormDirection _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				_tmp55_ = self->direction;
				dir = (gint) (_tmp55_ + 1);
				_tmp56_ = dir;
				if (_tmp56_ > 4) {
					dir = 1;
				}
				_tmp57_ = dir;
				self->direction = (WormDirection) _tmp57_;
			} else {
				gint32 _tmp58_;
				_tmp58_ = g_random_int_range ((gint32) 0, (gint32) 30);
				if (_tmp58_ == ((gint32) 1)) {
					gint _tmp59_ = 0;
					gboolean _tmp60_;
					WormDirection _tmp61_;
					gint _tmp62_;
					WormDirection _tmp63_;
					_tmp60_ = g_random_boolean ();
					if (_tmp60_) {
						_tmp59_ = 1;
					} else {
						_tmp59_ = -1;
					}
					_tmp61_ = self->direction;
					dir = (gint) (_tmp61_ + _tmp59_);
					_tmp62_ = dir;
					_tmp63_ = opposite;
					if (_tmp62_ != ((gint) _tmp63_)) {
						gint _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						_tmp64_ = dir;
						if (_tmp64_ > 4) {
							dir = 1;
						}
						_tmp65_ = dir;
						if (_tmp65_ < 1) {
							dir = 4;
						}
						_tmp66_ = dir;
						self->direction = (WormDirection) _tmp66_;
					}
				}
			}
		}
	}
	_tmp67_ = self->direction;
	old_dir = _tmp67_;
	best_yet = NIBBLES_GAME_CAPACITY * 2;
	best_dir = -1;
	{
		gboolean _tmp68_;
		dir = 1;
		_tmp68_ = TRUE;
		while (TRUE) {
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			WormDirection _tmp73_;
			gint* _tmp74_;
			gint _tmp74__length1;
			gint _tmp74__length2;
			gint _tmp75_;
			gboolean _tmp76_;
			GeeLinkedList* _tmp78_;
			gint _tmp79_;
			gboolean _tmp80_;
			gint _tmp82_;
			gint* _tmp83_;
			gint _tmp83__length1;
			gint _tmp83__length2;
			GeeLinkedList* _tmp84_;
			gint _tmp85_;
			Position _tmp86_ = {0};
			Position _tmp87_;
			gint _tmp88_;
			Position _tmp89_ = {0};
			Position _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			gboolean _tmp97_ = FALSE;
			gint _tmp98_;
			WormDirection _tmp99_;
			gint _tmp102_;
			gint _tmp105_;
			gint _tmp106_;
			if (!_tmp68_) {
				gint _tmp69_;
				_tmp69_ = dir;
				dir = _tmp69_ + 1;
			}
			_tmp68_ = FALSE;
			_tmp70_ = dir;
			if (!(_tmp70_ <= 4)) {
				break;
			}
			_tmp71_ = dir;
			self->direction = (WormDirection) _tmp71_;
			_tmp72_ = dir;
			_tmp73_ = opposite;
			if (_tmp72_ == ((gint) _tmp73_)) {
				continue;
			}
			this_len = 0;
			_tmp74_ = board;
			_tmp74__length1 = board_length1;
			_tmp74__length2 = board_length2;
			_tmp75_ = numworms;
			_tmp76_ = worm_can_move_to (self, _tmp74_, _tmp74__length1, _tmp74__length2, _tmp75_);
			if (!_tmp76_) {
				gint _tmp77_;
				_tmp77_ = this_len;
				this_len = _tmp77_ + NIBBLES_GAME_CAPACITY;
			}
			_tmp78_ = worms;
			_tmp79_ = numworms;
			_tmp80_ = worm_ai_too_close (self, _tmp78_, _tmp79_);
			if (_tmp80_) {
				gint _tmp81_;
				_tmp81_ = this_len;
				this_len = _tmp81_ + 4;
			}
			_tmp82_ = this_len;
			_tmp83_ = board;
			_tmp83__length1 = board_length1;
			_tmp83__length2 = board_length2;
			_tmp84_ = worms;
			_tmp85_ = numworms;
			worm_get_head (self, &_tmp86_);
			_tmp87_ = _tmp86_;
			_tmp88_ = _tmp87_.x;
			worm_get_head (self, &_tmp89_);
			_tmp90_ = _tmp89_;
			_tmp91_ = _tmp90_.y;
			_tmp92_ = dir;
			_tmp93_ = worm_get_length (self);
			_tmp94_ = _tmp93_;
			_tmp95_ = self->change;
			_tmp96_ = worm_ai_deadend_after (_tmp83_, _tmp83__length1, _tmp83__length2, _tmp84_, _tmp85_, _tmp88_, _tmp91_, _tmp92_, _tmp94_ + _tmp95_);
			this_len = _tmp82_ + _tmp96_;
			_tmp98_ = dir;
			_tmp99_ = old_dir;
			if (_tmp98_ == ((gint) _tmp99_)) {
				gint _tmp100_;
				_tmp100_ = this_len;
				_tmp97_ = _tmp100_ <= 0;
			} else {
				_tmp97_ = FALSE;
			}
			if (_tmp97_) {
				gint _tmp101_;
				_tmp101_ = this_len;
				this_len = _tmp101_ - 100;
			}
			_tmp102_ = this_len;
			if (_tmp102_ <= 0) {
				gint _tmp103_;
				gint32 _tmp104_;
				_tmp103_ = this_len;
				_tmp104_ = g_random_int_range ((gint32) 0, (gint32) 100);
				this_len = _tmp103_ - _tmp104_;
			}
			_tmp105_ = this_len;
			_tmp106_ = best_yet;
			if (_tmp105_ < _tmp106_) {
				gint _tmp107_;
				gint _tmp108_;
				_tmp107_ = this_len;
				best_yet = _tmp107_;
				_tmp108_ = dir;
				best_dir = _tmp108_;
			}
		}
	}
	_tmp109_ = best_dir;
	self->direction = (WormDirection) _tmp109_;
	{
		gboolean _tmp110_;
		dir = 1;
		_tmp110_ = TRUE;
		while (TRUE) {
			gint _tmp112_;
			gint _tmp113_;
			WormDirection _tmp114_;
			gint* _tmp115_;
			gint _tmp115__length1;
			gint _tmp115__length2;
			gint _tmp116_;
			gboolean _tmp117_;
			if (!_tmp110_) {
				gint _tmp111_;
				_tmp111_ = dir;
				dir = _tmp111_ + 1;
			}
			_tmp110_ = FALSE;
			_tmp112_ = dir;
			if (!(_tmp112_ <= 4)) {
				break;
			}
			_tmp113_ = dir;
			_tmp114_ = opposite;
			if (_tmp113_ == ((gint) _tmp114_)) {
				continue;
			}
			_tmp115_ = board;
			_tmp115__length1 = board_length1;
			_tmp115__length2 = board_length2;
			_tmp116_ = numworms;
			_tmp117_ = worm_can_move_to (self, _tmp115_, _tmp115__length1, _tmp115__length2, _tmp116_);
			if (!_tmp117_) {
				gint _tmp118_;
				_tmp118_ = dir;
				self->direction = (WormDirection) _tmp118_;
			} else {
				continue;
			}
		}
	}
}


void worm_get_starting_position (Worm* self, Position * result) {
	Position _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_starting_position;
	*result = _tmp0_;
	return;
}


static void worm_set_starting_position (Worm* self, Position * value) {
	Position old_value;
	g_return_if_fail (self != NULL);
	if (_position_equal (value, (worm_get_starting_position (self, &old_value), &old_value)) != TRUE) {
		Position _tmp0_;
		_tmp0_ = *value;
		self->priv->_starting_position = _tmp0_;
		g_object_notify ((GObject *) self, "starting-position");
	}
}


gint worm_get_id (Worm* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void worm_set_id (Worm* self, gint value) {
	g_return_if_fail (self != NULL);
	if (worm_get_id (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify ((GObject *) self, "id");
	}
}


gboolean worm_get_is_materialized (Worm* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_materialized;
	result = _tmp0_;
	return result;
}


static void worm_set_is_materialized (Worm* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (worm_get_is_materialized (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_materialized = _tmp0_;
		g_object_notify ((GObject *) self, "is-materialized");
	}
}


gint worm_get_lives (Worm* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_lives;
	result = _tmp0_;
	return result;
}


void worm_set_lives (Worm* self, gint value) {
	g_return_if_fail (self != NULL);
	if (worm_get_lives (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_lives = _tmp0_;
		g_object_notify ((GObject *) self, "lives");
	}
}


gint worm_get_score (Worm* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void worm_set_score (Worm* self, gint value) {
	g_return_if_fail (self != NULL);
	if (worm_get_score (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_score = _tmp0_;
		g_object_notify ((GObject *) self, "score");
	}
}


gint worm_get_length (Worm* self) {
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void worm_set_length (Worm* self, gint value) {
	g_return_if_fail (self != NULL);
	if (worm_get_length (self) != value) {
		g_object_notify ((GObject *) self, "length");
	}
}


void worm_get_head (Worm* self, Position * result) {
	Position head;
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Position* _tmp2_;
	Position _tmp3_;
	Position _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	_tmp1_ = gee_linked_list_first (_tmp0_);
	_tmp2_ = (Position*) _tmp1_;
	_tmp3_ = *_tmp2_;
	_position_free0 (_tmp2_);
	head = _tmp3_;
	_tmp4_ = head;
	*result = _tmp4_;
	return;
}


static void worm_set_head (Worm* self, Position * value) {
	Position old_value;
	g_return_if_fail (self != NULL);
	if (_position_equal (value, (worm_get_head (self, &old_value), &old_value)) != TRUE) {
		GeeLinkedList* _tmp0_;
		Position _tmp1_;
		_tmp0_ = self->priv->_list;
		_tmp1_ = *value;
		gee_abstract_list_set ((GeeAbstractList*) _tmp0_, 0, &_tmp1_);
		g_object_notify ((GObject *) self, "head");
	}
}


GeeLinkedList* worm_get_list (Worm* self) {
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list;
	result = _tmp0_;
	return result;
}


static void worm_set_list (Worm* self, GeeLinkedList* value) {
	g_return_if_fail (self != NULL);
	if (worm_get_list (self) != value) {
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_list);
		self->priv->_list = _tmp1_;
		g_object_notify ((GObject *) self, "list");
	}
}


static void worm_class_init (WormClass * klass) {
	guint* _tmp0_;
	worm_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (WormPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_worm_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_worm_set_property;
	G_OBJECT_CLASS (klass)->finalize = worm_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_STARTING_POSITION, g_param_spec_boxed ("starting-position", "starting-position", "starting-position", TYPE_POSITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_IS_MATERIALIZED, g_param_spec_boolean ("is-materialized", "is-materialized", "is-materialized", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIVES, g_param_spec_int ("lives", "lives", "lives", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_SCORE, g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_HEAD, g_param_spec_boxed ("head", "head", "head", TYPE_POSITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIST, g_param_spec_object ("list", "list", "list", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	worm_signals[WORM_ADDED_SIGNAL] = g_signal_new ("added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_FINISH_ADDED_SIGNAL] = g_signal_new ("finish_added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_RESCALED_SIGNAL] = g_signal_new ("rescaled", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	worm_signals[WORM_DIED_SIGNAL] = g_signal_new ("died", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_TAIL_REDUCED_SIGNAL] = g_signal_new ("tail_reduced", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	worm_signals[WORM_REVERSED_SIGNAL] = g_signal_new ("reversed", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_BONUS_FOUND_SIGNAL] = g_signal_new ("bonus_found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	worm_signals[WORM_WARP_FOUND_SIGNAL] = g_signal_new ("warp_found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_new0 (guint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
	worm_deadend_board = _tmp0_;
	worm_deadend_board_length1 = NIBBLES_GAME_WIDTH;
	worm_deadend_board_length2 = NIBBLES_GAME_HEIGHT;
}


static void worm_instance_init (Worm * self) {
	self->priv = WORM_GET_PRIVATE (self);
	self->keypress = FALSE;
	self->is_stopped = FALSE;
	self->priv->_is_materialized = TRUE;
}


static void worm_finalize (GObject * obj) {
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORM, Worm);
	_g_object_unref0 (self->priv->key_queue);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (worm_parent_class)->finalize (obj);
}


GType worm_get_type (void) {
	static volatile gsize worm_type_id__volatile = 0;
	if (g_once_init_enter (&worm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Worm), 0, (GInstanceInitFunc) worm_instance_init, NULL };
		GType worm_type_id;
		worm_type_id = g_type_register_static (G_TYPE_OBJECT, "Worm", &g_define_type_info, 0);
		g_once_init_leave (&worm_type_id__volatile, worm_type_id);
	}
	return worm_type_id__volatile;
}


static void _vala_worm_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
	switch (property_id) {
		case WORM_STARTING_POSITION:
		{
			Position boxed;
			worm_get_starting_position (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case WORM_ID:
		g_value_set_int (value, worm_get_id (self));
		break;
		case WORM_IS_MATERIALIZED:
		g_value_set_boolean (value, worm_get_is_materialized (self));
		break;
		case WORM_LIVES:
		g_value_set_int (value, worm_get_lives (self));
		break;
		case WORM_SCORE:
		g_value_set_int (value, worm_get_score (self));
		break;
		case WORM_LENGTH:
		g_value_set_int (value, worm_get_length (self));
		break;
		case WORM_HEAD:
		{
			Position boxed;
			worm_get_head (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case WORM_LIST:
		g_value_set_object (value, worm_get_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_worm_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
	switch (property_id) {
		case WORM_STARTING_POSITION:
		worm_set_starting_position (self, g_value_get_boxed (value));
		break;
		case WORM_ID:
		worm_set_id (self, g_value_get_int (value));
		break;
		case WORM_IS_MATERIALIZED:
		worm_set_is_materialized (self, g_value_get_boolean (value));
		break;
		case WORM_LIVES:
		worm_set_lives (self, g_value_get_int (value));
		break;
		case WORM_SCORE:
		worm_set_score (self, g_value_get_int (value));
		break;
		case WORM_LENGTH:
		worm_set_length (self, g_value_get_int (value));
		break;
		case WORM_HEAD:
		worm_set_head (self, g_value_get_boxed (value));
		break;
		case WORM_LIST:
		worm_set_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



