/* gitg-lanes.c generated by valac 0.35.5.2-9e6c0, the Vala compiler
 * generated from gitg-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_LANES (gitg_lanes_get_type ())
#define GITG_LANES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANES, GitgLanes))
#define GITG_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANES, GitgLanesClass))
#define GITG_IS_LANES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANES))
#define GITG_IS_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANES))
#define GITG_LANES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANES, GitgLanesClass))

typedef struct _GitgLanes GitgLanes;
typedef struct _GitgLanesClass GitgLanesClass;
typedef struct _GitgLanesPrivate GitgLanesPrivate;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_LANES_TYPE_LANE_CONTAINER (gitg_lanes_lane_container_get_type ())
#define GITG_LANES_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer))
#define GITG_LANES_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))
#define GITG_LANES_IS_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_IS_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_LANE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))

typedef struct _GitgLanesLaneContainer GitgLanesLaneContainer;
typedef struct _GitgLanesLaneContainerClass GitgLanesLaneContainerClass;
typedef struct _GitgLanesCollapsedLane GitgLanesCollapsedLane;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GitgLanesLaneContainerPrivate GitgLanesLaneContainerPrivate;

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
#define _gitg_lanes_lane_container_unref0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_lane_container_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())
#define _gitg_lanes_collapsed_lane_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL)))
typedef struct _GitgLanesParamSpecLaneContainer GitgLanesParamSpecLaneContainer;

struct _GitgLanes {
	GObject parent_instance;
	GitgLanesPrivate * priv;
};

struct _GitgLanesClass {
	GObjectClass parent_class;
};

struct _GitgLanesPrivate {
	gint _inactive_max;
	gint _inactive_collapse;
	gint _inactive_gap;
	gboolean _inactive_enabled;
	GSList* d_previous;
	GeeLinkedList* d_lanes;
	GHashTable* d_collapsed;
	GeeHashSet* d_roots;
};

struct _GitgLanesLaneContainer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgLanesLaneContainerPrivate * priv;
	GitgLane* lane;
	gint inactive;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesLaneContainerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgLanesLaneContainer *self);
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4,
	GITG_LANE_TAG_HIDDEN = 1 << 5
} GitgLaneTag;

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};

struct _GitgLanesCollapsedLane {
	GitgColor* color;
	guint index;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesParamSpecLaneContainer {
	GParamSpec parent_instance;
};


static gpointer gitg_lanes_parent_class = NULL;
static gpointer gitg_lanes_lane_container_parent_class = NULL;

GType gitg_lanes_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
static gpointer gitg_lanes_lane_container_ref (gpointer instance);
static void gitg_lanes_lane_container_unref (gpointer instance);
static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gitg_lanes_value_get_lane_container (const GValue* value) G_GNUC_UNUSED;
static GType gitg_lanes_lane_container_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane * self);
#define GITG_LANES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_LANES, GitgLanesPrivate))
enum  {
	GITG_LANES_DUMMY_PROPERTY,
	GITG_LANES_INACTIVE_MAX,
	GITG_LANES_INACTIVE_COLLAPSE,
	GITG_LANES_INACTIVE_GAP,
	GITG_LANES_INACTIVE_ENABLED
};
GitgLanes* gitg_lanes_new (void);
GitgLanes* gitg_lanes_construct (GType object_type);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void _gitg_lanes_collapsed_lane_free0_ (gpointer var);
void gitg_lanes_reset (GitgLanes* self, GgitOId** reserved, int reserved_length1, GeeHashSet* roots);
void gitg_color_reset (void);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to);
GType gitg_lane_get_type (void) G_GNUC_CONST;
static void gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self, gboolean value);
gboolean gitg_lanes_next (GitgLanes* self, GitgCommit* next, GSList* * lanes, gint* nextpos);
gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self);
static void gitg_lanes_collapse_lanes (GitgLanes* self);
static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit);
static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
GType gitg_color_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GitgColor* gitg_color_copy (GitgColor* self);
static gboolean gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self);
static GSList* gitg_lanes_lanes_list (GitgLanes* self);
static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos, gboolean hidden);
static void gitg_lanes_init_next_layer (GitgLanes* self);
gint gitg_lanes_get_inactive_collapse (GitgLanes* self);
gint gitg_lanes_get_inactive_gap (GitgLanes* self);
static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
gint gitg_lanes_get_inactive_max (GitgLanes* self);
static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction);
static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index);
static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction);
static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane);
GitgLane* gitg_lane_new_with_color (GitgColor* color);
GitgLane* gitg_lane_construct_with_color (GType object_type, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color);
GitgLane* gitg_lane_copy (GitgLane* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id);
static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index);
void gitg_lanes_set_inactive_max (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value);
enum  {
	GITG_LANES_LANE_CONTAINER_DUMMY_PROPERTY
};
static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer * obj);
static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self);
static void gitg_lanes_finalize (GObject * obj);
static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 257 "gitg-lanes.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 266 "gitg-lanes.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 273 "gitg-lanes.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 280 "gitg-lanes.c"
}


static void _gitg_lanes_collapsed_lane_free0_ (gpointer var) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL));
#line 287 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_construct (GType object_type) {
	GitgLanes * self = NULL;
	GHashTable* _tmp0_;
	GSettings* settings;
	GSettings* _tmp1_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanes*) g_object_new (object_type, NULL);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, _gitg_lanes_collapsed_lane_free0_);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 114 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_collapsed = _tmp0_;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = g_settings_new ("org.gnome.gitg.preferences.history");
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	settings = _tmp1_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_settings_bind (settings, "collapse-inactive-lanes-enabled", (GObject*) self, "inactive-enabled", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
#line 124 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_settings_bind (settings, "collapse-inactive-lanes", (GObject*) self, "inactive-collapse", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_reset (self, NULL, 0, NULL);
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (settings);
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 318 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_new (void) {
#line 112 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_construct (GITG_TYPE_LANES);
#line 325 "gitg-lanes.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self ? g_object_ref (self) : NULL;
#line 332 "gitg-lanes.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 339 "gitg-lanes.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 346 "gitg-lanes.c"
}


void gitg_lanes_reset (GitgLanes* self, GgitOId** reserved, int reserved_length1, GeeHashSet* roots) {
	GeeLinkedList* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	GgitOId** _tmp3_;
	gint _tmp3__length1;
	GHashTable* _tmp12_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = gee_linked_list_new (GITG_LANES_TYPE_LANE_CONTAINER, (GBoxedCopyFunc) gitg_lanes_lane_container_ref, gitg_lanes_lane_container_unref, NULL, NULL, NULL);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_lanes = _tmp0_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = roots;
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_roots);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_roots = _tmp2_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_color_reset ();
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = reserved;
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3__length1 = reserved_length1;
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 381 "gitg-lanes.c"
		GgitOId** _tmp4_;
		gint _tmp4__length1;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = reserved;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4__length1 = reserved_length1;
#line 388 "gitg-lanes.c"
		{
			GgitOId** r_collection = NULL;
			gint r_collection_length1 = 0;
			gint _r_collection_size_ = 0;
			gint r_it = 0;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			r_collection = _tmp4_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			r_collection_length1 = _tmp4__length1;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			for (r_it = 0; r_it < _tmp4__length1; r_it = r_it + 1) {
#line 400 "gitg-lanes.c"
				GgitOId* _tmp5_;
				GgitOId* r = NULL;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = __vala_GgitOId_copy0 (r_collection[r_it]);
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				r = _tmp5_;
#line 407 "gitg-lanes.c"
				{
					GitgLanesLaneContainer* ct;
					GgitOId* _tmp6_;
					GitgLanesLaneContainer* _tmp7_;
					GitgLanesLaneContainer* _tmp8_;
					GitgLanesLaneContainer* _tmp9_;
					GeeLinkedList* _tmp10_;
					GitgLanesLaneContainer* _tmp11_;
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp6_ = r;
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp7_ = gitg_lanes_lane_container_new (NULL, _tmp6_);
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					ct = _tmp7_;
#line 145 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp8_ = ct;
#line 145 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp8_->inactive = -1;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp9_ = ct;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					gitg_lanes_lane_container_set_is_hidden (_tmp9_, TRUE);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp10_ = self->priv->d_lanes;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp11_ = ct;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_gitg_lanes_lane_container_unref0 (ct);
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (r);
#line 440 "gitg-lanes.c"
				}
			}
		}
	}
#line 152 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = self->priv->d_collapsed;
#line 152 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_remove_all (_tmp12_);
#line 153 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 153 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = NULL;
#line 453 "gitg-lanes.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 460 "gitg-lanes.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_slist_free (self);
#line 469 "gitg-lanes.c"
}


gboolean gitg_lanes_next (GitgLanes* self, GitgCommit* next, GSList* * lanes, gint* nextpos) {
	GSList* _vala_lanes = NULL;
	gint _vala_nextpos = 0;
	gboolean result = FALSE;
	GgitOId* myoid;
	GitgCommit* _tmp0_;
	GgitOId* _tmp1_;
	gboolean _tmp2_;
	GitgLanesLaneContainer* mylane;
	GgitOId* _tmp4_;
	gint _tmp5_ = 0;
	GitgLanesLaneContainer* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GitgLanesLaneContainer* _tmp9_;
	GitgLanesLaneContainer* _tmp14_;
	gboolean hidden;
	GitgLanesLaneContainer* _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	GSList* _tmp50_;
	GitgCommit* _tmp51_;
	gint _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (next != NULL, FALSE);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp1_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->_inactive_enabled;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp2_) {
#line 512 "gitg-lanes.c"
		GitgCommit* _tmp3_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lanes (self);
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = next;
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lanes (self, _tmp3_);
#line 520 "gitg-lanes.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = myoid;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gitg_lanes_find_lane_by_oid (self, _tmp4_, &_tmp5_);
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_vala_nextpos = _tmp5_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	mylane = _tmp6_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = mylane;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp9_ == NULL) {
#line 534 "gitg-lanes.c"
		GeeHashSet* _tmp10_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = self->priv->d_roots;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = _tmp10_ != NULL;
#line 540 "gitg-lanes.c"
	} else {
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = FALSE;
#line 544 "gitg-lanes.c"
	}
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp8_) {
#line 548 "gitg-lanes.c"
		GeeHashSet* _tmp11_;
		GgitOId* _tmp12_;
		gboolean _tmp13_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = self->priv->d_roots;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = myoid;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp11_, _tmp12_);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = !_tmp13_;
#line 560 "gitg-lanes.c"
	} else {
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = FALSE;
#line 564 "gitg-lanes.c"
	}
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp7_) {
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_vala_lanes = NULL;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		result = FALSE;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (mylane);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (myoid);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (lanes) {
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			*lanes = _vala_lanes;
#line 582 "gitg-lanes.c"
		} else {
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 586 "gitg-lanes.c"
		}
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (nextpos) {
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			*nextpos = _vala_nextpos;
#line 592 "gitg-lanes.c"
		}
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 596 "gitg-lanes.c"
	}
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = mylane;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp14_ == NULL) {
#line 602 "gitg-lanes.c"
		GgitOId* _tmp15_;
		GitgLanesLaneContainer* _tmp16_;
		GeeLinkedList* _tmp17_;
		GitgLanesLaneContainer* _tmp18_;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = myoid;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = gitg_lanes_lane_container_new (_tmp15_, NULL);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (mylane);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp16_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = self->priv->d_lanes;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp18_ = mylane;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp19_ = self->priv->d_lanes;
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp21_ = _tmp20_;
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_vala_nextpos = ((gint) _tmp21_) - 1;
#line 632 "gitg-lanes.c"
	} else {
		GitgLanesLaneContainer* _tmp22_;
		GitgLane* _tmp23_;
		GitgLanesLaneContainer* _tmp24_;
		GitgLane* _tmp25_;
		GitgColor* _tmp26_;
		GitgColor* _tmp27_;
		GitgLanesLaneContainer* _tmp28_;
		GitgLanesLaneContainer* _tmp29_;
		GitgCommit* _tmp30_;
		GgitOId* _tmp31_;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		GitgLanesLaneContainer* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp36_;
		GitgLanesLaneContainer* _tmp44_;
		gint _tmp45_;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp22_ = mylane;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp23_ = _tmp22_->lane;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp24_ = mylane;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp25_ = _tmp24_->lane;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp26_ = _tmp25_->color;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp27_ = gitg_color_copy (_tmp26_);
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_tmp23_->color);
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp23_->color = _tmp27_;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp28_ = mylane;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp28_->to);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp28_->to = NULL;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp29_ = mylane;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp30_ = next;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = ggit_object_get_id ((GgitObject*) _tmp30_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp29_->from);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp29_->from = _tmp31_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = mylane;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = gitg_lanes_lane_container_get_is_hidden (_tmp34_);
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = _tmp35_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp36_) {
#line 691 "gitg-lanes.c"
			GeeHashSet* _tmp37_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp37_ = self->priv->d_roots;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp33_ = _tmp37_ != NULL;
#line 697 "gitg-lanes.c"
		} else {
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp33_ = FALSE;
#line 701 "gitg-lanes.c"
		}
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp33_) {
#line 705 "gitg-lanes.c"
			GeeHashSet* _tmp38_;
			GgitOId* _tmp39_;
			gboolean _tmp40_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp38_ = self->priv->d_roots;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = myoid;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp40_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp38_, _tmp39_);
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp32_ = _tmp40_;
#line 717 "gitg-lanes.c"
		} else {
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp32_ = FALSE;
#line 721 "gitg-lanes.c"
		}
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp32_) {
#line 725 "gitg-lanes.c"
			GitgLanesLaneContainer* _tmp41_;
			GitgLanesLaneContainer* _tmp42_;
			GitgLane* _tmp43_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = mylane;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_lane_container_set_is_hidden (_tmp41_, FALSE);
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp42_ = mylane;
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp43_ = _tmp42_->lane;
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_g_slist_free0 (_tmp43_->from);
#line 195 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp43_->from = NULL;
#line 741 "gitg-lanes.c"
		}
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp44_ = mylane;
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp45_ = _tmp44_->inactive;
#line 198 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp45_ >= 0) {
#line 749 "gitg-lanes.c"
			GitgLanesLaneContainer* _tmp46_;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = mylane;
#line 200 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp46_->inactive = 0;
#line 755 "gitg-lanes.c"
		}
	}
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp47_ = mylane;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp48_ = gitg_lanes_lane_container_get_is_hidden (_tmp47_);
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp49_ = _tmp48_;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	hidden = _tmp49_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp50_ = gitg_lanes_lanes_list (self);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_vala_lanes = _tmp50_;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp51_ = next;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp52_ = _vala_nextpos;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp53_ = hidden;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_prepare_lanes (self, _tmp51_, _tmp52_, _tmp53_);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp54_ = hidden;
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = !_tmp54_;
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (lanes) {
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*lanes = _vala_lanes;
#line 792 "gitg-lanes.c"
	} else {
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 796 "gitg-lanes.c"
	}
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (nextpos) {
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*nextpos = _vala_nextpos;
#line 802 "gitg-lanes.c"
	}
#line 209 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 806 "gitg-lanes.c"
}


static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos, gboolean hidden) {
	GgitCommitParents* parents;
	GitgCommit* _tmp0_;
	GgitCommitParents* _tmp1_;
	GgitOId* myoid;
	GitgCommit* _tmp2_;
	GgitOId* _tmp3_;
	gboolean _tmp4_;
	GitgLanesLaneContainer* mylane;
	GeeLinkedList* _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	gboolean _tmp89_ = FALSE;
	GitgLanesLaneContainer* _tmp90_;
	GSList* _tmp95_;
	guint _tmp96_;
	gint _tmp97_;
	gint _tmp98_;
	GitgCommit* _tmp101_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (next != NULL);
#line 214 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 214 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_commit_get_parents ((GgitCommit*) _tmp0_);
#line 214 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp1_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = next;
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp3_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = hidden;
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (!_tmp4_) {
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_init_next_layer (self);
#line 851 "gitg-lanes.c"
	}
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->priv->d_lanes;
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = pos;
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp6_);
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	mylane = (GitgLanesLaneContainer*) _tmp7_;
#line 861 "gitg-lanes.c"
	{
		guint i;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 866 "gitg-lanes.c"
		{
			gboolean _tmp8_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = TRUE;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 873 "gitg-lanes.c"
				guint _tmp10_;
				GgitCommitParents* _tmp11_;
				guint _tmp12_;
				guint _tmp13_;
				gint lnpos = 0;
				GgitOId* poid;
				GgitCommitParents* _tmp14_;
				guint _tmp15_;
				GgitOId* _tmp16_;
				GitgLanesLaneContainer* container;
				GgitOId* _tmp17_;
				gint _tmp18_ = 0;
				GitgLanesLaneContainer* _tmp19_;
				GitgLanesLaneContainer* _tmp20_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp8_) {
#line 890 "gitg-lanes.c"
					guint _tmp9_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp9_ = i;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					i = _tmp9_ + 1;
#line 896 "gitg-lanes.c"
				}
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = FALSE;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = i;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = parents;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = ggit_commit_parents_get_size (_tmp11_);
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = _tmp12_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp10_ < _tmp13_)) {
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					break;
#line 912 "gitg-lanes.c"
				}
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = parents;
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = i;
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = ggit_commit_parents_get_id (_tmp14_, _tmp15_);
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				poid = _tmp16_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = poid;
#line 229 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp19_ = gitg_lanes_find_lane_by_oid (self, _tmp17_, &_tmp18_);
#line 229 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				lnpos = _tmp18_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				container = _tmp19_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp20_ = container;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (_tmp20_ != NULL) {
#line 934 "gitg-lanes.c"
					gboolean _tmp21_ = FALSE;
					guint _tmp22_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp22_ = i;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					if (_tmp22_ == ((guint) 0)) {
#line 941 "gitg-lanes.c"
						gint _tmp23_;
						gint _tmp24_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp23_ = pos;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp24_ = lnpos;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp21_ = _tmp23_ < _tmp24_;
#line 950 "gitg-lanes.c"
					} else {
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp21_ = FALSE;
#line 954 "gitg-lanes.c"
					}
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					if (_tmp21_) {
#line 958 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp25_;
						GgitOId* _tmp26_;
						GgitOId* _tmp27_;
						GitgLanesLaneContainer* _tmp28_;
						GgitOId* _tmp29_;
						GgitOId* _tmp30_;
						GitgLanesLaneContainer* _tmp31_;
						gboolean _tmp32_;
						gboolean _tmp33_;
						GitgLanesLaneContainer* _tmp38_;
						GitgLane* _tmp39_;
						GitgLanesLaneContainer* _tmp40_;
						GitgLane* _tmp41_;
						GitgColor* _tmp42_;
						GitgColor* _tmp43_;
						GitgLanesLaneContainer* _tmp44_;
						gint _tmp45_;
						GeeLinkedList* _tmp47_;
						GitgLanesLaneContainer* _tmp48_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp25_ = mylane;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp26_ = poid;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp27_ = __vala_GgitOId_copy0 (_tmp26_);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp25_->to);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp25_->to = _tmp27_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp28_ = mylane;
#line 242 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp29_ = myoid;
#line 242 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp30_ = __vala_GgitOId_copy0 (_tmp29_);
#line 242 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp28_->from);
#line 242 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp28_->from = _tmp30_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp31_ = container;
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp32_ = gitg_lanes_lane_container_get_is_hidden (_tmp31_);
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp33_ = _tmp32_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp33_) {
#line 1006 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp34_;
							GitgLane* _tmp35_;
							gint _tmp36_;
							GitgLanesLaneContainer* _tmp37_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp34_ = mylane;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp35_ = _tmp34_->lane;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp36_ = lnpos;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp35_->from = g_slist_append (_tmp35_->from, (gpointer) ((gintptr) _tmp36_));
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp37_ = mylane;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							gitg_lanes_lane_container_set_is_hidden (_tmp37_, FALSE);
#line 1023 "gitg-lanes.c"
						}
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp38_ = mylane;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp39_ = _tmp38_->lane;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp40_ = mylane;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp41_ = _tmp40_->lane;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp42_ = _tmp41_->color;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp43_ = gitg_color_copy (_tmp42_);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp39_->color);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp39_->color = _tmp43_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp44_ = mylane;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp45_ = _tmp44_->inactive;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (_tmp45_ >= 0) {
#line 1047 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp46_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp46_ = mylane;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp46_->inactive = 0;
#line 1053 "gitg-lanes.c"
						}
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp47_ = self->priv->d_lanes;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp48_ = container;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp47_, _tmp48_);
#line 1061 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* _tmp49_;
						GgitOId* _tmp50_;
						GgitOId* _tmp51_;
						gboolean _tmp52_;
						GitgLanesLaneContainer* _tmp56_;
						GitgLane* _tmp57_;
						GitgLanesLaneContainer* _tmp58_;
						GitgLane* _tmp59_;
						GitgColor* _tmp60_;
						GitgColor* _tmp61_;
						gboolean _tmp62_;
						GitgLanesLaneContainer* _tmp64_;
						gint _tmp65_;
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp49_ = container;
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp50_ = myoid;
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp51_ = __vala_GgitOId_copy0 (_tmp50_);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp49_->from);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp49_->from = _tmp51_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp52_ = hidden;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp52_) {
#line 1090 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp53_;
							GitgLane* _tmp54_;
							gint _tmp55_;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp53_ = container;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp54_ = _tmp53_->lane;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp55_ = pos;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp54_->from = g_slist_append (_tmp54_->from, (gpointer) ((gintptr) _tmp55_));
#line 1102 "gitg-lanes.c"
						}
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp56_ = container;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp57_ = _tmp56_->lane;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp58_ = container;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp59_ = _tmp58_->lane;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp60_ = _tmp59_->color;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp61_ = gitg_color_copy (_tmp60_);
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp57_->color);
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp57_->color = _tmp61_;
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp62_ = hidden;
#line 270 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp62_) {
#line 1124 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp63_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp63_ = container;
#line 272 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							gitg_lanes_lane_container_set_is_hidden (_tmp63_, FALSE);
#line 1130 "gitg-lanes.c"
						}
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp64_ = container;
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp65_ = _tmp64_->inactive;
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (_tmp65_ >= 0) {
#line 1138 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp66_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp66_ = container;
#line 277 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp66_->inactive = 0;
#line 1144 "gitg-lanes.c"
						}
					}
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_gitg_lanes_lane_container_unref0 (container);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (poid);
#line 281 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					continue;
#line 1153 "gitg-lanes.c"
				} else {
					gboolean _tmp67_ = FALSE;
					GitgLanesLaneContainer* _tmp68_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp68_ = mylane;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					if (_tmp68_ != NULL) {
#line 1161 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp69_;
						GgitOId* _tmp70_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp69_ = mylane;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp70_ = _tmp69_->to;
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp67_ = _tmp70_ == NULL;
#line 1170 "gitg-lanes.c"
					} else {
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp67_ = FALSE;
#line 1174 "gitg-lanes.c"
					}
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					if (_tmp67_) {
#line 1178 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp71_;
						GgitOId* _tmp72_;
						GgitOId* _tmp73_;
						GitgLanesLaneContainer* _tmp74_;
						GitgLane* _tmp75_;
						GitgLanesLaneContainer* _tmp76_;
						GitgLane* _tmp77_;
						GitgColor* _tmp78_;
						GitgColor* _tmp79_;
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp71_ = mylane;
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp72_ = poid;
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp73_ = __vala_GgitOId_copy0 (_tmp72_);
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp71_->to);
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp71_->to = _tmp73_;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp74_ = mylane;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp75_ = _tmp74_->lane;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp76_ = mylane;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp77_ = _tmp76_->lane;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp78_ = _tmp77_->color;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp79_ = gitg_color_copy (_tmp78_);
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp75_->color);
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp75_->color = _tmp79_;
#line 1214 "gitg-lanes.c"
					} else {
						gboolean _tmp80_;
#line 291 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						_tmp80_ = hidden;
#line 291 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp80_) {
#line 1221 "gitg-lanes.c"
							GitgLanesLaneContainer* newlane;
							GgitOId* _tmp81_;
							GgitOId* _tmp82_;
							GitgLanesLaneContainer* _tmp83_;
							GitgLanesLaneContainer* _tmp84_;
							GitgLane* _tmp85_;
							gint _tmp86_;
							GeeLinkedList* _tmp87_;
							GitgLanesLaneContainer* _tmp88_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp81_ = myoid;
#line 294 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp82_ = poid;
#line 294 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp83_ = gitg_lanes_lane_container_new (_tmp81_, _tmp82_);
#line 294 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							newlane = _tmp83_;
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp84_ = newlane;
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp85_ = _tmp84_->lane;
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp86_ = pos;
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp85_->from = g_slist_prepend (_tmp85_->from, (gpointer) ((gintptr) _tmp86_));
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp87_ = self->priv->d_lanes;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_tmp88_ = newlane;
#line 297 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp87_, _tmp88_);
#line 291 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
							_gitg_lanes_lane_container_unref0 (newlane);
#line 1255 "gitg-lanes.c"
						}
					}
				}
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_gitg_lanes_lane_container_unref0 (container);
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (poid);
#line 1263 "gitg-lanes.c"
			}
		}
	}
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp90_ = mylane;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp90_ != NULL) {
#line 1271 "gitg-lanes.c"
		GitgLanesLaneContainer* _tmp91_;
		GgitOId* _tmp92_;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp91_ = mylane;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp92_ = _tmp91_->to;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp89_ = _tmp92_ == NULL;
#line 1280 "gitg-lanes.c"
	} else {
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp89_ = FALSE;
#line 1284 "gitg-lanes.c"
	}
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp89_) {
#line 1288 "gitg-lanes.c"
		GeeLinkedList* _tmp93_;
		GitgLanesLaneContainer* _tmp94_;
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp93_ = self->priv->d_lanes;
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp94_ = mylane;
#line 304 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp93_, _tmp94_);
#line 1297 "gitg-lanes.c"
	}
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp95_ = self->priv->d_previous;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp96_ = g_slist_length (_tmp95_);
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp97_ = self->priv->_inactive_collapse;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp98_ = self->priv->_inactive_gap;
#line 308 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp96_ == ((guint) ((_tmp97_ + _tmp98_) + 1))) {
#line 1309 "gitg-lanes.c"
		GSList* _tmp99_;
		GSList* _tmp100_;
#line 310 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp99_ = self->priv->d_previous;
#line 310 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp100_ = g_slist_last (_tmp99_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_previous = g_slist_delete_link (self->priv->d_previous, _tmp100_);
#line 1318 "gitg-lanes.c"
	}
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp101_ = next;
#line 313 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = g_slist_prepend (self->priv->d_previous, _tmp101_);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (parents);
#line 1330 "gitg-lanes.c"
}


static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesCollapsedLane* collapsed;
	GitgLanesLaneContainer* _tmp0_;
	GitgLanesCollapsedLane* _tmp1_;
	GitgLanesCollapsedLane* _tmp2_;
	gint _tmp3_;
	GHashTable* _tmp4_;
	GitgLanesLaneContainer* _tmp5_;
	GgitOId* _tmp6_;
	GgitOId* _tmp7_;
	GitgLanesCollapsedLane* _tmp8_;
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 319 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 319 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lanes_collapsed_lane_new (_tmp0_);
#line 319 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	collapsed = _tmp1_;
#line 320 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = collapsed;
#line 320 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 320 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->index = (guint) _tmp3_;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_collapsed;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = container;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = _tmp5_->to;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = __vala_GgitOId_copy0 (_tmp6_);
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = collapsed;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	collapsed = NULL;
#line 322 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
#line 316 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_collapsed_lane_free0 (collapsed);
#line 1377 "gitg-lanes.c"
}


static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesLaneContainer* _tmp0_;
	gint _tmp1_;
	GSList* item;
	GSList* _tmp2_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = index;
#line 328 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_add_collapsed (self, _tmp0_, _tmp1_);
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->d_previous;
#line 330 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	item = _tmp2_;
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1402 "gitg-lanes.c"
		GSList* _tmp3_;
		GitgCommit* commit;
		GSList* _tmp4_;
		gconstpointer _tmp5_;
		GitgCommit* _tmp6_;
		GSList* lns;
		GitgCommit* _tmp7_;
		GSList* _tmp8_;
		GSList* _tmp9_;
		GSList* _tmp43_;
		GSList* _tmp44_;
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = item;
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp3_ != NULL)) {
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1420 "gitg-lanes.c"
		}
#line 334 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = item;
#line 334 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = _tmp4_->data;
#line 334 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _g_object_ref0 ((GitgCommit*) _tmp5_);
#line 334 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp6_;
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = commit;
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = gitg_commit_get_lanes (_tmp7_);
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp8_;
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = lns;
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp9_ != NULL) {
#line 1440 "gitg-lanes.c"
			GitgLane* lane;
			GSList* _tmp10_;
			gint _tmp11_;
			gconstpointer _tmp12_;
			GSList* _tmp13_;
			GSList* _tmp14_;
#line 339 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = lns;
#line 339 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = index;
#line 339 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = g_slist_nth_data (_tmp10_, (guint) _tmp11_);
#line 339 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			lane = (GitgLane*) _tmp12_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = item;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = _tmp13_->next;
#line 341 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (_tmp14_ != NULL) {
#line 1461 "gitg-lanes.c"
				gint newindex;
				GitgLane* _tmp15_;
				GSList* _tmp16_;
				gconstpointer _tmp17_;
				GitgCommit* _tmp18_;
				GitgLane* _tmp19_;
				GSList* _tmp20_;
				GSList* _tmp21_;
				GSList* _tmp22_;
				GSList* _tmp23_;
				guint mylane;
				GitgCommit* _tmp26_;
				guint _tmp27_;
				guint _tmp28_;
				guint _tmp29_;
				gint _tmp30_;
				gint _tmp35_;
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = lane;
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = _tmp15_->from;
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = _tmp16_->data;
#line 343 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				newindex = (gint) ((gintptr) _tmp17_);
#line 345 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp18_ = commit;
#line 345 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp19_ = lane;
#line 345 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp20_ = gitg_commit_remove_lane (_tmp18_, _tmp19_);
#line 345 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				lns = _tmp20_;
#line 347 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp21_ = item;
#line 347 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp22_ = _tmp21_->next;
#line 347 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp23_ = _tmp22_->next;
#line 347 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (_tmp23_ != NULL) {
#line 1503 "gitg-lanes.c"
					GSList* _tmp24_;
					gint _tmp25_;
#line 349 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp24_ = lns;
#line 349 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp25_ = newindex;
#line 349 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					gitg_lanes_update_merge_indices (self, _tmp24_, _tmp25_, -1);
#line 1512 "gitg-lanes.c"
				}
#line 352 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp26_ = commit;
#line 352 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp27_ = gitg_commit_get_mylane (_tmp26_);
#line 352 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp28_ = _tmp27_;
#line 352 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				mylane = _tmp28_;
#line 354 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp29_ = mylane;
#line 354 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp30_ = index;
#line 354 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (_tmp29_ > ((guint) _tmp30_)) {
#line 1528 "gitg-lanes.c"
					GitgCommit* _tmp31_;
					GitgCommit* _tmp32_;
					guint _tmp33_;
					guint _tmp34_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp31_ = commit;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp32_ = commit;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp33_ = gitg_commit_get_mylane (_tmp32_);
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp34_ = _tmp33_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					gitg_commit_set_mylane (_tmp32_, _tmp34_ - 1);
#line 1543 "gitg-lanes.c"
				}
#line 359 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp35_ = newindex;
#line 359 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				index = _tmp35_;
#line 1549 "gitg-lanes.c"
			} else {
				GitgLane* _tmp36_;
				GitgLane* _tmp37_;
				GitgLaneTag _tmp38_;
				GitgLane* _tmp39_;
				GitgLanesLaneContainer* _tmp40_;
				GgitOId* _tmp41_;
				GgitOId* _tmp42_;
#line 363 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp36_ = lane;
#line 363 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp37_ = lane;
#line 363 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp38_ = _tmp37_->tag;
#line 363 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp37_->tag = _tmp38_ | GITG_LANE_TAG_END;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp39_ = lane;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp40_ = container;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp41_ = _tmp40_->to;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp42_ = __vala_GgitOId_copy0 (_tmp41_);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (_tmp39_->boundary_id);
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp39_->boundary_id = _tmp42_;
#line 1578 "gitg-lanes.c"
			}
		}
#line 368 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = item;
#line 368 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp44_ = _tmp43_->next;
#line 368 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		item = _tmp44_;
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1589 "gitg-lanes.c"
	}
}


static void gitg_lanes_collapse_lanes (GitgLanes* self) {
	gint index;
	GeeIterator* iter;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
#line 372 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 376 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 376 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 376 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	iter = _tmp1_;
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1611 "gitg-lanes.c"
		GeeIterator* _tmp2_;
		gboolean _tmp3_;
		GitgLanesLaneContainer* container;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		GitgLanesLaneContainer* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GitgLanesLaneContainer* _tmp11_;
		GitgLanesLaneContainer* _tmp12_;
		GitgLane* _tmp13_;
		GSList* _tmp14_;
		gconstpointer _tmp15_;
		gint _tmp16_;
		GeeIterator* _tmp17_;
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = iter;
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (!_tmp3_) {
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1636 "gitg-lanes.c"
		}
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = iter;
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 380 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		container = (GitgLanesLaneContainer*) _tmp5_;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = container;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = _tmp6_->inactive;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = self->priv->_inactive_max;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = self->priv->_inactive_gap;
#line 382 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp7_ != (_tmp8_ + _tmp9_)) {
#line 1654 "gitg-lanes.c"
			gint _tmp10_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = index;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			index = _tmp10_ + 1;
#line 385 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 385 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			continue;
#line 1664 "gitg-lanes.c"
		}
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = container;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = container;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->lane;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->from;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->data;
#line 388 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lane (self, _tmp11_, (gint) ((gintptr) _tmp15_));
#line 389 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = index;
#line 389 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_update_current_lane_merge_indices (self, _tmp16_, -1);
#line 391 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = iter;
#line 391 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gee_iterator_remove (_tmp17_);
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (container);
#line 1688 "gitg-lanes.c"
	}
#line 372 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (iter);
#line 1692 "gitg-lanes.c"
}


static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index) {
	gint result = 0;
	guint len;
	GitgCommit* _tmp0_;
	GSList* _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (commit != NULL, 0);
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_slist_length (_tmp1_);
#line 398 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	len = _tmp2_;
#line 400 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 400 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = len;
#line 400 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (((guint) _tmp3_) > _tmp4_) {
#line 1722 "gitg-lanes.c"
		guint _tmp5_;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = len;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		result = (gint) _tmp5_;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1730 "gitg-lanes.c"
	} else {
		gint _tmp6_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = index;
#line 406 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		result = _tmp6_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1739 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction) {
#line 410 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1749 "gitg-lanes.c"
		GSList* _tmp0_;
		gint idx;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		gint _tmp5_;
		GSList* _tmp13_;
		GSList* _tmp14_;
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = from;
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp0_ != NULL)) {
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1765 "gitg-lanes.c"
		}
#line 416 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = from;
#line 416 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _tmp1_->data;
#line 416 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		idx = (gint) ((gintptr) _tmp2_);
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = idx;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = index;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp4_ > _tmp5_) {
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = TRUE;
#line 1781 "gitg-lanes.c"
		} else {
			gboolean _tmp6_ = FALSE;
			gint _tmp7_;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = direction;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (_tmp7_ > 0) {
#line 1789 "gitg-lanes.c"
				gint _tmp8_;
				gint _tmp9_;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = idx;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = index;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = _tmp8_ == _tmp9_;
#line 1798 "gitg-lanes.c"
			} else {
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = FALSE;
#line 1802 "gitg-lanes.c"
			}
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = _tmp6_;
#line 1806 "gitg-lanes.c"
		}
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp3_) {
#line 1810 "gitg-lanes.c"
			GSList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = from;
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = idx;
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = direction;
#line 420 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_->data = (gpointer) ((gintptr) (_tmp11_ + _tmp12_));
#line 1822 "gitg-lanes.c"
		}
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = from;
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->next;
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		from = _tmp14_;
#line 1830 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction) {
	GSList* _tmp0_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lanes;
#line 1841 "gitg-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		lane_collection = _tmp0_;
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 1849 "gitg-lanes.c"
			GitgLane* lane = NULL;
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			lane = (GitgLane*) lane_it->data;
#line 1853 "gitg-lanes.c"
			{
				GitgLane* _tmp1_;
				GSList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = lane;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->from;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = index;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp4_ = direction;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_lane_merge_indices (self, _tmp2_, _tmp3_, _tmp4_);
#line 1869 "gitg-lanes.c"
			}
		}
	}
}


static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction) {
#line 436 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 1879 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _container_size;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_index;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 1907 "gitg-lanes.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GitgLanesLaneContainer* container;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GitgLanesLaneContainer* _tmp11_;
			GitgLane* _tmp12_;
			GSList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				break;
#line 1932 "gitg-lanes.c"
			}
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = _tmp12_->from;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = index;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = direction;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_lane_merge_indices (self, _tmp13_, _tmp14_, _tmp15_);
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 1956 "gitg-lanes.c"
		}
#line 439 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 1960 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane) {
	guint index;
	GitgLanesCollapsedLane* _tmp0_;
	guint _tmp1_;
	GitgLane* ln;
	GitgLanesCollapsedLane* _tmp2_;
	GitgColor* _tmp3_;
	GitgLane* _tmp4_;
	gint len;
	GeeLinkedList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint _tmp8_;
	gint _tmp9_;
	gint next;
	GSList* _tmp11_;
	gconstpointer _tmp12_;
	guint _tmp13_;
	gint _tmp14_;
	GitgLanesLaneContainer* container;
	GitgLanesCollapsedLane* _tmp15_;
	GgitOId* _tmp16_;
	GitgLanesCollapsedLane* _tmp17_;
	GgitOId* _tmp18_;
	GitgLanesCollapsedLane* _tmp19_;
	GitgColor* _tmp20_;
	GitgLanesLaneContainer* _tmp21_;
	guint _tmp22_;
	GitgLanesLaneContainer* _tmp23_;
	GitgLane* _tmp24_;
	gint _tmp25_;
	GeeLinkedList* _tmp26_;
	guint _tmp27_;
	GitgLanesLaneContainer* _tmp28_;
	gint _tmp29_;
	guint cnt;
	GSList* ptr;
	GSList* _tmp30_;
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (lane != NULL);
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lane;
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->index;
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	index = _tmp1_;
#line 450 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = lane;
#line 450 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _tmp2_->color;
#line 450 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = gitg_lane_new_with_color (_tmp3_);
#line 450 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	ln = _tmp4_;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->priv->d_lanes;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = _tmp6_;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	len = _tmp7_;
#line 453 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = index;
#line 453 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = len;
#line 453 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp8_ > ((guint) _tmp9_)) {
#line 2035 "gitg-lanes.c"
		gint _tmp10_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = len;
#line 455 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp10_;
#line 2041 "gitg-lanes.c"
	}
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = self->priv->d_previous;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = _tmp11_->data;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp13_ = index;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp12_, (gint) _tmp13_);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	next = _tmp14_;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp15_ = lane;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp16_ = _tmp15_->from;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp17_ = lane;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp18_ = _tmp17_->to;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp19_ = lane;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp20_ = _tmp19_->color;
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp21_ = gitg_lanes_lane_container_new_with_color (_tmp16_, _tmp18_, _tmp20_);
#line 460 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	container = _tmp21_;
#line 464 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp22_ = index;
#line 464 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_update_current_lane_merge_indices (self, (gint) _tmp22_, 1);
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp23_ = container;
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp24_ = _tmp23_->lane;
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp25_ = next;
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp24_->from = g_slist_prepend (_tmp24_->from, (gpointer) ((gintptr) _tmp25_));
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp26_ = self->priv->d_lanes;
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp27_ = index;
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp28_ = container;
#line 467 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gee_abstract_list_insert ((GeeAbstractList*) _tmp26_, (gint) _tmp27_, _tmp28_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp29_ = next;
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	index = (guint) _tmp29_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	cnt = (guint) 0;
#line 472 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp30_ = self->priv->d_previous;
#line 472 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	ptr = _tmp30_;
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 2101 "gitg-lanes.c"
		GSList* _tmp31_;
		GitgCommit* commit;
		GSList* _tmp32_;
		gconstpointer _tmp33_;
		GitgCommit* _tmp34_;
		guint _tmp35_;
		gint _tmp36_;
		GitgLane* copy;
		GitgLane* _tmp37_;
		GitgLane* _tmp38_;
		GSList* lns;
		GitgCommit* _tmp39_;
		GSList* _tmp40_;
		gboolean _tmp41_ = FALSE;
		GSList* _tmp42_;
		GSList* _tmp43_;
		GitgCommit* _tmp62_;
		GitgLane* _tmp63_;
		guint _tmp64_;
		guint mylane;
		GitgCommit* _tmp65_;
		guint _tmp66_;
		guint _tmp67_;
		guint _tmp68_;
		guint _tmp69_;
		gint _tmp74_;
		guint _tmp75_;
		GSList* _tmp76_;
		GSList* _tmp77_;
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = ptr;
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp31_ != NULL)) {
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			break;
#line 2137 "gitg-lanes.c"
		}
#line 476 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp32_ = ptr;
#line 476 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp33_ = _tmp32_->data;
#line 476 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = _g_object_ref0 ((GitgCommit*) _tmp33_);
#line 476 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp34_;
#line 478 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = cnt;
#line 478 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = self->priv->_inactive_collapse;
#line 478 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp35_ == ((guint) _tmp36_)) {
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_g_object_unref0 (commit);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			break;
#line 2157 "gitg-lanes.c"
		}
#line 484 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp37_ = ln;
#line 484 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp38_ = gitg_lane_copy (_tmp37_);
#line 484 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		copy = _tmp38_;
#line 485 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp39_ = commit;
#line 485 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp40_ = gitg_commit_get_lanes (_tmp39_);
#line 485 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp40_;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = ptr;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp43_ == NULL) {
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = TRUE;
#line 2179 "gitg-lanes.c"
		} else {
			guint _tmp44_;
			gint _tmp45_;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp44_ = cnt;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp45_ = self->priv->_inactive_collapse;
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = (_tmp44_ + 1) == ((guint) _tmp45_);
#line 2189 "gitg-lanes.c"
		}
#line 487 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp41_) {
#line 2193 "gitg-lanes.c"
			GitgLane* _tmp46_;
			GitgLanesCollapsedLane* _tmp47_;
			GgitOId* _tmp48_;
			GgitOId* _tmp49_;
			GitgLane* _tmp50_;
			GitgLane* _tmp51_;
			GitgLaneTag _tmp52_;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = copy;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp47_ = lane;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp48_ = _tmp47_->from;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp49_ = __vala_GgitOId_copy0 (_tmp48_);
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp46_->boundary_id);
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp46_->boundary_id = _tmp49_;
#line 490 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp50_ = copy;
#line 490 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp51_ = copy;
#line 490 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp52_ = _tmp51_->tag;
#line 490 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp51_->tag = _tmp52_ | GITG_LANE_TAG_START;
#line 2221 "gitg-lanes.c"
		} else {
			GSList* _tmp53_;
			GSList* _tmp54_;
			gconstpointer _tmp55_;
			guint _tmp56_;
			gint _tmp57_;
			GitgLane* _tmp58_;
			gint _tmp59_;
			GSList* _tmp60_;
			guint _tmp61_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp53_ = ptr;
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp54_ = _tmp53_->next;
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp55_ = _tmp54_->data;
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp56_ = index;
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp57_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp55_, (gint) _tmp56_);
#line 494 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			next = _tmp57_;
#line 495 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp58_ = copy;
#line 495 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp59_ = next;
#line 495 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp58_->from = g_slist_prepend (_tmp58_->from, (gpointer) ((gintptr) _tmp59_));
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp60_ = lns;
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp61_ = index;
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_merge_indices (self, _tmp60_, (gint) _tmp61_, 1);
#line 2256 "gitg-lanes.c"
		}
#line 500 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp62_ = commit;
#line 500 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp63_ = copy;
#line 500 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp64_ = index;
#line 500 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_commit_insert_lane (_tmp62_, _tmp63_, (gint) _tmp64_);
#line 502 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp65_ = commit;
#line 502 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp66_ = gitg_commit_get_mylane (_tmp65_);
#line 502 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp67_ = _tmp66_;
#line 502 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp67_;
#line 504 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp68_ = mylane;
#line 504 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp69_ = index;
#line 504 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (_tmp68_ >= _tmp69_) {
#line 2280 "gitg-lanes.c"
			GitgCommit* _tmp70_;
			GitgCommit* _tmp71_;
			guint _tmp72_;
			guint _tmp73_;
#line 506 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp70_ = commit;
#line 506 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp71_ = commit;
#line 506 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp72_ = gitg_commit_get_mylane (_tmp71_);
#line 506 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp73_ = _tmp72_;
#line 506 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			gitg_commit_set_mylane (_tmp71_, _tmp73_ + 1);
#line 2295 "gitg-lanes.c"
		}
#line 509 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp74_ = next;
#line 509 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp74_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = cnt;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		cnt = _tmp75_ + 1;
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = ptr;
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp77_ = _tmp76_->next;
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		ptr = _tmp77_;
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (copy);
#line 474 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 2315 "gitg-lanes.c"
	}
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (container);
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (ln);
#line 2321 "gitg-lanes.c"
}


static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id) {
	GitgLanesCollapsedLane* collapsed;
	GHashTable* _tmp0_;
	GgitOId* _tmp1_;
	gconstpointer _tmp2_;
	GitgLanesCollapsedLane* _tmp3_;
#line 516 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 516 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (id != NULL);
#line 518 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_collapsed;
#line 518 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = id;
#line 518 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 518 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	collapsed = (GitgLanesCollapsedLane*) _tmp2_;
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = collapsed;
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 2347 "gitg-lanes.c"
		GitgLanesCollapsedLane* _tmp4_;
		GHashTable* _tmp5_;
		GgitOId* _tmp6_;
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = collapsed;
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lane (self, _tmp4_);
#line 523 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->priv->d_collapsed;
#line 523 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = id;
#line 523 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_hash_table_remove (_tmp5_, _tmp6_);
#line 2361 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit) {
	GitgCommit* _tmp0_;
	GgitOId* _tmp1_;
	GgitOId* _tmp2_;
	GgitCommitParents* parents;
	GitgCommit* _tmp3_;
	GgitCommitParents* _tmp4_;
#line 527 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 527 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (commit != NULL);
#line 529 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 529 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 529 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_;
#line 529 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_expand_lane_from_oid (self, _tmp2_);
#line 529 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 531 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = commit;
#line 531 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = ggit_commit_get_parents ((GgitCommit*) _tmp3_);
#line 531 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp4_;
#line 2393 "gitg-lanes.c"
	{
		guint i;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 2398 "gitg-lanes.c"
		{
			gboolean _tmp5_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = TRUE;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 2405 "gitg-lanes.c"
				guint _tmp7_;
				GgitCommitParents* _tmp8_;
				guint _tmp9_;
				guint _tmp10_;
				GgitCommitParents* _tmp11_;
				guint _tmp12_;
				GgitOId* _tmp13_;
				GgitOId* _tmp14_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp5_) {
#line 2416 "gitg-lanes.c"
					guint _tmp6_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					_tmp6_ = i;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					i = _tmp6_ + 1;
#line 2422 "gitg-lanes.c"
				}
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = FALSE;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = i;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = parents;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = ggit_commit_parents_get_size (_tmp8_);
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = _tmp9_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp7_ < _tmp10_)) {
#line 533 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					break;
#line 2438 "gitg-lanes.c"
				}
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = parents;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = i;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = ggit_commit_parents_get_id (_tmp11_, _tmp12_);
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = _tmp13_;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_expand_lane_from_oid (self, _tmp14_);
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (_tmp14_);
#line 2452 "gitg-lanes.c"
			}
		}
	}
#line 527 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (parents);
#line 2458 "gitg-lanes.c"
}


static void gitg_lanes_init_next_layer (GitgLanes* self) {
	gint index;
#line 539 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 541 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 2468 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _container_size;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_index;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2496 "gitg-lanes.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GitgLanesLaneContainer* container;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GitgLanesLaneContainer* _tmp11_;
			gint _tmp12_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2518 "gitg-lanes.c"
			}
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = index;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			index = _tmp12_ + 1;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_lane_container_next (_tmp11_, _tmp12_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2538 "gitg-lanes.c"
		}
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2542 "gitg-lanes.c"
	}
}


static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos) {
	gint _vala_pos = 0;
	GitgLanesLaneContainer* result = NULL;
	gint p;
#line 549 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 549 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 552 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	p = 0;
#line 2557 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _container_size;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_index;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2585 "gitg-lanes.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GitgLanesLaneContainer* container;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			GitgLanesLaneContainer* _tmp12_;
			gint _tmp18_;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2608 "gitg-lanes.c"
			}
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 556 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = container;
#line 556 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (_tmp12_ != NULL) {
#line 2622 "gitg-lanes.c"
				GgitOId* _tmp13_;
				GitgLanesLaneContainer* _tmp14_;
				GgitOId* _tmp15_;
				gboolean _tmp16_;
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = id;
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = container;
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = _tmp14_->to;
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = ggit_oid_equal (_tmp13_, _tmp15_);
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = _tmp16_;
#line 2637 "gitg-lanes.c"
			} else {
#line 556 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = FALSE;
#line 2641 "gitg-lanes.c"
			}
#line 556 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (_tmp11_) {
#line 2645 "gitg-lanes.c"
				gint _tmp17_;
#line 559 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = p;
#line 559 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_vala_pos = _tmp17_;
#line 560 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				result = container;
#line 560 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				_g_object_unref0 (_container_list);
#line 560 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				if (pos) {
#line 560 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
					*pos = _vala_pos;
#line 2659 "gitg-lanes.c"
				}
#line 560 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				return result;
#line 2663 "gitg-lanes.c"
			}
#line 563 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = p;
#line 563 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			p = _tmp18_ + 1;
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2671 "gitg-lanes.c"
		}
#line 554 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2675 "gitg-lanes.c"
	}
#line 566 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_vala_pos = -1;
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = NULL;
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (pos) {
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*pos = _vala_pos;
#line 2685 "gitg-lanes.c"
	}
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2689 "gitg-lanes.c"
}


static GSList* gitg_lanes_lanes_list (GitgLanes* self) {
	GSList* result = NULL;
	GSList* ret;
#line 570 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 572 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	ret = NULL;
#line 2700 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _container_size;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_index;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2728 "gitg-lanes.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GitgLanesLaneContainer* container;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GitgLanesLaneContainer* _tmp11_;
			GitgLane* _tmp12_;
			GitgLane* _tmp13_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2751 "gitg-lanes.c"
			}
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 576 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 576 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 576 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = gitg_lane_copy (_tmp12_);
#line 576 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			ret = g_slist_prepend (ret, _tmp13_);
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2771 "gitg-lanes.c"
		}
#line 574 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2775 "gitg-lanes.c"
	}
#line 579 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	ret = g_slist_reverse (ret);
#line 580 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = ret;
#line 580 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2783 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_max (GitgLanes* self) {
	gint result;
	gint _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_max;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2798 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_max (GitgLanes* self, gint value) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (gitg_lanes_get_inactive_max (self) != value) {
#line 2807 "gitg-lanes.c"
		gint _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = value;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->priv->_inactive_max = _tmp0_;
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_object_notify ((GObject *) self, "inactive-max");
#line 2815 "gitg-lanes.c"
	}
}


gint gitg_lanes_get_inactive_collapse (GitgLanes* self) {
	gint result;
	gint _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_collapse;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2831 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value) {
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (gitg_lanes_get_inactive_collapse (self) != value) {
#line 2840 "gitg-lanes.c"
		gint _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = value;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->priv->_inactive_collapse = _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_object_notify ((GObject *) self, "inactive-collapse");
#line 2848 "gitg-lanes.c"
	}
}


gint gitg_lanes_get_inactive_gap (GitgLanes* self) {
	gint result;
	gint _tmp0_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_gap;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2864 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value) {
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (gitg_lanes_get_inactive_gap (self) != value) {
#line 2873 "gitg-lanes.c"
		gint _tmp0_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = value;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->priv->_inactive_gap = _tmp0_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_object_notify ((GObject *) self, "inactive-gap");
#line 2881 "gitg-lanes.c"
	}
}


gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self) {
	gboolean result;
	gboolean _tmp0_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_enabled;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2897 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value) {
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (gitg_lanes_get_inactive_enabled (self) != value) {
#line 2906 "gitg-lanes.c"
		gboolean _tmp0_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = value;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->priv->_inactive_enabled = _tmp0_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_object_notify ((GObject *) self, "inactive-enabled");
#line 2914 "gitg-lanes.c"
	}
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
	GgitOId* _tmp2_;
	GgitOId* _tmp3_;
	GitgColor* _tmp4_;
	GitgLane* _tmp5_;
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) g_type_create_instance (object_type);
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = __vala_GgitOId_copy0 (_tmp0_);
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp1_;
#line 47 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = to;
#line 47 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 47 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 47 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp3_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = color;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = gitg_lane_new_with_color (_tmp4_);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp5_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->inactive = 0;
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2957 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color) {
#line 42 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct_with_color (GITG_LANES_TYPE_LANE_CONTAINER, from, to, color);
#line 2964 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_;
	GgitOId* _tmp1_;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = to;
#line 55 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) gitg_lanes_lane_container_construct_with_color (object_type, _tmp0_, _tmp1_, NULL);
#line 52 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2980 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to) {
#line 52 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct (GITG_LANES_TYPE_LANE_CONTAINER, from, to);
#line 2987 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index) {
	gboolean hidden;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GitgLane* _tmp2_;
	GitgLane* _tmp3_;
	GitgLane* _tmp4_;
	GitgLane* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	GgitOId* _tmp11_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = gitg_lanes_lane_container_get_is_hidden (self);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	hidden = _tmp1_;
#line 61 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->lane;
#line 61 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = gitg_lane_copy (_tmp2_);
#line 61 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 61 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp3_;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->lane;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_->tag = GITG_LANE_TAG_NONE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->lane;
#line 64 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (_tmp5_->from);
#line 64 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_->from = NULL;
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = hidden;
#line 66 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (!_tmp6_) {
#line 3033 "gitg-lanes.c"
		GitgLane* _tmp7_;
		gint _tmp8_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = self->lane;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = index;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp7_->from = g_slist_prepend (_tmp7_->from, (gpointer) ((gintptr) _tmp8_));
#line 3042 "gitg-lanes.c"
	}
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = hidden;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_set_is_hidden (self, _tmp9_);
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = self->to;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp11_ != NULL) {
#line 3052 "gitg-lanes.c"
		gint _tmp12_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = self->inactive;
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = _tmp12_ >= 0;
#line 3058 "gitg-lanes.c"
	} else {
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = FALSE;
#line 3062 "gitg-lanes.c"
	}
#line 73 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp10_) {
#line 3066 "gitg-lanes.c"
		gint _tmp13_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = self->inactive;
#line 75 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		self->inactive = _tmp13_ + 1;
#line 3072 "gitg-lanes.c"
	}
}


static gboolean gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self) {
	gboolean result;
	GitgLane* _tmp0_;
	GitgLaneTag _tmp1_;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->lane;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->tag;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	result = (_tmp1_ & GITG_LANE_TAG_HIDDEN) != 0;
#line 81 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 3091 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self, gboolean value) {
	gboolean _tmp0_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (_tmp0_) {
#line 3103 "gitg-lanes.c"
		GitgLane* _tmp1_;
		GitgLane* _tmp2_;
		GitgLaneTag _tmp3_;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = self->lane;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = self->lane;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = _tmp2_->tag;
#line 86 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp2_->tag = _tmp3_ | GITG_LANE_TAG_HIDDEN;
#line 3115 "gitg-lanes.c"
	} else {
		GitgLane* _tmp4_;
		GitgLane* _tmp5_;
		GitgLaneTag _tmp6_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = self->lane;
#line 90 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->lane;
#line 90 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _tmp5_->tag;
#line 90 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		_tmp5_->tag = _tmp6_ & (~GITG_LANE_TAG_HIDDEN);
#line 3128 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_init (GValue* value) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	value->data[0].v_pointer = NULL;
#line 3136 "gitg-lanes.c"
}


static void gitg_lanes_value_lane_container_free_value (GValue* value) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (value->data[0].v_pointer) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (value->data[0].v_pointer);
#line 3145 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_copy_value (const GValue* src_value, GValue* dest_value) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (src_value->data[0].v_pointer) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = gitg_lanes_lane_container_ref (src_value->data[0].v_pointer);
#line 3155 "gitg-lanes.c"
	} else {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3159 "gitg-lanes.c"
	}
}


static gpointer gitg_lanes_value_lane_container_peek_pointer (const GValue* value) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 3167 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (collect_values[0].v_pointer) {
#line 3174 "gitg-lanes.c"
		GitgLanesLaneContainer * object;
		object = collect_values[0].v_pointer;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		if (object->parent_instance.g_class == NULL) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3181 "gitg-lanes.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3185 "gitg-lanes.c"
		}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = gitg_lanes_lane_container_ref (object);
#line 3189 "gitg-lanes.c"
	} else {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3193 "gitg-lanes.c"
	}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 3197 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgLanesLaneContainer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (!object_p) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3208 "gitg-lanes.c"
	}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (!value->data[0].v_pointer) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*object_p = NULL;
#line 3214 "gitg-lanes.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*object_p = value->data[0].v_pointer;
#line 3218 "gitg-lanes.c"
	} else {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		*object_p = gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 3222 "gitg-lanes.c"
	}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 3226 "gitg-lanes.c"
}


static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgLanesParamSpecLaneContainer* spec;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return G_PARAM_SPEC (spec);
#line 3240 "gitg-lanes.c"
}


static gpointer gitg_lanes_value_get_lane_container (const GValue* value) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 3249 "gitg-lanes.c"
}


static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer * old;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 3269 "gitg-lanes.c"
	} else {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3273 "gitg-lanes.c"
	}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 3279 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer * old;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 3298 "gitg-lanes.c"
	} else {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3302 "gitg-lanes.c"
	}
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 3308 "gitg-lanes.c"
	}
}


static void gitg_lanes_lane_container_class_init (GitgLanesLaneContainerClass * klass) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	((GitgLanesLaneContainerClass *) klass)->finalize = gitg_lanes_lane_container_finalize;
#line 3318 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->ref_count = 1;
#line 3325 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer * obj) {
	GitgLanesLaneContainer * self;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_signal_handlers_destroy (self);
#line 37 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 39 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 3341 "gitg-lanes.c"
}


static GType gitg_lanes_lane_container_get_type (void) {
	static volatile gsize gitg_lanes_lane_container_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_lane_container_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_lanes_value_lane_container_init, gitg_lanes_value_lane_container_free_value, gitg_lanes_value_lane_container_copy_value, gitg_lanes_value_lane_container_peek_pointer, "p", gitg_lanes_value_lane_container_collect_value, "p", gitg_lanes_value_lane_container_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesLaneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_lane_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanesLaneContainer), 0, (GInstanceInitFunc) gitg_lanes_lane_container_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_lanes_lane_container_type_id;
		gitg_lanes_lane_container_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLanesLaneContainer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_lanes_lane_container_type_id__volatile, gitg_lanes_lane_container_type_id);
	}
	return gitg_lanes_lane_container_type_id__volatile;
}


static gpointer gitg_lanes_lane_container_ref (gpointer instance) {
	GitgLanesLaneContainer * self;
	self = instance;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_atomic_int_inc (&self->ref_count);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return instance;
#line 3366 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_unref (gpointer instance) {
	GitgLanesLaneContainer * self;
	self = instance;
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		GITG_LANES_LANE_CONTAINER_GET_CLASS (self)->finalize (self);
#line 35 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3379 "gitg-lanes.c"
	}
}


static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container) {
	GitgLanesCollapsedLane* self;
	GitgLanesLaneContainer* _tmp0_;
	GitgLane* _tmp1_;
	GitgColor* _tmp2_;
	GitgColor* _tmp3_;
	GitgLanesLaneContainer* _tmp4_;
	GgitOId* _tmp5_;
	GgitOId* _tmp6_;
	GitgLanesLaneContainer* _tmp7_;
	GgitOId* _tmp8_;
	GgitOId* _tmp9_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = g_slice_new0 (GitgLanesCollapsedLane);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_collapsed_lane_instance_init (self);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->lane;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_->color;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->color = _tmp3_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = container;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = _tmp4_->from;
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = __vala_GgitOId_copy0 (_tmp5_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp6_;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = container;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = _tmp7_->to;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = __vala_GgitOId_copy0 (_tmp8_);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp9_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 3436 "gitg-lanes.c"
}


static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self) {
}


static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane * self) {
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 101 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 97 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_slice_free (GitgLanesCollapsedLane, self);
#line 3453 "gitg-lanes.c"
}


static void gitg_lanes_class_init (GitgLanesClass * klass) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_type_class_add_private (klass, sizeof (GitgLanesPrivate));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_lanes_get_property;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_lanes_set_property;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_lanes_finalize;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_MAX, g_param_spec_int ("inactive-max", "inactive-max", "inactive-max", G_MININT, G_MAXINT, 30, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_COLLAPSE, g_param_spec_int ("inactive-collapse", "inactive-collapse", "inactive-collapse", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_GAP, g_param_spec_int ("inactive-gap", "inactive-gap", "inactive-gap", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_ENABLED, g_param_spec_boolean ("inactive-enabled", "inactive-enabled", "inactive-enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3476 "gitg-lanes.c"
}


static void gitg_lanes_instance_init (GitgLanes * self) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv = GITG_LANES_GET_PRIVATE (self);
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_max = 30;
#line 26 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_collapse = 10;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_gap = 10;
#line 28 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_enabled = TRUE;
#line 3491 "gitg-lanes.c"
}


static void gitg_lanes_finalize (GObject * obj) {
	GitgLanes * self;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LANES, GitgLanes);
#line 30 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 31 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 33 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_roots);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (gitg_lanes_parent_class)->finalize (obj);
#line 3509 "gitg-lanes.c"
}


GType gitg_lanes_get_type (void) {
	static volatile gsize gitg_lanes_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanes), 0, (GInstanceInitFunc) gitg_lanes_instance_init, NULL };
		GType gitg_lanes_type_id;
		gitg_lanes_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgLanes", &g_define_type_info, 0);
		g_once_init_leave (&gitg_lanes_type_id__volatile, gitg_lanes_type_id);
	}
	return gitg_lanes_type_id__volatile;
}


static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_max (self));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_collapse (self));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_gap (self));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		g_value_set_boolean (value, gitg_lanes_get_inactive_enabled (self));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3554 "gitg-lanes.c"
		default:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3560 "gitg-lanes.c"
	}
}


static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_max (self, g_value_get_int (value));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_collapse (self, g_value_get_int (value));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_gap (self, g_value_get_int (value));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_enabled (self, g_value_get_boolean (value));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3594 "gitg-lanes.c"
		default:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3600 "gitg-lanes.c"
	}
}



