/* gnome-sudoku.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
enum  {
	SUDOKU_DUMMY_PROPERTY,
	SUDOKU_LAST_PROPERTY
};
static GParamSpec* sudoku_properties[SUDOKU_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
	GameMode current_game_mode;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda26_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation);
static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
static void sudoku_display_unpause_button (Sudoku* self);
static void sudoku_display_pause_button (Sudoku* self);
static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda21_ (Block1Data* _data1_, gint response_id);
static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void sudoku_tick_cb (Sudoku* self);
static void sudoku_show_game_view (Sudoku* self);
static void sudoku_set_headerbar_title (Sudoku* self);
static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda16_ (Sudoku* self);
static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda17_ (Sudoku* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (Block2Data* _data2_, gint response_id);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda20_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda25_ (Sudoku* self);
static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[14] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the possible values for each cell"), NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_new_game_cb ((Sudoku*) self);
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
}


static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_create_game_cb ((Sudoku*) self);
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_reset_cb ((Sudoku*) self);
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_back_cb ((Sudoku*) self);
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_undo_cb ((Sudoku*) self);
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_redo_cb ((Sudoku*) self);
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_print_cb ((Sudoku*) self);
}


static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_play_custom_game_cb ((Sudoku*) self);
}


static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_toggle_pause_cb ((Sudoku*) self);
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_print_multiple_cb ((Sudoku*) self);
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_help_cb ((Sudoku*) self);
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	sudoku_about_cb ((Sudoku*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
	return self;
}


Sudoku* sudoku_new (void) {
	return sudoku_construct (TYPE_SUDOKU);
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	GVariantDict* _tmp3_;
	gboolean _tmp4_;
	self = (Sudoku*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = options;
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
	if (_tmp4_) {
		self->priv->show_possibilities = TRUE;
	}
	result = -1;
	return result;
}


static void __lambda26_ (Sudoku* self) {
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
	_tmp1_ = self->priv->view;
	if (_tmp1_ != NULL) {
		GameMode _tmp2_;
		_tmp2_ = self->priv->current_game_mode;
		_tmp0_ = _tmp2_ == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuView* _tmp3_;
		GSettings* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->view;
		_tmp4_ = self->priv->settings;
		_tmp5_ = g_settings_get_boolean (_tmp4_, "show-warnings");
		sudoku_view_set_show_warnings (_tmp3_, _tmp5_);
	}
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda26_ ((Sudoku*) self);
}


static void __lambda27_ (Sudoku* self) {
	SudokuView* _tmp0_;
	_tmp0_ = self->priv->view;
	if (_tmp0_ != NULL) {
		SudokuView* _tmp1_;
		GSettings* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->view;
		_tmp2_ = self->priv->settings;
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
	}
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda27_ ((Sudoku*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	sudoku_size_allocate_cb ((Sudoku*) self, allocation);
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
	return result;
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_;
	GAction* action = NULL;
	GSettings* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp30_;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_;
	GtkApplicationWindow* _tmp33_;
	GtkApplicationWindow* _tmp34_;
	GtkApplicationWindow* _tmp35_;
	GtkApplicationWindow* _tmp36_;
	GSettings* _tmp37_;
	gint _tmp38_;
	GSettings* _tmp39_;
	gint _tmp40_;
	GSettings* _tmp41_;
	gboolean _tmp42_;
	GtkApplicationWindow* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_;
	GtkHeaderBar* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_;
	GtkStack* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_;
	GtkBox* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_;
	GtkBox* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_;
	GtkButton* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_;
	GtkLabel* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_;
	GtkImage* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_;
	GtkButton* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_;
	GtkButton* _tmp71_;
	GtkBuilder* _tmp72_;
	GObject* _tmp73_;
	GtkLabel* _tmp74_;
	GAction* _tmp75_;
	GSimpleAction* _tmp76_;
	GAction* _tmp77_;
	GSimpleAction* _tmp78_;
	GAction* _tmp79_;
	GSimpleAction* _tmp80_;
	GAction* _tmp81_;
	GSimpleAction* _tmp82_;
	GAction* _tmp83_;
	GSimpleAction* _tmp84_;
	GAction* _tmp85_;
	GSimpleAction* _tmp86_;
	GAction* _tmp87_;
	GSimpleAction* _tmp88_;
	GAction* _tmp89_;
	GSimpleAction* _tmp90_;
	GtkHeaderBar* _tmp91_;
	GtkApplicationWindow* _tmp92_;
	GtkHeaderBar* _tmp93_;
	SudokuSaver* _tmp94_;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp95_;
	SudokuGame* _tmp96_;
	SudokuGame* _tmp97_;
	self = (Sudoku*) base;
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
	action = _tmp2_;
	_tmp3_ = action;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda26__g_object_notify, self, 0);
	_tmp4_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
	highlighter_action = _tmp6_;
	_tmp7_ = highlighter_action;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda27__g_object_notify, self, 0);
	_tmp8_ = highlighter_action;
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
	_tmp9_ = g_strdup ("<Primary>n");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Primary>p");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Primary>q");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Primary>r");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<Primary>z");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("<Primary><Shift>z");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("F1");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	gtk_window_set_default_icon_name ("gnome-sudoku");
	_tmp30_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
	builder = _tmp30_;
	_tmp31_ = builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "sudoku_app");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp33_;
	_tmp34_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "size-allocate", (GCallback) _sudoku_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp35_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp35_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp36_ = self->priv->window;
	_tmp37_ = self->priv->settings;
	_tmp38_ = g_settings_get_int (_tmp37_, "window-width");
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_int (_tmp39_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp36_, _tmp38_, _tmp40_);
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_boolean (_tmp41_, "window-is-maximized");
	if (_tmp42_) {
		GtkApplicationWindow* _tmp43_;
		_tmp43_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp43_);
	}
	_tmp44_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp44_);
	_tmp45_ = builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "headerbar");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp47_;
	_tmp48_ = builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "main_stack");
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp50_;
	_tmp51_ = builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "game_box");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp53_;
	_tmp54_ = builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "undo_redo_box");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->undo_redo_box);
	self->priv->undo_redo_box = _tmp56_;
	_tmp57_ = builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "back_button");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = _tmp59_;
	_tmp60_ = builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "clock_label");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp62_;
	_tmp63_ = builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "clock_image");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_image_get_type (), GtkImage));
	_g_object_unref0 (self->priv->clock_image);
	self->priv->clock_image = _tmp65_;
	_tmp66_ = builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "play_custom_game_button");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_custom_game_button);
	self->priv->play_custom_game_button = _tmp68_;
	_tmp69_ = builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "play_pause_button");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp71_;
	_tmp72_ = builder;
	_tmp73_ = gtk_builder_get_object (_tmp72_, "play_pause_label");
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->play_pause_label);
	self->priv->play_pause_label = _tmp74_;
	_tmp75_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp76_;
	_tmp77_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp78_;
	_tmp79_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp80_;
	_tmp81_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->clear_action);
	self->priv->clear_action = _tmp82_;
	_tmp83_ = g_action_map_lookup_action ((GActionMap*) self, "print");
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_action);
	self->priv->print_action = _tmp84_;
	_tmp85_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_multiple_action);
	self->priv->print_multiple_action = _tmp86_;
	_tmp87_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp88_;
	_tmp89_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->play_custom_game_action);
	self->priv->play_custom_game_action = _tmp90_;
	_tmp91_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp91_, TRUE);
	_tmp92_ = self->priv->window;
	_tmp93_ = self->priv->headerbar;
	gtk_window_set_titlebar ((GtkWindow*) _tmp92_, (GtkWidget*) _tmp93_);
	_tmp94_ = sudoku_saver_new ();
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp94_;
	_tmp95_ = self->priv->saver;
	_tmp96_ = sudoku_saver_get_savedgame (_tmp95_);
	savegame = _tmp96_;
	_tmp97_ = savegame;
	if (_tmp97_ != NULL) {
		SudokuGame* _tmp98_;
		SudokuBoard* _tmp99_;
		DifficultyCategory _tmp100_;
		DifficultyCategory _tmp101_;
		SudokuGame* _tmp111_;
		SudokuBoard* _tmp112_;
		_tmp98_ = savegame;
		_tmp99_ = _tmp98_->board;
		_tmp100_ = sudoku_board_get_difficulty_category (_tmp99_);
		_tmp101_ = _tmp100_;
		if (_tmp101_ == DIFFICULTY_CATEGORY_CUSTOM) {
			GameMode _tmp102_ = 0;
			SudokuGame* _tmp103_;
			SudokuBoard* _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			SudokuGame* _tmp107_;
			SudokuBoard* _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			_tmp103_ = savegame;
			_tmp104_ = _tmp103_->board;
			_tmp105_ = sudoku_board_get_filled (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = savegame;
			_tmp108_ = _tmp107_->board;
			_tmp109_ = sudoku_board_get_fixed (_tmp108_);
			_tmp110_ = _tmp109_;
			if (_tmp106_ == _tmp110_) {
				_tmp102_ = GAME_MODE_CREATE;
			} else {
				_tmp102_ = GAME_MODE_PLAY;
			}
			self->priv->current_game_mode = _tmp102_;
		}
		_tmp111_ = savegame;
		_tmp112_ = _tmp111_->board;
		sudoku_start_game (self, _tmp112_);
	} else {
		sudoku_show_new_game_screen (self);
	}
	_g_object_unref0 (savegame);
	_g_object_unref0 (builder);
	_g_object_unref0 (highlighter_action);
	_g_object_unref0 (action);
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_;
	GSettings* _tmp22_;
	gint _tmp23_;
	GSettings* _tmp24_;
	gint _tmp25_;
	GSettings* _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_ = NULL;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp10_ = FALSE;
		SudokuGame* _tmp11_;
		gboolean _tmp12_;
		_tmp2_ = self->priv->game;
		_tmp3_ = sudoku_game_is_empty (_tmp2_);
		if (!_tmp3_) {
			SudokuGame* _tmp4_;
			SudokuBoard* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp4_ = self->priv->game;
			_tmp5_ = _tmp4_->board;
			_tmp6_ = sudoku_board_get_complete (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = !_tmp7_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			SudokuSaver* _tmp8_;
			SudokuGame* _tmp9_;
			_tmp8_ = self->priv->saver;
			_tmp9_ = self->priv->game;
			sudoku_saver_save_game (_tmp8_, _tmp9_);
		}
		_tmp11_ = self->priv->game;
		_tmp12_ = sudoku_game_is_empty (_tmp11_);
		if (_tmp12_) {
			SudokuSaver* _tmp13_;
			SudokuGame* _tmp14_;
			SudokuGame* _tmp15_;
			_tmp13_ = self->priv->saver;
			_tmp14_ = sudoku_saver_get_savedgame (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_ != NULL;
			_g_object_unref0 (_tmp15_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GFile* file = NULL;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GFile* _tmp18_;
			_tmp16_ = sudoku_saver_get_savegame_file ();
			_tmp17_ = _tmp16_;
			_tmp18_ = g_file_new_for_path (_tmp17_);
			file = _tmp18_;
			{
				GFile* _tmp19_;
				_tmp19_ = file;
				g_file_delete (_tmp19_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_;
				const gchar* _tmp21_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp20_ = e;
				_tmp21_ = _tmp20_->message;
				g_warning ("gnome-sudoku.vala:219: Failed to delete saved game: %s", _tmp21_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		}
	}
	_tmp22_ = self->priv->settings;
	_tmp23_ = self->priv->window_width;
	g_settings_set_int (_tmp22_, "window-width", _tmp23_);
	_tmp24_ = self->priv->settings;
	_tmp25_ = self->priv->window_height;
	g_settings_set_int (_tmp24_, "window-height", _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp26_, "window-is-maximized", _tmp27_);
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->window;
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
	self->priv->window_width = _tmp4_;
	self->priv->window_height = _tmp5_;
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static void sudoku_paused_changed_cb (Sudoku* self) {
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SudokuView* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
		sudoku_display_unpause_button (self);
		_tmp3_ = self->priv->clear_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
		_tmp5_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
		_tmp6_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		SudokuGame* _tmp7_;
		gdouble _tmp8_;
		_tmp7_ = self->priv->game;
		_tmp8_ = sudoku_game_get_total_time_played (_tmp7_);
		if (_tmp8_ > ((gdouble) 0)) {
			GSimpleAction* _tmp9_;
			SudokuGame* _tmp10_;
			gboolean _tmp11_;
			GSimpleAction* _tmp12_;
			SudokuGame* _tmp13_;
			gboolean _tmp14_;
			GSimpleAction* _tmp15_;
			SudokuGame* _tmp16_;
			gboolean _tmp17_;
			GSimpleAction* _tmp18_;
			sudoku_display_pause_button (self);
			_tmp9_ = self->priv->clear_action;
			_tmp10_ = self->priv->game;
			_tmp11_ = sudoku_game_is_empty (_tmp10_);
			g_simple_action_set_enabled (_tmp9_, !_tmp11_);
			_tmp12_ = self->priv->undo_action;
			_tmp13_ = self->priv->game;
			_tmp14_ = sudoku_game_is_undostack_null (_tmp13_);
			g_simple_action_set_enabled (_tmp12_, !_tmp14_);
			_tmp15_ = self->priv->redo_action;
			_tmp16_ = self->priv->game;
			_tmp17_ = sudoku_game_is_redostack_null (_tmp16_);
			g_simple_action_set_enabled (_tmp15_, !_tmp17_);
			_tmp18_ = self->priv->new_game_action;
			g_simple_action_set_enabled (_tmp18_, TRUE);
		}
	}
	_tmp19_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp19_);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Sudoku* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ____lambda21_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
	GtkMessageDialog* _tmp3_;
	self = _data1_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		SudokuGame* _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp1_ = self->priv->game;
		_tmp2_ = _tmp1_->board;
		sudoku_start_custom_game (self, _tmp2_);
	}
	_tmp3_ = _data1_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
}


static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	____lambda21_ (self, response_id);
}


static void sudoku_play_custom_game_cb (Sudoku* self) {
	gint solutions = 0;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = sudoku_board_count_solutions_limited (_tmp1_);
	solutions = _tmp2_;
	_tmp3_ = solutions;
	if (_tmp3_ == 1) {
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		_tmp4_ = self->priv->game;
		_tmp5_ = _tmp4_->board;
		sudoku_start_custom_game (self, _tmp5_);
	} else {
		gint _tmp6_;
		_tmp6_ = solutions;
		if (_tmp6_ == 0) {
			gchar* error_str = NULL;
			gchar* _tmp7_;
			GtkMessageDialog* dialog = NULL;
			GtkApplicationWindow* _tmp8_;
			const gchar* _tmp9_;
			GtkMessageDialog* _tmp10_;
			GtkMessageDialog* _tmp11_;
			GtkMessageDialog* _tmp12_;
			_tmp7_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered is not a valid Sudoku."), _ ("Please enter a valid puzzle."));
			error_str = _tmp7_;
			_tmp8_ = self->priv->window;
			_tmp9_ = error_str;
			_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp9_);
			g_object_ref_sink (_tmp10_);
			dialog = _tmp10_;
			_tmp11_ = dialog;
			gtk_dialog_run ((GtkDialog*) _tmp11_);
			_tmp12_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp12_);
			_g_object_unref0 (dialog);
			_g_free0 (error_str);
		} else {
			Block1Data* _data1_;
			gchar* warning_str = NULL;
			gchar* _tmp13_;
			GtkApplicationWindow* _tmp14_;
			const gchar* _tmp15_;
			GtkMessageDialog* _tmp16_;
			GtkMessageDialog* _tmp17_;
			GtkMessageDialog* _tmp18_;
			GtkMessageDialog* _tmp19_;
			GtkMessageDialog* _tmp20_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp13_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered has multiple solutions."), _ ("Valid Sudoku puzzles have exactly one solution."));
			warning_str = _tmp13_;
			_tmp14_ = self->priv->window;
			_tmp15_ = warning_str;
			_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp14_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp15_);
			g_object_ref_sink (_tmp16_);
			_data1_->dialog = _tmp16_;
			_tmp17_ = _data1_->dialog;
			gtk_dialog_add_button ((GtkDialog*) _tmp17_, _ ("_Back"), (gint) GTK_RESPONSE_REJECT);
			_tmp18_ = _data1_->dialog;
			gtk_dialog_add_button ((GtkDialog*) _tmp18_, _ ("Play _Anyway"), (gint) GTK_RESPONSE_ACCEPT);
			_tmp19_ = _data1_->dialog;
			g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) _____lambda21__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp20_ = _data1_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp20_);
			_g_free0 (warning_str);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
	}
}


static void sudoku_toggle_pause_cb (Sudoku* self) {
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SudokuGame* _tmp3_;
		_tmp3_ = self->priv->game;
		sudoku_game_resume_clock (_tmp3_);
	} else {
		SudokuGame* _tmp4_;
		_tmp4_ = self->priv->game;
		sudoku_game_stop_clock (_tmp4_);
	}
}


static void sudoku_tick_cb (Sudoku* self) {
	gint elapsed_time = 0;
	SudokuGame* _tmp0_;
	gdouble _tmp1_;
	gint hours = 0;
	gint _tmp2_;
	gint minutes = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint seconds = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_total_time_played (_tmp0_);
	elapsed_time = (gint) _tmp1_;
	_tmp2_ = elapsed_time;
	hours = _tmp2_ / 3600;
	_tmp3_ = elapsed_time;
	_tmp4_ = hours;
	minutes = (_tmp3_ - (_tmp4_ * 3600)) / 60;
	_tmp5_ = elapsed_time;
	_tmp6_ = hours;
	_tmp7_ = minutes;
	seconds = (_tmp5_ - (_tmp6_ * 3600)) - (_tmp7_ * 60);
	_tmp8_ = hours;
	if (_tmp8_ > 0) {
		GtkLabel* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = self->priv->clock_label;
		_tmp10_ = hours;
		_tmp11_ = minutes;
		_tmp12_ = seconds;
		_tmp13_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp10_, _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		gtk_label_set_text (_tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		GtkLabel* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = self->priv->clock_label;
		_tmp16_ = minutes;
		_tmp17_ = seconds;
		_tmp18_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		gtk_label_set_text (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
	}
}


static void sudoku_display_pause_button (Sudoku* self) {
	GtkButton* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->play_pause_label;
	gtk_label_set_label (_tmp1_, _ ("_Pause"));
}


static void sudoku_display_unpause_button (Sudoku* self) {
	GtkButton* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->play_pause_label;
	gtk_label_set_label (_tmp1_, _ ("_Resume"));
}


static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board) {
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	_tmp0_ = self->priv->game;
	sudoku_game_stop_clock (_tmp0_);
	_tmp1_ = board;
	sudoku_start_game (self, _tmp1_);
}


static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self) {
	sudoku_tick_cb ((Sudoku*) self);
}


static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self) {
	sudoku_paused_changed_cb ((Sudoku*) self);
}


static void __lambda16_ (Sudoku* self) {
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	GSimpleAction* _tmp6_;
	SudokuGame* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	GSimpleAction* _tmp15_;
	_tmp0_ = self->priv->undo_action;
	_tmp1_ = self->priv->game;
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
	_tmp3_ = self->priv->redo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->clear_action;
	_tmp7_ = self->priv->game;
	_tmp8_ = sudoku_game_is_empty (_tmp7_);
	g_simple_action_set_enabled (_tmp6_, !_tmp8_);
	_tmp10_ = self->priv->game;
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
	if (!_tmp11_) {
		SudokuGame* _tmp12_;
		SudokuBoard* _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = self->priv->game;
		_tmp13_ = _tmp12_->board;
		_tmp14_ = sudoku_board_is_fully_filled (_tmp13_);
		_tmp9_ = !_tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp15_ = self->priv->play_custom_game_action;
	g_simple_action_set_enabled (_tmp15_, _tmp9_);
}


static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
	__lambda16_ ((Sudoku*) self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Sudoku* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda18_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
	self = _data2_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		sudoku_show_new_game_screen (self);
	} else {
		gint _tmp1_;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
			g_application_quit ((GApplication*) self);
		}
	}
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
}


static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda18_ (self, response_id);
}


static void __lambda17_ (Sudoku* self) {
	Block2Data* _data2_;
	GtkButton* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuSaver* _tmp17_;
	SudokuGame* _tmp18_;
	gint minutes = 0;
	SudokuGame* _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	gchar* time_str = NULL;
	gchar* _tmp22_;
	GtkApplicationWindow* _tmp23_;
	GtkMessageDialog* _tmp24_;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->play_custom_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->game;
	sudoku_game_stop_clock (_tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				SudokuGame* _tmp5_;
				SudokuBoard* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->game;
				_tmp6_ = _tmp5_->board;
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp4_ < _tmp8_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							SudokuGame* _tmp12_;
							SudokuBoard* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							SudokuView* _tmp16_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							_tmp12_ = self->priv->game;
							_tmp13_ = _tmp12_->board;
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(_tmp11_ < _tmp15_)) {
								break;
							}
							_tmp16_ = self->priv->view;
							g_object_set ((GtkWidget*) _tmp16_, "can-focus", FALSE, NULL);
						}
					}
				}
			}
		}
	}
	_tmp17_ = self->priv->saver;
	_tmp18_ = self->priv->game;
	sudoku_saver_add_game_to_finished (_tmp17_, _tmp18_, TRUE);
	_tmp19_ = self->priv->game;
	_tmp20_ = sudoku_game_get_total_time_played (_tmp19_);
	_tmp21_ = MAX (1, ((gint) _tmp20_) / 60);
	minutes = _tmp21_;
	_tmp22_ = g_strdup_printf (ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes), minutes);
	time_str = _tmp22_;
	_tmp23_ = self->priv->window;
	_tmp24_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp23_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", time_str);
	g_object_ref_sink (_tmp24_);
	_data2_->dialog = _tmp24_;
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _ ("_Quit"), (gint) GTK_RESPONSE_REJECT);
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _ ("Play _Again"), (gint) GTK_RESPONSE_ACCEPT);
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
	_g_free0 (time_str);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
	__lambda17_ ((Sudoku*) self);
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	SudokuView* _tmp0_;
	SudokuBoard* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuGame* _tmp5_;
	GameMode _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	GSimpleAction* _tmp12_;
	SudokuGame* _tmp13_;
	gboolean _tmp14_;
	SudokuGame* _tmp15_;
	SudokuGame* _tmp16_;
	SudokuGame* _tmp17_;
	SudokuGame* _tmp18_;
	SudokuView* _tmp19_;
	SudokuView* _tmp20_;
	SudokuView* _tmp21_;
	gboolean _tmp22_;
	GameMode _tmp23_;
	SudokuView* _tmp28_;
	GSettings* _tmp29_;
	gboolean _tmp30_;
	SudokuView* _tmp31_;
	GtkBox* _tmp32_;
	SudokuView* _tmp33_;
	SudokuGame* _tmp34_;
	GameMode _tmp35_;
	SudokuGame* _tmp36_;
	SudokuBoard* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->priv->view;
	if (_tmp0_ != NULL) {
		GtkBox* _tmp1_;
		SudokuView* _tmp2_;
		_tmp1_ = self->priv->game_box;
		_tmp2_ = self->priv->view;
		gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	}
	sudoku_show_game_view (self);
	_tmp3_ = board;
	_tmp4_ = sudoku_game_new (_tmp3_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp4_;
	_tmp5_ = self->priv->game;
	_tmp6_ = self->priv->current_game_mode;
	_tmp5_->mode = _tmp6_;
	_tmp7_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	sudoku_set_headerbar_title (self);
	_tmp9_ = self->priv->clear_action;
	_tmp10_ = self->priv->game;
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
	g_simple_action_set_enabled (_tmp9_, !_tmp11_);
	_tmp12_ = self->priv->play_custom_game_action;
	_tmp13_ = self->priv->game;
	_tmp14_ = sudoku_game_is_empty (_tmp13_);
	g_simple_action_set_enabled (_tmp12_, !_tmp14_);
	_tmp15_ = self->priv->game;
	g_signal_connect_object (_tmp15_, "tick", (GCallback) _sudoku_tick_cb_sudoku_game_tick, self, 0);
	_tmp16_ = self->priv->game;
	g_signal_connect_object (_tmp16_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
	_tmp17_ = self->priv->game;
	sudoku_game_start_clock (_tmp17_);
	_tmp18_ = self->priv->game;
	_tmp19_ = sudoku_view_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp19_;
	_tmp20_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp20_, 480, 480);
	_tmp21_ = self->priv->view;
	_tmp22_ = self->priv->show_possibilities;
	sudoku_view_set_show_possibilities (_tmp21_, _tmp22_);
	_tmp23_ = self->priv->current_game_mode;
	if (_tmp23_ == GAME_MODE_CREATE) {
		SudokuView* _tmp24_;
		_tmp24_ = self->priv->view;
		sudoku_view_set_show_warnings (_tmp24_, TRUE);
	} else {
		SudokuView* _tmp25_;
		GSettings* _tmp26_;
		gboolean _tmp27_;
		_tmp25_ = self->priv->view;
		_tmp26_ = self->priv->settings;
		_tmp27_ = g_settings_get_boolean (_tmp26_, "show-warnings");
		sudoku_view_set_show_warnings (_tmp25_, _tmp27_);
	}
	_tmp28_ = self->priv->view;
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_boolean (_tmp29_, "highlighter");
	sudoku_view_set_highlighter (_tmp28_, _tmp30_);
	_tmp31_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->game_box;
	_tmp33_ = self->priv->view;
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
	_tmp34_ = self->priv->game;
	g_signal_connect_object (_tmp34_, "cell-changed", (GCallback) ___lambda16__sudoku_game_cell_changed, self, 0);
	_tmp35_ = self->priv->current_game_mode;
	if (_tmp35_ == GAME_MODE_CREATE) {
		return;
	}
	_tmp36_ = self->priv->game;
	_tmp37_ = _tmp36_->board;
	g_signal_connect_object (_tmp37_, "completed", (GCallback) ___lambda17__sudoku_board_completed, self, 0);
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	SudokuGame* _tmp2_;
	GtkBox* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GSimpleAction* _tmp5_;
	GtkLabel* _tmp6_;
	GtkImage* _tmp7_;
	SudokuGame* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
	_tmp1_ = self->priv->back_button;
	_tmp2_ = self->priv->game;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
	_tmp3_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->headerbar;
	gtk_header_bar_set_title (_tmp4_, _ ("Select Difficulty"));
	_tmp5_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->clock_label;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->clock_image;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->game;
	if (_tmp8_ != NULL) {
		SudokuGame* _tmp9_;
		_tmp9_ = self->priv->game;
		sudoku_game_stop_clock (_tmp9_);
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
	g_return_if_fail (self != NULL);
	sudoku_show_new_game_screen (self);
}


static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_;
		GeeList* _tmp1_;
		gpointer _tmp2_;
		SudokuBoard* _tmp3_;
		_tmp0_ = res;
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
		gen_boards = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp2_ = gee_list_get (gen_boards, 0);
		_tmp3_ = (SudokuBoard*) _tmp2_;
		sudoku_start_game (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("gnome-sudoku.vala:446: Error: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda19_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}


static void sudoku_create_game_cb (Sudoku* self) {
	g_return_if_fail (self != NULL);
	self->priv->current_game_mode = GAME_MODE_CREATE;
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda19__gasync_ready_callback, g_object_ref (self));
}


static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_;
		GeeList* _tmp1_;
		GtkButton* _tmp2_;
		gpointer _tmp3_;
		SudokuBoard* _tmp4_;
		_tmp0_ = res;
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
		gen_boards = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp2_ = self->priv->back_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = gee_list_get (gen_boards, 0);
		_tmp4_ = (SudokuBoard*) _tmp3_;
		sudoku_start_game (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("gnome-sudoku.vala:471: Error: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda15_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_;
	gint32 _tmp1_;
	GtkButton* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = difficulty;
	_tmp1_ = g_variant_get_int32 (_tmp0_);
	selected_difficulty = (DifficultyCategory) _tmp1_;
	_tmp2_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	sudoku_generator_generate_boards_async (1, selected_difficulty, NULL, ___lambda15__gasync_ready_callback, g_object_ref (self));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Sudoku* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda20_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
	self = _data3_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		SudokuGame* _tmp1_;
		SudokuView* _tmp2_;
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		_tmp1_ = self->priv->game;
		sudoku_game_reset (_tmp1_);
		_tmp2_ = self->priv->view;
		sudoku_view_clear (_tmp2_);
		_tmp3_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
	}
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}


static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda20_ (self, response_id);
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Reset the board to its original state?"));
	g_object_ref_sink (_tmp1_);
	_data3_->dialog = _tmp1_;
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void sudoku_show_game_view (Sudoku* self) {
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkBox* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkLabel* _tmp4_;
	GtkImage* _tmp5_;
	SudokuGame* _tmp6_;
	GameMode _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
	_tmp1_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	_tmp4_ = self->priv->clock_label;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->clock_image;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->game;
	if (_tmp6_ != NULL) {
		SudokuGame* _tmp7_;
		_tmp7_ = self->priv->game;
		sudoku_game_resume_clock (_tmp7_);
	}
	_tmp8_ = self->priv->current_game_mode;
	if (_tmp8_ == GAME_MODE_PLAY) {
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
		_tmp9_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
	} else {
		GtkLabel* _tmp11_;
		GtkImage* _tmp12_;
		GtkButton* _tmp13_;
		GtkButton* _tmp14_;
		_tmp11_ = self->priv->clock_label;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
		_tmp12_ = self->priv->clock_image;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
		_tmp14_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
	}
}


static void sudoku_set_headerbar_title (Sudoku* self) {
	GameMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_game_mode;
	if (_tmp0_ == GAME_MODE_PLAY) {
		GtkHeaderBar* _tmp1_;
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		DifficultyCategory _tmp4_;
		DifficultyCategory _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->headerbar;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		_tmp4_ = sudoku_board_get_difficulty_category (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = difficulty_category_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_header_bar_set_title (_tmp1_, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		GtkHeaderBar* _tmp8_;
		_tmp8_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp8_, _ ("Create Puzzle"));
	}
}


static void sudoku_back_cb (Sudoku* self) {
	g_return_if_fail (self != NULL);
	sudoku_show_game_view (self);
	sudoku_set_headerbar_title (self);
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	SudokuGame* _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	SudokuView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->game;
	sudoku_game_undo (_tmp2_);
	_tmp3_ = self->priv->undo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	SudokuGame* _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	SudokuView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->game;
	sudoku_game_redo (_tmp2_);
	_tmp3_ = self->priv->redo_action;
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
	_tmp6_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	SudokuGame* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuBoard* _tmp9_;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_;
	GtkApplicationWindow* _tmp11_;
	SudokuPrinter* _tmp12_;
	SudokuPrinter* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp4_;
	_tmp5_ = list;
	_tmp6_ = self->priv->game;
	_tmp7_ = _tmp6_->board;
	_tmp8_ = sudoku_board_clone (_tmp7_);
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = list;
	_tmp11_ = self->priv->window;
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, (GtkWindow*) _tmp11_);
	printer = _tmp12_;
	_tmp13_ = printer;
	sudoku_printer_print_sudoku (_tmp13_);
	_tmp14_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_tmp15_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp15_, TRUE);
	_g_object_unref0 (printer);
	_g_object_unref0 (list);
}


static void __lambda25_ (Sudoku* self) {
	GSimpleAction* _tmp0_;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	GSimpleAction* _tmp3_;
	_tmp0_ = self->priv->print_action;
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
	_tmp3_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
}


static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda25_ ((Sudoku*) self);
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	PrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	PrintDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->saver;
	_tmp3_ = self->priv->window;
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	print_dialog = _tmp4_;
	g_signal_connect_object ((GtkWidget*) print_dialog, "destroy", (GCallback) ___lambda25__gtk_widget_destroy, self, 0);
	gtk_dialog_run ((GtkDialog*) print_dialog);
	_g_object_unref0 (print_dialog);
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-sudoku.vala:588: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void sudoku_about_cb (Sudoku* self) {
	gchar* localized_comments_format = NULL;
	gchar* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s"));
	localized_comments_format = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = sudoku_generator_qqwing_version ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (localized_comments_format, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_show_about_dialog ((GtkWindow*) _tmp1_, "program-name", _ ("Sudoku"), "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp5_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_3_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (localized_comments_format);
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
	_tmp0_ = sudoku_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
	return sudoku_main (argv, argc);
}


static void sudoku_class_init (SudokuClass * klass) {
	sudoku_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) sudoku_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) sudoku_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) sudoku_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) sudoku_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
}


static void sudoku_instance_init (Sudoku * self) {
	self->priv = SUDOKU_GET_PRIVATE (self);
	self->priv->show_possibilities = FALSE;
	self->priv->current_game_mode = GAME_MODE_PLAY;
}


static void sudoku_finalize (GObject * obj) {
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->play_custom_game_button);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_label);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->clock_image);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->undo_redo_box);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->clear_action);
	_g_object_unref0 (self->priv->print_action);
	_g_object_unref0 (self->priv->print_multiple_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->play_custom_game_action);
	_g_object_unref0 (self->priv->new_game_action);
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



