/* rygel-media-export-query-container.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-media-export-query-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerSearchData RygelMediaExportQueryContainerSearchData;
typedef struct _RygelMediaExportQueryContainerGetChildrenData RygelMediaExportQueryContainerGetChildrenData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	gchar* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportQueryContainerPrivate {
	gchar* attribute;
	RygelSearchExpression* expression;
	gchar* pattern;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _RygelMediaExportQueryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	RygelSearchExpression* combined_expression;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelLogicalExpression* _tmp3_;
	RygelLogicalExpression* local_expression;
	RygelLogicalExpression* _tmp4_;
	RygelSearchExpression* _tmp5_;
	RygelSearchExpression* _tmp6_;
	RygelLogicalExpression* _tmp7_;
	RygelLogicalExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	RygelSearchExpression* _tmp10_;
	RygelLogicalExpression* _tmp11_;
	RygelSearchExpression* _tmp12_;
	RygelMediaExportMediaCache* _tmp13_;
	RygelSearchExpression* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	RygelMediaObjects* _tmp18_;
	RygelMediaObjects* _tmp19_;
	GError* _error_;
	GError* _tmp20_;
	RygelMediaObjects* _tmp21_;
	GError* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	const gchar* _tmp0_;
	guint total_matches;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaExportMediaCache* _tmp9_;
	const gchar* _tmp10_;
	RygelSearchExpression* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	GeeList* _tmp14_;
	GeeList* data;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	GeeList* _meta_data_list;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _meta_data_size;
	gint _meta_data_index;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeList* _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	gchar* meta_data;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* new_id;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaExportMediaCache* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	RygelMediaExportQueryContainer* _tmp34_;
	RygelMediaExportQueryContainer* container;
	RygelMediaObjects* _tmp35_;
	RygelMediaExportQueryContainer* _tmp36_;
	RygelMediaObjects* _tmp37_;
	RygelMediaObjects* _tmp38_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _child_size;
	gint _child_index;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	RygelMediaObjects* _tmp45_;
	gint _tmp46_;
	gpointer _tmp47_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp48_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_query_container_parent_class = NULL;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash);
static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2);
static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static void rygel_media_export_query_container_real_search_data_free (gpointer _data);
static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data);
static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_query_container_register_id (gchar** id);
static void rygel_media_export_query_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 277 "rygel-media-export-query-container.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 307 "rygel-media-export-query-container.c"
				goto __catch36_g_regex_error;
			}
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 316 "rygel-media-export-query-container.c"
		}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 332 "rygel-media-export-query-container.c"
				goto __catch36_g_regex_error;
			}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 343 "rygel-media-export-query-container.c"
		}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 351 "rygel-media-export-query-container.c"
	}
	goto __finally36;
	__catch36_g_regex_error:
	{
		GError* e = NULL;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1391 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 365 "rygel-media-export-query-container.c"
	}
	__finally36:
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 376 "rygel-media-export-query-container.c"
	}
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer * self = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gint i;
	gint _tmp31_ = 0;
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = media_db;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = id;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp2_ = name;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self = (RygelMediaExportQueryContainer*) rygel_media_export_db_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp3_ = id;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp4_ = rygel_media_export_query_container_get_virtual_container_definition (_tmp3_);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (self->plaintext_id);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self->plaintext_id = _tmp4_;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp5_ = self->plaintext_id;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_debug ("rygel-media-export-query-container.vala:57: plaintext ID is: %s", _tmp5_);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp6_ = self->plaintext_id;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ",", 0);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	args = _tmp8_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	args_length1 = _vala_array_length (_tmp7_);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_args_size_ = args_length1;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if ((args_length1 % 2) != 0) {
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_assert_not_reached ();
#line 437 "rygel-media-export-query-container.c"
	}
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	i = 0;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	while (TRUE) {
#line 443 "rygel-media-export-query-container.c"
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		gint _tmp30_;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp9_ = i;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (!(_tmp9_ < args_length1)) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			break;
#line 454 "rygel-media-export-query-container.c"
		}
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp10_ = i;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp11_ = args[_tmp10_ + 1];
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (g_strcmp0 (_tmp11_, "?") != 0) {
#line 462 "rygel-media-export-query-container.c"
			gint _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp12_ = i;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp13_ = args[_tmp12_];
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp14_ = i;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp15_ = args[_tmp14_ + 1];
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			rygel_media_export_query_container_update_search_expression (self, _tmp13_, _tmp15_);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp16_ = name;
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (g_strcmp0 (_tmp16_, "") == 0) {
#line 482 "rygel-media-export-query-container.c"
				gint _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_tmp17_ = i;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_tmp18_ = args[_tmp17_ + 1];
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_tmp19_ = g_uri_unescape_string (_tmp18_, NULL);
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_tmp20_ = _tmp19_;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				rygel_media_object_set_title ((RygelMediaObject*) self, _tmp20_);
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_g_free0 (_tmp20_);
#line 499 "rygel-media-export-query-container.c"
			}
		} else {
			gint _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp21_ = i;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp22_ = g_strdup ("%s");
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_free0 (args[_tmp21_ + 1]);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			args[_tmp21_ + 1] = _tmp22_;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp23_ = args[_tmp21_ + 1];
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp24_ = i;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp25_ = args[_tmp24_];
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp26_ = string_replace (_tmp25_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_free0 (self->priv->attribute);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			self->priv->attribute = _tmp26_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp27_ = self->priv->attribute;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp28_ = g_uri_unescape_string (_tmp27_, NULL);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_free0 (self->priv->attribute);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			self->priv->attribute = _tmp28_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp29_ = g_strjoinv (",", args);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_free0 (self->priv->pattern);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			self->priv->pattern = _tmp29_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			break;
#line 547 "rygel-media-export-query-container.c"
		}
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp30_ = i;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		i = _tmp30_ + 2;
#line 553 "rygel-media-export-query-container.c"
	}
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp31_ = rygel_media_export_query_container_count_children (self);
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	((RygelMediaContainer*) self)->child_count = _tmp31_;
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return self;
#line 563 "rygel-media-export-query-container.c"
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return rygel_media_export_query_container_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, media_db, id, name);
#line 570 "rygel-media-export-query-container.c"
}


static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 579 "rygel-media-export-query-container.c"
	{
		const gchar* _tmp0_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp0_ = self->priv->pattern;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (g_strcmp0 (_tmp0_, "") == 0) {
#line 586 "rygel-media-export-query-container.c"
			RygelMediaExportMediaCache* _tmp1_;
			RygelSearchExpression* _tmp2_;
			glong _tmp3_ = 0L;
			glong _tmp4_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp1_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp2_ = self->priv->expression;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp3_ = rygel_media_export_media_cache_get_object_count_by_search_expression (_tmp1_, _tmp2_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp4_ = _tmp3_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (_inner_error_ != NULL) {
#line 601 "rygel-media-export-query-container.c"
				goto __catch37_g_error;
			}
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			result = (gint) _tmp4_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			return result;
#line 608 "rygel-media-export-query-container.c"
		} else {
			RygelMediaExportMediaCache* _tmp5_;
			const gchar* _tmp6_;
			RygelSearchExpression* _tmp7_;
			GeeList* _tmp8_ = NULL;
			GeeList* data;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp5_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp6_ = self->priv->attribute;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp7_ = self->priv->expression;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp8_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (_tmp5_, _tmp6_, _tmp7_, (glong) 0, (guint) (-1), &_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			data = _tmp8_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (_inner_error_ != NULL) {
#line 630 "rygel-media-export-query-container.c"
				goto __catch37_g_error;
			}
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp9_ = data;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_tmp11_ = _tmp10_;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			result = _tmp11_;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (data);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			return result;
#line 645 "rygel-media-export-query-container.c"
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		e = _inner_error_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		result = 0;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_error_free0 (e);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return result;
#line 662 "rygel-media-export-query-container.c"
	}
	__finally37:
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_clear_error (&_inner_error_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return 0;
#line 671 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_real_search_data_free (gpointer _data) {
	RygelMediaExportQueryContainerSearchData* _data_;
	_data_ = _data;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->result);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_slice_free (RygelMediaExportQueryContainerSearchData, _data_);
#line 688 "rygel-media-export-query-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 695 "rygel-media-export-query-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 702 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerSearchData* _data_;
	RygelMediaExportQueryContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self = (RygelMediaExportQueryContainer*) base;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerSearchData);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_search);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_search_data_free);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = expression;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->expression = _tmp2_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp3_ = offset;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->offset = _tmp3_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp4_ = max_count;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->max_count = _tmp4_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp5_ = cancellable;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->cancellable = _tmp6_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	rygel_media_export_query_container_real_search_co (_data_);
#line 750 "rygel-media-export-query-container.c"
}


static RygelMediaObjects* rygel_media_export_query_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerSearchData* _data_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return NULL;
#line 761 "rygel-media-export-query-container.c"
	}
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (total_matches) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		*total_matches = _data_->total_matches;
#line 769 "rygel-media-export-query-container.c"
	}
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	result = _data_->result;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->result = NULL;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return result;
#line 777 "rygel-media-export-query-container.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return self ? g_error_copy (self) : NULL;
#line 784 "rygel-media-export-query-container.c"
}


static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* _data_) {
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	switch (_data_->_state_) {
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		case 0:
#line 793 "rygel-media-export-query-container.c"
		goto _state_0;
		default:
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_assert_not_reached ();
#line 798 "rygel-media-export-query-container.c"
	}
	_state_0:
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->children = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_tmp0_ = _data_->expression;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_tmp0_ == NULL) {
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp1_ = _data_->self->priv->expression;
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp2_ = _rygel_search_expression_ref0 (_data_->_tmp1_);
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (_data_->combined_expression);
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->combined_expression = _data_->_tmp2_;
#line 815 "rygel-media-export-query-container.c"
	} else {
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp3_ = rygel_logical_expression_new ();
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->local_expression = _data_->_tmp3_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp4_ = _data_->local_expression;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp5_ = _data_->self->priv->expression;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp6_ = _rygel_search_expression_ref0 (_data_->_tmp5_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp6_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp7_ = _data_->local_expression;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _data_->_tmp7_)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp8_ = _data_->local_expression;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp9_ = _data_->expression;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp10_ = _rygel_search_expression_ref0 (_data_->_tmp9_);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp8_)->operand2);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _data_->_tmp8_)->operand2 = _data_->_tmp10_;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp11_ = _data_->local_expression;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp12_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _data_->_tmp11_);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (_data_->combined_expression);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->combined_expression = _data_->_tmp12_;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (_data_->local_expression);
#line 855 "rygel-media-export-query-container.c"
	}
	{
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp13_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp14_ = _data_->combined_expression;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp15_ = _data_->offset;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp16_ = _data_->max_count;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp17_ = 0U;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp18_ = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp18_ = rygel_media_export_media_cache_get_objects_by_search_expression (_data_->_tmp13_, _data_->_tmp14_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, _data_->_tmp15_, _data_->_tmp16_, &_data_->_tmp17_, &_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->total_matches = _data_->_tmp17_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (_data_->_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
#line 880 "rygel-media-export-query-container.c"
				goto __catch38_rygel_media_export_media_cache_error;
			}
			goto __finally38;
		}
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->children);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->children = _data_->_tmp19_;
#line 889 "rygel-media-export-query-container.c"
	}
	goto __finally38;
	__catch38_rygel_media_export_media_cache_error:
	{
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_inner_error_ = NULL;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp20_ = _data_->_error_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (g_error_matches (_data_->_tmp20_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH)) {
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp21_ = rygel_media_objects_new ();
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (_data_->children);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->children = _data_->_tmp21_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->total_matches = (guint) 0;
#line 910 "rygel-media-export-query-container.c"
		} else {
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp22_ = _data_->_error_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp23_ = _g_error_copy0 (_data_->_tmp22_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_inner_error_ = _data_->_tmp23_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_error_free0 (_data_->_error_);
#line 920 "rygel-media-export-query-container.c"
			goto __finally38;
		}
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_error_free0 (_data_->_error_);
#line 925 "rygel-media-export-query-container.c"
	}
	__finally38:
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_error_free (_data_->_inner_error_);
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (_data_->combined_expression);
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->children);
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (_data_->_state_ == 0) {
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 942 "rygel-media-export-query-container.c"
		} else {
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 946 "rygel-media-export-query-container.c"
		}
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_object_unref (_data_->_async_result);
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return FALSE;
#line 952 "rygel-media-export-query-container.c"
	}
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->result = _data_->children;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_rygel_search_expression_unref0 (_data_->combined_expression);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_state_ == 0) {
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 962 "rygel-media-export-query-container.c"
	} else {
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 966 "rygel-media-export-query-container.c"
	}
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_object_unref (_data_->_async_result);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return FALSE;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_rygel_search_expression_unref0 (_data_->combined_expression);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->children);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_state_ == 0) {
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 980 "rygel-media-export-query-container.c"
	} else {
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 984 "rygel-media-export-query-container.c"
	}
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_object_unref (_data_->_async_result);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return FALSE;
#line 990 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data) {
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	_data_ = _data;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->result);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_slice_free (RygelMediaExportQueryContainerGetChildrenData, _data_);
#line 1005 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	RygelMediaExportQueryContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self = (RygelMediaExportQueryContainer*) base;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerGetChildrenData);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_get_children);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_get_children_data_free);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = offset;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->offset = _tmp1_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp2_ = max_count;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->max_count = _tmp2_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp3_ = cancellable;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->cancellable = _tmp4_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	rygel_media_export_query_container_real_get_children_co (_data_);
#line 1045 "rygel-media-export-query-container.c"
}


static RygelMediaObjects* rygel_media_export_query_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return NULL;
#line 1056 "rygel-media-export-query-container.c"
	}
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	result = _data_->result;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->result = NULL;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return result;
#line 1066 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportQueryContainerGetChildrenData* _data_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_ = _user_data_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_source_object_ = source_object;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_res_ = _res_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	rygel_media_export_query_container_real_get_children_co (_data_);
#line 1080 "rygel-media-export-query-container.c"
}


static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* _data_) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	switch (_data_->_state_) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		case 0:
#line 1089 "rygel-media-export-query-container.c"
		goto _state_0;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		case 1:
#line 1093 "rygel-media-export-query-container.c"
		goto _state_1;
		default:
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_assert_not_reached ();
#line 1098 "rygel-media-export-query-container.c"
	}
	_state_0:
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->_tmp0_ = _data_->self->priv->pattern;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (g_strcmp0 (_data_->_tmp0_, "") == 0) {
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp1_ = _data_->self->priv->expression;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp2_ = _data_->offset;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp3_ = _data_->max_count;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp4_ = _data_->cancellable;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp5_ = 0U;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_state_ = 1;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		rygel_media_export_db_container_search ((RygelMediaExportDBContainer*) _data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_media_export_query_container_get_children_ready, _data_);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return FALSE;
#line 1121 "rygel-media-export-query-container.c"
		_state_1:
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp6_ = NULL;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp6_ = rygel_media_export_db_container_search_finish ((RygelMediaExportDBContainer*) _data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->total_matches = _data_->_tmp5_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_error_free (_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (_data_->children);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (_data_->_state_ == 0) {
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1143 "rygel-media-export-query-container.c"
			} else {
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1147 "rygel-media-export-query-container.c"
			}
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_object_unref (_data_->_async_result);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			return FALSE;
#line 1153 "rygel-media-export-query-container.c"
		}
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->children);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->children = _data_->_tmp7_;
#line 1159 "rygel-media-export-query-container.c"
	} else {
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp8_ = rygel_media_objects_new ();
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->children);
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->children = _data_->_tmp8_;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp9_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp10_ = _data_->self->priv->attribute;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp11_ = _data_->self->priv->expression;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp12_ = _data_->offset;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp13_ = _data_->max_count;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp14_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp14_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, (glong) _data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->data = _data_->_tmp14_;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_error_free (_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (_data_->children);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (_data_->_state_ == 0) {
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1195 "rygel-media-export-query-container.c"
			} else {
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1199 "rygel-media-export-query-container.c"
			}
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			g_object_unref (_data_->_async_result);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			return FALSE;
#line 1205 "rygel-media-export-query-container.c"
		}
		{
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp15_ = _data_->data;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_meta_data_list = _data_->_tmp16_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp17_ = _data_->_meta_data_list;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp18_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp17_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_meta_data_size = _data_->_tmp19_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_meta_data_index = -1;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			while (TRUE) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp20_ = _data_->_meta_data_index;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_meta_data_index = _data_->_tmp20_ + 1;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp21_ = _data_->_meta_data_index;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp22_ = _data_->_meta_data_size;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
					break;
#line 1238 "rygel-media-export-query-container.c"
				}
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp23_ = _data_->_meta_data_list;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp24_ = _data_->_meta_data_index;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp25_ = NULL;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp25_ = gee_list_get (_data_->_tmp23_, _data_->_tmp24_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->meta_data = (gchar*) _data_->_tmp25_;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp26_ = _data_->meta_data;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp27_ = NULL;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp27_ = g_uri_escape_string (_data_->_tmp26_, "", TRUE);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->new_id = _data_->_tmp27_;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp28_ = _data_->self->priv->pattern;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp29_ = _data_->new_id;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp30_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp30_ = string_replace (_data_->_tmp28_, "%s", _data_->_tmp29_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_g_free0 (_data_->new_id);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->new_id = _data_->_tmp30_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				rygel_media_export_query_container_register_id (&_data_->new_id);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp31_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp32_ = _data_->new_id;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp33_ = _data_->meta_data;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp34_ = rygel_media_export_query_container_new (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->container = _data_->_tmp34_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp35_ = _data_->children;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_data_->_tmp36_ = _data_->container;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp35_, (RygelMediaObject*) _data_->_tmp36_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_g_object_unref0 (_data_->container);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_g_free0 (_data_->new_id);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				_g_free0 (_data_->meta_data);
#line 1294 "rygel-media-export-query-container.c"
			}
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (_data_->_meta_data_list);
#line 1298 "rygel-media-export-query-container.c"
		}
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->data);
#line 1302 "rygel-media-export-query-container.c"
	}
	{
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp37_ = _data_->children;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp38_ = _g_object_ref0 (_data_->_tmp37_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_child_list = _data_->_tmp38_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp39_ = _data_->_child_list;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp40_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp39_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_child_size = _data_->_tmp41_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_data_->_child_index = -1;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		while (TRUE) {
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp42_ = _data_->_child_index;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_child_index = _data_->_tmp42_ + 1;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp43_ = _data_->_child_index;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp44_ = _data_->_child_size;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			if (!(_data_->_tmp43_ < _data_->_tmp44_)) {
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
				break;
#line 1335 "rygel-media-export-query-container.c"
			}
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp45_ = _data_->_child_list;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp46_ = _data_->_child_index;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp47_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp45_, _data_->_tmp46_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp47_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp48_ = _data_->child;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_data_->_tmp48_->parent = (RygelMediaContainer*) _data_->self;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
			_g_object_unref0 (_data_->child);
#line 1353 "rygel-media-export-query-container.c"
		}
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1357 "rygel-media-export-query-container.c"
	}
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_data_->result = _data_->children;
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1365 "rygel-media-export-query-container.c"
	} else {
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1369 "rygel-media-export-query-container.c"
	}
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return FALSE;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_object_unref0 (_data_->children);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_data_->_state_ == 0) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1381 "rygel-media-export-query-container.c"
	} else {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1385 "rygel-media-export-query-container.c"
	}
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_object_unref (_data_->_async_result);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return FALSE;
#line 1391 "rygel-media-export-query-container.c"
}


void rygel_media_export_query_container_register_id (gchar** id) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* md5;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_if_fail (id != NULL);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = *id;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	md5 = _tmp1_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp2_ = rygel_media_export_query_container_virtual_container_map;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_tmp2_ == NULL) {
#line 1417 "rygel-media-export-query-container.c"
		GeeHashMap* _tmp3_;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_object_unref0 (rygel_media_export_query_container_virtual_container_map);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		rygel_media_export_query_container_virtual_container_map = _tmp3_;
#line 1425 "rygel-media-export-query-container.c"
	}
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp4_ = rygel_media_export_query_container_virtual_container_map;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp5_ = md5;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (!_tmp6_) {
#line 1435 "rygel-media-export-query-container.c"
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp7_ = rygel_media_export_query_container_virtual_container_map;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp8_ = md5;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp9_ = *id;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, _tmp8_, _tmp9_);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp10_ = md5;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp11_ = *id;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		g_debug ("rygel-media-export-query-container.vala:191: Registering %s for %s", _tmp10_, _tmp11_);
#line 1455 "rygel-media-export-query-container.c"
	}
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp12_ = md5;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp13_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp12_, NULL);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (*id);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	*id = _tmp13_;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (md5);
#line 1467 "rygel-media-export-query-container.c"
}


gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	gboolean _tmp7_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_val_if_fail (hash != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = hash;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = string_replace (_tmp0_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	id = _tmp1_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp3_ = rygel_media_export_query_container_virtual_container_map;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_tmp3_ != NULL) {
#line 1491 "rygel-media-export-query-container.c"
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp4_ = rygel_media_export_query_container_virtual_container_map;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp5_ = id;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp2_ = _tmp6_;
#line 1503 "rygel-media-export-query-container.c"
	} else {
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp2_ = FALSE;
#line 1507 "rygel-media-export-query-container.c"
	}
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp7_ = _tmp2_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_tmp7_) {
#line 1513 "rygel-media-export-query-container.c"
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp8_ = rygel_media_export_query_container_virtual_container_map;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp9_ = id;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		result = (gchar*) _tmp10_;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_g_free0 (id);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		return result;
#line 1529 "rygel-media-export-query-container.c"
	}
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	result = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (id);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	return result;
#line 1537 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2) {
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* exp;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* op1;
	RygelRelationalExpression* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	RygelRelationalExpression* _tmp6_;
	RygelRelationalExpression* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	RygelSearchExpression* _tmp10_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_if_fail (op1_ != NULL);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_return_if_fail (op2 != NULL);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = rygel_relational_expression_new ();
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	exp = _tmp0_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp1_ = op1_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp2_ = string_replace (_tmp1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	op1 = _tmp2_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp3_ = exp;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp4_ = op1;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp5_ = g_uri_unescape_string (_tmp4_, NULL);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (((RygelSearchExpression*) _tmp3_)->operand1);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	((RygelSearchExpression*) _tmp3_)->operand1 = _tmp5_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp6_ = exp;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	((RygelSearchExpression*) _tmp6_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp7_ = exp;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp8_ = op2;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (((RygelSearchExpression*) _tmp7_)->operand2);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	((RygelSearchExpression*) _tmp7_)->operand2 = _tmp9_;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp10_ = self->priv->expression;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	if (_tmp10_ != NULL) {
#line 1599 "rygel-media-export-query-container.c"
		RygelLogicalExpression* _tmp11_;
		RygelLogicalExpression* exp2;
		RygelLogicalExpression* _tmp12_;
		RygelSearchExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		RygelLogicalExpression* _tmp15_;
		RygelRelationalExpression* _tmp16_;
		RygelSearchExpression* _tmp17_;
		RygelLogicalExpression* _tmp18_;
		RygelLogicalExpression* _tmp19_;
		RygelSearchExpression* _tmp20_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp11_ = rygel_logical_expression_new ();
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		exp2 = _tmp11_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp12_ = exp2;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp13_ = self->priv->expression;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp14_ = _rygel_search_expression_ref0 (_tmp13_);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp12_)->operand1);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _tmp12_)->operand1 = _tmp14_;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp15_ = exp2;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp16_ = exp;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp17_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp16_);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp15_)->operand2);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _tmp15_)->operand2 = _tmp17_;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp18_ = exp2;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		((RygelSearchExpression*) _tmp18_)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp19_ = exp2;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp20_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp19_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (self->priv->expression);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		self->priv->expression = _tmp20_;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (exp2);
#line 1649 "rygel-media-export-query-container.c"
	} else {
		RygelRelationalExpression* _tmp21_;
		RygelSearchExpression* _tmp22_;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp21_ = exp;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_tmp22_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp21_);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		_rygel_search_expression_unref0 (self->priv->expression);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
		self->priv->expression = _tmp22_;
#line 1661 "rygel-media-export-query-container.c"
	}
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (op1);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_rygel_search_expression_unref0 (exp);
#line 1667 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_class_init (RygelMediaExportQueryContainerClass * klass) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	rygel_media_export_query_container_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerPrivate));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_query_container_real_search;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_query_container_real_search_finish;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_export_query_container_real_get_children;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_export_query_container_real_get_children_finish;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_finalize;
#line 1686 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_instance_init (RygelMediaExportQueryContainer * self) {
	gchar* _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE (self);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_tmp0_ = g_strdup ("");
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self->priv->pattern = _tmp0_;
#line 1698 "rygel-media-export-query-container.c"
}


static void rygel_media_export_query_container_finalize (GObject* obj) {
	RygelMediaExportQueryContainer * self;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	self = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER (obj);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (self->priv->attribute);
#line 27 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_rygel_search_expression_unref0 (self->priv->expression);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (self->plaintext_id);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	_g_free0 (self->priv->pattern);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-query-container.vala"
	G_OBJECT_CLASS (rygel_media_export_query_container_parent_class)->finalize (obj);
#line 1716 "rygel-media-export-query-container.c"
}


GType rygel_media_export_query_container_get_type (void) {
	static volatile gsize rygel_media_export_query_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainer), 0, (GInstanceInitFunc) rygel_media_export_query_container_instance_init, NULL };
		GType rygel_media_export_query_container_type_id;
		rygel_media_export_query_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportQueryContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_type_id__volatile, rygel_media_export_query_container_type_id);
	}
	return rygel_media_export_query_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



