/* minefield.c generated by valac 0.14.1, the Vala compiler
 * generated from minefield.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _LocationPrivate LocationPrivate;
typedef struct _ParamSpecLocation ParamSpecLocation;

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
typedef struct _MinefieldPrivate MinefieldPrivate;
#define _location_unref0(var) ((var == NULL) ? NULL : (var = (location_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecMinefield ParamSpecMinefield;

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Location {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LocationPrivate * priv;
	gboolean has_mine;
	gboolean cleared;
	FlagType flag;
};

struct _LocationClass {
	GTypeClass parent_class;
	void (*finalize) (Location *self);
};

struct _ParamSpecLocation {
	GParamSpec parent_instance;
};

struct _Neighbour {
	gint x;
	gint y;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

struct _MinefieldPrivate {
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean placed_mines;
};

struct _ParamSpecMinefield {
	GParamSpec parent_instance;
};


static gpointer location_parent_class = NULL;
static gpointer minefield_parent_class = NULL;

GType flag_type_get_type (void) G_GNUC_CONST;
gpointer location_ref (gpointer instance);
void location_unref (gpointer instance);
GParamSpec* param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_location (GValue* value, gpointer v_object);
void value_take_location (GValue* value, gpointer v_object);
gpointer value_get_location (const GValue* value);
GType location_get_type (void) G_GNUC_CONST;
enum  {
	LOCATION_DUMMY_PROPERTY
};
Location* location_new (void);
Location* location_construct (GType object_type);
static void location_finalize (Location* obj);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD, MinefieldPrivate))
enum  {
	MINEFIELD_DUMMY_PROPERTY
};
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
gboolean minefield_is_location (Minefield* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static void minefield_place_mines (Minefield* self, guint x, guint y);
static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y);
gboolean minefield_get_is_complete (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
void minefield_hint (Minefield* self, guint* x, guint* y);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_cleared (Minefield* self);
guint minefield_get_n_flags (Minefield* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void minefield_finalize (Minefield* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const Neighbour neighbour_map[8] = {{-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}};

GType flag_type_get_type (void) {
	static volatile gsize flag_type_type_id__volatile = 0;
	if (g_once_init_enter (&flag_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FLAG_TYPE_NONE, "FLAG_TYPE_NONE", "none"}, {FLAG_TYPE_FLAG, "FLAG_TYPE_FLAG", "flag"}, {FLAG_TYPE_MAYBE, "FLAG_TYPE_MAYBE", "maybe"}, {0, NULL, NULL}};
		GType flag_type_type_id;
		flag_type_type_id = g_enum_register_static ("FlagType", values);
		g_once_init_leave (&flag_type_type_id__volatile, flag_type_type_id);
	}
	return flag_type_type_id__volatile;
}


Location* location_construct (GType object_type) {
	Location* self = NULL;
	self = (Location*) g_type_create_instance (object_type);
	return self;
}


Location* location_new (void) {
	return location_construct (TYPE_LOCATION);
}


static void value_location_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_location_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		location_unref (value->data[0].v_pointer);
	}
}


static void value_location_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_location_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_location_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Location* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_location_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Location** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = location_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_location (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_location (GValue* value, gpointer v_object) {
	Location* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		location_unref (old);
	}
}


void value_take_location (GValue* value, gpointer v_object) {
	Location* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		location_unref (old);
	}
}


static void location_class_init (LocationClass * klass) {
	location_parent_class = g_type_class_peek_parent (klass);
	LOCATION_CLASS (klass)->finalize = location_finalize;
}


static void location_instance_init (Location * self) {
	self->has_mine = FALSE;
	self->cleared = FALSE;
	self->flag = FLAG_TYPE_NONE;
	self->ref_count = 1;
}


static void location_finalize (Location* obj) {
	Location * self;
	self = LOCATION (obj);
}


GType location_get_type (void) {
	static volatile gsize location_type_id__volatile = 0;
	if (g_once_init_enter (&location_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_location_init, value_location_free_value, value_location_copy_value, value_location_peek_pointer, "p", value_location_collect_value, "p", value_location_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Location), 0, (GInstanceInitFunc) location_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType location_type_id;
		location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Location", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&location_type_id__volatile, location_type_id);
	}
	return location_type_id__volatile;
}


gpointer location_ref (gpointer instance) {
	Location* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void location_unref (gpointer instance) {
	Location* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Neighbour* neighbour_dup (const Neighbour* self) {
	Neighbour* dup;
	dup = g_new0 (Neighbour, 1);
	memcpy (dup, self, sizeof (Neighbour));
	return dup;
}


void neighbour_free (Neighbour* self) {
	g_free (self);
}


GType neighbour_get_type (void) {
	static volatile gsize neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&neighbour_type_id__volatile)) {
		GType neighbour_type_id;
		neighbour_type_id = g_boxed_type_register_static ("Neighbour", (GBoxedCopyFunc) neighbour_dup, (GBoxedFreeFunc) neighbour_free);
		g_once_init_leave (&neighbour_type_id__volatile, neighbour_type_id);
	}
	return neighbour_type_id__volatile;
}


Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines) {
	Minefield* self = NULL;
	guint _tmp0_;
	guint _tmp1_;
	Location** _tmp2_ = NULL;
	guint _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	self = (Minefield*) g_type_create_instance (object_type);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_new0 (Location*, (_tmp0_ * _tmp1_) + 1);
	self->priv->locations = (_vala_array_free (self->priv->locations, self->priv->locations_length1 * self->priv->locations_length2, (GDestroyNotify) location_unref), NULL);
	self->priv->locations = _tmp2_;
	self->priv->locations_length1 = _tmp0_;
	self->priv->locations_length2 = _tmp1_;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint _tmp7_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = width;
				if (!(((guint) _tmp6_) < _tmp7_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_;
							gint _tmp11_;
							guint _tmp12_;
							Location** _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							gint _tmp14_;
							gint _tmp15_;
							Location* _tmp16_;
							Location* _tmp17_;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = y;
								y = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = y;
							_tmp12_ = height;
							if (!(((guint) _tmp11_) < _tmp12_)) {
								break;
							}
							_tmp13_ = self->priv->locations;
							_tmp13__length1 = self->priv->locations_length1;
							_tmp13__length2 = self->priv->locations_length2;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = location_new ();
							_location_unref0 (_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_]);
							_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = _tmp16_;
							_tmp17_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
						}
					}
				}
			}
		}
	}
	_tmp18_ = width;
	self->width = _tmp18_;
	_tmp19_ = height;
	self->height = _tmp19_;
	_tmp20_ = n_mines;
	self->n_mines = _tmp20_;
	return self;
}


Minefield* minefield_new (guint width, guint height, guint n_mines) {
	return minefield_construct (TYPE_MINEFIELD, width, height, n_mines);
}


gboolean minefield_has_mine (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint _tmp1_;
	guint _tmp2_;
	Location* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->has_mine;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_cleared (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint _tmp1_;
	guint _tmp2_;
	Location* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	result = _tmp4_;
	return result;
}


gboolean minefield_is_location (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= ((guint) 0)) {
		guint _tmp4_;
		_tmp4_ = y;
		_tmp2_ = _tmp4_ >= ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		guint _tmp6_;
		guint _tmp7_;
		_tmp6_ = x;
		_tmp7_ = self->width;
		_tmp1_ = _tmp6_ < _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		guint _tmp9_;
		guint _tmp10_;
		_tmp9_ = y;
		_tmp10_ = self->height;
		_tmp0_ = _tmp9_ < _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = _tmp0_;
	result = _tmp11_;
	return result;
}


void minefield_clear_mine (Minefield* self, guint x, guint y) {
	gboolean _tmp0_;
	gboolean _tmp3_ = FALSE;
	Location** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	guint _tmp5_;
	guint _tmp6_;
	Location* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	Location** _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	guint _tmp18_;
	guint _tmp19_;
	Location* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->placed_mines;
	if (!_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = x;
		_tmp2_ = y;
		minefield_place_mines (self, _tmp1_, _tmp2_);
		self->priv->placed_mines = TRUE;
	}
	_tmp4_ = self->priv->locations;
	_tmp4__length1 = self->priv->locations_length1;
	_tmp4__length2 = self->priv->locations_length2;
	_tmp5_ = x;
	_tmp6_ = y;
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
	_tmp8_ = _tmp7_->cleared;
	if (_tmp8_) {
		_tmp3_ = TRUE;
	} else {
		Location** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		guint _tmp10_;
		guint _tmp11_;
		Location* _tmp12_;
		FlagType _tmp13_;
		_tmp9_ = self->priv->locations;
		_tmp9__length1 = self->priv->locations_length1;
		_tmp9__length2 = self->priv->locations_length2;
		_tmp10_ = x;
		_tmp11_ = y;
		_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
		_tmp13_ = _tmp12_->flag;
		_tmp3_ = _tmp13_ == FLAG_TYPE_FLAG;
	}
	_tmp14_ = _tmp3_;
	if (_tmp14_) {
		return;
	}
	_tmp15_ = x;
	_tmp16_ = y;
	minefield_clear_mines_recursive (self, _tmp15_, _tmp16_);
	_tmp17_ = self->priv->locations;
	_tmp17__length1 = self->priv->locations_length1;
	_tmp17__length2 = self->priv->locations_length2;
	_tmp18_ = x;
	_tmp19_ = y;
	_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
	_tmp21_ = _tmp20_->has_mine;
	if (_tmp21_) {
		gboolean _tmp22_;
		_tmp22_ = self->exploded;
		if (!_tmp22_) {
			self->exploded = TRUE;
			g_signal_emit_by_name (self, "explode");
		}
		return;
	}
	_tmp23_ = minefield_get_is_complete (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		{
			gint tx;
			tx = 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp26_;
					gint _tmp28_;
					guint _tmp29_;
					_tmp26_ = _tmp25_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = tx;
						tx = _tmp27_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp28_ = tx;
					_tmp29_ = self->width;
					if (!(((guint) _tmp28_) < _tmp29_)) {
						break;
					}
					{
						gint ty;
						ty = 0;
						{
							gboolean _tmp30_;
							_tmp30_ = TRUE;
							while (TRUE) {
								gboolean _tmp31_;
								gint _tmp33_;
								guint _tmp34_;
								gint _tmp35_;
								gint _tmp36_;
								gboolean _tmp37_ = FALSE;
								_tmp31_ = _tmp30_;
								if (!_tmp31_) {
									gint _tmp32_;
									_tmp32_ = ty;
									ty = _tmp32_ + 1;
								}
								_tmp30_ = FALSE;
								_tmp33_ = ty;
								_tmp34_ = self->height;
								if (!(((guint) _tmp33_) < _tmp34_)) {
									break;
								}
								_tmp35_ = tx;
								_tmp36_ = ty;
								_tmp37_ = minefield_has_mine (self, (guint) _tmp35_, (guint) _tmp36_);
								if (_tmp37_) {
									gint _tmp38_;
									gint _tmp39_;
									_tmp38_ = tx;
									_tmp39_ = ty;
									minefield_set_flag (self, (guint) _tmp38_, (guint) _tmp39_, FLAG_TYPE_FLAG);
								}
							}
						}
					}
				}
			}
		}
		g_signal_emit_by_name (self, "cleared");
	}
}


static void minefield_clear_mines_recursive (Minefield* self, guint x, guint y) {
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint _tmp1_;
	guint _tmp2_;
	Location* _tmp3_;
	gboolean _tmp4_;
	Location** _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	guint _tmp6_;
	guint _tmp7_;
	Location* _tmp8_;
	Location** _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	guint _tmp10_;
	guint _tmp11_;
	Location* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_ = FALSE;
	Location** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	guint _tmp17_;
	guint _tmp18_;
	Location* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->cleared;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->locations;
	_tmp5__length1 = self->priv->locations_length1;
	_tmp5__length2 = self->priv->locations_length2;
	_tmp6_ = x;
	_tmp7_ = y;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp8_->cleared = TRUE;
	_tmp9_ = self->priv->locations;
	_tmp9__length1 = self->priv->locations_length1;
	_tmp9__length2 = self->priv->locations_length2;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
	_tmp12_->flag = FLAG_TYPE_NONE;
	_tmp13_ = x;
	_tmp14_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp13_, _tmp14_);
	g_signal_emit_by_name (self, "marks-changed");
	_tmp16_ = self->priv->locations;
	_tmp16__length1 = self->priv->locations_length1;
	_tmp16__length2 = self->priv->locations_length2;
	_tmp17_ = x;
	_tmp18_ = y;
	_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
	_tmp20_ = _tmp19_->has_mine;
	if (!_tmp20_) {
		guint _tmp21_;
		guint _tmp22_;
		guint _tmp23_ = 0U;
		_tmp21_ = x;
		_tmp22_ = y;
		_tmp23_ = minefield_get_n_adjacent_mines (self, _tmp21_, _tmp22_);
		_tmp15_ = _tmp23_ == ((guint) 0);
	} else {
		_tmp15_ = FALSE;
	}
	_tmp24_ = _tmp15_;
	if (_tmp24_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					guint _tmp25_;
					Neighbour _tmp26_;
					gint _tmp27_;
					guint nx;
					guint _tmp28_;
					Neighbour _tmp29_;
					gint _tmp30_;
					guint ny;
					guint _tmp31_;
					guint _tmp32_;
					gboolean _tmp33_ = FALSE;
					_tmp25_ = x;
					_tmp26_ = neighbour;
					_tmp27_ = _tmp26_.x;
					nx = _tmp25_ + _tmp27_;
					_tmp28_ = y;
					_tmp29_ = neighbour;
					_tmp30_ = _tmp29_.y;
					ny = _tmp28_ + _tmp30_;
					_tmp31_ = nx;
					_tmp32_ = ny;
					_tmp33_ = minefield_is_location (self, _tmp31_, _tmp32_);
					if (_tmp33_) {
						guint _tmp34_;
						guint _tmp35_;
						_tmp34_ = nx;
						_tmp35_ = ny;
						minefield_clear_mines_recursive (self, _tmp34_, _tmp35_);
					}
				}
			}
		}
	}
}


void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag) {
	gboolean _tmp0_ = FALSE;
	Location** _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint _tmp2_;
	guint _tmp3_;
	Location* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp12_;
	Location** _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	guint _tmp14_;
	guint _tmp15_;
	Location* _tmp16_;
	FlagType _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->locations;
	_tmp1__length1 = self->priv->locations_length1;
	_tmp1__length2 = self->priv->locations_length2;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = _tmp1_[(_tmp2_ * _tmp1__length2) + _tmp3_];
	_tmp5_ = _tmp4_->cleared;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Location** _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		guint _tmp7_;
		guint _tmp8_;
		Location* _tmp9_;
		FlagType _tmp10_;
		FlagType _tmp11_;
		_tmp6_ = self->priv->locations;
		_tmp6__length1 = self->priv->locations_length1;
		_tmp6__length2 = self->priv->locations_length2;
		_tmp7_ = x;
		_tmp8_ = y;
		_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
		_tmp10_ = _tmp9_->flag;
		_tmp11_ = flag;
		_tmp0_ = _tmp10_ == _tmp11_;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->locations;
	_tmp13__length1 = self->priv->locations_length1;
	_tmp13__length2 = self->priv->locations_length2;
	_tmp14_ = x;
	_tmp15_ = y;
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
	_tmp17_ = flag;
	_tmp16_->flag = _tmp17_;
	_tmp18_ = x;
	_tmp19_ = y;
	g_signal_emit_by_name (self, "redraw-sector", _tmp18_, _tmp19_);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp20_;
				Neighbour _tmp21_;
				gint _tmp22_;
				guint nx;
				guint _tmp23_;
				Neighbour _tmp24_;
				gint _tmp25_;
				guint ny;
				gboolean _tmp26_ = FALSE;
				guint _tmp27_;
				guint _tmp28_;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp33_;
				_tmp20_ = x;
				_tmp21_ = neighbour;
				_tmp22_ = _tmp21_.x;
				nx = _tmp20_ + _tmp22_;
				_tmp23_ = y;
				_tmp24_ = neighbour;
				_tmp25_ = _tmp24_.y;
				ny = _tmp23_ + _tmp25_;
				_tmp27_ = nx;
				_tmp28_ = ny;
				_tmp29_ = minefield_is_location (self, _tmp27_, _tmp28_);
				if (_tmp29_) {
					guint _tmp30_;
					guint _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp30_ = nx;
					_tmp31_ = ny;
					_tmp32_ = minefield_is_cleared (self, _tmp30_, _tmp31_);
					_tmp26_ = _tmp32_;
				} else {
					_tmp26_ = FALSE;
				}
				_tmp33_ = _tmp26_;
				if (_tmp33_) {
					guint _tmp34_;
					guint _tmp35_;
					_tmp34_ = nx;
					_tmp35_ = ny;
					g_signal_emit_by_name (self, "redraw-sector", _tmp34_, _tmp35_);
				}
			}
		}
	}
	g_signal_emit_by_name (self, "marks-changed");
}


FlagType minefield_get_flag (Minefield* self, guint x, guint y) {
	FlagType result = 0;
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	guint _tmp1_;
	guint _tmp2_;
	Location* _tmp3_;
	FlagType _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->locations;
	_tmp0__length1 = self->priv->locations_length1;
	_tmp0__length2 = self->priv->locations_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _tmp3_->flag;
	result = _tmp4_;
	return result;
}


static gpointer _location_ref0 (gpointer self) {
	return self ? location_ref (self) : NULL;
}


void minefield_hint (Minefield* self, guint* x, guint* y) {
	guint _vala_x = 0U;
	guint _vala_y = 0U;
	GList* case1list;
	GList* case2list;
	GList* case3list;
	guint hint_location;
	GList* _tmp53_;
	guint _tmp54_ = 0U;
	guint _tmp74_;
	guint _tmp75_;
	guint _tmp76_;
	guint _tmp77_;
	g_return_if_fail (self != NULL);
	case1list = NULL;
	case2list = NULL;
	case3list = NULL;
	{
		gint mx;
		mx = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = mx;
					mx = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = mx;
				_tmp4_ = self->width;
				if (!(((guint) _tmp3_) < _tmp4_)) {
					break;
				}
				{
					gint my;
					my = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							guint _tmp9_;
							Location** _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint _tmp11_;
							gint _tmp12_;
							Location* _tmp13_;
							Location* _tmp14_;
							Location* m;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp16_ = FALSE;
							Location* _tmp17_;
							gboolean _tmp18_;
							gboolean _tmp21_;
							gboolean _tmp24_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = my;
								my = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = my;
							_tmp9_ = self->height;
							if (!(((guint) _tmp8_) < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->locations;
							_tmp10__length1 = self->priv->locations_length1;
							_tmp10__length2 = self->priv->locations_length2;
							_tmp11_ = mx;
							_tmp12_ = my;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							_tmp14_ = _location_ref0 (_tmp13_);
							m = _tmp14_;
							_tmp17_ = m;
							_tmp18_ = _tmp17_->has_mine;
							if (!_tmp18_) {
								Location* _tmp19_;
								gboolean _tmp20_;
								_tmp19_ = m;
								_tmp20_ = _tmp19_->cleared;
								_tmp16_ = !_tmp20_;
							} else {
								_tmp16_ = FALSE;
							}
							_tmp21_ = _tmp16_;
							if (_tmp21_) {
								Location* _tmp22_;
								FlagType _tmp23_;
								_tmp22_ = m;
								_tmp23_ = _tmp22_->flag;
								_tmp15_ = _tmp23_ == FLAG_TYPE_NONE;
							} else {
								_tmp15_ = FALSE;
							}
							_tmp24_ = _tmp15_;
							if (_tmp24_) {
								gint _tmp25_;
								guint _tmp26_;
								gint _tmp27_;
								gint _tmp28_;
								gint _tmp29_;
								guint _tmp30_ = 0U;
								_tmp25_ = mx;
								_tmp26_ = self->width;
								_tmp27_ = my;
								case3list = g_list_append (case3list, GUINT_TO_POINTER ((_tmp25_ * _tmp26_) + _tmp27_));
								_tmp28_ = mx;
								_tmp29_ = my;
								_tmp30_ = minefield_get_n_adjacent_mines (self, (guint) _tmp28_, (guint) _tmp29_);
								if (_tmp30_ > ((guint) 0)) {
									gint _tmp31_;
									guint _tmp32_;
									gint _tmp33_;
									_tmp31_ = mx;
									_tmp32_ = self->width;
									_tmp33_ = my;
									case2list = g_list_append (case2list, GUINT_TO_POINTER ((_tmp31_ * _tmp32_) + _tmp33_));
									{
										Neighbour* neighbour_collection = NULL;
										gint neighbour_collection_length1 = 0;
										gint _neighbour_collection_size_ = 0;
										gint neighbour_it = 0;
										neighbour_collection = neighbour_map;
										neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
										for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
											Neighbour neighbour = {0};
											neighbour = neighbour_collection[neighbour_it];
											{
												gint _tmp34_;
												Neighbour _tmp35_;
												gint _tmp36_;
												gint _tmp37_;
												Neighbour _tmp38_;
												gint _tmp39_;
												gboolean _tmp40_ = FALSE;
												Location** _tmp41_;
												gint _tmp41__length1;
												gint _tmp41__length2;
												gint _tmp42_;
												Neighbour _tmp43_;
												gint _tmp44_;
												gint _tmp45_;
												Neighbour _tmp46_;
												gint _tmp47_;
												Location* _tmp48_;
												gboolean _tmp49_;
												_tmp34_ = mx;
												_tmp35_ = neighbour;
												_tmp36_ = _tmp35_.x;
												_tmp37_ = my;
												_tmp38_ = neighbour;
												_tmp39_ = _tmp38_.y;
												_tmp40_ = minefield_is_location (self, (guint) (_tmp34_ + _tmp36_), (guint) (_tmp37_ + _tmp39_));
												if (!_tmp40_) {
													continue;
												}
												_tmp41_ = self->priv->locations;
												_tmp41__length1 = self->priv->locations_length1;
												_tmp41__length2 = self->priv->locations_length2;
												_tmp42_ = mx;
												_tmp43_ = neighbour;
												_tmp44_ = _tmp43_.x;
												_tmp45_ = my;
												_tmp46_ = neighbour;
												_tmp47_ = _tmp46_.y;
												_tmp48_ = _tmp41_[((_tmp42_ + _tmp44_) * _tmp41__length2) + (_tmp45_ + _tmp47_)];
												_tmp49_ = _tmp48_->cleared;
												if (_tmp49_) {
													gint _tmp50_;
													guint _tmp51_;
													gint _tmp52_;
													_tmp50_ = mx;
													_tmp51_ = self->width;
													_tmp52_ = my;
													case1list = g_list_append (case1list, GUINT_TO_POINTER ((_tmp50_ * _tmp51_) + _tmp52_));
													break;
												}
											}
										}
									}
								}
							}
							_location_unref0 (m);
						}
					}
				}
			}
		}
	}
	hint_location = (guint) 0;
	_tmp53_ = case1list;
	_tmp54_ = g_list_length (_tmp53_);
	if (_tmp54_ > ((guint) 0)) {
		GList* _tmp55_;
		GList* _tmp56_;
		guint _tmp57_ = 0U;
		gint32 _tmp58_ = 0;
		gconstpointer _tmp59_ = NULL;
		_tmp55_ = case1list;
		_tmp56_ = case1list;
		_tmp57_ = g_list_length (_tmp56_);
		_tmp58_ = g_random_int_range ((gint32) 0, (gint32) _tmp57_);
		_tmp59_ = g_list_nth_data (_tmp55_, (guint) _tmp58_);
		hint_location = GPOINTER_TO_UINT (_tmp59_);
	} else {
		GList* _tmp60_;
		guint _tmp61_ = 0U;
		_tmp60_ = case2list;
		_tmp61_ = g_list_length (_tmp60_);
		if (_tmp61_ > ((guint) 0)) {
			GList* _tmp62_;
			GList* _tmp63_;
			guint _tmp64_ = 0U;
			gint32 _tmp65_ = 0;
			gconstpointer _tmp66_ = NULL;
			_tmp62_ = case2list;
			_tmp63_ = case2list;
			_tmp64_ = g_list_length (_tmp63_);
			_tmp65_ = g_random_int_range ((gint32) 0, (gint32) _tmp64_);
			_tmp66_ = g_list_nth_data (_tmp62_, (guint) _tmp65_);
			hint_location = GPOINTER_TO_UINT (_tmp66_);
		} else {
			GList* _tmp67_;
			guint _tmp68_ = 0U;
			_tmp67_ = case3list;
			_tmp68_ = g_list_length (_tmp67_);
			if (_tmp68_ > ((guint) 0)) {
				GList* _tmp69_;
				GList* _tmp70_;
				guint _tmp71_ = 0U;
				gint32 _tmp72_ = 0;
				gconstpointer _tmp73_ = NULL;
				_tmp69_ = case3list;
				_tmp70_ = case3list;
				_tmp71_ = g_list_length (_tmp70_);
				_tmp72_ = g_random_int_range ((gint32) 0, (gint32) _tmp71_);
				_tmp73_ = g_list_nth_data (_tmp69_, (guint) _tmp72_);
				hint_location = GPOINTER_TO_UINT (_tmp73_);
			}
		}
	}
	_tmp74_ = hint_location;
	_tmp75_ = self->width;
	_vala_x = _tmp74_ / _tmp75_;
	_tmp76_ = hint_location;
	_tmp77_ = self->width;
	_vala_y = _tmp76_ % _tmp77_;
	_g_list_free0 (case3list);
	_g_list_free0 (case2list);
	_g_list_free0 (case1list);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y) {
	guint result = 0U;
	guint n;
	g_return_val_if_fail (self != NULL, 0U);
	n = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp0_;
				Neighbour _tmp1_;
				gint _tmp2_;
				guint nx;
				guint _tmp3_;
				Neighbour _tmp4_;
				gint _tmp5_;
				guint ny;
				gboolean _tmp6_ = FALSE;
				guint _tmp7_;
				guint _tmp8_;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp13_;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = _tmp0_ + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = _tmp3_ + _tmp5_;
				_tmp7_ = nx;
				_tmp8_ = ny;
				_tmp9_ = minefield_is_location (self, _tmp7_, _tmp8_);
				if (_tmp9_) {
					guint _tmp10_;
					guint _tmp11_;
					gboolean _tmp12_ = FALSE;
					_tmp10_ = nx;
					_tmp11_ = ny;
					_tmp12_ = minefield_has_mine (self, _tmp10_, _tmp11_);
					_tmp6_ = _tmp12_;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp13_ = _tmp6_;
				if (_tmp13_) {
					guint _tmp14_;
					_tmp14_ = n;
					n = _tmp14_ + 1;
				}
			}
		}
	}
	result = n;
	return result;
}


gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	guint n_mines;
	guint n_flags;
	guint _tmp20_;
	guint _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = minefield_is_cleared (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	n_mines = (guint) 0;
	n_flags = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp3_;
				Neighbour _tmp4_;
				gint _tmp5_;
				guint nx;
				guint _tmp6_;
				Neighbour _tmp7_;
				gint _tmp8_;
				guint ny;
				guint _tmp9_;
				guint _tmp10_;
				gboolean _tmp11_ = FALSE;
				guint _tmp12_;
				guint _tmp13_;
				gboolean _tmp14_ = FALSE;
				guint _tmp16_;
				guint _tmp17_;
				FlagType _tmp18_ = 0;
				_tmp3_ = x;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.x;
				nx = _tmp3_ + _tmp5_;
				_tmp6_ = y;
				_tmp7_ = neighbour;
				_tmp8_ = _tmp7_.y;
				ny = _tmp6_ + _tmp8_;
				_tmp9_ = nx;
				_tmp10_ = ny;
				_tmp11_ = minefield_is_location (self, _tmp9_, _tmp10_);
				if (!_tmp11_) {
					continue;
				}
				_tmp12_ = nx;
				_tmp13_ = ny;
				_tmp14_ = minefield_has_mine (self, _tmp12_, _tmp13_);
				if (_tmp14_) {
					guint _tmp15_;
					_tmp15_ = n_mines;
					n_mines = _tmp15_ + 1;
				}
				_tmp16_ = nx;
				_tmp17_ = ny;
				_tmp18_ = minefield_get_flag (self, _tmp16_, _tmp17_);
				if (_tmp18_ == FLAG_TYPE_FLAG) {
					guint _tmp19_;
					_tmp19_ = n_flags;
					n_flags = _tmp19_ + 1;
				}
			}
		}
	}
	_tmp20_ = n_flags;
	_tmp21_ = n_mines;
	result = _tmp20_ > _tmp21_;
	return result;
}


static void minefield_place_mines (Minefield* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		gint n;
		n = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				gint32 _tmp5_ = 0;
				gint32 rx;
				guint _tmp6_;
				gint32 _tmp7_ = 0;
				gint32 ry;
				gboolean _tmp8_ = FALSE;
				gint32 _tmp9_;
				guint _tmp10_;
				gboolean _tmp13_;
				Location** _tmp14_;
				gint _tmp14__length1;
				gint _tmp14__length2;
				gint32 _tmp15_;
				gint32 _tmp16_;
				Location* _tmp17_;
				gboolean _tmp18_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
				}
				_tmp0_ = FALSE;
				_tmp2_ = n;
				_tmp3_ = self->n_mines;
				if (!(((guint) _tmp2_) < _tmp3_)) {
					break;
				}
				_tmp4_ = self->width;
				_tmp5_ = g_random_int_range ((gint32) 0, (gint32) _tmp4_);
				rx = _tmp5_;
				_tmp6_ = self->height;
				_tmp7_ = g_random_int_range ((gint32) 0, (gint32) _tmp6_);
				ry = _tmp7_;
				_tmp9_ = rx;
				_tmp10_ = x;
				if (((guint) _tmp9_) == _tmp10_) {
					gint32 _tmp11_;
					guint _tmp12_;
					_tmp11_ = ry;
					_tmp12_ = y;
					_tmp8_ = ((guint) _tmp11_) == _tmp12_;
				} else {
					_tmp8_ = FALSE;
				}
				_tmp13_ = _tmp8_;
				if (_tmp13_) {
					continue;
				}
				_tmp14_ = self->priv->locations;
				_tmp14__length1 = self->priv->locations_length1;
				_tmp14__length2 = self->priv->locations_length2;
				_tmp15_ = rx;
				_tmp16_ = ry;
				_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
				_tmp18_ = _tmp17_->has_mine;
				if (!_tmp18_) {
					gboolean adj_found;
					gboolean _tmp29_;
					adj_found = FALSE;
					{
						Neighbour* neighbour_collection = NULL;
						gint neighbour_collection_length1 = 0;
						gint _neighbour_collection_size_ = 0;
						gint neighbour_it = 0;
						neighbour_collection = neighbour_map;
						neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
						for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
							Neighbour neighbour = {0};
							neighbour = neighbour_collection[neighbour_it];
							{
								gboolean _tmp19_ = FALSE;
								gint32 _tmp20_;
								guint _tmp21_;
								Neighbour _tmp22_;
								gint _tmp23_;
								gboolean _tmp28_;
								_tmp20_ = rx;
								_tmp21_ = x;
								_tmp22_ = neighbour;
								_tmp23_ = _tmp22_.x;
								if (((guint) _tmp20_) == (_tmp21_ + _tmp23_)) {
									gint32 _tmp24_;
									guint _tmp25_;
									Neighbour _tmp26_;
									gint _tmp27_;
									_tmp24_ = ry;
									_tmp25_ = y;
									_tmp26_ = neighbour;
									_tmp27_ = _tmp26_.y;
									_tmp19_ = ((guint) _tmp24_) == (_tmp25_ + _tmp27_);
								} else {
									_tmp19_ = FALSE;
								}
								_tmp28_ = _tmp19_;
								if (_tmp28_) {
									adj_found = TRUE;
									break;
								}
							}
						}
					}
					_tmp29_ = adj_found;
					if (!_tmp29_) {
						Location** _tmp30_;
						gint _tmp30__length1;
						gint _tmp30__length2;
						gint32 _tmp31_;
						gint32 _tmp32_;
						Location* _tmp33_;
						gint _tmp34_;
						_tmp30_ = self->priv->locations;
						_tmp30__length1 = self->priv->locations_length1;
						_tmp30__length2 = self->priv->locations_length2;
						_tmp31_ = rx;
						_tmp32_ = ry;
						_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
						_tmp33_->has_mine = TRUE;
						_tmp34_ = n;
						n = _tmp34_ + 1;
					}
				}
			}
		}
	}
}


guint minefield_get_n_cleared (Minefield* self) {
	guint result;
	gint n;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, 0U);
	n = 0;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = self->width;
				if (!(((guint) _tmp3_) < _tmp4_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							guint _tmp9_;
							Location** _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint _tmp11_;
							gint _tmp12_;
							Location* _tmp13_;
							gboolean _tmp14_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = y;
							_tmp9_ = self->height;
							if (!(((guint) _tmp8_) < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->locations;
							_tmp10__length1 = self->priv->locations_length1;
							_tmp10__length2 = self->priv->locations_length2;
							_tmp11_ = x;
							_tmp12_ = y;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							_tmp14_ = _tmp13_->cleared;
							if (_tmp14_) {
								gint _tmp15_;
								_tmp15_ = n;
								n = _tmp15_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp16_ = n;
	result = (guint) _tmp16_;
	return result;
}


gboolean minefield_get_is_complete (Minefield* self) {
	gboolean result;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_n_cleared (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->width;
	_tmp3_ = self->height;
	_tmp4_ = self->n_mines;
	result = _tmp1_ == ((_tmp2_ * _tmp3_) - _tmp4_);
	return result;
}


guint minefield_get_n_flags (Minefield* self) {
	guint result;
	gint n;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, 0U);
	n = 0;
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = self->width;
				if (!(((guint) _tmp3_) < _tmp4_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							guint _tmp9_;
							Location** _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint _tmp11_;
							gint _tmp12_;
							Location* _tmp13_;
							FlagType _tmp14_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = y;
							_tmp9_ = self->height;
							if (!(((guint) _tmp8_) < _tmp9_)) {
								break;
							}
							_tmp10_ = self->priv->locations;
							_tmp10__length1 = self->priv->locations_length1;
							_tmp10__length2 = self->priv->locations_length2;
							_tmp11_ = x;
							_tmp12_ = y;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
							_tmp14_ = _tmp13_->flag;
							if (_tmp14_ == FLAG_TYPE_FLAG) {
								gint _tmp15_;
								_tmp15_ = n;
								n = _tmp15_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp16_ = n;
	result = (guint) _tmp16_;
	return result;
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void value_minefield_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_minefield_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		minefield_unref (value->data[0].v_pointer);
	}
}


static void value_minefield_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = minefield_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_minefield_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_minefield_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Minefield* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = minefield_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_minefield_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Minefield** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = minefield_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMinefield* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MINEFIELD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_minefield (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD), NULL);
	return value->data[0].v_pointer;
}


void value_set_minefield (GValue* value, gpointer v_object) {
	Minefield* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINEFIELD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		minefield_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minefield_unref (old);
	}
}


void value_take_minefield (GValue* value, gpointer v_object) {
	Minefield* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINEFIELD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINEFIELD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		minefield_unref (old);
	}
}


static void minefield_class_init (MinefieldClass * klass) {
	minefield_parent_class = g_type_class_peek_parent (klass);
	MINEFIELD_CLASS (klass)->finalize = minefield_finalize;
	g_type_class_add_private (klass, sizeof (MinefieldPrivate));
	g_signal_new ("redraw_sector", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("marks_changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("explode", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_instance_init (Minefield * self) {
	self->priv = MINEFIELD_GET_PRIVATE (self);
	self->width = (guint) 0;
	self->height = (guint) 0;
	self->n_mines = (guint) 0;
	self->exploded = FALSE;
	self->priv->placed_mines = FALSE;
	self->ref_count = 1;
}


static void minefield_finalize (Minefield* obj) {
	Minefield * self;
	self = MINEFIELD (obj);
	self->priv->locations = (_vala_array_free (self->priv->locations, self->priv->locations_length1 * self->priv->locations_length2, (GDestroyNotify) location_unref), NULL);
}


GType minefield_get_type (void) {
	static volatile gsize minefield_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_minefield_init, value_minefield_free_value, value_minefield_copy_value, value_minefield_peek_pointer, "p", value_minefield_collect_value, "p", value_minefield_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Minefield), 0, (GInstanceInitFunc) minefield_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType minefield_type_id;
		minefield_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Minefield", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&minefield_type_id__volatile, minefield_type_id);
	}
	return minefield_type_id__volatile;
}


gpointer minefield_ref (gpointer instance) {
	Minefield* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void minefield_unref (gpointer instance) {
	Minefield* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MINEFIELD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



