/* rygel-http-item-uri.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY
};
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelHTTPServer* _tmp6_;
	g_return_val_if_fail (item_id != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	_tmp0_ = item_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->item_id);
	self->item_id = _tmp1_;
	_tmp2_ = thumbnail_index;
	self->thumbnail_index = _tmp2_;
	_tmp3_ = subtitle_index;
	self->subtitle_index = _tmp3_;
	_tmp4_ = transcode_target;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->transcode_target);
	self->transcode_target = _tmp5_;
	_tmp6_ = http_server;
	self->http_server = _tmp6_;
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item_id, http_server, thumbnail_index, subtitle_index, transcode_target);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch86_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch86_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally86;
	__catch86_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally86:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* request_uri;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp12_;
	const gchar* _tmp53_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	self->thumbnail_index = -1;
	self->subtitle_index = -1;
	_g_free0 (self->transcode_target);
	self->transcode_target = NULL;
	_tmp0_ = http_server;
	self->http_server = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = http_server;
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
	request_uri = _tmp5_;
	_tmp6_ = request_uri;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
	parts = _tmp8_;
	parts_length1 = _vala_array_length (_tmp7_);
	_parts_size_ = parts_length1;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	if (_tmp10__length1 < 2) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = parts;
		_tmp11__length1 = parts_length1;
		_tmp9_ = (_tmp11__length1 % 2) == 0;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp13_ = _ ("Invalid URI '%s'");
		_tmp14_ = request_uri;
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GQuark _tmp26_ = 0U;
				static GQuark _tmp25_label0 = 0;
				static GQuark _tmp25_label1 = 0;
				static GQuark _tmp25_label2 = 0;
				static GQuark _tmp25_label3 = 0;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 2;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = parts;
				_tmp20__length1 = parts_length1;
				if (!(_tmp19_ < (_tmp20__length1 - 1))) {
					break;
				}
				_tmp21_ = parts;
				_tmp21__length1 = parts_length1;
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = _tmp23_;
				_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
				if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("i")))) {
					switch (0) {
						default:
						{
							gchar** _tmp27_;
							gint _tmp27__length1;
							gint _tmp28_;
							const gchar* _tmp29_;
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_;
							size_t _tmp32_;
							guchar* _tmp33_ = NULL;
							guchar* _tmp34_;
							gint _tmp34__length1;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp35_;
							GString* builder;
							GString* _tmp36_;
							guchar* _tmp37_;
							gint _tmp37__length1;
							GString* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
							_tmp27_ = parts;
							_tmp27__length1 = parts_length1;
							_tmp28_ = i;
							_tmp29_ = _tmp27_[_tmp28_ + 1];
							_tmp30_ = soup_uri_decode (_tmp29_);
							_tmp31_ = _tmp30_;
							_tmp33_ = g_base64_decode (_tmp31_, &_tmp32_);
							_tmp34_ = _tmp33_;
							_tmp34__length1 = _tmp32_;
							_g_free0 (_tmp31_);
							data = _tmp34_;
							data_length1 = _tmp34__length1;
							_data_size_ = data_length1;
							_tmp35_ = g_string_new ("");
							builder = _tmp35_;
							_tmp36_ = builder;
							_tmp37_ = data;
							_tmp37__length1 = data_length1;
							g_string_append (_tmp36_, (const gchar*) _tmp37_);
							_tmp38_ = builder;
							_tmp39_ = _tmp38_->str;
							_tmp40_ = g_strdup (_tmp39_);
							_g_free0 (self->item_id);
							self->item_id = _tmp40_;
							_g_string_free0 (builder);
							data = (g_free (data), NULL);
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("tr")))) {
					switch (0) {
						default:
						{
							gchar** _tmp41_;
							gint _tmp41__length1;
							gint _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_ = NULL;
							_tmp41_ = parts;
							_tmp41__length1 = parts_length1;
							_tmp42_ = i;
							_tmp43_ = _tmp41_[_tmp42_ + 1];
							_tmp44_ = soup_uri_decode (_tmp43_);
							_g_free0 (self->transcode_target);
							self->transcode_target = _tmp44_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("th")))) {
					switch (0) {
						default:
						{
							gchar** _tmp45_;
							gint _tmp45__length1;
							gint _tmp46_;
							const gchar* _tmp47_;
							gint _tmp48_ = 0;
							_tmp45_ = parts;
							_tmp45__length1 = parts_length1;
							_tmp46_ = i;
							_tmp47_ = _tmp45_[_tmp46_ + 1];
							_tmp48_ = atoi (_tmp47_);
							self->thumbnail_index = _tmp48_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("sub")))) {
					switch (0) {
						default:
						{
							gchar** _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							const gchar* _tmp51_;
							gint _tmp52_ = 0;
							_tmp49_ = parts;
							_tmp49__length1 = parts_length1;
							_tmp50_ = i;
							_tmp51_ = _tmp49_[_tmp50_ + 1];
							_tmp52_ = atoi (_tmp51_);
							self->subtitle_index = _tmp52_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	_tmp53_ = self->item_id;
	if (_tmp53_ == NULL) {
		const gchar* _tmp54_ = NULL;
		GError* _tmp55_;
		_tmp54_ = _ ("Not Found");
		_tmp55_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp54_);
		_inner_error_ = _tmp55_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* escaped;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* path;
	const gchar* _tmp10_;
	const gchar* _tmp34_;
	gchar* _tmp35_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->item_id;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, _tmp3__length1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	escaped = _tmp7_;
	_tmp8_ = escaped;
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
	path = _tmp9_;
	_tmp10_ = self->transcode_target;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = self->transcode_target;
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
		_g_free0 (escaped);
		escaped = _tmp12_;
		_tmp13_ = path;
		_tmp14_ = escaped;
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
		_g_free0 (path);
		path = _tmp17_;
		_g_free0 (_tmp16_);
	} else {
		gint _tmp18_;
		_tmp18_ = self->thumbnail_index;
		if (_tmp18_ >= 0) {
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp19_ = path;
			_tmp20_ = self->thumbnail_index;
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
			_g_free0 (path);
			path = _tmp25_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
		} else {
			gint _tmp26_;
			_tmp26_ = self->subtitle_index;
			if (_tmp26_ >= 0) {
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp27_ = path;
				_tmp28_ = self->subtitle_index;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
				_g_free0 (path);
				path = _tmp33_;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
			}
		}
	}
	_tmp34_ = path;
	_tmp35_ = rygel_http_item_uri_create_uri_for_path (self, _tmp34_);
	result = _tmp35_;
	_g_free0 (path);
	_g_free0 (escaped);
	data = (g_free (data), NULL);
	return result;
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelHTTPServer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->http_server;
	_tmp1_ = _tmp0_->context;
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->http_server;
	_tmp5_ = _tmp4_->context;
	_tmp6_ = gupnp_context_get_port (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->http_server;
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = path;
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
	result = _tmp12_;
	return result;
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
	self = RYGEL_HTTP_ITEM_URI (obj);
	_g_free0 (self->item_id);
	_g_free0 (self->transcode_target);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



