/* rygel-http-byte-seek_http-get.c generated by valac 0.17.2.19-5f50d, the Vala compiler
 * generated from rygel-http-byte-seek_http-get.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};


static gpointer rygel_http_byte_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeek * self = NULL;
	SoupRange* ranges = NULL;
	gint ranges_length1 = 0;
	gint _ranges_size_ = 0;
	gint64 start;
	gint64 total_length = 0LL;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* range;
	RygelHTTPGet* _tmp4_;
	RygelThumbnail* _tmp5_;
	gint64 _tmp17_;
	gint64 stop;
	const gchar* _tmp18_;
	RygelHTTPGet* _tmp40_;
	SoupMessage* _tmp41_;
	gint64 _tmp42_;
	gint64 _tmp43_;
	gint64 _tmp44_;
	GError * _inner_error_ = NULL;
#line 25 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	start = (gint64) 0;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp0_ = request;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	range = _tmp3_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp4_ = request;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp5_ = _tmp4_->thumbnail;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp5_ != NULL) {
#line 410 "rygel-http-byte-seek_http-get.c"
		RygelHTTPGet* _tmp6_;
		RygelThumbnail* _tmp7_;
		glong _tmp8_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp6_ = request;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp7_ = _tmp6_->thumbnail;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp8_ = _tmp7_->size;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		total_length = (gint64) _tmp8_;
#line 422 "rygel-http-byte-seek_http-get.c"
	} else {
		RygelHTTPGet* _tmp9_;
		RygelSubtitle* _tmp10_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp9_ = request;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp10_ = _tmp9_->subtitle;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_tmp10_ != NULL) {
#line 432 "rygel-http-byte-seek_http-get.c"
			RygelHTTPGet* _tmp11_;
			RygelSubtitle* _tmp12_;
			glong _tmp13_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp11_ = request;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp12_ = _tmp11_->subtitle;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp13_ = _tmp12_->size;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			total_length = (gint64) _tmp13_;
#line 444 "rygel-http-byte-seek_http-get.c"
		} else {
			RygelHTTPGet* _tmp14_;
			RygelMediaItem* _tmp15_;
			glong _tmp16_;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp14_ = request;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp15_ = ((RygelHTTPRequest*) _tmp14_)->item;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp16_ = _tmp15_->size;
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			total_length = (gint64) _tmp16_;
#line 457 "rygel-http-byte-seek_http-get.c"
		}
	}
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp17_ = total_length;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	stop = _tmp17_ - 1;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp18_ = range;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp18_ != NULL) {
#line 468 "rygel-http-byte-seek_http-get.c"
		RygelHTTPGet* _tmp19_;
		SoupMessage* _tmp20_;
		SoupMessageHeaders* _tmp21_;
		gint64 _tmp22_;
		SoupRange* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gboolean _tmp25_ = FALSE;
		gint64 _tmp35_;
		gint64 _tmp36_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp19_ = request;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp20_ = ((RygelHTTPRequest*) _tmp19_)->msg;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp21_ = _tmp20_->request_headers;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp22_ = total_length;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp25_ = soup_message_headers_get_ranges (_tmp21_, _tmp22_, (SoupRange**) (&_tmp23_), &_tmp24_);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		ranges = (g_free (ranges), NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		ranges = _tmp23_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		ranges_length1 = _tmp24_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_ranges_size_ = ranges_length1;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_tmp25_) {
#line 498 "rygel-http-byte-seek_http-get.c"
			SoupRange* _tmp26_;
			gint _tmp26__length1;
			SoupRange _tmp27_;
			gint64 _tmp28_;
			SoupRange* _tmp29_;
			gint _tmp29__length1;
			SoupRange _tmp30_;
			gint64 _tmp31_;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp26_ = ranges;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp26__length1 = ranges_length1;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp27_ = _tmp26_[0];
#line 43 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp28_ = _tmp27_.start;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			start = _tmp28_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp29_ = ranges;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp29__length1 = ranges_length1;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp30_ = _tmp29_[0];
#line 44 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp31_ = _tmp30_.end;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			stop = _tmp31_;
#line 527 "rygel-http-byte-seek_http-get.c"
		} else {
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_;
			GError* _tmp34_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp32_ = _ ("Invalid Range '%s'");
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp33_ = range;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp34_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp32_, _tmp33_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_inner_error_ = _tmp34_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_propagate_error (error, _inner_error_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				ranges = (g_free (ranges), NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				_g_object_unref0 (self);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				return NULL;
#line 550 "rygel-http-byte-seek_http-get.c"
			} else {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				ranges = (g_free (ranges), NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_clear_error (&_inner_error_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				return NULL;
#line 560 "rygel-http-byte-seek_http-get.c"
			}
		}
#line 51 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp35_ = start;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp36_ = stop;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_tmp35_ > _tmp36_) {
#line 569 "rygel-http-byte-seek_http-get.c"
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_;
			GError* _tmp39_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp37_ = _ ("Invalid Range '%s'");
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp38_ = range;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp37_, _tmp38_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_inner_error_ = _tmp39_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_propagate_error (error, _inner_error_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				ranges = (g_free (ranges), NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				_g_object_unref0 (self);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				return NULL;
#line 591 "rygel-http-byte-seek_http-get.c"
			} else {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				ranges = (g_free (ranges), NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				g_clear_error (&_inner_error_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
				return NULL;
#line 601 "rygel-http-byte-seek_http-get.c"
			}
		}
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp40_ = request;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp41_ = ((RygelHTTPRequest*) _tmp40_)->msg;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp42_ = start;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp43_ = stop;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp44_ = total_length;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp41_, _tmp42_, _tmp43_, (gint64) 1, _tmp44_, &_inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			ranges = (g_free (ranges), NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_g_object_unref0 (self);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			return NULL;
#line 629 "rygel-http-byte-seek_http-get.c"
		} else {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			ranges = (g_free (ranges), NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			return NULL;
#line 639 "rygel-http-byte-seek_http-get.c"
		}
	}
#line 25 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	ranges = (g_free (ranges), NULL);
#line 25 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	return self;
#line 646 "rygel-http-byte-seek_http-get.c"
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error) {
#line 25 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, request, error);
#line 653 "rygel-http-byte-seek_http-get.c"
}


gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	RygelHTTPGet* _tmp4_;
	RygelMediaItem* _tmp5_;
	glong _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_;
	gboolean _tmp30_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp4_ = request;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->item;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp6_ = _tmp5_->size;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp6_ > ((glong) 0)) {
#line 680 "rygel-http-byte-seek_http-get.c"
		RygelHTTPGet* _tmp7_;
		RygelHTTPGetHandler* _tmp8_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp7_ = request;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp8_ = _tmp7_->handler;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 689 "rygel-http-byte-seek_http-get.c"
	} else {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp3_ = FALSE;
#line 693 "rygel-http-byte-seek_http-get.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp9_ = _tmp3_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp9_) {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp2_ = TRUE;
#line 701 "rygel-http-byte-seek_http-get.c"
	} else {
		gboolean _tmp10_ = FALSE;
		RygelHTTPGet* _tmp11_;
		RygelThumbnail* _tmp12_;
		gboolean _tmp16_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp11_ = request;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp12_ = _tmp11_->thumbnail;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_tmp12_ != NULL) {
#line 713 "rygel-http-byte-seek_http-get.c"
			RygelHTTPGet* _tmp13_;
			RygelThumbnail* _tmp14_;
			glong _tmp15_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp13_ = request;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp14_ = _tmp13_->thumbnail;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp15_ = _tmp14_->size;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp10_ = _tmp15_ > ((glong) 0);
#line 725 "rygel-http-byte-seek_http-get.c"
		} else {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp10_ = FALSE;
#line 729 "rygel-http-byte-seek_http-get.c"
		}
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp16_ = _tmp10_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp2_ = _tmp16_;
#line 735 "rygel-http-byte-seek_http-get.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp17_ = _tmp2_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp17_) {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp1_ = TRUE;
#line 743 "rygel-http-byte-seek_http-get.c"
	} else {
		gboolean _tmp18_ = FALSE;
		RygelHTTPGet* _tmp19_;
		RygelSubtitle* _tmp20_;
		gboolean _tmp24_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp19_ = request;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp20_ = _tmp19_->subtitle;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		if (_tmp20_ != NULL) {
#line 755 "rygel-http-byte-seek_http-get.c"
			RygelHTTPGet* _tmp21_;
			RygelSubtitle* _tmp22_;
			glong _tmp23_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp21_ = request;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp22_ = _tmp21_->subtitle;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp23_ = _tmp22_->size;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp18_ = _tmp23_ > ((glong) 0);
#line 767 "rygel-http-byte-seek_http-get.c"
		} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
			_tmp18_ = FALSE;
#line 771 "rygel-http-byte-seek_http-get.c"
		}
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp24_ = _tmp18_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp1_ = _tmp24_;
#line 777 "rygel-http-byte-seek_http-get.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp25_ = _tmp1_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp25_) {
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp0_ = TRUE;
#line 785 "rygel-http-byte-seek_http-get.c"
	} else {
		RygelHTTPGet* _tmp26_;
		SoupMessage* _tmp27_;
		SoupMessageHeaders* _tmp28_;
		const gchar* _tmp29_ = NULL;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp26_ = request;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp27_ = ((RygelHTTPRequest*) _tmp26_)->msg;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp28_ = _tmp27_->request_headers;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp29_ = soup_message_headers_get_one (_tmp28_, "User-Agent");
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp0_ = g_strcmp0 (_tmp29_, "PLAYSTATION 3") == 0;
#line 801 "rygel-http-byte-seek_http-get.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp30_ = _tmp0_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	result = _tmp30_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	return result;
#line 809 "rygel-http-byte-seek_http-get.c"
}


gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp0_ = request;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	result = _tmp3_ != NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	return result;
#line 833 "rygel-http-byte-seek_http-get.c"
}


static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPByteSeek * self;
	gchar* _tmp0_;
	gchar* range;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* headers;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageHeaders* _tmp6_;
	const gchar* _tmp7_ = NULL;
	SoupMessageHeaders* _tmp33_;
	gint64 _tmp34_;
	gint64 _tmp35_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	self = (RygelHTTPByteSeek*) base;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp0_ = g_strdup ("bytes ");
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	range = _tmp0_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp1_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp2_ = _tmp1_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp3_ = _tmp2_->response_headers;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	headers = _tmp3_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp4_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp5_ = _tmp4_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp6_ = _tmp5_->request_headers;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "Range");
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	if (_tmp7_ != NULL) {
#line 876 "rygel-http-byte-seek_http-get.c"
		SoupMessageHeaders* _tmp8_;
		const gchar* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gint64 _tmp16_;
		gint64 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gint64 _tmp24_;
		gint64 _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		SoupMessageHeaders* _tmp31_;
		const gchar* _tmp32_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp8_ = headers;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		soup_message_headers_append (_tmp8_, "Accept-Ranges", "bytes");
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp9_ = range;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp10_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp11_ = _tmp10_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp13_ = _tmp12_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp14_ = g_strconcat (_tmp13_, "-", NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp15_ = _tmp14_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp16_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp17_ = _tmp16_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp19_ = _tmp18_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp21_ = _tmp20_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp22_ = g_strconcat (_tmp21_, "/", NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp23_ = _tmp22_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp25_ = _tmp24_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp26_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp25_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp27_ = _tmp26_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp29_ = _tmp28_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp30_ = g_strconcat (_tmp9_, _tmp29_, NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (range);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		range = _tmp30_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp29_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp27_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp23_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp21_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp19_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp15_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_g_free0 (_tmp13_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp31_ = headers;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		_tmp32_ = range;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
		soup_message_headers_append (_tmp31_, "Content-Range", _tmp32_);
#line 974 "rygel-http-byte-seek_http-get.c"
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp33_ = headers;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp34_ = rygel_http_seek_get_length ((RygelHTTPSeek*) self);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_tmp35_ = _tmp34_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	soup_message_headers_set_content_length (_tmp33_, _tmp35_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	_g_free0 (range);
#line 986 "rygel-http-byte-seek_http-get.c"
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
#line 24 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/tests/rygel-http-byte-seek_http-get.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_byte_seek_real_add_response_headers;
#line 995 "rygel-http-byte-seek_http-get.c"
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}



