/* rygel-http-post.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _RygelHttpPostWaitForItemData RygelHttpPostWaitForItemData;
typedef struct _RygelHttpPostFinalizePostData RygelHttpPostFinalizePostData;
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GFile* dotfile;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp1_;
	RygelMediaItem* _tmp2_;
	GError* _error_;
	RygelItemRemovalQueue* _tmp3_;
	RygelMediaItem* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* msg;
	const gchar* _tmp5_;
	RygelMediaItem* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelMediaItem* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaItem* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GFileOutputStream* _tmp31_;
	GFileOutputStream* _tmp32_;
	SoupMessage* _tmp33_;
	SoupMessage* _tmp34_;
	SoupServer* _tmp35_;
	SoupMessage* _tmp36_;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	RygelHTTPPost * self;
	RygelMediaContainer* container;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	guint source_id;
};

struct _RygelHttpPostWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaContainer* container;
	gchar* id;
	guint timeout;
	Block6Data* _data6_;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaItem* item;
	gboolean _tmp2_;
	RygelMediaItem* _tmp3_;
	RygelMediaItem* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	RygelMediaContainer* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GError* _error_;
	RygelMediaItem* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaItem* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	Block7Data* _data7_;
	guint _tmp19_;
	guint _tmp20_;
	RygelMediaContainer* _tmp21_;
	gulong _tmp22_;
	gulong update_id;
	RygelMediaContainer* _tmp23_;
	gulong _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	GError * _inner_error_;
};

struct _RygelHttpPostFinalizePostData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	GOutputStream* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GError* _error_;
	GSourceFunc _tmp3_;
	void* _tmp3__target;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelMediaItem* _tmp6_;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaItem* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GError* move_error;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	SoupServer* _tmp21_;
	SoupMessage* _tmp22_;
	GSourceFunc _tmp23_;
	void* _tmp23__target;
	RygelMediaItem* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaItem* _tmp26_;
	const gchar* _tmp27_;
	SoupServer* _tmp28_;
	SoupMessage* _tmp29_;
	GSourceFunc _tmp30_;
	void* _tmp30__target;
	GError * _inner_error_;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelMediaItem* _tmp1_;
};


static gpointer rygel_http_post_parent_class = NULL;

GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST, RygelHTTPPostPrivate))
enum  {
	RYGEL_HTTP_POST_DUMMY_PROPERTY
};
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GQuark rygel_content_directory_error_quark (void);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_http_request_error_quark (void);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_wait_for_item_data_free (gpointer _data);
static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda13_ (Block7Data* _data7_);
static gboolean _____lambda13__gsource_func (gpointer self);
static void ____lambda14_ (Block7Data* _data7_);
static void _____lambda14__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_http_post_finalize_post_data_free (gpointer _data);
static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_);
static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_finalize (GObject* obj);


static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_on_request_cancelled (self);
#line 487 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPPost * self = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageBody* _tmp6_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = http_server;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp1_ = server;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp2_ = msg;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp4_ = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_cancellable_connect (_tmp4_, (GCallback) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp5_ = msg;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp6_ = _tmp5_->request_body;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	soup_message_body_set_accumulate (_tmp6_, FALSE);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return self;
#line 528 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
#line 535 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_data_free (gpointer _data) {
	RygelHttpPostHandleData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleData, _data_);
#line 546 "rygel-http-post.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return self ? g_object_ref (self) : NULL;
#line 553 "rygel-http-post.c"
}


static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self = (RygelHTTPPost*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_real_handle);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 575 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return;
#line 585 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 589 "rygel-http-post.c"
}


static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleData* _data_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = _user_data_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 603 "rygel-http-post.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return self ? g_error_copy (self) : NULL;
#line 610 "rygel-http-post.c"
}


static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 0:
#line 619 "rygel-http-post.c"
		goto _state_0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 1:
#line 623 "rygel-http-post.c"
		goto _state_1;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 2:
#line 627 "rygel-http-post.c"
		goto _state_2;
		default:
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_assert_not_reached ();
#line 632 "rygel-http-post.c"
	}
	_state_0:
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp1_ = _data_->queue;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_item_removal_queue_dequeue (_data_->_tmp1_, _data_->_tmp2_);
#line 647 "rygel-http-post.c"
	{
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_state_ = 1;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_post_handle_real (_data_->self, rygel_http_post_handle_ready, _data_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 655 "rygel-http-post.c"
		_state_1:
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_post_handle_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 661 "rygel-http-post.c"
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->queue;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_state_ = 2;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_item_removal_queue_remove_now (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, rygel_http_post_handle_ready, _data_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 686 "rygel-http-post.c"
		_state_2:
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_item_removal_queue_remove_now_finish (_data_->_tmp3_, _data_->_res_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_error_free0 (_data_->_error_);
#line 698 "rygel-http-post.c"
		goto __finally24;
	}
	__finally24:
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_object_unref0 (_data_->queue);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 714 "rygel-http-post.c"
		} else {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 718 "rygel-http-post.c"
		}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 724 "rygel-http-post.c"
	}
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 732 "rygel-http-post.c"
	} else {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 736 "rygel-http-post.c"
	}
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 742 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_data_free (gpointer _data) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleRealData, _data_);
#line 753 "rygel-http-post.c"
}


static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_handle_real);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 772 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleRealData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return;
#line 782 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 786 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = _user_data_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 800 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_on_got_chunk (self, _sender, chunk);
#line 807 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_on_got_body (self, _sender);
#line 814 "rygel-http-post.c"
}


static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return result;
#line 823 "rygel-http-post.c"
}


static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 0:
#line 832 "rygel-http-post.c"
		goto _state_0;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 1:
#line 836 "rygel-http-post.c"
		goto _state_1;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 2:
#line 840 "rygel-http-post.c"
		goto _state_2;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 3:
#line 844 "rygel-http-post.c"
		goto _state_3;
		default:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_assert_not_reached ();
#line 849 "rygel-http-post.c"
	}
	_state_0:
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp1_ = rygel_media_item_get_place_holder (_data_->_tmp0_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (!_data_->_tmp2_) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ = _ ("Pushing data to non-empty item '%s' not allowed");
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->msg = _data_->_tmp4_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp5_ = _data_->msg;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp5_, _data_->_tmp7_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_free0 (_data_->msg);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 888 "rygel-http-post.c"
		} else {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 892 "rygel-http-post.c"
		}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 898 "rygel-http-post.c"
	}
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp9_, _data_->_tmp11_, rygel_http_post_handle_real_ready, _data_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 912 "rygel-http-post.c"
	_state_1:
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp12_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp12_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp13_ = _data_->_tmp12_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 930 "rygel-http-post.c"
		} else {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 934 "rygel-http-post.c"
		}
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 940 "rygel-http-post.c"
	}
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->file);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->file = _data_->_tmp13_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp14_ = _data_->self->priv->file;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_tmp14_ == NULL) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp15_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp15_ = _ ("No writable URI for %s available");
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp17_ = ((RygelMediaObject*) _data_->_tmp16_)->id;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp18_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp15_, _data_->_tmp17_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp18_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 970 "rygel-http-post.c"
		} else {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 974 "rygel-http-post.c"
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 980 "rygel-http-post.c"
	}
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp19_ = _data_->self->priv->file;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp20_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp20_ = g_file_get_parent (_data_->_tmp19_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp22_ = _data_->self->priv->file;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp23_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp23_ = g_file_get_basename (_data_->_tmp22_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp24_ = _data_->_tmp23_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp25_ = g_strconcat (".", _data_->_tmp24_, NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp26_ = _data_->_tmp25_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp27_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp27_ = g_file_get_child (_data_->_tmp21_, _data_->_tmp26_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->dotfile);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->dotfile = _data_->_tmp27_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_free0 (_data_->_tmp26_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_free0 (_data_->_tmp24_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->_tmp21_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp28_ = _data_->self->priv->dotfile;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp30_ = _data_->_tmp29_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_state_ = 2;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_file_replace_async (_data_->_tmp28_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, _data_->_tmp30_, rygel_http_post_handle_real_ready, _data_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1028 "rygel-http-post.c"
	_state_2:
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp31_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp31_ = g_file_replace_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp32_ = _data_->_tmp31_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1046 "rygel-http-post.c"
		} else {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1050 "rygel-http-post.c"
		}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 1056 "rygel-http-post.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->stream);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->stream = (GOutputStream*) _data_->_tmp32_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp33_, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, _data_->self, 0);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp34_, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, _data_->self, 0);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp35_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp36_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	soup_server_unpause_message (_data_->_tmp35_, _data_->_tmp36_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	(_data_->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->handle_continue_target_destroy_notify (_data_->self->priv->handle_continue_target), NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = _data_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_state_ = 3;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1094 "rygel-http-post.c"
	_state_3:
	;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1101 "rygel-http-post.c"
	} else {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1105 "rygel-http-post.c"
	}
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1111 "rygel-http-post.c"
}


static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg) {
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp1_ = msg;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_tmp0_ != _tmp1_) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return;
#line 1130 "rygel-http-post.c"
	}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_finalize_post (self, NULL, NULL);
#line 1134 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item_data_free (gpointer _data) {
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->container);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_slice_free (RygelHttpPostWaitForItemData, _data_);
#line 1149 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
	RygelHTTPPost* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostWaitForItemData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_wait_for_item);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_wait_for_item_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp1_ = container;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->container = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp3_ = id;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->id = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp5_ = timeout;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->timeout = _tmp5_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data_);
#line 1189 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostWaitForItemData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1197 "rygel-http-post.c"
}


/**
     * Waits for an item with @id to change its state to non-placeholder under
     * @container, but at most @timeout seconds.
     *
     * @param container The container to watch for changes
     * @param id The child id to look for
     * @param timeout Seconds to wait befor cancelling
     */
static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return _data6_;
#line 1214 "rygel-http-post.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1223 "rygel-http-post.c"
		RygelHTTPPost * self;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		self = _data6_->self;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_object_unref0 (_data6_->container);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_object_unref0 (self);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_slice_free (Block6Data, _data6_);
#line 1233 "rygel-http-post.c"
	}
}


static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = _user_data_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data_);
#line 1248 "rygel-http-post.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return _data7_;
#line 1257 "rygel-http-post.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1266 "rygel-http-post.c"
		RygelHTTPPost * self;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		self = _data7_->_data6_->self;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		block6_data_unref (_data7_->_data6_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data7_->_data6_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_slice_free (Block7Data, _data7_);
#line 1276 "rygel-http-post.c"
	}
}


static gboolean ____lambda13_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	RygelHTTPPost * self;
	gboolean result = FALSE;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data6_ = _data7_->_data6_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self = _data6_->self;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _data6_->container;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_debug ("rygel-http-post.vala:134: Timeout on waiting for 'updated' signal on '" \
"%s'.", _tmp1_);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data7_->source_id = (guint) 0;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data6_->_async_data_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	result = FALSE;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return result;
#line 1305 "rygel-http-post.c"
}


static gboolean _____lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda13_ (self);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return result;
#line 1314 "rygel-http-post.c"
}


static void ____lambda14_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	RygelHTTPPost * self;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data6_ = _data7_->_data6_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self = _data6_->self;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _data6_->container;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_debug ("rygel-http-post.vala:143: Finished waiting for update signal from cont" \
"ainer '%s'", _tmp1_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data6_->_async_data_);
#line 1335 "rygel-http-post.c"
}


static void _____lambda14__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	____lambda14_ (self);
#line 1342 "rygel-http-post.c"
}


static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 0:
#line 1351 "rygel-http-post.c"
		goto _state_0;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 1:
#line 1355 "rygel-http-post.c"
		goto _state_1;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 2:
#line 1359 "rygel-http-post.c"
		goto _state_2;
		default:
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_assert_not_reached ();
#line 1364 "rygel-http-post.c"
	}
	_state_0:
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_ = g_slice_new0 (Block6Data);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_->_ref_count_ = 1;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_->self = g_object_ref (_data_->self);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = _data_->container;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_->container = _data_->_tmp1_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_->_async_data_ = _data_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->item = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	while (TRUE) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_tmp3_ == NULL) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp2_ = TRUE;
#line 1391 "rygel-http-post.c"
		} else {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp4_ = _data_->item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp5_ = rygel_media_item_get_place_holder (_data_->_tmp4_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp6_ = _data_->_tmp5_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp2_ = _data_->_tmp6_;
#line 1401 "rygel-http-post.c"
		}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp7_ = _data_->_tmp2_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (!_data_->_tmp7_) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			break;
#line 1409 "rygel-http-post.c"
		}
		{
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp8_ = _data_->_data6_->container;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp9_ = _data_->id;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_state_ = 1;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			rygel_media_container_find_object (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp11_, rygel_http_post_wait_for_item_ready, _data_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			return FALSE;
#line 1426 "rygel-http-post.c"
			_state_1:
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp12_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp12_ = rygel_media_container_find_object_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1436 "rygel-http-post.c"
				goto __catch25_g_error;
			}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_g_object_unref0 (_data_->item);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->item = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp13_) : NULL;
#line 1443 "rygel-http-post.c"
		}
		goto __finally25;
		__catch25_g_error:
		{
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_inner_error_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_g_error_free0 (_data_->_error_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			break;
#line 1456 "rygel-http-post.c"
		}
		__finally25:
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_g_object_unref0 (_data_->item);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			block6_data_unref (_data_->_data6_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data6_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_clear_error (&_data_->_inner_error_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			return FALSE;
#line 1473 "rygel-http-post.c"
		}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp14_ = _data_->item;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_tmp14_ == NULL) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp15_ = _data_->id;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_warning ("rygel-http-post.vala:126: Item %s disappeared, stop waiting for it", _data_->_tmp15_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			break;
#line 1485 "rygel-http-post.c"
		}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp16_ = _data_->item;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp17_ = rygel_media_item_get_place_holder (_data_->_tmp16_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_tmp18_) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_ = g_slice_new0 (Block7Data);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_->_ref_count_ = 1;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_->source_id = (guint) 0;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp19_ = _data_->timeout;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp20_ = 0U;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp20_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->_tmp19_, _____lambda13__gsource_func, block7_data_ref (_data_->_data7_), block7_data_unref);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_->source_id = _data_->_tmp20_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp21_ = _data_->_data6_->container;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp22_ = 0UL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp22_ = g_signal_connect_data (_data_->_tmp21_, "container-updated", (GCallback) _____lambda14__rygel_media_container_container_updated, block7_data_ref (_data_->_data7_), (GClosureNotify) block7_data_unref, 0);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->update_id = _data_->_tmp22_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_state_ = 2;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			return FALSE;
#line 1523 "rygel-http-post.c"
			_state_2:
			;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp23_ = _data_->_data6_->container;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp24_ = _data_->update_id;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp23_, _data_->_tmp24_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_tmp25_ = _data_->_data7_->source_id;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			if (_data_->_tmp25_ != ((guint) 0)) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
				_data_->_tmp26_ = _data_->_data7_->source_id;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
				g_source_remove (_data_->_tmp26_);
#line 1540 "rygel-http-post.c"
			} else {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
				block7_data_unref (_data_->_data7_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
				_data_->_data7_ = NULL;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
				break;
#line 1548 "rygel-http-post.c"
			}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			block7_data_unref (_data_->_data7_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			_data_->_data7_ = NULL;
#line 1554 "rygel-http-post.c"
		}
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->item);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	block6_data_unref (_data_->_data6_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_data6_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1567 "rygel-http-post.c"
	} else {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1571 "rygel-http-post.c"
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1577 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_data_free (gpointer _data) {
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_slice_free (RygelHttpPostFinalizePostData, _data_);
#line 1588 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostFinalizePostData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_finalize_post);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_finalize_post_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_finalize_post_co (_data_);
#line 1607 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostFinalizePostData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1615 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = _user_data_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_finalize_post_co (_data_);
#line 1629 "rygel-http-post.c"
}


static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 0:
#line 1638 "rygel-http-post.c"
		goto _state_0;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 1:
#line 1642 "rygel-http-post.c"
		goto _state_1;
		default:
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_assert_not_reached ();
#line 1647 "rygel-http-post.c"
	}
	_state_0:
	{
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp0_ = _data_->self->priv->stream;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_output_stream_close (_data_->_tmp0_, _data_->_tmp2_, &_data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1661 "rygel-http-post.c"
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->self->priv->handle_continue;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3__target = _data_->self->priv->handle_continue_target;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp3_ (_data_->_tmp3__target);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_error_free0 (_data_->_error_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1686 "rygel-http-post.c"
		} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1690 "rygel-http-post.c"
		}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 1696 "rygel-http-post.c"
	}
	__finally26:
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_clear_error (&_data_->_inner_error_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 1707 "rygel-http-post.c"
	}
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	soup_server_pause_message (_data_->_tmp4_, _data_->_tmp5_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->parent;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp8_ = ((RygelMediaObject*) _data_->_tmp7_)->id;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp10_ = ((RygelMediaObject*) _data_->_tmp9_)->id;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'..", _data_->_tmp8_, _data_->_tmp10_);
#line 1727 "rygel-http-post.c"
	{
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp11_ = _data_->self->priv->dotfile;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp12_ = _data_->self->priv->file;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_file_move (_data_->_tmp11_, _data_->_tmp12_, G_FILE_COPY_NONE, _data_->_tmp14_, NULL, NULL, &_data_->_inner_error_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1741 "rygel-http-post.c"
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->move_error = _data_->_inner_error_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp15_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp15_ = _ ("Failed to move dotfile %s: %s");
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp16_ = _data_->self->priv->dotfile;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp17_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp19_ = _data_->move_error;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_free0 (_data_->_tmp18_);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp21_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp22_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		soup_server_unpause_message (_data_->_tmp21_, _data_->_tmp22_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp23_ = _data_->self->priv->handle_continue;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp23__target = _data_->self->priv->handle_continue_target;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_data_->_tmp23_ (_data_->_tmp23__target);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_error_free0 (_data_->move_error);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1792 "rygel-http-post.c"
		} else {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1796 "rygel-http-post.c"
		}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 1802 "rygel-http-post.c"
	}
	__finally27:
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_clear_error (&_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return FALSE;
#line 1813 "rygel-http-post.c"
	}
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp24_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp25_ = ((RygelMediaObject*) _data_->_tmp24_)->parent;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp27_ = ((RygelMediaObject*) _data_->_tmp26_)->id;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item (_data_->self, _data_->_tmp25_, _data_->_tmp27_, (guint) 5, rygel_http_post_finalize_post_ready, _data_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1829 "rygel-http-post.c"
	_state_1:
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_wait_for_item_finish (_data_->self, _data_->_res_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp28_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	soup_server_unpause_message (_data_->_tmp28_, _data_->_tmp29_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_OK);
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp30_ = _data_->self->priv->handle_continue;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp30__target = _data_->self->priv->handle_continue_target;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp30_ (_data_->_tmp30__target);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1851 "rygel-http-post.c"
	} else {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1855 "rygel-http-post.c"
	}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 1861 "rygel-http-post.c"
}


static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk) {
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (chunk != NULL);
#line 1873 "rygel-http-post.c"
	{
		GOutputStream* _tmp0_;
		SoupBuffer* _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp0_ = self->priv->stream;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp1_ = chunk;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp2_ = _tmp1_->data;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp2__length1 = (gint) _tmp1_->length;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp4_ = _tmp3_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_output_stream_write_all (_tmp0_, _tmp2_, (gsize) _tmp2__length1, NULL, _tmp4_, &_inner_error_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		if (_inner_error_ != NULL) {
#line 1897 "rygel-http-post.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		GSourceFunc _tmp9_;
		void* _tmp9__target;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_error_ = _inner_error_;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_inner_error_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_post_disconnect_message_signals (self);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp5_ = _error_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp6_ = _tmp5_->message;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp7_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR, _tmp6_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp8_ = _tmp7_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		rygel_http_request_handle_error ((RygelHTTPRequest*) self, _tmp8_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_error_free0 (_tmp8_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp9_ = self->priv->handle_continue;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp9__target = self->priv->handle_continue_target;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_tmp9_ (_tmp9__target);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		_g_error_free0 (_error_);
#line 1937 "rygel-http-post.c"
	}
	__finally28:
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_inner_error_ != NULL) {
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_clear_error (&_inner_error_);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		return;
#line 1948 "rygel-http-post.c"
	}
}


static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self) {
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_remove_item (self, NULL, NULL);
#line 1958 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_data_free (gpointer _data) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_slice_free (RygelHttpPostRemoveItemData, _data_);
#line 1969 "rygel-http-post.c"
}


static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_remove_item);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 1988 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostRemoveItemData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1996 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_ = _user_data_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 2010 "rygel-http-post.c"
}


static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 0:
#line 2019 "rygel-http-post.c"
		goto _state_0;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		case 1:
#line 2023 "rygel-http-post.c"
		goto _state_1;
		default:
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_assert_not_reached ();
#line 2028 "rygel-http-post.c"
	}
	_state_0:
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_item_removal_queue_remove_now (_data_->queue, _data_->_tmp1_, NULL, rygel_http_post_remove_item_ready, _data_);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 2045 "rygel-http-post.c"
	_state_1:
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_item_removal_queue_remove_now_finish (_data_->queue, _data_->_res_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2055 "rygel-http-post.c"
	} else {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2059 "rygel-http-post.c"
	}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	return FALSE;
#line 2065 "rygel-http-post.c"
}


static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self) {
	SoupMessage* _tmp0_;
	guint _tmp1_ = 0U;
	SoupMessage* _tmp2_;
	guint _tmp3_ = 0U;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_parse_name ("got-body", soup_message_get_type (), &_tmp1_, NULL, FALSE);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, self);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_tmp2_ = ((RygelHTTPRequest*) self)->msg;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_parse_name ("got-chunk", soup_message_get_type (), &_tmp3_, NULL, FALSE);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, self);
#line 2088 "rygel-http-post.c"
}


static void rygel_http_post_class_init (RygelHTTPPostClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPPostPrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_post_real_handle;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_post_real_handle_finish;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
#line 2103 "rygel-http-post.c"
}


static void rygel_http_post_instance_init (RygelHTTPPost * self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self->priv = RYGEL_HTTP_POST_GET_PRIVATE (self);
#line 2110 "rygel-http-post.c"
}


static void rygel_http_post_finalize (GObject* obj) {
	RygelHTTPPost * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_POST, RygelHTTPPost);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self->priv->handle_continue = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self->priv->handle_continue_target = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	self->priv->handle_continue_target_destroy_notify = NULL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (self->priv->file);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (self->priv->dotfile);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	_g_object_unref0 (self->priv->stream);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-post.vala"
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
#line 2134 "rygel-http-post.c"
}


/**
 * Responsible for handling HTTP POST client requests.
 */
GType rygel_http_post_get_type (void) {
	static volatile gsize rygel_http_post_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_type_id__volatile, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__volatile;
}



