/* rygel-media-server-plugin.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-media-server-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR (rygel_media_receiver_registrar_get_type ())
#define RYGEL_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrar))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))

typedef struct _RygelMediaReceiverRegistrar RygelMediaReceiverRegistrar;
typedef struct _RygelMediaReceiverRegistrarClass RygelMediaReceiverRegistrarClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_V1_HACKS (rygel_v1_hacks_get_type ())
#define RYGEL_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_V1_HACKS, RygelV1Hacks))
#define RYGEL_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))
#define RYGEL_IS_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_V1_HACKS))
#define RYGEL_IS_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_V1_HACKS))
#define RYGEL_V1_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))

typedef struct _RygelV1Hacks RygelV1Hacks;
typedef struct _RygelV1HacksClass RygelV1HacksClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelV1HacksPrivate RygelV1HacksPrivate;

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
	RygelMediaContainer* root_container;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaItem* item);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelV1Hacks {
	RygelClientHacks parent_instance;
	RygelV1HacksPrivate * priv;
	gchar* description_path;
};

struct _RygelV1HacksClass {
	RygelClientHacksClass parent_class;
};


static gpointer rygel_media_server_plugin_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_SERVER_PLUGIN_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH DATA_DIR "/xml/MediaServer2.xml"
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID "urn:microsoft-com:serviceId:X_MS_MediaReceiverRegistrar"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH "xml/X_MS_MediaReceiverRegistrar1.xml"
GType rygel_media_receiver_registrar_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated);
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
GQuark rygel_client_hacks_error_quark (void);
RygelV1Hacks* rygel_v1_hacks_new (GError** error);
RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, GError** error);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_v1_hacks_get_type (void) G_GNUC_CONST;
void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 340 "rygel-media-server-plugin.c"
}


static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_on_container_updated (self, _sender, container);
#line 347 "rygel-media-server-plugin.c"
}


RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description) {
	RygelMediaServerPlugin * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaContainer* _tmp6_;
	RygelResourceInfo* _tmp7_;
	RygelResourceInfo* info;
	RygelResourceInfo* _tmp8_;
	RygelResourceInfo* _tmp9_;
	RygelResourceInfo* _tmp10_;
	RygelResourceInfo* _tmp11_;
	RygelResourceInfo* _tmp12_;
	RygelMediaContainer* _tmp13_;
	gint _tmp14_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (root_container != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = name;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = root_container;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp1_);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = description;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) rygel_plugin_construct (object_type, RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH, _tmp0_, _tmp3_, _tmp4_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = root_container;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->root_container);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->root_container = _tmp6_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH, RYGEL_TYPE_CONTENT_DIRECTORY);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp7_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = info;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp8_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp9_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = info;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp10_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp11_ = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp11_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp12_ = info;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp12_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp13_ = root_container;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp14_ = _tmp13_->child_count;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp14_ == 0) {
#line 427 "rygel-media-server-plugin.c"
		const gchar* _tmp15_;
		RygelMediaContainer* _tmp16_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp15_ = ((RygelPlugin*) self)->name;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_debug ("rygel-media-server-plugin.vala:61: Deactivating plugin '%s' until it p" \
"rovides content.", _tmp15_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp16_ = root_container;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_signal_connect_object (_tmp16_, "container-updated", (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 440 "rygel-media-server-plugin.c"
	}
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self;
#line 446 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaServerPlugin * self;
	RygelV1Hacks* _tmp0_;
	RygelV1Hacks* v1_hacks;
	RygelV1Hacks* _tmp1_;
	RygelRootDevice* _tmp2_;
	const gchar* _tmp3_;
	RygelXBoxHacks* _tmp4_;
	RygelXBoxHacks* xbox_hacks;
	RygelXBoxHacks* _tmp5_;
	RygelRootDevice* _tmp6_;
	RygelV1Hacks* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) base;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (device != NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = rygel_v1_hacks_new (&_inner_error_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	v1_hacks = _tmp0_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 480 "rygel-media-server-plugin.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = v1_hacks;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = device;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = description_path;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_v1_hacks_apply_on_device (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 498 "rygel-media-server-plugin.c"
	}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = rygel_xbox_hacks_new (NULL, &_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	xbox_hacks = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 512 "rygel-media-server-plugin.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = xbox_hacks;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = device;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = v1_hacks;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = _tmp7_->description_path;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_xbox_hacks_apply_on_device (_tmp5_, _tmp6_, _tmp8_, &_inner_error_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_inner_error_ != NULL) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (xbox_hacks);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 534 "rygel-media-server-plugin.c"
	}
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (xbox_hacks);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (v1_hacks);
#line 540 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	gboolean _tmp5_;
	RygelMediaContainer* _tmp6_;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (root_container != NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (updated != NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = updated;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = root_container;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp1_ != _tmp2_) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = TRUE;
#line 566 "rygel-media-server-plugin.c"
	} else {
		RygelMediaContainer* _tmp3_;
		gint _tmp4_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = updated;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp4_ = _tmp3_->child_count;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = _tmp4_ == 0;
#line 576 "rygel-media-server-plugin.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = _tmp0_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp5_) {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 584 "rygel-media-server-plugin.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = root_container;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_parse_name ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, &_tmp7_, NULL, FALSE);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = ((RygelPlugin*) self)->name;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_debug ("rygel-media-server-plugin.vala:92: Activating plugin '%s' since it now" \
" provides content.", _tmp8_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_set_active ((RygelPlugin*) self, TRUE);
#line 598 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_class_init (RygelMediaServerPluginClass * klass) {
#line 24 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_media_server_plugin_real_apply_hacks;
#line 24 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_plugin_finalize;
#line 609 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_instance_init (RygelMediaServerPlugin * self) {
}


static void rygel_media_server_plugin_finalize (GObject* obj) {
	RygelMediaServerPlugin * self;
#line 24 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->root_container);
#line 24 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->finalize (obj);
#line 625 "rygel-media-server-plugin.c"
}


GType rygel_media_server_plugin_get_type (void) {
	static volatile gsize rygel_media_server_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServerPlugin), 0, (GInstanceInitFunc) rygel_media_server_plugin_instance_init, NULL };
		GType rygel_media_server_plugin_type_id;
		rygel_media_server_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaServerPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_server_plugin_type_id__volatile, rygel_media_server_plugin_type_id);
	}
	return rygel_media_server_plugin_type_id__volatile;
}



