/* rygel-transcode-manager.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-transcode-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;

#define RYGEL_TYPE_AAC_TRANSCODER (rygel_aac_transcoder_get_type ())
#define RYGEL_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoder))
#define RYGEL_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))
#define RYGEL_IS_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_IS_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_AAC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))

typedef struct _RygelAACTranscoder RygelAACTranscoder;
typedef struct _RygelAACTranscoderClass RygelAACTranscoderClass;

#define RYGEL_TYPE_AVC_TRANSCODER (rygel_avc_transcoder_get_type ())
#define RYGEL_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoder))
#define RYGEL_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))
#define RYGEL_IS_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_IS_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_AVC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))

typedef struct _RygelAVCTranscoder RygelAVCTranscoder;
typedef struct _RygelAVCTranscoderClass RygelAVCTranscoderClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelTranscodeManagerPrivate {
	GeeArrayList* transcoders;
};

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()

static gpointer rygel_transcode_manager_parent_class = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerPrivate))
enum  {
	RYGEL_TRANSCODE_MANAGER_DUMMY_PROPERTY
};
static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
RygelL16Transcoder* rygel_l16_transcoder_new (void);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
RygelMP3Transcoder* rygel_mp3_transcoder_new (void);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type);
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
RygelAACTranscoder* rygel_aac_transcoder_new (void);
RygelAACTranscoder* rygel_aac_transcoder_construct (GType object_type);
GType rygel_aac_transcoder_get_type (void) G_GNUC_CONST;
RygelAVCTranscoder* rygel_avc_transcoder_new (void);
RygelAVCTranscoder* rygel_avc_transcoder_construct (GType object_type);
GType rygel_avc_transcoder_get_type (void) G_GNUC_CONST;
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
GQuark rygel_http_request_error_quark (void);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self);
static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
static void rygel_transcode_manager_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 253 "rygel-transcode-manager.c"
}


static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	GUPnPProtocolInfo* protocol_a;
	void* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	GUPnPProtocolInfo* protocol_b;
	gboolean _tmp4_ = FALSE;
	GUPnPProtocolInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPProtocolInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp17_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp0_ = a;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GUPNP_TYPE_PROTOCOL_INFO) ? ((GUPnPProtocolInfo*) _tmp0_) : NULL);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	protocol_a = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp2_ = b;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GUPNP_TYPE_PROTOCOL_INFO) ? ((GUPnPProtocolInfo*) _tmp2_) : NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	protocol_b = _tmp3_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp5_ = protocol_a;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp6_ = gupnp_protocol_info_get_dlna_profile (_tmp5_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp7_ = _tmp6_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp8_ = protocol_b;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp9_ = gupnp_protocol_info_get_dlna_profile (_tmp8_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp10_ = _tmp9_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	if (g_strcmp0 (_tmp7_, _tmp10_) == 0) {
#line 299 "rygel-transcode-manager.c"
		GUPnPProtocolInfo* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GUPnPProtocolInfo* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp11_ = protocol_a;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp12_ = gupnp_protocol_info_get_mime_type (_tmp11_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp13_ = _tmp12_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp14_ = protocol_b;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp15_ = gupnp_protocol_info_get_mime_type (_tmp14_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp16_ = _tmp15_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 320 "rygel-transcode-manager.c"
	} else {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = FALSE;
#line 324 "rygel-transcode-manager.c"
	}
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp17_ = _tmp4_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	result = _tmp17_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_g_object_unref0 (protocol_b);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_g_object_unref0 (protocol_a);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return result;
#line 336 "rygel-transcode-manager.c"
}


RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type) {
	RygelTranscodeManager * self = NULL;
	GeeArrayList* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean transcoding;
	gboolean lpcm_transcoder;
	gboolean mp3_transcoder;
	gboolean mp2ts_transcoder;
	gboolean wmv_transcoder;
	gboolean aac_transcoder;
	gboolean avc_transcoder;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	self = (RygelTranscodeManager*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TRANSCODER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_g_object_unref0 (self->priv->transcoders);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	self->priv->transcoders = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	config = _tmp1_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	transcoding = TRUE;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	lpcm_transcoder = TRUE;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	mp3_transcoder = TRUE;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	mp2ts_transcoder = TRUE;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	wmv_transcoder = TRUE;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	aac_transcoder = TRUE;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	avc_transcoder = TRUE;
#line 380 "rygel-transcode-manager.c"
	{
		RygelMetaConfig* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp2_ = config;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp3_ = rygel_configuration_get_transcoding ((RygelConfiguration*) _tmp2_, &_inner_error_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_inner_error_ != NULL) {
#line 394 "rygel-transcode-manager.c"
			goto __catch50_g_error;
		}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		transcoding = _tmp4_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp5_ = transcoding;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp5_) {
#line 403 "rygel-transcode-manager.c"
			RygelMetaConfig* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			RygelMetaConfig* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			RygelMetaConfig* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			RygelMetaConfig* _tmp15_;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_;
			RygelMetaConfig* _tmp18_;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_;
			RygelMetaConfig* _tmp21_;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp6_ = config;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp7_ = rygel_configuration_get_lpcm_transcoder ((RygelConfiguration*) _tmp6_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp8_ = _tmp7_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 430 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			lpcm_transcoder = _tmp8_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp9_ = config;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp10_ = rygel_configuration_get_mp3_transcoder ((RygelConfiguration*) _tmp9_, &_inner_error_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp11_ = _tmp10_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 443 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			mp3_transcoder = _tmp11_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp12_ = config;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp13_ = rygel_configuration_get_mp2ts_transcoder ((RygelConfiguration*) _tmp12_, &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp14_ = _tmp13_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 456 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			mp2ts_transcoder = _tmp14_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp15_ = config;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp16_ = rygel_configuration_get_wmv_transcoder ((RygelConfiguration*) _tmp15_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp17_ = _tmp16_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 469 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			wmv_transcoder = _tmp17_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp18_ = config;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp19_ = rygel_configuration_get_aac_transcoder ((RygelConfiguration*) _tmp18_, &_inner_error_);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp20_ = _tmp19_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 482 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			aac_transcoder = _tmp20_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp21_ = config;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp22_ = rygel_configuration_get_avc_transcoder ((RygelConfiguration*) _tmp21_, &_inner_error_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp23_ = _tmp22_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_inner_error_ != NULL) {
#line 495 "rygel-transcode-manager.c"
				goto __catch50_g_error;
			}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			avc_transcoder = _tmp23_;
#line 500 "rygel-transcode-manager.c"
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* err = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		err = _inner_error_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_error_free0 (err);
#line 513 "rygel-transcode-manager.c"
	}
	__finally50:
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_object_unref0 (config);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		return NULL;
#line 526 "rygel-transcode-manager.c"
	}
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp24_ = transcoding;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	if (_tmp24_) {
#line 532 "rygel-transcode-manager.c"
		gboolean _tmp25_;
		gboolean _tmp29_;
		gboolean _tmp33_;
		gboolean _tmp40_;
		gboolean _tmp44_;
		gboolean _tmp48_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp25_ = lpcm_transcoder;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp25_) {
#line 543 "rygel-transcode-manager.c"
			GeeArrayList* _tmp26_;
			RygelL16Transcoder* _tmp27_;
			RygelL16Transcoder* _tmp28_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp26_ = self->priv->transcoders;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp27_ = rygel_l16_transcoder_new ();
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp28_ = _tmp27_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (RygelTranscoder*) _tmp28_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp28_);
#line 557 "rygel-transcode-manager.c"
		}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp29_ = mp3_transcoder;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp29_) {
#line 563 "rygel-transcode-manager.c"
			GeeArrayList* _tmp30_;
			RygelMP3Transcoder* _tmp31_;
			RygelMP3Transcoder* _tmp32_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp30_ = self->priv->transcoders;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp31_ = rygel_mp3_transcoder_new ();
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp32_ = _tmp31_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (RygelTranscoder*) _tmp32_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp32_);
#line 577 "rygel-transcode-manager.c"
		}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp33_ = mp2ts_transcoder;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp33_) {
#line 583 "rygel-transcode-manager.c"
			GeeArrayList* _tmp34_;
			RygelMP2TSTranscoder* _tmp35_;
			RygelMP2TSTranscoder* _tmp36_;
			GeeArrayList* _tmp37_;
			RygelMP2TSTranscoder* _tmp38_;
			RygelMP2TSTranscoder* _tmp39_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp34_ = self->priv->transcoders;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp35_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp36_ = _tmp35_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, (RygelTranscoder*) _tmp36_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp36_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp37_ = self->priv->transcoders;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp38_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp39_ = _tmp38_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (RygelTranscoder*) _tmp39_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp39_);
#line 610 "rygel-transcode-manager.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp40_ = wmv_transcoder;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp40_) {
#line 616 "rygel-transcode-manager.c"
			GeeArrayList* _tmp41_;
			RygelWMVTranscoder* _tmp42_;
			RygelWMVTranscoder* _tmp43_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp41_ = self->priv->transcoders;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp42_ = rygel_wmv_transcoder_new ();
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp43_ = _tmp42_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, (RygelTranscoder*) _tmp43_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp43_);
#line 630 "rygel-transcode-manager.c"
		}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp44_ = aac_transcoder;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp44_) {
#line 636 "rygel-transcode-manager.c"
			GeeArrayList* _tmp45_;
			RygelAACTranscoder* _tmp46_;
			RygelAACTranscoder* _tmp47_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp45_ = self->priv->transcoders;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp46_ = rygel_aac_transcoder_new ();
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp47_ = _tmp46_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, (RygelTranscoder*) _tmp47_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp47_);
#line 650 "rygel-transcode-manager.c"
		}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp48_ = avc_transcoder;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		if (_tmp48_) {
#line 656 "rygel-transcode-manager.c"
			GeeArrayList* _tmp49_;
			RygelAVCTranscoder* _tmp50_;
			RygelAVCTranscoder* _tmp51_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp49_ = self->priv->transcoders;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp50_ = rygel_avc_transcoder_new ();
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp51_ = _tmp50_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (RygelTranscoder*) _tmp51_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (_tmp51_);
#line 670 "rygel-transcode-manager.c"
		}
	}
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_g_object_unref0 (config);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return self;
#line 677 "rygel-transcode-manager.c"
}


static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_create_uri_for_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return NULL;
#line 686 "rygel-transcode-manager.c"
}


gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->create_uri_for_item (self, item, thumbnail_index, subtitle_index, transcode_target);
#line 695 "rygel-transcode-manager.c"
}


static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = rygel_media_item_compare_transcoders (self, a, b);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return result;
#line 704 "rygel-transcode-manager.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 711 "rygel-transcode-manager.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_list_free (self);
#line 720 "rygel-transcode-manager.c"
}


void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	GList* list;
	RygelMediaItem* _tmp17_;
	GList* _tmp18_;
	GError * _inner_error_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_if_fail (didl_item != NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_if_fail (item != NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	list = NULL;
#line 737 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _transcoder_size;
		gint _transcoder_index;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp0_ = self->priv->transcoders;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_list = _tmp1_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp2_ = _transcoder_list;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_size = _tmp4_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_index = -1;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		while (TRUE) {
#line 765 "rygel-transcode-manager.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* transcoder;
			RygelTranscoder* _tmp11_;
			RygelMediaItem* _tmp12_;
			guint _tmp13_ = 0U;
			guint _tmp14_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp5_ = _transcoder_index;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_transcoder_index = _tmp5_ + 1;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp6_ = _transcoder_index;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp7_ = _transcoder_size;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				break;
#line 789 "rygel-transcode-manager.c"
			}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp8_ = _transcoder_list;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp9_ = _transcoder_index;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			transcoder = (RygelTranscoder*) _tmp10_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp11_ = transcoder;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp12_ = item;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp13_ = rygel_transcoder_get_distance (_tmp11_, _tmp12_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp14_ = G_MAXUINT;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_tmp13_ != _tmp14_) {
#line 809 "rygel-transcode-manager.c"
				RygelTranscoder* _tmp15_;
				RygelTranscoder* _tmp16_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp15_ = transcoder;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				list = g_list_append (list, _tmp16_);
#line 818 "rygel-transcode-manager.c"
			}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (transcoder);
#line 822 "rygel-transcode-manager.c"
		}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_object_unref0 (_transcoder_list);
#line 826 "rygel-transcode-manager.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp17_ = item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	list = g_list_sort_with_data (list, _rygel_media_item_compare_transcoders_gcompare_data_func, _tmp17_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp18_ = list;
#line 834 "rygel-transcode-manager.c"
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		transcoder_collection = _tmp18_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
#line 842 "rygel-transcode-manager.c"
			RygelTranscoder* _tmp19_;
			RygelTranscoder* transcoder = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp19_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			transcoder = _tmp19_;
#line 849 "rygel-transcode-manager.c"
			{
				RygelTranscoder* _tmp20_;
				GUPnPDIDLLiteItem* _tmp21_;
				RygelMediaItem* _tmp22_;
				GUPnPDIDLLiteResource* _tmp23_ = NULL;
				GUPnPDIDLLiteResource* _tmp24_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp20_ = transcoder;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp21_ = didl_item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp22_ = item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp23_ = rygel_transcoder_add_resource (_tmp20_, _tmp21_, _tmp22_, self, &_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp24_ = _tmp23_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_g_object_unref0 (_tmp24_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				if (_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
					g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
					_g_object_unref0 (transcoder);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
					__g_list_free__g_object_unref0_0 (list);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
					return;
#line 878 "rygel-transcode-manager.c"
				}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_g_object_unref0 (transcoder);
#line 882 "rygel-transcode-manager.c"
			}
		}
	}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	__g_list_free__g_object_unref0_0 (list);
#line 888 "rygel-transcode-manager.c"
}


RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* transcoder;
	RygelTranscoder* _tmp16_;
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	transcoder = NULL;
#line 903 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _iter_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _iter_size;
		gint _iter_index;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp0_ = self->priv->transcoders;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_iter_list = _tmp1_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp2_ = _iter_list;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = _tmp3_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_iter_size = _tmp4_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_iter_index = -1;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		while (TRUE) {
#line 931 "rygel-transcode-manager.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* iter;
			RygelTranscoder* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp5_ = _iter_index;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_iter_index = _tmp5_ + 1;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp6_ = _iter_index;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp7_ = _iter_size;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				break;
#line 954 "rygel-transcode-manager.c"
			}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp8_ = _iter_list;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp9_ = _iter_index;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			iter = (RygelTranscoder*) _tmp10_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp11_ = iter;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp12_ = target;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp13_ = rygel_transcoder_can_handle (_tmp11_, _tmp12_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (_tmp13_) {
#line 972 "rygel-transcode-manager.c"
				RygelTranscoder* _tmp14_;
				RygelTranscoder* _tmp15_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp14_ = iter;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_tmp15_ = _g_object_ref0 (_tmp14_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				_g_object_unref0 (transcoder);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				transcoder = _tmp15_;
#line 983 "rygel-transcode-manager.c"
			}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (iter);
#line 987 "rygel-transcode-manager.c"
		}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_object_unref0 (_iter_list);
#line 991 "rygel-transcode-manager.c"
	}
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp16_ = transcoder;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	if (_tmp16_ == NULL) {
#line 997 "rygel-transcode-manager.c"
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp17_ = _ ("No transcoder available for target format '%s'");
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp18_ = target;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp19_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp17_, _tmp18_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_inner_error_ = _tmp19_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		g_propagate_error (error, _inner_error_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_object_unref0 (transcoder);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		return NULL;
#line 1015 "rygel-transcode-manager.c"
	}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	result = transcoder;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return result;
#line 1021 "rygel-transcode-manager.c"
}


static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_get_protocol'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return NULL;
#line 1030 "rygel-transcode-manager.c"
}


gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol (self);
#line 1039 "rygel-transcode-manager.c"
}


static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = rygel_transcode_manager_protocol_equal_func (a, b);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return result;
#line 1048 "rygel-transcode-manager.c"
}


static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* protocol_infos;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_tmp0_ = gee_array_list_new (GUPNP_TYPE_PROTOCOL_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_transcode_manager_protocol_equal_func_gequal_func);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	protocol_infos = _tmp0_;
#line 1060 "rygel-transcode-manager.c"
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _transcoder_size;
		gint _transcoder_index;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp1_ = self->priv->transcoders;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_list = _tmp2_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp3_ = _transcoder_list;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_tmp5_ = _tmp4_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_size = _tmp5_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_transcoder_index = -1;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		while (TRUE) {
#line 1088 "rygel-transcode-manager.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelTranscoder* transcoder;
			GUPnPProtocolInfo* _tmp12_;
			GUPnPProtocolInfo* protocol_info;
			GUPnPProtocolInfo* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			GUPnPProtocolInfo* _tmp16_;
			RygelTranscoder* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			GUPnPProtocolInfo* _tmp20_;
			RygelTranscoder* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			GeeArrayList* _tmp24_;
			GUPnPProtocolInfo* _tmp25_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp6_ = _transcoder_index;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_transcoder_index = _tmp6_ + 1;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp7_ = _transcoder_index;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp8_ = _transcoder_size;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
				break;
#line 1123 "rygel-transcode-manager.c"
			}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp9_ = _transcoder_list;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp10_ = _transcoder_index;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			transcoder = (RygelTranscoder*) _tmp11_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp12_ = gupnp_protocol_info_new ();
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			protocol_info = _tmp12_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp13_ = protocol_info;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp14_ = rygel_transcode_manager_get_protocol (self);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp15_ = _tmp14_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_protocol (_tmp13_, _tmp15_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_free0 (_tmp15_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp16_ = protocol_info;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp17_ = transcoder;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp18_ = rygel_transcoder_get_mime_type (_tmp17_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp19_ = _tmp18_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_mime_type (_tmp16_, _tmp19_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp20_ = protocol_info;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp21_ = transcoder;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp22_ = rygel_transcoder_get_dlna_profile (_tmp21_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp23_ = _tmp22_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gupnp_protocol_info_set_dlna_profile (_tmp20_, _tmp23_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp24_ = protocol_infos;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_tmp25_ = protocol_info;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (protocol_info);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
			_g_object_unref0 (transcoder);
#line 1177 "rygel-transcode-manager.c"
		}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
		_g_object_unref0 (_transcoder_list);
#line 1181 "rygel-transcode-manager.c"
	}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	result = protocol_infos;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return result;
#line 1187 "rygel-transcode-manager.c"
}


GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol_info (self);
#line 1196 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_class_init (RygelTranscodeManagerClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	rygel_transcode_manager_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscodeManagerPrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_transcode_manager_real_create_uri_for_item;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_transcode_manager_real_get_protocol;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_transcode_manager_real_get_protocol_info;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcode_manager_finalize;
#line 1213 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_instance_init (RygelTranscodeManager * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	self->priv = RYGEL_TRANSCODE_MANAGER_GET_PRIVATE (self);
#line 1220 "rygel-transcode-manager.c"
}


static void rygel_transcode_manager_finalize (GObject* obj) {
	RygelTranscodeManager * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	_g_object_unref0 (self->priv->transcoders);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcode-manager.vala"
	G_OBJECT_CLASS (rygel_transcode_manager_parent_class)->finalize (obj);
#line 1232 "rygel-transcode-manager.c"
}


/**
 * Responsible for management of all transcoders:
 *    - gets the appropriate transcoder given a transcoding target.
 *    - provide all possible transcoding resources for items.
 */
GType rygel_transcode_manager_get_type (void) {
	static volatile gsize rygel_transcode_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcode_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcode_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodeManager), 0, (GInstanceInitFunc) rygel_transcode_manager_instance_init, NULL };
		GType rygel_transcode_manager_type_id;
		rygel_transcode_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscodeManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcode_manager_type_id__volatile, rygel_transcode_manager_type_id);
	}
	return rygel_transcode_manager_type_id__volatile;
}



