/* rygel-transcoder.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_encoding_profile_unref0(var) ((var == NULL) ? NULL : (var = (gst_encoding_profile_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelTranscoder* self);
};

struct _RygelTranscoderPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
	gchar* _preset;
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
	gchar* _upnp_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_MIME_TYPE,
	RYGEL_TRANSCODER_DLNA_PROFILE,
	RYGEL_TRANSCODER_EXTENSION,
	RYGEL_TRANSCODER_PRESET,
	RYGEL_TRANSCODER_UPNP_CLASS
};
#define RYGEL_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#define RYGEL_TRANSCODER_DECODE_BIN "decodebin2"
#define RYGEL_TRANSCODER_ENCODE_BIN "encodebin"
#define RYGEL_TRANSCODER_description "Encoder and decoder are not " "compatible"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class, const gchar* extension);
void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value);
void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value);
void rygel_transcoder_set_upnp_class (RygelTranscoder* self, const gchar* value);
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
GstElement* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
static GstElement* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstEncodingProfile* rygel_transcoder_get_encoding_profile (RygelTranscoder* self);
static inline void _dynamic_set_profile4 (GstElement* obj, GstEncodingProfile* value);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
static inline GstEncodingProfile* _dynamic_get_profile5 (GstElement* obj);
static void rygel_transcoder_on_decoder_pad_added (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad);
static void _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static void rygel_transcoder_on_no_more_pads (RygelTranscoder* self, GstElement* decodebin);
static void _rygel_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static GstEncodingProfile* rygel_transcoder_real_get_encoding_profile (RygelTranscoder* self);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
const gchar* rygel_transcoder_get_preset (RygelTranscoder* self);
void rygel_transcoder_set_preset (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_upnp_class (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (dlna_profile != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = mime_type;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_set_mime_type (self, _tmp0_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = dlna_profile;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_set_dlna_profile (self, _tmp1_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp2_ = upnp_class;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_set_upnp_class (self, _tmp2_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->link_failed = TRUE;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp3_ = extension;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_set_extension (self, _tmp3_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return self;
#line 292 "rygel-transcoder.c"
}


/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static inline void _dynamic_set_profile4 (GstElement* obj, GstEncodingProfile* value) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_set (obj, "profile", value, NULL);
#line 307 "rygel-transcoder.c"
}


static inline GstEncodingProfile* _dynamic_get_profile5 (GstElement* obj) {
	GstEncodingProfile* result;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_get (obj, "profile", &result, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 317 "rygel-transcoder.c"
}


static void _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_on_decoder_pad_added (self, _sender, pad);
#line 324 "rygel-transcoder.c"
}


static void _rygel_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_on_no_more_pads (self, _sender);
#line 331 "rygel-transcoder.c"
}


static GstElement* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_;
	GstElement* _tmp4_;
	GstEncodingProfile* _tmp5_ = NULL;
	GstEncodingProfile* _tmp6_;
	GObjectClass* _tmp7_ = NULL;
	GType _tmp8_ = 0UL;
	const gchar* _tmp9_ = NULL;
	GstElement* _tmp10_;
	GstEncodingProfile* _tmp11_;
	GstEncodingProfile* _tmp12_;
	GstBin* _tmp13_;
	GstBin* bin;
	GstBin* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	GstElement* _tmp19_;
	GstElement* _tmp20_;
	GstElement* _tmp21_;
	GstElement* _tmp22_;
	GstPad* _tmp23_ = NULL;
	GstPad* pad;
	GstPad* _tmp24_;
	GstGhostPad* _tmp25_;
	GstGhostPad* ghost;
	GstBin* _tmp26_;
	GstGhostPad* _tmp27_;
	GError * _inner_error_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = rygel_gst_utils_create_element (RYGEL_TRANSCODER_DECODE_BIN, RYGEL_TRANSCODER_DECODE_BIN, &_inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = _tmp0_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		return NULL;
#line 383 "rygel-transcoder.c"
	}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (self->priv->decoder);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->decoder = _tmp1_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp2_ = rygel_gst_utils_create_element (RYGEL_TRANSCODER_ENCODE_BIN, RYGEL_TRANSCODER_ENCODE_BIN, &_inner_error_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		return NULL;
#line 399 "rygel-transcoder.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (self->priv->encoder);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->encoder = _tmp3_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp4_ = self->priv->encoder;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp5_ = rygel_transcoder_get_encoding_profile (self);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp6_ = _tmp5_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_dynamic_set_profile4 (_tmp4_, _tmp6_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_encoding_profile_unref0 (_tmp6_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp7_ = G_OBJECT_GET_CLASS ((GObject*) self);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp8_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp7_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp9_ = g_type_name (_tmp8_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_debug ("rygel-transcoder.vala:79: %s using the following encoding profile:", _tmp9_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp10_ = self->priv->encoder;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp11_ = _dynamic_get_profile5 (_tmp10_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp12_ = _tmp11_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_gst_utils_dump_encoding_profile (_tmp12_, 2);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp13_ = (GstBin*) gst_bin_new ("transcoder-source");
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gst_object_ref_sink (_tmp13_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	bin = _tmp13_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp14_ = bin;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp15_ = src;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp16_ = self->priv->decoder;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp17_ = self->priv->encoder;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gst_bin_add_many (_tmp14_, _tmp15_, _tmp16_, _tmp17_, NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp18_ = src;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp19_ = self->priv->decoder;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gst_element_link (_tmp18_, _tmp19_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp20_ = self->priv->decoder;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_signal_connect_object (_tmp20_, "pad-added", (GCallback) _rygel_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp21_ = self->priv->decoder;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_signal_connect_object (_tmp21_, "no-more-pads", (GCallback) _rygel_transcoder_on_no_more_pads_gst_element_no_more_pads, self, 0);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp22_ = self->priv->encoder;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp23_ = gst_element_get_static_pad (_tmp22_, "src");
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	pad = _tmp23_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp24_ = pad;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp25_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp24_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gst_object_ref_sink (_tmp25_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	ghost = _tmp25_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp26_ = bin;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp27_ = ghost;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp26_, (GstPad*) _tmp27_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = (GstElement*) bin;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (pad);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 489 "rygel-transcoder.c"
}


GstElement* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return RYGEL_TRANSCODER_GET_CLASS (self)->create_source (self, item, src, error);
#line 498 "rygel-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 505 "rygel-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_;
	RygelTranscodeManager* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* protocol;
	RygelTranscodeManager* _tmp11_;
	RygelMediaItem* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* uri;
	RygelMediaItem* _tmp15_;
	GUPnPDIDLLiteItem* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GUPnPDIDLLiteResource* _tmp19_ = NULL;
	GUPnPDIDLLiteResource* res;
	GUPnPDIDLLiteResource* _tmp20_;
	GUPnPDIDLLiteResource* _tmp21_;
	GUPnPProtocolInfo* _tmp22_;
	GUPnPProtocolInfo* _tmp23_;
	GUPnPProtocolInfo* _tmp24_;
	GUPnPProtocolInfo* protocol_info;
	GUPnPProtocolInfo* _tmp25_;
	const gchar* _tmp26_;
	GUPnPProtocolInfo* _tmp27_;
	const gchar* _tmp28_;
	GUPnPProtocolInfo* _tmp29_;
	GUPnPProtocolInfo* _tmp30_;
	gboolean _tmp31_ = FALSE;
	RygelMediaItem* _tmp32_;
	gboolean _tmp35_;
	GError * _inner_error_ = NULL;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = item;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp2_ = _tmp1_->mime_type;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp3_ = self->priv->_mime_type;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp4_ = rygel_transcoder_mime_type_is_a (self, _tmp2_, _tmp3_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp4_) {
#line 563 "rygel-transcoder.c"
		const gchar* _tmp5_;
		RygelMediaItem* _tmp6_;
		const gchar* _tmp7_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp5_ = self->priv->_dlna_profile;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp6_ = item;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp7_ = _tmp6_->dlna_profile;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp0_ = g_strcmp0 (_tmp5_, _tmp7_) == 0;
#line 575 "rygel-transcoder.c"
	} else {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp0_ = FALSE;
#line 579 "rygel-transcoder.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp8_ = _tmp0_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp8_) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		result = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		return result;
#line 589 "rygel-transcoder.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp9_ = manager;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp10_ = rygel_transcode_manager_get_protocol (_tmp9_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	protocol = _tmp10_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp11_ = manager;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp12_ = item;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp13_ = self->priv->_dlna_profile;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp14_ = rygel_transcode_manager_create_uri_for_item (_tmp11_, _tmp12_, -1, -1, _tmp13_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	uri = _tmp14_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp15_ = item;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp16_ = didl_item;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp17_ = uri;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp18_ = protocol;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp19_ = rygel_media_item_add_resource (_tmp15_, _tmp16_, _tmp17_, _tmp18_, NULL, &_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	res = _tmp19_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_free0 (uri);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_free0 (protocol);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		return NULL;
#line 629 "rygel-transcoder.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp20_ = res;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gupnp_didl_lite_resource_set_size (_tmp20_, (glong) (-1));
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp21_ = res;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp22_ = gupnp_didl_lite_resource_get_protocol_info (_tmp21_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp23_ = _tmp22_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	protocol_info = _tmp24_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp25_ = protocol_info;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp26_ = self->priv->_mime_type;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gupnp_protocol_info_set_mime_type (_tmp25_, _tmp26_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp27_ = protocol_info;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp28_ = self->priv->_dlna_profile;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gupnp_protocol_info_set_dlna_profile (_tmp27_, _tmp28_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp29_ = protocol_info;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gupnp_protocol_info_set_dlna_conversion (_tmp29_, GUPNP_DLNA_CONVERSION_TRANSCODED);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp30_ = protocol_info;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	gupnp_protocol_info_set_dlna_flags (_tmp30_, ((GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp32_ = item;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 669 "rygel-transcoder.c"
		RygelMediaItem* _tmp33_;
		glong _tmp34_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp33_ = item;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp34_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp33_) : NULL)->duration;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp31_ = _tmp34_ > ((glong) 0);
#line 678 "rygel-transcoder.c"
	} else {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp31_ = FALSE;
#line 682 "rygel-transcoder.c"
	}
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp35_ = _tmp31_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp35_) {
#line 688 "rygel-transcoder.c"
		GUPnPProtocolInfo* _tmp36_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp36_ = protocol_info;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		gupnp_protocol_info_set_dlna_operation (_tmp36_, GUPNP_DLNA_OPERATION_TIMESEEK);
#line 694 "rygel-transcoder.c"
	} else {
		GUPnPProtocolInfo* _tmp37_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp37_ = protocol_info;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		gupnp_protocol_info_set_dlna_operation (_tmp37_, GUPNP_DLNA_OPERATION_NONE);
#line 701 "rygel-transcoder.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = res;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_object_unref0 (protocol_info);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (uri);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (protocol);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 713 "rygel-transcoder.c"
}


GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return RYGEL_TRANSCODER_GET_CLASS (self)->add_resource (self, didl_item, item, manager, error);
#line 722 "rygel-transcoder.c"
}


gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (target != NULL, FALSE);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = target;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = self->priv->_dlna_profile;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = g_strcmp0 (_tmp0_, _tmp1_) == 0;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 742 "rygel-transcoder.c"
}


/**
     * Gets the numeric value that gives an gives an estimate of how hard
     * would it be to trancode @item to target profile of this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return 0U;
#line 761 "rygel-transcoder.c"
}


guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return RYGEL_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
#line 770 "rygel-transcoder.c"
}


/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile* rygel_transcoder_real_get_encoding_profile (RygelTranscoder* self) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return NULL;
#line 784 "rygel-transcoder.c"
}


GstEncodingProfile* rygel_transcoder_get_encoding_profile (RygelTranscoder* self) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return RYGEL_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self);
#line 793 "rygel-transcoder.c"
}


gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* content_type1;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* content_type2;
	gboolean _tmp4_ = FALSE;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = mime_type1;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_content_type_get_mime_type (_tmp0_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	content_type1 = _tmp1_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp2_ = mime_type2;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp3_ = g_content_type_get_mime_type (_tmp2_);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	content_type2 = _tmp3_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp4_ = g_content_type_is_a (content_type1, content_type2);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp4_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (content_type2);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (content_type1);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 834 "rygel-transcoder.c"
}


static void rygel_transcoder_on_decoder_pad_added (RygelTranscoder* self, GstElement* decodebin, GstPad* new_pad) {
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_;
	GstPad* _tmp1_;
	GstPad* _tmp2_ = NULL;
	GstPad* _tmp3_;
	GstPad* _tmp8_;
	GstPad* _tmp13_;
	GstPad* _tmp14_;
	GstPadLinkReturn _tmp15_ = 0;
	gboolean pad_link_ok;
	gboolean _tmp16_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (new_pad != NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->encoder;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = new_pad;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp2_ = gst_element_get_compatible_pad (_tmp0_, _tmp1_, NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (sinkpad);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	sinkpad = _tmp2_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp3_ = sinkpad;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp3_ == NULL) {
#line 870 "rygel-transcoder.c"
		GstPad* _tmp4_;
		GstCaps* _tmp5_ = NULL;
		GstCaps* caps;
		GstElement* _tmp6_;
		GstCaps* _tmp7_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp4_ = new_pad;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp5_ = gst_pad_get_caps_reffed (_tmp4_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		caps = _tmp5_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp6_ = self->priv->encoder;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp7_ = caps;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_signal_emit_by_name (_tmp6_, "request-pad", _tmp7_, &sinkpad, NULL);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_gst_caps_unref0 (caps);
#line 890 "rygel-transcoder.c"
	}
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp8_ = sinkpad;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp8_ == NULL) {
#line 896 "rygel-transcoder.c"
		GstPad* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp9_ = new_pad;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp10_ = gst_object_get_name ((GstObject*) _tmp9_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp11_ = _tmp10_;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp12_ = _tmp11_;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_debug ("rygel-transcoder.vala:173: No compatible encodebin pad found for pad '" \
"%s', ignoring..", _tmp12_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_free0 (_tmp12_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_gst_object_unref0 (sinkpad);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		return;
#line 917 "rygel-transcoder.c"
	}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp13_ = new_pad;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp14_ = sinkpad;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp15_ = gst_pad_link (_tmp13_, _tmp14_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	pad_link_ok = _tmp15_ == GST_PAD_LINK_OK;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp16_ = pad_link_ok;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (!_tmp16_) {
#line 931 "rygel-transcoder.c"
		GstPad* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GstPad* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp17_ = new_pad;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp19_ = _tmp18_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp20_ = _tmp19_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp21_ = sinkpad;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp22_ = gst_object_get_name ((GstObject*) _tmp21_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp23_ = _tmp22_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp24_ = _tmp23_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_warning ("rygel-transcoder.vala:181: Failed to link pad '%s' to '%s'", _tmp20_, _tmp24_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_free0 (_tmp24_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_free0 (_tmp20_);
#line 962 "rygel-transcoder.c"
	} else {
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		self->priv->link_failed = FALSE;
#line 966 "rygel-transcoder.c"
	}
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (sinkpad);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return;
#line 972 "rygel-transcoder.c"
}


static gpointer _gst_message_ref0 (gpointer self) {
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return self ? gst_message_ref (self) : NULL;
#line 979 "rygel-transcoder.c"
}


static void rygel_transcoder_on_no_more_pads (RygelTranscoder* self, GstElement* decodebin) {
	gboolean _tmp0_;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->link_failed;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	if (_tmp0_) {
#line 993 "rygel-transcoder.c"
		GstElement* _tmp1_;
		GstObject* _tmp2_ = NULL;
		GstBin* bin;
		GError* _tmp3_;
		GError* _error_;
		GstBin* _tmp4_;
		GError* _tmp5_;
		GstMessage* _tmp6_;
		GstMessage* message;
		GstBin* _tmp7_;
		GstBus* _tmp8_ = NULL;
		GstBus* bus;
		GstBus* _tmp9_;
		GstMessage* _tmp10_;
		GstMessage* _tmp11_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp1_ = self->priv->encoder;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp2_ = gst_object_get_parent ((GstObject*) _tmp1_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		bin = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GST_TYPE_BIN) ? ((GstBin*) _tmp2_) : NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_error_ = _tmp3_;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp4_ = bin;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp5_ = _error_;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp6_ = gst_message_new_error ((GstObject*) _tmp4_, _tmp5_, RYGEL_TRANSCODER_description);
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		message = _tmp6_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp7_ = bin;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp8_ = gst_element_get_bus ((GstElement*) _tmp7_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		bus = _tmp8_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp9_ = bus;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp10_ = message;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_tmp11_ = _gst_message_ref0 (_tmp10_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		gst_bus_post (_tmp9_, _tmp11_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_gst_object_unref0 (bus);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_gst_message_unref0 (message);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_g_error_free0 (_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		_gst_object_unref0 (bin);
#line 1049 "rygel-transcoder.c"
	}
}


const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->_mime_type;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 1065 "rygel-transcoder.c"
}


void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = value;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_mime_type);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_mime_type = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 1084 "rygel-transcoder.c"
}


const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->_dlna_profile;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 1099 "rygel-transcoder.c"
}


void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = value;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_dlna_profile = _tmp1_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_notify ((GObject *) self, "dlna-profile");
#line 1118 "rygel-transcoder.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->_extension;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 1133 "rygel-transcoder.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = value;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_extension);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_extension = _tmp1_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_notify ((GObject *) self, "extension");
#line 1152 "rygel-transcoder.c"
}


const gchar* rygel_transcoder_get_preset (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->_preset;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 1167 "rygel-transcoder.c"
}


void rygel_transcoder_set_preset (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_preset = _tmp1_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_notify ((GObject *) self, "preset");
#line 1186 "rygel-transcoder.c"
}


const gchar* rygel_transcoder_get_upnp_class (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = self->priv->_upnp_class;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	return result;
#line 1201 "rygel-transcoder.c"
}


void rygel_transcoder_set_upnp_class (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_upnp_class);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_upnp_class = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_notify ((GObject *) self, "upnp-class");
#line 1220 "rygel-transcoder.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_transcoder_real_create_source;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_transcoder_real_add_resource;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_transcoder_real_get_distance;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_encoding_profile = rygel_transcoder_real_get_encoding_profile;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_PRESET, g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1253 "rygel-transcoder.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	gchar* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_tmp0_ = g_strdup (RYGEL_TRANSCODER_DEFAULT_ENCODING_PRESET);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self->priv->_preset = _tmp0_;
#line 1265 "rygel-transcoder.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_mime_type);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_extension);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (self->priv->decoder);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_gst_object_unref0 (self->priv->encoder);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	_g_free0 (self->priv->_upnp_class);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 1289 "rygel-transcoder.c"
}


/**
 * The base Transcoder class. Each implementation derives from it and must
 * implement get_distance and get_encoding_profile methods.
 */
GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_MIME_TYPE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_value_set_string (value, rygel_transcoder_get_mime_type (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_DLNA_PROFILE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_value_set_string (value, rygel_transcoder_get_dlna_profile (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_PRESET:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_value_set_string (value, rygel_transcoder_get_preset (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_UPNP_CLASS:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		g_value_set_string (value, rygel_transcoder_get_upnp_class (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 1344 "rygel-transcoder.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 1350 "rygel-transcoder.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_MIME_TYPE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		rygel_transcoder_set_mime_type (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_DLNA_PROFILE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		rygel_transcoder_set_dlna_profile (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_PRESET:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		rygel_transcoder_set_preset (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		case RYGEL_TRANSCODER_UPNP_CLASS:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		rygel_transcoder_set_upnp_class (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 1390 "rygel-transcoder.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-transcoder.vala"
		break;
#line 1396 "rygel-transcoder.c"
	}
}



