/**
 * SECTION:rygel-transcoder
 * @short_description: The base Transcoder class. Each implementation derives from it and must implement get_distance.
 */
/**
 * RYGEL_TYPE_TRANSCODER
 * 
 * The type for <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link>.
 */
/**
 * rygel_transcoder_create_source
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance
 * @src: (in): the media item to create the transcoding source for 
 * @src: (in): the original (non-transcoding) source 
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Creates a transcoding source.
 * 
 * Returns: the new transcoding source 
 */
/**
 * rygel_transcoder_add_resource
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance
 * @error: location to store the error occuring, or %NULL to ignore
 */
/**
 * rygel_transcoder_can_handle
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance
 */
/**
 * rygel_transcoder_get_distance
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance
 * @item: (in): the media item to calculate the distance for 
 * 
 * Gets the numeric value that gives an gives an estimate of how hard would it be to trancode @item to target profile of this transcoder.
 * 
 * Returns: the distance from the @item, uint.MIN if providing such a value is impossible or uint.MAX if it doesn't make any sense to use this transcoder for @item 
 */
/**
 * rygel_transcoder_mime_type_is_a
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance
 */
/**
 * RygelTranscoder:mime-type
 */
/**
 * rygel_transcoder_get_mime_type
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to query
 * 
 * Returns: the value of the <link linkend="RygelTranscoder--mime-type"><type>"mime-type"</type></link> property
 */
/**
 * rygel_transcoder_set_mime_type
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to modify
 * @value: the new value of the <link linkend="RygelTranscoder--mime-type"><type>"mime-type"</type></link> property
 */
/**
 * RygelTranscoder:dlna-profile
 */
/**
 * rygel_transcoder_get_dlna_profile
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to query
 * 
 * Returns: the value of the <link linkend="RygelTranscoder--dlna-profile"><type>"dlna-profile"</type></link> property
 */
/**
 * rygel_transcoder_set_dlna_profile
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to modify
 * @value: the new value of the <link linkend="RygelTranscoder--dlna-profile"><type>"dlna-profile"</type></link> property
 */
/**
 * RygelTranscoder:extension
 */
/**
 * rygel_transcoder_get_extension
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to query
 * 
 * Returns: the value of the <link linkend="RygelTranscoder--extension"><type>"extension"</type></link> property
 */
/**
 * rygel_transcoder_set_extension
 * @self: the <link linkend="RygelTranscoder"><type>RygelTranscoder</type></link> instance to modify
 * @value: the new value of the <link linkend="RygelTranscoder--extension"><type>"extension"</type></link> property
 */
/**
 * RygelTranscoder
 * 
 * The base Transcoder class. Each implementation derives from it and must implement get_distance.
 */
