/* rygel-media-engine-test.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-media-engine-test.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libsoup/soup.h>
#include <gee.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG (rygel_data_source_test_config_get_type ())
#define RYGEL_DATA_SOURCE_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfig))
#define RYGEL_DATA_SOURCE_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigClass))
#define RYGEL_IS_DATA_SOURCE_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG))
#define RYGEL_IS_DATA_SOURCE_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG))
#define RYGEL_DATA_SOURCE_TEST_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigClass))

typedef struct _RygelDataSourceTestConfig RygelDataSourceTestConfig;
typedef struct _RygelDataSourceTestConfigClass RygelDataSourceTestConfigClass;
typedef struct _RygelDataSourceTestConfigPrivate RygelDataSourceTestConfigPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_BYTE_SEEK (rygel_byte_seek_get_type ())
#define RYGEL_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BYTE_SEEK, RygelByteSeek))
#define RYGEL_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BYTE_SEEK, RygelByteSeekClass))
#define RYGEL_IS_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BYTE_SEEK))
#define RYGEL_IS_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BYTE_SEEK))
#define RYGEL_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BYTE_SEEK, RygelByteSeekClass))

typedef struct _RygelByteSeek RygelByteSeek;
typedef struct _RygelByteSeekClass RygelByteSeekClass;
typedef struct _RygelByteSeekPrivate RygelByteSeekPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_BLOCK (data_block_get_type ())
#define DATA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_BLOCK, DataBlock))
#define DATA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_BLOCK, DataBlockClass))
#define IS_DATA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_BLOCK))
#define IS_DATA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_BLOCK))
#define DATA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_BLOCK, DataBlockClass))

typedef struct _DataBlock DataBlock;
typedef struct _DataBlockClass DataBlockClass;
typedef struct _DataBlockPrivate DataBlockPrivate;
typedef struct _ParamSpecDataBlock ParamSpecDataBlock;

#define RYGEL_TYPE_DATA_POOL (rygel_data_pool_get_type ())
#define RYGEL_DATA_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_POOL, RygelDataPool))
#define RYGEL_DATA_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_POOL, RygelDataPoolClass))
#define RYGEL_IS_DATA_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_POOL))
#define RYGEL_IS_DATA_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_POOL))
#define RYGEL_DATA_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_POOL, RygelDataPoolClass))

typedef struct _RygelDataPool RygelDataPool;
typedef struct _RygelDataPoolClass RygelDataPoolClass;
typedef struct _RygelDataPoolPrivate RygelDataPoolPrivate;
#define _data_block_unref0(var) ((var == NULL) ? NULL : (var = (data_block_unref (var), NULL)))

#define RYGEL_TYPE_DATA_SOURCE_TEST (rygel_data_source_test_get_type ())
#define RYGEL_DATA_SOURCE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTest))
#define RYGEL_DATA_SOURCE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestClass))
#define RYGEL_IS_DATA_SOURCE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE_TEST))
#define RYGEL_IS_DATA_SOURCE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATA_SOURCE_TEST))
#define RYGEL_DATA_SOURCE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestClass))

typedef struct _RygelDataSourceTest RygelDataSourceTest;
typedef struct _RygelDataSourceTestClass RygelDataSourceTestClass;
typedef struct _RygelDataSourceTestPrivate RygelDataSourceTestPrivate;
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDataSourceTestConfig {
	RygelBaseConfiguration parent_instance;
	RygelDataSourceTestConfigPrivate * priv;
};

struct _RygelDataSourceTestConfigClass {
	RygelBaseConfigurationClass parent_class;
};

struct _RygelDataSourceTestConfigPrivate {
	gchar* engine;
	gchar* path;
};

struct _RygelByteSeek {
	RygelHTTPSeek parent_instance;
	RygelByteSeekPrivate * priv;
};

struct _RygelByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _DataBlock {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataBlockPrivate * priv;
	guint8* data;
	gint data_length1;
	gint _data_size_;
};

struct _DataBlockClass {
	GTypeClass parent_class;
	void (*finalize) (DataBlock *self);
};

struct _ParamSpecDataBlock {
	GParamSpec parent_instance;
};

struct _RygelDataPool {
	GeeArrayList parent_instance;
	RygelDataPoolPrivate * priv;
};

struct _RygelDataPoolClass {
	GeeArrayListClass parent_class;
};

struct _RygelDataSourceTest {
	GObject parent_instance;
	RygelDataSourceTestPrivate * priv;
};

struct _RygelDataSourceTestClass {
	GObjectClass parent_class;
};

struct _RygelDataSourceTestPrivate {
	GFile* test_data_file;
	GMappedFile* test_data_mapped;
};

struct _Block1Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	guint64 received_bytes;
	GMainLoop* loop;
};

struct _Block2Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataPool* received_data;
	GMainLoop* loop;
};

struct _Block3Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	RygelDataPool* pool;
	GMainLoop* loop;
};

struct _Block4Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	GMainLoop* loop;
};

struct _Block5Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	RygelDataSource* source;
	GMainLoop* loop;
};

struct _Block6Data {
	int _ref_count_;
	RygelDataSourceTest * self;
	GMainLoop* loop;
	gboolean quit;
};


static gpointer rygel_data_source_test_config_parent_class = NULL;
static gpointer rygel_byte_seek_parent_class = NULL;
static gpointer data_block_parent_class = NULL;
static gpointer rygel_data_pool_parent_class = NULL;
static gpointer rygel_data_source_test_parent_class = NULL;

GType rygel_data_source_test_config_get_type (void) G_GNUC_CONST;
#define RYGEL_DATA_SOURCE_TEST_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfigPrivate))
enum  {
	RYGEL_DATA_SOURCE_TEST_CONFIG_DUMMY_PROPERTY
};
RygelDataSourceTestConfig* rygel_data_source_test_config_new (const gchar* path, const gchar* engine);
RygelDataSourceTestConfig* rygel_data_source_test_config_construct (GType object_type, const gchar* path, const gchar* engine);
static gchar* rygel_data_source_test_config_real_get_media_engine (RygelBaseConfiguration* base, GError** error);
static gchar* rygel_data_source_test_config_real_get_engine_path (RygelBaseConfiguration* base, GError** error);
gchar* rygel_data_source_test_config_to_string (RygelDataSourceTestConfig* self);
void rygel_data_source_test_config_clear (RygelDataSourceTestConfig* self);
static void rygel_data_source_test_config_finalize (GObject* obj);
GType rygel_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BYTE_SEEK_DUMMY_PROPERTY
};
RygelByteSeek* rygel_byte_seek_new (gint64 first, gint64 last, gint64 length);
RygelByteSeek* rygel_byte_seek_construct (GType object_type, gint64 first, gint64 last, gint64 length);
static void rygel_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
gpointer data_block_ref (gpointer instance);
void data_block_unref (gpointer instance);
GParamSpec* param_spec_data_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_block (GValue* value, gpointer v_object);
void value_take_data_block (GValue* value, gpointer v_object);
gpointer value_get_data_block (const GValue* value);
GType data_block_get_type (void) G_GNUC_CONST;
enum  {
	DATA_BLOCK_DUMMY_PROPERTY
};
DataBlock* data_block_new (guint8* data, int data_length1);
DataBlock* data_block_construct (GType object_type, guint8* data, int data_length1);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void data_block_finalize (DataBlock* obj);
GType rygel_data_pool_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DATA_POOL_DUMMY_PROPERTY
};
guint8* rygel_data_pool_flatten (RygelDataPool* self, int* result_length1);
guint64 rygel_data_pool_total_size (RygelDataPool* self);
RygelDataPool* rygel_data_pool_new (void);
RygelDataPool* rygel_data_pool_construct (GType object_type);
GType rygel_data_source_test_get_type (void) G_GNUC_CONST;
#define RYGEL_DATA_SOURCE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTestPrivate))
enum  {
	RYGEL_DATA_SOURCE_TEST_DUMMY_PROPERTY
};
RygelDataSourceTest* rygel_data_source_test_new (void);
RygelDataSourceTest* rygel_data_source_test_construct (GType object_type);
static void rygel_data_source_test_test_simple_streaming (RygelDataSourceTest* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (Block1Data* _data1_, guint8* data, int data_length1);
static void ___lambda2__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void __lambda3_ (Block1Data* _data1_, RygelDataSource* data);
static void ___lambda3__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void rygel_data_source_test_test_byte_range_request (RygelDataSourceTest* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda5_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda5__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda6_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda7_ (RygelDataSourceTest* self);
static void ____lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void ___lambda8_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda8__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda9_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda9__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda10_ (RygelDataSourceTest* self);
static void ____lambda10__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void ___lambda11_ (Block2Data* _data2_, guint8* data, int data_length1);
static void ____lambda11__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void ___lambda12_ (Block2Data* _data2_, RygelDataSource* data);
static void ____lambda12__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void ___lambda13_ (RygelDataSourceTest* self);
static void ____lambda13__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self);
static void rygel_data_source_test_test_stop_start (RygelDataSourceTest* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda14_ (Block3Data* _data3_, guint8* data, int data_length1);
static void ___lambda14__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static void __lambda15_ (Block3Data* _data3_, RygelDataSource* data);
static void ___lambda15__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda16_ (Block3Data* _data3_);
static gboolean ___lambda16__gsource_func (gpointer self);
static gboolean __lambda17_ (Block3Data* _data3_);
static gboolean ___lambda17__gsource_func (gpointer self);
static void rygel_data_source_test_test_multiple_freeze (RygelDataSourceTest* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda18_ (RygelDataSourceTest* self);
static void ___lambda18__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static gboolean __lambda19_ (Block4Data* _data4_);
static gboolean ___lambda19__gsource_func (gpointer self);
static void __lambda20_ (Block4Data* _data4_);
static void ___lambda20__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self);
static gboolean __lambda21_ (RygelDataSourceTest* self);
static gboolean ___lambda21__gsource_func (gpointer self);
static void rygel_data_source_test_test_freeze_stop (RygelDataSourceTest* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda22_ (Block5Data* _data5_);
static void ___lambda22__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static gboolean __lambda23_ (RygelDataSourceTest* self);
static gboolean ___lambda23__gsource_func (gpointer self);
static gboolean __lambda24_ (Block5Data* _data5_);
static gboolean ___lambda24__gsource_func (gpointer self);
void rygel_data_source_test_test_parallel_streaming (RygelDataSourceTest* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda25_ (Block6Data* _data6_);
static void ___lambda25__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
static void __lambda26_ (Block6Data* _data6_);
static void ___lambda26__rygel_data_source_done (RygelDataSource* _sender, gpointer self);
gint rygel_data_source_test_run (RygelDataSourceTest* self);
gint rygel_data_source_test_main (gchar** args, int args_length1);
static void rygel_data_source_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelDataSourceTestConfig* rygel_data_source_test_config_construct (GType object_type, const gchar* path, const gchar* engine) {
	RygelDataSourceTestConfig * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelDataSourceTestConfig*) rygel_base_configuration_construct (object_type);
#line 43 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = engine;
#line 43 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->engine);
#line 43 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv->engine = _tmp1_;
#line 44 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = path;
#line 44 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 44 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->path);
#line 44 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv->path = _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self;
#line 373 "rygel-media-engine-test.c"
}


RygelDataSourceTestConfig* rygel_data_source_test_config_new (const gchar* path, const gchar* engine) {
#line 41 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return rygel_data_source_test_config_construct (RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, path, engine);
#line 380 "rygel-media-engine-test.c"
}


static gchar* rygel_data_source_test_config_real_get_media_engine (RygelBaseConfiguration* base, GError** error) {
	RygelDataSourceTestConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelDataSourceTestConfig*) base;
#line 48 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = self->priv->engine;
#line 48 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_tmp0_ != NULL) {
#line 397 "rygel-media-engine-test.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 49 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp1_ = self->priv->engine;
#line 49 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 49 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		result = _tmp2_;
#line 49 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return result;
#line 408 "rygel-media-engine-test.c"
	}
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = RYGEL_BASE_CONFIGURATION_CLASS (rygel_data_source_test_config_parent_class)->get_media_engine (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASE_CONFIGURATION, RygelBaseConfiguration), &_inner_error_);
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_propagate_error (error, _inner_error_);
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return NULL;
#line 420 "rygel-media-engine-test.c"
	}
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = _tmp4_;
#line 53 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 426 "rygel-media-engine-test.c"
}


static gchar* rygel_data_source_test_config_real_get_engine_path (RygelBaseConfiguration* base, GError** error) {
	RygelDataSourceTestConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp3_;
#line 56 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelDataSourceTestConfig*) base;
#line 57 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = self->priv->path;
#line 57 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_tmp0_ != NULL) {
#line 441 "rygel-media-engine-test.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 58 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp1_ = self->priv->path;
#line 58 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 58 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		result = _tmp2_;
#line 58 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return result;
#line 452 "rygel-media-engine-test.c"
	}
#line 61 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_strdup (TEST_ENGINE_PATH);
#line 61 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = _tmp3_;
#line 61 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 460 "rygel-media-engine-test.c"
}


gchar* rygel_data_source_test_config_to_string (RygelDataSourceTestConfig* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = self->priv->path;
#line 65 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = self->priv->engine;
#line 65 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = g_strdup_printf ("Path: %s, Engine: %s", _tmp0_, _tmp1_);
#line 65 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = _tmp2_;
#line 65 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 481 "rygel-media-engine-test.c"
}


void rygel_data_source_test_config_clear (RygelDataSourceTestConfig* self) {
#line 68 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->engine);
#line 69 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv->engine = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->path);
#line 70 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv->path = NULL;
#line 496 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_config_class_init (RygelDataSourceTestConfigClass * klass) {
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_config_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_type_class_add_private (klass, sizeof (RygelDataSourceTestConfigPrivate));
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_media_engine = rygel_data_source_test_config_real_get_media_engine;
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_engine_path = rygel_data_source_test_config_real_get_engine_path;
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_data_source_test_config_finalize;
#line 511 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_config_instance_init (RygelDataSourceTestConfig * self) {
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv = RYGEL_DATA_SOURCE_TEST_CONFIG_GET_PRIVATE (self);
#line 518 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_config_finalize (GObject* obj) {
	RygelDataSourceTestConfig * self;
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, RygelDataSourceTestConfig);
#line 38 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->engine);
#line 39 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (self->priv->path);
#line 37 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	G_OBJECT_CLASS (rygel_data_source_test_config_parent_class)->finalize (obj);
#line 532 "rygel-media-engine-test.c"
}


/**
 * Helper class to convince the engine loader to load the media engine we want
 * to test.
 */
GType rygel_data_source_test_config_get_type (void) {
	static volatile gsize rygel_data_source_test_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_source_test_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataSourceTestConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_source_test_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataSourceTestConfig), 0, (GInstanceInitFunc) rygel_data_source_test_config_instance_init, NULL };
		GType rygel_data_source_test_config_type_id;
		rygel_data_source_test_config_type_id = g_type_register_static (RYGEL_TYPE_BASE_CONFIGURATION, "RygelDataSourceTestConfig", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_source_test_config_type_id__volatile, rygel_data_source_test_config_type_id);
	}
	return rygel_data_source_test_config_type_id__volatile;
}


RygelByteSeek* rygel_byte_seek_construct (GType object_type, gint64 first, gint64 last, gint64 length) {
	RygelByteSeek * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* msg;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GError * _inner_error_ = NULL;
#line 79 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = soup_message_new ("GET", "http://example.com/");
#line 79 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	msg = _tmp0_;
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = first;
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = last;
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = length;
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelByteSeek*) rygel_http_seek_construct (object_type, msg, _tmp1_, _tmp2_, (gint64) 1, _tmp3_, &_inner_error_);
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (msg);
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 80 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return NULL;
#line 582 "rygel-media-engine-test.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_BYTE);
#line 78 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (msg);
#line 78 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self;
#line 590 "rygel-media-engine-test.c"
}


RygelByteSeek* rygel_byte_seek_new (gint64 first, gint64 last, gint64 length) {
#line 78 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return rygel_byte_seek_construct (RYGEL_TYPE_BYTE_SEEK, first, last, length);
#line 597 "rygel-media-engine-test.c"
}


static void rygel_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelByteSeek * self;
#line 84 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelByteSeek*) base;
#line 605 "rygel-media-engine-test.c"
}


static void rygel_byte_seek_class_init (RygelByteSeekClass * klass) {
#line 77 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_byte_seek_parent_class = g_type_class_peek_parent (klass);
#line 77 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_byte_seek_real_add_response_headers;
#line 614 "rygel-media-engine-test.c"
}


static void rygel_byte_seek_instance_init (RygelByteSeek * self) {
}


/**
 * Stub implementation of Rygel.HTTPSeek
 */
GType rygel_byte_seek_get_type (void) {
	static volatile gsize rygel_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelByteSeek), 0, (GInstanceInitFunc) rygel_byte_seek_instance_init, NULL };
		GType rygel_byte_seek_type_id;
		rygel_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_byte_seek_type_id__volatile, rygel_byte_seek_type_id);
	}
	return rygel_byte_seek_type_id__volatile;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 640 "rygel-media-engine-test.c"
}


DataBlock* data_block_construct (GType object_type, guint8* data, int data_length1) {
	DataBlock* self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 94 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (DataBlock*) g_type_create_instance (object_type);
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = data;
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0__length1 = data_length1;
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1__length1 = _tmp0__length1;
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->data = (g_free (self->data), NULL);
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->data = _tmp1_;
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->data_length1 = _tmp1__length1;
#line 95 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->_data_size_ = self->data_length1;
#line 94 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self;
#line 670 "rygel-media-engine-test.c"
}


DataBlock* data_block_new (guint8* data, int data_length1) {
#line 94 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return data_block_construct (TYPE_DATA_BLOCK, data, data_length1);
#line 677 "rygel-media-engine-test.c"
}


static void value_data_block_init (GValue* value) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	value->data[0].v_pointer = NULL;
#line 684 "rygel-media-engine-test.c"
}


static void value_data_block_free_value (GValue* value) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (value->data[0].v_pointer) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		data_block_unref (value->data[0].v_pointer);
#line 693 "rygel-media-engine-test.c"
	}
}


static void value_data_block_copy_value (const GValue* src_value, GValue* dest_value) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (src_value->data[0].v_pointer) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		dest_value->data[0].v_pointer = data_block_ref (src_value->data[0].v_pointer);
#line 703 "rygel-media-engine-test.c"
	} else {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 707 "rygel-media-engine-test.c"
	}
}


static gpointer value_data_block_peek_pointer (const GValue* value) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return value->data[0].v_pointer;
#line 715 "rygel-media-engine-test.c"
}


static gchar* value_data_block_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (collect_values[0].v_pointer) {
#line 722 "rygel-media-engine-test.c"
		DataBlock* object;
		object = collect_values[0].v_pointer;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 729 "rygel-media-engine-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 733 "rygel-media-engine-test.c"
		}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = data_block_ref (object);
#line 737 "rygel-media-engine-test.c"
	} else {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = NULL;
#line 741 "rygel-media-engine-test.c"
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return NULL;
#line 745 "rygel-media-engine-test.c"
}


static gchar* value_data_block_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DataBlock** object_p;
	object_p = collect_values[0].v_pointer;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (!object_p) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 756 "rygel-media-engine-test.c"
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (!value->data[0].v_pointer) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		*object_p = NULL;
#line 762 "rygel-media-engine-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		*object_p = value->data[0].v_pointer;
#line 766 "rygel-media-engine-test.c"
	} else {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		*object_p = data_block_ref (value->data[0].v_pointer);
#line 770 "rygel-media-engine-test.c"
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return NULL;
#line 774 "rygel-media-engine-test.c"
}


GParamSpec* param_spec_data_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDataBlock* spec;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_BLOCK), NULL);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return G_PARAM_SPEC (spec);
#line 788 "rygel-media-engine-test.c"
}


gpointer value_get_data_block (const GValue* value) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK), NULL);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return value->data[0].v_pointer;
#line 797 "rygel-media-engine-test.c"
}


void value_set_data_block (GValue* value, gpointer v_object) {
	DataBlock* old;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	old = value->data[0].v_pointer;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (v_object) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_BLOCK));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = v_object;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		data_block_ref (value->data[0].v_pointer);
#line 817 "rygel-media-engine-test.c"
	} else {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = NULL;
#line 821 "rygel-media-engine-test.c"
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (old) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		data_block_unref (old);
#line 827 "rygel-media-engine-test.c"
	}
}


void value_take_data_block (GValue* value, gpointer v_object) {
	DataBlock* old;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_BLOCK));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	old = value->data[0].v_pointer;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (v_object) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_BLOCK));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = v_object;
#line 846 "rygel-media-engine-test.c"
	} else {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		value->data[0].v_pointer = NULL;
#line 850 "rygel-media-engine-test.c"
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (old) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		data_block_unref (old);
#line 856 "rygel-media-engine-test.c"
	}
}


static void data_block_class_init (DataBlockClass * klass) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	data_block_parent_class = g_type_class_peek_parent (klass);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	DATA_BLOCK_CLASS (klass)->finalize = data_block_finalize;
#line 866 "rygel-media-engine-test.c"
}


static void data_block_instance_init (DataBlock * self) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->ref_count = 1;
#line 873 "rygel-media-engine-test.c"
}


static void data_block_finalize (DataBlock* obj) {
	DataBlock * self;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_BLOCK, DataBlock);
#line 92 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->data = (g_free (self->data), NULL);
#line 883 "rygel-media-engine-test.c"
}


/**
 * Wrapper class arount uint8[] arrays to help stuff those buffers into a
 * Gee.ArrayList
 */
GType data_block_get_type (void) {
	static volatile gsize data_block_type_id__volatile = 0;
	if (g_once_init_enter (&data_block_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_data_block_init, value_data_block_free_value, value_data_block_copy_value, value_data_block_peek_pointer, "p", value_data_block_collect_value, "p", value_data_block_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DataBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataBlock), 0, (GInstanceInitFunc) data_block_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType data_block_type_id;
		data_block_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataBlock", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&data_block_type_id__volatile, data_block_type_id);
	}
	return data_block_type_id__volatile;
}


gpointer data_block_ref (gpointer instance) {
	DataBlock* self;
	self = instance;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return instance;
#line 912 "rygel-media-engine-test.c"
}


void data_block_unref (gpointer instance) {
	DataBlock* self;
	self = instance;
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		DATA_BLOCK_GET_CLASS (self)->finalize (self);
#line 91 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 925 "rygel-media-engine-test.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 933 "rygel-media-engine-test.c"
}


guint8* rygel_data_pool_flatten (RygelDataPool* self, int* result_length1) {
	guint8* result = NULL;
	guint64 _tmp0_ = 0ULL;
	guint64 size;
	guint64 _tmp1_;
	guint8* _tmp2_ = NULL;
	guint8* _result_;
	gint _result__length1;
	gint __result__size_;
	gint offset;
	guint8* _tmp22_;
	gint _tmp22__length1;
	DataBlock* _tmp23_;
	DataBlock* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
#line 103 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_data_pool_total_size (self);
#line 104 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	size = _tmp0_;
#line 105 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = size;
#line 105 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = g_new0 (guint8, _tmp1_);
#line 105 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_result_ = _tmp2_;
#line 105 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_result__length1 = _tmp1_;
#line 105 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__result__size_ = _result__length1;
#line 106 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	offset = 0;
#line 971 "rygel-media-engine-test.c"
	{
		RygelDataPool* _tmp3_;
		RygelDataPool* _data_list;
		RygelDataPool* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _data_size;
		gint _data_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp3_ = _g_object_ref0 (self);
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_list = _tmp3_;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp4_ = _data_list;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp6_ = _tmp5_;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_size = _tmp6_;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_index = -1;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		while (TRUE) {
#line 996 "rygel-media-engine-test.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			RygelDataPool* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			DataBlock* data;
			guint8* _tmp13_;
			gint _tmp13__length1;
			gint _tmp14_;
			DataBlock* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			DataBlock* _tmp17_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			gint _tmp19_;
			DataBlock* _tmp20_;
			guint8* _tmp21_;
			gint _tmp21__length1;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp7_ = _data_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data_index = _tmp7_ + 1;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp8_ = _data_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp9_ = _data_size;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				break;
#line 1029 "rygel-media-engine-test.c"
			}
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp10_ = _data_list;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp11_ = _data_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			data = (DataBlock*) _tmp12_;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp13_ = _result_;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp13__length1 = _result__length1;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp14_ = offset;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp15_ = data;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp16_ = _tmp15_->data;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp16__length1 = _tmp15_->data_length1;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp17_ = data;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp18_ = _tmp17_->data;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp18__length1 = _tmp17_->data_length1;
#line 109 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			memcpy (_tmp13_ + ((guint8) _tmp14_), (void*) _tmp16_, (gsize) _tmp18__length1);
#line 110 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp19_ = offset;
#line 110 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp20_ = data;
#line 110 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp21_ = _tmp20_->data;
#line 110 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp21__length1 = _tmp20_->data_length1;
#line 110 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			offset = _tmp19_ + _tmp21__length1;
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data_block_unref0 (data);
#line 1071 "rygel-media-engine-test.c"
		}
#line 108 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data_list);
#line 1075 "rygel-media-engine-test.c"
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp22_ = _result_;
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp22__length1 = _result__length1;
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp23_ = data_block_new (_tmp22_, _tmp22__length1);
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp24_ = _tmp23_;
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) self, _tmp24_);
#line 114 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data_block_unref0 (_tmp24_);
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp25_ = _result_;
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp25__length1 = _result__length1;
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (result_length1) {
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		*result_length1 = _tmp25__length1;
#line 1099 "rygel-media-engine-test.c"
	}
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = _tmp25_;
#line 116 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 1105 "rygel-media-engine-test.c"
}


guint64 rygel_data_pool_total_size (RygelDataPool* self) {
	guint64 result = 0ULL;
	guint64 total;
#line 119 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 120 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	total = (guint64) 0;
#line 1116 "rygel-media-engine-test.c"
	{
		RygelDataPool* _tmp0_;
		RygelDataPool* _data_list;
		RygelDataPool* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _data_size;
		gint _data_index;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp0_ = _g_object_ref0 (self);
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_list = _tmp0_;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp1_ = _data_list;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp3_ = _tmp2_;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_size = _tmp3_;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data_index = -1;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		while (TRUE) {
#line 1141 "rygel-media-engine-test.c"
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			RygelDataPool* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_ = NULL;
			DataBlock* data;
			guint64 _tmp10_;
			DataBlock* _tmp11_;
			guint8* _tmp12_;
			gint _tmp12__length1;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp4_ = _data_index;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data_index = _tmp4_ + 1;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp5_ = _data_index;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp6_ = _data_size;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				break;
#line 1165 "rygel-media-engine-test.c"
			}
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp7_ = _data_list;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp8_ = _data_index;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			data = (DataBlock*) _tmp9_;
#line 122 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp10_ = total;
#line 122 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp11_ = data;
#line 122 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp12_ = _tmp11_->data;
#line 122 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp12__length1 = _tmp11_->data_length1;
#line 122 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			total = _tmp10_ + _tmp12__length1;
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data_block_unref0 (data);
#line 1187 "rygel-media-engine-test.c"
		}
#line 121 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data_list);
#line 1191 "rygel-media-engine-test.c"
	}
#line 125 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = total;
#line 125 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 1197 "rygel-media-engine-test.c"
}


RygelDataPool* rygel_data_pool_construct (GType object_type) {
	RygelDataPool * self = NULL;
#line 102 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelDataPool*) gee_array_list_construct (object_type, TYPE_DATA_BLOCK, (GBoxedCopyFunc) data_block_ref, data_block_unref, NULL);
#line 102 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self;
#line 1207 "rygel-media-engine-test.c"
}


RygelDataPool* rygel_data_pool_new (void) {
#line 102 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return rygel_data_pool_construct (RYGEL_TYPE_DATA_POOL);
#line 1214 "rygel-media-engine-test.c"
}


static void rygel_data_pool_class_init (RygelDataPoolClass * klass) {
#line 102 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_pool_parent_class = g_type_class_peek_parent (klass);
#line 1221 "rygel-media-engine-test.c"
}


static void rygel_data_pool_instance_init (RygelDataPool * self) {
}


/**
 * Helper class to collect a number of byte buffers
 */
GType rygel_data_pool_get_type (void) {
	static volatile gsize rygel_data_pool_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_pool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataPoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_pool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataPool), 0, (GInstanceInitFunc) rygel_data_pool_instance_init, NULL };
		GType rygel_data_pool_type_id;
		rygel_data_pool_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelDataPool", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_pool_type_id__volatile, rygel_data_pool_type_id);
	}
	return rygel_data_pool_type_id__volatile;
}


RygelDataSourceTest* rygel_data_source_test_construct (GType object_type) {
	RygelDataSourceTest * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* path;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 142 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = (RygelDataSourceTest*) g_object_new (object_type, NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = g_build_filename (TEST_DATA_FOLDER, "test-data.dat", NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	path = _tmp0_;
#line 144 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = g_file_new_for_path (path);
#line 144 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (self->priv->test_data_file);
#line 144 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv->test_data_file = _tmp1_;
#line 1262 "rygel-media-engine-test.c"
	{
		GMappedFile* _tmp2_;
		GMappedFile* _tmp3_;
#line 146 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2_ = g_mapped_file_new (path, FALSE, &_inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp3_ = _tmp2_;
#line 146 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		if (_inner_error_ != NULL) {
#line 1272 "rygel-media-engine-test.c"
			goto __catch0_g_error;
		}
#line 146 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_mapped_file_unref0 (self->priv->test_data_mapped);
#line 146 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self->priv->test_data_mapped = _tmp3_;
#line 1279 "rygel-media-engine-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_;
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_error_ = _inner_error_;
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_inner_error_ = NULL;
#line 148 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp4_ = _error_->message;
#line 148 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_warning ("rygel-media-engine-test.vala:148: Error: Could not map file: %s", _tmp4_);
#line 149 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_assert_not_reached ();
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_error_free0 (_error_);
#line 1298 "rygel-media-engine-test.c"
	}
	__finally0:
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_free0 (path);
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return NULL;
#line 1311 "rygel-media-engine-test.c"
	}
#line 142 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (path);
#line 142 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return self;
#line 1317 "rygel-media-engine-test.c"
}


RygelDataSourceTest* rygel_data_source_test_new (void) {
#line 142 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return rygel_data_source_test_construct (RYGEL_TYPE_DATA_SOURCE_TEST);
#line 1324 "rygel-media-engine-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data1_;
#line 1333 "rygel-media-engine-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1342 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data1_->self;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data1_->source);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 1354 "rygel-media-engine-test.c"
	}
}


static void __lambda2_ (Block1Data* _data1_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
#line 163 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data1_->self;
#line 164 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = data;
#line 164 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0__length1 = data_length1;
#line 164 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->received_bytes = _data1_->received_bytes + _tmp0__length1;
#line 1371 "rygel-media-engine-test.c"
}


static void ___lambda2__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 163 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda2_ (self, data, data_length1);
#line 1378 "rygel-media-engine-test.c"
}


static void __lambda3_ (Block1Data* _data1_, RygelDataSource* data) {
	RygelDataSourceTest * self;
#line 166 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data1_->self;
#line 166 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (data != NULL);
#line 167 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_data1_->loop);
#line 1390 "rygel-media-engine-test.c"
}


static void ___lambda3__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 166 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda3_ (self, _sender);
#line 1397 "rygel-media-engine-test.c"
}


static gboolean __lambda4_ (Block1Data* _data1_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	RygelDataSource* _tmp0_;
	GError * _inner_error_ = NULL;
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data1_->self;
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data1_->source;
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return FALSE;
#line 1420 "rygel-media-engine-test.c"
	}
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 1426 "rygel-media-engine-test.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 1435 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_test_simple_streaming (RygelDataSourceTest* self) {
	Block1Data* _data1_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* _tmp7_;
	GMainLoop* _tmp8_;
	RygelDataSource* _tmp9_;
	RygelDataSource* _tmp10_;
	GMappedFile* _tmp11_;
	gsize _tmp12_ = 0UL;
	RygelDataSource* _tmp13_;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->_ref_count_ = 1;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->self = g_object_ref (self);
#line 155 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:155: test_simple_streaming");
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 156 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->source = _tmp6_;
#line 159 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = _data1_->source;
#line 159 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp7_ != NULL, "source != null");
#line 161 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->received_bytes = (guint64) 0;
#line 162 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp8_ = g_main_loop_new (NULL, FALSE);
#line 162 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->loop = _tmp8_;
#line 163 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp9_ = _data1_->source;
#line 163 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp9_, "data-available", (GCallback) ___lambda2__rygel_data_source_data_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 166 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp10_ = _data1_->source;
#line 166 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp10_, "done", (GCallback) ___lambda3__rygel_data_source_done, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 169 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 170 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_data1_->loop);
#line 171 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp11_ = self->priv->test_data_mapped;
#line 171 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp12_ = g_mapped_file_get_length (_tmp11_);
#line 171 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_data1_->received_bytes == ((guint64) _tmp12_), "received_bytes == this.test_data_mapped.get_length ()");
#line 172 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp13_ = _data1_->source;
#line 172 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (_tmp13_);
#line 173 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_data1_->source);
#line 173 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_->source = NULL;
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	block1_data_unref (_data1_);
#line 154 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data1_ = NULL;
#line 1525 "rygel-media-engine-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data2_;
#line 1534 "rygel-media-engine-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1543 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data2_->self;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data2_->received_data);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 1555 "rygel-media-engine-test.c"
	}
}


static void ___lambda5_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	DataBlock* _tmp2_;
	DataBlock* _tmp3_;
#line 190 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->received_data;
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = data;
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1__length1 = data_length1;
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = _tmp2_;
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 191 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data_block_unref0 (_tmp3_);
#line 1583 "rygel-media-engine-test.c"
}


static void ____lambda5__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 190 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda5_ (self, data, data_length1);
#line 1590 "rygel-media-engine-test.c"
}


static void ___lambda6_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_;
#line 193 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 193 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (data != NULL);
#line 194 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->loop;
#line 194 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 1605 "rygel-media-engine-test.c"
}


static void ____lambda6__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 193 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda6_ (self, _sender);
#line 1612 "rygel-media-engine-test.c"
}


static void ___lambda7_ (RygelDataSourceTest* self) {
#line 196 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 1619 "rygel-media-engine-test.c"
}


static void ____lambda7__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
#line 196 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda7_ (self);
#line 1626 "rygel-media-engine-test.c"
}


static void ___lambda8_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	DataBlock* _tmp2_;
	DataBlock* _tmp3_;
#line 214 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->received_data;
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = data;
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1__length1 = data_length1;
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = _tmp2_;
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 215 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data_block_unref0 (_tmp3_);
#line 1653 "rygel-media-engine-test.c"
}


static void ____lambda8__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 214 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda8_ (self, data, data_length1);
#line 1660 "rygel-media-engine-test.c"
}


static void ___lambda9_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_;
#line 217 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 217 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (data != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->loop;
#line 218 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 1675 "rygel-media-engine-test.c"
}


static void ____lambda9__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 217 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda9_ (self, _sender);
#line 1682 "rygel-media-engine-test.c"
}


static void ___lambda10_ (RygelDataSourceTest* self) {
#line 220 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 1689 "rygel-media-engine-test.c"
}


static void ____lambda10__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
#line 220 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda10_ (self);
#line 1696 "rygel-media-engine-test.c"
}


static void ___lambda11_ (Block2Data* _data2_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	RygelDataPool* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	DataBlock* _tmp2_;
	DataBlock* _tmp3_;
#line 240 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->received_data;
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = data;
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1__length1 = data_length1;
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = data_block_new (_tmp1_, _tmp1__length1);
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = _tmp2_;
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 241 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data_block_unref0 (_tmp3_);
#line 1723 "rygel-media-engine-test.c"
}


static void ____lambda11__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 240 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda11_ (self, data, data_length1);
#line 1730 "rygel-media-engine-test.c"
}


static void ___lambda12_ (Block2Data* _data2_, RygelDataSource* data) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_;
#line 244 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data2_->self;
#line 244 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (data != NULL);
#line 245 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data2_->loop;
#line 245 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 1745 "rygel-media-engine-test.c"
}


static void ____lambda12__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 244 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda12_ (self, _sender);
#line 1752 "rygel-media-engine-test.c"
}


static void ___lambda13_ (RygelDataSourceTest* self) {
#line 247 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 1759 "rygel-media-engine-test.c"
}


static void ____lambda13__rygel_data_source_error (RygelDataSource* _sender, GError* _error_, gpointer self) {
#line 247 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	___lambda13_ (self);
#line 1766 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_test_byte_range_request (RygelDataSourceTest* self) {
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* source;
	RygelDataSource* _tmp7_;
	GError * _inner_error_ = NULL;
#line 177 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 178 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:178: test_byte_range_request");
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 179 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	source = _tmp6_;
#line 182 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = source;
#line 182 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp7_ != NULL, "source != null");
#line 1809 "rygel-media-engine-test.c"
	{
		Block2Data* _data2_;
		GMappedFile* _tmp8_;
		gsize _tmp9_ = 0UL;
		RygelByteSeek* _tmp10_;
		RygelByteSeek* seek;
		RygelDataPool* _tmp11_;
		GMainLoop* _tmp12_;
		RygelDataSource* _tmp13_;
		RygelDataSource* _tmp14_;
		RygelDataSource* _tmp15_;
		RygelDataSource* _tmp16_;
		RygelByteSeek* _tmp17_;
		GMainLoop* _tmp18_;
		RygelDataPool* _tmp19_;
		guint64 _tmp20_ = 0ULL;
		GMappedFile* _tmp21_;
		gchar* _tmp22_ = NULL;
		RygelDataPool* _tmp23_;
		gint _tmp24_ = 0;
		guint8* _tmp25_ = NULL;
		RygelDataPool* _tmp26_;
		guint64 _tmp27_ = 0ULL;
		GMappedFile* _tmp28_;
		gsize _tmp29_ = 0UL;
		GMappedFile* _tmp30_;
		gsize _tmp31_ = 0UL;
		GMappedFile* _tmp32_;
		gsize _tmp33_ = 0UL;
		RygelByteSeek* _tmp34_;
		RygelDataPool* _tmp35_;
		GMainLoop* _tmp36_;
		RygelMediaEngine* _tmp37_ = NULL;
		RygelMediaEngine* _tmp38_;
		GFile* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		RygelDataSource* _tmp42_ = NULL;
		RygelDataSource* _tmp43_;
		RygelDataSource* _tmp44_;
		RygelDataSource* _tmp45_;
		RygelDataSource* _tmp46_;
		RygelByteSeek* _tmp47_;
		GMainLoop* _tmp48_;
		RygelDataPool* _tmp49_;
		guint64 _tmp50_ = 0ULL;
		GMappedFile* _tmp51_;
		gchar* _tmp52_ = NULL;
		GMappedFile* _tmp53_;
		gsize _tmp54_ = 0UL;
		RygelDataPool* _tmp55_;
		gint _tmp56_ = 0;
		guint8* _tmp57_ = NULL;
		RygelDataPool* _tmp58_;
		guint64 _tmp59_ = 0ULL;
		GMappedFile* _tmp60_;
		gsize _tmp61_ = 0UL;
		GMappedFile* _tmp62_;
		gsize _tmp63_ = 0UL;
		GMappedFile* _tmp64_;
		gsize _tmp65_ = 0UL;
		RygelByteSeek* _tmp66_;
		RygelDataPool* _tmp67_;
		GMainLoop* _tmp68_;
		RygelMediaEngine* _tmp69_ = NULL;
		RygelMediaEngine* _tmp70_;
		GFile* _tmp71_;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_;
		RygelDataSource* _tmp74_ = NULL;
		RygelDataSource* _tmp75_;
		RygelDataSource* _tmp76_;
		RygelDataSource* _tmp77_;
		RygelDataSource* _tmp78_;
		RygelByteSeek* _tmp79_;
		GMainLoop* _tmp80_;
		RygelDataPool* _tmp81_;
		guint64 _tmp82_ = 0ULL;
		GMappedFile* _tmp83_;
		gchar* _tmp84_ = NULL;
		GMappedFile* _tmp85_;
		gsize _tmp86_ = 0UL;
		RygelDataPool* _tmp87_;
		gint _tmp88_ = 0;
		guint8* _tmp89_ = NULL;
		RygelDataPool* _tmp90_;
		guint64 _tmp91_ = 0ULL;
		RygelDataSource* _tmp92_;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->_ref_count_ = 1;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->self = g_object_ref (self);
#line 186 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp8_ = self->priv->test_data_mapped;
#line 186 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp9_ = g_mapped_file_get_length (_tmp8_);
#line 186 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp10_ = rygel_byte_seek_new ((gint64) 0, (gint64) 9, (gint64) _tmp9_);
#line 186 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		seek = _tmp10_;
#line 188 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp11_ = rygel_data_pool_new ();
#line 188 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->received_data = _tmp11_;
#line 189 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp12_ = g_main_loop_new (NULL, FALSE);
#line 189 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->loop = _tmp12_;
#line 190 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp13_ = source;
#line 190 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp13_, "data-available", (GCallback) ____lambda5__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 193 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp14_ = source;
#line 193 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp14_, "done", (GCallback) ____lambda6__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 196 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp15_ = source;
#line 196 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_object (_tmp15_, "error", (GCallback) ____lambda7__rygel_data_source_error, self, 0);
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp16_ = source;
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp17_ = seek;
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		rygel_data_source_start (_tmp16_, (RygelHTTPSeek*) _tmp17_, &_inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		if (_inner_error_ != NULL) {
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (seek);
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			block2_data_unref (_data2_);
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data2_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
#line 1948 "rygel-media-engine-test.c"
				goto __catch1_rygel_data_source_error_seek_failed;
			}
			goto __catch1_g_error;
		}
#line 198 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp18_ = _data2_->loop;
#line 198 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_main_loop_run (_tmp18_);
#line 199 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp19_ = _data2_->received_data;
#line 199 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp20_ = rygel_data_pool_total_size (_tmp19_);
#line 199 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_vala_assert (_tmp20_ == ((guint64) 10), "received_data.total_size () == 10");
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp21_ = self->priv->test_data_mapped;
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp22_ = g_mapped_file_get_contents (_tmp21_);
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp23_ = _data2_->received_data;
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp25_ = rygel_data_pool_flatten (_tmp23_, &_tmp24_);
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp26_ = _data2_->received_data;
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp27_ = rygel_data_pool_total_size (_tmp26_);
#line 200 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		memcmp (_tmp22_, _tmp25_, (gsize) _tmp27_);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp28_ = self->priv->test_data_mapped;
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp29_ = g_mapped_file_get_length (_tmp28_);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp30_ = self->priv->test_data_mapped;
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp31_ = g_mapped_file_get_length (_tmp30_);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp32_ = self->priv->test_data_mapped;
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp33_ = g_mapped_file_get_length (_tmp32_);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp34_ = rygel_byte_seek_new ((gint64) (_tmp29_ - 10), (gint64) (_tmp31_ - 1), (gint64) _tmp33_);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (seek);
#line 205 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		seek = _tmp34_;
#line 209 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp35_ = rygel_data_pool_new ();
#line 209 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data2_->received_data);
#line 209 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->received_data = _tmp35_;
#line 210 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp36_ = g_main_loop_new (NULL, FALSE);
#line 210 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 210 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->loop = _tmp36_;
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp37_ = rygel_media_engine_get_default ();
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp38_ = _tmp37_;
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp39_ = self->priv->test_data_file;
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp40_ = g_file_get_uri (_tmp39_);
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp41_ = _tmp40_;
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp42_ = rygel_media_engine_create_data_source (_tmp38_, _tmp41_);
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source);
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		source = _tmp42_;
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_free0 (_tmp41_);
#line 212 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_tmp38_);
#line 214 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp43_ = source;
#line 214 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp43_, "data-available", (GCallback) ____lambda8__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 217 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp44_ = source;
#line 217 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp44_, "done", (GCallback) ____lambda9__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 220 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp45_ = source;
#line 220 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_object (_tmp45_, "error", (GCallback) ____lambda10__rygel_data_source_error, self, 0);
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp46_ = source;
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp47_ = seek;
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		rygel_data_source_start (_tmp46_, (RygelHTTPSeek*) _tmp47_, &_inner_error_);
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		if (_inner_error_ != NULL) {
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (seek);
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			block2_data_unref (_data2_);
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data2_ = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
#line 2055 "rygel-media-engine-test.c"
				goto __catch1_rygel_data_source_error_seek_failed;
			}
			goto __catch1_g_error;
		}
#line 222 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp48_ = _data2_->loop;
#line 222 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_main_loop_run (_tmp48_);
#line 224 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp49_ = _data2_->received_data;
#line 224 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp50_ = rygel_data_pool_total_size (_tmp49_);
#line 224 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_vala_assert (_tmp50_ == ((guint64) 10), "received_data.total_size () == 10");
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp51_ = self->priv->test_data_mapped;
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp52_ = g_mapped_file_get_contents (_tmp51_);
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp53_ = self->priv->test_data_mapped;
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp54_ = g_mapped_file_get_length (_tmp53_);
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp55_ = _data2_->received_data;
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp57_ = rygel_data_pool_flatten (_tmp55_, &_tmp56_);
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp58_ = _data2_->received_data;
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp59_ = rygel_data_pool_total_size (_tmp58_);
#line 225 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		memcmp (_tmp52_ + (_tmp54_ - 10), _tmp57_, (gsize) _tmp59_);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp60_ = self->priv->test_data_mapped;
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp61_ = g_mapped_file_get_length (_tmp60_);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp62_ = self->priv->test_data_mapped;
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp63_ = g_mapped_file_get_length (_tmp62_);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp64_ = self->priv->test_data_mapped;
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp65_ = g_mapped_file_get_length (_tmp64_);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp66_ = rygel_byte_seek_new ((gint64) (_tmp61_ / 2), (gint64) ((_tmp63_ / 2) + 9), (gint64) _tmp65_);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (seek);
#line 231 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		seek = _tmp66_;
#line 235 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp67_ = rygel_data_pool_new ();
#line 235 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data2_->received_data);
#line 235 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->received_data = _tmp67_;
#line 236 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp68_ = g_main_loop_new (NULL, FALSE);
#line 236 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 236 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_->loop = _tmp68_;
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp69_ = rygel_media_engine_get_default ();
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp70_ = _tmp69_;
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp71_ = self->priv->test_data_file;
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp72_ = g_file_get_uri (_tmp71_);
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp73_ = _tmp72_;
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp74_ = rygel_media_engine_create_data_source (_tmp70_, _tmp73_);
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source);
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		source = _tmp74_;
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_free0 (_tmp73_);
#line 238 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_tmp70_);
#line 240 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp75_ = source;
#line 240 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp75_, "data-available", (GCallback) ____lambda11__rygel_data_source_data_available, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 244 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp76_ = source;
#line 244 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_data (_tmp76_, "done", (GCallback) ____lambda12__rygel_data_source_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 247 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp77_ = source;
#line 247 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_signal_connect_object (_tmp77_, "error", (GCallback) ____lambda13__rygel_data_source_error, self, 0);
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp78_ = source;
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp79_ = seek;
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		rygel_data_source_start (_tmp78_, (RygelHTTPSeek*) _tmp79_, &_inner_error_);
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		if (_inner_error_ != NULL) {
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (seek);
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			block2_data_unref (_data2_);
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_data2_ = NULL;
#line 248 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED)) {
#line 2166 "rygel-media-engine-test.c"
				goto __catch1_rygel_data_source_error_seek_failed;
			}
			goto __catch1_g_error;
		}
#line 249 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp80_ = _data2_->loop;
#line 249 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_main_loop_run (_tmp80_);
#line 251 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp81_ = _data2_->received_data;
#line 251 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp82_ = rygel_data_pool_total_size (_tmp81_);
#line 251 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_vala_assert (_tmp82_ == ((guint64) 10), "received_data.total_size () == 10");
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp83_ = self->priv->test_data_mapped;
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp84_ = g_mapped_file_get_contents (_tmp83_);
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp85_ = self->priv->test_data_mapped;
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp86_ = g_mapped_file_get_length (_tmp85_);
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp87_ = _data2_->received_data;
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp89_ = rygel_data_pool_flatten (_tmp87_, &_tmp88_);
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp90_ = _data2_->received_data;
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp91_ = rygel_data_pool_total_size (_tmp90_);
#line 252 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		memcmp (_tmp84_ + (_tmp86_ / 2), _tmp89_, (gsize) _tmp91_);
#line 256 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp92_ = source;
#line 256 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		rygel_data_source_stop (_tmp92_);
#line 257 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source);
#line 257 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		source = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (seek);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		block2_data_unref (_data2_);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data2_ = NULL;
#line 2213 "rygel-media-engine-test.c"
	}
	goto __finally1;
	__catch1_rygel_data_source_error_seek_failed:
	{
		GError* seek_error = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		seek_error = _inner_error_;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_inner_error_ = NULL;
#line 259 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_debug ("rygel-media-engine-test.vala:259: Skipping seek test");
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_error_free0 (seek_error);
#line 2227 "rygel-media-engine-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp93_;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_error_ = _inner_error_;
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_inner_error_ = NULL;
#line 261 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp93_ = _error_->message;
#line 261 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_warning ("rygel-media-engine-test.vala:261: Failed to test: %s", _tmp93_);
#line 262 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_assert_not_reached ();
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_error_free0 (_error_);
#line 2246 "rygel-media-engine-test.c"
	}
	__finally1:
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return;
#line 2259 "rygel-media-engine-test.c"
	}
#line 177 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (source);
#line 2263 "rygel-media-engine-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data3_;
#line 2272 "rygel-media-engine-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2281 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data3_->self;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data3_->pool);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data3_->source);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 2295 "rygel-media-engine-test.c"
	}
}


static void __lambda14_ (Block3Data* _data3_, guint8* data, int data_length1) {
	RygelDataSourceTest * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	DataBlock* _tmp1_;
	DataBlock* _tmp2_;
	RygelDataSource* _tmp3_;
#line 277 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data3_->self;
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = data;
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0__length1 = data_length1;
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = data_block_new (_tmp0_, _tmp0__length1);
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = _tmp1_;
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data3_->pool, _tmp2_);
#line 278 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data_block_unref0 (_tmp2_);
#line 279 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = _data3_->source;
#line 279 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (_tmp3_);
#line 2325 "rygel-media-engine-test.c"
}


static void ___lambda14__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 277 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda14_ (self, data, data_length1);
#line 2332 "rygel-media-engine-test.c"
}


static void __lambda15_ (Block3Data* _data3_, RygelDataSource* data) {
	RygelDataSourceTest * self;
#line 281 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data3_->self;
#line 281 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (data != NULL);
#line 282 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_data3_->loop);
#line 2344 "rygel-media-engine-test.c"
}


static void ___lambda15__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 281 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda15_ (self, _sender);
#line 2351 "rygel-media-engine-test.c"
}


static gboolean __lambda16_ (Block3Data* _data3_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	RygelDataSource* _tmp0_;
	GError * _inner_error_ = NULL;
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data3_->self;
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data3_->source;
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return FALSE;
#line 2374 "rygel-media-engine-test.c"
	}
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2380 "rygel-media-engine-test.c"
}


static gboolean ___lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda16_ (self);
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2389 "rygel-media-engine-test.c"
}


static gboolean __lambda17_ (Block3Data* _data3_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	RygelDataSource* _tmp0_;
	GError * _inner_error_ = NULL;
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data3_->self;
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data3_->source;
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp0_, NULL, &_inner_error_);
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return FALSE;
#line 2412 "rygel-media-engine-test.c"
	}
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2418 "rygel-media-engine-test.c"
}


static gboolean ___lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda17_ (self);
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2427 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_test_stop_start (RygelDataSourceTest* self) {
	Block3Data* _data3_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* _tmp7_;
	RygelDataPool* _tmp8_;
	GMainLoop* _tmp9_;
	RygelDataSource* _tmp10_;
	RygelDataSource* _tmp11_;
	GMappedFile* _tmp12_;
	gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	guint64 _tmp16_ = 0ULL;
	RygelDataSource* _tmp17_;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->_ref_count_ = 1;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->self = g_object_ref (self);
#line 269 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:269: test_stop_start");
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 270 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->source = _tmp6_;
#line 273 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = _data3_->source;
#line 273 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp7_ != NULL, "source != null");
#line 275 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp8_ = rygel_data_pool_new ();
#line 275 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->pool = _tmp8_;
#line 276 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp9_ = g_main_loop_new (NULL, FALSE);
#line 276 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->loop = _tmp9_;
#line 277 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp10_ = _data3_->source;
#line 277 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp10_, "data-available", (GCallback) ___lambda14__rygel_data_source_data_available, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 281 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp11_ = _data3_->source;
#line 281 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp11_, "done", (GCallback) ___lambda15__rygel_data_source_done, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 284 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 285 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_data3_->loop);
#line 286 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data3_->pool);
#line 287 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 288 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_data3_->loop);
#line 289 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp12_ = self->priv->test_data_mapped;
#line 289 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp13_ = g_mapped_file_get_contents (_tmp12_);
#line 289 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp15_ = rygel_data_pool_flatten (_data3_->pool, &_tmp14_);
#line 289 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp16_ = rygel_data_pool_total_size (_data3_->pool);
#line 289 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	memcmp (_tmp13_, _tmp15_, (gsize) _tmp16_);
#line 293 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp17_ = _data3_->source;
#line 293 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (_tmp17_);
#line 294 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_data3_->source);
#line 294 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_->source = NULL;
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	block3_data_unref (_data3_);
#line 268 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data3_ = NULL;
#line 2533 "rygel-media-engine-test.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data4_;
#line 2542 "rygel-media-engine-test.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2551 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data4_->self;
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data4_->loop);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block4Data, _data4_);
#line 2561 "rygel-media-engine-test.c"
	}
}


static void __lambda18_ (RygelDataSourceTest* self) {
#line 306 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 2569 "rygel-media-engine-test.c"
}


static void ___lambda18__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 305 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda18_ (self);
#line 2576 "rygel-media-engine-test.c"
}


static gboolean __lambda19_ (Block4Data* _data4_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
#line 313 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data4_->self;
#line 314 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data4_->loop;
#line 314 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 316 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 316 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2594 "rygel-media-engine-test.c"
}


static gboolean ___lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda19_ (self);
#line 313 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2603 "rygel-media-engine-test.c"
}


static void __lambda20_ (Block4Data* _data4_) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_;
#line 321 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data4_->self;
#line 322 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data4_->loop;
#line 322 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 2616 "rygel-media-engine-test.c"
}


static void ___lambda20__rygel_data_source_data_available (RygelDataSource* _sender, guint8* data, int data_length1, gpointer self) {
#line 321 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda20_ (self);
#line 2623 "rygel-media-engine-test.c"
}


static gboolean __lambda21_ (RygelDataSourceTest* self) {
	gboolean result = FALSE;
#line 326 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 328 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 328 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 325 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2637 "rygel-media-engine-test.c"
}


static gboolean ___lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda21_ (self);
#line 325 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2646 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_test_multiple_freeze (RygelDataSourceTest* self) {
	Block4Data* _data4_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* source;
	gulong _tmp7_ = 0UL;
	gulong available_id;
	GMainLoop* _tmp8_;
	GMainLoop* _tmp9_;
	guint _tmp10_ = 0U;
	guint timeout_id;
	GMainLoop* _tmp11_;
	guint _tmp12_;
	GError * _inner_error_ = NULL;
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data4_->_ref_count_ = 1;
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data4_->self = g_object_ref (self);
#line 300 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:300: test_multiple_freeze");
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 301 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	source = _tmp6_;
#line 304 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (source != NULL, "source != null");
#line 305 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = g_signal_connect_object (source, "data-available", (GCallback) ___lambda18__rygel_data_source_data_available, self, 0);
#line 305 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	available_id = _tmp7_;
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (source, NULL, &_inner_error_);
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source);
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		block4_data_unref (_data4_);
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data4_ = NULL;
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 308 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return;
#line 2721 "rygel-media-engine-test.c"
	}
#line 309 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_freeze (source);
#line 310 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_freeze (source);
#line 311 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp8_ = g_main_loop_new (NULL, FALSE);
#line 311 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data4_->loop = _tmp8_;
#line 313 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda19__gsource_func, block4_data_ref (_data4_), block4_data_unref);
#line 319 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp9_ = _data4_->loop;
#line 319 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_tmp9_);
#line 320 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_handler_disconnect ((GObject*) source, available_id);
#line 321 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (source, "data-available", (GCallback) ___lambda20__rygel_data_source_data_available, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 325 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp10_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
#line 325 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	timeout_id = _tmp10_;
#line 331 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_thaw (source);
#line 332 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp11_ = _data4_->loop;
#line 332 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_tmp11_);
#line 333 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp12_ = timeout_id;
#line 333 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_source_remove (_tmp12_);
#line 334 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (source);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (source);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	block4_data_unref (_data4_);
#line 299 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data4_ = NULL;
#line 2763 "rygel-media-engine-test.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data5_;
#line 2772 "rygel-media-engine-test.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2781 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data5_->self;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data5_->loop);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_data5_->source);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block5Data, _data5_);
#line 2793 "rygel-media-engine-test.c"
	}
}


static void __lambda22_ (Block5Data* _data5_) {
	RygelDataSourceTest * self;
	GMainLoop* _tmp0_;
#line 349 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data5_->self;
#line 350 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data5_->loop;
#line 350 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_quit (_tmp0_);
#line 2807 "rygel-media-engine-test.c"
}


static void ___lambda22__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 349 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda22_ (self);
#line 2814 "rygel-media-engine-test.c"
}


static gboolean __lambda23_ (RygelDataSourceTest* self) {
	gboolean result = FALSE;
#line 353 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_assert_not_reached ();
#line 352 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2824 "rygel-media-engine-test.c"
}


static gboolean ___lambda23__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda23_ (self);
#line 352 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2833 "rygel-media-engine-test.c"
}


static gboolean __lambda24_ (Block5Data* _data5_) {
	RygelDataSourceTest * self;
	gboolean result = FALSE;
	RygelDataSource* _tmp0_;
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data5_->self;
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data5_->source;
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (_tmp0_);
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = FALSE;
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2851 "rygel-media-engine-test.c"
}


static gboolean ___lambda24__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda24_ (self);
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 2860 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_test_freeze_stop (RygelDataSourceTest* self) {
	Block5Data* _data5_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* _tmp7_;
	RygelDataSource* _tmp8_;
	RygelDataSource* _tmp9_;
	GMainLoop* _tmp10_;
	RygelDataSource* _tmp11_;
	guint _tmp12_ = 0U;
	guint id;
	GMainLoop* _tmp13_;
	guint _tmp14_;
	RygelDataSource* _tmp15_;
	GError * _inner_error_ = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_->_ref_count_ = 1;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_->self = g_object_ref (self);
#line 340 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:340: test_freeze_stop");
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 341 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_->source = _tmp6_;
#line 344 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = _data5_->source;
#line 344 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp7_ != NULL, "source != null");
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp8_ = _data5_->source;
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp8_, NULL, &_inner_error_);
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		block5_data_unref (_data5_);
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data5_ = NULL;
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 346 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return;
#line 2934 "rygel-media-engine-test.c"
	}
#line 347 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp9_ = _data5_->source;
#line 347 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_freeze (_tmp9_);
#line 348 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp10_ = g_main_loop_new (NULL, FALSE);
#line 348 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_->loop = _tmp10_;
#line 349 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp11_ = _data5_->source;
#line 349 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp11_, "done", (GCallback) ___lambda22__rygel_data_source_done, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 352 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp12_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda23__gsource_func, g_object_ref (self), g_object_unref);
#line 352 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	id = _tmp12_;
#line 355 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda24__gsource_func, block5_data_ref (_data5_), block5_data_unref);
#line 356 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp13_ = _data5_->loop;
#line 356 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_tmp13_);
#line 357 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp14_ = id;
#line 357 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_source_remove (_tmp14_);
#line 358 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp15_ = _data5_->source;
#line 358 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_stop (_tmp15_);
#line 359 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_data5_->source);
#line 359 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_->source = NULL;
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	block5_data_unref (_data5_);
#line 339 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data5_ = NULL;
#line 2974 "rygel-media-engine-test.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return _data6_;
#line 2983 "rygel-media-engine-test.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2992 "rygel-media-engine-test.c"
		RygelDataSourceTest * self;
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		self = _data6_->self;
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (self);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_slice_free (Block6Data, _data6_);
#line 3002 "rygel-media-engine-test.c"
	}
}


static void __lambda25_ (Block6Data* _data6_) {
	RygelDataSourceTest * self;
	gboolean _tmp0_;
#line 382 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data6_->self;
#line 383 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data6_->quit;
#line 383 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_tmp0_) {
#line 3016 "rygel-media-engine-test.c"
		GMainLoop* _tmp1_;
#line 384 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp1_ = _data6_->loop;
#line 384 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_main_loop_quit (_tmp1_);
#line 3022 "rygel-media-engine-test.c"
	} else {
#line 386 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data6_->quit = TRUE;
#line 3026 "rygel-media-engine-test.c"
	}
}


static void ___lambda25__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 382 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda25_ (self);
#line 3034 "rygel-media-engine-test.c"
}


static void __lambda26_ (Block6Data* _data6_) {
	RygelDataSourceTest * self;
	gboolean _tmp0_;
#line 390 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = _data6_->self;
#line 391 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = _data6_->quit;
#line 391 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_tmp0_) {
#line 3047 "rygel-media-engine-test.c"
		GMainLoop* _tmp1_;
#line 392 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp1_ = _data6_->loop;
#line 392 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_main_loop_quit (_tmp1_);
#line 3053 "rygel-media-engine-test.c"
	} else {
#line 394 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data6_->quit = TRUE;
#line 3057 "rygel-media-engine-test.c"
	}
}


static void ___lambda26__rygel_data_source_done (RygelDataSource* _sender, gpointer self) {
#line 390 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	__lambda26_ (self);
#line 3065 "rygel-media-engine-test.c"
}


void rygel_data_source_test_test_parallel_streaming (RygelDataSourceTest* self) {
	Block6Data* _data6_;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_;
	RygelDataSource* source1;
	RygelDataSource* _tmp7_;
	RygelMediaEngine* _tmp8_ = NULL;
	RygelMediaEngine* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	RygelDataSource* _tmp13_ = NULL;
	RygelDataSource* _tmp14_;
	RygelDataSource* source2;
	RygelDataSource* _tmp15_;
	RygelDataSource* _tmp16_;
	GMappedFile* _tmp17_;
	gsize _tmp18_ = 0UL;
	GMappedFile* _tmp19_;
	gsize _tmp20_ = 0UL;
	RygelByteSeek* _tmp21_;
	RygelByteSeek* seek;
	RygelDataSource* _tmp22_;
	RygelByteSeek* _tmp23_;
	GMainLoop* _tmp24_;
	RygelDataSource* _tmp25_;
	RygelDataSource* _tmp26_;
	GMainLoop* _tmp27_;
	GError * _inner_error_ = NULL;
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_->_ref_count_ = 1;
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_->self = g_object_ref (self);
#line 364 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_debug ("rygel-media-engine-test.vala:364: test_parallel_streaming");
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = rygel_media_engine_get_default ();
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = _tmp0_;
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp2_ = self->priv->test_data_file;
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp4_ = _tmp3_;
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp5_ = rygel_media_engine_create_data_source (_tmp1_, _tmp4_);
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp6_ = _tmp5_;
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp4_);
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp1_);
#line 365 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	source1 = _tmp6_;
#line 367 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp7_ = source1;
#line 367 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp7_ != NULL, "source1 != null");
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp8_ = rygel_media_engine_get_default ();
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp9_ = _tmp8_;
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp10_ = self->priv->test_data_file;
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp11_ = g_file_get_uri (_tmp10_);
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp12_ = _tmp11_;
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp13_ = rygel_media_engine_create_data_source (_tmp9_, _tmp12_);
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp14_ = _tmp13_;
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_free0 (_tmp12_);
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (_tmp9_);
#line 369 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	source2 = _tmp14_;
#line 371 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp15_ = source2;
#line 371 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_vala_assert (_tmp15_ != NULL, "source2 != null");
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp16_ = source1;
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp16_, NULL, &_inner_error_);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source2);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source1);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		block6_data_unref (_data6_);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data6_ = NULL;
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 373 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return;
#line 3181 "rygel-media-engine-test.c"
	}
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp17_ = self->priv->test_data_mapped;
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp18_ = g_mapped_file_get_length (_tmp17_);
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp19_ = self->priv->test_data_mapped;
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp20_ = g_mapped_file_get_length (_tmp19_);
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp21_ = rygel_byte_seek_new ((gint64) 0, (gint64) (_tmp18_ / 2), (gint64) _tmp20_);
#line 375 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	seek = _tmp21_;
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp22_ = source2;
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp23_ = seek;
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_start (_tmp22_, (RygelHTTPSeek*) _tmp23_, &_inner_error_);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_inner_error_ != NULL) {
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (seek);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source2);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (source1);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		block6_data_unref (_data6_);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_data6_ = NULL;
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		g_clear_error (&_inner_error_);
#line 379 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		return;
#line 3219 "rygel-media-engine-test.c"
	}
#line 380 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp24_ = g_main_loop_new (NULL, FALSE);
#line 380 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_->loop = _tmp24_;
#line 381 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_->quit = FALSE;
#line 382 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp25_ = source1;
#line 382 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp25_, "done", (GCallback) ___lambda25__rygel_data_source_done, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 390 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp26_ = source2;
#line 390 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_signal_connect_data (_tmp26_, "done", (GCallback) ___lambda26__rygel_data_source_done, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 397 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp27_ = _data6_->loop;
#line 397 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_main_loop_run (_tmp27_);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (seek);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (source2);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (source1);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	block6_data_unref (_data6_);
#line 363 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_data6_ = NULL;
#line 3249 "rygel-media-engine-test.c"
}


gint rygel_data_source_test_run (RygelDataSourceTest* self) {
	gint result = 0;
#line 400 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 401 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_simple_streaming (self);
#line 402 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_byte_range_request (self);
#line 403 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_stop_start (self);
#line 404 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_multiple_freeze (self);
#line 405 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_freeze_stop (self);
#line 406 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_test_parallel_streaming (self);
#line 408 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = 0;
#line 408 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 3273 "rygel-media-engine-test.c"
}


gint rygel_data_source_test_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** engines = NULL;
	gint engines_length1 = 0;
	gint _engines_size_ = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* configs;
	gchar** _tmp1_;
	gint _tmp1__length1;
	RygelDataSourceTestConfig* previous_config;
	GError * _inner_error_ = NULL;
#line 414 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_DATA_SOURCE_TEST_CONFIG, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 414 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	configs = _tmp0_;
#line 416 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1_ = args;
#line 416 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_tmp1__length1 = args_length1;
#line 416 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	if (_tmp1__length1 > 1) {
#line 3298 "rygel-media-engine-test.c"
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2_ = args;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp2__length1 = args_length1;
#line 3305 "rygel-media-engine-test.c"
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			arg_collection = _tmp2_;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			arg_collection_length1 = _tmp2__length1;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			for (arg_it = 0; arg_it < _tmp2__length1; arg_it = arg_it + 1) {
#line 3317 "rygel-media-engine-test.c"
				gchar* _tmp3_;
				gchar* arg = NULL;
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_tmp3_ = g_strdup (arg_collection[arg_it]);
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				arg = _tmp3_;
#line 3324 "rygel-media-engine-test.c"
				{
					GFile* file = NULL;
					gchar** _tmp4_;
					gint _tmp4__length1;
					const gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					GFile* _tmp13_;
					GFile* _tmp14_ = NULL;
					GFile* _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					gchar* path;
					GFile* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* engine;
					GeeArrayList* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					RygelDataSourceTestConfig* _tmp23_;
					RygelDataSourceTestConfig* _tmp24_;
#line 419 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp4_ = args;
#line 419 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp4__length1 = args_length1;
#line 419 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp5_ = _tmp4_[1];
#line 419 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp6_ = g_str_has_prefix (_tmp5_, "~");
#line 419 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					if (_tmp6_) {
#line 3355 "rygel-media-engine-test.c"
						gchar** _tmp7_;
						gint _tmp7__length1;
						const gchar* _tmp8_;
						GFile* _tmp9_ = NULL;
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp7_ = args;
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp7__length1 = args_length1;
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp8_ = _tmp7_[1];
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp9_ = g_file_parse_name (_tmp8_);
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_g_object_unref0 (file);
#line 420 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						file = _tmp9_;
#line 3372 "rygel-media-engine-test.c"
					} else {
						gchar** _tmp10_;
						gint _tmp10__length1;
						const gchar* _tmp11_;
						GFile* _tmp12_ = NULL;
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp10_ = args;
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp10__length1 = args_length1;
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp11_ = _tmp10_[1];
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_tmp12_ = g_file_new_for_commandline_arg (_tmp11_);
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						_g_object_unref0 (file);
#line 422 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
						file = _tmp12_;
#line 3390 "rygel-media-engine-test.c"
					}
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp13_ = file;
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp14_ = g_file_get_parent (_tmp13_);
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp15_ = _tmp14_;
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp16_ = g_file_get_path (_tmp15_);
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp17_ = _tmp16_;
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_object_unref0 (_tmp15_);
#line 424 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					path = _tmp17_;
#line 425 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp18_ = file;
#line 425 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp19_ = g_file_get_basename (_tmp18_);
#line 425 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					engine = _tmp19_;
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp20_ = configs;
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp21_ = path;
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp22_ = engine;
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp23_ = rygel_data_source_test_config_new (_tmp21_, _tmp22_);
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp24_ = _tmp23_;
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp24_);
#line 427 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_object_unref0 (_tmp24_);
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (engine);
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (path);
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_object_unref0 (file);
#line 417 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (arg);
#line 3434 "rygel-media-engine-test.c"
				}
			}
		}
	} else {
		gchar** _tmp25_;
		gchar** _tmp26_ = NULL;
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp26_ = _tmp25_ = g_strsplit (BUILT_ENGINES, ";", 0);
#line 3443 "rygel-media-engine-test.c"
		{
			gchar** engine_collection = NULL;
			gint engine_collection_length1 = 0;
			gint _engine_collection_size_ = 0;
			gint engine_it = 0;
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			engine_collection = _tmp26_;
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			engine_collection_length1 = _vala_array_length (_tmp25_);
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			for (engine_it = 0; engine_it < _vala_array_length (_tmp25_); engine_it = engine_it + 1) {
#line 3455 "rygel-media-engine-test.c"
				gchar* _tmp27_;
				gchar* engine = NULL;
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_tmp27_ = g_strdup (engine_collection[engine_it]);
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				engine = _tmp27_;
#line 3462 "rygel-media-engine-test.c"
				{
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* name;
					GeeArrayList* _tmp33_;
					const gchar* _tmp34_;
					RygelDataSourceTestConfig* _tmp35_;
					RygelDataSourceTestConfig* _tmp36_;
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp28_ = engine;
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp29_ = g_strconcat (_tmp28_, ".", NULL);
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp30_ = _tmp29_;
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp31_ = g_strconcat (_tmp30_, G_MODULE_SUFFIX, NULL);
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp32_ = _tmp31_;
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (_tmp30_);
#line 431 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					name = _tmp32_;
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp33_ = configs;
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp34_ = name;
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp35_ = rygel_data_source_test_config_new (NULL, _tmp34_);
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_tmp36_ = _tmp35_;
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp36_);
#line 432 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_object_unref0 (_tmp36_);
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (name);
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
					_g_free0 (engine);
#line 3504 "rygel-media-engine-test.c"
				}
			}
#line 430 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			engine_collection = (_vala_array_free (engine_collection, engine_collection_length1, (GDestroyNotify) g_free), NULL);
#line 3509 "rygel-media-engine-test.c"
		}
	}
#line 436 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	previous_config = NULL;
#line 3514 "rygel-media-engine-test.c"
	{
		GeeArrayList* _tmp37_;
		GeeArrayList* _tmp38_;
		GeeArrayList* _config_list;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _config_size;
		gint _config_index;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp37_ = configs;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp38_ = _g_object_ref0 (_tmp37_);
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_config_list = _tmp38_;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp39_ = _config_list;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_tmp41_ = _tmp40_;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_config_size = _tmp41_;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_config_index = -1;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		while (TRUE) {
#line 3542 "rygel-media-engine-test.c"
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			GeeArrayList* _tmp45_;
			gint _tmp46_;
			gpointer _tmp47_ = NULL;
			RygelDataSourceTestConfig* config;
			RygelDataSourceTestConfig* _tmp48_;
			RygelDataSourceTestConfig* _tmp50_;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_;
			RygelDataSourceTestConfig* _tmp53_;
			RygelDataSourceTestConfig* _tmp54_;
			RygelDataSourceTestConfig* _tmp55_;
			RygelDataSourceTest* _tmp56_;
			RygelDataSourceTest* test;
			RygelDataSourceTest* _tmp57_;
			gint _tmp58_ = 0;
			gint _result_;
			gint _tmp59_;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp42_ = _config_index;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_config_index = _tmp42_ + 1;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp43_ = _config_index;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp44_ = _config_size;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (!(_tmp43_ < _tmp44_)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				break;
#line 3575 "rygel-media-engine-test.c"
			}
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp45_ = _config_list;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp46_ = _config_index;
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			config = (RygelDataSourceTestConfig*) _tmp47_;
#line 440 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp48_ = previous_config;
#line 440 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (_tmp48_ != NULL) {
#line 3589 "rygel-media-engine-test.c"
				RygelDataSourceTestConfig* _tmp49_;
#line 441 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_tmp49_ = previous_config;
#line 441 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				rygel_data_source_test_config_clear (_tmp49_);
#line 3595 "rygel-media-engine-test.c"
			}
#line 444 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp50_ = config;
#line 444 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp51_ = rygel_data_source_test_config_to_string (_tmp50_);
#line 444 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp52_ = _tmp51_;
#line 444 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			g_debug ("rygel-media-engine-test.vala:444: => Executing tests for config %s", _tmp52_);
#line 444 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_free0 (_tmp52_);
#line 445 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp53_ = config;
#line 445 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp53_);
#line 446 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp54_ = config;
#line 446 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 446 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (previous_config);
#line 446 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			previous_config = _tmp55_;
#line 3619 "rygel-media-engine-test.c"
			{
#line 449 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				rygel_media_engine_init (&_inner_error_);
#line 449 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				if (_inner_error_ != NULL) {
#line 3625 "rygel-media-engine-test.c"
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* _error_ = NULL;
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_error_ = _inner_error_;
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_inner_error_ = NULL;
#line 451 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				g_assert_not_reached ();
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_error_free0 (_error_);
#line 3641 "rygel-media-engine-test.c"
			}
			__finally2:
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (_inner_error_ != NULL) {
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (config);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (_config_list);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (previous_config);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (configs);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_free), NULL);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				g_clear_error (&_inner_error_);
#line 448 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				return 0;
#line 3662 "rygel-media-engine-test.c"
			}
#line 454 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp56_ = rygel_data_source_test_new ();
#line 454 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			test = _tmp56_;
#line 456 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp57_ = test;
#line 456 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp58_ = rygel_data_source_test_run (_tmp57_);
#line 456 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_result_ = _tmp58_;
#line 457 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_tmp59_ = _result_;
#line 457 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			if (_tmp59_ != 0) {
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				result = _result_;
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (test);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (config);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (_config_list);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (previous_config);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				_g_object_unref0 (configs);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_free), NULL);
#line 458 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
				return result;
#line 3694 "rygel-media-engine-test.c"
			}
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (test);
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
			_g_object_unref0 (config);
#line 3700 "rygel-media-engine-test.c"
		}
#line 437 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
		_g_object_unref0 (_config_list);
#line 3704 "rygel-media-engine-test.c"
	}
#line 462 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	result = 0;
#line 462 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (previous_config);
#line 462 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (configs);
#line 462 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_free), NULL);
#line 462 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return result;
#line 3716 "rygel-media-engine-test.c"
}


int main (int argc, char ** argv) {
#line 411 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_type_init ();
#line 411 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	return rygel_data_source_test_main (argv, argc);
#line 3725 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_class_init (RygelDataSourceTestClass * klass) {
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	rygel_data_source_test_parent_class = g_type_class_peek_parent (klass);
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	g_type_class_add_private (klass, sizeof (RygelDataSourceTestPrivate));
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_data_source_test_finalize;
#line 3736 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_instance_init (RygelDataSourceTest * self) {
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self->priv = RYGEL_DATA_SOURCE_TEST_GET_PRIVATE (self);
#line 3743 "rygel-media-engine-test.c"
}


static void rygel_data_source_test_finalize (GObject* obj) {
	RygelDataSourceTest * self;
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DATA_SOURCE_TEST, RygelDataSourceTest);
#line 139 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_object_unref0 (self->priv->test_data_file);
#line 140 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	_g_mapped_file_unref0 (self->priv->test_data_mapped);
#line 138 "/home/jens/Source/rygel/tests/rygel-media-engine-test.vala"
	G_OBJECT_CLASS (rygel_data_source_test_parent_class)->finalize (obj);
#line 3757 "rygel-media-engine-test.c"
}


/**
 * Test a DataSource implementation against the expectations of the interface
 *
 * It is run as part of the test suite but can be used to check arbitrary
 * media engines as well:
 *
 * rygel-media-engine-test /path/to/my/first/custom-rygel-engine.so \
 *                         /path/to/my/second/custom-rygel-engine.so ...
 */
GType rygel_data_source_test_get_type (void) {
	static volatile gsize rygel_data_source_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_data_source_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDataSourceTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_data_source_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDataSourceTest), 0, (GInstanceInitFunc) rygel_data_source_test_instance_init, NULL };
		GType rygel_data_source_test_type_id;
		rygel_data_source_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDataSourceTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_data_source_test_type_id__volatile, rygel_data_source_test_type_id);
	}
	return rygel_data_source_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



