/**
 * SECTION:rygel-recursive-module-loader
 * @short_description: Recursivly walk a folder looking for shared libraries.
 * 
 * <para>The folder can either be walked synchronously or asynchronously. Implementing classes need to implement the abstract method load_module_from_file() which is called when the walker encounters a dynamic module file.</para>
 */
/**
 * RYGEL_TYPE_RECURSIVE_MODULE_LOADER
 * 
 * The type for <link linkend="RygelRecursiveModuleLoader"><type>RygelRecursiveModuleLoader</type></link>.
 */
/**
 * rygel_recursive_module_loader_load_modules
 * @self: the <link linkend="RygelRecursiveModuleLoader"><type>RygelRecursiveModuleLoader</type></link> instance
 * 
 * Walk asynchronously through the tree and load modules.
 */
/**
 * rygel_recursive_module_loader_load_modules_sync
 * @self: the <link linkend="RygelRecursiveModuleLoader"><type>RygelRecursiveModuleLoader</type></link> instance
 * 
 * Walk synchronously through the tree and load modules.
 */
/**
 * rygel_recursive_module_loader_load_module_from_file
 * @self: the <link linkend="RygelRecursiveModuleLoader"><type>RygelRecursiveModuleLoader</type></link> instance
 * @file: (in): File to load the module from 
 * 
 * Load module from file.
 * 
 * Returns: The implementation should return true if the class should continue to search for modules, false otherwise. 
 */
/**
 * RygelRecursiveModuleLoader
 * 
 * Recursivly walk a folder looking for shared libraries.
 * 
 * <para>The folder can either be walked synchronously or asynchronously. Implementing classes need to implement the abstract method load_module_from_file() which is called when the walker encounters a dynamic module file.</para>
 */
