/* rygel-user-config.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Krzesimir Nowak <krnowak@openismus.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ENTRY_TYPE (rygel_entry_type_get_type ())

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;

#define RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR (rygel_user_config_config_pair_get_type ())
#define RYGEL_USER_CONFIG_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))

typedef struct _RygelUserConfigConfigPair RygelUserConfigConfigPair;
typedef struct _RygelUserConfigConfigPairClass RygelUserConfigConfigPairClass;

#define RYGEL_USER_CONFIG_TYPE_SECTION_PAIR (rygel_user_config_section_pair_get_type ())
#define RYGEL_USER_CONFIG_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair))
#define RYGEL_USER_CONFIG_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))

typedef struct _RygelUserConfigSectionPair RygelUserConfigSectionPair;
typedef struct _RygelUserConfigSectionPairClass RygelUserConfigSectionPairClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelUserConfigSectionPairPrivate RygelUserConfigSectionPairPrivate;

#define RYGEL_TYPE_SECTION_ENTRY (rygel_section_entry_get_type ())
#define _rygel_user_config_section_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_section_pair_unref (var), NULL)))
typedef struct _RygelUserConfigConfigPairPrivate RygelUserConfigConfigPairPrivate;

#define RYGEL_TYPE_CONFIGURATION_ENTRY (rygel_configuration_entry_get_type ())
#define _rygel_user_config_config_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_config_pair_unref (var), NULL)))
typedef struct _RygelUserConfigParamSpecConfigPair RygelUserConfigParamSpecConfigPair;
typedef struct _RygelUserConfigParamSpecSectionPair RygelUserConfigParamSpecSectionPair;

typedef enum  {
	RYGEL_ENTRY_TYPE_STRING,
	RYGEL_ENTRY_TYPE_BOOL,
	RYGEL_ENTRY_TYPE_INT
} RygelEntryType;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
	GKeyFile* sys_key_file;
	GFileMonitor* key_file_monitor;
	GFileMonitor* sys_key_file_monitor;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
typedef enum  {
	RYGEL_SECTION_ENTRY_TITLE,
	RYGEL_SECTION_ENTRY_ENABLED
} RygelSectionEntry;

struct _RygelUserConfigSectionPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigSectionPairPrivate * priv;
	RygelSectionEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigSectionPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigSectionPair *self);
};

typedef enum  {
	RYGEL_CONFIGURATION_ENTRY_UPNP_ENABLED,
	RYGEL_CONFIGURATION_ENTRY_INTERFACE,
	RYGEL_CONFIGURATION_ENTRY_PORT,
	RYGEL_CONFIGURATION_ENTRY_TRANSCODING,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION,
	RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS,
	RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH,
	RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER
} RygelConfigurationEntry;

struct _RygelUserConfigConfigPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigConfigPairPrivate * priv;
	RygelConfigurationEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigConfigPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigConfigPair *self);
};

struct _RygelUserConfigParamSpecConfigPair {
	GParamSpec parent_instance;
};

struct _RygelUserConfigParamSpecSectionPair {
	GParamSpec parent_instance;
};


static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static GeeHashMap* rygel_user_config_config_keys;
static GeeHashMap* rygel_user_config_config_keys = NULL;
static GeeHashMap* rygel_user_config_section_keys;
static GeeHashMap* rygel_user_config_section_keys = NULL;
static gpointer rygel_user_config_config_pair_parent_class = NULL;
static gpointer rygel_user_config_section_pair_parent_class = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_entry_type_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
static gpointer rygel_user_config_config_pair_ref (gpointer instance);
static void rygel_user_config_config_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_config_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_config_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_config_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_config_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_config_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer rygel_user_config_section_pair_ref (gpointer instance);
static void rygel_user_config_section_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_section_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_section_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_section_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_section_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_section_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_USER_CONFIG_GENERAL_SECTION "general"
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_UPNP_ENABLED_KEY "upnp-" RYGEL_USER_CONFIG_ENABLED_KEY
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVELS_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_ENGINE_PATH_KEY "engine-path"
#define RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY "media-engine"
#define RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY "upload-folder"
#define RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY "video-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY "music-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY "picture-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_engine_path (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_media_engine (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error);
static void rygel_user_config_initialize (RygelUserConfig* self, const gchar* local_path, const gchar* system_path, GError** error);
static void rygel_user_config_on_system_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_user_config_on_local_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
RygelUserConfig* rygel_user_config_new_with_paths (const gchar* local_path, const gchar* system_path, GError** error);
RygelUserConfig* rygel_user_config_construct_with_paths (GType object_type, const gchar* local_path, const gchar* system_path, GError** error);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_get_string_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_user_config_get_string_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_get_int_from_keyfiles (const gchar* section, const gchar* key, gint min, gint max, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_get_int_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_user_config_get_bool_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_user_config_get_value_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeHashSet* rygel_user_config_get_sections (GKeyFile* key_file, GKeyFile* sys_key_file);
static GeeHashSet* rygel_user_config_get_keys (const gchar* section, GKeyFile* key_file, GKeyFile* sys_key_file);
static gboolean rygel_user_config_are_values_different (const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* new_key_file, GKeyFile* new_sys_key_file, RygelEntryType type);
static void rygel_user_config_emit_conditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* key_file, GKeyFile* sys_key_file, GeeHashMap* config_keys);
GType rygel_section_entry_get_type (void) G_GNUC_CONST;
GType rygel_configuration_entry_get_type (void) G_GNUC_CONST;
static void rygel_user_config_emit_unconditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GeeHashMap* config_keys);
static void rygel_user_config_compare_and_notify (RygelUserConfig* self, GKeyFile* key_file, GKeyFile* sys_key_file);
static void rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self, GFile* system);
static void rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self, GFile* local);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_new (RygelConfigurationEntry entry, RygelEntryType type);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_construct (GType object_type, RygelConfigurationEntry entry, RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_new (RygelSectionEntry entry, RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_construct (GType object_type, RygelSectionEntry entry, RygelEntryType type);
enum  {
	RYGEL_USER_CONFIG_CONFIG_PAIR_DUMMY_PROPERTY
};
static void rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair* obj);
enum  {
	RYGEL_USER_CONFIG_SECTION_PAIR_DUMMY_PROPERTY
};
static void rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair* obj);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType rygel_entry_type_get_type (void) {
	static volatile gsize rygel_entry_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_entry_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_ENTRY_TYPE_STRING, "RYGEL_ENTRY_TYPE_STRING", "string"}, {RYGEL_ENTRY_TYPE_BOOL, "RYGEL_ENTRY_TYPE_BOOL", "bool"}, {RYGEL_ENTRY_TYPE_INT, "RYGEL_ENTRY_TYPE_INT", "int"}, {0, NULL, NULL}};
		GType rygel_entry_type_type_id;
		rygel_entry_type_type_id = g_enum_register_static ("RygelEntryType", values);
		g_once_init_leave (&rygel_entry_type_type_id__volatile, rygel_entry_type_type_id);
	}
	return rygel_entry_type_type_id__volatile;
}


static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 152 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_UPNP_ENABLED_KEY, &_inner_error_);
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 346 "rygel-user-config.c"
	}
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 153 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 352 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 374 "rygel-user-config.c"
	}
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 157 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 380 "rygel-user-config.c"
}


static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	guint16 _tmp0_;
	guint16 _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
#line 160 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = 0U;
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = G_MAXUINT16;
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = rygel_configuration_get_int ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PORT_KEY, (gint) _tmp0_, (gint) _tmp1_, &_inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = _tmp2_;
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return 0;
#line 408 "rygel-user-config.c"
	}
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp3_;
#line 161 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 414 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 436 "rygel-user-config.c"
	}
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 165 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 442 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 168 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, &_inner_error_);
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 464 "rygel-user-config.c"
	}
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 169 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 470 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 172 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, &_inner_error_);
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 492 "rygel-user-config.c"
	}
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 173 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 498 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 176 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, &_inner_error_);
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 520 "rygel-user-config.c"
	}
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 177 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 526 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 180 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 548 "rygel-user-config.c"
	}
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 181 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 554 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_engine_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ENGINE_PATH_KEY, &_inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 576 "rygel-user-config.c"
	}
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 185 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 582 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_media_engine (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 188 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY, &_inner_error_);
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 604 "rygel-user-config.c"
	}
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 189 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 610 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 632 "rygel-user-config.c"
	}
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 193 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 638 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 660 "rygel-user-config.c"
	}
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 197 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 666 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 200 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, &_inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _tmp0_;
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 688 "rygel-user-config.c"
	}
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp1_;
#line 201 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 694 "rygel-user-config.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 211 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self ? g_object_ref (self) : NULL;
#line 701 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_get_default (GError** error) {
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp0_;
	RygelUserConfig* _tmp6_;
	RygelUserConfig* _tmp7_;
	GError * _inner_error_ = NULL;
#line 205 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_user_config_config;
#line 205 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp0_ == NULL) {
#line 715 "rygel-user-config.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* path;
		const gchar* _tmp3_;
		RygelUserConfig* _tmp4_;
		RygelUserConfig* _tmp5_;
#line 206 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = g_get_user_config_dir ();
#line 206 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = g_build_filename (_tmp1_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		path = _tmp2_;
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = path;
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = rygel_user_config_new (_tmp3_, &_inner_error_);
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = _tmp4_;
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_propagate_error (error, _inner_error_);
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (path);
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return NULL;
#line 742 "rygel-user-config.c"
		}
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (rygel_user_config_config);
#line 208 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_config = _tmp5_;
#line 205 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (path);
#line 750 "rygel-user-config.c"
	}
#line 211 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp6_ = rygel_user_config_config;
#line 211 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 211 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp7_;
#line 211 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 760 "rygel-user-config.c"
}


static void _rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 229 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_on_system_config_changed (self, _sender, file, other_file, event_type);
#line 767 "rygel-user-config.c"
}


static void _rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 249 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_on_local_config_changed (self, _sender, file, other_file, event_type);
#line 774 "rygel-user-config.c"
}


static void rygel_user_config_initialize (RygelUserConfig* self, const gchar* local_path, const gchar* system_path, GError** error) {
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* sys_key_g_file;
	GFile* _tmp7_;
	GFileMonitor* _tmp8_ = NULL;
	GFileMonitor* _tmp9_;
	GFileMonitor* _tmp10_;
	const gchar* _tmp18_;
	GFile* _tmp19_ = NULL;
	GFile* key_g_file;
	GFile* _tmp20_;
	GFileMonitor* _tmp21_ = NULL;
	GFileMonitor* _tmp22_;
	GFileMonitor* _tmp23_;
	GError * _inner_error_ = NULL;
#line 214 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (local_path != NULL);
#line 214 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (system_path != NULL);
#line 216 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = g_key_file_new ();
#line 216 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->key_file);
#line 216 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->key_file = _tmp0_;
#line 217 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = g_key_file_new ();
#line 217 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->sys_key_file);
#line 217 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->sys_key_file = _tmp1_;
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->sys_key_file;
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = system_path;
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_key_file_load_from_file (_tmp2_, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 219 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 829 "rygel-user-config.c"
	}
#line 222 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = system_path;
#line 222 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_debug ("rygel-user-config.vala:222: Loaded system configuration from file '%s'", _tmp4_);
#line 224 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = system_path;
#line 224 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 224 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	sys_key_g_file = _tmp6_;
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = sys_key_g_file;
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp8_ = g_file_monitor_file (_tmp7_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp9_ = _tmp8_;
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (sys_key_g_file);
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 855 "rygel-user-config.c"
	}
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (self->sys_key_file_monitor);
#line 225 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->sys_key_file_monitor = _tmp9_;
#line 229 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp10_ = self->sys_key_file_monitor;
#line 229 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_signal_connect_object (_tmp10_, "changed", (GCallback) _rygel_user_config_on_system_config_changed_g_file_monitor_changed, self, 0);
#line 865 "rygel-user-config.c"
	{
		GKeyFile* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
#line 233 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp11_ = self->key_file;
#line 233 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp12_ = local_path;
#line 233 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_key_file_load_from_file (_tmp11_, _tmp12_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 233 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 878 "rygel-user-config.c"
			goto __catch0_g_error;
		}
#line 237 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp13_ = local_path;
#line 237 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_debug ("rygel-user-config.vala:237: Loaded user configuration from file '%s'", _tmp13_);
#line 885 "rygel-user-config.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GKeyFile* _tmp17_;
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 239 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp14_ = local_path;
#line 239 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp15_ = _error_;
#line 239 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp16_ = _tmp15_->message;
#line 239 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_debug ("rygel-user-config.vala:239: Failed to load user configuration from fil" \
"e '%s': %s", _tmp14_, _tmp16_);
#line 242 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp17_ = g_key_file_new ();
#line 242 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_key_file_unref0 (self->key_file);
#line 242 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		self->key_file = _tmp17_;
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 915 "rygel-user-config.c"
	}
	__finally0:
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (sys_key_g_file);
#line 232 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 926 "rygel-user-config.c"
	}
#line 245 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp18_ = local_path;
#line 245 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19_ = g_file_new_for_path (_tmp18_);
#line 245 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	key_g_file = _tmp19_;
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp20_ = key_g_file;
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp21_ = g_file_monitor_file (_tmp20_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp22_ = _tmp21_;
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (key_g_file);
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (sys_key_g_file);
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 950 "rygel-user-config.c"
	}
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (self->key_file_monitor);
#line 247 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->key_file_monitor = _tmp22_;
#line 249 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp23_ = self->key_file_monitor;
#line 249 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_signal_connect_object (_tmp23_, "changed", (GCallback) _rygel_user_config_on_local_config_changed_g_file_monitor_changed, self, 0);
#line 214 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (key_g_file);
#line 214 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (sys_key_g_file);
#line 964 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error) {
	RygelUserConfig * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* system_path;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 252 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (local_path != NULL, NULL);
#line 252 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
#line 253 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = g_build_filename (SYS_CONFIG_DIR, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 253 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	system_path = _tmp0_;
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = local_path;
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_initialize (self, _tmp1_, system_path, &_inner_error_);
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (system_path);
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (self);
#line 256 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 996 "rygel-user-config.c"
	}
#line 252 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_free0 (system_path);
#line 252 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self;
#line 1002 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error) {
#line 252 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, local_path, error);
#line 1009 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_construct_with_paths (GType object_type, const gchar* local_path, const gchar* system_path, GError** error) {
	RygelUserConfig * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 259 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (local_path != NULL, NULL);
#line 259 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (system_path != NULL, NULL);
#line 259 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = local_path;
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = system_path;
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_initialize (self, _tmp0_, _tmp1_, &_inner_error_);
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (self);
#line 261 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1038 "rygel-user-config.c"
	}
#line 259 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self;
#line 1042 "rygel-user-config.c"
}


RygelUserConfig* rygel_user_config_new_with_paths (const gchar* local_path, const gchar* system_path, GError** error) {
#line 259 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return rygel_user_config_construct_with_paths (RYGEL_TYPE_USER_CONFIG, local_path, system_path, error);
#line 1049 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 264 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 264 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, _tmp0_, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = _tmp1_;
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 1076 "rygel-user-config.c"
	}
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp2_;
#line 265 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1082 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 268 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 268 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, _tmp0_, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = _tmp1_;
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1109 "rygel-user-config.c"
	}
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp2_;
#line 269 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1115 "rygel-user-config.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 286 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self ? g_error_copy (self) : NULL;
#line 1122 "rygel-user-config.c"
}


static gchar* rygel_user_config_get_string_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gchar* result = NULL;
	gchar* val = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
#line 272 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 272 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 272 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 272 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 1141 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp0_ = key_file;
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = section;
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = key;
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_string (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1162 "rygel-user-config.c"
				goto __catch1_g_key_file_error;
			}
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (val);
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return NULL;
#line 1173 "rygel-user-config.c"
		}
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (val);
#line 280 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		val = _tmp4_;
#line 1179 "rygel-user-config.c"
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 282 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 282 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 282 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 1198 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 283 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 283 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1205 "rygel-user-config.c"
		}
#line 282 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 282 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp8_) {
#line 1211 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = sys_key_file;
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp10_ = section;
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = key;
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_string (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1231 "rygel-user-config.c"
				goto __finally1;
			}
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (val);
#line 284 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			val = _tmp13_;
#line 1238 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 286 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 286 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 286 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 286 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1250 "rygel-user-config.c"
			goto __finally1;
		}
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1255 "rygel-user-config.c"
	}
	__finally1:
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (val);
#line 279 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1266 "rygel-user-config.c"
	}
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp17_ = val;
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp17_ == NULL) {
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp16_ = TRUE;
#line 1274 "rygel-user-config.c"
	} else {
		const gchar* _tmp18_;
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp18_ = val;
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp16_ = g_strcmp0 (_tmp18_, "") == 0;
#line 1281 "rygel-user-config.c"
	}
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19_ = _tmp16_;
#line 290 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp19_) {
#line 1287 "rygel-user-config.c"
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		GError* _tmp22_;
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp20_ = _ ("No value available for '%s'");
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp21_ = key;
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp22_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp20_, _tmp21_);
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = _tmp22_;
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (val);
#line 291 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1305 "rygel-user-config.c"
	}
#line 295 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = val;
#line 295 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1311 "rygel-user-config.c"
}


static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 298 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 298 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 298 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->key_file;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = self->sys_key_file;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = rygel_user_config_get_string_from_keyfiles (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = _tmp4_;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1349 "rygel-user-config.c"
	}
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp5_;
#line 300 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1355 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_get_string_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* str_list;
	gchar** strings = NULL;
	gint strings_length1 = 0;
	gint _strings_size_ = 0;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
#line 306 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 306 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 306 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 306 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 312 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 312 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	str_list = _tmp0_;
#line 1381 "rygel-user-config.c"
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gsize _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gint __tmp6__size_;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = key_file;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = section;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = key;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = g_key_file_get_string_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _tmp5_;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6__length1 = _tmp4_;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		__tmp6__size_ = _tmp6__length1;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1409 "rygel-user-config.c"
				goto __catch2_g_key_file_error;
			}
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (str_list);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return NULL;
#line 1422 "rygel-user-config.c"
		}
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		strings = _tmp6_;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		strings_length1 = _tmp6__length1;
#line 316 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_strings_size_ = strings_length1;
#line 1432 "rygel-user-config.c"
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_;
		gboolean _tmp10_;
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 318 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _error_;
#line 318 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 318 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = TRUE;
#line 1451 "rygel-user-config.c"
		} else {
			GError* _tmp9_;
#line 319 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = _error_;
#line 319 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1458 "rygel-user-config.c"
		}
#line 318 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp10_ = _tmp7_;
#line 318 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp10_) {
#line 1464 "rygel-user-config.c"
			GKeyFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gsize _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint __tmp16__size_;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = sys_key_file;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = section;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = key;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = g_key_file_get_string_list (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_inner_error_);
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16_ = _tmp15_;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16__length1 = _tmp14_;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			__tmp16__size_ = _tmp16__length1;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1491 "rygel-user-config.c"
				goto __finally2;
			}
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			strings = _tmp16_;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			strings_length1 = _tmp16__length1;
#line 320 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_strings_size_ = strings_length1;
#line 1502 "rygel-user-config.c"
		} else {
			GError* _tmp17_;
			GError* _tmp18_;
#line 322 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp17_ = _error_;
#line 322 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp18_ = _g_error_copy0 (_tmp17_);
#line 322 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp18_;
#line 322 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1514 "rygel-user-config.c"
			goto __finally2;
		}
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1519 "rygel-user-config.c"
	}
	__finally2:
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (str_list);
#line 315 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1532 "rygel-user-config.c"
	}
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19_ = strings;
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19__length1 = strings_length1;
#line 1538 "rygel-user-config.c"
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		str_collection = _tmp19_;
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		str_collection_length1 = _tmp19__length1;
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		for (str_it = 0; str_it < _tmp19__length1; str_it = str_it + 1) {
#line 1550 "rygel-user-config.c"
			gchar* _tmp20_;
			gchar* str = NULL;
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp20_ = g_strdup (str_collection[str_it]);
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			str = _tmp20_;
#line 1557 "rygel-user-config.c"
			{
				GeeArrayList* _tmp21_;
				const gchar* _tmp22_;
#line 327 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp21_ = str_list;
#line 327 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp22_ = str;
#line 327 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
#line 326 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (str);
#line 1569 "rygel-user-config.c"
			}
		}
	}
#line 330 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = str_list;
#line 330 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 330 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1579 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_;
	GError * _inner_error_ = NULL;
#line 333 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 333 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 333 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->key_file;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = self->sys_key_file;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = rygel_user_config_get_string_list_from_keyfiles (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = _tmp4_;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 1617 "rygel-user-config.c"
	}
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp5_;
#line 335 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1623 "rygel-user-config.c"
}


static gint rygel_user_config_get_int_from_keyfiles (const gchar* section, const gchar* key, gint min, gint max, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gint result = 0;
	gint val = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	gint _tmp18_;
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
#line 341 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 341 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 341 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, 0);
#line 341 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, 0);
#line 1643 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp0_ = key_file;
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = section;
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = key;
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1664 "rygel-user-config.c"
				goto __catch3_g_key_file_error;
			}
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return 0;
#line 1673 "rygel-user-config.c"
		}
#line 351 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		val = _tmp4_;
#line 1677 "rygel-user-config.c"
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 353 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 353 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 353 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 1696 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 354 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 354 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1703 "rygel-user-config.c"
		}
#line 353 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 353 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp8_) {
#line 1709 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_;
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = sys_key_file;
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp10_ = section;
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = key;
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_integer (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1729 "rygel-user-config.c"
				goto __finally3;
			}
#line 355 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			val = _tmp13_;
#line 1734 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 357 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 357 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 357 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 357 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 1746 "rygel-user-config.c"
			goto __finally3;
		}
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 1751 "rygel-user-config.c"
	}
	__finally3:
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 350 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return 0;
#line 1760 "rygel-user-config.c"
	}
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp17_ = val;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp18_ = min;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp17_ < _tmp18_) {
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp16_ = TRUE;
#line 1770 "rygel-user-config.c"
	} else {
		gint _tmp19_;
		gint _tmp20_;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp19_ = val;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp20_ = max;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp16_ = _tmp19_ > _tmp20_;
#line 1780 "rygel-user-config.c"
	}
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp21_ = _tmp16_;
#line 361 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp21_) {
#line 1786 "rygel-user-config.c"
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		GError* _tmp24_;
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp22_ = _ ("Value of '%s' out of range");
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp23_ = key;
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp24_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _tmp22_, _tmp23_);
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = _tmp24_;
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 362 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return 0;
#line 1802 "rygel-user-config.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = val;
#line 366 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1808 "rygel-user-config.c"
}


static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
#line 369 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 369 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 369 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = min;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = max;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = self->key_file;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = self->sys_key_file;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp6_ = rygel_user_config_get_int_from_keyfiles (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = _tmp6_;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return 0;
#line 1852 "rygel-user-config.c"
	}
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp7_;
#line 373 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 1858 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_get_int_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* int_list;
	gint* ints = NULL;
	gint ints_length1 = 0;
	gint _ints_size_ = 0;
	gint* _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
#line 381 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 381 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 381 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 381 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 387 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
#line 387 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	int_list = _tmp0_;
#line 1884 "rygel-user-config.c"
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gsize _tmp4_;
		gint* _tmp5_ = NULL;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint __tmp6__size_;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = key_file;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = section;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = key;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = g_key_file_get_integer_list (_tmp1_, _tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _tmp5_;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6__length1 = _tmp4_;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		__tmp6__size_ = _tmp6__length1;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1912 "rygel-user-config.c"
				goto __catch4_g_key_file_error;
			}
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			ints = (g_free (ints), NULL);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (int_list);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return NULL;
#line 1925 "rygel-user-config.c"
		}
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		ints = (g_free (ints), NULL);
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		ints = _tmp6_;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		ints_length1 = _tmp6__length1;
#line 391 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_ints_size_ = ints_length1;
#line 1935 "rygel-user-config.c"
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_;
		gboolean _tmp10_;
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 393 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _error_;
#line 393 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 393 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = TRUE;
#line 1954 "rygel-user-config.c"
		} else {
			GError* _tmp9_;
#line 394 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = _error_;
#line 394 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 1961 "rygel-user-config.c"
		}
#line 393 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp10_ = _tmp7_;
#line 393 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp10_) {
#line 1967 "rygel-user-config.c"
			GKeyFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gsize _tmp14_;
			gint* _tmp15_ = NULL;
			gint* _tmp16_;
			gint _tmp16__length1;
			gint __tmp16__size_;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = sys_key_file;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = section;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = key;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = g_key_file_get_integer_list (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_inner_error_);
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16_ = _tmp15_;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16__length1 = _tmp14_;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			__tmp16__size_ = _tmp16__length1;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 1994 "rygel-user-config.c"
				goto __finally4;
			}
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			ints = (g_free (ints), NULL);
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			ints = _tmp16_;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			ints_length1 = _tmp16__length1;
#line 395 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_ints_size_ = ints_length1;
#line 2005 "rygel-user-config.c"
		} else {
			GError* _tmp17_;
			GError* _tmp18_;
#line 397 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp17_ = _error_;
#line 397 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp18_ = _g_error_copy0 (_tmp17_);
#line 397 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp18_;
#line 397 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 2017 "rygel-user-config.c"
			goto __finally4;
		}
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 2022 "rygel-user-config.c"
	}
	__finally4:
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		ints = (g_free (ints), NULL);
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (int_list);
#line 390 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 2035 "rygel-user-config.c"
	}
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19_ = ints;
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19__length1 = ints_length1;
#line 2041 "rygel-user-config.c"
	{
		gint* num_collection = NULL;
		gint num_collection_length1 = 0;
		gint _num_collection_size_ = 0;
		gint num_it = 0;
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		num_collection = _tmp19_;
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		num_collection_length1 = _tmp19__length1;
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		for (num_it = 0; num_it < _tmp19__length1; num_it = num_it + 1) {
#line 2053 "rygel-user-config.c"
			gint num = 0;
#line 401 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			num = num_collection[num_it];
#line 2057 "rygel-user-config.c"
			{
				GeeArrayList* _tmp20_;
				gint _tmp21_;
#line 402 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp20_ = int_list;
#line 402 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp21_ = num;
#line 402 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (gpointer) ((gintptr) _tmp21_));
#line 2067 "rygel-user-config.c"
			}
		}
	}
#line 405 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = int_list;
#line 405 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	ints = (g_free (ints), NULL);
#line 405 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2077 "rygel-user-config.c"
}


static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_;
	GError * _inner_error_ = NULL;
#line 408 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 408 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 408 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->key_file;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = self->sys_key_file;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = rygel_user_config_get_int_list_from_keyfiles (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = _tmp4_;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 2115 "rygel-user-config.c"
	}
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp5_;
#line 410 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2121 "rygel-user-config.c"
}


static gboolean rygel_user_config_get_bool_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
#line 416 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 416 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 416 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, FALSE);
#line 416 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, FALSE);
#line 2137 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp0_ = key_file;
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = section;
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = key;
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 2158 "rygel-user-config.c"
				goto __catch5_g_key_file_error;
			}
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return FALSE;
#line 2167 "rygel-user-config.c"
		}
#line 424 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		val = _tmp4_;
#line 2171 "rygel-user-config.c"
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 426 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 426 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 426 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 2190 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 427 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 427 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 2197 "rygel-user-config.c"
		}
#line 426 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 426 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp8_) {
#line 2203 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = sys_key_file;
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp10_ = section;
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = key;
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_boolean (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 2223 "rygel-user-config.c"
				goto __finally5;
			}
#line 428 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			val = _tmp13_;
#line 2228 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 430 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 430 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 430 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 430 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 2240 "rygel-user-config.c"
			goto __finally5;
		}
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 2245 "rygel-user-config.c"
	}
	__finally5:
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 2254 "rygel-user-config.c"
	}
#line 434 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = val;
#line 434 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2260 "rygel-user-config.c"
}


static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
#line 437 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfig*) base;
#line 437 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 437 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = section;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->key_file;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = self->sys_key_file;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = rygel_user_config_get_bool_from_keyfiles (_tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = _tmp4_;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return FALSE;
#line 2298 "rygel-user-config.c"
	}
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = _tmp5_;
#line 439 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2304 "rygel-user-config.c"
}


static gchar* rygel_user_config_get_value_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gchar* result = NULL;
	gchar* val = NULL;
	GError * _inner_error_ = NULL;
#line 445 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 445 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 445 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 445 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 2320 "rygel-user-config.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp0_ = key_file;
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = section;
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = key;
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = g_key_file_get_value (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = _tmp3_;
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 2341 "rygel-user-config.c"
				goto __catch6_g_key_file_error;
			}
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (val);
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_clear_error (&_inner_error_);
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return NULL;
#line 2352 "rygel-user-config.c"
		}
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (val);
#line 453 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		val = _tmp4_;
#line 2358 "rygel-user-config.c"
	}
	goto __finally6;
	__catch6_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_error_ = _inner_error_;
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 455 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = _error_;
#line 455 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
#line 455 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = TRUE;
#line 2377 "rygel-user-config.c"
		} else {
			GError* _tmp7_;
#line 456 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp7_ = _error_;
#line 456 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
#line 2384 "rygel-user-config.c"
		}
#line 455 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _tmp5_;
#line 455 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp8_) {
#line 2390 "rygel-user-config.c"
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp9_ = sys_key_file;
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp10_ = section;
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp11_ = key;
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = g_key_file_get_value (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = _tmp12_;
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (_error_);
#line 2410 "rygel-user-config.c"
				goto __finally6;
			}
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (val);
#line 457 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			val = _tmp13_;
#line 2417 "rygel-user-config.c"
		} else {
			GError* _tmp14_;
			GError* _tmp15_;
#line 459 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp14_ = _error_;
#line 459 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = _g_error_copy0 (_tmp14_);
#line 459 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_inner_error_ = _tmp15_;
#line 459 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_error_free0 (_error_);
#line 2429 "rygel-user-config.c"
			goto __finally6;
		}
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (_error_);
#line 2434 "rygel-user-config.c"
	}
	__finally6:
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_propagate_error (error, _inner_error_);
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (val);
#line 452 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 2445 "rygel-user-config.c"
	}
#line 463 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = val;
#line 463 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2451 "rygel-user-config.c"
}


static GeeHashSet* rygel_user_config_get_sections (GKeyFile* key_file, GKeyFile* sys_key_file) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* sections;
	GKeyFile* _tmp1_;
	gsize _tmp2_;
	gchar** _tmp3_ = NULL;
	GKeyFile* _tmp7_;
	gsize _tmp8_;
	gchar** _tmp9_ = NULL;
#line 466 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 466 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 468 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
#line 468 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	sections = _tmp0_;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key_file;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = g_key_file_get_groups (_tmp1_, &_tmp2_);
#line 2477 "rygel-user-config.c"
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection = _tmp3_;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection_length1 = _tmp2_;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		for (section_it = 0; section_it < _tmp2_; section_it = section_it + 1) {
#line 2489 "rygel-user-config.c"
			gchar* _tmp4_;
			gchar* section = NULL;
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp4_ = g_strdup (section_collection[section_it]);
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			section = _tmp4_;
#line 2496 "rygel-user-config.c"
			{
				GeeHashSet* _tmp5_;
				const gchar* _tmp6_;
#line 471 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp5_ = sections;
#line 471 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp6_ = section;
#line 471 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (section);
#line 2508 "rygel-user-config.c"
			}
		}
#line 470 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2513 "rygel-user-config.c"
	}
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = sys_key_file;
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp9_ = g_key_file_get_groups (_tmp7_, &_tmp8_);
#line 2519 "rygel-user-config.c"
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection = _tmp9_;
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection_length1 = _tmp8_;
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		for (section_it = 0; section_it < _tmp8_; section_it = section_it + 1) {
#line 2531 "rygel-user-config.c"
			gchar* _tmp10_;
			gchar* section = NULL;
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp10_ = g_strdup (section_collection[section_it]);
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			section = _tmp10_;
#line 2538 "rygel-user-config.c"
			{
				GeeHashSet* _tmp11_;
				const gchar* _tmp12_;
#line 475 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp11_ = sections;
#line 475 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp12_ = section;
#line 475 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (section);
#line 2550 "rygel-user-config.c"
			}
		}
#line 474 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2555 "rygel-user-config.c"
	}
#line 478 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = sections;
#line 478 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2561 "rygel-user-config.c"
}


static GeeHashSet* rygel_user_config_get_keys (const gchar* section, GKeyFile* key_file, GKeyFile* sys_key_file) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* keys;
	GError * _inner_error_ = NULL;
#line 481 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 481 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key_file != NULL, NULL);
#line 481 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (sys_key_file != NULL, NULL);
#line 484 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
#line 484 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	keys = _tmp0_;
#line 2580 "rygel-user-config.c"
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		gsize _tmp3_;
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gint __tmp5__size_;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = key_file;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = section;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = g_key_file_get_keys (_tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = _tmp4_;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5__length1 = _tmp3_;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		__tmp5__size_ = _tmp5__length1;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 2603 "rygel-user-config.c"
			goto __catch7_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection = _tmp5_;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection_length1 = _tmp5__length1;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			for (key_it = 0; key_it < _tmp5__length1; key_it = key_it + 1) {
#line 2617 "rygel-user-config.c"
				gchar* _tmp6_;
				gchar* key = NULL;
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp6_ = g_strdup (key_collection[key_it]);
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				key = _tmp6_;
#line 2624 "rygel-user-config.c"
				{
					const gchar* _tmp7_;
#line 488 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp7_ = key;
#line 488 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp7_);
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_free0 (key);
#line 2633 "rygel-user-config.c"
				}
			}
#line 487 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2638 "rygel-user-config.c"
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		e = _inner_error_;
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (e);
#line 2651 "rygel-user-config.c"
	}
	__finally7:
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (keys);
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_clear_error (&_inner_error_);
#line 486 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 2664 "rygel-user-config.c"
	}
	{
		GKeyFile* _tmp8_;
		const gchar* _tmp9_;
		gsize _tmp10_;
		gchar** _tmp11_ = NULL;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gint __tmp12__size_;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = sys_key_file;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp9_ = section;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp11_ = g_key_file_get_keys (_tmp8_, _tmp9_, &_tmp10_, &_inner_error_);
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp12_ = _tmp11_;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp12__length1 = _tmp10_;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		__tmp12__size_ = _tmp12__length1;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 2688 "rygel-user-config.c"
			goto __catch8_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection = _tmp12_;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection_length1 = _tmp12__length1;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			for (key_it = 0; key_it < _tmp12__length1; key_it = key_it + 1) {
#line 2702 "rygel-user-config.c"
				gchar* _tmp13_;
				gchar* key = NULL;
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp13_ = g_strdup (key_collection[key_it]);
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				key = _tmp13_;
#line 2709 "rygel-user-config.c"
				{
					const gchar* _tmp14_;
#line 494 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp14_ = key;
#line 494 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp14_);
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_free0 (key);
#line 2718 "rygel-user-config.c"
				}
			}
#line 493 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2723 "rygel-user-config.c"
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		e = _inner_error_;
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (e);
#line 2736 "rygel-user-config.c"
	}
	__finally8:
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (keys);
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_clear_error (&_inner_error_);
#line 492 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return NULL;
#line 2749 "rygel-user-config.c"
	}
#line 498 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	result = keys;
#line 498 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return result;
#line 2755 "rygel-user-config.c"
}


static gboolean rygel_user_config_are_values_different (const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* new_key_file, GKeyFile* new_sys_key_file, RygelEntryType type) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (old_key_file != NULL, FALSE);
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (old_sys_key_file != NULL, FALSE);
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (new_key_file != NULL, FALSE);
#line 501 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (new_sys_key_file != NULL, FALSE);
#line 2774 "rygel-user-config.c"
	{
		RygelEntryType _tmp0_;
#line 509 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp0_ = type;
#line 509 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		switch (_tmp0_) {
#line 509 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			case RYGEL_ENTRY_TYPE_STRING:
#line 2783 "rygel-user-config.c"
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				GKeyFile* _tmp3_;
				GKeyFile* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* old_value;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GKeyFile* _tmp8_;
				GKeyFile* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* new_value;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp1_ = section;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp2_ = key;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp3_ = old_key_file;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp4_ = old_sys_key_file;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp5_ = rygel_user_config_get_string_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				old_value = _tmp5_;
#line 511 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 2813 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp6_ = section;
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp7_ = key;
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp8_ = new_key_file;
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp9_ = new_sys_key_file;
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp10_ = rygel_user_config_get_string_from_keyfiles (_tmp6_, _tmp7_, _tmp8_, _tmp9_, &_inner_error_);
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				new_value = _tmp10_;
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 516 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_free0 (old_value);
#line 2832 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp11_ = old_value;
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp12_ = new_value;
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				result = g_strcmp0 (_tmp11_, _tmp12_) != 0;
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (new_value);
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (old_value);
#line 522 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				return result;
#line 2847 "rygel-user-config.c"
			}
#line 509 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			case RYGEL_ENTRY_TYPE_BOOL:
#line 2851 "rygel-user-config.c"
			{
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				GKeyFile* _tmp15_;
				GKeyFile* _tmp16_;
				gboolean _tmp17_ = FALSE;
				gboolean old_value;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GKeyFile* _tmp20_;
				GKeyFile* _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean new_value;
				gboolean _tmp23_;
				gboolean _tmp24_;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp13_ = section;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp14_ = key;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp15_ = old_key_file;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp16_ = old_sys_key_file;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp17_ = rygel_user_config_get_bool_from_keyfiles (_tmp13_, _tmp14_, _tmp15_, _tmp16_, &_inner_error_);
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				old_value = _tmp17_;
#line 525 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 2881 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp18_ = section;
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp19_ = key;
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp20_ = new_key_file;
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp21_ = new_sys_key_file;
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp22_ = rygel_user_config_get_bool_from_keyfiles (_tmp18_, _tmp19_, _tmp20_, _tmp21_, &_inner_error_);
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				new_value = _tmp22_;
#line 530 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 2898 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 536 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp23_ = old_value;
#line 536 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp24_ = new_value;
#line 536 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				result = _tmp23_ != _tmp24_;
#line 536 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				return result;
#line 2909 "rygel-user-config.c"
			}
#line 509 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			case RYGEL_ENTRY_TYPE_INT:
#line 2913 "rygel-user-config.c"
			{
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				GKeyFile* _tmp29_;
				GKeyFile* _tmp30_;
				gint _tmp31_ = 0;
				gint old_value;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				GKeyFile* _tmp36_;
				GKeyFile* _tmp37_;
				gint _tmp38_ = 0;
				gint new_value;
				gint _tmp39_;
				gint _tmp40_;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp25_ = section;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp26_ = key;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp27_ = G_MININT;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp28_ = G_MAXINT;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp29_ = old_key_file;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp30_ = old_sys_key_file;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp31_ = rygel_user_config_get_int_from_keyfiles (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, &_inner_error_);
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				old_value = _tmp31_;
#line 539 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 2951 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp32_ = section;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp33_ = key;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp34_ = G_MININT;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp35_ = G_MAXINT;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp36_ = new_key_file;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp37_ = new_sys_key_file;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp38_ = rygel_user_config_get_int_from_keyfiles (_tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, &_inner_error_);
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				new_value = _tmp38_;
#line 546 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 2972 "rygel-user-config.c"
					goto __catch9_g_error;
				}
#line 554 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp39_ = old_value;
#line 554 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp40_ = new_value;
#line 554 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				result = _tmp39_ != _tmp40_;
#line 554 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				return result;
#line 2983 "rygel-user-config.c"
			}
			default:
			{
#line 557 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				g_assert_not_reached ();
#line 2989 "rygel-user-config.c"
			}
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
#line 508 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		e = _inner_error_;
#line 508 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 562 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		result = TRUE;
#line 562 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (e);
#line 562 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return result;
#line 3007 "rygel-user-config.c"
	}
	__finally9:
#line 508 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_clear_error (&_inner_error_);
#line 508 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return FALSE;
#line 3016 "rygel-user-config.c"
}


static void rygel_user_config_emit_conditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* key_file, GKeyFile* sys_key_file, GeeHashMap* config_keys) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (old_key_file != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (old_sys_key_file != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (key_file != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (sys_key_file != NULL);
#line 566 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (config_keys != NULL);
#line 573 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_user_config_section_keys;
#line 573 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 573 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 573 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp2_) {
#line 3049 "rygel-user-config.c"
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelUserConfigSectionPair* pair;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GKeyFile* _tmp8_;
		GKeyFile* _tmp9_;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		RygelUserConfigSectionPair* _tmp12_;
		RygelEntryType _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean emit;
		gboolean _tmp15_;
#line 575 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = rygel_user_config_section_keys;
#line 575 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = key;
#line 575 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 575 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		pair = (RygelUserConfigSectionPair*) _tmp5_;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = section;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp7_ = key;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = old_key_file;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp9_ = old_sys_key_file;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp10_ = key_file;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp11_ = sys_key_file;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp12_ = pair;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp13_ = _tmp12_->type;
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp14_ = rygel_user_config_are_values_different (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp13_);
#line 576 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		emit = _tmp14_;
#line 584 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp15_ = emit;
#line 584 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp15_) {
#line 3097 "rygel-user-config.c"
			const gchar* _tmp16_;
			RygelUserConfigSectionPair* _tmp17_;
			RygelSectionEntry _tmp18_;
#line 585 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16_ = section;
#line 585 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp17_ = pair;
#line 585 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp18_ = _tmp17_->entry;
#line 585 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", _tmp16_, _tmp18_);
#line 3109 "rygel-user-config.c"
		}
#line 573 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_rygel_user_config_section_pair_unref0 (pair);
#line 3113 "rygel-user-config.c"
	} else {
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
#line 587 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp19_ = config_keys;
#line 587 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp20_ = key;
#line 587 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp19_, _tmp20_);
#line 587 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp21_) {
#line 3126 "rygel-user-config.c"
			GeeHashMap* _tmp22_;
			const gchar* _tmp23_;
			gpointer _tmp24_ = NULL;
			RygelUserConfigConfigPair* pair;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GKeyFile* _tmp27_;
			GKeyFile* _tmp28_;
			GKeyFile* _tmp29_;
			GKeyFile* _tmp30_;
			RygelUserConfigConfigPair* _tmp31_;
			RygelEntryType _tmp32_;
			gboolean _tmp33_ = FALSE;
			gboolean emit;
			gboolean _tmp34_;
#line 588 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp22_ = config_keys;
#line 588 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp23_ = key;
#line 588 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
#line 588 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			pair = (RygelUserConfigConfigPair*) _tmp24_;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp25_ = section;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp26_ = key;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp27_ = old_key_file;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp28_ = old_sys_key_file;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp29_ = key_file;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp30_ = sys_key_file;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp31_ = pair;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp32_ = _tmp31_->type;
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp33_ = rygel_user_config_are_values_different (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp32_);
#line 589 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			emit = _tmp33_;
#line 597 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp34_ = emit;
#line 597 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_tmp34_) {
#line 3174 "rygel-user-config.c"
				RygelUserConfigConfigPair* _tmp35_;
				RygelConfigurationEntry _tmp36_;
#line 598 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp35_ = pair;
#line 598 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp36_ = _tmp35_->entry;
#line 598 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp36_);
#line 3183 "rygel-user-config.c"
			}
#line 587 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_rygel_user_config_config_pair_unref0 (pair);
#line 3187 "rygel-user-config.c"
		} else {
			gboolean emit;
			gboolean _tmp49_;
#line 603 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			emit = FALSE;
#line 3193 "rygel-user-config.c"
			{
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				GKeyFile* _tmp39_;
				GKeyFile* _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* old_value;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				GKeyFile* _tmp44_;
				GKeyFile* _tmp45_;
				gchar* _tmp46_ = NULL;
				gchar* new_value;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp37_ = section;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp38_ = key;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp39_ = old_key_file;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp40_ = old_sys_key_file;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp41_ = rygel_user_config_get_value_from_keyfiles (_tmp37_, _tmp38_, _tmp39_, _tmp40_, &_inner_error_);
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				old_value = _tmp41_;
#line 606 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 3223 "rygel-user-config.c"
					goto __catch10_g_error;
				}
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp42_ = section;
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp43_ = key;
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp44_ = key_file;
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp45_ = sys_key_file;
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp46_ = rygel_user_config_get_value_from_keyfiles (_tmp42_, _tmp43_, _tmp44_, _tmp45_, &_inner_error_);
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				new_value = _tmp46_;
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				if (_inner_error_ != NULL) {
#line 611 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_free0 (old_value);
#line 3242 "rygel-user-config.c"
					goto __catch10_g_error;
				}
#line 617 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp47_ = old_value;
#line 617 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp48_ = new_value;
#line 617 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				emit = g_strcmp0 (_tmp47_, _tmp48_) != 0;
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (new_value);
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_free0 (old_value);
#line 3255 "rygel-user-config.c"
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError* e = NULL;
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				e = _inner_error_;
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_inner_error_ = NULL;
#line 621 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				emit = TRUE;
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_error_free0 (e);
#line 3269 "rygel-user-config.c"
			}
			__finally10:
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_inner_error_ != NULL) {
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				g_clear_error (&_inner_error_);
#line 605 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				return;
#line 3280 "rygel-user-config.c"
			}
#line 624 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp49_ = emit;
#line 624 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_tmp49_) {
#line 3286 "rygel-user-config.c"
				const gchar* _tmp50_;
				const gchar* _tmp51_;
#line 625 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp50_ = section;
#line 625 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp51_ = key;
#line 625 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", _tmp50_, _tmp51_);
#line 3295 "rygel-user-config.c"
			}
		}
	}
}


static void rygel_user_config_emit_unconditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GeeHashMap* config_keys) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 630 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 630 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 630 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 630 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (config_keys != NULL);
#line 634 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = rygel_user_config_section_keys;
#line 634 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = key;
#line 634 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 634 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_tmp2_) {
#line 3322 "rygel-user-config.c"
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelUserConfigSectionPair* pair;
		const gchar* _tmp6_;
		RygelUserConfigSectionPair* _tmp7_;
		RygelSectionEntry _tmp8_;
#line 635 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = rygel_user_config_section_keys;
#line 635 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp4_ = key;
#line 635 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 635 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		pair = (RygelUserConfigSectionPair*) _tmp5_;
#line 637 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp6_ = section;
#line 637 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp7_ = pair;
#line 637 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp8_ = _tmp7_->entry;
#line 637 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", _tmp6_, _tmp8_);
#line 634 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_rygel_user_config_section_pair_unref0 (pair);
#line 3348 "rygel-user-config.c"
	} else {
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
#line 638 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp9_ = config_keys;
#line 638 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp10_ = key;
#line 638 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_);
#line 638 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_tmp11_) {
#line 3361 "rygel-user-config.c"
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			RygelUserConfigConfigPair* pair;
			RygelUserConfigConfigPair* _tmp15_;
			RygelConfigurationEntry _tmp16_;
#line 639 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp12_ = config_keys;
#line 639 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp13_ = key;
#line 639 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
#line 639 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			pair = (RygelUserConfigConfigPair*) _tmp14_;
#line 641 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp15_ = pair;
#line 641 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16_ = _tmp15_->entry;
#line 641 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp16_);
#line 638 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_rygel_user_config_config_pair_unref0 (pair);
#line 3384 "rygel-user-config.c"
		} else {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
#line 643 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp17_ = section;
#line 643 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp18_ = key;
#line 643 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", _tmp17_, _tmp18_);
#line 3394 "rygel-user-config.c"
		}
	}
}


static gpointer _g_key_file_ref0 (gpointer self) {
#line 649 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self ? g_key_file_ref (self) : NULL;
#line 3403 "rygel-user-config.c"
}


static void rygel_user_config_compare_and_notify (RygelUserConfig* self, GKeyFile* key_file, GKeyFile* sys_key_file) {
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* old_key_file;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	GKeyFile* old_sys_key_file;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	GeeHashSet* _tmp6_ = NULL;
	GeeHashSet* old_sections;
	GKeyFile* _tmp7_;
	GKeyFile* _tmp8_;
	GeeHashSet* _tmp9_ = NULL;
	GeeHashSet* new_sections;
	GKeyFile* _tmp10_;
	GKeyFile* _tmp11_;
	GKeyFile* _tmp12_;
	GKeyFile* _tmp13_;
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (key_file != NULL);
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (sys_key_file != NULL);
#line 649 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = self->key_file;
#line 649 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = _g_key_file_ref0 (_tmp0_);
#line 649 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old_key_file = _tmp1_;
#line 650 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = self->sys_key_file;
#line 650 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = _g_key_file_ref0 (_tmp2_);
#line 650 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old_sys_key_file = _tmp3_;
#line 651 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = old_key_file;
#line 651 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = old_sys_key_file;
#line 651 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp6_ = rygel_user_config_get_sections (_tmp4_, _tmp5_);
#line 651 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old_sections = _tmp6_;
#line 653 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = key_file;
#line 653 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp8_ = sys_key_file;
#line 653 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp9_ = rygel_user_config_get_sections (_tmp7_, _tmp8_);
#line 653 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	new_sections = _tmp9_;
#line 655 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp10_ = key_file;
#line 655 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp11_ = _g_key_file_ref0 (_tmp10_);
#line 655 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->key_file);
#line 655 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->key_file = _tmp11_;
#line 656 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp12_ = sys_key_file;
#line 656 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp13_ = _g_key_file_ref0 (_tmp12_);
#line 656 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->sys_key_file);
#line 656 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->sys_key_file = _tmp13_;
#line 3476 "rygel-user-config.c"
	{
		GeeHashSet* _tmp14_;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _section_it;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp14_ = old_sections;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp14_);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_section_it = _tmp15_;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		while (TRUE) {
#line 3489 "rygel-user-config.c"
			GeeIterator* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GeeIterator* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* section;
			const gchar* _tmp20_;
			GKeyFile* _tmp21_;
			GKeyFile* _tmp22_;
			GeeHashSet* _tmp23_ = NULL;
			GeeHashSet* old_keys;
			GeeHashMap* _tmp24_ = NULL;
			GeeHashMap* _tmp25_;
			const gchar* _tmp26_;
			gboolean _tmp27_ = FALSE;
			GeeHashMap* _tmp32_;
			GeeHashMap* _tmp33_;
			GeeHashMap* config_keys;
			GeeHashSet* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp16_ = _section_it;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp17_ = gee_iterator_next (_tmp16_);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (!_tmp17_) {
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				break;
#line 3518 "rygel-user-config.c"
			}
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp18_ = _section_it;
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp19_ = gee_iterator_get (_tmp18_);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			section = (gchar*) _tmp19_;
#line 659 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp20_ = section;
#line 659 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp21_ = old_key_file;
#line 659 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp22_ = old_sys_key_file;
#line 659 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp23_ = rygel_user_config_get_keys (_tmp20_, _tmp21_, _tmp22_);
#line 659 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			old_keys = _tmp23_;
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp25_ = rygel_user_config_config_keys;
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp26_ = section;
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp27_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp25_, _tmp26_);
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_tmp27_) {
#line 3544 "rygel-user-config.c"
				GeeHashMap* _tmp28_;
				const gchar* _tmp29_;
				gpointer _tmp30_ = NULL;
#line 663 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp28_ = rygel_user_config_config_keys;
#line 663 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp29_ = section;
#line 663 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
#line 663 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (_tmp24_);
#line 663 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp24_ = (GeeHashMap*) _tmp30_;
#line 3558 "rygel-user-config.c"
			} else {
				GeeHashMap* _tmp31_;
#line 664 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp31_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL);
#line 664 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (_tmp24_);
#line 664 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp24_ = _tmp31_;
#line 3567 "rygel-user-config.c"
			}
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp32_ = _tmp24_;
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 662 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			config_keys = _tmp33_;
#line 666 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp34_ = new_sections;
#line 666 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp35_ = section;
#line 666 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp36_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp34_, _tmp35_);
#line 666 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_tmp36_) {
#line 3583 "rygel-user-config.c"
				const gchar* _tmp37_;
				GKeyFile* _tmp38_;
				GKeyFile* _tmp39_;
				GeeHashSet* _tmp40_ = NULL;
				GeeHashSet* new_keys;
#line 668 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp37_ = section;
#line 668 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp38_ = key_file;
#line 668 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp39_ = sys_key_file;
#line 668 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp40_ = rygel_user_config_get_keys (_tmp37_, _tmp38_, _tmp39_);
#line 668 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				new_keys = _tmp40_;
#line 3599 "rygel-user-config.c"
				{
					GeeHashSet* _tmp41_;
					GeeIterator* _tmp42_ = NULL;
					GeeIterator* _key_it;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp41_ = old_keys;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp42_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp41_);
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_key_it = _tmp42_;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					while (TRUE) {
#line 3612 "rygel-user-config.c"
						GeeIterator* _tmp43_;
						gboolean _tmp44_ = FALSE;
						GeeIterator* _tmp45_;
						gpointer _tmp46_ = NULL;
						gchar* key;
						GeeHashSet* _tmp47_;
						const gchar* _tmp48_;
						gboolean _tmp49_ = FALSE;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp43_ = _key_it;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp44_ = gee_iterator_next (_tmp43_);
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						if (!_tmp44_) {
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							break;
#line 3629 "rygel-user-config.c"
						}
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp45_ = _key_it;
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp46_ = gee_iterator_get (_tmp45_);
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						key = (gchar*) _tmp46_;
#line 673 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp47_ = new_keys;
#line 673 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp48_ = key;
#line 673 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp49_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp47_, _tmp48_);
#line 673 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						if (_tmp49_) {
#line 3645 "rygel-user-config.c"
							const gchar* _tmp50_;
							const gchar* _tmp51_;
							GKeyFile* _tmp52_;
							GKeyFile* _tmp53_;
							GKeyFile* _tmp54_;
							GKeyFile* _tmp55_;
							GeeHashMap* _tmp56_;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp50_ = section;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp51_ = key;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp52_ = old_key_file;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp53_ = old_sys_key_file;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp54_ = key_file;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp55_ = sys_key_file;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp56_ = config_keys;
#line 675 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							rygel_user_config_emit_conditionally (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
#line 3669 "rygel-user-config.c"
						} else {
							const gchar* _tmp57_;
							const gchar* _tmp58_;
							GeeHashMap* _tmp59_;
#line 684 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp57_ = section;
#line 684 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp58_ = key;
#line 684 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							_tmp59_ = config_keys;
#line 684 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							rygel_user_config_emit_unconditionally (self, _tmp57_, _tmp58_, _tmp59_);
#line 3682 "rygel-user-config.c"
						}
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_g_free0 (key);
#line 3686 "rygel-user-config.c"
					}
#line 672 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_object_unref0 (_key_it);
#line 3690 "rygel-user-config.c"
				}
				{
					GeeHashSet* _tmp60_;
					GeeIterator* _tmp61_ = NULL;
					GeeIterator* _key_it;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp60_ = new_keys;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp61_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp60_);
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_key_it = _tmp61_;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					while (TRUE) {
#line 3704 "rygel-user-config.c"
						GeeIterator* _tmp62_;
						gboolean _tmp63_ = FALSE;
						GeeIterator* _tmp64_;
						gpointer _tmp65_ = NULL;
						gchar* key;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						GeeHashMap* _tmp68_;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp62_ = _key_it;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp63_ = gee_iterator_next (_tmp62_);
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						if (!_tmp63_) {
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							break;
#line 3721 "rygel-user-config.c"
						}
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp64_ = _key_it;
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp65_ = gee_iterator_get (_tmp64_);
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						key = (gchar*) _tmp65_;
#line 690 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp66_ = section;
#line 690 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp67_ = key;
#line 690 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp68_ = config_keys;
#line 690 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						rygel_user_config_emit_unconditionally (self, _tmp66_, _tmp67_, _tmp68_);
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_g_free0 (key);
#line 3739 "rygel-user-config.c"
					}
#line 687 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_object_unref0 (_key_it);
#line 3743 "rygel-user-config.c"
				}
#line 666 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (new_keys);
#line 3747 "rygel-user-config.c"
			} else {
				{
					GeeHashSet* _tmp69_;
					GeeIterator* _tmp70_ = NULL;
					GeeIterator* _key_it;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp69_ = old_keys;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp70_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp69_);
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_key_it = _tmp70_;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					while (TRUE) {
#line 3761 "rygel-user-config.c"
						GeeIterator* _tmp71_;
						gboolean _tmp72_ = FALSE;
						GeeIterator* _tmp73_;
						gpointer _tmp74_ = NULL;
						gchar* key;
						const gchar* _tmp75_;
						const gchar* _tmp76_;
						GeeHashMap* _tmp77_;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp71_ = _key_it;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp72_ = gee_iterator_next (_tmp71_);
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						if (!_tmp72_) {
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
							break;
#line 3778 "rygel-user-config.c"
						}
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp73_ = _key_it;
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp74_ = gee_iterator_get (_tmp73_);
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						key = (gchar*) _tmp74_;
#line 697 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp75_ = section;
#line 697 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp76_ = key;
#line 697 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_tmp77_ = config_keys;
#line 697 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						rygel_user_config_emit_unconditionally (self, _tmp75_, _tmp76_, _tmp77_);
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						_g_free0 (key);
#line 3796 "rygel-user-config.c"
					}
#line 696 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_object_unref0 (_key_it);
#line 3800 "rygel-user-config.c"
				}
			}
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (config_keys);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (_tmp24_);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (old_keys);
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (section);
#line 3811 "rygel-user-config.c"
		}
#line 658 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (_section_it);
#line 3815 "rygel-user-config.c"
	}
	{
		GeeHashSet* _tmp78_;
		GeeIterator* _tmp79_ = NULL;
		GeeIterator* _section_it;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp78_ = new_sections;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp79_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp78_);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_section_it = _tmp79_;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		while (TRUE) {
#line 3829 "rygel-user-config.c"
			GeeIterator* _tmp80_;
			gboolean _tmp81_ = FALSE;
			GeeIterator* _tmp82_;
			gpointer _tmp83_ = NULL;
			gchar* section;
			const gchar* _tmp84_;
			GKeyFile* _tmp85_;
			GKeyFile* _tmp86_;
			GeeHashSet* _tmp87_ = NULL;
			GeeHashSet* keys;
			GeeHashMap* _tmp88_ = NULL;
			GeeHashMap* _tmp89_;
			const gchar* _tmp90_;
			gboolean _tmp91_ = FALSE;
			GeeHashMap* _tmp96_;
			GeeHashMap* _tmp97_;
			GeeHashMap* config_keys;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp80_ = _section_it;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp81_ = gee_iterator_next (_tmp80_);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (!_tmp81_) {
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				break;
#line 3855 "rygel-user-config.c"
			}
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp82_ = _section_it;
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp83_ = gee_iterator_get (_tmp82_);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			section = (gchar*) _tmp83_;
#line 705 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp84_ = section;
#line 705 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp85_ = sys_key_file;
#line 705 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp86_ = key_file;
#line 705 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp87_ = rygel_user_config_get_keys (_tmp84_, _tmp85_, _tmp86_);
#line 705 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			keys = _tmp87_;
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp89_ = rygel_user_config_config_keys;
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp90_ = section;
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp91_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp89_, _tmp90_);
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			if (_tmp91_) {
#line 3881 "rygel-user-config.c"
				GeeHashMap* _tmp92_;
				const gchar* _tmp93_;
				gpointer _tmp94_ = NULL;
#line 707 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp92_ = rygel_user_config_config_keys;
#line 707 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp93_ = section;
#line 707 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp94_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp92_, _tmp93_);
#line 707 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (_tmp88_);
#line 707 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp88_ = (GeeHashMap*) _tmp94_;
#line 3895 "rygel-user-config.c"
			} else {
				GeeHashMap* _tmp95_;
#line 708 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp95_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL);
#line 708 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (_tmp88_);
#line 708 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp88_ = _tmp95_;
#line 3904 "rygel-user-config.c"
			}
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp96_ = _tmp88_;
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_tmp97_ = _g_object_ref0 (_tmp96_);
#line 706 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			config_keys = _tmp97_;
#line 3912 "rygel-user-config.c"
			{
				GeeHashSet* _tmp98_;
				GeeIterator* _tmp99_ = NULL;
				GeeIterator* _key_it;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp98_ = keys;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_tmp99_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp98_);
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_key_it = _tmp99_;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				while (TRUE) {
#line 3925 "rygel-user-config.c"
					GeeIterator* _tmp100_;
					gboolean _tmp101_ = FALSE;
					GeeIterator* _tmp102_;
					gpointer _tmp103_ = NULL;
					gchar* key;
					const gchar* _tmp104_;
					const gchar* _tmp105_;
					GeeHashMap* _tmp106_;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp100_ = _key_it;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp101_ = gee_iterator_next (_tmp100_);
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					if (!_tmp101_) {
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
						break;
#line 3942 "rygel-user-config.c"
					}
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp102_ = _key_it;
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp103_ = gee_iterator_get (_tmp102_);
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					key = (gchar*) _tmp103_;
#line 711 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp104_ = section;
#line 711 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp105_ = key;
#line 711 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_tmp106_ = config_keys;
#line 711 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					rygel_user_config_emit_unconditionally (self, _tmp104_, _tmp105_, _tmp106_);
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
					_g_free0 (key);
#line 3960 "rygel-user-config.c"
				}
#line 710 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
				_g_object_unref0 (_key_it);
#line 3964 "rygel-user-config.c"
			}
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (config_keys);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (_tmp88_);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_object_unref0 (keys);
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			_g_free0 (section);
#line 3974 "rygel-user-config.c"
		}
#line 702 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_object_unref0 (_section_it);
#line 3978 "rygel-user-config.c"
	}
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (new_sections);
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (old_sections);
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (old_sys_key_file);
#line 647 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (old_key_file);
#line 3988 "rygel-user-config.c"
}


static void rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self, GFile* system) {
	GKeyFile* _tmp0_;
	GKeyFile* sys_key_file;
	GKeyFile* _tmp4_;
	GError * _inner_error_ = NULL;
#line 716 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 716 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (system != NULL);
#line 717 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = g_key_file_new ();
#line 717 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	sys_key_file = _tmp0_;
#line 4005 "rygel-user-config.c"
	{
		GFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = system;
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = g_file_get_path (_tmp1_);
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = _tmp2_;
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_key_file_load_from_file (sys_key_file, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (_tmp3_);
#line 720 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 4022 "rygel-user-config.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		e = _inner_error_;
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (e);
#line 4036 "rygel-user-config.c"
	}
	__finally11:
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_key_file_unref0 (sys_key_file);
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_clear_error (&_inner_error_);
#line 719 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 4049 "rygel-user-config.c"
	}
#line 726 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = self->key_file;
#line 726 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_compare_and_notify (self, _tmp4_, sys_key_file);
#line 716 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (sys_key_file);
#line 4057 "rygel-user-config.c"
}


static void rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self, GFile* local) {
	GKeyFile* _tmp0_;
	GKeyFile* key_file;
	GKeyFile* _tmp4_;
	GError * _inner_error_ = NULL;
#line 729 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 729 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (local != NULL);
#line 730 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = g_key_file_new ();
#line 730 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	key_file = _tmp0_;
#line 4074 "rygel-user-config.c"
	{
		GFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp1_ = local;
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp2_ = g_file_get_path (_tmp1_);
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_tmp3_ = _tmp2_;
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_key_file_load_from_file (key_file, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_free0 (_tmp3_);
#line 733 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (_inner_error_ != NULL) {
#line 4091 "rygel-user-config.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		e = _inner_error_;
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_inner_error_ = NULL;
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_error_free0 (e);
#line 4105 "rygel-user-config.c"
	}
	__finally12:
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (_inner_error_ != NULL) {
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		_g_key_file_unref0 (key_file);
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_clear_error (&_inner_error_);
#line 732 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return;
#line 4118 "rygel-user-config.c"
	}
#line 739 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = self->sys_key_file;
#line 739 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_compare_and_notify (self, key_file, _tmp4_);
#line 729 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (key_file);
#line 4126 "rygel-user-config.c"
}


static void rygel_user_config_on_system_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	GFile* _tmp0_;
#line 742 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 742 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (monitor != NULL);
#line 742 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (file != NULL);
#line 746 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = file;
#line 746 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_reload_compare_and_notify_system (self, _tmp0_);
#line 4142 "rygel-user-config.c"
}


static void rygel_user_config_on_local_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	GFile* _tmp0_;
#line 749 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 749 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (monitor != NULL);
#line 749 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (file != NULL);
#line 753 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = file;
#line 753 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_reload_compare_and_notify_local (self, _tmp0_);
#line 4158 "rygel-user-config.c"
}


static RygelUserConfigConfigPair* rygel_user_config_config_pair_construct (GType object_type, RygelConfigurationEntry entry, RygelEntryType type) {
	RygelUserConfigConfigPair* self = NULL;
	RygelConfigurationEntry _tmp0_;
	RygelEntryType _tmp1_;
#line 69 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfigConfigPair*) g_type_create_instance (object_type);
#line 71 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = entry;
#line 71 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->entry = _tmp0_;
#line 72 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = type;
#line 72 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->type = _tmp1_;
#line 69 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self;
#line 4178 "rygel-user-config.c"
}


static RygelUserConfigConfigPair* rygel_user_config_config_pair_new (RygelConfigurationEntry entry, RygelEntryType type) {
#line 69 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return rygel_user_config_config_pair_construct (RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, entry, type);
#line 4185 "rygel-user-config.c"
}


static void rygel_user_config_value_config_pair_init (GValue* value) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	value->data[0].v_pointer = NULL;
#line 4192 "rygel-user-config.c"
}


static void rygel_user_config_value_config_pair_free_value (GValue* value) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (value->data[0].v_pointer) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_config_pair_unref (value->data[0].v_pointer);
#line 4201 "rygel-user-config.c"
	}
}


static void rygel_user_config_value_config_pair_copy_value (const GValue* src_value, GValue* dest_value) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (src_value->data[0].v_pointer) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		dest_value->data[0].v_pointer = rygel_user_config_config_pair_ref (src_value->data[0].v_pointer);
#line 4211 "rygel-user-config.c"
	} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4215 "rygel-user-config.c"
	}
}


static gpointer rygel_user_config_value_config_pair_peek_pointer (const GValue* value) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return value->data[0].v_pointer;
#line 4223 "rygel-user-config.c"
}


static gchar* rygel_user_config_value_config_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (collect_values[0].v_pointer) {
#line 4230 "rygel-user-config.c"
		RygelUserConfigConfigPair* object;
		object = collect_values[0].v_pointer;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (object->parent_instance.g_class == NULL) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4237 "rygel-user-config.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4241 "rygel-user-config.c"
		}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = rygel_user_config_config_pair_ref (object);
#line 4245 "rygel-user-config.c"
	} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4249 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return NULL;
#line 4253 "rygel-user-config.c"
}


static gchar* rygel_user_config_value_config_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelUserConfigConfigPair** object_p;
	object_p = collect_values[0].v_pointer;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (!object_p) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4264 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (!value->data[0].v_pointer) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = NULL;
#line 4270 "rygel-user-config.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = value->data[0].v_pointer;
#line 4274 "rygel-user-config.c"
	} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = rygel_user_config_config_pair_ref (value->data[0].v_pointer);
#line 4278 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return NULL;
#line 4282 "rygel-user-config.c"
}


static GParamSpec* rygel_user_config_param_spec_config_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelUserConfigParamSpecConfigPair* spec;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return G_PARAM_SPEC (spec);
#line 4296 "rygel-user-config.c"
}


static gpointer rygel_user_config_value_get_config_pair (const GValue* value) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return value->data[0].v_pointer;
#line 4305 "rygel-user-config.c"
}


static void rygel_user_config_value_set_config_pair (GValue* value, gpointer v_object) {
	RygelUserConfigConfigPair* old;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old = value->data[0].v_pointer;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (v_object) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = v_object;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_config_pair_ref (value->data[0].v_pointer);
#line 4325 "rygel-user-config.c"
	} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4329 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (old) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_config_pair_unref (old);
#line 4335 "rygel-user-config.c"
	}
}


static void rygel_user_config_value_take_config_pair (GValue* value, gpointer v_object) {
	RygelUserConfigConfigPair* old;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old = value->data[0].v_pointer;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (v_object) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = v_object;
#line 4354 "rygel-user-config.c"
	} else {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4358 "rygel-user-config.c"
	}
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (old) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_config_pair_unref (old);
#line 4364 "rygel-user-config.c"
	}
}


static void rygel_user_config_config_pair_class_init (RygelUserConfigConfigPairClass * klass) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_config_pair_parent_class = g_type_class_peek_parent (klass);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	RYGEL_USER_CONFIG_CONFIG_PAIR_CLASS (klass)->finalize = rygel_user_config_config_pair_finalize;
#line 4374 "rygel-user-config.c"
}


static void rygel_user_config_config_pair_instance_init (RygelUserConfigConfigPair * self) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->ref_count = 1;
#line 4381 "rygel-user-config.c"
}


static void rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair* obj) {
	RygelUserConfigConfigPair * self;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair);
#line 4389 "rygel-user-config.c"
}


static GType rygel_user_config_config_pair_get_type (void) {
	static volatile gsize rygel_user_config_config_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_config_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_config_pair_init, rygel_user_config_value_config_pair_free_value, rygel_user_config_value_config_pair_copy_value, rygel_user_config_value_config_pair_peek_pointer, "p", rygel_user_config_value_config_pair_collect_value, "p", rygel_user_config_value_config_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigConfigPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_config_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigConfigPair), 0, (GInstanceInitFunc) rygel_user_config_config_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_config_pair_type_id;
		rygel_user_config_config_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigConfigPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_config_pair_type_id__volatile, rygel_user_config_config_pair_type_id);
	}
	return rygel_user_config_config_pair_type_id__volatile;
}


static gpointer rygel_user_config_config_pair_ref (gpointer instance) {
	RygelUserConfigConfigPair* self;
	self = instance;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_atomic_int_inc (&self->ref_count);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return instance;
#line 4414 "rygel-user-config.c"
}


static void rygel_user_config_config_pair_unref (gpointer instance) {
	RygelUserConfigConfigPair* self;
	self = instance;
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS (self)->finalize (self);
#line 65 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4427 "rygel-user-config.c"
	}
}


static RygelUserConfigSectionPair* rygel_user_config_section_pair_construct (GType object_type, RygelSectionEntry entry, RygelEntryType type) {
	RygelUserConfigSectionPair* self = NULL;
	RygelSectionEntry _tmp0_;
	RygelEntryType _tmp1_;
#line 80 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = (RygelUserConfigSectionPair*) g_type_create_instance (object_type);
#line 82 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = entry;
#line 82 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->entry = _tmp0_;
#line 83 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = type;
#line 83 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->type = _tmp1_;
#line 80 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return self;
#line 4448 "rygel-user-config.c"
}


static RygelUserConfigSectionPair* rygel_user_config_section_pair_new (RygelSectionEntry entry, RygelEntryType type) {
#line 80 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return rygel_user_config_section_pair_construct (RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, entry, type);
#line 4455 "rygel-user-config.c"
}


static void rygel_user_config_value_section_pair_init (GValue* value) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	value->data[0].v_pointer = NULL;
#line 4462 "rygel-user-config.c"
}


static void rygel_user_config_value_section_pair_free_value (GValue* value) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (value->data[0].v_pointer) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_section_pair_unref (value->data[0].v_pointer);
#line 4471 "rygel-user-config.c"
	}
}


static void rygel_user_config_value_section_pair_copy_value (const GValue* src_value, GValue* dest_value) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (src_value->data[0].v_pointer) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		dest_value->data[0].v_pointer = rygel_user_config_section_pair_ref (src_value->data[0].v_pointer);
#line 4481 "rygel-user-config.c"
	} else {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4485 "rygel-user-config.c"
	}
}


static gpointer rygel_user_config_value_section_pair_peek_pointer (const GValue* value) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return value->data[0].v_pointer;
#line 4493 "rygel-user-config.c"
}


static gchar* rygel_user_config_value_section_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (collect_values[0].v_pointer) {
#line 4500 "rygel-user-config.c"
		RygelUserConfigSectionPair* object;
		object = collect_values[0].v_pointer;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		if (object->parent_instance.g_class == NULL) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4507 "rygel-user-config.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4511 "rygel-user-config.c"
		}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = rygel_user_config_section_pair_ref (object);
#line 4515 "rygel-user-config.c"
	} else {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4519 "rygel-user-config.c"
	}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return NULL;
#line 4523 "rygel-user-config.c"
}


static gchar* rygel_user_config_value_section_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelUserConfigSectionPair** object_p;
	object_p = collect_values[0].v_pointer;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (!object_p) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4534 "rygel-user-config.c"
	}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (!value->data[0].v_pointer) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = NULL;
#line 4540 "rygel-user-config.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = value->data[0].v_pointer;
#line 4544 "rygel-user-config.c"
	} else {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		*object_p = rygel_user_config_section_pair_ref (value->data[0].v_pointer);
#line 4548 "rygel-user-config.c"
	}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return NULL;
#line 4552 "rygel-user-config.c"
}


static GParamSpec* rygel_user_config_param_spec_section_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelUserConfigParamSpecSectionPair* spec;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return G_PARAM_SPEC (spec);
#line 4566 "rygel-user-config.c"
}


static gpointer rygel_user_config_value_get_section_pair (const GValue* value) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return value->data[0].v_pointer;
#line 4575 "rygel-user-config.c"
}


static void rygel_user_config_value_set_section_pair (GValue* value, gpointer v_object) {
	RygelUserConfigSectionPair* old;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old = value->data[0].v_pointer;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (v_object) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = v_object;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_section_pair_ref (value->data[0].v_pointer);
#line 4595 "rygel-user-config.c"
	} else {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4599 "rygel-user-config.c"
	}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (old) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_section_pair_unref (old);
#line 4605 "rygel-user-config.c"
	}
}


static void rygel_user_config_value_take_section_pair (GValue* value, gpointer v_object) {
	RygelUserConfigSectionPair* old;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	old = value->data[0].v_pointer;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (v_object) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = v_object;
#line 4624 "rygel-user-config.c"
	} else {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		value->data[0].v_pointer = NULL;
#line 4628 "rygel-user-config.c"
	}
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (old) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		rygel_user_config_section_pair_unref (old);
#line 4634 "rygel-user-config.c"
	}
}


static void rygel_user_config_section_pair_class_init (RygelUserConfigSectionPairClass * klass) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_section_pair_parent_class = g_type_class_peek_parent (klass);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	RYGEL_USER_CONFIG_SECTION_PAIR_CLASS (klass)->finalize = rygel_user_config_section_pair_finalize;
#line 4644 "rygel-user-config.c"
}


static void rygel_user_config_section_pair_instance_init (RygelUserConfigSectionPair * self) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self->ref_count = 1;
#line 4651 "rygel-user-config.c"
}


static void rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair* obj) {
	RygelUserConfigSectionPair * self;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair);
#line 4659 "rygel-user-config.c"
}


static GType rygel_user_config_section_pair_get_type (void) {
	static volatile gsize rygel_user_config_section_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_section_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_section_pair_init, rygel_user_config_value_section_pair_free_value, rygel_user_config_value_section_pair_copy_value, rygel_user_config_value_section_pair_peek_pointer, "p", rygel_user_config_value_section_pair_collect_value, "p", rygel_user_config_value_section_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigSectionPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_section_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigSectionPair), 0, (GInstanceInitFunc) rygel_user_config_section_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_section_pair_type_id;
		rygel_user_config_section_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigSectionPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_section_pair_type_id__volatile, rygel_user_config_section_pair_type_id);
	}
	return rygel_user_config_section_pair_type_id__volatile;
}


static gpointer rygel_user_config_section_pair_ref (gpointer instance) {
	RygelUserConfigSectionPair* self;
	self = instance;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	g_atomic_int_inc (&self->ref_count);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	return instance;
#line 4684 "rygel-user-config.c"
}


static void rygel_user_config_section_pair_unref (gpointer instance) {
	RygelUserConfigSectionPair* self;
	self = instance;
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS (self)->finalize (self);
#line 76 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4697 "rygel-user-config.c"
	}
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	GeeHashMap* _tmp0_;
	GeeHashMap* general_config_keys;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	RygelUserConfigConfigPair* _tmp4_;
	RygelUserConfigConfigPair* _tmp5_;
	GeeHashMap* _tmp6_;
	RygelUserConfigConfigPair* _tmp7_;
	RygelUserConfigConfigPair* _tmp8_;
	GeeHashMap* _tmp9_;
	RygelUserConfigConfigPair* _tmp10_;
	RygelUserConfigConfigPair* _tmp11_;
	GeeHashMap* _tmp12_;
	RygelUserConfigConfigPair* _tmp13_;
	RygelUserConfigConfigPair* _tmp14_;
	GeeHashMap* _tmp15_;
	RygelUserConfigConfigPair* _tmp16_;
	RygelUserConfigConfigPair* _tmp17_;
	GeeHashMap* _tmp18_;
	RygelUserConfigConfigPair* _tmp19_;
	RygelUserConfigConfigPair* _tmp20_;
	GeeHashMap* _tmp21_;
	RygelUserConfigConfigPair* _tmp22_;
	RygelUserConfigConfigPair* _tmp23_;
	GeeHashMap* _tmp24_;
	RygelUserConfigConfigPair* _tmp25_;
	RygelUserConfigConfigPair* _tmp26_;
	GeeHashMap* _tmp27_;
	RygelUserConfigConfigPair* _tmp28_;
	RygelUserConfigConfigPair* _tmp29_;
	GeeHashMap* _tmp30_;
	RygelUserConfigConfigPair* _tmp31_;
	RygelUserConfigConfigPair* _tmp32_;
	GeeHashMap* _tmp33_;
	RygelUserConfigConfigPair* _tmp34_;
	RygelUserConfigConfigPair* _tmp35_;
	GeeHashMap* _tmp36_;
	GeeHashMap* _tmp37_;
	GeeHashMap* _tmp38_;
	RygelUserConfigSectionPair* _tmp39_;
	RygelUserConfigSectionPair* _tmp40_;
	GeeHashMap* _tmp41_;
	RygelUserConfigSectionPair* _tmp42_;
	RygelUserConfigSectionPair* _tmp43_;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
#line 96 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL);
#line 96 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	general_config_keys = _tmp0_;
#line 98 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 98 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (rygel_user_config_config_keys);
#line 98 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_config_keys = _tmp1_;
#line 100 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, (GBoxedCopyFunc) rygel_user_config_section_pair_ref, rygel_user_config_section_pair_unref, NULL, NULL, NULL);
#line 100 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (rygel_user_config_section_keys);
#line 100 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_section_keys = _tmp2_;
#line 102 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp3_ = general_config_keys;
#line 102 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp4_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_INTERFACE, RYGEL_ENTRY_TYPE_STRING);
#line 102 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp5_ = _tmp4_;
#line 102 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, RYGEL_USER_CONFIG_IFACE_KEY, _tmp5_);
#line 102 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp5_);
#line 105 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp6_ = general_config_keys;
#line 105 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp7_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PORT, RYGEL_ENTRY_TYPE_INT);
#line 105 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp8_ = _tmp7_;
#line 105 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, RYGEL_USER_CONFIG_PORT_KEY, _tmp8_);
#line 105 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp8_);
#line 108 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp9_ = general_config_keys;
#line 108 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp10_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_UPNP_ENABLED, RYGEL_ENTRY_TYPE_BOOL);
#line 108 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp11_ = _tmp10_;
#line 108 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, RYGEL_USER_CONFIG_UPNP_ENABLED_KEY, _tmp11_);
#line 108 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp11_);
#line 112 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp12_ = general_config_keys;
#line 112 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp13_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_TRANSCODING, RYGEL_ENTRY_TYPE_BOOL);
#line 112 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp14_ = _tmp13_;
#line 112 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, RYGEL_USER_CONFIG_TRANSCODING_KEY, _tmp14_);
#line 112 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp14_);
#line 115 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp15_ = general_config_keys;
#line 115 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp16_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD, RYGEL_ENTRY_TYPE_BOOL);
#line 115 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp17_ = _tmp16_;
#line 115 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, _tmp17_);
#line 115 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp17_);
#line 119 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp18_ = general_config_keys;
#line 119 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp19_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION, RYGEL_ENTRY_TYPE_BOOL);
#line 119 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp20_ = _tmp19_;
#line 119 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, _tmp20_);
#line 119 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp20_);
#line 123 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp21_ = general_config_keys;
#line 123 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp22_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS, RYGEL_ENTRY_TYPE_STRING);
#line 123 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp23_ = _tmp22_;
#line 123 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, _tmp23_);
#line 123 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp23_);
#line 126 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp24_ = general_config_keys;
#line 126 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp25_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH, RYGEL_ENTRY_TYPE_STRING);
#line 126 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp26_ = _tmp25_;
#line 126 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, _tmp26_);
#line 126 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp26_);
#line 129 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp27_ = general_config_keys;
#line 129 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp28_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
#line 129 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp29_ = _tmp28_;
#line 129 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, _tmp29_);
#line 129 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp29_);
#line 133 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp30_ = general_config_keys;
#line 133 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp31_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
#line 133 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp32_ = _tmp31_;
#line 133 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, _tmp32_);
#line 133 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp32_);
#line 137 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp33_ = general_config_keys;
#line 137 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp34_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
#line 137 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp35_ = _tmp34_;
#line 137 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, _tmp35_);
#line 137 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_config_pair_unref0 (_tmp35_);
#line 142 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp36_ = rygel_user_config_config_keys;
#line 142 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp37_ = general_config_keys;
#line 142 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, RYGEL_USER_CONFIG_GENERAL_SECTION, _tmp37_);
#line 144 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp38_ = rygel_user_config_section_keys;
#line 144 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp39_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_ENABLED, RYGEL_ENTRY_TYPE_BOOL);
#line 144 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp40_ = _tmp39_;
#line 144 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp38_, RYGEL_USER_CONFIG_ENABLED_KEY, _tmp40_);
#line 144 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_section_pair_unref0 (_tmp40_);
#line 147 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp41_ = rygel_user_config_section_keys;
#line 147 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp42_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_TITLE, RYGEL_ENTRY_TYPE_STRING);
#line 147 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_tmp43_ = _tmp42_;
#line 147 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, RYGEL_USER_CONFIG_TITLE_KEY, _tmp43_);
#line 147 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_rygel_user_config_section_pair_unref0 (_tmp43_);
#line 95 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (general_config_keys);
#line 4906 "rygel-user-config.c"
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_upnp_enabled;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_interface = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_interface;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_port = (gint (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_port;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_transcoding = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_transcoding;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_upload;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_deletion;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_log_levels = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_log_levels;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_plugin_path;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_engine_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_engine_path;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_media_engine = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_media_engine;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_video_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_video_upload_folder;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_music_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_music_upload_folder;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_picture_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_picture_upload_folder;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_enabled = (gboolean (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_enabled;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_title = (gchar* (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_title;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_string = (gchar* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string_list;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_int = (gint (*)(RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_user_config_real_get_int;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_int_list;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	iface->get_bool = (gboolean (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_bool;
#line 4953 "rygel-user-config.c"
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_USER_CONFIG, RygelUserConfig);
#line 90 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->key_file);
#line 91 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_key_file_unref0 (self->sys_key_file);
#line 92 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (self->key_file_monitor);
#line 93 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	_g_object_unref0 (self->sys_key_file_monitor);
#line 39 "/home/jens/Source/rygel/tests/rygel-user-config.vala"
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
#line 4975 "rygel-user-config.c"
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



